<?php include(cfg('language', 'languages_path').'lang.'.$site_lang.'.php'); ?>
<head>
	<title><?php $t=isset( $_GET['page'] ) ? $title . ' - '.$lang['URL_PAGE'].' ' . $_GET['page'] : $title; echo $t.' - '.cfg('base', 'site_title');?></title>
	
	<!-- Meta -->
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta name="Keywords" content="<?php echo $keywords; ?>"/>
	<meta name="Description" content="<?php echo $description; ?>"/>
	<meta name="author" content="xtend-music"/>
	<meta name="robots" content="all, index, follow"/>
	
	<!-- Twitter Cards Metadata -->
	<meta name="twitter:card" content="<?php echo $tw_card;?>" />
	<meta name="twitter:site" content="<?php echo str_replace("https://twitter.com/","@",cfg('social', 'twitter_page'));?>" />
	<meta name="twitter:title" content="<?php echo $title;?>">
	<meta name="twitter:description" content="<?php echo ShortenText(strip_tags($description),100);?>">
	<meta name="twitter:creator" content="@xtendradio">
	<meta name="twitter:image:src" content="<?php echo $og_image;?>">
	<meta name="twitter:domain" content="<?php $domain=str_replace("http://www.","",cfg('base', 'site_url')); echo str_replace("/","",$domain); ?>">
	<?php echo $tw_video_url;?>
	<?php echo $tw_video_width;?>
	<?php echo $tw_video_height;?>

	<!-- Open Graph ProtocolMeta Values -->
	<meta property="og:title" content="<?php echo $title;?>" />
	<meta property="og:type" content="<?php echo $og_type;?>"/>
	<meta property="og:url" content="<?php echo "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];?>"/>
	<meta property="og:image" content="<?php echo $og_image;?>" />
	<meta property="og:site_name" content="<?php echo cfg('base', 'site_title');?>" />
	<meta property="og:description" content="<?php echo $description;?>" />
	<meta property="fb:app_id" content="<?php echo cfg('social', 'facebook_appid'); ?>" />
	<?php echo $og_video_url;?>
	<?php echo $og_video_type;?>
	<?php echo $og_video_width;?>
	<?php echo $og_video_height;?>

	<!-- PREV / NEXT for pagination -->
	<?php if(isset($_GET['page'])) 
	{ 
		function paginate($current_page,$pages,$url,$pag) {
			$paginate="";
			if($current_page==1)
			$paginate='<link rel="next" href="'.$url.'/'.$pag.'/'.($current_page+1).'">'; 
			elseif($current_page==$pages)
			$paginate='<link rel="prev" href="'.$url.'/'.$pag.'/'.($current_page-1).'">'; 
			else
			$paginate='<link rel="prev" href="'.$url.'/'.$pag.'/'.($current_page-1).'"><link rel="next" href="'.$url.'/'.$pag.'/'.($current_page+1).'">'; 
			return $paginate;
		}
		$url=str_replace('/'.$lang['URL_PAGE'].'/'.$_GET['page'],'','http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
		echo paginate($current_page,$pages,$url,$lang['URL_PAGE']);
	}?>

	<!-- Pinterest Verification Code -->
	<meta name="p:domain_verify" content="<?php echo cfg('social', 'pinterest_verification'); ?>" />

	<!-- Google Webmaster Tools Verification Code -->
	<meta name="google-site-verification" content="<?php echo cfg('base', 'google_verification'); ?>" />

	<!-- Microsoft Bing Webmaster Tools Verification Code -->
	<meta name="msvalidate.01" content="<?php echo cfg('base', 'bing_verification'); ?>" />

	<!-- Canonical Url -->
	<link rel="canonical" href="<?php echo "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];?>">

	<!-- Feeds -->
	<link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php echo cfg('base', 'site_url'); ?>rss">

	<!-- Favicon -->
	<link rel="shortcut icon" href="<?php echo cfg('template', 'site_url'); ?>templates/assets/img/favicon.ico" type="image/x-icon" />
	
	<!-- Links -->
	<link rel="stylesheet" href="<?php echo cfg('template', 'site_url'); ?>templates/assets/css/defaults.css"/>
	<link rel="stylesheet" href="<?php echo cfg('template', 'site_url'); ?>templates/assets/css/style.css"/>
	<link rel="stylesheet" href="<?php echo cfg('template', 'site_url'); ?>templates/assets/css/responsive.css"/>
	<link rel="stylesheet" href="<?php echo cfg('template', 'site_url'); ?>templates/assets/css/font-awesome.min.css"/>
	<link rel="stylesheet" href="<?php echo cfg('template', 'site_url'); ?>templates/assets/css/font.css"/>
	
	<!-- Synchronous Scripts -->
	<!--[if lt IE 9]>
		<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
		<script>window.html5 || document.write('<script src="<?php echo cfg('template', 'site_url'); ?>templates/assets/js/html5shiv.min.js"><\/script>')</script>
		<script src="<?php echo cfg('template', 'site_url'); ?>templates/assets/js/selectivizr-min.js"></script>
		<script src="<?php echo cfg('template', 'site_url'); ?>templates/assets/js/respond.js"></script>
	<![endif]--> 
</head>