<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>
	
	<div id="container">
		
		<div class="wrapper">
			
			<div class="content left">
			
				<section class="module">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_EVENTS']; ?></h2>
					</header>
					
					<div class="thumbsList">
						
						<?php foreach ($events as $row): ?>
						
						<article class="scaleEffectImg">
							<header>
								<figure>
									<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['event_poster']; ?>" alt="" title="" width="233" height="324"/>
								</figure>
							</header>
							
							<div>
								<h3><?php echo $row['event_title']; ?></h3>
								
								<div>
									<a class="button btn-grey-red" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.url($row['event_title']).'-'.$row['event_id']; ?>" title="">
										<i class="fa fa-arrow-circle-right"></i> <?php echo $lang['BTN_VIEW_DETAILS']; ?>
									</a>
								</div>
							</div>
						</article>
						
						<?php endforeach; ?>
						
					</div> <!-- END .thumbsList -->
					
					
					<?php if($pages>1) { ?>
					<div class="pagination darkTheme center gap-T15">
					<ol>
					<?php if ($current_page>1) {?>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/1'; ?>">&laquo;</a></li>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.($current_page-1); ?>">&lt;</a></li>
					<?php } else {?>
					<?php }?>

					<?php 
					if($current_page-2<=4)
					{	for($i=1;$i<=$current_page;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
					}
					else
					{	for($i=1;$i<=3;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
						echo '<li><a class="inactive" title="">...</a></li>';
						for($i=$current_page-2;$i<=$current_page;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
					}
					?>

					<?php 
					if ($current_page<$pages) 
					{	if($current_page+2>=$pages-3)
						{	for($i=$current_page+1;$i<=$pages;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li><a class="current" href="#">'.$i.'</a></li>';
							}
						}
						else
						{	for($i=$current_page+1;$i<=$current_page+2;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li class="active"><a href="#">'.$i.'</a></li>';
							}
							echo '<li><a class="inactive" title="">...</a></li>';
							for($i=$pages-2;$i<=$pages;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li><a class="current" href="#">'.$i.'</a></li>';
							}
						}

					
					?>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.($current_page+1);?>">&gt;</a></li>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.$lang['URL_PAGE'].'/'.$pages;?>">&raquo;</a></li>
					<?php } else {?>
					
					<?php }?>
				</ol>
				</div> <!-- END .pagination -->
				<?php } ?>
					
				</section> <!-- END .module -->
			
			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
				
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>
				
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_MIXES']; ?></h2>
					</header>
					
					<div class="articles smallArticles widgetArticles">
					
						<?php foreach ($mixes as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title="">
								<?php if($mix['cover']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['cover']; ?>" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php else: ?>
									<figure>
										<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title=""><?php echo $row['mix_title']; ?></a></h3>
								</header>
								<p>
									<i class="fa fa-user"></i> <?php echo $row['author']; ?>
								</p>
							</div>
						</article>
						
						<?php endforeach; ?>
					
					</div> <!-- END .articles .smallArticles .widgetArticles -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</article> <!-- END .widget -->
			
			</aside> <!-- END .sidebar .right -->
		
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>