<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>
	
	<div id="container">
		
		<div class="wrapper">
			
			<div class="module">
			
				<ul class="breadcrumbNav">
					<li>
						<a href="<?php echo cfg('base', 'site_url').$url_lang; ?>" title="">
							<i class="fa fa-home"></i> <?php echo $lang['MENU_HOME']; ?>
						</a>
					</li>
					
					<li>
						<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS']; ?>" title="">
							<i class="fa fa-thumb-tack"></i> <?php echo $lang['MENU_EVENTS']; ?>
						</a>
					</li>
					
					<li><?php echo $event['event_title']; ?></li>
				</ul>
				
			</div> <!-- END .module -->
		
		
			<div class="content left">
			
				<section class="module">
					<header>
						<h1><?php echo $event['event_title']; ?></h1>
					</header>
					
					<div class="thumbsDetails">
						<header>
							<figure>
								<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $event['event_poster']; ?>" alt="<?php echo $event['event_title']; ?>" title="" width="100%"/>
							</figure>
						</header>
						
						<footer>
							<dl>
								<dt><i class="fa fa-group"></i>&nbsp; <?php echo $lang['TXT_EVENT_GUESTS']; ?></dt>
								<dd><?php echo $event['event_guests']; ?></dd>
								
								<dt><i class="fa fa-calendar"></i>&nbsp;<?php echo $lang['TXT_EVENT_DATE']; ?></dt>
								<dd><time datetime="<?php echo $event['event_date']; ?>"><?php echo $event['event_date']; ?></time></dd>
								
								<dt><i class="fa fa-map-marker"></i>&nbsp; <?php echo $lang['TXT_EVENT_LOCATION']; ?></dt>
								<dd><?php echo $event['event_location']; ?></dd>
								
								<dt><i class="fa fa-money"></i>&nbsp; <?php echo $lang['TXT_EVENT_PRICE']; ?></dt>
								<dd><?php echo $event['ticket_price']; ?></dd>
								
								<dt><i class="fa fa-ticket"></i>&nbsp; <?php echo $lang['TXT_EVENT_RESERVATION']; ?></dt>
								<dd><?php echo $event['reservation_details']; ?></dd>
							</dl>
						</footer>
					</div> <!-- END .thumbsDetails -->
					
				</section> <!-- END .module -->
			
			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
			
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>
				
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_MIXES']; ?></h2>
					</header>
					
					<div class="articles smallArticles widgetArticles">
					
						<?php foreach ($mixes as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title="">
								<?php if($mix['cover']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['cover']; ?>" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php else: ?>
									<figure>
										<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title=""><?php echo $row['mix_title']; ?></a></h3>
								</header>
								<p>
									<i class="fa fa-user"></i> <?php echo $row['author']; ?>
								</p>
							</div>
						</article>
						
						<?php endforeach; ?>
					
					</div> <!-- END .articles .smallArticles .widgetArticles -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_EVENTS']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</article> <!-- END .widget -->
			
			</aside> <!-- END .sidebar .right -->
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>