<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>

	<div id="container">
		
		<div class="wrapper">
		
						<div class="module cover-mix">
			
				<article>
					
					<?php if($mix['cover']):?> 
						<figure class="scaleEffect">
							<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $mix['cover']; ?>" alt="<?php echo $mix['mix_title']; ?>" title="" width="200" height="200"/>
						</figure>
					<?php else: ?>
						<figure>
							<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="" title="" width="200" height="200"/>
						</figure>
					<?php endif; ?>
					
					<div>
						<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($mix['mix_title']).'-'.$mix['mix_id']; ?>" title=""><?php echo $mix['mix_title']; ?></a></h3>

						<p class="gap-T5 gap-B10 txt-italic txt-gray"> 
							<a class="link-red-gray" href="#" title=""><?php echo $mix['author']; ?></a>
						</p>
						
						<footer>
							<script type="text/javascript">var zippywww="<?php echo $mix['zippy_www']; ?>";var zippyfile="<?php echo $mix['zippy_file']; ?>";var zippytext="#ffffff";var zippyback="#222222";var zippyplay="#ff0056";var zippywidth="100%";var zippyauto=false;var zippyvol=80;var zippywave = "#666666";var zippyborder = "#222222";</script><script type="text/javascript" src="http://api.zippyshare.com/api/embed_new.js"></script>
						</footer>
					</div>
				</article>

				<aside>
					<header>
						<h1 class="txt22"><?php echo $title; ?></h1>
					</header>
					
					<?php echo $content; ?>
				</aside>
				
			</div> <!-- END .module -->
		
		
			<div class="content left">
			
				<section class="module">
					<header>
						<h2>DeeJay <em>Sets</em></h2>
					</header>
					
					<div class="articles smallArticles">
					
						<?php foreach ($mixes as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title="">
								<?php if($mix['cover']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['cover']; ?>" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php else: ?>
									<figure>
										<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title=""><?php echo $row['mix_title']; ?></a></h3>
								</header>
								<p>
									<i class="fa fa-user"></i> <?php echo $row['author']; ?>
								</p>
							</div>
						</article>
						
						<?php endforeach; ?>
					
					</div> <!-- END .articles .smallArticles -->

					
					<?php if($pages>1) { ?>
					<div class="pagination darkTheme center gap-T15">
					<ol>
					<?php if ($current_page>1) {?>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/1'; ?>">&laquo;</a></li>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.($current_page-1); ?>">&lt;</a></li>
					<?php } else {?>
					<?php }?>

					<?php 
					if($current_page-2<=4)
					{	for($i=1;$i<=$current_page;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
					}
					else
					{	for($i=1;$i<=3;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
						echo '<li><a class="inactive" title="">...</a></li>';
						for($i=$current_page-2;$i<=$current_page;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
					}
					?>

					<?php 
					if ($current_page<$pages) 
					{	if($current_page+2>=$pages-3)
						{	for($i=$current_page+1;$i<=$pages;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li><a class="current" href="#">'.$i.'</a></li>';
							}
						}
						else
						{	for($i=$current_page+1;$i<=$current_page+2;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li class="active"><a href="#">'.$i.'</a></li>';
							}
							echo '<li><a class="inactive" title="">...</a></li>';
							for($i=$pages-2;$i<=$pages;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li><a class="current" href="#">'.$i.'</a></li>';
							}
						}

					
					?>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.($current_page+1);?>">&gt;</a></li>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.$lang['URL_PAGE'].'/'.$pages;?>">&raquo;</a></li>
					<?php } else {?>
					
					<?php }?>
				</ol>
				</div> <!-- END .pagination -->
				<?php } ?>
					
				</section> <!-- END .module -->

			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_FACEBOOK_FAN']; ?></h2>
					</header>
					
					<div class="fb-like-box" 
						data-href="<?php echo cfg('social', 'facebook_page'); ?>" 
						data-colorscheme="dark" 
						data-show-faces="true" 
						data-header="false" 
						data-stream="false"
						data-show-border="false"
						data-height="260">
					</div>
				</article> <!-- END .widget -->
				
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>	
			
			</aside> <!-- END .sidebar .right -->
		
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>