<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>
	
	<div id="container">
		
		<div class="wrapper">		
		
			<div class="module">
			
				<ul class="breadcrumbNav">
					<li>
						<a href="<?php echo cfg('base', 'site_url').$url_lang; ?>" title="">
							<i class="fa fa-home"></i> <?php echo $lang['MENU_HOME']; ?>
						</a>
					</li>
					
					<li>
						<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES']; ?>" title="">
							<i class="fa fa-music"></i> <?php echo $lang['MENU_DJMIXES']; ?>
						</a>
					</li>
					
					<li><?php echo $mix['mix_title']; ?></li>
				</ul>
				
			</div> <!-- END .module -->
		
		
			<div class="content left">
			
				<section class="module setDetails">
					<header>
						<h2><?php echo $mix['mix_title']; ?></h2>
					</header>
					
					<div class="cover-mix">
						<article>
							
							<?php if($mix['cover']):?> 
								<figure>
									<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $mix['cover']; ?>" alt="<?php echo $mix['mix_title']; ?>" title=""  width="200" height="250"/>
								</figure>
							<?php else: ?>
								<figure>
									<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="" title="" width="200" height="200"/>
								</figure>
							<?php endif; ?>
							
							<div>
								<p class="gap-T5 gap-B10 txt-italic txt-gray"> 
									<a class="link-red-gray" title=""><?php echo $mix['author']; ?></a>
								</p>
								
								<div class="share">
									<input type="hidden" id="input_url" value="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($mix['mix_title']).'-'.$mix['mix_id']; ?>" />
								    <input type="hidden" id="input_img" value="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $mix['cover']; ?>" />
								    <input type="hidden" id="input_title" value="<?php echo $title; ?>" />
								    <input type="hidden" id="input_desc" value="<?php echo ShortenText(strip_tags($description),140); ?>" />
								    <input type="hidden" id="input_app_id" value="<?php echo cfg('social', 'facebook_appid'); ?>" />
								    <input type="hidden" id="input_redirect_url" value="<?php echo cfg('base', 'site_url'); ?>" />
								    <input type="hidden" id="input_via" value="<?php echo str_replace("https://twitter.com/","",cfg('social', 'twitter_page'));?>" />
								    <input type="hidden" id="input_hashtags" value="" />
									<button class="btn-gray-red gap-B15" id="btn_generate">
										<i class="fa fa-share-alt"></i> Share
									</button>
									<div id="share_target" class="social_links"></div>
								</div> <!-- END .share -->
								
								<footer>
									<script type="text/javascript">var zippywww="<?php echo $mix['zippy_www']; ?>";var zippyfile="<?php echo $mix['zippy_file']; ?>";var zippytext="#ffffff";var zippyback="#222222";var zippyplay="#ff0056";var zippywidth="100%";var zippyauto=false;var zippyvol=80;var zippywave = "#666666";var zippyborder = "#222222";</script><script type="text/javascript" src="http://api.zippyshare.com/api/embed_new.js"></script>
								</footer>
							</div>
						</article>
					</div> <!-- END .cover-mix -->
					
					<div class="gap-T5 gap-B5"> 
						<?php echo $mix['mix_description']; ?>
					</div>
					

					<?php if($content_ad): ?>
						<div class="advertisement">
							<?php echo $content_ad; ?>
						</div> <!-- END .advertisement -->
					<?php endif; ?>
					
					<aside>
						<header>
							<h3>Tracklist</h3>
						</header>
						
						<?php echo $mix['tracklist']; ?>
					</aside>
					
					<?php if($content_ad): ?>
						<div class="advertisement">
							<?php echo $content_ad; ?>
						</div> <!-- END .advertisement -->
					<?php endif; ?>
					
					<div>
						<a id="downloadSet" class="button btn-gray-red left" href="<?php echo $mix['download_url']; ?>" title="">
							<i class="fa fa-download"></i> Download
						</a>
						
						<?php if(cfg('social', 'facebook_appid')): ?>
						<div class="right fbLikeWrapper">
							<div class="fb-like"
								data-href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($mix['mix_title']).'-'.$mix['mix_id']; ?>" 
								data-width="80" 
								data-layout="button_count" 
								data-show-faces="false" 
								data-send="false"
							></div>
						</div> <!-- END .right -->
						<?php endif; ?> 
					</div>
					
					<?php if(cfg('social', 'facebook_appid') && cfg('social', 'comment_system') == 1): ?>
					<div class="fbComments gradBefore">
						<div class="fb-comments" 
							data-href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($mix['mix_title']).'-'.$mix['mix_id']; ?>" 
							data-colorscheme="dark" 
							data-width="100%"
							data-layout="standard" 
							data-action="like" 
							data-show-faces="false" 
							data-send="false"
						></div>
					</div>
					<?php endif; ?>
					
					<?php if(cfg('social', 'disqus_shortname') && cfg('social', 'comment_system') == 2): ?>
						<div id="disqus_thread"></div>
						<script type="text/javascript">
							/* * * CONFIGURATION VARIABLES: EDIT BEFORE PASTING INTO YOUR WEBPAGE * * */
							var disqus_shortname = '<?php echo cfg('social', 'disqus_shortname'); ?>'; // required: replace example with your forum shortname

							/* * * DON'T EDIT BELOW THIS LINE * * */
							(function() {
								var dsq = document.createElement('script'); dsq.type = 'text/javascript'; dsq.async = true;
								dsq.src = '//' + disqus_shortname + '.disqus.com/embed.js';
								(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(dsq);
							})();
						</script>
					<?php endif; ?>
						
				</section> <!-- END .module .setDetails -->

			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_MIXES']; ?></h2>
					</header>
					
					<div class="articles smallArticles widgetArticles">
					
						<?php foreach ($mixes as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title="">
								<?php if($mix['cover']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['cover']; ?>" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php else: ?>
									<figure>
										<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title=""><?php echo $row['mix_title']; ?></a></h3>
								</header>
								<p>
									<i class="fa fa-user"></i> <?php echo $row['author']; ?>
								</p>
							</div>
						</article>
						
						<?php endforeach; ?>
					
					</div> <!-- END .articles .smallArticles .widgetArticles -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</article> <!-- END .widget -->
				
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>
			
			</aside> <!-- END .sidebar .right -->
		
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>