<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>

	<div id="container">
		
		<div class="wrapper">
		
			<div class="module">
				<div id="map" style="max-width:1073px;height:300px;">
				</div>
			</div> <!-- END .module -->
			
		
			<div class="content left">
			
				<section class="module">
					<header>
						<h1><?php echo $lang['TITLE_CONTACT']; ?></h1>
					</header>
					
					<?php if (isset($_POST['submit_message']) && !$_POST['honeypot']): ?>
					<article class="alertBox alertSuccess" data-init="alertbox" data-effect="slideUp">
						<header>
							<i class="fa fa-check-circle"></i>
						</header>
						
						<div>
							<h4 class="txt16"><?php echo $lang['FORM_VALIDATIONMESSAGE']; ?></h4>
						</div>
						
						<footer>
							<i class="close" title="Close">x</i>
						</footer>
					</article> <!-- END .alertBox .alertSuccess -->
					<?php endif; ?>
					<form class="formContact" action="#" method="post" data-parsley-validate data-parsley-errors-messages-disabled>
						<fieldset>
							<div>
								<label><?php echo $lang['LABEL_NAME']; ?></label>
								<div>
									<input type="text" name="name" placeholder="<?php echo $lang['PLACEHOLDER_NAME']; ?>" data-parsley-required="true" data-parsley-trigger="change"/>
								</div>
							</div>
							
							<div>
								<label><?php echo $lang['LABEL_EMAIL']; ?></label>
								<div>
									<input type="email" name="email" placeholder="<?php echo $lang['PLACEHOLDER_EMAIL']; ?>" data-parsley-required="true" data-parsley-type="email" data-parsley-trigger="change"/>
								</div>
							</div>
							
							<div>
								<label><?php echo $lang['LABEL_SUBJECT']; ?></label>
								<div>
									<input type="text" name="subject" id="subject" placeholder="<?php echo $lang['PLACEHOLDER_SUBJECT']; ?>" data-parsley-required="true" data-parsley-trigger="change"/>
								</div>
							</div>
							
							<div>
								<label><?php echo $lang['LABEL_MESSAGE']; ?></label>
								<div>
									<textarea id="message" name="message" placeholder="<?php echo $lang['PLACEHOLDER_MESSAGE']; ?>" data-init="growandshrink" data-parsley-required="true" data-parsley-trigger="change"></textarea>
								</div>
							</div>
							
							<div>
								<label>&nbsp;</label>
								<div>
									<button type="submit" name="submit_message" class="btn-gray-red"><?php echo $lang['BTN_SEND_MESSAGE']; ?></button>
								</div>
							</div>
						</fieldset>
					</form>
					
				</section> <!-- END .module -->
				
			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">

				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_FACEBOOK_FAN']; ?></h2>
					</header>
					
					<div class="fb-like-box" 
						data-href="<?php echo cfg('social', 'facebook_page'); ?>" 
						data-colorscheme="dark" 
						data-show-faces="true" 
						data-header="false" 
						data-stream="false"
						data-show-border="false"
						data-height="260">
					</div>
				</article> <!-- END .widget -->

			</aside> <!-- END .sidebar .right -->
		
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
	<script src="https://maps.googleapis.com/maps/api/js?sensor=false"></script>
    <script type="text/javascript">
		function initialize()
		{	var myOptions = {
				zoom: 12,
				center: new google.maps.LatLng(<?php echo cfg('contact', 'map_latitude'); ?>,<?php echo cfg('contact', 'map_longitude'); ?>),
				mapTypeId: google.maps.MapTypeId.ROADMAP
			}
			var map = new google.maps.Map(document.getElementById("map"),myOptions);
			var myLatLng = new google.maps.LatLng(<?php echo cfg('contact', 'map_latitude'); ?>,<?php echo cfg('contact', 'map_longitude'); ?>);
			var beachMarker = new google.maps.Marker({
				position: myLatLng,
				map: map,
				});
		}
		function google_map()
		{	var myZoom = 10;
			var myMarkerIsDraggable = false;
			var myCoordsLenght = 6;
			var defaultLat=<?php echo cfg('contact', 'map_latitude'); ?>;
			var defaultLng=<?php echo cfg('contact', 'map_longitude'); ?>;

			// creates the map
			// zooms
			// centers the map
			// sets the map type
			var map = new google.maps.Map(document.getElementById('map'), {
				zoom: myZoom,
				center: new google.maps.LatLng(defaultLat, defaultLng),
				mapTypeId: google.maps.MapTypeId.ROADMAP
			});

			// creates a draggable marker to the given coords
			var myMarker = new google.maps.Marker({
				position: new google.maps.LatLng(defaultLat, defaultLng),
				draggable: myMarkerIsDraggable
			});

			// adds a listener to the marker
			// gets the coords when drag event ends
			// then updates the input with the new coords
			google.maps.event.addListener(myMarker, 'dragend', function(evt){
				document.getElementById('latitude').value = evt.latLng.lat().toFixed(myCoordsLenght);
				document.getElementById('longitude').value = evt.latLng.lng().toFixed(myCoordsLenght);
			});

			// centers the map on markers coords
			map.setCenter(myMarker.position);

			// adds the marker on the map
			myMarker.setMap(map);
		}
		 google.maps.event.addDomListener(window, 'load', google_map);
	</script>
	
</body>
</html>