<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>
	
	<div id="container">
		
		<div class="wrapper">
		
			<div class="content left">
			
				<section class="module">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_NEWS']; ?></h2>
					</header>
					
					<div class="articles">
					
						<?php foreach ($articles as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($row['article_id'],$site_lang)).'/'.url($row['article_title']).'-'.$row['article_id']; ?>" title="">
								<?php if($row['article_video']):?>
									<figure>
										<iframe style="border:0px;" width="232" height="140" src="http://www.youtube.com/embed/<?php echo $row['article_video']; ?>?rel=0&amp;iv_load_policy=3&amp;hd=1" allowfullscreen></iframe>
									</figure>
								<?php elseif($row['article_image']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['article_image']; ?>" alt="<?php echo $row['article_title']; ?>" title="" width="250" height="166"/>
									</figure>
								<?php else: ?>
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/blog.jpg" alt="<?php echo $row['article_title']; ?>" title="" width="250" height="166"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3>
										<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($row['article_id'],$site_lang)).'/'.url($row['article_title']).'-'.$row['article_id']; ?>" title="">
											<?php echo $row['article_title']; ?>
										</a>
									</h3>
									<ul class="inlineLi">
										<li>
											<i class="fa fa-user"></i> <?php echo $row['article_source']; ?>
										</li>
										<li>
										    <i class="fa fa-calendar"></i> <?php echo $row['date_added']; ?>
										</li>
									</ul>
								</header>
								
								<p><?php echo ShortenText(strip_tags($row['article_content']),200); ?></p>
								
								<footer>
									<a class="button btn-gray-red" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.url(article_category($row['article_id'],$site_lang)).'/'.url($row['article_title']).'-'.$row['article_id']; ?>" title=""><?php echo $lang['BTN_READ_MORE']; ?></a>
								</footer>
							</div>
						</article>
						
					<?php endforeach; ?>	
						
					</div> <!-- END .articles -->
					
					
					<?php if($pages>1) { ?>
					<div class="pagination darkTheme center gap-T25">
					<ol>
					<?php if ($current_page>1) {?>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/1'; ?>">&laquo;</a></li>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.($current_page-1); ?>">&lt;</a></li>
					<?php } else {?>
					<?php }?>

					<?php 
					if($current_page-2<=4)
					{	for($i=1;$i<=$current_page;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
					}
					else
					{	for($i=1;$i<=3;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
						echo '<li><a class="inactive" title="">...</a></li>';
						for($i=$current_page-2;$i<=$current_page;$i++)
						{	if($i!=$current_page)
								echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
							else
								echo '<li><a class="current" href="#">'.$i.'</a></li>';
						}
					}
					?>

					<?php 
					if ($current_page<$pages) 
					{	if($current_page+2>=$pages-3)
						{	for($i=$current_page+1;$i<=$pages;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li><a class="current" href="#">'.$i.'</a></li>';
							}
						}
						else
						{	for($i=$current_page+1;$i<=$current_page+2;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li class="active"><a href="#">'.$i.'</a></li>';
							}
							echo '<li><a class="inactive" title="">...</a></li>';
							for($i=$pages-2;$i<=$pages;$i++)
							{	if($i!=$current_page)
									echo '<li><a href="'.cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.$i.'">'.$i.'</a></li>';
								else
									echo '<li><a class="current" href="#">'.$i.'</a></li>';
							}
						}

					
					?>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.($current_page+1);?>">&gt;</a></li>
					<li><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.$_GET['category'] .'/'.$lang['URL_PAGE'].'/'.$pages;?>">&raquo;</a></li>
					<?php } else {?>
					
					<?php }?>
				</ol>
				</div> <!-- END .pagination -->
				<?php } ?>
					
				</section> <!-- END .module -->
				
			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_BLOG_CATEGORIES']; ?></h2>
					</header>
					
					<ul class="articleCat">
						<?php foreach (categories(0,$site_lang) as $value): ?>
						<li>
						    <a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url($value['category_name']); ?>" title="">&raquo; <?php echo $value['category_name']; ?></a>
						</li>
						<?php endforeach; ?>
					</ul>
				</article> <!-- END .widget -->
			
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_META_TAGS']; ?></h2>
					</header>
					
					<ul class="articleTags">
						<?php $tags = str_replace(' ', '-', trim($keywords)); $tags1 = explode(",", $tags); 
						 foreach ($tags1 as $key1) { if (strlen($key1) > 0) 
						{ 
						  $tag1 = $tag1.'<li><a class="link-gray-red" href="#" title=""><i class="fa fa-tag"></i> '.trim(str_replace('-',' ',$key1)).'</a></li>'; } }
						  $tags =($tag1); ?>
						 <?php echo $tags;?> 
					</ul>
				</article> <!-- END .widget -->
			
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_MIXES']; ?></h2>
					</header>
					
					<div class="articles smallArticles widgetArticles">
					
						<?php foreach ($mixes as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title="">
								<?php if($row['cover']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['cover']; ?>" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php else: ?>
									<figure>
										<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title=""><?php echo $row['mix_title']; ?></a></h3>
								</header>
								<p>
									<i class="fa fa-user"></i> <?php echo $row['author']; ?>
								</p>
							</div>
						</article>
						
						<?php endforeach; ?>
					
					</div> <!-- END .articles .smallArticles .widgetArticles -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</article> <!-- END .widget -->
				
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>	

			</aside> <!-- END .sidebar .right -->
		
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>