/*!
 *	XtendRadio jQuery Plugins
 * 	Author	: @alinhort
 * 	Version	: 1.0
 */

/*----------------------------------------------------------*
*	Toggle between two functions on click					*
*	Use: $(object).ClickToggle(function(){}, function(){});	*
*----------------------------------------------------------*/
(function($) {
    $.fn.ClickToggle = function(func1, func2) {
        var funcs = [func1, func2];
        this.data('toggleclicked', 0);
        this.click(function() {
            var data = $(this).data();
            var tc = data.toggleclicked;
            $.proxy(funcs[tc], this)();
            data.toggleclicked = (tc + 1) % 2;
        });
        return this;
    };
}(jQuery));

 
/*--------------------------------------------------------------------------*
*	Width & Height Auto Increase When typing and Auto Decrease on Delete	*
*	Use with JavaScript		: $(object).GrowAndShrink({options});			*
*	Use without JavaScript	: <input data-init="growandshrink"/>			*
*--------------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		GrowAndShrink: function(options) {
			var defaults = {
				growEvent 	: 'keydown',
				shrinkEvent : 'keyup',
				speed		: 400
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		  = $(this),
					objData		  = obj.data(),
					o 			  = $.extend(true, {}, options, objData),
					initialWidth  = obj.width(),
					initialHeight = obj.height();
				
				obj.on(o.growEvent, function() {
					var $this = $(this);
					$this.css({
						'width' : initialWidth + 'px', 
						'height' : initialHeight + 'px'
					});
					
					var srollWidth 	= $this.prop('scrollWidth'),
						srollHeight = $this.prop('scrollHeight'),
						minWidth 	= $this.css('min-width').replace('px', ''),
						minHeight	= $this.css('min-height').replace('px', '');
					$this.css({
						'width' : Math.max(srollWidth, minWidth) + 'px',
						'height' : Math.max(srollHeight, minHeight) + 'px'
					}); 
				});
				
				obj.on(o.shrinkEvent, function() {
					var $this = $(this);
					if($this.val() == '') {
						$this.animate({
							width: initialWidth,
							height: initialHeight
						}, o.speed);
					} 
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="growandshrink"]').each(function() {
			$(this).GrowAndShrink();
		});
	});
})(jQuery);

/*------------------------------------------------------*
*	Check Multiple Boxes								*
*	Use (JS)	: $(object).CheckAll({options});		*
*	Use (HTML)	: <div data-checkall=".toCheck"></div>	*
*------------------------------------------------------*/
(function($) {
	$.fn.extend({
		CheckAll: function(options) {
			var defaults = {
				event		: 'click',
				txtuncheck	: 'Deselect All'
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData),
					checkbox	= $(obj.data('checkall')),
					inittitle	= obj.attr('title');

				obj.ClickToggle(
					function() {
						checkbox.prop('checked', true);
						obj.attr('title', o.txtuncheck);
					}, function() {
						checkbox.prop('checked', false);
						obj.attr('title', inittitle);
					}
				);
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-checkall]').each(function() {
			$(this).CheckAll();
		});
	});
})(jQuery);

/*------------------------------------------------------------------*
*	Form Input PlaceHolder											*
*	Activated by JavaScript	: $(object).PlaceHolder();				*
*	Activated by Markup 	: <input data-placeholder="text"/>		*
*------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		PlaceHolder: function() {
		
			return this.each(function() {
				var	obj  = $(this),
					text = obj.data('placeholder');

				obj.on('focus', function() {
					if (obj.val() == text) {
						obj.val('');
					}
				});
				
				obj.on('blur', function() {
					if (obj.val() == '') {
						obj.val(text);
					}
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-placeholder]').each(function() {
			$(this).PlaceHolder();
		});
	});
})(jQuery);


/*------------------------------------------------------------------*
*	ScrollTop Animation												*
*	Activated by JavaScript	: $(object).ScrollTop({options});		*
*	Activated by Markup 	: <div data-init="scrolltop"></div>		*
*------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		ScrollTop: function(options) {
			var defaults = {
				event 	: 'click',
				speed	: 800
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 	= $(this),
					objData	= obj.data(),
					o 		= $.extend(true, {}, options, objData);
				
				function ShowAndHide(object) {
					if ($(this).scrollTop()) {
						object.stop().fadeIn(o.speed);
					} else {
						object.stop().fadeOut(o.speed);
					}
				}
				
				ShowAndHide(obj);
				
				$(window).on('scroll', function() {
					ShowAndHide(obj);
				});
				
				obj.on(o.event, function(e) {
					e.preventDefault();
					$('body, html').animate({ scrollTop: 0 }, o.speed);
					return false;
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="scrolltop"]').each(function() {
			$(this).ScrollTop();
		});
	});
})(jQuery);


/*------------------------------------------------------------------*
*	SmoothScroll Animation											*
*	Activated by JavaScript	: $(object).SmoothScroll({options});	*
*	Activated by Markup 	: <div data-init="smoothscroll"></div>	*
*------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		SmoothScroll: function(options) {
			var defaults = {
				event 	: 'click',
				speed	: 1000
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 	= $(this),
					objData	= obj.data(),
					o 		= $.extend(true, {}, options, objData);
				
				obj.on(o.event, function(e) {
					e.preventDefault();
					$('html, body').animate({
						scrollTop: $( $(this).attr('href') ).offset().top
					}, o.speed);
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="smoothscroll"]').each(function() {
			$(this).SmoothScroll();
		});
	});
})(jQuery);


/*-------------------------------------------------------------------*
*	HeaderAnimation													 *
*	Activated by JavaScript	: $(object).HeaderAnimation({options});	 *
*	Activated by Markup 	: <div data-init="headeranimation"></div>*
*-------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		HeaderAnimation: function(options) {
			var defaults = {
				event 	: 'scroll',
				speed	: 500,
				padding : 30
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 			= $(this),
					objData			= obj.data(),
					o 				= $.extend(true, {}, options, objData),
					headerBar 		= obj.find('.headerBar'),
					extraContent 	= obj.find('.hiddenContent'),
					extraTrigger 	= obj.find('.headerToggler'),
					header			= $('#header'),
					container		= $('#container');

					
				//Trigger button goes with the flow
				extraTrigger.ClickToggle(function() {
					extraTrigger.stop().animate({top : extraContent.outerHeight() + 'px'}, o.speed);
					extraTrigger.children('i').removeClass('fa-plus').addClass('fa-minus');
					if (obj.css('position') == "fixed") {
						container.stop().animate({marginTop : extraContent.outerHeight() + 15}, o.speed);
					} else {
						container.stop().animate({marginTop : "auto"}, o.speed);
					}
				}, function() {
					extraTrigger.stop().animate({top : 0}, o.speed);
					extraTrigger.children('i').removeClass('fa-minus').addClass('fa-plus');
					container.stop().animate({marginTop : 15}, o.speed);
				});
				
				$(window).resize(function() {
					if ((obj.css('position') == "fixed") && (extraContent.css('display') == "block")) {
						container.stop().animate({marginTop : extraContent.outerHeight() + 15}, o.speed);
					} else {
						container.stop().animate({marginTop : 15 + 'px'}, o.speed);
					}
				});
				
				//On window scroll animate header
				$(window).on(o.event, function() {
					if (obj.offset().top > 0) {
						obj.addClass('condensed');
					} else {
						obj.removeClass('condensed');
					}			
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="headeranimation"]').each(function() {
			$(this).HeaderAnimation();
		});
	});
})(jQuery);


/*------------------------------------------------------------------*
*	Tabs															*
*	Activated by JavaScript	: $(object).Tabs({options});			*
*	Activated by Markup 	: <div data-init="tabs"></div>			*
*------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		Tabs: function(options) {
			var defaults = {
				event		: 'click',
				active		: undefined,
				collapsible	: false,
				disabled	: [],
				heightStyle	: 'content',		//auto, fill, content
				hideeffect	: 'fadeOut',
				showeffect	: 'fadeIn',
				duration 	: 400
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData);

				obj.tabs({ 
					event 		: o.event,
					active 		: o.active,
					collapsible	: o.collapsible,
					disabled	: o.disabled,
					heightStyle	: o.heightStyle,
					hide 		: {effect: o.hideeffect, duration : o.duration},
					show 		: {effect: o.showeffect, duration : o.duration}
				});
				
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="tabs"]').each(function() {
			$(this).Tabs();
		});
	});
})(jQuery);


/*------------------------------------------------------------------*
*	Toggle															*
*	Activated by JavaScript	: $(object).Toggle({options});			*
*	Activated by Markup 	: <div data-toggle="#target"></div>		*
*------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		Toggle: function(options) {
			var defaults = {
				event		: 'click',
				speed		: 500,
				menutoggler	: false,
				menutitle	: undefined
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData);

				obj.on(o.event, function() {
					$(obj.data('toggle')).slideToggle(o.speed);
				});
				
				if (o.menutoggler == true) {
					$(window).resize(function() {  
						var w = $(window).width();  
						if(w > 320 && $(obj.data('toggle')).css('display') == "none") {  
							$(obj.data('toggle')).removeAttr('style');  
						}  
					});
					
					if (o.menutitle != undefined) {
						obj.parent().append('<h3>' + obj.data('menutitle') + '</h3>');
					}
				}
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-toggle]').each(function() {
			$(this).Toggle();
		});
	});
})(jQuery);


/*------------------------------------------------------------------*
*	ToolTip															*
*	Activated by JavaScript	: $(object).ToolTip({options});			*
*	Activated by Markup 	: <div data-init="tooltip"></div>		*
*------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		ToolTip: function(options) {
			var defaults = {
				event	: 'mouseover',
				duration: 600
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData);
					
				obj.tooltip({
					track	: true,
					show	: {effect : "fadeIn", duration : o.duration},
					hide	: {effect : "fadeOut", duration : 1},
					position: {
						my: "left+15 top+10",
						at: "left+15 bottom+10"
					}
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('[title]').each(function() {
			$(this).ToolTip();
		});
	});
})(jQuery);


/*------------------------------------------------------------------*
*	Accordion														*
*	Activated by JavaScript	: $(object).Accordion({options});		*
*	Activated by Markup 	: <div data-init="accordion"></div>		*
*------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		Accordion: function(options) {
			var defaults = {
				event 		: 'click',
				header		: '> div > header',
				active		: false,
				collapsible	: true,
				icons		: false,
				heightStyle	: 'content'
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData),
					customIcons = undefined;
					
				if (o.icons == true) {
					customIcons = {
						header		: "fa fa-plus",
						activeHeader: "fa fa-minus"
					};
				};

				obj.accordion({
					event		: o.event,
					icons		: customIcons,
					header		: o.header,
					active		: o.active,
					collapsible	: o.collapsible,
					heightStyle	: o.heightStyle	
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="accordion"]').each(function() {
			$(this).Accordion();
		});
	});
})(jQuery);


/*----------------------------------------------------------------------*
*	CountDownRedirect													*
*	Activated by JavaScript	: $(object).CountDownRedirect({options});	*
*	Activated by Markup 	: <div data-init="countdownredirect"></div>	*
*----------------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		CountDownRedirect: function(options) {
			var defaults = {
				event		: 'load',
				duration	: 1000,
				countfrom	: 5,
				page		: 'http://www.xtendradio.ro/'
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData),
					target		= obj.find('.countdown');
					
					
				var countdown = setInterval(function() {
					target.html(o.countfrom);
					
					if (o.countfrom === 0) {
						clearInterval(countdown);
						window.location.href = o.page;
					}
					
					o.countfrom--;
				}, 1000);
				
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="countdownredirect"]').each(function() {
			$(this).CountDownRedirect();
		});
	});
})(jQuery);


/*--------------------------------------------------------------*
*	AlertBox													*
*	Activated by JavaScript	: $(object).AlertBox({options});	*
*	Activated by Markup 	: <div data-init="alertbox"></div>	*
*--------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		AlertBox: function(options) {
			var defaults = {
				event		: 'click',
				speed		: 500,
				timeout		: undefined
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData),
					effect 		= obj.data('effect'),
					closeBtn	= obj.find('.close');
				
				//Close alertbox on click
				closeBtn.on(o.event, function() {
					SetEffect(obj, effect, o.speed);
				});
				
				//Auto close alertbox after 'timeout' miliseconds
				if (o.timeout != undefined) {
					var closeInterval = setInterval(function() {	
						SetEffect(obj, effect, o.speed);
						clearInterval(closeInterval);
					}, o.timeout);
				}
			});
		}	
	});
	
	$(document).ready(function() {
		$('[data-init="alertbox"]').each(function() {
			$(this).AlertBox();
		});
	});
})(jQuery);


/*--------------------------------------------------------------*
*	CustomForm													*
*	Activated by JavaScript	: $(object).CustomForm({options});	*
*	Activated by Markup 	: <div data-init="customform"></div>*
*--------------------------------------------------------------*/
(function($) {
	$.fn.extend({
		CustomForm: function(options) {
			var defaults = {
				event		: 'change'
			};
			var options = $.extend(defaults, options);
			
			return this.each(function() {
				var	obj 		= $(this),
					objData		= obj.data(),
					o 			= $.extend(true, {}, options, objData),
					inputFile	= obj.find('input[type="file"]');
				
				//Input File 
				inputFile.each(function() {
					var $this 		= $(this),
						placeholder = $this.data('placeholder');
					
					$this.wrap('<div class="input fileBrowse"/>');
					
					var wrapper 	= $this.parent();
				
					wrapper.append('<span>' + placeholder + '</span>');
					
					var label 		= wrapper.find('span');

					$this.on('change', function() {
						var val 	= $(this).val();
						
						if (val != "") {
							label.text( val.split('\\').pop() );
						} else {
							label.text(placeholder);
						}
					});
				});
			});
		}	
	});
	
	$(document).ready(function() {
		$('form').each(function() {
			$(this).CustomForm();
		});
	});
})(jQuery);


/*------------------------------------------------------------------*
*	DOM element Change Event										*
*------------------------------------------------------------------*/
;(function (factory) {
    if (typeof exports == 'object') {
        factory(require('jquery'));
    } else if (typeof define == 'function' && define.amd) {
        define(['jquery'], factory);
    } else {
        factory(jQuery);
    }
}(function ($) {
    'use strict';
    /**
     * Triggers the DOM changed event on the given element
     *
     * @private
     * @param   {Object}    element     the jQuery element that has been modified
     * @param   {String}    type        jQuery method used to trigger manipulation
     */
    function jQueryDOMChanged (element, type) {
        return $(element).trigger('DOMChanged', type);
    }
    /**
     * Wraps a given jQuery method and injects another function to be called
     *
     * @private
     * @param   {String}    method
     * @param   {Function}  caller
     */
    function jQueryHook (method, caller) {
        var definition = $.fn[method];
        if (definition) {
            $.fn[method] = function () {
                var args   = Array.prototype.slice.apply(arguments);
                var result = definition.apply(this, args);
                caller.apply(this, args);
                return result;
            };
        }
    }
    jQueryHook('prepend', function () {
        return jQueryDOMChanged(this, 'prepend');
    });
    jQueryHook('append', function () {
        return jQueryDOMChanged(this, 'append');
    });
    jQueryHook('before', function () {
        return jQueryDOMChanged($(this).parent(), 'before');
    });
    jQueryHook('after', function () {
        return jQueryDOMChanged($(this).parent(), 'after');
    });
    jQueryHook('html', function (value) {
        // Internally jQuery will set strings using innerHTML
        // otherwise will use append to insert new elements
        // Only trigger on string types to avoid doubled events
        if (typeof value === 'string') {
            return jQueryDOMChanged(this, 'html');
        }
    });
}));


/*----------------------------------------------------------*
*	Set custome effect for transitions						*
*	Call in JavaScript	: SetEffect(object, effect, speed);	*
*----------------------------------------------------------*/
function SetEffect(object, effect, speed) {
	//Check if effect provided it's a valid function
	if ($.isFunction(object[effect])) {
		//Apply the effect to object
		object[effect](speed);
	} else { 
		//Apply default effect to object
		object.slideUp(speed);
	}
}


/*----------------------------------------------*
*	Plugins auto loaded when DOM is ready		*
*----------------------------------------------*/
(function() {

	//Clone header for layout match
	var $header 	= $('#header').children('.wrapper, .wrap').html(),
		$container 	= $('#container');
		
	$('<div class="headerClone" aria-hidden="true">' + $header + '</div>').insertBefore($container);

	
	//Page smooth scroll
	$("html").niceScroll({
		scrollspeed 	: 60,
		mousescrollstep : 40,
		zindex 			: 10000,
		autohidemode	: true,
		bouncescroll	: true
	});

	
	//Main Navgation
	$('.mainNav').children('li').hover(function() {
		$('ul', this).stop().slideDown(400);

		$(this).has('ul').children('a').click(function(e) {
			if ($(this).attr('href') == "#") {
				e.preventDefault();
			}
		});
	}, function() {		
		$('ul', this).stop().slideUp(400); 		
	});

})();