<!DOCTYPE html>
<html lang="<?php echo $site_lang;?>">

<?php require_once('head' . cfg('template', 'template_extension')); ?>

<body>
    
	<?php require_once('header' . cfg('template', 'template_extension')); ?>
	
	<div id="container">
		
		<div class="wrapper">
		
			<div class="module">
			
				<ul class="breadcrumbNav">
					<li>
						<a href="<?php echo cfg('base', 'site_url').$url_lang; ?>" title="">
							<i class="fa fa-home"></i> <?php echo $lang['MENU_HOME']; ?>
						</a>
					</li>
					
					<li>
						<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG']; ?>" title="">
							<i class="fa fa-file"></i> <?php echo $lang['MENU_BLOG']; ?>
						</a>
					</li>
					
					<li>
						<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($art['article_id'],$site_lang)); ?>" title="">
							<i class="fa fa-list"></i> <?php echo ucfirst(article_category($art['article_id'],$site_lang)); ?>
						</a>
					</li>
					
					<li><?php echo $art['article_title']; ?></li>
				</ul>
				
			</div> <!-- END .module -->
			
			
			<div class="content left">
			
				<section class="module">
					<header>
						<h1><?php echo $art['article_title']; ?></h1>
					</header>
					
					<div class="articleDetails">
						
						<div class="left">
							<ul class="inlineLi gapLi-R10 txt-gray">
								<li>
									<a class="link-gray-red" title="">
										<i class="fa fa-user"></i> <?php echo $art['article_source']; ?>
									</a>
								</li>
								
								<li>
									<i class="fa fa-calendar"></i>&nbsp;
									<time datetime="<?php echo $art['date_added']; ?>"><?php echo $art['date_added']; ?></time>
								</li>
							</ul>
						</div> <!-- END .left -->
 						<br><br>
						
						<?php if($art['article_video']):?>
								<figure>
									<iframe style="border:0px;" width="728" height="438" src="http://www.youtube.com/embed/<?php echo $art['article_video']; ?>?rel=0&amp;iv_load_policy=3&amp;hd=1" allowfullscreen></iframe>
								</figure>
							<?php elseif($art['article_image']):?> 
								<figure>
									<img class="block scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $art['article_image']; ?>" alt="<?php echo $art['article_title']; ?>" title="" width="728" height="438"/>
								</figure>
							<?php else: ?>
								<figure>
									<img class="block scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj3.jpg" alt="<?php echo $art['article_title']; ?>" title=""  width="728" height="438"/>
								</figure>
							<?php endif; ?>
						
						
						<?php echo $art['article_content']; ?>
					
						<footer>
							
							<div class="left share">
								<input type="hidden" id="input_url" value="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($art['article_id'],$site_lang)).'/'.url($art['article_title']).'-'.$art['article_id']; ?>" />
								<input type="hidden" id="input_img" value="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $art['article_image']; ?>" />
								<input type="hidden" id="input_title" value="<?php echo $title; ?>" />
								<input type="hidden" id="input_desc" value="<?php echo ShortenText(strip_tags($description),140); ?>" />
								<input type="hidden" id="input_app_id" value="<?php echo cfg('social', 'facebook_appid'); ?>" />
								<input type="hidden" id="input_redirect_url" value="<?php echo cfg('base', 'site_url'); ?>" />
								<input type="hidden" id="input_via" value="<?php echo str_replace("https://twitter.com/","",cfg('social', 'twitter_page'));?>" />
								<input type="hidden" id="input_hashtags" value="" />
								<button class="btn-gray-red gap-B10" id="btn_generate">
									<i class="fa fa-share-alt"></i> Share
								</button>
								<div id="share_target" class="social_links"></div>
							</div> <!-- END .left -->
							
							<?php if(cfg('social', 'facebook_appid')): ?>
							<div class="right fbLikeWrapper">
								<div class="fb-like"
									data-href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($art['article_id'],$site_lang)).'/'.url($art['article_title']).'-'.$art['article_id']; ?>" 
									data-width="80" 
									data-layout="button_count" 
									data-show-faces="false" 
									data-send="false"
								></div>
							</div> <!-- END .right -->
							<?php endif; ?> 
							
						</footer>
						
						<?php if(cfg('social', 'facebook_appid') && cfg('social', 'comment_system') == 1): ?>
						<div class="fbComments gradBefore">
							<div class="fb-comments" 
								data-href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url(article_category($art['article_id'],$site_lang)).'/'.url($art['article_title']).'-'.$art['article_id']; ?>" 
								data-colorscheme="dark" 
								data-width="100%"
								data-layout="standard" 
								data-action="like" 
								data-show-faces="false" 
								data-send="false"
							></div>
						</div>
						<?php endif; ?>
						
						<?php if(cfg('social', 'disqus_shortname') && cfg('social', 'comment_system') == 2): ?>
						<div id="disqus_thread"></div>
						<script type="text/javascript">
							/* * * CONFIGURATION VARIABLES: EDIT BEFORE PASTING INTO YOUR WEBPAGE * * */
							var disqus_shortname = '<?php echo cfg('social', 'disqus_shortname'); ?>'; // required: replace example with your forum shortname

							/* * * DON'T EDIT BELOW THIS LINE * * */
							(function() {
								var dsq = document.createElement('script'); dsq.type = 'text/javascript'; dsq.async = true;
								dsq.src = '//' + disqus_shortname + '.disqus.com/embed.js';
								(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(dsq);
							})();
						</script>
						<?php endif; ?>
						
					</div> <!-- END .articleDetails -->
					
				</section> <!-- END .module -->
				
			</div> <!-- END .content .left -->
			
			
			<aside class="sidebar right">
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_BLOG_CATEGORIES']; ?></h2>
					</header>
					
					<ul class="articleCat">
						<?php foreach (categories(0,$site_lang) as $value): ?>
						<li>
						    <a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_BLOG'].'/'.url($value['category_name']); ?>" title="">&raquo; <?php echo $value['category_name']; ?></a>
						</li>
						<?php endforeach; ?>
					</ul>
				</article> <!-- END .widget -->
			
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_META_TAGS']; ?></h2>
					</header>
					
					<ul class="articleTags">
						<?php $tags = str_replace(' ', '-', trim($keywords)); $tags1 = explode(",", $tags); 
						 foreach ($tags1 as $key1) { if (strlen($key1) > 0) 
						{ 
						  $tag1 = $tag1.'<li><a class="link-gray-red" href="#" title=""><i class="fa fa-tag"></i> '.trim(str_replace('-',' ',$key1)).'</a></li>'; } }
						  $tags =($tag1); ?>
						 <?php echo $tags;?> 
					</ul>
				</article> <!-- END .widget -->
			
			
				<article class="widget">
					<header>
						<h2><?php echo $lang['TITLE_LATEST_MIXES']; ?></h2>
					</header>
					
					<div class="articles smallArticles widgetArticles">
					
						<?php foreach ($mixes as $row): ?>
						
						<article>
							<a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title="">
								<?php if($row['cover']):?> 
									<figure class="scaleEffect">
										<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $row['cover']; ?>" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php else: ?>
									<figure>
										<img class="scaleEffect" src="<?php echo cfg('base', 'site_url'); ?>templates/assets/img/tmp/dj.jpg" alt="<?php echo $row['mix_title']; ?>" title="" width="50" height="50"/>
									</figure>
								<?php endif; ?>
							</a>
							
							<div>
								<header>
									<h3><a href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES'].'/'.url($row['mix_title']).'-'.$row['mix_id']; ?>" title=""><?php echo $row['mix_title']; ?></a></h3>
								</header>
								<p>
									<i class="fa fa-user"></i> <?php echo $row['author']; ?>
								</p>
							</div>
						</article>
						
						<?php endforeach; ?>
					
					</div> <!-- END .articles .smallArticles .widgetArticles -->
					
					<footer>
						<a class="link-black-white" href="<?php echo cfg('base', 'site_url').$url_lang.$lang['URL_DJMIXES']; ?>" title=""><?php echo $lang['BTN_MORE']; ?> <i class="fa fa-arrow-right"></i></a>
					</footer>
					
				</article> <!-- END .widget -->
				
				<?php if($sidebar_ad): ?>
					<article class="widget">
					
						<?php echo $sidebar_ad; ?>
						
					</article> <!-- END .widget -->
				<?php endif; ?>	

			</aside> <!-- END .sidebar .right -->
		
		
		</div> <!-- END .wrapper -->
		
	</div> <!-- END #container -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
</body>
</html>