<!DOCTYPE html>
<html>
    
	<?php require_once('head' . cfg('template', 'template_extension')); ?>
    
	<body class="skin-black">
        
		<?php require_once('header' . cfg('template', 'template_extension')); ?>
		
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">
                
			    <?php require_once('sidebar' . cfg('template', 'template_extension')); ?>	
				
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Edit partner
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="partners.php">Partners</a></li>
						<li class="active">Edit partner</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        
                        <div class="col-md-12">
                            
							<?php if ($error->hasErrors()): ?>
								 <div class="alert alert-danger alert-dismissable">
									<i class="fa fa-ban"></i>
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
									<span>
									<strong>An error occurred while processing request</strong>
									</span>
									<?php foreach ($error->displayErrors() as $value): ?>		
									<p><?php echo $value; ?></p>
									<?php endforeach; ?>
								 </div>
								 <?php $error->clearErrors(); ?>
							<?php else: ?>
								<?php if ($session->get('success')): ?>
								 <div class="alert alert-success alert-dismissable">
									<i class="fa fa-check"></i>
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
									Partner edited successfully! 
								 </div>
								 <?php $session->delete('success'); endif; ?>
							<?php endif; ?>
							
							<?php if (isset($_GET['partner_id']) && $rowCount > 0): ?>
							<!-- form start -->
                            <form role="form" action="" method="post" enctype="multipart/form-data">
                                 
								<div class="box box-primary">
									<div class="box-header">
                                        <!--<h3 class="box-title">Quick Example</h3>-->
                                    </div><!-- /.box-header -->
									<div class="box-body">
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Image</label>
											<div class="col-md-10 no-padding">
												<input id="image" type="file" name="image">
												<span class="help-block">Image browser and preview only. Press submit to upload.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Partner Name</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="partner_name" value="<?php echo $partner['partner_name']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Partner URL</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="partner_url" value="<?php echo $partner['partner_url'];?>">
												<span class="help-block">Enter full url with http:// included.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Partner status</label>
											<div class="col-md-10 no-padding">
												<?php if ($partner['partner_status']): ?>
													 <div class="radio-inline">
														<label><input type="radio" class="iradio_minimal" name="partner_status" value="1" checked="checked"> Active </label>
													 </div>
													 <div class="radio-inline">															
														<label><input type="radio" class="iradio_minimal" name="partner_status" value="0"> Inactive </label>
													 </div>
													 <?php else: ?>
													 <div class="radio-inline">
														<label><input type="radio" class="iradio_minimal" name="partner_status" value="1"> Active </label>
													 </div>
													 <div class="radio-inline">															
														<label><input type="radio" class="iradio_minimal" name="partner_status" value="0" checked="checked"> Inactive </label>
													 </div>
												<?php endif; ?>
											</div>
										</div>
									</div><!-- /.box-body -->  
									<div class="box-footer">
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2"></label>
											<div class="col-md-10 no-padding">
												<button type="submit" name="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</div><!-- /.box-footer -->                                                                        
							    
								<div class="clearfix"></div>
								
								</div><!-- /.box -->
                            </form><!-- /.form -->
							
							<?php else: ?>
								<div class="alert alert-info alert-dismissable">
									<i class="fa fa-info"></i>
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
									<p>Partner not found.</p>
								</div>
							<?php endif; ?>
							
                        </div><!--/.col -->
                    </div>   <!-- /.row -->
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->
        
    <?php require_once('footer' . cfg('template', 'template_extension')); ?>	
	
	<!-- Bootstrap File Input -->
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/bootstrap-fileinput/fileinput.js" type="text/javascript"></script>
	<script>
    $("#image").fileinput({
        <?php if($partner['partner_image']): ?>
		initialPreview: [
            '<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $partner['partner_image']; ?>" class="file-preview-image preview-image">'
         ],
		<?php else: ?>
		 initialPreview: [
            '<img src="<?php echo cfg('base', 'site_url'); ?>templates/admin/assets/img/no_image.png" class="file-preview-image preview-image">'
         ],
		<?php endif; ?>
        overwriteInitial: true,
		browseClass: "btn btn-primary btn-md",
		showCaption: false,
		showUpload: false,
		previewClass: "preview-image",
		removeLabel: '',
	});
	</script>
	
    </body>
</html>
