<!DOCTYPE html>
<html>
    
	<?php require_once('head' . cfg('template', 'template_extension')); ?>
    
	<body class="skin-black">
        
		<?php require_once('header' . cfg('template', 'template_extension')); ?>
		
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">
                
			    <?php require_once('sidebar' . cfg('template', 'template_extension')); ?>	
				
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Edit Article 
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="articles.php">Articles</a></li>
	                    <li class="active">Edit Article</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        
                        <div class="col-md-12">
                            
							<?php if ($error->hasErrors()): ?>
								 <div class="alert alert-danger alert-dismissable">
									<i class="fa fa-ban"></i>
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
									<span>
									<strong>An error occurred while processing request</strong>
									</span>
									<?php foreach ($error->displayErrors() as $value): ?>		
									<p><?php echo $value; ?></p>
									<?php endforeach; ?>
								 </div>
								 <?php $error->clearErrors(); ?>
							<?php else: ?>
								<?php if ($session->get('success')): ?>
								 <div class="alert alert-success alert-dismissable">
									<i class="fa fa-check"></i>
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
									Article edited successfully! 
								 </div>
								 <?php $session->delete('success'); endif; ?>
							 <?php endif; ?>
							
							
							<?php if (isset($_GET['article_id']) && $rowCount > 0): ?>
							<!-- form start -->
                            <form role="form" action="" method="post" enctype="multipart/form-data">
                                 
								<div class="box box-primary">
									<div class="box-header">
                                        <!--<h3 class="box-title">Quick Example</h3>-->
                                    </div><!-- /.box-header -->
									<div class="box-body">
										
										<!-- Custom Tabs (Pulled to the right) -->
										<div class="nav-tabs-custom">
											<ul class="nav nav-tabs pull-right">
												<?php foreach ($languages as $row): ?>
												<li <?php if($row['language_code']==cfg('language', 'site_language')) echo 'class="active"'; ?>><a href="#<?php echo $row['language_code']; ?>" data-toggle="tab"><?php echo $row['language_code']; ?></a></li>
												<?php endforeach; ?>
												<li class="pull-left header"><i class="fa fa-flag"></i> Language</li>
											</ul>
											<div class="tab-content">
												<?php foreach ($languages as $row): ?>
												<div class="tab-pane <?php if($row['language_code']==cfg('language', 'site_language')) echo 'active'; ?>" id="<?php echo $row['language_code']; ?>">
													<fieldset class="default-fieldset">
							                            <legend><i class="fa fa-tags" data-toggle="tooltip" title="Meta tags are pieces of HTML code which are finded by some search engines, but for the most visitors aren't visible. With their help, you can control how search engines indexing your site."></i> Meta Data</legend>
												        <input type="hidden" class="form-control" name="language_code" value="<?php echo $row['language_code']; ?>">
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Title</label>
															<div class="col-md-10 no-padding">
																<input type="text" class="form-control" name="article_title<?php echo '_'.$row['language_code']; ?>" value="<?php echo art($row['language_code'],'article_title'); ?>">
															    <span class="help-block">Recommended length is under 70 characters.</span>
															</div>
														</div>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Meta keywords</label>
															<div class="col-md-10 no-padding">
																<input id="tags_<?php echo $row['language_code']; ?>" type="text" class="form-control tags" type="text" class="tags" name="article_meta_keywords<?php echo '_'.$row['language_code']; ?>" value="<?php echo art($row['language_code'],'article_meta_keywords'); ?>">
															    <span class="help-block">5 to 10 words that best describe the site/page separated by commas.</span>
															</div>
														</div>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Meta Description</label>
															<div class="col-md-10 no-padding">
																<textarea class="form-control" rows="3" name="article_meta_description<?php echo '_'.$row['language_code']; ?>"><?php echo art($row['language_code'],'article_meta_description'); ?></textarea>
															    <span class="help-block">In this paragraph is described the site/page. Recommended length is between 120-150 characters.</span>
															</div>
														</div>
													</fieldset>
													<fieldset class="default-fieldset">
													<legend><i class="fa fa-file"></i> Content Data</legend>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Content</label>
															<div class="col-md-10 no-padding">
																<textarea class="form-control ckeditor" name="article_content<?php echo '_'.$row['language_code']; ?>"><?php echo art($row['language_code'],'article_content'); ?></textarea>
															</div>
														</div>
													</fieldset>
												</div><!-- /.tab-pane -->
												<?php endforeach; ?>
											</div><!-- /.tab-content -->
											</div><!-- nav-tabs-custom -->
											<!-- END CUSTOM TABS -->
											
											<div class="form-group col-md-12 no-padding">
												<label class="control-label col-md-2">Image</label>
												<div class="col-md-10 no-padding">
													<input id="image" type="file" name="image">
													<span class="help-block">Image browser and preview only. Press submit to upload.</span>
												</div>
										    </div>
											
											<div class="form-group col-md-12 no-padding">
												<label class="control-label col-md-2">Embed youtube video</label>
												<div class="col-md-10 no-padding">
													<input type="text" class="form-control" name="article_video" value="<?php echo $art['article_video']; ?>">
													<span class="help-block">For youtube videos go to share, select embed and place only code for youtube video (ex. http://www.youtube/.../<span class="label label-info">n7Y9-YYkOGk</span>).</span>
												</div>
										    </div>
											
											<div class="form-group col-md-12 no-padding">
												<label class="control-label col-md-2">Category</label>
												<div class="col-md-10 no-padding">
													<select class="form-control select2" name="category_id">
														<?php foreach (categories(0,cfg('language','site_language')) as $value): ?>
															<?php if ($value['category_id'] == art(cfg('language','site_language'),'category_id')): ?>
																<option value="<?php echo $value['category_id']; ?>" selected="selected"><?php echo $value['category_name']; ?></option>
															<?php else: ?>	
																<option value="<?php echo $value['category_id']; ?>"><?php echo $value['category_name']; ?></option>
															<?php endif; ?>
														<?php endforeach; ?>
													</select>
												</div>
											</div>
											
											<div class="form-group col-md-12 no-padding">
												<label class="control-label col-md-2">Source/Author</label>
												<div class="col-md-10 no-padding">
													<input type="text" class="form-control" name="article_source" value="<?php echo $art['article_source']; ?>">
												</div>
											</div>
										
											<div class="form-group col-md-12 no-padding">
												<label class="control-label col-md-2">Article status</label>
												<div class="col-md-10 no-padding">
													<?php if ($art['article_status']): ?>
													<div class="radio-inline">
														<label><input type="radio" name="article_status" class="iradio_minimal" value="1" checked="checked"> Active </label>
													 </div>
													 <div class="radio-inline">															
														<label><input type="radio" name="article_status" class="iradio_minimal" value="0"> Inactive </label>
													 </div>
													 <?php else: ?>
													 <div class="radio-inline">
														<label><input type="radio" name="article_status" class="iradio_minimal" value="1"> Active </label>
													 </div>
													 <div class="radio-inline">															
														<label><input type="radio" name="article_status" class="iradio_minimal" value="0" checked="checked"> Inactive </label>
													 </div>
													 <?php endif; ?>
												</div>
											</div>
										
									</div><!-- /.box-body -->  
									<div class="box-footer">
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2"></label>
											<div class="col-md-10 no-padding">
												<button type="submit" name="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</div><!-- /.box-footer -->                                                                        
							    
								<div class="clearfix"></div>
								
								</div><!-- /.box -->
                            </form><!-- /.form -->
							
							<?php else: ?>
								<div class="alert alert-info alert-dismissable">
									<i class="fa fa-info"></i>
									<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
									<p>Article not found.</p>
								</div>
							<?php endif; ?>
							
                        </div><!--/.col -->
                    </div>   <!-- /.row -->
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->
        
    <?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
	<!-- CK Editor -->
	<script src="<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/js/plugins/ckeditor/ckeditor.js" type="text/javascript"></script>
	<?php foreach ($languages as $row): ?>
	<script type="text/javascript">
		$(function() {
			// Replace the <textarea class="ckeditor" name="article_content_(language_code)"> with a CKEditor
			// instance, using default configuration.
			CKEDITOR.replace('article_content<?php echo '_'.$row['language_code']; ?>', {
			
			 filebrowserBrowseUrl: '<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/kcfinder/browse.php?opener=ckeditor&type=files',
			 filebrowserImageBrowseUrl: '<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/kcfinder/browse.php?opener=ckeditor&type=images',
			 filebrowserFlashBrowseUrl: '<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/kcfinder/browse.php?opener=ckeditor&type=flash',
			 filebrowserUploadUrl: '<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/kcfinder/upload.php?opener=ckeditor&type=files',
			 filebrowserImageUploadUrl: '<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/kcfinder/upload.php?opener=ckeditor&type=images',
			 filebrowserFlashUploadUrl: '<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/kcfinder/upload.php?opener=ckeditor&type=flash'
	
			});
			CKEDITOR.add
		});
	</script>
	<?php endforeach; ?>
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/jquery-tags-input/jquery.tagsinput.min.js" type="text/javascript"></script>
	<?php foreach ($languages as $row): ?>
	<script>
            $(function() {
                $('#tags_<?php echo $row['language_code']; ?>').tagsInput({width: 'auto'});
            });
    </script>
	<?php endforeach; ?>
	
	<!-- Bootstrap File Input -->
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/bootstrap-fileinput/fileinput.js" type="text/javascript"></script>
	<script>
    $("#image").fileinput({
        <?php if($art['article_image']): ?>
		initialPreview: [
            '<img src="<?php echo cfg('base', 'site_url'); ?>uploads/images/<?php echo $art['article_image']; ?>" class="file-preview-image preview-image">'
         ],
		<?php else: ?>
		 initialPreview: [
            '<img src="<?php echo cfg('base', 'site_url'); ?>templates/admin/assets/img/no_image.png" class="file-preview-image preview-image">'
         ],
		<?php endif; ?>
        overwriteInitial: true,
		browseClass: "btn btn-primary btn-md",
		showCaption: false,
		showUpload: false,
		previewClass: "preview-image",
		removeLabel: '',
	});
	</script> 
	
    </body>
</html>
