<!DOCTYPE html>
<html>
    
	<?php require_once('head' . cfg('template', 'template_extension')); ?>
    
	<body class="skin-black">
        
		<?php require_once('header' . cfg('template', 'template_extension')); ?>
		
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">
                
			    <?php require_once('sidebar' . cfg('template', 'template_extension')); ?>	
				
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Add User
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="users.php">Users</a></li>
						<li class="active">Add User</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        
                        <div class="col-md-12">
                            
							<?php if ($error->hasErrors()): ?>
							 <div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
								<span>
								<strong>An error occurred while processing request</strong>
								</span>
								<?php foreach ($error->displayErrors() as $value): ?>		
								<p><?php echo $value; ?></p>
								<?php endforeach; ?>
							 </div>
							 <?php $error->clearErrors(); endif; ?>
							<?php if ($session->get('success') && isset($_POST['submit'])): ?>
							 <div class="alert alert-success alert-dismissable">
								<i class="fa fa-check"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
								User added successfully! 
							 </div>
							 <?php endif; ?>
							
							<!-- form start -->
                            <form role="form" action="" method="post" enctype="multipart/form-data">
                                 
								<div class="box box-primary">
									<div class="box-header">
                                        <!--<h3 class="box-title">Quick Example</h3>-->
                                    </div><!-- /.box-header -->
									<div class="box-body">
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Image</label>
											<div class="col-md-10 no-padding">
												<input id="image" type="file" name="image">
												<span class="help-block">Image browser and preview only. Press submit to upload.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">First name</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="first_name" value="<?php if (isset($_POST['first_name'])) echo $_POST['first_name']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Last name</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="last_name" value="<?php if (isset($_POST['last_name'])) echo $_POST['last_name']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Email address</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="email" value="<?php if (isset($_POST['email'])) echo $_POST['email']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">User status</label>
											<div class="col-md-10 no-padding">
												<?php if (isset($_POST['user_status']) && $_POST['user_status'] == 1): ?>
												<div class="radio-inline">
													<label><input type="radio" name="user_status" class="iradio_minimal" value="1" checked="checked"> Active </label>
												 </div>
												 <div class="radio-inline">															
													<label><input type="radio" name="user_status" class="iradio_minimal" value="0"> Inactive </label>
												 </div>
												 <?php else: ?>
												 <div class="radio-inline">
													<label><input type="radio" name="user_status" class="iradio_minimal" value="1"> Active </label>
												 </div>
												 <div class="radio-inline">															
													<label><input type="radio" name="user_status" class="iradio_minimal" value="0" checked="checked"> Inactive </label>
												 </div>
												 <?php endif; ?>
											</div>
										</div>
										<div class="form-group">
											<label class="control-label col-md-2">Welcome email</label>
											<div class="col-md-10">
												 <div class="checkbox no-top">
													<?php if (isset($_POST['send_email'])): ?>
													<input type="checkbox" class="icheckbox_minimal" name="send_email" value="true" checked="checked">
													<?php else: ?>
													<input type="checkbox" class="icheckbox_minimal" name="send_email" value="true">
													<?php endif; ?>
												 </div>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Password</label>
											<div class="col-md-10 no-padding">
												<input type="password" class="form-control" name="password">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Confirm Password</label>
											<div class="col-md-10 no-padding">
												<input type="password" class="form-control" name="confirm_password">
											</div>
										</div>
									</div><!-- /.box-body -->  
									<div class="box-footer">
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2"></label>
											<div class="col-md-10 no-padding">
												<button type="submit" name="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</div><!-- /.box-footer -->                                                                        
							    
								<div class="clearfix"></div>
								
								</div><!-- /.box -->
                            </form><!-- /.form -->
							
                        </div><!--/.col -->
                    </div>   <!-- /.row -->
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
	<!-- Bootstrap File Input -->
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/bootstrap-fileinput/fileinput.js" type="text/javascript"></script>
	<script>
    $("#image").fileinput({
        browseClass: "btn btn-primary btn-md",
		showCaption: false,
		showUpload: false,
		previewClass: "preview-image",
		removeLabel: '',
	});
	</script>
	
    </body>
</html>
