<!DOCTYPE html>
<html>
    
	<?php require_once('head' . cfg('template', 'template_extension')); ?>
    
	<body class="skin-black">
        
		<?php require_once('header' . cfg('template', 'template_extension')); ?>
		
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">
                
			    <?php require_once('sidebar' . cfg('template', 'template_extension')); ?>	
				
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Add mix
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="mixes.php">Mixes</a></li>
						<li class="active">Add mix</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        
                        <div class="col-md-12">
                            
							<?php if ($error->hasErrors()): ?>
							 <div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
								<span>
								<strong>An error occurred while processing request</strong>
								</span>
								<?php foreach ($error->displayErrors() as $value): ?>		
								<p><?php echo $value; ?></p>
								<?php endforeach; ?>
							 </div>
							 <?php $error->clearErrors(); endif; ?>
							<?php if ($session->get('success') && isset($_POST['submit'])): ?>
							 <div class="alert alert-success alert-dismissable">
								<i class="fa fa-check"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
								Mix added successfully! 
							 </div>
							 <?php endif; ?>
							
							<!-- form start -->
                            <form role="form" action="" method="post" enctype="multipart/form-data">
                                 
								<div class="box box-primary">
									<div class="box-header">
                                        <!--<h3 class="box-title">Quick Example</h3>-->
                                    </div><!-- /.box-header -->
									<div class="box-body">
										
										<!-- Custom Tabs (Pulled to the right) -->
										<div class="nav-tabs-custom">
											<ul class="nav nav-tabs pull-right">
												<?php foreach ($languages as $row): ?>
												<li <?php if($row['language_code']==cfg('language', 'site_language')) echo 'class="active"'; ?>><a href="#<?php echo $row['language_code']; ?>" data-toggle="tab"><?php echo $row['language_code']; ?></a></li>
												<?php endforeach; ?>
												<li class="pull-left header"><i class="fa fa-flag"></i> Language</li>
											</ul>
											<div class="tab-content">
												<?php foreach ($languages as $row): ?>
												<div class="tab-pane <?php if($row['language_code']==cfg('language', 'site_language')) echo 'active'; ?>" id="<?php echo $row['language_code']; ?>">
													<fieldset class="default-fieldset">
							                            <legend><i class="fa fa-tags" data-toggle="tooltip" title="Meta tags are pieces of HTML code which are finded by some search engines, but for the most visitors aren't visible. With their help, you can control how search engines indexing your site."></i> Meta Data</legend>
												        <input type="hidden" class="form-control" name=language_code" value="<?php echo $row['language_code']; ?>">
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Title</label>
															<div class="col-md-10 no-padding">
																<input type="text" class="form-control" name="mix_title<?php echo '_'.$row['language_code']; ?>" value="<?php if (isset($_POST['mix_title'.'_'.$row['language_code']])) echo $_POST['mix_title'.'_'.$row['language_code']]; ?>">
															    <span class="help-block">Recommended length is under 70 characters.</span>
															</div>
														</div>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Meta keywords</label>
															<div class="col-md-10 no-padding">
																<input id="tags_<?php echo $row['language_code']; ?>" type="text" class="form-control tags" type="text" class="tags" name="mix_meta_keywords<?php echo '_'.$row['language_code']; ?>" value="<?php if (isset($_POST['mix_meta_keywords'.'_'.$row['language_code']])) echo $_POST['mix_meta_keywords'.'_'.$row['language_code']];?>">
															    <span class="help-block">5 to 10 words that best describe the site/page separated by commas.</span>
															</div>
														</div>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Meta Description</label>
															<div class="col-md-10 no-padding">
																<textarea class="form-control" rows="3" name="mix_meta_description<?php echo '_'.$row['language_code']; ?>"><?php if (isset($_POST['mix_meta_description'.'_'.$row['language_code']])) echo $_POST['mix_meta_description'.'_'.$row['language_code']];?></textarea>
															    <span class="help-block">In this paragraph is described the site/page. Recommended length is between 120-150 characters.</span>
															</div>
														</div>
													</fieldset>
													<fieldset class="default-fieldset">
													<legend><i class="fa fa-file"></i> Content Data</legend>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Description</label>
															<div class="col-md-10 no-padding">
																<textarea class="form-control textarea" name="mix_description<?php echo '_'.$row['language_code']; ?>"><?php if (isset($_POST['mix_description'.'_'.$row['language_code']])) echo $_POST['mix_description'.'_'.$row['language_code']];?></textarea>
															</div>
														</div>
													</fieldset>
												</div><!-- /.tab-pane -->
												<?php endforeach; ?>
											</div><!-- /.tab-content -->
											</div><!-- nav-tabs-custom -->
											<!-- END CUSTOM TABS -->
										
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Image</label>
											<div class="col-md-10 no-padding">
												<input id="image" type="file" name="image">
												<span class="help-block">Image browser and preview only. Press submit to upload.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Author</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="author" value="<?php if (isset($_POST['author'])) echo $_POST['author']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Tracklist</label>
											<div class="col-md-10 no-padding">
												<textarea class="form-control textarea" rows="3" name="tracklist"><?php if (isset($_POST['tracklist'])) echo $_POST['tracklist']; ?></textarea>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Download URL</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="download_url" value="<?php if (isset($_POST['download_url'])) echo $_POST['download_url']; ?>">
											    <span class="help-block">Right click on download button in zippyshare, select <span class="label label-info">Copy link adress</span> and paste here.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Zippywww</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="zippy_www" value="<?php if (isset($_POST['zippy_www'])) echo $_POST['zippy_www']; ?>">
												<span class="help-block">From url copied in download url select number near www, ex http://www <span class="label label-info">21</span> .zippyshare.com... and paste here.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Zippyfile</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="zippy_file" value="<?php if (isset($_POST['zippy_file'])) echo $_POST['zippy_file']; ?>">
												<span class="help-block">From url copied in download url select number near d/, ex http://www21.zippyshare.com/d/ <span class="label label-info">77694024</span> /744/... and paste here.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Mix status</label>
											<div class="col-md-10 no-padding">
												<div class="radio-inline">
													<label><input type="radio" name="mix_status" class="iradio_minimal" value="1" checked="checked"> Active </label>
												 </div>
												 <div class="radio-inline">															
													<label><input type="radio" name="mix_status" class="iradio_minimal" value="0"> Inactive </label>
												 </div>
											</div>
										</div>
									</div><!-- /.box-body -->  
									<div class="box-footer">
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2"></label>
											<div class="col-md-10 no-padding">
												<button type="submit" name="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</div><!-- /.box-footer -->                                                                        
							    
								<div class="clearfix"></div>
								
								</div><!-- /.box -->
                            </form><!-- /.form -->
							
                        </div><!--/.col -->
                    </div>   <!-- /.row -->
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
	
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/jquery-tags-input/jquery.tagsinput.min.js" type="text/javascript"></script>
	<?php foreach ($languages as $row): ?>
	<script>
            $(function() {
                $('#tags_<?php echo $row['language_code']; ?>').tagsInput({width: 'auto'});
            });
    </script>
	<?php endforeach; ?>
	<!-- Bootstrap File Input -->
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/bootstrap-fileinput/fileinput.js" type="text/javascript"></script>
	<script>
    $("#image").fileinput({
        browseClass: "btn btn-primary btn-md",
		showCaption: false,
		showUpload: false,
		previewClass: "preview-image",
		removeLabel: '',
	});
	</script>
	<!-- jQuery DateTimePicker -->
	<script src="<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/datetimepicker/moment-2.4.0.js" type="text/javascript"></script>
	<script src="<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/datetimepicker/bootstrap-datetimepicker.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(function () {
			$('#datetimepicker1').datetimepicker();
		});
	</script>
	<!-- Bootstrap WYSIHTML5 -->
	<script src="<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/js/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(function() {
			//bootstrap WYSIHTML5 - text editor
			$(".textarea").wysihtml5();
		});
	</script>
    </body>
</html>
