<!DOCTYPE html>
<html>
    
	<?php require_once('head' . cfg('template', 'template_extension')); ?>
    
	<body class="skin-black">
        
		<?php require_once('header' . cfg('template', 'template_extension')); ?>
		
        <div class="wrapper row-offcanvas row-offcanvas-left">
            <!-- Left side column. contains the logo and sidebar -->
            <aside class="left-side sidebar-offcanvas">
                
			    <?php require_once('sidebar' . cfg('template', 'template_extension')); ?>	
				
            </aside>

            <!-- Right side column. Contains the navbar and content of the page -->
            <aside class="right-side">
                <!-- Content Header (Page header) -->
                <section class="content-header">
                    <h1>
                        Add event
                    </h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li><a href="events.php">Events</a></li>
						<li class="active">Add event</li>
                    </ol>
                </section>

                <!-- Main content -->
                <section class="content">
                    <div class="row">
                        
                        <div class="col-md-12">
                            
							<?php if ($error->hasErrors()): ?>
							 <div class="alert alert-danger alert-dismissable">
								<i class="fa fa-ban"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
								<span>
								<strong>An error occurred while processing request</strong>
								</span>
								<?php foreach ($error->displayErrors() as $value): ?>		
								<p><?php echo $value; ?></p>
								<?php endforeach; ?>
							 </div>
							 <?php $error->clearErrors(); endif; ?>
							<?php if ($session->get('success') && isset($_POST['submit'])): ?>
							 <div class="alert alert-success alert-dismissable">
								<i class="fa fa-check"></i>
								<button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
								Event added successfully! 
							 </div>
							 <?php endif; ?>
							
							<!-- form start -->
                            <form role="form" action="" method="post" enctype="multipart/form-data">
                                 
								<div class="box box-primary">
									<div class="box-header">
                                        <!--<h3 class="box-title">Quick Example</h3>-->
                                    </div><!-- /.box-header -->
									<div class="box-body">
										
										<!-- Custom Tabs (Pulled to the right) -->
										<div class="nav-tabs-custom">
											<ul class="nav nav-tabs pull-right">
												<?php foreach ($languages as $row): ?>
												<li <?php if($row['language_code']==cfg('language', 'site_language')) echo 'class="active"'; ?>><a href="#<?php echo $row['language_code']; ?>" data-toggle="tab"><?php echo $row['language_code']; ?></a></li>
												<?php endforeach; ?>
												<li class="pull-left header"><i class="fa fa-flag"></i> Language</li>
											</ul>
											<div class="tab-content">
												<?php foreach ($languages as $row): ?>
												<div class="tab-pane <?php if($row['language_code']==cfg('language', 'site_language')) echo 'active'; ?>" id="<?php echo $row['language_code']; ?>">
													<fieldset class="default-fieldset">
							                            <legend><i class="fa fa-tags" data-toggle="tooltip" title="Meta tags are pieces of HTML code which are finded by some search engines, but for the most visitors aren't visible. With their help, you can control how search engines indexing your site."></i> Meta Data</legend>
												        <input type="hidden" class="form-control" name=language_code" value="<?php echo $row['language_code']; ?>">
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Title</label>
															<div class="col-md-10 no-padding">
																<input type="text" class="form-control" name="event_title<?php echo '_'.$row['language_code']; ?>" value="<?php if (isset($_POST['event_title'.'_'.$row['language_code']])) echo $_POST['event_title'.'_'.$row['language_code']]; ?>">
															    <span class="help-block">Recommended length is under 70 characters.</span>
															</div>
														</div>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Meta keywords</label>
															<div class="col-md-10 no-padding">
																<input id="tags_<?php echo $row['language_code']; ?>" type="text" class="form-control tags" type="text" class="tags" name="event_meta_keywords<?php echo '_'.$row['language_code']; ?>" value="<?php if (isset($_POST['event_meta_keywords'.'_'.$row['language_code']])) echo $_POST['event_meta_keywords'.'_'.$row['language_code']];?>">
															    <span class="help-block">5 to 10 words that best describe the site/page separated by commas.</span>
															</div>
														</div>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Meta Description</label>
															<div class="col-md-10 no-padding">
																<textarea class="form-control" rows="3" name="event_meta_description<?php echo '_'.$row['language_code']; ?>"><?php if (isset($_POST['event_meta_description'.'_'.$row['language_code']])) echo $_POST['event_meta_description'.'_'.$row['language_code']];?></textarea>
															    <span class="help-block">In this paragraph is described the site/page. Recommended length is between 120-150 characters.</span>
															</div>
														</div>
													</fieldset>
													<fieldset class="default-fieldset">
													<legend><i class="fa fa-file"></i> Content Data</legend>
														<div class="form-group col-md-12 no-padding">
															<label class="control-label col-md-2">Reservation Details</label>
															<div class="col-md-10 no-padding">
																<textarea class="form-control textarea" name="reservation_details<?php echo '_'.$row['language_code']; ?>"><?php if (isset($_POST['reservation_details'])) echo $_POST['reservation_details']; ?></textarea>
															</div>
														</div>
													</fieldset>
												</div><!-- /.tab-pane -->
												<?php endforeach; ?>
											</div><!-- /.tab-content -->
											</div><!-- nav-tabs-custom -->
											<!-- END CUSTOM TABS -->
										
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Image</label>
											<div class="col-md-10 no-padding">
												<input id="image" type="file" name="image">
												<span class="help-block">Image browser and preview only. Press submit to upload.</span>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Event guests</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="event_guests" value="<?php if (isset($_POST['event_guests'])) echo $_POST['event_guests']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Event date</label>
											<div class="col-md-4 no-padding">
												<div class='input-group date' id='datetimepicker1'>
													<input data-format="YYYY-MM-DD HH:mm:ss" type="text" class="form-control" name="event_date" value="<?php if (isset($_POST['event_date'])) echo $_POST['event_date']; ?>">
													<span class="input-group-addon">
													   <span class="add-on"><i data-time-icon="icon-time" data-date-icon="icon-calendar"></i></span>
													</span>
												</div>
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Event location</label>
											<div class="col-md-10 no-padding">
												<input type="text" class="form-control" name="event_location" value="<?php if (isset($_POST['event_location'])) echo $_POST['event_location']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Ticket price</label>
											<div class="col-md-4 no-padding">
												<input type="text" class="form-control" name="ticket_price" value="<?php if (isset($_POST['ticket_price'])) echo $_POST['ticket_price']; ?>">
											</div>
										</div>
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2">Event status</label>
											<div class="col-md-10 no-padding">
												<div class="radio-inline">
													<label><input type="radio" name="event_status" class="iradio_minimal" value="1" checked="checked"> Active </label>
												 </div>
												 <div class="radio-inline">															
													<label><input type="radio" name="event_status" class="iradio_minimal" value="0"> Inactive </label>
												 </div>
											</div>
										</div>
									</div><!-- /.box-body -->  
									<div class="box-footer">
										<div class="form-group col-md-12 no-padding">
											<label class="control-label col-md-2"></label>
											<div class="col-md-10 no-padding">
												<button type="submit" name="submit" class="btn btn-primary">Submit</button>
											</div>
										</div>
									</div><!-- /.box-footer -->                                                                        
							    
								<div class="clearfix"></div>
								
								</div><!-- /.box -->
                            </form><!-- /.form -->
							
                        </div><!--/.col -->
                    </div>   <!-- /.row -->
                </section><!-- /.content -->
            </aside><!-- /.right-side -->
        </div><!-- ./wrapper -->
	
	<?php require_once('footer' . cfg('template', 'template_extension')); ?>
	
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/jquery-tags-input/jquery.tagsinput.min.js" type="text/javascript"></script>
	<?php foreach ($languages as $row): ?>
	<script>
            $(function() {
                $('#tags_<?php echo $row['language_code']; ?>').tagsInput({width: 'auto'});
            });
    </script>
	<?php endforeach; ?>
	<!-- Bootstrap File Input -->
	<script src="<?php echo cfg('template', 'site_url');?>templates/admin/assets/plugins/bootstrap-fileinput/fileinput.js" type="text/javascript"></script>
	<script>
    $("#image").fileinput({
        browseClass: "btn btn-primary btn-md",
		showCaption: false,
		showUpload: false,
		previewClass: "preview-image",
		removeLabel: '',
	});
	</script>
	<!-- jQuery DateTimePicker -->
	<script src="<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/datetimepicker/moment-2.4.0.js" type="text/javascript"></script>
	<script src="<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/plugins/datetimepicker/bootstrap-datetimepicker.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(function () {
			$('#datetimepicker1').datetimepicker();
		});
	</script>
	<!-- Bootstrap WYSIHTML5 -->
	<script src="<?php echo cfg('template', 'site_url'); ?>templates/admin/assets/js/plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.min.js" type="text/javascript"></script>
	<script type="text/javascript">
		$(function() {
			//bootstrap WYSIHTML5 - text editor
			$(".textarea").wysihtml5();
		});
	</script>
    </body>
</html>
