-- MySQL Script generated by MySQL Workbench
-- 08/03/14 23:06:51
-- Model: New Model    Version: 1.0
SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';


-- -----------------------------------------------------
-- Table `user_groups`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_user_groups` (
  `group_id` INT NOT NULL AUTO_INCREMENT,
  `group_name` VARCHAR(45) NULL,
  `group_description` VARCHAR(255) NULL,
  PRIMARY KEY (`group_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `xtend_user_groups` (`group_id`, `group_name`, `group_description`) VALUES
(1, 'admin', 'Administrator'),
(2, 'user', 'Registered User');

-- -----------------------------------------------------
-- Table `users`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_users` (
  `user_id` INT NOT NULL AUTO_INCREMENT,
  `group_id` INT NOT NULL,
  `user_email` VARCHAR(255) NULL,
  `user_password` VARCHAR(45) NULL,
  `user_status` TINYINT NULL,
  `user_approved` TINYINT NULL,
  `user_created` DATETIME NULL,
  `last_login` DATETIME NULL,
  `last_ip` VARCHAR(45) NULL,
  `remember_code` VARCHAR(45) NULL,
  `activation_code` VARCHAR(45) NULL,
  PRIMARY KEY (`user_id`),
  INDEX `fk_users_user_groups1_idx` (`group_id` ASC),
  CONSTRAINT `fk_users_user_groups1`
    FOREIGN KEY (`group_id`)
    REFERENCES `xtend_user_groups` (`group_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `user_profiles`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_user_profiles` (
  `profile_id` INT NOT NULL AUTO_INCREMENT,
  `user_id` INT NOT NULL,
  `first_name` VARCHAR(255) NULL,
  `last_name` VARCHAR(255) NULL,
  `avatar` VARCHAR(255) NULL,
  PRIMARY KEY (`profile_id`),
  INDEX `fk_user_profiles_users1_idx` (`user_id` ASC),
  CONSTRAINT `fk_user_profiles_users1`
    FOREIGN KEY (`user_id`)
    REFERENCES `xtend_users` (`user_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `social_accounts`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_social_accounts` (
  `social_id` INT NOT NULL AUTO_INCREMENT,
  `social_network` VARCHAR(45) NULL,
  `social_token` VARCHAR(255) NULL,
  `user_id` INT NOT NULL,
  PRIMARY KEY (`social_id`),
  INDEX `fk_social_accounts_users1_idx` (`user_id` ASC),
  CONSTRAINT `fk_social_accounts_users1`
    FOREIGN KEY (`user_id`)
    REFERENCES `xtend_users` (`user_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `languages`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_languages` (
  `language_code` VARCHAR(2) NOT NULL,
  `language_name` VARCHAR(45) NULL,
  `language_status` TINYINT NOT NULL DEFAULT 0,
  PRIMARY KEY (`language_code`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO `xtend_languages` (`language_code`, `language_name`, `language_status`) VALUES
('ro', 'Romana', 1),
('en', 'English', 1);


-- -----------------------------------------------------
-- Table `articles`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_articles` (
  `article_id` INT NOT NULL AUTO_INCREMENT,
  `article_image` VARCHAR(255) NULL,
  `article_video` VARCHAR(255) NULL,
  `article_source` VARCHAR(255) NULL,
  `date_added` DATETIME NULL,
  `article_status` TINYINT NOT NULL DEFAULT 0,
  PRIMARY KEY (`article_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `article_translations`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_article_translations` (
  `translation_id` INT NOT NULL AUTO_INCREMENT,
  `article_id` INT NOT NULL,
  `language_code` VARCHAR(2) NOT NULL,
  `article_title` VARCHAR(255) NULL,
  `article_meta_keywords` VARCHAR(255) NULL,
  `article_meta_description` VARCHAR(255) NULL,
  `article_content` TEXT NULL,
  PRIMARY KEY (`translation_id`),
  INDEX `fk_article_translations_languages1_idx` (`language_code` ASC),
  INDEX `fk_article_translations_articles1_idx` (`article_id` ASC),
  CONSTRAINT `fk_article_translations_languages1`
    FOREIGN KEY (`language_code`)
    REFERENCES `xtend_languages` (`language_code`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_article_translations_articles1`
    FOREIGN KEY (`article_id`)
    REFERENCES `xtend_articles` (`article_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `articles_categories`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_articles_categories` (
  `category_id` INT NOT NULL AUTO_INCREMENT,
  `parent_id` INT NOT NULL DEFAULT 0,
  `category_status` TINYINT NOT NULL DEFAULT 0,
  PRIMARY KEY (`category_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `articles_category_translations`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_articles_category_translations` (
  `translation_id` INT NOT NULL AUTO_INCREMENT,
  `category_id` INT NOT NULL,
  `language_code` VARCHAR(2) NOT NULL,
  `category_name` VARCHAR(255) NULL,
  `category_meta_keywords` VARCHAR(255) NULL,
  `category_meta_description` VARCHAR(255) NULL,
  PRIMARY KEY (`translation_id`),
  INDEX `fk_articles_category_translations_languages1_idx` (`language_code` ASC),
  INDEX `fk_articles_category_translations_articles_categories1_idx` (`category_id` ASC),
  CONSTRAINT `fk_articles_category_translations_languages1`
    FOREIGN KEY (`language_code`)
    REFERENCES `xtend_languages` (`language_code`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_articles_category_translations_articles_categories1`
    FOREIGN KEY (`category_id`)
    REFERENCES `xtend_articles_categories` (`category_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `pages`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_pages` (
  `page_id` INT NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`page_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `page_translations`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_page_translations` (
  `translation_id` INT NOT NULL AUTO_INCREMENT,
  `page_id` INT NOT NULL,
  `language_code` VARCHAR(2) NOT NULL,
  `page_title` VARCHAR(255) NULL,
  `page_meta_keywords` VARCHAR(255) NULL,
  `page_meta_description` VARCHAR(255) NULL,
  `page_content` TEXT NULL,
  `page_slug` VARCHAR(255) NULL,
  PRIMARY KEY (`translation_id`),
  INDEX `fk_page_translations_pages1_idx` (`page_id` ASC),
  INDEX `fk_page_translations_languages1_idx` (`language_code` ASC),
  CONSTRAINT `fk_page_translations_pages1`
    FOREIGN KEY (`page_id`)
    REFERENCES `xtend_pages` (`page_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_page_translations_languages1`
    FOREIGN KEY (`language_code`)
    REFERENCES `xtend_languages` (`language_code`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `category_articles`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_category_articles` (
  `article_id` INT NOT NULL,
  `category_id` INT NOT NULL,
  PRIMARY KEY (`article_id`, `category_id`),
  INDEX `fk_articles_has_articles_categories_articles_categories1_idx` (`category_id` ASC),
  INDEX `fk_articles_has_articles_categories_articles1_idx` (`article_id` ASC),
  CONSTRAINT `fk_articles_has_articles_categories_articles1`
    FOREIGN KEY (`article_id`)
    REFERENCES `xtend_articles` (`article_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_articles_has_articles_categories_articles_categories1`
    FOREIGN KEY (`category_id`)
    REFERENCES `xtend_articles_categories` (`category_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `mixes`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_mixes` (
  `mix_id` INT NOT NULL AUTO_INCREMENT,
  `cover` VARCHAR(255) NULL,
  `author` VARCHAR(255) NULL,
  `tracklist` TEXT NULL,
  `download_url` VARCHAR(255) NULL,
  `zippy_www` VARCHAR(45) NULL,
  `zippy_file` VARCHAR(45) NULL,
  `date_added` DATETIME NULL,
  `mix_status` TINYINT NULL,
  PRIMARY KEY (`mix_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `mix_translations`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_mix_translations` (
  `translation_id` INT NOT NULL AUTO_INCREMENT,
  `mix_id` INT NOT NULL,
  `language_code` VARCHAR(2) NOT NULL,
  `mix_title` VARCHAR(255) NULL,
  `mix_meta_keywords` VARCHAR(255) NULL,
  `mix_meta_description` VARCHAR(255) NULL,
  `mix_description` TEXT NULL,
  PRIMARY KEY (`translation_id`),
  INDEX `fk_mix_translations_languages1_idx` (`language_code` ASC),
  INDEX `fk_mix_translations_mixes1_idx` (`mix_id` ASC),
  CONSTRAINT `fk_mix_translations_languages1`
    FOREIGN KEY (`language_code`)
    REFERENCES `xtend_languages` (`language_code`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_mix_translations_mixes1`
    FOREIGN KEY (`mix_id`)
    REFERENCES `xtend_mixes` (`mix_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `partners`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_partners` (
  `partner_id` INT NOT NULL AUTO_INCREMENT,
  `partner_name` VARCHAR(255) NULL,
  `partner_image` VARCHAR(255) NULL,
  `partner_url` VARCHAR(255) NULL,
  `partner_status` TINYINT NULL,
  PRIMARY KEY (`partner_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `countries`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_countries` (
  `country_id` INT NOT NULL AUTO_INCREMENT,
  `country_name` VARCHAR(255) NULL,
  `iso_code_2` VARCHAR(2) NULL,
  `iso_code_3` VARCHAR(3) NULL,
  `country_status` TINYINT NULL,
  PRIMARY KEY (`country_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


INSERT INTO `xtend_countries` (`country_id`, `country_name`, `iso_code_2`, `iso_code_3`, `country_status`) VALUES
(1, 'Afghanistan', 'AF', 'AFG', 1),
(2, 'Albania', 'AL', 'ALB', 1),
(3, 'Algeria', 'DZ', 'DZA', 1),
(4, 'American Samoa', 'AS', 'ASM', 1),
(5, 'Andorra', 'AD', 'AND', 1),
(6, 'Angola', 'AO', 'AGO', 1),
(7, 'Anguilla', 'AI', 'AIA', 1),
(8, 'Antarctica', 'AQ', 'ATA', 1),
(9, 'Antigua and Barbuda', 'AG', 'ATG', 1),
(10, 'Argentina', 'AR', 'ARG', 1),
(11, 'Armenia', 'AM', 'ARM', 1),
(12, 'Aruba', 'AW', 'ABW', 1),
(13, 'Australia', 'AU', 'AUS', 1),
(14, 'Austria', 'AT', 'AUT', 1),
(15, 'Azerbaijan', 'AZ', 'AZE', 1),
(16, 'Bahamas', 'BS', 'BHS', 1),
(17, 'Bahrain', 'BH', 'BHR', 1),
(18, 'Bangladesh', 'BD', 'BGD', 1),
(19, 'Barbados', 'BB', 'BRB', 1),
(20, 'Belarus', 'BY', 'BLR', 1),
(21, 'Belgium', 'BE', 'BEL', 1),
(22, 'Belize', 'BZ', 'BLZ', 1),
(23, 'Benin', 'BJ', 'BEN', 1),
(24, 'Bermuda', 'BM', 'BMU', 1),
(25, 'Bhutan', 'BT', 'BTN', 1),
(26, 'Bolivia', 'BO', 'BOL', 1),
(27, 'Bosnia and Herzegowina', 'BA', 'BIH', 1),
(28, 'Botswana', 'BW', 'BWA', 1),
(29, 'Bouvet Island', 'BV', 'BVT', 1),
(30, 'Brazil', 'BR', 'BRA', 1),
(31, 'British Indian Ocean Territory', 'IO', 'IOT', 1),
(32, 'Brunei Darussalam', 'BN', 'BRN', 1),
(33, 'Bulgaria', 'BG', 'BGR', 1),
(34, 'Burkina Faso', 'BF', 'BFA', 1),
(35, 'Burundi', 'BI', 'BDI', 1),
(36, 'Cambodia', 'KH', 'KHM', 1),
(37, 'Cameroon', 'CM', 'CMR', 1),
(38, 'Canada', 'CA', 'CAN', 1),
(39, 'Cape Verde', 'CV', 'CPV', 1),
(40, 'Cayman Islands', 'KY', 'CYM', 1),
(41, 'Central African Republic', 'CF', 'CAF', 1),
(42, 'Chad', 'TD', 'TCD', 1),
(43, 'Chile', 'CL', 'CHL', 1),
(44, 'China', 'CN', 'CHN', 1),
(45, 'Christmas Island', 'CX', 'CXR', 1),
(46, 'Cocos (Keeling) Islands', 'CC', 'CCK', 1),
(47, 'Colombia', 'CO', 'COL', 1),
(48, 'Comoros', 'KM', 'COM', 1),
(49, 'Congo', 'CG', 'COG', 1),
(50, 'Cook Islands', 'CK', 'COK', 1),
(51, 'Costa Rica', 'CR', 'CRI', 1),
(52, 'Cote D''Ivoire', 'CI', 'CIV', 1),
(53, 'Croatia', 'HR', 'HRV', 1),
(54, 'Cuba', 'CU', 'CUB', 1),
(55, 'Cyprus', 'CY', 'CYP', 1),
(56, 'Czech Republic', 'CZ', 'CZE', 1),
(57, 'Denmark', 'DK', 'DNK', 1),
(58, 'Djibouti', 'DJ', 'DJI', 1),
(59, 'Dominica', 'DM', 'DMA', 1),
(60, 'Dominican Republic', 'DO', 'DOM', 1),
(61, 'East Timor', 'TP', 'TMP', 1),
(62, 'Ecuador', 'EC', 'ECU', 1),
(63, 'Egypt', 'EG', 'EGY', 1),
(64, 'El Salvador', 'SV', 'SLV', 1),
(65, 'Equatorial Guinea', 'GQ', 'GNQ', 1),
(66, 'Eritrea', 'ER', 'ERI', 1),
(67, 'Estonia', 'EE', 'EST', 1),
(68, 'Ethiopia', 'ET', 'ETH', 1),
(69, 'Falkland Islands (Malvinas)', 'FK', 'FLK', 1),
(70, 'Faroe Islands', 'FO', 'FRO', 1),
(71, 'Fiji', 'FJ', 'FJI', 1),
(72, 'Finland', 'FI', 'FIN', 1),
(73, 'France', 'FR', 'FRA', 1),
(74, 'France, Metropolitan', 'FX', 'FXX', 1),
(75, 'French Guiana', 'GF', 'GUF', 1),
(76, 'French Polynesia', 'PF', 'PYF', 1),
(77, 'French Southern Territories', 'TF', 'ATF', 1),
(78, 'Gabon', 'GA', 'GAB', 1),
(79, 'Gambia', 'GM', 'GMB', 1),
(80, 'Georgia', 'GE', 'GEO', 1),
(81, 'Germany', 'DE', 'DEU', 1),
(82, 'Ghana', 'GH', 'GHA', 1),
(83, 'Gibraltar', 'GI', 'GIB', 1),
(84, 'Greece', 'GR', 'GRC', 1),
(85, 'Greenland', 'GL', 'GRL', 1),
(86, 'Grenada', 'GD', 'GRD', 1),
(87, 'Guadeloupe', 'GP', 'GLP', 1),
(88, 'Guam', 'GU', 'GUM', 1),
(89, 'Guatemala', 'GT', 'GTM', 1),
(90, 'Guinea', 'GN', 'GIN', 1),
(91, 'Guinea-bissau', 'GW', 'GNB', 1),
(92, 'Guyana', 'GY', 'GUY', 1),
(93, 'Haiti', 'HT', 'HTI', 1),
(94, 'Heard and Mc Donald Islands', 'HM', 'HMD', 1),
(95, 'Honduras', 'HN', 'HND', 1),
(96, 'Hong Kong', 'HK', 'HKG', 1),
(97, 'Hungary', 'HU', 'HUN', 1),
(98, 'Iceland', 'IS', 'ISL', 1),
(99, 'India', 'IN', 'IND', 1),
(100, 'Indonesia', 'ID', 'IDN', 1),
(101, 'Iran (Islamic Republic of)', 'IR', 'IRN', 1),
(102, 'Iraq', 'IQ', 'IRQ', 1),
(103, 'Ireland', 'IE', 'IRL', 1),
(104, 'Israel', 'IL', 'ISR', 1),
(105, 'Italy', 'IT', 'ITA', 1),
(106, 'Jamaica', 'JM', 'JAM', 1),
(107, 'Japan', 'JP', 'JPN', 1),
(108, 'Jordan', 'JO', 'JOR', 1),
(109, 'Kazakhstan', 'KZ', 'KAZ', 1),
(110, 'Kenya', 'KE', 'KEN', 1),
(111, 'Kiribati', 'KI', 'KIR', 1),
(112, 'North Korea', 'KP', 'PRK', 1),
(113, 'Korea, Republic of', 'KR', 'KOR', 1),
(114, 'Kuwait', 'KW', 'KWT', 1),
(115, 'Kyrgyzstan', 'KG', 'KGZ', 1),
(116, 'Laos', 'LA', 'LAO', 1),
(117, 'Latvia', 'LV', 'LVA', 1),
(118, 'Lebanon', 'LB', 'LBN', 1),
(119, 'Lesotho', 'LS', 'LSO', 1),
(120, 'Liberia', 'LR', 'LBR', 1),
(121, 'Libyan Arab Jamahiriya', 'LY', 'LBY', 1),
(122, 'Liechtenstein', 'LI', 'LIE', 1),
(123, 'Lithuania', 'LT', 'LTU', 1),
(124, 'Luxembourg', 'LU', 'LUX', 1),
(125, 'Macau', 'MO', 'MAC', 1),
(126, 'Macedonia', 'MK', 'MKD', 1),
(127, 'Madagascar', 'MG', 'MDG', 1),
(128, 'Malawi', 'MW', 'MWI', 1),
(129, 'Malaysia', 'MY', 'MYS', 1),
(130, 'Maldives', 'MV', 'MDV', 1),
(131, 'Mali', 'ML', 'MLI', 1),
(132, 'Malta', 'MT', 'MLT', 1),
(133, 'Marshall Islands', 'MH', 'MHL', 1),
(134, 'Martinique', 'MQ', 'MTQ', 1),
(135, 'Mauritania', 'MR', 'MRT', 1),
(136, 'Mauritius', 'MU', 'MUS', 1),
(137, 'Mayotte', 'YT', 'MYT', 1),
(138, 'Mexico', 'MX', 'MEX', 1),
(139, 'Micronesia, Federated States of', 'FM', 'FSM', 1),
(140, 'Moldova, Republic of', 'MD', 'MDA', 1),
(141, 'Monaco', 'MC', 'MCO', 1),
(142, 'Mongolia', 'MN', 'MNG', 1),
(143, 'Montserrat', 'MS', 'MSR', 1),
(144, 'Morocco', 'MA', 'MAR', 1),
(145, 'Mozambique', 'MZ', 'MOZ', 1),
(146, 'Myanmar', 'MM', 'MMR', 1),
(147, 'Namibia', 'NA', 'NAM', 1),
(148, 'Nauru', 'NR', 'NRU', 1),
(149, 'Nepal', 'NP', 'NPL', 1),
(150, 'Netherlands', 'NL', 'NLD', 1),
(151, 'Netherlands Antilles', 'AN', 'ANT', 1),
(152, 'New Caledonia', 'NC', 'NCL', 1),
(153, 'New Zealand', 'NZ', 'NZL', 1),
(154, 'Nicaragua', 'NI', 'NIC', 1),
(155, 'Niger', 'NE', 'NER', 1),
(156, 'Nigeria', 'NG', 'NGA', 1),
(157, 'Niue', 'NU', 'NIU', 1),
(158, 'Norfolk Island', 'NF', 'NFK', 1),
(159, 'Northern Mariana Islands', 'MP', 'MNP', 1),
(160, 'Norway', 'NO', 'NOR', 1),
(161, 'Oman', 'OM', 'OMN', 1),
(162, 'Pakistan', 'PK', 'PAK', 1),
(163, 'Palau', 'PW', 'PLW', 1),
(164, 'Panama', 'PA', 'PAN', 1),
(165, 'Papua New Guinea', 'PG', 'PNG', 1),
(166, 'Paraguay', 'PY', 'PRY', 1),
(167, 'Peru', 'PE', 'PER', 1),
(168, 'Philippines', 'PH', 'PHL', 1),
(169, 'Pitcairn', 'PN', 'PCN', 1),
(170, 'Poland', 'PL', 'POL', 1),
(171, 'Portugal', 'PT', 'PRT', 1),
(172, 'Puerto Rico', 'PR', 'PRI', 1),
(173, 'Qatar', 'QA', 'QAT', 1),
(174, 'Reunion', 'RE', 'REU', 1),
(175, 'Romania', 'RO', 'ROM', 1),
(176, 'Russian Federation', 'RU', 'RUS', 1),
(177, 'Rwanda', 'RW', 'RWA', 1),
(178, 'Saint Kitts and Nevis', 'KN', 'KNA', 1),
(179, 'Saint Lucia', 'LC', 'LCA', 1),
(180, 'Saint Vincent and the Grenadines', 'VC', 'VCT', 1),
(181, 'Samoa', 'WS', 'WSM', 1),
(182, 'San Marino', 'SM', 'SMR', 1),
(183, 'Sao Tome and Principe', 'ST', 'STP', 1),
(184, 'Saudi Arabia', 'SA', 'SAU', 1),
(185, 'Senegal', 'SN', 'SEN', 1),
(186, 'Seychelles', 'SC', 'SYC', 1),
(187, 'Sierra Leone', 'SL', 'SLE', 1),
(188, 'Singapore', 'SG', 'SGP', 1),
(189, 'Slovakia (Slovak Republic)', 'SK', 'SVK', 1),
(190, 'Slovenia', 'SI', 'SVN', 1),
(191, 'Solomon Islands', 'SB', 'SLB', 1),
(192, 'Somalia', 'SO', 'SOM', 1),
(193, 'South Africa', 'ZA', 'ZAF', 1),
(194, 'South Georgia and South Sandwich Islands', 'GS', 'SGS', 1),
(195, 'Spain', 'ES', 'ESP', 1),
(196, 'Sri Lanka', 'LK', 'LKA', 1),
(197, 'St. Helena', 'SH', 'SHN', 1),
(198, 'St. Pierre and Miquelon', 'PM', 'SPM', 1),
(199, 'Sudan', 'SD', 'SDN', 1),
(200, 'Suriname', 'SR', 'SUR', 1),
(201, 'Svalbard and Jan Mayen Islands', 'SJ', 'SJM', 1),
(202, 'Swaziland', 'SZ', 'SWZ', 1),
(203, 'Sweden', 'SE', 'SWE', 1),
(204, 'Switzerland', 'CH', 'CHE', 1),
(205, 'Syrian Arab Republic', 'SY', 'SYR', 1),
(206, 'Taiwan', 'TW', 'TWN', 1),
(207, 'Tajikistan', 'TJ', 'TJK', 1),
(208, 'Tanzania, United Republic of', 'TZ', 'TZA', 1),
(209, 'Thailand', 'TH', 'THA', 1),
(210, 'Togo', 'TG', 'TGO', 1),
(211, 'Tokelau', 'TK', 'TKL', 1),
(212, 'Tonga', 'TO', 'TON', 1),
(213, 'Trinidad and Tobago', 'TT', 'TTO', 1),
(214, 'Tunisia', 'TN', 'TUN', 1),
(215, 'Turkey', 'TR', 'TUR', 1),
(216, 'Turkmenistan', 'TM', 'TKM', 1),
(217, 'Turks and Caicos Islands', 'TC', 'TCA', 1),
(218, 'Tuvalu', 'TV', 'TUV', 1),
(219, 'Uganda', 'UG', 'UGA', 1),
(220, 'Ukraine', 'UA', 'UKR', 1),
(221, 'United Arab Emirates', 'AE', 'ARE', 1),
(222, 'United Kingdom', 'GB', 'GBR', 1),
(223, 'United States', 'US', 'USA', 1),
(224, 'United States Minor Outlying Islands', 'UM', 'UMI', 1),
(225, 'Uruguay', 'UY', 'URY', 1),
(226, 'Uzbekistan', 'UZ', 'UZB', 1),
(227, 'Vanuatu', 'VU', 'VUT', 1),
(228, 'Vatican City State (Holy See)', 'VA', 'VAT', 1),
(229, 'Venezuela', 'VE', 'VEN', 1),
(230, 'Viet Nam', 'VN', 'VNM', 1),
(231, 'Virgin Islands (British)', 'VG', 'VGB', 1),
(232, 'Virgin Islands (U.S.)', 'VI', 'VIR', 1),
(233, 'Wallis and Futuna Islands', 'WF', 'WLF', 1),
(234, 'Western Sahara', 'EH', 'ESH', 1),
(235, 'Yemen', 'YE', 'YEM', 1),
(236, 'Yugoslavia', 'YU', 'YUG', 1),
(237, 'Zaire', 'ZR', 'ZAR', 1),
(238, 'Zambia', 'ZM', 'ZMB', 1),
(239, 'Zimbabwe', 'ZW', 'ZWE', 1);



-- -----------------------------------------------------
-- Table `slides`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_slides` (
  `slide_id` INT NOT NULL AUTO_INCREMENT,
  `slide_image` VARCHAR(255) NULL,
  `slide_url` VARCHAR(255) NULL,
  `slide_status` TINYINT NULL,
  `target_blank` TINYINT NULL,
  `slide_order` SMALLINT NULL,
  PRIMARY KEY (`slide_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `slide_translations`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_slide_translations` (
  `translation_id` INT NOT NULL AUTO_INCREMENT,
  `slide_id` INT NOT NULL,
  `language_code` VARCHAR(2) NOT NULL,
  `slide_title` VARCHAR(255) NULL,
  `slide_info` VARCHAR(255) NULL,
  PRIMARY KEY (`translation_id`),
  INDEX `fk_slide_translations_slides1_idx` (`slide_id` ASC),
  INDEX `fk_slide_translations_languages1_idx` (`language_code` ASC),
  CONSTRAINT `fk_slide_translations_slides1`
    FOREIGN KEY (`slide_id`)
    REFERENCES `xtend_slides` (`slide_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_slide_translations_languages1`
    FOREIGN KEY (`language_code`)
    REFERENCES `xtend_languages` (`language_code`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `ads`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_ads` (
  `ad_id` INT NOT NULL AUTO_INCREMENT,
  `ad_content` TEXT NULL,
  PRIMARY KEY (`ad_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

-- -----------------------------------------------------
-- Table `events`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_events` (
  `event_id` INT NOT NULL AUTO_INCREMENT,
  `event_poster` VARCHAR(255) NULL,
  `event_guests` TEXT NULL,
  `event_date` DATETIME NULL,
  `event_location` VARCHAR(255) NULL,
  `ticket_price` VARCHAR(45) NULL,
  `event_status` TINYINT NULL,
  PRIMARY KEY (`event_id`))
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


-- -----------------------------------------------------
-- Table `event_translations`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `xtend_event_translations` (
  `translation_id` INT NOT NULL AUTO_INCREMENT,
  `event_id` INT NOT NULL,
  `language_code` VARCHAR(2) NOT NULL,
  `event_title` VARCHAR(255) NULL,
  `event_meta_keywords` VARCHAR(255) NULL,
  `event_meta_description` VARCHAR(255) NULL,
  `reservation_details` TEXT NULL,
  PRIMARY KEY (`translation_id`),
  INDEX `fk_event_translations_languages1_idx` (`language_code` ASC),
  INDEX `fk_event_translations_events1_idx` (`event_id` ASC),
  CONSTRAINT `fk_event_translations_languages1`
    FOREIGN KEY (`language_code`)
    REFERENCES `xtend_languages` (`language_code`)
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_event_translations_events1`
    FOREIGN KEY (`event_id`)
    REFERENCES `xtend_events` (`event_id`)
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;