<?php

//Include the common file
require_once 'common.php';

$meta = $db->fetchRowAssoc("SELECT * FROM " . cfg('base', 'table_pages') . " p, " . cfg('base', 'table_page_translations') . " t  WHERE p.page_id = 1 AND t.language_code = '" . $site_lang . "' AND p.page_id = t.page_id LIMIT 1");

$og_type ='website';
$og_image = cfg('base', 'site_url').'templates/assets/img/og_logo.png';
$og_video_url = '';
$og_video_type = '';
$og_video_width = '';
$og_video_height = '';

$tw_card = 'summary';
$tw_video_url = '';
$tw_video_width = '';
$tw_video_height= '';

//Random mix
$mix = $db->fetchRowAssoc("SELECT m.mix_id, m.cover, m.author, m.zippy_www, m.zippy_file, t.mix_title FROM " . cfg('base', 'table_mixes') . " m, " . cfg('base', 'table_mix_translations') . " t  WHERE m.mix_id = t.mix_id AND t.language_code = '" . $site_lang . "' AND mix_status = 1 ORDER BY RAND() LIMIT 1");

$sql = "SELECT a.article_id, a.article_image, a.article_video, a.article_source, a.date_added, t.article_title, t.article_content FROM " . cfg('base', 'table_articles') . " a, " . cfg('base', 'table_article_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND a.article_id = t.article_id AND a.article_status = 1 ORDER BY a.article_id DESC LIMIT 0, 5";

//Articles
$articles = array();

foreach ($db->query($sql) as $row) {

    $articles[] = array(
        'article_id'               => $row['article_id'],
        'article_title'               => $row['article_title'],
        'article_content'             => $row['article_content'],
        'article_image'               => $row['article_image'],
        'article_video'               => $row['article_video'],
        'article_source'           => $row['article_source'],
        'date_added'               => $row['date_added']
    );

}

$sql = "SELECT m.mix_id, m.cover, m.author, t.mix_title FROM " . cfg('base', 'table_mixes') . " m, " . cfg('base', 'table_mix_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND m.mix_id = t.mix_id AND m.mix_status =1 ORDER BY m.mix_id DESC LIMIT 0, 3";

//Mixes
$mixes = array();

foreach ($db->query($sql) as $row) {

    $mixes[] = array(
        'mix_id'                   => $row['mix_id'],
        'mix_title'               => $row['mix_title'],
        'cover'                       => $row['cover'],
        'author'                     => $row['author']
    );

}

$sql = "SELECT e.event_id, e.event_poster, t.event_title FROM " . cfg('base', 'table_events') . " e, " . cfg('base', 'table_event_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND e.event_id = t.event_id AND e.event_status = 1 ORDER BY e.event_id DESC LIMIT 0, 3";

//Events
$events = array();

foreach ($db->query($sql) as $row) {

    $events[] = array(
        'event_id'          => $row['event_id'],
        'event_poster'      => $row['event_poster'],
        'event_title'       => $row['event_title']
    );

}

//Navigation class
$current_home = 'class="current"';

//Template values
$tpl->set('title', $meta['page_title']);
$tpl->set('keywords', $meta['page_meta_keywords']);
$tpl->set('description', $meta['page_meta_description']);
$tpl->set('content', $meta['page_content']);
$tpl->set('og_type', $og_type);
$tpl->set('og_image', $og_image);
$tpl->set('og_video_url', $og_video_url);
$tpl->set('og_video_type', $og_video_type);
$tpl->set('og_video_width', $og_video_width);
$tpl->set('og_video_height', $og_video_height);

$tpl->set('tw_card', $tw_card);
$tpl->set('tw_video_url', $tw_video_url);
$tpl->set('tw_video_width', $tw_video_width);
$tpl->set('tw_video_height', $tw_video_height);

$tpl->set('mix', $mix);
$tpl->set('articles', $articles);
$tpl->set('mixes', $mixes);
$tpl->set('events', $events);

//Display navigation current class
$tpl->set('current_home', $current_home);

//Display the template
$tpl->display('index');
