<?php

//Include the common file
require_once 'common.php';

$meta = $db->fetchRowAssoc("SELECT * FROM " . cfg('base', 'table_pages') . " p, " . cfg('base', 'table_page_translations') . " t  WHERE p.page_id = 5 AND t.language_code = '" . $site_lang . "' AND p.page_id = t.page_id LIMIT 1");

$og_type ='website';
$og_image = cfg('base', 'site_url').'templates/assets/img/og_logo.png';
$og_video_url = '';
$og_video_type = '';
$og_video_width = '';
$og_video_height = '';

$tw_card = 'summary';
$tw_video_url = '';
$tw_video_width = '';
$tw_video_height= '';

//Returns the number of rows
$rowCount = $db->rowCount("SELECT event_id FROM " . cfg('base', 'table_events') . " WHERE event_status = 1");

//Pagination
if (isset($_GET['page']))
    $current_page = trim($_GET['page']);
else
    $current_page = 1;

$start = ($current_page -1 ) * 9;

$sql = "SELECT e.event_id, e.event_poster, t.event_title FROM " . cfg('base', 'table_events') . " e, " . cfg('base', 'table_event_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND e.event_id = t.event_id AND e.event_status = 1 ORDER BY e.event_id DESC";

$sql .= " LIMIT " . $start . ", 9";

$pages = ceil($db->rowCount("SELECT event_id FROM " . cfg('base', 'table_events') . " WHERE event_status = 1") / 9);

//Events
$events = array();

foreach ($db->query($sql) as $row) {

    $events[] = array(
        'event_id'          => $row['event_id'],
        'event_poster'      => $row['event_poster'],
        'event_title'       => $row['event_title']
    );

}

$sql = "SELECT m.mix_id, m.cover, m.author, t.mix_title FROM " . cfg('base', 'table_mixes') . " m, " . cfg('base', 'table_mix_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND m.mix_id = t.mix_id AND m.mix_status =1 ORDER BY m.mix_id DESC LIMIT 0, 3";

//Mixes
$mixes = array();

foreach ($db->query($sql) as $row) {

    $mixes[] = array(
        'mix_id'                   => $row['mix_id'],
        'mix_title'               => $row['mix_title'],
        'cover'                       => $row['cover'],
        'author'                     => $row['author']
    );

}

//Navigation class
$current_extra = 'class="current"';
$current_events = 'class="current"';

//Template values
$tpl->set('title', $meta['page_title']);
$tpl->set('keywords', $meta['page_meta_keywords']);
$tpl->set('description', $meta['page_meta_description']);
$tpl->set('content', $meta['page_content']);
$tpl->set('og_type', $og_type);
$tpl->set('og_image', $og_image);
$tpl->set('og_video_url', $og_video_url);
$tpl->set('og_video_type', $og_video_type);
$tpl->set('og_video_width', $og_video_width);
$tpl->set('og_video_height', $og_video_height);

$tpl->set('tw_card', $tw_card);
$tpl->set('tw_video_url', $tw_video_url);
$tpl->set('tw_video_width', $tw_video_width);
$tpl->set('tw_video_height', $tw_video_height);

$tpl->set('rowCount', $rowCount);
$tpl->set('current_page', $current_page);
$tpl->set('pages', $pages);
$tpl->set('events', $events);
$tpl->set('mixes', $mixes);

//Display navigation current class
$tpl->set('current_extra', $current_extra);
$tpl->set('current_events', $current_events);

//Display the template
$tpl->display('events');
