<?php

//Include the common file
require_once 'common.php';

$meta = $db->fetchRowAssoc("SELECT * FROM " . cfg('base', 'table_pages') . " p, " . cfg('base', 'table_page_translations') . " t  WHERE p.page_id = 6 AND t.language_code = '" . $site_lang . "' AND p.page_id = t.page_id LIMIT 1");

$og_type ='website';
$og_image = cfg('base', 'site_url').'templates/assets/img/og_logo.png';
$og_video_url = '';
$og_video_type = '';
$og_video_width = '';
$og_video_height = '';

$tw_card = 'summary';
$tw_video_url = '';
$tw_video_width = '';
$tw_video_height= '';

if (isset($_POST['submit_message'])) {

    if (!$_POST['honeypot'] && filter_var($_POST['email'], FILTER_VALIDATE_EMAIL)) {

        $message = file_get_contents(cfg('base','absolute_path') . 'mail/contact.tpl');

        $message = str_replace('%%SITE_TITLE%%', cfg('base', 'site_title'), $message);
        $message = str_replace('%%DATE%%', date('d-m-Y H:i:s', time()), $message);
        $message = str_replace('%%MESSAGE%%', filter_var($_POST['message'], FILTER_SANITIZE_STRING), $message);
        $message = str_replace('%%NAME%%', filter_var($_POST['name'], FILTER_SANITIZE_STRING), $message);

        $headers  = 'From: ' . cfg('base','site_title') . '<' . $_POST['email'] . '>' . "\r\n";
        $headers .= 'Reply-To: ' . $_POST['email'] . "\r\n";
        $headers .= 'X-Mailer: PHP/' . phpversion();
        $headers .= 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";

        mail(cfg('authentication', 'admin_email'), filter_var($_POST['subject'], FILTER_SANITIZE_STRING), $message, $headers);

        $session->set('success', true);

   }

}
//Navigation class
$current_contact = 'class="current"';

//Template values
$tpl->set('title', $meta['page_title']);
$tpl->set('keywords', $meta['page_meta_keywords']);
$tpl->set('description', $meta['page_meta_description']);
$tpl->set('content', $meta['page_content']);
$tpl->set('og_type', $og_type);
$tpl->set('og_image', $og_image);
$tpl->set('og_video_url', $og_video_url);
$tpl->set('og_video_type', $og_video_type);
$tpl->set('og_video_width', $og_video_width);
$tpl->set('og_video_height', $og_video_height);

$tpl->set('tw_card', $tw_card);
$tpl->set('tw_video_url', $tw_video_url);
$tpl->set('tw_video_width', $tw_video_width);
$tpl->set('tw_video_height', $tw_video_height);

//Display navigation current class
$tpl->set('current_contact', $current_contact);

//Display the template
$tpl->display('contact');
