<?php

//Include the common file
require_once 'common.php';

$og_type ='website';
$og_image = cfg('base', 'site_url').'templates/assets/img/og_logo.png';
$og_video_url = '';
$og_video_type = '';
$og_video_width = '';
$og_video_height = '';

$tw_card = 'summary';
$tw_video_url = '';
$tw_video_width = '';
$tw_video_height= '';

//Get category id coresponding to url form of category name
function category_id($category, $site_lang)
{
    global $db;

    foreach ($db->query("SELECT a.category_id, t.category_name FROM " . cfg('base', 'table_articles_categories') . " a, " . cfg('base', 'table_articles_category_translations') . " t WHERE a.category_id = t.category_id AND t.language_code = '" . $site_lang ."'") as $row) {
    if(url($category)==url($row['category_name']))
      $cat=$row['category_id'];
    }

    return $cat;
}
$meta = $db->fetchRowAssoc("SELECT c.category_id, t.category_name, t.category_meta_keywords, t.category_meta_description FROM " . cfg('base', 'table_articles_categories') . " c, " . cfg('base', 'table_articles_category_translations') . " t WHERE c.category_id = t.category_id AND c.category_id ='" . category_id($_GET['category'],$site_lang) . "' AND t.language_code = '" . $site_lang ."'");

//Categories
function categories($parent_id,$language)
{
    global $db;

    $categories = array();
    foreach ($db->query("SELECT c.category_id, c.category_status, t.category_name FROM " . cfg('base', 'table_articles_categories') . " c, " . cfg('base', 'table_articles_category_translations') . " t WHERE c.category_id = t.category_id AND t.language_code = '" . $language ."' AND c.parent_id = '" . $parent_id . "' ORDER BY c.category_id ASC") as $value) {

        $categories[] = array(
            'category_id'        => $value['category_id'],
            'category_status'    => $value['category_status'],
            'category_name'        => get_path($value['category_id'],$language)
        );

        $categories = array_merge($categories, categories($value['category_id'],$language));

    }

    return $categories;
}

function get_path($category_id,$language)
{
    global $db;

    $result = $db->fetchRowAssoc("SELECT c.category_id, c.parent_id, t.category_name FROM " . cfg('base', 'table_articles_categories') . " c, " . cfg('base', 'table_articles_category_translations') . " t WHERE c.category_id = t.category_id AND t.language_code = '" . $language ."' AND c.category_id = '" . $category_id . "' ORDER BY c.category_id ASC");

    if ($result['parent_id'])
        return get_path($result['parent_id'],$language) .' > '. $result['category_name'];
    else
        return $result['category_name'];

}

//Pagination
if (isset($_GET['page']))
    $current_page = trim($_GET['page']);
else
    $current_page = 1;

$start = ($current_page -1 ) * cfg('base', 'per_page_catalog');

$sql = "SELECT a.article_id, a.article_image, a.article_video, a.article_source, a.date_added, t.article_title, t.article_content FROM " . cfg('base', 'table_articles') . " a, " . cfg('base', 'table_category_articles') . " ca, " . cfg('base', 'table_article_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND a.article_status = 1 AND a.article_id = t.article_id AND a.article_id = ca.article_id AND ca.category_id = '" . $meta['category_id'] . "'";

$sql .= " ORDER BY a.article_id DESC LIMIT " . $start . ", " . cfg('base', 'per_page_catalog') . "";

$pages = ceil($db->rowCount("SELECT ca.article_id FROM " . cfg('base', 'table_category_articles') . " ca, ". cfg('base', 'table_articles') . " a WHERE ca.category_id = '" . $meta['category_id'] . "' AND ca.article_id = a.article_id AND a.article_status = 1") / cfg('base', 'per_page_catalog'));

//articles
$articles = array();

foreach ($db->query($sql) as $row) {

    $articles[] = array(
        'article_id'            => $row['article_id'],
        'article_title'            => $row['article_title'],
        'article_meta_keywords'    => $row['article_meta_keywords'],
        'article_meta_description' => $row['article_meta_description'],
        'article_content'          => $row['article_content'],
        'article_image'            => $row['article_image'],
        'article_video'            => $row['article_video'],
        'article_source'        => $row['article_source'],
        'date_added'            => $row['date_added']
    );

}

$sql = "SELECT m.mix_id, m.cover, m.author, t.mix_title FROM " . cfg('base', 'table_mixes') . " m, " . cfg('base', 'table_mix_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND m.mix_id = t.mix_id AND m.mix_status =1 ORDER BY m.mix_id DESC LIMIT 0, 3";

//Mixes
$mixes = array();

foreach ($db->query($sql) as $row) {

    $mixes[] = array(
        'mix_id'                   => $row['mix_id'],
        'mix_title'               => $row['mix_title'],
        'cover'                       => $row['cover'],
        'author'                     => $row['author']
    );

}

//Navigation class
$current_blog = 'class="current"';

//Template values
$tpl->set('title', $meta['category_name']);
$tpl->set('keywords', $meta['category_meta_keywords']);
$tpl->set('description', $meta['category_meta_description']);

$tpl->set('og_type', $og_type);
$tpl->set('og_image', $og_image);
$tpl->set('og_video_url', $og_video_url);
$tpl->set('og_video_type', $og_video_type);
$tpl->set('og_video_width', $og_video_width);
$tpl->set('og_video_height', $og_video_height);

$tpl->set('tw_card', $tw_card);
$tpl->set('tw_video_url', $tw_video_url);
$tpl->set('tw_video_width', $tw_video_width);
$tpl->set('tw_video_height', $tw_video_height);

$tpl->set('rowCount', $rowCount);
$tpl->set('current_page', $current_page);
$tpl->set('pages', $pages);
$tpl->set('articles', $articles);
$tpl->set('mixes', $mixes);

//Display navigation current class
$tpl->set('current_blog', $current_blog);

//Display the template
$tpl->display('blog-category');
