<?php

//Include the common file
require_once 'common.php';

$art = $db->fetchRowAssoc("SELECT * FROM " . cfg('base', 'table_articles') . " a, " . cfg('base', 'table_article_translations') . " t WHERE a.article_id = '" . $_GET['id'] . "' AND t.language_code = '" . $site_lang ."' AND a.article_id = t.article_id");

 if ($art['article_video']) {
        $og_type = 'video';
        $og_image = 'http://img.youtube.com/vi/'.$art['article_video'].'/hqdefault.jpg';
        $og_video_url = '<meta property="og:video" content="https://www.youtube.com/v/'.$art['article_video'].'" />';
        $og_video_type = '<meta property="og:video:type" content="application/x-shockwave-flash" />';
        $og_video_width = '<meta property="og:video:width" content="635" />';
        $og_video_height = '<meta property="og:video:height" content="360" />';

        $tw_card = 'player';
        $tw_video_url = '<meta name="twitter:player" content="https://www.youtube.com/embed/'.$art['article_video'].'">';
        $tw_video_width = '<meta name="twitter:player:width" content="635">';
        $tw_video_height= '<meta name="twitter:player:height" content="360">';
    } elseif ($art['article_image']) {
        $og_type = 'article';
        $og_image = cfg('base', 'site_url').'uploads/images/'.$art['article_image'];
        $og_video_url = '';
        $og_video_type = '';
        $og_video_width = '';
        $og_video_height = '';

        $tw_card = 'article';
        $tw_video_url = '';
        $tw_video_width = '';
        $tw_video_height= '';
    } else {
        $og_type = 'article';
        $og_image = cfg('base', 'site_url').'templates/img/og_logo.png';
        $og_video_url = '';
        $og_video_type = '';
        $og_video_width = '';
        $og_video_height = '';

        $tw_card = 'article';
        $tw_video_url = '';
        $tw_video_width = '';
        $tw_video_height= '';
   }

//Categories
function categories($parent_id,$language)
{
    global $db;

    $categories = array();
    foreach ($db->query("SELECT c.category_id, c.category_status, t.category_name FROM " . cfg('base', 'table_articles_categories') . " c, " . cfg('base', 'table_articles_category_translations') . " t WHERE c.category_id = t.category_id AND t.language_code = '" . $language ."' AND c.parent_id = '" . $parent_id . "' ORDER BY c.category_id ASC") as $value) {

        $categories[] = array(
            'category_id'        => $value['category_id'],
            'category_status'    => $value['category_status'],
            'category_name'        => get_path($value['category_id'],$language)
        );

        $categories = array_merge($categories, categories($value['category_id'],$language));

    }

    return $categories;
}

function get_path($category_id,$language)
{
    global $db;

    $result = $db->fetchRowAssoc("SELECT c.category_id, c.parent_id, t.category_name FROM " . cfg('base', 'table_articles_categories') . " c, " . cfg('base', 'table_articles_category_translations') . " t WHERE c.category_id = t.category_id AND t.language_code = '" . $language ."' AND c.category_id = '" . $category_id . "' ORDER BY c.category_id ASC");

    if ($result['parent_id'])
        return get_path($result['parent_id'],$language) .' > '. $result['category_name'];
    else
        return $result['category_name'];

}

$sql = "SELECT m.mix_id, m.cover, m.author, t.mix_title FROM " . cfg('base', 'table_mixes') . " m, " . cfg('base', 'table_mix_translations') . " t WHERE t.language_code = '" . $site_lang . "' AND m.mix_id = t.mix_id AND m.mix_status =1 ORDER BY m.mix_id DESC LIMIT 0, 3";

//Mixes
$mixes = array();

foreach ($db->query($sql) as $row) {

    $mixes[] = array(
        'mix_id'                   => $row['mix_id'],
        'mix_title'               => $row['mix_title'],
        'cover'                       => $row['cover'],
        'author'                     => $row['author']
    );

}

//Navigation class
$current_blog = 'class="current"';

//Template values
$tpl->set('title', $art['article_title']);
$tpl->set('keywords', $art['article_meta_keywords']);
$tpl->set('description', $art['article_meta_description']);

$tpl->set('og_type', $og_type);
$tpl->set('og_image', $og_image);
$tpl->set('og_video_url', $og_video_url);
$tpl->set('og_video_type', $og_video_type);
$tpl->set('og_video_width', $og_video_width);
$tpl->set('og_video_height', $og_video_height);

$tpl->set('tw_card', $tw_card);
$tpl->set('tw_video_url', $tw_video_url);
$tpl->set('tw_video_width', $tw_video_width);
$tpl->set('tw_video_height', $tw_video_height);

$tpl->set('art', $art);
$tpl->set('mixes', $mixes);

//Display navigation current class
$tpl->set('current_blog', $current_blog);

//Display the template
$tpl->display('article');
