<?php

//Include the common file
require '../common.php';

//Check if the user is logged in
if (!$authentication->loggedIn() || !$authentication->isAdmin()) header("Location: login.php");

//Check if the form has been submitted
if (isset($_POST['submit'])) {

    $validate->required($_POST['site_title'], 'Site title required.');
    $validate->required($_POST['site_url'], 'Site URL required.');
    $validate->required($_POST['map_latitude'], 'Map latitude required.');
    $validate->required($_POST['map_longitude'], 'Map longitude required.');
    $validate->email($_POST['admin_email'], 'Email address admin not valid.');

    $validate->numeric($_POST['per_page_catalog'], 'Catalog items limit required.');
    $validate->numeric($_POST['per_page_admin'], 'Admin items limit required.');

    $validate->numeric($_POST['max_filesize'], 'Maximum upload size is required.');
    $validate->numeric($_POST['max_width_thumbnail'], 'Image thumbnail size dimensions required.');
    $validate->numeric($_POST['max_height_thumbnail'], 'Image thumbnail size dimensions required.');
    $validate->numeric($_POST['max_width'], 'Image size dimensions required.');
    $validate->numeric($_POST['max_height'], 'Image size size dimensions required.');

    if (!$error->hasErrors()) {

        save_config($_POST);

        $tpl->set('success', true);
        header("Location: settings.php");
    }

}

//Navigation class
$current_settings = 'class="active"';

//Template values
$tpl->set('current_settings', $current_settings);

//Display the template
$tpl->display('admin/settings');
