<?php
//Include the common file
require '../common.php';

//Check if the user is logged in
if (!$authentication->loggedIn() || !$authentication->isAdmin()) header("Location: login.php");

//Check if the form has been submitted
if (isset($_POST['submit'])) {

    $validate->required($_POST['partner_name'], 'Enter partner name.');
    $validate->required($_POST['partner_url'], 'Enter partner url.');

    if (!empty($_FILES['image']['name'])) {

        $image = $upload->uploadImage('image',url($_POST['partner_name']), 200, 200);

    }

    if (!$error->hasErrors()) {

        $values = array(
            'partner_name'     => $_POST['partner_name'],
            'partner_url'      => $_POST['partner_url'],
            'partner_status'   => $_POST['partner_status']

        );

        if (isset($image)) {

            $values['partner_image'] = $image;

        }

        $db->insert(cfg('base', 'table_partners'), $values);

        $tpl->set('success', true);
        header("Location: partners.php");
    }

}

//Navigation class
$current_partners = 'class="active"';

//Template values
$tpl->set('current_partners', $current_partners);

//Display the template
$tpl->display('admin/add_partner');
