<?php

//Include the common file
require '../common.php';

//Check if the user is logged in
if (!$authentication->loggedIn() || !$authentication->isAdmin()) header("Location: login.php");

//Check if the form has been submitted
if (isset($_POST['submit'])) {

    foreach ($languages as $row) {
     $validate->required($_POST['mix_title'.'_'.$row['language_code']], 'Enter mix title ('.$row['language_code'].').');
    }

    if (!empty($_FILES['image']['name'])) {

        $image = $upload->uploadImage('image',url($_POST['mix_title'.'_'.cfg('language','site_language')]), 197, 168, true, true);
    }

    if (!$error->hasErrors()) {

        $values = array(
            'author'               => $_POST['author'],
            'tracklist'               => $_POST['tracklist'],
            'download_url'         => $_POST['download_url'],
            'zippy_www'            => $_POST['zippy_www'],
            'zippy_file'           => $_POST['zippy_file'],
            'date_added'           => date('Y-m-d H:i:s'),
            'mix_status'           => $_POST['mix_status']
        );

        if (isset($image)) {

            $values['cover'] = $image;

        }

        $db->insert(cfg('base', 'table_mixes'), $values);

        $mix_id = $db->lastInsertId();

        foreach ($languages as $row) {
            $values = array(
                'mix_id'                 => $mix_id,
                'language_code'          => $row['language_code'],
                'mix_title'             => $_POST['mix_title'.'_'.$row['language_code']],
                'mix_meta_keywords'      => $_POST['mix_meta_keywords'.'_'.$row['language_code']],
                'mix_meta_description'   => $_POST['mix_meta_description'.'_'.$row['language_code']],
                'mix_description'         => $_POST['mix_description'.'_'.$row['language_code']]
            );
            $db->insert(cfg('base', 'table_mix_translations'), $values);
        }

        $tpl->set('success', true);
        header('Location: mixes.php');

    }

}

//Navigation class
$current_mixes = 'class="active"';

//Template values
$tpl->set('current_mixes', $current_mixes);

//Display the template
$tpl->display('admin/add_mix');
