<?php
//Include the common file
require '../common.php';

//Check if the user is logged in
if (!$authentication->loggedIn() || !$authentication->isAdmin()) header("Location: login.php");

//Check if the form has been submitted
if (isset($_POST['submit'])) {

    foreach ($languages as $row) {
     $validate->required($_POST['event_title'.'_'.$row['language_code']], 'Enter event title ('.$row['language_code'].').');
    }

    if (!empty($_FILES['image']['name'])) {

        $image = $upload->uploadImage('image',url($_POST['event_title'.'_'.cfg('language','site_language')]), 698, 910, true, true);
    }

    if (!$error->hasErrors()) {

        $values = array(
            'event_guests'           => $_POST['event_guests'],
            'event_date'             => $_POST['event_date'],
            'event_location'         => $_POST['event_location'],
            'ticket_price'           => $_POST['ticket_price'],
            'event_status'           => $_POST['event_status']
        );

        if (isset($image)) {

            $values['event_poster'] = $image;

        }

        $db->insert(cfg('base', 'table_events'), $values);

        $event_id = $db->lastInsertId();

        foreach ($languages as $row) {
            $values = array(
                'event_id'                 => $event_id,
                'language_code'          => $row['language_code'],
                'event_title'             => $_POST['event_title'.'_'.$row['language_code']],
                'event_meta_keywords'    => $_POST['event_meta_keywords'.'_'.$row['language_code']],
                'event_meta_description' => $_POST['event_meta_description'.'_'.$row['language_code']],
                'reservation_details'     => $_POST['reservation_details'.'_'.$row['language_code']]
            );
            $db->insert(cfg('base', 'table_event_translations'), $values);
        }

        $tpl->set('success', true);
        header('Location: events.php');

    }

}

//Navigation class
$current_events = 'class="active"';

//Template values
$tpl->set('current_events', $current_events);

//Display the template
$tpl->display('admin/add_event');
