<?php
if(function_exists('wc')) {

	class XT_Woo_Floating_Cart_AJAX extends WC_AJAX {
	
	    /**
	     - Hook in ajax handlers.
	     */
	    public static function init() {
	        add_action( 'init', array( __CLASS__, 'define_ajax' ), 0 );
	        add_action( 'template_redirect', array( __CLASS__, 'do_wc_ajax' ), 0 );
	        add_filter('woocommerce_add_to_cart_fragments', array( __CLASS__, 'add_to_cart_fragments' ), 1 );
	        self::add_ajax_events();
	    }
	
	    /**
	     - Add custom ajax events here
	     */
	    public static function add_ajax_events() {
	        // woocommerce_EVENT => nopriv
	        $ajax_events = array(
	            'xt_woofc_update_cart' => true,
	        );
	        foreach ( $ajax_events as $ajax_event => $nopriv ) {
	            add_action( 'wp_ajax_woocommerce_' . $ajax_event, array( __CLASS__, $ajax_event ) );
	            if ( $nopriv ) {
	                add_action( 'wp_ajax_nopriv_woocommerce_' . $ajax_event, array( __CLASS__, $ajax_event ) );
	                // WC AJAX can be used for frontend ajax requests
	                add_action( 'wc_ajax_' . $ajax_event, array( __CLASS__, $ajax_event ) );
	            }
	        }
	    }
	
		public static function add_to_cart_fragments($fragments) {

			$list = xt_woo_floating_cart_template('parts/cart/list', array(), true);
			$total = xt_woofc_checkout_total();
			$count = WC()->cart->get_cart_contents_count();

            ob_start();
            wc_print_notices();
            $notices = ob_get_clean();

            $fragments['xt_woofc'] = array(
				'subtotal' => $total,
				'total_items' => $count,
                'notices' => $notices
			);	
			
			if(empty($_COOKIE['xt_woofc_last_removed'])) {
                $fragments['.xt_woofc-list'] = $list;
			}

            $fragments['.xt_woofc-checkout span.amount'] = '<span class="amount">'.$total.'</span>';
            $fragments['.xt_woofc-count li:nth-child(1)'] = '<li>'.$count.'</li>';
            $fragments['.xt_woofc-count li:nth-child(2)'] = '<li>'.($count + 1).'</li>';

	        return $fragments;
	    }
	    
	    /**
	     - Removes item from the cart then returns a new fragment
	     */
	    public static function xt_woofc_update_cart() {
		   
			$type = filter_var($_POST['type'], FILTER_SANITIZE_STRING);
			
			$cart_item_key = null;
			
			if(!empty($_POST['cart_item_key'])) {
				$cart_item_key = filter_var($_POST['cart_item_key'], FILTER_SANITIZE_STRING);
			}
	
			if($type == 'update' && !empty($cart_item_key)) {
			
				$cart_item_qty = intval($_POST['cart_item_qty']);  
				WC()->cart->set_quantity($cart_item_key, $cart_item_qty, true); 
				
			}else if($type == 'single-add' || $type == 'add') {
				
				$cart_item_key = WC()->session->get( 'xt_woofc_last_added');

			}else if($type == 'remove' && !empty($cart_item_key)) {
				
				WC()->cart->remove_cart_item($cart_item_key); 
				
			}else if($type == 'undo' && !empty($cart_item_key)) {
	
				WC()->cart->restore_cart_item($cart_item_key);
				
			}

            WC()->cart->calculate_totals();

			WC_Ajax::get_refreshed_fragments();

	    }
	}
	
	$xt_woofc_ajax = new XT_Woo_Floating_Cart_AJAX();
	$xt_woofc_ajax->init();
}	