<?php
defined('_JEXEC') or die;
/**
 * Joomla! xCRUD Plugin
 */
class PlgSystemXcrud extends JPlugin
{
    protected $session;
    public function onAfterInitialise()
    {
        require_once (dirname(__file__) . '/xcrud/xcrud.php');
        $config = new JConfig;
        Xcrud_config::$dbname = $config->db;
        Xcrud_config::$dbuser = $config->user;
        Xcrud_config::$dbpass = $config->password;
        Xcrud_config::$dbhost = $config->host;
        Xcrud_config::$dbprefix = $config->dbprefix;
        Xcrud_config::$scripts_url = rtrim(JURI::root(), '/');
        Xcrud_config::$ajax_uri = '';
        Xcrud_config::$external_session = true;
        Xcrud_config::$load_jquery = false;
        Xcrud_config::$load_bootstrap = false;
        Xcrud_config::$editor_url = '';
        Xcrud_config::$plugins_uri = 'plugins/system/xcrud/xcrud/plugins';
        Xcrud_config::$themes_uri = 'plugins/system/xcrud/xcrud/themes';
        Xcrud_config::$lang_uri = 'plugins/system/xcrud/xcrud/languages';
        $this->session = JFactory::getSession();
        Xcrud::import_session($this->session->get('xcrud_sess'));
        if (JRequest::getVar('xcrud'))
        {
            $app = JFactory::getApplication();
            echo Xcrud::get_requested_instance();
            $this->session->set('xcrud_sess', Xcrud::export_session());
            $app->close();
        }
        $doc = JFactory::getDocument();
        $data = $doc->getHeadData();
        $data['custom'][] = Xcrud::load_css();
        $data['custom'][] = Xcrud::load_js();
        $doc->setHeadData($data);
    }

    public function onAfterRender()
    {
        $this->session->set('xcrud_sess', Xcrud::export_session());
    }
}
