SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DROP TABLE IF EXISTS `base_fields`;
CREATE TABLE IF NOT EXISTS `base_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` varchar(50) NOT NULL,
  `text_area` text NOT NULL,
  `text_editor` text NOT NULL,
  `integer` int(11) NOT NULL,
  `float` float(5,2) NOT NULL,
  `enum` enum('one','two','three') NOT NULL,
  `set` set('one','two','three') NOT NULL,
  `date` date NOT NULL,
  `datetime` datetime NOT NULL,
  `time` time NOT NULL,
  `bool` bit(1) NOT NULL,
  `point` point NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

INSERT INTO `base_fields` (`id`, `text`, `text_area`, `text_editor`, `integer`, `float`, `enum`, `set`, `date`, `datetime`, `time`, `bool`, `point`) VALUES
(1, 'Test test', 'Test test', '<p>Test test</p>', 0, 0.00, 'one', '', '0000-00-00', '0000-00-00 00:00:00', '02:00:00', b'0', '\0\0\0\0\0\0\0\Z[ AA@uu"va@'),
(3, 'Test', 'Test', '<p>Test</p>', 0, 0.00, 'two', 'two,three', '2013-09-28', '1970-01-01 00:00:00', '14:00:25', b'1', '\0\0\0\0\0\0\0JF\0Ks2@TP'),
(7, 'Test test test', 'Test test test', '<ol>\n<li><em><strong>asdasdasd asdad sad</strong></em></li>\n<li><em><strong>asdasdasd</strong></em></li>\n<li><em><strong>asd</strong></em></li>\n<li><em><strong>asd</strong></em></li>\n<li><em><strong>asd</strong></em></li>\n<li><em><strong>asd</strong></em></li>\n<li><em><strong>asd</strong></em></li>\n<li><em><strong>asdasdasd</strong></em></li>\n<li><em><strong>asd</strong></em></li>\n<li><em><strong>asd</strong></em></li>\n<li><em><strong>ad</strong></em></li>\n</ol>', 131313, 999.99, 'three', 'one,two,three', '2032-11-30', '2013-11-26 22:48:55', '11:56:41', b'1', '\0\0\0\0\0\0\0ǥAl\0F2@$ԔP'),
(9, 'Text', 'Text Area', '<p>Text Editor</p>', 0, 0.00, 'one', '', '0000-00-00', '0000-00-00 00:00:00', '02:00:00', b'0', '\0\0\0\0\0\0\0\Z[ AA@uu"va@'),
(12, 'ttt', '', '', 0, 0.00, 'one', 'three', '1970-01-01', '1970-01-01 02:00:00', '02:00:00', b'1', '\0\0\0\0\0\0\0\Z[ AA@uu"va@');

DROP TABLE IF EXISTS `consultation`;
CREATE TABLE IF NOT EXISTS `consultation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `office` varchar(50) NOT NULL,
  `manager` varchar(50) NOT NULL,
  `country` int(11) NOT NULL,
  `region` int(11) NOT NULL,
  `city` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;


DROP TABLE IF EXISTS `customers`;
CREATE TABLE IF NOT EXISTS `customers` (
  `customerNumber` int(11) NOT NULL AUTO_INCREMENT,
  `customerName` varchar(50) NOT NULL,
  `contactLastName` varchar(50) NOT NULL,
  `contactFirstName` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `addressLine1` varchar(50) NOT NULL,
  `addressLine2` varchar(50) DEFAULT NULL,
  `city` varchar(50) NOT NULL,
  `state` varchar(50) DEFAULT NULL,
  `postalCode` varchar(15) DEFAULT NULL,
  `country` varchar(50) CHARACTER SET utf8 COLLATE utf8_estonian_ci NOT NULL,
  `salesRepEmployeeNumber` int(11) DEFAULT NULL,
  `creditLimit` double DEFAULT NULL,
  `avatar` mediumblob NOT NULL,
  `photo` varchar(50) NOT NULL,
  `attach` varchar(255) NOT NULL,
  `sex` enum('male','female') NOT NULL,
  `interests` set('sports','programming','cars','girls','drinks','fights','history','cooking','shopping') NOT NULL,
  PRIMARY KEY (`customerNumber`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=497 ;

INSERT INTO `customers` (`customerNumber`, `customerName`, `contactLastName`, `contactFirstName`, `phone`, `addressLine1`, `addressLine2`, `city`, `state`, `postalCode`, `country`, `salesRepEmployeeNumber`, `creditLimit`, `avatar`, `photo`, `attach`, `sex`, `interests`) VALUES
(103, 'Atelier graphique', 'Schmitt', 'Carine ', '40.32.2555', '54, rue Royale', NULL, 'Nantes', NULL, '44000', 'France', 1370, 21000, '', '', '', 'male', ''),
(112, 'Signal Gift Stores', 'King', 'Jean', '7025551838', '8489 Strong St.', NULL, 'Las Vegas', 'NV', '83030', 'USA', 1166, 71800, '', '', '', 'male', ''),
(114, 'Australian Collectors, Co.', 'Ferguson', 'Peter', '03 9520 4555', '636 St Kilda Road', 'Level 3', 'Melbourne', 'Victoria', '3004', 'Australia', 1611, 117300, '', '', '', 'male', ''),
(119, 'La Rochelle Gifts', 'Labrune', 'Janine ', '40.67.8555', '67, rue des Cinquante Otages', NULL, 'Nantes', NULL, '44000', 'France', 1370, 118200, '', '', '', 'male', ''),
(121, 'Baane Mini Imports', 'Bergulfsen', 'Jonas ', '07-98 9555', 'Erling Skakkes gate 78', NULL, 'Stavern', NULL, '4110', 'Norway', 1504, 81700, '', '', '', 'male', ''),
(124, 'Mini Gifts Distributors Ltd.', 'Nelson', 'Susan', '4155551450', '5677 Strong St.', NULL, 'San Rafael', 'CA', '97562', 'USA', 1165, 210500, '', '', '', 'male', ''),
(125, 'Havel & Zbyszek Co', 'Piestrzeniewicz', 'Zbyszek ', '(26) 642-7555', 'ul. Filtrowa 68', NULL, 'Warszawa', NULL, '01-012', 'Poland', NULL, 0, '', '', '', 'male', ''),
(128, 'Blauer See Auto, Co.', 'Keitel', 'Roland', '+49 69 66 90 2555', 'Lyonerstr. 34', NULL, 'Frankfurt', NULL, '60528', 'Germany', 1504, 59700, '', '', '', 'male', ''),
(129, 'Mini Wheels Co.', 'Murphy', 'Julie', '6505555787', '5557 North Pendale Street', NULL, 'San Francisco', 'CA', '94217', 'USA', 1165, 64600, '', '', '', 'male', ''),
(131, 'Land of Toys Inc.', 'Lee', 'Kwai', '2125557818', '897 Long Airport Avenue', NULL, 'NYC', 'NY', '10022', 'USA', 1323, 114900, '', '', '', 'male', ''),
(141, 'Euro+ Shopping Channel', 'Freyre', 'Diego ', '(91) 555 94 44', 'C/ Moralzarzal, 86', NULL, 'Madrid', NULL, '28034', 'Spain', 1370, 227600, '', '', '', 'male', ''),
(144, 'Volvo Model Replicas, Co', 'Berglund', 'Christina ', '0921-12 3555', 'BerguvsvÃ¤gen  8', NULL, 'LuleÃ¥', NULL, 'S-958 22', 'Sweden', 1504, 53100, '', '', '', 'male', ''),
(145, 'Danish Wholesale Imports', 'Petersen', 'Jytte ', '31 12 3555', 'VinbÃ¦ltet 34', NULL, 'Kobenhavn', NULL, '1734', 'Denmark', 1401, 83400, '', '', '', 'male', ''),
(146, 'Saveley & Henriot, Co.', 'Saveley', 'Mary ', '78.32.5555', '2, rue du Commerce', NULL, 'Lyon', NULL, '69004', 'France', 1337, 123900, '', '', '', 'male', ''),
(148, 'Dragon Souveniers, Ltd.', 'Natividad', 'Eric', '+65 221 7555', 'Bronz Sok.', 'Bronz Apt. 3/6 Tesvikiye', 'Singapore', NULL, '079903', 'Singapore', 1621, 103800, '', '', '', 'male', ''),
(151, 'Muscle Machine Inc', 'Young', 'Jeff', '2125557413', '4092 Furth Circle', 'Suite 400', 'NYC', 'NY', '10022', 'USA', 1286, 138500, '', '', '', 'male', ''),
(157, 'Diecast Classics Inc.', 'Leong', 'Kelvin', '2155551555', '7586 Pompton St.', NULL, 'Allentown', 'PA', '70267', 'USA', 1216, 100600, '', '', '', 'male', ''),
(161, 'Technics Stores Inc.', 'Hashimoto', 'Juri', '6505556809', '9408 Furth Circle', NULL, 'Burlingame', 'CA', '94217', 'USA', 1165, 84600, '', '', '', 'male', ''),
(166, 'Handji Gifts& Co', 'Victorino', 'Wendy', '+65 224 1555', '106 Linden Road Sandown', '2nd Floor', 'Singapore', NULL, '069045', 'Singapore', 1612, 97900, '', '', '', 'male', ''),
(167, 'Herkku Gifts', 'Oeztan', 'Veysel', '+47 2267 3215', 'Brehmen St. 121', 'PR 334 Sentrum', 'Bergen', NULL, 'N 5804', 'Norway  ', 1504, 96800, '', '', '', 'male', ''),
(168, 'Joe', 'Franco', 'Keith', '2035557845', '149 Spinnaker Dr.', 'Suite 101', 'New Haven', 'CT', '97823', 'USA', 1286, 0, '', '', '', 'male', ''),
(169, 'Porto Imports Co.', 'de Castro', 'Isabel ', '(1) 356-5555', 'Estrada da saÃºde n. 58', NULL, 'Lisboa', NULL, '1756', 'Portugal', NULL, 0, '', '', '', 'male', ''),
(171, 'Daedalus Designs Imports', 'RancÃ©', 'Martine ', '20.16.1555', '184, chaussÃ©e de Tournai', NULL, 'Lille', NULL, '59000', 'France', 1370, 82900, '', '', '', 'male', ''),
(172, 'La Corne D''abondance, Co.', 'Bertrand', 'Marie', '(1) 42.34.2555', '265, boulevard Charonne', NULL, 'Paris', NULL, '75012', 'France', 1337, 84300, '', '', '', 'male', ''),
(173, 'Cambridge Collectables Co.', 'Tseng', 'Jerry', '6175555555', '4658 Baden Av.', NULL, 'Cambridge', 'MA', '51247', 'USA', 1188, 43400, '', '', '', 'male', ''),
(175, 'Gift Depot Inc.', 'King', 'Julie', '2035552570', '25593 South Bay Ln.', NULL, 'Bridgewater', 'CT', '97562', 'USA', 1323, 84300, '', '', '', 'male', ''),
(177, 'Osaka Souveniers Co.', 'Kentary', 'Mory', '+81 06 6342 5555', '1-6-20 Dojima', NULL, 'Kita-ku', 'Osaka', ' 530-0003', 'Japan', 1621, 81200, '', '', '', 'male', ''),
(181, 'Vitachrome Inc.', 'Frick', 'Michael', '2125551500', '2678 Kingston Rd.', 'Suite 101', 'NYC', 'NY', '10022', 'USA', 1286, 76400, '', '', '', 'male', ''),
(186, 'Toys of Finland, Co.', 'Karttunen', 'Matti', '90-224 8555', 'Keskuskatu 45', NULL, 'Helsinki', NULL, '21240', 'Finland', 1501, 96500, '', '', '', 'male', ''),
(187, 'AV Stores, Co.', 'Ashworth', 'Rachel', '(171) 555-1555', 'Fauntleroy Circus', NULL, 'Manchester', NULL, 'EC2 5NT', 'UK', 1501, 136800, '', '', '', 'male', ''),
(189, 'Clover Collections, Co.', 'Cassidy', 'Dean', '+353 1862 1555', '25 Maiden Lane', 'Floor No. 4', 'Dublin', NULL, '2', 'Ireland', 1504, 69400, '', '', '', 'male', ''),
(198, 'Auto-Moto Classics Inc.', 'Taylor', 'Leslie', '6175558428', '16780 Pompton St.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1216, 23000, '', '', '', 'male', ''),
(201, 'UK Collectables, Ltd.', 'Devon', 'Elizabeth', '(171) 555-2282', '12, Berkeley Gardens Blvd', NULL, 'Liverpool', NULL, 'WX1 6LT', 'UK', 1501, 92700, '', '', '', 'male', ''),
(202, 'Canadian Gift Exchange Network', 'Tamuri', 'Yoshi ', '(604) 555-3392', '1900 Oak St.', NULL, 'Vancouver', 'BC', 'V3F 2K1', 'Canada', 1323, 90300, '', '', '', 'male', ''),
(204, 'Online Mini Collectables', 'Barajas', 'Miguel', '6175557555', '7635 Spinnaker Dr.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1188, 68700, '', '', '', 'male', ''),
(205, 'Toys4GrownUps.com', 'Young', 'Julie', '6265557265', '78934 Hillside Dr.', NULL, 'Pasadena', 'CA', '90003', 'USA', 1166, 90700, '', '', '', 'male', ''),
(206, 'Asian Shopping Network, Co', 'Walker', 'Brydey', '+612 9411 1555', 'Suntec Tower Three', '8 Temasek', 'Singapore', NULL, '038988', 'Singapore', NULL, 0, '', '', '', 'male', ''),
(209, 'Mini Caravy', 'Citeaux', 'FrÃ©dÃ©rique ', '88.60.1555', '24, place KlÃ©ber', NULL, 'Strasbourg', NULL, '67000', 'France', 1370, 53800, '', '', '', 'male', ''),
(211, 'King Kong Collectables, Co.', 'Gao', 'Mike', '+852 2251 1555', 'Bank of China Tower', '1 Garden Road', 'Central Hong Kong', NULL, NULL, 'Hong Kong', 1621, 58600, '', '', '', 'male', ''),
(216, 'Enaco Distributors', 'Saavedra', 'Eduardo ', '(93) 203 4555', 'Rambla de CataluÃ±a, 23', NULL, 'Barcelona', NULL, '08022', 'Spain', 1702, 60300, '', '', '', 'male', ''),
(219, 'Boards & Toys Co.', 'Young', 'Mary', '3105552373', '4097 Douglas Av.', NULL, 'Glendale', 'CA', '92561', 'USA', 1166, 11000, '', '', '', 'male', ''),
(223, 'NatÃ¼rlich Autos', 'Kloss', 'Horst ', '0372-555188', 'TaucherstraÃŸe 10', NULL, 'Cunewalde', NULL, '01307', 'Germany', NULL, 0, '', '', '', 'male', ''),
(227, 'Heintze Collectables', 'Ibsen', 'Palle', '86 21 3555', 'Smagsloget 45', NULL, 'Ã…rhus', NULL, '8200', 'Denmark', 1401, 120800, '', '', '', 'male', ''),
(233, 'QuÃ©bec Home Shopping Network', 'FresniÃ¨re', 'Jean ', '(514) 555-8054', '43 rue St. Laurent', NULL, 'MontrÃ©al', 'QuÃ©bec', 'H1J 1C3', 'Canada', 1286, 48700, '', '', '', 'male', ''),
(237, 'ANG Resellers', 'Camino', 'Alejandra ', '(91) 745 6555', 'Gran VÃ­a, 1', NULL, 'Madrid', NULL, '28001', 'Spain', NULL, 0, '', '', '', 'male', ''),
(239, 'Collectable Mini Designs Co.', 'Thompson', 'Valarie', '7605558146', '361 Furth Circle', NULL, 'San Diego', 'CA', '91217', 'USA', 1166, 105000, '', '', '', 'male', ''),
(240, 'giftsbymail.co.uk', 'Bennett', 'Helen ', '(198) 555-8888', 'Garden House', 'Crowther Way 23', 'Cowes', 'Isle of Wight', 'PO31 7PJ', 'UK', 1501, 93900, '', '', '', 'male', ''),
(242, 'Joe', 'Roulet', 'Annette', '61.77.6555', '1 rue Alsace-Lorraine', NULL, 'Toulouse', NULL, '31000', 'France', 1370, 61100.12, 0xffd8ffe000104a46494600010100000100010000fffe003b43524541544f523a2067642d6a7065672076312e3020287573696e6720494a47204a50454720763730292c207175616c697479203d2039320affdb004300030202020202030202020303030304060404040404080606050609080a0a090809090a0c0f0c0a0b0e0b09090d110d0e0f101011100a0c12131210130f101010ffdb00430103030304030408040408100b090b1010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010ffc00011080050005003012200021101031101ffc4001f0000010501010101010100000000000000000102030405060708090a0bffc400b5100002010303020403050504040000017d01020300041105122131410613516107227114328191a1082342b1c11552d1f02433627282090a161718191a25262728292a3435363738393a434445464748494a535455565758595a636465666768696a737475767778797a838485868788898a92939495969798999aa2a3a4a5a6a7a8a9aab2b3b4b5b6b7b8b9bac2c3c4c5c6c7c8c9cad2d3d4d5d6d7d8d9dae1e2e3e4e5e6e7e8e9eaf1f2f3f4f5f6f7f8f9faffc4001f0100030101010101010101010000000000000102030405060708090a0bffc400b51100020102040403040705040400010277000102031104052131061241510761711322328108144291a1b1c109233352f0156272d10a162434e125f11718191a262728292a35363738393a434445464748494a535455565758595a636465666768696a737475767778797a82838485868788898a92939495969798999aa2a3a4a5a6a7a8a9aab2b3b4b5b6b7b8b9bac2c3c4c5c6c7c8c9cad2d3d4d5d6d7d8d9dae2e3e4e5e6e7e8e9eaf2f3f4f5f6f7f8f9faffda000c03010002110311003f00f8b34e9d668dd8609321527d315dc787fe12f8a3c4f02b2a47a64538fddcd7070ec4f4c28e7f956b7c0bf865e5db4fe39d7a092e12e256165104dc8b8ff968dc633ede801ef5ebf717774b750d841208da35694dc2028f8cfcbd0f1d3b57e5398661ec6aba7435b75e87ea1493941396845a069dfd93a6db43ab6bb76f359110cf3db598019803ce0c99e064fe15d278821d1ad91208f5c8751791884177a7c904bb4805183119c3060473d3ae2b975d16de7899e68d164639666192dee73503599d2db16b7333230d8c8c1b953d703d38e9ed5f2d530742a4b99ad7cb43d5866b8b83f8befb1d6693aa78621558eeed6e209e220161209a2751d73d08fa826bc8be33fc7af869078f746f0f682b1c2079b0ea13c321f22366da10e3b720e7d0577b2e836fabe9d2e9d7aa8f0dc215e0e3ef0c75edfcebe3bf897f01b56f0bebd2e9fa5c777a84b792f9964806f924427eef1f7981fd3d2bd5e1ec97035714e58aaad593e55d35d2edf96f639b38cfb18f09ecf0f4936f77e4b5b25ddffc31f56e9b74d1c2cb0e72ca323009273c0cfa1ef5a705b681acb5ce9f7d3849d228c42ab089125247ce1836083cf515c5fc00f86df13747f0d9d3fc7ed67142a80d861ccb750138c2498f9193032003b978e71c57aa47e04bf478665bddb22606ff0023963fdee0838fe5f95618ba70c35695384d4adb34f467361eafb6a4a738b8dfa33c6bc6bfb3eea1a4eac3c4bf0e75c1a6eac02cc208a40d1baedddc104fa7dd39e78c74ac64fda27e22780dee342f88fe0d9924c9124f6e86366ed928dc7e75f55e89e0fd4b53b67b2b6d620bbbe5c3c56bb56190e7af0e554e4e380d9cf6af22f8b7a9e81e135bad1fc7169f6ad765fdd5b595e46c6e6173c7461927b0e3033d7d7b30d8f78ab51c5d3f6ab64f692ffb7974f530ab868d36e7869f23edba7f27fa177c153ac3e11d3ad55b2896e983d3aa8e78abb726f2395dac6ea083ee310eaae666c90a8aa412dc93c018c919ed5e3df013e247f6df874687ab4c06a9a70f266048cb01c0603d3181e808f7af507bd0482119b27009f940239233ebc76acb1986a985c44e9cd6b77f3f32e8d5857a6a71d99d25b5948192436c5cc65586f8f721c1cf20f50715a16bac69373018757d16cadc01218ee2d6062c8e7246e4de011cf38e9c1c1e877eefe2cebfaaf8761f0ccde1bf0d595bc08112e2cf4f3f6948cb0619958924ed0002727079cf5ae3d85bdd2c3f6053234a30a8bf31001c73dfb67f1ae19c55fdd7fa1b41b6bdf5fa97adad6d2f648a5b481b694de1d08f2d82fde6c9edd4e3ad76ff0008fe1ce9de37ba9fc497d6cd325bca6cac7cb452ca8f9cc85988daacd8c37cdc67e5c819f24bebf83468e4923b8791155a5758652232fb78e9c16ec48fa5769f0ebc6fa9e8be0ed1e6d1f577854da46e811b86c80c41e7920329ef8c9e9ddcaf18dfe40d37a2dcf4abff0087778d77aa2daac91db5a4f243005c81248bf2b1503af28738e303dab9fd6f40fb22c7797568b042155591672af92061f2dbb2a7b11deb4f40f1d6a7a84f6d72fae082e126937acd133c7207d80a9e71961e61cf1f301c8cee5cd93c592c81967d3207493704dc371818e3a160c540c75183f4ae4695aec69cae64580ba37b0db4b7aab1ef55ff004b0762ae7a904642f24f1d8d5af15f84fc3be2dd26d2cbe21da4379258978f49d63cb06ef4cc8f956373ccb1f3f347c84e0a90d9157ed3435bf8e5f114e6eda36936c53a1dcb6ee5b9328c1620027a73e9591acc3a8c90c977b5278ada0489e458540846ec0381cae703e6201cb1cf27929b9d27cd06124a6d5fa1f999a56a1aa59dadc78af40925865b6ba764913a8cb3100fa8230083c1af65f01fed4ba53a4761e36827d3e74c01776e9e6464f4c91f79063a95dd9e30a38af6ef187c199b5af86f3789be157836c26d5f4e8278f56d374fd3235596c0a6e1332a0037c6ca0a9fbc49e32462be5eb0f861e17f18cb14b1ddb69ed70c72f18de17903057b1c923a81c57dfd1ccb2dcea84aa6260d453d1ad64bd6de9a6e9fadce0c4e4f8fc1558d2c2ce329db54f44ddf757db73e8bb5f8cde01beb7696c3c71a3323a6ddf24eb1b648fee4bb5ff4aa5aefc75f00e916125a1f18690220a23f2ac537acc0777d80963c672ddcd7cf7a87ece3776124b24be24b75b70fb616f28ee901fbbc678c8e7bd5cd13e03e996934777ab35c5f420038c18a363d7a9c1c63d09ae6580c912f690af292ec92fbaed21ac3e78e5c93a118f9b97e3657763a0f10fc6dd6fc76d2f877e17e9f710acaa239f53b91b044a7825146769eb83927d003cd7a67ecade3b8fc55e159bc01abde22eb3e1f2c115dbe796104fcc33d704ed6e981b0f40c4709aa2e81e17d27ccb716fa759da2991846800edd0ae0b633c679638c13915e0763e2ed7ac3c593f8dfc253cfa6deda5c0ba85a03868a3070338e1b8da1b8c1c9cf5aefa59750cdb093a1421c91566a4f57cdb6afadd745a238f1d39e4f5a9cab4f9e6ef74b6e5b5ee9793eaf57a9fa4b1dc49612b5bb32640daeac80e0f048f9870474fceba3b8bb8fc417b6d73a7a30ba9862e565779da49371f98331ce0838f6000c93cd7cddf0d3f6a4f0178eec63b4f1b3c3e1ad79542c92853f61ba6e9b94804c0c78cab7eefa90ea3083deed3c49a141e1d41e18b986e8de29171a8473ac91ba120ec42a76fd70581182727013e2719976272e9ba5888d977dd3f467af4313471515528caffd753d0f44d42d7c3379737b0ead6ef6842b5cd9cb26d9074f976e0abf3c7ca49ea485c1028f8bc4faf08fc43a2dbcf696105ba8d4517251672194a0c72d952091cf5c77ae2548b6953ed37103a381b8991708727ee90793c70c0e0e7ad3be257ed0ff000c3e1df845f4bbfd612eaf150a47690c81b8e48015704312725b3d4101b0d8ae7a34675e6a14a2db7d15d9539469ae6931cdf1427f09f8417c05e1555b78ee0b36a5771e4cb76f9c73dc281d01c633db26be37f895a5dff863c5b2f887c1b7702acf9967b29816467f600771d7ff00afcfb9eb77d75a6e8ba878b25b668a2b20079fb080f312707191ea4e3d139e79af9eefefe7d69e6bcbb9b74d74cf270380339ce3fce73ef5ddc33879c6a4abef1b59a7aa77d6df2dfc8f6b3d9d385354a3a4dbe64d68d5badfcf6edf212dfe33ddc2822d5bc157f0ca18176b2e41c2ed00750bcf271cf6e94dd47e296bbad3b9d23c1baa3a7cdb7ed6a15541231f3371c63d3a1abb6cb6c612da843e5bae046ea4649cf393e9d7d46474ea6b4a295d53745891303e641dbe9fd467f0afa6953c1d39734682bff8a56febe67871c4e3ea4791e21dbfc31bff005f23915f03f883c7faae996fe37f1545a6584d3ac72c304608801184237b00c72704b11b413e98ae67c6fe0abcf84fe2efb0bc5bded498a6427292ae0720f75742ac0fbfb57afd8436d732e50a6f242e5f95c9f6c75ff3c7268f14f836cbc565f4496eed90db5948f6b7258f2c920215b201cfef48e9dc01d2ba2866b528d54aa694acd38a564afd74d7f5ebb9c388cb295684a50bbad74d49b6dbb74d7fcac7904bf0d2d7c5366de20f055e47b002f2dbeff9a06ee18755f6ea0f6a8b48f007c64b4b79756f0de9f7f37d99da394d84e1e74daa5cb1446f3428009dc46de3ad5dd5be16fc59f02345ae59e8d7d00551279d6db98a0ec180e9d8f3d3a1c1c8a9749f8efe38d0ae77df691657574bc79b35b6d97b6724633d057adedf17569b7809d3ad1ecdabaf26fafaefe4cf32543054a76cc29d4a13eae29f2bf34ba7a7e44d61e12fda0f5bfdc483598f71f2c477374cac5f3809b19b20fb1156fc71f074782ad2cb4df1478963d4bc5da982574f87e68ec63c6ef359c121f29c8000ef5d3e8df143e3e78fd5a2f0778616c6298f972df456e6345c8c73348768e3f1acc4f046b5e1dd7adeefc5324b71e22bd4b969a398b16429b1b6ee3d7285ce41c11d322bcd8e33150adcb5e54e9b5af242ce4ffc4fa47bf57b68b7f43ea5849d14f0f0a9513d39e77515fe15a5e5dba2df5691ed5f16bc5137fc20f63e1896eadcceb2b18479d990c6164670101c639049209381cf4af1c48a4061ba850e02059142e718e9c7b64f4e69fadf81ed3c396571ad35e5c5fea90b2491cd7137984a64971c7cbc829c8ea1fb74a86cb5037b6d15ee9bf3444e14120903b86f71cd79796e1e9e1f0fcb425ccaeeedab6aff004ed7f33d9ccea54a95d4eb4795db449df4bfcb5ef6f234ca4371006888dedf205ec7d40e9db8c1c60134fb4b7b94123a1319272211f77a7a75196207b804d0b6cd70d1807664f2c064819e067a1ebdeb6ed346bbb297ecd7f1c3711e3890c863c7b649ca9eddc56b3aaa2acd9c8a1ccefb7992e99368372ef16ab2c966cf22c706ddd23cafb805fba393dcb1e808c7607d77e1c783746d77c4f0d979cb15c5bc52bc12344c0cd365085d99605b6ab945c924a13d86df169b4bd36ff509174c945b5bda2c8ed7176fc47173f33b2f19218640ea582ae49515fa23f01be044eff02e7b6f1ac773a75e6bd2dbdd6750b07692de0cb1b320212e928f32494a8705249829381b6bc8cda54e387e45269cb4fd7eeb6fa9d387c5fd4eafb7a89349e9e6f6bdbadb7dbb1e6fa6d943a7dcb4b75a0996e6d88061ba863f35496db9003b20258a804e39c63a9ae9ae7c19e19d5aee09f52f86e52eb89049e441707ae3965cf27afb7d68f097862ee5b89acb58d322b7bed36f6eecf53f22c9a389afa3321dca4b1c64b5b37393b4afddc015e916be00b8795e28b5995a05ba280ac6d2b7d98bc4a42ed2e0baa472e1b8fbc46339cfe7188718d5708349edd57ea8fadaf983a694e6f5b5fba7f357febb6e79c5d3f84d6ddad0db5c4e159c7d962b5f2b2aaa559cb3e10007201ce78240c735e2df1afe1f681ace949ace9119bad5b4047bf8e489e262f02ae24b7930c08478ccbca866079193c57d05e2ef0a6bd63a535fe9d736737936df3dbcf0169202204dea9875db87b844e99c86efd321fe1c5b49e05b6f106afae44b2ea293416d66b03923931a1ddb88298c121867e6386e4d6f82c62c0548578596bb6baf74fd55f62aa55a78aa4e9d4937ccedb27aead3565d2d7bb3ffd9, 'f08d514b878b63a1d55e8c3c65832e0848502782.jpg', 'adg3com_crypticpsyche.mp3', 'female', 'sports,girls,drinks'),
(247, 'Messner Shopping Network', 'Messner', 'Renate ', '069-0555984', 'Magazinweg 7', NULL, 'Frankfurt', NULL, '60528', 'Germany', NULL, 0, '', '', '', 'male', ''),
(249, 'Amica Models & Co.', 'Accorti', 'Paolo ', '011-4988555', 'Via Monte Bianco 34', '', 'Torino', '', '10100', 'Italy', 1401, 113000, 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, '', '', 'male', ''),
(250, 'Lyon Souveniers', 'Da Silva', 'Daniel', '+33 1 46 62 7555', '27 rue du Colonel Pierre Avia', NULL, 'Paris', NULL, '75508', 'France', 1337, 68100, '', '', '', 'male', ''),
(256, 'Auto AssociÃ©s & Cie.', 'Tonini', 'Daniel ', '30.59.8555', '67, avenue de l''Europe', NULL, 'Versailles', NULL, '78000', 'France', 1370, 77900, '', '', '', 'male', ''),
(259, 'Toms SpezialitÃ¤ten, Ltd', 'Pfalzheim', 'Henriette ', '0221-5554327', 'Mehrheimerstr. 369', NULL, 'KÃ¶ln', NULL, '50739', 'Germany', 1504, 120400, '', '', '', 'male', ''),
(260, 'Royal Canadian Collectables, Ltd.', 'Lincoln', 'Elizabeth ', '(604) 555-4555', '23 Tsawassen Blvd.', NULL, 'Tsawassen', 'BC', 'T2F 8M4', 'Canada', 1323, 89600, '', '', '', 'male', ''),
(273, 'Franken Gifts, Co', 'Franken', 'Peter ', '089-0877555', 'Berliner Platz 43', NULL, 'MÃ¼nchen', NULL, '80805', 'Germany', NULL, 0, '', '', '', 'male', ''),
(276, 'Anna''s Decorations, Ltd', 'O''Hara', 'Anna', '02 9936 8555', '201 Miller Street', 'Level 15', 'North Sydney', 'NSW', '2060', 'Australia', 1611, 107800, 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, '8f93d64c6d9e4e9efa2a3fb8c7c1f17e00deabce.jpg', '', 'male', 'cooking'),
(278, 'Rovelli Gifts', 'Rovelli', 'Giovanni ', '035-640555', 'Via Ludovico il Moro 22', NULL, 'Bergamo', NULL, '24100', 'Italy', 1401, 119600, '', '', '', 'male', ''),
(282, 'Souveniers And Things Co.', 'Huxley', 'Adrian', '+61 2 9495 8555', 'Monitor Money Building', '815 Pacific Hwy', 'Chatswood', 'NSW', '2067', 'Australia', 1611, 93300, '', '', '', 'male', ''),
(286, 'Marta''s Replicas Co.', 'Hernandez', 'Marta', '6175558555', '39323 Spinnaker Dr.', NULL, 'Cambridge', 'MA', '51247', 'USA', 1216, 123700, '', '', '', 'male', ''),
(293, 'BG&E Collectables', 'Harrison', 'Ed', '+41 26 425 50 01', 'Rte des Arsenaux 41 ', NULL, 'Fribourg', NULL, '1700', 'Switzerland', NULL, 0, '', '', '', 'male', ''),
(298, 'Vida Sport, Ltd', 'Holz', 'Mihael', '0897-034555', 'Grenzacherweg 237', NULL, 'GenÃ¨ve', NULL, '1203', 'Switzerland', 1702, 141300, '', '', '', 'male', ''),
(299, 'Norway Gifts By Mail, Co.', 'Klaeboe', 'Jan', '+47 2212 1555', 'Drammensveien 126A', 'PB 211 Sentrum', 'Oslo', NULL, 'N 0106', 'Norway  ', 1504, 95100, '', '', '', 'male', ''),
(303, 'Schuyler Imports', 'Schuyler', 'Bradley', '+31 20 491 9555', 'Kingsfordweg 151', NULL, 'Amsterdam', NULL, '1043 GR', 'Netherlands', NULL, 0, '', '', '', 'male', ''),
(307, 'Der Hund Imports', 'Andersen', 'Mel', '030-0074555', 'Obere Str. 57', NULL, 'Berlin', NULL, '12209', 'Germany', NULL, 0, '', '', '', 'male', ''),
(311, 'Oulu Toy Supplies, Inc.', 'Koskitalo', 'Pirkko', '981-443655', 'Torikatu 38', NULL, 'Oulu', NULL, '90110', 'Finland', 1501, 90500, '', '', '', 'male', ''),
(314, 'Petit Auto', 'Dewey', 'Catherine ', '(02) 5554 67', 'Rue Joseph-Bens 532', NULL, 'Bruxelles', NULL, 'B-1180', 'Belgium', 1401, 79900, '', '', '', 'male', ''),
(319, 'Mini Classics', 'Frick', 'Steve', '9145554562', '3758 North Pendale Street', NULL, 'White Plains', 'NY', '24067', 'USA', 1323, 102700, '', '', '', 'male', ''),
(320, 'Mini Creations Ltd.', 'Huang', 'Wing', '5085559555', '4575 Hillside Dr.', NULL, 'New Bedford', 'MA', '50553', 'USA', 1188, 94500, '', '', '', 'male', ''),
(321, 'Corporate Gift Ideas Co.', 'Brown', 'Julie', '6505551386', '7734 Strong St.', NULL, 'San Francisco', 'CA', '94217', 'USA', 1165, 105000, '', '', '', 'male', ''),
(323, 'Down Under Souveniers, Inc', 'Graham', 'Mike', '+64 9 312 5555', '162-164 Grafton Road', 'Level 2', 'Auckland  ', NULL, NULL, 'New Zealand', 1612, 88000, '', '', '', 'male', ''),
(324, 'Stylish Desk Decors, Co.', 'Brown', 'Ann ', '(171) 555-0297', '35 King George', NULL, 'London', NULL, 'WX3 6FW', 'UK', 1501, 77000, '', '', '', 'male', ''),
(328, 'Tekni Collectables Inc.', 'Brown', 'William', '2015559350', '7476 Moss Rd.', NULL, 'Newark', 'NJ', '94019', 'USA', 1323, 43000, '', '', '', 'male', ''),
(333, 'Australian Gift Network, Co', 'Calaghan', 'Ben', '61-7-3844-6555', '31 Duncan St. West End', NULL, 'South Brisbane', 'Queensland', '4101', 'Australia', 1611, 51600, '', '', '', 'male', ''),
(334, 'Suominen Souveniers', 'Suominen', 'Kalle', '+358 9 8045 555', 'Software Engineering Center', 'SEC Oy', 'Espoo', NULL, 'FIN-02271', 'Finland', 1501, 98800, '', '', '', 'male', ''),
(335, 'Cramer SpezialitÃ¤ten, Ltd', 'Cramer', 'Philip ', '0555-09555', 'Maubelstr. 90', NULL, 'Brandenburg', NULL, '14776', 'Germany', NULL, 0, '', '', '', 'male', ''),
(339, 'Classic Gift Ideas, Inc', 'Cervantes', 'Francisca', '2155554695', '782 First Street', NULL, 'Philadelphia', 'PA', '71270', 'USA', 1188, 81100, '', '', '', 'male', ''),
(344, 'CAF Imports', 'Fernandez', 'Jesus', '+34 913 728 555', 'Merchants House', '27-30 Merchant''s Quay', 'Madrid', NULL, '28023', 'Spain', 1702, 59600, '', '', '', 'male', ''),
(347, 'Men ''R'' US Retailers, Ltd.', 'Chandler', 'Brian', '2155554369', '6047 Douglas Av.', NULL, 'Los Angeles', 'CA', '91003', 'USA', 1166, 57700, '', '', '', 'male', ''),
(348, 'Asian Treasures, Inc.', 'McKenna', 'Patricia ', '2967 555', '8 Johnstown Road', NULL, 'Cork', 'Co. Cork', NULL, 'Ireland', NULL, 0, '', '', '', 'male', ''),
(350, 'Marseille Mini Autos', 'Lebihan', 'Laurence ', '91.24.4555', '12, rue des Bouchers', NULL, 'Marseille', NULL, '13008', 'France', 1337, 65000, '', '', '', 'male', ''),
(353, 'Reims Collectables', 'Henriot', 'Paul ', '26.47.1555', '59 rue de l''Abbaye', NULL, 'Reims', NULL, '51100', 'France', 1337, 81100, '', '', '', 'male', ''),
(356, 'SAR Distributors, Co', 'Kuger', 'Armand', '+27 21 550 3555', '1250 Pretorius Street', NULL, 'Hatfield', 'Pretoria', '0028', 'South Africa', NULL, 0, '', '', '', 'male', ''),
(357, 'GiftsForHim.com', 'MacKinlay', 'Wales', '64-9-3763555', '199 Great North Road', NULL, 'Auckland', NULL, NULL, 'New Zealand', 1612, 77700, '', '', '', 'male', ''),
(361, 'Kommission Auto', 'Josephs', 'Karin', '0251-555259', 'Luisenstr. 48', NULL, 'MÃ¼nster', NULL, '44087', 'Germany', NULL, 0, '', '', '', 'male', ''),
(362, 'Gifts4AllAges.com', 'Yoshido', 'Juri', '6175559555', '8616 Spinnaker Dr.', NULL, 'Boston', 'MA', '51003', 'USA', 1216, 41900, '', '', '', 'male', ''),
(363, 'Online Diecast Creations Co.', 'Young', 'Dorothy', '6035558647', '2304 Long Airport Avenue', NULL, 'Nashua', 'NH', '62005', 'USA', 1216, 114200, '', '', '', 'male', ''),
(369, 'Lisboa Souveniers, Inc', 'Rodriguez', 'Lino ', '(1) 354-2555', 'Jardim das rosas n. 32', NULL, 'Lisboa', NULL, '1675', 'Portugal', NULL, 0, '', '', '', 'male', ''),
(376, 'Precious Collectables', 'Urs', 'Braun', '0452-076555', 'Hauptstr. 29', NULL, 'Bern', NULL, '3012', 'Switzerland', 1702, 0, '', '', '', 'male', ''),
(379, 'Collectables For Less Inc.', 'Nelson', 'Allen', '6175558555', '7825 Douglas Av.', NULL, 'Brickhaven', 'MA', '58339', 'USA', 1188, 70700, '', '', '', 'male', ''),
(381, 'Royale Belge', 'Cartrain', 'Pascale ', '(071) 23 67 2555', 'Boulevard Tirou, 255', NULL, 'Charleroi', NULL, 'B-6000', 'Belgium', 1401, 23500, '', '', '', 'male', ''),
(382, 'Salzburg Collectables', 'Pipps', 'Georg ', '6562-9555', 'Geislweg 14', NULL, 'Salzburg', NULL, '5020', 'Austria', 1401, 71700, '', '', '', 'male', ''),
(385, 'Cruz & Sons Co.', 'Cruz', 'Arnold', '+63 2 555 3587', '15 McCallum Street', 'NatWest Center #13-03', 'Makati City', NULL, '1227 MM', 'Philippines', 1621, 81500, '', '', '', 'male', ''),
(386, 'L''ordine Souveniers', 'Moroni', 'Maurizio ', '0522-556555', 'Strada Provinciale 124', NULL, 'Reggio Emilia', NULL, '42100', 'Italy', 1401, 121400, '', '', '', 'male', ''),
(398, 'Tokyo Collectables, Ltd', 'Shimamura', 'Akiko', '+81 3 3584 0555', '2-2-8 Roppongi', NULL, 'Minato-ku', 'Tokyo', '106-0032', 'Japan', 1621, 94400, '', '', '', 'male', ''),
(406, 'Auto Canal+ Petit', 'Perrier', 'Dominique', '(1) 47.55.6555', '25, rue Lauriston', NULL, 'Paris', NULL, '75016', 'France', 1337, 95000, '', '', '', 'male', ''),
(409, 'Stuttgart Collectable Exchange', 'MÃ¼ller', 'Rita ', '0711-555361', 'Adenauerallee 900', NULL, 'Stuttgart', NULL, '70563', 'Germany', NULL, 0, '', '', '', 'male', ''),
(412, 'Extreme Desk Decorations, Ltd', 'McRoy', 'Sarah', '04 499 9555', '101 Lambton Quay', 'Level 11', 'Wellington', NULL, NULL, 'New Zealand', 1612, 86800, '', '', '', 'male', ''),
(415, 'Bavarian Collectables Imports, Co.', 'Donnermeyer', 'Michael', ' +49 89 61 08 9555', 'Hansastr. 15', NULL, 'Munich', NULL, '80686', 'Germany', 1504, 77000, '', '', '', 'male', ''),
(424, 'Classic Legends Inc.', 'Hernandez', 'Maria', '2125558493', '5905 Pompton St.', 'Suite 750', 'NYC', 'NY', '10022', 'USA', 1286, 67500, '', '', '', 'male', ''),
(443, 'Feuer Online Stores, Inc', 'Feuer', 'Alexander ', '0342-555176', 'Heerstr. 22', NULL, 'Leipzig', NULL, '04179', 'Germany', NULL, 0, '', '', '', 'male', ''),
(447, 'Gift Ideas Corp.', 'Lewis', 'Dan', '2035554407', '2440 Pompton St.', NULL, 'Glendale', 'CT', '97561', 'USA', 1323, 49700, '', '', '', 'male', ''),
(448, 'Scandinavian Gift Ideas', 'Larsson', 'Martha', '0695-34 6555', 'Ã…kergatan 24', NULL, 'BrÃ¤cke', NULL, 'S-844 67', 'Sweden', 1504, 116400, '', '', '', 'male', ''),
(450, 'The Sharp Gifts Warehouse', 'Frick', 'Sue', '4085553659', '3086 Ingle Ln.', NULL, 'San Jose', 'CA', '94217', 'USA', 1165, 77600, '', '', '', 'male', ''),
(452, 'Mini Auto Werke', 'Mendel', 'Roland ', '7675-3555', 'Kirchgasse 6', NULL, 'Graz', NULL, '8010', 'Austria', 1401, 45300, '', '', '', 'male', ''),
(455, 'Super Scale Inc.', 'Murphy', 'Leslie', '2035559545', '567 North Pendale Street', NULL, 'New Haven', 'CT', '97823', 'USA', 1286, 95400, '', '', '', 'male', ''),
(456, 'Microscale Inc.', 'Choi', 'Yu', '2125551957', '5290 North Pendale Street', 'Suite 200', 'NYC', 'NY', '10022', 'USA', 1286, 39800, '', '', '', 'male', ''),
(458, 'Corrida Auto Replicas, Ltd', 'Sommer', 'MartÃ­n ', '(91) 555 22 82', 'C/ Araquil, 67', NULL, 'Madrid', NULL, '28023', 'Spain', 1702, 104600, '', '', '', 'male', ''),
(459, 'Warburg Exchange', 'Ottlieb', 'Sven ', '0241-039123', 'Walserweg 21', NULL, 'Aachen', NULL, '52066', 'Germany', NULL, 0, '', '', '', 'male', ''),
(462, 'FunGiftIdeas.com', 'Benitez', 'Violeta', '5085552555', '1785 First Street', NULL, 'New Bedford', 'MA', '50553', 'USA', 1216, 85800, '', '', '', 'male', ''),
(465, 'Anton Designs, Ltd.', 'Anton', 'Carmen', '+34 913 728555', 'c/ Gobelas, 19-1 Urb. La Florida', NULL, 'Madrid', NULL, '28023', 'Spain', NULL, 0, '', '', '', 'male', ''),
(471, 'Australian Collectables, Ltd', 'Clenahan', 'Sean', '61-9-3844-6555', '7 Allen Street', NULL, 'Glen Waverly', 'Victoria', '3150', 'Australia', 1611, 60300, '', '', '', 'male', ''),
(473, 'Frau da Collezione', 'Ricotti', 'Franco', '+39 022515555', '20093 Cologno Monzese', 'Alessandro Volta 16', 'Milan', NULL, NULL, 'Italy', 1401, 34800, '', '', '', 'male', ''),
(475, 'Joe', 'Thompson', 'Steve', '3105553722', '3675 Furth Circle', NULL, 'Burbank', 'CA', '94019', 'USA', 1166, 55400, '', '', '', 'male', ''),
(477, 'Mit VergnÃ¼gen & Co.', 'Moos', 'Hanna ', '0621-08555', 'Forsterstr. 57', NULL, 'Mannheim', NULL, '68306', 'Germany', NULL, 0, '', '', '', 'male', ''),
(480, 'Kremlin Collectables, Co.', 'Semenov', 'Alexander ', '+7 812 293 0521', '2 Pobedy Square', NULL, 'Saint Petersburg', NULL, '196143', 'Russia', NULL, 0, '', '', '', 'male', ''),
(481, 'Raanan Stores, Inc', 'Altagar,G M', 'Raanan', '+ 972 9 959 8555', '3 Hagalim Blv.', NULL, 'Herzlia', NULL, '47625', 'Israel', NULL, 0, '', '', '', 'male', ''),
(484, 'Iberia Gift Imports, Corp.', 'Roel', 'JosÃ© Pedro ', '(95) 555 82 82', 'C/ Romero, 33', NULL, 'Sevilla', NULL, '41101', 'Spain', 1702, 65700, '', '', '', 'male', ''),
(486, 'Motor Mint Distributors Inc.', 'Salazar', 'Rosa', '2155559857', '11328 Douglas Av.', NULL, 'Philadelphia', 'PA', '71270', 'USA', 1323, 72600, '', '', '', 'male', ''),
(487, 'Signal Collectibles Ltd.', 'Taylor', 'Sue', '4155554312', '2793 Furth Circle', NULL, 'Brisbane', 'CA', '94217', 'USA', 1165, 60300, '', '', '', 'male', ''),
(489, 'Double Decker Gift Stores, Ltd', 'Smith', 'Thomas ', '(171) 555-7555', '120 Hanover Sq.', NULL, 'London', NULL, 'WA1 1DP', 'UK', 1501, 43300, '', '', '', 'male', ''),
(495, 'Diecast Collectables', 'Franco', 'Valarie', '6175552555', '6251 Ingle Ln.', NULL, 'Boston', 'MA', '51003', 'USA', 1188, 85100, '', '', '', 'male', ''),
(496, 'Kelly''s Gift Shop', 'Snowden', 'Tony', '+64 9 5555500', 'Arenales 1938 3''A''', NULL, 'Auckland  ', NULL, NULL, 'New Zealand', 1612, 110000, '', '', '', 'male', '');

DROP TABLE IF EXISTS `employees`;
CREATE TABLE IF NOT EXISTS `employees` (
  `employeeNumber` int(11) NOT NULL AUTO_INCREMENT,
  `lastName` varchar(50) NOT NULL,
  `firstName` varchar(50) NOT NULL,
  `extension` varchar(10) NOT NULL,
  `email` varchar(100) NOT NULL,
  `officeCode` varchar(10) NOT NULL,
  `reportsTo` int(11) DEFAULT NULL,
  `jobTitle` varchar(50) NOT NULL,
  PRIMARY KEY (`employeeNumber`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1703 ;

INSERT INTO `employees` (`employeeNumber`, `lastName`, `firstName`, `extension`, `email`, `officeCode`, `reportsTo`, `jobTitle`) VALUES
(1002, 'Murphy', 'Diane', 'x5800', 'dmurphy@classicmodelcars.com', '5', 8, 'President'),
(1056, 'Patterson', 'Mar''y', 'x4611', 'mpatterso@classicmodelcars.com', '1', 1002, 'VP Sales'),
(1076, 'Firrelli', 'Jeff', 'x9273', 'jfirrelli@classicmodelcars.com', '1', 1002, 'VP Marketing'),
(1088, 'Patterson', 'William', 'x4871', 'wpatterson@classicmodelcars.com', '6', 1056, 'Sales Manager (APAC)'),
(1102, 'Bondur', 'Gerard', 'x5408', 'gbondur@classicmodelcars.com', '4', 1056, 'Sale Manager (EMEA)'),
(1143, 'Bow', 'Anthony', 'x5428', 'abow@classicmodelcars.com', '1', 1056, 'Sales Manager (NA)'),
(1165, 'Jennings', 'Leslie', 'x3291', 'ljennings@classicmodelcars.com', '1', 1143, 'Sales Rep'),
(1166, 'Thompson', 'Leslie', 'x4065', 'lthompson@classicmodelcars.com', '1', 1143, 'Sales Rep'),
(1188, 'Firrelli', 'Julie', 'x2173', 'jfirrelli@classicmodelcars.com', '2', 1143, 'Sales Rep'),
(1216, 'Patterson', 'Steve', 'x4334', 'spatterson@classicmodelcars.com', '2', 1143, 'Sales Rep'),
(1286, 'Tseng', 'Foon Yue', 'o224', 'ftseng@classicmodelcars.com', '3', 1143, 'Sales Rep'),
(1323, 'Vanauf', 'George', 'x4102', 'gvanauf@classicmodelcars.com', '3', 1143, 'Sales Rep'),
(1337, 'Bondur', 'Loui', 'x6493', 'lbondur@classicmodelcars.com', '4', 1102, 'Sales Rep'),
(1370, 'Hernandez', 'Gerard', 'x2028', 'ghernande@classicmodelcars.com', '4', 1102, 'Sales Rep'),
(1401, 'Castillo', 'Pamela', 'x2759', 'pcastillo@classicmodelcars.com', '4', 1102, 'Sales Rep'),
(1501, 'Bott', 'Larry', 'x2311', 'lbott@classicmodelcars.com', '7', 1102, 'Sales Rep'),
(1504, 'Jones', 'Barry', 'x102', 'bjones@classicmodelcars.com', '7', 1102, 'Sales Rep'),
(1611, 'Fixter', 'Andy', 'x101', 'afixter@classicmodelcars.com', '6', 1088, 'Sales Rep'),
(1612, 'Marsh', 'Peter', 'x102', 'pmarsh@classicmodelcars.com', '6', 1088, 'Sales Rep'),
(1619, 'King', 'Tom', 'x103', 'tking@classicmodelcars.com', '6', 1088, 'Sales Rep'),
(1621, 'Nishi', 'Mami', 'x101', 'mnishi@classicmodelcars.com', '5', 1056, 'Sales Rep'),
(1625, 'Kato', 'Yoshimi', 'x102', 'ykato@classicmodelcars.com', '5', 1621, 'Sales Rep'),
(1702, 'Gerard', 'Martin', 'x2312', 'mgerard@classicmodelcars.com', '4', 1102, 'Sales Rep');

DROP TABLE IF EXISTS `gallery`;
CREATE TABLE IF NOT EXISTS `gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `image` varchar(127) NOT NULL,
  `title` varchar(127) NOT NULL,
  `description` text NOT NULL,
  `active` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `gallery` (`id`, `image`, `title`, `description`, `active`) VALUES
(2, 'bs2plwjo13c48ow.jpg', 'Big Tree', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum tellus massa, tempus id tempus at, porta eu purus. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Maecenas purus velit, dapibus vel placerat vitae, pulvinar ut sapien. Nullam sit amet lacus nec diam pulvinar malesuada. Quisque mattis, purus lacinia scelerisque scelerisque, enim lectus aliquet nisi, vel iaculis urna risus vel massa. Etiam eu sem quis ante sollicitudin tincidunt. Proin ac arcu metus.</p>', 1),
(3, 'bfex7xk4nagok08.jpg', 'Nunc congue facilisis bibendum. Fusce mollis elit', '<p>Nunc congue facilisis bibendum. Fusce mollis elit lectus, sit amet varius sem. Aliquam augue eros, sagittis ac aliquet et, viverra in erat. Praesent nunc ante, mattis at aliquet ut, consequat in massa. Integer iaculis, sem nec lacinia tristique, sem leo ullamcorper justo, id elementum risus nibh non risus.</p>', 0),
(4, 'fip742zqb6ggssw.jpg', 'Cras quis quam quis est interdum suscipit. Ut orci risus, ornare in porta at, varius viverra arcu.', '<p>Donec augue massa, vehicula et lacinia nec, pulvinar sit amet ligula. Vestibulum sodales justo ut arcu tincidunt sagittis pellentesque lacus ullamcorper. Nam eu arcu lectus, a fermentum lectus. Nullam nec scelerisque elit. Suspendisse potenti. In adipiscing odio cursus erat pretium commodo vulputate dui faucibus. Nunc convallis diam velit, non congue est. Ut augue nisi, dictum nec consequat vel, mollis nec felis. In consequat tempor diam a porta.</p>', 1),
(5, '1m4wn2mydoiosws.jpg', 'Duis elementum facilisis massa quis rhoncus.', '<p>Fusce accumsan, odio ut placerat congue, mauris quam pulvinar ipsum, in molestie est nisi a eros. In lacus lorem, tempor vitae vulputate id, imperdiet pulvinar arcu. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus.</p>', 1),
(6, '136hc9xe4u34ck0.jpg', 'Nulla lobortis, velit ut aliquet commodo, purus erat cursus sem, a convallis felis tellus eget ligula. Integer ullamcorper laci', '<p>Sed sed felis in massa sodales bibendum et id lacus. Sed consequat est eu ligula hendrerit blandit. Cras pretium, sapien id ultricies suscipit, arcu quam ornare urna, in viverra lorem est a quam. Pellentesque sem dui, ullamcorper vehicula tempus sit amet, hendrerit ac lorem.</p>', 1),
(7, 'a4bqt6tpdw0ck4w.jpg', 'Maecenas volutpat commodo ante, a porta metus sodales at.', '<p>Nullam sodales ligula non risus luctus ut faucibus nulla sagittis. Phasellus accumsan mollis dui, quis imperdiet lectus tempus ac. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. In sit amet mauris quis augue vehicula vestibulum. Quisque arcu magna, sodales et egestas a, tempus in augue.</p>', 0);

DROP TABLE IF EXISTS `offices`;
CREATE TABLE IF NOT EXISTS `offices` (
  `officeCode` int(10) NOT NULL AUTO_INCREMENT,
  `city` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `addressLine1` varchar(50) NOT NULL,
  `addressLine2` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `country` varchar(50) NOT NULL,
  `postalCode` varchar(15) NOT NULL,
  `territory` varchar(10) NOT NULL,
  PRIMARY KEY (`officeCode`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=8 ;

INSERT INTO `offices` (`officeCode`, `city`, `phone`, `addressLine1`, `addressLine2`, `state`, `country`, `postalCode`, `territory`) VALUES
(1, 'San Francisco', '+1 650 219 4782', '100 Market Street', 'Suite 300', 'CA', 'USA', '94080', 'NA'),
(2, 'Boston', '+1 215 837 0825', '1550 Court Place', 'Suite 102', 'MA', 'USA', '02107', 'NA'),
(3, 'NYC', '+1 212 555 3000', '523 East 53rd Street', 'apt. 5A', 'NY', 'USA', '10022', 'NA'),
(4, 'Paris', '+33 14 723 4404', '43 Rue Jouffroy D''abbans', NULL, NULL, 'France', '75017', 'EMEA'),
(5, 'Tokyo', '+81 33 224 5000', '4-1 Kioicho', NULL, 'Chiyoda-Ku', 'Japan', '102-8578', 'Japan'),
(6, 'Sydney', '+61 2 9264 2451', '5-11 Wentworth Avenue', 'Floor #2', NULL, 'Australia', 'NSW 2010', 'APAC'),
(7, 'London', '+44 20 7877 2041', '25 Old Broad Street', 'Level 7', NULL, 'UK', 'EC2N 1HN', 'EMEA');

DROP TABLE IF EXISTS `orderdetails`;
CREATE TABLE IF NOT EXISTS `orderdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `orderNumber` int(11) NOT NULL,
  `productCode` varchar(15) NOT NULL,
  `quantityOrdered` int(11) NOT NULL,
  `priceEach` double NOT NULL,
  `orderLineNumber` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4096 ;

INSERT INTO `orderdetails` (`id`, `orderNumber`, `productCode`, `quantityOrdered`, `priceEach`, `orderLineNumber`) VALUES
(1, 10100, 'S18_1749', 30, 136, 3),
(2, 10100, 'S18_2248', 50, 55.09, 2),
(3, 10100, 'S18_4409', 22, 75.46, 4),
(4, 10100, 'S24_3969', 49, 35.29, 1),
(5, 10101, 'S18_2325', 25, 108.06, 4),
(6, 10101, 'S18_2795', 26, 167.06, 1),
(7, 10101, 'S24_1937', 45, 32.53, 3),
(8, 10101, 'S24_2022', 46, 44.35, 2),
(9, 10102, 'S18_1342', 39, 95.55, 2),
(10, 10102, 'S18_1367', 41, 43.13, 1),
(11, 10103, 'S10_1949', 26, 214.3, 11),
(12, 10103, 'S10_4962', 42, 119.67, 4),
(13, 10103, 'S12_1666', 27, 121.64, 8),
(14, 10103, 'S18_1097', 35, 94.5, 10),
(15, 10103, 'S18_2432', 22, 58.34, 2),
(16, 10103, 'S18_2949', 27, 92.19, 12),
(17, 10103, 'S18_2957', 35, 61.84, 14),
(18, 10103, 'S18_3136', 25, 86.92, 13),
(19, 10103, 'S18_3320', 46, 86.31, 16),
(20, 10103, 'S18_4600', 36, 98.07, 5),
(21, 10103, 'S18_4668', 41, 40.75, 9),
(22, 10103, 'S24_2300', 36, 107.34, 1),
(23, 10103, 'S24_4258', 25, 88.62, 15),
(24, 10103, 'S32_1268', 31, 92.46, 3),
(25, 10103, 'S32_3522', 45, 63.35, 7),
(26, 10103, 'S700_2824', 42, 94.07, 6),
(27, 10104, 'S12_3148', 34, 131.44, 1),
(28, 10104, 'S12_4473', 41, 111.39, 9),
(29, 10104, 'S18_2238', 24, 135.9, 8),
(30, 10104, 'S18_2319', 29, 122.73, 12),
(31, 10104, 'S18_3232', 23, 165.95, 13),
(32, 10104, 'S18_4027', 38, 119.2, 3),
(33, 10104, 'S24_1444', 35, 52.02, 6),
(34, 10104, 'S24_2840', 44, 30.41, 10),
(35, 10104, 'S24_4048', 26, 106.45, 5),
(36, 10104, 'S32_2509', 35, 51.95, 11),
(37, 10104, 'S32_3207', 49, 56.55, 4),
(38, 10104, 'S50_1392', 33, 114.59, 7),
(39, 10104, 'S50_1514', 32, 53.31, 2),
(40, 10105, 'S10_4757', 50, 127.84, 2),
(41, 10105, 'S12_1108', 41, 205.72, 15),
(42, 10105, 'S12_3891', 29, 141.88, 14),
(43, 10105, 'S18_3140', 22, 136.59, 11),
(44, 10105, 'S18_3259', 38, 87.73, 13),
(45, 10105, 'S18_4522', 41, 75.48, 10),
(46, 10105, 'S24_2011', 43, 117.97, 9),
(47, 10105, 'S24_3151', 44, 73.46, 4),
(48, 10105, 'S24_3816', 50, 75.47, 1),
(49, 10105, 'S700_1138', 41, 54, 5),
(50, 10105, 'S700_1938', 29, 86.61, 12),
(51, 10105, 'S700_2610', 31, 60.72, 3),
(52, 10105, 'S700_3505', 39, 92.16, 6),
(53, 10105, 'S700_3962', 22, 99.31, 7),
(54, 10105, 'S72_3212', 25, 44.77, 8),
(55, 10106, 'S18_1662', 36, 134.04, 12),
(56, 10106, 'S18_2581', 34, 81.1, 2),
(57, 10106, 'S18_3029', 41, 80.86, 18),
(58, 10106, 'S18_3856', 41, 94.22, 17),
(59, 10106, 'S24_1785', 28, 107.23, 4),
(60, 10106, 'S24_2841', 49, 65.77, 13),
(61, 10106, 'S24_3420', 31, 55.89, 14),
(62, 10106, 'S24_3949', 50, 55.96, 11),
(63, 10106, 'S24_4278', 26, 71, 3),
(64, 10106, 'S32_4289', 33, 65.35, 5),
(65, 10106, 'S50_1341', 39, 35.78, 6),
(66, 10106, 'S700_1691', 31, 91.34, 7),
(67, 10106, 'S700_2047', 30, 85.09, 16),
(68, 10106, 'S700_2466', 34, 99.72, 9),
(69, 10106, 'S700_2834', 32, 113.9, 1),
(70, 10106, 'S700_3167', 44, 76, 8),
(71, 10106, 'S700_4002', 48, 70.33, 10),
(72, 10106, 'S72_1253', 48, 43.7, 15),
(73, 10107, 'S10_1678', 30, 81.35, 2),
(74, 10107, 'S10_2016', 39, 105.86, 5),
(75, 10107, 'S10_4698', 27, 172.36, 4),
(76, 10107, 'S12_2823', 21, 122, 1),
(77, 10107, 'S18_2625', 29, 52.7, 6),
(78, 10107, 'S24_1578', 25, 96.92, 3),
(79, 10107, 'S24_2000', 38, 73.12, 7),
(80, 10107, 'S32_1374', 20, 88.9, 8),
(81, 10108, 'S12_1099', 33, 165.38, 6),
(82, 10108, 'S12_3380', 45, 96.3, 4),
(83, 10108, 'S12_3990', 39, 75.81, 7),
(84, 10108, 'S12_4675', 36, 107.1, 3),
(85, 10108, 'S18_1889', 38, 67.76, 2),
(86, 10108, 'S18_3278', 26, 73.17, 9),
(87, 10108, 'S18_3482', 29, 132.29, 8),
(88, 10108, 'S18_3782', 43, 52.84, 12),
(89, 10108, 'S18_4721', 44, 139.87, 11),
(90, 10108, 'S24_2360', 35, 64.41, 15),
(91, 10108, 'S24_3371', 30, 60.01, 5),
(92, 10108, 'S24_3856', 40, 132, 1),
(93, 10108, 'S24_4620', 31, 67.1, 10),
(94, 10108, 'S32_2206', 27, 36.21, 13),
(95, 10108, 'S32_4485', 31, 87.76, 16),
(96, 10108, 'S50_4713', 34, 74.85, 14),
(97, 10109, 'S18_1129', 26, 117.48, 4),
(98, 10109, 'S18_1984', 38, 137.98, 3),
(99, 10109, 'S18_2870', 26, 126.72, 1),
(100, 10109, 'S18_3232', 46, 160.87, 5),
(101, 10109, 'S18_3685', 47, 125.74, 2),
(102, 10109, 'S24_2972', 29, 32.1, 6),
(103, 10110, 'S18_1589', 37, 118.22, 16),
(104, 10110, 'S18_1749', 42, 153, 7),
(105, 10110, 'S18_2248', 32, 51.46, 6),
(106, 10110, 'S18_2325', 33, 115.69, 4),
(107, 10110, 'S18_2795', 31, 163.69, 1),
(108, 10110, 'S18_4409', 28, 81.91, 8),
(109, 10110, 'S18_4933', 42, 62, 9),
(110, 10110, 'S24_1046', 36, 72.02, 13),
(111, 10110, 'S24_1628', 29, 43.27, 15),
(112, 10110, 'S24_1937', 20, 28.88, 3),
(113, 10110, 'S24_2022', 39, 40.77, 2),
(114, 10110, 'S24_2766', 43, 82.69, 11),
(115, 10110, 'S24_2887', 46, 112.74, 10),
(116, 10110, 'S24_3191', 27, 80.47, 12),
(117, 10110, 'S24_3432', 37, 96.37, 14),
(118, 10110, 'S24_3969', 48, 35.29, 5),
(119, 10111, 'S18_1342', 33, 87.33, 6),
(120, 10111, 'S18_1367', 48, 48.52, 5),
(121, 10111, 'S18_2957', 28, 53.09, 2),
(122, 10111, 'S18_3136', 43, 94.25, 1),
(123, 10111, 'S18_3320', 39, 91.27, 4),
(124, 10111, 'S24_4258', 26, 85.7, 3),
(125, 10112, 'S10_1949', 29, 197.16, 1),
(126, 10112, 'S18_2949', 23, 85.1, 2),
(127, 10113, 'S12_1666', 21, 121.64, 2),
(128, 10113, 'S18_1097', 49, 101.5, 4),
(129, 10113, 'S18_4668', 50, 43.27, 3),
(130, 10113, 'S32_3522', 23, 58.82, 1),
(131, 10114, 'S10_4962', 31, 128.53, 8),
(132, 10114, 'S18_2319', 39, 106.78, 3),
(133, 10114, 'S18_2432', 45, 53.48, 6),
(134, 10114, 'S18_3232', 48, 169.34, 4),
(135, 10114, 'S18_4600', 41, 105.34, 9),
(136, 10114, 'S24_2300', 21, 102.23, 5),
(137, 10114, 'S24_2840', 24, 28.64, 1),
(138, 10114, 'S32_1268', 32, 88.61, 7),
(139, 10114, 'S32_2509', 28, 43.83, 2),
(140, 10114, 'S700_2824', 42, 82.94, 10),
(141, 10115, 'S12_4473', 46, 111.39, 5),
(142, 10115, 'S18_2238', 46, 140.81, 4),
(143, 10115, 'S24_1444', 47, 56.64, 2),
(144, 10115, 'S24_4048', 44, 106.45, 1),
(145, 10115, 'S50_1392', 27, 100.7, 3),
(146, 10116, 'S32_3207', 27, 60.28, 1),
(147, 10117, 'S12_1108', 33, 195.33, 9),
(148, 10117, 'S12_3148', 43, 148.06, 10),
(149, 10117, 'S12_3891', 39, 173.02, 8),
(150, 10117, 'S18_3140', 26, 121.57, 5),
(151, 10117, 'S18_3259', 21, 81.68, 7),
(152, 10117, 'S18_4027', 22, 122.08, 12),
(153, 10117, 'S18_4522', 23, 73.73, 4),
(154, 10117, 'S24_2011', 41, 119.2, 3),
(155, 10117, 'S50_1514', 21, 55.65, 11),
(156, 10117, 'S700_1938', 38, 75.35, 6),
(157, 10117, 'S700_3962', 45, 89.38, 1),
(158, 10117, 'S72_3212', 50, 52.42, 2),
(159, 10118, 'S700_3505', 36, 86.15, 1),
(160, 10119, 'S10_4757', 46, 112.88, 11),
(161, 10119, 'S18_1662', 43, 151.38, 3),
(162, 10119, 'S18_3029', 21, 74.84, 9),
(163, 10119, 'S18_3856', 27, 95.28, 8),
(164, 10119, 'S24_2841', 41, 64.4, 4),
(165, 10119, 'S24_3151', 35, 72.58, 13),
(166, 10119, 'S24_3420', 20, 63.12, 5),
(167, 10119, 'S24_3816', 35, 82.18, 10),
(168, 10119, 'S24_3949', 28, 62.1, 2),
(169, 10119, 'S700_1138', 25, 57.34, 14),
(170, 10119, 'S700_2047', 29, 74.23, 7),
(171, 10119, 'S700_2610', 38, 67.22, 12),
(172, 10119, 'S700_4002', 26, 63.67, 1),
(173, 10119, 'S72_1253', 28, 40.22, 6),
(174, 10120, 'S10_2016', 29, 118.94, 3),
(175, 10120, 'S10_4698', 46, 158.8, 2),
(176, 10120, 'S18_2581', 29, 82.79, 8),
(177, 10120, 'S18_2625', 46, 57.54, 4),
(178, 10120, 'S24_1578', 35, 110.45, 1),
(179, 10120, 'S24_1785', 39, 93.01, 10),
(180, 10120, 'S24_2000', 34, 72.36, 5),
(181, 10120, 'S24_4278', 29, 71.73, 9),
(182, 10120, 'S32_1374', 22, 94.9, 6),
(183, 10120, 'S32_4289', 29, 68.79, 11),
(184, 10120, 'S50_1341', 49, 41.46, 12),
(185, 10120, 'S700_1691', 47, 91.34, 13),
(186, 10120, 'S700_2466', 24, 81.77, 15),
(187, 10120, 'S700_2834', 24, 106.79, 7),
(188, 10120, 'S700_3167', 43, 72, 14),
(189, 10121, 'S10_1678', 34, 86.13, 5),
(190, 10121, 'S12_2823', 50, 126.52, 4),
(191, 10121, 'S24_2360', 32, 58.18, 2),
(192, 10121, 'S32_4485', 25, 95.93, 3),
(193, 10121, 'S50_4713', 44, 72.41, 1),
(194, 10122, 'S12_1099', 42, 155.66, 10),
(195, 10122, 'S12_3380', 37, 113.92, 8),
(196, 10122, 'S12_3990', 32, 65.44, 11),
(197, 10122, 'S12_4675', 20, 104.8, 7),
(198, 10122, 'S18_1129', 34, 114.65, 2),
(199, 10122, 'S18_1889', 43, 62.37, 6),
(200, 10122, 'S18_1984', 31, 113.8, 1),
(201, 10122, 'S18_3232', 25, 137.17, 3),
(202, 10122, 'S18_3278', 21, 69.15, 13),
(203, 10122, 'S18_3482', 21, 133.76, 12),
(204, 10122, 'S18_3782', 35, 59.06, 16),
(205, 10122, 'S18_4721', 28, 145.82, 15),
(206, 10122, 'S24_2972', 39, 34.74, 4),
(207, 10122, 'S24_3371', 34, 50.82, 9),
(208, 10122, 'S24_3856', 43, 136.22, 5),
(209, 10122, 'S24_4620', 29, 67.1, 14),
(210, 10122, 'S32_2206', 31, 33.79, 17),
(211, 10123, 'S18_1589', 26, 120.71, 2),
(212, 10123, 'S18_2870', 46, 114.84, 3),
(213, 10123, 'S18_3685', 34, 117.26, 4),
(214, 10123, 'S24_1628', 50, 43.27, 1),
(215, 10124, 'S18_1749', 21, 153, 6),
(216, 10124, 'S18_2248', 42, 58.12, 5),
(217, 10124, 'S18_2325', 42, 111.87, 3),
(218, 10124, 'S18_4409', 36, 75.46, 7),
(219, 10124, 'S18_4933', 23, 66.28, 8),
(220, 10124, 'S24_1046', 22, 62.47, 12),
(221, 10124, 'S24_1937', 45, 30.53, 2),
(222, 10124, 'S24_2022', 22, 36.29, 1),
(223, 10124, 'S24_2766', 32, 74.51, 10),
(224, 10124, 'S24_2887', 25, 93.95, 9),
(225, 10124, 'S24_3191', 49, 76.19, 11),
(226, 10124, 'S24_3432', 43, 101.73, 13),
(227, 10124, 'S24_3969', 46, 36.11, 4),
(228, 10125, 'S18_1342', 32, 89.38, 1),
(229, 10125, 'S18_2795', 34, 138.38, 2),
(230, 10126, 'S10_1949', 38, 205.73, 11),
(231, 10126, 'S10_4962', 22, 122.62, 4),
(232, 10126, 'S12_1666', 21, 135.3, 8),
(233, 10126, 'S18_1097', 38, 116.67, 10),
(234, 10126, 'S18_1367', 42, 51.21, 17),
(235, 10126, 'S18_2432', 43, 51.05, 2),
(236, 10126, 'S18_2949', 31, 93.21, 12),
(237, 10126, 'S18_2957', 46, 61.84, 14),
(238, 10126, 'S18_3136', 30, 93.2, 13),
(239, 10126, 'S18_3320', 38, 94.25, 16),
(240, 10126, 'S18_4600', 50, 102.92, 5),
(241, 10126, 'S18_4668', 43, 47.29, 9),
(242, 10126, 'S24_2300', 27, 122.68, 1),
(243, 10126, 'S24_4258', 34, 83.76, 15),
(244, 10126, 'S32_1268', 43, 82.83, 3),
(245, 10126, 'S32_3522', 26, 62.05, 7),
(246, 10126, 'S700_2824', 45, 97.1, 6),
(247, 10127, 'S12_1108', 46, 193.25, 2),
(248, 10127, 'S12_3148', 46, 140.5, 3),
(249, 10127, 'S12_3891', 42, 169.56, 1),
(250, 10127, 'S12_4473', 24, 100.73, 11),
(251, 10127, 'S18_2238', 45, 140.81, 10),
(252, 10127, 'S18_2319', 45, 114.14, 14),
(253, 10127, 'S18_3232', 22, 149.02, 15),
(254, 10127, 'S18_4027', 25, 126.39, 5),
(255, 10127, 'S24_1444', 20, 50.86, 8),
(256, 10127, 'S24_2840', 39, 34.3, 12),
(257, 10127, 'S24_4048', 20, 107.63, 7),
(258, 10127, 'S32_2509', 45, 46.53, 13),
(259, 10127, 'S32_3207', 29, 60.9, 6),
(260, 10127, 'S50_1392', 46, 111.12, 9),
(261, 10127, 'S50_1514', 46, 55.65, 4),
(262, 10128, 'S18_3140', 41, 120.2, 2),
(263, 10128, 'S18_3259', 41, 80.67, 4),
(264, 10128, 'S18_4522', 43, 77.24, 1),
(265, 10128, 'S700_1938', 32, 72.75, 3),
(266, 10129, 'S10_4757', 33, 123.76, 2),
(267, 10129, 'S24_2011', 45, 113.06, 9),
(268, 10129, 'S24_3151', 41, 81.43, 4),
(269, 10129, 'S24_3816', 50, 76.31, 1),
(270, 10129, 'S700_1138', 31, 58.67, 5),
(271, 10129, 'S700_2610', 45, 72.28, 3),
(272, 10129, 'S700_3505', 42, 90.15, 6),
(273, 10129, 'S700_3962', 30, 94.34, 7),
(274, 10129, 'S72_3212', 32, 44.23, 8),
(275, 10130, 'S18_3029', 40, 68.82, 2),
(276, 10130, 'S18_3856', 33, 99.52, 1),
(277, 10131, 'S18_1662', 21, 141.92, 4),
(278, 10131, 'S24_2841', 35, 60.97, 5),
(279, 10131, 'S24_3420', 29, 52.6, 6),
(280, 10131, 'S24_3949', 50, 54.59, 3),
(281, 10131, 'S700_2047', 22, 76.94, 8),
(282, 10131, 'S700_2466', 40, 86.76, 1),
(283, 10131, 'S700_4002', 26, 63.67, 2),
(284, 10131, 'S72_1253', 21, 40.22, 7),
(285, 10132, 'S700_3167', 36, 80, 1),
(286, 10133, 'S18_2581', 49, 80.26, 3),
(287, 10133, 'S24_1785', 41, 109.42, 5),
(288, 10133, 'S24_4278', 46, 61.58, 4),
(289, 10133, 'S32_1374', 23, 80.91, 1),
(290, 10133, 'S32_4289', 49, 67.41, 6),
(291, 10133, 'S50_1341', 27, 37.09, 7),
(292, 10133, 'S700_1691', 24, 76.73, 8),
(293, 10133, 'S700_2834', 27, 115.09, 2),
(294, 10134, 'S10_1678', 41, 90.92, 2),
(295, 10134, 'S10_2016', 27, 116.56, 5),
(296, 10134, 'S10_4698', 31, 187.85, 4),
(297, 10134, 'S12_2823', 20, 131.04, 1),
(298, 10134, 'S18_2625', 30, 51.48, 6),
(299, 10134, 'S24_1578', 35, 94.67, 3),
(300, 10134, 'S24_2000', 43, 75.41, 7),
(301, 10135, 'S12_1099', 42, 173.17, 7),
(302, 10135, 'S12_3380', 48, 110.39, 5),
(303, 10135, 'S12_3990', 24, 72.62, 8),
(304, 10135, 'S12_4675', 29, 103.64, 4),
(305, 10135, 'S18_1889', 48, 66.99, 3),
(306, 10135, 'S18_3278', 45, 65.94, 10),
(307, 10135, 'S18_3482', 42, 139.64, 9),
(308, 10135, 'S18_3782', 45, 49.74, 13),
(309, 10135, 'S18_4721', 31, 133.92, 12),
(310, 10135, 'S24_2360', 29, 67.18, 16),
(311, 10135, 'S24_2972', 20, 34.36, 1),
(312, 10135, 'S24_3371', 27, 52.05, 6),
(313, 10135, 'S24_3856', 47, 139.03, 2),
(314, 10135, 'S24_4620', 23, 76.8, 11),
(315, 10135, 'S32_2206', 33, 38.62, 14),
(316, 10135, 'S32_4485', 30, 91.85, 17),
(317, 10135, 'S50_4713', 44, 78.92, 15),
(318, 10136, 'S18_1129', 25, 117.48, 2),
(319, 10136, 'S18_1984', 36, 120.91, 1),
(320, 10136, 'S18_3232', 41, 169.34, 3),
(321, 10137, 'S18_1589', 44, 115.73, 2),
(322, 10137, 'S18_2870', 37, 110.88, 3),
(323, 10137, 'S18_3685', 31, 118.68, 4),
(324, 10137, 'S24_1628', 26, 40.25, 1),
(325, 10138, 'S18_1749', 33, 149.6, 6),
(326, 10138, 'S18_2248', 22, 51.46, 5),
(327, 10138, 'S18_2325', 38, 114.42, 3),
(328, 10138, 'S18_4409', 47, 79.15, 7),
(329, 10138, 'S18_4933', 23, 64.86, 8),
(330, 10138, 'S24_1046', 45, 59.53, 12),
(331, 10138, 'S24_1937', 22, 33.19, 2),
(332, 10138, 'S24_2022', 33, 38.53, 1),
(333, 10138, 'S24_2766', 28, 73.6, 10),
(334, 10138, 'S24_2887', 30, 96.3, 9),
(335, 10138, 'S24_3191', 49, 77.05, 11),
(336, 10138, 'S24_3432', 21, 99.58, 13),
(337, 10138, 'S24_3969', 29, 32.82, 4),
(338, 10139, 'S18_1342', 31, 89.38, 7),
(339, 10139, 'S18_1367', 49, 52.83, 6),
(340, 10139, 'S18_2795', 41, 151.88, 8),
(341, 10139, 'S18_2949', 46, 91.18, 1),
(342, 10139, 'S18_2957', 20, 52.47, 3),
(343, 10139, 'S18_3136', 20, 101.58, 2),
(344, 10139, 'S18_3320', 30, 81.35, 5),
(345, 10139, 'S24_4258', 29, 93.49, 4),
(346, 10140, 'S10_1949', 37, 186.44, 11),
(347, 10140, 'S10_4962', 26, 131.49, 4),
(348, 10140, 'S12_1666', 38, 118.9, 8),
(349, 10140, 'S18_1097', 32, 95.67, 10),
(350, 10140, 'S18_2432', 46, 51.05, 2),
(351, 10140, 'S18_4600', 40, 100.5, 5),
(352, 10140, 'S18_4668', 29, 40.25, 9),
(353, 10140, 'S24_2300', 47, 118.84, 1),
(354, 10140, 'S32_1268', 26, 87.64, 3),
(355, 10140, 'S32_3522', 28, 62.05, 7),
(356, 10140, 'S700_2824', 36, 101.15, 6),
(357, 10141, 'S12_4473', 21, 114.95, 5),
(358, 10141, 'S18_2238', 39, 160.46, 4),
(359, 10141, 'S18_2319', 47, 103.09, 8),
(360, 10141, 'S18_3232', 34, 143.94, 9),
(361, 10141, 'S24_1444', 20, 50.86, 2),
(362, 10141, 'S24_2840', 21, 32.18, 6),
(363, 10141, 'S24_4048', 40, 104.09, 1),
(364, 10141, 'S32_2509', 24, 53.03, 7),
(365, 10141, 'S50_1392', 44, 94.92, 3),
(366, 10142, 'S12_1108', 33, 166.24, 12),
(367, 10142, 'S12_3148', 33, 140.5, 13),
(368, 10142, 'S12_3891', 46, 167.83, 11),
(369, 10142, 'S18_3140', 47, 129.76, 8),
(370, 10142, 'S18_3259', 22, 95.8, 10),
(371, 10142, 'S18_4027', 24, 122.08, 15),
(372, 10142, 'S18_4522', 24, 79.87, 7),
(373, 10142, 'S24_2011', 33, 114.29, 6),
(374, 10142, 'S24_3151', 49, 74.35, 1),
(375, 10142, 'S32_3207', 42, 60.9, 16),
(376, 10142, 'S50_1514', 42, 56.24, 14),
(377, 10142, 'S700_1138', 41, 55.34, 2),
(378, 10142, 'S700_1938', 43, 77.08, 9),
(379, 10142, 'S700_3505', 21, 92.16, 3),
(380, 10142, 'S700_3962', 38, 91.37, 4),
(381, 10142, 'S72_3212', 39, 46.96, 5),
(382, 10143, 'S10_4757', 49, 133.28, 15),
(383, 10143, 'S18_1662', 32, 126.15, 7),
(384, 10143, 'S18_3029', 46, 70.54, 13),
(385, 10143, 'S18_3856', 34, 99.52, 12),
(386, 10143, 'S24_2841', 27, 63.71, 8),
(387, 10143, 'S24_3420', 33, 59.83, 9),
(388, 10143, 'S24_3816', 23, 74.64, 14),
(389, 10143, 'S24_3949', 28, 55.96, 6),
(390, 10143, 'S50_1341', 34, 34.91, 1),
(391, 10143, 'S700_1691', 36, 86.77, 2),
(392, 10143, 'S700_2047', 26, 87.8, 11),
(393, 10143, 'S700_2466', 26, 79.78, 4),
(394, 10143, 'S700_2610', 31, 69.39, 16),
(395, 10143, 'S700_3167', 28, 70.4, 3),
(396, 10143, 'S700_4002', 34, 65.15, 5),
(397, 10143, 'S72_1253', 37, 49.66, 10),
(398, 10144, 'S32_4289', 20, 56.41, 1),
(399, 10145, 'S10_1678', 45, 76.56, 6),
(400, 10145, 'S10_2016', 37, 104.67, 9),
(401, 10145, 'S10_4698', 33, 154.93, 8),
(402, 10145, 'S12_2823', 49, 146.1, 5),
(403, 10145, 'S18_2581', 30, 71.81, 14),
(404, 10145, 'S18_2625', 30, 52.7, 10),
(405, 10145, 'S24_1578', 43, 103.68, 7),
(406, 10145, 'S24_1785', 40, 87.54, 16),
(407, 10145, 'S24_2000', 47, 63.98, 11),
(408, 10145, 'S24_2360', 27, 56.1, 3),
(409, 10145, 'S24_4278', 33, 71.73, 15),
(410, 10145, 'S32_1374', 33, 99.89, 12),
(411, 10145, 'S32_2206', 31, 39.43, 1),
(412, 10145, 'S32_4485', 27, 95.93, 4),
(413, 10145, 'S50_4713', 38, 73.22, 2),
(414, 10145, 'S700_2834', 20, 113.9, 13),
(415, 10146, 'S18_3782', 47, 60.3, 2),
(416, 10146, 'S18_4721', 29, 130.94, 1),
(417, 10147, 'S12_1099', 48, 161.49, 7),
(418, 10147, 'S12_3380', 31, 110.39, 5),
(419, 10147, 'S12_3990', 21, 74.21, 8),
(420, 10147, 'S12_4675', 33, 97.89, 4),
(421, 10147, 'S18_1889', 26, 70.84, 3),
(422, 10147, 'S18_3278', 36, 74.78, 10),
(423, 10147, 'S18_3482', 37, 129.35, 9),
(424, 10147, 'S24_2972', 25, 33.23, 1),
(425, 10147, 'S24_3371', 30, 48.98, 6),
(426, 10147, 'S24_3856', 23, 123.58, 2),
(427, 10147, 'S24_4620', 31, 72.76, 11),
(428, 10148, 'S18_1129', 23, 114.65, 13),
(429, 10148, 'S18_1589', 47, 108.26, 9),
(430, 10148, 'S18_1984', 25, 136.56, 12),
(431, 10148, 'S18_2870', 27, 113.52, 10),
(432, 10148, 'S18_3232', 32, 143.94, 14),
(433, 10148, 'S18_3685', 28, 135.63, 11),
(434, 10148, 'S18_4409', 34, 83.75, 1),
(435, 10148, 'S18_4933', 29, 66.28, 2),
(436, 10148, 'S24_1046', 25, 65.41, 6),
(437, 10148, 'S24_1628', 47, 46.29, 8),
(438, 10148, 'S24_2766', 21, 77.24, 4),
(439, 10148, 'S24_2887', 34, 115.09, 3),
(440, 10148, 'S24_3191', 31, 71.91, 5),
(441, 10148, 'S24_3432', 27, 96.37, 7),
(442, 10149, 'S18_1342', 50, 87.33, 4),
(443, 10149, 'S18_1367', 30, 48.52, 3),
(444, 10149, 'S18_1749', 34, 156.4, 11),
(445, 10149, 'S18_2248', 24, 50.85, 10),
(446, 10149, 'S18_2325', 33, 125.86, 8),
(447, 10149, 'S18_2795', 23, 167.06, 5),
(448, 10149, 'S18_3320', 42, 89.29, 2),
(449, 10149, 'S24_1937', 36, 31.2, 7),
(450, 10149, 'S24_2022', 49, 39.87, 6),
(451, 10149, 'S24_3969', 26, 38.57, 9),
(452, 10149, 'S24_4258', 20, 90.57, 1),
(453, 10150, 'S10_1949', 45, 182.16, 8),
(454, 10150, 'S10_4962', 20, 121.15, 1),
(455, 10150, 'S12_1666', 30, 135.3, 5),
(456, 10150, 'S18_1097', 34, 95.67, 7),
(457, 10150, 'S18_2949', 47, 93.21, 9),
(458, 10150, 'S18_2957', 30, 56.21, 11),
(459, 10150, 'S18_3136', 26, 97.39, 10),
(460, 10150, 'S18_4600', 49, 111.39, 2),
(461, 10150, 'S18_4668', 30, 47.29, 6),
(462, 10150, 'S32_3522', 49, 62.05, 4),
(463, 10150, 'S700_2824', 20, 95.08, 3),
(464, 10151, 'S12_4473', 24, 114.95, 3),
(465, 10151, 'S18_2238', 43, 152.27, 2),
(466, 10151, 'S18_2319', 49, 106.78, 6),
(467, 10151, 'S18_2432', 39, 58.34, 9),
(468, 10151, 'S18_3232', 21, 167.65, 7),
(469, 10151, 'S24_2300', 42, 109.9, 8),
(470, 10151, 'S24_2840', 30, 29.35, 4),
(471, 10151, 'S32_1268', 27, 84.75, 10),
(472, 10151, 'S32_2509', 41, 43.29, 5),
(473, 10151, 'S50_1392', 26, 108.81, 1),
(474, 10152, 'S18_4027', 35, 117.77, 1),
(475, 10152, 'S24_1444', 25, 49.13, 4),
(476, 10152, 'S24_4048', 23, 112.37, 3),
(477, 10152, 'S32_3207', 33, 57.17, 2),
(478, 10153, 'S12_1108', 20, 201.57, 11),
(479, 10153, 'S12_3148', 42, 128.42, 12),
(480, 10153, 'S12_3891', 49, 155.72, 10),
(481, 10153, 'S18_3140', 31, 125.66, 7),
(482, 10153, 'S18_3259', 29, 82.69, 9),
(483, 10153, 'S18_4522', 22, 82.5, 6),
(484, 10153, 'S24_2011', 40, 111.83, 5),
(485, 10153, 'S50_1514', 31, 53.31, 13),
(486, 10153, 'S700_1138', 43, 58, 1),
(487, 10153, 'S700_1938', 31, 80.55, 8),
(488, 10153, 'S700_3505', 50, 87.15, 2),
(489, 10153, 'S700_3962', 20, 85.41, 3),
(490, 10153, 'S72_3212', 50, 51.87, 4),
(491, 10154, 'S24_3151', 31, 75.23, 2),
(492, 10154, 'S700_2610', 36, 59.27, 1),
(493, 10155, 'S10_4757', 32, 129.2, 13),
(494, 10155, 'S18_1662', 38, 138.77, 5),
(495, 10155, 'S18_3029', 44, 83.44, 11),
(496, 10155, 'S18_3856', 29, 105.87, 10),
(497, 10155, 'S24_2841', 23, 62.34, 6),
(498, 10155, 'S24_3420', 34, 56.55, 7),
(499, 10155, 'S24_3816', 37, 76.31, 12),
(500, 10155, 'S24_3949', 44, 58.69, 4),
(501, 10155, 'S700_2047', 32, 89.61, 9),
(502, 10155, 'S700_2466', 20, 87.75, 2),
(503, 10155, 'S700_3167', 43, 76.8, 1),
(504, 10155, 'S700_4002', 44, 70.33, 3),
(505, 10155, 'S72_1253', 34, 49.16, 8),
(506, 10156, 'S50_1341', 20, 43.64, 1),
(507, 10156, 'S700_1691', 48, 77.64, 2),
(508, 10157, 'S18_2581', 33, 69.27, 3),
(509, 10157, 'S24_1785', 40, 89.72, 5),
(510, 10157, 'S24_4278', 33, 66.65, 4),
(511, 10157, 'S32_1374', 34, 83.91, 1),
(512, 10157, 'S32_4289', 28, 56.41, 6),
(513, 10157, 'S700_2834', 48, 109.16, 2),
(514, 10158, 'S24_2000', 22, 67.79, 1),
(515, 10159, 'S10_1678', 49, 81.35, 14),
(516, 10159, 'S10_2016', 37, 101.1, 17),
(517, 10159, 'S10_4698', 22, 170.42, 16),
(518, 10159, 'S12_1099', 41, 188.73, 2),
(519, 10159, 'S12_2823', 38, 131.04, 13),
(520, 10159, 'S12_3990', 24, 67.03, 3),
(521, 10159, 'S18_2625', 42, 51.48, 18),
(522, 10159, 'S18_3278', 21, 66.74, 5),
(523, 10159, 'S18_3482', 25, 129.35, 4),
(524, 10159, 'S18_3782', 21, 54.71, 8),
(525, 10159, 'S18_4721', 32, 142.85, 7),
(526, 10159, 'S24_1578', 44, 100.3, 15),
(527, 10159, 'S24_2360', 27, 67.18, 11),
(528, 10159, 'S24_3371', 50, 49.6, 1),
(529, 10159, 'S24_4620', 23, 80.84, 6),
(530, 10159, 'S32_2206', 35, 39.43, 9),
(531, 10159, 'S32_4485', 23, 86.74, 12),
(532, 10159, 'S50_4713', 31, 78.11, 10),
(533, 10160, 'S12_3380', 46, 96.3, 6),
(534, 10160, 'S12_4675', 50, 93.28, 5),
(535, 10160, 'S18_1889', 38, 70.84, 4),
(536, 10160, 'S18_3232', 20, 140.55, 1),
(537, 10160, 'S24_2972', 42, 30.59, 2),
(538, 10160, 'S24_3856', 35, 130.6, 3),
(539, 10161, 'S18_1129', 28, 121.72, 12),
(540, 10161, 'S18_1589', 43, 102.04, 8),
(541, 10161, 'S18_1984', 48, 139.41, 11),
(542, 10161, 'S18_2870', 23, 125.4, 9),
(543, 10161, 'S18_3685', 36, 132.8, 10),
(544, 10161, 'S18_4933', 25, 62.72, 1),
(545, 10161, 'S24_1046', 37, 73.49, 5),
(546, 10161, 'S24_1628', 23, 47.29, 7),
(547, 10161, 'S24_2766', 20, 82.69, 3),
(548, 10161, 'S24_2887', 25, 108.04, 2),
(549, 10161, 'S24_3191', 20, 72.77, 4),
(550, 10161, 'S24_3432', 30, 94.23, 6),
(551, 10162, 'S18_1342', 48, 87.33, 2),
(552, 10162, 'S18_1367', 45, 45.28, 1),
(553, 10162, 'S18_1749', 29, 141.1, 9),
(554, 10162, 'S18_2248', 27, 53.28, 8),
(555, 10162, 'S18_2325', 38, 113.15, 6),
(556, 10162, 'S18_2795', 48, 156.94, 3),
(557, 10162, 'S18_4409', 39, 86.51, 10),
(558, 10162, 'S24_1937', 37, 27.55, 5),
(559, 10162, 'S24_2022', 43, 38.98, 4),
(560, 10162, 'S24_3969', 37, 32.82, 7),
(561, 10163, 'S10_1949', 21, 212.16, 1),
(562, 10163, 'S18_2949', 31, 101.31, 2),
(563, 10163, 'S18_2957', 48, 59.96, 4),
(564, 10163, 'S18_3136', 40, 101.58, 3),
(565, 10163, 'S18_3320', 43, 80.36, 6),
(566, 10163, 'S24_4258', 42, 96.42, 5),
(567, 10164, 'S10_4962', 21, 143.31, 2),
(568, 10164, 'S12_1666', 49, 121.64, 6),
(569, 10164, 'S18_1097', 36, 103.84, 8),
(570, 10164, 'S18_4600', 45, 107.76, 3),
(571, 10164, 'S18_4668', 25, 46.29, 7),
(572, 10164, 'S32_1268', 24, 91.49, 1),
(573, 10164, 'S32_3522', 49, 57.53, 5),
(574, 10164, 'S700_2824', 39, 86.99, 4),
(575, 10165, 'S12_1108', 44, 168.32, 3),
(576, 10165, 'S12_3148', 34, 123.89, 4),
(577, 10165, 'S12_3891', 27, 152.26, 2),
(578, 10165, 'S12_4473', 48, 109.02, 12),
(579, 10165, 'S18_2238', 29, 134.26, 11),
(580, 10165, 'S18_2319', 46, 120.28, 15),
(581, 10165, 'S18_2432', 31, 60.77, 18),
(582, 10165, 'S18_3232', 47, 154.1, 16),
(583, 10165, 'S18_3259', 50, 84.71, 1),
(584, 10165, 'S18_4027', 28, 123.51, 6),
(585, 10165, 'S24_1444', 25, 46.82, 9),
(586, 10165, 'S24_2300', 32, 117.57, 17),
(587, 10165, 'S24_2840', 27, 31.12, 13),
(588, 10165, 'S24_4048', 24, 106.45, 8),
(589, 10165, 'S32_2509', 48, 50.86, 14),
(590, 10165, 'S32_3207', 44, 55.3, 7),
(591, 10165, 'S50_1392', 48, 106.49, 10),
(592, 10165, 'S50_1514', 38, 49.21, 5),
(593, 10166, 'S18_3140', 43, 136.59, 2),
(594, 10166, 'S18_4522', 26, 72.85, 1),
(595, 10166, 'S700_1938', 29, 76.22, 3),
(596, 10167, 'S10_4757', 44, 123.76, 9),
(597, 10167, 'S18_1662', 43, 141.92, 1),
(598, 10167, 'S18_3029', 46, 69.68, 7),
(599, 10167, 'S18_3856', 34, 84.7, 6),
(600, 10167, 'S24_2011', 33, 110.6, 16),
(601, 10167, 'S24_2841', 21, 54.81, 2),
(602, 10167, 'S24_3151', 20, 77, 11),
(603, 10167, 'S24_3420', 32, 64.44, 3),
(604, 10167, 'S24_3816', 29, 73.8, 8),
(605, 10167, 'S700_1138', 43, 66, 12),
(606, 10167, 'S700_2047', 29, 87.8, 5),
(607, 10167, 'S700_2610', 46, 62.16, 10),
(608, 10167, 'S700_3505', 24, 85.14, 13),
(609, 10167, 'S700_3962', 28, 83.42, 14),
(610, 10167, 'S72_1253', 40, 42.71, 4),
(611, 10167, 'S72_3212', 38, 43.68, 15),
(612, 10168, 'S10_1678', 36, 94.74, 1),
(613, 10168, 'S10_2016', 27, 97.53, 4),
(614, 10168, 'S10_4698', 20, 160.74, 3),
(615, 10168, 'S18_2581', 21, 75.19, 9),
(616, 10168, 'S18_2625', 46, 49.06, 5),
(617, 10168, 'S24_1578', 50, 103.68, 2),
(618, 10168, 'S24_1785', 49, 93.01, 11),
(619, 10168, 'S24_2000', 29, 72.36, 6),
(620, 10168, 'S24_3949', 27, 57.32, 18),
(621, 10168, 'S24_4278', 48, 68.1, 10),
(622, 10168, 'S32_1374', 28, 89.9, 7),
(623, 10168, 'S32_4289', 31, 57.78, 12),
(624, 10168, 'S50_1341', 48, 39.71, 13),
(625, 10168, 'S700_1691', 28, 91.34, 14),
(626, 10168, 'S700_2466', 31, 87.75, 16),
(627, 10168, 'S700_2834', 36, 94.92, 8),
(628, 10168, 'S700_3167', 48, 72, 15),
(629, 10168, 'S700_4002', 39, 67.37, 17),
(630, 10169, 'S12_1099', 30, 163.44, 2),
(631, 10169, 'S12_2823', 35, 126.52, 13),
(632, 10169, 'S12_3990', 36, 71.82, 3),
(633, 10169, 'S18_3278', 32, 65.13, 5),
(634, 10169, 'S18_3482', 36, 136.7, 4),
(635, 10169, 'S18_3782', 38, 52.84, 8),
(636, 10169, 'S18_4721', 33, 120.53, 7),
(637, 10169, 'S24_2360', 38, 66.49, 11),
(638, 10169, 'S24_3371', 34, 53.27, 1),
(639, 10169, 'S24_4620', 24, 77.61, 6),
(640, 10169, 'S32_2206', 26, 37.01, 9),
(641, 10169, 'S32_4485', 34, 83.68, 12),
(642, 10169, 'S50_4713', 48, 75.66, 10),
(643, 10170, 'S12_3380', 47, 116.27, 4),
(644, 10170, 'S12_4675', 41, 93.28, 3),
(645, 10170, 'S18_1889', 20, 70.07, 2),
(646, 10170, 'S24_3856', 34, 130.6, 1),
(647, 10171, 'S18_1129', 35, 134.46, 2),
(648, 10171, 'S18_1984', 35, 128.03, 1),
(649, 10171, 'S18_3232', 39, 165.95, 3),
(650, 10171, 'S24_2972', 36, 34.74, 4),
(651, 10172, 'S18_1589', 42, 109.51, 6),
(652, 10172, 'S18_2870', 39, 117.48, 7),
(653, 10172, 'S18_3685', 48, 139.87, 8),
(654, 10172, 'S24_1046', 32, 61, 3),
(655, 10172, 'S24_1628', 34, 43.27, 5),
(656, 10172, 'S24_2766', 22, 79.97, 1),
(657, 10172, 'S24_3191', 24, 77.91, 2),
(658, 10172, 'S24_3432', 22, 87.81, 4),
(659, 10173, 'S18_1342', 43, 101.71, 6),
(660, 10173, 'S18_1367', 48, 51.75, 5),
(661, 10173, 'S18_1749', 24, 168.3, 13),
(662, 10173, 'S18_2248', 26, 55.09, 12),
(663, 10173, 'S18_2325', 31, 127.13, 10),
(664, 10173, 'S18_2795', 22, 140.06, 7),
(665, 10173, 'S18_2957', 28, 56.84, 2),
(666, 10173, 'S18_3136', 31, 86.92, 1),
(667, 10173, 'S18_3320', 29, 90.28, 4),
(668, 10173, 'S18_4409', 21, 77.31, 14),
(669, 10173, 'S18_4933', 39, 58.44, 15),
(670, 10173, 'S24_1937', 31, 29.87, 9),
(671, 10173, 'S24_2022', 27, 39.42, 8),
(672, 10173, 'S24_2887', 23, 98.65, 16),
(673, 10173, 'S24_3969', 35, 35.7, 11),
(674, 10173, 'S24_4258', 22, 93.49, 3),
(675, 10174, 'S10_1949', 34, 207.87, 4),
(676, 10174, 'S12_1666', 43, 113.44, 1),
(677, 10174, 'S18_1097', 48, 108.5, 3),
(678, 10174, 'S18_2949', 46, 100.3, 5),
(679, 10174, 'S18_4668', 49, 44.27, 2),
(680, 10175, 'S10_4962', 33, 119.67, 9),
(681, 10175, 'S12_4473', 26, 109.02, 1),
(682, 10175, 'S18_2319', 48, 101.87, 4),
(683, 10175, 'S18_2432', 41, 59.55, 7),
(684, 10175, 'S18_3232', 29, 150.71, 5),
(685, 10175, 'S18_4600', 47, 102.92, 10),
(686, 10175, 'S24_2300', 28, 121.4, 6),
(687, 10175, 'S24_2840', 37, 32.18, 2),
(688, 10175, 'S32_1268', 22, 89.57, 8),
(689, 10175, 'S32_2509', 50, 50.86, 3),
(690, 10175, 'S32_3522', 29, 56.24, 12),
(691, 10175, 'S700_2824', 42, 80.92, 11),
(692, 10176, 'S12_1108', 33, 166.24, 2),
(693, 10176, 'S12_3148', 47, 145.04, 3),
(694, 10176, 'S12_3891', 50, 160.91, 1),
(695, 10176, 'S18_2238', 20, 139.17, 10),
(696, 10176, 'S18_4027', 36, 140.75, 5),
(697, 10176, 'S24_1444', 27, 55.49, 8),
(698, 10176, 'S24_4048', 29, 101.72, 7),
(699, 10176, 'S32_3207', 22, 62.14, 6),
(700, 10176, 'S50_1392', 23, 109.96, 9),
(701, 10176, 'S50_1514', 38, 52.14, 4),
(702, 10177, 'S18_3140', 23, 113.37, 9),
(703, 10177, 'S18_3259', 29, 92.77, 11),
(704, 10177, 'S18_4522', 35, 82.5, 8),
(705, 10177, 'S24_2011', 50, 115.52, 7),
(706, 10177, 'S24_3151', 45, 79.66, 2),
(707, 10177, 'S700_1138', 24, 58.67, 3),
(708, 10177, 'S700_1938', 31, 77.95, 10),
(709, 10177, 'S700_2610', 32, 64.33, 1),
(710, 10177, 'S700_3505', 44, 88.15, 4),
(711, 10177, 'S700_3962', 24, 83.42, 5),
(712, 10177, 'S72_3212', 40, 52.96, 6),
(713, 10178, 'S10_4757', 24, 131.92, 12),
(714, 10178, 'S18_1662', 42, 127.73, 4),
(715, 10178, 'S18_3029', 41, 70.54, 10),
(716, 10178, 'S18_3856', 48, 104.81, 9),
(717, 10178, 'S24_2841', 34, 67.82, 5),
(718, 10178, 'S24_3420', 27, 65.75, 6),
(719, 10178, 'S24_3816', 21, 68.77, 11),
(720, 10178, 'S24_3949', 30, 64.15, 3),
(721, 10178, 'S700_2047', 34, 86.9, 8),
(722, 10178, 'S700_2466', 22, 91.74, 1),
(723, 10178, 'S700_4002', 45, 68.11, 2),
(724, 10178, 'S72_1253', 45, 41.71, 7),
(725, 10179, 'S18_2581', 24, 82.79, 3),
(726, 10179, 'S24_1785', 47, 105.04, 5),
(727, 10179, 'S24_4278', 27, 66.65, 4),
(728, 10179, 'S32_1374', 45, 86.9, 1),
(729, 10179, 'S32_4289', 24, 63.97, 6),
(730, 10179, 'S50_1341', 34, 43.2, 7),
(731, 10179, 'S700_1691', 23, 75.81, 8),
(732, 10179, 'S700_2834', 25, 98.48, 2),
(733, 10179, 'S700_3167', 39, 80, 9),
(734, 10180, 'S10_1678', 29, 76.56, 9),
(735, 10180, 'S10_2016', 42, 99.91, 12),
(736, 10180, 'S10_4698', 41, 164.61, 11),
(737, 10180, 'S12_2823', 40, 131.04, 8),
(738, 10180, 'S18_2625', 25, 48.46, 13),
(739, 10180, 'S18_3782', 21, 59.06, 3),
(740, 10180, 'S18_4721', 44, 147.31, 2),
(741, 10180, 'S24_1578', 48, 98.05, 10),
(742, 10180, 'S24_2000', 28, 61.7, 14),
(743, 10180, 'S24_2360', 35, 60.95, 6),
(744, 10180, 'S24_4620', 28, 68.71, 1),
(745, 10180, 'S32_2206', 34, 33.39, 4),
(746, 10180, 'S32_4485', 22, 102.05, 7),
(747, 10180, 'S50_4713', 21, 74.85, 5),
(748, 10181, 'S12_1099', 27, 155.66, 14),
(749, 10181, 'S12_3380', 28, 113.92, 12),
(750, 10181, 'S12_3990', 20, 67.03, 15),
(751, 10181, 'S12_4675', 36, 107.1, 11),
(752, 10181, 'S18_1129', 44, 124.56, 6),
(753, 10181, 'S18_1589', 42, 124.44, 2),
(754, 10181, 'S18_1889', 22, 74.69, 10),
(755, 10181, 'S18_1984', 21, 129.45, 5),
(756, 10181, 'S18_2870', 27, 130.68, 3),
(757, 10181, 'S18_3232', 45, 147.33, 7),
(758, 10181, 'S18_3278', 30, 73.17, 17),
(759, 10181, 'S18_3482', 22, 120.53, 16),
(760, 10181, 'S18_3685', 39, 137.04, 4),
(761, 10181, 'S24_1628', 34, 45.28, 1),
(762, 10181, 'S24_2972', 37, 32.85, 8),
(763, 10181, 'S24_3371', 23, 54.49, 13),
(764, 10181, 'S24_3856', 25, 122.17, 9),
(765, 10182, 'S18_1342', 25, 83.22, 3),
(766, 10182, 'S18_1367', 32, 44.21, 2),
(767, 10182, 'S18_1749', 44, 159.8, 10),
(768, 10182, 'S18_2248', 38, 54.49, 9),
(769, 10182, 'S18_2325', 20, 105.52, 7),
(770, 10182, 'S18_2795', 21, 135, 4),
(771, 10182, 'S18_3320', 33, 86.31, 1),
(772, 10182, 'S18_4409', 36, 88.35, 11),
(773, 10182, 'S18_4933', 44, 61.29, 12),
(774, 10182, 'S24_1046', 47, 63.2, 16),
(775, 10182, 'S24_1937', 39, 31.86, 6),
(776, 10182, 'S24_2022', 31, 39.87, 5),
(777, 10182, 'S24_2766', 36, 87.24, 14),
(778, 10182, 'S24_2887', 20, 116.27, 13),
(779, 10182, 'S24_3191', 33, 73.62, 15),
(780, 10182, 'S24_3432', 49, 95.3, 17),
(781, 10182, 'S24_3969', 23, 34.88, 8),
(782, 10183, 'S10_1949', 23, 180.01, 8),
(783, 10183, 'S10_4962', 28, 127.06, 1),
(784, 10183, 'S12_1666', 41, 114.8, 5),
(785, 10183, 'S18_1097', 21, 108.5, 7),
(786, 10183, 'S18_2949', 37, 91.18, 9),
(787, 10183, 'S18_2957', 39, 51.22, 11),
(788, 10183, 'S18_3136', 22, 90.06, 10),
(789, 10183, 'S18_4600', 21, 118.66, 2),
(790, 10183, 'S18_4668', 40, 42.26, 6),
(791, 10183, 'S24_4258', 47, 81.81, 12),
(792, 10183, 'S32_3522', 49, 52.36, 4),
(793, 10183, 'S700_2824', 23, 85.98, 3),
(794, 10184, 'S12_4473', 37, 105.47, 6),
(795, 10184, 'S18_2238', 46, 145.72, 5),
(796, 10184, 'S18_2319', 46, 119.05, 9),
(797, 10184, 'S18_2432', 44, 60.77, 12),
(798, 10184, 'S18_3232', 28, 165.95, 10),
(799, 10184, 'S24_1444', 31, 57.22, 3),
(800, 10184, 'S24_2300', 24, 117.57, 11),
(801, 10184, 'S24_2840', 42, 30.06, 7),
(802, 10184, 'S24_4048', 49, 114.73, 2),
(803, 10184, 'S32_1268', 46, 84.75, 13),
(804, 10184, 'S32_2509', 33, 52.49, 8),
(805, 10184, 'S32_3207', 48, 59.03, 1),
(806, 10184, 'S50_1392', 45, 92.6, 4),
(807, 10185, 'S12_1108', 21, 195.33, 13),
(808, 10185, 'S12_3148', 33, 146.55, 14),
(809, 10185, 'S12_3891', 43, 147.07, 12),
(810, 10185, 'S18_3140', 28, 124.3, 9),
(811, 10185, 'S18_3259', 49, 94.79, 11),
(812, 10185, 'S18_4027', 39, 127.82, 16),
(813, 10185, 'S18_4522', 47, 87.77, 8),
(814, 10185, 'S24_2011', 30, 105.69, 7),
(815, 10185, 'S24_3151', 33, 83.2, 2),
(816, 10185, 'S50_1514', 20, 46.86, 15),
(817, 10185, 'S700_1138', 21, 64.67, 3),
(818, 10185, 'S700_1938', 30, 79.68, 10),
(819, 10185, 'S700_2610', 39, 61.44, 1),
(820, 10185, 'S700_3505', 37, 99.17, 4),
(821, 10185, 'S700_3962', 22, 93.35, 5),
(822, 10185, 'S72_3212', 28, 47.5, 6),
(823, 10186, 'S10_4757', 26, 108.8, 9),
(824, 10186, 'S18_1662', 32, 137.19, 1),
(825, 10186, 'S18_3029', 32, 73.12, 7),
(826, 10186, 'S18_3856', 46, 98.46, 6),
(827, 10186, 'S24_2841', 22, 60.29, 2),
(828, 10186, 'S24_3420', 21, 59.83, 3),
(829, 10186, 'S24_3816', 36, 68.77, 8),
(830, 10186, 'S700_2047', 24, 80.56, 5),
(831, 10186, 'S72_1253', 28, 42.71, 4),
(832, 10187, 'S18_2581', 45, 70.12, 1),
(833, 10187, 'S24_1785', 46, 96.29, 3),
(834, 10187, 'S24_3949', 43, 55.96, 10),
(835, 10187, 'S24_4278', 33, 64.48, 2),
(836, 10187, 'S32_4289', 31, 61.22, 4),
(837, 10187, 'S50_1341', 41, 39.71, 5),
(838, 10187, 'S700_1691', 34, 84.95, 6),
(839, 10187, 'S700_2466', 44, 95.73, 8),
(840, 10187, 'S700_3167', 34, 72, 7),
(841, 10187, 'S700_4002', 44, 70.33, 9),
(842, 10188, 'S10_1678', 48, 95.7, 1),
(843, 10188, 'S10_2016', 38, 111.8, 4),
(844, 10188, 'S10_4698', 45, 182.04, 3),
(845, 10188, 'S18_2625', 32, 52.09, 5),
(846, 10188, 'S24_1578', 25, 95.8, 2),
(847, 10188, 'S24_2000', 40, 61.7, 6),
(848, 10188, 'S32_1374', 44, 81.91, 7),
(849, 10188, 'S700_2834', 29, 96.11, 8),
(850, 10189, 'S12_2823', 28, 138.57, 1),
(851, 10190, 'S24_2360', 42, 58.87, 3),
(852, 10190, 'S32_2206', 46, 38.62, 1),
(853, 10190, 'S32_4485', 42, 89.8, 4),
(854, 10190, 'S50_4713', 40, 67.53, 2),
(855, 10191, 'S12_1099', 21, 155.66, 3),
(856, 10191, 'S12_3380', 40, 104.52, 1),
(857, 10191, 'S12_3990', 30, 70.22, 4),
(858, 10191, 'S18_3278', 36, 75.59, 6),
(859, 10191, 'S18_3482', 23, 119.06, 5),
(860, 10191, 'S18_3782', 43, 60.93, 9),
(861, 10191, 'S18_4721', 32, 136.9, 8),
(862, 10191, 'S24_3371', 48, 53.27, 2),
(863, 10191, 'S24_4620', 44, 77.61, 7),
(864, 10192, 'S12_4675', 27, 99.04, 16),
(865, 10192, 'S18_1129', 22, 140.12, 11),
(866, 10192, 'S18_1589', 29, 100.8, 7),
(867, 10192, 'S18_1889', 45, 70.84, 15),
(868, 10192, 'S18_1984', 47, 128.03, 10),
(869, 10192, 'S18_2870', 38, 110.88, 8),
(870, 10192, 'S18_3232', 26, 137.17, 12),
(871, 10192, 'S18_3685', 45, 125.74, 9),
(872, 10192, 'S24_1046', 37, 72.02, 4),
(873, 10192, 'S24_1628', 47, 49.3, 6),
(874, 10192, 'S24_2766', 46, 86.33, 2),
(875, 10192, 'S24_2887', 23, 112.74, 1),
(876, 10192, 'S24_2972', 30, 33.23, 13),
(877, 10192, 'S24_3191', 32, 69.34, 3),
(878, 10192, 'S24_3432', 46, 93.16, 5),
(879, 10192, 'S24_3856', 45, 112.34, 14),
(880, 10193, 'S18_1342', 28, 92.47, 7),
(881, 10193, 'S18_1367', 46, 46.36, 6),
(882, 10193, 'S18_1749', 21, 153, 14),
(883, 10193, 'S18_2248', 42, 60.54, 13),
(884, 10193, 'S18_2325', 44, 115.69, 11),
(885, 10193, 'S18_2795', 22, 143.44, 8),
(886, 10193, 'S18_2949', 28, 87.13, 1),
(887, 10193, 'S18_2957', 24, 53.09, 3),
(888, 10193, 'S18_3136', 23, 97.39, 2),
(889, 10193, 'S18_3320', 32, 79.37, 5),
(890, 10193, 'S18_4409', 24, 92.03, 15),
(891, 10193, 'S18_4933', 25, 66.28, 16),
(892, 10193, 'S24_1937', 26, 32.19, 10),
(893, 10193, 'S24_2022', 20, 44.8, 9),
(894, 10193, 'S24_3969', 22, 38.16, 12),
(895, 10193, 'S24_4258', 20, 92.52, 4),
(896, 10194, 'S10_1949', 42, 203.59, 11),
(897, 10194, 'S10_4962', 26, 134.44, 4),
(898, 10194, 'S12_1666', 38, 124.37, 8),
(899, 10194, 'S18_1097', 21, 103.84, 10),
(900, 10194, 'S18_2432', 45, 51.05, 2),
(901, 10194, 'S18_4600', 32, 113.82, 5),
(902, 10194, 'S18_4668', 41, 47.79, 9),
(903, 10194, 'S24_2300', 49, 112.46, 1),
(904, 10194, 'S32_1268', 37, 77.05, 3),
(905, 10194, 'S32_3522', 39, 61.41, 7),
(906, 10194, 'S700_2824', 26, 80.92, 6),
(907, 10195, 'S12_4473', 49, 118.5, 6),
(908, 10195, 'S18_2238', 27, 139.17, 5),
(909, 10195, 'S18_2319', 35, 112.91, 9),
(910, 10195, 'S18_3232', 50, 150.71, 10),
(911, 10195, 'S24_1444', 44, 54.33, 3),
(912, 10195, 'S24_2840', 32, 31.82, 7),
(913, 10195, 'S24_4048', 34, 95.81, 2),
(914, 10195, 'S32_2509', 32, 51.95, 8),
(915, 10195, 'S32_3207', 33, 59.03, 1),
(916, 10195, 'S50_1392', 49, 97.23, 4),
(917, 10196, 'S12_1108', 47, 203.64, 5),
(918, 10196, 'S12_3148', 24, 151.08, 6),
(919, 10196, 'S12_3891', 38, 147.07, 4),
(920, 10196, 'S18_3140', 49, 127.03, 1),
(921, 10196, 'S18_3259', 35, 81.68, 3),
(922, 10196, 'S18_4027', 27, 126.39, 8),
(923, 10196, 'S50_1514', 46, 56.82, 7),
(924, 10196, 'S700_1938', 50, 84.88, 2),
(925, 10197, 'S10_4757', 45, 118.32, 6),
(926, 10197, 'S18_3029', 46, 83.44, 4),
(927, 10197, 'S18_3856', 22, 85.75, 3),
(928, 10197, 'S18_4522', 50, 78.99, 14),
(929, 10197, 'S24_2011', 41, 109.37, 13),
(930, 10197, 'S24_3151', 47, 83.2, 8),
(931, 10197, 'S24_3816', 22, 67.93, 5),
(932, 10197, 'S700_1138', 23, 60, 9),
(933, 10197, 'S700_2047', 24, 78.75, 2),
(934, 10197, 'S700_2610', 50, 66.5, 7),
(935, 10197, 'S700_3505', 27, 100.17, 10),
(936, 10197, 'S700_3962', 35, 88.39, 11),
(937, 10197, 'S72_1253', 29, 39.73, 1),
(938, 10197, 'S72_3212', 42, 48.59, 12),
(939, 10198, 'S18_1662', 42, 149.81, 4),
(940, 10198, 'S24_2841', 48, 60.97, 5),
(941, 10198, 'S24_3420', 27, 61.81, 6),
(942, 10198, 'S24_3949', 43, 65.51, 3),
(943, 10198, 'S700_2466', 42, 94.73, 1),
(944, 10198, 'S700_4002', 40, 74.03, 2),
(945, 10199, 'S50_1341', 29, 37.97, 1),
(946, 10199, 'S700_1691', 48, 81.29, 2),
(947, 10199, 'S700_3167', 38, 70.4, 3),
(948, 10200, 'S18_2581', 28, 74.34, 3),
(949, 10200, 'S24_1785', 33, 99.57, 5),
(950, 10200, 'S24_4278', 39, 70.28, 4),
(951, 10200, 'S32_1374', 35, 80.91, 1),
(952, 10200, 'S32_4289', 27, 65.35, 6),
(953, 10200, 'S700_2834', 39, 115.09, 2),
(954, 10201, 'S10_1678', 22, 82.3, 2),
(955, 10201, 'S10_2016', 24, 116.56, 5),
(956, 10201, 'S10_4698', 49, 191.72, 4),
(957, 10201, 'S12_2823', 25, 126.52, 1),
(958, 10201, 'S18_2625', 30, 48.46, 6),
(959, 10201, 'S24_1578', 39, 93.54, 3),
(960, 10201, 'S24_2000', 25, 66.27, 7),
(961, 10202, 'S18_3782', 30, 55.33, 3),
(962, 10202, 'S18_4721', 43, 124.99, 2),
(963, 10202, 'S24_2360', 50, 56.1, 6),
(964, 10202, 'S24_4620', 50, 75.18, 1),
(965, 10202, 'S32_2206', 27, 33.39, 4),
(966, 10202, 'S32_4485', 31, 81.64, 7),
(967, 10202, 'S50_4713', 40, 79.73, 5),
(968, 10203, 'S12_1099', 20, 161.49, 8),
(969, 10203, 'S12_3380', 20, 111.57, 6),
(970, 10203, 'S12_3990', 44, 63.84, 9),
(971, 10203, 'S12_4675', 47, 115.16, 5),
(972, 10203, 'S18_1889', 45, 73.15, 4),
(973, 10203, 'S18_3232', 48, 157.49, 1),
(974, 10203, 'S18_3278', 33, 66.74, 11),
(975, 10203, 'S18_3482', 32, 127.88, 10),
(976, 10203, 'S24_2972', 21, 33.23, 2),
(977, 10203, 'S24_3371', 34, 56.94, 7),
(978, 10203, 'S24_3856', 47, 140.43, 3),
(979, 10204, 'S18_1129', 42, 114.65, 17),
(980, 10204, 'S18_1589', 40, 113.24, 13),
(981, 10204, 'S18_1749', 33, 153, 4),
(982, 10204, 'S18_1984', 38, 133.72, 16),
(983, 10204, 'S18_2248', 23, 59.33, 3),
(984, 10204, 'S18_2325', 26, 119.5, 1),
(985, 10204, 'S18_2870', 27, 106.92, 14),
(986, 10204, 'S18_3685', 35, 132.8, 15),
(987, 10204, 'S18_4409', 29, 83.75, 5),
(988, 10204, 'S18_4933', 45, 69.84, 6),
(989, 10204, 'S24_1046', 20, 69.82, 10),
(990, 10204, 'S24_1628', 45, 46.79, 12),
(991, 10204, 'S24_2766', 47, 79.06, 8),
(992, 10204, 'S24_2887', 42, 112.74, 7),
(993, 10204, 'S24_3191', 40, 84.75, 9),
(994, 10204, 'S24_3432', 48, 104.94, 11),
(995, 10204, 'S24_3969', 39, 34.88, 2),
(996, 10205, 'S18_1342', 36, 98.63, 2),
(997, 10205, 'S18_1367', 48, 45.82, 1),
(998, 10205, 'S18_2795', 40, 138.38, 3),
(999, 10205, 'S24_1937', 32, 27.88, 5),
(1000, 10205, 'S24_2022', 24, 36.74, 4),
(1001, 10206, 'S10_1949', 47, 203.59, 6),
(1002, 10206, 'S12_1666', 28, 109.34, 3),
(1003, 10206, 'S18_1097', 34, 115.5, 5),
(1004, 10206, 'S18_2949', 37, 98.27, 7),
(1005, 10206, 'S18_2957', 28, 51.84, 9),
(1006, 10206, 'S18_3136', 30, 102.63, 8),
(1007, 10206, 'S18_3320', 28, 99.21, 11),
(1008, 10206, 'S18_4668', 21, 45.78, 4),
(1009, 10206, 'S24_4258', 33, 95.44, 10),
(1010, 10206, 'S32_3522', 36, 54.94, 2),
(1011, 10206, 'S700_2824', 33, 89.01, 1),
(1012, 10207, 'S10_4962', 31, 125.58, 15),
(1013, 10207, 'S12_4473', 34, 95.99, 7),
(1014, 10207, 'S18_2238', 44, 140.81, 6),
(1015, 10207, 'S18_2319', 43, 109.23, 10),
(1016, 10207, 'S18_2432', 37, 60.77, 13),
(1017, 10207, 'S18_3232', 25, 140.55, 11),
(1018, 10207, 'S18_4027', 40, 143.62, 1),
(1019, 10207, 'S18_4600', 47, 119.87, 16),
(1020, 10207, 'S24_1444', 49, 57.8, 4),
(1021, 10207, 'S24_2300', 46, 127.79, 12),
(1022, 10207, 'S24_2840', 42, 30.76, 8),
(1023, 10207, 'S24_4048', 28, 108.82, 3),
(1024, 10207, 'S32_1268', 49, 84.75, 14),
(1025, 10207, 'S32_2509', 27, 51.95, 9),
(1026, 10207, 'S32_3207', 45, 55.3, 2),
(1027, 10207, 'S50_1392', 28, 106.49, 5),
(1028, 10208, 'S12_1108', 46, 176.63, 13),
(1029, 10208, 'S12_3148', 26, 128.42, 14),
(1030, 10208, 'S12_3891', 20, 152.26, 12),
(1031, 10208, 'S18_3140', 24, 117.47, 9),
(1032, 10208, 'S18_3259', 48, 96.81, 11),
(1033, 10208, 'S18_4522', 45, 72.85, 8),
(1034, 10208, 'S24_2011', 35, 122.89, 7),
(1035, 10208, 'S24_3151', 20, 80.54, 2),
(1036, 10208, 'S50_1514', 30, 57.99, 15),
(1037, 10208, 'S700_1138', 38, 56.67, 3),
(1038, 10208, 'S700_1938', 40, 73.62, 10),
(1039, 10208, 'S700_2610', 46, 63.61, 1),
(1040, 10208, 'S700_3505', 37, 95.16, 4),
(1041, 10208, 'S700_3962', 33, 95.34, 5),
(1042, 10208, 'S72_3212', 42, 48.05, 6),
(1043, 10209, 'S10_4757', 39, 129.2, 8),
(1044, 10209, 'S18_3029', 28, 82.58, 6),
(1045, 10209, 'S18_3856', 20, 97.4, 5),
(1046, 10209, 'S24_2841', 43, 66.45, 1),
(1047, 10209, 'S24_3420', 36, 56.55, 2),
(1048, 10209, 'S24_3816', 22, 79.67, 7),
(1049, 10209, 'S700_2047', 33, 90.52, 4),
(1050, 10209, 'S72_1253', 48, 44.2, 3),
(1051, 10210, 'S10_2016', 23, 112.99, 2),
(1052, 10210, 'S10_4698', 34, 189.79, 1),
(1053, 10210, 'S18_1662', 31, 141.92, 17),
(1054, 10210, 'S18_2581', 50, 68.43, 7),
(1055, 10210, 'S18_2625', 40, 51.48, 3),
(1056, 10210, 'S24_1785', 27, 100.67, 9),
(1057, 10210, 'S24_2000', 30, 63.22, 4),
(1058, 10210, 'S24_3949', 29, 56.64, 16),
(1059, 10210, 'S24_4278', 40, 68.1, 8),
(1060, 10210, 'S32_1374', 46, 84.91, 5),
(1061, 10210, 'S32_4289', 39, 57.1, 10),
(1062, 10210, 'S50_1341', 43, 43.2, 11),
(1063, 10210, 'S700_1691', 21, 87.69, 12),
(1064, 10210, 'S700_2466', 26, 93.74, 14),
(1065, 10210, 'S700_2834', 25, 98.48, 6),
(1066, 10210, 'S700_3167', 31, 64, 13),
(1067, 10210, 'S700_4002', 42, 60.7, 15),
(1068, 10211, 'S10_1678', 41, 90.92, 14),
(1069, 10211, 'S12_1099', 41, 171.22, 2),
(1070, 10211, 'S12_2823', 36, 126.52, 13),
(1071, 10211, 'S12_3990', 28, 79.8, 3),
(1072, 10211, 'S18_3278', 35, 73.17, 5),
(1073, 10211, 'S18_3482', 28, 138.17, 4),
(1074, 10211, 'S18_3782', 46, 60.3, 8),
(1075, 10211, 'S18_4721', 41, 148.8, 7),
(1076, 10211, 'S24_1578', 25, 109.32, 15),
(1077, 10211, 'S24_2360', 21, 62.33, 11),
(1078, 10211, 'S24_3371', 48, 52.66, 1),
(1079, 10211, 'S24_4620', 22, 80.84, 6),
(1080, 10211, 'S32_2206', 41, 39.83, 9),
(1081, 10211, 'S32_4485', 37, 94.91, 12),
(1082, 10211, 'S50_4713', 40, 70.78, 10),
(1083, 10212, 'S12_3380', 39, 99.82, 16),
(1084, 10212, 'S12_4675', 33, 110.55, 15),
(1085, 10212, 'S18_1129', 29, 117.48, 10),
(1086, 10212, 'S18_1589', 38, 105.77, 6),
(1087, 10212, 'S18_1889', 20, 64.68, 14),
(1088, 10212, 'S18_1984', 41, 133.72, 9),
(1089, 10212, 'S18_2870', 40, 117.48, 7),
(1090, 10212, 'S18_3232', 40, 155.79, 11),
(1091, 10212, 'S18_3685', 45, 115.85, 8),
(1092, 10212, 'S24_1046', 41, 61.73, 3),
(1093, 10212, 'S24_1628', 45, 43.27, 5),
(1094, 10212, 'S24_2766', 45, 81.78, 1),
(1095, 10212, 'S24_2972', 34, 37.38, 12),
(1096, 10212, 'S24_3191', 27, 77.91, 2),
(1097, 10212, 'S24_3432', 46, 100.66, 4),
(1098, 10212, 'S24_3856', 49, 117.96, 13),
(1099, 10213, 'S18_4409', 38, 84.67, 1),
(1100, 10213, 'S18_4933', 25, 58.44, 2),
(1101, 10213, 'S24_2887', 27, 97.48, 3),
(1102, 10214, 'S18_1749', 30, 166.6, 7),
(1103, 10214, 'S18_2248', 21, 53.28, 6),
(1104, 10214, 'S18_2325', 27, 125.86, 4),
(1105, 10214, 'S18_2795', 50, 167.06, 1),
(1106, 10214, 'S24_1937', 20, 32.19, 3),
(1107, 10214, 'S24_2022', 49, 39.87, 2),
(1108, 10214, 'S24_3969', 44, 38.57, 5),
(1109, 10215, 'S10_1949', 35, 205.73, 3),
(1110, 10215, 'S18_1097', 46, 100.34, 2),
(1111, 10215, 'S18_1342', 27, 92.47, 10),
(1112, 10215, 'S18_1367', 33, 53.91, 9),
(1113, 10215, 'S18_2949', 49, 97.26, 4),
(1114, 10215, 'S18_2957', 31, 56.21, 6),
(1115, 10215, 'S18_3136', 49, 89.01, 5),
(1116, 10215, 'S18_3320', 41, 84.33, 8),
(1117, 10215, 'S18_4668', 46, 42.76, 1),
(1118, 10215, 'S24_4258', 39, 94.47, 7),
(1119, 10216, 'S12_1666', 43, 133.94, 1),
(1120, 10217, 'S10_4962', 48, 132.97, 4),
(1121, 10217, 'S18_2432', 35, 58.34, 2),
(1122, 10217, 'S18_4600', 38, 118.66, 5),
(1123, 10217, 'S24_2300', 28, 103.51, 1),
(1124, 10217, 'S32_1268', 21, 78.97, 3),
(1125, 10217, 'S32_3522', 39, 56.24, 7),
(1126, 10217, 'S700_2824', 31, 90.02, 6),
(1127, 10218, 'S18_2319', 22, 110.46, 1),
(1128, 10218, 'S18_3232', 34, 152.41, 2),
(1129, 10219, 'S12_4473', 48, 94.8, 2),
(1130, 10219, 'S18_2238', 43, 132.62, 1),
(1131, 10219, 'S24_2840', 21, 31.12, 3),
(1132, 10219, 'S32_2509', 35, 47.62, 4),
(1133, 10220, 'S12_1108', 32, 189.1, 2),
(1134, 10220, 'S12_3148', 30, 151.08, 3),
(1135, 10220, 'S12_3891', 27, 166.1, 1),
(1136, 10220, 'S18_4027', 50, 126.39, 5),
(1137, 10220, 'S24_1444', 26, 48.55, 8),
(1138, 10220, 'S24_4048', 37, 101.72, 7),
(1139, 10220, 'S32_3207', 20, 49.71, 6),
(1140, 10220, 'S50_1392', 37, 92.6, 9),
(1141, 10220, 'S50_1514', 30, 56.82, 4),
(1142, 10221, 'S18_3140', 33, 133.86, 3),
(1143, 10221, 'S18_3259', 23, 89.75, 5),
(1144, 10221, 'S18_4522', 39, 84.26, 2),
(1145, 10221, 'S24_2011', 49, 113.06, 1),
(1146, 10221, 'S700_1938', 23, 69.29, 4),
(1147, 10222, 'S10_4757', 49, 133.28, 12),
(1148, 10222, 'S18_1662', 49, 137.19, 4),
(1149, 10222, 'S18_3029', 49, 79.14, 10),
(1150, 10222, 'S18_3856', 45, 88.93, 9),
(1151, 10222, 'S24_2841', 32, 56.86, 5),
(1152, 10222, 'S24_3151', 47, 74.35, 14),
(1153, 10222, 'S24_3420', 43, 61.15, 6),
(1154, 10222, 'S24_3816', 46, 77.99, 11),
(1155, 10222, 'S24_3949', 48, 55.27, 3),
(1156, 10222, 'S700_1138', 31, 58.67, 15),
(1157, 10222, 'S700_2047', 26, 80.56, 8),
(1158, 10222, 'S700_2466', 37, 90.75, 1),
(1159, 10222, 'S700_2610', 36, 69.39, 13),
(1160, 10222, 'S700_3505', 38, 84.14, 16),
(1161, 10222, 'S700_3962', 31, 81.43, 17),
(1162, 10222, 'S700_4002', 43, 66.63, 2),
(1163, 10222, 'S72_1253', 31, 45.19, 7),
(1164, 10222, 'S72_3212', 36, 48.59, 18),
(1165, 10223, 'S10_1678', 37, 80.39, 1),
(1166, 10223, 'S10_2016', 47, 110.61, 4),
(1167, 10223, 'S10_4698', 49, 189.79, 3),
(1168, 10223, 'S18_2581', 47, 67.58, 9),
(1169, 10223, 'S18_2625', 28, 58.75, 5),
(1170, 10223, 'S24_1578', 32, 104.81, 2),
(1171, 10223, 'S24_1785', 34, 87.54, 11),
(1172, 10223, 'S24_2000', 38, 60.94, 6),
(1173, 10223, 'S24_4278', 23, 68.1, 10),
(1174, 10223, 'S32_1374', 21, 90.9, 7),
(1175, 10223, 'S32_4289', 20, 66.73, 12),
(1176, 10223, 'S50_1341', 41, 41.02, 13),
(1177, 10223, 'S700_1691', 25, 84.03, 14),
(1178, 10223, 'S700_2834', 29, 113.9, 8),
(1179, 10223, 'S700_3167', 26, 79.2, 15),
(1180, 10224, 'S12_2823', 43, 141.58, 6),
(1181, 10224, 'S18_3782', 38, 57.2, 1),
(1182, 10224, 'S24_2360', 37, 60.26, 4),
(1183, 10224, 'S32_2206', 43, 37.01, 2),
(1184, 10224, 'S32_4485', 30, 94.91, 5),
(1185, 10224, 'S50_4713', 50, 81.36, 3),
(1186, 10225, 'S12_1099', 27, 157.6, 9),
(1187, 10225, 'S12_3380', 25, 101, 7),
(1188, 10225, 'S12_3990', 37, 64.64, 10),
(1189, 10225, 'S12_4675', 21, 100.19, 6),
(1190, 10225, 'S18_1129', 32, 116.06, 1),
(1191, 10225, 'S18_1889', 47, 71.61, 5),
(1192, 10225, 'S18_3232', 43, 162.57, 2),
(1193, 10225, 'S18_3278', 37, 69.96, 12),
(1194, 10225, 'S18_3482', 27, 119.06, 11),
(1195, 10225, 'S18_4721', 35, 135.41, 14),
(1196, 10225, 'S24_2972', 42, 34.74, 3),
(1197, 10225, 'S24_3371', 24, 51.43, 8),
(1198, 10225, 'S24_3856', 40, 130.6, 4),
(1199, 10225, 'S24_4620', 46, 77.61, 13),
(1200, 10226, 'S18_1589', 38, 108.26, 4),
(1201, 10226, 'S18_1984', 24, 129.45, 7),
(1202, 10226, 'S18_2870', 24, 125.4, 5),
(1203, 10226, 'S18_3685', 46, 122.91, 6),
(1204, 10226, 'S24_1046', 21, 65.41, 1),
(1205, 10226, 'S24_1628', 36, 47.79, 3),
(1206, 10226, 'S24_3432', 48, 95.3, 2),
(1207, 10227, 'S18_1342', 25, 85.27, 3),
(1208, 10227, 'S18_1367', 31, 50.14, 2),
(1209, 10227, 'S18_1749', 26, 136, 10),
(1210, 10227, 'S18_2248', 28, 59.93, 9),
(1211, 10227, 'S18_2325', 46, 118.23, 7),
(1212, 10227, 'S18_2795', 29, 146.81, 4),
(1213, 10227, 'S18_3320', 33, 99.21, 1),
(1214, 10227, 'S18_4409', 34, 87.43, 11),
(1215, 10227, 'S18_4933', 37, 70.56, 12),
(1216, 10227, 'S24_1937', 42, 27.22, 6),
(1217, 10227, 'S24_2022', 24, 39.42, 5),
(1218, 10227, 'S24_2766', 47, 84.51, 14),
(1219, 10227, 'S24_2887', 33, 102.17, 13),
(1220, 10227, 'S24_3191', 40, 78.76, 15),
(1221, 10227, 'S24_3969', 27, 34.88, 8),
(1222, 10228, 'S10_1949', 29, 214.3, 2),
(1223, 10228, 'S18_1097', 32, 100.34, 1),
(1224, 10228, 'S18_2949', 24, 101.31, 3),
(1225, 10228, 'S18_2957', 45, 57.46, 5),
(1226, 10228, 'S18_3136', 31, 100.53, 4),
(1227, 10228, 'S24_4258', 33, 84.73, 6),
(1228, 10229, 'S10_4962', 50, 138.88, 9),
(1229, 10229, 'S12_1666', 25, 110.7, 13),
(1230, 10229, 'S12_4473', 36, 95.99, 1),
(1231, 10229, 'S18_2319', 26, 104.32, 4),
(1232, 10229, 'S18_2432', 28, 53.48, 7),
(1233, 10229, 'S18_3232', 22, 157.49, 5),
(1234, 10229, 'S18_4600', 41, 119.87, 10),
(1235, 10229, 'S18_4668', 39, 43.77, 14),
(1236, 10229, 'S24_2300', 48, 115.01, 6),
(1237, 10229, 'S24_2840', 33, 34.65, 2),
(1238, 10229, 'S32_1268', 25, 78.97, 8),
(1239, 10229, 'S32_2509', 23, 49.78, 3),
(1240, 10229, 'S32_3522', 30, 52.36, 12),
(1241, 10229, 'S700_2824', 50, 91.04, 11),
(1242, 10230, 'S12_3148', 43, 128.42, 1),
(1243, 10230, 'S18_2238', 49, 153.91, 8),
(1244, 10230, 'S18_4027', 42, 142.18, 3),
(1245, 10230, 'S24_1444', 36, 47.4, 6),
(1246, 10230, 'S24_4048', 45, 99.36, 5),
(1247, 10230, 'S32_3207', 46, 59.03, 4),
(1248, 10230, 'S50_1392', 34, 100.7, 7),
(1249, 10230, 'S50_1514', 43, 57.41, 2),
(1250, 10231, 'S12_1108', 42, 193.25, 2),
(1251, 10231, 'S12_3891', 49, 147.07, 1),
(1252, 10232, 'S18_3140', 22, 133.86, 6),
(1253, 10232, 'S18_3259', 48, 97.81, 8),
(1254, 10232, 'S18_4522', 23, 78.12, 5),
(1255, 10232, 'S24_2011', 46, 113.06, 4),
(1256, 10232, 'S700_1938', 26, 84.88, 7),
(1257, 10232, 'S700_3505', 48, 86.15, 1),
(1258, 10232, 'S700_3962', 35, 81.43, 2),
(1259, 10232, 'S72_3212', 24, 48.59, 3),
(1260, 10233, 'S24_3151', 40, 70.81, 2),
(1261, 10233, 'S700_1138', 36, 66, 3),
(1262, 10233, 'S700_2610', 29, 67.94, 1),
(1263, 10234, 'S10_4757', 48, 118.32, 9),
(1264, 10234, 'S18_1662', 50, 146.65, 1),
(1265, 10234, 'S18_3029', 48, 84.3, 7),
(1266, 10234, 'S18_3856', 39, 85.75, 6),
(1267, 10234, 'S24_2841', 44, 67.14, 2),
(1268, 10234, 'S24_3420', 25, 65.09, 3),
(1269, 10234, 'S24_3816', 31, 78.83, 8),
(1270, 10234, 'S700_2047', 29, 83.28, 5),
(1271, 10234, 'S72_1253', 40, 45.69, 4),
(1272, 10235, 'S18_2581', 24, 81.95, 3),
(1273, 10235, 'S24_1785', 23, 89.72, 5),
(1274, 10235, 'S24_3949', 33, 55.27, 12),
(1275, 10235, 'S24_4278', 40, 63.03, 4),
(1276, 10235, 'S32_1374', 41, 90.9, 1),
(1277, 10235, 'S32_4289', 34, 66.73, 6),
(1278, 10235, 'S50_1341', 41, 37.09, 7),
(1279, 10235, 'S700_1691', 25, 88.6, 8),
(1280, 10235, 'S700_2466', 38, 92.74, 10),
(1281, 10235, 'S700_2834', 25, 116.28, 2),
(1282, 10235, 'S700_3167', 32, 73.6, 9),
(1283, 10235, 'S700_4002', 34, 70.33, 11),
(1284, 10236, 'S10_2016', 22, 105.86, 1),
(1285, 10236, 'S18_2625', 23, 52.7, 2),
(1286, 10236, 'S24_2000', 36, 65.51, 3),
(1287, 10237, 'S10_1678', 23, 91.87, 7),
(1288, 10237, 'S10_4698', 39, 158.8, 9),
(1289, 10237, 'S12_2823', 32, 129.53, 6);
INSERT INTO `orderdetails` (`id`, `orderNumber`, `productCode`, `quantityOrdered`, `priceEach`, `orderLineNumber`) VALUES
(1290, 10237, 'S18_3782', 26, 49.74, 1),
(1291, 10237, 'S24_1578', 20, 109.32, 8),
(1292, 10237, 'S24_2360', 26, 62.33, 4),
(1293, 10237, 'S32_2206', 26, 35, 2),
(1294, 10237, 'S32_4485', 27, 94.91, 5),
(1295, 10237, 'S50_4713', 20, 78.92, 3),
(1296, 10238, 'S12_1099', 28, 161.49, 3),
(1297, 10238, 'S12_3380', 29, 104.52, 1),
(1298, 10238, 'S12_3990', 20, 73.42, 4),
(1299, 10238, 'S18_3278', 41, 68.35, 6),
(1300, 10238, 'S18_3482', 49, 144.05, 5),
(1301, 10238, 'S18_4721', 44, 120.53, 8),
(1302, 10238, 'S24_3371', 47, 53.88, 2),
(1303, 10238, 'S24_4620', 22, 67.91, 7),
(1304, 10239, 'S12_4675', 21, 100.19, 5),
(1305, 10239, 'S18_1889', 46, 70.07, 4),
(1306, 10239, 'S18_3232', 47, 135.47, 1),
(1307, 10239, 'S24_2972', 20, 32.47, 2),
(1308, 10239, 'S24_3856', 29, 133.41, 3),
(1309, 10240, 'S18_1129', 41, 125.97, 3),
(1310, 10240, 'S18_1984', 37, 136.56, 2),
(1311, 10240, 'S18_3685', 37, 134.22, 1),
(1312, 10241, 'S18_1589', 21, 119.46, 11),
(1313, 10241, 'S18_1749', 41, 153, 2),
(1314, 10241, 'S18_2248', 33, 55.7, 1),
(1315, 10241, 'S18_2870', 44, 126.72, 12),
(1316, 10241, 'S18_4409', 42, 77.31, 3),
(1317, 10241, 'S18_4933', 30, 62.72, 4),
(1318, 10241, 'S24_1046', 22, 72.02, 8),
(1319, 10241, 'S24_1628', 21, 47.29, 10),
(1320, 10241, 'S24_2766', 47, 89.05, 6),
(1321, 10241, 'S24_2887', 28, 117.44, 5),
(1322, 10241, 'S24_3191', 26, 69.34, 7),
(1323, 10241, 'S24_3432', 27, 107.08, 9),
(1324, 10242, 'S24_3969', 46, 36.52, 1),
(1325, 10243, 'S18_2325', 47, 111.87, 2),
(1326, 10243, 'S24_1937', 33, 30.87, 1),
(1327, 10244, 'S18_1342', 40, 99.66, 7),
(1328, 10244, 'S18_1367', 20, 48.52, 6),
(1329, 10244, 'S18_2795', 43, 141.75, 8),
(1330, 10244, 'S18_2949', 30, 87.13, 1),
(1331, 10244, 'S18_2957', 24, 54.96, 3),
(1332, 10244, 'S18_3136', 29, 85.87, 2),
(1333, 10244, 'S18_3320', 36, 87.3, 5),
(1334, 10244, 'S24_2022', 39, 42.11, 9),
(1335, 10244, 'S24_4258', 40, 97.39, 4),
(1336, 10245, 'S10_1949', 34, 195.01, 9),
(1337, 10245, 'S10_4962', 28, 147.74, 2),
(1338, 10245, 'S12_1666', 38, 120.27, 6),
(1339, 10245, 'S18_1097', 29, 114.34, 8),
(1340, 10245, 'S18_4600', 21, 111.39, 3),
(1341, 10245, 'S18_4668', 45, 48.8, 7),
(1342, 10245, 'S32_1268', 37, 81.86, 1),
(1343, 10245, 'S32_3522', 44, 54.94, 5),
(1344, 10245, 'S700_2824', 44, 81.93, 4),
(1345, 10246, 'S12_4473', 46, 99.54, 5),
(1346, 10246, 'S18_2238', 40, 144.08, 4),
(1347, 10246, 'S18_2319', 22, 100.64, 8),
(1348, 10246, 'S18_2432', 30, 57.73, 11),
(1349, 10246, 'S18_3232', 36, 145.63, 9),
(1350, 10246, 'S24_1444', 44, 46.24, 2),
(1351, 10246, 'S24_2300', 29, 118.84, 10),
(1352, 10246, 'S24_2840', 49, 34.65, 6),
(1353, 10246, 'S24_4048', 46, 100.54, 1),
(1354, 10246, 'S32_2509', 35, 45.45, 7),
(1355, 10246, 'S50_1392', 22, 113.44, 3),
(1356, 10247, 'S12_1108', 44, 195.33, 2),
(1357, 10247, 'S12_3148', 25, 140.5, 3),
(1358, 10247, 'S12_3891', 27, 167.83, 1),
(1359, 10247, 'S18_4027', 48, 143.62, 5),
(1360, 10247, 'S32_3207', 40, 58.41, 6),
(1361, 10247, 'S50_1514', 49, 51.55, 4),
(1362, 10248, 'S10_4757', 20, 126.48, 3),
(1363, 10248, 'S18_3029', 21, 80.86, 1),
(1364, 10248, 'S18_3140', 32, 133.86, 12),
(1365, 10248, 'S18_3259', 42, 95.8, 14),
(1366, 10248, 'S18_4522', 42, 87.77, 11),
(1367, 10248, 'S24_2011', 48, 122.89, 10),
(1368, 10248, 'S24_3151', 30, 85.85, 5),
(1369, 10248, 'S24_3816', 23, 83.02, 2),
(1370, 10248, 'S700_1138', 36, 66, 6),
(1371, 10248, 'S700_1938', 40, 81.41, 13),
(1372, 10248, 'S700_2610', 32, 69.39, 4),
(1373, 10248, 'S700_3505', 30, 84.14, 7),
(1374, 10248, 'S700_3962', 35, 92.36, 8),
(1375, 10248, 'S72_3212', 23, 53.51, 9),
(1376, 10249, 'S18_3856', 46, 88.93, 5),
(1377, 10249, 'S24_2841', 20, 54.81, 1),
(1378, 10249, 'S24_3420', 25, 65.75, 2),
(1379, 10249, 'S700_2047', 40, 85.99, 4),
(1380, 10249, 'S72_1253', 32, 49.16, 3),
(1381, 10250, 'S18_1662', 45, 148.23, 14),
(1382, 10250, 'S18_2581', 27, 84.48, 4),
(1383, 10250, 'S24_1785', 31, 95.2, 6),
(1384, 10250, 'S24_2000', 32, 63.22, 1),
(1385, 10250, 'S24_3949', 40, 61.42, 13),
(1386, 10250, 'S24_4278', 37, 72.45, 5),
(1387, 10250, 'S32_1374', 31, 99.89, 2),
(1388, 10250, 'S32_4289', 50, 62.6, 7),
(1389, 10250, 'S50_1341', 36, 36.66, 8),
(1390, 10250, 'S700_1691', 31, 91.34, 9),
(1391, 10250, 'S700_2466', 35, 90.75, 11),
(1392, 10250, 'S700_2834', 44, 98.48, 3),
(1393, 10250, 'S700_3167', 44, 76, 10),
(1394, 10250, 'S700_4002', 38, 65.89, 12),
(1395, 10251, 'S10_1678', 59, 93.79, 2),
(1396, 10251, 'S10_2016', 44, 115.37, 5),
(1397, 10251, 'S10_4698', 43, 172.36, 4),
(1398, 10251, 'S12_2823', 46, 129.53, 1),
(1399, 10251, 'S18_2625', 44, 58.15, 6),
(1400, 10251, 'S24_1578', 50, 91.29, 3),
(1401, 10252, 'S18_3278', 20, 74.78, 2),
(1402, 10252, 'S18_3482', 41, 145.52, 1),
(1403, 10252, 'S18_3782', 31, 50.36, 5),
(1404, 10252, 'S18_4721', 26, 127.97, 4),
(1405, 10252, 'S24_2360', 47, 63.03, 8),
(1406, 10252, 'S24_4620', 38, 69.52, 3),
(1407, 10252, 'S32_2206', 36, 36.21, 6),
(1408, 10252, 'S32_4485', 25, 93.89, 9),
(1409, 10252, 'S50_4713', 48, 72.41, 7),
(1410, 10253, 'S12_1099', 24, 157.6, 13),
(1411, 10253, 'S12_3380', 22, 102.17, 11),
(1412, 10253, 'S12_3990', 25, 67.03, 14),
(1413, 10253, 'S12_4675', 41, 109.4, 10),
(1414, 10253, 'S18_1129', 26, 130.22, 5),
(1415, 10253, 'S18_1589', 24, 103.29, 1),
(1416, 10253, 'S18_1889', 23, 67.76, 9),
(1417, 10253, 'S18_1984', 33, 130.87, 4),
(1418, 10253, 'S18_2870', 37, 114.84, 2),
(1419, 10253, 'S18_3232', 40, 145.63, 6),
(1420, 10253, 'S18_3685', 31, 139.87, 3),
(1421, 10253, 'S24_2972', 40, 34.74, 7),
(1422, 10253, 'S24_3371', 24, 50.82, 12),
(1423, 10253, 'S24_3856', 39, 115.15, 8),
(1424, 10254, 'S18_1749', 49, 137.7, 5),
(1425, 10254, 'S18_2248', 36, 55.09, 4),
(1426, 10254, 'S18_2325', 41, 102.98, 2),
(1427, 10254, 'S18_4409', 34, 80.99, 6),
(1428, 10254, 'S18_4933', 30, 59.87, 7),
(1429, 10254, 'S24_1046', 34, 66.88, 11),
(1430, 10254, 'S24_1628', 32, 43.27, 13),
(1431, 10254, 'S24_1937', 38, 28.88, 1),
(1432, 10254, 'S24_2766', 31, 85.42, 9),
(1433, 10254, 'S24_2887', 33, 111.57, 8),
(1434, 10254, 'S24_3191', 42, 69.34, 10),
(1435, 10254, 'S24_3432', 49, 101.73, 12),
(1436, 10254, 'S24_3969', 20, 39.8, 3),
(1437, 10255, 'S18_2795', 24, 135, 1),
(1438, 10255, 'S24_2022', 37, 37.63, 2),
(1439, 10256, 'S18_1342', 34, 93.49, 2),
(1440, 10256, 'S18_1367', 29, 52.83, 1),
(1441, 10257, 'S18_2949', 50, 92.19, 1),
(1442, 10257, 'S18_2957', 49, 59.34, 3),
(1443, 10257, 'S18_3136', 37, 83.78, 2),
(1444, 10257, 'S18_3320', 26, 91.27, 5),
(1445, 10257, 'S24_4258', 46, 81.81, 4),
(1446, 10258, 'S10_1949', 32, 177.87, 6),
(1447, 10258, 'S12_1666', 41, 133.94, 3),
(1448, 10258, 'S18_1097', 41, 113.17, 5),
(1449, 10258, 'S18_4668', 21, 49.81, 4),
(1450, 10258, 'S32_3522', 20, 62.7, 2),
(1451, 10258, 'S700_2824', 45, 86.99, 1),
(1452, 10259, 'S10_4962', 26, 121.15, 12),
(1453, 10259, 'S12_4473', 46, 117.32, 4),
(1454, 10259, 'S18_2238', 30, 134.26, 3),
(1455, 10259, 'S18_2319', 34, 120.28, 7),
(1456, 10259, 'S18_2432', 30, 59.55, 10),
(1457, 10259, 'S18_3232', 27, 152.41, 8),
(1458, 10259, 'S18_4600', 41, 107.76, 13),
(1459, 10259, 'S24_1444', 28, 46.82, 1),
(1460, 10259, 'S24_2300', 47, 121.4, 9),
(1461, 10259, 'S24_2840', 31, 31.47, 5),
(1462, 10259, 'S32_1268', 45, 95.35, 11),
(1463, 10259, 'S32_2509', 40, 45.99, 6),
(1464, 10259, 'S50_1392', 29, 105.33, 2),
(1465, 10260, 'S12_1108', 46, 180.79, 5),
(1466, 10260, 'S12_3148', 30, 140.5, 6),
(1467, 10260, 'S12_3891', 44, 169.56, 4),
(1468, 10260, 'S18_3140', 32, 121.57, 1),
(1469, 10260, 'S18_3259', 29, 92.77, 3),
(1470, 10260, 'S18_4027', 23, 137.88, 8),
(1471, 10260, 'S24_4048', 23, 117.1, 10),
(1472, 10260, 'S32_3207', 27, 55.3, 9),
(1473, 10260, 'S50_1514', 21, 56.24, 7),
(1474, 10260, 'S700_1938', 33, 80.55, 2),
(1475, 10261, 'S10_4757', 27, 116.96, 1),
(1476, 10261, 'S18_4522', 20, 80.75, 9),
(1477, 10261, 'S24_2011', 36, 105.69, 8),
(1478, 10261, 'S24_3151', 22, 79.66, 3),
(1479, 10261, 'S700_1138', 34, 64, 4),
(1480, 10261, 'S700_2610', 44, 58.55, 2),
(1481, 10261, 'S700_3505', 25, 89.15, 5),
(1482, 10261, 'S700_3962', 50, 88.39, 6),
(1483, 10261, 'S72_3212', 29, 43.68, 7),
(1484, 10262, 'S18_1662', 49, 157.69, 9),
(1485, 10262, 'S18_3029', 32, 81.72, 15),
(1486, 10262, 'S18_3856', 34, 85.75, 14),
(1487, 10262, 'S24_1785', 34, 98.48, 1),
(1488, 10262, 'S24_2841', 24, 63.71, 10),
(1489, 10262, 'S24_3420', 46, 65.75, 11),
(1490, 10262, 'S24_3816', 49, 82.18, 16),
(1491, 10262, 'S24_3949', 48, 58.69, 8),
(1492, 10262, 'S32_4289', 40, 63.97, 2),
(1493, 10262, 'S50_1341', 49, 35.78, 3),
(1494, 10262, 'S700_1691', 40, 87.69, 4),
(1495, 10262, 'S700_2047', 44, 83.28, 13),
(1496, 10262, 'S700_2466', 33, 81.77, 6),
(1497, 10262, 'S700_3167', 27, 64.8, 5),
(1498, 10262, 'S700_4002', 35, 64.41, 7),
(1499, 10262, 'S72_1253', 21, 41.71, 12),
(1500, 10263, 'S10_1678', 34, 89, 2),
(1501, 10263, 'S10_2016', 40, 107.05, 5),
(1502, 10263, 'S10_4698', 41, 193.66, 4),
(1503, 10263, 'S12_2823', 48, 123.51, 1),
(1504, 10263, 'S18_2581', 33, 67.58, 10),
(1505, 10263, 'S18_2625', 34, 50.27, 6),
(1506, 10263, 'S24_1578', 42, 109.32, 3),
(1507, 10263, 'S24_2000', 37, 67.03, 7),
(1508, 10263, 'S24_4278', 24, 59.41, 11),
(1509, 10263, 'S32_1374', 31, 93.9, 8),
(1510, 10263, 'S700_2834', 47, 117.46, 9),
(1511, 10264, 'S18_3782', 48, 58.44, 3),
(1512, 10264, 'S18_4721', 20, 124.99, 2),
(1513, 10264, 'S24_2360', 37, 61.64, 6),
(1514, 10264, 'S24_4620', 47, 75.18, 1),
(1515, 10264, 'S32_2206', 20, 39.02, 4),
(1516, 10264, 'S32_4485', 34, 100.01, 7),
(1517, 10264, 'S50_4713', 47, 67.53, 5),
(1518, 10265, 'S18_3278', 45, 74.78, 2),
(1519, 10265, 'S18_3482', 49, 123.47, 1),
(1520, 10266, 'S12_1099', 44, 188.73, 14),
(1521, 10266, 'S12_3380', 22, 110.39, 12),
(1522, 10266, 'S12_3990', 35, 67.83, 15),
(1523, 10266, 'S12_4675', 40, 112.86, 11),
(1524, 10266, 'S18_1129', 21, 131.63, 6),
(1525, 10266, 'S18_1589', 36, 99.55, 2),
(1526, 10266, 'S18_1889', 33, 77, 10),
(1527, 10266, 'S18_1984', 49, 139.41, 5),
(1528, 10266, 'S18_2870', 20, 113.52, 3),
(1529, 10266, 'S18_3232', 29, 137.17, 7),
(1530, 10266, 'S18_3685', 33, 127.15, 4),
(1531, 10266, 'S24_1628', 28, 40.25, 1),
(1532, 10266, 'S24_2972', 34, 35.12, 8),
(1533, 10266, 'S24_3371', 47, 56.33, 13),
(1534, 10266, 'S24_3856', 24, 119.37, 9),
(1535, 10267, 'S18_4933', 36, 71.27, 1),
(1536, 10267, 'S24_1046', 40, 72.02, 5),
(1537, 10267, 'S24_2766', 38, 76.33, 3),
(1538, 10267, 'S24_2887', 43, 93.95, 2),
(1539, 10267, 'S24_3191', 44, 83.9, 4),
(1540, 10267, 'S24_3432', 43, 98.51, 6),
(1541, 10268, 'S18_1342', 49, 93.49, 3),
(1542, 10268, 'S18_1367', 26, 45.82, 2),
(1543, 10268, 'S18_1749', 34, 164.9, 10),
(1544, 10268, 'S18_2248', 31, 60.54, 9),
(1545, 10268, 'S18_2325', 50, 124.59, 7),
(1546, 10268, 'S18_2795', 35, 148.5, 4),
(1547, 10268, 'S18_3320', 39, 96.23, 1),
(1548, 10268, 'S18_4409', 35, 84.67, 11),
(1549, 10268, 'S24_1937', 33, 31.86, 6),
(1550, 10268, 'S24_2022', 40, 36.29, 5),
(1551, 10268, 'S24_3969', 30, 37.75, 8),
(1552, 10269, 'S18_2957', 32, 57.46, 1),
(1553, 10269, 'S24_4258', 48, 95.44, 2),
(1554, 10270, 'S10_1949', 21, 171.44, 9),
(1555, 10270, 'S10_4962', 32, 124.1, 2),
(1556, 10270, 'S12_1666', 28, 135.3, 6),
(1557, 10270, 'S18_1097', 43, 94.5, 8),
(1558, 10270, 'S18_2949', 31, 81.05, 10),
(1559, 10270, 'S18_3136', 38, 85.87, 11),
(1560, 10270, 'S18_4600', 38, 107.76, 3),
(1561, 10270, 'S18_4668', 44, 40.25, 7),
(1562, 10270, 'S32_1268', 32, 93.42, 1),
(1563, 10270, 'S32_3522', 21, 52.36, 5),
(1564, 10270, 'S700_2824', 46, 101.15, 4),
(1565, 10271, 'S12_4473', 31, 99.54, 5),
(1566, 10271, 'S18_2238', 50, 147.36, 4),
(1567, 10271, 'S18_2319', 50, 121.5, 8),
(1568, 10271, 'S18_2432', 25, 59.55, 11),
(1569, 10271, 'S18_3232', 20, 169.34, 9),
(1570, 10271, 'S24_1444', 45, 49.71, 2),
(1571, 10271, 'S24_2300', 43, 122.68, 10),
(1572, 10271, 'S24_2840', 38, 28.64, 6),
(1573, 10271, 'S24_4048', 22, 110, 1),
(1574, 10271, 'S32_2509', 35, 51.95, 7),
(1575, 10271, 'S50_1392', 34, 93.76, 3),
(1576, 10272, 'S12_1108', 35, 187.02, 2),
(1577, 10272, 'S12_3148', 27, 123.89, 3),
(1578, 10272, 'S12_3891', 39, 148.8, 1),
(1579, 10272, 'S18_4027', 25, 126.39, 5),
(1580, 10272, 'S32_3207', 45, 56.55, 6),
(1581, 10272, 'S50_1514', 43, 53.89, 4),
(1582, 10273, 'S10_4757', 30, 136, 4),
(1583, 10273, 'S18_3029', 34, 84.3, 2),
(1584, 10273, 'S18_3140', 40, 117.47, 13),
(1585, 10273, 'S18_3259', 47, 87.73, 15),
(1586, 10273, 'S18_3856', 50, 105.87, 1),
(1587, 10273, 'S18_4522', 33, 72.85, 12),
(1588, 10273, 'S24_2011', 22, 103.23, 11),
(1589, 10273, 'S24_3151', 27, 84.08, 6),
(1590, 10273, 'S24_3816', 48, 83.86, 3),
(1591, 10273, 'S700_1138', 21, 66, 7),
(1592, 10273, 'S700_1938', 21, 77.95, 14),
(1593, 10273, 'S700_2610', 42, 57.82, 5),
(1594, 10273, 'S700_3505', 40, 91.15, 8),
(1595, 10273, 'S700_3962', 26, 89.38, 9),
(1596, 10273, 'S72_3212', 37, 51.32, 10),
(1597, 10274, 'S18_1662', 41, 129.31, 1),
(1598, 10274, 'S24_2841', 40, 56.86, 2),
(1599, 10274, 'S24_3420', 24, 65.09, 3),
(1600, 10274, 'S700_2047', 24, 75.13, 5),
(1601, 10274, 'S72_1253', 32, 49.66, 4),
(1602, 10275, 'S10_1678', 45, 81.35, 1),
(1603, 10275, 'S10_2016', 22, 115.37, 4),
(1604, 10275, 'S10_4698', 36, 154.93, 3),
(1605, 10275, 'S18_2581', 35, 70.12, 9),
(1606, 10275, 'S18_2625', 37, 52.09, 5),
(1607, 10275, 'S24_1578', 21, 105.94, 2),
(1608, 10275, 'S24_1785', 25, 97.38, 11),
(1609, 10275, 'S24_2000', 30, 61.7, 6),
(1610, 10275, 'S24_3949', 41, 58, 18),
(1611, 10275, 'S24_4278', 27, 67.38, 10),
(1612, 10275, 'S32_1374', 23, 89.9, 7),
(1613, 10275, 'S32_4289', 28, 58.47, 12),
(1614, 10275, 'S50_1341', 38, 40.15, 13),
(1615, 10275, 'S700_1691', 32, 85.86, 14),
(1616, 10275, 'S700_2466', 39, 82.77, 16),
(1617, 10275, 'S700_2834', 48, 102.04, 8),
(1618, 10275, 'S700_3167', 43, 72, 15),
(1619, 10275, 'S700_4002', 31, 59.96, 17),
(1620, 10276, 'S12_1099', 50, 184.84, 3),
(1621, 10276, 'S12_2823', 43, 150.62, 14),
(1622, 10276, 'S12_3380', 47, 104.52, 1),
(1623, 10276, 'S12_3990', 38, 67.83, 4),
(1624, 10276, 'S18_3278', 38, 78, 6),
(1625, 10276, 'S18_3482', 30, 139.64, 5),
(1626, 10276, 'S18_3782', 33, 54.71, 9),
(1627, 10276, 'S18_4721', 48, 120.53, 8),
(1628, 10276, 'S24_2360', 46, 61.64, 12),
(1629, 10276, 'S24_3371', 20, 58.17, 2),
(1630, 10276, 'S24_4620', 48, 67.1, 7),
(1631, 10276, 'S32_2206', 27, 35.4, 10),
(1632, 10276, 'S32_4485', 38, 94.91, 13),
(1633, 10276, 'S50_4713', 21, 67.53, 11),
(1634, 10277, 'S12_4675', 28, 93.28, 1),
(1635, 10278, 'S18_1129', 34, 114.65, 6),
(1636, 10278, 'S18_1589', 23, 107.02, 2),
(1637, 10278, 'S18_1889', 29, 73.15, 10),
(1638, 10278, 'S18_1984', 29, 118.07, 5),
(1639, 10278, 'S18_2870', 39, 117.48, 3),
(1640, 10278, 'S18_3232', 42, 167.65, 7),
(1641, 10278, 'S18_3685', 31, 114.44, 4),
(1642, 10278, 'S24_1628', 35, 48.8, 1),
(1643, 10278, 'S24_2972', 31, 37.38, 8),
(1644, 10278, 'S24_3856', 25, 136.22, 9),
(1645, 10279, 'S18_4933', 26, 68.42, 1),
(1646, 10279, 'S24_1046', 32, 68.35, 5),
(1647, 10279, 'S24_2766', 49, 76.33, 3),
(1648, 10279, 'S24_2887', 48, 106.87, 2),
(1649, 10279, 'S24_3191', 33, 78.76, 4),
(1650, 10279, 'S24_3432', 48, 95.3, 6),
(1651, 10280, 'S10_1949', 34, 205.73, 2),
(1652, 10280, 'S18_1097', 24, 98, 1),
(1653, 10280, 'S18_1342', 50, 87.33, 9),
(1654, 10280, 'S18_1367', 27, 47.44, 8),
(1655, 10280, 'S18_1749', 26, 161.5, 16),
(1656, 10280, 'S18_2248', 25, 53.28, 15),
(1657, 10280, 'S18_2325', 37, 109.33, 13),
(1658, 10280, 'S18_2795', 22, 158.63, 10),
(1659, 10280, 'S18_2949', 46, 82.06, 3),
(1660, 10280, 'S18_2957', 43, 54.34, 5),
(1661, 10280, 'S18_3136', 29, 102.63, 4),
(1662, 10280, 'S18_3320', 34, 99.21, 7),
(1663, 10280, 'S18_4409', 35, 77.31, 17),
(1664, 10280, 'S24_1937', 20, 29.87, 12),
(1665, 10280, 'S24_2022', 45, 36.29, 11),
(1666, 10280, 'S24_3969', 33, 35.29, 14),
(1667, 10280, 'S24_4258', 21, 79.86, 6),
(1668, 10281, 'S10_4962', 44, 132.97, 9),
(1669, 10281, 'S12_1666', 25, 127.1, 13),
(1670, 10281, 'S12_4473', 41, 98.36, 1),
(1671, 10281, 'S18_2319', 48, 114.14, 4),
(1672, 10281, 'S18_2432', 29, 56.52, 7),
(1673, 10281, 'S18_3232', 25, 135.47, 5),
(1674, 10281, 'S18_4600', 25, 96.86, 10),
(1675, 10281, 'S18_4668', 44, 42.76, 14),
(1676, 10281, 'S24_2300', 25, 112.46, 6),
(1677, 10281, 'S24_2840', 20, 33.95, 2),
(1678, 10281, 'S32_1268', 29, 80.9, 8),
(1679, 10281, 'S32_2509', 31, 44.91, 3),
(1680, 10281, 'S32_3522', 36, 59.47, 12),
(1681, 10281, 'S700_2824', 27, 89.01, 11),
(1682, 10282, 'S12_1108', 41, 176.63, 5),
(1683, 10282, 'S12_3148', 27, 142.02, 6),
(1684, 10282, 'S12_3891', 24, 169.56, 4),
(1685, 10282, 'S18_2238', 23, 147.36, 13),
(1686, 10282, 'S18_3140', 43, 122.93, 1),
(1687, 10282, 'S18_3259', 36, 88.74, 3),
(1688, 10282, 'S18_4027', 31, 132.13, 8),
(1689, 10282, 'S24_1444', 29, 49.71, 11),
(1690, 10282, 'S24_4048', 39, 96.99, 10),
(1691, 10282, 'S32_3207', 36, 51.58, 9),
(1692, 10282, 'S50_1392', 38, 114.59, 12),
(1693, 10282, 'S50_1514', 37, 56.24, 7),
(1694, 10282, 'S700_1938', 43, 77.95, 2),
(1695, 10283, 'S10_4757', 25, 130.56, 6),
(1696, 10283, 'S18_3029', 21, 78.28, 4),
(1697, 10283, 'S18_3856', 46, 100.58, 3),
(1698, 10283, 'S18_4522', 34, 71.97, 14),
(1699, 10283, 'S24_2011', 42, 99.54, 13),
(1700, 10283, 'S24_3151', 34, 80.54, 8),
(1701, 10283, 'S24_3816', 33, 77.15, 5),
(1702, 10283, 'S700_1138', 45, 62, 9),
(1703, 10283, 'S700_2047', 20, 74.23, 2),
(1704, 10283, 'S700_2610', 47, 68.67, 7),
(1705, 10283, 'S700_3505', 22, 88.15, 10),
(1706, 10283, 'S700_3962', 38, 85.41, 11),
(1707, 10283, 'S72_1253', 43, 41.22, 1),
(1708, 10283, 'S72_3212', 33, 49.14, 12),
(1709, 10284, 'S18_1662', 45, 137.19, 11),
(1710, 10284, 'S18_2581', 31, 68.43, 1),
(1711, 10284, 'S24_1785', 22, 101.76, 3),
(1712, 10284, 'S24_2841', 30, 65.08, 12),
(1713, 10284, 'S24_3420', 39, 59.83, 13),
(1714, 10284, 'S24_3949', 21, 65.51, 10),
(1715, 10284, 'S24_4278', 21, 66.65, 2),
(1716, 10284, 'S32_4289', 50, 60.54, 4),
(1717, 10284, 'S50_1341', 33, 35.78, 5),
(1718, 10284, 'S700_1691', 24, 87.69, 6),
(1719, 10284, 'S700_2466', 45, 95.73, 8),
(1720, 10284, 'S700_3167', 25, 68, 7),
(1721, 10284, 'S700_4002', 32, 73.29, 9),
(1722, 10285, 'S10_1678', 36, 95.7, 6),
(1723, 10285, 'S10_2016', 47, 110.61, 9),
(1724, 10285, 'S10_4698', 27, 166.55, 8),
(1725, 10285, 'S12_2823', 49, 131.04, 5),
(1726, 10285, 'S18_2625', 20, 50.88, 10),
(1727, 10285, 'S24_1578', 34, 91.29, 7),
(1728, 10285, 'S24_2000', 39, 61.7, 11),
(1729, 10285, 'S24_2360', 38, 64.41, 3),
(1730, 10285, 'S32_1374', 37, 82.91, 12),
(1731, 10285, 'S32_2206', 37, 36.61, 1),
(1732, 10285, 'S32_4485', 26, 100.01, 4),
(1733, 10285, 'S50_4713', 39, 76.48, 2),
(1734, 10285, 'S700_2834', 45, 102.04, 13),
(1735, 10286, 'S18_3782', 38, 51.6, 1),
(1736, 10287, 'S12_1099', 21, 190.68, 12),
(1737, 10287, 'S12_3380', 45, 117.44, 10),
(1738, 10287, 'S12_3990', 41, 74.21, 13),
(1739, 10287, 'S12_4675', 23, 107.1, 9),
(1740, 10287, 'S18_1129', 41, 113.23, 4),
(1741, 10287, 'S18_1889', 44, 61.6, 8),
(1742, 10287, 'S18_1984', 24, 123.76, 3),
(1743, 10287, 'S18_2870', 44, 114.84, 1),
(1744, 10287, 'S18_3232', 36, 137.17, 5),
(1745, 10287, 'S18_3278', 43, 68.35, 15),
(1746, 10287, 'S18_3482', 40, 127.88, 14),
(1747, 10287, 'S18_3685', 27, 139.87, 2),
(1748, 10287, 'S18_4721', 34, 119.04, 17),
(1749, 10287, 'S24_2972', 36, 31.34, 6),
(1750, 10287, 'S24_3371', 20, 58.17, 11),
(1751, 10287, 'S24_3856', 36, 137.62, 7),
(1752, 10287, 'S24_4620', 40, 79.22, 16),
(1753, 10288, 'S18_1589', 20, 120.71, 14),
(1754, 10288, 'S18_1749', 32, 168.3, 5),
(1755, 10288, 'S18_2248', 28, 50.25, 4),
(1756, 10288, 'S18_2325', 31, 102.98, 2),
(1757, 10288, 'S18_4409', 35, 90.19, 6),
(1758, 10288, 'S18_4933', 23, 57.02, 7),
(1759, 10288, 'S24_1046', 36, 66.88, 11),
(1760, 10288, 'S24_1628', 50, 49.3, 13),
(1761, 10288, 'S24_1937', 29, 32.19, 1),
(1762, 10288, 'S24_2766', 35, 81.78, 9),
(1763, 10288, 'S24_2887', 48, 109.22, 8),
(1764, 10288, 'S24_3191', 34, 76.19, 10),
(1765, 10288, 'S24_3432', 41, 101.73, 12),
(1766, 10288, 'S24_3969', 33, 37.75, 3),
(1767, 10289, 'S18_1342', 38, 92.47, 2),
(1768, 10289, 'S18_1367', 24, 44.75, 1),
(1769, 10289, 'S18_2795', 43, 141.75, 3),
(1770, 10289, 'S24_2022', 45, 41.22, 4),
(1771, 10290, 'S18_3320', 26, 80.36, 2),
(1772, 10290, 'S24_4258', 45, 83.76, 1),
(1773, 10291, 'S10_1949', 37, 210.01, 11),
(1774, 10291, 'S10_4962', 30, 141.83, 4),
(1775, 10291, 'S12_1666', 41, 123, 8),
(1776, 10291, 'S18_1097', 41, 96.84, 10),
(1777, 10291, 'S18_2432', 26, 52.26, 2),
(1778, 10291, 'S18_2949', 47, 99.28, 12),
(1779, 10291, 'S18_2957', 37, 56.21, 14),
(1780, 10291, 'S18_3136', 23, 93.2, 13),
(1781, 10291, 'S18_4600', 48, 96.86, 5),
(1782, 10291, 'S18_4668', 29, 45.28, 9),
(1783, 10291, 'S24_2300', 48, 109.9, 1),
(1784, 10291, 'S32_1268', 26, 82.83, 3),
(1785, 10291, 'S32_3522', 32, 53, 7),
(1786, 10291, 'S700_2824', 28, 86.99, 6),
(1787, 10292, 'S12_4473', 21, 94.8, 8),
(1788, 10292, 'S18_2238', 26, 140.81, 7),
(1789, 10292, 'S18_2319', 41, 103.09, 11),
(1790, 10292, 'S18_3232', 21, 147.33, 12),
(1791, 10292, 'S18_4027', 44, 114.9, 2),
(1792, 10292, 'S24_1444', 40, 48.55, 5),
(1793, 10292, 'S24_2840', 39, 34.3, 9),
(1794, 10292, 'S24_4048', 27, 113.55, 4),
(1795, 10292, 'S32_2509', 50, 54.11, 10),
(1796, 10292, 'S32_3207', 31, 59.65, 3),
(1797, 10292, 'S50_1392', 41, 113.44, 6),
(1798, 10292, 'S50_1514', 35, 49.79, 1),
(1799, 10293, 'S12_1108', 46, 187.02, 8),
(1800, 10293, 'S12_3148', 24, 129.93, 9),
(1801, 10293, 'S12_3891', 45, 171.29, 7),
(1802, 10293, 'S18_3140', 24, 110.64, 4),
(1803, 10293, 'S18_3259', 22, 91.76, 6),
(1804, 10293, 'S18_4522', 49, 72.85, 3),
(1805, 10293, 'S24_2011', 21, 111.83, 2),
(1806, 10293, 'S700_1938', 29, 77.95, 5),
(1807, 10293, 'S72_3212', 32, 51.32, 1),
(1808, 10294, 'S700_3962', 45, 98.32, 1),
(1809, 10295, 'S10_4757', 24, 136, 1),
(1810, 10295, 'S24_3151', 46, 84.08, 3),
(1811, 10295, 'S700_1138', 26, 62, 4),
(1812, 10295, 'S700_2610', 44, 71.56, 2),
(1813, 10295, 'S700_3505', 34, 93.16, 5),
(1814, 10296, 'S18_1662', 36, 146.65, 7),
(1815, 10296, 'S18_3029', 21, 69.68, 13),
(1816, 10296, 'S18_3856', 22, 105.87, 12),
(1817, 10296, 'S24_2841', 21, 60.97, 8),
(1818, 10296, 'S24_3420', 31, 63.78, 9),
(1819, 10296, 'S24_3816', 22, 83.02, 14),
(1820, 10296, 'S24_3949', 32, 63.46, 6),
(1821, 10296, 'S50_1341', 26, 41.02, 1),
(1822, 10296, 'S700_1691', 42, 75.81, 2),
(1823, 10296, 'S700_2047', 34, 89.61, 11),
(1824, 10296, 'S700_2466', 24, 96.73, 4),
(1825, 10296, 'S700_3167', 22, 74.4, 3),
(1826, 10296, 'S700_4002', 47, 61.44, 5),
(1827, 10296, 'S72_1253', 21, 46.68, 10),
(1828, 10297, 'S18_2581', 25, 81.95, 4),
(1829, 10297, 'S24_1785', 32, 107.23, 6),
(1830, 10297, 'S24_2000', 32, 70.08, 1),
(1831, 10297, 'S24_4278', 23, 71.73, 5),
(1832, 10297, 'S32_1374', 26, 88.9, 2),
(1833, 10297, 'S32_4289', 28, 63.29, 7),
(1834, 10297, 'S700_2834', 35, 111.53, 3),
(1835, 10298, 'S10_2016', 39, 105.86, 1),
(1836, 10298, 'S18_2625', 32, 60.57, 2),
(1837, 10299, 'S10_1678', 23, 76.56, 9),
(1838, 10299, 'S10_4698', 29, 164.61, 11),
(1839, 10299, 'S12_2823', 24, 123.51, 8),
(1840, 10299, 'S18_3782', 39, 62.17, 3),
(1841, 10299, 'S18_4721', 49, 119.04, 2),
(1842, 10299, 'S24_1578', 47, 107.07, 10),
(1843, 10299, 'S24_2360', 33, 58.87, 6),
(1844, 10299, 'S24_4620', 32, 66.29, 1),
(1845, 10299, 'S32_2206', 24, 36.21, 4),
(1846, 10299, 'S32_4485', 38, 84.7, 7),
(1847, 10299, 'S50_4713', 44, 77.29, 5),
(1848, 10300, 'S12_1099', 33, 184.84, 5),
(1849, 10300, 'S12_3380', 29, 116.27, 3),
(1850, 10300, 'S12_3990', 22, 76.61, 6),
(1851, 10300, 'S12_4675', 23, 95.58, 2),
(1852, 10300, 'S18_1889', 41, 63.14, 1),
(1853, 10300, 'S18_3278', 49, 65.94, 8),
(1854, 10300, 'S18_3482', 23, 144.05, 7),
(1855, 10300, 'S24_3371', 31, 52.05, 4),
(1856, 10301, 'S18_1129', 37, 114.65, 8),
(1857, 10301, 'S18_1589', 32, 118.22, 4),
(1858, 10301, 'S18_1984', 47, 119.49, 7),
(1859, 10301, 'S18_2870', 22, 113.52, 5),
(1860, 10301, 'S18_3232', 23, 135.47, 9),
(1861, 10301, 'S18_3685', 39, 137.04, 6),
(1862, 10301, 'S24_1046', 27, 64.67, 1),
(1863, 10301, 'S24_1628', 22, 40.75, 3),
(1864, 10301, 'S24_2972', 48, 32.1, 10),
(1865, 10301, 'S24_3432', 22, 86.73, 2),
(1866, 10301, 'S24_3856', 50, 122.17, 11),
(1867, 10302, 'S18_1749', 43, 166.6, 1),
(1868, 10302, 'S18_4409', 38, 82.83, 2),
(1869, 10302, 'S18_4933', 23, 70.56, 3),
(1870, 10302, 'S24_2766', 49, 75.42, 5),
(1871, 10302, 'S24_2887', 45, 104.52, 4),
(1872, 10302, 'S24_3191', 48, 74.48, 6),
(1873, 10303, 'S18_2248', 46, 56.91, 2),
(1874, 10303, 'S24_3969', 24, 35.7, 1),
(1875, 10304, 'S10_1949', 47, 201.44, 6),
(1876, 10304, 'S12_1666', 39, 117.54, 3),
(1877, 10304, 'S18_1097', 46, 106.17, 5),
(1878, 10304, 'S18_1342', 37, 95.55, 13),
(1879, 10304, 'S18_1367', 37, 46.9, 12),
(1880, 10304, 'S18_2325', 24, 102.98, 17),
(1881, 10304, 'S18_2795', 20, 141.75, 14),
(1882, 10304, 'S18_2949', 46, 98.27, 7),
(1883, 10304, 'S18_2957', 24, 54.34, 9),
(1884, 10304, 'S18_3136', 26, 90.06, 8),
(1885, 10304, 'S18_3320', 38, 95.24, 11),
(1886, 10304, 'S18_4668', 34, 44.27, 4),
(1887, 10304, 'S24_1937', 23, 29.21, 16),
(1888, 10304, 'S24_2022', 44, 42.11, 15),
(1889, 10304, 'S24_4258', 33, 80.83, 10),
(1890, 10304, 'S32_3522', 36, 52.36, 2),
(1891, 10304, 'S700_2824', 40, 80.92, 1),
(1892, 10305, 'S10_4962', 38, 130.01, 13),
(1893, 10305, 'S12_4473', 38, 107.84, 5),
(1894, 10305, 'S18_2238', 27, 132.62, 4),
(1895, 10305, 'S18_2319', 36, 117.82, 8),
(1896, 10305, 'S18_2432', 41, 58.95, 11),
(1897, 10305, 'S18_3232', 37, 160.87, 9),
(1898, 10305, 'S18_4600', 22, 112.6, 14),
(1899, 10305, 'S24_1444', 45, 48.55, 2),
(1900, 10305, 'S24_2300', 24, 107.34, 10),
(1901, 10305, 'S24_2840', 48, 30.76, 6),
(1902, 10305, 'S24_4048', 36, 118.28, 1),
(1903, 10305, 'S32_1268', 28, 94.38, 12),
(1904, 10305, 'S32_2509', 40, 48.7, 7),
(1905, 10305, 'S50_1392', 42, 109.96, 3),
(1906, 10306, 'S12_1108', 31, 182.86, 13),
(1907, 10306, 'S12_3148', 34, 145.04, 14),
(1908, 10306, 'S12_3891', 20, 145.34, 12),
(1909, 10306, 'S18_3140', 32, 114.74, 9),
(1910, 10306, 'S18_3259', 40, 83.7, 11),
(1911, 10306, 'S18_4027', 23, 126.39, 16),
(1912, 10306, 'S18_4522', 39, 85.14, 8),
(1913, 10306, 'S24_2011', 29, 109.37, 7),
(1914, 10306, 'S24_3151', 31, 76.12, 2),
(1915, 10306, 'S32_3207', 46, 60.28, 17),
(1916, 10306, 'S50_1514', 34, 51.55, 15),
(1917, 10306, 'S700_1138', 50, 61.34, 3),
(1918, 10306, 'S700_1938', 38, 73.62, 10),
(1919, 10306, 'S700_2610', 43, 62.16, 1),
(1920, 10306, 'S700_3505', 32, 99.17, 4),
(1921, 10306, 'S700_3962', 30, 87.39, 5),
(1922, 10306, 'S72_3212', 35, 48.05, 6),
(1923, 10307, 'S10_4757', 22, 118.32, 9),
(1924, 10307, 'S18_1662', 39, 135.61, 1),
(1925, 10307, 'S18_3029', 31, 71.4, 7),
(1926, 10307, 'S18_3856', 48, 92.11, 6),
(1927, 10307, 'S24_2841', 25, 58.23, 2),
(1928, 10307, 'S24_3420', 22, 64.44, 3),
(1929, 10307, 'S24_3816', 22, 75.47, 8),
(1930, 10307, 'S700_2047', 34, 81.47, 5),
(1931, 10307, 'S72_1253', 34, 44.2, 4),
(1932, 10308, 'S10_2016', 34, 115.37, 2),
(1933, 10308, 'S10_4698', 20, 187.85, 1),
(1934, 10308, 'S18_2581', 27, 81.95, 7),
(1935, 10308, 'S18_2625', 34, 48.46, 3),
(1936, 10308, 'S24_1785', 31, 99.57, 9),
(1937, 10308, 'S24_2000', 47, 68.55, 4),
(1938, 10308, 'S24_3949', 43, 58, 16),
(1939, 10308, 'S24_4278', 44, 71.73, 8),
(1940, 10308, 'S32_1374', 24, 99.89, 5),
(1941, 10308, 'S32_4289', 46, 61.22, 10),
(1942, 10308, 'S50_1341', 47, 37.09, 11),
(1943, 10308, 'S700_1691', 21, 73.07, 12),
(1944, 10308, 'S700_2466', 35, 88.75, 14),
(1945, 10308, 'S700_2834', 31, 100.85, 6),
(1946, 10308, 'S700_3167', 21, 79.2, 13),
(1947, 10308, 'S700_4002', 39, 62.93, 15),
(1948, 10309, 'S10_1678', 41, 94.74, 5),
(1949, 10309, 'S12_2823', 26, 144.6, 4),
(1950, 10309, 'S24_1578', 21, 96.92, 6),
(1951, 10309, 'S24_2360', 24, 59.56, 2),
(1952, 10309, 'S32_4485', 50, 93.89, 3),
(1953, 10309, 'S50_4713', 28, 74.04, 1),
(1954, 10310, 'S12_1099', 33, 165.38, 10),
(1955, 10310, 'S12_3380', 24, 105.7, 8),
(1956, 10310, 'S12_3990', 49, 77.41, 11),
(1957, 10310, 'S12_4675', 25, 101.34, 7),
(1958, 10310, 'S18_1129', 37, 128.8, 2),
(1959, 10310, 'S18_1889', 20, 66.99, 6),
(1960, 10310, 'S18_1984', 24, 129.45, 1),
(1961, 10310, 'S18_3232', 48, 159.18, 3),
(1962, 10310, 'S18_3278', 27, 70.76, 13),
(1963, 10310, 'S18_3482', 49, 122, 12),
(1964, 10310, 'S18_3782', 42, 59.06, 16),
(1965, 10310, 'S18_4721', 40, 133.92, 15),
(1966, 10310, 'S24_2972', 33, 33.23, 4),
(1967, 10310, 'S24_3371', 38, 50.21, 9),
(1968, 10310, 'S24_3856', 45, 139.03, 5),
(1969, 10310, 'S24_4620', 49, 75.18, 14),
(1970, 10310, 'S32_2206', 36, 38.62, 17),
(1971, 10311, 'S18_1589', 29, 124.44, 9),
(1972, 10311, 'S18_2870', 43, 114.84, 10),
(1973, 10311, 'S18_3685', 32, 134.22, 11),
(1974, 10311, 'S18_4409', 41, 92.03, 1),
(1975, 10311, 'S18_4933', 25, 66.99, 2),
(1976, 10311, 'S24_1046', 26, 70.55, 6),
(1977, 10311, 'S24_1628', 45, 48.8, 8),
(1978, 10311, 'S24_2766', 28, 89.05, 4),
(1979, 10311, 'S24_2887', 43, 116.27, 3),
(1980, 10311, 'S24_3191', 25, 85.61, 5),
(1981, 10311, 'S24_3432', 46, 91.02, 7),
(1982, 10312, 'S10_1949', 48, 214.3, 3),
(1983, 10312, 'S18_1097', 32, 101.5, 2),
(1984, 10312, 'S18_1342', 43, 102.74, 10),
(1985, 10312, 'S18_1367', 25, 43.67, 9),
(1986, 10312, 'S18_1749', 48, 146.2, 17),
(1987, 10312, 'S18_2248', 30, 48.43, 16),
(1988, 10312, 'S18_2325', 31, 111.87, 14),
(1989, 10312, 'S18_2795', 25, 150.19, 11),
(1990, 10312, 'S18_2949', 37, 91.18, 4),
(1991, 10312, 'S18_2957', 35, 54.34, 6),
(1992, 10312, 'S18_3136', 38, 93.2, 5),
(1993, 10312, 'S18_3320', 33, 84.33, 8),
(1994, 10312, 'S18_4668', 39, 44.27, 1),
(1995, 10312, 'S24_1937', 39, 27.88, 13),
(1996, 10312, 'S24_2022', 23, 43.46, 12),
(1997, 10312, 'S24_3969', 31, 40.21, 15),
(1998, 10312, 'S24_4258', 44, 96.42, 7),
(1999, 10313, 'S10_4962', 40, 141.83, 7),
(2000, 10313, 'S12_1666', 21, 131.2, 11),
(2001, 10313, 'S18_2319', 29, 109.23, 2),
(2002, 10313, 'S18_2432', 34, 52.87, 5),
(2003, 10313, 'S18_3232', 25, 143.94, 3),
(2004, 10313, 'S18_4600', 28, 110.18, 8),
(2005, 10313, 'S24_2300', 42, 102.23, 4),
(2006, 10313, 'S32_1268', 27, 96.31, 6),
(2007, 10313, 'S32_2509', 38, 48.7, 1),
(2008, 10313, 'S32_3522', 34, 55.59, 10),
(2009, 10313, 'S700_2824', 30, 96.09, 9),
(2010, 10314, 'S12_1108', 38, 176.63, 5),
(2011, 10314, 'S12_3148', 46, 125.4, 6),
(2012, 10314, 'S12_3891', 36, 169.56, 4),
(2013, 10314, 'S12_4473', 45, 95.99, 14),
(2014, 10314, 'S18_2238', 42, 135.9, 13),
(2015, 10314, 'S18_3140', 20, 129.76, 1),
(2016, 10314, 'S18_3259', 23, 84.71, 3),
(2017, 10314, 'S18_4027', 29, 129.26, 8),
(2018, 10314, 'S24_1444', 44, 51.44, 11),
(2019, 10314, 'S24_2840', 39, 31.82, 15),
(2020, 10314, 'S24_4048', 38, 111.18, 10),
(2021, 10314, 'S32_3207', 35, 58.41, 9),
(2022, 10314, 'S50_1392', 28, 115.75, 12),
(2023, 10314, 'S50_1514', 38, 50.38, 7),
(2024, 10314, 'S700_1938', 23, 83.15, 2),
(2025, 10315, 'S18_4522', 36, 78.12, 7),
(2026, 10315, 'S24_2011', 35, 111.83, 6),
(2027, 10315, 'S24_3151', 24, 78.77, 1),
(2028, 10315, 'S700_1138', 41, 60.67, 2),
(2029, 10315, 'S700_3505', 31, 99.17, 3),
(2030, 10315, 'S700_3962', 37, 88.39, 4),
(2031, 10315, 'S72_3212', 40, 51.32, 5),
(2032, 10316, 'S10_4757', 33, 126.48, 17),
(2033, 10316, 'S18_1662', 27, 140.34, 9),
(2034, 10316, 'S18_3029', 21, 72.26, 15),
(2035, 10316, 'S18_3856', 47, 89.99, 14),
(2036, 10316, 'S24_1785', 25, 93.01, 1),
(2037, 10316, 'S24_2841', 34, 67.14, 10),
(2038, 10316, 'S24_3420', 47, 55.23, 11),
(2039, 10316, 'S24_3816', 25, 77.15, 16),
(2040, 10316, 'S24_3949', 30, 67.56, 8),
(2041, 10316, 'S32_4289', 24, 59.16, 2),
(2042, 10316, 'S50_1341', 34, 36.66, 3),
(2043, 10316, 'S700_1691', 34, 74.9, 4),
(2044, 10316, 'S700_2047', 45, 73.32, 13),
(2045, 10316, 'S700_2466', 23, 85.76, 6),
(2046, 10316, 'S700_2610', 48, 67.22, 18),
(2047, 10316, 'S700_3167', 48, 77.6, 5),
(2048, 10316, 'S700_4002', 44, 68.11, 7),
(2049, 10316, 'S72_1253', 34, 43.7, 12),
(2050, 10317, 'S24_4278', 35, 69.55, 1),
(2051, 10318, 'S10_1678', 46, 84.22, 1),
(2052, 10318, 'S10_2016', 45, 102.29, 4),
(2053, 10318, 'S10_4698', 37, 189.79, 3),
(2054, 10318, 'S18_2581', 31, 81.95, 9),
(2055, 10318, 'S18_2625', 42, 49.67, 5),
(2056, 10318, 'S24_1578', 48, 93.54, 2),
(2057, 10318, 'S24_2000', 26, 60.94, 6),
(2058, 10318, 'S32_1374', 47, 81.91, 7),
(2059, 10318, 'S700_2834', 50, 102.04, 8),
(2060, 10319, 'S12_2823', 30, 134.05, 9),
(2061, 10319, 'S18_3278', 46, 77.19, 1),
(2062, 10319, 'S18_3782', 44, 54.71, 4),
(2063, 10319, 'S18_4721', 45, 120.53, 3),
(2064, 10319, 'S24_2360', 31, 65.8, 7),
(2065, 10319, 'S24_4620', 43, 78.41, 2),
(2066, 10319, 'S32_2206', 29, 35, 5),
(2067, 10319, 'S32_4485', 22, 96.95, 8),
(2068, 10319, 'S50_4713', 45, 79.73, 6),
(2069, 10320, 'S12_1099', 31, 184.84, 3),
(2070, 10320, 'S12_3380', 35, 102.17, 1),
(2071, 10320, 'S12_3990', 38, 63.84, 4),
(2072, 10320, 'S18_3482', 25, 139.64, 5),
(2073, 10320, 'S24_3371', 26, 60.62, 2),
(2074, 10321, 'S12_4675', 24, 105.95, 15),
(2075, 10321, 'S18_1129', 41, 123.14, 10),
(2076, 10321, 'S18_1589', 44, 120.71, 6),
(2077, 10321, 'S18_1889', 37, 73.92, 14),
(2078, 10321, 'S18_1984', 25, 142.25, 9),
(2079, 10321, 'S18_2870', 27, 126.72, 7),
(2080, 10321, 'S18_3232', 33, 164.26, 11),
(2081, 10321, 'S18_3685', 28, 138.45, 8),
(2082, 10321, 'S24_1046', 30, 68.35, 3),
(2083, 10321, 'S24_1628', 48, 42.76, 5),
(2084, 10321, 'S24_2766', 30, 74.51, 1),
(2085, 10321, 'S24_2972', 37, 31.72, 12),
(2086, 10321, 'S24_3191', 39, 81.33, 2),
(2087, 10321, 'S24_3432', 21, 103.87, 4),
(2088, 10321, 'S24_3856', 26, 137.62, 13),
(2089, 10322, 'S10_1949', 40, 180.01, 1),
(2090, 10322, 'S10_4962', 46, 141.83, 8),
(2091, 10322, 'S12_1666', 27, 136.67, 9),
(2092, 10322, 'S18_1097', 22, 101.5, 10),
(2093, 10322, 'S18_1342', 43, 92.47, 14),
(2094, 10322, 'S18_1367', 41, 44.21, 5),
(2095, 10322, 'S18_2325', 50, 120.77, 6),
(2096, 10322, 'S18_2432', 35, 57.12, 11),
(2097, 10322, 'S18_2795', 36, 158.63, 2),
(2098, 10322, 'S18_2949', 33, 100.3, 12),
(2099, 10322, 'S18_2957', 41, 54.34, 13),
(2100, 10322, 'S18_3136', 48, 90.06, 7),
(2101, 10322, 'S24_1937', 20, 26.55, 3),
(2102, 10322, 'S24_2022', 30, 40.77, 4),
(2103, 10323, 'S18_3320', 33, 88.3, 2),
(2104, 10323, 'S18_4600', 47, 96.86, 1),
(2105, 10324, 'S12_3148', 27, 148.06, 1),
(2106, 10324, 'S12_4473', 26, 100.73, 7),
(2107, 10324, 'S18_2238', 47, 142.45, 8),
(2108, 10324, 'S18_2319', 33, 105.55, 10),
(2109, 10324, 'S18_3232', 27, 137.17, 12),
(2110, 10324, 'S18_4027', 49, 120.64, 13),
(2111, 10324, 'S18_4668', 38, 49.81, 6),
(2112, 10324, 'S24_1444', 25, 49.71, 14),
(2113, 10324, 'S24_2300', 31, 107.34, 2),
(2114, 10324, 'S24_2840', 30, 29.35, 9),
(2115, 10324, 'S24_4258', 33, 95.44, 3),
(2116, 10324, 'S32_1268', 20, 91.49, 11),
(2117, 10324, 'S32_3522', 48, 60.76, 4),
(2118, 10324, 'S700_2824', 34, 80.92, 5),
(2119, 10325, 'S10_4757', 47, 111.52, 6),
(2120, 10325, 'S12_1108', 42, 193.25, 8),
(2121, 10325, 'S12_3891', 24, 166.1, 1),
(2122, 10325, 'S18_3140', 24, 114.74, 9),
(2123, 10325, 'S24_4048', 44, 114.73, 5),
(2124, 10325, 'S32_2509', 38, 44.37, 3),
(2125, 10325, 'S32_3207', 28, 55.3, 2),
(2126, 10325, 'S50_1392', 38, 99.55, 4),
(2127, 10325, 'S50_1514', 44, 56.24, 7),
(2128, 10326, 'S18_3259', 32, 94.79, 6),
(2129, 10326, 'S18_4522', 50, 73.73, 5),
(2130, 10326, 'S24_2011', 41, 120.43, 4),
(2131, 10326, 'S24_3151', 41, 86.74, 3),
(2132, 10326, 'S24_3816', 20, 81.34, 2),
(2133, 10326, 'S700_1138', 39, 60.67, 1),
(2134, 10327, 'S18_1662', 25, 154.54, 6),
(2135, 10327, 'S18_2581', 45, 74.34, 8),
(2136, 10327, 'S18_3029', 25, 74.84, 5),
(2137, 10327, 'S700_1938', 20, 79.68, 7),
(2138, 10327, 'S700_2610', 21, 65.05, 1),
(2139, 10327, 'S700_3505', 43, 85.14, 2),
(2140, 10327, 'S700_3962', 37, 83.42, 3),
(2141, 10327, 'S72_3212', 37, 48.05, 4),
(2142, 10328, 'S18_3856', 34, 104.81, 6),
(2143, 10328, 'S24_1785', 47, 87.54, 14),
(2144, 10328, 'S24_2841', 48, 67.82, 1),
(2145, 10328, 'S24_3420', 20, 56.55, 2),
(2146, 10328, 'S24_3949', 35, 55.96, 3),
(2147, 10328, 'S24_4278', 43, 69.55, 4),
(2148, 10328, 'S32_4289', 24, 57.1, 5),
(2149, 10328, 'S50_1341', 34, 42.33, 7),
(2150, 10328, 'S700_1691', 27, 84.03, 8),
(2151, 10328, 'S700_2047', 41, 75.13, 9),
(2152, 10328, 'S700_2466', 37, 95.73, 10),
(2153, 10328, 'S700_2834', 33, 117.46, 11),
(2154, 10328, 'S700_3167', 33, 71.2, 13),
(2155, 10328, 'S700_4002', 39, 69.59, 12),
(2156, 10329, 'S10_1678', 42, 80.39, 1),
(2157, 10329, 'S10_2016', 20, 109.42, 2),
(2158, 10329, 'S10_4698', 26, 164.61, 3),
(2159, 10329, 'S12_1099', 41, 182.9, 5),
(2160, 10329, 'S12_2823', 24, 128.03, 6),
(2161, 10329, 'S12_3380', 46, 117.44, 13),
(2162, 10329, 'S12_3990', 33, 74.21, 14),
(2163, 10329, 'S12_4675', 39, 102.49, 15),
(2164, 10329, 'S18_1889', 29, 66.22, 9),
(2165, 10329, 'S18_2625', 38, 55.72, 12),
(2166, 10329, 'S18_3278', 38, 65.13, 10),
(2167, 10329, 'S24_1578', 30, 104.81, 7),
(2168, 10329, 'S24_2000', 37, 71.6, 4),
(2169, 10329, 'S32_1374', 45, 80.91, 11),
(2170, 10329, 'S72_1253', 44, 41.22, 8),
(2171, 10330, 'S18_3482', 37, 136.7, 3),
(2172, 10330, 'S18_3782', 29, 59.06, 2),
(2173, 10330, 'S18_4721', 50, 133.92, 4),
(2174, 10330, 'S24_2360', 42, 56.1, 1),
(2175, 10331, 'S18_1129', 46, 120.31, 6),
(2176, 10331, 'S18_1589', 44, 99.55, 14),
(2177, 10331, 'S18_1749', 44, 154.7, 7),
(2178, 10331, 'S18_1984', 30, 135.14, 8),
(2179, 10331, 'S18_2870', 26, 130.68, 10),
(2180, 10331, 'S18_3232', 27, 169.34, 11),
(2181, 10331, 'S18_3685', 26, 132.8, 12),
(2182, 10331, 'S24_2972', 27, 37, 13),
(2183, 10331, 'S24_3371', 25, 55.11, 9),
(2184, 10331, 'S24_3856', 21, 139.03, 1),
(2185, 10331, 'S24_4620', 41, 70.33, 2),
(2186, 10331, 'S32_2206', 28, 33.39, 3),
(2187, 10331, 'S32_4485', 32, 100.01, 4),
(2188, 10331, 'S50_4713', 20, 74.04, 5),
(2189, 10332, 'S18_1342', 46, 89.38, 15),
(2190, 10332, 'S18_1367', 27, 51.21, 16),
(2191, 10332, 'S18_2248', 38, 53.88, 9),
(2192, 10332, 'S18_2325', 35, 116.96, 8),
(2193, 10332, 'S18_2795', 24, 138.38, 1),
(2194, 10332, 'S18_2957', 26, 53.09, 17),
(2195, 10332, 'S18_3136', 40, 100.53, 18),
(2196, 10332, 'S18_4409', 50, 92.03, 2),
(2197, 10332, 'S18_4933', 21, 70.56, 3),
(2198, 10332, 'S24_1046', 23, 61.73, 4),
(2199, 10332, 'S24_1628', 20, 47.29, 5),
(2200, 10332, 'S24_1937', 45, 29.87, 6),
(2201, 10332, 'S24_2022', 26, 43.01, 10),
(2202, 10332, 'S24_2766', 39, 84.51, 7),
(2203, 10332, 'S24_2887', 44, 108.04, 11),
(2204, 10332, 'S24_3191', 45, 77.91, 12),
(2205, 10332, 'S24_3432', 31, 94.23, 13),
(2206, 10332, 'S24_3969', 41, 34.47, 14),
(2207, 10333, 'S10_1949', 26, 188.58, 3),
(2208, 10333, 'S12_1666', 33, 121.64, 6),
(2209, 10333, 'S18_1097', 29, 110.84, 7),
(2210, 10333, 'S18_2949', 31, 95.23, 5),
(2211, 10333, 'S18_3320', 46, 95.24, 2),
(2212, 10333, 'S18_4668', 24, 42.26, 8),
(2213, 10333, 'S24_4258', 39, 95.44, 1),
(2214, 10333, 'S32_3522', 33, 62.05, 4),
(2215, 10334, 'S10_4962', 26, 130.01, 2),
(2216, 10334, 'S18_2319', 46, 108, 6),
(2217, 10334, 'S18_2432', 34, 52.87, 1),
(2218, 10334, 'S18_3232', 20, 147.33, 3),
(2219, 10334, 'S18_4600', 49, 101.71, 4),
(2220, 10334, 'S24_2300', 42, 117.57, 5),
(2221, 10335, 'S24_2840', 33, 32.88, 2),
(2222, 10335, 'S32_1268', 44, 77.05, 1),
(2223, 10335, 'S32_2509', 40, 49.78, 3),
(2224, 10336, 'S12_1108', 33, 176.63, 10),
(2225, 10336, 'S12_3148', 33, 126.91, 11),
(2226, 10336, 'S12_3891', 49, 141.88, 1),
(2227, 10336, 'S12_4473', 38, 95.99, 3),
(2228, 10336, 'S18_2238', 49, 153.91, 6),
(2229, 10336, 'S18_3140', 48, 135.22, 12),
(2230, 10336, 'S18_3259', 21, 100.84, 7),
(2231, 10336, 'S24_1444', 45, 49.71, 4),
(2232, 10336, 'S24_4048', 31, 113.55, 5),
(2233, 10336, 'S32_3207', 31, 59.03, 9),
(2234, 10336, 'S50_1392', 23, 109.96, 8),
(2235, 10336, 'S700_2824', 46, 94.07, 2),
(2236, 10337, 'S10_4757', 25, 131.92, 8),
(2237, 10337, 'S18_4027', 36, 140.75, 3),
(2238, 10337, 'S18_4522', 29, 76.36, 2),
(2239, 10337, 'S24_2011', 29, 119.2, 4),
(2240, 10337, 'S50_1514', 21, 54.48, 6),
(2241, 10337, 'S700_1938', 36, 73.62, 9),
(2242, 10337, 'S700_3505', 31, 84.14, 1),
(2243, 10337, 'S700_3962', 36, 83.42, 7),
(2244, 10337, 'S72_3212', 42, 49.14, 5),
(2245, 10338, 'S18_1662', 41, 137.19, 1),
(2246, 10338, 'S18_3029', 28, 80.86, 3),
(2247, 10338, 'S18_3856', 45, 93.17, 2),
(2248, 10339, 'S10_2016', 40, 117.75, 4),
(2249, 10339, 'S10_4698', 39, 178.17, 3),
(2250, 10339, 'S18_2581', 27, 79.41, 2),
(2251, 10339, 'S18_2625', 30, 48.46, 1),
(2252, 10339, 'S24_1578', 27, 96.92, 10),
(2253, 10339, 'S24_1785', 21, 106.14, 7),
(2254, 10339, 'S24_2841', 55, 67.82, 12),
(2255, 10339, 'S24_3151', 55, 73.46, 13),
(2256, 10339, 'S24_3420', 29, 57.86, 14),
(2257, 10339, 'S24_3816', 42, 72.96, 16),
(2258, 10339, 'S24_3949', 45, 57.32, 11),
(2259, 10339, 'S700_1138', 22, 53.34, 5),
(2260, 10339, 'S700_2047', 55, 86.9, 15),
(2261, 10339, 'S700_2610', 50, 62.16, 9),
(2262, 10339, 'S700_4002', 50, 66.63, 8),
(2263, 10339, 'S72_1253', 27, 49.66, 6),
(2264, 10340, 'S24_2000', 55, 62.46, 8),
(2265, 10340, 'S24_4278', 40, 63.76, 1),
(2266, 10340, 'S32_1374', 55, 95.89, 2),
(2267, 10340, 'S32_4289', 39, 67.41, 3),
(2268, 10340, 'S50_1341', 40, 37.09, 4),
(2269, 10340, 'S700_1691', 30, 73.99, 5),
(2270, 10340, 'S700_2466', 55, 81.77, 7),
(2271, 10340, 'S700_2834', 29, 98.48, 6),
(2272, 10341, 'S10_1678', 41, 84.22, 9),
(2273, 10341, 'S12_1099', 45, 192.62, 2),
(2274, 10341, 'S12_2823', 55, 120.5, 8),
(2275, 10341, 'S12_3380', 44, 111.57, 1),
(2276, 10341, 'S12_3990', 36, 77.41, 10),
(2277, 10341, 'S12_4675', 55, 109.4, 7),
(2278, 10341, 'S24_2360', 32, 63.03, 6),
(2279, 10341, 'S32_4485', 31, 95.93, 4),
(2280, 10341, 'S50_4713', 38, 78.11, 3),
(2281, 10341, 'S700_3167', 34, 70.4, 5),
(2282, 10342, 'S18_1129', 40, 118.89, 2),
(2283, 10342, 'S18_1889', 55, 63.14, 1),
(2284, 10342, 'S18_1984', 22, 115.22, 3),
(2285, 10342, 'S18_3232', 30, 167.65, 4),
(2286, 10342, 'S18_3278', 25, 76.39, 5),
(2287, 10342, 'S18_3482', 55, 136.7, 7),
(2288, 10342, 'S18_3782', 26, 57.82, 8),
(2289, 10342, 'S18_4721', 38, 124.99, 11),
(2290, 10342, 'S24_2972', 39, 30.59, 9),
(2291, 10342, 'S24_3371', 48, 60.01, 10),
(2292, 10342, 'S24_3856', 42, 112.34, 6),
(2293, 10343, 'S18_1589', 36, 109.51, 4),
(2294, 10343, 'S18_2870', 25, 118.8, 3),
(2295, 10343, 'S18_3685', 44, 127.15, 2),
(2296, 10343, 'S24_1628', 27, 44.78, 6),
(2297, 10343, 'S24_4620', 30, 76.8, 1),
(2298, 10343, 'S32_2206', 29, 37.41, 5),
(2299, 10344, 'S18_1749', 45, 168.3, 1),
(2300, 10344, 'S18_2248', 40, 49.04, 2),
(2301, 10344, 'S18_2325', 30, 118.23, 3),
(2302, 10344, 'S18_4409', 21, 80.99, 4),
(2303, 10344, 'S18_4933', 26, 68.42, 5),
(2304, 10344, 'S24_1046', 29, 61, 7),
(2305, 10344, 'S24_1937', 20, 27.88, 6),
(2306, 10345, 'S24_2022', 43, 38.98, 1),
(2307, 10346, 'S18_1342', 42, 88.36, 3),
(2308, 10346, 'S24_2766', 25, 87.24, 1),
(2309, 10346, 'S24_2887', 24, 117.44, 5),
(2310, 10346, 'S24_3191', 24, 80.47, 2),
(2311, 10346, 'S24_3432', 26, 103.87, 6),
(2312, 10346, 'S24_3969', 22, 38.57, 4),
(2313, 10347, 'S10_1949', 30, 188.58, 1),
(2314, 10347, 'S10_4962', 27, 132.97, 2),
(2315, 10347, 'S12_1666', 29, 132.57, 3),
(2316, 10347, 'S18_1097', 42, 113.17, 5),
(2317, 10347, 'S18_1367', 21, 46.36, 7),
(2318, 10347, 'S18_2432', 50, 51.05, 8),
(2319, 10347, 'S18_2795', 21, 136.69, 6),
(2320, 10347, 'S18_2949', 48, 84.09, 9),
(2321, 10347, 'S18_2957', 34, 60.59, 10),
(2322, 10347, 'S18_3136', 45, 95.3, 11),
(2323, 10347, 'S18_3320', 26, 84.33, 12),
(2324, 10347, 'S18_4600', 45, 115.03, 4),
(2325, 10348, 'S12_1108', 48, 207.8, 8),
(2326, 10348, 'S12_3148', 47, 122.37, 4),
(2327, 10348, 'S18_4668', 29, 43.77, 6),
(2328, 10348, 'S24_2300', 37, 107.34, 1),
(2329, 10348, 'S24_4258', 39, 82.78, 2),
(2330, 10348, 'S32_1268', 42, 90.53, 3),
(2331, 10348, 'S32_3522', 31, 62.7, 5),
(2332, 10348, 'S700_2824', 32, 100.14, 7),
(2333, 10349, 'S12_3891', 26, 166.1, 10),
(2334, 10349, 'S12_4473', 48, 114.95, 9),
(2335, 10349, 'S18_2238', 38, 142.45, 8),
(2336, 10349, 'S18_2319', 38, 117.82, 7),
(2337, 10349, 'S18_3232', 48, 164.26, 6),
(2338, 10349, 'S18_4027', 34, 140.75, 5),
(2339, 10349, 'S24_1444', 48, 50.29, 4),
(2340, 10349, 'S24_2840', 36, 31.47, 3),
(2341, 10349, 'S24_4048', 23, 111.18, 2),
(2342, 10349, 'S32_2509', 33, 44.37, 1),
(2343, 10350, 'S10_4757', 26, 110.16, 5),
(2344, 10350, 'S18_3029', 43, 84.3, 6),
(2345, 10350, 'S18_3140', 44, 135.22, 1),
(2346, 10350, 'S18_3259', 41, 94.79, 2),
(2347, 10350, 'S18_4522', 30, 70.22, 3),
(2348, 10350, 'S24_2011', 34, 98.31, 7),
(2349, 10350, 'S24_3151', 30, 86.74, 9),
(2350, 10350, 'S24_3816', 25, 77.15, 10),
(2351, 10350, 'S32_3207', 27, 61.52, 14),
(2352, 10350, 'S50_1392', 31, 104.18, 8),
(2353, 10350, 'S50_1514', 44, 56.82, 17),
(2354, 10350, 'S700_1138', 46, 56, 11),
(2355, 10350, 'S700_1938', 28, 76.22, 4),
(2356, 10350, 'S700_2610', 29, 68.67, 12),
(2357, 10350, 'S700_3505', 31, 87.15, 13),
(2358, 10350, 'S700_3962', 25, 97.32, 16),
(2359, 10350, 'S72_3212', 20, 48.05, 15),
(2360, 10351, 'S18_1662', 39, 143.5, 1),
(2361, 10351, 'S18_3856', 20, 104.81, 2),
(2362, 10351, 'S24_2841', 25, 64.4, 5),
(2363, 10351, 'S24_3420', 38, 53.92, 4),
(2364, 10351, 'S24_3949', 34, 68.24, 3),
(2365, 10352, 'S700_2047', 23, 75.13, 3),
(2366, 10352, 'S700_2466', 49, 87.75, 2),
(2367, 10352, 'S700_4002', 22, 62.19, 1),
(2368, 10352, 'S72_1253', 49, 46.18, 4),
(2369, 10353, 'S18_2581', 27, 71.81, 1),
(2370, 10353, 'S24_1785', 28, 107.23, 2),
(2371, 10353, 'S24_4278', 35, 69.55, 3),
(2372, 10353, 'S32_1374', 46, 86.9, 5),
(2373, 10353, 'S32_4289', 40, 68.1, 7),
(2374, 10353, 'S50_1341', 40, 35.78, 8),
(2375, 10353, 'S700_1691', 39, 73.07, 9),
(2376, 10353, 'S700_2834', 48, 98.48, 4),
(2377, 10353, 'S700_3167', 43, 74.4, 6),
(2378, 10354, 'S10_1678', 42, 84.22, 6),
(2379, 10354, 'S10_2016', 20, 95.15, 2),
(2380, 10354, 'S10_4698', 42, 178.17, 3),
(2381, 10354, 'S12_1099', 31, 157.6, 9),
(2382, 10354, 'S12_2823', 35, 141.58, 4),
(2383, 10354, 'S12_3380', 29, 98.65, 11),
(2384, 10354, 'S12_3990', 23, 76.61, 12),
(2385, 10354, 'S12_4675', 28, 100.19, 13),
(2386, 10354, 'S18_1889', 21, 76.23, 8),
(2387, 10354, 'S18_2625', 28, 49.06, 10),
(2388, 10354, 'S18_3278', 36, 69.15, 7),
(2389, 10354, 'S24_1578', 21, 96.92, 5),
(2390, 10354, 'S24_2000', 28, 62.46, 1),
(2391, 10355, 'S18_3482', 23, 117.59, 7),
(2392, 10355, 'S18_3782', 31, 60.3, 1),
(2393, 10355, 'S18_4721', 25, 124.99, 2),
(2394, 10355, 'S24_2360', 41, 56.1, 3),
(2395, 10355, 'S24_2972', 36, 37.38, 4),
(2396, 10355, 'S24_3371', 44, 60.62, 6),
(2397, 10355, 'S24_3856', 32, 137.62, 8),
(2398, 10355, 'S24_4620', 28, 75.18, 9),
(2399, 10355, 'S32_2206', 38, 32.99, 10),
(2400, 10355, 'S32_4485', 40, 93.89, 5),
(2401, 10356, 'S18_1129', 43, 120.31, 8),
(2402, 10356, 'S18_1342', 50, 82.19, 9),
(2403, 10356, 'S18_1367', 22, 44.75, 6),
(2404, 10356, 'S18_1984', 27, 130.87, 2),
(2405, 10356, 'S18_2325', 29, 106.79, 3),
(2406, 10356, 'S18_2795', 30, 158.63, 1),
(2407, 10356, 'S24_1937', 48, 31.86, 5),
(2408, 10356, 'S24_2022', 26, 42.11, 7),
(2409, 10356, 'S50_4713', 26, 78.11, 4),
(2410, 10357, 'S10_1949', 32, 199.3, 10),
(2411, 10357, 'S10_4962', 43, 135.92, 9),
(2412, 10357, 'S12_1666', 49, 109.34, 8),
(2413, 10357, 'S18_1097', 39, 112, 1),
(2414, 10357, 'S18_2432', 41, 58.95, 7),
(2415, 10357, 'S18_2949', 41, 91.18, 6),
(2416, 10357, 'S18_2957', 49, 59.34, 5),
(2417, 10357, 'S18_3136', 44, 104.72, 4),
(2418, 10357, 'S18_3320', 25, 84.33, 3),
(2419, 10357, 'S18_4600', 28, 105.34, 2),
(2420, 10358, 'S12_3148', 49, 129.93, 5),
(2421, 10358, 'S12_4473', 42, 98.36, 9),
(2422, 10358, 'S18_2238', 20, 142.45, 10),
(2423, 10358, 'S18_2319', 20, 99.41, 11),
(2424, 10358, 'S18_3232', 32, 137.17, 12),
(2425, 10358, 'S18_4027', 25, 117.77, 13),
(2426, 10358, 'S18_4668', 30, 46.29, 8),
(2427, 10358, 'S24_1444', 44, 56.07, 14),
(2428, 10358, 'S24_2300', 41, 127.79, 7),
(2429, 10358, 'S24_2840', 36, 33.59, 4),
(2430, 10358, 'S24_4258', 41, 88.62, 6),
(2431, 10358, 'S32_1268', 41, 82.83, 1),
(2432, 10358, 'S32_3522', 36, 51.71, 2),
(2433, 10358, 'S700_2824', 27, 85.98, 3),
(2434, 10359, 'S10_4757', 48, 122.4, 6),
(2435, 10359, 'S12_1108', 42, 180.79, 8),
(2436, 10359, 'S12_3891', 49, 162.64, 5),
(2437, 10359, 'S24_4048', 22, 108.82, 7),
(2438, 10359, 'S32_2509', 36, 45.45, 3),
(2439, 10359, 'S32_3207', 22, 62.14, 1),
(2440, 10359, 'S50_1392', 46, 99.55, 2),
(2441, 10359, 'S50_1514', 25, 47.45, 4),
(2442, 10360, 'S18_1662', 50, 126.15, 12),
(2443, 10360, 'S18_2581', 41, 68.43, 13),
(2444, 10360, 'S18_3029', 46, 71.4, 14),
(2445, 10360, 'S18_3140', 29, 122.93, 8),
(2446, 10360, 'S18_3259', 29, 94.79, 18),
(2447, 10360, 'S18_3856', 40, 101.64, 15),
(2448, 10360, 'S18_4522', 40, 76.36, 1),
(2449, 10360, 'S24_1785', 22, 106.14, 17),
(2450, 10360, 'S24_2011', 31, 100.77, 2),
(2451, 10360, 'S24_2841', 49, 55.49, 16),
(2452, 10360, 'S24_3151', 36, 70.81, 3),
(2453, 10360, 'S24_3816', 22, 78.83, 4),
(2454, 10360, 'S700_1138', 32, 64.67, 5),
(2455, 10360, 'S700_1938', 26, 86.61, 6),
(2456, 10360, 'S700_2610', 30, 70.11, 7),
(2457, 10360, 'S700_3505', 35, 83.14, 9),
(2458, 10360, 'S700_3962', 31, 92.36, 10),
(2459, 10360, 'S72_3212', 31, 54.05, 11),
(2460, 10361, 'S10_1678', 20, 92.83, 13),
(2461, 10361, 'S10_2016', 26, 114.18, 8),
(2462, 10361, 'S24_3420', 34, 62.46, 6),
(2463, 10361, 'S24_3949', 26, 61.42, 7),
(2464, 10361, 'S24_4278', 25, 68.83, 1),
(2465, 10361, 'S32_4289', 49, 56.41, 2),
(2466, 10361, 'S50_1341', 33, 35.78, 3),
(2467, 10361, 'S700_1691', 20, 88.6, 4),
(2468, 10361, 'S700_2047', 24, 85.99, 14),
(2469, 10361, 'S700_2466', 26, 91.74, 9),
(2470, 10361, 'S700_2834', 44, 107.97, 5),
(2471, 10361, 'S700_3167', 44, 76.8, 10),
(2472, 10361, 'S700_4002', 35, 62.19, 11),
(2473, 10361, 'S72_1253', 23, 47.67, 12),
(2474, 10362, 'S10_4698', 22, 182.04, 4),
(2475, 10362, 'S12_2823', 22, 131.04, 1),
(2476, 10362, 'S18_2625', 23, 53.91, 3),
(2477, 10362, 'S24_1578', 50, 91.29, 2),
(2478, 10363, 'S12_1099', 33, 180.95, 3),
(2479, 10363, 'S12_3380', 34, 106.87, 4),
(2480, 10363, 'S12_3990', 34, 68.63, 5),
(2481, 10363, 'S12_4675', 46, 103.64, 6),
(2482, 10363, 'S18_1889', 22, 61.6, 7),
(2483, 10363, 'S18_3278', 46, 69.15, 10),
(2484, 10363, 'S18_3482', 24, 124.94, 11),
(2485, 10363, 'S18_3782', 32, 52.22, 12),
(2486, 10363, 'S18_4721', 28, 123.5, 13),
(2487, 10363, 'S24_2000', 21, 70.08, 8),
(2488, 10363, 'S24_2360', 43, 56.1, 14),
(2489, 10363, 'S24_3371', 21, 52.05, 15),
(2490, 10363, 'S24_3856', 31, 113.75, 1),
(2491, 10363, 'S24_4620', 43, 75.99, 9),
(2492, 10363, 'S32_1374', 50, 92.9, 2),
(2493, 10364, 'S32_2206', 48, 38.22, 1),
(2494, 10365, 'S18_1129', 30, 116.06, 1),
(2495, 10365, 'S32_4485', 22, 82.66, 3),
(2496, 10365, 'S50_4713', 44, 68.34, 2),
(2497, 10366, 'S18_1984', 34, 116.65, 3),
(2498, 10366, 'S18_2870', 49, 105.6, 2),
(2499, 10366, 'S18_3232', 34, 154.1, 1),
(2500, 10367, 'S18_1589', 49, 105.77, 1),
(2501, 10367, 'S18_1749', 37, 144.5, 3),
(2502, 10367, 'S18_2248', 45, 50.25, 4),
(2503, 10367, 'S18_2325', 27, 124.59, 5),
(2504, 10367, 'S18_2795', 32, 140.06, 7),
(2505, 10367, 'S18_3685', 46, 131.39, 6),
(2506, 10367, 'S18_4409', 43, 77.31, 8),
(2507, 10367, 'S18_4933', 44, 66.99, 9),
(2508, 10367, 'S24_1046', 21, 72.76, 10),
(2509, 10367, 'S24_1628', 38, 50.31, 11),
(2510, 10367, 'S24_1937', 23, 29.54, 13),
(2511, 10367, 'S24_2022', 28, 43.01, 12),
(2512, 10367, 'S24_2972', 36, 36.25, 2),
(2513, 10368, 'S24_2766', 40, 73.6, 2),
(2514, 10368, 'S24_2887', 31, 115.09, 5),
(2515, 10368, 'S24_3191', 46, 83.04, 1),
(2516, 10368, 'S24_3432', 20, 93.16, 4),
(2517, 10368, 'S24_3969', 46, 36.52, 3),
(2518, 10369, 'S10_1949', 41, 195.01, 2),
(2519, 10369, 'S18_1342', 44, 89.38, 8),
(2520, 10369, 'S18_1367', 32, 46.36, 7),
(2521, 10369, 'S18_2949', 42, 100.3, 1),
(2522, 10369, 'S18_2957', 28, 51.84, 6),
(2523, 10369, 'S18_3136', 21, 90.06, 5),
(2524, 10369, 'S18_3320', 45, 80.36, 4),
(2525, 10369, 'S24_4258', 40, 93.49, 3),
(2526, 10370, 'S10_4962', 35, 128.53, 4),
(2527, 10370, 'S12_1666', 49, 128.47, 8),
(2528, 10370, 'S18_1097', 27, 100.34, 1),
(2529, 10370, 'S18_2319', 22, 101.87, 5),
(2530, 10370, 'S18_2432', 22, 60.16, 7),
(2531, 10370, 'S18_3232', 27, 167.65, 9),
(2532, 10370, 'S18_4600', 29, 105.34, 6),
(2533, 10370, 'S18_4668', 20, 41.76, 2),
(2534, 10370, 'S32_3522', 25, 63.99, 3),
(2535, 10371, 'S12_1108', 32, 178.71, 6),
(2536, 10371, 'S12_4473', 49, 104.28, 4),
(2537, 10371, 'S18_2238', 25, 160.46, 7),
(2538, 10371, 'S24_1444', 25, 53.75, 12),
(2539, 10371, 'S24_2300', 20, 126.51, 5),
(2540, 10371, 'S24_2840', 45, 35.01, 8),
(2541, 10371, 'S24_4048', 28, 95.81, 9),
(2542, 10371, 'S32_1268', 26, 82.83, 1),
(2543, 10371, 'S32_2509', 20, 44.37, 2),
(2544, 10371, 'S32_3207', 30, 53.44, 11),
(2545, 10371, 'S50_1392', 48, 97.23, 10),
(2546, 10371, 'S700_2824', 34, 83.95, 3),
(2547, 10372, 'S12_3148', 40, 146.55, 4),
(2548, 10372, 'S12_3891', 34, 140.15, 1),
(2549, 10372, 'S18_3140', 28, 131.13, 3),
(2550, 10372, 'S18_3259', 25, 91.76, 5);
INSERT INTO `orderdetails` (`id`, `orderNumber`, `productCode`, `quantityOrdered`, `priceEach`, `orderLineNumber`) VALUES
(2551, 10372, 'S18_4027', 48, 119.2, 6),
(2552, 10372, 'S18_4522', 41, 78.99, 7),
(2553, 10372, 'S24_2011', 37, 102, 8),
(2554, 10372, 'S50_1514', 24, 56.82, 9),
(2555, 10372, 'S700_1938', 44, 74.48, 2),
(2556, 10373, 'S10_4757', 39, 118.32, 3),
(2557, 10373, 'S18_1662', 28, 143.5, 4),
(2558, 10373, 'S18_3029', 22, 75.7, 5),
(2559, 10373, 'S18_3856', 50, 99.52, 6),
(2560, 10373, 'S24_2841', 38, 58.92, 7),
(2561, 10373, 'S24_3151', 33, 82.31, 12),
(2562, 10373, 'S24_3420', 46, 53.92, 11),
(2563, 10373, 'S24_3816', 23, 83.86, 10),
(2564, 10373, 'S24_3949', 39, 62.1, 13),
(2565, 10373, 'S700_1138', 44, 58, 14),
(2566, 10373, 'S700_2047', 32, 76.94, 15),
(2567, 10373, 'S700_2610', 41, 69.39, 16),
(2568, 10373, 'S700_3505', 34, 94.16, 2),
(2569, 10373, 'S700_3962', 37, 83.42, 8),
(2570, 10373, 'S700_4002', 45, 68.11, 17),
(2571, 10373, 'S72_1253', 25, 44.2, 9),
(2572, 10373, 'S72_3212', 29, 48.05, 1),
(2573, 10374, 'S10_2016', 39, 115.37, 5),
(2574, 10374, 'S10_4698', 22, 158.8, 1),
(2575, 10374, 'S18_2581', 42, 75.19, 2),
(2576, 10374, 'S18_2625', 22, 48.46, 4),
(2577, 10374, 'S24_1578', 38, 112.7, 6),
(2578, 10374, 'S24_1785', 46, 107.23, 3),
(2579, 10375, 'S10_1678', 21, 76.56, 12),
(2580, 10375, 'S12_1099', 45, 184.84, 7),
(2581, 10375, 'S12_2823', 49, 150.62, 13),
(2582, 10375, 'S24_2000', 23, 67.03, 9),
(2583, 10375, 'S24_2360', 20, 60.26, 14),
(2584, 10375, 'S24_4278', 43, 60.13, 2),
(2585, 10375, 'S32_1374', 37, 87.9, 3),
(2586, 10375, 'S32_4289', 44, 59.85, 4),
(2587, 10375, 'S32_4485', 41, 96.95, 15),
(2588, 10375, 'S50_1341', 49, 36.22, 5),
(2589, 10375, 'S50_4713', 49, 69.16, 8),
(2590, 10375, 'S700_1691', 37, 86.77, 6),
(2591, 10375, 'S700_2466', 33, 94.73, 1),
(2592, 10375, 'S700_2834', 25, 98.48, 10),
(2593, 10375, 'S700_3167', 44, 69.6, 11),
(2594, 10376, 'S12_3380', 35, 98.65, 1),
(2595, 10377, 'S12_3990', 24, 65.44, 5),
(2596, 10377, 'S12_4675', 50, 112.86, 1),
(2597, 10377, 'S18_1129', 35, 124.56, 2),
(2598, 10377, 'S18_1889', 31, 61.6, 4),
(2599, 10377, 'S18_1984', 36, 125.18, 6),
(2600, 10377, 'S18_3232', 39, 143.94, 3),
(2601, 10378, 'S18_1589', 34, 121.95, 5),
(2602, 10378, 'S18_3278', 22, 66.74, 4),
(2603, 10378, 'S18_3482', 43, 146.99, 10),
(2604, 10378, 'S18_3782', 28, 60.3, 9),
(2605, 10378, 'S18_4721', 49, 122.02, 8),
(2606, 10378, 'S24_2972', 41, 30.59, 7),
(2607, 10378, 'S24_3371', 46, 52.66, 6),
(2608, 10378, 'S24_3856', 33, 129.2, 3),
(2609, 10378, 'S24_4620', 41, 80.84, 2),
(2610, 10378, 'S32_2206', 40, 35.8, 1),
(2611, 10379, 'S18_1749', 39, 156.4, 2),
(2612, 10379, 'S18_2248', 27, 50.85, 1),
(2613, 10379, 'S18_2870', 29, 113.52, 5),
(2614, 10379, 'S18_3685', 32, 134.22, 4),
(2615, 10379, 'S24_1628', 32, 48.8, 3),
(2616, 10380, 'S18_1342', 27, 88.36, 13),
(2617, 10380, 'S18_2325', 40, 119.5, 10),
(2618, 10380, 'S18_2795', 21, 156.94, 8),
(2619, 10380, 'S18_4409', 32, 78.23, 1),
(2620, 10380, 'S18_4933', 24, 66.99, 2),
(2621, 10380, 'S24_1046', 34, 66.88, 3),
(2622, 10380, 'S24_1937', 32, 29.87, 4),
(2623, 10380, 'S24_2022', 27, 37.63, 5),
(2624, 10380, 'S24_2766', 36, 77.24, 6),
(2625, 10380, 'S24_2887', 44, 111.57, 7),
(2626, 10380, 'S24_3191', 44, 77.05, 9),
(2627, 10380, 'S24_3432', 34, 91.02, 11),
(2628, 10380, 'S24_3969', 43, 32.82, 12),
(2629, 10381, 'S10_1949', 36, 182.16, 3),
(2630, 10381, 'S10_4962', 37, 138.88, 6),
(2631, 10381, 'S12_1666', 20, 132.57, 1),
(2632, 10381, 'S18_1097', 48, 114.34, 2),
(2633, 10381, 'S18_1367', 25, 49.6, 9),
(2634, 10381, 'S18_2432', 35, 60.77, 7),
(2635, 10381, 'S18_2949', 41, 100.3, 8),
(2636, 10381, 'S18_2957', 40, 51.22, 4),
(2637, 10381, 'S18_3136', 35, 93.2, 5),
(2638, 10382, 'S12_1108', 34, 166.24, 10),
(2639, 10382, 'S12_3148', 37, 145.04, 11),
(2640, 10382, 'S12_3891', 34, 143.61, 12),
(2641, 10382, 'S12_4473', 32, 103.1, 13),
(2642, 10382, 'S18_2238', 25, 160.46, 5),
(2643, 10382, 'S18_3320', 50, 84.33, 7),
(2644, 10382, 'S18_4600', 39, 115.03, 1),
(2645, 10382, 'S18_4668', 39, 46.29, 2),
(2646, 10382, 'S24_2300', 20, 120.12, 3),
(2647, 10382, 'S24_4258', 33, 97.39, 4),
(2648, 10382, 'S32_1268', 26, 85.72, 6),
(2649, 10382, 'S32_3522', 48, 57.53, 8),
(2650, 10382, 'S700_2824', 34, 101.15, 9),
(2651, 10383, 'S18_2319', 27, 119.05, 11),
(2652, 10383, 'S18_3140', 24, 125.66, 9),
(2653, 10383, 'S18_3232', 47, 155.79, 6),
(2654, 10383, 'S18_3259', 26, 83.7, 12),
(2655, 10383, 'S18_4027', 38, 137.88, 1),
(2656, 10383, 'S18_4522', 28, 77.24, 7),
(2657, 10383, 'S24_1444', 22, 52.6, 2),
(2658, 10383, 'S24_2840', 40, 33.24, 3),
(2659, 10383, 'S24_4048', 21, 117.1, 4),
(2660, 10383, 'S32_2509', 32, 53.57, 5),
(2661, 10383, 'S32_3207', 44, 55.93, 8),
(2662, 10383, 'S50_1392', 29, 94.92, 13),
(2663, 10383, 'S50_1514', 38, 48.62, 10),
(2664, 10384, 'S10_4757', 34, 129.2, 4),
(2665, 10384, 'S24_2011', 28, 114.29, 3),
(2666, 10384, 'S24_3151', 43, 71.69, 2),
(2667, 10384, 'S700_1938', 49, 71.02, 1),
(2668, 10385, 'S24_3816', 37, 78.83, 2),
(2669, 10385, 'S700_1138', 25, 62, 1),
(2670, 10386, 'S18_1662', 25, 130.88, 7),
(2671, 10386, 'S18_2581', 21, 72.65, 18),
(2672, 10386, 'S18_3029', 37, 73.12, 5),
(2673, 10386, 'S18_3856', 22, 100.58, 6),
(2674, 10386, 'S24_1785', 33, 101.76, 11),
(2675, 10386, 'S24_2841', 39, 56.86, 1),
(2676, 10386, 'S24_3420', 35, 54.57, 9),
(2677, 10386, 'S24_3949', 41, 55.96, 12),
(2678, 10386, 'S24_4278', 50, 71.73, 8),
(2679, 10386, 'S700_2047', 29, 85.09, 13),
(2680, 10386, 'S700_2466', 37, 90.75, 14),
(2681, 10386, 'S700_2610', 37, 67.22, 10),
(2682, 10386, 'S700_3167', 32, 68, 17),
(2683, 10386, 'S700_3505', 45, 83.14, 2),
(2684, 10386, 'S700_3962', 30, 80.44, 3),
(2685, 10386, 'S700_4002', 44, 59.22, 15),
(2686, 10386, 'S72_1253', 50, 47.67, 16),
(2687, 10386, 'S72_3212', 43, 52.42, 4),
(2688, 10387, 'S32_1374', 44, 79.91, 1),
(2689, 10388, 'S10_1678', 42, 80.39, 4),
(2690, 10388, 'S10_2016', 50, 118.94, 5),
(2691, 10388, 'S10_4698', 21, 156.86, 7),
(2692, 10388, 'S12_2823', 44, 125.01, 6),
(2693, 10388, 'S32_4289', 35, 58.47, 8),
(2694, 10388, 'S50_1341', 27, 41.02, 1),
(2695, 10388, 'S700_1691', 46, 74.9, 2),
(2696, 10388, 'S700_2834', 50, 111.53, 3),
(2697, 10389, 'S12_1099', 26, 182.9, 4),
(2698, 10389, 'S12_3380', 25, 95.13, 6),
(2699, 10389, 'S12_3990', 36, 76.61, 7),
(2700, 10389, 'S12_4675', 47, 102.49, 8),
(2701, 10389, 'S18_1889', 49, 63.91, 3),
(2702, 10389, 'S18_2625', 39, 52.09, 5),
(2703, 10389, 'S24_1578', 45, 112.7, 1),
(2704, 10389, 'S24_2000', 49, 61.7, 2),
(2705, 10390, 'S18_1129', 36, 117.48, 14),
(2706, 10390, 'S18_1984', 34, 132.29, 15),
(2707, 10390, 'S18_2325', 31, 102.98, 16),
(2708, 10390, 'S18_2795', 26, 162, 7),
(2709, 10390, 'S18_3278', 40, 75.59, 9),
(2710, 10390, 'S18_3482', 50, 135.23, 1),
(2711, 10390, 'S18_3782', 36, 54.09, 2),
(2712, 10390, 'S18_4721', 49, 122.02, 3),
(2713, 10390, 'S24_2360', 35, 67.87, 4),
(2714, 10390, 'S24_2972', 37, 35.87, 5),
(2715, 10390, 'S24_3371', 46, 51.43, 6),
(2716, 10390, 'S24_3856', 45, 134.81, 8),
(2717, 10390, 'S24_4620', 30, 66.29, 10),
(2718, 10390, 'S32_2206', 41, 39.02, 11),
(2719, 10390, 'S32_4485', 45, 101.03, 12),
(2720, 10390, 'S50_4713', 22, 81.36, 13),
(2721, 10391, 'S10_1949', 24, 195.01, 4),
(2722, 10391, 'S10_4962', 37, 121.15, 7),
(2723, 10391, 'S12_1666', 39, 110.7, 9),
(2724, 10391, 'S18_1097', 29, 114.34, 10),
(2725, 10391, 'S18_1342', 35, 102.74, 2),
(2726, 10391, 'S18_1367', 42, 47.44, 3),
(2727, 10391, 'S18_2432', 44, 57.73, 5),
(2728, 10391, 'S18_2949', 32, 99.28, 6),
(2729, 10391, 'S24_1937', 33, 26.55, 8),
(2730, 10391, 'S24_2022', 24, 36.29, 1),
(2731, 10392, 'S18_2957', 37, 61.21, 3),
(2732, 10392, 'S18_3136', 29, 103.67, 2),
(2733, 10392, 'S18_3320', 36, 98.22, 1),
(2734, 10393, 'S12_3148', 35, 145.04, 8),
(2735, 10393, 'S12_4473', 32, 99.54, 10),
(2736, 10393, 'S18_2238', 20, 137.53, 11),
(2737, 10393, 'S18_2319', 38, 104.32, 7),
(2738, 10393, 'S18_4600', 30, 106.55, 9),
(2739, 10393, 'S18_4668', 44, 41.76, 1),
(2740, 10393, 'S24_2300', 33, 112.46, 2),
(2741, 10393, 'S24_4258', 33, 88.62, 3),
(2742, 10393, 'S32_1268', 38, 84.75, 4),
(2743, 10393, 'S32_3522', 31, 63.35, 5),
(2744, 10393, 'S700_2824', 21, 83.95, 6),
(2745, 10394, 'S18_3232', 22, 135.47, 5),
(2746, 10394, 'S18_4027', 37, 124.95, 1),
(2747, 10394, 'S24_1444', 31, 53.18, 2),
(2748, 10394, 'S24_2840', 46, 35.36, 6),
(2749, 10394, 'S24_4048', 37, 104.09, 7),
(2750, 10394, 'S32_2509', 36, 47.08, 3),
(2751, 10394, 'S32_3207', 30, 55.93, 4),
(2752, 10395, 'S10_4757', 32, 125.12, 2),
(2753, 10395, 'S12_1108', 33, 205.72, 1),
(2754, 10395, 'S50_1392', 46, 98.39, 4),
(2755, 10395, 'S50_1514', 45, 57.99, 3),
(2756, 10396, 'S12_3891', 33, 155.72, 3),
(2757, 10396, 'S18_3140', 33, 129.76, 2),
(2758, 10396, 'S18_3259', 24, 91.76, 4),
(2759, 10396, 'S18_4522', 45, 83.38, 5),
(2760, 10396, 'S24_2011', 49, 100.77, 6),
(2761, 10396, 'S24_3151', 27, 77, 7),
(2762, 10396, 'S24_3816', 37, 77.99, 8),
(2763, 10396, 'S700_1138', 39, 62, 1),
(2764, 10397, 'S700_1938', 32, 69.29, 5),
(2765, 10397, 'S700_2610', 22, 62.88, 4),
(2766, 10397, 'S700_3505', 48, 86.15, 3),
(2767, 10397, 'S700_3962', 36, 80.44, 2),
(2768, 10397, 'S72_3212', 34, 52.96, 1),
(2769, 10398, 'S18_1662', 33, 130.88, 11),
(2770, 10398, 'S18_2581', 34, 82.79, 15),
(2771, 10398, 'S18_3029', 28, 70.54, 18),
(2772, 10398, 'S18_3856', 45, 92.11, 17),
(2773, 10398, 'S24_1785', 43, 100.67, 16),
(2774, 10398, 'S24_2841', 28, 60.29, 3),
(2775, 10398, 'S24_3420', 34, 61.15, 13),
(2776, 10398, 'S24_3949', 41, 56.64, 2),
(2777, 10398, 'S24_4278', 45, 65.93, 14),
(2778, 10398, 'S32_4289', 22, 60.54, 4),
(2779, 10398, 'S50_1341', 49, 38.84, 5),
(2780, 10398, 'S700_1691', 47, 78.55, 6),
(2781, 10398, 'S700_2047', 36, 75.13, 7),
(2782, 10398, 'S700_2466', 22, 98.72, 8),
(2783, 10398, 'S700_2834', 23, 102.04, 9),
(2784, 10398, 'S700_3167', 29, 76.8, 10),
(2785, 10398, 'S700_4002', 36, 62.19, 12),
(2786, 10398, 'S72_1253', 34, 41.22, 1),
(2787, 10399, 'S10_1678', 40, 77.52, 8),
(2788, 10399, 'S10_2016', 51, 99.91, 7),
(2789, 10399, 'S10_4698', 22, 156.86, 6),
(2790, 10399, 'S12_2823', 29, 123.51, 5),
(2791, 10399, 'S18_2625', 30, 51.48, 4),
(2792, 10399, 'S24_1578', 57, 104.81, 3),
(2793, 10399, 'S24_2000', 58, 75.41, 2),
(2794, 10399, 'S32_1374', 32, 97.89, 1),
(2795, 10400, 'S10_4757', 64, 134.64, 9),
(2796, 10400, 'S18_1662', 34, 129.31, 1),
(2797, 10400, 'S18_3029', 30, 74.84, 7),
(2798, 10400, 'S18_3856', 58, 88.93, 6),
(2799, 10400, 'S24_2841', 24, 55.49, 2),
(2800, 10400, 'S24_3420', 38, 59.18, 3),
(2801, 10400, 'S24_3816', 42, 74.64, 8),
(2802, 10400, 'S700_2047', 46, 82.37, 5),
(2803, 10400, 'S72_1253', 20, 41.71, 4),
(2804, 10401, 'S18_2581', 42, 75.19, 3),
(2805, 10401, 'S24_1785', 38, 87.54, 5),
(2806, 10401, 'S24_3949', 64, 59.37, 12),
(2807, 10401, 'S24_4278', 52, 65.93, 4),
(2808, 10401, 'S32_1374', 49, 81.91, 1),
(2809, 10401, 'S32_4289', 62, 62.6, 6),
(2810, 10401, 'S50_1341', 56, 41.46, 7),
(2811, 10401, 'S700_1691', 11, 77.64, 8),
(2812, 10401, 'S700_2466', 85, 98.72, 10),
(2813, 10401, 'S700_2834', 21, 96.11, 2),
(2814, 10401, 'S700_3167', 77, 73.6, 9),
(2815, 10401, 'S700_4002', 40, 66.63, 11),
(2816, 10402, 'S10_2016', 45, 118.94, 1),
(2817, 10402, 'S18_2625', 55, 58.15, 2),
(2818, 10402, 'S24_2000', 59, 61.7, 3),
(2819, 10403, 'S10_1678', 24, 85.17, 7),
(2820, 10403, 'S10_4698', 66, 174.29, 9),
(2821, 10403, 'S12_2823', 66, 122, 6),
(2822, 10403, 'S18_3782', 36, 55.33, 1),
(2823, 10403, 'S24_1578', 46, 109.32, 8),
(2824, 10403, 'S24_2360', 27, 57.49, 4),
(2825, 10403, 'S32_2206', 30, 35.8, 2),
(2826, 10403, 'S32_4485', 45, 88.78, 5),
(2827, 10403, 'S50_4713', 31, 65.09, 3),
(2828, 10404, 'S12_1099', 64, 163.44, 3),
(2829, 10404, 'S12_3380', 43, 102.17, 1),
(2830, 10404, 'S12_3990', 77, 67.03, 4),
(2831, 10404, 'S18_3278', 90, 67.54, 6),
(2832, 10404, 'S18_3482', 28, 127.88, 5),
(2833, 10404, 'S18_4721', 48, 124.99, 8),
(2834, 10404, 'S24_3371', 49, 53.27, 2),
(2835, 10404, 'S24_4620', 48, 65.48, 7),
(2836, 10405, 'S12_4675', 97, 115.16, 5),
(2837, 10405, 'S18_1889', 61, 72.38, 4),
(2838, 10405, 'S18_3232', 55, 147.33, 1),
(2839, 10405, 'S24_2972', 47, 37.38, 2),
(2840, 10405, 'S24_3856', 76, 127.79, 3),
(2841, 10406, 'S18_1129', 61, 124.56, 3),
(2842, 10406, 'S18_1984', 48, 133.72, 2),
(2843, 10406, 'S18_3685', 65, 117.26, 1),
(2844, 10407, 'S18_1589', 59, 114.48, 11),
(2845, 10407, 'S18_1749', 76, 141.1, 2),
(2846, 10407, 'S18_2248', 42, 58.12, 1),
(2847, 10407, 'S18_2870', 41, 132, 12),
(2848, 10407, 'S18_4409', 6, 91.11, 3),
(2849, 10407, 'S18_4933', 66, 64.14, 4),
(2850, 10407, 'S24_1046', 26, 68.35, 8),
(2851, 10407, 'S24_1628', 64, 45.78, 10),
(2852, 10407, 'S24_2766', 76, 81.78, 6),
(2853, 10407, 'S24_2887', 59, 98.65, 5),
(2854, 10407, 'S24_3191', 13, 77.05, 7),
(2855, 10407, 'S24_3432', 43, 101.73, 9),
(2856, 10408, 'S24_3969', 15, 41.03, 1),
(2857, 10409, 'S18_2325', 6, 104.25, 2),
(2858, 10409, 'S24_1937', 61, 27.88, 1),
(2859, 10410, 'S18_1342', 65, 99.66, 7),
(2860, 10410, 'S18_1367', 44, 51.21, 6),
(2861, 10410, 'S18_2795', 56, 145.13, 8),
(2862, 10410, 'S18_2949', 47, 93.21, 1),
(2863, 10410, 'S18_2957', 53, 49.97, 3),
(2864, 10410, 'S18_3136', 34, 84.82, 2),
(2865, 10410, 'S18_3320', 44, 81.35, 5),
(2866, 10410, 'S24_2022', 31, 42.56, 9),
(2867, 10410, 'S24_4258', 50, 95.44, 4),
(2868, 10411, 'S10_1949', 23, 205.73, 9),
(2869, 10411, 'S10_4962', 27, 144.79, 2),
(2870, 10411, 'S12_1666', 40, 110.7, 6),
(2871, 10411, 'S18_1097', 27, 109.67, 8),
(2872, 10411, 'S18_4600', 46, 106.55, 3),
(2873, 10411, 'S18_4668', 35, 41.25, 7),
(2874, 10411, 'S32_1268', 26, 78.01, 1),
(2875, 10411, 'S32_3522', 27, 60.76, 5),
(2876, 10411, 'S700_2824', 34, 89.01, 4),
(2877, 10412, 'S12_4473', 54, 100.73, 5),
(2878, 10412, 'S18_2238', 41, 150.63, 4),
(2879, 10412, 'S18_2319', 56, 120.28, 8),
(2880, 10412, 'S18_2432', 47, 49.83, 11),
(2881, 10412, 'S18_3232', 60, 157.49, 9),
(2882, 10412, 'S24_1444', 21, 47.4, 2),
(2883, 10412, 'S24_2300', 70, 109.9, 10),
(2884, 10412, 'S24_2840', 30, 32.88, 6),
(2885, 10412, 'S24_4048', 31, 108.82, 1),
(2886, 10412, 'S32_2509', 19, 50.86, 7),
(2887, 10412, 'S50_1392', 26, 105.33, 3),
(2888, 10413, 'S12_1108', 36, 201.57, 2),
(2889, 10413, 'S12_3148', 47, 145.04, 3),
(2890, 10413, 'S12_3891', 22, 173.02, 1),
(2891, 10413, 'S18_4027', 49, 133.57, 5),
(2892, 10413, 'S32_3207', 24, 56.55, 6),
(2893, 10413, 'S50_1514', 51, 53.31, 4),
(2894, 10414, 'S10_4757', 49, 114.24, 3),
(2895, 10414, 'S18_3029', 44, 77.42, 1),
(2896, 10414, 'S18_3140', 41, 128.39, 12),
(2897, 10414, 'S18_3259', 48, 85.71, 14),
(2898, 10414, 'S18_4522', 56, 83.38, 11),
(2899, 10414, 'S24_2011', 43, 108.14, 10),
(2900, 10414, 'S24_3151', 60, 72.58, 5),
(2901, 10414, 'S24_3816', 51, 72.96, 2),
(2902, 10414, 'S700_1138', 37, 62, 6),
(2903, 10414, 'S700_1938', 34, 74.48, 13),
(2904, 10414, 'S700_2610', 31, 61.44, 4),
(2905, 10414, 'S700_3505', 28, 84.14, 7),
(2906, 10414, 'S700_3962', 40, 84.41, 8),
(2907, 10414, 'S72_3212', 47, 54.6, 9),
(2908, 10415, 'S18_3856', 51, 86.81, 5),
(2909, 10415, 'S24_2841', 21, 60.97, 1),
(2910, 10415, 'S24_3420', 18, 59.83, 2),
(2911, 10415, 'S700_2047', 32, 73.32, 4),
(2912, 10415, 'S72_1253', 42, 43.2, 3),
(2913, 10416, 'S18_1662', 24, 129.31, 14),
(2914, 10416, 'S18_2581', 15, 70.96, 4),
(2915, 10416, 'S24_1785', 47, 90.82, 6),
(2916, 10416, 'S24_2000', 32, 62.46, 1),
(2917, 10416, 'S24_3949', 18, 64.83, 13),
(2918, 10416, 'S24_4278', 48, 70.28, 5),
(2919, 10416, 'S32_1374', 45, 86.9, 2),
(2920, 10416, 'S32_4289', 26, 68.1, 7),
(2921, 10416, 'S50_1341', 37, 39.71, 8),
(2922, 10416, 'S700_1691', 23, 88.6, 9),
(2923, 10416, 'S700_2466', 22, 84.76, 11),
(2924, 10416, 'S700_2834', 41, 98.48, 3),
(2925, 10416, 'S700_3167', 39, 65.6, 10),
(2926, 10416, 'S700_4002', 43, 63.67, 12),
(2927, 10417, 'S10_1678', 66, 79.43, 2),
(2928, 10417, 'S10_2016', 45, 116.56, 5),
(2929, 10417, 'S10_4698', 56, 162.67, 4),
(2930, 10417, 'S12_2823', 21, 144.6, 1),
(2931, 10417, 'S18_2625', 36, 58.75, 6),
(2932, 10417, 'S24_1578', 35, 109.32, 3),
(2933, 10418, 'S18_3278', 16, 70.76, 2),
(2934, 10418, 'S18_3482', 27, 139.64, 1),
(2935, 10418, 'S18_3782', 33, 56.57, 5),
(2936, 10418, 'S18_4721', 28, 120.53, 4),
(2937, 10418, 'S24_2360', 52, 64.41, 8),
(2938, 10418, 'S24_4620', 10, 66.29, 3),
(2939, 10418, 'S32_2206', 43, 36.61, 6),
(2940, 10418, 'S32_4485', 50, 100.01, 9),
(2941, 10418, 'S50_4713', 40, 72.41, 7),
(2942, 10419, 'S12_1099', 12, 182.9, 13),
(2943, 10419, 'S12_3380', 10, 111.57, 11),
(2944, 10419, 'S12_3990', 34, 64.64, 14),
(2945, 10419, 'S12_4675', 32, 99.04, 10),
(2946, 10419, 'S18_1129', 38, 117.48, 5),
(2947, 10419, 'S18_1589', 37, 100.8, 1),
(2948, 10419, 'S18_1889', 39, 67.76, 9),
(2949, 10419, 'S18_1984', 34, 133.72, 4),
(2950, 10419, 'S18_2870', 55, 116.16, 2),
(2951, 10419, 'S18_3232', 35, 165.95, 6),
(2952, 10419, 'S18_3685', 43, 114.44, 3),
(2953, 10419, 'S24_2972', 15, 32.1, 7),
(2954, 10419, 'S24_3371', 55, 52.66, 12),
(2955, 10419, 'S24_3856', 70, 112.34, 8),
(2956, 10420, 'S18_1749', 37, 153, 5),
(2957, 10420, 'S18_2248', 36, 52.06, 4),
(2958, 10420, 'S18_2325', 45, 116.96, 2),
(2959, 10420, 'S18_4409', 66, 73.62, 6),
(2960, 10420, 'S18_4933', 36, 68.42, 7),
(2961, 10420, 'S24_1046', 60, 60.26, 11),
(2962, 10420, 'S24_1628', 37, 48.8, 13),
(2963, 10420, 'S24_1937', 45, 32.19, 1),
(2964, 10420, 'S24_2766', 39, 76.33, 9),
(2965, 10420, 'S24_2887', 55, 115.09, 8),
(2966, 10420, 'S24_3191', 35, 77.05, 10),
(2967, 10420, 'S24_3432', 26, 104.94, 12),
(2968, 10420, 'S24_3969', 15, 35.29, 3),
(2969, 10421, 'S18_2795', 35, 167.06, 1),
(2970, 10421, 'S24_2022', 40, 44.8, 2),
(2971, 10422, 'S18_1342', 51, 91.44, 2),
(2972, 10422, 'S18_1367', 25, 47.44, 1),
(2973, 10423, 'S18_2949', 10, 89.15, 1),
(2974, 10423, 'S18_2957', 31, 56.21, 3),
(2975, 10423, 'S18_3136', 21, 98.44, 2),
(2976, 10423, 'S18_3320', 21, 80.36, 5),
(2977, 10423, 'S24_4258', 28, 78.89, 4),
(2978, 10424, 'S10_1949', 50, 201.44, 6),
(2979, 10424, 'S12_1666', 49, 121.64, 3),
(2980, 10424, 'S18_1097', 54, 108.5, 5),
(2981, 10424, 'S18_4668', 26, 40.25, 4),
(2982, 10424, 'S32_3522', 44, 54.94, 2),
(2983, 10424, 'S700_2824', 46, 85.98, 1),
(2984, 10425, 'S10_4962', 38, 131.49, 12),
(2985, 10425, 'S12_4473', 33, 95.99, 4),
(2986, 10425, 'S18_2238', 28, 147.36, 3),
(2987, 10425, 'S18_2319', 38, 117.82, 7),
(2988, 10425, 'S18_2432', 19, 48.62, 10),
(2989, 10425, 'S18_3232', 28, 140.55, 8),
(2990, 10425, 'S18_4600', 38, 107.76, 13),
(2991, 10425, 'S24_1444', 55, 53.75, 1),
(2992, 10425, 'S24_2300', 49, 127.79, 9),
(2993, 10425, 'S24_2840', 31, 31.82, 5),
(2994, 10425, 'S32_1268', 41, 83.79, 11),
(2995, 10425, 'S32_2509', 11, 50.32, 6),
(2996, 10425, 'S50_1392', 18, 94.92, 2),
(2997, 10426, '995', 1, 150, 0);

DROP TABLE IF EXISTS `orders`;
CREATE TABLE IF NOT EXISTS `orders` (
  `orderNumber` int(11) NOT NULL AUTO_INCREMENT,
  `orderDate` datetime NOT NULL,
  `requiredDate` datetime NOT NULL,
  `shippedDate` datetime DEFAULT NULL,
  `status` varchar(15) NOT NULL,
  `comments` text,
  `customerNumber` int(11) NOT NULL,
  PRIMARY KEY (`orderNumber`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10427 ;

INSERT INTO `orders` (`orderNumber`, `orderDate`, `requiredDate`, `shippedDate`, `status`, `comments`, `customerNumber`) VALUES
(10100, '2003-01-06 00:00:00', '2003-01-13 00:00:00', '2003-01-10 00:00:00', 'Shipped', NULL, 363),
(10101, '2003-01-09 00:00:00', '2003-01-18 00:00:00', '2003-01-11 00:00:00', 'Shipped', 'Check on availability.', 128),
(10102, '2003-01-10 00:00:00', '2003-01-18 00:00:00', '2003-01-14 00:00:00', 'Shipped', NULL, 181),
(10103, '2003-01-29 00:00:00', '2003-02-07 00:00:00', '2003-02-02 00:00:00', 'Shipped', NULL, 121),
(10104, '2003-01-31 00:00:00', '2003-02-09 00:00:00', '2003-02-01 00:00:00', 'Shipped', NULL, 141),
(10105, '2003-02-11 00:00:00', '2003-02-21 00:00:00', '2003-02-12 00:00:00', 'Shipped', NULL, 145),
(10106, '2003-02-17 00:00:00', '2003-02-24 00:00:00', '2003-02-21 00:00:00', 'Shipped', NULL, 278),
(10107, '2003-02-24 00:00:00', '2003-03-03 00:00:00', '2003-02-26 00:00:00', 'Shipped', 'Difficult to negotiate with customer. We need more marketing materials', 131),
(10108, '2003-03-03 00:00:00', '2003-03-12 00:00:00', '2003-03-08 00:00:00', 'Shipped', NULL, 385),
(10109, '2003-03-10 00:00:00', '2003-03-19 00:00:00', '2003-03-11 00:00:00', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 486),
(10110, '2003-03-18 00:00:00', '2003-03-24 00:00:00', '2003-03-20 00:00:00', 'Shipped', NULL, 187),
(10111, '2003-03-25 00:00:00', '2003-03-31 00:00:00', '2003-03-30 00:00:00', 'Shipped', NULL, 129),
(10112, '2003-03-24 00:00:00', '2003-04-03 00:00:00', '2003-03-29 00:00:00', 'Shipped', 'Customer requested that ad materials (such as posters, pamphlets) be included in the shippment', 144),
(10113, '2003-03-26 00:00:00', '2003-04-02 00:00:00', '2003-03-27 00:00:00', 'Shipped', NULL, 124),
(10114, '2003-04-01 00:00:00', '2003-04-07 00:00:00', '2003-04-02 00:00:00', 'Shipped', NULL, 172),
(10115, '2003-04-04 00:00:00', '2003-04-12 00:00:00', '2003-04-07 00:00:00', 'Shipped', NULL, 424),
(10116, '2003-04-11 00:00:00', '2003-04-19 00:00:00', '2003-04-13 00:00:00', 'Shipped', NULL, 381),
(10117, '2003-04-16 00:00:00', '2003-04-24 00:00:00', '2003-04-17 00:00:00', 'Shipped', NULL, 148),
(10118, '2003-04-21 00:00:00', '2003-04-29 00:00:00', '2003-04-26 00:00:00', 'Shipped', 'Customer has worked with some of our vendors in the past and is aware of their MSRP', 216),
(10119, '2003-04-28 00:00:00', '2003-05-05 00:00:00', '2003-05-02 00:00:00', 'Shipped', NULL, 382),
(10120, '2003-04-29 00:00:00', '2003-05-08 00:00:00', '2003-05-01 00:00:00', 'Shipped', NULL, 114),
(10121, '2003-05-07 00:00:00', '2003-05-13 00:00:00', '2003-05-13 00:00:00', 'Shipped', NULL, 353),
(10122, '2003-05-08 00:00:00', '2003-05-16 00:00:00', '2003-05-13 00:00:00', 'Shipped', NULL, 350),
(10123, '2003-05-20 00:00:00', '2003-05-29 00:00:00', '2003-05-22 00:00:00', 'Shipped', NULL, 103),
(10124, '2003-05-21 00:00:00', '2003-05-29 00:00:00', '2003-05-25 00:00:00', 'Shipped', 'Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch', 112),
(10125, '2003-05-21 00:00:00', '2003-05-27 00:00:00', '2003-05-24 00:00:00', 'Shipped', NULL, 114),
(10126, '2003-05-28 00:00:00', '2003-06-07 00:00:00', '2003-06-02 00:00:00', 'Shipped', NULL, 458),
(10127, '2003-06-03 00:00:00', '2003-06-09 00:00:00', '2003-06-06 00:00:00', 'Shipped', 'Customer requested special shippment. The instructions were passed along to the warehouse', 151),
(10128, '2003-06-06 00:00:00', '2003-06-12 00:00:00', '2003-06-11 00:00:00', 'Shipped', NULL, 141),
(10129, '2003-06-12 00:00:00', '2003-06-18 00:00:00', '2003-06-14 00:00:00', 'Shipped', NULL, 324),
(10130, '2003-06-16 00:00:00', '2003-06-24 00:00:00', '2003-06-21 00:00:00', 'Shipped', NULL, 198),
(10131, '2003-06-16 00:00:00', '2003-06-25 00:00:00', '2003-06-21 00:00:00', 'Shipped', NULL, 447),
(10132, '2003-06-25 00:00:00', '2003-07-01 00:00:00', '2003-06-28 00:00:00', 'Shipped', NULL, 323),
(10133, '2003-06-27 00:00:00', '2003-07-04 00:00:00', '2003-07-03 00:00:00', 'Shipped', NULL, 141),
(10134, '2003-07-01 00:00:00', '2003-07-10 00:00:00', '2003-07-05 00:00:00', 'Shipped', NULL, 250),
(10135, '2003-07-02 00:00:00', '2003-07-12 00:00:00', '2003-07-03 00:00:00', 'Shipped', NULL, 124),
(10136, '2003-07-04 00:00:00', '2003-07-14 00:00:00', '2003-07-06 00:00:00', 'Shipped', 'Customer is interested in buying more Ferrari models', 242),
(10137, '2003-07-10 00:00:00', '2003-07-20 00:00:00', '2003-07-14 00:00:00', 'Shipped', NULL, 353),
(10138, '2003-07-07 00:00:00', '2003-07-16 00:00:00', '2003-07-13 00:00:00', 'Shipped', NULL, 496),
(10139, '2003-07-16 00:00:00', '2003-07-23 00:00:00', '2003-07-21 00:00:00', 'Shipped', NULL, 282),
(10140, '2003-07-24 00:00:00', '2003-08-02 00:00:00', '2003-07-30 00:00:00', 'Shipped', NULL, 161),
(10141, '2003-08-01 00:00:00', '2003-08-09 00:00:00', '2003-08-04 00:00:00', 'Shipped', NULL, 334),
(10142, '2003-08-08 00:00:00', '2003-08-16 00:00:00', '2003-08-13 00:00:00', 'Shipped', NULL, 124),
(10143, '2003-08-10 00:00:00', '2003-08-18 00:00:00', '2003-08-12 00:00:00', 'Shipped', 'Can we deliver the new Ford Mustang models by end-of-quarter?', 320),
(10144, '2003-08-13 00:00:00', '2003-08-21 00:00:00', '2003-08-14 00:00:00', 'Shipped', NULL, 381),
(10145, '2003-08-25 00:00:00', '2003-09-02 00:00:00', '2003-08-31 00:00:00', 'Shipped', NULL, 205),
(10146, '2003-09-03 00:00:00', '2003-09-13 00:00:00', '2003-09-06 00:00:00', 'Shipped', NULL, 447),
(10147, '2003-09-05 00:00:00', '2003-09-12 00:00:00', '2003-09-09 00:00:00', 'Shipped', NULL, 379),
(10148, '2003-09-11 00:00:00', '2003-09-21 00:00:00', '2003-09-15 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 276),
(10149, '2003-09-12 00:00:00', '2003-09-18 00:00:00', '2003-09-17 00:00:00', 'Shipped', NULL, 487),
(10150, '2003-09-19 00:00:00', '2003-09-27 00:00:00', '2003-09-21 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 148),
(10151, '2003-09-21 00:00:00', '2003-09-30 00:00:00', '2003-09-24 00:00:00', 'Shipped', NULL, 311),
(10152, '2003-09-25 00:00:00', '2003-10-03 00:00:00', '2003-10-01 00:00:00', 'Shipped', NULL, 333),
(10153, '2003-09-28 00:00:00', '2003-10-05 00:00:00', '2003-10-03 00:00:00', 'Shipped', NULL, 141),
(10154, '2003-10-02 00:00:00', '2003-10-12 00:00:00', '2003-10-08 00:00:00', 'Shipped', NULL, 219),
(10155, '2003-10-06 00:00:00', '2003-10-13 00:00:00', '2003-10-07 00:00:00', 'Shipped', NULL, 186),
(10156, '2003-10-08 00:00:00', '2003-10-17 00:00:00', '2003-10-11 00:00:00', 'Shipped', NULL, 141),
(10157, '2003-10-09 00:00:00', '2003-10-15 00:00:00', '2003-10-14 00:00:00', 'Shipped', NULL, 473),
(10158, '2003-10-10 00:00:00', '2003-10-18 00:00:00', '2003-10-15 00:00:00', 'Shipped', NULL, 121),
(10159, '2003-10-10 00:00:00', '2003-10-19 00:00:00', '2003-10-16 00:00:00', 'Shipped', NULL, 321),
(10160, '2003-10-11 00:00:00', '2003-10-17 00:00:00', '2003-10-17 00:00:00', 'Shipped', NULL, 347),
(10161, '2003-10-17 00:00:00', '2003-10-25 00:00:00', '2003-10-20 00:00:00', 'Shipped', NULL, 227),
(10162, '2003-10-18 00:00:00', '2003-10-26 00:00:00', '2003-10-19 00:00:00', 'Shipped', NULL, 321),
(10163, '2003-10-20 00:00:00', '2003-10-27 00:00:00', '2003-10-24 00:00:00', 'Shipped', NULL, 424),
(10164, '2003-10-21 00:00:00', '2003-10-30 00:00:00', '2003-10-23 00:00:00', 'Resolved', 'This order was disputed, but resolved on 11/1/2003; Customer doesn''t like the colors and precision of the models.', 452),
(10165, '2003-10-22 00:00:00', '2003-10-31 00:00:00', '2003-12-26 00:00:00', 'Shipped', 'This order was on hold because customers''s credit limit had been exceeded. Order will ship when payment is received', 148),
(10166, '2003-10-21 00:00:00', '2003-10-30 00:00:00', '2003-10-27 00:00:00', 'Shipped', NULL, 462),
(10167, '2003-10-23 00:00:00', '2003-10-30 00:00:00', NULL, 'Cancelled', 'Customer called to cancel. The warehouse was notified in time and the order didn''t ship. They have a new VP of Sales and are shifting their sales model. Our VP of Sales should contact them.', 448),
(10168, '2003-10-28 00:00:00', '2003-11-03 00:00:00', '2003-11-01 00:00:00', 'Shipped', NULL, 161),
(10169, '2003-11-04 00:00:00', '2003-11-14 00:00:00', '2003-11-09 00:00:00', 'Shipped', NULL, 276),
(10170, '2003-11-04 00:00:00', '2003-11-12 00:00:00', '2003-11-07 00:00:00', 'Shipped', NULL, 452),
(10171, '2003-11-05 00:00:00', '2003-11-13 00:00:00', '2003-11-07 00:00:00', 'Shipped', NULL, 233),
(10172, '2003-11-05 00:00:00', '2003-11-14 00:00:00', '2003-11-11 00:00:00', 'Shipped', NULL, 175),
(10173, '2003-11-05 00:00:00', '2003-11-15 00:00:00', '2003-11-09 00:00:00', 'Shipped', 'Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches', 278),
(10174, '2003-11-06 00:00:00', '2003-11-15 00:00:00', '2003-11-10 00:00:00', 'Shipped', NULL, 333),
(10175, '2003-11-06 00:00:00', '2003-11-14 00:00:00', '2003-11-09 00:00:00', 'Shipped', NULL, 324),
(10176, '2003-11-06 00:00:00', '2003-11-15 00:00:00', '2003-11-12 00:00:00', 'Shipped', NULL, 386),
(10177, '2003-11-07 00:00:00', '2003-11-17 00:00:00', '2003-11-12 00:00:00', 'Shipped', NULL, 344),
(10178, '2003-11-08 00:00:00', '2003-11-16 00:00:00', '2003-11-10 00:00:00', 'Shipped', 'Custom shipping instructions sent to warehouse', 242),
(10179, '2003-11-11 00:00:00', '2003-11-17 00:00:00', '2003-11-13 00:00:00', 'Cancelled', 'Customer cancelled due to urgent budgeting issues. Must be cautious when dealing with them in the future. Since order shipped already we must discuss who would cover the shipping charges.', 496),
(10180, '2003-11-11 00:00:00', '2003-11-19 00:00:00', '2003-11-14 00:00:00', 'Shipped', NULL, 171),
(10181, '2003-11-12 00:00:00', '2003-11-19 00:00:00', '2003-11-15 00:00:00', 'Shipped', NULL, 167),
(10182, '2003-11-12 00:00:00', '2003-11-21 00:00:00', '2003-11-18 00:00:00', 'Shipped', NULL, 124),
(10183, '2003-11-13 00:00:00', '2003-11-22 00:00:00', '2003-11-15 00:00:00', 'Shipped', 'We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.', 339),
(10184, '2003-11-14 00:00:00', '2003-11-22 00:00:00', '2003-11-20 00:00:00', 'Shipped', NULL, 484),
(10185, '2003-11-14 00:00:00', '2003-11-21 00:00:00', '2003-11-20 00:00:00', 'Shipped', NULL, 320),
(10186, '2003-11-14 00:00:00', '2003-11-20 00:00:00', '2003-11-18 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with the VP of Sales', 489),
(10187, '2003-11-15 00:00:00', '2003-11-24 00:00:00', '2003-11-16 00:00:00', 'Shipped', NULL, 211),
(10188, '2003-11-18 00:00:00', '2003-11-26 00:00:00', '2003-11-24 00:00:00', 'Shipped', NULL, 167),
(10189, '2003-11-18 00:00:00', '2003-11-25 00:00:00', '2003-11-24 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 205),
(10190, '2003-11-19 00:00:00', '2003-11-29 00:00:00', '2003-11-20 00:00:00', 'Shipped', NULL, 141),
(10191, '2003-11-20 00:00:00', '2003-11-30 00:00:00', '2003-11-24 00:00:00', 'Shipped', 'We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.', 259),
(10192, '2003-11-20 00:00:00', '2003-11-29 00:00:00', '2003-11-25 00:00:00', 'Shipped', NULL, 363),
(10193, '2003-11-21 00:00:00', '2003-11-28 00:00:00', '2003-11-27 00:00:00', 'Shipped', NULL, 471),
(10194, '2003-11-25 00:00:00', '2003-12-02 00:00:00', '2003-11-26 00:00:00', 'Shipped', NULL, 146),
(10195, '2003-11-25 00:00:00', '2003-12-01 00:00:00', '2003-11-28 00:00:00', 'Shipped', NULL, 319),
(10196, '2003-11-26 00:00:00', '2003-12-03 00:00:00', '2003-12-01 00:00:00', 'Shipped', NULL, 455),
(10197, '2003-11-26 00:00:00', '2003-12-02 00:00:00', '2003-12-01 00:00:00', 'Shipped', 'Customer inquired about remote controlled models and gold models.', 216),
(10198, '2003-11-27 00:00:00', '2003-12-06 00:00:00', '2003-12-03 00:00:00', 'Shipped', NULL, 385),
(10199, '2003-12-01 00:00:00', '2003-12-10 00:00:00', '2003-12-06 00:00:00', 'Shipped', NULL, 475),
(10200, '2003-12-01 00:00:00', '2003-12-09 00:00:00', '2003-12-06 00:00:00', 'Shipped', NULL, 211),
(10201, '2003-12-01 00:00:00', '2003-12-11 00:00:00', '2003-12-02 00:00:00', 'Shipped', NULL, 129),
(10202, '2003-12-02 00:00:00', '2003-12-09 00:00:00', '2003-12-06 00:00:00', 'Shipped', NULL, 357),
(10203, '2003-12-02 00:00:00', '2003-12-11 00:00:00', '2003-12-07 00:00:00', 'Shipped', NULL, 141),
(10204, '2003-12-02 00:00:00', '2003-12-10 00:00:00', '2003-12-04 00:00:00', 'Shipped', NULL, 151),
(10205, '2003-12-03 00:00:00', '2003-12-09 00:00:00', '2003-12-07 00:00:00', 'Shipped', ' I need all the information I can get on our competitors.', 141),
(10206, '2003-12-05 00:00:00', '2003-12-13 00:00:00', '2003-12-08 00:00:00', 'Shipped', 'Can we renegotiate this one?', 202),
(10207, '2003-12-09 00:00:00', '2003-12-17 00:00:00', '2003-12-11 00:00:00', 'Shipped', 'Check on availability.', 495),
(10208, '2004-01-02 00:00:00', '2004-01-11 00:00:00', '2004-01-04 00:00:00', 'Shipped', NULL, 146),
(10209, '2004-01-09 00:00:00', '2004-01-15 00:00:00', '2004-01-12 00:00:00', 'Shipped', NULL, 347),
(10210, '2004-01-12 00:00:00', '2004-01-22 00:00:00', '2004-01-20 00:00:00', 'Shipped', NULL, 177),
(10211, '2004-01-15 00:00:00', '2004-01-25 00:00:00', '2004-01-18 00:00:00', 'Shipped', NULL, 406),
(10212, '2004-01-16 00:00:00', '2004-01-24 00:00:00', '2004-01-18 00:00:00', 'Shipped', NULL, 141),
(10213, '2004-01-22 00:00:00', '2004-01-28 00:00:00', '2004-01-27 00:00:00', 'Shipped', 'Difficult to negotiate with customer. We need more marketing materials', 489),
(10214, '2004-01-26 00:00:00', '2004-02-04 00:00:00', '2004-01-29 00:00:00', 'Shipped', NULL, 458),
(10215, '2004-01-29 00:00:00', '2004-02-08 00:00:00', '2004-02-01 00:00:00', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 475),
(10216, '2004-02-02 00:00:00', '2004-02-10 00:00:00', '2004-02-04 00:00:00', 'Shipped', NULL, 256),
(10217, '2004-02-04 00:00:00', '2004-02-14 00:00:00', '2004-02-06 00:00:00', 'Shipped', NULL, 166),
(10218, '2004-02-09 00:00:00', '2004-02-16 00:00:00', '2004-02-11 00:00:00', 'Shipped', 'Customer requested that ad materials (such as posters, pamphlets) be included in the shippment', 473),
(10219, '2004-02-10 00:00:00', '2004-02-17 00:00:00', '2004-02-12 00:00:00', 'Shipped', NULL, 487),
(10220, '2004-02-12 00:00:00', '2004-02-19 00:00:00', '2004-02-16 00:00:00', 'Shipped', NULL, 189),
(10221, '2004-02-18 00:00:00', '2004-02-26 00:00:00', '2004-02-19 00:00:00', 'Shipped', NULL, 314),
(10222, '2004-02-19 00:00:00', '2004-02-27 00:00:00', '2004-02-20 00:00:00', 'Shipped', NULL, 239),
(10223, '2004-02-20 00:00:00', '2004-02-29 00:00:00', '2004-02-24 00:00:00', 'Shipped', NULL, 114),
(10224, '2004-02-21 00:00:00', '2004-03-02 00:00:00', '2004-02-26 00:00:00', 'Shipped', 'Customer has worked with some of our vendors in the past and is aware of their MSRP', 171),
(10225, '2004-02-22 00:00:00', '2004-03-01 00:00:00', '2004-02-24 00:00:00', 'Shipped', NULL, 298),
(10226, '2004-02-26 00:00:00', '2004-03-06 00:00:00', '2004-03-02 00:00:00', 'Shipped', NULL, 239),
(10227, '2004-03-02 00:00:00', '2004-03-12 00:00:00', '2004-03-08 00:00:00', 'Shipped', NULL, 146),
(10228, '2004-03-10 00:00:00', '2004-03-18 00:00:00', '2004-03-13 00:00:00', 'Shipped', NULL, 173),
(10229, '2004-03-11 00:00:00', '2004-03-20 00:00:00', '2004-03-12 00:00:00', 'Shipped', NULL, 124),
(10230, '2004-03-15 00:00:00', '2004-03-24 00:00:00', '2004-03-20 00:00:00', 'Shipped', 'Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch', 128),
(10231, '2004-03-19 00:00:00', '2004-03-26 00:00:00', '2004-03-25 00:00:00', 'Shipped', NULL, 344),
(10232, '2004-03-20 00:00:00', '2004-03-30 00:00:00', '2004-03-25 00:00:00', 'Shipped', NULL, 240),
(10233, '2004-03-29 00:00:00', '2004-04-04 00:00:00', '2004-04-02 00:00:00', 'Shipped', 'Customer requested special shippment. The instructions were passed along to the warehouse', 328),
(10234, '2004-03-30 00:00:00', '2004-04-05 00:00:00', '2004-04-02 00:00:00', 'Shipped', NULL, 412),
(10235, '2004-04-02 00:00:00', '2004-04-12 00:00:00', '2004-04-06 00:00:00', 'Shipped', NULL, 260),
(10236, '2004-04-03 00:00:00', '2004-04-11 00:00:00', '2004-04-08 00:00:00', 'Shipped', NULL, 486),
(10237, '2004-04-05 00:00:00', '2004-04-12 00:00:00', '2004-04-10 00:00:00', 'Shipped', NULL, 181),
(10238, '2004-04-09 00:00:00', '2004-04-16 00:00:00', '2004-04-10 00:00:00', 'Shipped', NULL, 145),
(10239, '2004-04-12 00:00:00', '2004-04-21 00:00:00', '2004-04-17 00:00:00', 'Shipped', NULL, 311),
(10240, '2004-04-13 00:00:00', '2004-04-20 00:00:00', '2004-04-20 00:00:00', 'Shipped', NULL, 177),
(10241, '2004-04-13 00:00:00', '2004-04-20 00:00:00', '2004-04-19 00:00:00', 'Shipped', NULL, 209),
(10242, '2004-04-20 00:00:00', '2004-04-28 00:00:00', '2004-04-25 00:00:00', 'Shipped', 'Customer is interested in buying more Ferrari models', 456),
(10243, '2004-04-26 00:00:00', '2004-05-03 00:00:00', '2004-04-28 00:00:00', 'Shipped', NULL, 495),
(10244, '2004-04-29 00:00:00', '2004-05-09 00:00:00', '2004-05-04 00:00:00', 'Shipped', NULL, 141),
(10245, '2004-05-04 00:00:00', '2004-05-12 00:00:00', '2004-05-09 00:00:00', 'Shipped', NULL, 455),
(10246, '2004-05-05 00:00:00', '2004-05-13 00:00:00', '2004-05-06 00:00:00', 'Shipped', NULL, 141),
(10247, '2004-05-05 00:00:00', '2004-05-11 00:00:00', '2004-05-08 00:00:00', 'Shipped', NULL, 334),
(10248, '2004-05-07 00:00:00', '2004-05-14 00:00:00', NULL, 'Cancelled', 'Order was mistakenly placed. The warehouse noticed the lack of documentation.', 131),
(10249, '2004-05-08 00:00:00', '2004-05-17 00:00:00', '2004-05-11 00:00:00', 'Shipped', 'Can we deliver the new Ford Mustang models by end-of-quarter?', 173),
(10250, '2004-05-11 00:00:00', '2004-05-19 00:00:00', '2004-05-15 00:00:00', 'Shipped', NULL, 450),
(10251, '2004-05-18 00:00:00', '2004-05-24 00:00:00', '2004-05-24 00:00:00', 'Shipped', NULL, 328),
(10252, '2004-05-26 00:00:00', '2004-06-04 00:00:00', '2004-05-29 00:00:00', 'Shipped', NULL, 406),
(10253, '2004-06-01 00:00:00', '2004-06-09 00:00:00', '2004-06-02 00:00:00', 'Cancelled', 'Customer disputed the order and we agreed to cancel it. We must be more cautions with this customer going forward, since they are very hard to please. We must cover the shipping fees.', 201),
(10254, '2004-06-03 00:00:00', '2004-06-13 00:00:00', '2004-06-04 00:00:00', 'Shipped', 'Customer requested that DHL is used for this shipping', 323),
(10255, '2004-06-04 00:00:00', '2004-06-12 00:00:00', '2004-06-09 00:00:00', 'Shipped', NULL, 209),
(10256, '2004-06-08 00:00:00', '2004-06-16 00:00:00', '2004-06-10 00:00:00', 'Shipped', NULL, 145),
(10257, '2004-06-14 00:00:00', '2004-06-24 00:00:00', '2004-06-15 00:00:00', 'Shipped', NULL, 450),
(10258, '2004-06-15 00:00:00', '2004-06-25 00:00:00', '2004-06-23 00:00:00', 'Shipped', NULL, 398),
(10259, '2004-06-15 00:00:00', '2004-06-22 00:00:00', '2004-06-17 00:00:00', 'Shipped', NULL, 166),
(10260, '2004-06-16 00:00:00', '2004-06-22 00:00:00', NULL, 'Cancelled', 'Customer heard complaints from their customers and called to cancel this order. Will notify the Sales Manager.', 357),
(10261, '2004-06-17 00:00:00', '2004-06-25 00:00:00', '2004-06-22 00:00:00', 'Shipped', NULL, 233),
(10262, '2004-06-24 00:00:00', '2004-07-01 00:00:00', NULL, 'Cancelled', 'This customer found a better offer from one of our competitors. Will call back to renegotiate.', 141),
(10263, '2004-06-28 00:00:00', '2004-07-04 00:00:00', '2004-07-02 00:00:00', 'Shipped', NULL, 175),
(10264, '2004-06-30 00:00:00', '2004-07-06 00:00:00', '2004-07-01 00:00:00', 'Shipped', 'Customer will send a truck to our local warehouse on 7/1/2004', 362),
(10265, '2004-07-02 00:00:00', '2004-07-09 00:00:00', '2004-07-07 00:00:00', 'Shipped', NULL, 471),
(10266, '2004-07-06 00:00:00', '2004-07-14 00:00:00', '2004-07-10 00:00:00', 'Shipped', NULL, 386),
(10267, '2004-07-07 00:00:00', '2004-07-17 00:00:00', '2004-07-09 00:00:00', 'Shipped', NULL, 151),
(10268, '2004-07-12 00:00:00', '2004-07-18 00:00:00', '2004-07-14 00:00:00', 'Shipped', NULL, 412),
(10269, '2004-07-16 00:00:00', '2004-07-22 00:00:00', '2004-07-18 00:00:00', 'Shipped', NULL, 382),
(10270, '2004-07-19 00:00:00', '2004-07-27 00:00:00', '2004-07-24 00:00:00', 'Shipped', 'Can we renegotiate this one?', 282),
(10271, '2004-07-20 00:00:00', '2004-07-29 00:00:00', '2004-07-23 00:00:00', 'Shipped', NULL, 124),
(10272, '2004-07-20 00:00:00', '2004-07-26 00:00:00', '2004-07-22 00:00:00', 'Shipped', NULL, 157),
(10273, '2004-07-21 00:00:00', '2004-07-28 00:00:00', '2004-07-22 00:00:00', 'Shipped', NULL, 314),
(10274, '2004-07-21 00:00:00', '2004-07-29 00:00:00', '2004-07-22 00:00:00', 'Shipped', NULL, 379),
(10275, '2004-07-23 00:00:00', '2004-08-02 00:00:00', '2004-07-29 00:00:00', 'Shipped', NULL, 119),
(10276, '2004-08-02 00:00:00', '2004-08-11 00:00:00', '2004-08-08 00:00:00', 'Shipped', NULL, 204),
(10277, '2004-08-04 00:00:00', '2004-08-12 00:00:00', '2004-08-05 00:00:00', 'Shipped', NULL, 148),
(10278, '2004-08-06 00:00:00', '2004-08-16 00:00:00', '2004-08-09 00:00:00', 'Shipped', NULL, 112),
(10279, '2004-08-09 00:00:00', '2004-08-19 00:00:00', '2004-08-15 00:00:00', 'Shipped', 'Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches', 141),
(10280, '2004-08-17 00:00:00', '2004-08-27 00:00:00', '2004-08-19 00:00:00', 'Shipped', NULL, 249),
(10281, '2004-08-19 00:00:00', '2004-08-28 00:00:00', '2004-08-23 00:00:00', 'Shipped', NULL, 157),
(10282, '2004-08-20 00:00:00', '2004-08-26 00:00:00', '2004-08-22 00:00:00', 'Shipped', NULL, 124),
(10283, '2004-08-20 00:00:00', '2004-08-30 00:00:00', '2004-08-23 00:00:00', 'Shipped', NULL, 260),
(10284, '2004-08-21 00:00:00', '2004-08-29 00:00:00', '2004-08-26 00:00:00', 'Shipped', 'Custom shipping instructions sent to warehouse', 299),
(10285, '2004-08-27 00:00:00', '2004-09-04 00:00:00', '2004-08-31 00:00:00', 'Shipped', NULL, 286),
(10286, '2004-08-28 00:00:00', '2004-09-06 00:00:00', '2004-09-01 00:00:00', 'Shipped', NULL, 172),
(10287, '2004-08-30 00:00:00', '2004-09-06 00:00:00', '2004-09-01 00:00:00', 'Shipped', NULL, 298),
(10288, '2004-09-01 00:00:00', '2004-09-11 00:00:00', '2004-09-05 00:00:00', 'Shipped', NULL, 166),
(10289, '2004-09-03 00:00:00', '2004-09-13 00:00:00', '2004-09-04 00:00:00', 'Shipped', 'We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.', 167),
(10290, '2004-09-07 00:00:00', '2004-09-15 00:00:00', '2004-09-13 00:00:00', 'Shipped', NULL, 198),
(10291, '2004-09-08 00:00:00', '2004-09-17 00:00:00', '2004-09-14 00:00:00', 'Shipped', NULL, 448),
(10292, '2004-09-08 00:00:00', '2004-09-18 00:00:00', '2004-09-11 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 131),
(10293, '2004-09-09 00:00:00', '2004-09-18 00:00:00', '2004-09-14 00:00:00', 'Shipped', NULL, 249),
(10294, '2004-09-10 00:00:00', '2004-09-17 00:00:00', '2004-09-14 00:00:00', 'Shipped', NULL, 204),
(10295, '2004-09-10 00:00:00', '2004-09-17 00:00:00', '2004-09-14 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 362),
(10296, '2004-09-15 00:00:00', '2004-09-22 00:00:00', '2004-09-16 00:00:00', 'Shipped', NULL, 415),
(10297, '2004-09-16 00:00:00', '2004-09-22 00:00:00', '2004-09-21 00:00:00', 'Shipped', 'We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.', 189),
(10298, '2004-09-27 00:00:00', '2004-10-05 00:00:00', '2004-10-01 00:00:00', 'Shipped', NULL, 103),
(10299, '2004-09-30 00:00:00', '2004-10-10 00:00:00', '2004-10-01 00:00:00', 'Shipped', NULL, 186),
(10300, '2003-10-04 00:00:00', '2003-10-13 00:00:00', '2003-10-09 00:00:00', 'Shipped', NULL, 128),
(10301, '2003-10-05 00:00:00', '2003-10-15 00:00:00', '2003-10-08 00:00:00', 'Shipped', NULL, 299),
(10302, '2003-10-06 00:00:00', '2003-10-16 00:00:00', '2003-10-07 00:00:00', 'Shipped', NULL, 201),
(10303, '2004-10-06 00:00:00', '2004-10-14 00:00:00', '2004-10-09 00:00:00', 'Shipped', 'Customer inquired about remote controlled models and gold models.', 484),
(10304, '2004-10-11 00:00:00', '2004-10-20 00:00:00', '2004-10-17 00:00:00', 'Shipped', NULL, 256),
(10305, '2004-10-13 00:00:00', '2004-10-22 00:00:00', '2004-10-15 00:00:00', 'Shipped', 'Check on availability.', 286),
(10306, '2004-10-14 00:00:00', '2004-10-21 00:00:00', '2004-10-17 00:00:00', 'Shipped', NULL, 187),
(10307, '2004-10-14 00:00:00', '2004-10-23 00:00:00', '2004-10-20 00:00:00', 'Shipped', NULL, 339),
(10308, '2004-10-15 00:00:00', '2004-10-24 00:00:00', '2004-10-20 00:00:00', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 319),
(10309, '2004-10-15 00:00:00', '2004-10-24 00:00:00', '2004-10-18 00:00:00', 'Shipped', NULL, 121),
(10310, '2004-10-16 00:00:00', '2004-10-24 00:00:00', '2004-10-18 00:00:00', 'Shipped', NULL, 259),
(10311, '2004-10-16 00:00:00', '2004-10-23 00:00:00', '2004-10-20 00:00:00', 'Shipped', 'Difficult to negotiate with customer. We need more marketing materials', 141),
(10312, '2004-10-21 00:00:00', '2004-10-27 00:00:00', '2004-10-23 00:00:00', 'Shipped', NULL, 124),
(10313, '2004-10-22 00:00:00', '2004-10-28 00:00:00', '2004-10-25 00:00:00', 'Shipped', 'Customer requested that FedEx Ground is used for this shipping', 202),
(10314, '2004-10-22 00:00:00', '2004-11-01 00:00:00', '2004-10-23 00:00:00', 'Shipped', NULL, 227),
(10315, '2004-10-29 00:00:00', '2004-11-08 00:00:00', '2004-10-30 00:00:00', 'Shipped', NULL, 119),
(10316, '2004-11-01 00:00:00', '2004-11-09 00:00:00', '2004-11-07 00:00:00', 'Shipped', 'Customer requested that ad materials (such as posters, pamphlets) be included in the shippment', 240),
(10317, '2004-11-02 00:00:00', '2004-11-12 00:00:00', '2004-11-08 00:00:00', 'Shipped', NULL, 161),
(10318, '2004-11-02 00:00:00', '2004-11-09 00:00:00', '2004-11-07 00:00:00', 'Shipped', NULL, 157),
(10319, '2004-11-03 00:00:00', '2004-11-11 00:00:00', '2004-11-06 00:00:00', 'Shipped', 'Customer requested that DHL is used for this shipping', 456),
(10320, '2004-11-03 00:00:00', '2004-11-13 00:00:00', '2004-11-07 00:00:00', 'Shipped', NULL, 144),
(10321, '2004-11-04 00:00:00', '2004-11-12 00:00:00', '2004-11-07 00:00:00', 'Shipped', NULL, 462),
(10322, '2004-11-04 00:00:00', '2004-11-12 00:00:00', '2004-11-10 00:00:00', 'Shipped', 'Customer has worked with some of our vendors in the past and is aware of their MSRP', 363),
(10323, '2004-11-05 00:00:00', '2004-11-12 00:00:00', '2004-11-09 00:00:00', 'Shipped', NULL, 128),
(10324, '2004-11-05 00:00:00', '2004-11-11 00:00:00', '2004-11-08 00:00:00', 'Shipped', NULL, 181),
(10325, '2004-11-05 00:00:00', '2004-11-13 00:00:00', '2004-11-08 00:00:00', 'Shipped', NULL, 121),
(10326, '2004-11-09 00:00:00', '2004-11-16 00:00:00', '2004-11-10 00:00:00', 'Shipped', NULL, 144),
(10327, '2004-11-10 00:00:00', '2004-11-19 00:00:00', '2004-11-13 00:00:00', 'Resolved', 'Order was disputed and resolved on 12/1/04. The Sales Manager was involved. Customer claims the scales of the models don''t match what was discussed.', 145),
(10328, '2004-11-12 00:00:00', '2004-11-21 00:00:00', '2004-11-18 00:00:00', 'Shipped', 'Customer very concerned about the exact color of the models. There is high risk that he may dispute the order because there is a slight color mismatch', 278),
(10329, '2004-11-15 00:00:00', '2004-11-24 00:00:00', '2004-11-16 00:00:00', 'Shipped', NULL, 131),
(10330, '2004-11-16 00:00:00', '2004-11-25 00:00:00', '2004-11-21 00:00:00', 'Shipped', NULL, 385),
(10331, '2004-11-17 00:00:00', '2004-11-23 00:00:00', '2004-11-23 00:00:00', 'Shipped', 'Customer requested special shippment. The instructions were passed along to the warehouse', 486),
(10332, '2004-11-17 00:00:00', '2004-11-25 00:00:00', '2004-11-18 00:00:00', 'Shipped', NULL, 187),
(10333, '2004-11-18 00:00:00', '2004-11-27 00:00:00', '2004-11-20 00:00:00', 'Shipped', NULL, 129),
(10334, '2004-11-19 00:00:00', '2004-11-28 00:00:00', NULL, 'On Hold', 'The outstaniding balance for this customer exceeds their credit limit. Order will be shipped when a payment is received.', 144),
(10335, '2004-11-19 00:00:00', '2004-11-29 00:00:00', '2004-11-23 00:00:00', 'Shipped', NULL, 124),
(10336, '2004-11-20 00:00:00', '2004-11-26 00:00:00', '2004-11-24 00:00:00', 'Shipped', 'Customer requested that DHL is used for this shipping', 172),
(10337, '2004-11-21 00:00:00', '2004-11-30 00:00:00', '2004-11-26 00:00:00', 'Shipped', NULL, 424),
(10338, '2004-11-22 00:00:00', '2004-12-02 00:00:00', '2004-11-27 00:00:00', 'Shipped', NULL, 381),
(10339, '2004-11-23 00:00:00', '2004-11-30 00:00:00', '2004-11-30 00:00:00', 'Shipped', NULL, 398),
(10340, '2004-11-24 00:00:00', '2004-12-01 00:00:00', '2004-11-25 00:00:00', 'Shipped', 'Customer is interested in buying more Ferrari models', 216),
(10341, '2004-11-24 00:00:00', '2004-12-01 00:00:00', '2004-11-29 00:00:00', 'Shipped', NULL, 382),
(10342, '2004-11-24 00:00:00', '2004-12-01 00:00:00', '2004-11-29 00:00:00', 'Shipped', NULL, 114),
(10343, '2004-11-24 00:00:00', '2004-12-01 00:00:00', '2004-11-26 00:00:00', 'Shipped', NULL, 353),
(10344, '2004-11-25 00:00:00', '2004-12-02 00:00:00', '2004-11-29 00:00:00', 'Shipped', NULL, 350),
(10345, '2004-11-25 00:00:00', '2004-12-01 00:00:00', '2004-11-26 00:00:00', 'Shipped', NULL, 103),
(10346, '2004-11-29 00:00:00', '2004-12-05 00:00:00', '2004-11-30 00:00:00', 'Shipped', NULL, 112),
(10347, '2004-11-29 00:00:00', '2004-12-07 00:00:00', '2004-11-30 00:00:00', 'Shipped', 'Can we deliver the new Ford Mustang models by end-of-quarter?', 114),
(10348, '2004-11-01 00:00:00', '2004-11-08 00:00:00', '2004-11-05 00:00:00', 'Shipped', NULL, 458),
(10349, '2004-12-01 00:00:00', '2004-12-07 00:00:00', '2004-12-03 00:00:00', 'Shipped', NULL, 151),
(10350, '2004-12-02 00:00:00', '2004-12-08 00:00:00', '2004-12-05 00:00:00', 'Shipped', NULL, 141),
(10351, '2004-12-03 00:00:00', '2004-12-11 00:00:00', '2004-12-07 00:00:00', 'Shipped', NULL, 324),
(10352, '2004-12-03 00:00:00', '2004-12-12 00:00:00', '2004-12-09 00:00:00', 'Shipped', NULL, 198),
(10353, '2004-12-04 00:00:00', '2004-12-11 00:00:00', '2004-12-05 00:00:00', 'Shipped', NULL, 447),
(10354, '2004-12-04 00:00:00', '2004-12-10 00:00:00', '2004-12-05 00:00:00', 'Shipped', NULL, 323),
(10355, '2004-12-07 00:00:00', '2004-12-14 00:00:00', '2004-12-13 00:00:00', 'Shipped', NULL, 141),
(10356, '2004-12-09 00:00:00', '2004-12-15 00:00:00', '2004-12-12 00:00:00', 'Shipped', NULL, 250),
(10357, '2004-12-10 00:00:00', '2004-12-16 00:00:00', '2004-12-14 00:00:00', 'Shipped', NULL, 124),
(10358, '2004-12-10 00:00:00', '2004-12-16 00:00:00', '2004-12-16 00:00:00', 'Shipped', 'Customer requested that DHL is used for this shipping', 141),
(10359, '2004-12-15 00:00:00', '2004-12-23 00:00:00', '2004-12-18 00:00:00', 'Shipped', NULL, 353),
(10360, '2004-12-16 00:00:00', '2004-12-22 00:00:00', '2004-12-18 00:00:00', 'In Process', '', 496),
(10361, '2004-12-17 00:00:00', '2004-12-24 00:00:00', '2004-12-20 00:00:00', 'Shipped', NULL, 282),
(10362, '2005-01-05 00:00:00', '2005-01-16 00:00:00', '2005-01-10 00:00:00', 'Shipped', NULL, 161),
(10363, '2005-01-06 00:00:00', '2005-01-12 00:00:00', '2005-01-10 00:00:00', 'Shipped', NULL, 334),
(10364, '2005-01-06 00:00:00', '2005-01-17 00:00:00', '2005-01-09 00:00:00', 'Shipped', NULL, 350),
(10365, '2005-01-07 00:00:00', '2005-01-18 00:00:00', '2005-01-11 00:00:00', 'Shipped', NULL, 320),
(10366, '2005-01-10 00:00:00', '2005-01-19 00:00:00', '2005-01-12 00:00:00', 'Shipped', NULL, 381),
(10367, '2005-01-12 00:00:00', '2005-01-21 00:00:00', '2005-01-16 00:00:00', 'Resolved', 'This order was disputed and resolved on 2/1/2005. Customer claimed that container with shipment was damaged. FedEx''s investigation proved this wrong.', 205),
(10368, '2005-01-19 00:00:00', '2005-01-27 00:00:00', '2005-01-24 00:00:00', 'Shipped', 'Can we renegotiate this one?', 124),
(10369, '2005-01-20 00:00:00', '2005-01-28 00:00:00', '2005-01-24 00:00:00', 'Shipped', NULL, 379),
(10370, '2005-01-20 00:00:00', '2005-02-01 00:00:00', '2005-01-25 00:00:00', 'Shipped', NULL, 276),
(10371, '2005-01-23 00:00:00', '2005-02-03 00:00:00', '2005-01-25 00:00:00', 'Shipped', NULL, 124),
(10372, '2005-01-26 00:00:00', '2005-02-05 00:00:00', '2005-01-28 00:00:00', 'Shipped', NULL, 398),
(10373, '2005-01-31 00:00:00', '2005-02-08 00:00:00', '2005-02-06 00:00:00', 'Shipped', NULL, 311),
(10374, '2005-02-02 00:00:00', '2005-02-09 00:00:00', '2005-02-03 00:00:00', 'Shipped', NULL, 333),
(10375, '2005-02-03 00:00:00', '2005-02-10 00:00:00', '2005-02-06 00:00:00', 'Shipped', NULL, 119),
(10376, '2005-02-08 00:00:00', '2005-02-18 00:00:00', '2005-02-13 00:00:00', 'Shipped', NULL, 219),
(10377, '2005-02-09 00:00:00', '2005-02-21 00:00:00', '2005-02-12 00:00:00', 'Shipped', 'Cautious optimism. We have happy customers here, if we can keep them well stocked.  I need all the information I can get on the planned shippments of Porches', 186),
(10378, '2005-02-10 00:00:00', '2005-02-18 00:00:00', '2005-02-11 00:00:00', 'Shipped', NULL, 141),
(10379, '2005-02-10 00:00:00', '2005-02-18 00:00:00', '2005-02-11 00:00:00', 'Shipped', NULL, 141),
(10380, '2005-02-16 00:00:00', '2005-02-24 00:00:00', '2005-02-18 00:00:00', 'Shipped', NULL, 141),
(10381, '2005-02-17 00:00:00', '2005-02-25 00:00:00', '2005-02-18 00:00:00', 'Shipped', NULL, 321),
(10382, '2005-02-17 00:00:00', '2005-02-23 00:00:00', '2005-02-18 00:00:00', 'Shipped', 'Custom shipping instructions sent to warehouse', 124),
(10383, '2005-02-22 00:00:00', '2005-03-02 00:00:00', '2005-02-25 00:00:00', 'Shipped', NULL, 141),
(10384, '2005-02-23 00:00:00', '2005-03-06 00:00:00', '2005-02-27 00:00:00', 'Shipped', NULL, 321),
(10385, '2005-02-28 00:00:00', '2005-03-09 00:00:00', '2005-03-01 00:00:00', 'Shipped', NULL, 124),
(10386, '2005-03-01 00:00:00', '2005-03-09 00:00:00', '2005-03-06 00:00:00', 'Resolved', 'Disputed then Resolved on 3/15/2005. Customer doesn''t like the craftsmaship of the models.', 141),
(10387, '2005-03-02 00:00:00', '2005-03-09 00:00:00', '2005-03-06 00:00:00', 'Shipped', 'We need to keep in close contact with their Marketing VP. He is the decision maker for all their purchases.', 148),
(10388, '2005-03-03 00:00:00', '2005-03-11 00:00:00', '2005-03-09 00:00:00', 'Shipped', NULL, 462),
(10389, '2005-03-03 00:00:00', '2005-03-09 00:00:00', '2005-03-08 00:00:00', 'Shipped', NULL, 448),
(10390, '2005-03-04 00:00:00', '2005-03-11 00:00:00', '2005-03-07 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 124),
(10391, '2005-03-09 00:00:00', '2005-03-20 00:00:00', '2005-03-15 00:00:00', 'Shipped', NULL, 276),
(10392, '2005-03-10 00:00:00', '2005-03-18 00:00:00', '2005-03-12 00:00:00', 'Shipped', NULL, 452),
(10393, '2005-03-11 00:00:00', '2005-03-22 00:00:00', '2005-03-14 00:00:00', 'Shipped', 'They want to reevaluate their terms agreement with Finance.', 323),
(10394, '2005-03-15 00:00:00', '2005-03-25 00:00:00', '2005-03-19 00:00:00', 'Shipped', NULL, 141),
(10395, '2005-03-17 00:00:00', '2005-03-24 00:00:00', '2005-03-23 00:00:00', 'Shipped', 'We must be cautions with this customer. Their VP of Sales resigned. Company may be heading down.', 250),
(10396, '2005-03-23 00:00:00', '2005-04-02 00:00:00', '2005-03-28 00:00:00', 'Shipped', NULL, 124),
(10397, '2005-03-28 00:00:00', '2005-04-09 00:00:00', '2005-04-01 00:00:00', 'Shipped', NULL, 242),
(10398, '2005-03-30 00:00:00', '2005-04-09 00:00:00', '2005-03-31 00:00:00', 'Shipped', NULL, 353),
(10399, '2005-04-01 00:00:00', '2005-04-12 00:00:00', '2005-04-03 00:00:00', 'Shipped', NULL, 496),
(10400, '2005-04-01 00:00:00', '2005-04-11 00:00:00', '2005-04-04 00:00:00', 'Shipped', 'Customer requested that DHL is used for this shipping', 450),
(10401, '2005-04-03 00:00:00', '2005-04-14 00:00:00', NULL, 'On Hold', 'Customer credit limit exceeded. Will ship when a payment is received.', 328),
(10402, '2005-04-07 00:00:00', '2005-04-14 00:00:00', '2005-04-12 00:00:00', 'Shipped', NULL, 406),
(10403, '2005-04-08 00:00:00', '2005-04-18 00:00:00', '2005-04-11 00:00:00', 'Shipped', NULL, 201),
(10404, '2005-04-08 00:00:00', '2005-04-14 00:00:00', '2005-04-11 00:00:00', 'Shipped', NULL, 323),
(10405, '2005-04-14 00:00:00', '2005-04-24 00:00:00', '2005-04-20 00:00:00', 'Shipped', NULL, 209),
(10406, '2005-04-15 00:00:00', '2005-04-25 00:00:00', '2005-04-21 00:00:00', 'Disputed', 'Customer claims container with shipment was damaged during shipping and some items were missing. I am talking to FedEx about this.', 145),
(10407, '2005-04-22 00:00:00', '2005-05-04 00:00:00', NULL, 'On Hold', 'Customer credit limit exceeded. Will ship when a payment is received.', 450),
(10408, '2005-04-22 00:00:00', '2005-04-29 00:00:00', '2005-04-27 00:00:00', 'Shipped', NULL, 398),
(10409, '2005-04-23 00:00:00', '2005-05-05 00:00:00', '2005-04-24 00:00:00', 'Shipped', NULL, 166),
(10410, '2005-04-29 00:00:00', '2005-05-10 00:00:00', '2005-04-30 00:00:00', 'Shipped', NULL, 357),
(10411, '2005-05-01 00:00:00', '2005-05-08 00:00:00', '2005-05-06 00:00:00', 'Shipped', NULL, 233),
(10412, '2005-05-03 00:00:00', '2005-05-13 00:00:00', '2005-05-05 00:00:00', 'Shipped', NULL, 141),
(10413, '2005-05-05 00:00:00', '2005-05-14 00:00:00', '2005-05-09 00:00:00', 'Shipped', 'Customer requested that DHL is used for this shipping', 175),
(10414, '2005-05-06 00:00:00', '2005-05-13 00:00:00', NULL, 'On Hold', 'Customer credit limit exceeded. Will ship when a payment is received.', 362),
(10415, '2005-05-09 00:00:00', '2005-05-20 00:00:00', '2005-05-12 00:00:00', 'Disputed', 'Customer claims the scales of the models don''t match what was discussed. I keep all the paperwork though to prove otherwise', 471),
(10416, '2005-05-10 00:00:00', '2005-05-16 00:00:00', '2005-05-14 00:00:00', 'Shipped', NULL, 386),
(10417, '2005-05-13 00:00:00', '2005-05-19 00:00:00', '2005-05-19 00:00:00', 'Disputed', 'Customer doesn''t like the colors and precision of the models.', 141),
(10418, '2005-05-16 00:00:00', '2005-05-24 00:00:00', '2005-05-20 00:00:00', 'Shipped', NULL, 412),
(10419, '2005-05-17 00:00:00', '2005-05-28 00:00:00', '2005-05-19 00:00:00', 'Shipped', NULL, 382),
(10420, '2005-05-29 00:00:00', '2005-06-07 00:00:00', NULL, 'In Process', NULL, 282),
(10421, '2005-05-29 00:00:00', '2005-06-06 00:00:00', NULL, 'In Process', 'Custom shipping instructions were sent to warehouse', 124),
(10422, '2005-05-30 00:00:00', '2005-06-11 00:00:00', NULL, 'In Process', NULL, 157),
(10423, '2005-05-30 00:00:00', '2005-06-05 00:00:00', NULL, 'In Process', NULL, 314),
(10424, '2005-05-31 00:00:00', '2005-06-08 00:00:00', NULL, 'In Process', NULL, 141),
(10425, '2005-05-31 00:00:00', '2005-06-07 00:00:00', NULL, 'In Process', NULL, 119),
(10426, '2013-11-30 20:03:14', '2013-11-30 20:03:11', '2013-11-30 20:03:09', '1', '<p>тест</p>', 5);

DROP TABLE IF EXISTS `payments`;
CREATE TABLE IF NOT EXISTS `payments` (
  `paymentId` int(11) NOT NULL AUTO_INCREMENT,
  `customerNumber` int(11) NOT NULL,
  `checkNumber` varchar(50) NOT NULL,
  `paymentDate` datetime NOT NULL,
  `amount` double NOT NULL,
  PRIMARY KEY (`paymentId`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=274 ;

INSERT INTO `payments` (`paymentId`, `customerNumber`, `checkNumber`, `paymentDate`, `amount`) VALUES
(1, 103, 'HQ336336', '2004-10-19 00:00:00', 6066.78),
(2, 103, 'JM555205', '2003-06-05 00:00:00', 14571.44),
(3, 103, 'OM314933', '2004-12-18 00:00:00', 1676.14),
(4, 112, 'BO864823', '2004-12-17 00:00:00', 14191.12),
(5, 112, 'HQ55022', '2003-06-06 00:00:00', 32641.98),
(6, 112, 'ND748579', '2004-08-20 00:00:00', 33347.88),
(7, 114, 'GG31455', '2003-05-20 00:00:00', 45864.03),
(8, 114, 'MA765515', '2004-12-15 00:00:00', 82261.22),
(9, 114, 'NP603840', '2003-05-31 00:00:00', 7565.08),
(10, 114, 'NR27552', '2004-03-10 00:00:00', 44894.74),
(11, 119, 'DB933704', '2004-11-14 00:00:00', 19501.82),
(12, 119, 'LN373447', '2004-08-08 00:00:00', 47924.19),
(13, 119, 'NG94694', '2005-02-22 00:00:00', 49523.67),
(14, 121, 'DB889831', '2003-02-16 00:00:00', 50218.95),
(15, 121, 'FD317790', '2003-10-28 00:00:00', 1491.38),
(16, 121, 'KI831359', '2004-11-04 00:00:00', 17876.32),
(17, 121, 'MA302151', '2004-11-28 00:00:00', 34638.14),
(18, 124, 'AE215433', '2005-03-05 00:00:00', 101244.59),
(19, 124, 'BG255406', '2004-08-28 00:00:00', 85410.87),
(20, 124, 'CQ287967', '2003-04-11 00:00:00', 11044.3),
(21, 124, 'ET64396', '2005-04-16 00:00:00', 83598.04),
(22, 124, 'HI366474', '2004-12-27 00:00:00', 47142.7),
(23, 124, 'HR86578', '2004-11-02 00:00:00', 55639.66),
(24, 124, 'KI131716', '2003-08-15 00:00:00', 111654.4),
(25, 124, 'LF217299', '2004-03-26 00:00:00', 43369.3),
(26, 124, 'NT141748', '2003-11-25 00:00:00', 45084.38),
(27, 128, 'DI925118', '2003-01-28 00:00:00', 10549.01),
(28, 128, 'FA465482', '2003-10-18 00:00:00', 24101.81),
(29, 128, 'FH668230', '2004-03-24 00:00:00', 33820.62),
(30, 128, 'IP383901', '2004-11-18 00:00:00', 7466.32),
(31, 129, 'DM826140', '2004-12-08 00:00:00', 26248.78),
(32, 129, 'ID449593', '2003-12-11 00:00:00', 23923.93),
(33, 129, 'PI42991', '2003-04-09 00:00:00', 16537.85),
(34, 131, 'CL442705', '2003-03-12 00:00:00', 22292.62),
(35, 131, 'MA724562', '2004-12-02 00:00:00', 50025.35),
(36, 131, 'NB445135', '2004-09-11 00:00:00', 35321.97),
(37, 141, 'AU364101', '2003-07-19 00:00:00', 36251.03),
(38, 141, 'DB583216', '2004-11-01 00:00:00', 36140.38),
(39, 141, 'DL460618', '2005-05-19 00:00:00', 46895.48),
(40, 141, 'HJ32686', '2004-01-30 00:00:00', 59830.55),
(41, 141, 'ID10962', '2004-12-31 00:00:00', 116208.4),
(42, 141, 'IN446258', '2005-03-25 00:00:00', 65071.26),
(43, 141, 'JE105477', '2005-03-18 00:00:00', 120166.58),
(44, 141, 'JN355280', '2003-10-26 00:00:00', 49539.37),
(45, 141, 'JN722010', '2003-02-25 00:00:00', 40206.2),
(46, 141, 'KT52578', '2003-12-09 00:00:00', 63843.55),
(47, 141, 'MC46946', '2004-07-09 00:00:00', 35420.74),
(48, 141, 'MF629602', '2004-08-16 00:00:00', 20009.53),
(49, 141, 'NU627706', '2004-05-17 00:00:00', 26155.91),
(50, 144, 'IR846303', '2004-12-12 00:00:00', 36005.71),
(51, 144, 'LA685678', '2003-04-09 00:00:00', 7674.94),
(52, 145, 'CN328545', '2004-07-03 00:00:00', 4710.73),
(53, 145, 'ED39322', '2004-04-26 00:00:00', 28211.7),
(54, 145, 'HR182688', '2004-12-01 00:00:00', 20564.86),
(55, 145, 'JJ246391', '2003-02-20 00:00:00', 53959.21),
(56, 146, 'FP549817', '2004-03-18 00:00:00', 40978.53),
(57, 146, 'FU793410', '2004-01-16 00:00:00', 49614.72),
(58, 146, 'LJ160635', '2003-12-10 00:00:00', 39712.1),
(59, 148, 'BI507030', '2003-04-22 00:00:00', 44380.15),
(60, 148, 'DD635282', '2004-08-11 00:00:00', 2611.84),
(61, 148, 'KM172879', '2003-12-26 00:00:00', 105743),
(62, 148, 'ME497970', '2005-03-27 00:00:00', 3516.04),
(63, 151, 'BF686658', '2003-12-22 00:00:00', 58793.53),
(64, 151, 'GB852215', '2004-07-26 00:00:00', 20314.44),
(65, 151, 'IP568906', '2003-06-18 00:00:00', 58841.35),
(66, 151, 'KI884577', '2004-12-14 00:00:00', 39964.63),
(67, 157, 'HI618861', '2004-11-19 00:00:00', 35152.12),
(68, 157, 'NN711988', '2004-09-07 00:00:00', 63357.13),
(69, 161, 'BR352384', '2004-11-14 00:00:00', 2434.25),
(70, 161, 'BR478494', '2003-11-18 00:00:00', 50743.65),
(71, 161, 'KG644125', '2005-02-02 00:00:00', 12692.19),
(72, 161, 'NI908214', '2003-08-05 00:00:00', 38675.13),
(73, 166, 'BQ327613', '2004-09-16 00:00:00', 38785.48),
(74, 166, 'DC979307', '2004-07-07 00:00:00', 44160.92),
(75, 166, 'LA318629', '2004-02-28 00:00:00', 22474.17),
(76, 167, 'ED743615', '2004-09-19 00:00:00', 12538.01),
(77, 167, 'GN228846', '2003-12-03 00:00:00', 85024.46),
(78, 171, 'GB878038', '2004-03-15 00:00:00', 18997.89),
(79, 171, 'IL104425', '2003-11-22 00:00:00', 42783.81),
(80, 172, 'AD832091', '2004-09-09 00:00:00', 1960.8),
(81, 172, 'CE51751', '2004-12-04 00:00:00', 51209.58),
(82, 172, 'EH208589', '2003-04-20 00:00:00', 33383.14),
(83, 173, 'GP545698', '2004-05-13 00:00:00', 11843.45),
(84, 173, 'IG462397', '2004-03-29 00:00:00', 20355.24),
(85, 175, 'IO448913', '2003-11-19 00:00:00', 24879.08),
(86, 175, 'PI15215', '2004-07-10 00:00:00', 42044.77),
(87, 177, 'AU750837', '2004-04-17 00:00:00', 15183.63),
(88, 177, 'CI381435', '2004-01-19 00:00:00', 47177.59),
(89, 181, 'CM564612', '2004-04-25 00:00:00', 22602.36),
(90, 175, 'CITI3434344', '2005-05-19 00:00:00', 28500.78),
(91, 209, 'BOAF82044', '2005-05-03 00:00:00', 35157.75),
(92, 181, 'GQ132144', '2003-01-30 00:00:00', 5494.78),
(93, 181, 'OH367219', '2004-11-16 00:00:00', 44400.5),
(94, 186, 'AE192287', '2005-03-10 00:00:00', 23602.9),
(95, 186, 'AK412714', '2003-10-27 00:00:00', 37602.48),
(96, 186, 'KA602407', '2004-10-21 00:00:00', 34341.08),
(97, 187, 'AM968797', '2004-11-03 00:00:00', 52825.29),
(98, 187, 'BQ39062', '2004-12-08 00:00:00', 47159.11),
(99, 187, 'KL124726', '2003-03-27 00:00:00', 48425.69),
(100, 189, 'BO711618', '2004-10-03 00:00:00', 17359.53),
(101, 189, 'NM916675', '2004-03-01 00:00:00', 32538.74),
(102, 198, 'FI192930', '2004-12-06 00:00:00', 9658.74),
(103, 198, 'HQ920205', '2003-07-06 00:00:00', 6036.96),
(104, 198, 'IS946883', '2004-09-21 00:00:00', 5858.56),
(105, 201, 'DP677013', '2003-10-20 00:00:00', 23908.24),
(106, 201, 'OO846801', '2004-06-15 00:00:00', 37258.94),
(107, 202, 'HI358554', '2003-12-18 00:00:00', 36527.61),
(108, 202, 'IQ627690', '2004-11-08 00:00:00', 33594.58),
(109, 204, 'GC697638', '2004-08-13 00:00:00', 51152.86),
(110, 204, 'IS150005', '2004-09-24 00:00:00', 4424.4),
(111, 205, 'GL756480', '2003-12-04 00:00:00', 3879.96),
(112, 205, 'LL562733', '2003-09-05 00:00:00', 50342.74),
(113, 205, 'NM739638', '2005-02-06 00:00:00', 39580.6),
(114, 209, 'ED520529', '2004-06-21 00:00:00', 4632.31),
(115, 209, 'PH785937', '2004-05-04 00:00:00', 36069.26),
(116, 211, 'BJ535230', '2003-12-09 00:00:00', 45480.79),
(117, 216, 'BG407567', '2003-05-09 00:00:00', 3101.4),
(118, 216, 'ML780814', '2004-12-06 00:00:00', 24945.21),
(119, 216, 'MM342086', '2003-12-14 00:00:00', 40473.86),
(120, 219, 'BN17870', '2005-03-02 00:00:00', 3452.75),
(121, 219, 'BR941480', '2003-10-18 00:00:00', 4465.85),
(122, 227, 'MQ413968', '2003-10-31 00:00:00', 36164.46),
(123, 227, 'NU21326', '2004-11-02 00:00:00', 53745.34),
(124, 233, 'II180006', '2004-07-01 00:00:00', 22997.45),
(125, 233, 'JG981190', '2003-11-18 00:00:00', 16909.84),
(126, 239, 'NQ865547', '2004-03-15 00:00:00', 80375.24),
(127, 240, 'IF245157', '2004-11-16 00:00:00', 46788.14),
(128, 240, 'JO719695', '2004-03-28 00:00:00', 24995.61),
(129, 242, 'AF40894', '2003-11-22 00:00:00', 33818.34),
(130, 242, 'HR224331', '2005-06-03 00:00:00', 12432.32),
(131, 242, 'KI744716', '2003-07-21 00:00:00', 14232.7),
(132, 249, 'IJ399820', '2004-09-19 00:00:00', 33924.24),
(133, 249, 'NE404084', '2004-09-04 00:00:00', 48298.99),
(134, 250, 'EQ12267', '2005-05-17 00:00:00', 17928.09),
(135, 250, 'HD284647', '2004-12-30 00:00:00', 26311.63),
(136, 250, 'HN114306', '2003-07-18 00:00:00', 23419.47),
(137, 256, 'EP227123', '2004-02-10 00:00:00', 5759.42),
(138, 256, 'HE84936', '2004-10-22 00:00:00', 53116.99),
(139, 259, 'EU280955', '2004-11-06 00:00:00', 61234.67),
(140, 259, 'GB361972', '2003-12-07 00:00:00', 27988.47),
(141, 260, 'IO164641', '2004-08-30 00:00:00', 37527.58),
(142, 260, 'NH776924', '2004-04-24 00:00:00', 29284.42),
(143, 276, 'EM979878', '2005-02-09 00:00:00', 27083.78),
(144, 276, 'KM841847', '2003-11-13 00:00:00', 38547.19),
(145, 276, 'LE432182', '2003-09-28 00:00:00', 41554.73),
(146, 276, 'OJ819725', '2005-04-30 00:00:00', 29848.52),
(147, 278, 'BJ483870', '2004-12-05 00:00:00', 37654.09),
(148, 278, 'GP636783', '2003-03-02 00:00:00', 52151.81),
(149, 278, 'NI983021', '2003-11-24 00:00:00', 37723.79),
(150, 282, 'IA793562', '2003-08-03 00:00:00', 24013.52),
(151, 282, 'JT819493', '2004-08-02 00:00:00', 35806.73),
(152, 282, 'OD327378', '2005-01-03 00:00:00', 31835.36),
(153, 286, 'DR578578', '2004-10-28 00:00:00', 47411.33),
(154, 286, 'KH910279', '2004-09-05 00:00:00', 43134.04),
(155, 298, 'AJ574927', '2004-03-13 00:00:00', 47375.92),
(156, 298, 'LF501133', '2004-09-18 00:00:00', 61402),
(157, 299, 'AD304085', '2003-10-24 00:00:00', 36798.88),
(158, 299, 'NR157385', '2004-09-05 00:00:00', 32260.16),
(159, 311, 'DG336041', '2005-02-15 00:00:00', 46770.52),
(160, 311, 'FA728475', '2003-10-06 00:00:00', 32723.04),
(161, 311, 'NQ966143', '2004-04-25 00:00:00', 16212.59),
(162, 314, 'LQ244073', '2004-08-09 00:00:00', 45352.47),
(163, 314, 'MD809704', '2004-03-03 00:00:00', 16901.38),
(164, 319, 'HL685576', '2004-11-06 00:00:00', 42339.76),
(165, 319, 'OM548174', '2003-12-07 00:00:00', 36092.4),
(166, 320, 'GJ597719', '2005-01-18 00:00:00', 8307.28),
(167, 320, 'HO576374', '2003-08-20 00:00:00', 41016.75),
(168, 320, 'MU817160', '2003-11-24 00:00:00', 52548.49),
(169, 321, 'DJ15149', '2003-11-03 00:00:00', 85559.12),
(170, 321, 'LA556321', '2005-03-15 00:00:00', 46781.66),
(171, 323, 'AL493079', '2005-05-23 00:00:00', 75020.13),
(172, 323, 'ES347491', '2004-06-24 00:00:00', 37281.36),
(173, 323, 'HG738664', '2003-07-05 00:00:00', 2880),
(174, 323, 'PQ803830', '2004-12-24 00:00:00', 39440.59),
(175, 324, 'DQ409197', '2004-12-13 00:00:00', 13671.82),
(176, 324, 'FP443161', '2003-07-07 00:00:00', 29429.14),
(177, 324, 'HB150714', '2003-11-23 00:00:00', 37455.77),
(178, 328, 'EN930356', '2004-04-16 00:00:00', 7178.66),
(179, 328, 'NR631421', '2004-05-30 00:00:00', 31102.85),
(180, 333, 'HL209210', '2003-11-15 00:00:00', 23936.53),
(181, 333, 'JK479662', '2003-10-17 00:00:00', 9821.32),
(182, 333, 'NF959653', '2005-03-01 00:00:00', 21432.31),
(183, 334, 'CS435306', '2005-01-27 00:00:00', 45785.34),
(184, 334, 'HH517378', '2003-08-16 00:00:00', 29716.86),
(185, 334, 'LF737277', '2004-05-22 00:00:00', 28394.54),
(186, 339, 'AP286625', '2004-10-24 00:00:00', 23333.06),
(187, 339, 'DA98827', '2003-11-28 00:00:00', 34606.28),
(188, 344, 'AF246722', '2003-11-24 00:00:00', 31428.21),
(189, 344, 'NJ906924', '2004-04-02 00:00:00', 15322.93),
(190, 347, 'DG700707', '2004-01-18 00:00:00', 21053.69),
(191, 347, 'LG808674', '2003-10-24 00:00:00', 20452.5),
(192, 350, 'BQ602907', '2004-12-11 00:00:00', 18888.31),
(193, 350, 'CI471510', '2003-05-25 00:00:00', 50824.66),
(194, 350, 'OB648482', '2005-01-29 00:00:00', 1834.56),
(195, 353, 'CO351193', '2005-01-10 00:00:00', 49705.52),
(196, 353, 'ED878227', '2003-07-21 00:00:00', 13920.26),
(197, 353, 'GT878649', '2003-05-21 00:00:00', 16700.47),
(198, 353, 'HJ618252', '2005-06-09 00:00:00', 46656.94),
(199, 357, 'AG240323', '2003-12-16 00:00:00', 20220.04),
(200, 357, 'NB291497', '2004-05-15 00:00:00', 36442.34),
(201, 362, 'FP170292', '2004-07-11 00:00:00', 18473.71),
(202, 362, 'OG208861', '2004-09-21 00:00:00', 15059.76),
(203, 363, 'HL575273', '2004-11-17 00:00:00', 50799.69),
(204, 363, 'IS232033', '2003-01-16 00:00:00', 10223.83),
(205, 363, 'PN238558', '2003-12-05 00:00:00', 55425.77),
(206, 379, 'CA762595', '2005-02-12 00:00:00', 28322.83),
(207, 379, 'FR499138', '2003-09-16 00:00:00', 32680.31),
(208, 379, 'GB890854', '2004-08-02 00:00:00', 12530.51),
(209, 381, 'BC726082', '2004-12-03 00:00:00', 12081.52),
(210, 381, 'CC475233', '2003-04-19 00:00:00', 1627.56),
(211, 381, 'GB117430', '2005-02-03 00:00:00', 14379.9),
(212, 381, 'MS154481', '2003-08-22 00:00:00', 1128.2),
(213, 382, 'CC871084', '2003-05-12 00:00:00', 35826.33),
(214, 382, 'CT821147', '2004-08-01 00:00:00', 6419.84),
(215, 382, 'PH29054', '2004-11-27 00:00:00', 42813.83),
(216, 385, 'BN347084', '2003-12-02 00:00:00', 20644.24),
(217, 385, 'CP804873', '2004-11-19 00:00:00', 15822.84),
(218, 385, 'EK785462', '2003-03-09 00:00:00', 51001.22),
(219, 386, 'DO106109', '2003-11-18 00:00:00', 38524.29),
(220, 386, 'HG438769', '2004-07-18 00:00:00', 51619.02),
(221, 398, 'AJ478695', '2005-02-14 00:00:00', 33967.73),
(222, 398, 'DO787644', '2004-06-21 00:00:00', 22037.91),
(223, 398, 'KB54275', '2004-11-29 00:00:00', 48927.64),
(224, 406, 'HJ217687', '2004-01-28 00:00:00', 49165.16),
(225, 406, 'NA197101', '2004-06-17 00:00:00', 25080.96),
(226, 412, 'GH197075', '2004-07-25 00:00:00', 35034.57),
(227, 412, 'PJ434867', '2004-04-14 00:00:00', 31670.37),
(228, 415, 'ER54537', '2004-09-28 00:00:00', 31310.09),
(229, 424, 'KF480160', '2004-12-07 00:00:00', 25505.98),
(230, 424, 'LM271923', '2003-04-16 00:00:00', 21665.98),
(231, 424, 'OA595449', '2003-10-31 00:00:00', 22042.37),
(232, 447, 'AO757239', '2003-09-15 00:00:00', 6631.36),
(233, 447, 'ER615123', '2003-06-25 00:00:00', 17032.29),
(234, 447, 'OU516561', '2004-12-17 00:00:00', 26304.13),
(235, 448, 'FS299615', '2005-04-18 00:00:00', 27966.54),
(236, 448, 'KR822727', '2004-09-30 00:00:00', 48809.9),
(237, 450, 'EF485824', '2004-06-21 00:00:00', 59551.38),
(238, 452, 'ED473873', '2003-11-15 00:00:00', 27121.9),
(239, 452, 'FN640986', '2003-11-20 00:00:00', 15130.97),
(240, 452, 'HG635467', '2005-05-03 00:00:00', 8807.12),
(241, 455, 'HA777606', '2003-12-05 00:00:00', 38139.18),
(242, 455, 'IR662429', '2004-05-12 00:00:00', 32239.47),
(243, 456, 'GJ715659', '2004-11-13 00:00:00', 27550.51),
(244, 456, 'MO743231', '2004-04-30 00:00:00', 1679.92),
(245, 458, 'DD995006', '2004-11-15 00:00:00', 33145.56),
(246, 458, 'NA377824', '2004-02-06 00:00:00', 22162.61),
(247, 458, 'OO606861', '2003-06-13 00:00:00', 57131.92),
(248, 462, 'ED203908', '2005-04-15 00:00:00', 30293.77),
(249, 462, 'GC60330', '2003-11-08 00:00:00', 9977.85),
(250, 462, 'PE176846', '2004-11-27 00:00:00', 48355.87),
(251, 471, 'AB661578', '2004-07-28 00:00:00', 9415.13),
(252, 471, 'CO645196', '2003-12-10 00:00:00', 35505.63),
(253, 473, 'LL427009', '2004-02-17 00:00:00', 7612.06),
(254, 473, 'PC688499', '2003-10-27 00:00:00', 17746.26),
(255, 475, 'JP113227', '2003-12-09 00:00:00', 7678.25),
(256, 475, 'PB951268', '2004-02-13 00:00:00', 36070.47),
(257, 484, 'GK294076', '2004-10-26 00:00:00', 3474.66),
(258, 484, 'JH546765', '2003-11-29 00:00:00', 47513.19),
(259, 486, 'BL66528', '2004-04-14 00:00:00', 5899.38),
(260, 486, 'HS86661', '2004-11-23 00:00:00', 45994.07),
(261, 486, 'JB117768', '2003-03-20 00:00:00', 25833.14),
(262, 487, 'AH612904', '2003-09-28 00:00:00', 29997.09),
(263, 487, 'PT550181', '2004-02-29 00:00:00', 12573.28),
(264, 489, 'OC773849', '2003-12-04 00:00:00', 22275.73),
(265, 489, 'PO860906', '2004-01-31 00:00:00', 7310.42),
(266, 495, 'BH167026', '2003-12-26 00:00:00', 59265.14),
(267, 495, 'FN155234', '2004-05-14 00:00:00', 6276.6),
(268, 496, 'EU531600', '2005-05-25 00:00:00', 30253.75),
(269, 496, 'MB342426', '2003-07-16 00:00:00', 32077.44),
(270, 496, 'MN89921', '2004-12-31 00:00:00', 52166),
(271, 233, 'BOFA23232', '2005-05-20 00:00:00', 29070.38),
(272, 398, 'JPMR4544', '2005-05-18 00:00:00', 615.45),
(273, 406, 'BJMPR4545', '2005-04-23 00:00:00', 12190.85);

DROP TABLE IF EXISTS `productlines`;
CREATE TABLE IF NOT EXISTS `productlines` (
  `productLine` varchar(50) NOT NULL,
  `textDescription` varchar(4000) DEFAULT NULL,
  `htmlDescription` mediumtext,
  `image` mediumblob,
  PRIMARY KEY (`productLine`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `productlines` (`productLine`, `textDescription`, `htmlDescription`, `image`) VALUES
('Classic Cars', 'Attention car enthusiasts: Make your wildest car ownership dreams come true. Whether you are looking for classic muscle cars, dream sports cars or movie-inspired miniatures, you will find great choices in this category. These replicas feature superb attention to detail and craftsmanship and offer features such as working steering system, opening forward compartment, opening rear trunk with removable spare wheel, 4-wheel independent spring suspension, and so on. The models range in size from 1:10 to 1:24 scale and include numerous limited edition and several out-of-production vehicles. All models include a certificate of authenticity from their manufacturers and come fully assembled and ready for display in the home or office.', NULL, NULL),
('Motorcycles', 'Our motorcycles are state of the art replicas of classic as well as contemporary motorcycle legends such as Harley Davidson, Ducati and Vespa. Models contain stunning details such as official logos, rotating wheels, working kickstand, front suspension, gear-shift lever, footbrake lever, and drive chain. Materials used include diecast and plastic. The models range in size from 1:10 to 1:50 scale and include numerous limited edition and several out-of-production vehicles. All models come fully assembled and ready for display in the home or office. Most include a certificate of authenticity.', NULL, NULL),
('Planes', 'Unique, diecast airplane and helicopter replicas suitable for collections, as well as home, office or classroom decorations. Models contain stunning details such as official logos and insignias, rotating jet engines and propellers, retractable wheels, and so on. Most come fully assembled and with a certificate of authenticity from their manufacturers.', NULL, NULL),
('Ships', 'The perfect holiday or anniversary gift for executives, clients, friends, and family. These handcrafted model ships are unique, stunning works of art that will be treasured for generations! They come fully assembled and ready for display in the home or office. We guarantee the highest quality, and best value.', NULL, NULL),
('Trains', 'Model trains are a rewarding hobby for enthusiasts of all ages. Whether you''re looking for collectible wooden trains, electric streetcars or locomotives, you''ll find a number of great choices for any budget within this category. The interactive aspect of trains makes toy trains perfect for young children. The wooden train sets are ideal for children under the age of 5.', NULL, NULL),
('trucks', 'r', '<p>q</p>', NULL),
('Trucks and Buses', 'The Truck and Bus models are realistic replicas of buses and specialized trucks produced from the early 1920s to present. The models range in size from 1:12 to 1:50 scale and include numerous limited edition and several out-of-production vehicles. Materials used include tin, diecast and plastic. All models include a certificate of authenticity from their manufacturers and are a perfect ornament for the home and office.', NULL, NULL),
('Vintage Cars', 'Our Vintage Car models realistically portray automobiles produced from the early 1900s through the 1940s. Materials used include Bakelite, diecast, plastic and wood. Most of the replicas are in the 1:18 and 1:24 scale sizes, which provide the optimum in detail and accuracy. Prices range from $30.00 up to $180.00 for some special limited edition replicas. All models include a certificate of authenticity from their manufacturers and come fully assembled and ready for display in the home or office.', NULL, NULL);

DROP TABLE IF EXISTS `products`;
CREATE TABLE IF NOT EXISTS `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `productCode` varchar(15) NOT NULL,
  `productName` varchar(70) NOT NULL,
  `productLine` varchar(50) NOT NULL,
  `productScale` varchar(10) NOT NULL,
  `productVendor` varchar(50) NOT NULL,
  `productDescription` text NOT NULL,
  `quantityInStock` smallint(6) NOT NULL,
  `buyPrice` double NOT NULL,
  `MSRP` double NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=112 ;

INSERT INTO `products` (`id`, `productCode`, `productName`, `productLine`, `productScale`, `productVendor`, `productDescription`, `quantityInStock`, `buyPrice`, `MSRP`) VALUES
(1, 'S10_1678', '1969 Harley Davidson Ultimate Chopper', 'ação, canção, café', '1:10', 'Min Lin Diecast', 'This replica features working kickstand, front suspension, gear-shift lever, footbrake lever, drive chain, wheels and steering. All parts are particularly delicate due to their precise scale and require special care and attention.', 7933, 48.81, 95.7),
(2, 'S10_1949', '1952 Alpine Renault 1300', 'Classic Cars', '1:10', 'Classic Metal Creations', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 7305, 98.58, 214.3),
(3, 'S10_2016', '1996 Moto Guzzi 1100i', 'Motorcycles', '1:10', 'Highway 66 Mini Classics', 'Official Moto Guzzi logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.', 6625, 68.99, 118.94),
(4, 'S10_4698', '2003 Harley-Davidson Eagle Drag Bike', 'Motorcycles', '1:10', 'Red Start Diecast', 'Model features, official Harley Davidson logos and insignias, detachable rear wheelie bar, heavy diecast metal with resin parts, authentic multi-color tampo-printed graphics, separate engine drive belts, free-turning front fork, rotating tires and rear racing slick, certificate of authenticity, detailed engine, display stand\r\n, precision diecast replica, baked enamel finish, 1:10 scale model, removable fender, seat and tank cover piece for displaying the superior detail of the v-twin engine', 5582, 91.02, 193.66),
(5, 'S10_4757', '1972 Alfa Romeo GTA', 'Classic Cars', '1:10', 'Motor City Art Classics', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 3252, 85.68, 136),
(6, 'S10_4962', '1962 LanciaA Delta 16V', 'Classic Cars', '1:10', 'Second Gear Diecast', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 6791, 103.42, 147.74),
(7, 'S12_1099', '1968 Ford Mustang', 'Classic Cars', '1:12', 'Autoart Studio Design', 'Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color dark green.', 68, 95.34, 194.57),
(8, 'S12_1108', '2001 Ferrari Enzo', 'Classic Cars', '1:12', 'Second Gear Diecast', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 3619, 95.59, 207.8),
(9, 'S12_1666', '1958 Setra Bus', 'Trucks and Buses', '1:12', 'Welly Diecast Productions', 'Model features 30 windows, skylights & glare resistant glass, working steering system, original logos', 1579, 77.9, 136.67),
(10, 'S12_2823', '2002 Suzuki XREO', 'Motorcycles', '1:12', 'Unimax Art Galleries', 'Official logos and insignias, saddle bags located on side of motorcycle, detailed engine, working steering, working suspension, two leather seats, luggage rack, dual exhaust pipes, small saddle bag located on handle bars, two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand, diecast metal with plastic parts and baked enamel finish.', 9997, 66.27, 150.62),
(11, 'S12_3148', '1969 Corvair Monza', 'Classic Cars', '1:18', 'Welly Diecast Productions', '1:18 scale die-cast about 10" long doors open, hood opens, trunk opens and wheels roll', 6906, 89.14, 151.08),
(12, 'S12_3380', '1968 Dodge Charger', 'Classic Cars', '1:12', 'Welly Diecast Productions', '1:12 scale model of a 1968 Dodge Charger. Hood, doors and trunk all open to reveal highly detailed interior features. Steering wheel actually turns the front wheels. Color black', 9123, 75.16, 117.44),
(13, 'S12_3891', '1969 Ford Falcon', 'Classic Cars', '1:12', 'Second Gear Diecast', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 1049, 83.05, 173.02),
(14, 'S12_3990', '1970 Plymouth Hemi Cuda', 'Classic Cars', '1:12', 'Studio M Art Models', 'Very detailed 1970 Plymouth Cuda model in 1:12 scale. The Cuda is generally accepted as one of the fastest original muscle cars from the 1970s. This model is a reproduction of one of the orginal 652 cars built in 1970. Red color.', 5663, 31.92, 79.8),
(15, 'S12_4473', '1957 Chevy Pickup', 'Trucks and Buses', '1:12', 'Exoto Designs', '1:12 scale die-cast about 20" long Hood opens, Rubber wheels', 6125, 55.7, 118.5),
(16, 'S12_4675', '1969 Dodge Charger', 'Classic Cars', '1:12', 'Welly Diecast Productions', 'Detailed model of the 1969 Dodge Charger. This model includes finely detailed interior and exterior features. Painted in red and white.', 7323, 58.73, 115.16),
(17, 'S18_1097', '1940 Ford Pickup Truck', 'Trucks and Buses', '1:18', 'Studio M Art Models', 'This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood,  removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box', 2613, 58.33, 116.67),
(18, 'S18_1129', '1993 Mazda RX-7', 'Classic Cars', '1:18', 'Highway 66 Mini Classics', 'This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color red.', 3975, 83.51, 141.54),
(19, 'S18_1342', '1937 Lincoln Berline', 'Vintage Cars', '1:18', 'Motor City Art Classics', 'Features opening engine cover, doors, trunk, and fuel filler cap. Color black', 8693, 60.62, 102.74),
(20, 'S18_1367', '1936 Mercedes-Benz 500K Special Roadster', 'Vintage Cars', '1:18', 'Studio M Art Models', 'This 1:18 scale replica is constructed of heavy die-cast metal and has all the features of the original: working doors and rumble seat, independent spring suspension, detailed interior, working steering system, and a bifold hood that reveals an engine so accurate that it even includes the wiring. All this is topped off with a baked enamel finish. Color white.', 8635, 24.26, 53.91),
(21, 'S18_1589', '1965 Aston Martin DB5', 'Classic Cars', '1:18', 'Classic Metal Creations', 'Die-cast model of the silver 1965 Aston Martin DB5 in silver. This model includes full wire wheels and doors that open with fully detailed passenger compartment. In 1:18 scale, this model measures approximately 10 inches/20 cm long.', 9042, 65.96, 124.44),
(22, 'S18_1662', '1980s Black Hawk Helicopter', 'Planes', '1:18', 'Red Start Diecast', '1:18 scale replica of actual Army''s UH-60L BLACK HAWK Helicopter. 100% hand-assembled. Features rotating rotor blades, propeller blades and rubber wheels.', 5330, 77.27, 157.69),
(23, 'S18_1749', '1917 Grand Touring Sedan', 'Vintage Cars', '1:18', 'Welly Diecast Productions', 'This 1:18 scale replica of the 1917 Grand Touring car has all the features you would expect from museum quality reproductions: all four doors and bi-fold hood opening, detailed engine and instrument panel, chrome-look trim, and tufted upholstery, all topped off with a factory baked-enamel finish.', 2724, 86.7, 170),
(24, 'S18_1889', '1948 Porsche 356-A Roadster', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'This precision die-cast replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 8826, 53.9, 77),
(25, 'S18_1984', '1995 Honda Civic', 'Classic Cars', '1:18', 'Min Lin Diecast', 'This model features, opening hood, opening doors, detailed engine, rear spoiler, opening trunk, working steering, tinted windows, baked enamel finish. Color yellow.', 9772, 93.89, 142.25),
(26, 'S18_2238', '1998 Chrysler Plymouth Prowler', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 4724, 101.51, 163.73),
(27, 'S18_2248', '1911 Ford Town Car', 'Vintage Cars', '1:18', 'Motor City Art Classics', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system.', 540, 33.3, 60.54),
(28, 'S18_2319', '1964 Mercedes Tour Bus', 'Trucks and Buses', '1:18', 'Unimax Art Galleries', 'Exact replica. 100+ parts. working steering system, original logos', 8258, 74.86, 122.73),
(29, 'S18_2325', '1932 Model A Ford J-Coupe', 'Vintage Cars', '1:18', 'Autoart Studio Design', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine', 9354, 58.48, 127.13),
(30, 'S18_2432', '1926 Ford Fire Engine', 'Trucks and Buses', '1:18', 'Carousel DieCast Legends', 'Gleaming red handsome appearance. Everything is here the fire hoses, ladder, axes, bells, lanterns, ready to fight any inferno.', 2018, 24.92, 60.77),
(31, 'S18_2581', 'P-51-D Mustang', 'Planes', '1:72', 'Gearbox Collectibles', 'Has retractable wheels and comes with a stand', 992, 49, 84.48),
(32, 'S18_2625', '1936 Harley Davidson El Knucklehead', 'Motorcycles', '1:18', 'Welly Diecast Productions', 'Intricately detailed with chrome accents and trim, official die-struck logos and baked enamel finish.', 4357, 24.23, 60.57),
(33, 'S18_2795', '1928 Mercedes-Benz SSK', 'Vintage Cars', '1:18', 'Gearbox Collectibles', 'This 1:18 replica features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system, chrome-covered spare, opening doors, detailed and wired engine. Color black.', 548, 72.56, 168.75),
(34, 'S18_2870', '1999 Indy 500 Monte Carlo SS', 'Classic Cars', '1:18', 'Red Start Diecast', 'Features include opening and closing doors. Color: Red', 8164, 56.76, 132),
(35, 'S18_2949', '1913 Ford Model T Speedster', 'Vintage Cars', '1:18', 'Carousel DieCast Legends', 'This 250 part reproduction includes moving handbrakes, clutch, throttle and foot pedals, squeezable horn, detailed wired engine, removable water, gas, and oil cans, pivoting monocle windshield, all topped with a baked enamel red finish. Each replica comes with an Owners Title and Certificate of Authenticity. Color red.', 4189, 60.78, 101.31),
(36, 'S18_2957', '1934 Ford V8 Coupe', 'Vintage Cars', '1:18', 'Min Lin Diecast', 'Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System', 5649, 34.35, 62.46),
(37, 'S18_3029', '1999 Yamaha Speed Boat', 'Ships', '1:18', 'Min Lin Diecast', 'Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 4259, 51.61, 86.02),
(38, 'S18_3136', '18th Century Vintage Horse Carriage', 'Vintage Cars', '1:18', 'Red Start Diecast', 'Hand crafted diecast-like metal horse carriage is re-created in about 1:18 scale of antique horse carriage. This antique style metal Stagecoach is all hand-assembled with many different parts.\r\n\r\nThis collectible metal horse carriage is painted in classic Red, and features turning steering wheel and is entirely hand-finished.', 5992, 60.74, 104.72),
(39, 'S18_3140', '1903 Ford Model A', 'Vintage Cars', '1:18', 'Unimax Art Galleries', 'Features opening trunk,  working steering system', 3913, 68.3, 136.59),
(40, 'S18_3232', '1992 Ferrari 360 Spider red', 'Classic Cars', '1:18', 'Unimax Art Galleries', 'his replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 8347, 77.9, 169.34),
(41, 'S18_3233', '1985 Toyota Supra', 'Classic Cars', '1:18', 'Highway 66 Mini Classics', 'This model features soft rubber tires, working steering, rubber mud guards, authentic Ford logos, detailed undercarriage, opening doors and hood, removable split rear gate, full size spare mounted in bed, detailed interior with opening glove box', 7733, 57.01, 107.57),
(42, 'S18_3259', 'Collectable Wooden Train', 'Trains', '1:18', 'Carousel DieCast Legends', 'Hand crafted wooden toy train set is in about 1:18 scale, 25 inches in total length including 2 additional carts, of actual vintage train. This antique style wooden toy train model set is all hand-assembled with 100% wood.', 6450, 67.56, 100.84),
(43, 'S18_3278', '1969 Dodge Super Bee', 'Classic Cars', '1:18', 'Min Lin Diecast', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 1917, 49.05, 80.41),
(44, 'S18_3320', '1917 Maxwell Touring Car', 'Vintage Cars', '1:18', 'Exoto Designs', 'Features Gold Trim, Full Size Spare Tire, Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System', 7913, 57.54, 99.21),
(45, 'S18_3482', '1976 Ford Gran Torino', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'Highly detailed 1976 Ford Gran Torino "Starsky and Hutch" diecast model. Very well constructed and painted in red and white patterns.', 9127, 73.49, 146.99),
(46, 'S18_3685', '1948 Porsche Type 356 Roadster', 'Classic Cars', '1:18', 'Gearbox Collectibles', 'This model features working front and rear suspension on accurately replicated and actuating shock absorbers as well as opening engine cover, rear stabilizer flap,  and 4 opening doors.', 8990, 62.16, 141.28),
(47, 'S18_3782', '1957 Vespa GS150', 'Motorcycles', '1:18', 'Studio M Art Models', 'Features rotating wheels , working kick stand. Comes with stand.', 7689, 32.95, 62.17),
(48, 'S18_3856', '1941 Chevrolet Special Deluxe Cabriolet', 'Vintage Cars', '1:18', 'Exoto Designs', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system, leather upholstery. Color black.', 2378, 64.58, 105.87),
(49, 'S18_4027', '1970 Triumph Spitfire', 'Classic Cars', '1:18', 'Min Lin Diecast', 'Features include opening and closing doors. Color: White.', 5545, 91.92, 143.62),
(50, 'S18_4409', '1932 Alfa Romeo 8C2300 Spider Sport', 'Vintage Cars', '1:18', 'Exoto Designs', 'This 1:18 scale precision die cast replica features the 6 front headlights of the original, plus a detailed version of the 142 horsepower straight 8 engine, dual spares and their famous comprehensive dashboard. Color black.', 6553, 43.26, 92.03),
(51, 'S18_4522', '1904 Buick Runabout', 'Vintage Cars', '1:18', 'Exoto Designs', 'Features opening trunk,  working steering system', 8290, 52.66, 87.77),
(52, 'S18_4600', '1940s Ford truck', 'Trucks and Buses', '1:18', 'Motor City Art Classics', 'This 1940s Ford Pick-Up truck is re-created in 1:18 scale of original 1940s Ford truck. This antique style metal 1940s Ford Flatbed truck is all hand-assembled. This collectible 1940''s Pick-Up truck is painted in classic dark green color, and features rotating wheels.', 3128, 84.76, 121.08),
(53, 'S18_4668', '1939 Cadillac Limousine', 'Vintage Cars', '1:18', 'Studio M Art Models', 'Features completely detailed interior including Velvet flocked drapes,deluxe wood grain floor, and a wood grain casket with seperate chrome handles', 6645, 23.14, 50.31),
(54, 'S18_4721', '1957 Corvette Convertible', 'Classic Cars', '1:18', 'Classic Metal Creations', '1957 die cast Corvette Convertible in Roman Red with white sides and whitewall tires. 1:18 scale quality die-cast with detailed engine and underbvody. Now you can own The Classic Corvette.', 1249, 69.93, 148.8),
(55, 'S18_4933', '1957 Ford Thunderbird', 'Classic Cars', '1:18', 'Studio M Art Models', 'This 1:18 scale precision die-cast replica, with its optional porthole hardtop and factory baked-enamel Thunderbird Bronze finish, is a 100% accurate rendition of this American classic.', 3209, 34.21, 71.27),
(56, 'S24_1046', '1970 Chevy Chevelle SS 454', 'Classic Cars', '1:24', 'Unimax Art Galleries', 'This model features rotating wheels, working streering system and opening doors. All parts are particularly delicate due to their precise scale and require special care and attention. It should not be picked up by the doors, roof, hood or trunk.', 1005, 49.24, 73.49),
(57, 'S24_1444', '1970 Dodge Coronet', 'Classic Cars', '1:24', 'Highway 66 Mini Classics', '1:24 scale die-cast about 18" long doors open, hood opens and rubber wheels', 4074, 32.37, 57.8),
(58, 'S24_1578', '1997 BMW R 1100 S', 'Motorcycles', '1:24', 'Autoart Studio Design', 'Detailed scale replica with working suspension and constructed from over 70 parts', 7003, 60.86, 112.7),
(59, 'S24_1628', '1966 Shelby Cobra 427 S/C', 'Classic Cars', '1:24', 'Carousel DieCast Legends', 'This diecast model of the 1966 Shelby Cobra 427 S/C includes many authentic details and operating parts. The 1:24 scale model of this iconic lighweight sports car from the 1960s comes in silver and it''s own display case.', 8197, 29.18, 50.31),
(60, 'S24_1785', '1928 British Royal Navy Airplane', 'Planes', '1:24', 'Classic Metal Creations', 'Official logos and insignias', 3627, 66.74, 109.42),
(61, 'S24_1937', '1939 Chevrolet Deluxe Coupe', 'Vintage Cars', '1:24', 'Motor City Art Classics', 'This 1:24 scale die-cast replica of the 1939 Chevrolet Deluxe Coupe has the same classy look as the original. Features opening trunk, hood and doors and a showroom quality baked enamel finish.', 7332, 22.57, 33.19),
(62, 'S24_2000', '1960 BSA Gold Star DBD34', 'Motorcycles', '1:24', 'Highway 66 Mini Classics', 'Detailed scale replica with working suspension and constructed from over 70 parts', 15, 37.32, 76.17),
(63, 'S24_2011', '18th century schooner', 'Ships', '1:24', 'Carousel DieCast Legends', 'All wood with canvas sails. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with 4 masts, all square-rigged.', 1898, 82.34, 122.89),
(64, 'S24_2022', '1938 Cadillac V-16 Presidential Limousine', 'Vintage Cars', '1:24', 'Classic Metal Creations', 'This 1:24 scale precision die cast replica of the 1938 Cadillac V-16 Presidential Limousine has all the details of the original, from the flags on the front to an opening back seat compartment complete with telephone and rifle. Features factory baked-enamel black finish, hood goddess ornament, working jump seats.', 2847, 20.61, 44.8),
(65, 'S24_2300', '1962 Volkswagen Microbus', 'Trucks and Buses', '1:24', 'Autoart Studio Design', 'This 1:18 scale die cast replica of the 1962 Microbus is loaded with features: A working steering system, opening front doors and tailgate, and famous two-tone factory baked enamel finish, are all topped of by the sliding, real fabric, sunroof.', 2327, 61.34, 127.79),
(66, 'S24_2360', '1982 Ducati 900 Monster', 'Motorcycles', '1:24', 'Highway 66 Mini Classics', 'Features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand', 6840, 47.1, 69.26),
(67, 'S24_2766', '1949 Jaguar XK 120', 'Classic Cars', '1:24', 'Classic Metal Creations', 'Precision-engineered from original Jaguar specification in perfect scale ratio. Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 2350, 47.25, 90.87),
(68, 'S24_2840', '1958 Chevy Corvette Limited Edition', 'Classic Cars', '1:24', 'Carousel DieCast Legends', 'The operating parts of this 1958 Chevy Corvette Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, working streering, opening doors and trunk. Color dark green.', 2542, 15.91, 35.36),
(69, 'S24_2841', '1900s Vintage Bi-Plane', 'Planes', '1:24', 'Autoart Studio Design', 'Hand crafted diecast-like metal bi-plane is re-created in about 1:24 scale of antique pioneer airplane. All hand-assembled with many different parts. Hand-painted in classic yellow and features correct markings of original airplane.', 5942, 34.25, 68.51),
(70, 'S24_2887', '1952 Citroen-15CV', 'Classic Cars', '1:24', 'Exoto Designs', 'Precision crafted hand-assembled 1:18 scale reproduction of the 1952 15CV, with its independent spring suspension, working steering system, opening doors and hood, detailed engine and instrument panel, all topped of with a factory fresh baked enamel finish.', 1452, 72.82, 117.44),
(71, 'S24_2972', '1982 Lamborghini Diablo', 'Classic Cars', '1:24', 'Second Gear Diecast', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 7723, 16.24, 37.76),
(72, 'S24_3151', '1912 Ford Model T Delivery Wagon', 'Vintage Cars', '1:24', 'Min Lin Diecast', 'This model features chrome trim and grille, opening hood, opening doors, opening trunk, detailed engine, working steering system. Color white.', 9173, 46.91, 88.51),
(73, 'S24_3191', '1969 Chevrolet Camaro Z28', 'Classic Cars', '1:24', 'Exoto Designs', '1969 Z/28 Chevy Camaro 1:24 scale replica. The operating parts of this limited edition 1:24 scale diecast model car 1969 Chevy Camaro Z28- hood, trunk, wheels, streering, suspension and doors- are particularly delicate due to their precise scale and require special care and attention.', 4695, 50.51, 85.61),
(74, 'S24_3371', '1971 Alpine Renault 1600s', 'Classic Cars', '1:24', 'Welly Diecast Productions', 'This 1971 Alpine Renault 1600s replica Features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 7995, 38.58, 61.23),
(75, 'S24_3420', '1937 Horch 930V Limousine', 'Vintage Cars', '1:24', 'Autoart Studio Design', 'Features opening hood, opening doors, opening trunk, wide white wall tires, front door arm rests, working steering system', 2902, 26.3, 65.75),
(76, 'S24_3432', '2002 Chevy Corvette', 'Classic Cars', '1:24', 'Gearbox Collectibles', 'The operating parts of this limited edition Diecast 2002 Chevy Corvette 50th Anniversary Pace car Limited Edition are particularly delicate due to their precise scale and require special care and attention. Features rotating wheels, poseable streering, opening doors and trunk.', 9446, 62.11, 107.08),
(77, 'S24_3816', '1940 Ford Delivery Sedan', 'Vintage Cars', '1:24', 'Carousel DieCast Legends', 'Chrome Trim, Chrome Grille, Opening Hood, Opening Doors, Opening Trunk, Detailed Engine, Working Steering System. Color black.', 6621, 48.64, 83.86),
(78, 'S24_3856', '1956 Porsche 356A Coupe', 'Classic Cars', '1:18', 'Classic Metal Creations', 'Features include: Turnable front wheels; steering function; detailed interior; detailed engine; opening hood; opening trunk; opening doors; and detailed chassis.', 6600, 98.3, 140.43),
(79, 'S24_3949', 'Corsair F4U ( Bird Cage)', 'Planes', '1:24', 'Second Gear Diecast', 'Has retractable wheels and comes with a stand. Official logos and insignias.', 6812, 29.34, 68.24),
(80, 'S24_3969', '1936 Mercedes Benz 500k Roadster', 'Vintage Cars', '1:24', 'Red Start Diecast', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system and rubber wheels. Color black.', 2081, 21.75, 41.03),
(81, 'S24_4048', '1992 Porsche Cayenne Turbo Silver', 'Classic Cars', '1:24', 'Exoto Designs', 'This replica features opening doors, superb detail and craftsmanship, working steering system, opening forward compartment, opening rear trunk with removable spare, 4 wheel independent spring suspension as well as factory baked enamel finish.', 6582, 69.78, 118.28),
(82, 'S24_4258', '1936 Chrysler Airflow', 'Vintage Cars', '1:24', 'Second Gear Diecast', 'Features opening trunk,  working steering system. Color dark green.', 4710, 57.46, 97.39),
(83, 'S24_4278', '1900s Vintage Tri-Plane', 'Planes', '1:24', 'Unimax Art Galleries', 'Hand crafted diecast-like metal Triplane is Re-created in about 1:24 scale of antique pioneer airplane. This antique style metal triplane is all hand-assembled with many different parts.', 2756, 36.23, 72.45),
(84, 'S24_4620', '1961 Chevrolet Impala', 'Classic Cars', '1:18', 'Classic Metal Creations', 'This 1:18 scale precision die-cast reproduction of the 1961 Chevrolet Impala has all the features-doors, hood and trunk that open; detailed 409 cubic-inch engine; chrome dashboard and stick shift, two-tone interior; working steering system; all topped of with a factory baked-enamel finish.', 7869, 32.33, 80.84),
(85, 'S32_1268', '1980â€™s GM Manhattan Express', 'Trucks and Buses', '1:32', 'Motor City Art Classics', 'This 1980â€™s era new look Manhattan express is still active, running from the Bronx to mid-town Manhattan. Has 35 opeining windows and working lights. Needs a battery.', 5099, 53.93, 96.31),
(86, 'S32_1374', '1997 BMW F650 ST', 'Motorcycles', '1:32', 'Exoto Designs', 'Features official die-struck logos and baked enamel finish. Comes with stand.', 178, 66.92, 99.89),
(87, 'S32_2206', '1982 Ducati 996 R', 'Motorcycles', '1:32', 'Gearbox Collectibles', 'Features rotating wheels , working kick stand. Comes with stand.', 9241, 24.14, 40.23),
(88, 'S32_2509', '1954 Greyhound Scenicruiser', 'Trucks and Buses', '1:32', 'Classic Metal Creations', 'Model features bi-level seating, 50 windows, skylights & glare resistant glass, working steering system, original logos', 2874, 25.98, 54.11),
(89, 'S32_3207', '1950''s Chicago Surface Lines Streetcar', 'Trains', '1:32', 'Gearbox Collectibles', 'This streetcar is a joy to see. It has 80 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).', 8601, 26.72, 62.14),
(90, 'S32_3522', '1996 Peterbilt 379 Stake Bed with Outrigger', 'Trucks and Buses', '1:32', 'Red Start Diecast', 'This model features, opening doors, detailed engine, working steering, tinted windows, detailed interior, die-struck logos, removable stakes operating outriggers, detachable second trailer, functioning 360-degree self loader, precision molded resin trailer and trim, baked enamel finish on cab', 814, 33.61, 64.64),
(91, 'S32_4289', '1928 Ford Phaeton Deluxe', 'Vintage Cars', '1:32', 'Highway 66 Mini Classics', 'This model features grille-mounted chrome horn, lift-up louvered hood, fold-down rumble seat, working steering system', 136, 33.02, 68.79),
(92, 'S32_4485', '1974 Ducati 350 Mk3 Desmo', 'Motorcycles', '1:32', 'Second Gear Diecast', 'This model features two-tone paint with chrome accents, superior die-cast detail , rotating wheels , working kick stand', 3341, 56.13, 102.05),
(93, 'S50_1341', '1930 Buick Marquette Phaeton', 'Vintage Cars', '1:50', 'Studio M Art Models', 'Features opening trunk,  working steering system', 7062, 27.06, 43.64),
(94, 'S50_1392', 'Diamond T620 Semi-Skirted Tanker', 'Trucks and Buses', '1:50', 'Highway 66 Mini Classics', 'This limited edition model is licensed and perfectly scaled for Lionel Trains. The Diamond T620 has been produced in solid precision diecast and painted with a fire baked enamel finish. It comes with a removable tanker and is a perfect model to add authenticity to your static train or car layout or to just have on display.', 1016, 68.29, 115.75),
(95, 'S50_1514', '1962 City of Detroit Streetcar', 'Trains', '1:50', 'Classic Metal Creations', 'This streetcar is a joy to see. It has 99 separate windows, electric wire guides, detailed interiors with seats, poles and drivers controls, rolling and turning wheel assemblies, plus authentic factory baked-enamel finishes (Green Hornet for Chicago and Cream and Crimson for Boston).', 1645, 37.49, 58.58),
(96, 'S50_4713', '2002 Yamaha YZR M1', 'Motorcycles', '1:50', 'Autoart Studio Design', 'Features rotating wheels , working kick stand. Comes with stand.', 600, 34.17, 81.36),
(97, 'S700_1138', 'The Schooner Bluenose', 'Ships', '1:700', 'Autoart Studio Design', 'All wood with canvas sails. Measures 31 1/2 inches in Length, 22 inches High and 4 3/4 inches Wide. Many extras.\r\nThe schooner Bluenose was built in Nova Scotia in 1921 to fish the rough waters off the coast of Newfoundland. Because of the Bluenose racing prowess she became the pride of all Canadians. Still featured on stamps and the Canadian dime, the Bluenose was lost off Haiti in 1946.', 1897, 34, 66.67),
(98, 'S700_1691', 'American Airlines: B767-300', 'Planes', '1:700', 'Min Lin Diecast', 'Exact replia with official logos and insignias and retractable wheels', 5841, 51.15, 91.34),
(99, 'S700_1938', 'The Mayflower', 'Ships', '1:700', 'Studio M Art Models', 'Measures 31 1/2 inches Long x 25 1/2 inches High x 10 5/8 inches Wide\r\nAll wood with canvas sail. Extras include long boats, rigging, ladders, railing, anchors, side cannons, hand painted, etc.', 737, 43.3, 86.61),
(100, 'S700_2047', 'HMS Bounty', 'Ships', '1:700', 'Unimax Art Galleries', 'Measures 30 inches Long x 27 1/2 inches High x 4 3/4 inches Wide. \r\nMany extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 3501, 39.83, 90.52),
(101, 'S700_2466', 'America West Airlines B757-200', 'Planes', '1:700', 'Motor City Art Classics', 'Official logos and insignias. Working steering system. Rotating jet engines', 9653, 68.8, 99.72),
(102, 'S700_2610', 'The USS Constitution Ship', 'Ships', '1:700', 'Red Start Diecast', 'All wood with canvas sails. Measures 31 1/2" Length x 22 3/8" High x 8 1/4" Width. Extras include 4 boats on deck, sea sprite on bow, anchors, copper railing, pilot houses, etc.', 7083, 33.97, 72.28),
(103, 'S700_2824', '1982 Camaro Z28', 'Classic Cars', '1:18', 'Carousel DieCast Legends', 'Features include opening and closing doors. Color: White. \r\nMeasures approximately 9 1/2" Long.', 6934, 46.53, 101.15),
(104, 'S700_2834', 'ATA: B757-300', 'Planes', '1:700', 'Highway 66 Mini Classics', 'Exact replia with official logos and insignias and retractable wheels', 7106, 59.33, 118.65),
(105, 'S700_3167', 'F/A 18 Hornet 1/72', 'Planes', '1:72', 'Motor City Art Classics', '10" Wingspan with retractable landing gears.Comes with pilot', 551, 54.4, 80),
(106, 'S700_3505', 'The Titanic', 'Ships', '1:700', 'Carousel DieCast Legends', 'Completed model measures 19 1/2 inches long, 9 inches high, 3inches wide and is in barn red/black. All wood and metal.', 1956, 51.09, 100.17),
(107, 'S700_3962', 'The Queen Mary', 'Ships', '1:700', 'Welly Diecast Productions', 'Exact replica. Wood and Metal. Many extras including rigging, long boats, pilot house, anchors, etc. Comes with three masts, all square-rigged.', 5088, 53.63, 99.31),
(108, 'S700_4002', 'American Airlines: MD-11S', 'Planes', '1:700', 'Second Gear Diecast', 'Polished finish. Exact replia with official logos and insignias and retractable wheels', 8820, 36.27, 74.03),
(109, 'S72_1253', 'Boeing X-32A JSF', 'Planes', '1:72', 'Motor City Art Classics', '10" Wingspan with retractable landing gears.Comes with pilot', 4857, 32.77, 49.66),
(110, 'S72_3212', 'Pont Yacht', 'Ships', '1:72', 'Unimax Art Galleries', 'Measures 38 inches Long x 33 3/4 inches High. Includes a stand.\r\nMany extras including rigging, long boats, pilot house, anchors, etc. Comes with 2 masts, all square-rigged', 414, 33.3, 54.6),
(111, '995', 'Prod name', 'trucks', '1:50', 'test', '<p>test</p>', 9, 88, 3);

DROP TABLE IF EXISTS `uploads`;
CREATE TABLE IF NOT EXISTS `uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `simple_upload` varchar(255) NOT NULL,
  `simple_image` varchar(255) NOT NULL,
  `auto_resize` varchar(255) NOT NULL,
  `auto_crop` varchar(255) NOT NULL,
  `manual_crop` varchar(255) NOT NULL,
  `manual_crop_2` varchar(255) NOT NULL,
  `manual_crop_3` varchar(255) NOT NULL,
  `watermark` varchar(255) NOT NULL,
  `watermark_position` varchar(255) NOT NULL,
  `image_with_thumbs` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

INSERT INTO `uploads` (`id`, `simple_upload`, `simple_image`, `auto_resize`, `auto_crop`, `manual_crop`, `manual_crop_2`, `manual_crop_3`, `watermark`, `watermark_position`, `image_with_thumbs`) VALUES
(14, 'adg3com_crypticpsyche.mp3', '23avt41fm76ok8w.jpg', 'c15idvlmla80kog.jpg', '1he2ijymrpuoosc.jpg', '18fm0pd975y8kkc.jpg', '1swijqc1rxpcs80.jpg', '185ubvhqmg4gwwc.jpg', '1fa1vvrb139c440.jpg', '516556i77s00s44.jpg', '1bhw6oddqhlw8gc.jpg');

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
