SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;


DROP TABLE IF EXISTS `meta_location`;
CREATE TABLE IF NOT EXISTS `meta_location` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `iso` varchar(50) DEFAULT NULL,
  `local_name` varchar(255) DEFAULT NULL,
  `type` char(2) DEFAULT NULL,
  `in_location` int(11) unsigned DEFAULT NULL,
  `geo_lat` double(18,11) DEFAULT NULL,
  `geo_lng` double(18,11) DEFAULT NULL,
  `db_id` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=112265 ;

INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(1, 'AD', 'Andorra', 'CO', NULL, 42.50000000000, 1.50000000000, 'AD'),
(2, 'AE', 'United Arab Emirates', 'CO', NULL, 24.00000000000, 54.00000000000, 'AE'),
(3, 'AF', 'Afghanistan', 'CO', NULL, 33.00000000000, 65.00000000000, 'AF'),
(4, 'AG', 'Antigua and Barbuda', 'CO', NULL, 17.05000000000, -61.80000000000, 'AG'),
(5, 'AI', 'Anguilla', 'CO', NULL, 18.25000000000, -63.16670000000, 'AI'),
(6, 'AL', 'Albania', 'CO', NULL, 41.00000000000, 20.00000000000, 'AL'),
(7, 'AM', 'Armenia\r\n', 'CO', NULL, 40.00000000000, 45.00000000000, 'AM'),
(8, 'AN', 'Netherlands Antilles\r\n', 'CO', NULL, 12.25000000000, -68.75000000000, 'AN'),
(9, 'AO', 'Angola\r\n', 'CO', NULL, -12.50000000000, 18.50000000000, 'AO'),
(10, 'AQ', 'Antarctica\r\n', 'CO', NULL, -90.00000000000, 0.00000000000, 'AQ'),
(11, 'AR', 'Argentina\r\n', 'CO', NULL, -34.00000000000, -64.00000000000, 'AR'),
(12, 'AS', 'American Samoa\r\n', 'CO', NULL, -14.33330000000, -170.00000000000, 'AS'),
(13, 'AT', 'Austria\r\n', 'CO', NULL, 47.33330000000, 13.33330000000, 'AT'),
(14, 'AU', 'Australia\r\n', 'CO', NULL, -27.00000000000, 133.00000000000, 'AU'),
(15, 'AW', 'Aruba\r\n', 'CO', NULL, 12.50000000000, -69.96670000000, 'AW'),
(16, 'AX', 'Aland Islands\r\nÅland Islands', 'CO', NULL, 0.10000000000, 0.10000000000, 'AX'),
(17, 'AZ', 'Azerbaijan\r\n', 'CO', NULL, 40.50000000000, 47.50000000000, 'AZ'),
(18, 'BA', 'Bosnia and Herzegovina\r\n', 'CO', NULL, 44.00000000000, 18.00000000000, 'BA'),
(19, 'BB', 'Barbados\r\n', 'CO', NULL, 13.16670000000, -59.53330000000, 'BB'),
(20, 'BD', 'Bangladesh\r\n', 'CO', NULL, 24.00000000000, 90.00000000000, 'BD'),
(21, 'BE', 'Belgium\r\n', 'CO', NULL, 50.83330000000, 4.00000000000, 'BE'),
(22, 'BF', 'Burkina Faso\r\n', 'CO', NULL, 13.00000000000, -2.00000000000, 'BF'),
(23, 'BG', 'Bulgaria\r\n', 'CO', NULL, 43.00000000000, 25.00000000000, 'BG'),
(24, 'BH', 'Bahrain\r\n', 'CO', NULL, 26.00000000000, 50.55000000000, 'BH'),
(25, 'BI', 'Burundi\r\n', 'CO', NULL, -3.50000000000, 30.00000000000, 'BI'),
(26, 'BJ', 'Benin\r\n', 'CO', NULL, 9.50000000000, 2.25000000000, 'BJ'),
(27, 'BL', 'Saint Barthlemy', 'CO', NULL, NULL, NULL, 'BL'),
(28, 'BM', 'Bermuda\r\n', 'CO', NULL, 32.33330000000, -64.75000000000, 'BM'),
(29, 'BN', 'Brunei Darussalam\r\n', 'CO', NULL, 4.50000000000, 114.66670000000, 'BN'),
(30, 'BO', 'Bolivia\r\nBolivia, Plurinational state of', 'CO', NULL, -17.00000000000, -65.00000000000, 'BO'),
(31, 'BR', 'Brazil\r\n', 'CO', NULL, -10.00000000000, -55.00000000000, 'BR'),
(32, 'BS', 'Bahamas\r\n', 'CO', NULL, 24.25000000000, -76.00000000000, 'BS'),
(33, 'BT', 'Bhutan\r\n', 'CO', NULL, 27.50000000000, 90.50000000000, 'BT'),
(34, 'BV', 'Bouvet Island\r\n', 'CO', NULL, -54.43330000000, 3.40000000000, 'BV'),
(35, 'BW', 'Botswana\r\n', 'CO', NULL, -22.00000000000, 24.00000000000, 'BW'),
(36, 'BY', 'Belarus\r\n', 'CO', NULL, 53.00000000000, 28.00000000000, 'BY'),
(37, 'BZ', 'Belize\r\n', 'CO', NULL, 17.25000000000, -88.75000000000, 'BZ'),
(38, 'CA', 'Canada\r\n', 'CO', NULL, 60.00000000000, -95.00000000000, 'CA'),
(39, 'CC', 'Cocos (Keeling) Islands\r\n', 'CO', NULL, -12.50000000000, 96.83330000000, 'CC'),
(40, 'CD', 'Congo, The Democratic Republic of the\r\n', 'CO', NULL, -4.03833300000, 21.75866400000, 'CD'),
(41, 'CF', 'Central African Republic\r\n', 'CO', NULL, 7.00000000000, 21.00000000000, 'CF'),
(42, 'CG', 'Congo\r\n', 'CO', NULL, -1.00000000000, 15.00000000000, 'CG'),
(43, 'CH', 'Switzerland\r\n', 'CO', NULL, 47.00000000000, 8.00000000000, 'CH'),
(44, 'CI', 'Côte d''Ivoire', 'CO', NULL, 8.00000000000, -5.00000000000, 'CI'),
(45, 'CK', 'Cook Islands\r\n', 'CO', NULL, -21.23330000000, -159.76670000000, 'CK'),
(46, 'CL', 'Chile', 'CO', NULL, -30.00000000000, -71.00000000000, 'CL'),
(47, 'CM', 'Cameroon\r\n', 'CO', NULL, 6.00000000000, 12.00000000000, 'CM'),
(48, 'CN', 'China\r\n', 'CO', NULL, 35.00000000000, 105.00000000000, 'CN'),
(49, 'CO', 'Colombia\r\n', 'CO', NULL, 4.00000000000, -72.00000000000, 'CO'),
(50, 'CR', 'Costa Rica\r\n', 'CO', NULL, 10.00000000000, -84.00000000000, 'CR'),
(51, 'CU', 'Cuba\r\n', 'CO', NULL, 21.50000000000, -80.00000000000, 'CU'),
(52, 'CV', 'Cape Verde\r\n', 'CO', NULL, 16.00000000000, -24.00000000000, 'CV'),
(53, 'CX', 'Christmas Island\r\n', 'CO', NULL, -10.50000000000, 105.66670000000, 'CX'),
(54, 'CY', 'Cyprus\r\n', 'CO', NULL, 35.00000000000, 33.00000000000, 'CY'),
(55, 'CZ', 'Czech Republic\r\n', 'CO', NULL, 49.75000000000, 15.50000000000, 'CZ'),
(56, 'DE', 'Germany\r\n', 'CO', NULL, 51.00000000000, 9.00000000000, 'DE'),
(57, 'DJ', 'Djibouti\r\n', 'CO', NULL, 11.50000000000, 43.00000000000, 'DJ'),
(58, 'DK', 'Denmark\r\n', 'CO', NULL, 56.00000000000, 10.00000000000, 'DK'),
(59, 'DM', 'Dominica\r\n', 'CO', NULL, 15.41670000000, -61.33330000000, 'DM'),
(60, 'DO', 'Dominican Republic\r\n', 'CO', NULL, 19.00000000000, -70.66670000000, 'DO'),
(61, 'DZ', 'Algeria\r\n', 'CO', NULL, 28.00000000000, 3.00000000000, 'DZ'),
(62, 'EC', 'Ecuador\r\n', 'CO', NULL, -2.00000000000, -77.50000000000, 'EC'),
(63, 'EE', 'Estonia\r\n', 'CO', NULL, 59.00000000000, 26.00000000000, 'EE'),
(64, 'EG', 'Egypt\r\n', 'CO', NULL, 27.00000000000, 30.00000000000, 'EG'),
(65, 'EH', 'Western Sahara\r\n', 'CO', NULL, 24.50000000000, -13.00000000000, 'EH'),
(66, 'ER', 'Eritrea\r\n', 'CO', NULL, 15.00000000000, 39.00000000000, 'ER'),
(67, 'ES', 'Spain\r\n', 'CO', NULL, 40.00000000000, -4.00000000000, 'ES'),
(68, 'ET', 'Ethiopia\r\n', 'CO', NULL, 8.00000000000, 38.00000000000, 'ET'),
(69, 'FI', 'Finland\r\n', 'CO', NULL, 64.00000000000, 26.00000000000, 'FI'),
(70, 'FJ', 'Fiji\r\n', 'CO', NULL, -18.00000000000, 175.00000000000, 'FJ'),
(71, 'FK', 'Falkland Islands (Malvinas)\r\n', 'CO', NULL, -51.75000000000, -59.00000000000, 'FK'),
(72, 'FM', 'Micronesia, Federated States of\r\n', 'CO', NULL, 6.91670000000, 158.25000000000, 'FM'),
(73, 'FO', 'Faroe Islands\r\n', 'CO', NULL, 62.00000000000, -7.00000000000, 'FO'),
(74, 'FR', 'France\r\n', 'CO', NULL, 46.00000000000, 2.00000000000, 'FR'),
(75, 'GA', 'Gabon', 'CO', NULL, -1.00000000000, 11.75000000000, 'GA'),
(76, 'GB', 'United Kingdom', 'CO', NULL, 54.00000000000, -2.00000000000, 'GB'),
(77, 'GD', 'Grenada', 'CO', NULL, 12.11670000000, -61.66670000000, 'GD'),
(78, 'GE', 'Georgia', 'CO', NULL, 42.00000000000, 43.50000000000, 'GE'),
(79, 'GF', 'French Guiana', 'CO', NULL, 4.00000000000, -53.00000000000, 'GF'),
(80, 'GG', 'Guernsey', 'CO', NULL, 49.46569100000, -2.58527800000, 'GG'),
(81, 'GH', 'Ghana\r\n', 'CO', NULL, 8.00000000000, -2.00000000000, 'GH'),
(82, 'GI', 'Gibraltar\r\n', 'CO', NULL, 36.18330000000, -5.36670000000, 'GI'),
(83, 'GL', 'Greenland\r\n', 'CO', NULL, 72.00000000000, -40.00000000000, 'GL'),
(84, 'GM', 'Gambia\r\n', 'CO', NULL, 13.46670000000, -16.56670000000, 'GM'),
(85, 'GN', 'Guinea\r\n', 'CO', NULL, 11.00000000000, -10.00000000000, 'GN'),
(86, 'GP', 'Guadeloupe\r\n', 'CO', NULL, 16.25000000000, -61.58330000000, 'GP'),
(87, 'GQ', 'Equatorial Guinea\r\n', 'CO', NULL, 2.00000000000, 10.00000000000, 'GQ'),
(88, 'GR', 'Greece\r\n', 'CO', NULL, 39.00000000000, 22.00000000000, 'GR'),
(89, 'GS', 'South Georgia and the South Sandwich Islands\r\n', 'CO', NULL, -54.50000000000, -37.00000000000, 'GS'),
(90, 'GT', 'Guatemala\r\n', 'CO', NULL, 15.50000000000, -90.25000000000, 'GT'),
(91, 'GU', 'Guam\r\n', 'CO', NULL, 13.46670000000, 144.78330000000, 'GU'),
(92, 'GW', 'Guinea-Bissau\r\n', 'CO', NULL, 12.00000000000, -15.00000000000, 'GW'),
(93, 'GY', 'Guyana\r\n', 'CO', NULL, 5.00000000000, -59.00000000000, 'GY'),
(94, 'HK', 'Hong Kong\r\n', 'CO', NULL, 22.25000000000, 114.16670000000, 'HK'),
(95, 'HM', 'Heard Island and McDonald Islands\r\n', 'CO', NULL, -53.10000000000, 72.51670000000, 'HM'),
(96, 'HN', 'Honduras\r\n', 'CO', NULL, 15.00000000000, -86.50000000000, 'HN'),
(97, 'HR', 'Croatia\r\n', 'CO', NULL, 45.16670000000, 15.50000000000, 'HR'),
(98, 'HT', 'Haiti\r\n', 'CO', NULL, 19.00000000000, -72.41670000000, 'HT'),
(99, 'HU', 'Hungary\r\n', 'CO', NULL, 47.00000000000, 20.00000000000, 'HU'),
(100, 'ID', 'Indonesia\r\n', 'CO', NULL, -5.00000000000, 120.00000000000, 'ID'),
(101, 'IE', 'Ireland\r\n', 'CO', NULL, 53.00000000000, -8.00000000000, 'IE'),
(102, 'IL', 'Israel\r\n', 'CO', NULL, 31.50000000000, 34.75000000000, 'IL'),
(103, 'IM', 'Isle of Man\r\n', 'CO', NULL, 54.23610700000, -4.54805600000, 'IM'),
(104, 'IN', 'India\r\n', 'CO', NULL, 20.00000000000, 77.00000000000, 'IN'),
(105, 'IO', 'British Indian Ocean Territory\r\n', 'CO', NULL, -6.00000000000, 71.50000000000, 'IO'),
(106, 'IQ', 'Iraq\r\n', 'CO', NULL, 33.00000000000, 44.00000000000, 'IQ'),
(107, 'IR', 'Iran, Islamic Republic of\r\n', 'CO', NULL, 32.00000000000, 53.00000000000, 'IR'),
(108, 'IS', 'Iceland\r\n', 'CO', NULL, 65.00000000000, -18.00000000000, 'IS'),
(109, 'IT', 'Italy', 'CO', NULL, 42.83330000000, 12.83330000000, 'IT'),
(110, 'JE', 'Jersey\r\n', 'CO', NULL, 49.21443900000, -2.13125000000, 'JE'),
(111, 'JM', 'Jamaica\r\n', 'CO', NULL, 18.25000000000, -77.50000000000, 'JM'),
(112, 'JO', 'Jordan\r\n', 'CO', NULL, 31.00000000000, 36.00000000000, 'JO'),
(113, 'JP', 'Japan\r\n', 'CO', NULL, 36.00000000000, 138.00000000000, 'JP'),
(114, 'KE', 'Kenya\r\n', 'CO', NULL, 1.00000000000, 38.00000000000, 'KE'),
(115, 'KG', 'Kyrgyzstan\r\n', 'CO', NULL, 41.00000000000, 75.00000000000, 'KG'),
(116, 'KH', 'Cambodia\r\n', 'CO', NULL, 13.00000000000, 105.00000000000, 'KH'),
(117, 'KI', 'Kiribati\r\n', 'CO', NULL, 1.41670000000, 173.00000000000, 'KI'),
(118, 'KM', 'Comoros\r\n', 'CO', NULL, -12.16670000000, 44.25000000000, 'KM'),
(119, 'KN', 'Saint Kitts and Nevis\r\n', 'CO', NULL, 17.33330000000, -62.75000000000, 'KN'),
(120, 'KP', 'Korea, Democratic People&#39;s Republic of\r\n', 'CO', NULL, 40.00000000000, 127.00000000000, 'KP'),
(121, 'KR', 'Korea, Republic of\r\n', 'CO', NULL, 37.00000000000, 127.50000000000, 'KR'),
(122, 'KW', 'Kuwait\r\n', 'CO', NULL, 29.50000000000, 45.75000000000, 'KW'),
(123, 'KY', 'Cayman Islands\r\n', 'CO', NULL, 19.50000000000, -80.50000000000, 'KY'),
(124, 'KZ', 'Kazakhstan\r\n', 'CO', NULL, 48.00000000000, 68.00000000000, 'KZ'),
(125, 'LA', 'Lao People&#39;s Democratic Republic\r\n', 'CO', NULL, 18.00000000000, 105.00000000000, 'LA'),
(126, 'LB', 'Lebanon\r\n', 'CO', NULL, 33.83330000000, 35.83330000000, 'LB'),
(127, 'LC', 'Saint Lucia\r\n', 'CO', NULL, 13.88330000000, -61.13330000000, 'LC'),
(128, 'LI', 'Liechtenstein\r\n', 'CO', NULL, 47.16670000000, 9.53330000000, 'LI'),
(129, 'LK', 'Sri Lanka\r\n', 'CO', NULL, 7.00000000000, 81.00000000000, 'LK'),
(130, 'LR', 'Liberia\r\n', 'CO', NULL, 6.50000000000, -9.50000000000, 'LR'),
(131, 'LS', 'Lesotho\r\n', 'CO', NULL, -29.50000000000, 28.50000000000, 'LS'),
(132, 'LT', 'Lithuania\r\n', 'CO', NULL, 56.00000000000, 24.00000000000, 'LT'),
(133, 'LU', 'Luxembourg\r\n', 'CO', NULL, 49.75000000000, 6.16670000000, 'LU'),
(134, 'LV', 'Latvia\r\n', 'CO', NULL, 57.00000000000, 25.00000000000, 'LV'),
(135, 'LY', 'Libyan Arab Jamahiriya\r\n', 'CO', NULL, 25.00000000000, 17.00000000000, 'LY'),
(136, 'MA', 'Morocco\r\n', 'CO', NULL, 32.00000000000, -5.00000000000, 'MA'),
(137, 'MC', 'Monaco\r\n', 'CO', NULL, 43.73330000000, 7.40000000000, 'MC'),
(138, 'MD', 'Moldova, Republic of\r\n', 'CO', NULL, 47.00000000000, 29.00000000000, 'MD'),
(139, 'ME', 'Montenegro\r\n', 'CO', NULL, 42.57263800000, 18.80775600000, 'ME'),
(140, 'MF', 'Saint Martin', 'CO', NULL, NULL, NULL, 'MF'),
(141, 'MG', 'Madagascar\r\n', 'CO', NULL, -20.00000000000, 47.00000000000, 'MG'),
(142, 'MH', 'Marshall Islands\r\n', 'CO', NULL, 9.00000000000, 168.00000000000, 'MH'),
(143, 'MK', 'Macedonia\r\n', 'CO', NULL, 41.83330000000, 22.00000000000, 'MK'),
(144, 'ML', 'Mali\r\n', 'CO', NULL, 17.00000000000, -4.00000000000, 'ML'),
(145, 'MM', 'Myanmar\r\n', 'CO', NULL, 21.91396500000, 95.95622300000, 'MM'),
(146, 'MN', 'Mongolia\r\n', 'CO', NULL, 46.00000000000, 105.00000000000, 'MN'),
(147, 'MO', 'Macao\r\n', 'CO', NULL, 22.16670000000, 113.55000000000, 'MO'),
(148, 'MP', 'Northern Mariana Islands\r\n', 'CO', NULL, 15.20000000000, 145.75000000000, 'MP'),
(149, 'MQ', 'Martinique\r\n', 'CO', NULL, 14.66670000000, -61.00000000000, 'MQ'),
(150, 'MR', 'Mauritania\r\n', 'CO', NULL, 20.00000000000, -12.00000000000, 'MR'),
(151, 'MS', 'Montserrat\r\n', 'CO', NULL, 16.75000000000, -62.20000000000, 'MS'),
(152, 'MT', 'Malta\r\n', 'CO', NULL, 35.83330000000, 14.58330000000, 'MT'),
(153, 'MU', 'Mauritius\r\n', 'CO', NULL, -20.28330000000, 57.55000000000, 'MU'),
(154, 'MV', 'Maldives\r\n', 'CO', NULL, 3.25000000000, 73.00000000000, 'MV'),
(155, 'MW', 'Malawi\r\n', 'CO', NULL, -13.50000000000, 34.00000000000, 'MW'),
(156, 'MX', 'Mexico\r\n', 'CO', NULL, 23.00000000000, -102.00000000000, 'MX'),
(157, 'MY', 'Malaysia\r\n', 'CO', NULL, 2.50000000000, 112.50000000000, 'MY'),
(158, 'MZ', 'Mozambique\r\n', 'CO', NULL, -18.25000000000, 35.00000000000, 'MZ'),
(159, 'NA', 'Namibia\r\n', 'CO', NULL, -22.00000000000, 17.00000000000, 'NA'),
(160, 'NC', 'New Caledonia\r\n', 'CO', NULL, -21.50000000000, 165.50000000000, 'NC'),
(161, 'NE', 'Niger\r\n', 'CO', NULL, 16.00000000000, 8.00000000000, 'NE'),
(162, 'NF', 'Norfolk Island\r\n', 'CO', NULL, -29.03330000000, 167.95000000000, 'NF'),
(163, 'NG', 'Nigeria\r\n', 'CO', NULL, 10.00000000000, 8.00000000000, 'NG'),
(164, 'NI', 'Nicaragua\r\n', 'CO', NULL, 13.00000000000, -85.00000000000, 'NI'),
(165, 'NL', 'Netherlands\r\n', 'CO', NULL, 52.50000000000, 5.75000000000, 'NL'),
(166, 'NO', 'Norway', 'CO', NULL, 62.00000000000, 10.00000000000, 'NO'),
(167, 'NP', 'Nepal\r\n', 'CO', NULL, 28.00000000000, 84.00000000000, 'NP'),
(168, 'NR', 'Nauru\r\n', 'CO', NULL, -0.53330000000, 166.91670000000, 'NR'),
(169, 'NU', 'Niue\r\n', 'CO', NULL, -19.03330000000, -169.86670000000, 'NU'),
(170, 'NZ', 'New Zealand\r\n', 'CO', NULL, -41.00000000000, 174.00000000000, 'NZ'),
(171, 'OM', 'Oman\r\n', 'CO', NULL, 21.00000000000, 57.00000000000, 'OM'),
(172, 'PA', 'Panama\r\n', 'CO', NULL, 9.00000000000, -80.00000000000, 'PA'),
(173, 'PE', 'Peru\r\n', 'CO', NULL, -10.00000000000, -76.00000000000, 'PE'),
(174, 'PF', 'French Polynesia\r\n', 'CO', NULL, -15.00000000000, -140.00000000000, 'PF'),
(175, 'PG', 'Papua New Guinea\r\n', 'CO', NULL, -6.00000000000, 147.00000000000, 'PG'),
(176, 'PH', 'Philippines\r\n', 'CO', NULL, 13.00000000000, 122.00000000000, 'PH'),
(177, 'PK', 'Pakistan\r\n', 'CO', NULL, 30.00000000000, 70.00000000000, 'PK'),
(178, 'PL', 'Poland\r\n', 'CO', NULL, 52.00000000000, 20.00000000000, 'PL'),
(179, 'PM', 'Saint Pierre and Miquelon\r\n', 'CO', NULL, 46.83330000000, -56.33330000000, 'PM'),
(180, 'PN', 'Pitcairn\r\n', 'CO', NULL, -24.70361500000, -127.43930800000, 'PN'),
(181, 'PR', 'Puerto Rico\r\n', 'CO', NULL, 18.25000000000, -66.50000000000, 'PR'),
(182, 'PS', 'Palestinian Territory, Occupied', 'CO', NULL, 32.00000000000, 35.25000000000, 'PS'),
(183, 'PT', 'Portugal\r\n', 'CO', NULL, 39.50000000000, -8.00000000000, 'PT'),
(184, 'PW', 'Palau\r\n', 'CO', NULL, 7.50000000000, 134.50000000000, 'PW'),
(185, 'PY', 'Paraguay\r\n', 'CO', NULL, -23.00000000000, -58.00000000000, 'PY'),
(186, 'QA', 'Qatar\r\n', 'CO', NULL, 25.50000000000, 51.25000000000, 'QA'),
(187, 'RE', 'Réunion', 'CO', NULL, -21.10000000000, 55.60000000000, 'RE'),
(188, 'RO', 'Romania\r\n', 'CO', NULL, 46.00000000000, 25.00000000000, 'RO'),
(189, 'RS', 'Serbia\r\n', 'CO', NULL, 44.01519400000, 20.72916400000, 'RS'),
(190, 'RU', 'Russian Federation\r\n', 'CO', NULL, 60.00000000000, 100.00000000000, 'RU'),
(191, 'RW', 'Rwanda\r\n', 'CO', NULL, -2.00000000000, 30.00000000000, 'RW'),
(192, 'SA', 'Saudi Arabia\r\n', 'CO', NULL, 25.00000000000, 45.00000000000, 'SA'),
(193, 'SB', 'Solomon Islands\r\n', 'CO', NULL, -8.00000000000, 159.00000000000, 'SB'),
(194, 'SC', 'Seychelles\r\n', 'CO', NULL, -4.58330000000, 55.66670000000, 'SC'),
(195, 'SD', 'Sudan\r\n', 'CO', NULL, 15.00000000000, 30.00000000000, 'SD'),
(196, 'SE', 'Sweden\r\n', 'CO', NULL, 62.00000000000, 15.00000000000, 'SE'),
(197, 'SG', 'Singapore\r\n', 'CO', NULL, 1.36670000000, 103.80000000000, 'SG'),
(198, 'SH', 'Saint Helena\r\n', 'CO', NULL, -15.93330000000, -5.70000000000, 'SH'),
(199, 'SI', 'Slovenia\r\n', 'CO', NULL, 46.00000000000, 15.00000000000, 'SI'),
(200, 'SJ', 'Svalbard and Jan Mayen\r\n', 'CO', NULL, 78.00000000000, 20.00000000000, 'SJ'),
(201, 'SK', 'Slovakia\r\n', 'CO', NULL, 48.66670000000, 19.50000000000, 'SK'),
(202, 'SL', 'Sierra Leone\r\n', 'CO', NULL, 8.50000000000, -11.50000000000, 'SL'),
(203, 'SM', 'San Marino\r\n', 'CO', NULL, 43.76670000000, 12.41670000000, 'SM'),
(204, 'SN', 'Senegal\r\n', 'CO', NULL, 14.00000000000, -14.00000000000, 'SN'),
(205, 'SO', 'Somalia\r\n', 'CO', NULL, 10.00000000000, 49.00000000000, 'SO'),
(206, 'SR', 'Suriname\r\n', 'CO', NULL, 4.00000000000, -56.00000000000, 'SR'),
(207, 'ST', 'Sao Tome and Principe\r\n', 'CO', NULL, 1.00000000000, 7.00000000000, 'ST'),
(208, 'SV', 'El Salvador\r\n', 'CO', NULL, 13.83330000000, -88.91670000000, 'SV'),
(209, 'SY', 'Syrian Arab Republic\r\n', 'CO', NULL, 35.00000000000, 38.00000000000, 'SY'),
(210, 'SZ', 'Swaziland\r\n', 'CO', NULL, -26.50000000000, 31.50000000000, 'SZ'),
(211, 'TC', 'Turks and Caicos Islands\r\n', 'CO', NULL, 21.75000000000, -71.58330000000, 'TC'),
(212, 'TD', 'Chad', 'CO', NULL, 15.00000000000, 19.00000000000, 'TD'),
(213, 'TF', 'French Southern Territories', 'CO', NULL, -49.44996000000, 70.02498200000, 'TF'),
(214, 'TG', 'Togo', 'CO', NULL, 8.00000000000, 1.16670000000, 'TG'),
(215, 'TH', 'Thailand', 'CO', NULL, 15.00000000000, 100.00000000000, 'TH'),
(216, 'TJ', 'Tajikistan', 'CO', NULL, 39.00000000000, 71.00000000000, 'TJ'),
(217, 'TK', 'Tokelau', 'CO', NULL, -9.00000000000, -172.00000000000, 'TK'),
(218, 'TL', 'Timor-Leste', 'CO', NULL, -8.87421700000, 125.72753900000, 'TL'),
(219, 'TM', 'Turkmenistan\r\n', 'CO', NULL, 40.00000000000, 60.00000000000, 'TM'),
(220, 'TN', 'Tunisia\r\n', 'CO', NULL, 34.00000000000, 9.00000000000, 'TN'),
(221, 'TO', 'Tonga\r\n', 'CO', NULL, -20.00000000000, -175.00000000000, 'TO'),
(222, 'TR', 'Turkey', 'CO', NULL, 39.00000000000, 35.00000000000, 'TR'),
(223, 'TT', 'Trinidad and Tobago\r\n', 'CO', NULL, 11.00000000000, -61.00000000000, 'TT'),
(224, 'TV', 'Tuvalu\r\n', 'CO', NULL, -8.00000000000, 178.00000000000, 'TV'),
(225, 'TW', 'Taiwan\r\n', 'CO', NULL, 23.50000000000, 121.00000000000, 'TW'),
(226, 'TZ', 'Tanzania, United Republic of\r\n', 'CO', NULL, -6.00000000000, 35.00000000000, 'TZ'),
(227, 'UA', 'Ukraine\r\n', 'CO', NULL, 49.00000000000, 32.00000000000, 'UA'),
(228, 'UG', 'Uganda\r\n', 'CO', NULL, 1.00000000000, 32.00000000000, 'UG'),
(229, 'UM', 'United States Minor Outlying Islands\r\n', 'CO', NULL, 19.28330000000, 166.60000000000, 'UM'),
(230, 'US', 'United States\r\n', 'CO', NULL, 38.00000000000, -97.00000000000, 'US'),
(231, 'UY', 'Uruguay\r\n', 'CO', NULL, -33.00000000000, -56.00000000000, 'UY'),
(232, 'UZ', 'Uzbekistan\r\n', 'CO', NULL, 41.00000000000, 64.00000000000, 'UZ'),
(233, 'VA', 'Holy See (Vatican City State)\r\n', 'CO', NULL, 41.90000000000, 12.45000000000, 'VA'),
(234, 'VC', 'Saint Vincent and the Grenadines\r\n', 'CO', NULL, 13.25000000000, -61.20000000000, 'VC'),
(235, 'VE', 'Venezuela, Bolivarian Republic of', 'CO', NULL, 8.00000000000, -66.00000000000, 'VE'),
(236, 'VG', 'Virgin Islands, British\r\n', 'CO', NULL, 18.50000000000, -64.50000000000, 'VG'),
(237, 'VI', 'Virgin Islands, U.S.\r\n', 'CO', NULL, 18.33330000000, -64.83330000000, 'VI'),
(238, 'VN', 'Viet Nam', 'CO', NULL, 16.00000000000, 106.00000000000, 'VN'),
(239, 'VU', 'Vanuatu\r\n', 'CO', NULL, -16.00000000000, 167.00000000000, 'VU'),
(240, 'WF', 'Wallis and Futuna\r\n', 'CO', NULL, -13.30000000000, -176.20000000000, 'WF'),
(241, 'WS', 'Samoa\r\n', 'CO', NULL, -13.58330000000, -172.33330000000, 'WS'),
(242, 'YE', 'Yemen\r\n', 'CO', NULL, 15.00000000000, 48.00000000000, 'YE'),
(243, 'YT', 'Mayotte\r\n', 'CO', NULL, -12.83330000000, 45.16670000000, 'YT'),
(244, 'ZA', 'South Africa\r\n', 'CO', NULL, -29.00000000000, 24.00000000000, 'ZA'),
(245, 'ZM', 'Zambia\r\n', 'CO', NULL, -15.00000000000, 30.00000000000, 'ZM'),
(246, 'ZW', 'Zimbabwe', 'CO', NULL, -20.00000000000, 30.00000000000, 'ZW'),
(256, 'AD-07', 'Andorra la Vella\r', 'RE', 1, NULL, NULL, '199'),
(257, 'AD-02', 'Canillo\r', 'RE', 1, NULL, NULL, '200'),
(258, 'AD-03', 'Encamp\r', 'RE', 1, NULL, NULL, '201'),
(259, 'AD-08', 'Escaldes-Engordany\r', 'RE', 1, NULL, NULL, '202'),
(260, 'AD-04', 'La Massana\r', 'RE', 1, NULL, NULL, '203'),
(261, 'AD-05', 'Ordino\r', 'RE', 1, NULL, NULL, '204'),
(262, 'AD-06', 'Sant Julia de Loria\r', 'RE', 1, 42.46503100000, 1.49106400000, '205'),
(263, 'AE-01', 'Abu Dhabi\r', 'RE', 2, NULL, NULL, '206'),
(264, 'AE-02', 'Ajman\r', 'RE', 2, 25.41222000000, 55.43473800000, '207'),
(265, 'AE-03', 'Dubai\r', 'RE', 2, NULL, NULL, '208'),
(266, 'AE-04', 'Fujairah\r', 'RE', 2, NULL, NULL, '209'),
(267, 'AE-05', 'Ras Al Khaimah\r', 'RE', 2, NULL, NULL, '210'),
(268, 'AE-06', 'Sharjah\r', 'RE', 2, NULL, NULL, '211'),
(269, 'AE-07', 'Umm Al Quwain\r', 'RE', 2, NULL, NULL, '212'),
(270, 'AF-01', 'Badakhshan\r', 'RE', 3, 36.96213400000, 72.48409000000, '213'),
(271, 'AF-02', 'Badghis\r', 'RE', 3, 35.26769700000, 63.88498000000, '214'),
(272, 'AF-03', 'Baghlan\r', 'RE', 3, 36.12760000000, 68.68910000000, '215'),
(273, 'AF-30', 'Balkh\r', 'RE', 3, 36.75970000000, 66.88970000000, '216'),
(274, 'AF-05', 'Bamian\r', 'RE', 3, NULL, NULL, '217'),
(275, 'AF-06', 'Farah\r', 'RE', 3, 32.37540000000, 62.11230000000, '218'),
(276, 'AF-07', 'Faryab\r', 'RE', 3, 36.18640500000, 64.84962400000, '219'),
(277, 'AF-08', 'Ghazni\r', 'RE', 3, 33.55330000000, 68.42600000000, '220'),
(278, 'AF-09', 'Ghowr\r', 'RE', 3, 34.15485400000, 64.90566800000, '221'),
(279, 'AF-10', 'Helmand\r', 'RE', 3, 31.79148900000, 64.56520800000, '222'),
(280, 'AF-11', 'Herat\r', 'RE', 3, NULL, NULL, '223'),
(281, 'AF-31', 'Jowzjan\r', 'RE', 3, 36.70109400000, 65.96080000000, '224'),
(282, 'AF-13', 'Kabol\r', 'RE', 3, NULL, NULL, '225'),
(283, 'AF-23', 'Kandahar\r', 'RE', 3, NULL, NULL, '226'),
(284, 'AF-14', 'Kapisa\r', 'RE', 3, 34.87102700000, 69.72943300000, '227'),
(285, 'AF-37', 'Khowst\r', 'RE', 3, 33.33940000000, 69.91480000000, '228'),
(286, 'AF-15', 'Konar\r', 'RE', 3, 35.02577400000, 71.17078400000, '229'),
(287, 'AF-24', 'Kondoz\r', 'RE', 3, NULL, NULL, '230'),
(288, 'AF-16', 'Laghman\r', 'RE', 3, 34.79674800000, 70.31178200000, '231'),
(289, 'AF-17', 'Lowgar\r', 'RE', 3, 33.94363800000, 69.20436600000, '232'),
(290, 'AF-18', 'Nangarhar\r', 'RE', 3, NULL, NULL, '233'),
(291, 'AF-19', 'Nimruz\r', 'RE', 3, 30.80113200000, 62.21204400000, '234'),
(292, 'AF-38', 'Nurestan\r', 'RE', 3, 34.93742000000, 70.37568700000, '235'),
(293, 'AF-20', 'Oruzgan\r', 'RE', 3, 32.93021000000, 66.63642900000, '236'),
(294, 'AF-21', 'Paktia\r', 'RE', 3, 33.68246600000, 69.48192800000, '237'),
(295, 'AF-29', 'Paktika\r', 'RE', 3, 32.49314700000, 68.76484500000, '238'),
(296, 'AF-22', 'Parvan\r', 'RE', 3, NULL, NULL, '239'),
(297, 'AF-32', 'Samangan\r', 'RE', 3, 35.93503500000, 67.89899800000, '240'),
(298, 'AF-33', 'Sar-e Pol\r', 'RE', 3, NULL, NULL, '241'),
(299, 'AF-26', 'Takhar\r', 'RE', 3, NULL, NULL, '242'),
(300, 'AF-27', 'Vardak\r', 'RE', 3, 34.19443000000, 68.27050900000, '243'),
(301, 'AF-28', 'Zabol\r', 'RE', 3, 32.24809900000, 67.18359800000, '244'),
(302, 'AG-01', 'Barbuda\r', 'RE', 4, 17.63709900000, -61.80959300000, '245'),
(303, 'AG-03', 'Saint George\r', 'RE', 4, NULL, NULL, '246'),
(304, 'AG-04', 'Saint John\r', 'RE', 4, NULL, NULL, '247'),
(305, 'AG-05', 'Saint Mary\r', 'RE', 4, NULL, NULL, '248'),
(306, 'AG-06', 'Saint Paul\r', 'RE', 4, NULL, NULL, '249'),
(307, 'AG-07', 'Saint Peter\r', 'RE', 4, NULL, NULL, '250'),
(308, 'AG-08', 'Saint Philip\r', 'RE', 4, NULL, NULL, '251'),
(309, 'AL-40', 'Berat\r', 'RE', 6, 40.70749500000, 19.97228200000, '252'),
(310, 'AL-41', 'Diber\r', 'RE', 6, NULL, NULL, '253'),
(311, 'AL-42', 'Durres\r', 'RE', 6, 41.33083100000, 19.44290200000, '254'),
(312, 'AL-43', 'Elbasan\r', 'RE', 6, NULL, NULL, '255'),
(313, 'AL-44', 'Fier\r', 'RE', 6, NULL, NULL, '256'),
(314, 'AL-45', 'Gjirokaster\r', 'RE', 6, 40.07596500000, 20.15065400000, '257'),
(315, 'AL-46', 'Korce\r', 'RE', 6, 40.62300100000, 20.78523900000, '258'),
(316, 'AL-47', 'Kukes\r', 'RE', 6, 42.06532600000, 20.44038400000, '259'),
(317, 'AL-48', 'Lezhe\r', 'RE', 6, NULL, NULL, '260'),
(318, 'AL-49', 'Shkoder\r', 'RE', 6, 42.06625100000, 19.52299700000, '261'),
(319, 'AL-50', 'Tirane\r', 'RE', 6, NULL, NULL, '262'),
(320, 'AL-51', 'Vlore\r', 'RE', 6, 40.47366200000, 19.48841100000, '263'),
(321, 'AM-01', 'Aragatsotn\r', 'RE', 7, NULL, NULL, '264'),
(322, 'AM-02', 'Ararat\r', 'RE', 7, NULL, NULL, '265'),
(323, 'AM-03', 'Armavir\r', 'RE', 7, NULL, NULL, '266'),
(324, 'AM-04', 'Geghark''unik''\r', 'RE', 7, NULL, NULL, '267'),
(325, 'AM-05', 'Kotayk''\r', 'RE', 7, NULL, NULL, '268'),
(326, 'AM-06', 'Lorri\r', 'RE', 7, NULL, NULL, '269'),
(327, 'AM-07', 'Shirak\r', 'RE', 7, NULL, NULL, '270'),
(328, 'AM-08', 'Syunik''\r', 'RE', 7, NULL, NULL, '271'),
(329, 'AM-09', 'Tavush\r', 'RE', 7, NULL, NULL, '272'),
(330, 'AM-10', 'Vayots'' Dzor\r', 'RE', 7, NULL, NULL, '273'),
(331, 'AM-11', 'Yerevan\r', 'RE', 7, NULL, NULL, '274'),
(332, 'AO-19', 'Bengo\r', 'RE', 9, -9.01666600000, 13.92000300000, '275'),
(333, 'AO-01', 'Benguela\r', 'RE', 9, NULL, NULL, '276'),
(334, 'AO-02', 'Bie\r', 'RE', 9, -12.40000000000, 17.43190000000, '277'),
(335, 'AO-03', 'Cabinda\r', 'RE', 9, -5.56160000000, 12.18500000000, '278'),
(336, 'AO-04', 'Cuando Cubango\r', 'RE', 9, -15.95284000000, 19.75960400000, '279'),
(337, 'AO-05', 'Cuanza Norte\r', 'RE', 9, -8.85000000000, 14.92500000000, '280'),
(338, 'AO-06', 'Cuanza Sul\r', 'RE', 9, NULL, NULL, '281'),
(339, 'AO-07', 'Cunene\r', 'RE', 9, -16.31648100000, 15.28353000000, '282'),
(340, 'AO-08', 'Huambo\r', 'RE', 9, -12.76770000000, 15.73800000000, '283'),
(341, 'AO-09', 'Huila\r', 'RE', 9, NULL, NULL, '284'),
(342, 'AO-20', 'Luanda\r', 'RE', 9, -8.81350000000, 13.23190000000, '285'),
(343, 'AO-17', 'Lunda Norte\r', 'RE', 9, NULL, NULL, '286'),
(344, 'AO-18', 'Lunda Sul\r', 'RE', 9, -9.95833300000, 20.38926500000, '287'),
(345, 'AO-12', 'Malanje\r', 'RE', 9, NULL, NULL, '288'),
(346, 'AO-14', 'Moxico\r', 'RE', 9, -11.85000000000, 20.03333300000, '289'),
(347, 'AO-15', 'Uige\r', 'RE', 9, -7.60277800000, 15.02775000000, '290'),
(348, 'AO-16', 'Zaire\r', 'RE', 9, NULL, NULL, '291'),
(349, 'AR-01', 'Buenos Aires\r', 'RE', 11, NULL, NULL, '292'),
(350, 'AR-02', 'Catamarca\r', 'RE', 11, NULL, NULL, '293'),
(351, 'AR-03', 'Chaco\r', 'RE', 11, NULL, NULL, '294'),
(352, 'AR-04', 'Chubut\r', 'RE', 11, NULL, NULL, '295'),
(353, 'AR-05', 'Cordoba\r', 'RE', 11, NULL, NULL, '296'),
(354, 'AR-06', 'Corrientes\r', 'RE', 11, NULL, NULL, '297'),
(355, 'AR-07', 'Distrito Federal\r', 'RE', 11, NULL, NULL, '298'),
(356, 'AR-08', 'Entre Rios\r', 'RE', 11, NULL, NULL, '299'),
(357, 'AR-09', 'Formosa\r', 'RE', 11, NULL, NULL, '300'),
(358, 'AR-10', 'Jujuy\r', 'RE', 11, NULL, NULL, '301'),
(359, 'AR-11', 'La Pampa\r', 'RE', 11, NULL, NULL, '302'),
(360, 'AR-12', 'La Rioja\r', 'RE', 11, NULL, NULL, '303'),
(361, 'AR-13', 'Mendoza\r', 'RE', 11, NULL, NULL, '304'),
(362, 'AR-14', 'Misiones\r', 'RE', 11, NULL, NULL, '305'),
(363, 'AR-15', 'Neuquen\r', 'RE', 11, NULL, NULL, '306'),
(364, 'AR-16', 'Rio Negro\r', 'RE', 11, NULL, NULL, '307'),
(365, 'AR-17', 'Salta\r', 'RE', 11, NULL, NULL, '308'),
(366, 'AR-18', 'San Juan\r', 'RE', 11, NULL, NULL, '309'),
(367, 'AR-19', 'San Luis\r', 'RE', 11, NULL, NULL, '310'),
(368, 'AR-20', 'Santa Cruz\r', 'RE', 11, NULL, NULL, '311'),
(369, 'AR-21', 'Santa Fe\r', 'RE', 11, NULL, NULL, '312'),
(370, 'AR-22', 'Santiago del Estero\r', 'RE', 11, NULL, NULL, '313'),
(371, 'AR-23', 'Tierra del Fuego\r', 'RE', 11, NULL, NULL, '314'),
(372, 'AR-24', 'Tucuman\r', 'RE', 11, NULL, NULL, '315'),
(373, 'AT-01', 'Burgenland\r', 'RE', 13, NULL, NULL, '316'),
(374, 'AT-02', 'Karnten\r', 'RE', 13, NULL, NULL, '317'),
(375, 'AT-03', 'Niederosterreich\r', 'RE', 13, NULL, NULL, '318'),
(376, 'AT-04', 'Oberosterreich\r', 'RE', 13, NULL, NULL, '319'),
(377, 'AT-05', 'Salzburg\r', 'RE', 13, NULL, NULL, '320'),
(378, 'AT-06', 'Steiermark\r', 'RE', 13, NULL, NULL, '321'),
(379, 'AT-07', 'Tirol\r', 'RE', 13, NULL, NULL, '322'),
(380, 'AT-08', 'Vorarlberg\r', 'RE', 13, NULL, NULL, '323'),
(381, 'AT-09', 'Wien\r', 'RE', 13, NULL, NULL, '324'),
(382, 'AU-01', 'Australian Capital Territory\r', 'RE', 14, NULL, NULL, '325'),
(383, 'AU-02', 'New South Wales\r', 'RE', 14, NULL, NULL, '326'),
(384, 'AU-03', 'Northern Territory\r', 'RE', 14, NULL, NULL, '327'),
(385, 'AU-04', 'Queensland\r', 'RE', 14, NULL, NULL, '328'),
(386, 'AU-05', 'South Australia\r', 'RE', 14, NULL, NULL, '329'),
(387, 'AU-06', 'Tasmania\r', 'RE', 14, NULL, NULL, '330'),
(388, 'AU-07', 'Victoria\r', 'RE', 14, NULL, NULL, '331'),
(389, 'AU-08', 'Western Australia\r', 'RE', 14, NULL, NULL, '332'),
(390, 'AZ-01', 'Abseron\r', 'RE', 17, NULL, NULL, '333'),
(391, 'AZ-02', 'Agcabadi\r', 'RE', 17, NULL, NULL, '334'),
(392, 'AZ-03', 'Agdam\r', 'RE', 17, 39.98370000000, 46.92861200000, '335'),
(393, 'AZ-04', 'Agdas\r', 'RE', 17, NULL, NULL, '336'),
(394, 'AZ-05', 'Agstafa\r', 'RE', 17, NULL, NULL, '337'),
(395, 'AZ-06', 'Agsu\r', 'RE', 17, NULL, NULL, '338'),
(396, 'AZ-07', 'Ali Bayramli\r', 'RE', 17, NULL, NULL, '339'),
(397, 'AZ-08', 'Astara\r', 'RE', 17, 38.44000000000, 48.87520000000, '340'),
(398, 'AZ-09', 'Baki\r', 'RE', 17, NULL, NULL, '341'),
(399, 'AZ-10', 'Balakan\r', 'RE', 17, NULL, NULL, '342'),
(400, 'AZ-11', 'Barda\r', 'RE', 17, 40.38316000000, 47.11862200000, '343'),
(401, 'AZ-12', 'Beylaqan\r', 'RE', 17, NULL, NULL, '344'),
(402, 'AZ-13', 'Bilasuvar\r', 'RE', 17, NULL, NULL, '345'),
(403, 'AZ-14', 'Cabrayil\r', 'RE', 17, NULL, NULL, '346'),
(404, 'AZ-15', 'Calilabad\r', 'RE', 17, NULL, NULL, '347'),
(405, 'AZ-16', 'Daskasan\r', 'RE', 17, NULL, NULL, '348'),
(406, 'AZ-17', 'Davaci\r', 'RE', 17, NULL, NULL, '349'),
(407, 'AZ-18', 'Fuzuli\r', 'RE', 17, NULL, NULL, '350'),
(408, 'AZ-19', 'Gadabay\r', 'RE', 17, NULL, NULL, '351'),
(409, 'AZ-20', 'Ganca\r', 'RE', 17, NULL, NULL, '352'),
(410, 'AZ-21', 'Goranboy\r', 'RE', 17, NULL, NULL, '353'),
(411, 'AZ-22', 'Goycay\r', 'RE', 17, NULL, NULL, '354'),
(412, 'AZ-23', 'Haciqabul\r', 'RE', 17, NULL, NULL, '355'),
(413, 'AZ-24', 'Imisli\r', 'RE', 17, NULL, NULL, '356'),
(414, 'AZ-25', 'Ismayilli\r', 'RE', 17, NULL, NULL, '357'),
(415, 'AZ-26', 'Kalbacar\r', 'RE', 17, NULL, NULL, '358'),
(416, 'AZ-27', 'Kurdamir\r', 'RE', 17, NULL, NULL, '359'),
(417, 'AZ-28', 'Lacin\r', 'RE', 17, NULL, NULL, '360'),
(418, 'AZ-29', 'Lankaran\r', 'RE', 17, NULL, NULL, '361'),
(419, 'AZ-31', 'Lerik\r', 'RE', 17, 38.76685000000, 48.40573100000, '362'),
(420, 'AZ-32', 'Masalli\r', 'RE', 17, NULL, NULL, '363'),
(421, 'AZ-33', 'Mingacevir\r', 'RE', 17, NULL, NULL, '364'),
(422, 'AZ-34', 'Naftalan\r', 'RE', 17, NULL, NULL, '365'),
(423, 'AZ-35', 'Naxcivan\r', 'RE', 17, NULL, NULL, '366'),
(424, 'AZ-36', 'Neftcala\r', 'RE', 17, NULL, NULL, '367'),
(425, 'AZ-37', 'Oguz\r', 'RE', 17, NULL, NULL, '368'),
(426, 'AZ-38', 'Qabala\r', 'RE', 17, NULL, NULL, '369'),
(427, 'AZ-39', 'Qax\r', 'RE', 17, NULL, NULL, '370'),
(428, 'AZ-40', 'Qazax\r', 'RE', 17, NULL, NULL, '371'),
(429, 'AZ-41', 'Qobustan\r', 'RE', 17, NULL, NULL, '372'),
(430, 'AZ-42', 'Quba\r', 'RE', 17, NULL, NULL, '373'),
(431, 'AZ-43', 'Qubadli\r', 'RE', 17, NULL, NULL, '374'),
(432, 'AZ-44', 'Qusar\r', 'RE', 17, NULL, NULL, '375'),
(433, 'AZ-45', 'Saatli\r', 'RE', 17, NULL, NULL, '376'),
(434, 'AZ-46', 'Sabirabad\r', 'RE', 17, 40.00521100000, 48.47193100000, '377'),
(435, 'AZ-47', 'Saki\r', 'RE', 17, NULL, NULL, '378'),
(436, 'AZ-49', 'Salyan\r', 'RE', 17, NULL, NULL, '379'),
(437, 'AZ-50', 'Samaxi\r', 'RE', 17, NULL, NULL, '380'),
(438, 'AZ-51', 'Samkir\r', 'RE', 17, NULL, NULL, '381'),
(439, 'AZ-52', 'Samux\r', 'RE', 17, NULL, NULL, '382'),
(440, 'AZ-53', 'Siyazan\r', 'RE', 17, NULL, NULL, '383'),
(441, 'AZ-54', 'Sumqayit\r', 'RE', 17, NULL, NULL, '384'),
(442, 'AZ-55', 'Susa\r', 'RE', 17, NULL, NULL, '385'),
(443, 'AZ-57', 'Tartar\r', 'RE', 17, NULL, NULL, '386'),
(444, 'AZ-58', 'Tovuz\r', 'RE', 17, NULL, NULL, '387'),
(445, 'AZ-59', 'Ucar\r', 'RE', 17, NULL, NULL, '388'),
(446, 'AZ-60', 'Xacmaz\r', 'RE', 17, NULL, NULL, '389'),
(447, 'AZ-61', 'Xankandi\r', 'RE', 17, 39.81235100000, 46.75167100000, '390'),
(448, 'AZ-62', 'Xanlar\r', 'RE', 17, NULL, NULL, '391'),
(449, 'AZ-63', 'Xizi\r', 'RE', 17, NULL, NULL, '392'),
(450, 'AZ-64', 'Xocali\r', 'RE', 17, NULL, NULL, '393'),
(451, 'AZ-65', 'Xocavand\r', 'RE', 17, NULL, NULL, '394'),
(452, 'AZ-66', 'Yardimli\r', 'RE', 17, NULL, NULL, '395'),
(453, 'AZ-67', 'Yevlax\r', 'RE', 17, NULL, NULL, '396'),
(454, 'AZ-69', 'Zangilan\r', 'RE', 17, NULL, NULL, '397'),
(455, 'AZ-70', 'Zaqatala\r', 'RE', 17, NULL, NULL, '398'),
(456, 'AZ-71', 'Zardab\r', 'RE', 17, NULL, NULL, '399'),
(457, 'BA-01', 'Federation of Bosnia and Herzegovina\r', 'RE', 18, NULL, NULL, '400'),
(458, 'BA-02', 'Republika Srpska\r', 'RE', 18, NULL, NULL, '401'),
(459, 'BB-01', 'Christ Church\r', 'RE', 19, NULL, NULL, '402'),
(460, 'BB-02', 'Saint Andrew\r', 'RE', 19, NULL, NULL, '403'),
(461, 'BB-03', 'Saint George\r', 'RE', 19, NULL, NULL, '404'),
(462, 'BB-04', 'Saint James\r', 'RE', 19, NULL, NULL, '405'),
(463, 'BB-05', 'Saint John\r', 'RE', 19, NULL, NULL, '406'),
(464, 'BB-06', 'Saint Joseph\r', 'RE', 19, 13.20232000000, -59.52676000000, '407'),
(465, 'BB-07', 'Saint Lucy\r', 'RE', 19, NULL, NULL, '408'),
(466, 'BB-08', 'Saint Michael\r', 'RE', 19, NULL, NULL, '409'),
(467, 'BB-09', 'Saint Peter\r', 'RE', 19, NULL, NULL, '410'),
(468, 'BB-10', 'Saint Philip\r', 'RE', 19, NULL, NULL, '411'),
(469, 'BB-11', 'Saint Thomas\r', 'RE', 19, NULL, NULL, '412'),
(470, 'BD-22', 'Bagerhat\r', 'RE', 20, 22.65707000000, 89.80368000000, '413'),
(471, 'BD-04', 'Bandarban\r', 'RE', 20, 22.16190000000, 92.18030000000, '414'),
(472, 'BD-25', 'Barguna\r', 'RE', 20, NULL, NULL, '415'),
(473, 'BD-01', 'Barisal\r', 'RE', 20, 22.40071200000, 90.42992000000, '416'),
(474, 'BD-23', 'Bhola\r', 'RE', 20, 22.67948900000, 90.64391300000, '417'),
(475, 'BD-24', 'Bogra\r', 'RE', 20, 24.84440000000, 89.37840000000, '418'),
(476, 'BD-26', 'Brahmanbaria\r', 'RE', 20, NULL, NULL, '419'),
(477, 'BD-27', 'Chandpur\r', 'RE', 20, 23.22230900000, 90.65051300000, '420'),
(478, 'BD-28', 'Chapai Nawabganj\r', 'RE', 20, NULL, NULL, '421'),
(479, 'BD-29', 'Chattagram\r', 'RE', 20, NULL, NULL, '422'),
(480, 'BD-30', 'Chuadanga\r', 'RE', 20, 23.64077900000, 88.68547800000, '423'),
(481, 'BD-05', 'Comilla\r', 'RE', 20, 23.43580000000, 91.18900000000, '424'),
(482, 'BD-31', 'Cox''s Bazar\r', 'RE', 20, NULL, NULL, '425'),
(483, 'BD-32', 'Dhaka\r', 'RE', 20, 23.70548000000, 90.41129500000, '426'),
(484, 'BD-33', 'Dinajpur\r', 'RE', 20, 25.62550000000, 88.64040000000, '427'),
(485, 'BD-34', 'Faridpur\r', 'RE', 20, 23.44035900000, 89.51273300000, '428'),
(486, 'BD-35', 'Feni\r', 'RE', 20, 22.99185900000, 91.38970200000, '429'),
(487, 'BD-36', 'Gaibandha\r', 'RE', 20, NULL, NULL, '430'),
(488, 'BD-37', 'Gazipur\r', 'RE', 20, 22.43000000000, 89.18000000000, '431'),
(489, 'BD-38', 'Gopalganj\r', 'RE', 20, NULL, NULL, '432'),
(490, 'BD-39', 'Habiganj\r', 'RE', 20, 24.37978900000, 91.40908800000, '433'),
(491, 'BD-40', 'Jaipurhat\r', 'RE', 20, NULL, NULL, '434'),
(492, 'BD-41', 'Jamalpur\r', 'RE', 20, 24.91620000000, 89.94260000000, '435'),
(493, 'BD-42', 'Jessore\r', 'RE', 20, 23.18330000000, 89.16660000000, '436'),
(494, 'BD-43', 'Jhalakati\r', 'RE', 20, NULL, NULL, '437'),
(495, 'BD-44', 'Jhenaidah\r', 'RE', 20, NULL, NULL, '438'),
(496, 'BD-45', 'Khagrachari\r', 'RE', 20, NULL, NULL, '439'),
(497, 'BD-46', 'Khulna\r', 'RE', 20, 22.91209800000, 89.27950700000, '440'),
(498, 'BD-47', 'Kishorganj\r', 'RE', 20, 24.42580000000, 90.78460000000, '441'),
(499, 'BD-48', 'Kurigram\r', 'RE', 20, NULL, NULL, '442'),
(500, 'BD-49', 'Kushtia\r', 'RE', 20, 23.93450000000, 88.99360000000, '443'),
(501, 'BD-50', 'Laksmipur\r', 'RE', 20, NULL, NULL, '444'),
(502, 'BD-51', 'Lalmonirhat\r', 'RE', 20, NULL, NULL, '445'),
(503, 'BD-52', 'Madaripur\r', 'RE', 20, 23.16540000000, 90.19860000000, '446'),
(504, 'BD-53', 'Magura\r', 'RE', 20, 26.28000000000, 88.51000000000, '447'),
(505, 'BD-54', 'Manikganj\r', 'RE', 20, NULL, NULL, '448'),
(506, 'BD-55', 'Meherpur\r', 'RE', 20, 23.77120000000, 88.64250000000, '449'),
(507, 'BD-56', 'Moulavibazar\r', 'RE', 20, NULL, NULL, '450'),
(508, 'BD-57', 'Munshiganj\r', 'RE', 20, 23.54997100000, 90.52522300000, '451'),
(509, 'BD-12', 'Mymensingh\r', 'RE', 20, 24.75570000000, 90.39810000000, '452'),
(510, 'BD-58', 'Naogaon\r', 'RE', 20, 24.80452000000, 88.93525700000, '453'),
(511, 'BD-59', 'Narail\r', 'RE', 20, 23.16000000000, 89.50000000000, '454'),
(512, 'BD-60', 'Narayanganj\r', 'RE', 20, 23.61900000000, 90.49790000000, '455'),
(513, 'BD-61', 'Narsingdi\r', 'RE', 20, NULL, NULL, '456'),
(514, 'BD-62', 'Nator\r', 'RE', 20, 24.41450000000, 88.99150000000, '457'),
(515, 'BD-63', 'Netrakona\r', 'RE', 20, 24.88610100000, 90.72913400000, '458'),
(516, 'BD-64', 'Nilphamari\r', 'RE', 20, 25.93454000000, 88.84956400000, '459'),
(517, 'BD-13', 'Noakhali\r', 'RE', 20, 22.81008000000, 91.09974700000, '460'),
(518, 'BD-65', 'Pabna\r', 'RE', 20, 24.00480000000, 89.25790000000, '461'),
(519, 'BD-66', 'Panchagar\r', 'RE', 20, NULL, NULL, '462'),
(520, 'BD-67', 'Parbattya Chattagram\r', 'RE', 20, NULL, NULL, '463'),
(521, 'BD-15', 'Patuakhali\r', 'RE', 20, 22.35588100000, 90.24210400000, '464'),
(522, 'BD-68', 'Pirojpur\r', 'RE', 20, 22.57352100000, 89.98737300000, '465'),
(523, 'BD-69', 'Rajbari\r', 'RE', 20, 23.75408900000, 89.65197000000, '466'),
(524, 'BD-70', 'Rajshahi\r', 'RE', 20, 25.22802800000, 88.95433400000, '467'),
(525, 'BD-71', 'Rangpur\r', 'RE', 20, 25.75000000000, 89.23330000000, '468'),
(526, 'BD-72', 'Satkhira\r', 'RE', 20, 22.70439900000, 89.08293900000, '469'),
(527, 'BD-73', 'Shariyatpur\r', 'RE', 20, NULL, NULL, '470'),
(528, 'BD-74', 'Sherpur\r', 'RE', 20, 25.01640000000, 90.01430000000, '471'),
(529, 'BD-75', 'Sirajganj\r', 'RE', 20, 24.45539100000, 89.69995100000, '472'),
(530, 'BD-76', 'Sunamganj\r', 'RE', 20, 25.04562000000, 91.38715400000, '473'),
(531, 'BD-77', 'Sylhet\r', 'RE', 20, 24.58997800000, 91.72658700000, '474'),
(532, 'BD-78', 'Tangail\r', 'RE', 20, 24.24470000000, 89.92430000000, '475'),
(533, 'BD-79', 'Thakurgaon\r', 'RE', 20, 26.01666700000, 88.46666700000, '476'),
(534, 'BE-01', 'Antwerpen\r', 'RE', 21, NULL, NULL, '477'),
(535, 'BE-02', 'Brabant\r', 'RE', 21, NULL, NULL, '478'),
(536, 'BE-10', 'Brabant Wallon\r', 'RE', 21, 50.66634800000, 4.55561300000, '479'),
(537, 'BE-11', 'Brussels Hoofdstedelijk Gewest\r', 'RE', 21, NULL, NULL, '480'),
(538, 'BE-03', 'Hainaut\r', 'RE', 21, NULL, NULL, '481'),
(539, 'BE-04', 'Liege\r', 'RE', 21, NULL, NULL, '482'),
(540, 'BE-05', 'Limburg\r', 'RE', 21, NULL, NULL, '483'),
(541, 'BE-06', 'Luxembourg\r', 'RE', 21, NULL, NULL, '484'),
(542, 'BE-07', 'Namur\r', 'RE', 21, NULL, NULL, '485'),
(543, 'BE-08', 'Oost-Vlaanderen\r', 'RE', 21, NULL, NULL, '486'),
(544, 'BE-12', 'Vlaams-Brabant\r', 'RE', 21, NULL, NULL, '487'),
(545, 'BE-09', 'West-Vlaanderen\r', 'RE', 21, NULL, NULL, '488'),
(546, 'BF-45', 'Bale\r', 'RE', 22, 13.70000000000, -0.61666700000, '489'),
(547, 'BF-15', 'Bam\r', 'RE', 22, NULL, NULL, '490'),
(548, 'BF-46', 'Banwa\r', 'RE', 22, NULL, NULL, '491'),
(549, 'BF-47', 'Bazega\r', 'RE', 22, NULL, NULL, '492'),
(550, 'BF-48', 'Bougouriba\r', 'RE', 22, NULL, NULL, '493'),
(551, 'BF-49', 'Boulgou\r', 'RE', 22, 12.51166000000, 0.83241500000, '494'),
(552, 'BF-19', 'Boulkiemde\r', 'RE', 22, NULL, NULL, '495'),
(553, 'BF-20', 'Ganzourgou\r', 'RE', 22, NULL, NULL, '496'),
(554, 'BF-21', 'Gnagna\r', 'RE', 22, NULL, NULL, '497'),
(555, 'BF-50', 'Gourma\r', 'RE', 22, 12.93333300000, 0.73333300000, '498'),
(556, 'BF-51', 'Houet\r', 'RE', 22, NULL, NULL, '499'),
(557, 'BF-52', 'Ioba\r', 'RE', 22, NULL, NULL, '500'),
(558, 'BF-53', 'Kadiogo\r', 'RE', 22, NULL, NULL, '501'),
(559, 'BF-54', 'Kenedougou\r', 'RE', 22, NULL, NULL, '502'),
(560, 'BF-55', 'Komoe\r', 'RE', 22, NULL, NULL, '503'),
(561, 'BF-56', 'Komondjari\r', 'RE', 22, NULL, NULL, '504'),
(562, 'BF-57', 'Kompienga\r', 'RE', 22, NULL, NULL, '505'),
(563, 'BF-58', 'Kossi\r', 'RE', 22, NULL, NULL, '506'),
(564, 'BF-59', 'Koulpelogo\r', 'RE', 22, NULL, NULL, '507'),
(565, 'BF-28', 'Kouritenga\r', 'RE', 22, NULL, NULL, '508'),
(566, 'BF-60', 'Kourweogo\r', 'RE', 22, NULL, NULL, '509'),
(567, 'BF-61', 'Leraba\r', 'RE', 22, 10.06782000000, -4.79913300000, '510'),
(568, 'BF-62', 'Loroum\r', 'RE', 22, NULL, NULL, '511'),
(569, 'BF-63', 'Mouhoun\r', 'RE', 22, NULL, NULL, '512'),
(570, 'BF-64', 'Namentenga\r', 'RE', 22, NULL, NULL, '513'),
(571, 'BF-65', 'Naouri\r', 'RE', 22, 12.13333300000, 0.58333300000, '514'),
(572, 'BF-66', 'Nayala\r', 'RE', 22, NULL, NULL, '515'),
(573, 'BF-67', 'Noumbiel\r', 'RE', 22, NULL, NULL, '516'),
(574, 'BF-68', 'Oubritenga\r', 'RE', 22, NULL, NULL, '517'),
(575, 'BF-33', 'Oudalan\r', 'RE', 22, NULL, NULL, '518'),
(576, 'BF-34', 'Passore\r', 'RE', 22, NULL, NULL, '519'),
(577, 'BF-69', 'Poni\r', 'RE', 22, NULL, NULL, '520'),
(578, 'BF-36', 'Sanguie\r', 'RE', 22, NULL, NULL, '521'),
(579, 'BF-70', 'Sanmatenga\r', 'RE', 22, NULL, NULL, '522'),
(580, 'BF-71', 'Seno\r', 'RE', 22, 14.36666700000, -0.56666700000, '523'),
(581, 'BF-72', 'Sissili\r', 'RE', 22, NULL, NULL, '524'),
(582, 'BF-40', 'Soum\r', 'RE', 22, NULL, NULL, '525'),
(583, 'BF-73', 'Sourou\r', 'RE', 22, 11.41666700000, -1.86666700000, '526'),
(584, 'BF-42', 'Tapoa\r', 'RE', 22, 12.48433700000, 2.39936500000, '527'),
(585, 'BF-74', 'Tuy\r', 'RE', 22, NULL, NULL, '528'),
(586, 'BF-75', 'Yagha\r', 'RE', 22, 10.46666700000, -2.78333300000, '529'),
(587, 'BF-76', 'Yatenga\r', 'RE', 22, NULL, NULL, '530'),
(588, 'BF-77', 'Ziro\r', 'RE', 22, NULL, NULL, '531'),
(589, 'BF-78', 'Zondoma\r', 'RE', 22, NULL, NULL, '532'),
(590, 'BF-44', 'Zoundweogo\r', 'RE', 22, NULL, NULL, '533'),
(591, 'BG-38', 'Blagoevgrad\r', 'RE', 23, NULL, NULL, '534'),
(592, 'BG-39', 'Burgas\r', 'RE', 23, NULL, NULL, '535'),
(593, 'BG-40', 'Dobrich\r', 'RE', 23, NULL, NULL, '536'),
(594, 'BG-41', 'Gabrovo\r', 'RE', 23, NULL, NULL, '537'),
(595, 'BG-42', 'Grad Sofiya\r', 'RE', 23, NULL, NULL, '538'),
(596, 'BG-43', 'Khaskovo\r', 'RE', 23, NULL, NULL, '539'),
(597, 'BG-44', 'Kurdzhali\r', 'RE', 23, NULL, NULL, '540'),
(598, 'BG-45', 'Kyustendil\r', 'RE', 23, NULL, NULL, '541'),
(599, 'BG-46', 'Lovech\r', 'RE', 23, NULL, NULL, '542'),
(600, 'BG-33', 'Mikhaylovgrad\r', 'RE', 23, NULL, NULL, '543'),
(601, 'BG-47', 'Montana\r', 'RE', 23, NULL, NULL, '544'),
(602, 'BG-48', 'Pazardzhik\r', 'RE', 23, NULL, NULL, '545'),
(603, 'BG-49', 'Pernik\r', 'RE', 23, NULL, NULL, '546'),
(604, 'BG-50', 'Pleven\r', 'RE', 23, NULL, NULL, '547'),
(605, 'BG-51', 'Plovdiv\r', 'RE', 23, NULL, NULL, '548'),
(606, 'BG-52', 'Razgrad\r', 'RE', 23, NULL, NULL, '549'),
(607, 'BG-53', 'Ruse\r', 'RE', 23, NULL, NULL, '550'),
(608, 'BG-54', 'Shumen\r', 'RE', 23, NULL, NULL, '551'),
(609, 'BG-55', 'Silistra\r', 'RE', 23, NULL, NULL, '552'),
(610, 'BG-56', 'Sliven\r', 'RE', 23, NULL, NULL, '553'),
(611, 'BG-57', 'Smolyan\r', 'RE', 23, NULL, NULL, '554'),
(612, 'BG-58', 'Sofiya\r', 'RE', 23, NULL, NULL, '555'),
(613, 'BG-59', 'Stara Zagora\r', 'RE', 23, NULL, NULL, '556'),
(614, 'BG-60', 'Turgovishte\r', 'RE', 23, NULL, NULL, '557'),
(615, 'BG-61', 'Varna\r', 'RE', 23, NULL, NULL, '558'),
(616, 'BG-62', 'Veliko Turnovo\r', 'RE', 23, NULL, NULL, '559'),
(617, 'BG-63', 'Vidin\r', 'RE', 23, NULL, NULL, '560'),
(618, 'BG-64', 'Vratsa\r', 'RE', 23, NULL, NULL, '561'),
(619, 'BG-65', 'Yambol\r', 'RE', 23, NULL, NULL, '562'),
(620, 'BH-01', 'Al Hadd\r', 'RE', 24, NULL, NULL, '563'),
(621, 'BH-02', 'Al Manamah\r', 'RE', 24, NULL, NULL, '564'),
(622, 'BH-08', 'Al Mintaqah al Gharbiyah\r', 'RE', 24, 26.04178000000, 50.49752900000, '565'),
(623, 'BH-11', 'Al Mintaqah al Wusta\r', 'RE', 24, 26.17831500000, 50.53250800000, '566'),
(624, 'BH-10', 'Al Mintaqah ash Shamaliyah\r', 'RE', 24, NULL, NULL, '567'),
(625, 'BH-03', 'Al Muharraq\r', 'RE', 24, NULL, NULL, '568'),
(626, 'BH-13', 'Ar Rifa\r', 'RE', 24, 26.12980000000, 50.53700000000, '569'),
(627, 'BH-05', 'Jidd Hafs\r', 'RE', 24, NULL, NULL, '570'),
(628, 'BH-12', 'Madinat\r', 'RE', 24, NULL, NULL, '571'),
(629, 'BH-14', 'Madinat Hamad\r', 'RE', 24, 26.10045600000, 50.51252100000, '572'),
(630, 'BH-09', 'Mintaqat Juzur Hawar\r', 'RE', 24, NULL, NULL, '573'),
(631, 'BH-06', 'Sitrah\r', 'RE', 24, 26.16101200000, 50.62515100000, '574'),
(632, 'BI-09', 'Bubanza\r', 'RE', 25, -3.13350200000, 29.38668600000, '575'),
(633, 'BI-02', 'Bujumbura\r', 'RE', 25, NULL, NULL, '576'),
(634, 'BI-10', 'Bururi\r', 'RE', 25, -3.88226900000, 29.64166700000, '577'),
(635, 'BI-11', 'Cankuzo\r', 'RE', 25, -3.15000000000, 30.60367600000, '578'),
(636, 'BI-12', 'Cibitoke\r', 'RE', 25, -2.83333300000, 29.22500000000, '579'),
(637, 'BI-13', 'Gitega\r', 'RE', 25, -3.44166700000, 29.91666600000, '580'),
(638, 'BI-14', 'Karuzi\r', 'RE', 25, -3.12500000000, 30.12500000000, '581'),
(639, 'BI-15', 'Kayanza\r', 'RE', 25, -3.02500000000, 29.64166700000, '582'),
(640, 'BI-16', 'Kirundo\r', 'RE', 25, -2.55000000000, 30.15833300000, '583'),
(641, 'BI-17', 'Makamba\r', 'RE', 25, -4.19166700000, 29.82500000000, '584'),
(642, 'BI-22', 'Muramvya\r', 'RE', 25, -3.38333300000, 29.69166600000, '585'),
(643, 'BI-18', 'Muyinga\r', 'RE', 25, -2.70833300000, 30.30000000000, '586'),
(644, 'BI-23', 'Mwaro\r', 'RE', 25, NULL, NULL, '587'),
(645, 'BI-19', 'Ngozi\r', 'RE', 25, -2.90000000000, 29.87500000000, '588'),
(646, 'BI-20', 'Rutana\r', 'RE', 25, -3.82500000000, 30.16666600000, '589'),
(647, 'BI-21', 'Ruyigi\r', 'RE', 25, -3.45541800000, 30.35833300000, '590'),
(648, 'BJ-01', 'Atakora\r', 'RE', 26, NULL, NULL, '591'),
(649, 'BJ-02', 'Atlantique\r', 'RE', 26, NULL, NULL, '592'),
(650, 'BJ-03', 'Borgou\r', 'RE', 26, NULL, NULL, '593'),
(651, 'BJ-04', 'Mono\r', 'RE', 26, NULL, NULL, '594'),
(652, 'BJ-05', 'Oueme\r', 'RE', 26, NULL, NULL, '595'),
(653, 'BJ-06', 'Zou\r', 'RE', 26, NULL, NULL, '596'),
(654, 'BM-01', 'Devonshire\r', 'RE', 28, 33.73958000000, -116.30926700000, '597'),
(655, 'BM-02', 'Hamilton\r', 'RE', 28, 32.32933700000, -64.70600000000, '598'),
(656, 'BM-04', 'Paget\r', 'RE', 28, NULL, NULL, '599'),
(657, 'BM-05', 'Pembroke\r', 'RE', 28, 37.28994900000, -77.43291400000, '600'),
(658, 'BM-06', 'Saint George\r', 'RE', 28, NULL, NULL, '601'),
(659, 'BM-07', 'Saint George''s\r', 'RE', 28, NULL, NULL, '602'),
(660, 'BM-08', 'Sandys\r', 'RE', 28, NULL, NULL, '603'),
(661, 'BM-09', 'Smiths\r', 'RE', 28, NULL, NULL, '604'),
(662, 'BM-10', 'Southampton\r', 'RE', 28, 37.23734200000, -77.37665900000, '605'),
(663, 'BM-11', 'Warwick\r', 'RE', 28, 37.45889000000, -77.42306000000, '606'),
(664, 'BN-07', 'Alibori\r', 'RE', 29, NULL, NULL, '607'),
(665, 'BN-08', 'Belait\r', 'RE', 29, 4.44975800000, 114.31870300000, '608'),
(666, 'BN-09', 'Brunei and Muara\r', 'RE', 29, NULL, NULL, '609'),
(667, 'BN-11', 'Collines\r', 'RE', 29, NULL, NULL, '610'),
(668, 'BN-13', 'Donga\r', 'RE', 29, NULL, NULL, '611'),
(669, 'BN-12', 'Kouffo\r', 'RE', 29, NULL, NULL, '612'),
(670, 'BN-14', 'Littoral\r', 'RE', 29, NULL, NULL, '613'),
(671, 'BN-16', 'Oueme\r', 'RE', 29, NULL, NULL, '614'),
(672, 'BN-17', 'Plateau\r', 'RE', 29, NULL, NULL, '615'),
(673, 'BN-10', 'Temburong\r', 'RE', 29, NULL, NULL, '616'),
(674, 'BN-15', 'Tutong\r', 'RE', 29, 4.80578400000, 114.64669800000, '617'),
(675, 'BN-18', 'Zou\r', 'RE', 29, NULL, NULL, '618'),
(676, 'BO-01', 'Chuquisaca\r', 'RE', 30, NULL, NULL, '619'),
(677, 'BO-02', 'Cochabamba\r', 'RE', 30, NULL, NULL, '620'),
(678, 'BO-03', 'El Beni\r', 'RE', 30, NULL, NULL, '621'),
(679, 'BO-04', 'La Paz\r', 'RE', 30, NULL, NULL, '622'),
(680, 'BO-05', 'Oruro\r', 'RE', 30, NULL, NULL, '623'),
(681, 'BO-06', 'Pando\r', 'RE', 30, -11.08862300000, -67.42319800000, '624'),
(682, 'BO-07', 'Potosi\r', 'RE', 30, NULL, NULL, '625'),
(683, 'BO-08', 'Santa Cruz\r', 'RE', 30, NULL, NULL, '626'),
(684, 'BO-09', 'Tarija\r', 'RE', 30, NULL, NULL, '627'),
(685, 'BR-01', 'Acre\r', 'RE', 31, NULL, NULL, '628'),
(686, 'BR-02', 'Alagoas\r', 'RE', 31, NULL, NULL, '629'),
(687, 'BR-03', 'Amapa\r', 'RE', 31, NULL, NULL, '630'),
(688, 'BR-04', 'Amazonas\r', 'RE', 31, NULL, NULL, '631'),
(689, 'BR-05', 'Bahia\r', 'RE', 31, NULL, NULL, '632'),
(690, 'BR-06', 'Ceara\r', 'RE', 31, NULL, NULL, '633'),
(691, 'BR-07', 'Distrito Federal\r', 'RE', 31, NULL, NULL, '634'),
(692, 'BR-08', 'Espirito Santo\r', 'RE', 31, NULL, NULL, '635'),
(693, 'BR-29', 'Goias\r', 'RE', 31, NULL, NULL, '636'),
(694, 'BR-13', 'Maranhao\r', 'RE', 31, NULL, NULL, '637'),
(695, 'BR-14', 'Mato Grosso\r', 'RE', 31, NULL, NULL, '638'),
(696, 'BR-11', 'Mato Grosso do Sul\r', 'RE', 31, NULL, NULL, '639'),
(697, 'BR-15', 'Minas Gerais\r', 'RE', 31, NULL, NULL, '640'),
(698, 'BR-16', 'Para\r', 'RE', 31, NULL, NULL, '641'),
(699, 'BR-17', 'Paraiba\r', 'RE', 31, NULL, NULL, '642'),
(700, 'BR-18', 'Parana\r', 'RE', 31, NULL, NULL, '643'),
(701, 'BR-30', 'Pernambuco\r', 'RE', 31, NULL, NULL, '644'),
(702, 'BR-20', 'Piaui\r', 'RE', 31, NULL, NULL, '645'),
(703, 'BR-21', 'Rio de Janeiro\r', 'RE', 31, NULL, NULL, '646'),
(704, 'BR-22', 'Rio Grande do Norte\r', 'RE', 31, NULL, NULL, '647'),
(705, 'BR-23', 'Rio Grande do Sul\r', 'RE', 31, NULL, NULL, '648'),
(706, 'BR-24', 'Rondonia\r', 'RE', 31, NULL, NULL, '649'),
(707, 'BR-25', 'Roraima\r', 'RE', 31, NULL, NULL, '650'),
(708, 'BR-26', 'Santa Catarina\r', 'RE', 31, NULL, NULL, '651'),
(709, 'BR-27', 'Sao Paulo\r', 'RE', 31, NULL, NULL, '652'),
(710, 'BR-28', 'Sergipe\r', 'RE', 31, NULL, NULL, '653'),
(711, 'BR-31', 'Tocantins\r', 'RE', 31, NULL, NULL, '654'),
(712, 'BS-24', 'Acklins and Crooked Islands\r', 'RE', 32, NULL, NULL, '655'),
(713, 'BS-05', 'Bimini\r', 'RE', 32, 25.70037800000, -79.26474000000, '656'),
(714, 'BS-06', 'Cat Island\r', 'RE', 32, 24.40320900000, -75.52594800000, '657'),
(715, 'BS-10', 'Exuma\r', 'RE', 32, 23.56913000000, -75.84544700000, '658'),
(716, 'BS-25', 'Freeport\r', 'RE', 32, NULL, NULL, '659'),
(717, 'BS-26', 'Fresh Creek\r', 'RE', 32, NULL, NULL, '660'),
(718, 'BS-27', 'Governor''s Harbour\r', 'RE', 32, NULL, NULL, '661'),
(719, 'BS-28', 'Green Turtle Cay\r', 'RE', 32, NULL, NULL, '662'),
(720, 'BS-22', 'Harbour Island\r', 'RE', 32, NULL, NULL, '663'),
(721, 'BS-29', 'High Rock\r', 'RE', 32, NULL, NULL, '664'),
(722, 'BS-13', 'Inagua\r', 'RE', 32, 20.97722200000, -73.66527600000, '665'),
(723, 'BS-30', 'Kemps Bay\r', 'RE', 32, 23.86666700000, -77.51666700000, '666'),
(724, 'BS-15', 'Long Island\r', 'RE', 32, 23.27165100000, -75.08570800000, '667'),
(725, 'BS-31', 'Marsh Harbour\r', 'RE', 32, NULL, NULL, '668'),
(726, 'BS-16', 'Mayaguana\r', 'RE', 32, 22.37952800000, -73.01350000000, '669'),
(727, 'BS-23', 'New Providence\r', 'RE', 32, NULL, NULL, '670'),
(728, 'BS-32', 'Nichollstown and Berry Islands\r', 'RE', 32, NULL, NULL, '671'),
(729, 'BS-18', 'Ragged Island\r', 'RE', 32, 22.22731000000, -75.73079300000, '672'),
(730, 'BS-33', 'Rock Sound\r', 'RE', 32, 24.96731000000, -76.18382300000, '673'),
(731, 'BS-35', 'San Salvador and Rum Cay\r', 'RE', 32, NULL, NULL, '674'),
(732, 'BS-34', 'Sandy Point\r', 'RE', 32, 26.00463900000, -77.39548300000, '675'),
(733, 'BT-05', 'Bumthang\r', 'RE', 33, 27.68225900000, 90.63064300000, '676'),
(734, 'BT-06', 'Chhukha\r', 'RE', 33, NULL, NULL, '677');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(735, 'BT-07', 'Chirang\r', 'RE', 33, NULL, NULL, '678'),
(736, 'BT-08', 'Daga\r', 'RE', 33, NULL, NULL, '679'),
(737, 'BT-09', 'Geylegphug\r', 'RE', 33, NULL, NULL, '680'),
(738, 'BT-10', 'Ha\r', 'RE', 33, NULL, NULL, '681'),
(739, 'BT-11', 'Lhuntshi\r', 'RE', 33, NULL, NULL, '682'),
(740, 'BT-12', 'Mongar\r', 'RE', 33, 27.12915200000, 91.16715600000, '683'),
(741, 'BT-13', 'Paro\r', 'RE', 33, 27.51356800000, 89.35705800000, '684'),
(742, 'BT-14', 'Pemagatsel\r', 'RE', 33, NULL, NULL, '685'),
(743, 'BT-15', 'Punakha\r', 'RE', 33, 27.68042500000, 89.89518200000, '686'),
(744, 'BT-16', 'Samchi\r', 'RE', 33, NULL, NULL, '687'),
(745, 'BT-17', 'Samdrup\r', 'RE', 33, 26.81000000000, 91.56000000000, '688'),
(746, 'BT-18', 'Shemgang\r', 'RE', 33, NULL, NULL, '689'),
(747, 'BT-19', 'Tashigang\r', 'RE', 33, 27.37943100000, 91.87918900000, '690'),
(748, 'BT-20', 'Thimphu\r', 'RE', 33, NULL, NULL, '691'),
(749, 'BT-21', 'Tongsa\r', 'RE', 33, 27.49996900000, 90.50335700000, '692'),
(750, 'BT-22', 'Wangdi Phodrang\r', 'RE', 33, 27.53841000000, 89.89295100000, '693'),
(751, 'BW-01', 'Central\r', 'RE', 35, -21.48333400000, 26.42262800000, '694'),
(752, 'BW-02', 'Chobe\r', 'RE', 35, -18.30833400000, 24.88333300000, '695'),
(753, 'BW-03', 'Ghanzi\r', 'RE', 35, -21.70397500000, 21.64618000000, '696'),
(754, 'BW-04', 'Kgalagadi\r', 'RE', 35, -25.07500000000, 22.07500000000, '697'),
(755, 'BW-05', 'Kgatleng\r', 'RE', 35, -24.21666700000, 26.35000000000, '698'),
(756, 'BW-06', 'Kweneng\r', 'RE', 35, -24.03006300000, 24.50000000000, '699'),
(757, 'BW-07', 'Ngamiland\r', 'RE', 35, -19.24486600000, 23.10000000000, '700'),
(758, 'BW-08', 'North-East\r', 'RE', 35, NULL, NULL, '701'),
(759, 'BW-09', 'South-East\r', 'RE', 35, NULL, NULL, '702'),
(760, 'BW-10', 'Southern\r', 'RE', 35, -25.00833300000, 24.39608800000, '703'),
(761, 'BY-01', 'Brestskaya Voblasts''\r', 'RE', 36, NULL, NULL, '704'),
(762, 'BY-02', 'Homyel''skaya Voblasts''\r', 'RE', 36, NULL, NULL, '705'),
(763, 'BY-03', 'Hrodzyenskaya Voblasts''\r', 'RE', 36, NULL, NULL, '706'),
(764, 'BY-06', 'Mahilyowskaya Voblasts''\r', 'RE', 36, NULL, NULL, '707'),
(765, 'BY-04', 'Minsk\r', 'RE', 36, NULL, NULL, '708'),
(766, 'BY-05', 'Minskaya Voblasts''\r', 'RE', 36, NULL, NULL, '709'),
(767, 'BY-07', 'Vitsyebskaya Voblasts''\r', 'RE', 36, NULL, NULL, '710'),
(768, 'BZ-01', 'Belize\r', 'RE', 37, NULL, NULL, '711'),
(769, 'BZ-02', 'Cayo\r', 'RE', 37, NULL, NULL, '712'),
(770, 'BZ-03', 'Corozal\r', 'RE', 37, NULL, NULL, '713'),
(771, 'BZ-04', 'Orange Walk\r', 'RE', 37, 17.77972600000, -88.71841100000, '714'),
(772, 'BZ-05', 'Stann Creek\r', 'RE', 37, NULL, NULL, '715'),
(773, 'BZ-06', 'Toledo\r', 'RE', 37, NULL, NULL, '716'),
(774, 'CA-01', 'Alberta\r', 'RE', 38, 54.50098100000, -114.99992000000, '717'),
(775, 'CA-02', 'British Columbia\r', 'RE', 38, 54.11574900000, -126.55071000000, '718'),
(776, 'CA-03', 'Manitoba\r', 'RE', 38, 54.50362900000, -95.49425500000, '719'),
(777, 'CA-04', 'New Brunswick\r', 'RE', 38, 46.28587500000, -66.25601500000, '720'),
(778, 'CA-05', 'Newfoundland and Labrador\r', 'RE', 38, 53.33712500000, -60.21835000000, '721'),
(779, 'CA-13', 'Northwest Territories\r', 'RE', 38, 69.36212000000, -119.24044500000, '722'),
(780, 'CA-07', 'Nova Scotia\r', 'RE', 38, 45.54342500000, -61.63183000000, '723'),
(781, 'CA-14', 'Nunavut\r', 'RE', 38, 67.13686500000, -91.09202500000, '724'),
(782, 'CA-08', 'Ontario\r', 'RE', 38, 49.26788000000, -84.74493000000, '725'),
(783, 'CA-09', 'Prince Edward Island\r', 'RE', 38, 46.63464500000, -63.05213000000, '726'),
(784, 'CA-10', 'Quebec\r', 'RE', 38, 46.81274000000, -71.21935000000, '727'),
(785, 'CA-11', 'Saskatchewan\r', 'RE', 38, 54.50071000000, -105.68423000000, '728'),
(786, 'CA-12', 'Yukon Territory\r', 'RE', 38, 64.83690000000, -132.39536000000, '729'),
(787, 'CD-01', 'Bandundu\r', 'RE', 40, -3.30777800000, 17.38333300000, '730'),
(788, 'CD-08', 'Bas-Congo\r', 'RE', 40, -5.18338800000, 14.25833300000, '731'),
(789, 'CD-02', 'Equateur\r', 'RE', 40, 1.35833400000, 20.29064900000, '732'),
(790, 'CD-03', 'Kasai-Occidental\r', 'RE', 40, -5.14998200000, 21.73654100000, '733'),
(791, 'CD-04', 'Kasai-Oriental\r', 'RE', 40, -4.85672200000, 24.05833300000, '734'),
(792, 'CD-05', 'Katanga\r', 'RE', 40, -9.17904500000, 26.19199700000, '735'),
(793, 'CD-06', 'Kinshasa\r', 'RE', 40, -4.49166600000, 15.82800100000, '736'),
(794, 'CD-07', 'Kivu\r', 'RE', 40, NULL, NULL, '737'),
(795, 'CD-10', 'Maniema\r', 'RE', 40, -1.16748500000, 28.61903000000, '738'),
(796, 'CD-11', 'Nord-Kivu\r', 'RE', 40, NULL, NULL, '739'),
(797, 'CD-09', 'Orientale\r', 'RE', 40, 1.50539500000, 26.88871900000, '740'),
(798, 'CD-12', 'Sud-Kivu\r', 'RE', 40, NULL, NULL, '741'),
(799, 'CF-01', 'Bamingui-Bangoran\r', 'RE', 41, 8.20245900000, 20.27448900000, '742'),
(800, 'CF-18', 'Bangui\r', 'RE', 41, NULL, NULL, '743'),
(801, 'CF-02', 'Basse-Kotto\r', 'RE', 41, 4.92494400000, 21.35000000000, '744'),
(802, 'CF-05', 'Haut-Mbomou\r', 'RE', 41, 6.07254100000, 26.04166600000, '745'),
(803, 'CF-03', 'Haute-Kotto\r', 'RE', 41, 7.03974000000, 22.51585600000, '746'),
(804, 'CF-06', 'Kemo\r', 'RE', 41, 5.71147100000, 19.47500000000, '747'),
(805, 'CF-07', 'Lobaye\r', 'RE', 41, 4.25130300000, 17.72709500000, '748'),
(806, 'CF-04', 'Mambere-Kadei\r', 'RE', 41, 4.52207500000, 15.90833300000, '749'),
(807, 'CF-08', 'Mbomou\r', 'RE', 41, 5.24721200000, 23.40000000000, '750'),
(808, 'CF-15', 'Nana-Grebizi\r', 'RE', 41, 6.97325700000, 19.42500000000, '751'),
(809, 'CF-09', 'Nana-Mambere\r', 'RE', 41, 5.77355700000, 15.54668000000, '752'),
(810, 'CF-17', 'Ombella-Mpoko\r', 'RE', 41, 4.91666700000, 17.83333300000, '753'),
(811, 'CF-11', 'Ouaka\r', 'RE', 41, 6.14317300000, 20.76937000000, '754'),
(812, 'CF-12', 'Ouham\r', 'RE', 41, 7.06753200000, 17.86118500000, '755'),
(813, 'CF-13', 'Ouham-Pende\r', 'RE', 41, 6.68333300000, 16.10881600000, '756'),
(814, 'CF-16', 'Sangha-Mbaere\r', 'RE', 41, 3.30087500000, 16.30000000000, '757'),
(815, 'CF-14', 'Vakaga\r', 'RE', 41, 9.64351800000, 22.14725500000, '758'),
(816, 'CG-01', 'Bouenza\r', 'RE', 42, -4.15000000000, 13.51666700000, '759'),
(817, 'CG-12', 'Brazzaville\r', 'RE', 42, NULL, NULL, '760'),
(818, 'CG-03', 'Cuvette\r', 'RE', 42, -0.46666700000, 15.68252500000, '761'),
(819, 'CG-04', 'Kouilou\r', 'RE', 42, NULL, NULL, '762'),
(820, 'CG-05', 'Lekoumou\r', 'RE', 42, -3.17170500000, 13.47500000000, '763'),
(821, 'CG-06', 'Likouala\r', 'RE', 42, 1.40141200000, 17.74006000000, '764'),
(822, 'CG-07', 'Niari\r', 'RE', 42, -3.38469800000, 12.56870100000, '765'),
(823, 'CG-08', 'Plateaux\r', 'RE', 42, -1.94166700000, 15.44166700000, '766'),
(824, 'CG-11', 'Pool\r', 'RE', 42, -3.90740200000, 15.08288100000, '767'),
(825, 'CG-10', 'Sangha\r', 'RE', 42, NULL, NULL, '768'),
(826, 'CH-01', 'Aargau\r', 'RE', 43, NULL, NULL, '769'),
(827, 'CH-02', 'Ausser-Rhoden\r', 'RE', 43, NULL, NULL, '770'),
(828, 'CH-03', 'Basel-Landschaft\r', 'RE', 43, NULL, NULL, '771'),
(829, 'CH-04', 'Basel-Stadt\r', 'RE', 43, NULL, NULL, '772'),
(830, 'CH-05', 'Bern\r', 'RE', 43, NULL, NULL, '773'),
(831, 'CH-06', 'Fribourg\r', 'RE', 43, NULL, NULL, '774'),
(832, 'CH-07', 'Geneve\r', 'RE', 43, NULL, NULL, '775'),
(833, 'CH-08', 'Glarus\r', 'RE', 43, NULL, NULL, '776'),
(834, 'CH-09', 'Graubunden\r', 'RE', 43, NULL, NULL, '777'),
(835, 'CH-10', 'Inner-Rhoden\r', 'RE', 43, NULL, NULL, '778'),
(836, 'CH-26', 'Jura\r', 'RE', 43, NULL, NULL, '779'),
(837, 'CH-11', 'Luzern\r', 'RE', 43, NULL, NULL, '780'),
(838, 'CH-12', 'Neuchatel\r', 'RE', 43, NULL, NULL, '781'),
(839, 'CH-13', 'Nidwalden\r', 'RE', 43, NULL, NULL, '782'),
(840, 'CH-14', 'Obwalden\r', 'RE', 43, NULL, NULL, '783'),
(841, 'CH-15', 'Sankt Gallen\r', 'RE', 43, NULL, NULL, '784'),
(842, 'CH-16', 'Schaffhausen\r', 'RE', 43, NULL, NULL, '785'),
(843, 'CH-17', 'Schwyz\r', 'RE', 43, NULL, NULL, '786'),
(844, 'CH-18', 'Solothurn\r', 'RE', 43, NULL, NULL, '787'),
(845, 'CH-19', 'Thurgau\r', 'RE', 43, NULL, NULL, '788'),
(846, 'CH-20', 'Ticino\r', 'RE', 43, NULL, NULL, '789'),
(847, 'CH-21', 'Uri\r', 'RE', 43, NULL, NULL, '790'),
(848, 'CH-22', 'Valais\r', 'RE', 43, NULL, NULL, '791'),
(849, 'CH-23', 'Vaud\r', 'RE', 43, NULL, NULL, '792'),
(850, 'CH-24', 'Zug\r', 'RE', 43, NULL, NULL, '793'),
(851, 'CH-25', 'Zurich\r', 'RE', 43, NULL, NULL, '794'),
(852, 'CI-01', 'Abengourou\r', 'RE', 44, 6.72909000000, -3.49142100000, '795'),
(853, 'CI-61', 'Abidjan\r', 'RE', 44, NULL, NULL, '796'),
(854, 'CI-62', 'Aboisso\r', 'RE', 44, 5.46666700000, -3.20000000000, '797'),
(855, 'CI-63', 'Adiake\r', 'RE', 44, 5.29080000000, -3.32670000000, '798'),
(856, 'CI-05', 'Adzope\r', 'RE', 44, 6.09614300000, -3.86816300000, '799'),
(857, 'CI-06', 'Agboville\r', 'RE', 44, 5.92777300000, -4.22239300000, '800'),
(858, 'CI-64', 'Alepe\r', 'RE', 44, NULL, NULL, '801'),
(859, 'CI-36', 'Bangolo\r', 'RE', 44, 7.03324800000, -7.14425500000, '802'),
(860, 'CI-37', 'Beoumi\r', 'RE', 44, 7.77573300000, -5.39106700000, '803'),
(861, 'CI-07', 'Biankouma\r', 'RE', 44, 7.73440000000, -7.61280000000, '804'),
(862, 'CI-65', 'Bocanda\r', 'RE', 44, 7.04810000000, -4.52840000000, '805'),
(863, 'CI-38', 'Bondoukou\r', 'RE', 44, 7.08333300000, -5.05000000000, '806'),
(864, 'CI-27', 'Bongouanou\r', 'RE', 44, 6.65000000000, -4.20000000000, '807'),
(865, 'CI-39', 'Bouafle\r', 'RE', 44, 6.98166000000, -5.75057500000, '808'),
(866, 'CI-40', 'Bouake\r', 'RE', 44, 9.61666700000, -7.41666700000, '809'),
(867, 'CI-11', 'Bouna\r', 'RE', 44, 9.26994500000, -2.99469300000, '810'),
(868, 'CI-12', 'Boundiali\r', 'RE', 44, 9.52211000000, -6.48862300000, '811'),
(869, 'CI-03', 'Dabakala\r', 'RE', 44, 8.36110000000, -4.42400000000, '812'),
(870, 'CI-66', 'Dabou\r', 'RE', 44, 5.31354100000, -4.38353900000, '813'),
(871, 'CI-41', 'Daloa\r', 'RE', 44, 6.87775000000, -6.44720000000, '814'),
(872, 'CI-14', 'Danane\r', 'RE', 44, 7.26019800000, -8.15084200000, '815'),
(873, 'CI-42', 'Daoukro\r', 'RE', 44, 7.05910000000, -3.96310000000, '816'),
(874, 'CI-67', 'Dimbokro\r', 'RE', 44, 6.64582800000, -4.70660100000, '817'),
(875, 'CI-16', 'Divo\r', 'RE', 44, 5.84332500000, -5.36144000000, '818'),
(876, 'CI-44', 'Duekoue\r', 'RE', 44, 6.74260000000, -7.33720000000, '819'),
(877, 'CI-17', 'Ferkessedougou\r', 'RE', 44, 9.59407700000, -5.20225400000, '820'),
(878, 'CI-18', 'Gagnoa\r', 'RE', 44, 6.13746100000, -5.90811200000, '821'),
(879, 'CI-68', 'Grand-Bassam\r', 'RE', 44, 5.19635400000, -3.74569800000, '822'),
(880, 'CI-45', 'Grand-Lahou\r', 'RE', 44, 5.18285800000, -4.99906800000, '823'),
(881, 'CI-69', 'Guiglo\r', 'RE', 44, 6.55000000000, -7.48333300000, '824'),
(882, 'CI-28', 'Issia\r', 'RE', 44, 6.48010000000, -6.58660000000, '825'),
(883, 'CI-70', 'Jacqueville\r', 'RE', 44, 5.20000000000, -4.41666700000, '826'),
(884, 'CI-20', 'Katiola\r', 'RE', 44, 9.65000000000, -7.61666700000, '827'),
(885, 'CI-21', 'Korhogo\r', 'RE', 44, 9.44910200000, -5.64202400000, '828'),
(886, 'CI-29', 'Lakota\r', 'RE', 44, 5.85000000000, -5.68333300000, '829'),
(887, 'CI-47', 'Man\r', 'RE', 44, 7.40411900000, -7.55092900000, '830'),
(888, 'CI-30', 'Mankono\r', 'RE', 44, 8.45000000000, -6.86666700000, '831'),
(889, 'CI-48', 'Mbahiakro\r', 'RE', 44, 7.45570000000, -4.34690000000, '832'),
(890, 'CI-23', 'Odienne\r', 'RE', 44, 9.50956500000, -7.57429800000, '833'),
(891, 'CI-31', 'Oume\r', 'RE', 44, 6.37790000000, -5.42560000000, '834'),
(892, 'CI-49', 'Sakassou\r', 'RE', 44, 6.54257800000, -4.82700300000, '835'),
(893, 'CI-50', 'San Pedro\r', 'RE', 44, 4.74555500000, -6.66166700000, '836'),
(894, 'CI-51', 'Sassandra\r', 'RE', 44, NULL, NULL, '837'),
(895, 'CI-25', 'Seguela\r', 'RE', 44, 7.96666700000, -6.66666700000, '838'),
(896, 'CI-52', 'Sinfra\r', 'RE', 44, 6.62075100000, -5.91470400000, '839'),
(897, 'CI-32', 'Soubre\r', 'RE', 44, 5.78100000000, -6.60320000000, '840'),
(898, 'CI-53', 'Tabou\r', 'RE', 44, 4.41730000000, -7.35930000000, '841'),
(899, 'CI-54', 'Tanda\r', 'RE', 44, 7.80180000000, -3.16780000000, '842'),
(900, 'CI-55', 'Tiassale\r', 'RE', 44, 5.93270000000, -4.98670000000, '843'),
(901, 'CI-71', 'Tiebissou\r', 'RE', 44, 7.71666700000, -4.66666700000, '844'),
(902, 'CI-33', 'Tingrela\r', 'RE', 44, 10.46960000000, -6.40840000000, '845'),
(903, 'CI-26', 'Touba\r', 'RE', 44, 9.72319400000, -7.39518500000, '846'),
(904, 'CI-72', 'Toulepleu\r', 'RE', 44, 6.57657500000, -8.42009100000, '847'),
(905, 'CI-56', 'Toumodi\r', 'RE', 44, 7.43333300000, -5.61666700000, '848'),
(906, 'CI-57', 'Vavoua\r', 'RE', 44, 7.37130000000, -6.48370000000, '849'),
(907, 'CI-73', 'Yamoussoukro\r', 'RE', 44, 6.84025000000, -5.32390000000, '850'),
(908, 'CI-34', 'Zuenoula\r', 'RE', 44, 7.43333300000, -6.05000000000, '851'),
(909, 'CL-02', 'Aisen del General Carlos Ibanez del Campo\r', 'RE', 46, NULL, NULL, '852'),
(910, 'CL-03', 'Antofagasta\r', 'RE', 46, NULL, NULL, '853'),
(911, 'CL-04', 'Araucania\r', 'RE', 46, NULL, NULL, '854'),
(912, 'CL-05', 'Atacama\r', 'RE', 46, NULL, NULL, '855'),
(913, 'CL-06', 'Bio-Bio\r', 'RE', 46, NULL, NULL, '856'),
(914, 'CL-07', 'Coquimbo\r', 'RE', 46, NULL, NULL, '857'),
(915, 'CL-08', 'Libertador General Bernardo O''Higgins\r', 'RE', 46, NULL, NULL, '858'),
(916, 'CL-09', 'Los Lagos\r', 'RE', 46, NULL, NULL, '859'),
(917, 'CL-10', 'Magallanes y de la Antartica Chilena\r', 'RE', 46, NULL, NULL, '860'),
(918, 'CL-11', 'Maule\r', 'RE', 46, NULL, NULL, '861'),
(919, 'CL-12', 'Region Metropolitana\r', 'RE', 46, NULL, NULL, '862'),
(920, 'CL-13', 'Tarapaca\r', 'RE', 46, NULL, NULL, '863'),
(921, 'CL-01', 'Valparaiso\r', 'RE', 46, NULL, NULL, '864'),
(922, 'CM-10', 'Adamaoua\r', 'RE', 47, NULL, NULL, '865'),
(923, 'CM-11', 'Centre\r', 'RE', 47, NULL, NULL, '866'),
(924, 'CM-04', 'Est\r', 'RE', 47, 4.00833400000, 14.11337000000, '867'),
(925, 'CM-12', 'Extreme-Nord\r', 'RE', 47, NULL, NULL, '868'),
(926, 'CM-05', 'Littoral\r', 'RE', 47, NULL, NULL, '869'),
(927, 'CM-13', 'Nord\r', 'RE', 47, 8.66666700000, 13.91575300000, '870'),
(928, 'CM-07', 'Nord-Ouest\r', 'RE', 47, NULL, NULL, '871'),
(929, 'CM-08', 'Ouest\r', 'RE', 47, NULL, NULL, '872'),
(930, 'CM-14', 'Sud\r', 'RE', 47, 2.91666700000, 11.61515500000, '873'),
(931, 'CM-09', 'Sud-Ouest\r', 'RE', 47, NULL, NULL, '874'),
(932, 'CN-01', 'Anhui\r', 'RE', 48, NULL, NULL, '875'),
(933, 'CN-22', 'Beijing\r', 'RE', 48, NULL, NULL, '876'),
(934, 'CN-33', 'Chongqing\r', 'RE', 48, NULL, NULL, '877'),
(935, 'CN-07', 'Fujian\r', 'RE', 48, NULL, NULL, '878'),
(936, 'CN-15', 'Gansu\r', 'RE', 48, NULL, NULL, '879'),
(937, 'CN-30', 'Guangdong\r', 'RE', 48, 22.87894900000, 113.44745200000, '880'),
(938, 'CN-16', 'Guangxi\r', 'RE', 48, NULL, NULL, '881'),
(939, 'CN-18', 'Guizhou\r', 'RE', 48, NULL, NULL, '882'),
(940, 'CN-31', 'Hainan\r', 'RE', 48, NULL, NULL, '883'),
(941, 'CN-10', 'Hebei\r', 'RE', 48, 39.34436900000, 116.66245900000, '884'),
(942, 'CN-08', 'Heilongjiang\r', 'RE', 48, NULL, NULL, '885'),
(943, 'CN-09', 'Henan\r', 'RE', 48, NULL, NULL, '886'),
(944, 'CN-12', 'Hubei\r', 'RE', 48, NULL, NULL, '887'),
(945, 'CN-11', 'Hunan\r', 'RE', 48, NULL, NULL, '888'),
(946, 'CN-04', 'Jiangsu\r', 'RE', 48, NULL, NULL, '889'),
(947, 'CN-03', 'Jiangxi\r', 'RE', 48, NULL, NULL, '890'),
(948, 'CN-05', 'Jilin\r', 'RE', 48, NULL, NULL, '891'),
(949, 'CN-19', 'Liaoning\r', 'RE', 48, NULL, NULL, '892'),
(950, 'CN-20', 'Nei Mongol\r', 'RE', 48, NULL, NULL, '893'),
(951, 'CN-21', 'Ningxia\r', 'RE', 48, NULL, NULL, '894'),
(952, 'CN-06', 'Qinghai\r', 'RE', 48, NULL, NULL, '895'),
(953, 'CN-26', 'Shaanxi\r', 'RE', 48, NULL, NULL, '896'),
(954, 'CN-25', 'Shandong\r', 'RE', 48, NULL, NULL, '897'),
(955, 'CN-23', 'Shanghai\r', 'RE', 48, NULL, NULL, '898'),
(956, 'CN-24', 'Shanxi\r', 'RE', 48, NULL, NULL, '899'),
(957, 'CN-32', 'Sichuan\r', 'RE', 48, NULL, NULL, '900'),
(958, 'CN-28', 'Tianjin\r', 'RE', 48, NULL, NULL, '901'),
(959, 'CN-13', 'Xinjiang\r', 'RE', 48, NULL, NULL, '902'),
(960, 'CN-14', 'Xizang\r', 'RE', 48, NULL, NULL, '903'),
(961, 'CN-29', 'Yunnan\r', 'RE', 48, NULL, NULL, '904'),
(962, 'CN-02', 'Zhejiang\r', 'RE', 48, NULL, NULL, '905'),
(963, 'CO-01', 'Amazonas\r', 'RE', 49, -2.03509200000, -71.87917700000, '906'),
(964, 'CO-02', 'Antioquia\r', 'RE', 49, NULL, NULL, '907'),
(965, 'CO-03', 'Arauca\r', 'RE', 49, 6.54052500000, -70.92947700000, '908'),
(966, 'CO-04', 'Atlantico\r', 'RE', 49, NULL, NULL, '909'),
(967, 'CO-35', 'Bolivar\r', 'RE', 49, 8.89113000000, -74.78502700000, '910'),
(968, 'CO-36', 'Boyaca\r', 'RE', 49, 5.83475000000, -73.32869300000, '911'),
(969, 'CO-37', 'Caldas\r', 'RE', 49, 5.28265000000, -75.30185300000, '912'),
(970, 'CO-08', 'Caqueta\r', 'RE', 49, 1.10700000000, -73.89489700000, '913'),
(971, 'CO-32', 'Casanare\r', 'RE', 49, NULL, NULL, '914'),
(972, 'CO-09', 'Cauca\r', 'RE', 49, NULL, NULL, '915'),
(973, 'CO-10', 'Cesar\r', 'RE', 49, NULL, NULL, '916'),
(974, 'CO-11', 'Choco\r', 'RE', 49, 6.33989200000, -76.95206100000, '917'),
(975, 'CO-12', 'Cordoba\r', 'RE', 49, NULL, NULL, '918'),
(976, 'CO-33', 'Cundinamarca\r', 'RE', 49, NULL, NULL, '919'),
(977, 'CO-34', 'Distrito Especial\r', 'RE', 49, NULL, NULL, '920'),
(978, 'CO-15', 'Guainia\r', 'RE', 49, NULL, NULL, '921'),
(979, 'CO-14', 'Guaviare\r', 'RE', 49, 1.75200000000, -71.82900200000, '922'),
(980, 'CO-16', 'Huila\r', 'RE', 49, NULL, NULL, '923'),
(981, 'CO-17', 'La Guajira\r', 'RE', 49, 11.42225400000, -72.39850600000, '924'),
(982, 'CO-38', 'Magdalena\r', 'RE', 49, 10.15394100000, -74.27949900000, '925'),
(983, 'CO-19', 'Meta\r', 'RE', 49, NULL, NULL, '926'),
(984, 'CO-20', 'Narino\r', 'RE', 49, NULL, NULL, '927'),
(985, 'CO-21', 'Norte de Santander\r', 'RE', 49, NULL, NULL, '928'),
(986, 'CO-22', 'Putumayo\r', 'RE', 49, NULL, NULL, '929'),
(987, 'CO-23', 'Quindio\r', 'RE', 49, NULL, NULL, '930'),
(988, 'CO-24', 'Risaralda\r', 'RE', 49, NULL, NULL, '931'),
(989, 'CO-25', 'San Andres y Providencia\r', 'RE', 49, 12.93866800000, -81.53886000000, '932'),
(990, 'CO-26', 'Santander\r', 'RE', 49, NULL, NULL, '933'),
(991, 'CO-27', 'Sucre\r', 'RE', 49, NULL, NULL, '934'),
(992, 'CO-28', 'Tolima\r', 'RE', 49, NULL, NULL, '935'),
(993, 'CO-29', 'Valle del Cauca\r', 'RE', 49, NULL, NULL, '936'),
(994, 'CO-30', 'Vaupes\r', 'RE', 49, 0.38530000000, -70.57706400000, '937'),
(995, 'CO-31', 'Vichada\r', 'RE', 49, 4.50504400000, -69.25945600000, '938'),
(996, 'CR-01', 'Alajuela\r', 'RE', 50, NULL, NULL, '939'),
(997, 'CR-02', 'Cartago\r', 'RE', 50, NULL, NULL, '940'),
(998, 'CR-03', 'Guanacaste\r', 'RE', 50, NULL, NULL, '941'),
(999, 'CR-04', 'Heredia\r', 'RE', 50, NULL, NULL, '942'),
(1000, 'CR-06', 'Limon\r', 'RE', 50, NULL, NULL, '943'),
(1001, 'CR-07', 'Puntarenas\r', 'RE', 50, NULL, NULL, '944'),
(1002, 'CR-08', 'San Jose\r', 'RE', 50, NULL, NULL, '945'),
(1003, 'CU-05', 'Camaguey\r', 'RE', 51, NULL, NULL, '946'),
(1004, 'CU-07', 'Ciego de Avila\r', 'RE', 51, NULL, NULL, '947'),
(1005, 'CU-08', 'Cienfuegos\r', 'RE', 51, NULL, NULL, '948'),
(1006, 'CU-02', 'Ciudad de la Habana\r', 'RE', 51, NULL, NULL, '949'),
(1007, 'CU-09', 'Granma\r', 'RE', 51, NULL, NULL, '950'),
(1008, 'CU-10', 'Guantanamo\r', 'RE', 51, 20.14303000000, -75.20900700000, '951'),
(1009, 'CU-12', 'Holguin\r', 'RE', 51, 20.80833300000, -75.72327000000, '952'),
(1010, 'CU-04', 'Isla de la Juventud\r', 'RE', 51, 21.66846500000, -82.87691100000, '953'),
(1011, 'CU-11', 'La Habana\r', 'RE', 51, NULL, NULL, '954'),
(1012, 'CU-13', 'Las Tunas\r', 'RE', 51, NULL, NULL, '955'),
(1013, 'CU-03', 'Matanzas\r', 'RE', 51, NULL, NULL, '956'),
(1014, 'CU-01', 'Pinar del Rio\r', 'RE', 51, NULL, NULL, '957'),
(1015, 'CU-14', 'Sancti Spiritus\r', 'RE', 51, 21.95447300000, -79.51888600000, '958'),
(1016, 'CU-15', 'Santiago de Cuba\r', 'RE', 51, NULL, NULL, '959'),
(1017, 'CU-16', 'Villa Clara\r', 'RE', 51, NULL, NULL, '960'),
(1018, 'CV-01', 'Boa Vista\r', 'RE', 52, 16.09608600000, -22.81722600000, '961'),
(1019, 'CV-02', 'Brava\r', 'RE', 52, 14.85014400000, -24.71983200000, '962'),
(1020, 'CV-04', 'Maio\r', 'RE', 52, 15.13626000000, -23.22175000000, '963'),
(1021, 'CV-13', 'Mosteiros\r', 'RE', 52, 15.00000000000, -24.43333300000, '964'),
(1022, 'CV-05', 'Paul\r', 'RE', 52, NULL, NULL, '965'),
(1023, 'CV-14', 'Praia\r', 'RE', 52, 14.92180000000, -23.50869500000, '966'),
(1024, 'CV-07', 'Ribeira Grande\r', 'RE', 52, NULL, NULL, '967'),
(1025, 'CV-08', 'Sal\r', 'RE', 52, 16.71759700000, -22.93231100000, '968'),
(1026, 'CV-15', 'Santa Catarina\r', 'RE', 52, NULL, NULL, '969'),
(1027, 'CV-16', 'Santa Cruz\r', 'RE', 52, 15.13333300000, -23.56666700000, '970'),
(1028, 'CV-17', 'Sao Domingos\r', 'RE', 52, NULL, NULL, '971'),
(1029, 'CV-18', 'Sao Filipe\r', 'RE', 52, 14.95830400000, -23.53225500000, '972'),
(1030, 'CV-19', 'Sao Miguel\r', 'RE', 52, NULL, NULL, '973'),
(1031, 'CV-10', 'Sao Nicolau\r', 'RE', 52, NULL, NULL, '974'),
(1032, 'CV-11', 'Sao Vicente\r', 'RE', 52, NULL, NULL, '975'),
(1033, 'CV-20', 'Tarrafal\r', 'RE', 52, 15.27320000000, -23.76123000000, '976'),
(1034, 'CY-01', 'Famagusta\r', 'RE', 54, NULL, NULL, '977'),
(1035, 'CY-02', 'Kyrenia\r', 'RE', 54, NULL, NULL, '978'),
(1036, 'CY-03', 'Larnaca\r', 'RE', 54, NULL, NULL, '979'),
(1037, 'CY-05', 'Limassol\r', 'RE', 54, NULL, NULL, '980'),
(1038, 'CY-04', 'Nicosia\r', 'RE', 54, NULL, NULL, '981'),
(1039, 'CY-06', 'Paphos\r', 'RE', 54, NULL, NULL, '982'),
(1040, 'CZ-03', 'Blansko\r', 'RE', 55, 49.45069900000, 16.60653800000, '983'),
(1041, 'CZ-04', 'Breclav\r', 'RE', 55, 48.83898500000, 16.75626900000, '984'),
(1042, 'CZ-52', 'Hlavni Mesto Praha\r', 'RE', 55, NULL, NULL, '985'),
(1043, 'CZ-20', 'Hradec Kralove\r', 'RE', 55, NULL, NULL, '986'),
(1044, 'CZ-21', 'Jablonec nad Nisou\r', 'RE', 55, NULL, NULL, '987'),
(1045, 'CZ-23', 'Jiein\r', 'RE', 55, NULL, NULL, '988'),
(1046, 'CZ-24', 'Jihlava\r', 'RE', 55, NULL, NULL, '989'),
(1047, 'CZ-79', 'Jihocesky Kraj\r', 'RE', 55, NULL, NULL, '990'),
(1048, 'CZ-78', 'Jihomoravsky Kraj\r', 'RE', 55, NULL, NULL, '991'),
(1049, 'CZ-81', 'Karlovarsky Kraj\r', 'RE', 55, NULL, NULL, '992'),
(1050, 'CZ-30', 'Kolin\r', 'RE', 55, NULL, NULL, '993'),
(1051, 'CZ-82', 'Kralovehradecky Kraj\r', 'RE', 55, NULL, NULL, '994'),
(1052, 'CZ-33', 'Liberec\r', 'RE', 55, NULL, NULL, '995'),
(1053, 'CZ-83', 'Liberecky Kraj\r', 'RE', 55, NULL, NULL, '996'),
(1054, 'CZ-36', 'Melnik\r', 'RE', 55, NULL, NULL, '997'),
(1055, 'CZ-37', 'Mlada Boleslav\r', 'RE', 55, NULL, NULL, '998'),
(1056, 'CZ-85', 'Moravskoslezsky Kraj\r', 'RE', 55, NULL, NULL, '999'),
(1057, 'CZ-39', 'Nachod\r', 'RE', 55, NULL, NULL, '1000'),
(1058, 'CZ-41', 'Nymburk\r', 'RE', 55, NULL, NULL, '1001'),
(1059, 'CZ-84', 'Olomoucky Kraj\r', 'RE', 55, NULL, NULL, '1002'),
(1060, 'CZ-45', 'Pardubice\r', 'RE', 55, NULL, NULL, '1003'),
(1061, 'CZ-86', 'Pardubicky Kraj\r', 'RE', 55, NULL, NULL, '1004'),
(1062, 'CZ-87', 'Plzensky Kraj\r', 'RE', 55, NULL, NULL, '1005'),
(1063, 'CZ-61', 'Semily\r', 'RE', 55, NULL, NULL, '1006'),
(1064, 'CZ-88', 'Stredocesky Kraj\r', 'RE', 55, NULL, NULL, '1007'),
(1065, 'CZ-70', 'Trutnov\r', 'RE', 55, NULL, NULL, '1008'),
(1066, 'CZ-89', 'Ustecky Kraj\r', 'RE', 55, NULL, NULL, '1009'),
(1067, 'CZ-80', 'Vysocina\r', 'RE', 55, NULL, NULL, '1010'),
(1068, 'CZ-90', 'Zlinsky Kraj\r', 'RE', 55, NULL, NULL, '1011'),
(1069, 'DE-01', 'Baden-Württemberg', 'RE', 56, NULL, NULL, '1012'),
(1070, 'DE-02', 'Bayern\r', 'RE', 56, NULL, NULL, '1013'),
(1071, 'DE-16', 'Berlin\r', 'RE', 56, NULL, NULL, '1014'),
(1072, 'DE-11', 'Brandenburg\r', 'RE', 56, NULL, NULL, '1015'),
(1073, 'DE-03', 'Bremen\r', 'RE', 56, NULL, NULL, '1016'),
(1074, 'DE-04', 'Hamburg\r', 'RE', 56, NULL, NULL, '1017'),
(1075, 'DE-05', 'Hessen\r', 'RE', 56, NULL, NULL, '1018'),
(1076, 'DE-12', 'Mecklenburg-Vorpommern\r', 'RE', 56, NULL, NULL, '1019'),
(1077, 'DE-06', 'Niedersachsen\r', 'RE', 56, NULL, NULL, '1020'),
(1078, 'DE-07', 'Nordrhein-Westfalen\r', 'RE', 56, NULL, NULL, '1021'),
(1079, 'DE-08', 'Rheinland-Pfalz\r', 'RE', 56, NULL, NULL, '1022'),
(1080, 'DE-09', 'Saarland\r', 'RE', 56, NULL, NULL, '1023'),
(1081, 'DE-13', 'Sachsen\r', 'RE', 56, NULL, NULL, '1024'),
(1082, 'DE-14', 'Sachsen-Anhalt\r', 'RE', 56, NULL, NULL, '1025'),
(1083, 'DE-10', 'Schleswig-Holstein\r', 'RE', 56, NULL, NULL, '1026'),
(1084, 'DE-15', 'Thuringen\r', 'RE', 56, NULL, NULL, '1027'),
(1085, 'DJ-02', 'Dikhil\r', 'RE', 57, 11.09962200000, 42.34872100000, '1028'),
(1086, 'DJ-03', 'Djibouti\r', 'RE', 57, 11.58060000000, 43.14250000000, '1029'),
(1087, 'DJ-04', 'Obock\r', 'RE', 57, 11.96420000000, 43.27250000000, '1030'),
(1088, 'DJ-05', 'Tadjoura\r', 'RE', 57, 11.77660000000, 42.82210000000, '1031'),
(1089, 'DK-01', 'Arhus\r', 'RE', 58, NULL, NULL, '1032'),
(1090, 'DK-02', 'Bornholm\r', 'RE', 58, NULL, NULL, '1033'),
(1091, 'DK-03', 'Frederiksborg\r', 'RE', 58, NULL, NULL, '1034'),
(1092, 'DK-04', 'Fyn\r', 'RE', 58, NULL, NULL, '1035'),
(1093, 'DK-05', 'Kobenhavn\r', 'RE', 58, NULL, NULL, '1036'),
(1094, 'DK-07', 'Nordjylland\r', 'RE', 58, NULL, NULL, '1037'),
(1095, 'DK-08', 'Ribe\r', 'RE', 58, NULL, NULL, '1038'),
(1096, 'DK-09', 'Ringkobing\r', 'RE', 58, NULL, NULL, '1039'),
(1097, 'DK-10', 'Roskilde\r', 'RE', 58, NULL, NULL, '1040'),
(1098, 'DK-11', 'Sonderjylland\r', 'RE', 58, NULL, NULL, '1041'),
(1099, 'DK-06', 'Staden Kobenhavn\r', 'RE', 58, NULL, NULL, '1042'),
(1100, 'DK-12', 'Storstrom\r', 'RE', 58, NULL, NULL, '1043'),
(1101, 'DK-13', 'Vejle\r', 'RE', 58, NULL, NULL, '1044'),
(1102, 'DK-14', 'Vestsjalland\r', 'RE', 58, NULL, NULL, '1045'),
(1103, 'DK-15', 'Viborg\r', 'RE', 58, NULL, NULL, '1046'),
(1104, 'DM-02', 'Saint Andrew\r', 'RE', 59, 15.55710000000, -61.31409800000, '1047'),
(1105, 'DM-03', 'Saint David\r', 'RE', 59, 15.43333300000, -61.26666700000, '1048'),
(1106, 'DM-04', 'Saint George\r', 'RE', 59, NULL, NULL, '1049'),
(1107, 'DM-05', 'Saint John\r', 'RE', 59, 15.56953000000, -61.45513200000, '1050'),
(1108, 'DM-06', 'Saint Joseph\r', 'RE', 59, 15.43333300000, -61.45000000000, '1051'),
(1109, 'DM-07', 'Saint Luke\r', 'RE', 59, NULL, NULL, '1052'),
(1110, 'DM-08', 'Saint Mark\r', 'RE', 59, NULL, NULL, '1053'),
(1111, 'DM-09', 'Saint Patrick\r', 'RE', 59, 15.28493500000, -61.28604100000, '1054'),
(1112, 'DM-10', 'Saint Paul\r', 'RE', 59, NULL, NULL, '1055'),
(1113, 'DM-11', 'Saint Peter\r', 'RE', 59, NULL, NULL, '1056'),
(1114, 'DO-01', 'Azua\r', 'RE', 60, 18.62485800000, -70.76349500000, '1057'),
(1115, 'DO-02', 'Baoruco\r', 'RE', 60, 18.49406100000, -71.31186400000, '1058'),
(1116, 'DO-03', 'Barahona\r', 'RE', 60, NULL, NULL, '1059'),
(1117, 'DO-04', 'Dajabon\r', 'RE', 60, 19.44998000000, -71.62804300000, '1060'),
(1118, 'DO-05', 'Distrito Nacional\r', 'RE', 60, NULL, NULL, '1061'),
(1119, 'DO-06', 'Duarte\r', 'RE', 60, 19.26083400000, -70.00056000000, '1062'),
(1120, 'DO-28', 'El Seibo\r', 'RE', 60, NULL, NULL, '1063'),
(1121, 'DO-11', 'Elias Pina\r', 'RE', 60, 18.87628000000, -71.70654300000, '1064'),
(1122, 'DO-08', 'Espaillat\r', 'RE', 60, NULL, NULL, '1065'),
(1123, 'DO-29', 'Hato Mayor\r', 'RE', 60, NULL, NULL, '1066'),
(1124, 'DO-09', 'Independencia\r', 'RE', 60, 18.43203700000, -71.60544600000, '1067'),
(1125, 'DO-10', 'La Altagracia\r', 'RE', 60, 18.53639200000, -68.61709600000, '1068'),
(1126, 'DO-12', 'La Romana\r', 'RE', 60, NULL, NULL, '1069'),
(1127, 'DO-30', 'La Vega\r', 'RE', 60, NULL, NULL, '1070'),
(1128, 'DO-14', 'Maria Trinidad Sanchez\r', 'RE', 60, NULL, NULL, '1071'),
(1129, 'DO-31', 'Monsenor Nouel\r', 'RE', 60, NULL, NULL, '1072'),
(1130, 'DO-15', 'Monte Cristi\r', 'RE', 60, 19.85060900000, -71.64529400000, '1073'),
(1131, 'DO-32', 'Monte Plata\r', 'RE', 60, NULL, NULL, '1074'),
(1132, 'DO-16', 'Pedernales\r', 'RE', 60, 17.90563100000, -71.51482000000, '1075'),
(1133, 'DO-17', 'Peravia\r', 'RE', 60, 18.35054200000, -70.36838500000, '1076'),
(1134, 'DO-18', 'Puerto Plata\r', 'RE', 60, NULL, NULL, '1077'),
(1135, 'DO-19', 'Salcedo\r', 'RE', 60, NULL, NULL, '1078'),
(1136, 'DO-20', 'Samana\r', 'RE', 60, NULL, NULL, '1079'),
(1137, 'DO-33', 'San Cristobal\r', 'RE', 60, NULL, NULL, '1080'),
(1138, 'DO-23', 'San Juan\r', 'RE', 60, NULL, NULL, '1081'),
(1139, 'DO-24', 'San Pedro De Macoris\r', 'RE', 60, NULL, NULL, '1082'),
(1140, 'DO-21', 'Sanchez Ramirez\r', 'RE', 60, NULL, NULL, '1083'),
(1141, 'DO-25', 'Santiago\r', 'RE', 60, NULL, NULL, '1084'),
(1142, 'DO-26', 'Santiago Rodriguez\r', 'RE', 60, 19.39662500000, -71.31632800000, '1085'),
(1143, 'DO-27', 'Valverde\r', 'RE', 60, NULL, NULL, '1086'),
(1144, 'DZ-34', 'Adrar\r', 'RE', 61, NULL, NULL, '1087'),
(1145, 'DZ-35', 'Ain Defla\r', 'RE', 61, 36.06732200000, 4.55530300000, '1088'),
(1146, 'DZ-36', 'Ain Temouchent\r', 'RE', 61, 35.28910000000, -1.14250000000, '1089'),
(1147, 'DZ-01', 'Alger\r', 'RE', 61, NULL, NULL, '1090'),
(1148, 'DZ-37', 'Annaba\r', 'RE', 61, 36.89875000000, 7.75635000000, '1091'),
(1149, 'DZ-03', 'Batna\r', 'RE', 61, NULL, NULL, '1092'),
(1150, 'DZ-38', 'Bechar\r', 'RE', 61, 31.60875000000, -2.21680000000, '1093'),
(1151, 'DZ-18', 'Bejaia\r', 'RE', 61, NULL, NULL, '1094'),
(1152, 'DZ-19', 'Biskra\r', 'RE', 61, NULL, NULL, '1095'),
(1153, 'DZ-20', 'Blida\r', 'RE', 61, NULL, NULL, '1096'),
(1154, 'DZ-39', 'Bordj Bou Arreridj\r', 'RE', 61, 36.05912000000, 4.63031800000, '1097'),
(1155, 'DZ-21', 'Bouira\r', 'RE', 61, NULL, NULL, '1098'),
(1156, 'DZ-40', 'Boumerdes\r', 'RE', 61, 36.72648400000, 3.70985600000, '1099'),
(1157, 'DZ-41', 'Chlef\r', 'RE', 61, NULL, NULL, '1100'),
(1158, 'DZ-04', 'Constantine\r', 'RE', 61, NULL, NULL, '1101'),
(1159, 'DZ-22', 'Djelfa\r', 'RE', 61, NULL, NULL, '1102'),
(1160, 'DZ-42', 'El Bayadh\r', 'RE', 61, 32.57227500000, 0.95001100000, '1103'),
(1161, 'DZ-43', 'El Oued\r', 'RE', 61, 33.36830900000, 6.86736900000, '1104'),
(1162, 'DZ-44', 'El Tarf\r', 'RE', 61, 36.66273500000, 8.20349800000, '1105'),
(1163, 'DZ-45', 'Ghardaia\r', 'RE', 61, 32.49330000000, 3.67541900000, '1106'),
(1164, 'DZ-23', 'Guelma\r', 'RE', 61, 36.46580000000, 7.43390000000, '1107'),
(1165, 'DZ-46', 'Illizi\r', 'RE', 61, 26.56481000000, 8.92268900000, '1108'),
(1166, 'DZ-24', 'Jijel\r', 'RE', 61, NULL, NULL, '1109'),
(1167, 'DZ-47', 'Khenchela\r', 'RE', 61, 35.43525000000, 7.14030000000, '1110'),
(1168, 'DZ-25', 'Laghouat\r', 'RE', 61, NULL, NULL, '1111'),
(1169, 'DZ-27', 'M''sila\r', 'RE', 61, 35.70200000000, 4.54710000000, '1112'),
(1170, 'DZ-26', 'Mascara\r', 'RE', 61, NULL, NULL, '1113'),
(1171, 'DZ-06', 'Medea\r', 'RE', 61, 36.26287400000, 2.76029600000, '1114'),
(1172, 'DZ-48', 'Mila\r', 'RE', 61, 36.21772900000, 6.20007500000, '1115'),
(1173, 'DZ-07', 'Mostaganem\r', 'RE', 61, NULL, NULL, '1116'),
(1174, 'DZ-49', 'Naama\r', 'RE', 61, 33.19956100000, -0.80000400000, '1117'),
(1175, 'DZ-09', 'Oran\r', 'RE', 61, NULL, NULL, '1118'),
(1176, 'DZ-50', 'Ouargla\r', 'RE', 61, NULL, NULL, '1119'),
(1177, 'DZ-29', 'Oum el Bouaghi\r', 'RE', 61, 35.79000100000, 7.05584900000, '1120'),
(1178, 'DZ-51', 'Relizane\r', 'RE', 61, NULL, NULL, '1121'),
(1179, 'DZ-10', 'Saida\r', 'RE', 61, 34.83057600000, 0.15180000000, '1122'),
(1180, 'DZ-12', 'Setif\r', 'RE', 61, 36.18795000000, 5.40910000000, '1123'),
(1181, 'DZ-30', 'Sidi Bel Abbes\r', 'RE', 61, 35.19992600000, -0.63524200000, '1124'),
(1182, 'DZ-31', 'Skikda\r', 'RE', 61, NULL, NULL, '1125'),
(1183, 'DZ-52', 'Souk Ahras\r', 'RE', 61, 36.28376000000, 7.95537900000, '1126'),
(1184, 'DZ-53', 'Tamanghasset\r', 'RE', 61, NULL, NULL, '1127'),
(1185, 'DZ-33', 'Tebessa\r', 'RE', 61, 35.41021900000, 8.12150000000, '1128'),
(1186, 'DZ-13', 'Tiaret\r', 'RE', 61, NULL, NULL, '1129'),
(1187, 'DZ-54', 'Tindouf\r', 'RE', 61, NULL, NULL, '1130'),
(1188, 'DZ-55', 'Tipaza\r', 'RE', 61, NULL, NULL, '1131'),
(1189, 'DZ-56', 'Tissemsilt\r', 'RE', 61, 35.75276000000, 1.86724000000, '1132'),
(1190, 'DZ-14', 'Tizi Ouzou\r', 'RE', 61, NULL, NULL, '1133'),
(1191, 'DZ-15', 'Tlemcen\r', 'RE', 61, NULL, NULL, '1134'),
(1192, 'EC-02', 'Azuay\r', 'RE', 62, NULL, NULL, '1135'),
(1193, 'EC-03', 'Bolivar\r', 'RE', 62, NULL, NULL, '1136'),
(1194, 'EC-04', 'Canar\r', 'RE', 62, NULL, NULL, '1137'),
(1195, 'EC-05', 'Carchi\r', 'RE', 62, NULL, NULL, '1138'),
(1196, 'EC-06', 'Chimborazo\r', 'RE', 62, NULL, NULL, '1139'),
(1197, 'EC-07', 'Cotopaxi\r', 'RE', 62, NULL, NULL, '1140'),
(1198, 'EC-08', 'El Oro\r', 'RE', 62, NULL, NULL, '1141'),
(1199, 'EC-09', 'Esmeraldas\r', 'RE', 62, NULL, NULL, '1142'),
(1200, 'EC-01', 'Galapagos\r', 'RE', 62, NULL, NULL, '1143'),
(1201, 'EC-10', 'Guayas\r', 'RE', 62, NULL, NULL, '1144'),
(1202, 'EC-11', 'Imbabura\r', 'RE', 62, NULL, NULL, '1145'),
(1203, 'EC-12', 'Loja\r', 'RE', 62, NULL, NULL, '1146'),
(1204, 'EC-13', 'Los Rios\r', 'RE', 62, NULL, NULL, '1147'),
(1205, 'EC-14', 'Manabi\r', 'RE', 62, NULL, NULL, '1148'),
(1206, 'EC-15', 'Morona-Santiago\r', 'RE', 62, -2.51886400000, -77.85412200000, '1149'),
(1207, 'EC-23', 'Napo\r', 'RE', 62, -0.75400900000, -76.79733600000, '1150'),
(1208, 'EC-24', 'Orellana\r', 'RE', 62, -0.79478700000, -76.42654700000, '1151'),
(1209, 'EC-17', 'Pastaza\r', 'RE', 62, NULL, NULL, '1152'),
(1210, 'EC-18', 'Pichincha\r', 'RE', 62, NULL, NULL, '1153'),
(1211, 'EC-22', 'Sucumbios\r', 'RE', 62, 0.00139000000, -76.60435500000, '1154'),
(1212, 'EC-19', 'Tungurahua\r', 'RE', 62, NULL, NULL, '1155'),
(1213, 'EC-20', 'Zamora-Chinchipe\r', 'RE', 62, -4.16730600000, -78.88745800000, '1156'),
(1214, 'EE-01', 'Harjumaa\r', 'RE', 63, NULL, NULL, '1157'),
(1215, 'EE-02', 'Hiiumaa\r', 'RE', 63, NULL, NULL, '1158'),
(1216, 'EE-03', 'Ida-Virumaa\r', 'RE', 63, NULL, NULL, '1159'),
(1217, 'EE-04', 'Jarvamaa\r', 'RE', 63, NULL, NULL, '1160'),
(1218, 'EE-05', 'Jogevamaa\r', 'RE', 63, NULL, NULL, '1161'),
(1219, 'EE-06', 'Kohtla-Jarve\r', 'RE', 63, 59.39871100000, 27.25049800000, '1162'),
(1220, 'EE-08', 'Laane-Virumaa\r', 'RE', 63, NULL, NULL, '1163'),
(1221, 'EE-07', 'Laanemaa\r', 'RE', 63, NULL, NULL, '1164'),
(1222, 'EE-09', 'Narva\r', 'RE', 63, 59.37425100000, 28.18229400000, '1165'),
(1223, 'EE-10', 'Parnu\r', 'RE', 63, 58.38601500000, 24.49863700000, '1166'),
(1224, 'EE-11', 'Parnumaa\r', 'RE', 63, NULL, NULL, '1167'),
(1225, 'EE-12', 'Polvamaa\r', 'RE', 63, NULL, NULL, '1168'),
(1226, 'EE-13', 'Raplamaa\r', 'RE', 63, NULL, NULL, '1169'),
(1227, 'EE-14', 'Saaremaa\r', 'RE', 63, NULL, NULL, '1170'),
(1228, 'EE-15', 'Sillamae\r', 'RE', 63, 59.40075800000, 27.74548600000, '1171'),
(1229, 'EE-16', 'Tallinn\r', 'RE', 63, 59.43923200000, 24.75861900000, '1172'),
(1230, 'EE-17', 'Tartu\r', 'RE', 63, 58.37084600000, 26.71476100000, '1173'),
(1231, 'EE-18', 'Tartumaa\r', 'RE', 63, NULL, NULL, '1174'),
(1232, 'EE-19', 'Valgamaa\r', 'RE', 63, NULL, NULL, '1175'),
(1233, 'EE-20', 'Viljandimaa\r', 'RE', 63, NULL, NULL, '1176'),
(1234, 'EE-21', 'Vorumaa\r', 'RE', 63, NULL, NULL, '1177'),
(1235, 'EG-01', 'Ad Daqahliyah\r', 'RE', 64, NULL, NULL, '1178'),
(1236, 'EG-02', 'Al Bahr al Ahmar\r', 'RE', 64, NULL, NULL, '1179'),
(1237, 'EG-03', 'Al Buhayrah\r', 'RE', 64, NULL, NULL, '1180'),
(1238, 'EG-04', 'Al Fayyum\r', 'RE', 64, NULL, NULL, '1181'),
(1239, 'EG-05', 'Al Gharbiyah\r', 'RE', 64, NULL, NULL, '1182'),
(1240, 'EG-06', 'Al Iskandariyah\r', 'RE', 64, NULL, NULL, '1183'),
(1241, 'EG-07', 'Al Isma''iliyah\r', 'RE', 64, NULL, NULL, '1184'),
(1242, 'EG-08', 'Al Jizah\r', 'RE', 64, NULL, NULL, '1185'),
(1243, 'EG-09', 'Al Minufiyah\r', 'RE', 64, NULL, NULL, '1186'),
(1244, 'EG-10', 'Al Minya\r', 'RE', 64, NULL, NULL, '1187'),
(1245, 'EG-11', 'Al Qahirah\r', 'RE', 64, NULL, NULL, '1188'),
(1246, 'EG-12', 'Al Qalyubiyah\r', 'RE', 64, NULL, NULL, '1189'),
(1247, 'EG-13', 'Al Wadi al Jadid\r', 'RE', 64, 25.78284500000, 30.40171200000, '1190'),
(1248, 'EG-15', 'As Suways\r', 'RE', 64, NULL, NULL, '1191'),
(1249, 'EG-14', 'Ash Sharqiyah\r', 'RE', 64, NULL, NULL, '1192'),
(1250, 'EG-16', 'Aswan\r', 'RE', 64, NULL, NULL, '1193'),
(1251, 'EG-17', 'Asyut\r', 'RE', 64, NULL, NULL, '1194'),
(1252, 'EG-18', 'Bani Suwayf\r', 'RE', 64, 29.04820500000, 30.62891900000, '1195'),
(1253, 'EG-19', 'Bur Sa''id\r', 'RE', 64, NULL, NULL, '1196'),
(1254, 'EG-20', 'Dumyat\r', 'RE', 64, NULL, NULL, '1197'),
(1255, 'EG-26', 'Janub Sina''\r', 'RE', 64, 28.72720400000, 33.68816200000, '1198'),
(1256, 'EG-21', 'Kafr ash Shaykh\r', 'RE', 64, NULL, NULL, '1199'),
(1257, 'EG-22', 'Matruh\r', 'RE', 64, NULL, NULL, '1200'),
(1258, 'EG-23', 'Qina\r', 'RE', 64, NULL, NULL, '1201'),
(1259, 'EG-27', 'Shamal Sina''\r', 'RE', 64, 30.38770000000, 33.81554700000, '1202'),
(1260, 'EG-24', 'Suhaj\r', 'RE', 64, NULL, NULL, '1203'),
(1261, 'ES-51', 'Andalucia\r', 'RE', 67, NULL, NULL, '1204'),
(1262, 'ES-52', 'Aragon\r', 'RE', 67, NULL, NULL, '1205'),
(1263, 'ES-34', 'Asturias\r', 'RE', 67, NULL, NULL, '1206'),
(1264, 'ES-53', 'Canarias\r', 'RE', 67, NULL, NULL, '1207'),
(1265, 'ES-39', 'Cantabria\r', 'RE', 67, NULL, NULL, '1208'),
(1266, 'ES-55', 'Castilla y Leon\r', 'RE', 67, NULL, NULL, '1209'),
(1267, 'ES-54', 'Castilla-La Mancha\r', 'RE', 67, NULL, NULL, '1210'),
(1268, 'ES-56', 'Catalonia\r', 'RE', 67, NULL, NULL, '1211'),
(1269, 'ES-60', 'Comunidad Valenciana\r', 'RE', 67, NULL, NULL, '1212'),
(1270, 'ES-57', 'Extremadura\r', 'RE', 67, NULL, NULL, '1213'),
(1271, 'ES-58', 'Galicia\r', 'RE', 67, NULL, NULL, '1214'),
(1272, 'ES-07', 'Islas Baleares\r', 'RE', 67, NULL, NULL, '1215'),
(1273, 'ES-27', 'La Rioja\r', 'RE', 67, NULL, NULL, '1216'),
(1274, 'ES-29', 'Madrid\r', 'RE', 67, NULL, NULL, '1217'),
(1275, 'ES-31', 'Murcia\r', 'RE', 67, NULL, NULL, '1218'),
(1276, 'ES-32', 'Navarra\r', 'RE', 67, NULL, NULL, '1219'),
(1277, 'ES-59', 'Pais Vasco\r', 'RE', 67, NULL, NULL, '1220'),
(1278, 'ET-10', 'Addis Abeba\r', 'RE', 68, NULL, NULL, '1221'),
(1279, 'ET-44', 'Adis Abeba\r', 'RE', 68, 9.02273600000, 38.74679900000, '1222'),
(1280, 'ET-14', 'Afar\r', 'RE', 68, NULL, NULL, '1223'),
(1281, 'ET-46', 'Amara\r', 'RE', 68, 8.80000000000, 34.73333300000, '1224'),
(1282, 'ET-02', 'Amhara\r', 'RE', 68, NULL, NULL, '1225'),
(1283, 'ET-13', 'Benishangul\r', 'RE', 68, NULL, NULL, '1226'),
(1284, 'ET-47', 'Binshangul Gumuz\r', 'RE', 68, NULL, NULL, '1227'),
(1285, 'ET-48', 'Dire Dawa\r', 'RE', 68, 9.58922900000, 41.87019000000, '1228'),
(1286, 'ET-49', 'Gambela Hizboch\r', 'RE', 68, NULL, NULL, '1229'),
(1287, 'ET-08', 'Gambella\r', 'RE', 68, 8.12833300000, 34.56277800000, '1230'),
(1288, 'ET-50', 'Hareri Hizb\r', 'RE', 68, NULL, NULL, '1231'),
(1289, 'ET-51', 'Oromiya\r', 'RE', 68, NULL, NULL, '1232'),
(1290, 'ET-07', 'Somali\r', 'RE', 68, NULL, NULL, '1233'),
(1291, 'ET-11', 'Southern\r', 'RE', 68, NULL, NULL, '1234'),
(1292, 'ET-52', 'Sumale\r', 'RE', 68, NULL, NULL, '1235'),
(1293, 'ET-12', 'Tigray\r', 'RE', 68, 13.66666700000, 39.68333300000, '1236'),
(1294, 'ET-54', 'YeDebub Biheroch Bihereseboch na Hizboch\r', 'RE', 68, NULL, NULL, '1237'),
(1296, 'FI-14', 'Eastern Finland\r', 'RE', 69, NULL, NULL, '1239'),
(1297, 'FI-06', 'Lapland\r', 'RE', 69, NULL, NULL, '1240'),
(1298, 'FI-08', 'Oulu\r', 'RE', 69, NULL, NULL, '1241'),
(1299, 'FI-13', 'Southern Finland\r', 'RE', 69, NULL, NULL, '1242'),
(1300, 'FI-15', 'Western Finland\r', 'RE', 69, NULL, NULL, '1243'),
(1301, 'FJ-01', 'Central\r', 'RE', 70, NULL, NULL, '1244'),
(1302, 'FJ-02', 'Eastern\r', 'RE', 70, NULL, NULL, '1245'),
(1303, 'FJ-03', 'Northern\r', 'RE', 70, NULL, NULL, '1246'),
(1304, 'FJ-04', 'Rotuma\r', 'RE', 70, -12.50000000000, 177.08333300000, '1247'),
(1305, 'FJ-05', 'Western\r', 'RE', 70, NULL, NULL, '1248'),
(1306, 'FM-03', 'Chuuk\r', 'RE', 72, NULL, NULL, '1249'),
(1307, 'FM-01', 'Kosrae\r', 'RE', 72, NULL, NULL, '1250'),
(1308, 'FM-02', 'Pohnpei\r', 'RE', 72, NULL, NULL, '1251'),
(1309, 'FM-04', 'Yap\r', 'RE', 72, NULL, NULL, '1252'),
(1310, 'FR-C1', 'Alsace\r', 'RE', 74, NULL, NULL, '1253'),
(1311, 'FR-97', 'Aquitaine\r', 'RE', 74, NULL, NULL, '1254'),
(1312, 'FR-98', 'Auvergne\r', 'RE', 74, NULL, NULL, '1255'),
(1313, 'FR-99', 'Basse-Normandie\r', 'RE', 74, NULL, NULL, '1256'),
(1314, 'FR-A1', 'Bourgogne\r', 'RE', 74, NULL, NULL, '1257'),
(1315, 'FR-A2', 'Bretagne\r', 'RE', 74, NULL, NULL, '1258'),
(1316, 'FR-A3', 'Centre\r', 'RE', 74, NULL, NULL, '1259'),
(1317, 'FR-A4', 'Champagne-Ardenne\r', 'RE', 74, NULL, NULL, '1260'),
(1318, 'FR-A5', 'Corse\r', 'RE', 74, NULL, NULL, '1261'),
(1319, 'FR-A6', 'Franche-Comte\r', 'RE', 74, NULL, NULL, '1262'),
(1320, 'FR-A7', 'Haute-Normandie\r', 'RE', 74, NULL, NULL, '1263'),
(1321, 'FR-A8', 'Ile-de-France\r', 'RE', 74, NULL, NULL, '1264'),
(1322, 'FR-A9', 'Languedoc-Roussillon\r', 'RE', 74, NULL, NULL, '1265'),
(1323, 'FR-B1', 'Limousin\r', 'RE', 74, NULL, NULL, '1266'),
(1324, 'FR-B2', 'Lorraine\r', 'RE', 74, NULL, NULL, '1267'),
(1325, 'FR-B3', 'Midi-Pyrenees\r', 'RE', 74, NULL, NULL, '1268'),
(1326, 'FR-B4', 'Nord-Pas-de-Calais\r', 'RE', 74, NULL, NULL, '1269'),
(1327, 'FR-B5', 'Pays de la Loire\r', 'RE', 74, NULL, NULL, '1270'),
(1328, 'FR-B6', 'Picardie\r', 'RE', 74, NULL, NULL, '1271'),
(1329, 'FR-B7', 'Poitou-Charentes\r', 'RE', 74, NULL, NULL, '1272'),
(1330, 'FR-B8', 'Provence-Alpes-Cote d''Azur\r', 'RE', 74, NULL, NULL, '1273'),
(1331, 'FR-B9', 'Rhone-Alpes\r', 'RE', 74, NULL, NULL, '1274'),
(1332, 'GA-01', 'Estuaire\r', 'RE', 75, NULL, NULL, '1275'),
(1333, 'GA-02', 'Haut-Ogooue\r', 'RE', 75, -1.15833300000, 13.62500000000, '1276'),
(1334, 'GA-03', 'Moyen-Ogooue\r', 'RE', 75, -0.46034500000, 10.51814800000, '1277'),
(1335, 'GA-04', 'Ngounie\r', 'RE', 75, -1.80105600000, 11.24608500000, '1278'),
(1336, 'GA-05', 'Nyanga\r', 'RE', 75, -3.08333400000, 10.88955900000, '1279'),
(1337, 'GA-06', 'Ogooue-Ivindo\r', 'RE', 75, 0.34195300000, 12.85768500000, '1280'),
(1338, 'GA-07', 'Ogooue-Lolo\r', 'RE', 75, -0.93731900000, 12.60437000000, '1281'),
(1339, 'GA-08', 'Ogooue-Maritime\r', 'RE', 75, NULL, NULL, '1282'),
(1340, 'GA-09', 'Woleu-Ntem\r', 'RE', 75, 1.25893100000, 11.82500000000, '1283'),
(1341, 'GB-T5', 'Aberdeen City\r', 'RE', 76, NULL, NULL, '1284'),
(1342, 'GB-T6', 'Aberdeenshire\r', 'RE', 76, NULL, NULL, '1285'),
(1343, 'GB-T7', 'Angus\r', 'RE', 76, NULL, NULL, '1286'),
(1344, 'GB-Q6', 'Antrim\r', 'RE', 76, NULL, NULL, '1287'),
(1345, 'GB-Q7', 'Ards\r', 'RE', 76, NULL, NULL, '1288'),
(1346, 'GB-T8', 'Argyll and Bute\r', 'RE', 76, NULL, NULL, '1289'),
(1347, 'GB-Q8', 'Armagh\r', 'RE', 76, NULL, NULL, '1290'),
(1348, 'GB-01', 'Avon\r', 'RE', 76, 51.41479200000, -2.60152500000, '1291'),
(1349, 'GB-Q9', 'Ballymena\r', 'RE', 76, NULL, NULL, '1292'),
(1350, 'GB-R1', 'Ballymoney\r', 'RE', 76, NULL, NULL, '1293'),
(1351, 'GB-R2', 'Banbridge\r', 'RE', 76, NULL, NULL, '1294'),
(1352, 'GB-A1', 'Barking and Dagenham\r', 'RE', 76, NULL, NULL, '1295'),
(1353, 'GB-A2', 'Barnet\r', 'RE', 76, NULL, NULL, '1296'),
(1354, 'GB-A3', 'Barnsley\r', 'RE', 76, NULL, NULL, '1297'),
(1355, 'GB-A4', 'Bath and North East Somerset\r', 'RE', 76, NULL, NULL, '1298'),
(1356, 'GB-A5', 'Bedfordshire\r', 'RE', 76, NULL, NULL, '1299'),
(1357, 'GB-R3', 'Belfast\r', 'RE', 76, NULL, NULL, '1300'),
(1358, 'GB-03', 'Berkshire\r', 'RE', 76, NULL, NULL, '1301'),
(1359, 'GB-A6', 'Bexley\r', 'RE', 76, NULL, NULL, '1302'),
(1360, 'GB-A7', 'Birmingham\r', 'RE', 76, NULL, NULL, '1303'),
(1361, 'GB-A8', 'Blackburn with Darwen\r', 'RE', 76, NULL, NULL, '1304'),
(1362, 'GB-A9', 'Blackpool\r', 'RE', 76, NULL, NULL, '1305'),
(1363, 'GB-X2', 'Blaenau Gwent\r', 'RE', 76, NULL, NULL, '1306'),
(1364, 'GB-B1', 'Bolton\r', 'RE', 76, NULL, NULL, '1307'),
(1365, 'GB-B2', 'Bournemouth\r', 'RE', 76, NULL, NULL, '1308'),
(1366, 'GB-B3', 'Bracknell Forest\r', 'RE', 76, NULL, NULL, '1309'),
(1367, 'GB-B4', 'Bradford\r', 'RE', 76, NULL, NULL, '1310'),
(1368, 'GB-B5', 'Brent\r', 'RE', 76, NULL, NULL, '1311'),
(1369, 'GB-X3', 'Bridgend\r', 'RE', 76, NULL, NULL, '1312'),
(1370, 'GB-B6', 'Brighton and Hove\r', 'RE', 76, NULL, NULL, '1313'),
(1371, 'GB-B7', 'Bristol, City of\r', 'RE', 76, NULL, NULL, '1314'),
(1372, 'GB-B8', 'Bromley\r', 'RE', 76, NULL, NULL, '1315'),
(1373, 'GB-B9', 'Buckinghamshire\r', 'RE', 76, NULL, NULL, '1316'),
(1374, 'GB-C1', 'Bury\r', 'RE', 76, NULL, NULL, '1317'),
(1375, 'GB-X4', 'Caerphilly\r', 'RE', 76, NULL, NULL, '1318'),
(1376, 'GB-C2', 'Calderdale\r', 'RE', 76, NULL, NULL, '1319'),
(1377, 'GB-C3', 'Cambridgeshire\r', 'RE', 76, NULL, NULL, '1320'),
(1378, 'GB-C4', 'Camden\r', 'RE', 76, NULL, NULL, '1321'),
(1379, 'GB-X5', 'Cardiff\r', 'RE', 76, NULL, NULL, '1322'),
(1380, 'GB-X7', 'Carmarthenshire\r', 'RE', 76, NULL, NULL, '1323'),
(1381, 'GB-R4', 'Carrickfergus\r', 'RE', 76, NULL, NULL, '1324'),
(1382, 'GB-R5', 'Castlereagh\r', 'RE', 76, NULL, NULL, '1325'),
(1383, 'GB-79', 'Central\r', 'RE', 76, 54.96932000000, -1.61565500000, '1326'),
(1384, 'GB-X6', 'Ceredigion\r', 'RE', 76, NULL, NULL, '1327'),
(1385, 'GB-C5', 'Cheshire\r', 'RE', 76, NULL, NULL, '1328'),
(1386, 'GB-U1', 'Clackmannanshire\r', 'RE', 76, NULL, NULL, '1329'),
(1387, 'GB-07', 'Cleveland\r', 'RE', 76, 54.52557900000, -1.18965100000, '1330'),
(1388, 'GB-90', 'Clwyd\r', 'RE', 76, NULL, NULL, '1331'),
(1389, 'GB-R6', 'Coleraine\r', 'RE', 76, NULL, NULL, '1332'),
(1390, 'GB-X8', 'Conwy\r', 'RE', 76, NULL, NULL, '1333'),
(1391, 'GB-R7', 'Cookstown\r', 'RE', 76, NULL, NULL, '1334'),
(1392, 'GB-C6', 'Cornwall\r', 'RE', 76, NULL, NULL, '1335'),
(1393, 'GB-C7', 'Coventry\r', 'RE', 76, NULL, NULL, '1336'),
(1394, 'GB-R8', 'Craigavon\r', 'RE', 76, NULL, NULL, '1337'),
(1395, 'GB-C8', 'Croydon\r', 'RE', 76, NULL, NULL, '1338'),
(1396, 'GB-C9', 'Cumbria\r', 'RE', 76, NULL, NULL, '1339'),
(1397, 'GB-D1', 'Darlington\r', 'RE', 76, NULL, NULL, '1340'),
(1398, 'GB-X9', 'Denbighshire\r', 'RE', 76, NULL, NULL, '1341'),
(1399, 'GB-D2', 'Derby\r', 'RE', 76, NULL, NULL, '1342'),
(1400, 'GB-D3', 'Derbyshire\r', 'RE', 76, NULL, NULL, '1343'),
(1401, 'GB-S6', 'Derry\r', 'RE', 76, NULL, NULL, '1344'),
(1402, 'GB-D4', 'Devon\r', 'RE', 76, NULL, NULL, '1345'),
(1403, 'GB-D5', 'Doncaster\r', 'RE', 76, NULL, NULL, '1346'),
(1404, 'GB-D6', 'Dorset\r', 'RE', 76, NULL, NULL, '1347'),
(1405, 'GB-R9', 'Down\r', 'RE', 76, NULL, NULL, '1348'),
(1406, 'GB-D7', 'Dudley\r', 'RE', 76, NULL, NULL, '1349'),
(1407, 'GB-U2', 'Dumfries and Galloway\r', 'RE', 76, NULL, NULL, '1350'),
(1408, 'GB-U3', 'Dundee City\r', 'RE', 76, NULL, NULL, '1351'),
(1409, 'GB-S1', 'Dungannon\r', 'RE', 76, NULL, NULL, '1352'),
(1410, 'GB-D8', 'Durham\r', 'RE', 76, NULL, NULL, '1353'),
(1411, 'GB-91', 'Dyfed\r', 'RE', 76, 52.12964200000, -4.35774600000, '1354'),
(1412, 'GB-D9', 'Ealing\r', 'RE', 76, NULL, NULL, '1355'),
(1413, 'GB-U4', 'East Ayrshire\r', 'RE', 76, NULL, NULL, '1356'),
(1414, 'GB-U5', 'East Dunbartonshire\r', 'RE', 76, NULL, NULL, '1357'),
(1415, 'GB-U6', 'East Lothian\r', 'RE', 76, NULL, NULL, '1358'),
(1416, 'GB-U7', 'East Renfrewshire\r', 'RE', 76, NULL, NULL, '1359'),
(1417, 'GB-E1', 'East Riding of Yorkshire\r', 'RE', 76, NULL, NULL, '1360'),
(1418, 'GB-E2', 'East Sussex\r', 'RE', 76, NULL, NULL, '1361'),
(1419, 'GB-U8', 'Edinburgh, City of\r', 'RE', 76, NULL, NULL, '1362'),
(1420, 'GB-W8', 'Eilean Siar\r', 'RE', 76, NULL, NULL, '1363'),
(1421, 'GB-E3', 'Enfield\r', 'RE', 76, NULL, NULL, '1364'),
(1422, 'GB-E4', 'Essex\r', 'RE', 76, NULL, NULL, '1365'),
(1423, 'GB-U9', 'Falkirk\r', 'RE', 76, NULL, NULL, '1366'),
(1424, 'GB-S2', 'Fermanagh\r', 'RE', 76, NULL, NULL, '1367'),
(1425, 'GB-V1', 'Fife\r', 'RE', 76, NULL, NULL, '1368'),
(1426, 'GB-Y1', 'Flintshire\r', 'RE', 76, NULL, NULL, '1369'),
(1427, 'GB-E5', 'Gateshead\r', 'RE', 76, NULL, NULL, '1370'),
(1428, 'GB-V2', 'Glasgow City\r', 'RE', 76, NULL, NULL, '1371'),
(1429, 'GB-E6', 'Gloucestershire\r', 'RE', 76, NULL, NULL, '1372'),
(1430, 'GB-82', 'Grampian\r', 'RE', 76, 52.87985000000, -1.49550500000, '1373'),
(1431, 'GB-17', 'Greater London\r', 'RE', 76, NULL, NULL, '1374'),
(1432, 'GB-18', 'Greater Manchester\r', 'RE', 76, 53.44236200000, -2.23348000000, '1375'),
(1433, 'GB-E7', 'Greenwich\r', 'RE', 76, NULL, NULL, '1376'),
(1434, 'GB-92', 'Gwent\r', 'RE', 76, 51.77414700000, -3.00679700000, '1377'),
(1435, 'GB-Y2', 'Gwynedd\r', 'RE', 76, NULL, NULL, '1378'),
(1436, 'GB-E8', 'Hackney\r', 'RE', 76, NULL, NULL, '1379'),
(1437, 'GB-E9', 'Halton\r', 'RE', 76, NULL, NULL, '1380'),
(1438, 'GB-F1', 'Hammersmith and Fulham\r', 'RE', 76, NULL, NULL, '1381'),
(1439, 'GB-F2', 'Hampshire\r', 'RE', 76, NULL, NULL, '1382'),
(1440, 'GB-F3', 'Haringey\r', 'RE', 76, NULL, NULL, '1383'),
(1441, 'GB-F4', 'Harrow\r', 'RE', 76, NULL, NULL, '1384'),
(1442, 'GB-F5', 'Hartlepool\r', 'RE', 76, NULL, NULL, '1385'),
(1443, 'GB-F6', 'Havering\r', 'RE', 76, NULL, NULL, '1386'),
(1444, 'GB-20', 'Hereford and Worcester\r', 'RE', 76, 52.13427700000, -2.45017400000, '1387'),
(1445, 'GB-F7', 'Herefordshire\r', 'RE', 76, NULL, NULL, '1388'),
(1446, 'GB-F8', 'Hertford\r', 'RE', 76, NULL, NULL, '1389'),
(1447, 'GB-V3', 'Highland\r', 'RE', 76, NULL, NULL, '1390'),
(1448, 'GB-F9', 'Hillingdon\r', 'RE', 76, NULL, NULL, '1391'),
(1449, 'GB-G1', 'Hounslow\r', 'RE', 76, NULL, NULL, '1392'),
(1450, 'GB-22', 'Humberside\r', 'RE', 76, 53.58309300000, -0.34901300000, '1393'),
(1451, 'GB-V4', 'Inverclyde\r', 'RE', 76, NULL, NULL, '1394'),
(1452, 'GB-X1', 'Isle of Anglesey\r', 'RE', 76, NULL, NULL, '1395'),
(1453, 'GB-G2', 'Isle of Wight\r', 'RE', 76, NULL, NULL, '1396'),
(1454, 'GB-G3', 'Islington\r', 'RE', 76, NULL, NULL, '1397'),
(1455, 'GB-G4', 'Kensington and Chelsea\r', 'RE', 76, NULL, NULL, '1398'),
(1456, 'GB-G5', 'Kent\r', 'RE', 76, NULL, NULL, '1399'),
(1457, 'GB-G6', 'Kingston upon Hull, City of\r', 'RE', 76, NULL, NULL, '1400'),
(1458, 'GB-G7', 'Kingston upon Thames\r', 'RE', 76, NULL, NULL, '1401'),
(1459, 'GB-G8', 'Kirklees\r', 'RE', 76, NULL, NULL, '1402'),
(1460, 'GB-G9', 'Knowsley\r', 'RE', 76, NULL, NULL, '1403'),
(1461, 'GB-H1', 'Lambeth\r', 'RE', 76, NULL, NULL, '1404'),
(1462, 'GB-H2', 'Lancashire\r', 'RE', 76, NULL, NULL, '1405'),
(1463, 'GB-S3', 'Larne\r', 'RE', 76, NULL, NULL, '1406'),
(1464, 'GB-H3', 'Leeds\r', 'RE', 76, NULL, NULL, '1407'),
(1465, 'GB-H4', 'Leicester\r', 'RE', 76, NULL, NULL, '1408'),
(1466, 'GB-H5', 'Leicestershire\r', 'RE', 76, NULL, NULL, '1409'),
(1467, 'GB-H6', 'Lewisham\r', 'RE', 76, NULL, NULL, '1410'),
(1468, 'GB-S4', 'Limavady\r', 'RE', 76, NULL, NULL, '1411'),
(1469, 'GB-H7', 'Lincolnshire\r', 'RE', 76, NULL, NULL, '1412'),
(1470, 'GB-S5', 'Lisburn\r', 'RE', 76, NULL, NULL, '1413'),
(1471, 'GB-H8', 'Liverpool\r', 'RE', 76, NULL, NULL, '1414'),
(1472, 'GB-H9', 'London, City of\r', 'RE', 76, NULL, NULL, '1415'),
(1473, 'GB-84', 'Lothian\r', 'RE', 76, 55.88668600000, -3.60893900000, '1416'),
(1474, 'GB-I1', 'Luton\r', 'RE', 76, NULL, NULL, '1417'),
(1475, 'GB-S7', 'Magherafelt\r', 'RE', 76, NULL, NULL, '1418'),
(1476, 'GB-I2', 'Manchester\r', 'RE', 76, NULL, NULL, '1419'),
(1477, 'GB-I3', 'Medway\r', 'RE', 76, NULL, NULL, '1420'),
(1478, 'GB-28', 'Merseyside\r', 'RE', 76, NULL, NULL, '1421'),
(1479, 'GB-Y3', 'Merthyr Tydfil\r', 'RE', 76, NULL, NULL, '1422'),
(1480, 'GB-I4', 'Merton\r', 'RE', 76, NULL, NULL, '1423'),
(1481, 'GB-94', 'Mid Glamorgan\r', 'RE', 76, 51.65536000000, -3.40090500000, '1424'),
(1482, 'GB-I5', 'Middlesbrough\r', 'RE', 76, NULL, NULL, '1425'),
(1483, 'GB-V5', 'Midlothian\r', 'RE', 76, NULL, NULL, '1426'),
(1484, 'GB-I6', 'Milton Keynes\r', 'RE', 76, NULL, NULL, '1427'),
(1485, 'GB-Y4', 'Monmouthshire\r', 'RE', 76, NULL, NULL, '1428'),
(1486, 'GB-V6', 'Moray\r', 'RE', 76, NULL, NULL, '1429'),
(1487, 'GB-S8', 'Moyle\r', 'RE', 76, NULL, NULL, '1430'),
(1488, 'GB-Y5', 'Neath Port Talbot\r', 'RE', 76, NULL, NULL, '1431'),
(1489, 'GB-I7', 'Newcastle upon Tyne\r', 'RE', 76, NULL, NULL, '1432'),
(1490, 'GB-I8', 'Newham\r', 'RE', 76, NULL, NULL, '1433'),
(1491, 'GB-Y6', 'Newport\r', 'RE', 76, NULL, NULL, '1434'),
(1492, 'GB-S9', 'Newry and Mourne\r', 'RE', 76, NULL, NULL, '1435'),
(1493, 'GB-T1', 'Newtownabbey\r', 'RE', 76, NULL, NULL, '1436');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(1494, 'GB-I9', 'Norfolk\r', 'RE', 76, NULL, NULL, '1437'),
(1495, 'GB-V7', 'North Ayrshire\r', 'RE', 76, NULL, NULL, '1438'),
(1496, 'GB-T2', 'North Down\r', 'RE', 76, NULL, NULL, '1439'),
(1497, 'GB-J2', 'North East Lincolnshire\r', 'RE', 76, NULL, NULL, '1440'),
(1498, 'GB-V8', 'North Lanarkshire\r', 'RE', 76, NULL, NULL, '1441'),
(1499, 'GB-J3', 'North Lincolnshire\r', 'RE', 76, NULL, NULL, '1442'),
(1500, 'GB-J4', 'North Somerset\r', 'RE', 76, NULL, NULL, '1443'),
(1501, 'GB-J5', 'North Tyneside\r', 'RE', 76, NULL, NULL, '1444'),
(1502, 'GB-J7', 'North Yorkshire\r', 'RE', 76, NULL, NULL, '1445'),
(1503, 'GB-J1', 'Northamptonshire\r', 'RE', 76, NULL, NULL, '1446'),
(1504, 'GB-J6', 'Northumberland\r', 'RE', 76, NULL, NULL, '1447'),
(1505, 'GB-J8', 'Nottingham\r', 'RE', 76, NULL, NULL, '1448'),
(1506, 'GB-J9', 'Nottinghamshire\r', 'RE', 76, NULL, NULL, '1449'),
(1507, 'GB-K1', 'Oldham\r', 'RE', 76, NULL, NULL, '1450'),
(1508, 'GB-T3', 'Omagh\r', 'RE', 76, NULL, NULL, '1451'),
(1509, 'GB-V9', 'Orkney\r', 'RE', 76, NULL, NULL, '1452'),
(1510, 'GB-K2', 'Oxfordshire\r', 'RE', 76, NULL, NULL, '1453'),
(1511, 'GB-Y7', 'Pembrokeshire\r', 'RE', 76, NULL, NULL, '1454'),
(1512, 'GB-W1', 'Perth and Kinross\r', 'RE', 76, NULL, NULL, '1455'),
(1513, 'GB-K3', 'Peterborough\r', 'RE', 76, NULL, NULL, '1456'),
(1514, 'GB-K4', 'Plymouth\r', 'RE', 76, NULL, NULL, '1457'),
(1515, 'GB-K5', 'Poole\r', 'RE', 76, NULL, NULL, '1458'),
(1516, 'GB-K6', 'Portsmouth\r', 'RE', 76, NULL, NULL, '1459'),
(1517, 'GB-Y8', 'Powys\r', 'RE', 76, NULL, NULL, '1460'),
(1518, 'GB-K7', 'Reading\r', 'RE', 76, NULL, NULL, '1461'),
(1519, 'GB-K8', 'Redbridge\r', 'RE', 76, NULL, NULL, '1462'),
(1520, 'GB-K9', 'Redcar and Cleveland\r', 'RE', 76, NULL, NULL, '1463'),
(1521, 'GB-W2', 'Renfrewshire\r', 'RE', 76, NULL, NULL, '1464'),
(1522, 'GB-Y9', 'Rhondda Cynon Taff\r', 'RE', 76, NULL, NULL, '1465'),
(1523, 'GB-L1', 'Richmond upon Thames\r', 'RE', 76, NULL, NULL, '1466'),
(1524, 'GB-L2', 'Rochdale\r', 'RE', 76, NULL, NULL, '1467'),
(1525, 'GB-L3', 'Rotherham\r', 'RE', 76, NULL, NULL, '1468'),
(1526, 'GB-L4', 'Rutland\r', 'RE', 76, NULL, NULL, '1469'),
(1527, 'GB-L5', 'Salford\r', 'RE', 76, NULL, NULL, '1470'),
(1528, 'GB-L7', 'Sandwell\r', 'RE', 76, NULL, NULL, '1471'),
(1529, 'GB-T9', 'Scottish Borders, The\r', 'RE', 76, NULL, NULL, '1472'),
(1530, 'GB-L8', 'Sefton\r', 'RE', 76, NULL, NULL, '1473'),
(1531, 'GB-L9', 'Sheffield\r', 'RE', 76, NULL, NULL, '1474'),
(1532, 'GB-W3', 'Shetland Islands\r', 'RE', 76, NULL, NULL, '1475'),
(1533, 'GB-L6', 'Shropshire\r', 'RE', 76, NULL, NULL, '1476'),
(1534, 'GB-M1', 'Slough\r', 'RE', 76, NULL, NULL, '1477'),
(1535, 'GB-M2', 'Solihull\r', 'RE', 76, NULL, NULL, '1478'),
(1536, 'GB-M3', 'Somerset\r', 'RE', 76, NULL, NULL, '1479'),
(1537, 'GB-W4', 'South Ayrshire\r', 'RE', 76, NULL, NULL, '1480'),
(1538, 'GB-96', 'South Glamorgan\r', 'RE', 76, 51.54850600000, -3.32428000000, '1481'),
(1539, 'GB-M6', 'South Gloucestershire\r', 'RE', 76, NULL, NULL, '1482'),
(1540, 'GB-W5', 'South Lanarkshire\r', 'RE', 76, NULL, NULL, '1483'),
(1541, 'GB-M7', 'South Tyneside\r', 'RE', 76, NULL, NULL, '1484'),
(1542, 'GB-37', 'South Yorkshire\r', 'RE', 76, NULL, NULL, '1485'),
(1543, 'GB-M4', 'Southampton\r', 'RE', 76, NULL, NULL, '1486'),
(1544, 'GB-M5', 'Southend-on-Sea\r', 'RE', 76, NULL, NULL, '1487'),
(1545, 'GB-M8', 'Southwark\r', 'RE', 76, NULL, NULL, '1488'),
(1546, 'GB-N1', 'St. Helens\r', 'RE', 76, NULL, NULL, '1489'),
(1547, 'GB-M9', 'Staffordshire\r', 'RE', 76, NULL, NULL, '1490'),
(1548, 'GB-W6', 'Stirling\r', 'RE', 76, NULL, NULL, '1491'),
(1549, 'GB-N2', 'Stockport\r', 'RE', 76, NULL, NULL, '1492'),
(1550, 'GB-N3', 'Stockton-on-Tees\r', 'RE', 76, NULL, NULL, '1493'),
(1551, 'GB-N4', 'Stoke-on-Trent\r', 'RE', 76, NULL, NULL, '1494'),
(1552, 'GB-T4', 'Strabane\r', 'RE', 76, NULL, NULL, '1495'),
(1553, 'GB-87', 'Strathclyde\r', 'RE', 76, NULL, NULL, '1496'),
(1554, 'GB-N5', 'Suffolk\r', 'RE', 76, NULL, NULL, '1497'),
(1555, 'GB-N6', 'Sunderland\r', 'RE', 76, NULL, NULL, '1498'),
(1556, 'GB-N7', 'Surrey\r', 'RE', 76, NULL, NULL, '1499'),
(1557, 'GB-N8', 'Sutton\r', 'RE', 76, NULL, NULL, '1500'),
(1558, 'GB-Z1', 'Swansea\r', 'RE', 76, NULL, NULL, '1501'),
(1559, 'GB-N9', 'Swindon\r', 'RE', 76, NULL, NULL, '1502'),
(1560, 'GB-O1', 'Tameside\r', 'RE', 76, NULL, NULL, '1503'),
(1561, 'GB-88', 'Tayside\r', 'RE', 76, 55.87392000000, -3.98927800000, '1504'),
(1562, 'GB-O2', 'Telford and Wrekin\r', 'RE', 76, NULL, NULL, '1505'),
(1563, 'GB-O3', 'Thurrock\r', 'RE', 76, NULL, NULL, '1506'),
(1564, 'GB-O4', 'Torbay\r', 'RE', 76, NULL, NULL, '1507'),
(1565, 'GB-Z2', 'Torfaen\r', 'RE', 76, NULL, NULL, '1508'),
(1566, 'GB-O5', 'Tower Hamlets\r', 'RE', 76, NULL, NULL, '1509'),
(1567, 'GB-O6', 'Trafford\r', 'RE', 76, NULL, NULL, '1510'),
(1568, 'GB-41', 'Tyne and Wear\r', 'RE', 76, 55.05392800000, -2.01769700000, '1511'),
(1569, 'GB-Z3', 'Vale of Glamorgan, The\r', 'RE', 76, NULL, NULL, '1512'),
(1570, 'GB-O7', 'Wakefield\r', 'RE', 76, NULL, NULL, '1513'),
(1571, 'GB-O8', 'Walsall\r', 'RE', 76, NULL, NULL, '1514'),
(1572, 'GB-O9', 'Waltham Forest\r', 'RE', 76, NULL, NULL, '1515'),
(1573, 'GB-P1', 'Wandsworth\r', 'RE', 76, NULL, NULL, '1516'),
(1574, 'GB-P2', 'Warrington\r', 'RE', 76, NULL, NULL, '1517'),
(1575, 'GB-P3', 'Warwickshire\r', 'RE', 76, NULL, NULL, '1518'),
(1576, 'GB-P4', 'West Berkshire\r', 'RE', 76, NULL, NULL, '1519'),
(1577, 'GB-W7', 'West Dunbartonshire\r', 'RE', 76, NULL, NULL, '1520'),
(1578, 'GB-97', 'West Glamorgan\r', 'RE', 76, 51.80183100000, -3.81081800000, '1521'),
(1579, 'GB-W9', 'West Lothian\r', 'RE', 76, NULL, NULL, '1522'),
(1580, 'GB-43', 'West Midlands\r', 'RE', 76, NULL, NULL, '1523'),
(1581, 'GB-P6', 'West Sussex\r', 'RE', 76, NULL, NULL, '1524'),
(1582, 'GB-45', 'West Yorkshire\r', 'RE', 76, NULL, NULL, '1525'),
(1583, 'GB-P5', 'Westminster\r', 'RE', 76, NULL, NULL, '1526'),
(1584, 'GB-P7', 'Wigan\r', 'RE', 76, NULL, NULL, '1527'),
(1585, 'GB-P8', 'Wiltshire\r', 'RE', 76, NULL, NULL, '1528'),
(1586, 'GB-P9', 'Windsor and Maidenhead\r', 'RE', 76, NULL, NULL, '1529'),
(1587, 'GB-Q1', 'Wirral\r', 'RE', 76, NULL, NULL, '1530'),
(1588, 'GB-Q2', 'Wokingham\r', 'RE', 76, NULL, NULL, '1531'),
(1589, 'GB-Q3', 'Wolverhampton\r', 'RE', 76, NULL, NULL, '1532'),
(1590, 'GB-Q4', 'Worcestershire\r', 'RE', 76, NULL, NULL, '1533'),
(1591, 'GB-Z4', 'Wrexham\r', 'RE', 76, NULL, NULL, '1534'),
(1592, 'GB-Q5', 'York\r', 'RE', 76, NULL, NULL, '1535'),
(1593, 'GD-01', 'Saint Andrew\r', 'RE', 77, NULL, NULL, '1536'),
(1594, 'GD-02', 'Saint David\r', 'RE', 77, 12.04876000000, -61.66408900000, '1537'),
(1595, 'GD-03', 'Saint George\r', 'RE', 77, NULL, NULL, '1538'),
(1596, 'GD-04', 'Saint John\r', 'RE', 77, NULL, NULL, '1539'),
(1597, 'GD-05', 'Saint Mark\r', 'RE', 77, 12.19327000000, -61.69646100000, '1540'),
(1598, 'GD-06', 'Saint Patrick\r', 'RE', 77, NULL, NULL, '1541'),
(1599, 'GE-01', 'Abashis Raioni\r', 'RE', 78, NULL, NULL, '1542'),
(1600, 'GE-02', 'Abkhazia\r', 'RE', 78, NULL, NULL, '1543'),
(1601, 'GE-03', 'Adigenis Raioni\r', 'RE', 78, NULL, NULL, '1544'),
(1602, 'GE-04', 'Ajaria\r', 'RE', 78, NULL, NULL, '1545'),
(1603, 'GE-05', 'Akhalgoris Raioni\r', 'RE', 78, NULL, NULL, '1546'),
(1604, 'GE-06', 'Akhalk''alak''is Raioni\r', 'RE', 78, NULL, NULL, '1547'),
(1605, 'GE-07', 'Akhalts''ikhis Raioni\r', 'RE', 78, NULL, NULL, '1548'),
(1606, 'GE-08', 'Akhmetis Raioni\r', 'RE', 78, NULL, NULL, '1549'),
(1607, 'GE-09', 'Ambrolauris Raioni\r', 'RE', 78, NULL, NULL, '1550'),
(1608, 'GE-10', 'Aspindzis Raioni\r', 'RE', 78, NULL, NULL, '1551'),
(1609, 'GE-11', 'Baghdat''is Raioni\r', 'RE', 78, NULL, NULL, '1552'),
(1610, 'GE-12', 'Bolnisis Raioni\r', 'RE', 78, NULL, NULL, '1553'),
(1611, 'GE-13', 'Borjomis Raioni\r', 'RE', 78, NULL, NULL, '1554'),
(1612, 'GE-15', 'Ch''khorotsqus Raioni\r', 'RE', 78, NULL, NULL, '1555'),
(1613, 'GE-16', 'Ch''okhatauris Raioni\r', 'RE', 78, NULL, NULL, '1556'),
(1614, 'GE-14', 'Chiat''ura\r', 'RE', 78, NULL, NULL, '1557'),
(1615, 'GE-17', 'Dedop''listsqaros Raioni\r', 'RE', 78, NULL, NULL, '1558'),
(1616, 'GE-18', 'Dmanisis Raioni\r', 'RE', 78, NULL, NULL, '1559'),
(1617, 'GE-19', 'Dushet''is Raioni\r', 'RE', 78, NULL, NULL, '1560'),
(1618, 'GE-20', 'Gardabanis Raioni\r', 'RE', 78, NULL, NULL, '1561'),
(1619, 'GE-21', 'Gori\r', 'RE', 78, 41.98136100000, 44.10953900000, '1562'),
(1620, 'GE-22', 'Goris Raioni\r', 'RE', 78, NULL, NULL, '1563'),
(1621, 'GE-23', 'Gurjaanis Raioni\r', 'RE', 78, NULL, NULL, '1564'),
(1622, 'GE-24', 'Javis Raioni\r', 'RE', 78, NULL, NULL, '1565'),
(1623, 'GE-25', 'K''arelis Raioni\r', 'RE', 78, NULL, NULL, '1566'),
(1624, 'GE-31', 'K''ut''aisi\r', 'RE', 78, NULL, NULL, '1567'),
(1625, 'GE-26', 'Kaspis Raioni\r', 'RE', 78, NULL, NULL, '1568'),
(1626, 'GE-27', 'Kharagaulis Raioni\r', 'RE', 78, NULL, NULL, '1569'),
(1627, 'GE-28', 'Khashuris Raioni\r', 'RE', 78, NULL, NULL, '1570'),
(1628, 'GE-29', 'Khobis Raioni\r', 'RE', 78, NULL, NULL, '1571'),
(1629, 'GE-30', 'Khonis Raioni\r', 'RE', 78, NULL, NULL, '1572'),
(1630, 'GE-32', 'Lagodekhis Raioni\r', 'RE', 78, NULL, NULL, '1573'),
(1631, 'GE-33', 'Lanch''khut''is Raioni\r', 'RE', 78, NULL, NULL, '1574'),
(1632, 'GE-34', 'Lentekhis Raioni\r', 'RE', 78, NULL, NULL, '1575'),
(1633, 'GE-35', 'Marneulis Raioni\r', 'RE', 78, NULL, NULL, '1576'),
(1634, 'GE-36', 'Martvilis Raioni\r', 'RE', 78, NULL, NULL, '1577'),
(1635, 'GE-37', 'Mestiis Raioni\r', 'RE', 78, NULL, NULL, '1578'),
(1636, 'GE-38', 'Mts''khet''is Raioni\r', 'RE', 78, NULL, NULL, '1579'),
(1637, 'GE-39', 'Ninotsmindis Raioni\r', 'RE', 78, NULL, NULL, '1580'),
(1638, 'GE-40', 'Onis Raioni\r', 'RE', 78, NULL, NULL, '1581'),
(1639, 'GE-41', 'Ozurget''is Raioni\r', 'RE', 78, NULL, NULL, '1582'),
(1640, 'GE-42', 'P''ot''i\r', 'RE', 78, NULL, NULL, '1583'),
(1641, 'GE-43', 'Qazbegis Raioni\r', 'RE', 78, NULL, NULL, '1584'),
(1642, 'GE-44', 'Qvarlis Raioni\r', 'RE', 78, NULL, NULL, '1585'),
(1643, 'GE-45', 'Rust''avi\r', 'RE', 78, NULL, NULL, '1586'),
(1644, 'GE-46', 'Sach''kheris Raioni\r', 'RE', 78, NULL, NULL, '1587'),
(1645, 'GE-47', 'Sagarejos Raioni\r', 'RE', 78, NULL, NULL, '1588'),
(1646, 'GE-48', 'Samtrediis Raioni\r', 'RE', 78, NULL, NULL, '1589'),
(1647, 'GE-49', 'Senakis Raioni\r', 'RE', 78, NULL, NULL, '1590'),
(1648, 'GE-50', 'Sighnaghis Raioni\r', 'RE', 78, NULL, NULL, '1591'),
(1649, 'GE-51', 'T''bilisi\r', 'RE', 78, 41.70998100000, 44.79299800000, '1592'),
(1650, 'GE-52', 'T''elavis Raioni\r', 'RE', 78, NULL, NULL, '1593'),
(1651, 'GE-53', 'T''erjolis Raioni\r', 'RE', 78, NULL, NULL, '1594'),
(1652, 'GE-54', 'T''et''ritsqaros Raioni\r', 'RE', 78, NULL, NULL, '1595'),
(1653, 'GE-55', 'T''ianet''is Raioni\r', 'RE', 78, NULL, NULL, '1596'),
(1654, 'GE-56', 'Tqibuli\r', 'RE', 78, NULL, NULL, '1597'),
(1655, 'GE-57', 'Ts''ageris Raioni\r', 'RE', 78, NULL, NULL, '1598'),
(1656, 'GE-58', 'Tsalenjikhis Raioni\r', 'RE', 78, NULL, NULL, '1599'),
(1657, 'GE-59', 'Tsalkis Raioni\r', 'RE', 78, NULL, NULL, '1600'),
(1658, 'GE-60', 'Tsqaltubo\r', 'RE', 78, NULL, NULL, '1601'),
(1659, 'GE-61', 'Vanis Raioni\r', 'RE', 78, NULL, NULL, '1602'),
(1660, 'GE-62', 'Zestap''onis Raioni\r', 'RE', 78, NULL, NULL, '1603'),
(1661, 'GE-63', 'Zugdidi\r', 'RE', 78, 42.50212900000, 41.86095000000, '1604'),
(1662, 'GE-64', 'Zugdidis Raioni\r', 'RE', 78, NULL, NULL, '1605'),
(1663, 'GH-02', 'Ashanti\r', 'RE', 81, NULL, NULL, '1606'),
(1664, 'GH-03', 'Brong-Ahafo\r', 'RE', 81, NULL, NULL, '1607'),
(1665, 'GH-04', 'Central\r', 'RE', 81, NULL, NULL, '1608'),
(1666, 'GH-05', 'Eastern\r', 'RE', 81, 6.44303300000, -0.45833300000, '1609'),
(1667, 'GH-01', 'Greater Accra\r', 'RE', 81, NULL, NULL, '1610'),
(1668, 'GH-06', 'Northern\r', 'RE', 81, NULL, NULL, '1611'),
(1669, 'GH-10', 'Upper East\r', 'RE', 81, 10.73333300000, -0.75336200000, '1612'),
(1670, 'GH-11', 'Upper West\r', 'RE', 81, NULL, NULL, '1613'),
(1671, 'GH-08', 'Volta\r', 'RE', 81, NULL, NULL, '1614'),
(1672, 'GH-09', 'Western\r', 'RE', 81, NULL, NULL, '1615'),
(1673, 'GL-01', 'Nordgronland\r', 'RE', 83, NULL, NULL, '1616'),
(1674, 'GL-02', 'Ostgronland\r', 'RE', 83, NULL, NULL, '1617'),
(1675, 'GL-03', 'Vestgronland\r', 'RE', 83, NULL, NULL, '1618'),
(1676, 'GM-01', 'Banjul\r', 'RE', 84, NULL, NULL, '1619'),
(1677, 'GM-02', 'Lower River\r', 'RE', 84, 13.40000000000, -15.69166600000, '1620'),
(1678, 'GM-03', 'MacCarthy Island\r', 'RE', 84, NULL, NULL, '1621'),
(1679, 'GM-07', 'North Bank\r', 'RE', 84, 13.46358600000, -15.93333300000, '1622'),
(1680, 'GM-04', 'Upper River\r', 'RE', 84, 13.38408700000, -14.16666600000, '1623'),
(1681, 'GM-05', 'Western\r', 'RE', 84, NULL, NULL, '1624'),
(1682, 'GN-01', 'Beyla\r', 'RE', 85, 8.70833300000, -8.32543800000, '1625'),
(1683, 'GN-02', 'Boffa\r', 'RE', 85, 10.29713800000, -14.11744500000, '1626'),
(1684, 'GN-03', 'Boke\r', 'RE', 85, 11.05738500000, -14.40833300000, '1627'),
(1685, 'GN-04', 'Conakry\r', 'RE', 85, NULL, NULL, '1628'),
(1686, 'GN-30', 'Coyah\r', 'RE', 85, 9.99166600000, -13.50913300000, '1629'),
(1687, 'GN-05', 'Dabola\r', 'RE', 85, 10.62050500000, -10.92080000000, '1630'),
(1688, 'GN-06', 'Dalaba\r', 'RE', 85, 11.82565000000, -12.54923400000, '1631'),
(1689, 'GN-07', 'Dinguiraye\r', 'RE', 85, 11.62797400000, -10.69166600000, '1632'),
(1690, 'GN-31', 'Dubreka\r', 'RE', 85, 9.77487000000, -13.48532000000, '1633'),
(1691, 'GN-09', 'Faranah\r', 'RE', 85, 9.85000000000, -10.79884000000, '1634'),
(1692, 'GN-10', 'Forecariah\r', 'RE', 85, 9.39332500000, -13.04166700000, '1635'),
(1693, 'GN-11', 'Fria\r', 'RE', 85, 11.91163300000, -12.66392200000, '1636'),
(1694, 'GN-12', 'Gaoual\r', 'RE', 85, 11.74166600000, -13.35833300000, '1637'),
(1695, 'GN-13', 'Gueckedou\r', 'RE', 85, 8.69157900000, -10.20002500000, '1638'),
(1696, 'GN-32', 'Kankan\r', 'RE', 85, 10.63750000000, -9.78145000000, '1639'),
(1697, 'GN-15', 'Kerouane\r', 'RE', 85, 11.42648900000, -9.59666600000, '1640'),
(1698, 'GN-16', 'Kindia\r', 'RE', 85, 10.35795000000, -13.60195000000, '1641'),
(1699, 'GN-17', 'Kissidougou\r', 'RE', 85, 9.26666700000, -9.85833300000, '1642'),
(1700, 'GN-33', 'Koubia\r', 'RE', 85, 12.17557100000, -12.28612600000, '1643'),
(1701, 'GN-18', 'Koundara\r', 'RE', 85, 12.35833300000, -13.15911100000, '1644'),
(1702, 'GN-19', 'Kouroussa\r', 'RE', 85, 10.53333300000, -10.06809100000, '1645'),
(1703, 'GN-34', 'Labe\r', 'RE', 85, 11.49756100000, -12.82544400000, '1646'),
(1704, 'GN-35', 'Lelouma\r', 'RE', 85, 11.45833400000, -12.74166600000, '1647'),
(1705, 'GN-36', 'Lola\r', 'RE', 85, 7.90833400000, -8.32500000000, '1648'),
(1706, 'GN-21', 'Macenta\r', 'RE', 85, 8.37845700000, -9.38333300000, '1649'),
(1707, 'GN-22', 'Mali\r', 'RE', 85, 12.07159600000, -12.10029600000, '1650'),
(1708, 'GN-23', 'Mamou\r', 'RE', 85, 10.14962200000, -11.95538900000, '1651'),
(1709, 'GN-37', 'Mandiana\r', 'RE', 85, 10.68639300000, -8.65833300000, '1652'),
(1710, 'GN-38', 'Nzerekore\r', 'RE', 85, 8.45470000000, -9.18000000000, '1653'),
(1711, 'GN-25', 'Pita\r', 'RE', 85, 11.39863300000, -10.80420000000, '1654'),
(1712, 'GN-39', 'Siguiri\r', 'RE', 85, 11.66214100000, -9.31443100000, '1655'),
(1713, 'GN-27', 'Telimele\r', 'RE', 85, 10.85380000000, -13.48212500000, '1656'),
(1714, 'GN-28', 'Tougue\r', 'RE', 85, 11.50833400000, -11.60000000000, '1657'),
(1715, 'GN-29', 'Yomou\r', 'RE', 85, 10.67230000000, -12.27363300000, '1658'),
(1716, 'GQ-03', 'Annobon\r', 'RE', 87, NULL, NULL, '1659'),
(1717, 'GQ-04', 'Bioko Norte\r', 'RE', 87, NULL, NULL, '1660'),
(1718, 'GQ-05', 'Bioko Sur\r', 'RE', 87, 3.44171700000, 8.69603800000, '1661'),
(1719, 'GQ-06', 'Centro Sur\r', 'RE', 87, 1.59166700000, 10.47500000000, '1662'),
(1720, 'GQ-07', 'Kie-Ntem\r', 'RE', 87, 1.95833400000, 10.87500000000, '1663'),
(1721, 'GQ-08', 'Litoral\r', 'RE', 87, NULL, NULL, '1664'),
(1722, 'GQ-09', 'Wele-Nzas\r', 'RE', 87, 1.47865600000, 10.95000000000, '1665'),
(1723, 'GR-31', 'Aitolia kai Akarnania\r', 'RE', 88, NULL, NULL, '1666'),
(1724, 'GR-38', 'Akhaia\r', 'RE', 88, NULL, NULL, '1667'),
(1725, 'GR-36', 'Argolis\r', 'RE', 88, NULL, NULL, '1668'),
(1726, 'GR-41', 'Arkadhia\r', 'RE', 88, NULL, NULL, '1669'),
(1727, 'GR-20', 'Arta\r', 'RE', 88, 39.25707800000, 21.13104500000, '1670'),
(1728, 'GR-35', 'Attiki\r', 'RE', 88, NULL, NULL, '1671'),
(1729, 'GR-47', 'Dhodhekanisos\r', 'RE', 88, NULL, NULL, '1672'),
(1730, 'GR-04', 'Drama\r', 'RE', 88, 41.27141700000, 24.15833300000, '1673'),
(1731, 'GR-30', 'Evritania\r', 'RE', 88, NULL, NULL, '1674'),
(1732, 'GR-01', 'Evros\r', 'RE', 88, 41.03061600000, 26.05834000000, '1675'),
(1733, 'GR-34', 'Evvoia\r', 'RE', 88, 38.51207500000, 23.71331900000, '1676'),
(1734, 'GR-08', 'Florina\r', 'RE', 88, 40.74059100000, 21.42466200000, '1677'),
(1735, 'GR-32', 'Fokis\r', 'RE', 88, NULL, NULL, '1678'),
(1736, 'GR-29', 'Fthiotis\r', 'RE', 88, 38.95657500000, 22.95626400000, '1679'),
(1737, 'GR-10', 'Grevena\r', 'RE', 88, 40.05029000000, 21.41260300000, '1680'),
(1738, 'GR-39', 'Ilia\r', 'RE', 88, NULL, NULL, '1681'),
(1739, 'GR-12', 'Imathia\r', 'RE', 88, NULL, NULL, '1682'),
(1740, 'GR-17', 'Ioannina\r', 'RE', 88, 39.65595500000, 20.83422600000, '1683'),
(1741, 'GR-45', 'Iraklion\r', 'RE', 88, NULL, NULL, '1684'),
(1742, 'GR-23', 'Kardhitsa\r', 'RE', 88, NULL, NULL, '1685'),
(1743, 'GR-09', 'Kastoria\r', 'RE', 88, 40.46666700000, 21.13924700000, '1686'),
(1744, 'GR-14', 'Kavala\r', 'RE', 88, 40.89588900000, 24.36059900000, '1687'),
(1745, 'GR-27', 'Kefallinia\r', 'RE', 88, 38.27713100000, 20.58068200000, '1688'),
(1746, 'GR-25', 'Kerkira\r', 'RE', 88, NULL, NULL, '1689'),
(1747, 'GR-15', 'Khalkidhiki\r', 'RE', 88, 40.50811100000, 23.66490700000, '1690'),
(1748, 'GR-43', 'Khania\r', 'RE', 88, NULL, NULL, '1691'),
(1749, 'GR-50', 'Khios\r', 'RE', 88, 38.37340900000, 26.13921900000, '1692'),
(1750, 'GR-49', 'Kikladhes\r', 'RE', 88, NULL, NULL, '1693'),
(1751, 'GR-06', 'Kilkis\r', 'RE', 88, 41.03333300000, 22.76358500000, '1694'),
(1752, 'GR-37', 'Korinthia\r', 'RE', 88, NULL, NULL, '1695'),
(1753, 'GR-11', 'Kozani\r', 'RE', 88, NULL, NULL, '1696'),
(1754, 'GR-42', 'Lakonia\r', 'RE', 88, 36.90253400000, 22.68818900000, '1697'),
(1755, 'GR-21', 'Larisa\r', 'RE', 88, 39.64526900000, 22.35071100000, '1698'),
(1756, 'GR-46', 'Lasithi\r', 'RE', 88, 35.18553500000, 25.88944000000, '1699'),
(1757, 'GR-51', 'Lesvos\r', 'RE', 88, 39.51049700000, 25.81025700000, '1700'),
(1758, 'GR-26', 'Levkas\r', 'RE', 88, 38.91051900000, 21.99813100000, '1701'),
(1759, 'GR-24', 'Magnisia\r', 'RE', 88, 39.29857900000, 23.13448500000, '1702'),
(1760, 'GR-40', 'Messinia\r', 'RE', 88, NULL, NULL, '1703'),
(1761, 'GR-07', 'Pella\r', 'RE', 88, 40.89761000000, 22.18916500000, '1704'),
(1762, 'GR-16', 'Pieria\r', 'RE', 88, NULL, NULL, '1705'),
(1763, 'GR-19', 'Preveza\r', 'RE', 88, 39.15395500000, 20.69682000000, '1706'),
(1764, 'GR-44', 'Rethimni\r', 'RE', 88, NULL, NULL, '1707'),
(1765, 'GR-02', 'Rodhopi\r', 'RE', 88, NULL, NULL, '1708'),
(1766, 'GR-48', 'Samos\r', 'RE', 88, 37.66152900000, 26.50289900000, '1709'),
(1767, 'GR-05', 'Serrai\r', 'RE', 88, 41.09339100000, 23.56204000000, '1710'),
(1768, 'GR-18', 'Thesprotia\r', 'RE', 88, NULL, NULL, '1711'),
(1769, 'GR-13', 'Thessaloniki\r', 'RE', 88, NULL, NULL, '1712'),
(1770, 'GR-22', 'Trikala\r', 'RE', 88, 39.63895000000, 21.70864900000, '1713'),
(1771, 'GR-33', 'Voiotia\r', 'RE', 88, 38.37576500000, 23.07972500000, '1714'),
(1772, 'GR-03', 'Xanthi\r', 'RE', 88, 41.14840000000, 24.85059100000, '1715'),
(1773, 'GR-28', 'Zakinthos\r', 'RE', 88, 37.78287900000, 20.89777900000, '1716'),
(1774, 'GT-01', 'Alta Verapaz\r', 'RE', 90, 15.59693200000, -90.11435900000, '1717'),
(1775, 'GT-02', 'Baja Verapaz\r', 'RE', 90, NULL, NULL, '1718'),
(1776, 'GT-03', 'Chimaltenango\r', 'RE', 90, NULL, NULL, '1719'),
(1777, 'GT-04', 'Chiquimula\r', 'RE', 90, NULL, NULL, '1720'),
(1778, 'GT-05', 'El Progreso\r', 'RE', 90, NULL, NULL, '1721'),
(1779, 'GT-06', 'Escuintla\r', 'RE', 90, 14.19149900000, -91.05903900000, '1722'),
(1780, 'GT-07', 'Guatemala\r', 'RE', 90, NULL, NULL, '1723'),
(1781, 'GT-08', 'Huehuetenango\r', 'RE', 90, NULL, NULL, '1724'),
(1782, 'GT-09', 'Izabal\r', 'RE', 90, NULL, NULL, '1725'),
(1783, 'GT-10', 'Jalapa\r', 'RE', 90, NULL, NULL, '1726'),
(1784, 'GT-11', 'Jutiapa\r', 'RE', 90, 14.14986900000, -89.89818000000, '1727'),
(1785, 'GT-12', 'Peten\r', 'RE', 90, NULL, NULL, '1728'),
(1786, 'GT-13', 'Quetzaltenango\r', 'RE', 90, NULL, NULL, '1729'),
(1787, 'GT-14', 'Quiche\r', 'RE', 90, NULL, NULL, '1730'),
(1788, 'GT-15', 'Retalhuleu\r', 'RE', 90, 14.45346700000, -91.84187600000, '1731'),
(1789, 'GT-16', 'Sacatepequez\r', 'RE', 90, NULL, NULL, '1732'),
(1790, 'GT-17', 'San Marcos\r', 'RE', 90, NULL, NULL, '1733'),
(1791, 'GT-18', 'Santa Rosa\r', 'RE', 90, NULL, NULL, '1734'),
(1792, 'GT-19', 'Solola\r', 'RE', 90, 14.70996800000, -91.28942600000, '1735'),
(1793, 'GT-20', 'Suchitepequez\r', 'RE', 90, 14.37617100000, -91.44000700000, '1736'),
(1794, 'GT-21', 'Totonicapan\r', 'RE', 90, 15.03840900000, -91.36536100000, '1737'),
(1795, 'GT-22', 'Zacapa\r', 'RE', 90, NULL, NULL, '1738'),
(1796, 'GW-01', 'Bafata\r', 'RE', 92, 12.16644500000, -14.68468500000, '1739'),
(1797, 'GW-12', 'Biombo\r', 'RE', 92, 11.88055000000, -15.79065000000, '1740'),
(1798, 'GW-11', 'Bissau\r', 'RE', 92, NULL, NULL, '1741'),
(1799, 'GW-05', 'Bolama\r', 'RE', 92, 11.58886500000, -15.46892500000, '1742'),
(1800, 'GW-06', 'Cacheu\r', 'RE', 92, 12.26849000000, -16.16520500000, '1743'),
(1801, 'GW-10', 'Gabu\r', 'RE', 92, 12.12055000000, -14.09820000000, '1744'),
(1802, 'GW-04', 'Oio\r', 'RE', 92, 12.28655000000, -15.29860000000, '1745'),
(1803, 'GW-02', 'Quinara\r', 'RE', 92, 11.57370000000, -15.38870000000, '1746'),
(1804, 'GW-07', 'Tombali\r', 'RE', 92, 11.30083800000, -15.40993900000, '1747'),
(1805, 'GY-10', 'Barima-Waini\r', 'RE', 93, 7.76928500000, -59.74872600000, '1748'),
(1806, 'GY-11', 'Cuyuni-Mazaruni\r', 'RE', 93, 6.19683300000, -59.97946100000, '1749'),
(1807, 'GY-12', 'Demerara-Mahaica\r', 'RE', 93, NULL, NULL, '1750'),
(1808, 'GY-13', 'East Berbice-Corentyne\r', 'RE', 93, 3.88860300000, -57.49950400000, '1751'),
(1809, 'GY-14', 'Essequibo Islands-West Demerara\r', 'RE', 93, 6.61415900000, -58.50034100000, '1752'),
(1810, 'GY-15', 'Mahaica-Berbice\r', 'RE', 93, 6.27841800000, -57.82864600000, '1753'),
(1811, 'GY-16', 'Pomeroon-Supenaam\r', 'RE', 93, NULL, NULL, '1754'),
(1812, 'GY-17', 'Potaro-Siparuni\r', 'RE', 93, 4.86159600000, -59.21807100000, '1755'),
(1813, 'GY-18', 'Upper Demerara-Berbice\r', 'RE', 93, NULL, NULL, '1756'),
(1814, 'GY-19', 'Upper Takutu-Upper Essequibo\r', 'RE', 93, NULL, NULL, '1757'),
(1815, 'HN-01', 'Atlantida\r', 'RE', 96, NULL, NULL, '1758'),
(1816, 'HN-02', 'Choluteca\r', 'RE', 96, NULL, NULL, '1759'),
(1817, 'HN-03', 'Colon\r', 'RE', 96, 15.54875500000, -85.72819300000, '1760'),
(1818, 'HN-04', 'Comayagua\r', 'RE', 96, 14.55119300000, -87.64852500000, '1761'),
(1819, 'HN-05', 'Copan\r', 'RE', 96, NULL, NULL, '1762'),
(1820, 'HN-06', 'Cortes\r', 'RE', 96, NULL, NULL, '1763'),
(1821, 'HN-07', 'El Paraiso\r', 'RE', 96, 13.96111100000, -86.39726500000, '1764'),
(1822, 'HN-08', 'Francisco Morazan\r', 'RE', 96, NULL, NULL, '1765'),
(1823, 'HN-09', 'Gracias a Dios\r', 'RE', 96, 15.29768500000, -84.07476100000, '1766'),
(1824, 'HN-10', 'Intibuca\r', 'RE', 96, 14.25496100000, -88.17953600000, '1767'),
(1825, 'HN-11', 'Islas de la Bahia\r', 'RE', 96, NULL, NULL, '1768'),
(1826, 'HN-12', 'La Paz\r', 'RE', 96, 14.12759600000, -87.91394500000, '1769'),
(1827, 'HN-13', 'Lempira\r', 'RE', 96, 14.45465900000, -88.64879800000, '1770'),
(1828, 'HN-14', 'Ocotepeque\r', 'RE', 96, 14.47501700000, -89.03560600000, '1771'),
(1829, 'HN-15', 'Olancho\r', 'RE', 96, 14.82005200000, -85.99571100000, '1772'),
(1830, 'HN-16', 'Santa Barbara\r', 'RE', 96, NULL, NULL, '1773'),
(1831, 'HN-17', 'Valle\r', 'RE', 96, 13.54993100000, -87.58001200000, '1774'),
(1832, 'HN-18', 'Yoro\r', 'RE', 96, NULL, NULL, '1775'),
(1833, 'HR-01', 'Bjelovarsko-Bilogorska\r', 'RE', 97, NULL, NULL, '1776'),
(1834, 'HR-02', 'Brodsko-Posavska\r', 'RE', 97, NULL, NULL, '1777'),
(1835, 'HR-03', 'Dubrovacko-Neretvanska\r', 'RE', 97, NULL, NULL, '1778'),
(1836, 'HR-21', 'Grad Zagreb\r', 'RE', 97, NULL, NULL, '1779'),
(1837, 'HR-04', 'Istarska\r', 'RE', 97, NULL, NULL, '1780'),
(1838, 'HR-05', 'Karlovacka\r', 'RE', 97, NULL, NULL, '1781'),
(1839, 'HR-06', 'Koprivnicko-Krizevacka\r', 'RE', 97, NULL, NULL, '1782'),
(1840, 'HR-07', 'Krapinsko-Zagorska\r', 'RE', 97, NULL, NULL, '1783'),
(1841, 'HR-08', 'Licko-Senjska\r', 'RE', 97, NULL, NULL, '1784'),
(1842, 'HR-09', 'Medimurska\r', 'RE', 97, NULL, NULL, '1785'),
(1843, 'HR-10', 'Osjecko-Baranjska\r', 'RE', 97, NULL, NULL, '1786'),
(1844, 'HR-11', 'Pozesko-Slavonska\r', 'RE', 97, NULL, NULL, '1787'),
(1845, 'HR-12', 'Primorsko-Goranska\r', 'RE', 97, NULL, NULL, '1788'),
(1846, 'HR-13', 'Sibensko-Kninska\r', 'RE', 97, NULL, NULL, '1789'),
(1847, 'HR-14', 'Sisacko-Moslavacka\r', 'RE', 97, NULL, NULL, '1790'),
(1848, 'HR-15', 'Splitsko-Dalmatinska\r', 'RE', 97, NULL, NULL, '1791'),
(1849, 'HR-16', 'Varazdinska\r', 'RE', 97, NULL, NULL, '1792'),
(1850, 'HR-17', 'Viroviticko-Podravska\r', 'RE', 97, NULL, NULL, '1793'),
(1851, 'HR-18', 'Vukovarsko-Srijemska\r', 'RE', 97, NULL, NULL, '1794'),
(1852, 'HR-19', 'Zadarska\r', 'RE', 97, NULL, NULL, '1795'),
(1853, 'HR-20', 'Zagrebacka\r', 'RE', 97, NULL, NULL, '1796'),
(1854, 'HT-06', 'Artibonite\r', 'RE', 98, 19.33818300000, -72.63196700000, '1797'),
(1855, 'HT-07', 'Centre\r', 'RE', 98, 19.00888500000, -72.02500000000, '1798'),
(1856, 'HT-08', 'Grand'' Anse\r', 'RE', 98, 18.51210500000, -73.76998900000, '1799'),
(1857, 'HT-09', 'Nord\r', 'RE', 98, 19.57530000000, -72.33333300000, '1800'),
(1858, 'HT-10', 'Nord-Est\r', 'RE', 98, 19.50875600000, -71.89555800000, '1801'),
(1859, 'HT-03', 'Nord-Ouest\r', 'RE', 98, 19.85233100000, -73.04646200000, '1802'),
(1860, 'HT-11', 'Ouest\r', 'RE', 98, NULL, NULL, '1803'),
(1861, 'HT-12', 'Sud\r', 'RE', 98, 18.22723200000, -73.69685300000, '1804'),
(1862, 'HT-13', 'Sud-Est\r', 'RE', 98, 18.25833400000, -72.43686300000, '1805'),
(1863, 'HU-01', 'Bacs-Kiskun\r', 'RE', 99, NULL, NULL, '1806'),
(1864, 'HU-02', 'Baranya\r', 'RE', 99, NULL, NULL, '1807'),
(1865, 'HU-03', 'Bekes\r', 'RE', 99, NULL, NULL, '1808'),
(1866, 'HU-26', 'Bekescsaba\r', 'RE', 99, 46.68421600000, 21.08675300000, '1809'),
(1867, 'HU-04', 'Borsod-Abauj-Zemplen\r', 'RE', 99, NULL, NULL, '1810'),
(1868, 'HU-05', 'Budapest\r', 'RE', 99, NULL, NULL, '1811'),
(1869, 'HU-06', 'Csongrad\r', 'RE', 99, NULL, NULL, '1812'),
(1870, 'HU-07', 'Debrecen\r', 'RE', 99, NULL, NULL, '1813'),
(1871, 'HU-27', 'Dunaujvaros\r', 'RE', 99, 46.98066800000, 18.91270600000, '1814'),
(1872, 'HU-28', 'Eger\r', 'RE', 99, 47.90319800000, 20.37310700000, '1815'),
(1873, 'HU-08', 'Fejer\r', 'RE', 99, NULL, NULL, '1816'),
(1874, 'HU-25', 'Gyor\r', 'RE', 99, NULL, NULL, '1817'),
(1875, 'HU-09', 'Gyor-Moson-Sopron\r', 'RE', 99, NULL, NULL, '1818'),
(1876, 'HU-10', 'Hajdu-Bihar\r', 'RE', 99, NULL, NULL, '1819'),
(1877, 'HU-11', 'Heves\r', 'RE', 99, NULL, NULL, '1820'),
(1878, 'HU-29', 'Hodmezovasarhely\r', 'RE', 99, 46.43041100000, 20.31882900000, '1821'),
(1879, 'HU-20', 'Jasz-Nagykun-Szolnok\r', 'RE', 99, NULL, NULL, '1822'),
(1880, 'HU-30', 'Kaposvar\r', 'RE', 99, 46.36653000000, 17.78248300000, '1823'),
(1881, 'HU-31', 'Kecskemet\r', 'RE', 99, 46.90620000000, 19.68998800000, '1824'),
(1882, 'HU-12', 'Komarom-Esztergom\r', 'RE', 99, NULL, NULL, '1825'),
(1883, 'HU-13', 'Miskolc\r', 'RE', 99, NULL, NULL, '1826'),
(1884, 'HU-32', 'Nagykanizsa\r', 'RE', 99, 46.45523700000, 16.99534100000, '1827'),
(1885, 'HU-14', 'Nograd\r', 'RE', 99, NULL, NULL, '1828'),
(1886, 'HU-33', 'Nyiregyhaza\r', 'RE', 99, 47.95316100000, 21.72679200000, '1829'),
(1887, 'HU-15', 'Pecs\r', 'RE', 99, NULL, NULL, '1830'),
(1888, 'HU-16', 'Pest\r', 'RE', 99, NULL, NULL, '1831'),
(1889, 'HU-17', 'Somogy\r', 'RE', 99, NULL, NULL, '1832'),
(1890, 'HU-34', 'Sopron\r', 'RE', 99, 47.68489800000, 16.58305300000, '1833'),
(1891, 'HU-18', 'Szabolcs-Szatmar-Bereg\r', 'RE', 99, NULL, NULL, '1834'),
(1892, 'HU-19', 'Szeged\r', 'RE', 99, NULL, NULL, '1835'),
(1893, 'HU-35', 'Szekesfehervar\r', 'RE', 99, 47.18871500000, 18.41380800000, '1836'),
(1894, 'HU-36', 'Szolnok\r', 'RE', 99, 47.17466200000, 20.17628000000, '1837'),
(1895, 'HU-37', 'Szombathely\r', 'RE', 99, 47.23514000000, 16.62191700000, '1838'),
(1896, 'HU-38', 'Tatabanya\r', 'RE', 99, 47.58618600000, 18.39476600000, '1839'),
(1897, 'HU-21', 'Tolna\r', 'RE', 99, NULL, NULL, '1840'),
(1898, 'HU-22', 'Vas\r', 'RE', 99, NULL, NULL, '1841'),
(1899, 'HU-23', 'Veszprem\r', 'RE', 99, NULL, NULL, '1842'),
(1900, 'HU-24', 'Zala\r', 'RE', 99, NULL, NULL, '1843'),
(1901, 'HU-40', 'Zalaegerszeg\r', 'RE', 99, 46.84538900000, 16.84723500000, '1844'),
(1902, 'ID-01', 'Aceh\r', 'RE', 100, NULL, NULL, '1845'),
(1903, 'ID-02', 'Bali\r', 'RE', 100, NULL, NULL, '1846'),
(1904, 'ID-33', 'Banten\r', 'RE', 100, -6.41211500000, 105.96122300000, '1847'),
(1905, 'ID-03', 'Bengkulu\r', 'RE', 100, NULL, NULL, '1848'),
(1906, 'ID-34', 'Gorontalo\r', 'RE', 100, 0.69913300000, 122.16102400000, '1849'),
(1907, 'ID-04', 'Jakarta Raya\r', 'RE', 100, NULL, NULL, '1850'),
(1908, 'ID-05', 'Jambi\r', 'RE', 100, NULL, NULL, '1851'),
(1909, 'ID-30', 'Jawa Barat\r', 'RE', 100, NULL, NULL, '1852'),
(1910, 'ID-07', 'Jawa Tengah\r', 'RE', 100, NULL, NULL, '1853'),
(1911, 'ID-08', 'Jawa Timur\r', 'RE', 100, NULL, NULL, '1854'),
(1912, 'ID-11', 'Kalimantan Barat\r', 'RE', 100, NULL, NULL, '1855'),
(1913, 'ID-12', 'Kalimantan Selatan\r', 'RE', 100, NULL, NULL, '1856'),
(1914, 'ID-13', 'Kalimantan Tengah\r', 'RE', 100, NULL, NULL, '1857'),
(1915, 'ID-14', 'Kalimantan Timur\r', 'RE', 100, NULL, NULL, '1858'),
(1916, 'ID-35', 'Kepulauan Bangka Belitung\r', 'RE', 100, -2.40208400000, 106.92331600000, '1859'),
(1917, 'ID-15', 'Lampung\r', 'RE', 100, NULL, NULL, '1860'),
(1918, 'ID-28', 'Maluku\r', 'RE', 100, -3.63680200000, 130.30754100000, '1861'),
(1919, 'ID-29', 'Maluku Utara\r', 'RE', 100, 0.07981700000, 126.89476400000, '1862'),
(1920, 'ID-17', 'Nusa Tenggara Barat\r', 'RE', 100, NULL, NULL, '1863'),
(1921, 'ID-18', 'Nusa Tenggara Timur\r', 'RE', 100, NULL, NULL, '1864'),
(1922, 'ID-09', 'Papua\r', 'RE', 100, NULL, NULL, '1865'),
(1923, 'ID-19', 'Riau\r', 'RE', 100, NULL, NULL, '1866'),
(1924, 'ID-20', 'Sulawesi Selatan\r', 'RE', 100, NULL, NULL, '1867'),
(1925, 'ID-21', 'Sulawesi Tengah\r', 'RE', 100, NULL, NULL, '1868'),
(1926, 'ID-22', 'Sulawesi Tenggara\r', 'RE', 100, NULL, NULL, '1869'),
(1927, 'ID-31', 'Sulawesi Utara\r', 'RE', 100, NULL, NULL, '1870'),
(1928, 'ID-24', 'Sumatera Barat\r', 'RE', 100, NULL, NULL, '1871'),
(1929, 'ID-32', 'Sumatera Selatan\r', 'RE', 100, -3.22161000000, 106.21448500000, '1872'),
(1930, 'ID-26', 'Sumatera Utara\r', 'RE', 100, NULL, NULL, '1873'),
(1931, 'ID-10', 'Yogyakarta\r', 'RE', 100, NULL, NULL, '1874'),
(1932, 'IE-01', 'Carlow\r', 'RE', 101, NULL, NULL, '1875'),
(1933, 'IE-02', 'Cavan\r', 'RE', 101, NULL, NULL, '1876'),
(1934, 'IE-03', 'Clare\r', 'RE', 101, NULL, NULL, '1877'),
(1935, 'IE-04', 'Cork\r', 'RE', 101, NULL, NULL, '1878'),
(1936, 'IE-06', 'Donegal\r', 'RE', 101, NULL, NULL, '1879'),
(1937, 'IE-07', 'Dublin\r', 'RE', 101, NULL, NULL, '1880'),
(1938, 'IE-10', 'Galway\r', 'RE', 101, NULL, NULL, '1881'),
(1939, 'IE-11', 'Kerry\r', 'RE', 101, NULL, NULL, '1882'),
(1940, 'IE-12', 'Kildare\r', 'RE', 101, NULL, NULL, '1883'),
(1941, 'IE-13', 'Kilkenny\r', 'RE', 101, NULL, NULL, '1884'),
(1942, 'IE-15', 'Laois\r', 'RE', 101, NULL, NULL, '1885'),
(1943, 'IE-14', 'Leitrim\r', 'RE', 101, NULL, NULL, '1886'),
(1944, 'IE-16', 'Limerick\r', 'RE', 101, NULL, NULL, '1887'),
(1945, 'IE-18', 'Longford\r', 'RE', 101, NULL, NULL, '1888'),
(1946, 'IE-19', 'Louth\r', 'RE', 101, NULL, NULL, '1889'),
(1947, 'IE-20', 'Mayo\r', 'RE', 101, NULL, NULL, '1890'),
(1948, 'IE-21', 'Meath\r', 'RE', 101, NULL, NULL, '1891'),
(1949, 'IE-22', 'Monaghan\r', 'RE', 101, NULL, NULL, '1892'),
(1950, 'IE-23', 'Offaly\r', 'RE', 101, NULL, NULL, '1893'),
(1951, 'IE-24', 'Roscommon\r', 'RE', 101, NULL, NULL, '1894'),
(1952, 'IE-25', 'Sligo\r', 'RE', 101, NULL, NULL, '1895'),
(1953, 'IE-26', 'Tipperary\r', 'RE', 101, NULL, NULL, '1896'),
(1954, 'IE-27', 'Waterford\r', 'RE', 101, NULL, NULL, '1897'),
(1955, 'IE-29', 'Westmeath\r', 'RE', 101, NULL, NULL, '1898'),
(1956, 'IE-30', 'Wexford\r', 'RE', 101, NULL, NULL, '1899'),
(1957, 'IE-31', 'Wicklow\r', 'RE', 101, NULL, NULL, '1900'),
(1958, 'IL-01', 'HaDarom\r', 'RE', 102, NULL, NULL, '1901'),
(1959, 'IL-02', 'HaMerkaz\r', 'RE', 102, NULL, NULL, '1902'),
(1960, 'IL-03', 'HaZafon\r', 'RE', 102, NULL, NULL, '1903'),
(1961, 'IL-04', 'Hefa\r', 'RE', 102, NULL, NULL, '1904'),
(1962, 'IL-05', 'Tel Aviv\r', 'RE', 102, NULL, NULL, '1905'),
(1963, 'IL-06', 'Yerushalayim\r', 'RE', 102, NULL, NULL, '1906'),
(1964, 'IN-01', 'Andaman and Nicobar Islands\r', 'RE', 104, NULL, NULL, '1907'),
(1965, 'IN-02', 'Andhra Pradesh\r', 'RE', 104, NULL, NULL, '1908'),
(1966, 'IN-30', 'Arunachal Pradesh\r', 'RE', 104, NULL, NULL, '1909'),
(1967, 'IN-03', 'Assam\r', 'RE', 104, NULL, NULL, '1910'),
(1968, 'IN-34', 'Bihar\r', 'RE', 104, NULL, NULL, '1911'),
(1969, 'IN-05', 'Chandigarh\r', 'RE', 104, NULL, NULL, '1912'),
(1970, 'IN-37', 'Chhattisgarh\r', 'RE', 104, NULL, NULL, '1913'),
(1971, 'IN-06', 'Dadra and Nagar Haveli\r', 'RE', 104, NULL, NULL, '1914'),
(1972, 'IN-32', 'Daman and Diu\r', 'RE', 104, NULL, NULL, '1915'),
(1973, 'IN-07', 'Delhi\r', 'RE', 104, NULL, NULL, '1916'),
(1974, 'IN-33', 'Goa\r', 'RE', 104, NULL, NULL, '1917'),
(1975, 'IN-09', 'Gujarat\r', 'RE', 104, NULL, NULL, '1918'),
(1976, 'IN-10', 'Haryana\r', 'RE', 104, NULL, NULL, '1919'),
(1977, 'IN-11', 'Himachal Pradesh\r', 'RE', 104, NULL, NULL, '1920'),
(1978, 'IN-12', 'Jammu and Kashmir\r', 'RE', 104, NULL, NULL, '1921'),
(1979, 'IN-38', 'Jharkhand\r', 'RE', 104, NULL, NULL, '1922'),
(1980, 'IN-19', 'Karnataka\r', 'RE', 104, NULL, NULL, '1923'),
(1981, 'IN-13', 'Kerala\r', 'RE', 104, NULL, NULL, '1924'),
(1982, 'IN-14', 'Lakshadweep\r', 'RE', 104, 10.33261700000, 72.74059000000, '1925'),
(1983, 'IN-35', 'Madhya Pradesh\r', 'RE', 104, NULL, NULL, '1926'),
(1984, 'IN-16', 'Maharashtra\r', 'RE', 104, NULL, NULL, '1927'),
(1985, 'IN-17', 'Manipur\r', 'RE', 104, NULL, NULL, '1928'),
(1986, 'IN-18', 'Meghalaya\r', 'RE', 104, NULL, NULL, '1929'),
(1987, 'IN-31', 'Mizoram\r', 'RE', 104, NULL, NULL, '1930'),
(1988, 'IN-20', 'Nagaland\r', 'RE', 104, NULL, NULL, '1931'),
(1989, 'IN-21', 'Orissa\r', 'RE', 104, NULL, NULL, '1932'),
(1990, 'IN-22', 'Pondicherry\r', 'RE', 104, NULL, NULL, '1933'),
(1991, 'IN-23', 'Punjab\r', 'RE', 104, NULL, NULL, '1934'),
(1992, 'IN-24', 'Rajasthan\r', 'RE', 104, NULL, NULL, '1935'),
(1993, 'IN-29', 'Sikkim\r', 'RE', 104, NULL, NULL, '1936'),
(1994, 'IN-25', 'Tamil Nadu\r', 'RE', 104, NULL, NULL, '1937'),
(1995, 'IN-26', 'Tripura\r', 'RE', 104, NULL, NULL, '1938'),
(1996, 'IN-36', 'Uttar Pradesh\r', 'RE', 104, NULL, NULL, '1939'),
(1997, 'IN-39', 'Uttaranchal\r', 'RE', 104, NULL, NULL, '1940'),
(1998, 'IN-28', 'West Bengal\r', 'RE', 104, NULL, NULL, '1941'),
(1999, 'IQ-01', 'Al Anbar\r', 'RE', 106, NULL, NULL, '1942'),
(2000, 'IQ-02', 'Al Basrah\r', 'RE', 106, NULL, NULL, '1943'),
(2001, 'IQ-03', 'Al Muthanna\r', 'RE', 106, NULL, NULL, '1944'),
(2002, 'IQ-04', 'Al Qadisiyah\r', 'RE', 106, 31.83727400000, 45.10155300000, '1945'),
(2003, 'IQ-17', 'An Najaf\r', 'RE', 106, NULL, NULL, '1946'),
(2004, 'IQ-11', 'Arbil\r', 'RE', 106, NULL, NULL, '1947'),
(2005, 'IQ-05', 'As Sulaymaniyah\r', 'RE', 106, NULL, NULL, '1948'),
(2006, 'IQ-13', 'At Ta''mim\r', 'RE', 106, NULL, NULL, '1949'),
(2007, 'IQ-06', 'Babil\r', 'RE', 106, 32.65605100000, 44.53195800000, '1950'),
(2008, 'IQ-07', 'Baghdad\r', 'RE', 106, NULL, NULL, '1951'),
(2009, 'IQ-08', 'Dahuk\r', 'RE', 106, NULL, NULL, '1952'),
(2010, 'IQ-09', 'Dhi Qar\r', 'RE', 106, NULL, NULL, '1953'),
(2011, 'IQ-10', 'Diyala\r', 'RE', 106, NULL, NULL, '1954'),
(2012, 'IQ-12', 'Karbala''\r', 'RE', 106, NULL, NULL, '1955'),
(2013, 'IQ-14', 'Maysan\r', 'RE', 106, 31.99154000000, 47.08336500000, '1956'),
(2014, 'IQ-15', 'Ninawa\r', 'RE', 106, NULL, NULL, '1957'),
(2015, 'IQ-18', 'Salah ad Din\r', 'RE', 106, 34.54493600000, 43.70288100000, '1958'),
(2016, 'IQ-16', 'Wasit\r', 'RE', 106, 32.69417600000, 45.55818900000, '1959'),
(2017, 'IR-32', 'Ardabil\r', 'RE', 107, NULL, NULL, '1960'),
(2018, 'IR-01', 'Azarbayjan-e Bakhtari\r', 'RE', 107, NULL, NULL, '1961'),
(2019, 'IR-02', 'Azarbayjan-e Khavari\r', 'RE', 107, NULL, NULL, '1962'),
(2020, 'IR-13', 'Bakhtaran\r', 'RE', 107, NULL, NULL, '1963'),
(2021, 'IR-22', 'Bushehr\r', 'RE', 107, NULL, NULL, '1964'),
(2022, 'IR-03', 'Chahar Mahall va Bakhtiari\r', 'RE', 107, NULL, NULL, '1965'),
(2023, 'IR-28', 'Esfahan\r', 'RE', 107, NULL, NULL, '1966'),
(2024, 'IR-07', 'Fars\r', 'RE', 107, NULL, NULL, '1967'),
(2025, 'IR-08', 'Gilan\r', 'RE', 107, NULL, NULL, '1968'),
(2026, 'IR-37', 'Golestan\r', 'RE', 107, NULL, NULL, '1969'),
(2027, 'IR-09', 'Hamadan\r', 'RE', 107, NULL, NULL, '1970'),
(2028, 'IR-11', 'Hormozgan\r', 'RE', 107, NULL, NULL, '1971'),
(2029, 'IR-10', 'Ilam\r', 'RE', 107, NULL, NULL, '1972'),
(2030, 'IR-29', 'Kerman\r', 'RE', 107, NULL, NULL, '1973'),
(2031, 'IR-30', 'Khorasan\r', 'RE', 107, NULL, NULL, '1974'),
(2032, 'IR-15', 'Khuzestan\r', 'RE', 107, NULL, NULL, '1975'),
(2033, 'IR-05', 'Kohkiluyeh va Buyer Ahmadi\r', 'RE', 107, NULL, NULL, '1976'),
(2034, 'IR-16', 'Kordestan\r', 'RE', 107, NULL, NULL, '1977'),
(2035, 'IR-23', 'Lorestan\r', 'RE', 107, NULL, NULL, '1978'),
(2036, 'IR-34', 'Markazi\r', 'RE', 107, NULL, NULL, '1979'),
(2037, 'IR-35', 'Mazandaran\r', 'RE', 107, NULL, NULL, '1980'),
(2038, 'IR-38', 'Qazvin\r', 'RE', 107, NULL, NULL, '1981'),
(2039, 'IR-39', 'Qom\r', 'RE', 107, NULL, NULL, '1982'),
(2040, 'IR-25', 'Semnan\r', 'RE', 107, NULL, NULL, '1983'),
(2041, 'IR-04', 'Sistan va Baluchestan\r', 'RE', 107, NULL, NULL, '1984'),
(2042, 'IR-26', 'Tehran\r', 'RE', 107, NULL, NULL, '1985'),
(2043, 'IR-31', 'Yazd\r', 'RE', 107, NULL, NULL, '1986'),
(2044, 'IR-36', 'Zanjan\r', 'RE', 107, NULL, NULL, '1987'),
(2045, 'IS-01', 'Akranes\r', 'RE', 108, 64.32235700000, -22.07443000000, '1988'),
(2046, 'IS-02', 'Akureyri\r', 'RE', 108, 65.68386800000, -18.11046000000, '1989'),
(2047, 'IS-03', 'Arnessysla\r', 'RE', 108, NULL, NULL, '1990'),
(2048, 'IS-04', 'Austur-Bardastrandarsysla\r', 'RE', 108, NULL, NULL, '1991'),
(2049, 'IS-05', 'Austur-Hunavatnssysla\r', 'RE', 108, NULL, NULL, '1992'),
(2050, 'IS-06', 'Austur-Skaftafellssysla\r', 'RE', 108, NULL, NULL, '1993'),
(2051, 'IS-07', 'Borgarfjardarsysla\r', 'RE', 108, NULL, NULL, '1994'),
(2052, 'IS-08', 'Dalasysla\r', 'RE', 108, NULL, NULL, '1995'),
(2053, 'IS-09', 'Eyjafjardarsysla\r', 'RE', 108, NULL, NULL, '1996'),
(2054, 'IS-10', 'Gullbringusysla\r', 'RE', 108, NULL, NULL, '1997'),
(2055, 'IS-11', 'Hafnarfjordur\r', 'RE', 108, NULL, NULL, '1998'),
(2056, 'IS-12', 'Husavik\r', 'RE', 108, 66.04763000000, -17.34359900000, '1999'),
(2057, 'IS-13', 'Isafjordur\r', 'RE', 108, 66.07055800000, -23.12886000000, '2000'),
(2058, 'IS-14', 'Keflavik\r', 'RE', 108, 64.00653800000, -22.57210000000, '2001'),
(2059, 'IS-15', 'Kjosarsysla\r', 'RE', 108, NULL, NULL, '2002'),
(2060, 'IS-16', 'Kopavogur\r', 'RE', 108, 64.11103000000, -21.90569200000, '2003'),
(2061, 'IS-17', 'Myrasysla\r', 'RE', 108, NULL, NULL, '2004'),
(2062, 'IS-18', 'Neskaupstadur\r', 'RE', 108, NULL, NULL, '2005'),
(2063, 'IS-19', 'Nordur-Isafjardarsysla\r', 'RE', 108, NULL, NULL, '2006'),
(2064, 'IS-20', 'Nordur-Mulasysla\r', 'RE', 108, NULL, NULL, '2007'),
(2065, 'IS-21', 'Nordur-Tingeyjarsysla\r', 'RE', 108, NULL, NULL, '2008'),
(2066, 'IS-22', 'Olafsfjordur\r', 'RE', 108, 66.06517000000, -18.65763300000, '2009'),
(2067, 'IS-23', 'Rangarvallasysla\r', 'RE', 108, NULL, NULL, '2010'),
(2068, 'IS-24', 'Reykjavik\r', 'RE', 108, 64.13533800000, -21.89521000000, '2011'),
(2069, 'IS-25', 'Saudarkrokur\r', 'RE', 108, NULL, NULL, '2012'),
(2070, 'IS-26', 'Seydisfjordur\r', 'RE', 108, 65.26666700000, -14.00000000000, '2013'),
(2071, 'IS-27', 'Siglufjordur\r', 'RE', 108, NULL, NULL, '2014'),
(2072, 'IS-28', 'Skagafjardarsysla\r', 'RE', 108, NULL, NULL, '2015'),
(2073, 'IS-29', 'Snafellsnes- og Hnappadalssysla\r', 'RE', 108, NULL, NULL, '2016'),
(2074, 'IS-30', 'Strandasysla\r', 'RE', 108, NULL, NULL, '2017'),
(2075, 'IS-31', 'Sudur-Mulasysla\r', 'RE', 108, NULL, NULL, '2018'),
(2076, 'IS-32', 'Sudur-Tingeyjarsysla\r', 'RE', 108, NULL, NULL, '2019'),
(2077, 'IS-33', 'Vestmannaeyjar\r', 'RE', 108, 63.43767900000, -20.26732100000, '2020'),
(2078, 'IS-34', 'Vestur-Bardastrandarsysla\r', 'RE', 108, NULL, NULL, '2021'),
(2079, 'IS-35', 'Vestur-Hunavatnssysla\r', 'RE', 108, NULL, NULL, '2022'),
(2080, 'IS-36', 'Vestur-Isafjardarsysla\r', 'RE', 108, NULL, NULL, '2023'),
(2081, 'IS-37', 'Vestur-Skaftafellssysla\r', 'RE', 108, NULL, NULL, '2024'),
(2082, 'IT-01', 'Abruzzi\r', 'RE', 109, NULL, NULL, '2025'),
(2083, 'IT-02', 'Basilicata\r', 'RE', 109, NULL, NULL, '2026'),
(2084, 'IT-03', 'Calabria\r', 'RE', 109, NULL, NULL, '2027'),
(2085, 'IT-04', 'Campania\r', 'RE', 109, NULL, NULL, '2028'),
(2086, 'IT-05', 'Emilia-Romagna\r', 'RE', 109, NULL, NULL, '2029'),
(2087, 'IT-06', 'Friuli-Venezia Giulia\r', 'RE', 109, NULL, NULL, '2030'),
(2088, 'IT-07', 'Lazio\r', 'RE', 109, NULL, NULL, '2031'),
(2089, 'IT-08', 'Liguria\r', 'RE', 109, NULL, NULL, '2032'),
(2090, 'IT-09', 'Lombardia\r', 'RE', 109, NULL, NULL, '2033'),
(2091, 'IT-10', 'Marche\r', 'RE', 109, NULL, NULL, '2034'),
(2092, 'IT-11', 'Molise\r', 'RE', 109, NULL, NULL, '2035'),
(2093, 'IT-12', 'Piemonte\r', 'RE', 109, NULL, NULL, '2036'),
(2094, 'IT-13', 'Puglia\r', 'RE', 109, NULL, NULL, '2037'),
(2095, 'IT-14', 'Sardegna\r', 'RE', 109, NULL, NULL, '2038'),
(2096, 'IT-15', 'Sicilia\r', 'RE', 109, NULL, NULL, '2039'),
(2097, 'IT-16', 'Toscana\r', 'RE', 109, NULL, NULL, '2040'),
(2098, 'IT-17', 'Trentino-Alto Adige\r', 'RE', 109, NULL, NULL, '2041'),
(2099, 'IT-18', 'Umbria\r', 'RE', 109, NULL, NULL, '2042'),
(2100, 'IT-19', 'Valle d''Aosta\r', 'RE', 109, NULL, NULL, '2043'),
(2101, 'IT-20', 'Veneto\r', 'RE', 109, NULL, NULL, '2044'),
(2102, 'JM-01', 'Clarendon\r', 'RE', 111, NULL, NULL, '2045'),
(2103, 'JM-02', 'Hanover\r', 'RE', 111, NULL, NULL, '2046'),
(2104, 'JM-17', 'Kingston\r', 'RE', 111, 17.99273100000, -76.79200900000, '2047'),
(2105, 'JM-04', 'Manchester\r', 'RE', 111, NULL, NULL, '2048'),
(2106, 'JM-07', 'Portland\r', 'RE', 111, 18.12496100000, -76.50821100000, '2049'),
(2107, 'JM-08', 'Saint Andrew\r', 'RE', 111, NULL, NULL, '2050'),
(2108, 'JM-09', 'Saint Ann\r', 'RE', 111, NULL, NULL, '2051'),
(2109, 'JM-10', 'Saint Catherine\r', 'RE', 111, NULL, NULL, '2052'),
(2110, 'JM-11', 'Saint Elizabeth\r', 'RE', 111, NULL, NULL, '2053'),
(2111, 'JM-12', 'Saint James\r', 'RE', 111, NULL, NULL, '2054'),
(2112, 'JM-13', 'Saint Mary\r', 'RE', 111, NULL, NULL, '2055'),
(2113, 'JM-14', 'Saint Thomas\r', 'RE', 111, 17.96712400000, -76.42268700000, '2056'),
(2114, 'JM-15', 'Trelawny\r', 'RE', 111, NULL, NULL, '2057'),
(2115, 'JM-16', 'Westmoreland\r', 'RE', 111, NULL, NULL, '2058'),
(2116, 'JO-02', 'Al Balqa''\r', 'RE', 112, NULL, NULL, '2059'),
(2117, 'JO-09', 'Al Karak\r', 'RE', 112, NULL, NULL, '2060'),
(2118, 'JO-10', 'Al Mafraq\r', 'RE', 112, NULL, NULL, '2061'),
(2119, 'JO-16', 'Amman\r', 'RE', 112, 31.94968500000, 35.92635000000, '2062'),
(2120, 'JO-12', 'At Tafilah\r', 'RE', 112, NULL, NULL, '2063'),
(2121, 'JO-13', 'Az Zarqa\r', 'RE', 112, 32.04114900000, 36.08147000000, '2064'),
(2122, 'JO-14', 'Irbid\r', 'RE', 112, NULL, NULL, '2065'),
(2123, 'JO-07', 'Ma\r', 'RE', 112, NULL, NULL, '2066'),
(2124, 'JP-01', 'Aichi\r', 'RE', 113, NULL, NULL, '2067'),
(2125, 'JP-02', 'Akita\r', 'RE', 113, NULL, NULL, '2068'),
(2126, 'JP-03', 'Aomori\r', 'RE', 113, NULL, NULL, '2069'),
(2127, 'JP-04', 'Chiba\r', 'RE', 113, NULL, NULL, '2070'),
(2128, 'JP-05', 'Ehime\r', 'RE', 113, NULL, NULL, '2071'),
(2129, 'JP-06', 'Fukui\r', 'RE', 113, NULL, NULL, '2072'),
(2130, 'JP-07', 'Fukuoka\r', 'RE', 113, NULL, NULL, '2073'),
(2131, 'JP-08', 'Fukushima\r', 'RE', 113, NULL, NULL, '2074'),
(2132, 'JP-09', 'Gifu\r', 'RE', 113, NULL, NULL, '2075'),
(2133, 'JP-10', 'Gumma\r', 'RE', 113, NULL, NULL, '2076'),
(2134, 'JP-11', 'Hiroshima\r', 'RE', 113, NULL, NULL, '2077'),
(2135, 'JP-12', 'Hokkaido\r', 'RE', 113, NULL, NULL, '2078'),
(2136, 'JP-13', 'Hyogo\r', 'RE', 113, NULL, NULL, '2079'),
(2137, 'JP-14', 'Ibaraki\r', 'RE', 113, NULL, NULL, '2080'),
(2138, 'JP-15', 'Ishikawa\r', 'RE', 113, NULL, NULL, '2081'),
(2139, 'JP-16', 'Iwate\r', 'RE', 113, NULL, NULL, '2082'),
(2140, 'JP-17', 'Kagawa\r', 'RE', 113, NULL, NULL, '2083'),
(2141, 'JP-18', 'Kagoshima\r', 'RE', 113, NULL, NULL, '2084'),
(2142, 'JP-19', 'Kanagawa\r', 'RE', 113, NULL, NULL, '2085'),
(2143, 'JP-20', 'Kochi\r', 'RE', 113, NULL, NULL, '2086'),
(2144, 'JP-21', 'Kumamoto\r', 'RE', 113, NULL, NULL, '2087'),
(2145, 'JP-22', 'Kyoto\r', 'RE', 113, NULL, NULL, '2088'),
(2146, 'JP-23', 'Mie\r', 'RE', 113, NULL, NULL, '2089'),
(2147, 'JP-24', 'Miyagi\r', 'RE', 113, NULL, NULL, '2090'),
(2148, 'JP-25', 'Miyazaki\r', 'RE', 113, NULL, NULL, '2091'),
(2149, 'JP-26', 'Nagano\r', 'RE', 113, NULL, NULL, '2092'),
(2150, 'JP-27', 'Nagasaki\r', 'RE', 113, NULL, NULL, '2093'),
(2151, 'JP-28', 'Nara\r', 'RE', 113, NULL, NULL, '2094'),
(2152, 'JP-29', 'Niigata\r', 'RE', 113, NULL, NULL, '2095'),
(2153, 'JP-30', 'Oita\r', 'RE', 113, NULL, NULL, '2096'),
(2154, 'JP-31', 'Okayama\r', 'RE', 113, NULL, NULL, '2097'),
(2155, 'JP-47', 'Okinawa\r', 'RE', 113, NULL, NULL, '2098'),
(2156, 'JP-32', 'Osaka\r', 'RE', 113, NULL, NULL, '2099'),
(2157, 'JP-33', 'Saga\r', 'RE', 113, NULL, NULL, '2100'),
(2158, 'JP-34', 'Saitama\r', 'RE', 113, NULL, NULL, '2101'),
(2159, 'JP-35', 'Shiga\r', 'RE', 113, NULL, NULL, '2102'),
(2160, 'JP-36', 'Shimane\r', 'RE', 113, NULL, NULL, '2103'),
(2161, 'JP-37', 'Shizuoka\r', 'RE', 113, NULL, NULL, '2104'),
(2162, 'JP-38', 'Tochigi\r', 'RE', 113, NULL, NULL, '2105'),
(2163, 'JP-39', 'Tokushima\r', 'RE', 113, NULL, NULL, '2106'),
(2164, 'JP-40', 'Tokyo\r', 'RE', 113, NULL, NULL, '2107'),
(2165, 'JP-41', 'Tottori\r', 'RE', 113, NULL, NULL, '2108'),
(2166, 'JP-42', 'Toyama\r', 'RE', 113, NULL, NULL, '2109'),
(2167, 'JP-43', 'Wakayama\r', 'RE', 113, NULL, NULL, '2110'),
(2168, 'JP-44', 'Yamagata\r', 'RE', 113, NULL, NULL, '2111'),
(2169, 'JP-45', 'Yamaguchi\r', 'RE', 113, NULL, NULL, '2112'),
(2170, 'JP-46', 'Yamanashi\r', 'RE', 113, NULL, NULL, '2113'),
(2171, 'KE-01', 'Central\r', 'RE', 114, NULL, NULL, '2114'),
(2172, 'KE-02', 'Coast\r', 'RE', 114, NULL, NULL, '2115'),
(2173, 'KE-03', 'Eastern\r', 'RE', 114, NULL, NULL, '2116'),
(2174, 'KE-05', 'Nairobi Area\r', 'RE', 114, NULL, NULL, '2117'),
(2175, 'KE-06', 'North-Eastern\r', 'RE', 114, 1.12354300000, 40.29374800000, '2118'),
(2176, 'KE-07', 'Nyanza\r', 'RE', 114, NULL, NULL, '2119'),
(2177, 'KE-08', 'Rift Valley\r', 'RE', 114, NULL, NULL, '2120'),
(2178, 'KE-09', 'Western\r', 'RE', 114, NULL, NULL, '2121'),
(2179, 'KG-09', 'Batken\r', 'RE', 115, NULL, NULL, '2122'),
(2180, 'KG-01', 'Bishkek\r', 'RE', 115, NULL, NULL, '2123'),
(2181, 'KG-02', 'Chuy\r', 'RE', 115, NULL, NULL, '2124'),
(2182, 'KG-03', 'Jalal-Abad\r', 'RE', 115, NULL, NULL, '2125'),
(2183, 'KG-04', 'Naryn\r', 'RE', 115, NULL, NULL, '2126'),
(2184, 'KG-08', 'Osh\r', 'RE', 115, 39.97775300000, 73.09539000000, '2127'),
(2185, 'KG-06', 'Talas\r', 'RE', 115, NULL, NULL, '2128'),
(2186, 'KG-07', 'Ysyk-Kol\r', 'RE', 115, NULL, NULL, '2129'),
(2187, 'KH-29', 'Batdambang\r', 'RE', 116, 13.11220000000, 103.21260000000, '2130'),
(2188, 'KH-02', 'Kampong Cham\r', 'RE', 116, 12.06149900000, 105.64213200000, '2131'),
(2189, 'KH-03', 'Kampong Chhnang\r', 'RE', 116, 12.17481200000, 104.54485400000, '2132'),
(2190, 'KH-04', 'Kampong Spoe\r', 'RE', 116, 11.45820000000, 104.50880000000, '2133'),
(2191, 'KH-05', 'Kampong Thum\r', 'RE', 116, 12.72060000000, 104.88820000000, '2134'),
(2192, 'KH-06', 'Kampot\r', 'RE', 116, 10.78545100000, 104.32603000000, '2135'),
(2193, 'KH-07', 'Kandal\r', 'RE', 116, 11.39354000000, 104.97866100000, '2136'),
(2194, 'KH-08', 'Kaoh Kong\r', 'RE', 116, 11.42569000000, 103.01899700000, '2137'),
(2195, 'KH-09', 'Kracheh\r', 'RE', 116, 12.49240000000, 106.02520000000, '2138'),
(2196, 'KH-10', 'Mondol Kiri\r', 'RE', 116, 12.74156200000, 106.97902700000, '2139'),
(2197, 'KH-30', 'Pailin\r', 'RE', 116, 12.85000000000, 102.58333300000, '2140'),
(2198, 'KH-11', 'Phnum Penh\r', 'RE', 116, NULL, NULL, '2141'),
(2199, 'KH-12', 'Pouthisat\r', 'RE', 116, 12.52790000000, 103.92500000000, '2142'),
(2200, 'KH-13', 'Preah Vihear\r', 'RE', 116, 13.76669600000, 105.12039700000, '2143'),
(2201, 'KH-14', 'Prey Veng\r', 'RE', 116, 11.35792300000, 105.47031400000, '2144'),
(2202, 'KH-15', 'Rotanokiri\r', 'RE', 116, NULL, NULL, '2145'),
(2203, 'KH-16', 'Siemreab-Otdar Meanchey\r', 'RE', 116, NULL, NULL, '2146'),
(2204, 'KH-17', 'Stoeng Treng\r', 'RE', 116, 13.51810000000, 105.96950000000, '2147'),
(2205, 'KH-18', 'Svay Rieng\r', 'RE', 116, 11.18825100000, 105.89571400000, '2148'),
(2206, 'KH-19', 'Takev\r', 'RE', 116, NULL, NULL, '2149'),
(2207, 'KI-01', 'Gilbert Islands\r', 'RE', 117, 0.35934400000, 173.18632500000, '2150'),
(2208, 'KI-02', 'Line Islands\r', 'RE', 117, -3.35627900000, -155.31757500000, '2151'),
(2209, 'KI-03', 'Phoenix Islands\r', 'RE', 117, -3.73025700000, -172.62754000000, '2152'),
(2210, 'KM-01', 'Anjouan\r', 'RE', 118, -12.22338200000, 44.37088000000, '2153'),
(2211, 'KM-02', 'Grande Comore\r', 'RE', 118, NULL, NULL, '2154'),
(2212, 'KM-03', 'Moheli\r', 'RE', 118, -12.31518500000, 43.74102800000, '2155'),
(2213, 'KN-01', 'Christ Church Nichola Town\r', 'RE', 119, NULL, NULL, '2156'),
(2214, 'KN-02', 'Saint Anne Sandy Point\r', 'RE', 119, NULL, NULL, '2157'),
(2215, 'KN-03', 'Saint George Basseterre\r', 'RE', 119, NULL, NULL, '2158'),
(2216, 'KN-04', 'Saint George Gingerland\r', 'RE', 119, NULL, NULL, '2159'),
(2217, 'KN-05', 'Saint James Windward\r', 'RE', 119, NULL, NULL, '2160'),
(2218, 'KN-06', 'Saint John Capisterre\r', 'RE', 119, NULL, NULL, '2161'),
(2219, 'KN-07', 'Saint John Figtree\r', 'RE', 119, NULL, NULL, '2162'),
(2220, 'KN-08', 'Saint Mary Cayon\r', 'RE', 119, NULL, NULL, '2163'),
(2221, 'KN-09', 'Saint Paul Capisterre\r', 'RE', 119, NULL, NULL, '2164'),
(2222, 'KN-10', 'Saint Paul Charlestown\r', 'RE', 119, NULL, NULL, '2165'),
(2223, 'KN-11', 'Saint Peter Basseterre\r', 'RE', 119, NULL, NULL, '2166'),
(2224, 'KN-12', 'Saint Thomas Lowland\r', 'RE', 119, NULL, NULL, '2167'),
(2225, 'KN-13', 'Saint Thomas Middle Island\r', 'RE', 119, NULL, NULL, '2168'),
(2226, 'KN-15', 'Trinity Palmetto Point\r', 'RE', 119, NULL, NULL, '2169'),
(2227, 'KP-01', 'Chagang-do\r', 'RE', 120, NULL, NULL, '2170'),
(2228, 'KP-17', 'Hamgyong-bukto\r', 'RE', 120, NULL, NULL, '2171'),
(2229, 'KP-03', 'Hamgyong-namdo\r', 'RE', 120, NULL, NULL, '2172'),
(2230, 'KP-07', 'Hwanghae-bukto\r', 'RE', 120, NULL, NULL, '2173'),
(2231, 'KP-06', 'Hwanghae-namdo\r', 'RE', 120, NULL, NULL, '2174'),
(2232, 'KP-08', 'Kaesong-si\r', 'RE', 120, NULL, NULL, '2175'),
(2233, 'KP-09', 'Kangwon-do\r', 'RE', 120, NULL, NULL, '2176'),
(2234, 'KP-18', 'Najin Sonbong-si\r', 'RE', 120, NULL, NULL, '2177'),
(2235, 'KP-14', 'Namp''o-si\r', 'RE', 120, NULL, NULL, '2178'),
(2236, 'KP-11', 'P''yongan-bukto\r', 'RE', 120, NULL, NULL, '2179'),
(2237, 'KP-15', 'P''yongan-namdo\r', 'RE', 120, NULL, NULL, '2180');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(2238, 'KP-12', 'P''yongyang-si\r', 'RE', 120, NULL, NULL, '2181'),
(2239, 'KP-13', 'Yanggang-do\r', 'RE', 120, NULL, NULL, '2182'),
(2240, 'KR-05', 'Ch''ungch''ong-bukto\r', 'RE', 121, NULL, NULL, '2183'),
(2241, 'KR-17', 'Ch''ungch''ong-namdo\r', 'RE', 121, NULL, NULL, '2184'),
(2242, 'KR-01', 'Cheju-do\r', 'RE', 121, NULL, NULL, '2185'),
(2243, 'KR-03', 'Cholla-bukto\r', 'RE', 121, NULL, NULL, '2186'),
(2244, 'KR-16', 'Cholla-namdo\r', 'RE', 121, NULL, NULL, '2187'),
(2245, 'KR-12', 'Inch''on-jikhalsi\r', 'RE', 121, NULL, NULL, '2188'),
(2246, 'KR-06', 'Kangwon-do\r', 'RE', 121, NULL, NULL, '2189'),
(2247, 'KR-18', 'Kwangju-jikhalsi\r', 'RE', 121, NULL, NULL, '2190'),
(2248, 'KR-13', 'Kyonggi-do\r', 'RE', 121, NULL, NULL, '2191'),
(2249, 'KR-14', 'Kyongsang-bukto\r', 'RE', 121, NULL, NULL, '2192'),
(2250, 'KR-20', 'Kyongsang-namdo\r', 'RE', 121, NULL, NULL, '2193'),
(2251, 'KR-10', 'Pusan-jikhalsi\r', 'RE', 121, NULL, NULL, '2194'),
(2252, 'KR-11', 'Seoul-t''ukpyolsi\r', 'RE', 121, NULL, NULL, '2195'),
(2253, 'KR-15', 'Taegu-jikhalsi\r', 'RE', 121, NULL, NULL, '2196'),
(2254, 'KR-19', 'Taejon-jikhalsi\r', 'RE', 121, NULL, NULL, '2197'),
(2255, 'KR-21', 'Ulsan-gwangyoksi\r', 'RE', 121, NULL, NULL, '2198'),
(2256, 'KW-01', 'Al Ahmadi\r', 'RE', 122, 28.88701600000, 48.00598900000, '2199'),
(2257, 'KW-05', 'Al Jahra\r', 'RE', 122, 29.33200100000, 47.69554900000, '2200'),
(2258, 'KW-02', 'Al Kuwayt\r', 'RE', 122, NULL, NULL, '2201'),
(2259, 'KW-03', 'Hawalli\r', 'RE', 122, 29.32940400000, 48.00393000000, '2202'),
(2260, 'KY-01', 'Creek\r', 'RE', 123, 19.75000000000, -79.76666700000, '2203'),
(2261, 'KY-02', 'Eastern\r', 'RE', 123, NULL, NULL, '2204'),
(2262, 'KY-03', 'Midland\r', 'RE', 123, NULL, NULL, '2205'),
(2263, 'KY-04', 'South Town\r', 'RE', 123, NULL, NULL, '2206'),
(2264, 'KY-05', 'Spot Bay\r', 'RE', 123, NULL, NULL, '2207'),
(2265, 'KY-06', 'Stake Bay\r', 'RE', 123, NULL, NULL, '2208'),
(2266, 'KY-07', 'West End\r', 'RE', 123, NULL, NULL, '2209'),
(2267, 'KY-08', 'Western\r', 'RE', 123, NULL, NULL, '2210'),
(2269, 'KZ-01', 'Almaty\r', 'RE', 124, NULL, NULL, '2212'),
(2270, 'KZ-02', 'Almaty City\r', 'RE', 124, NULL, NULL, '2213'),
(2271, 'KZ-03', 'Aqmola\r', 'RE', 124, NULL, NULL, '2214'),
(2272, 'KZ-05', 'Astana\r', 'RE', 124, NULL, NULL, '2215'),
(2273, 'KZ-06', 'Atyrau\r', 'RE', 124, NULL, NULL, '2216'),
(2274, 'KZ-08', 'Bayqonyr\r', 'RE', 124, 45.86531200000, 63.32514900000, '2217'),
(2275, 'KZ-15', 'East Kazakhstan\r', 'RE', 124, NULL, NULL, '2218'),
(2276, 'KZ-09', 'Mangghystau\r', 'RE', 124, NULL, NULL, '2219'),
(2277, 'KZ-16', 'North Kazakhstan\r', 'RE', 124, NULL, NULL, '2220'),
(2278, 'KZ-11', 'Pavlodar\r', 'RE', 124, NULL, NULL, '2221'),
(2279, 'KZ-12', 'Qaraghandy\r', 'RE', 124, NULL, NULL, '2222'),
(2280, 'KZ-13', 'Qostanay\r', 'RE', 124, NULL, NULL, '2223'),
(2281, 'KZ-14', 'Qyzylorda\r', 'RE', 124, NULL, NULL, '2224'),
(2282, 'KZ-10', 'South Kazakhstan\r', 'RE', 124, NULL, NULL, '2225'),
(2283, 'KZ-07', 'West Kazakhstan\r', 'RE', 124, NULL, NULL, '2226'),
(2284, 'KZ-17', 'Zhambyl\r', 'RE', 124, NULL, NULL, '2227'),
(2285, 'LA-01', 'Attapu\r', 'RE', 125, NULL, NULL, '2228'),
(2286, 'LA-02', 'Champasak\r', 'RE', 125, NULL, NULL, '2229'),
(2287, 'LA-03', 'Houaphan\r', 'RE', 125, NULL, NULL, '2230'),
(2288, 'LA-04', 'Khammouan\r', 'RE', 125, NULL, NULL, '2231'),
(2289, 'LA-05', 'Louang Namtha\r', 'RE', 125, NULL, NULL, '2232'),
(2290, 'LA-17', 'Louangphrabang\r', 'RE', 125, NULL, NULL, '2233'),
(2291, 'LA-07', 'Oudomxai\r', 'RE', 125, NULL, NULL, '2234'),
(2292, 'LA-08', 'Phongsali\r', 'RE', 125, NULL, NULL, '2235'),
(2293, 'LA-09', 'Saravan\r', 'RE', 125, NULL, NULL, '2236'),
(2294, 'LA-10', 'Savannakhet\r', 'RE', 125, NULL, NULL, '2237'),
(2295, 'LA-11', 'Vientiane\r', 'RE', 125, NULL, NULL, '2238'),
(2296, 'LA-13', 'Xaignabouri\r', 'RE', 125, NULL, NULL, '2239'),
(2297, 'LA-14', 'Xiangkhoang\r', 'RE', 125, NULL, NULL, '2240'),
(2298, 'LB-01', 'Beqaa\r', 'RE', 126, NULL, NULL, '2241'),
(2299, 'LB-04', 'Beyrouth\r', 'RE', 126, NULL, NULL, '2242'),
(2300, 'LB-03', 'Liban-Nord\r', 'RE', 126, NULL, NULL, '2243'),
(2301, 'LB-06', 'Liban-Sud\r', 'RE', 126, NULL, NULL, '2244'),
(2302, 'LB-05', 'Mont-Liban\r', 'RE', 126, NULL, NULL, '2245'),
(2303, 'LB-07', 'Nabatiye\r', 'RE', 126, NULL, NULL, '2246'),
(2304, 'LC-01', 'Anse-la-Raye\r', 'RE', 127, NULL, NULL, '2247'),
(2305, 'LC-03', 'Castries\r', 'RE', 127, NULL, NULL, '2248'),
(2306, 'LC-04', 'Choiseul\r', 'RE', 127, NULL, NULL, '2249'),
(2307, 'LC-02', 'Dauphin\r', 'RE', 127, -27.48884000000, 153.01509400000, '2250'),
(2308, 'LC-05', 'Dennery\r', 'RE', 127, 13.91555000000, -60.89183000000, '2251'),
(2309, 'LC-06', 'Gros-Islet\r', 'RE', 127, 14.07784000000, -60.94500000000, '2252'),
(2310, 'LC-07', 'Laborie\r', 'RE', 127, NULL, NULL, '2253'),
(2311, 'LC-08', 'Micoud\r', 'RE', 127, 13.81666700000, -60.91666700000, '2254'),
(2312, 'LC-11', 'Praslin\r', 'RE', 127, NULL, NULL, '2255'),
(2313, 'LC-09', 'Soufriere\r', 'RE', 127, 13.85323000000, -61.05207100000, '2256'),
(2314, 'LC-10', 'Vieux-Fort\r', 'RE', 127, 13.73037000000, -60.94738000000, '2257'),
(2315, 'LI-01', 'Balzers\r', 'RE', 128, NULL, NULL, '2258'),
(2316, 'LI-02', 'Eschen\r', 'RE', 128, NULL, NULL, '2259'),
(2317, 'LI-03', 'Gamprin\r', 'RE', 128, 47.22029800000, 9.50962900000, '2260'),
(2318, 'LI-04', 'Mauren\r', 'RE', 128, NULL, NULL, '2261'),
(2319, 'LI-05', 'Planken\r', 'RE', 128, NULL, NULL, '2262'),
(2320, 'LI-06', 'Ruggell\r', 'RE', 128, NULL, NULL, '2263'),
(2321, 'LI-07', 'Schaan\r', 'RE', 128, NULL, NULL, '2264'),
(2322, 'LI-08', 'Schellenberg\r', 'RE', 128, 47.23088600000, 9.54672900000, '2265'),
(2323, 'LI-09', 'Triesen\r', 'RE', 128, NULL, NULL, '2266'),
(2324, 'LI-10', 'Triesenberg\r', 'RE', 128, NULL, NULL, '2267'),
(2325, 'LI-11', 'Vaduz\r', 'RE', 128, NULL, NULL, '2268'),
(2326, 'LK-01', 'Amparai\r', 'RE', 129, 7.33330000000, 81.61660000000, '2269'),
(2327, 'LK-02', 'Anuradhapura\r', 'RE', 129, 8.30136100000, 80.42649800000, '2270'),
(2328, 'LK-03', 'Badulla\r', 'RE', 129, 6.99350000000, 81.04730000000, '2271'),
(2329, 'LK-04', 'Batticaloa\r', 'RE', 129, 7.70483400000, 81.67705500000, '2272'),
(2330, 'LK-23', 'Colombo\r', 'RE', 129, 6.92148400000, 79.85277900000, '2273'),
(2331, 'LK-06', 'Galle\r', 'RE', 129, 6.03080000000, 80.23870000000, '2274'),
(2332, 'LK-24', 'Gampaha\r', 'RE', 129, 7.08989500000, 79.99941300000, '2275'),
(2333, 'LK-07', 'Hambantota\r', 'RE', 129, 6.12330000000, 81.11740000000, '2276'),
(2334, 'LK-25', 'Jaffna\r', 'RE', 129, 9.66630000000, 80.02030000000, '2277'),
(2335, 'LK-09', 'Kalutara\r', 'RE', 129, 6.58940000000, 79.95730000000, '2278'),
(2336, 'LK-10', 'Kandy\r', 'RE', 129, 7.30160000000, 80.64760000000, '2279'),
(2337, 'LK-11', 'Kegalla\r', 'RE', 129, 7.25460000000, 80.34110000000, '2280'),
(2338, 'LK-12', 'Kurunegala\r', 'RE', 129, 7.48050000000, 80.36640000000, '2281'),
(2339, 'LK-26', 'Mannar\r', 'RE', 129, 8.97250000000, 79.91100000000, '2282'),
(2340, 'LK-14', 'Matale\r', 'RE', 129, 7.44370000000, 80.61140000000, '2283'),
(2341, 'LK-15', 'Matara\r', 'RE', 129, 5.97600000000, 80.42500000000, '2284'),
(2342, 'LK-16', 'Moneragala\r', 'RE', 129, NULL, NULL, '2285'),
(2343, 'LK-27', 'Mullaittivu\r', 'RE', 129, 9.22342100000, 80.79093900000, '2286'),
(2344, 'LK-17', 'Nuwara Eliya\r', 'RE', 129, 6.96580000000, 80.75780000000, '2287'),
(2345, 'LK-18', 'Polonnaruwa\r', 'RE', 129, 7.93285700000, 81.00808700000, '2288'),
(2346, 'LK-19', 'Puttalam\r', 'RE', 129, 8.03339600000, 79.82579000000, '2289'),
(2347, 'LK-20', 'Ratnapura\r', 'RE', 129, 6.68470000000, 80.40360000000, '2290'),
(2348, 'LK-21', 'Trincomalee\r', 'RE', 129, 8.57660000000, 81.23090000000, '2291'),
(2349, 'LK-28', 'Vavuniya\r', 'RE', 129, 8.75616600000, 80.49314100000, '2292'),
(2350, 'LR-01', 'Bong\r', 'RE', 130, 6.61685600000, -9.19971100000, '2293'),
(2351, 'LR-11', 'Grand Bassa\r', 'RE', 130, NULL, NULL, '2294'),
(2352, 'LR-04', 'Grand Cape Mount\r', 'RE', 130, NULL, NULL, '2295'),
(2353, 'LR-02', 'Grand Jide\r', 'RE', 130, NULL, NULL, '2296'),
(2354, 'LR-05', 'Lofa\r', 'RE', 130, NULL, NULL, '2297'),
(2355, 'LR-06', 'Maryland\r', 'RE', 130, 38.90355500000, -76.89690400000, '2298'),
(2356, 'LR-07', 'Monrovia\r', 'RE', 130, 6.30038700000, -10.79573000000, '2299'),
(2357, 'LR-14', 'Montserrado\r', 'RE', 130, NULL, NULL, '2300'),
(2358, 'LR-09', 'Nimba\r', 'RE', 130, 7.50000000000, -8.58333300000, '2301'),
(2359, 'LR-10', 'Sino\r', 'RE', 130, 5.28446700000, -8.94135600000, '2302'),
(2360, 'LS-10', 'Berea\r', 'RE', 131, -29.20000000000, 27.80833300000, '2303'),
(2361, 'LS-11', 'Butha-Buthe\r', 'RE', 131, -28.83080700000, 28.45502500000, '2304'),
(2362, 'LS-12', 'Leribe\r', 'RE', 131, -28.95833300000, 28.10833300000, '2305'),
(2363, 'LS-13', 'Mafeteng\r', 'RE', 131, -29.82243000000, 27.23902000000, '2306'),
(2364, 'LS-14', 'Maseru\r', 'RE', 131, NULL, NULL, '2307'),
(2365, 'LS-15', 'Mohales Hoek\r', 'RE', 131, -30.15852900000, 27.48008900000, '2308'),
(2366, 'LS-16', 'Mokhotlong\r', 'RE', 131, -29.28936000000, 29.06063000000, '2309'),
(2367, 'LS-17', 'Qachas Nek\r', 'RE', 131, -30.12595900000, 28.70241900000, '2310'),
(2368, 'LS-18', 'Quthing\r', 'RE', 131, -30.41144900000, 27.71622100000, '2311'),
(2369, 'LS-19', 'Thaba-Tseka\r', 'RE', 131, -29.62500000000, 28.48401300000, '2312'),
(2370, 'LT-56', 'Alytaus Apskritis\r', 'RE', 132, NULL, NULL, '2313'),
(2371, 'LT-57', 'Kauno Apskritis\r', 'RE', 132, NULL, NULL, '2314'),
(2372, 'LT-58', 'Klaipedos Apskritis\r', 'RE', 132, NULL, NULL, '2315'),
(2373, 'LT-59', 'Marijampoles Apskritis\r', 'RE', 132, NULL, NULL, '2316'),
(2374, 'LT-60', 'Panevezio Apskritis\r', 'RE', 132, NULL, NULL, '2317'),
(2375, 'LT-61', 'Siauliu Apskritis\r', 'RE', 132, NULL, NULL, '2318'),
(2376, 'LT-62', 'Taurages Apskritis\r', 'RE', 132, NULL, NULL, '2319'),
(2377, 'LT-63', 'Telsiu Apskritis\r', 'RE', 132, NULL, NULL, '2320'),
(2378, 'LT-64', 'Utenos Apskritis\r', 'RE', 132, NULL, NULL, '2321'),
(2379, 'LT-65', 'Vilniaus Apskritis\r', 'RE', 132, NULL, NULL, '2322'),
(2380, 'LU-01', 'Diekirch\r', 'RE', 133, NULL, NULL, '2323'),
(2381, 'LU-02', 'Grevenmacher\r', 'RE', 133, NULL, NULL, '2324'),
(2382, 'LU-03', 'Luxembourg\r', 'RE', 133, NULL, NULL, '2325'),
(2384, 'LV-01', 'Aizkraukles\r', 'RE', 134, NULL, NULL, '2327'),
(2385, 'LV-02', 'Aluksnes\r', 'RE', 134, NULL, NULL, '2328'),
(2386, 'LV-03', 'Balvu\r', 'RE', 134, NULL, NULL, '2329'),
(2387, 'LV-04', 'Bauskas\r', 'RE', 134, NULL, NULL, '2330'),
(2388, 'LV-06', 'Daugavpils\r', 'RE', 134, NULL, NULL, '2331'),
(2389, 'LV-08', 'Dobeles\r', 'RE', 134, NULL, NULL, '2332'),
(2390, 'LV-09', 'Gulbenes\r', 'RE', 134, NULL, NULL, '2333'),
(2391, 'LV-11', 'Jelgava\r', 'RE', 134, 56.64841600000, 23.71394100000, '2334'),
(2392, 'LV-12', 'Jelgavas\r', 'RE', 134, NULL, NULL, '2335'),
(2393, 'LV-13', 'Jurmala\r', 'RE', 134, 56.96815400000, 23.77052700000, '2336'),
(2394, 'LV-15', 'Kuldigas\r', 'RE', 134, NULL, NULL, '2337'),
(2395, 'LV-18', 'Limbazu\r', 'RE', 134, NULL, NULL, '2338'),
(2396, 'LV-19', 'Ludzas\r', 'RE', 134, NULL, NULL, '2339'),
(2397, 'LV-20', 'Madonas\r', 'RE', 134, NULL, NULL, '2340'),
(2398, 'LV-21', 'Ogres\r', 'RE', 134, NULL, NULL, '2341'),
(2399, 'LV-22', 'Preilu\r', 'RE', 134, NULL, NULL, '2342'),
(2400, 'LV-25', 'Riga\r', 'RE', 134, NULL, NULL, '2343'),
(2401, 'LV-26', 'Rigas\r', 'RE', 134, NULL, NULL, '2344'),
(2402, 'LV-27', 'Saldus\r', 'RE', 134, NULL, NULL, '2345'),
(2403, 'LV-28', 'Talsu\r', 'RE', 134, NULL, NULL, '2346'),
(2404, 'LV-29', 'Tukuma\r', 'RE', 134, NULL, NULL, '2347'),
(2405, 'LV-30', 'Valkas\r', 'RE', 134, NULL, NULL, '2348'),
(2406, 'LV-31', 'Valmieras\r', 'RE', 134, NULL, NULL, '2349'),
(2407, 'LV-32', 'Ventspils\r', 'RE', 134, NULL, NULL, '2350'),
(2408, 'LY-47', 'Ajdabiya\r', 'RE', 135, 30.10585100000, 20.83609100000, '2351'),
(2409, 'LY-03', 'Al\r', 'RE', 135, 32.65259900000, 14.27167000000, '2352'),
(2410, 'LY-48', 'Al Fatih\r', 'RE', 135, 32.14255100000, 20.88333300000, '2353'),
(2411, 'LY-49', 'Al Jabal al Akhdar\r', 'RE', 135, 32.54438000000, 21.68077500000, '2354'),
(2412, 'LY-05', 'Al Jufrah\r', 'RE', 135, 28.49179600000, 16.67730500000, '2355'),
(2413, 'LY-50', 'Al Khums\r', 'RE', 135, 32.65259900000, 14.27167000000, '2356'),
(2414, 'LY-08', 'Al Kufrah\r', 'RE', 135, 24.13254900000, 23.26859100000, '2357'),
(2415, 'LY-51', 'An Nuqat al Khams\r', 'RE', 135, 32.77500000000, 12.06666600000, '2358'),
(2416, 'LY-13', 'Ash Shati''\r', 'RE', 135, 27.54031500000, 13.98754500000, '2359'),
(2417, 'LY-52', 'Awbari\r', 'RE', 135, 26.67913100000, 12.72949000000, '2360'),
(2418, 'LY-53', 'Az Zawiyah\r', 'RE', 135, 31.98333300000, 24.66666700000, '2361'),
(2419, 'LY-54', 'Banghazi\r', 'RE', 135, NULL, NULL, '2362'),
(2420, 'LY-55', 'Darnah\r', 'RE', 135, 32.75735000000, 22.64550000000, '2363'),
(2421, 'LY-56', 'Ghadamis\r', 'RE', 135, 30.13949500000, 9.48973800000, '2364'),
(2422, 'LY-57', 'Gharyan\r', 'RE', 135, 30.35083400000, 13.10000000000, '2365'),
(2423, 'LY-58', 'Misratah\r', 'RE', 135, NULL, NULL, '2366'),
(2424, 'LY-30', 'Murzuq\r', 'RE', 135, 24.84441600000, 15.75054500000, '2367'),
(2425, 'LY-34', 'Sabha\r', 'RE', 135, NULL, NULL, '2368'),
(2426, 'LY-59', 'Sawfajjin\r', 'RE', 135, 31.27500000000, 14.83363900000, '2369'),
(2427, 'LY-60', 'Surt\r', 'RE', 135, 31.20528000000, 16.58836900000, '2370'),
(2428, 'LY-61', 'Tarabulus\r', 'RE', 135, NULL, NULL, '2371'),
(2429, 'LY-41', 'Tarhunah\r', 'RE', 135, 32.29152800000, 13.56847200000, '2372'),
(2430, 'LY-42', 'Tubruq\r', 'RE', 135, 32.08700000000, 23.96420000000, '2373'),
(2431, 'LY-62', 'Yafran\r', 'RE', 135, 31.67500000000, 12.19930500000, '2374'),
(2432, 'LY-45', 'Zlitan\r', 'RE', 135, 32.37810700000, 14.58333300000, '2375'),
(2433, 'MA-01', 'Agadir\r', 'RE', 136, NULL, NULL, '2376'),
(2434, 'MA-02', 'Al Hoceima\r', 'RE', 136, 35.24929900000, -3.93711200000, '2377'),
(2435, 'MA-03', 'Azilal\r', 'RE', 136, 31.96690000000, -6.56620000000, '2378'),
(2436, 'MA-04', 'Ben Slimane\r', 'RE', 136, 33.62328000000, -7.12064200000, '2379'),
(2437, 'MA-05', 'Beni Mellal\r', 'RE', 136, 32.35020100000, -6.35878700000, '2380'),
(2438, 'MA-06', 'Boulemane\r', 'RE', 136, NULL, NULL, '2381'),
(2439, 'MA-07', 'Casablanca\r', 'RE', 136, NULL, NULL, '2382'),
(2440, 'MA-08', 'Chaouen\r', 'RE', 136, NULL, NULL, '2383'),
(2441, 'MA-09', 'El Jadida\r', 'RE', 136, 33.25590900000, -8.50783000000, '2384'),
(2442, 'MA-10', 'El Kelaa des Srarhna\r', 'RE', 136, NULL, NULL, '2385'),
(2443, 'MA-11', 'Er Rachidia\r', 'RE', 136, 31.94474000000, -4.40060000000, '2386'),
(2444, 'MA-12', 'Essaouira\r', 'RE', 136, NULL, NULL, '2387'),
(2445, 'MA-13', 'Fes\r', 'RE', 136, NULL, NULL, '2388'),
(2446, 'MA-14', 'Figuig\r', 'RE', 136, NULL, NULL, '2389'),
(2447, 'MA-33', 'Guelmim\r', 'RE', 136, NULL, NULL, '2390'),
(2448, 'MA-34', 'Ifrane\r', 'RE', 136, 34.05000000000, -3.76666700000, '2391'),
(2449, 'MA-15', 'Kenitra\r', 'RE', 136, NULL, NULL, '2392'),
(2450, 'MA-16', 'Khemisset\r', 'RE', 136, NULL, NULL, '2393'),
(2451, 'MA-17', 'Khenifra\r', 'RE', 136, 32.93820000000, -5.66740000000, '2394'),
(2452, 'MA-18', 'Khouribga\r', 'RE', 136, 32.88475000000, -6.91615000000, '2395'),
(2453, 'MA-35', 'Laayoune\r', 'RE', 136, 26.85833300000, -13.12500000000, '2396'),
(2454, 'MA-41', 'Larache\r', 'RE', 136, 35.19180000000, -6.15360000000, '2397'),
(2455, 'MA-19', 'Marrakech\r', 'RE', 136, NULL, NULL, '2398'),
(2456, 'MA-20', 'Meknes\r', 'RE', 136, NULL, NULL, '2399'),
(2457, 'MA-21', 'Nador\r', 'RE', 136, NULL, NULL, '2400'),
(2458, 'MA-22', 'Ouarzazate\r', 'RE', 136, 30.91730000000, -6.91911900000, '2401'),
(2459, 'MA-23', 'Oujda\r', 'RE', 136, NULL, NULL, '2402'),
(2460, 'MA-24', 'Rabat-Sale\r', 'RE', 136, NULL, NULL, '2403'),
(2461, 'MA-25', 'Safi\r', 'RE', 136, NULL, NULL, '2404'),
(2462, 'MA-26', 'Settat\r', 'RE', 136, NULL, NULL, '2405'),
(2463, 'MA-38', 'Sidi Kacem\r', 'RE', 136, NULL, NULL, '2406'),
(2464, 'MA-36', 'Tan-Tan\r', 'RE', 136, 28.43264900000, -11.10033000000, '2407'),
(2465, 'MA-27', 'Tanger\r', 'RE', 136, NULL, NULL, '2408'),
(2466, 'MA-37', 'Taounate\r', 'RE', 136, NULL, NULL, '2409'),
(2467, 'MA-39', 'Taroudannt\r', 'RE', 136, NULL, NULL, '2410'),
(2468, 'MA-29', 'Tata\r', 'RE', 136, 29.74280000000, -7.97260000000, '2411'),
(2469, 'MA-30', 'Taza\r', 'RE', 136, 34.22340000000, -4.00690000000, '2412'),
(2470, 'MA-40', 'Tetouan\r', 'RE', 136, NULL, NULL, '2413'),
(2471, 'MA-32', 'Tiznit\r', 'RE', 136, NULL, NULL, '2414'),
(2472, 'MC-01', 'La Condamine\r', 'RE', 137, 43.73466400000, 7.42114300000, '2415'),
(2473, 'MC-02', 'Monaco\r', 'RE', 137, 43.73252900000, 7.41890700000, '2416'),
(2474, 'MC-03', 'Monte-Carlo\r', 'RE', 137, 43.74043900000, 7.42557700000, '2417'),
(2475, 'MD-46', 'Balti\r', 'RE', 138, NULL, NULL, '2418'),
(2476, 'MD-47', 'Cahul\r', 'RE', 138, NULL, NULL, '2419'),
(2477, 'MD-48', 'Chisinau\r', 'RE', 138, NULL, NULL, '2420'),
(2478, 'MD-50', 'Edinet\r', 'RE', 138, NULL, NULL, '2421'),
(2479, 'MD-51', 'Gagauzia\r', 'RE', 138, NULL, NULL, '2422'),
(2480, 'MD-52', 'Lapusna\r', 'RE', 138, NULL, NULL, '2423'),
(2481, 'MD-53', 'Orhei\r', 'RE', 138, NULL, NULL, '2424'),
(2482, 'MD-54', 'Soroca\r', 'RE', 138, NULL, NULL, '2425'),
(2483, 'MD-49', 'Stinga Nistrului\r', 'RE', 138, NULL, NULL, '2426'),
(2484, 'MD-55', 'Tighina\r', 'RE', 138, NULL, NULL, '2427'),
(2485, 'MD-56', 'Ungheni\r', 'RE', 138, NULL, NULL, '2428'),
(2486, 'MG-05', 'Antananarivo\r', 'RE', 141, NULL, NULL, '2429'),
(2487, 'MG-01', 'Antsiranana\r', 'RE', 141, -13.96909000000, 49.16515200000, '2430'),
(2488, 'MG-02', 'Fianarantsoa\r', 'RE', 141, NULL, NULL, '2431'),
(2489, 'MG-03', 'Mahajanga\r', 'RE', 141, NULL, NULL, '2432'),
(2490, 'MG-04', 'Toamasina\r', 'RE', 141, NULL, NULL, '2433'),
(2491, 'MG-06', 'Toliara\r', 'RE', 141, -21.93039500000, 45.29112400000, '2434'),
(2492, 'MK-01', 'Aracinovo\r', 'RE', 143, NULL, NULL, '2435'),
(2493, 'MK-02', 'Bac\r', 'RE', 143, NULL, NULL, '2436'),
(2494, 'MK-03', 'Belcista\r', 'RE', 143, NULL, NULL, '2437'),
(2495, 'MK-04', 'Berovo\r', 'RE', 143, 41.71187100000, 22.86402800000, '2438'),
(2496, 'MK-05', 'Bistrica\r', 'RE', 143, NULL, NULL, '2439'),
(2497, 'MK-06', 'Bitola\r', 'RE', 143, NULL, NULL, '2440'),
(2498, 'MK-07', 'Blatec\r', 'RE', 143, 41.83966100000, 22.59316100000, '2441'),
(2499, 'MK-08', 'Bogdanci\r', 'RE', 143, NULL, NULL, '2442'),
(2500, 'MK-09', 'Bogomila\r', 'RE', 143, 41.59623000000, 21.48348000000, '2443'),
(2501, 'MK-10', 'Bogovinje\r', 'RE', 143, NULL, NULL, '2444'),
(2502, 'MK-11', 'Bosilovo\r', 'RE', 143, NULL, NULL, '2445'),
(2503, 'MK-12', 'Brvenica\r', 'RE', 143, NULL, NULL, '2446'),
(2504, 'MK-13', 'Cair\r', 'RE', 143, NULL, NULL, '2447'),
(2505, 'MK-14', 'Capari\r', 'RE', 143, 41.05000000000, 21.18333300000, '2448'),
(2506, 'MK-15', 'Caska\r', 'RE', 143, NULL, NULL, '2449'),
(2507, 'MK-16', 'Cegrane\r', 'RE', 143, 41.84466200000, 20.99925000000, '2450'),
(2508, 'MK-17', 'Centar\r', 'RE', 143, NULL, NULL, '2451'),
(2509, 'MK-18', 'Centar Zupa\r', 'RE', 143, NULL, NULL, '2452'),
(2510, 'MK-19', 'Cesinovo\r', 'RE', 143, NULL, NULL, '2453'),
(2511, 'MK-20', 'Cucer-Sandevo\r', 'RE', 143, NULL, NULL, '2454'),
(2512, 'MK-21', 'Debar\r', 'RE', 143, 41.52592700000, 20.53673700000, '2455'),
(2513, 'MK-22', 'Delcevo\r', 'RE', 143, NULL, NULL, '2456'),
(2514, 'MK-23', 'Delogozdi\r', 'RE', 143, NULL, NULL, '2457'),
(2515, 'MK-24', 'Demir Hisar\r', 'RE', 143, NULL, NULL, '2458'),
(2516, 'MK-25', 'Demir Kapija\r', 'RE', 143, 41.42438500000, 22.26747500000, '2459'),
(2517, 'MK-26', 'Dobrusevo\r', 'RE', 143, NULL, NULL, '2460'),
(2518, 'MK-27', 'Dolna Banjica\r', 'RE', 143, NULL, NULL, '2461'),
(2519, 'MK-28', 'Dolneni\r', 'RE', 143, 41.42820800000, 21.45471100000, '2462'),
(2520, 'MK-29', 'Dorce Petrov\r', 'RE', 143, NULL, NULL, '2463'),
(2521, 'MK-30', 'Drugovo\r', 'RE', 143, 41.48734200000, 20.93383100000, '2464'),
(2522, 'MK-31', 'Dzepciste\r', 'RE', 143, NULL, NULL, '2465'),
(2523, 'MK-32', 'Gazi Baba\r', 'RE', 143, NULL, NULL, '2466'),
(2524, 'MK-33', 'Gevgelija\r', 'RE', 143, NULL, NULL, '2467'),
(2525, 'MK-34', 'Gostivar\r', 'RE', 143, NULL, NULL, '2468'),
(2526, 'MK-35', 'Gradsko\r', 'RE', 143, NULL, NULL, '2469'),
(2527, 'MK-36', 'Ilinden\r', 'RE', 143, NULL, NULL, '2470'),
(2528, 'MK-37', 'Izvor\r', 'RE', 143, 41.56382200000, 21.68593500000, '2471'),
(2529, 'MK-38', 'Jegunovce\r', 'RE', 143, NULL, NULL, '2472'),
(2530, 'MK-39', 'Kamenjane\r', 'RE', 143, NULL, NULL, '2473'),
(2531, 'MK-40', 'Karbinci\r', 'RE', 143, NULL, NULL, '2474'),
(2532, 'MK-41', 'Karpos\r', 'RE', 143, NULL, NULL, '2475'),
(2533, 'MK-42', 'Kavadarci\r', 'RE', 143, NULL, NULL, '2476'),
(2534, 'MK-43', 'Kicevo\r', 'RE', 143, NULL, NULL, '2477'),
(2535, 'MK-44', 'Kisela Voda\r', 'RE', 143, NULL, NULL, '2478'),
(2536, 'MK-45', 'Klecevce\r', 'RE', 143, NULL, NULL, '2479'),
(2537, 'MK-46', 'Kocani\r', 'RE', 143, NULL, NULL, '2480'),
(2538, 'MK-47', 'Konce\r', 'RE', 143, NULL, NULL, '2481'),
(2539, 'MK-48', 'Kondovo\r', 'RE', 143, NULL, NULL, '2482'),
(2540, 'MK-49', 'Konopiste\r', 'RE', 143, NULL, NULL, '2483'),
(2541, 'MK-50', 'Kosel\r', 'RE', 143, NULL, NULL, '2484'),
(2542, 'MK-51', 'Kratovo\r', 'RE', 143, 42.07766900000, 22.18845400000, '2485'),
(2543, 'MK-52', 'Kriva Palanka\r', 'RE', 143, 42.19801600000, 22.33370100000, '2486'),
(2544, 'MK-53', 'Krivogastani\r', 'RE', 143, 41.34820000000, 21.34119000000, '2487'),
(2545, 'MK-54', 'Krusevo\r', 'RE', 143, 41.37822200000, 21.24931300000, '2488'),
(2546, 'MK-55', 'Kuklis\r', 'RE', 143, NULL, NULL, '2489'),
(2547, 'MK-56', 'Kukurecani\r', 'RE', 143, NULL, NULL, '2490'),
(2548, 'MK-57', 'Kumanovo\r', 'RE', 143, NULL, NULL, '2491'),
(2549, 'MK-58', 'Labunista\r', 'RE', 143, NULL, NULL, '2492'),
(2550, 'MK-59', 'Lipkovo\r', 'RE', 143, 42.14740700000, 21.58919900000, '2493'),
(2551, 'MK-60', 'Lozovo\r', 'RE', 143, NULL, NULL, '2494'),
(2552, 'MK-61', 'Lukovo\r', 'RE', 143, NULL, NULL, '2495'),
(2553, 'MK-62', 'Makedonska Kamenica\r', 'RE', 143, NULL, NULL, '2496'),
(2554, 'MK-63', 'Makedonski Brod\r', 'RE', 143, NULL, NULL, '2497'),
(2555, 'MK-64', 'Mavrovi Anovi\r', 'RE', 143, NULL, NULL, '2498'),
(2556, 'MK-65', 'Meseista\r', 'RE', 143, 41.24319100000, 20.78484000000, '2499'),
(2557, 'MK-66', 'Miravci\r', 'RE', 143, 41.30341100000, 22.43149700000, '2500'),
(2558, 'MK-67', 'Mogila\r', 'RE', 143, 41.11176200000, 21.39306800000, '2501'),
(2559, 'MK-68', 'Murtino\r', 'RE', 143, 41.41939500000, 22.70613200000, '2502'),
(2560, 'MK-69', 'Negotino\r', 'RE', 143, NULL, NULL, '2503'),
(2561, 'MK-70', 'Negotino-Polosko\r', 'RE', 143, NULL, NULL, '2504'),
(2562, 'MK-71', 'Novaci\r', 'RE', 143, 41.04707000000, 21.46995500000, '2505'),
(2563, 'MK-72', 'Novo Selo\r', 'RE', 143, 41.41817800000, 22.87933000000, '2506'),
(2564, 'MK-73', 'Oblesevo\r', 'RE', 143, 41.89201000000, 22.33404900000, '2507'),
(2565, 'MK-74', 'Ohrid\r', 'RE', 143, NULL, NULL, '2508'),
(2566, 'MK-75', 'Orasac\r', 'RE', 143, NULL, NULL, '2509'),
(2567, 'MK-76', 'Orizari\r', 'RE', 143, 41.92578500000, 22.43697900000, '2510'),
(2568, 'MK-77', 'Oslomej\r', 'RE', 143, NULL, NULL, '2511'),
(2569, 'MK-78', 'Pehcevo\r', 'RE', 143, 41.76850900000, 22.90189500000, '2512'),
(2570, 'MK-79', 'Petrovec\r', 'RE', 143, NULL, NULL, '2513'),
(2571, 'MK-80', 'Plasnica\r', 'RE', 143, 41.46260800000, 21.13865100000, '2514'),
(2572, 'MK-81', 'Podares\r', 'RE', 143, NULL, NULL, '2515'),
(2573, 'MK-82', 'Prilep\r', 'RE', 143, NULL, NULL, '2516'),
(2574, 'MK-83', 'Probistip\r', 'RE', 143, NULL, NULL, '2517'),
(2575, 'MK-84', 'Radovis\r', 'RE', 143, NULL, NULL, '2518'),
(2576, 'MK-85', 'Rankovce\r', 'RE', 143, 42.18173400000, 22.12018800000, '2519'),
(2577, 'MK-86', 'Resen\r', 'RE', 143, NULL, NULL, '2520'),
(2578, 'MK-87', 'Rosoman\r', 'RE', 143, NULL, NULL, '2521'),
(2579, 'MK-88', 'Rostusa\r', 'RE', 143, NULL, NULL, '2522'),
(2580, 'MK-89', 'Samokov\r', 'RE', 143, NULL, NULL, '2523'),
(2581, 'MK-90', 'Saraj\r', 'RE', 143, NULL, NULL, '2524'),
(2582, 'MK-91', 'Sipkovica\r', 'RE', 143, NULL, NULL, '2525'),
(2583, 'MK-92', 'Sopiste\r', 'RE', 143, NULL, NULL, '2526'),
(2584, 'MK-93', 'Sopotnica\r', 'RE', 143, 41.29838900000, 21.16424000000, '2527'),
(2585, 'MK-94', 'Srbinovo\r', 'RE', 143, NULL, NULL, '2528'),
(2586, 'MK-96', 'Star Dojran\r', 'RE', 143, NULL, NULL, '2529'),
(2587, 'MK-95', 'Staravina\r', 'RE', 143, 41.09030500000, 21.76040900000, '2530'),
(2588, 'MK-97', 'Staro Nagoricane\r', 'RE', 143, NULL, NULL, '2531'),
(2589, 'MK-98', 'Stip\r', 'RE', 143, NULL, NULL, '2532'),
(2590, 'MK-99', 'Struga\r', 'RE', 143, NULL, NULL, '2533'),
(2591, 'MK-A1', 'Strumica\r', 'RE', 143, NULL, NULL, '2534'),
(2592, 'MK-A2', 'Studenicani\r', 'RE', 143, NULL, NULL, '2535'),
(2593, 'MK-A3', 'Suto Orizari\r', 'RE', 143, NULL, NULL, '2536'),
(2594, 'MK-A4', 'Sveti Nikole\r', 'RE', 143, NULL, NULL, '2537'),
(2595, 'MK-A5', 'Tearce\r', 'RE', 143, 42.10879400000, 21.04622500000, '2538'),
(2596, 'MK-A6', 'Tetovo\r', 'RE', 143, NULL, NULL, '2539'),
(2597, 'MK-A7', 'Topolcani\r', 'RE', 143, NULL, NULL, '2540'),
(2598, 'MK-A8', 'Valandovo\r', 'RE', 143, NULL, NULL, '2541'),
(2599, 'MK-A9', 'Vasilevo\r', 'RE', 143, NULL, NULL, '2542'),
(2600, 'MK-B1', 'Veles\r', 'RE', 143, NULL, NULL, '2543'),
(2601, 'MK-B2', 'Velesta\r', 'RE', 143, 41.24696000000, 20.65213000000, '2544'),
(2602, 'MK-B3', 'Vevcani\r', 'RE', 143, NULL, NULL, '2545'),
(2603, 'MK-B4', 'Vinica\r', 'RE', 143, 41.87984800000, 22.51337700000, '2546'),
(2604, 'MK-B5', 'Vitoliste\r', 'RE', 143, NULL, NULL, '2547'),
(2605, 'MK-B6', 'Vranestica\r', 'RE', 143, NULL, NULL, '2548'),
(2606, 'MK-B7', 'Vrapciste\r', 'RE', 143, NULL, NULL, '2549'),
(2607, 'MK-B8', 'Vratnica\r', 'RE', 143, NULL, NULL, '2550'),
(2608, 'MK-B9', 'Vrutok\r', 'RE', 143, 41.76563000000, 20.82476600000, '2551'),
(2609, 'MK-C1', 'Zajas\r', 'RE', 143, 41.59386800000, 20.95285800000, '2552'),
(2610, 'MK-C2', 'Zelenikovo\r', 'RE', 143, NULL, NULL, '2553'),
(2611, 'MK-C3', 'Zelino\r', 'RE', 143, NULL, NULL, '2554'),
(2612, 'MK-C4', 'Zitose\r', 'RE', 143, NULL, NULL, '2555'),
(2613, 'MK-C5', 'Zletovo\r', 'RE', 143, 41.98148300000, 22.19752200000, '2556'),
(2614, 'MK-C6', 'Zrnovci\r', 'RE', 143, NULL, NULL, '2557'),
(2615, 'ML-01', 'Bamako\r', 'RE', 144, NULL, NULL, '2558'),
(2616, 'ML-09', 'Gao\r', 'RE', 144, 16.26680000000, -0.04269400000, '2559'),
(2617, 'ML-03', 'Kayes\r', 'RE', 144, NULL, NULL, '2560'),
(2618, 'ML-10', 'Kidal\r', 'RE', 144, 18.44430900000, 1.40152300000, '2561'),
(2619, 'ML-07', 'Koulikoro\r', 'RE', 144, 12.86379500000, -7.56968600000, '2562'),
(2620, 'ML-04', 'Mopti\r', 'RE', 144, 14.48039500000, -4.19001500000, '2563'),
(2621, 'ML-05', 'Segou\r', 'RE', 144, 13.43959800000, -6.26846100000, '2564'),
(2622, 'ML-06', 'Sikasso\r', 'RE', 144, 11.31598300000, -5.66968300000, '2565'),
(2623, 'ML-08', 'Tombouctou\r', 'RE', 144, 16.77206000000, -3.00778200000, '2566'),
(2624, 'MM-02', 'Chin State\r', 'RE', 145, NULL, NULL, '2567'),
(2625, 'MM-03', 'Irrawaddy\r', 'RE', 145, NULL, NULL, '2568'),
(2626, 'MM-04', 'Kachin State\r', 'RE', 145, NULL, NULL, '2569'),
(2627, 'MM-05', 'Karan State\r', 'RE', 145, NULL, NULL, '2570'),
(2628, 'MM-06', 'Kayah State\r', 'RE', 145, NULL, NULL, '2571'),
(2629, 'MM-07', 'Magwe\r', 'RE', 145, 20.12530000000, 94.93180000000, '2572'),
(2630, 'MM-08', 'Mandalay\r', 'RE', 145, 21.52669700000, 95.85920600000, '2573'),
(2631, 'MM-13', 'Mon State\r', 'RE', 145, NULL, NULL, '2574'),
(2632, 'MM-09', 'Pegu\r', 'RE', 145, 17.32910000000, 96.49910000000, '2575'),
(2633, 'MM-01', 'Rakhine State\r', 'RE', 145, NULL, NULL, '2576'),
(2634, 'MM-14', 'Rangoon\r', 'RE', 145, 16.86700000000, 96.14190000000, '2577'),
(2635, 'MM-10', 'Sagaing\r', 'RE', 145, 24.47305500000, 95.52068000000, '2578'),
(2636, 'MM-11', 'Shan State\r', 'RE', 145, NULL, NULL, '2579'),
(2637, 'MM-12', 'Tenasserim\r', 'RE', 145, 12.56954500000, 97.85430500000, '2580'),
(2638, 'MM-17', 'Yangon\r', 'RE', 145, NULL, NULL, '2581'),
(2639, 'MN-01', 'Arhangay\r', 'RE', 146, 48.08119300000, 100.95493400000, '2582'),
(2640, 'MN-03', 'Bayan-Olgiy\r', 'RE', 146, 48.20234200000, 89.95168000000, '2583'),
(2641, 'MN-02', 'Bayanhongor\r', 'RE', 146, 45.01666600000, 99.32500000000, '2584'),
(2642, 'MN-21', 'Bulgan\r', 'RE', 146, 48.77965500000, 103.34669900000, '2585'),
(2643, 'MN-05', 'Darhan\r', 'RE', 146, 49.90258000000, 106.17500300000, '2586'),
(2644, 'MN-23', 'Darhan Uul\r', 'RE', 146, NULL, NULL, '2587'),
(2645, 'MN-06', 'Dornod\r', 'RE', 146, 48.26650600000, 115.74531700000, '2588'),
(2646, 'MN-07', 'Dornogovi\r', 'RE', 146, 44.55355000000, 109.86666600000, '2589'),
(2647, 'MN-08', 'Dundgovi\r', 'RE', 146, 45.40000000000, 106.36511400000, '2590'),
(2648, 'MN-09', 'Dzavhan\r', 'RE', 146, 48.28333300000, 96.49279100000, '2591'),
(2649, 'MN-22', 'Erdenet\r', 'RE', 146, 48.98894500000, 104.14041900000, '2592'),
(2650, 'MN-10', 'Govi-Altay\r', 'RE', 146, 46.10096600000, 95.90833300000, '2593'),
(2651, 'MN-24', 'Govi-Sumber\r', 'RE', 146, NULL, NULL, '2594'),
(2652, 'MN-11', 'Hentiy\r', 'RE', 146, 47.78333300000, 110.45806500000, '2595'),
(2653, 'MN-12', 'Hovd\r', 'RE', 146, 47.33726800000, 92.39606300000, '2596'),
(2654, 'MN-13', 'Hovsgol\r', 'RE', 146, 49.97500000000, 99.84166600000, '2597'),
(2655, 'MN-14', 'Omnogovi\r', 'RE', 146, 43.41099300000, 103.74166700000, '2598'),
(2656, 'MN-25', 'Orhon\r', 'RE', 146, NULL, NULL, '2599'),
(2657, 'MN-15', 'Ovorhangay\r', 'RE', 146, 45.79780500000, 102.91796200000, '2600'),
(2658, 'MN-16', 'Selenge\r', 'RE', 146, 49.48947600000, 106.42543400000, '2601'),
(2659, 'MN-17', 'Suhbaatar\r', 'RE', 146, 46.30000000000, 113.57900100000, '2602'),
(2660, 'MN-18', 'Tov\r', 'RE', 146, 47.59899300000, 106.50000000000, '2603'),
(2661, 'MN-20', 'Ulaanbaatar\r', 'RE', 146, NULL, NULL, '2604'),
(2662, 'MN-19', 'Uvs\r', 'RE', 146, 49.71813500000, 92.76679200000, '2605'),
(2663, 'MO-01', 'Ilhas\r', 'RE', 147, NULL, NULL, '2606'),
(2664, 'MO-02', 'Macau\r', 'RE', 147, 22.20187400000, 113.54420200000, '2607'),
(2665, 'MR-07', 'Adrar\r', 'RE', 150, 20.41393500000, -12.46903300000, '2608'),
(2666, 'MR-03', 'Assaba\r', 'RE', 150, 16.13683500000, -11.82893000000, '2609'),
(2667, 'MR-05', 'Brakna\r', 'RE', 150, 16.64238500000, -13.83333300000, '2610'),
(2668, 'MR-08', 'Dakhlet Nouadhibou\r', 'RE', 150, 20.88364000000, -17.04151100000, '2611'),
(2669, 'MR-04', 'Gorgol\r', 'RE', 150, 15.96526500000, -13.09689000000, '2612'),
(2670, 'MR-10', 'Guidimaka\r', 'RE', 150, 15.38333300000, -12.13333300000, '2613'),
(2671, 'MR-01', 'Hodh Ech Chargui\r', 'RE', 150, 16.49166700000, -7.09282900000, '2614'),
(2672, 'MR-02', 'Hodh El Gharbi\r', 'RE', 150, 16.32222100000, -9.67203400000, '2615'),
(2673, 'MR-12', 'Inchiri\r', 'RE', 150, 19.74731100000, -14.39091000000, '2616'),
(2674, 'MR-09', 'Tagant\r', 'RE', 150, 18.15149000000, -10.91290600000, '2617'),
(2675, 'MR-11', 'Tiris Zemmour\r', 'RE', 150, 24.25513100000, -9.24541100000, '2618'),
(2676, 'MR-06', 'Trarza\r', 'RE', 150, NULL, NULL, '2619'),
(2677, 'MS-01', 'Saint Anthony\r', 'RE', 151, NULL, NULL, '2620'),
(2678, 'MS-02', 'Saint Georges\r', 'RE', 151, NULL, NULL, '2621'),
(2679, 'MS-03', 'Saint Peter\r', 'RE', 151, NULL, NULL, '2622'),
(2680, 'MU-21', 'Agalega Islands\r', 'RE', 153, NULL, NULL, '2623'),
(2681, 'MU-12', 'Black River\r', 'RE', 153, NULL, NULL, '2624'),
(2682, 'MU-22', 'Cargados Carajos\r', 'RE', 153, NULL, NULL, '2625'),
(2683, 'MU-13', 'Flacq\r', 'RE', 153, NULL, NULL, '2626'),
(2684, 'MU-14', 'Grand Port\r', 'RE', 153, NULL, NULL, '2627'),
(2685, 'MU-15', 'Moka\r', 'RE', 153, NULL, NULL, '2628'),
(2686, 'MU-16', 'Pamplemousses\r', 'RE', 153, NULL, NULL, '2629'),
(2687, 'MU-17', 'Plaines Wilhems\r', 'RE', 153, NULL, NULL, '2630'),
(2688, 'MU-18', 'Port Louis\r', 'RE', 153, NULL, NULL, '2631'),
(2689, 'MU-19', 'Riviere du Rempart\r', 'RE', 153, NULL, NULL, '2632'),
(2690, 'MU-23', 'Rodrigues\r', 'RE', 153, NULL, NULL, '2633'),
(2691, 'MU-20', 'Savanne\r', 'RE', 153, NULL, NULL, '2634'),
(2692, 'MV-02', 'Aliff\r', 'RE', 154, NULL, NULL, '2635'),
(2693, 'MV-20', 'Baa\r', 'RE', 154, 5.08628700000, 73.00271200000, '2636'),
(2694, 'MV-17', 'Daalu\r', 'RE', 154, NULL, NULL, '2637'),
(2695, 'MV-14', 'Faafu\r', 'RE', 154, 3.16277300000, 72.93702800000, '2638'),
(2696, 'MV-27', 'Gaafu Aliff\r', 'RE', 154, NULL, NULL, '2639'),
(2697, 'MV-28', 'Gaafu Daalu\r', 'RE', 154, NULL, NULL, '2640'),
(2698, 'MV-07', 'Haa Aliff\r', 'RE', 154, NULL, NULL, '2641'),
(2699, 'MV-23', 'Haa Daalu\r', 'RE', 154, NULL, NULL, '2642'),
(2700, 'MV-26', 'Kaafu\r', 'RE', 154, NULL, NULL, '2643'),
(2701, 'MV-05', 'Laamu\r', 'RE', 154, 1.95654500000, 73.40617600000, '2644'),
(2702, 'MV-03', 'Laviyani\r', 'RE', 154, NULL, NULL, '2645'),
(2703, 'MV-12', 'Meemu\r', 'RE', 154, 2.94010400000, 73.50143600000, '2646'),
(2704, 'MV-29', 'Naviyani\r', 'RE', 154, NULL, NULL, '2647'),
(2705, 'MV-25', 'Noonu\r', 'RE', 154, 5.82457300000, 73.30543600000, '2648'),
(2706, 'MV-13', 'Raa\r', 'RE', 154, 5.67105600000, 72.92561400000, '2649'),
(2707, 'MV-01', 'Seenu\r', 'RE', 154, -0.63921900000, 73.15833100000, '2650'),
(2708, 'MV-24', 'Shaviyani\r', 'RE', 154, 6.21095900000, 73.10433900000, '2651'),
(2709, 'MV-08', 'Thaa\r', 'RE', 154, 2.36218200000, 73.13720500000, '2652'),
(2710, 'MV-04', 'Waavu\r', 'RE', 154, NULL, NULL, '2653'),
(2711, 'MW-26', 'Balaka\r', 'RE', 155, -14.98206500000, 34.95803000000, '2654'),
(2712, 'MW-24', 'Blantyre\r', 'RE', 155, NULL, NULL, '2655'),
(2713, 'MW-02', 'Chikwawa\r', 'RE', 155, -16.02433000000, 34.78675100000, '2656'),
(2714, 'MW-03', 'Chiradzulu\r', 'RE', 155, -15.68867000000, 35.11969000000, '2657'),
(2715, 'MW-04', 'Chitipa\r', 'RE', 155, -9.70093900000, 33.27325000000, '2658'),
(2716, 'MW-06', 'Dedza\r', 'RE', 155, -14.38381500000, 34.33599400000, '2659'),
(2717, 'MW-07', 'Dowa\r', 'RE', 155, -13.70331600000, 33.96356600000, '2660'),
(2718, 'MW-08', 'Karonga\r', 'RE', 155, -9.93065700000, 33.93789100000, '2661'),
(2719, 'MW-09', 'Kasungu\r', 'RE', 155, -13.03336600000, 33.48416600000, '2662'),
(2720, 'MW-27', 'Likoma\r', 'RE', 155, -12.06711100000, 34.73415300000, '2663'),
(2721, 'MW-11', 'Lilongwe\r', 'RE', 155, NULL, NULL, '2664'),
(2722, 'MW-28', 'Machinga\r', 'RE', 155, NULL, NULL, '2665'),
(2723, 'MW-12', 'Mangochi\r', 'RE', 155, -14.48333300000, 35.26666700000, '2666'),
(2724, 'MW-13', 'Mchinji\r', 'RE', 155, -13.79977000000, 32.88130500000, '2667'),
(2725, 'MW-29', 'Mulanje\r', 'RE', 155, -16.02361600000, 35.49595000000, '2668'),
(2726, 'MW-25', 'Mwanza\r', 'RE', 155, -15.60510000000, 34.52701400000, '2669'),
(2727, 'MW-15', 'Mzimba\r', 'RE', 155, -11.89743500000, 33.59780900000, '2670'),
(2728, 'MW-17', 'Nkhata Bay\r', 'RE', 155, -11.60700000000, 34.27942000000, '2671'),
(2729, 'MW-18', 'Nkhotakota\r', 'RE', 155, -12.96910000000, 34.26650000000, '2672'),
(2730, 'MW-19', 'Nsanje\r', 'RE', 155, -16.92071000000, 35.26188400000, '2673'),
(2731, 'MW-16', 'Ntcheu\r', 'RE', 155, -14.79680000000, 34.62510000000, '2674'),
(2732, 'MW-20', 'Ntchisi\r', 'RE', 155, -13.35310000000, 33.92110000000, '2675'),
(2733, 'MW-30', 'Phalombe\r', 'RE', 155, -15.80015000000, 35.64646500000, '2676'),
(2734, 'MW-21', 'Rumphi\r', 'RE', 155, -11.01747500000, 33.81485500000, '2677'),
(2735, 'MW-22', 'Salima\r', 'RE', 155, -13.78197000000, 34.45899000000, '2678'),
(2736, 'MW-05', 'Thyolo\r', 'RE', 155, -16.06430000000, 35.13420000000, '2679'),
(2737, 'MW-23', 'Zomba\r', 'RE', 155, NULL, NULL, '2680'),
(2738, 'MX-01', 'Aguascalientes\r', 'RE', 156, NULL, NULL, '2681'),
(2739, 'MX-02', 'Baja California\r', 'RE', 156, NULL, NULL, '2682'),
(2740, 'MX-03', 'Baja California Sur\r', 'RE', 156, NULL, NULL, '2683'),
(2741, 'MX-04', 'Campeche\r', 'RE', 156, NULL, NULL, '2684'),
(2742, 'MX-05', 'Chiapas\r', 'RE', 156, NULL, NULL, '2685'),
(2743, 'MX-06', 'Chihuahua\r', 'RE', 156, NULL, NULL, '2686'),
(2744, 'MX-07', 'Coahuila de Zaragoza\r', 'RE', 156, NULL, NULL, '2687'),
(2745, 'MX-08', 'Colima\r', 'RE', 156, NULL, NULL, '2688'),
(2746, 'MX-09', 'Distrito Federal\r', 'RE', 156, NULL, NULL, '2689'),
(2747, 'MX-10', 'Durango\r', 'RE', 156, NULL, NULL, '2690'),
(2748, 'MX-11', 'Guanajuato\r', 'RE', 156, NULL, NULL, '2691'),
(2749, 'MX-12', 'Guerrero\r', 'RE', 156, NULL, NULL, '2692'),
(2750, 'MX-13', 'Hidalgo\r', 'RE', 156, NULL, NULL, '2693'),
(2751, 'MX-14', 'Jalisco\r', 'RE', 156, NULL, NULL, '2694'),
(2752, 'MX-15', 'Mexico\r', 'RE', 156, NULL, NULL, '2695'),
(2753, 'MX-16', 'Michoacan de Ocampo\r', 'RE', 156, NULL, NULL, '2696'),
(2754, 'MX-17', 'Morelos\r', 'RE', 156, NULL, NULL, '2697'),
(2755, 'MX-18', 'Nayarit\r', 'RE', 156, NULL, NULL, '2698'),
(2756, 'MX-19', 'Nuevo Leon\r', 'RE', 156, NULL, NULL, '2699'),
(2757, 'MX-20', 'Oaxaca\r', 'RE', 156, NULL, NULL, '2700'),
(2758, 'MX-21', 'Puebla\r', 'RE', 156, NULL, NULL, '2701'),
(2759, 'MX-22', 'Queretaro de Arteaga\r', 'RE', 156, NULL, NULL, '2702'),
(2760, 'MX-23', 'Quintana Roo\r', 'RE', 156, NULL, NULL, '2703'),
(2761, 'MX-24', 'San Luis Potosi\r', 'RE', 156, NULL, NULL, '2704'),
(2762, 'MX-25', 'Sinaloa\r', 'RE', 156, NULL, NULL, '2705'),
(2763, 'MX-26', 'Sonora\r', 'RE', 156, NULL, NULL, '2706'),
(2764, 'MX-27', 'Tabasco\r', 'RE', 156, NULL, NULL, '2707'),
(2765, 'MX-28', 'Tamaulipas\r', 'RE', 156, NULL, NULL, '2708'),
(2766, 'MX-29', 'Tlaxcala\r', 'RE', 156, NULL, NULL, '2709'),
(2767, 'MX-30', 'Veracruz-Llave\r', 'RE', 156, NULL, NULL, '2710'),
(2768, 'MX-31', 'Yucatan\r', 'RE', 156, NULL, NULL, '2711'),
(2769, 'MX-32', 'Zacatecas\r', 'RE', 156, NULL, NULL, '2712'),
(2770, 'MY-01', 'Johor\r', 'RE', 157, NULL, NULL, '2713'),
(2771, 'MY-02', 'Kedah\r', 'RE', 157, NULL, NULL, '2714'),
(2772, 'MY-03', 'Kelantan\r', 'RE', 157, NULL, NULL, '2715'),
(2773, 'MY-15', 'Labuan\r', 'RE', 157, NULL, NULL, '2716'),
(2774, 'MY-04', 'Melaka\r', 'RE', 157, NULL, NULL, '2717'),
(2775, 'MY-05', 'Negeri Sembilan\r', 'RE', 157, NULL, NULL, '2718'),
(2776, 'MY-06', 'Pahang\r', 'RE', 157, NULL, NULL, '2719'),
(2777, 'MY-07', 'Perak\r', 'RE', 157, NULL, NULL, '2720'),
(2778, 'MY-08', 'Perlis\r', 'RE', 157, NULL, NULL, '2721'),
(2779, 'MY-09', 'Pulau Pinang\r', 'RE', 157, NULL, NULL, '2722'),
(2780, 'MY-16', 'Sabah\r', 'RE', 157, NULL, NULL, '2723'),
(2781, 'MY-11', 'Sarawak\r', 'RE', 157, NULL, NULL, '2724'),
(2782, 'MY-12', 'Selangor\r', 'RE', 157, NULL, NULL, '2725'),
(2783, 'MY-13', 'Terengganu\r', 'RE', 157, NULL, NULL, '2726'),
(2784, 'MY-14', 'Wilayah Persekutuan\r', 'RE', 157, NULL, NULL, '2727'),
(2785, 'MZ-01', 'Cabo Delgado\r', 'RE', 158, -12.33361200000, 39.38055500000, '2728'),
(2786, 'MZ-02', 'Gaza\r', 'RE', 158, -23.30474700000, 32.89994800000, '2729'),
(2787, 'MZ-03', 'Inhambane\r', 'RE', 158, -23.87167000000, 35.38688000000, '2730'),
(2788, 'MZ-10', 'Manica\r', 'RE', 158, -20.07490000000, 34.71926100000, '2731'),
(2789, 'MZ-04', 'Maputo\r', 'RE', 158, NULL, NULL, '2732'),
(2790, 'MZ-06', 'Nampula\r', 'RE', 158, NULL, NULL, '2733'),
(2791, 'MZ-07', 'Niassa\r', 'RE', 158, NULL, NULL, '2734'),
(2792, 'MZ-05', 'Sofala\r', 'RE', 158, NULL, NULL, '2735'),
(2793, 'MZ-08', 'Tete\r', 'RE', 158, NULL, NULL, '2736'),
(2794, 'MZ-09', 'Zambezia\r', 'RE', 158, NULL, NULL, '2737'),
(2795, 'NA-01', 'Bethanien\r', 'RE', 159, -26.50238000000, 17.16074000000, '2738'),
(2796, 'NA-03', 'Boesmanland\r', 'RE', 159, NULL, NULL, '2739'),
(2797, 'NA-28', 'Caprivi\r', 'RE', 159, NULL, NULL, '2740'),
(2798, 'NA-02', 'Caprivi Oos\r', 'RE', 159, NULL, NULL, '2741'),
(2799, 'NA-22', 'Damaraland\r', 'RE', 159, NULL, NULL, '2742'),
(2800, 'NA-29', 'Erongo\r', 'RE', 159, NULL, NULL, '2743'),
(2801, 'NA-04', 'Gobabis\r', 'RE', 159, -22.50500000000, 18.97028000000, '2744'),
(2802, 'NA-05', 'Grootfontein\r', 'RE', 159, -25.01666700000, 16.75000000000, '2745'),
(2803, 'NA-30', 'Hardap\r', 'RE', 159, NULL, NULL, '2746'),
(2804, 'NA-23', 'Hereroland Oos\r', 'RE', 159, NULL, NULL, '2747'),
(2805, 'NA-24', 'Hereroland Wes\r', 'RE', 159, NULL, NULL, '2748'),
(2806, 'NA-06', 'Kaokoland\r', 'RE', 159, NULL, NULL, '2749'),
(2807, 'NA-31', 'Karas\r', 'RE', 159, NULL, NULL, '2750'),
(2808, 'NA-20', 'Karasburg\r', 'RE', 159, -28.00000000000, 18.71666700000, '2751'),
(2809, 'NA-07', 'Karibib\r', 'RE', 159, -21.93829400000, 15.85231000000, '2752'),
(2810, 'NA-25', 'Kavango\r', 'RE', 159, NULL, NULL, '2753'),
(2811, 'NA-08', 'Keetmanshoop\r', 'RE', 159, -26.57620000000, 18.14660000000, '2754'),
(2812, 'NA-32', 'Kunene\r', 'RE', 159, NULL, NULL, '2755'),
(2813, 'NA-09', 'Luderitz\r', 'RE', 159, -26.67620000000, 15.24680000000, '2756'),
(2814, 'NA-10', 'Maltahohe\r', 'RE', 159, -24.84044000000, 16.97943500000, '2757'),
(2815, 'NA-26', 'Mariental\r', 'RE', 159, -24.62470000000, 17.96100000000, '2758'),
(2816, 'NA-27', 'Namaland\r', 'RE', 159, NULL, NULL, '2759'),
(2817, 'NA-33', 'Ohangwena\r', 'RE', 159, -17.46740900000, 15.89713700000, '2760'),
(2818, 'NA-11', 'Okahandja\r', 'RE', 159, -21.97784900000, 16.90789500000, '2761'),
(2819, 'NA-34', 'Okavango\r', 'RE', 159, NULL, NULL, '2762'),
(2820, 'NA-35', 'Omaheke\r', 'RE', 159, NULL, NULL, '2763'),
(2821, 'NA-12', 'Omaruru\r', 'RE', 159, -21.42582000000, 15.95642000000, '2764'),
(2822, 'NA-36', 'Omusati\r', 'RE', 159, NULL, NULL, '2765'),
(2823, 'NA-37', 'Oshana\r', 'RE', 159, NULL, NULL, '2766'),
(2824, 'NA-38', 'Oshikoto\r', 'RE', 159, NULL, NULL, '2767'),
(2825, 'NA-13', 'Otjiwarongo\r', 'RE', 159, -18.08333300000, 13.08333300000, '2768'),
(2826, 'NA-39', 'Otjozondjupa\r', 'RE', 159, NULL, NULL, '2769'),
(2827, 'NA-14', 'Outjo\r', 'RE', 159, -20.10513500000, 16.14389500000, '2770'),
(2828, 'NA-15', 'Owambo\r', 'RE', 159, NULL, NULL, '2771'),
(2829, 'NA-16', 'Rehoboth\r', 'RE', 159, -23.32160500000, 17.07961900000, '2772'),
(2830, 'NA-17', 'Swakopmund\r', 'RE', 159, -22.67090000000, 14.56860000000, '2773'),
(2831, 'NA-18', 'Tsumeb\r', 'RE', 159, -19.26660000000, 17.73330000000, '2774'),
(2832, 'NA-21', 'Windhoek\r', 'RE', 159, NULL, NULL, '2775'),
(2833, 'NE-01', 'Agadez\r', 'RE', 161, 16.99180000000, 7.98566900000, '2776'),
(2834, 'NE-02', 'Diffa\r', 'RE', 161, 13.31166000000, 12.60946000000, '2777'),
(2835, 'NE-03', 'Dosso\r', 'RE', 161, 13.04794000000, 3.20115500000, '2778'),
(2836, 'NE-04', 'Maradi\r', 'RE', 161, NULL, NULL, '2779'),
(2837, 'NE-05', 'Niamey\r', 'RE', 161, 13.51405000000, 2.10730000000, '2780'),
(2838, 'NE-06', 'Tahoua\r', 'RE', 161, 14.89715000000, 5.26448300000, '2781'),
(2839, 'NE-07', 'Zinder\r', 'RE', 161, 13.79860000000, 8.98910000000, '2782'),
(2840, 'NG-45', 'Abia\r', 'RE', 163, NULL, NULL, '2783'),
(2841, 'NG-11', 'Abuja Capital Territory\r', 'RE', 163, NULL, NULL, '2784'),
(2842, 'NG-35', 'Adamawa\r', 'RE', 163, NULL, NULL, '2785'),
(2843, 'NG-21', 'Akwa Ibom\r', 'RE', 163, NULL, NULL, '2786'),
(2844, 'NG-25', 'Anambra\r', 'RE', 163, NULL, NULL, '2787'),
(2845, 'NG-46', 'Bauchi\r', 'RE', 163, NULL, NULL, '2788'),
(2846, 'NG-52', 'Bayelsa\r', 'RE', 163, NULL, NULL, '2789'),
(2847, 'NG-26', 'Benue\r', 'RE', 163, NULL, NULL, '2790'),
(2848, 'NG-27', 'Borno\r', 'RE', 163, NULL, NULL, '2791'),
(2849, 'NG-22', 'Cross River\r', 'RE', 163, NULL, NULL, '2792'),
(2850, 'NG-36', 'Delta\r', 'RE', 163, NULL, NULL, '2793'),
(2851, 'NG-53', 'Ebonyi\r', 'RE', 163, NULL, NULL, '2794'),
(2852, 'NG-37', 'Edo\r', 'RE', 163, NULL, NULL, '2795'),
(2853, 'NG-54', 'Ekiti\r', 'RE', 163, 7.60000000000, 5.10000000000, '2796'),
(2854, 'NG-47', 'Enugu\r', 'RE', 163, NULL, NULL, '2797'),
(2855, 'NG-55', 'Gombe\r', 'RE', 163, NULL, NULL, '2798'),
(2856, 'NG-28', 'Imo\r', 'RE', 163, NULL, NULL, '2799'),
(2857, 'NG-39', 'Jigawa\r', 'RE', 163, NULL, NULL, '2800'),
(2858, 'NG-23', 'Kaduna\r', 'RE', 163, NULL, NULL, '2801'),
(2859, 'NG-29', 'Kano\r', 'RE', 163, NULL, NULL, '2802'),
(2860, 'NG-24', 'Katsina\r', 'RE', 163, NULL, NULL, '2803'),
(2861, 'NG-40', 'Kebbi\r', 'RE', 163, 12.03333300000, 4.63333300000, '2804'),
(2862, 'NG-41', 'Kogi\r', 'RE', 163, NULL, NULL, '2805'),
(2863, 'NG-30', 'Kwara\r', 'RE', 163, NULL, NULL, '2806'),
(2864, 'NG-05', 'Lagos\r', 'RE', 163, NULL, NULL, '2807'),
(2865, 'NG-56', 'Nassarawa\r', 'RE', 163, NULL, NULL, '2808'),
(2866, 'NG-31', 'Niger\r', 'RE', 163, NULL, NULL, '2809'),
(2867, 'NG-16', 'Ogun\r', 'RE', 163, NULL, NULL, '2810'),
(2868, 'NG-48', 'Ondo\r', 'RE', 163, NULL, NULL, '2811'),
(2869, 'NG-42', 'Osun\r', 'RE', 163, NULL, NULL, '2812'),
(2870, 'NG-32', 'Oyo\r', 'RE', 163, NULL, NULL, '2813'),
(2871, 'NG-49', 'Plateau\r', 'RE', 163, NULL, NULL, '2814'),
(2872, 'NG-50', 'Rivers\r', 'RE', 163, NULL, NULL, '2815'),
(2873, 'NG-51', 'Sokoto\r', 'RE', 163, NULL, NULL, '2816'),
(2874, 'NG-43', 'Taraba\r', 'RE', 163, 8.71666700000, 13.15000000000, '2817'),
(2875, 'NG-44', 'Yobe\r', 'RE', 163, NULL, NULL, '2818'),
(2876, 'NG-57', 'Zamfara\r', 'RE', 163, NULL, NULL, '2819'),
(2877, 'NI-01', 'Boaco\r', 'RE', 164, NULL, NULL, '2820'),
(2878, 'NI-02', 'Carazo\r', 'RE', 164, NULL, NULL, '2821'),
(2879, 'NI-03', 'Chinandega\r', 'RE', 164, NULL, NULL, '2822'),
(2880, 'NI-04', 'Chontales\r', 'RE', 164, 12.13016500000, -85.10038000000, '2823'),
(2881, 'NI-05', 'Esteli\r', 'RE', 164, 13.14704900000, -86.42307600000, '2824'),
(2882, 'NI-06', 'Granada\r', 'RE', 164, NULL, NULL, '2825'),
(2883, 'NI-07', 'Jinotega\r', 'RE', 164, 13.80415300000, -85.54496000000, '2826'),
(2884, 'NI-08', 'Leon\r', 'RE', 164, NULL, NULL, '2827'),
(2885, 'NI-09', 'Madriz\r', 'RE', 164, 13.42718300000, -86.41897800000, '2828'),
(2886, 'NI-10', 'Managua\r', 'RE', 164, NULL, NULL, '2829'),
(2887, 'NI-11', 'Masaya\r', 'RE', 164, NULL, NULL, '2830'),
(2888, 'NI-12', 'Matagalpa\r', 'RE', 164, NULL, NULL, '2831'),
(2889, 'NI-13', 'Nueva Segovia\r', 'RE', 164, 13.77150200000, -86.26941300000, '2832'),
(2890, 'NI-14', 'Rio San Juan\r', 'RE', 164, 11.29400000000, -84.42364900000, '2833'),
(2891, 'NI-15', 'Rivas\r', 'RE', 164, NULL, NULL, '2834'),
(2892, 'NI-16', 'Zelaya\r', 'RE', 164, NULL, NULL, '2835'),
(2893, 'NL-01', 'Drenthe\r', 'RE', 165, NULL, NULL, '2836'),
(2894, 'NL-12', 'Dronten\r', 'RE', 165, 52.52351600000, 5.71788900000, '2837'),
(2895, 'NL-16', 'Flevoland\r', 'RE', 165, NULL, NULL, '2838'),
(2896, 'NL-02', 'Friesland\r', 'RE', 165, NULL, NULL, '2839'),
(2897, 'NL-03', 'Gelderland\r', 'RE', 165, NULL, NULL, '2840'),
(2898, 'NL-04', 'Groningen\r', 'RE', 165, NULL, NULL, '2841'),
(2899, 'NL-14', 'Lelystad\r', 'RE', 165, 52.51000700000, 5.47772300000, '2842'),
(2900, 'NL-05', 'Limburg\r', 'RE', 165, NULL, NULL, '2843'),
(2901, 'NL-06', 'Noord-Brabant\r', 'RE', 165, NULL, NULL, '2844'),
(2902, 'NL-07', 'Noord-Holland\r', 'RE', 165, NULL, NULL, '2845'),
(2903, 'NL-08', 'Overijssel\r', 'RE', 165, 52.48613200000, 6.42529000000, '2846'),
(2904, 'NL-09', 'Utrecht\r', 'RE', 165, NULL, NULL, '2847'),
(2905, 'NL-10', 'Zeeland\r', 'RE', 165, NULL, NULL, '2848'),
(2906, 'NL-11', 'Zuid-Holland\r', 'RE', 165, NULL, NULL, '2849'),
(2907, 'NL-13', 'Zuidelijke IJsselmeerpolders\r', 'RE', 165, NULL, NULL, '2850'),
(2908, 'NO-01', 'Akershus\r', 'RE', 166, NULL, NULL, '2851'),
(2909, 'NO-02', 'Aust-Agder\r', 'RE', 166, NULL, NULL, '2852'),
(2910, 'NO-04', 'Buskerud\r', 'RE', 166, NULL, NULL, '2853'),
(2911, 'NO-05', 'Finnmark\r', 'RE', 166, NULL, NULL, '2854'),
(2912, 'NO-06', 'Hedmark\r', 'RE', 166, NULL, NULL, '2855'),
(2913, 'NO-07', 'Hordaland\r', 'RE', 166, NULL, NULL, '2856'),
(2914, 'NO-08', 'More og Romsdal\r', 'RE', 166, NULL, NULL, '2857'),
(2915, 'NO-10', 'Nord-Trondelag\r', 'RE', 166, NULL, NULL, '2858'),
(2916, 'NO-09', 'Nordland\r', 'RE', 166, NULL, NULL, '2859'),
(2917, 'NO-11', 'Oppland\r', 'RE', 166, NULL, NULL, '2860'),
(2918, 'NO-12', 'Oslo\r', 'RE', 166, NULL, NULL, '2861'),
(2919, 'NO-13', 'Ostfold\r', 'RE', 166, NULL, NULL, '2862'),
(2920, 'NO-14', 'Rogaland\r', 'RE', 166, NULL, NULL, '2863'),
(2921, 'NO-15', 'Sogn og Fjordane\r', 'RE', 166, NULL, NULL, '2864'),
(2922, 'NO-16', 'Sor-Trondelag\r', 'RE', 166, NULL, NULL, '2865'),
(2923, 'NO-17', 'Telemark\r', 'RE', 166, NULL, NULL, '2866'),
(2924, 'NO-18', 'Troms\r', 'RE', 166, NULL, NULL, '2867'),
(2925, 'NO-19', 'Vest-Agder\r', 'RE', 166, NULL, NULL, '2868'),
(2926, 'NO-20', 'Vestfold\r', 'RE', 166, NULL, NULL, '2869'),
(2927, 'NP-01', 'Bagmati\r', 'RE', 167, 27.83010500000, 85.34555200000, '2870'),
(2928, 'NP-02', 'Bheri\r', 'RE', 167, 28.49720600000, 81.72154200000, '2871'),
(2929, 'NP-03', 'Dhawalagiri\r', 'RE', 167, 28.65681000000, 83.53358100000, '2872'),
(2930, 'NP-04', 'Gandaki\r', 'RE', 167, 28.32806600000, 84.31691700000, '2873'),
(2931, 'NP-05', 'Janakpur\r', 'RE', 167, 27.36904300000, 85.94985600000, '2874'),
(2932, 'NP-06', 'Karnali\r', 'RE', 167, 29.57158600000, 82.47281200000, '2875'),
(2933, 'NP-07', 'Kosi\r', 'RE', 167, 27.15545000000, 87.33386600000, '2876'),
(2934, 'NP-08', 'Lumbini\r', 'RE', 167, 27.80250100000, 83.56115200000, '2877'),
(2935, 'NP-09', 'Mahakali\r', 'RE', 167, 29.38610800000, 80.58717700000, '2878'),
(2936, 'NP-10', 'Mechi\r', 'RE', 167, 27.13940300000, 87.83413000000, '2879'),
(2937, 'NP-11', 'Narayani\r', 'RE', 167, 27.31432100000, 84.71537400000, '2880'),
(2938, 'NP-12', 'Rapti\r', 'RE', 167, 28.33731700000, 82.45102700000, '2881'),
(2939, 'NP-13', 'Sagarmatha\r', 'RE', 167, 27.26753300000, 86.65341400000, '2882'),
(2940, 'NP-14', 'Seti\r', 'RE', 167, 29.23290800000, 81.15991500000, '2883'),
(2941, 'NR-01', 'Aiwo\r', 'RE', 168, NULL, NULL, '2884'),
(2942, 'NR-02', 'Anabar\r', 'RE', 168, NULL, NULL, '2885'),
(2943, 'NR-03', 'Anetan\r', 'RE', 168, NULL, NULL, '2886'),
(2944, 'NR-04', 'Anibare\r', 'RE', 168, NULL, NULL, '2887'),
(2945, 'NR-05', 'Baiti\r', 'RE', 168, NULL, NULL, '2888'),
(2946, 'NR-06', 'Boe\r', 'RE', 168, NULL, NULL, '2889'),
(2947, 'NR-07', 'Buada\r', 'RE', 168, NULL, NULL, '2890'),
(2948, 'NR-08', 'Denigomodu\r', 'RE', 168, NULL, NULL, '2891'),
(2949, 'NR-09', 'Ewa\r', 'RE', 168, NULL, NULL, '2892'),
(2950, 'NR-10', 'Ijuw\r', 'RE', 168, NULL, NULL, '2893'),
(2951, 'NR-11', 'Meneng\r', 'RE', 168, NULL, NULL, '2894'),
(2952, 'NR-12', 'Nibok\r', 'RE', 168, NULL, NULL, '2895'),
(2953, 'NR-13', 'Uaboe\r', 'RE', 168, NULL, NULL, '2896'),
(2954, 'NR-14', 'Yaren\r', 'RE', 168, -0.54718900000, 166.91161700000, '2897'),
(2955, 'NZ-01', 'Akaroa\r', 'RE', 170, -43.80603100000, 172.96656800000, '2898'),
(2956, 'NZ-03', 'Amuri\r', 'RE', 170, -43.53744500000, 172.51881400000, '2899'),
(2957, 'NZ-04', 'Ashburton\r', 'RE', 170, -43.90249600000, 171.74932600000, '2900'),
(2958, 'NZ-07', 'Bay of Islands\r', 'RE', 170, -35.18129300000, 174.19920900000, '2901'),
(2959, 'NZ-08', 'Bruce\r', 'RE', 170, -40.75173000000, 175.60440400000, '2902'),
(2960, 'NZ-09', 'Buller\r', 'RE', 170, -41.78452000000, 172.12283000000, '2903'),
(2961, 'NZ-10', 'Chatham Islands\r', 'RE', 170, -44.00428200000, -176.38372000000, '2904'),
(2962, 'NZ-11', 'Cheviot\r', 'RE', 170, -42.81304500000, 173.27398900000, '2905'),
(2963, 'NZ-12', 'Clifton\r', 'RE', 170, -46.45028000000, 168.36782800000, '2906'),
(2964, 'NZ-13', 'Clutha\r', 'RE', 170, -41.24887800000, 174.78856400000, '2907'),
(2965, 'NZ-14', 'Cook\r', 'RE', 170, -41.30143100000, 174.77384000000, '2908'),
(2966, 'NZ-16', 'Dannevirke\r', 'RE', 170, -40.20750800000, 176.10408400000, '2909'),
(2967, 'NZ-17', 'Egmont\r', 'RE', 170, -39.26698200000, 174.05974400000, '2910'),
(2968, 'NZ-18', 'Eketahuna\r', 'RE', 170, -40.64501900000, 175.70310200000, '2911'),
(2969, 'NZ-19', 'Ellesmere\r', 'RE', 170, -43.66389500000, 172.35644400000, '2912'),
(2970, 'NZ-20', 'Eltham\r', 'RE', 170, -39.42971500000, 174.29922200000, '2913'),
(2971, 'NZ-21', 'Eyre\r', 'RE', 170, -43.37961900000, 172.36948300000, '2914'),
(2972, 'NZ-22', 'Featherston\r', 'RE', 170, -41.11702600000, 175.32265100000, '2915');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(2973, 'NZ-24', 'Franklin\r', 'RE', 170, -36.85115300000, 174.74925700000, '2916'),
(2974, 'NZ-26', 'Golden Bay\r', 'RE', 170, -40.68637700000, 172.68703300000, '2917'),
(2975, 'NZ-27', 'Great Barrier Island\r', 'RE', 170, -36.19979300000, 175.42866900000, '2918'),
(2976, 'NZ-28', 'Grey\r', 'RE', 170, -36.86058100000, 174.73462600000, '2919'),
(2977, 'NZ-29', 'Hauraki Plains\r', 'RE', 170, -37.33725200000, 175.45491600000, '2920'),
(2978, 'NZ-30', 'Hawera\r', 'RE', 170, -39.59335400000, 174.27829100000, '2921'),
(2979, 'NZ-31', 'Hawke''s Bay\r', 'RE', 170, -39.50507600000, 177.03010400000, '2922'),
(2980, 'NZ-32', 'Heathcote\r', 'RE', 170, -43.57753300000, 172.70742800000, '2923'),
(2981, 'NZ-D9', 'Hikurangi\r', 'RE', 170, -35.59838600000, 174.28661500000, '2924'),
(2982, 'NZ-33', 'Hobson\r', 'RE', 170, -36.84981400000, 174.76083400000, '2925'),
(2983, 'NZ-34', 'Hokianga\r', 'RE', 170, -35.93535500000, 173.86198800000, '2926'),
(2984, 'NZ-35', 'Horowhenua\r', 'RE', 170, -40.60755100000, 175.25355400000, '2927'),
(2985, 'NZ-D4', 'Hurunui\r', 'RE', 170, -42.88028700000, 172.75090000000, '2928'),
(2986, 'NZ-36', 'Hutt\r', 'RE', 170, -43.52402600000, 171.62063000000, '2929'),
(2987, 'NZ-37', 'Inangahua\r', 'RE', 170, -41.85978300000, 171.94958600000, '2930'),
(2988, 'NZ-38', 'Inglewood\r', 'RE', 170, -39.15598500000, 174.20723000000, '2931'),
(2989, 'NZ-39', 'Kaikoura\r', 'RE', 170, -42.40230600000, 173.68056300000, '2932'),
(2990, 'NZ-40', 'Kairanga\r', 'RE', 170, -40.34820700000, 175.53193800000, '2933'),
(2991, 'NZ-41', 'Kiwitea\r', 'RE', 170, -40.10811400000, 175.72198500000, '2934'),
(2992, 'NZ-43', 'Lake\r', 'RE', 170, -46.01321100000, 170.08040800000, '2935'),
(2993, 'NZ-45', 'Mackenzie\r', 'RE', 170, -44.25796900000, 170.09455400000, '2936'),
(2994, 'NZ-46', 'Malvern\r', 'RE', 170, -45.84612800000, 170.50636400000, '2937'),
(2995, 'NZ-E1', 'Manaia\r', 'RE', 170, -39.55091900000, 174.12486200000, '2938'),
(2996, 'NZ-47', 'Manawatu\r', 'RE', 170, -39.50429900000, 175.64500400000, '2939'),
(2997, 'NZ-48', 'Mangonui\r', 'RE', 170, -34.99210400000, 173.53119300000, '2940'),
(2998, 'NZ-49', 'Maniototo\r', 'RE', 170, -45.19750000000, 170.02836300000, '2941'),
(2999, 'NZ-50', 'Marlborough\r', 'RE', 170, -41.68820200000, 173.51699800000, '2942'),
(3000, 'NZ-51', 'Masterton\r', 'RE', 170, -40.94894900000, 175.66076400000, '2943'),
(3001, 'NZ-52', 'Matamata\r', 'RE', 170, -37.80956500000, 175.77325200000, '2944'),
(3002, 'NZ-53', 'Mount Herbert\r', 'RE', 170, -43.68944700000, 172.74156500000, '2945'),
(3003, 'NZ-54', 'Ohinemuri\r', 'RE', 170, -37.37170200000, 175.67537300000, '2946'),
(3004, 'NZ-55', 'Opotiki\r', 'RE', 170, -38.00420600000, 177.28711500000, '2947'),
(3005, 'NZ-56', 'Oroua\r', 'RE', 170, -40.33236200000, 175.41140900000, '2948'),
(3006, 'NZ-57', 'Otamatea\r', 'RE', 170, -39.90690500000, 175.02155400000, '2949'),
(3007, 'NZ-58', 'Otorohanga\r', 'RE', 170, -38.18405800000, 175.21260600000, '2950'),
(3008, 'NZ-59', 'Oxford\r', 'RE', 170, -43.29908900000, 172.18452500000, '2951'),
(3009, 'NZ-60', 'Pahiatua\r', 'RE', 170, -40.45338100000, 175.84066200000, '2952'),
(3010, 'NZ-61', 'Paparua\r', 'RE', 170, -43.51831300000, 172.44837100000, '2953'),
(3011, 'NZ-63', 'Patea\r', 'RE', 170, -39.75718700000, 174.47666000000, '2954'),
(3012, 'NZ-65', 'Piako\r', 'RE', 170, -37.67882100000, 175.39465500000, '2955'),
(3013, 'NZ-66', 'Pohangina\r', 'RE', 170, -40.17270900000, 175.79370800000, '2956'),
(3014, 'NZ-67', 'Raglan\r', 'RE', 170, -37.80257100000, 174.87260600000, '2957'),
(3015, 'NZ-68', 'Rangiora\r', 'RE', 170, -43.30403800000, 172.59056000000, '2958'),
(3016, 'NZ-69', 'Rangitikei\r', 'RE', 170, -40.34548800000, 175.60294700000, '2959'),
(3017, 'NZ-70', 'Rodney\r', 'RE', 170, -42.52704100000, 172.70342800000, '2960'),
(3018, 'NZ-71', 'Rotorua\r', 'RE', 170, -38.13982600000, 176.24707300000, '2961'),
(3019, 'NZ-E2', 'Runanga\r', 'RE', 170, -42.40066800000, 171.25144300000, '2962'),
(3020, 'NZ-E3', 'Saint Kilda\r', 'RE', 170, -45.90472900000, 170.50305300000, '2963'),
(3021, 'NZ-D5', 'Silverpeaks\r', 'RE', 170, -45.72837400000, 170.46389300000, '2964'),
(3022, 'NZ-72', 'Southland\r', 'RE', 170, -45.46530100000, 167.92599500000, '2965'),
(3023, 'NZ-73', 'Stewart Island\r', 'RE', 170, -47.00000000000, 167.86666700000, '2966'),
(3024, 'NZ-74', 'Stratford\r', 'RE', 170, -39.33774600000, 174.28404500000, '2967'),
(3025, 'NZ-D6', 'Strathallan\r', 'RE', 170, -45.88836500000, 170.50409000000, '2968'),
(3026, 'NZ-76', 'Taranaki\r', 'RE', 170, -39.30020100000, 174.37199400000, '2969'),
(3027, 'NZ-77', 'Taumarunui\r', 'RE', 170, -38.88303300000, 175.26287600000, '2970'),
(3028, 'NZ-78', 'Taupo\r', 'RE', 170, -38.68659400000, 176.06969400000, '2971'),
(3029, 'NZ-79', 'Tauranga\r', 'RE', 170, NULL, NULL, '2972'),
(3030, 'NZ-E4', 'Thames-Coromandel\r', 'RE', 170, -36.95995700000, 175.61324900000, '2973'),
(3031, 'NZ-81', 'Tuapeka\r', 'RE', 170, -45.93612300000, 169.55169100000, '2974'),
(3032, 'NZ-82', 'Vincent\r', 'RE', 170, -36.90008400000, 174.92216800000, '2975'),
(3033, 'NZ-83', 'Waiapu\r', 'RE', 170, -38.00997000000, 178.27219100000, '2976'),
(3034, 'NZ-D8', 'Waiheke\r', 'RE', 170, -36.79504000000, 175.09716500000, '2977'),
(3035, 'NZ-84', 'Waihemo\r', 'RE', 170, -45.32455500000, 170.56991800000, '2978'),
(3036, 'NZ-85', 'Waikato\r', 'RE', 170, -40.62112200000, 172.67887100000, '2979'),
(3037, 'NZ-86', 'Waikohu\r', 'RE', 170, -38.39112500000, 177.71956100000, '2980'),
(3038, 'NZ-88', 'Waimairi\r', 'RE', 170, -43.48042800000, 172.71967900000, '2981'),
(3039, 'NZ-89', 'Waimarino\r', 'RE', 170, -37.04440900000, 174.87020400000, '2982'),
(3040, 'NZ-90', 'Waimate\r', 'RE', 170, -44.73403900000, 171.04649800000, '2983'),
(3041, 'NZ-91', 'Waimate West\r', 'RE', 170, -35.27305900000, 173.90113900000, '2984'),
(3042, 'NZ-92', 'Waimea\r', 'RE', 170, -45.87230600000, 168.68331200000, '2985'),
(3043, 'NZ-93', 'Waipa\r', 'RE', 170, -38.45069800000, 175.39444100000, '2986'),
(3044, 'NZ-95', 'Waipawa\r', 'RE', 170, -39.94254700000, 176.58858700000, '2987'),
(3045, 'NZ-96', 'Waipukurau\r', 'RE', 170, -39.99567300000, 176.55667700000, '2988'),
(3046, 'NZ-97', 'Wairarapa South\r', 'RE', 170, NULL, NULL, '2989'),
(3047, 'NZ-98', 'Wairewa\r', 'RE', 170, -43.76988300000, 172.79536700000, '2990'),
(3048, 'NZ-99', 'Wairoa\r', 'RE', 170, -39.03952700000, 177.42539000000, '2991'),
(3049, 'NZ-A4', 'Waitaki\r', 'RE', 170, -44.93792500000, 171.09713000000, '2992'),
(3050, 'NZ-A6', 'Waitomo\r', 'RE', 170, -38.26091600000, 175.11253300000, '2993'),
(3051, 'NZ-A8', 'Waitotara\r', 'RE', 170, -39.80589000000, 174.73435500000, '2994'),
(3052, 'NZ-E6', 'Wallace\r', 'RE', 170, -36.95069000000, 174.77696700000, '2995'),
(3053, 'NZ-B2', 'Wanganui\r', 'RE', 170, -39.93032600000, 175.04766300000, '2996'),
(3054, 'NZ-E5', 'Waverley\r', 'RE', 170, -39.76103300000, 174.62986100000, '2997'),
(3055, 'NZ-B3', 'Westland\r', 'RE', 170, -45.90238800000, 170.42416700000, '2998'),
(3056, 'NZ-B4', 'Whakatane\r', 'RE', 170, -37.95843400000, 176.98588900000, '2999'),
(3057, 'NZ-A1', 'Whangarei\r', 'RE', 170, -35.72287000000, 174.32268500000, '3000'),
(3058, 'NZ-A2', 'Whangaroa\r', 'RE', 170, -35.05222900000, 173.74194800000, '3001'),
(3059, 'NZ-A3', 'Woodville\r', 'RE', 170, -40.33709400000, 175.86669700000, '3002'),
(3060, 'OM-01', 'Ad Dakhiliyah\r', 'RE', 171, NULL, NULL, '3003'),
(3061, 'OM-02', 'Al Batinah\r', 'RE', 171, NULL, NULL, '3004'),
(3062, 'OM-03', 'Al Wusta\r', 'RE', 171, NULL, NULL, '3005'),
(3063, 'OM-04', 'Ash Sharqiyah\r', 'RE', 171, NULL, NULL, '3006'),
(3064, 'OM-05', 'Az Zahirah\r', 'RE', 171, NULL, NULL, '3007'),
(3065, 'OM-06', 'Masqat\r', 'RE', 171, NULL, NULL, '3008'),
(3066, 'OM-07', 'Musandam\r', 'RE', 171, NULL, NULL, '3009'),
(3067, 'OM-08', 'Zufar\r', 'RE', 171, NULL, NULL, '3010'),
(3068, 'PA-01', 'Bocas del Toro\r', 'RE', 172, NULL, NULL, '3011'),
(3069, 'PA-02', 'Chiriqui\r', 'RE', 172, NULL, NULL, '3012'),
(3070, 'PA-03', 'Cocle\r', 'RE', 172, NULL, NULL, '3013'),
(3071, 'PA-04', 'Colon\r', 'RE', 172, NULL, NULL, '3014'),
(3072, 'PA-05', 'Darien\r', 'RE', 172, NULL, NULL, '3015'),
(3073, 'PA-06', 'Herrera\r', 'RE', 172, 7.85538100000, -80.67739800000, '3016'),
(3074, 'PA-07', 'Los Santos\r', 'RE', 172, NULL, NULL, '3017'),
(3075, 'PA-08', 'Panama\r', 'RE', 172, NULL, NULL, '3018'),
(3076, 'PA-09', 'San Blas\r', 'RE', 172, NULL, NULL, '3019'),
(3077, 'PA-10', 'Veraguas\r', 'RE', 172, NULL, NULL, '3020'),
(3078, 'PE-01', 'Amazonas\r', 'RE', 173, NULL, NULL, '3021'),
(3079, 'PE-02', 'Ancash\r', 'RE', 173, NULL, NULL, '3022'),
(3080, 'PE-03', 'Apurimac\r', 'RE', 173, NULL, NULL, '3023'),
(3081, 'PE-04', 'Arequipa\r', 'RE', 173, NULL, NULL, '3024'),
(3082, 'PE-05', 'Ayacucho\r', 'RE', 173, NULL, NULL, '3025'),
(3083, 'PE-06', 'Cajamarca\r', 'RE', 173, NULL, NULL, '3026'),
(3084, 'PE-07', 'Callao\r', 'RE', 173, NULL, NULL, '3027'),
(3085, 'PE-08', 'Cusco\r', 'RE', 173, NULL, NULL, '3028'),
(3086, 'PE-09', 'Huancavelica\r', 'RE', 173, NULL, NULL, '3029'),
(3087, 'PE-10', 'Huanuco\r', 'RE', 173, NULL, NULL, '3030'),
(3088, 'PE-11', 'Ica\r', 'RE', 173, NULL, NULL, '3031'),
(3089, 'PE-12', 'Junin\r', 'RE', 173, NULL, NULL, '3032'),
(3090, 'PE-13', 'La Libertad\r', 'RE', 173, NULL, NULL, '3033'),
(3091, 'PE-14', 'Lambayeque\r', 'RE', 173, NULL, NULL, '3034'),
(3092, 'PE-15', 'Lima\r', 'RE', 173, NULL, NULL, '3035'),
(3093, 'PE-16', 'Loreto\r', 'RE', 173, NULL, NULL, '3036'),
(3094, 'PE-17', 'Madre de Dios\r', 'RE', 173, NULL, NULL, '3037'),
(3095, 'PE-18', 'Moquegua\r', 'RE', 173, NULL, NULL, '3038'),
(3096, 'PE-19', 'Pasco\r', 'RE', 173, NULL, NULL, '3039'),
(3097, 'PE-20', 'Piura\r', 'RE', 173, NULL, NULL, '3040'),
(3098, 'PE-21', 'Puno\r', 'RE', 173, NULL, NULL, '3041'),
(3099, 'PE-22', 'San Martin\r', 'RE', 173, NULL, NULL, '3042'),
(3100, 'PE-23', 'Tacna\r', 'RE', 173, NULL, NULL, '3043'),
(3101, 'PE-24', 'Tumbes\r', 'RE', 173, NULL, NULL, '3044'),
(3102, 'PE-25', 'Ucayali\r', 'RE', 173, NULL, NULL, '3045'),
(3103, 'PG-01', 'Central\r', 'RE', 175, -9.07821700000, 148.09775300000, '3046'),
(3104, 'PG-08', 'Chimbu\r', 'RE', 175, -6.30067000000, 144.67245000000, '3047'),
(3105, 'PG-10', 'East New Britain\r', 'RE', 175, -5.06980400000, 151.58737900000, '3048'),
(3106, 'PG-11', 'East Sepik\r', 'RE', 175, -4.15643700000, 143.12399700000, '3049'),
(3107, 'PG-09', 'Eastern Highlands\r', 'RE', 175, -6.51200400000, 145.65074700000, '3050'),
(3108, 'PG-19', 'Enga\r', 'RE', 175, -5.46776100000, 143.56790800000, '3051'),
(3109, 'PG-02', 'Gulf\r', 'RE', 175, -7.65354000000, 144.92883000000, '3052'),
(3110, 'PG-12', 'Madang\r', 'RE', 175, -4.99199900000, 145.67383400000, '3053'),
(3111, 'PG-13', 'Manus\r', 'RE', 175, -1.72848400000, 145.51431300000, '3054'),
(3112, 'PG-03', 'Milne Bay\r', 'RE', 175, NULL, NULL, '3055'),
(3113, 'PG-14', 'Morobe\r', 'RE', 175, NULL, NULL, '3056'),
(3114, 'PG-20', 'National Capital\r', 'RE', 175, NULL, NULL, '3057'),
(3115, 'PG-15', 'New Ireland\r', 'RE', 175, -3.08638900000, 151.62053700000, '3058'),
(3116, 'PG-07', 'North Solomons\r', 'RE', 175, NULL, NULL, '3059'),
(3117, 'PG-04', 'Northern\r', 'RE', 175, -8.95150600000, 148.27185200000, '3060'),
(3118, 'PG-18', 'Sandaun\r', 'RE', 175, -3.99700300000, 142.09110300000, '3061'),
(3119, 'PG-05', 'Southern Highlands\r', 'RE', 175, -5.84211300000, 143.49166900000, '3062'),
(3120, 'PG-17', 'West New Britain\r', 'RE', 175, -5.43002800000, 150.07610100000, '3063'),
(3121, 'PG-06', 'Western\r', 'RE', 175, -7.09174300000, 142.38345300000, '3064'),
(3122, 'PG-16', 'Western Highlands\r', 'RE', 175, -5.64508500000, 144.61693200000, '3065'),
(3123, 'PH-01', 'Abra\r', 'RE', 176, NULL, NULL, '3066'),
(3124, 'PH-02', 'Agusan del Norte\r', 'RE', 176, NULL, NULL, '3067'),
(3125, 'PH-03', 'Agusan del Sur\r', 'RE', 176, NULL, NULL, '3068'),
(3126, 'PH-04', 'Aklan\r', 'RE', 176, NULL, NULL, '3069'),
(3127, 'PH-05', 'Albay\r', 'RE', 176, NULL, NULL, '3070'),
(3128, 'PH-A1', 'Angeles\r', 'RE', 176, NULL, NULL, '3071'),
(3129, 'PH-06', 'Antique\r', 'RE', 176, NULL, NULL, '3072'),
(3130, 'PH-G8', 'Aurora\r', 'RE', 176, NULL, NULL, '3073'),
(3131, 'PH-A2', 'Bacolod\r', 'RE', 176, NULL, NULL, '3074'),
(3132, 'PH-A3', 'Bago\r', 'RE', 176, NULL, NULL, '3075'),
(3133, 'PH-A4', 'Baguio\r', 'RE', 176, NULL, NULL, '3076'),
(3134, 'PH-A5', 'Bais\r', 'RE', 176, 9.59524400000, 123.12229900000, '3077'),
(3135, 'PH-22', 'Basilan\r', 'RE', 176, NULL, NULL, '3078'),
(3136, 'PH-A6', 'Basilan City\r', 'RE', 176, NULL, NULL, '3079'),
(3137, 'PH-07', 'Bataan\r', 'RE', 176, NULL, NULL, '3080'),
(3138, 'PH-08', 'Batanes\r', 'RE', 176, NULL, NULL, '3081'),
(3139, 'PH-09', 'Batangas\r', 'RE', 176, NULL, NULL, '3082'),
(3140, 'PH-A7', 'Batangas City\r', 'RE', 176, NULL, NULL, '3083'),
(3141, 'PH-10', 'Benguet\r', 'RE', 176, NULL, NULL, '3084'),
(3142, 'PH-11', 'Bohol\r', 'RE', 176, NULL, NULL, '3085'),
(3143, 'PH-12', 'Bukidnon\r', 'RE', 176, NULL, NULL, '3086'),
(3144, 'PH-13', 'Bulacan\r', 'RE', 176, NULL, NULL, '3087'),
(3145, 'PH-A8', 'Butuan\r', 'RE', 176, NULL, NULL, '3088'),
(3146, 'PH-A9', 'Cabanatuan\r', 'RE', 176, NULL, NULL, '3089'),
(3147, 'PH-B1', 'Cadiz\r', 'RE', 176, NULL, NULL, '3090'),
(3148, 'PH-14', 'Cagayan\r', 'RE', 176, NULL, NULL, '3091'),
(3149, 'PH-B2', 'Cagayan de Oro\r', 'RE', 176, NULL, NULL, '3092'),
(3150, 'PH-B3', 'Calbayog\r', 'RE', 176, NULL, NULL, '3093'),
(3151, 'PH-B4', 'Caloocan\r', 'RE', 176, NULL, NULL, '3094'),
(3152, 'PH-15', 'Camarines Norte\r', 'RE', 176, NULL, NULL, '3095'),
(3153, 'PH-16', 'Camarines Sur\r', 'RE', 176, NULL, NULL, '3096'),
(3154, 'PH-17', 'Camiguin\r', 'RE', 176, NULL, NULL, '3097'),
(3155, 'PH-B5', 'Canlaon\r', 'RE', 176, NULL, NULL, '3098'),
(3156, 'PH-18', 'Capiz\r', 'RE', 176, NULL, NULL, '3099'),
(3157, 'PH-19', 'Catanduanes\r', 'RE', 176, NULL, NULL, '3100'),
(3158, 'PH-20', 'Cavite\r', 'RE', 176, NULL, NULL, '3101'),
(3159, 'PH-B6', 'Cavite City\r', 'RE', 176, NULL, NULL, '3102'),
(3160, 'PH-21', 'Cebu\r', 'RE', 176, NULL, NULL, '3103'),
(3161, 'PH-B7', 'Cebu City\r', 'RE', 176, NULL, NULL, '3104'),
(3162, 'PH-B8', 'Cotabato\r', 'RE', 176, NULL, NULL, '3105'),
(3163, 'PH-B9', 'Dagupan\r', 'RE', 176, 16.03820000000, 120.33719600000, '3106'),
(3164, 'PH-C1', 'Danao\r', 'RE', 176, NULL, NULL, '3107'),
(3165, 'PH-C2', 'Dapitan\r', 'RE', 176, 8.65700500000, 123.43219800000, '3108'),
(3166, 'PH-24', 'Davao\r', 'RE', 176, NULL, NULL, '3109'),
(3167, 'PH-C3', 'Davao City\r', 'RE', 176, NULL, NULL, '3110'),
(3168, 'PH-25', 'Davao del Sur\r', 'RE', 176, NULL, NULL, '3111'),
(3169, 'PH-26', 'Davao Oriental\r', 'RE', 176, NULL, NULL, '3112'),
(3170, 'PH-C4', 'Dipolog\r', 'RE', 176, NULL, NULL, '3113'),
(3171, 'PH-C5', 'Dumaguete\r', 'RE', 176, NULL, NULL, '3114'),
(3172, 'PH-23', 'Eastern Samar\r', 'RE', 176, NULL, NULL, '3115'),
(3173, 'PH-C6', 'General Santos\r', 'RE', 176, NULL, NULL, '3116'),
(3174, 'PH-C7', 'Gingoog\r', 'RE', 176, NULL, NULL, '3117'),
(3175, 'PH-27', 'Ifugao\r', 'RE', 176, NULL, NULL, '3118'),
(3176, 'PH-C8', 'Iligan\r', 'RE', 176, NULL, NULL, '3119'),
(3177, 'PH-28', 'Ilocos Norte\r', 'RE', 176, NULL, NULL, '3120'),
(3178, 'PH-29', 'Ilocos Sur\r', 'RE', 176, NULL, NULL, '3121'),
(3179, 'PH-30', 'Iloilo\r', 'RE', 176, NULL, NULL, '3122'),
(3180, 'PH-C9', 'Iloilo City\r', 'RE', 176, NULL, NULL, '3123'),
(3181, 'PH-D1', 'Iriga\r', 'RE', 176, NULL, NULL, '3124'),
(3182, 'PH-31', 'Isabela\r', 'RE', 176, NULL, NULL, '3125'),
(3183, 'PH-32', 'Kalinga-Apayao\r', 'RE', 176, NULL, NULL, '3126'),
(3184, 'PH-D2', 'La Carlota\r', 'RE', 176, NULL, NULL, '3127'),
(3185, 'PH-36', 'La Union\r', 'RE', 176, NULL, NULL, '3128'),
(3186, 'PH-33', 'Laguna\r', 'RE', 176, NULL, NULL, '3129'),
(3187, 'PH-34', 'Lanao del Norte\r', 'RE', 176, NULL, NULL, '3130'),
(3188, 'PH-35', 'Lanao del Sur\r', 'RE', 176, NULL, NULL, '3131'),
(3189, 'PH-D3', 'Laoag\r', 'RE', 176, NULL, NULL, '3132'),
(3190, 'PH-D4', 'Lapu-Lapu\r', 'RE', 176, NULL, NULL, '3133'),
(3191, 'PH-D5', 'Legaspi\r', 'RE', 176, NULL, NULL, '3134'),
(3192, 'PH-37', 'Leyte\r', 'RE', 176, NULL, NULL, '3135'),
(3193, 'PH-D6', 'Lipa\r', 'RE', 176, NULL, NULL, '3136'),
(3194, 'PH-D7', 'Lucena\r', 'RE', 176, NULL, NULL, '3137'),
(3195, 'PH-56', 'Maguindanao\r', 'RE', 176, NULL, NULL, '3138'),
(3196, 'PH-D8', 'Mandaue\r', 'RE', 176, NULL, NULL, '3139'),
(3197, 'PH-D9', 'Manila\r', 'RE', 176, NULL, NULL, '3140'),
(3198, 'PH-E1', 'Marawi\r', 'RE', 176, NULL, NULL, '3141'),
(3199, 'PH-38', 'Marinduque\r', 'RE', 176, NULL, NULL, '3142'),
(3200, 'PH-39', 'Masbate\r', 'RE', 176, NULL, NULL, '3143'),
(3201, 'PH-40', 'Mindoro Occidental\r', 'RE', 176, NULL, NULL, '3144'),
(3202, 'PH-41', 'Mindoro Oriental\r', 'RE', 176, NULL, NULL, '3145'),
(3203, 'PH-42', 'Misamis Occidental\r', 'RE', 176, NULL, NULL, '3146'),
(3204, 'PH-43', 'Misamis Oriental\r', 'RE', 176, NULL, NULL, '3147'),
(3205, 'PH-44', 'Mountain\r', 'RE', 176, NULL, NULL, '3148'),
(3206, 'PH-E2', 'Naga\r', 'RE', 176, NULL, NULL, '3149'),
(3207, 'PH-H3', 'Negros Occidental\r', 'RE', 176, NULL, NULL, '3150'),
(3208, 'PH-46', 'Negros Oriental\r', 'RE', 176, NULL, NULL, '3151'),
(3209, 'PH-57', 'North Cotabato\r', 'RE', 176, NULL, NULL, '3152'),
(3210, 'PH-67', 'Northern Samar\r', 'RE', 176, NULL, NULL, '3153'),
(3211, 'PH-47', 'Nueva Ecija\r', 'RE', 176, NULL, NULL, '3154'),
(3212, 'PH-48', 'Nueva Vizcaya\r', 'RE', 176, NULL, NULL, '3155'),
(3213, 'PH-E3', 'Olongapo\r', 'RE', 176, NULL, NULL, '3156'),
(3214, 'PH-E4', 'Ormoc\r', 'RE', 176, NULL, NULL, '3157'),
(3215, 'PH-E5', 'Oroquieta\r', 'RE', 176, NULL, NULL, '3158'),
(3216, 'PH-E6', 'Ozamis\r', 'RE', 176, NULL, NULL, '3159'),
(3217, 'PH-E7', 'Pagadian\r', 'RE', 176, 7.82980100000, 123.43710300000, '3160'),
(3218, 'PH-49', 'Palawan\r', 'RE', 176, NULL, NULL, '3161'),
(3219, 'PH-E8', 'Palayan\r', 'RE', 176, NULL, NULL, '3162'),
(3220, 'PH-50', 'Pampanga\r', 'RE', 176, NULL, NULL, '3163'),
(3221, 'PH-51', 'Pangasinan\r', 'RE', 176, NULL, NULL, '3164'),
(3222, 'PH-E9', 'Pasay\r', 'RE', 176, NULL, NULL, '3165'),
(3223, 'PH-F1', 'Puerto Princesa\r', 'RE', 176, NULL, NULL, '3166'),
(3224, 'PH-H2', 'Quezon\r', 'RE', 176, NULL, NULL, '3167'),
(3225, 'PH-F2', 'Quezon City\r', 'RE', 176, NULL, NULL, '3168'),
(3226, 'PH-68', 'Quirino\r', 'RE', 176, NULL, NULL, '3169'),
(3227, 'PH-53', 'Rizal\r', 'RE', 176, NULL, NULL, '3170'),
(3228, 'PH-54', 'Romblon\r', 'RE', 176, NULL, NULL, '3171'),
(3229, 'PH-F3', 'Roxas\r', 'RE', 176, NULL, NULL, '3172'),
(3230, 'PH-55', 'Samar\r', 'RE', 176, NULL, NULL, '3173'),
(3231, 'PH-F4', 'San Carlos\r', 'RE', 176, NULL, NULL, '3174'),
(3232, 'PH-F6', 'San Jose\r', 'RE', 176, 10.75484000000, 121.94429800000, '3175'),
(3233, 'PH-F7', 'San Pablo\r', 'RE', 176, NULL, NULL, '3176'),
(3234, 'PH-F8', 'Silay\r', 'RE', 176, NULL, NULL, '3177'),
(3235, 'PH-69', 'Siquijor\r', 'RE', 176, NULL, NULL, '3178'),
(3236, 'PH-58', 'Sorsogon\r', 'RE', 176, NULL, NULL, '3179'),
(3237, 'PH-70', 'South Cotabato\r', 'RE', 176, NULL, NULL, '3180'),
(3238, 'PH-59', 'Southern Leyte\r', 'RE', 176, NULL, NULL, '3181'),
(3239, 'PH-71', 'Sultan Kudarat\r', 'RE', 176, NULL, NULL, '3182'),
(3240, 'PH-60', 'Sulu\r', 'RE', 176, NULL, NULL, '3183'),
(3241, 'PH-F9', 'Surigao\r', 'RE', 176, NULL, NULL, '3184'),
(3242, 'PH-61', 'Surigao del Norte\r', 'RE', 176, NULL, NULL, '3185'),
(3243, 'PH-62', 'Surigao del Sur\r', 'RE', 176, NULL, NULL, '3186'),
(3244, 'PH-G1', 'Tacloban\r', 'RE', 176, NULL, NULL, '3187'),
(3245, 'PH-G2', 'Tagaytay\r', 'RE', 176, NULL, NULL, '3188'),
(3246, 'PH-G3', 'Tagbilaran\r', 'RE', 176, NULL, NULL, '3189'),
(3247, 'PH-G4', 'Tangub\r', 'RE', 176, 8.06472200000, 123.75019800000, '3190'),
(3248, 'PH-63', 'Tarlac\r', 'RE', 176, NULL, NULL, '3191'),
(3249, 'PH-72', 'Tawitawi\r', 'RE', 176, NULL, NULL, '3192'),
(3250, 'PH-G5', 'Toledo\r', 'RE', 176, NULL, NULL, '3193'),
(3251, 'PH-G6', 'Trece Martires\r', 'RE', 176, NULL, NULL, '3194'),
(3252, 'PH-64', 'Zambales\r', 'RE', 176, NULL, NULL, '3195'),
(3253, 'PH-G7', 'Zamboanga\r', 'RE', 176, NULL, NULL, '3196'),
(3254, 'PH-65', 'Zamboanga del Norte\r', 'RE', 176, NULL, NULL, '3197'),
(3255, 'PH-66', 'Zamboanga del Sur\r', 'RE', 176, NULL, NULL, '3198'),
(3256, 'PK-06', 'Azad Kashmir\r', 'RE', 177, NULL, NULL, '3199'),
(3257, 'PK-02', 'Balochistan\r', 'RE', 177, NULL, NULL, '3200'),
(3258, 'PK-01', 'Federally Administered Tribal Areas\r', 'RE', 177, 33.02546900000, 70.55162800000, '3201'),
(3259, 'PK-08', 'Islamabad\r', 'RE', 177, NULL, NULL, '3202'),
(3260, 'PK-03', 'North-West Frontier\r', 'RE', 177, NULL, NULL, '3203'),
(3261, 'PK-07', 'Northern Areas\r', 'RE', 177, 35.80642100000, 75.19054300000, '3204'),
(3262, 'PK-04', 'Punjab\r', 'RE', 177, NULL, NULL, '3205'),
(3263, 'PK-05', 'Sindh\r', 'RE', 177, NULL, NULL, '3206'),
(3264, 'PL-23', 'Biala Podlaska\r', 'RE', 178, NULL, NULL, '3207'),
(3265, 'PL-24', 'Bialystok\r', 'RE', 178, NULL, NULL, '3208'),
(3266, 'PL-25', 'Bielsko\r', 'RE', 178, NULL, NULL, '3209'),
(3267, 'PL-26', 'Bydgoszcz\r', 'RE', 178, NULL, NULL, '3210'),
(3268, 'PL-27', 'Chelm\r', 'RE', 178, NULL, NULL, '3211'),
(3269, 'PL-28', 'Ciechanow\r', 'RE', 178, NULL, NULL, '3212'),
(3270, 'PL-29', 'Czestochowa\r', 'RE', 178, NULL, NULL, '3213'),
(3271, 'PL-72', 'Dolnoslaskie\r', 'RE', 178, NULL, NULL, '3214'),
(3272, 'PL-30', 'Elblag\r', 'RE', 178, NULL, NULL, '3215'),
(3273, 'PL-31', 'Gdansk\r', 'RE', 178, NULL, NULL, '3216'),
(3274, 'PL-32', 'Gorzow\r', 'RE', 178, NULL, NULL, '3217'),
(3275, 'PL-33', 'Jelenia Gora\r', 'RE', 178, NULL, NULL, '3218'),
(3276, 'PL-34', 'Kalisz\r', 'RE', 178, NULL, NULL, '3219'),
(3277, 'PL-35', 'Katowice\r', 'RE', 178, NULL, NULL, '3220'),
(3278, 'PL-36', 'Kielce\r', 'RE', 178, NULL, NULL, '3221'),
(3279, 'PL-37', 'Konin\r', 'RE', 178, NULL, NULL, '3222'),
(3280, 'PL-38', 'Koszalin\r', 'RE', 178, 54.18999800000, 16.18000000000, '3223'),
(3281, 'PL-39', 'Krakow\r', 'RE', 178, NULL, NULL, '3224'),
(3282, 'PL-40', 'Krosno\r', 'RE', 178, NULL, NULL, '3225'),
(3283, 'PL-73', 'Kujawsko-Pomorskie\r', 'RE', 178, NULL, NULL, '3226'),
(3284, 'PL-41', 'Legnica\r', 'RE', 178, NULL, NULL, '3227'),
(3285, 'PL-42', 'Leszno\r', 'RE', 178, NULL, NULL, '3228'),
(3286, 'PL-43', 'Lodz\r', 'RE', 178, NULL, NULL, '3229'),
(3287, 'PL-74', 'Lodzkie\r', 'RE', 178, NULL, NULL, '3230'),
(3288, 'PL-44', 'Lomza\r', 'RE', 178, NULL, NULL, '3231'),
(3289, 'PL-75', 'Lubelskie\r', 'RE', 178, NULL, NULL, '3232'),
(3290, 'PL-45', 'Lublin\r', 'RE', 178, NULL, NULL, '3233'),
(3291, 'PL-76', 'Lubuskie\r', 'RE', 178, 52.24240500000, 15.48220400000, '3234'),
(3292, 'PL-77', 'Malopolskie\r', 'RE', 178, NULL, NULL, '3235'),
(3293, 'PL-78', 'Mazowieckie\r', 'RE', 178, 52.24786200000, 21.19509900000, '3236'),
(3294, 'PL-46', 'Nowy Sacz\r', 'RE', 178, NULL, NULL, '3237'),
(3295, 'PL-47', 'Olsztyn\r', 'RE', 178, NULL, NULL, '3238'),
(3296, 'PL-48', 'Opole\r', 'RE', 178, NULL, NULL, '3239'),
(3297, 'PL-79', 'Opolskie\r', 'RE', 178, NULL, NULL, '3240'),
(3298, 'PL-49', 'Ostroleka\r', 'RE', 178, NULL, NULL, '3241'),
(3299, 'PL-50', 'Pila\r', 'RE', 178, NULL, NULL, '3242'),
(3300, 'PL-51', 'Piotrkow\r', 'RE', 178, NULL, NULL, '3243'),
(3301, 'PL-52', 'Plock\r', 'RE', 178, NULL, NULL, '3244'),
(3302, 'PL-80', 'Podkarpackie\r', 'RE', 178, 49.90789700000, 22.34830300000, '3245'),
(3303, 'PL-81', 'Podlaskie\r', 'RE', 178, NULL, NULL, '3246'),
(3304, 'PL-82', 'Pomorskie\r', 'RE', 178, NULL, NULL, '3247'),
(3305, 'PL-53', 'Poznan\r', 'RE', 178, NULL, NULL, '3248'),
(3306, 'PL-54', 'Przemysl\r', 'RE', 178, NULL, NULL, '3249'),
(3307, 'PL-55', 'Radom\r', 'RE', 178, NULL, NULL, '3250'),
(3308, 'PL-56', 'Rzeszow\r', 'RE', 178, NULL, NULL, '3251'),
(3309, 'PL-57', 'Siedlce\r', 'RE', 178, NULL, NULL, '3252'),
(3310, 'PL-58', 'Sieradz\r', 'RE', 178, NULL, NULL, '3253'),
(3311, 'PL-59', 'Skierniewice\r', 'RE', 178, NULL, NULL, '3254'),
(3312, 'PL-83', 'Slaskie\r', 'RE', 178, NULL, NULL, '3255'),
(3313, 'PL-60', 'Slupsk\r', 'RE', 178, NULL, NULL, '3256'),
(3314, 'PL-61', 'Suwalki\r', 'RE', 178, NULL, NULL, '3257'),
(3315, 'PL-84', 'Swietokrzyskie\r', 'RE', 178, NULL, NULL, '3258'),
(3316, 'PL-62', 'Szczecin\r', 'RE', 178, 53.43000000000, 14.52999900000, '3259'),
(3317, 'PL-63', 'Tarnobrzeg\r', 'RE', 178, NULL, NULL, '3260'),
(3318, 'PL-64', 'Tarnow\r', 'RE', 178, NULL, NULL, '3261'),
(3319, 'PL-65', 'Torun\r', 'RE', 178, NULL, NULL, '3262'),
(3320, 'PL-66', 'Walbrzych\r', 'RE', 178, NULL, NULL, '3263'),
(3321, 'PL-85', 'Warminsko-Mazurskie\r', 'RE', 178, NULL, NULL, '3264'),
(3322, 'PL-67', 'Warszawa\r', 'RE', 178, NULL, NULL, '3265'),
(3323, 'PL-86', 'Wielkopolskie\r', 'RE', 178, NULL, NULL, '3266'),
(3324, 'PL-68', 'Wloclawek\r', 'RE', 178, NULL, NULL, '3267'),
(3325, 'PL-69', 'Wroclaw\r', 'RE', 178, NULL, NULL, '3268'),
(3326, 'PL-87', 'Zachodniopomorskie\r', 'RE', 178, NULL, NULL, '3269'),
(3327, 'PL-70', 'Zamosc\r', 'RE', 178, NULL, NULL, '3270'),
(3328, 'PL-71', 'Zielona Gora\r', 'RE', 178, NULL, NULL, '3271'),
(3329, 'PT-02', 'Aveiro\r', 'RE', 183, NULL, NULL, '3272'),
(3330, 'PT-23', 'Azores\r', 'RE', 183, NULL, NULL, '3273'),
(3331, 'PT-03', 'Beja\r', 'RE', 183, NULL, NULL, '3274'),
(3332, 'PT-04', 'Braga\r', 'RE', 183, NULL, NULL, '3275'),
(3333, 'PT-05', 'Braganca\r', 'RE', 183, NULL, NULL, '3276'),
(3334, 'PT-06', 'Castelo Branco\r', 'RE', 183, NULL, NULL, '3277'),
(3335, 'PT-07', 'Coimbra\r', 'RE', 183, NULL, NULL, '3278'),
(3336, 'PT-08', 'Evora\r', 'RE', 183, NULL, NULL, '3279'),
(3337, 'PT-09', 'Faro\r', 'RE', 183, NULL, NULL, '3280'),
(3338, 'PT-11', 'Guarda\r', 'RE', 183, NULL, NULL, '3281'),
(3339, 'PT-13', 'Leiria\r', 'RE', 183, NULL, NULL, '3282'),
(3340, 'PT-14', 'Lisboa\r', 'RE', 183, NULL, NULL, '3283'),
(3341, 'PT-10', 'Madeira\r', 'RE', 183, NULL, NULL, '3284'),
(3342, 'PT-16', 'Portalegre\r', 'RE', 183, NULL, NULL, '3285'),
(3343, 'PT-17', 'Porto\r', 'RE', 183, NULL, NULL, '3286'),
(3344, 'PT-18', 'Santarem\r', 'RE', 183, NULL, NULL, '3287'),
(3345, 'PT-19', 'Setubal\r', 'RE', 183, NULL, NULL, '3288'),
(3346, 'PT-20', 'Viana do Castelo\r', 'RE', 183, NULL, NULL, '3289'),
(3347, 'PT-21', 'Vila Real\r', 'RE', 183, NULL, NULL, '3290'),
(3348, 'PT-22', 'Viseu\r', 'RE', 183, NULL, NULL, '3291'),
(3349, 'PY-23', 'Alto Paraguay\r', 'RE', 185, -20.83925000000, -59.86386600000, '3292'),
(3350, 'PY-01', 'Alto Parana\r', 'RE', 185, NULL, NULL, '3293'),
(3351, 'PY-02', 'Amambay\r', 'RE', 185, -22.95641000000, -56.15942500000, '3294'),
(3352, 'PY-03', 'Boqueron\r', 'RE', 185, -21.96838700000, -60.96501500000, '3295'),
(3353, 'PY-04', 'Caaguazu\r', 'RE', 185, -25.46982000000, -56.01535000000, '3296'),
(3354, 'PY-05', 'Caazapa\r', 'RE', 185, -26.15824700000, -56.04756200000, '3297'),
(3355, 'PY-19', 'Canindeyu\r', 'RE', 185, -24.16000300000, -55.21221000000, '3298'),
(3356, 'PY-06', 'Central\r', 'RE', 185, NULL, NULL, '3299'),
(3357, 'PY-20', 'Chaco\r', 'RE', 185, -26.04658100000, -60.89573600000, '3300'),
(3358, 'PY-07', 'Concepcion\r', 'RE', 185, -22.79370900000, -57.05761900000, '3301'),
(3359, 'PY-08', 'Cordillera\r', 'RE', 185, -25.25101000000, -56.99091900000, '3302'),
(3360, 'PY-10', 'Guaira\r', 'RE', 185, -24.07942600000, -54.25741500000, '3303'),
(3361, 'PY-11', 'Itapua\r', 'RE', 185, NULL, NULL, '3304'),
(3362, 'PY-12', 'Misiones\r', 'RE', 185, -26.98553800000, -57.19062600000, '3305'),
(3363, 'PY-13', 'Neembucu\r', 'RE', 185, NULL, NULL, '3306'),
(3364, 'PY-21', 'Nueva Asuncion\r', 'RE', 185, -20.70307000000, -61.92321000000, '3307'),
(3365, 'PY-15', 'Paraguari\r', 'RE', 185, -26.00098900000, -57.14451300000, '3308'),
(3366, 'PY-16', 'Presidente Hayes\r', 'RE', 185, -23.66204700000, -58.96751800000, '3309'),
(3367, 'PY-17', 'San Pedro\r', 'RE', 185, -24.15867600000, -56.63650300000, '3310'),
(3368, 'QA-01', 'Ad Dawhah\r', 'RE', 186, NULL, NULL, '3311'),
(3369, 'QA-02', 'Al Ghuwariyah\r', 'RE', 186, NULL, NULL, '3312'),
(3370, 'QA-03', 'Al Jumaliyah\r', 'RE', 186, NULL, NULL, '3313'),
(3371, 'QA-04', 'Al Khawr\r', 'RE', 186, NULL, NULL, '3314'),
(3372, 'QA-10', 'Al Wakrah\r', 'RE', 186, 25.16650000000, 51.59610000000, '3315'),
(3373, 'QA-06', 'Ar Rayyan\r', 'RE', 186, 25.30271100000, 51.33433500000, '3316'),
(3374, 'QA-11', 'Jariyan al Batnah\r', 'RE', 186, NULL, NULL, '3317'),
(3375, 'QA-08', 'Madinat ach Shamal\r', 'RE', 186, NULL, NULL, '3318'),
(3376, 'QA-12', 'Umm Sa''id\r', 'RE', 186, NULL, NULL, '3319'),
(3377, 'QA-09', 'Umm Salal\r', 'RE', 186, 25.52039000000, 51.36919400000, '3320'),
(3378, 'RO-01', 'Alba\r', 'RE', 188, NULL, NULL, '3321'),
(3379, 'RO-02', 'Arad\r', 'RE', 188, NULL, NULL, '3322'),
(3380, 'RO-03', 'Arges\r', 'RE', 188, NULL, NULL, '3323'),
(3381, 'RO-04', 'Bacau\r', 'RE', 188, NULL, NULL, '3324'),
(3382, 'RO-05', 'Bihor\r', 'RE', 188, NULL, NULL, '3325'),
(3383, 'RO-06', 'Bistrita-Nasaud\r', 'RE', 188, NULL, NULL, '3326'),
(3384, 'RO-07', 'Botosani\r', 'RE', 188, NULL, NULL, '3327'),
(3385, 'RO-08', 'Braila\r', 'RE', 188, NULL, NULL, '3328'),
(3386, 'RO-09', 'Brasov\r', 'RE', 188, NULL, NULL, '3329'),
(3387, 'RO-10', 'Bucuresti\r', 'RE', 188, NULL, NULL, '3330'),
(3388, 'RO-11', 'Buzau\r', 'RE', 188, NULL, NULL, '3331'),
(3389, 'RO-41', 'Calarasi\r', 'RE', 188, NULL, NULL, '3332'),
(3390, 'RO-12', 'Caras-Severin\r', 'RE', 188, NULL, NULL, '3333'),
(3391, 'RO-13', 'Cluj\r', 'RE', 188, NULL, NULL, '3334'),
(3392, 'RO-14', 'Constanta\r', 'RE', 188, NULL, NULL, '3335'),
(3393, 'RO-15', 'Covasna\r', 'RE', 188, NULL, NULL, '3336'),
(3394, 'RO-16', 'Dambovita\r', 'RE', 188, NULL, NULL, '3337'),
(3395, 'RO-17', 'Dolj\r', 'RE', 188, NULL, NULL, '3338'),
(3396, 'RO-18', 'Galati\r', 'RE', 188, NULL, NULL, '3339'),
(3397, 'RO-42', 'Giurgiu\r', 'RE', 188, NULL, NULL, '3340'),
(3398, 'RO-19', 'Gorj\r', 'RE', 188, NULL, NULL, '3341'),
(3399, 'RO-20', 'Harghita\r', 'RE', 188, NULL, NULL, '3342'),
(3400, 'RO-21', 'Hunedoara\r', 'RE', 188, NULL, NULL, '3343'),
(3401, 'RO-22', 'Ialomita\r', 'RE', 188, NULL, NULL, '3344'),
(3402, 'RO-23', 'Iasi\r', 'RE', 188, NULL, NULL, '3345'),
(3403, 'RO-43', 'Ilfov\r', 'RE', 188, NULL, NULL, '3346'),
(3404, 'RO-25', 'Maramures\r', 'RE', 188, NULL, NULL, '3347'),
(3405, 'RO-26', 'Mehedinti\r', 'RE', 188, NULL, NULL, '3348'),
(3406, 'RO-27', 'Mures\r', 'RE', 188, NULL, NULL, '3349'),
(3407, 'RO-28', 'Neamt\r', 'RE', 188, NULL, NULL, '3350'),
(3408, 'RO-29', 'Olt\r', 'RE', 188, NULL, NULL, '3351'),
(3409, 'RO-30', 'Prahova\r', 'RE', 188, NULL, NULL, '3352'),
(3410, 'RO-31', 'Salaj\r', 'RE', 188, NULL, NULL, '3353'),
(3411, 'RO-32', 'Satu Mare\r', 'RE', 188, NULL, NULL, '3354'),
(3412, 'RO-33', 'Sibiu\r', 'RE', 188, NULL, NULL, '3355'),
(3413, 'RO-34', 'Suceava\r', 'RE', 188, NULL, NULL, '3356'),
(3414, 'RO-35', 'Teleorman\r', 'RE', 188, NULL, NULL, '3357'),
(3415, 'RO-36', 'Timis\r', 'RE', 188, NULL, NULL, '3358'),
(3416, 'RO-37', 'Tulcea\r', 'RE', 188, NULL, NULL, '3359'),
(3417, 'RO-39', 'Valcea\r', 'RE', 188, NULL, NULL, '3360'),
(3418, 'RO-38', 'Vaslui\r', 'RE', 188, NULL, NULL, '3361'),
(3419, 'RO-40', 'Vrancea\r', 'RE', 188, NULL, NULL, '3362'),
(3420, 'RU-01', 'Adygeya, Republic of\r', 'RE', 190, NULL, NULL, '3363'),
(3421, 'RU-02', 'Aginsky Buryatsky AO\r', 'RE', 190, NULL, NULL, '3364'),
(3422, 'RU-04', 'Altaisky krai\r', 'RE', 190, NULL, NULL, '3365'),
(3423, 'RU-05', 'Amur\r', 'RE', 190, NULL, NULL, '3366'),
(3424, 'RU-06', 'Arkhangel''sk\r', 'RE', 190, NULL, NULL, '3367'),
(3425, 'RU-07', 'Astrakhan''\r', 'RE', 190, NULL, NULL, '3368'),
(3426, 'RU-08', 'Bashkortostan\r', 'RE', 190, NULL, NULL, '3369'),
(3427, 'RU-09', 'Belgorod\r', 'RE', 190, NULL, NULL, '3370'),
(3428, 'RU-10', 'Bryansk\r', 'RE', 190, NULL, NULL, '3371'),
(3429, 'RU-11', 'Buryat\r', 'RE', 190, NULL, NULL, '3372'),
(3430, 'RU-12', 'Chechnya\r', 'RE', 190, NULL, NULL, '3373'),
(3431, 'RU-13', 'Chelyabinsk\r', 'RE', 190, NULL, NULL, '3374'),
(3432, 'RU-14', 'Chita\r', 'RE', 190, NULL, NULL, '3375'),
(3433, 'RU-15', 'Chukot\r', 'RE', 190, NULL, NULL, '3376'),
(3434, 'RU-16', 'Chuvashia\r', 'RE', 190, NULL, NULL, '3377'),
(3435, 'RU-17', 'Dagestan\r', 'RE', 190, NULL, NULL, '3378'),
(3436, 'RU-18', 'Evenk\r', 'RE', 190, NULL, NULL, '3379'),
(3437, 'RU-03', 'Gorno-Altay\r', 'RE', 190, NULL, NULL, '3380'),
(3438, 'RU-19', 'Ingush\r', 'RE', 190, NULL, NULL, '3381'),
(3439, 'RU-20', 'Irkutsk\r', 'RE', 190, NULL, NULL, '3382'),
(3440, 'RU-21', 'Ivanovo\r', 'RE', 190, NULL, NULL, '3383'),
(3441, 'RU-22', 'Kabardin-Balkar\r', 'RE', 190, NULL, NULL, '3384'),
(3442, 'RU-23', 'Kaliningrad\r', 'RE', 190, NULL, NULL, '3385'),
(3443, 'RU-24', 'Kalmyk\r', 'RE', 190, NULL, NULL, '3386'),
(3444, 'RU-25', 'Kaluga\r', 'RE', 190, NULL, NULL, '3387'),
(3445, 'RU-26', 'Kamchatka\r', 'RE', 190, NULL, NULL, '3388'),
(3446, 'RU-27', 'Karachay-Cherkess\r', 'RE', 190, NULL, NULL, '3389'),
(3447, 'RU-28', 'Karelia\r', 'RE', 190, NULL, NULL, '3390'),
(3448, 'RU-29', 'Kemerovo\r', 'RE', 190, NULL, NULL, '3391'),
(3449, 'RU-30', 'Khabarovsk\r', 'RE', 190, NULL, NULL, '3392'),
(3450, 'RU-31', 'Khakass\r', 'RE', 190, NULL, NULL, '3393'),
(3451, 'RU-32', 'Khanty-Mansiy\r', 'RE', 190, NULL, NULL, '3394'),
(3452, 'RU-33', 'Kirov\r', 'RE', 190, NULL, NULL, '3395'),
(3453, 'RU-34', 'Komi\r', 'RE', 190, NULL, NULL, '3396'),
(3454, 'RU-35', 'Komi-Permyak\r', 'RE', 190, NULL, NULL, '3397'),
(3455, 'RU-36', 'Koryak\r', 'RE', 190, NULL, NULL, '3398'),
(3456, 'RU-37', 'Kostroma\r', 'RE', 190, NULL, NULL, '3399'),
(3457, 'RU-38', 'Krasnodar\r', 'RE', 190, NULL, NULL, '3400'),
(3458, 'RU-39', 'Krasnoyarsk\r', 'RE', 190, NULL, NULL, '3401'),
(3459, 'RU-40', 'Kurgan\r', 'RE', 190, NULL, NULL, '3402'),
(3460, 'RU-41', 'Kursk\r', 'RE', 190, NULL, NULL, '3403'),
(3461, 'RU-42', 'Leningrad\r', 'RE', 190, NULL, NULL, '3404'),
(3462, 'RU-43', 'Lipetsk\r', 'RE', 190, NULL, NULL, '3405'),
(3463, 'RU-44', 'Magadan\r', 'RE', 190, NULL, NULL, '3406'),
(3464, 'RU-45', 'Mariy-El\r', 'RE', 190, NULL, NULL, '3407'),
(3465, 'RU-46', 'Mordovia\r', 'RE', 190, NULL, NULL, '3408'),
(3466, 'RU-48', 'Moscow City\r', 'RE', 190, NULL, NULL, '3409'),
(3467, 'RU-47', 'Moskva\r', 'RE', 190, NULL, NULL, '3410'),
(3468, 'RU-49', 'Murmansk\r', 'RE', 190, NULL, NULL, '3411'),
(3469, 'RU-50', 'Nenets\r', 'RE', 190, NULL, NULL, '3412'),
(3470, 'RU-51', 'Nizhegorod\r', 'RE', 190, NULL, NULL, '3413'),
(3471, 'RU-68', 'North Ossetia\r', 'RE', 190, NULL, NULL, '3414'),
(3472, 'RU-52', 'Novgorod\r', 'RE', 190, NULL, NULL, '3415'),
(3473, 'RU-53', 'Novosibirsk\r', 'RE', 190, NULL, NULL, '3416'),
(3474, 'RU-54', 'Omsk\r', 'RE', 190, NULL, NULL, '3417'),
(3475, 'RU-56', 'Orel\r', 'RE', 190, NULL, NULL, '3418'),
(3476, 'RU-55', 'Orenburg\r', 'RE', 190, NULL, NULL, '3419'),
(3477, 'RU-57', 'Penza\r', 'RE', 190, NULL, NULL, '3420'),
(3478, 'RU-58', 'Perm''\r', 'RE', 190, NULL, NULL, '3421'),
(3479, 'RU-59', 'Primor''ye\r', 'RE', 190, NULL, NULL, '3422'),
(3480, 'RU-60', 'Pskov\r', 'RE', 190, NULL, NULL, '3423'),
(3481, 'RU-61', 'Rostov\r', 'RE', 190, NULL, NULL, '3424'),
(3482, 'RU-62', 'Ryazan''\r', 'RE', 190, NULL, NULL, '3425'),
(3483, 'RU-66', 'Saint Petersburg City\r', 'RE', 190, NULL, NULL, '3426'),
(3484, 'RU-63', 'Sakha\r', 'RE', 190, NULL, NULL, '3427'),
(3485, 'RU-64', 'Sakhalin\r', 'RE', 190, NULL, NULL, '3428'),
(3486, 'RU-65', 'Samara\r', 'RE', 190, NULL, NULL, '3429'),
(3487, 'RU-67', 'Saratov\r', 'RE', 190, NULL, NULL, '3430'),
(3488, 'RU-69', 'Smolensk\r', 'RE', 190, NULL, NULL, '3431'),
(3489, 'RU-70', 'Stavropol''\r', 'RE', 190, NULL, NULL, '3432'),
(3490, 'RU-71', 'Sverdlovsk\r', 'RE', 190, NULL, NULL, '3433'),
(3491, 'RU-72', 'Tambovskaya oblast\r', 'RE', 190, NULL, NULL, '3434'),
(3492, 'RU-73', 'Tatarstan\r', 'RE', 190, NULL, NULL, '3435'),
(3493, 'RU-74', 'Taymyr\r', 'RE', 190, NULL, NULL, '3436'),
(3494, 'RU-75', 'Tomsk\r', 'RE', 190, NULL, NULL, '3437'),
(3495, 'RU-76', 'Tula\r', 'RE', 190, NULL, NULL, '3438'),
(3496, 'RU-79', 'Tuva\r', 'RE', 190, NULL, NULL, '3439'),
(3497, 'RU-77', 'Tver''\r', 'RE', 190, NULL, NULL, '3440'),
(3498, 'RU-78', 'Tyumen''\r', 'RE', 190, NULL, NULL, '3441'),
(3499, 'RU-80', 'Udmurt\r', 'RE', 190, NULL, NULL, '3442'),
(3500, 'RU-81', 'Ul''yanovsk\r', 'RE', 190, NULL, NULL, '3443'),
(3501, 'RU-82', 'Ust-Orda Buryat\r', 'RE', 190, NULL, NULL, '3444'),
(3502, 'RU-83', 'Vladimir\r', 'RE', 190, NULL, NULL, '3445'),
(3503, 'RU-84', 'Volgograd\r', 'RE', 190, NULL, NULL, '3446'),
(3504, 'RU-85', 'Vologda\r', 'RE', 190, NULL, NULL, '3447'),
(3505, 'RU-86', 'Voronezh\r', 'RE', 190, NULL, NULL, '3448'),
(3506, 'RU-87', 'Yamal-Nenets\r', 'RE', 190, NULL, NULL, '3449'),
(3507, 'RU-88', 'Yaroslavl''\r', 'RE', 190, NULL, NULL, '3450'),
(3508, 'RU-89', 'Yevrey\r', 'RE', 190, NULL, NULL, '3451'),
(3509, 'RW-01', 'Butare\r', 'RE', 191, NULL, NULL, '3452'),
(3510, 'RW-02', 'Byumba\r', 'RE', 191, -1.62202300000, 30.12122000000, '3453'),
(3511, 'RW-03', 'Cyangugu\r', 'RE', 191, -2.48680000000, 28.90308700000, '3454'),
(3512, 'RW-04', 'Gikongoro\r', 'RE', 191, -2.50750000000, 29.59540000000, '3455'),
(3513, 'RW-05', 'Gisenyi\r', 'RE', 191, -1.69535000000, 29.26053400000, '3456'),
(3514, 'RW-06', 'Gitarama\r', 'RE', 191, -2.07939600000, 29.75520000000, '3457'),
(3515, 'RW-07', 'Kibungo\r', 'RE', 191, -2.17896100000, 30.54573900000, '3458'),
(3516, 'RW-08', 'Kibuye\r', 'RE', 191, -2.05353900000, 29.37543900000, '3459'),
(3517, 'RW-09', 'Kigali\r', 'RE', 191, NULL, NULL, '3460'),
(3518, 'RW-10', 'Ruhengeri\r', 'RE', 191, -1.50363800000, 29.62855400000, '3461'),
(3519, 'SA-02', 'Al Bahah\r', 'RE', 192, NULL, NULL, '3462'),
(3520, 'SA-15', 'Al Hudud ash Shamaliyah\r', 'RE', 192, 29.80908300000, 41.89076200000, '3463'),
(3521, 'SA-03', 'Al Jawf\r', 'RE', 192, 29.56337600000, 39.87901700000, '3464'),
(3522, 'SA-05', 'Al Madinah\r', 'RE', 192, NULL, NULL, '3465'),
(3523, 'SA-08', 'Al Qasim\r', 'RE', 192, 25.97402500000, 43.11705200000, '3466'),
(3524, 'SA-09', 'Al Qurayyat\r', 'RE', 192, NULL, NULL, '3467'),
(3525, 'SA-10', 'Ar Riyad\r', 'RE', 192, NULL, NULL, '3468'),
(3526, 'SA-06', 'Ash Sharqiyah\r', 'RE', 192, NULL, NULL, '3469'),
(3527, 'SA-13', 'Ha''il\r', 'RE', 192, 27.09187800000, 41.89526100000, '3470'),
(3528, 'SA-17', 'Jizan\r', 'RE', 192, NULL, NULL, '3471'),
(3529, 'SA-14', 'Makkah\r', 'RE', 192, NULL, NULL, '3472'),
(3530, 'SA-16', 'Najran\r', 'RE', 192, 18.20973500000, 45.68290500000, '3473'),
(3531, 'SA-19', 'Tabuk\r', 'RE', 192, 28.15009200000, 37.33449000000, '3474'),
(3532, 'SB-05', 'Central\r', 'RE', 193, NULL, NULL, '3475'),
(3533, 'SB-06', 'Guadalcanal\r', 'RE', 193, -9.59581200000, 160.20898400000, '3476'),
(3534, 'SB-07', 'Isabel\r', 'RE', 193, NULL, NULL, '3477'),
(3535, 'SB-08', 'Makira\r', 'RE', 193, NULL, NULL, '3478'),
(3536, 'SB-03', 'Malaita\r', 'RE', 193, -8.97957300000, 160.97020000000, '3479'),
(3537, 'SB-09', 'Temotu\r', 'RE', 193, NULL, NULL, '3480'),
(3538, 'SB-04', 'Western\r', 'RE', 193, NULL, NULL, '3481'),
(3539, 'SC-01', 'Anse aux Pins\r', 'RE', 194, NULL, NULL, '3482'),
(3540, 'SC-02', 'Anse Boileau\r', 'RE', 194, -4.71370000000, 55.48600000000, '3483'),
(3541, 'SC-03', 'Anse Etoile\r', 'RE', 194, NULL, NULL, '3484'),
(3542, 'SC-04', 'Anse Louis\r', 'RE', 194, NULL, NULL, '3485'),
(3543, 'SC-05', 'Anse Royale\r', 'RE', 194, NULL, NULL, '3486'),
(3544, 'SC-06', 'Baie Lazare\r', 'RE', 194, NULL, NULL, '3487'),
(3545, 'SC-07', 'Baie Sainte Anne\r', 'RE', 194, NULL, NULL, '3488'),
(3546, 'SC-08', 'Beau Vallon\r', 'RE', 194, NULL, NULL, '3489'),
(3547, 'SC-09', 'Bel Air\r', 'RE', 194, NULL, NULL, '3490'),
(3548, 'SC-10', 'Bel Ombre\r', 'RE', 194, NULL, NULL, '3491'),
(3549, 'SC-11', 'Cascade\r', 'RE', 194, NULL, NULL, '3492'),
(3550, 'SC-12', 'Glacis\r', 'RE', 194, NULL, NULL, '3493'),
(3551, 'SC-13', 'Grand'' Anse\r', 'RE', 194, NULL, NULL, '3494'),
(3552, 'SC-15', 'La Digue\r', 'RE', 194, -4.35377300000, 55.83697300000, '3495'),
(3553, 'SC-16', 'La Riviere Anglaise\r', 'RE', 194, NULL, NULL, '3496'),
(3554, 'SC-17', 'Mont Buxton\r', 'RE', 194, NULL, NULL, '3497'),
(3555, 'SC-18', 'Mont Fleuri\r', 'RE', 194, NULL, NULL, '3498'),
(3556, 'SC-19', 'Plaisance\r', 'RE', 194, NULL, NULL, '3499'),
(3557, 'SC-20', 'Pointe La Rue\r', 'RE', 194, NULL, NULL, '3500'),
(3558, 'SC-21', 'Port Glaud\r', 'RE', 194, NULL, NULL, '3501'),
(3559, 'SC-22', 'Saint Louis\r', 'RE', 194, NULL, NULL, '3502'),
(3560, 'SC-23', 'Takamaka\r', 'RE', 194, NULL, NULL, '3503'),
(3561, 'SD-28', 'Al Istiwa''iyah\r', 'RE', 195, NULL, NULL, '3504'),
(3562, 'SD-29', 'Al Khartum\r', 'RE', 195, NULL, NULL, '3505'),
(3563, 'SD-27', 'Al Wusta\r', 'RE', 195, NULL, NULL, '3506'),
(3564, 'SD-30', 'Ash Shamaliyah\r', 'RE', 195, NULL, NULL, '3507'),
(3565, 'SD-31', 'Ash Sharqiyah\r', 'RE', 195, NULL, NULL, '3508'),
(3566, 'SD-32', 'Bahr al Ghazal\r', 'RE', 195, NULL, NULL, '3509'),
(3567, 'SD-33', 'Darfur\r', 'RE', 195, 13.40000000000, 24.00000000000, '3510'),
(3568, 'SD-34', 'Kurdufan\r', 'RE', 195, NULL, NULL, '3511'),
(3569, 'SE-01', 'Alvsborgs Lan\r', 'RE', 196, 56.43757500000, 12.88909700000, '3512'),
(3570, 'SE-02', 'Blekinge Lan\r', 'RE', 196, NULL, NULL, '3513'),
(3571, 'SE-10', 'Dalarnas Lan\r', 'RE', 196, NULL, NULL, '3514'),
(3572, 'SE-03', 'Gavleborgs Lan\r', 'RE', 196, NULL, NULL, '3515'),
(3573, 'SE-04', 'Goteborgs och Bohus Lan\r', 'RE', 196, NULL, NULL, '3516'),
(3574, 'SE-05', 'Gotlands Lan\r', 'RE', 196, NULL, NULL, '3517'),
(3575, 'SE-06', 'Hallands Lan\r', 'RE', 196, NULL, NULL, '3518'),
(3576, 'SE-07', 'Jamtlands Lan\r', 'RE', 196, NULL, NULL, '3519'),
(3577, 'SE-08', 'Jonkopings Lan\r', 'RE', 196, NULL, NULL, '3520'),
(3578, 'SE-09', 'Kalmar Lan\r', 'RE', 196, NULL, NULL, '3521'),
(3579, 'SE-11', 'Kristianstads Lan\r', 'RE', 196, 56.42894500000, 13.11732700000, '3522'),
(3580, 'SE-12', 'Kronobergs Lan\r', 'RE', 196, NULL, NULL, '3523'),
(3581, 'SE-13', 'Malmohus Lan\r', 'RE', 196, 55.60223000000, 12.98727900000, '3524'),
(3582, 'SE-14', 'Norrbottens Lan\r', 'RE', 196, NULL, NULL, '3525'),
(3583, 'SE-15', 'Orebro Lan\r', 'RE', 196, NULL, NULL, '3526'),
(3584, 'SE-16', 'Ostergotlands Lan\r', 'RE', 196, NULL, NULL, '3527'),
(3585, 'SE-27', 'Skane Lan\r', 'RE', 196, NULL, NULL, '3528'),
(3586, 'SE-17', 'Skaraborgs Lan\r', 'RE', 196, 58.38417500000, 13.43691900000, '3529'),
(3587, 'SE-18', 'Sodermanlands Lan\r', 'RE', 196, NULL, NULL, '3530'),
(3588, 'SE-26', 'Stockholms Lan\r', 'RE', 196, NULL, NULL, '3531'),
(3589, 'SE-21', 'Uppsala Lan\r', 'RE', 196, NULL, NULL, '3532'),
(3590, 'SE-22', 'Varmlands Lan\r', 'RE', 196, NULL, NULL, '3533'),
(3591, 'SE-23', 'Vasterbottens Lan\r', 'RE', 196, NULL, NULL, '3534'),
(3592, 'SE-24', 'Vasternorrlands Lan\r', 'RE', 196, NULL, NULL, '3535'),
(3593, 'SE-25', 'Vastmanlands Lan\r', 'RE', 196, NULL, NULL, '3536'),
(3594, 'SE-28', 'Vastra Gotaland\r', 'RE', 196, NULL, NULL, '3537'),
(3595, 'SH-01', 'Ascension\r', 'RE', 198, -7.94010900000, -14.35820800000, '3538'),
(3596, 'SH-02', 'Saint Helena\r', 'RE', 198, NULL, NULL, '3539'),
(3597, 'SH-03', 'Tristan da Cunha\r', 'RE', 198, -37.11362800000, -12.28393400000, '3540'),
(3598, 'SI-01', 'Ajdovscina\r', 'RE', 199, 45.88885000000, 13.90393500000, '3541'),
(3599, 'SI-02', 'Beltinci\r', 'RE', 199, 46.60680000000, 16.24120000000, '3542'),
(3600, 'SI-03', 'Bled\r', 'RE', 199, 46.36831000000, 14.11469000000, '3543'),
(3601, 'SI-04', 'Bohinj\r', 'RE', 199, NULL, NULL, '3544'),
(3602, 'SI-05', 'Borovnica\r', 'RE', 199, 45.92261000000, 14.36275000000, '3545'),
(3603, 'SI-06', 'Bovec\r', 'RE', 199, 46.33694000000, 13.55172000000, '3546'),
(3604, 'SI-07', 'Brda\r', 'RE', 199, 45.44687000000, 13.76288200000, '3547'),
(3605, 'SI-08', 'Brezice\r', 'RE', 199, 45.90252000000, 15.59985000000, '3548'),
(3606, 'SI-09', 'Brezovica\r', 'RE', 199, NULL, NULL, '3549'),
(3607, 'SI-11', 'Celje\r', 'RE', 199, 46.23955000000, 15.26660000000, '3550'),
(3608, 'SI-12', 'Cerklje na Gorenjskem\r', 'RE', 199, NULL, NULL, '3551'),
(3609, 'SI-13', 'Cerknica\r', 'RE', 199, 45.79722000000, 14.36063000000, '3552'),
(3610, 'SI-14', 'Cerkno\r', 'RE', 199, 46.12619000000, 13.98425000000, '3553'),
(3611, 'SI-15', 'Crensovci\r', 'RE', 199, 46.57548000000, 16.28954000000, '3554'),
(3612, 'SI-16', 'Crna na Koroskem\r', 'RE', 199, NULL, NULL, '3555'),
(3613, 'SI-17', 'Crnomelj\r', 'RE', 199, 45.57516000000, 15.19419000000, '3556'),
(3614, 'SI-19', 'Divaca\r', 'RE', 199, 45.68291000000, 13.96974000000, '3557'),
(3615, 'SI-20', 'Dobrepolje\r', 'RE', 199, NULL, NULL, '3558'),
(3616, 'SI-G4', 'Dobrova-Horjul-Polhov Gradec\r', 'RE', 199, 46.05516000000, 14.41665000000, '3559'),
(3617, 'SI-22', 'Dol pri Ljubljani\r', 'RE', 199, NULL, NULL, '3560'),
(3618, 'SI-G7', 'Domzale\r', 'RE', 199, 46.13606000000, 14.59767000000, '3561'),
(3619, 'SI-24', 'Dornava\r', 'RE', 199, 46.43526000000, 15.95499000000, '3562'),
(3620, 'SI-25', 'Dravograd\r', 'RE', 199, 46.59028000000, 15.02837000000, '3563'),
(3621, 'SI-26', 'Duplek\r', 'RE', 199, 46.51439000000, 15.71835000000, '3564'),
(3622, 'SI-27', 'Gorenja Vas-Poljane\r', 'RE', 199, 46.10573000000, 14.14394000000, '3565'),
(3623, 'SI-28', 'Gorisnica\r', 'RE', 199, NULL, NULL, '3566'),
(3624, 'SI-29', 'Gornja Radgona\r', 'RE', 199, 46.67893000000, 15.98880000000, '3567'),
(3625, 'SI-30', 'Gornji Grad\r', 'RE', 199, 46.29534000000, 14.80781000000, '3568'),
(3626, 'SI-31', 'Gornji Petrovci\r', 'RE', 199, NULL, NULL, '3569'),
(3627, 'SI-32', 'Grosuplje\r', 'RE', 199, 45.95653000000, 14.66033000000, '3570'),
(3628, 'SI-34', 'Hrastnik\r', 'RE', 199, 46.14653000000, 15.08450000000, '3571'),
(3629, 'SI-35', 'Hrpelje-Kozina\r', 'RE', 199, 45.60822000000, 13.93432000000, '3572'),
(3630, 'SI-36', 'Idrija\r', 'RE', 199, 45.99968000000, 14.01831000000, '3573'),
(3631, 'SI-37', 'Ig\r', 'RE', 199, 45.95857000000, 14.52719000000, '3574'),
(3632, 'SI-38', 'Ilirska Bistrica\r', 'RE', 199, 45.57012000000, 14.24184000000, '3575'),
(3633, 'SI-39', 'Ivancna Gorica\r', 'RE', 199, NULL, NULL, '3576'),
(3634, 'SI-40', 'Izola-Isola\r', 'RE', 199, NULL, NULL, '3577'),
(3635, 'SI-H4', 'Jesenice\r', 'RE', 199, 46.43431000000, 14.07109000000, '3578'),
(3636, 'SI-42', 'Jursinci\r', 'RE', 199, 46.48496000000, 15.97223000000, '3579'),
(3637, 'SI-H6', 'Kamnik\r', 'RE', 199, 45.95512000000, 14.40879000000, '3580'),
(3638, 'SI-44', 'Kanal\r', 'RE', 199, 46.08530000000, 13.63430000000, '3581'),
(3639, 'SI-45', 'Kidricevo\r', 'RE', 199, NULL, NULL, '3582'),
(3640, 'SI-46', 'Kobarid\r', 'RE', 199, 46.24500500000, 13.57907500000, '3583'),
(3641, 'SI-47', 'Kobilje\r', 'RE', 199, NULL, NULL, '3584'),
(3642, 'SI-H7', 'Kocevje\r', 'RE', 199, 45.64310000000, 14.86070000000, '3585'),
(3643, 'SI-49', 'Komen\r', 'RE', 199, 45.81752000000, 13.74830000000, '3586'),
(3644, 'SI-50', 'Koper-Capodistria\r', 'RE', 199, NULL, NULL, '3587'),
(3645, 'SI-51', 'Kozje\r', 'RE', 199, 46.07299000000, 15.56108000000, '3588'),
(3646, 'SI-52', 'Kranj\r', 'RE', 199, 46.23668000000, 14.35591500000, '3589'),
(3647, 'SI-53', 'Kranjska Gora\r', 'RE', 199, 46.48320000000, 13.78589000000, '3590'),
(3648, 'SI-54', 'Krsko\r', 'RE', 199, 45.95630000000, 15.49155000000, '3591'),
(3649, 'SI-55', 'Kungota\r', 'RE', 199, NULL, NULL, '3592'),
(3650, 'SI-I2', 'Kuzma\r', 'RE', 199, NULL, NULL, '3593'),
(3651, 'SI-57', 'Lasko\r', 'RE', 199, 46.15434000000, 15.23581000000, '3594'),
(3652, 'SI-I3', 'Lenart\r', 'RE', 199, 46.57702000000, 15.83262000000, '3595'),
(3653, 'SI-I5', 'Litija\r', 'RE', 199, 46.05942000000, 14.82245000000, '3596'),
(3654, 'SI-61', 'Ljubljana\r', 'RE', 199, 46.05456000000, 14.50443000000, '3597'),
(3655, 'SI-62', 'Ljubno\r', 'RE', 199, 46.34217000000, 14.83341000000, '3598'),
(3656, 'SI-I6', 'Ljutomer\r', 'RE', 199, 46.51834000000, 16.19556000000, '3599'),
(3657, 'SI-64', 'Logatec\r', 'RE', 199, 45.91217000000, 14.22831000000, '3600'),
(3658, 'SI-I7', 'Loska Dolina\r', 'RE', 199, 45.62288000000, 14.46245000000, '3601'),
(3659, 'SI-66', 'Loski Potok\r', 'RE', 199, NULL, NULL, '3602'),
(3660, 'SI-I9', 'Luce\r', 'RE', 199, 46.35384300000, 14.73569100000, '3603'),
(3661, 'SI-68', 'Lukovica\r', 'RE', 199, 46.16702400000, 14.68603200000, '3604'),
(3662, 'SI-J1', 'Majsperk\r', 'RE', 199, 46.35150000000, 15.73500000000, '3605'),
(3663, 'SI-J2', 'Maribor\r', 'RE', 199, 46.54922500000, 15.63707500000, '3606'),
(3664, 'SI-71', 'Medvode\r', 'RE', 199, 46.14444000000, 14.41181000000, '3607'),
(3665, 'SI-72', 'Menges\r', 'RE', 199, 46.15864000000, 14.56965000000, '3608'),
(3666, 'SI-73', 'Metlika\r', 'RE', 199, 45.64857000000, 15.31298000000, '3609'),
(3667, 'SI-74', 'Mezica\r', 'RE', 199, NULL, NULL, '3610'),
(3668, 'SI-J5', 'Miren-Kostanjevica\r', 'RE', 199, 45.89463000000, 13.60842000000, '3611'),
(3669, 'SI-76', 'Mislinja\r', 'RE', 199, 46.44171000000, 15.19576000000, '3612'),
(3670, 'SI-77', 'Moravce\r', 'RE', 199, NULL, NULL, '3613'),
(3671, 'SI-78', 'Moravske Toplice\r', 'RE', 199, 46.69053000000, 16.22297000000, '3614'),
(3672, 'SI-79', 'Mozirje\r', 'RE', 199, 46.34033000000, 14.96121000000, '3615'),
(3673, 'SI-80', 'Murska Sobota\r', 'RE', 199, 46.66285500000, 16.14338500000, '3616'),
(3674, 'SI-81', 'Muta\r', 'RE', 199, 46.60977000000, 15.16304000000, '3617'),
(3675, 'SI-82', 'Naklo\r', 'RE', 199, 46.30009000000, 14.29755200000, '3618'),
(3676, 'SI-83', 'Nazarje\r', 'RE', 199, NULL, NULL, '3619'),
(3677, 'SI-84', 'Nova Gorica\r', 'RE', 199, 45.95578000000, 13.65504500000, '3620'),
(3678, 'SI-J7', 'Novo Mesto\r', 'RE', 199, 45.80565000000, 15.17581500000, '3621'),
(3679, 'SI-86', 'Odranci\r', 'RE', 199, NULL, NULL, '3622'),
(3680, 'SI-87', 'Ormoz\r', 'RE', 199, 46.40585900000, 16.15333900000, '3623'),
(3681, 'SI-88', 'Osilnica\r', 'RE', 199, NULL, NULL, '3624'),
(3682, 'SI-89', 'Pesnica\r', 'RE', 199, 46.61774400000, 15.67375100000, '3625'),
(3683, 'SI-J9', 'Piran\r', 'RE', 199, 45.52217000000, 13.57422500000, '3626'),
(3684, 'SI-91', 'Pivka\r', 'RE', 199, 45.68290000000, 14.19730000000, '3627'),
(3685, 'SI-92', 'Podcetrtek\r', 'RE', 199, 46.15655000000, 15.59705000000, '3628'),
(3686, 'SI-94', 'Postojna\r', 'RE', 199, 45.79131600000, 14.28875400000, '3629'),
(3687, 'SI-K5', 'Preddvor\r', 'RE', 199, 46.30168000000, 14.42151000000, '3630'),
(3688, 'SI-K7', 'Ptuj\r', 'RE', 199, 46.42563000000, 15.88644500000, '3631'),
(3689, 'SI-97', 'Puconci\r', 'RE', 199, NULL, NULL, '3632'),
(3690, 'SI-98', 'Racam\r', 'RE', 199, NULL, NULL, '3633'),
(3691, 'SI-99', 'Radece\r', 'RE', 199, 46.06670000000, 15.18197000000, '3634'),
(3692, 'SI-A1', 'Radenci\r', 'RE', 199, 46.64041000000, 16.04427000000, '3635'),
(3693, 'SI-A2', 'Radlje ob Dravi\r', 'RE', 199, 46.61434000000, 15.22557000000, '3636'),
(3694, 'SI-A3', 'Radovljica\r', 'RE', 199, 46.34531000000, 14.17130000000, '3637'),
(3695, 'SI-L1', 'Ribnica\r', 'RE', 199, 45.74070000000, 14.72890000000, '3638'),
(3696, 'SI-A7', 'Rogaska Slatina\r', 'RE', 199, 46.23248900000, 15.49919200000, '3639'),
(3697, 'SI-A6', 'Rogasovci\r', 'RE', 199, NULL, NULL, '3640'),
(3698, 'SI-A8', 'Rogatec\r', 'RE', 199, 46.22594000000, 15.70001000000, '3641'),
(3699, 'SI-L3', 'Ruse\r', 'RE', 199, 46.53986000000, 15.50778000000, '3642'),
(3700, 'SI-B1', 'Semic\r', 'RE', 199, 45.65196000000, 15.18209000000, '3643'),
(3701, 'SI-B2', 'Sencur\r', 'RE', 199, 46.24234000000, 14.42114000000, '3644'),
(3702, 'SI-B3', 'Sentilj\r', 'RE', 199, 46.67480000000, 15.65691000000, '3645'),
(3703, 'SI-B4', 'Sentjernej\r', 'RE', 199, 45.84353000000, 15.33806000000, '3646'),
(3704, 'SI-L7', 'Sentjur pri Celju\r', 'RE', 199, 46.21916500000, 15.39626500000, '3647'),
(3705, 'SI-B6', 'Sevnica\r', 'RE', 199, 46.01058000000, 15.30682000000, '3648'),
(3706, 'SI-B7', 'Sezana\r', 'RE', 199, 45.70883500000, 13.87134000000, '3649'),
(3707, 'SI-B8', 'Skocjan\r', 'RE', 199, 45.90650000000, 15.29222000000, '3650');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(3708, 'SI-B9', 'Skofja Loka\r', 'RE', 199, 46.16700000000, 14.31531500000, '3651'),
(3709, 'SI-C1', 'Skofljica\r', 'RE', 199, 45.98451000000, 14.57416000000, '3652'),
(3710, 'SI-C2', 'Slovenj Gradec\r', 'RE', 199, 46.48144700000, 15.03198700000, '3653'),
(3711, 'SI-L8', 'Slovenska Bistrica\r', 'RE', 199, 46.38991500000, 15.56907500000, '3654'),
(3712, 'SI-C4', 'Slovenske Konjice\r', 'RE', 199, 46.33689000000, 15.42299000000, '3655'),
(3713, 'SI-C5', 'Smarje pri Jelsah\r', 'RE', 199, NULL, NULL, '3656'),
(3714, 'SI-C6', 'Smartno ob Paki\r', 'RE', 199, 46.32920000000, 15.03216000000, '3657'),
(3715, 'SI-C7', 'Sostanj\r', 'RE', 199, 46.38086000000, 15.04798000000, '3658'),
(3716, 'SI-C8', 'Starse\r', 'RE', 199, NULL, NULL, '3659'),
(3717, 'SI-C9', 'Store\r', 'RE', 199, NULL, NULL, '3660'),
(3718, 'SI-D1', 'Sveti Jurij\r', 'RE', 199, NULL, NULL, '3661'),
(3719, 'SI-D2', 'Tolmin\r', 'RE', 199, 46.18409800000, 13.73426700000, '3662'),
(3720, 'SI-D3', 'Trbovlje\r', 'RE', 199, 46.15218500000, 15.04593500000, '3663'),
(3721, 'SI-D4', 'Trebnje\r', 'RE', 199, 45.90765000000, 15.00592000000, '3664'),
(3722, 'SI-D5', 'Trzic\r', 'RE', 199, 46.36700000000, 14.30885000000, '3665'),
(3723, 'SI-D6', 'Turnisce\r', 'RE', 199, 46.62843000000, 16.30905000000, '3666'),
(3724, 'SI-D7', 'Velenje\r', 'RE', 199, 46.36297500000, 15.11395000000, '3667'),
(3725, 'SI-D8', 'Velike Lasce\r', 'RE', 199, NULL, NULL, '3668'),
(3726, 'SI-N2', 'Videm\r', 'RE', 199, 46.57622400000, 16.03930600000, '3669'),
(3727, 'SI-E1', 'Vipava\r', 'RE', 199, 45.84529500000, 13.95512600000, '3670'),
(3728, 'SI-E2', 'Vitanje\r', 'RE', 199, 46.38106000000, 15.29411000000, '3671'),
(3729, 'SI-E3', 'Vodice\r', 'RE', 199, 45.48419000000, 14.05240000000, '3672'),
(3730, 'SI-N3', 'Vojnik\r', 'RE', 199, 46.29307000000, 15.30240000000, '3673'),
(3731, 'SI-E5', 'Vrhnika\r', 'RE', 199, 45.96520000000, 14.29766000000, '3674'),
(3732, 'SI-E6', 'Vuzenica\r', 'RE', 199, 46.59925000000, 15.16423000000, '3675'),
(3733, 'SI-E7', 'Zagorje ob Savi\r', 'RE', 199, 46.13533300000, 14.99566000000, '3676'),
(3734, 'SI-N5', 'Zalec\r', 'RE', 199, 46.25197000000, 15.16514000000, '3677'),
(3735, 'SI-E9', 'Zavrc\r', 'RE', 199, NULL, NULL, '3678'),
(3736, 'SI-F1', 'Zelezniki\r', 'RE', 199, NULL, NULL, '3679'),
(3737, 'SI-F2', 'Ziri\r', 'RE', 199, 46.04701000000, 14.10966000000, '3680'),
(3738, 'SI-F3', 'Zrece\r', 'RE', 199, 46.37523000000, 15.38652000000, '3681'),
(3739, 'SK-01', 'Banska Bystrica\r', 'RE', 201, NULL, NULL, '3682'),
(3740, 'SK-02', 'Bratislava\r', 'RE', 201, NULL, NULL, '3683'),
(3741, 'SK-03', 'Kosice\r', 'RE', 201, NULL, NULL, '3684'),
(3742, 'SK-04', 'Nitra\r', 'RE', 201, NULL, NULL, '3685'),
(3743, 'SK-05', 'Presov\r', 'RE', 201, NULL, NULL, '3686'),
(3744, 'SK-06', 'Trencin\r', 'RE', 201, NULL, NULL, '3687'),
(3745, 'SK-07', 'Trnava\r', 'RE', 201, NULL, NULL, '3688'),
(3746, 'SK-08', 'Zilina\r', 'RE', 201, NULL, NULL, '3689'),
(3747, 'SL-01', 'Eastern\r', 'RE', 202, 8.20833300000, -10.94166600000, '3690'),
(3748, 'SL-02', 'Northern\r', 'RE', 202, 9.15536400000, -11.98333300000, '3691'),
(3749, 'SL-03', 'Southern\r', 'RE', 202, 7.72500000000, -12.08907100000, '3692'),
(3750, 'SL-04', 'Western Area\r', 'RE', 202, NULL, NULL, '3693'),
(3751, 'SM-01', 'Acquaviva\r', 'RE', 203, 43.94499100000, 12.41843900000, '3694'),
(3752, 'SM-06', 'Borgo Maggiore\r', 'RE', 203, 43.94327400000, 12.44595700000, '3695'),
(3753, 'SM-02', 'Chiesanuova\r', 'RE', 203, 43.90454900000, 12.42040000000, '3696'),
(3754, 'SM-03', 'Domagnano\r', 'RE', 203, 43.95285600000, 12.46944400000, '3697'),
(3755, 'SM-04', 'Faetano\r', 'RE', 203, 43.92549400000, 12.49836800000, '3698'),
(3756, 'SM-05', 'Fiorentino\r', 'RE', 203, 43.91179500000, 12.45673200000, '3699'),
(3757, 'SM-08', 'Monte Giardino\r', 'RE', 203, 41.73085700000, 13.33618300000, '3700'),
(3758, 'SM-07', 'San Marino\r', 'RE', 203, 43.93215600000, 12.44862500000, '3701'),
(3759, 'SM-09', 'Serravalle\r', 'RE', 203, NULL, NULL, '3702'),
(3760, 'SN-01', 'Dakar\r', 'RE', 204, NULL, NULL, '3703'),
(3761, 'SN-03', 'Diourbel\r', 'RE', 204, NULL, NULL, '3704'),
(3762, 'SN-09', 'Fatick\r', 'RE', 204, 14.34066000000, -16.42700000000, '3705'),
(3763, 'SN-10', 'Kaolack\r', 'RE', 204, 14.13996000000, -16.08739500000, '3706'),
(3764, 'SN-11', 'Kolda\r', 'RE', 204, NULL, NULL, '3707'),
(3765, 'SN-08', 'Louga\r', 'RE', 204, 15.61494000000, -16.23353400000, '3708'),
(3766, 'SN-04', 'Saint-Louis\r', 'RE', 204, NULL, NULL, '3709'),
(3767, 'SN-05', 'Tambacounda\r', 'RE', 204, 13.77234000000, -13.67311000000, '3710'),
(3768, 'SN-07', 'Thies\r', 'RE', 204, NULL, NULL, '3711'),
(3769, 'SN-12', 'Ziguinchor\r', 'RE', 204, NULL, NULL, '3712'),
(3770, 'SO-01', 'Bakool\r', 'RE', 205, 4.22360300000, 43.68333300000, '3713'),
(3771, 'SO-02', 'Banaadir\r', 'RE', 205, NULL, NULL, '3714'),
(3772, 'SO-03', 'Bari\r', 'RE', 205, NULL, NULL, '3715'),
(3773, 'SO-04', 'Bay\r', 'RE', 205, 2.64166700000, 43.50000000000, '3716'),
(3774, 'SO-05', 'Galguduud\r', 'RE', 205, 4.89166700000, 46.70833300000, '3717'),
(3775, 'SO-06', 'Gedo\r', 'RE', 205, 3.21666700000, 42.01666600000, '3718'),
(3776, 'SO-07', 'Hiiraan\r', 'RE', 205, 4.36123500000, 45.41666700000, '3719'),
(3777, 'SO-08', 'Jubbada Dhexe\r', 'RE', 205, 1.33828300000, 42.15833300000, '3720'),
(3778, 'SO-09', 'Jubbada Hoose\r', 'RE', 205, -0.17093900000, 42.00000000000, '3721'),
(3779, 'SO-10', 'Mudug\r', 'RE', 205, 6.24170600000, 47.98155100000, '3722'),
(3780, 'SO-11', 'Nugaal\r', 'RE', 205, NULL, NULL, '3723'),
(3781, 'SO-12', 'Sanaag\r', 'RE', 205, 10.26660500000, 47.40833300000, '3724'),
(3782, 'SO-13', 'Shabeellaha Dhexe\r', 'RE', 205, 3.03333300000, 46.06654900000, '3725'),
(3783, 'SO-14', 'Shabeellaha Hoose\r', 'RE', 205, 2.00000000000, 44.22205000000, '3726'),
(3784, 'SO-15', 'Togdheer\r', 'RE', 205, 9.12068300000, 45.78333300000, '3727'),
(3785, 'SO-16', 'Woqooyi Galbeed\r', 'RE', 205, NULL, NULL, '3728'),
(3786, 'SR-10', 'Brokopondo\r', 'RE', 206, 4.69086300000, -55.12365500000, '3729'),
(3787, 'SR-11', 'Commewijne\r', 'RE', 206, 5.74418100000, -54.89196800000, '3730'),
(3788, 'SR-12', 'Coronie\r', 'RE', 206, 5.63787200000, -56.24282400000, '3731'),
(3789, 'SR-13', 'Marowijne\r', 'RE', 206, 5.60308800000, -54.36237300000, '3732'),
(3790, 'SR-14', 'Nickerie\r', 'RE', 206, NULL, NULL, '3733'),
(3791, 'SR-15', 'Para\r', 'RE', 206, 5.34552900000, -55.33481200000, '3734'),
(3792, 'SR-16', 'Paramaribo\r', 'RE', 206, NULL, NULL, '3735'),
(3793, 'SR-17', 'Saramacca\r', 'RE', 206, 5.69243700000, -55.63845200000, '3736'),
(3794, 'SR-18', 'Sipaliwini\r', 'RE', 206, 3.68372300000, -56.03202800000, '3737'),
(3795, 'SR-19', 'Wanica\r', 'RE', 206, 5.79870000000, -55.21848600000, '3738'),
(3796, 'ST-01', 'Principe\r', 'RE', 207, 1.61460200000, 7.40555500000, '3739'),
(3797, 'ST-02', 'Sao Tome\r', 'RE', 207, 0.20618000000, 6.60710200000, '3740'),
(3798, 'SV-01', 'Ahuachapan\r', 'RE', 208, NULL, NULL, '3741'),
(3799, 'SV-02', 'Cabanas\r', 'RE', 208, NULL, NULL, '3742'),
(3800, 'SV-03', 'Chalatenango\r', 'RE', 208, NULL, NULL, '3743'),
(3801, 'SV-04', 'Cuscatlan\r', 'RE', 208, NULL, NULL, '3744'),
(3802, 'SV-05', 'La Libertad\r', 'RE', 208, NULL, NULL, '3745'),
(3803, 'SV-06', 'La Paz\r', 'RE', 208, NULL, NULL, '3746'),
(3804, 'SV-07', 'La Union\r', 'RE', 208, NULL, NULL, '3747'),
(3805, 'SV-08', 'Morazan\r', 'RE', 208, NULL, NULL, '3748'),
(3806, 'SV-09', 'San Miguel\r', 'RE', 208, 13.47699800000, -88.17844100000, '3749'),
(3807, 'SV-10', 'San Salvador\r', 'RE', 208, NULL, NULL, '3750'),
(3808, 'SV-12', 'San Vicente\r', 'RE', 208, 13.64190500000, -88.78577000000, '3751'),
(3809, 'SV-11', 'Santa Ana\r', 'RE', 208, NULL, NULL, '3752'),
(3810, 'SV-13', 'Sonsonate\r', 'RE', 208, NULL, NULL, '3753'),
(3811, 'SV-14', 'Usulutan\r', 'RE', 208, 13.42217400000, -88.46813200000, '3754'),
(3812, 'SY-01', 'Al Hasakah\r', 'RE', 209, NULL, NULL, '3755'),
(3813, 'SY-02', 'Al Ladhiqiyah\r', 'RE', 209, NULL, NULL, '3756'),
(3814, 'SY-03', 'Al Qunaytirah\r', 'RE', 209, NULL, NULL, '3757'),
(3815, 'SY-04', 'Ar Raqqah\r', 'RE', 209, NULL, NULL, '3758'),
(3816, 'SY-05', 'As Suwayda''\r', 'RE', 209, NULL, NULL, '3759'),
(3817, 'SY-06', 'Dar\r', 'RE', 209, NULL, NULL, '3760'),
(3818, 'SY-07', 'Dayr az Zawr\r', 'RE', 209, NULL, NULL, '3761'),
(3819, 'SY-13', 'Dimashq\r', 'RE', 209, NULL, NULL, '3762'),
(3820, 'SY-09', 'Halab\r', 'RE', 209, NULL, NULL, '3763'),
(3821, 'SY-10', 'Hamah\r', 'RE', 209, NULL, NULL, '3764'),
(3822, 'SY-11', 'Hims\r', 'RE', 209, NULL, NULL, '3765'),
(3823, 'SY-12', 'Idlib\r', 'RE', 209, NULL, NULL, '3766'),
(3824, 'SY-08', 'Rif Dimashq\r', 'RE', 209, NULL, NULL, '3767'),
(3825, 'SY-14', 'Tartus\r', 'RE', 209, NULL, NULL, '3768'),
(3826, 'SZ-01', 'Hhohho\r', 'RE', 210, NULL, NULL, '3769'),
(3827, 'SZ-02', 'Lubombo\r', 'RE', 210, -26.55000000000, 31.80228500000, '3770'),
(3828, 'SZ-03', 'Manzini\r', 'RE', 210, NULL, NULL, '3771'),
(3829, 'SZ-05', 'Praslin\r', 'RE', 210, NULL, NULL, '3772'),
(3830, 'SZ-04', 'Shiselweni\r', 'RE', 210, NULL, NULL, '3773'),
(3831, 'TD-01', 'Batha\r', 'RE', 212, 13.78215800000, 18.68162500000, '3774'),
(3832, 'TD-02', 'Biltine\r', 'RE', 212, 14.53070000000, 20.92481500000, '3775'),
(3833, 'TD-03', 'Borkou-Ennedi-Tibesti\r', 'RE', 212, 18.68913000000, 19.85566900000, '3776'),
(3834, 'TD-04', 'Chari-Baguirmi\r', 'RE', 212, NULL, NULL, '3777'),
(3835, 'TD-05', 'Guera\r', 'RE', 212, 11.38753500000, 18.60334200000, '3778'),
(3836, 'TD-06', 'Kanem\r', 'RE', 212, 14.56666600000, 15.63487000000, '3779'),
(3837, 'TD-07', 'Lac\r', 'RE', 212, 13.76654500000, 14.72958300000, '3780'),
(3838, 'TD-08', 'Logone Occidental\r', 'RE', 212, NULL, NULL, '3781'),
(3839, 'TD-09', 'Logone Oriental\r', 'RE', 212, 8.29166700000, 16.29166600000, '3782'),
(3840, 'TD-10', 'Mayo-Kebbi\r', 'RE', 212, NULL, NULL, '3783'),
(3841, 'TD-11', 'Moyen-Chari\r', 'RE', 212, 9.15833400000, 18.33919600000, '3784'),
(3842, 'TD-12', 'Ouaddai\r', 'RE', 212, 12.75833300000, 21.41451500000, '3785'),
(3843, 'TD-13', 'Salamat\r', 'RE', 212, 10.81178000000, 20.42826800000, '3786'),
(3844, 'TD-14', 'Tandjile\r', 'RE', 212, 9.59564900000, 16.49749900000, '3787'),
(3845, 'TG-01', 'Amlame\r', 'RE', 214, 7.45430000000, 0.90190000000, '3788'),
(3846, 'TG-02', 'Aneho\r', 'RE', 214, NULL, NULL, '3789'),
(3847, 'TG-03', 'Atakpame\r', 'RE', 214, 7.52501700000, 1.12551800000, '3790'),
(3848, 'TG-15', 'Badou\r', 'RE', 214, 7.59820000000, 0.62660000000, '3791'),
(3849, 'TG-04', 'Bafilo\r', 'RE', 214, 9.34324600000, 1.24226000000, '3792'),
(3850, 'TG-05', 'Bassar\r', 'RE', 214, 9.26510000000, 0.78540000000, '3793'),
(3851, 'TG-06', 'Dapaong\r', 'RE', 214, NULL, NULL, '3794'),
(3852, 'TG-07', 'Kante\r', 'RE', 214, NULL, NULL, '3795'),
(3853, 'TG-08', 'Klouto\r', 'RE', 214, NULL, NULL, '3796'),
(3854, 'TG-14', 'Kpagouda\r', 'RE', 214, NULL, NULL, '3797'),
(3855, 'TG-09', 'Lama-Kara\r', 'RE', 214, NULL, NULL, '3798'),
(3856, 'TG-10', 'Lome\r', 'RE', 214, 6.12280000000, 1.22550000000, '3799'),
(3857, 'TG-11', 'Mango\r', 'RE', 214, 10.36790900000, 0.46660800000, '3800'),
(3858, 'TG-12', 'Niamtougou\r', 'RE', 214, 9.76611100000, 1.11333100000, '3801'),
(3859, 'TG-13', 'Notse\r', 'RE', 214, NULL, NULL, '3802'),
(3860, 'TG-16', 'Sotouboua\r', 'RE', 214, 8.55638500000, 0.98368800000, '3803'),
(3861, 'TG-17', 'Tabligbo\r', 'RE', 214, 6.58300000000, 1.49740000000, '3804'),
(3862, 'TG-19', 'Tchamba\r', 'RE', 214, 9.01561200000, 1.41491800000, '3805'),
(3863, 'TG-20', 'Tchaoudjo\r', 'RE', 214, NULL, NULL, '3806'),
(3864, 'TG-18', 'Tsevie\r', 'RE', 214, 6.42098700000, 1.20973500000, '3807'),
(3865, 'TG-21', 'Vogan\r', 'RE', 214, 6.33333300000, 1.26666700000, '3808'),
(3866, 'TH-35', 'Ang Thong\r', 'RE', 215, NULL, NULL, '3809'),
(3867, 'TH-28', 'Buriram\r', 'RE', 215, NULL, NULL, '3810'),
(3868, 'TH-44', 'Chachoengsao\r', 'RE', 215, NULL, NULL, '3811'),
(3869, 'TH-32', 'Chai Nat\r', 'RE', 215, NULL, NULL, '3812'),
(3870, 'TH-26', 'Chaiyaphum\r', 'RE', 215, NULL, NULL, '3813'),
(3871, 'TH-48', 'Chanthaburi\r', 'RE', 215, NULL, NULL, '3814'),
(3872, 'TH-02', 'Chiang Mai\r', 'RE', 215, NULL, NULL, '3815'),
(3873, 'TH-03', 'Chiang Rai\r', 'RE', 215, NULL, NULL, '3816'),
(3874, 'TH-46', 'Chon Buri\r', 'RE', 215, NULL, NULL, '3817'),
(3875, 'TH-58', 'Chumphon\r', 'RE', 215, NULL, NULL, '3818'),
(3876, 'TH-23', 'Kalasin\r', 'RE', 215, NULL, NULL, '3819'),
(3877, 'TH-11', 'Kamphaeng Phet\r', 'RE', 215, NULL, NULL, '3820'),
(3878, 'TH-50', 'Kanchanaburi\r', 'RE', 215, NULL, NULL, '3821'),
(3879, 'TH-22', 'Khon Kaen\r', 'RE', 215, NULL, NULL, '3822'),
(3880, 'TH-63', 'Krabi\r', 'RE', 215, NULL, NULL, '3823'),
(3881, 'TH-40', 'Krung Thep\r', 'RE', 215, NULL, NULL, '3824'),
(3882, 'TH-06', 'Lampang\r', 'RE', 215, NULL, NULL, '3825'),
(3883, 'TH-05', 'Lamphun\r', 'RE', 215, NULL, NULL, '3826'),
(3884, 'TH-18', 'Loei\r', 'RE', 215, 17.48670900000, 101.49430900000, '3827'),
(3885, 'TH-34', 'Lop Buri\r', 'RE', 215, 15.07561700000, 100.94771300000, '3828'),
(3886, 'TH-01', 'Mae Hong Son\r', 'RE', 215, 18.72560600000, 97.99870100000, '3829'),
(3887, 'TH-24', 'Maha Sarakham\r', 'RE', 215, NULL, NULL, '3830'),
(3888, 'TH-78', 'Mukdahan\r', 'RE', 215, NULL, NULL, '3831'),
(3889, 'TH-43', 'Nakhon Nayok\r', 'RE', 215, 14.23705800000, 101.20933300000, '3832'),
(3890, 'TH-53', 'Nakhon Pathom\r', 'RE', 215, 13.91414300000, 100.08336500000, '3833'),
(3891, 'TH-21', 'Nakhon Phanom\r', 'RE', 215, 17.40580100000, 104.39502700000, '3834'),
(3892, 'TH-27', 'Nakhon Ratchasima\r', 'RE', 215, NULL, NULL, '3835'),
(3893, 'TH-16', 'Nakhon Sawan\r', 'RE', 215, NULL, NULL, '3836'),
(3894, 'TH-64', 'Nakhon Si Thammarat\r', 'RE', 215, NULL, NULL, '3837'),
(3895, 'TH-04', 'Nan\r', 'RE', 215, NULL, NULL, '3838'),
(3896, 'TH-31', 'Narathiwat\r', 'RE', 215, NULL, NULL, '3839'),
(3897, 'TH-17', 'Nong Khai\r', 'RE', 215, 17.88410900000, 102.74659700000, '3840'),
(3898, 'TH-38', 'Nonthaburi\r', 'RE', 215, NULL, NULL, '3841'),
(3899, 'TH-39', 'Pathum Thani\r', 'RE', 215, NULL, NULL, '3842'),
(3900, 'TH-69', 'Pattani\r', 'RE', 215, NULL, NULL, '3843'),
(3901, 'TH-61', 'Phangnga\r', 'RE', 215, 8.74673900000, 98.16991500000, '3844'),
(3902, 'TH-66', 'Phatthalung\r', 'RE', 215, 7.49223200000, 100.08061500000, '3845'),
(3903, 'TH-41', 'Phayao\r', 'RE', 215, NULL, NULL, '3846'),
(3904, 'TH-14', 'Phetchabun\r', 'RE', 215, 16.24818600000, 101.21418800000, '3847'),
(3905, 'TH-56', 'Phetchaburi\r', 'RE', 215, NULL, NULL, '3848'),
(3906, 'TH-13', 'Phichit\r', 'RE', 215, NULL, NULL, '3849'),
(3907, 'TH-12', 'Phitsanulok\r', 'RE', 215, NULL, NULL, '3850'),
(3908, 'TH-36', 'Phra Nakhon Si Ayutthaya\r', 'RE', 215, NULL, NULL, '3851'),
(3909, 'TH-07', 'Phrae\r', 'RE', 215, NULL, NULL, '3852'),
(3910, 'TH-62', 'Phuket\r', 'RE', 215, NULL, NULL, '3853'),
(3911, 'TH-45', 'Prachin Buri\r', 'RE', 215, 14.04907000000, 101.37770100000, '3854'),
(3912, 'TH-57', 'Prachuap Khiri Khan\r', 'RE', 215, NULL, NULL, '3855'),
(3913, 'TH-59', 'Ranong\r', 'RE', 215, NULL, NULL, '3856'),
(3914, 'TH-52', 'Ratchaburi\r', 'RE', 215, NULL, NULL, '3857'),
(3915, 'TH-47', 'Rayong\r', 'RE', 215, NULL, NULL, '3858'),
(3916, 'TH-25', 'Roi Et\r', 'RE', 215, NULL, NULL, '3859'),
(3917, 'TH-20', 'Sakon Nakhon\r', 'RE', 215, NULL, NULL, '3860'),
(3918, 'TH-42', 'Samut Prakan\r', 'RE', 215, NULL, NULL, '3861'),
(3919, 'TH-55', 'Samut Sakhon\r', 'RE', 215, NULL, NULL, '3862'),
(3920, 'TH-54', 'Samut Songkhram\r', 'RE', 215, 13.37616200000, 99.96213100000, '3863'),
(3921, 'TH-37', 'Saraburi\r', 'RE', 215, NULL, NULL, '3864'),
(3922, 'TH-67', 'Satun\r', 'RE', 215, NULL, NULL, '3865'),
(3923, 'TH-33', 'Sing Buri\r', 'RE', 215, NULL, NULL, '3866'),
(3924, 'TH-30', 'Sisaket\r', 'RE', 215, NULL, NULL, '3867'),
(3925, 'TH-68', 'Songkhla\r', 'RE', 215, NULL, NULL, '3868'),
(3926, 'TH-09', 'Sukhothai\r', 'RE', 215, NULL, NULL, '3869'),
(3927, 'TH-51', 'Suphan Buri\r', 'RE', 215, NULL, NULL, '3870'),
(3928, 'TH-60', 'Surat Thani\r', 'RE', 215, NULL, NULL, '3871'),
(3929, 'TH-29', 'Surin\r', 'RE', 215, NULL, NULL, '3872'),
(3930, 'TH-08', 'Tak\r', 'RE', 215, NULL, NULL, '3873'),
(3931, 'TH-65', 'Trang\r', 'RE', 215, NULL, NULL, '3874'),
(3932, 'TH-49', 'Trat\r', 'RE', 215, NULL, NULL, '3875'),
(3933, 'TH-75', 'Ubon Ratchathani\r', 'RE', 215, NULL, NULL, '3876'),
(3934, 'TH-76', 'Udon Thani\r', 'RE', 215, NULL, NULL, '3877'),
(3935, 'TH-15', 'Uthai Thani\r', 'RE', 215, 15.36990600000, 99.54499600000, '3878'),
(3936, 'TH-10', 'Uttaradit\r', 'RE', 215, NULL, NULL, '3879'),
(3937, 'TH-70', 'Yala\r', 'RE', 215, NULL, NULL, '3880'),
(3938, 'TH-72', 'Yasothon\r', 'RE', 215, NULL, NULL, '3881'),
(3939, 'TJ-02', 'Khatlon\r', 'RE', 216, NULL, NULL, '3882'),
(3940, 'TJ-01', 'Kuhistoni Badakhshon\r', 'RE', 216, 38.07147600000, 72.67687900000, '3883'),
(3941, 'TJ-03', 'Sughd\r', 'RE', 216, 39.98417800000, 69.18573400000, '3884'),
(3942, 'TM-01', 'Ahal\r', 'RE', 219, NULL, NULL, '3885'),
(3943, 'TM-02', 'Balkan\r', 'RE', 219, 39.82634000000, 54.82057900000, '3886'),
(3944, 'TM-03', 'Dashoguz\r', 'RE', 219, 41.13087700000, 58.68615100000, '3887'),
(3945, 'TM-04', 'Lebap\r', 'RE', 219, 39.07120900000, 63.43708800000, '3888'),
(3946, 'TM-05', 'Mary\r', 'RE', 219, 37.32734800000, 62.56643700000, '3889'),
(3947, 'TN-15', 'Al Mahdiyah\r', 'RE', 220, 35.30503000000, 10.65756000000, '3890'),
(3948, 'TN-16', 'Al Munastir\r', 'RE', 220, NULL, NULL, '3891'),
(3949, 'TN-02', 'Al Qasrayn\r', 'RE', 220, 35.24166700000, 8.84948800000, '3892'),
(3950, 'TN-03', 'Al Qayrawan\r', 'RE', 220, NULL, NULL, '3893'),
(3951, 'TN-38', 'Ariana\r', 'RE', 220, 36.87500000000, 9.95833300000, '3894'),
(3952, 'TN-17', 'Bajah\r', 'RE', 220, NULL, NULL, '3895'),
(3953, 'TN-18', 'Banzart\r', 'RE', 220, NULL, NULL, '3896'),
(3954, 'TN-27', 'Bin\r', 'RE', 220, 36.75000000000, 8.75000000000, '3897'),
(3955, 'TN-06', 'Jundubah\r', 'RE', 220, 36.70334400000, 8.62500000000, '3898'),
(3956, 'TN-14', 'Kef\r', 'RE', 220, 36.18040000000, 8.70600000000, '3899'),
(3957, 'TN-28', 'Madanin\r', 'RE', 220, NULL, NULL, '3900'),
(3958, 'TN-39', 'Manouba\r', 'RE', 220, 36.79800000000, 10.10550000000, '3901'),
(3959, 'TN-19', 'Nabul\r', 'RE', 220, NULL, NULL, '3902'),
(3960, 'TN-29', 'Qabis\r', 'RE', 220, 33.70236300000, 9.98333300000, '3903'),
(3961, 'TN-10', 'Qafsah\r', 'RE', 220, 34.49319200000, 8.71520300000, '3904'),
(3962, 'TN-31', 'Qibili\r', 'RE', 220, NULL, NULL, '3905'),
(3963, 'TN-32', 'Safaqis\r', 'RE', 220, NULL, NULL, '3906'),
(3964, 'TN-33', 'Sidi Bu Zayd\r', 'RE', 220, 34.92598400000, 9.57500000000, '3907'),
(3965, 'TN-22', 'Silyanah\r', 'RE', 220, NULL, NULL, '3908'),
(3966, 'TN-23', 'Susah\r', 'RE', 220, NULL, NULL, '3909'),
(3967, 'TN-34', 'Tatawin\r', 'RE', 220, 32.09402800000, 10.61458300000, '3910'),
(3968, 'TN-35', 'Tawzar\r', 'RE', 220, NULL, NULL, '3911'),
(3969, 'TN-36', 'Tunis\r', 'RE', 220, NULL, NULL, '3912'),
(3970, 'TN-37', 'Zaghwan\r', 'RE', 220, 36.30436000000, 10.00000000000, '3913'),
(3971, 'TO-01', 'Ha\r', 'RE', 221, 52.40171400000, 5.31628800000, '3914'),
(3972, 'TO-02', 'Tongatapu\r', 'RE', 221, -21.16793800000, -175.19599900000, '3915'),
(3973, 'TO-03', 'Vava\r', 'RE', 221, NULL, NULL, '3916'),
(3974, 'TR-81', 'Adana\r', 'RE', 222, 38.63333300000, 28.88333300000, '3917'),
(3975, 'TR-02', 'Adiyaman\r', 'RE', 222, 37.74779900000, 38.37316300000, '3918'),
(3976, 'TR-03', 'Afyon\r', 'RE', 222, 38.76376000000, 30.54034000000, '3919'),
(3977, 'TR-04', 'Agri\r', 'RE', 222, 39.68693200000, 43.03889200000, '3920'),
(3978, 'TR-75', 'Aksaray\r', 'RE', 222, 38.37105000000, 34.03257600000, '3921'),
(3979, 'TR-05', 'Amasya\r', 'RE', 222, 40.65123200000, 35.83443100000, '3922'),
(3980, 'TR-68', 'Ankara\r', 'RE', 222, 39.71526600000, 32.36064000000, '3923'),
(3981, 'TR-07', 'Antalya\r', 'RE', 222, 36.90029700000, 30.69008300000, '3924'),
(3982, 'TR-86', 'Ardahan\r', 'RE', 222, 41.12254700000, 42.89689800000, '3925'),
(3983, 'TR-08', 'Artvin\r', 'RE', 222, 41.17858500000, 41.82928200000, '3926'),
(3984, 'TR-09', 'Aydin\r', 'RE', 222, 40.16314200000, 32.66680500000, '3927'),
(3985, 'TR-10', 'Balikesir\r', 'RE', 222, 39.63285600000, 27.90430300000, '3928'),
(3986, 'TR-87', 'Bartin\r', 'RE', 222, 41.63664800000, 32.34138400000, '3929'),
(3987, 'TR-76', 'Batman\r', 'RE', 222, 37.87973400000, 41.12929500000, '3930'),
(3988, 'TR-77', 'Bayburt\r', 'RE', 222, 40.25918200000, 40.22663700000, '3931'),
(3989, 'TR-11', 'Bilecik\r', 'RE', 222, 40.14638300000, 29.98117900000, '3932'),
(3990, 'TR-12', 'Bingol\r', 'RE', 222, 39.73196600000, 37.14135000000, '3933'),
(3991, 'TR-13', 'Bitlis\r', 'RE', 222, 38.39716500000, 42.11580000000, '3934'),
(3992, 'TR-14', 'Bolu\r', 'RE', 222, 40.73593800000, 31.60966400000, '3935'),
(3993, 'TR-15', 'Burdur\r', 'RE', 222, 37.72476900000, 30.28534100000, '3936'),
(3994, 'TR-16', 'Bursa\r', 'RE', 222, 40.18989300000, 29.06877900000, '3937'),
(3995, 'TR-17', 'Canakkale\r', 'RE', 222, 40.14600600000, 26.41678600000, '3938'),
(3996, 'TR-82', 'Cankiri\r', 'RE', 222, 40.60024400000, 33.61623500000, '3939'),
(3997, 'TR-19', 'Corum\r', 'RE', 222, 40.55222400000, 34.95867600000, '3940'),
(3998, 'TR-20', 'Denizli\r', 'RE', 222, 37.81494600000, 29.05015000000, '3941'),
(3999, 'TR-21', 'Diyarbakir\r', 'RE', 222, 37.92046700000, 40.21629500000, '3942'),
(4000, 'TR-93', 'Duzce\r', 'RE', 222, 40.83979900000, 31.16233500000, '3943'),
(4001, 'TR-22', 'Edirne\r', 'RE', 222, 41.67393700000, 26.55857600000, '3944'),
(4002, 'TR-23', 'Elazig\r', 'RE', 222, 38.64397900000, 39.25321800000, '3945'),
(4003, 'TR-24', 'Erzincan\r', 'RE', 222, 39.73075900000, 39.50938700000, '3946'),
(4004, 'TR-25', 'Erzurum\r', 'RE', 222, 39.90495900000, 41.27887000000, '3947'),
(4005, 'TR-26', 'Eskisehir\r', 'RE', 222, 39.77112500000, 30.49869600000, '3948'),
(4006, 'TR-83', 'Gaziantep\r', 'RE', 222, 37.11260500000, 37.26556300000, '3949'),
(4007, 'TR-28', 'Giresun\r', 'RE', 222, 40.90293500000, 38.37953100000, '3950'),
(4008, 'TR-69', 'Gumushane\r', 'RE', 222, 40.33767500000, 39.44965300000, '3951'),
(4009, 'TR-70', 'Hakkari\r', 'RE', 222, 37.57122100000, 43.74349500000, '3952'),
(4010, 'TR-31', 'Hatay\r', 'RE', 222, 36.41380600000, 36.23845500000, '3953'),
(4011, 'TR-32', 'Icel / Mersin', 'RE', 222, 36.79753200000, 34.63019400000, '3954'),
(4012, 'TR-88', 'Igdir\r', 'RE', 222, 39.92338900000, 44.04682900000, '3955'),
(4013, 'TR-33', 'Isparta\r', 'RE', 222, 37.80983200000, 30.46321400000, '3956'),
(4014, 'TR-34', 'Istanbul\r', 'RE', 222, 41.19371000000, 28.96497500000, '3957'),
(4015, 'TR-35', 'Izmir\r', 'RE', 222, 38.60507300000, 27.36448600000, '3958'),
(4016, 'TR-46', 'Kahramanmaras\r', 'RE', 222, 37.89283100000, 36.95651600000, '3959'),
(4017, 'TR-89', 'Karabuk\r', 'RE', 222, 41.19465000000, 32.61908400000, '3960'),
(4018, 'TR-78', 'Karaman\r', 'RE', 222, 39.80070000000, 37.94560000000, '3961'),
(4019, 'TR-84', 'Kars\r', 'RE', 222, 40.58424700000, 43.09882300000, '3962'),
(4020, 'TR-37', 'Kastamonu\r', 'RE', 222, 41.35103600000, 33.78615200000, '3963'),
(4021, 'TR-38', 'Kayseri\r', 'RE', 222, 38.52680900000, 35.92831100000, '3964'),
(4022, 'TR-90', 'Kilis\r', 'RE', 222, 36.71695200000, 37.11763200000, '3965'),
(4023, 'TR-79', 'Kirikkale\r', 'RE', 222, 39.84870400000, 33.50450300000, '3966'),
(4024, 'TR-39', 'Kirklareli\r', 'RE', 222, 41.73533400000, 27.21253100000, '3967'),
(4025, 'TR-40', 'Kirsehir\r', 'RE', 222, 39.14432900000, 34.16568300000, '3968'),
(4026, 'TR-41', 'Kocaeli\r', 'RE', 222, 40.87127100000, 29.84654000000, '3969'),
(4027, 'TR-71', 'Konya\r', 'RE', 222, 37.87499800000, 32.48711700000, '3970'),
(4028, 'TR-43', 'Kutahya\r', 'RE', 222, 39.41944600000, 29.98279900000, '3971'),
(4029, 'TR-44', 'Malatya\r', 'RE', 222, 38.35210900000, 38.31472400000, '3972'),
(4030, 'TR-45', 'Manisa\r', 'RE', 222, 38.61693100000, 27.43161200000, '3973'),
(4031, 'TR-72', 'Mardin\r', 'RE', 222, 37.26927300000, 40.69172200000, '3974'),
(4032, 'TR-48', 'Mugla\r', 'RE', 222, 37.19508500000, 28.37146600000, '3975'),
(4033, 'TR-49', 'Mus\r', 'RE', 222, 38.73906100000, 41.57523900000, '3976'),
(4034, 'TR-50', 'Nevsehir\r', 'RE', 222, 38.69878400000, 34.62743000000, '3977'),
(4035, 'TR-73', 'Nigde\r', 'RE', 222, 37.97319700000, 34.68514700000, '3978'),
(4036, 'TR-52', 'Ordu\r', 'RE', 222, 40.96224500000, 37.90136500000, '3979'),
(4037, 'TR-91', 'Osmaniye\r', 'RE', 222, 39.80910000000, 37.84070000000, '3980'),
(4038, 'TR-53', 'Rize\r', 'RE', 222, 41.02863700000, 40.53712100000, '3981'),
(4039, 'TR-54', 'Sakarya\r', 'RE', 222, 40.73141200000, 30.48551900000, '3982'),
(4040, 'TR-55', 'Samsun\r', 'RE', 222, 41.29584800000, 36.32634600000, '3983'),
(4041, 'TR-63', 'Sanliurfa\r', 'RE', 222, 37.34619500000, 39.03540300000, '3984'),
(4042, 'TR-74', 'Siirt\r', 'RE', 222, 37.93601400000, 41.93811300000, '3985'),
(4043, 'TR-57', 'Sinop\r', 'RE', 222, 42.02485400000, 35.11653500000, '3986'),
(4044, 'TR-80', 'Sirnak\r', 'RE', 222, 37.52033900000, 42.46340200000, '3987'),
(4045, 'TR-58', 'Sivas\r', 'RE', 222, 39.74885700000, 37.01670800000, '3988'),
(4046, 'TR-59', 'Tekirdag\r', 'RE', 222, 40.96721300000, 27.50294600000, '3989'),
(4047, 'TR-60', 'Tokat\r', 'RE', 222, 39.20420000000, 29.13890000000, '3990'),
(4048, 'TR-61', 'Trabzon\r', 'RE', 222, 40.99186500000, 39.72084400000, '3991'),
(4049, 'TR-62', 'Tunceli\r', 'RE', 222, 39.10699100000, 39.55387200000, '3992'),
(4050, 'TR-64', 'Usak\r', 'RE', 222, 38.69306700000, 29.40557100000, '3993'),
(4051, 'TR-65', 'Van\r', 'RE', 222, 38.49645700000, 43.40235200000, '3994'),
(4052, 'TR-92', 'Yalova\r', 'RE', 222, 40.25502500000, 26.40363700000, '3995'),
(4053, 'TR-66', 'Yozgat\r', 'RE', 222, 39.81869500000, 34.81466500000, '3996'),
(4054, 'TR-85', 'Zonguldak\r', 'RE', 222, 41.35591600000, 31.61351600000, '3997'),
(4055, 'TT-01', 'Arima\r', 'RE', 223, NULL, NULL, '3998'),
(4056, 'TT-02', 'Caroni\r', 'RE', 223, NULL, NULL, '3999'),
(4057, 'TT-03', 'Mayaro\r', 'RE', 223, 10.23187500000, -61.00886300000, '4000'),
(4058, 'TT-04', 'Nariva\r', 'RE', 223, 10.36917100000, -61.15232700000, '4001'),
(4059, 'TT-05', 'Port-of-Spain\r', 'RE', 223, NULL, NULL, '4002'),
(4060, 'TT-06', 'Saint Andrew\r', 'RE', 223, NULL, NULL, '4003'),
(4061, 'TT-07', 'Saint David\r', 'RE', 223, 10.79990500000, -61.03647000000, '4004'),
(4062, 'TT-08', 'Saint George\r', 'RE', 223, NULL, NULL, '4005'),
(4063, 'TT-09', 'Saint Patrick\r', 'RE', 223, 10.12219500000, -61.70616500000, '4006'),
(4064, 'TT-10', 'San Fernando\r', 'RE', 223, NULL, NULL, '4007'),
(4065, 'TT-11', 'Tobago\r', 'RE', 223, NULL, NULL, '4008'),
(4066, 'TT-12', 'Victoria\r', 'RE', 223, NULL, NULL, '4009'),
(4067, 'TW-01', 'Fu-chien\r', 'RE', 225, NULL, NULL, '4010'),
(4068, 'TW-02', 'Kao-hsiung\r', 'RE', 225, NULL, NULL, '4011'),
(4069, 'TW-03', 'T''ai-pei\r', 'RE', 225, NULL, NULL, '4012'),
(4070, 'TW-04', 'T''ai-wan\r', 'RE', 225, NULL, NULL, '4013'),
(4071, 'TZ-01', 'Arusha\r', 'RE', 226, -2.62613900000, 36.17810300000, '4014'),
(4072, 'TZ-23', 'Dar es Salaam\r', 'RE', 226, NULL, NULL, '4015'),
(4073, 'TZ-03', 'Dodoma\r', 'RE', 226, NULL, NULL, '4016'),
(4074, 'TZ-04', 'Iringa\r', 'RE', 226, NULL, NULL, '4017'),
(4075, 'TZ-19', 'Kagera\r', 'RE', 226, -2.16741300000, 31.72673900000, '4018'),
(4076, 'TZ-05', 'Kigoma\r', 'RE', 226, -4.82617300000, 30.40882400000, '4019'),
(4077, 'TZ-06', 'Kilimanjaro\r', 'RE', 226, NULL, NULL, '4020'),
(4078, 'TZ-07', 'Lindi\r', 'RE', 226, -9.38883400000, 38.39711100000, '4021'),
(4079, 'TZ-08', 'Mara\r', 'RE', 226, -1.76026800000, 34.02882500000, '4022'),
(4080, 'TZ-09', 'Mbeya\r', 'RE', 226, -8.30872700000, 33.48628500000, '4023'),
(4081, 'TZ-10', 'Morogoro\r', 'RE', 226, -7.88648900000, 36.90542600000, '4024'),
(4082, 'TZ-11', 'Mtwara\r', 'RE', 226, NULL, NULL, '4025'),
(4083, 'TZ-12', 'Mwanza\r', 'RE', 226, NULL, NULL, '4026'),
(4084, 'TZ-13', 'Pemba North\r', 'RE', 226, -5.03623900000, 39.74520500000, '4027'),
(4085, 'TZ-20', 'Pemba South\r', 'RE', 226, -5.32951000000, 39.72040300000, '4028'),
(4086, 'TZ-02', 'Pwani\r', 'RE', 226, -7.13950700000, 38.86204300000, '4029'),
(4087, 'TZ-24', 'Rukwa\r', 'RE', 226, -7.12934300000, 31.35135100000, '4030'),
(4088, 'TZ-14', 'Ruvuma\r', 'RE', 226, -10.46607200000, 36.30898700000, '4031'),
(4089, 'TZ-15', 'Shinyanga\r', 'RE', 226, -3.35923600000, 33.20516100000, '4032'),
(4090, 'TZ-16', 'Singida\r', 'RE', 226, -5.68591400000, 34.40522400000, '4033'),
(4091, 'TZ-17', 'Tabora\r', 'RE', 226, -6.92311100000, 32.52961000000, '4034'),
(4092, 'TZ-18', 'Tanga\r', 'RE', 226, NULL, NULL, '4035'),
(4093, 'TZ-21', 'Zanzibar Central\r', 'RE', 226, -6.26568700000, 39.42446300000, '4036'),
(4094, 'TZ-22', 'Zanzibar North\r', 'RE', 226, -5.90116000000, 39.29779000000, '4037'),
(4095, 'TZ-25', 'Zanzibar Urban\r', 'RE', 226, NULL, NULL, '4038'),
(4096, 'UA-01', 'Cherkas''ka Oblast''\r', 'RE', 227, NULL, NULL, '4039'),
(4097, 'UA-02', 'Chernihivs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4040'),
(4098, 'UA-03', 'Chernivets''ka Oblast''\r', 'RE', 227, NULL, NULL, '4041'),
(4099, 'UA-04', 'Dnipropetrovs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4042'),
(4100, 'UA-05', 'Donets''ka Oblast''\r', 'RE', 227, NULL, NULL, '4043'),
(4101, 'UA-06', 'Ivano-Frankivs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4044'),
(4102, 'UA-07', 'Kharkivs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4045'),
(4103, 'UA-08', 'Khersons''ka Oblast''\r', 'RE', 227, NULL, NULL, '4046'),
(4104, 'UA-09', 'Khmel''nyts''ka Oblast''\r', 'RE', 227, NULL, NULL, '4047'),
(4105, 'UA-10', 'Kirovohrads''ka Oblast''\r', 'RE', 227, NULL, NULL, '4048'),
(4106, 'UA-11', 'Krym\r', 'RE', 227, 45.37321100000, 36.62501100000, '4049'),
(4107, 'UA-12', 'Kyyiv\r', 'RE', 227, 50.45362900000, 30.50382800000, '4050'),
(4108, 'UA-13', 'Kyyivs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4051'),
(4109, 'UA-15', 'L''vivs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4052'),
(4110, 'UA-14', 'Luhans''ka Oblast''\r', 'RE', 227, NULL, NULL, '4053'),
(4111, 'UA-16', 'Mykolayivs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4054'),
(4112, 'UA-17', 'Odes''ka Oblast''\r', 'RE', 227, NULL, NULL, '4055'),
(4113, 'UA-18', 'Poltavs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4056'),
(4114, 'UA-19', 'Rivnens''ka Oblast''\r', 'RE', 227, NULL, NULL, '4057'),
(4115, 'UA-20', 'Sevastopol''\r', 'RE', 227, NULL, NULL, '4058'),
(4116, 'UA-21', 'Sums''ka Oblast''\r', 'RE', 227, NULL, NULL, '4059'),
(4117, 'UA-22', 'Ternopil''s''ka Oblast''\r', 'RE', 227, NULL, NULL, '4060'),
(4118, 'UA-23', 'Vinnyts''ka Oblast''\r', 'RE', 227, NULL, NULL, '4061'),
(4119, 'UA-24', 'Volyns''ka Oblast''\r', 'RE', 227, NULL, NULL, '4062'),
(4120, 'UA-25', 'Zakarpats''ka Oblast''\r', 'RE', 227, NULL, NULL, '4063'),
(4121, 'UA-26', 'Zaporiz''ka Oblast''\r', 'RE', 227, NULL, NULL, '4064'),
(4122, 'UA-27', 'Zhytomyrs''ka Oblast''\r', 'RE', 227, NULL, NULL, '4065'),
(4123, 'UG-65', 'Adjumani\r', 'RE', 228, 3.22996900000, 31.76233800000, '4066'),
(4124, 'UG-77', 'Arua\r', 'RE', 228, 3.02238000000, 30.90199000000, '4067'),
(4125, 'UG-66', 'Bugiri\r', 'RE', 228, 1.08333300000, 33.71666700000, '4068'),
(4126, 'UG-67', 'Busia\r', 'RE', 228, 0.38222600000, 34.00763700000, '4069'),
(4127, 'UG-05', 'Busoga\r', 'RE', 228, NULL, NULL, '4070'),
(4128, 'UG-18', 'Central\r', 'RE', 228, NULL, NULL, '4071'),
(4129, 'UG-20', 'Eastern\r', 'RE', 228, NULL, NULL, '4072'),
(4130, 'UG-78', 'Iganga\r', 'RE', 228, 0.75659000000, 33.55050600000, '4073'),
(4131, 'UG-79', 'Kabarole\r', 'RE', 228, 0.59854500000, 30.27455600000, '4074'),
(4132, 'UG-80', 'Kaberamaido\r', 'RE', 228, 1.76330000000, 33.15060000000, '4075'),
(4133, 'UG-37', 'Kampala\r', 'RE', 228, NULL, NULL, '4076'),
(4134, 'UG-81', 'Kamwenge\r', 'RE', 228, 0.18975100000, 30.54713000000, '4077'),
(4135, 'UG-82', 'Kanungu\r', 'RE', 228, -0.72602100000, 29.73710500000, '4078'),
(4136, 'UG-08', 'Karamoja\r', 'RE', 228, NULL, NULL, '4079'),
(4137, 'UG-69', 'Katakwi\r', 'RE', 228, 2.00888100000, 33.78649800000, '4080'),
(4138, 'UG-83', 'Kayunga\r', 'RE', 228, NULL, NULL, '4081'),
(4139, 'UG-84', 'Kitgum\r', 'RE', 228, 3.44814800000, 32.95499400000, '4082'),
(4140, 'UG-85', 'Kyenjojo\r', 'RE', 228, 0.54824100000, 30.85638000000, '4083'),
(4141, 'UG-86', 'Mayuge\r', 'RE', 228, -0.20551500000, 33.49898300000, '4084'),
(4142, 'UG-87', 'Mbale\r', 'RE', 228, 1.07805500000, 34.16951500000, '4085'),
(4143, 'UG-88', 'Moroto\r', 'RE', 228, 2.53349500000, 34.64877400000, '4086'),
(4144, 'UG-89', 'Mpigi\r', 'RE', 228, 0.20035800000, 32.03273800000, '4087'),
(4145, 'UG-90', 'Mukono\r', 'RE', 228, NULL, NULL, '4088'),
(4146, 'UG-91', 'Nakapiripirit\r', 'RE', 228, 1.83314900000, 34.63229400000, '4089'),
(4147, 'UG-73', 'Nakasongola\r', 'RE', 228, 1.28816100000, 32.38446000000, '4090'),
(4148, 'UG-21', 'Nile\r', 'RE', 228, NULL, NULL, '4091'),
(4149, 'UG-22', 'North Buganda\r', 'RE', 228, NULL, NULL, '4092'),
(4150, 'UG-23', 'Northern\r', 'RE', 228, NULL, NULL, '4093'),
(4151, 'UG-92', 'Pader\r', 'RE', 228, 2.90374700000, 33.04011100000, '4094'),
(4152, 'UG-93', 'Rukungiri\r', 'RE', 228, -0.72177700000, 29.89329700000, '4095'),
(4153, 'UG-74', 'Sembabule\r', 'RE', 228, -0.07872300000, 31.32080300000, '4096'),
(4154, 'UG-94', 'Sironko\r', 'RE', 228, 1.29575800000, 34.36553200000, '4097'),
(4155, 'UG-95', 'Soroti\r', 'RE', 228, 1.71199800000, 33.60819600000, '4098'),
(4156, 'UG-12', 'South Buganda\r', 'RE', 228, NULL, NULL, '4099'),
(4157, 'UG-24', 'Southern\r', 'RE', 228, NULL, NULL, '4100'),
(4158, 'UG-96', 'Wakiso\r', 'RE', 228, NULL, NULL, '4101'),
(4159, 'UG-25', 'Western\r', 'RE', 228, 0.52840500000, 34.54489700000, '4102'),
(4160, 'UG-97', 'Yumbe\r', 'RE', 228, 3.45479600000, 31.33932800000, '4103'),
(4161, 'US-AL', 'Alabama\r', 'RE', 230, NULL, NULL, '4104'),
(4162, 'US-AK', 'Alaska\r', 'RE', 230, NULL, NULL, '4105'),
(4163, 'US-AS', 'American Samoa\r', 'RE', 230, NULL, NULL, '4106'),
(4164, 'US-AZ', 'Arizona\r', 'RE', 230, NULL, NULL, '4107'),
(4165, 'US-AR', 'Arkansas\r', 'RE', 230, NULL, NULL, '4108'),
(4166, 'US-AA', 'Armed Forces Americas\r', 'RE', 230, NULL, NULL, '4109'),
(4167, 'US-AE', 'Armed Forces Europe, Middle East, & Canada\r', 'RE', 230, NULL, NULL, '4110'),
(4168, 'US-AP', 'Armed Forces Pacific\r', 'RE', 230, NULL, NULL, '4111'),
(4169, 'US-CA', 'California\r', 'RE', 230, NULL, NULL, '4112'),
(4170, 'US-CO', 'Colorado\r', 'RE', 230, NULL, NULL, '4113'),
(4171, 'US-CT', 'Connecticut\r', 'RE', 230, NULL, NULL, '4114'),
(4172, 'US-DE', 'Delaware\r', 'RE', 230, NULL, NULL, '4115'),
(4173, 'US-DC', 'District of Columbia\r', 'RE', 230, NULL, NULL, '4116'),
(4174, 'US-FM', 'Federated States of Micronesia\r', 'RE', 230, NULL, NULL, '4117'),
(4175, 'US-FL', 'Florida\r', 'RE', 230, NULL, NULL, '4118'),
(4176, 'US-GA', 'Georgia\r', 'RE', 230, NULL, NULL, '4119'),
(4177, 'US-GU', 'Guam\r', 'RE', 230, 36.90214800000, -89.82387500000, '4120'),
(4178, 'US-HI', 'Hawaii\r', 'RE', 230, NULL, NULL, '4121'),
(4179, 'US-ID', 'Idaho\r', 'RE', 230, NULL, NULL, '4122'),
(4180, 'US-IL', 'Illinois\r', 'RE', 230, NULL, NULL, '4123'),
(4181, 'US-IN', 'Indiana\r', 'RE', 230, NULL, NULL, '4124'),
(4182, 'US-IA', 'Iowa\r', 'RE', 230, NULL, NULL, '4125'),
(4183, 'US-KS', 'Kansas\r', 'RE', 230, NULL, NULL, '4126'),
(4184, 'US-KY', 'Kentucky\r', 'RE', 230, NULL, NULL, '4127'),
(4185, 'US-LA', 'Louisiana\r', 'RE', 230, NULL, NULL, '4128'),
(4186, 'US-ME', 'Maine\r', 'RE', 230, NULL, NULL, '4129'),
(4187, 'US-MH', 'Marshall Islands\r', 'RE', 230, 42.38076200000, -70.98954400000, '4130'),
(4188, 'US-MD', 'Maryland\r', 'RE', 230, NULL, NULL, '4131'),
(4189, 'US-MA', 'Massachusetts\r', 'RE', 230, NULL, NULL, '4132'),
(4190, 'US-MI', 'Michigan\r', 'RE', 230, NULL, NULL, '4133'),
(4191, 'US-MN', 'Minnesota\r', 'RE', 230, NULL, NULL, '4134'),
(4192, 'US-MS', 'Mississippi\r', 'RE', 230, NULL, NULL, '4135'),
(4193, 'US-MO', 'Missouri\r', 'RE', 230, NULL, NULL, '4136'),
(4194, 'US-MT', 'Montana\r', 'RE', 230, NULL, NULL, '4137'),
(4195, 'US-NE', 'Nebraska\r', 'RE', 230, NULL, NULL, '4138'),
(4196, 'US-NV', 'Nevada\r', 'RE', 230, NULL, NULL, '4139'),
(4197, 'US-NH', 'New Hampshire\r', 'RE', 230, NULL, NULL, '4140'),
(4198, 'US-NJ', 'New Jersey\r', 'RE', 230, NULL, NULL, '4141'),
(4199, 'US-NM', 'New Mexico\r', 'RE', 230, NULL, NULL, '4142'),
(4200, 'US-NY', 'New York\r', 'RE', 230, NULL, NULL, '4143'),
(4201, 'US-NC', 'North Carolina\r', 'RE', 230, NULL, NULL, '4144'),
(4202, 'US-ND', 'North Dakota\r', 'RE', 230, NULL, NULL, '4145'),
(4203, 'US-MP', 'Northern Mariana Islands\r', 'RE', 230, NULL, NULL, '4146'),
(4204, 'US-OH', 'Ohio\r', 'RE', 230, NULL, NULL, '4147'),
(4205, 'US-OK', 'Oklahoma\r', 'RE', 230, NULL, NULL, '4148'),
(4206, 'US-OR', 'Oregon\r', 'RE', 230, NULL, NULL, '4149'),
(4207, 'US-PW', 'Palau\r', 'RE', 230, NULL, NULL, '4150'),
(4208, 'US-PA', 'Pennsylvania\r', 'RE', 230, NULL, NULL, '4151'),
(4209, 'US-PR', 'Puerto Rico\r', 'RE', 230, 18.19975500000, -66.58362800000, '4152'),
(4210, 'US-RI', 'Rhode Island\r', 'RE', 230, NULL, NULL, '4153'),
(4211, 'US-SC', 'South Carolina\r', 'RE', 230, NULL, NULL, '4154'),
(4212, 'US-SD', 'South Dakota\r', 'RE', 230, NULL, NULL, '4155'),
(4213, 'US-TN', 'Tennessee\r', 'RE', 230, NULL, NULL, '4156'),
(4214, 'US-TX', 'Texas\r', 'RE', 230, NULL, NULL, '4157'),
(4215, 'US-UT', 'Utah\r', 'RE', 230, NULL, NULL, '4158'),
(4216, 'US-VT', 'Vermont\r', 'RE', 230, NULL, NULL, '4159'),
(4217, 'US-VI', 'Virgin Islands\r', 'RE', 230, 39.95529300000, -74.23205400000, '4160'),
(4218, 'US-VA', 'Virginia\r', 'RE', 230, NULL, NULL, '4161'),
(4219, 'US-WA', 'Washington\r', 'RE', 230, NULL, NULL, '4162'),
(4220, 'US-WV', 'West Virginia\r', 'RE', 230, NULL, NULL, '4163'),
(4221, 'US-WI', 'Wisconsin\r', 'RE', 230, NULL, NULL, '4164'),
(4222, 'US-WY', 'Wyoming\r', 'RE', 230, NULL, NULL, '4165'),
(4223, 'UY-01', 'Artigas\r', 'RE', 231, -30.40996000000, -56.47282000000, '4166'),
(4224, 'UY-02', 'Canelones\r', 'RE', 231, NULL, NULL, '4167'),
(4225, 'UY-03', 'Cerro Largo\r', 'RE', 231, NULL, NULL, '4168'),
(4226, 'UY-04', 'Colonia\r', 'RE', 231, NULL, NULL, '4169'),
(4227, 'UY-05', 'Durazno\r', 'RE', 231, NULL, NULL, '4170'),
(4228, 'UY-06', 'Flores\r', 'RE', 231, -33.54609700000, -56.87835100000, '4171'),
(4229, 'UY-07', 'Florida\r', 'RE', 231, NULL, NULL, '4172'),
(4230, 'UY-08', 'Lavalleja\r', 'RE', 231, NULL, NULL, '4173'),
(4231, 'UY-09', 'Maldonado\r', 'RE', 231, NULL, NULL, '4174'),
(4232, 'UY-10', 'Montevideo\r', 'RE', 231, NULL, NULL, '4175'),
(4233, 'UY-11', 'Paysandu\r', 'RE', 231, -32.31775500000, -58.07683600000, '4176'),
(4234, 'UY-12', 'Rio Negro\r', 'RE', 231, -32.87060300000, -57.48390800000, '4177'),
(4235, 'UY-13', 'Rivera\r', 'RE', 231, NULL, NULL, '4178'),
(4236, 'UY-14', 'Rocha\r', 'RE', 231, -34.49675000000, -54.32622900000, '4179'),
(4237, 'UY-15', 'Salto\r', 'RE', 231, NULL, NULL, '4180'),
(4238, 'UY-16', 'San Jose\r', 'RE', 231, -34.30356400000, -56.76173900000, '4181'),
(4239, 'UY-17', 'Soriano\r', 'RE', 231, NULL, NULL, '4182'),
(4240, 'UY-18', 'Tacuarembo\r', 'RE', 231, -31.69783500000, -55.96400400000, '4183'),
(4241, 'UY-19', 'Treinta y Tres\r', 'RE', 231, -33.23148000000, -54.37455000000, '4184'),
(4242, 'UZ-01', 'Andijon\r', 'RE', 232, NULL, NULL, '4185'),
(4243, 'UZ-02', 'Bukhoro\r', 'RE', 232, NULL, NULL, '4186'),
(4244, 'UZ-03', 'Farghona\r', 'RE', 232, NULL, NULL, '4187'),
(4245, 'UZ-04', 'Jizzakh\r', 'RE', 232, NULL, NULL, '4188'),
(4246, 'UZ-05', 'Khorazm\r', 'RE', 232, NULL, NULL, '4189'),
(4247, 'UZ-06', 'Namangan\r', 'RE', 232, 41.10049000000, 71.26251200000, '4190'),
(4248, 'UZ-07', 'Nawoiy\r', 'RE', 232, NULL, NULL, '4191'),
(4249, 'UZ-08', 'Qashqadaryo\r', 'RE', 232, NULL, NULL, '4192'),
(4250, 'UZ-09', 'Qoraqalpoghiston\r', 'RE', 232, NULL, NULL, '4193'),
(4251, 'UZ-10', 'Samarqand\r', 'RE', 232, NULL, NULL, '4194'),
(4252, 'UZ-11', 'Sirdaryo\r', 'RE', 232, 40.52603000000, 68.60426300000, '4195'),
(4253, 'UZ-12', 'Surkhondaryo\r', 'RE', 232, NULL, NULL, '4196'),
(4254, 'UZ-13', 'Toshkent\r', 'RE', 232, NULL, NULL, '4197'),
(4255, 'VC-01', 'Charlotte\r', 'RE', 234, 13.32435000000, -61.14800000000, '4198'),
(4256, 'VC-06', 'Grenadines\r', 'RE', 234, NULL, NULL, '4199'),
(4257, 'VC-02', 'Saint Andrew\r', 'RE', 234, NULL, NULL, '4200'),
(4258, 'VC-03', 'Saint David\r', 'RE', 234, 13.27991000000, -61.23777000000, '4201'),
(4259, 'VC-04', 'Saint George\r', 'RE', 234, NULL, NULL, '4202'),
(4260, 'VC-05', 'Saint Patrick\r', 'RE', 234, NULL, NULL, '4203'),
(4261, 'VE-01', 'Amazonas\r', 'RE', 235, NULL, NULL, '4204'),
(4262, 'VE-02', 'Anzoategui\r', 'RE', 235, NULL, NULL, '4205'),
(4263, 'VE-03', 'Apure\r', 'RE', 235, NULL, NULL, '4206'),
(4264, 'VE-04', 'Aragua\r', 'RE', 235, NULL, NULL, '4207'),
(4265, 'VE-05', 'Barinas\r', 'RE', 235, NULL, NULL, '4208'),
(4266, 'VE-06', 'Bolivar\r', 'RE', 235, NULL, NULL, '4209'),
(4267, 'VE-07', 'Carabobo\r', 'RE', 235, NULL, NULL, '4210'),
(4268, 'VE-08', 'Cojedes\r', 'RE', 235, NULL, NULL, '4211'),
(4269, 'VE-09', 'Delta Amacuro\r', 'RE', 235, 8.83746300000, -61.15621700000, '4212'),
(4270, 'VE-24', 'Dependencias Federales\r', 'RE', 235, NULL, NULL, '4213'),
(4271, 'VE-25', 'Distrito Federal\r', 'RE', 235, NULL, NULL, '4214'),
(4272, 'VE-11', 'Falcon\r', 'RE', 235, NULL, NULL, '4215'),
(4273, 'VE-12', 'Guarico\r', 'RE', 235, NULL, NULL, '4216'),
(4274, 'VE-13', 'Lara\r', 'RE', 235, NULL, NULL, '4217'),
(4275, 'VE-14', 'Merida\r', 'RE', 235, NULL, NULL, '4218'),
(4276, 'VE-15', 'Miranda\r', 'RE', 235, NULL, NULL, '4219'),
(4277, 'VE-16', 'Monagas\r', 'RE', 235, NULL, NULL, '4220'),
(4278, 'VE-17', 'Nueva Esparta\r', 'RE', 235, NULL, NULL, '4221'),
(4279, 'VE-18', 'Portuguesa\r', 'RE', 235, NULL, NULL, '4222'),
(4280, 'VE-19', 'Sucre\r', 'RE', 235, NULL, NULL, '4223'),
(4281, 'VE-20', 'Tachira\r', 'RE', 235, NULL, NULL, '4224'),
(4282, 'VE-21', 'Trujillo\r', 'RE', 235, NULL, NULL, '4225'),
(4283, 'VE-26', 'Vargas\r', 'RE', 235, NULL, NULL, '4226'),
(4284, 'VE-22', 'Yaracuy\r', 'RE', 235, NULL, NULL, '4227'),
(4285, 'VE-23', 'Zulia\r', 'RE', 235, NULL, NULL, '4228'),
(4286, 'VN-43', 'An Giang\r', 'RE', 238, 10.58520200000, 105.16358800000, '4229'),
(4287, 'VN-53', 'Ba Ria-Vung Tau\r', 'RE', 238, 10.57582200000, 107.30483800000, '4230'),
(4288, 'VN-02', 'Bac Thai\r', 'RE', 238, NULL, NULL, '4231'),
(4289, 'VN-03', 'Ben Tre\r', 'RE', 238, NULL, NULL, '4232'),
(4290, 'VN-54', 'Binh Dinh\r', 'RE', 238, NULL, NULL, '4233'),
(4291, 'VN-55', 'Binh Thuan\r', 'RE', 238, 10.79462800000, 108.26224500000, '4234'),
(4292, 'VN-56', 'Can Tho\r', 'RE', 238, 9.98101800000, 105.58881000000, '4235'),
(4293, 'VN-05', 'Cao Bang\r', 'RE', 238, 22.71812900000, 106.04347800000, '4236'),
(4294, 'VN-44', 'Dac Lac\r', 'RE', 238, NULL, NULL, '4237'),
(4295, 'VN-45', 'Dong Nai\r', 'RE', 238, NULL, NULL, '4238'),
(4296, 'VN-46', 'Dong Thap\r', 'RE', 238, NULL, NULL, '4239'),
(4297, 'VN-57', 'Gia Lai\r', 'RE', 238, 13.87101600000, 108.17330500000, '4240'),
(4298, 'VN-11', 'Ha Bac\r', 'RE', 238, NULL, NULL, '4241'),
(4299, 'VN-58', 'Ha Giang\r', 'RE', 238, NULL, NULL, '4242'),
(4300, 'VN-51', 'Ha Noi\r', 'RE', 238, 21.00687500000, 105.82513000000, '4243'),
(4301, 'VN-59', 'Ha Tay\r', 'RE', 238, 20.91777200000, 105.63890000000, '4244'),
(4302, 'VN-60', 'Ha Tinh\r', 'RE', 238, NULL, NULL, '4245'),
(4303, 'VN-12', 'Hai Hung\r', 'RE', 238, NULL, NULL, '4246'),
(4304, 'VN-13', 'Hai Phong\r', 'RE', 238, NULL, NULL, '4247'),
(4305, 'VN-52', 'Ho Chi Minh\r', 'RE', 238, 10.75800000000, 106.65340000000, '4248'),
(4306, 'VN-61', 'Hoa Binh\r', 'RE', 238, 20.71785400000, 105.31692000000, '4249'),
(4307, 'VN-62', 'Khanh Hoa\r', 'RE', 238, 12.37250000000, 109.08447900000, '4250'),
(4308, 'VN-47', 'Kien Giang\r', 'RE', 238, 9.97125100000, 104.68408400000, '4251'),
(4309, 'VN-63', 'Kon Tum\r', 'RE', 238, NULL, NULL, '4252'),
(4310, 'VN-22', 'Lai Chau\r', 'RE', 238, NULL, NULL, '4253'),
(4311, 'VN-23', 'Lam Dong\r', 'RE', 238, NULL, NULL, '4254'),
(4312, 'VN-39', 'Lang Son\r', 'RE', 238, NULL, NULL, '4255'),
(4313, 'VN-64', 'Lao Cai\r', 'RE', 238, 22.26141200000, 104.06737500000, '4256'),
(4314, 'VN-24', 'Long An\r', 'RE', 238, 10.72473100000, 106.13171000000, '4257'),
(4315, 'VN-48', 'Minh Hai\r', 'RE', 238, NULL, NULL, '4258'),
(4316, 'VN-65', 'Nam Ha\r', 'RE', 238, NULL, NULL, '4259'),
(4317, 'VN-66', 'Nghe An\r', 'RE', 238, NULL, NULL, '4260'),
(4318, 'VN-67', 'Ninh Binh\r', 'RE', 238, NULL, NULL, '4261'),
(4319, 'VN-68', 'Ninh Thuan\r', 'RE', 238, 11.77486300000, 108.92239300000, '4262'),
(4320, 'VN-69', 'Phu Yen\r', 'RE', 238, NULL, NULL, '4263'),
(4321, 'VN-70', 'Quang Binh\r', 'RE', 238, 17.48857700000, 106.29713800000, '4264'),
(4322, 'VN-29', 'Quang Nam-Da Nang\r', 'RE', 238, NULL, NULL, '4265'),
(4323, 'VN-71', 'Quang Ngai\r', 'RE', 238, NULL, NULL, '4266'),
(4324, 'VN-30', 'Quang Ninh\r', 'RE', 238, 21.19007700000, 107.25710500000, '4267'),
(4325, 'VN-72', 'Quang Tri\r', 'RE', 238, 16.74016900000, 106.95133200000, '4268'),
(4326, 'VN-73', 'Soc Trang\r', 'RE', 238, 9.58194000000, 105.91780100000, '4269'),
(4327, 'VN-32', 'Son La\r', 'RE', 238, NULL, NULL, '4270'),
(4328, 'VN-49', 'Song Be\r', 'RE', 238, NULL, NULL, '4271'),
(4329, 'VN-33', 'Tay Ninh\r', 'RE', 238, 11.36344600000, 106.15206000000, '4272'),
(4330, 'VN-35', 'Thai Binh\r', 'RE', 238, NULL, NULL, '4273'),
(4331, 'VN-34', 'Thanh Hoa\r', 'RE', 238, NULL, NULL, '4274'),
(4332, 'VN-74', 'Thua Thien\r', 'RE', 238, NULL, NULL, '4275'),
(4333, 'VN-37', 'Tien Giang\r', 'RE', 238, NULL, NULL, '4276'),
(4334, 'VN-75', 'Tra Vinh\r', 'RE', 238, 9.82305300000, 106.31852500000, '4277'),
(4335, 'VN-76', 'Tuyen Quang\r', 'RE', 238, 22.06427200000, 105.20504000000, '4278'),
(4336, 'VN-77', 'Vinh Long\r', 'RE', 238, 10.11007300000, 105.98819000000, '4279'),
(4337, 'VN-50', 'Vinh Phu\r', 'RE', 238, 9.93422700000, 106.33390000000, '4280'),
(4338, 'VN-78', 'Yen Bai\r', 'RE', 238, NULL, NULL, '4281'),
(4339, 'VU-05', 'Ambrym\r', 'RE', 239, NULL, NULL, '4282'),
(4340, 'VU-06', 'Aoba\r', 'RE', 239, NULL, NULL, '4283'),
(4341, 'VU-08', 'Efate\r', 'RE', 239, NULL, NULL, '4284'),
(4342, 'VU-09', 'Epi\r', 'RE', 239, -16.75000000000, 168.33333300000, '4285'),
(4343, 'VU-10', 'Malakula\r', 'RE', 239, NULL, NULL, '4286'),
(4344, 'VU-16', 'Malampa\r', 'RE', 239, NULL, NULL, '4287'),
(4345, 'VU-11', 'Paama\r', 'RE', 239, -16.47608500000, 168.23692300000, '4288'),
(4346, 'VU-17', 'Penama\r', 'RE', 239, NULL, NULL, '4289'),
(4347, 'VU-12', 'Pentecote\r', 'RE', 239, NULL, NULL, '4290'),
(4348, 'VU-13', 'Sanma\r', 'RE', 239, NULL, NULL, '4291'),
(4349, 'VU-18', 'Shefa\r', 'RE', 239, NULL, NULL, '4292'),
(4350, 'VU-14', 'Shepherd\r', 'RE', 239, NULL, NULL, '4293'),
(4351, 'VU-15', 'Tafea\r', 'RE', 239, NULL, NULL, '4294'),
(4352, 'VU-07', 'Torba\r', 'RE', 239, NULL, NULL, '4295'),
(4353, 'WS-02', 'Aiga-i-le-Tai\r', 'RE', 241, NULL, NULL, '4296'),
(4354, 'WS-03', 'Atua\r', 'RE', 241, NULL, NULL, '4297'),
(4355, 'WS-04', 'Fa\r', 'RE', 241, NULL, NULL, '4298'),
(4356, 'WS-05', 'Gaga\r', 'RE', 241, NULL, NULL, '4299'),
(4357, 'WS-07', 'Gagaifomauga\r', 'RE', 241, NULL, NULL, '4300'),
(4358, 'WS-08', 'Palauli\r', 'RE', 241, NULL, NULL, '4301'),
(4359, 'WS-09', 'Satupa\r', 'RE', 241, NULL, NULL, '4302'),
(4360, 'WS-10', 'Tuamasaga\r', 'RE', 241, NULL, NULL, '4303'),
(4361, 'WS-06', 'Va\r', 'RE', 241, 37.82627400000, -81.15970900000, '4304'),
(4362, 'WS-11', 'Vaisigano\r', 'RE', 241, NULL, NULL, '4305'),
(4363, 'YE-01', 'Abyan\r', 'RE', 242, NULL, NULL, '4306'),
(4364, 'YE-20', 'Al Bayda''\r', 'RE', 242, 14.24498500000, 48.79494300000, '4307'),
(4365, 'YE-08', 'Al Hudaydah\r', 'RE', 242, 14.79497000000, 42.94640000000, '4308'),
(4366, 'YE-21', 'Al Jawf\r', 'RE', 242, 18.22000000000, 43.18000000000, '4309'),
(4367, 'YE-03', 'Al Mahrah\r', 'RE', 242, NULL, NULL, '4310'),
(4368, 'YE-10', 'Al Mahwit\r', 'RE', 242, NULL, NULL, '4311'),
(4369, 'YE-11', 'Dhamar\r', 'RE', 242, NULL, NULL, '4312'),
(4370, 'YE-04', 'Hadramawt\r', 'RE', 242, NULL, NULL, '4313'),
(4371, 'YE-22', 'Hajjah\r', 'RE', 242, 15.69750000000, 43.59910000000, '4314'),
(4372, 'YE-23', 'Ibb\r', 'RE', 242, 13.96440000000, 44.18200000000, '4315'),
(4373, 'YE-24', 'Lahij\r', 'RE', 242, 13.05410000000, 44.88410000000, '4316'),
(4374, 'YE-14', 'Ma''rib\r', 'RE', 242, NULL, NULL, '4317'),
(4375, 'YE-15', 'Sa\r', 'RE', 242, 16.18333300000, 43.36666700000, '4318'),
(4376, 'YE-16', 'San\r', 'RE', 242, NULL, NULL, '4319'),
(4377, 'YE-05', 'Shabwah\r', 'RE', 242, NULL, NULL, '4320'),
(4378, 'YE-25', 'Ta\r', 'RE', 242, NULL, NULL, '4321'),
(4379, 'ZA-05', 'Eastern Cape\r', 'RE', 244, NULL, NULL, '4322'),
(4380, 'ZA-03', 'Free State\r', 'RE', 244, NULL, NULL, '4323'),
(4381, 'ZA-06', 'Gauteng\r', 'RE', 244, NULL, NULL, '4324'),
(4382, 'ZA-02', 'KwaZulu-Natal\r', 'RE', 244, NULL, NULL, '4325'),
(4383, 'ZA-09', 'Limpopo\r', 'RE', 244, NULL, NULL, '4326'),
(4384, 'ZA-07', 'Mpumalanga\r', 'RE', 244, NULL, NULL, '4327'),
(4385, 'ZA-10', 'North-West\r', 'RE', 244, NULL, NULL, '4328'),
(4386, 'ZA-08', 'Northern Cape\r', 'RE', 244, NULL, NULL, '4329'),
(4387, 'ZA-11', 'Western Cape\r', 'RE', 244, NULL, NULL, '4330'),
(4388, 'ZM-02', 'Central\r', 'RE', 245, NULL, NULL, '4331'),
(4389, 'ZM-08', 'Copperbelt\r', 'RE', 245, -13.09166600000, 27.95833300000, '4332'),
(4390, 'ZM-03', 'Eastern\r', 'RE', 245, -12.64489000000, 31.85858600000, '4333'),
(4391, 'ZM-04', 'Luapula\r', 'RE', 245, NULL, NULL, '4334'),
(4392, 'ZM-09', 'Lusaka\r', 'RE', 245, NULL, NULL, '4335'),
(4393, 'ZM-06', 'North-Western\r', 'RE', 245, -12.74166700000, 24.73333300000, '4336'),
(4394, 'ZM-05', 'Northern\r', 'RE', 245, NULL, NULL, '4337'),
(4395, 'ZM-07', 'Southern\r', 'RE', 245, -16.64060500000, 26.94166600000, '4338'),
(4396, 'ZM-01', 'Western\r', 'RE', 245, NULL, NULL, '4339'),
(4397, 'ZW-09', 'Bulawayo\r', 'RE', 246, -20.16780000000, 28.58130000000, '4340'),
(4398, 'ZW-10', 'Harare', 'RE', 246, -17.83115000000, 31.06725000000, '4341'),
(4399, 'ZW-01', 'Manicaland\r', 'RE', 246, -19.06666600000, 32.20833300000, '4342'),
(4400, 'ZW-03', 'Mashonaland Central\r', 'RE', 246, -16.60266400000, 31.24837300000, '4343'),
(4401, 'ZW-04', 'Mashonaland East\r', 'RE', 246, NULL, NULL, '4344'),
(4402, 'ZW-05', 'Mashonaland West\r', 'RE', 246, -17.48817300000, 29.53247500000, '4345'),
(4403, 'ZW-08', 'Masvingo\r', 'RE', 246, -20.87941700000, 31.30833300000, '4346'),
(4404, 'ZW-06', 'Matabeleland North\r', 'RE', 246, NULL, NULL, '4347'),
(4405, 'ZW-07', 'Matabeleland South\r', 'RE', 246, -21.00693200000, 29.07500000000, '4348'),
(4406, 'ZW-02', 'Midlands\r', 'RE', 246, -19.15000000000, 29.65000000000, '4349'),
(8689, 'ZA-11-104061', 'Cape Town', 'CI', 4387, -33.91670000000, 18.41670000000, '104061'),
(8690, 'ZA-06-104062', 'Pretoria', 'CI', 4381, -25.70690000000, 28.22940000000, '104062'),
(8691, 'ZA-02-104063', 'Pietermaritzburg', 'CI', 4382, -29.61670000000, 30.38330000000, '104063'),
(8692, 'ZA-10-104064', 'Potchefstroom', 'CI', 4385, -26.71670000000, 27.10000000000, '104064'),
(8693, 'ZA-03-104065', 'Bloemfontein', 'CI', 4380, -29.13330000000, 26.20000000000, '104065'),
(8694, 'ZA-02-104066', 'Durban', 'CI', 4382, -29.85000000000, 31.01670000000, '104066'),
(8695, 'ZA-05-104067', 'Grahamstown', 'CI', 4379, -33.30000000000, 26.53330000000, '104067'),
(8696, 'ZA-11-104068', 'Stellenbosch', 'CI', 4387, -33.93330000000, 18.85000000000, '104068'),
(8697, 'ZA-06-104069', 'Sandton', 'CI', 4381, -26.05000000000, 27.96670000000, '104069'),
(8698, 'ZA-06-104070', 'Johannesburg', 'CI', 4381, -26.20000000000, 28.08330000000, '104070'),
(8699, 'ZA-05-104071', 'Uitenhage', 'CI', 4379, -33.76530000000, 25.40220000000, '104071'),
(8700, 'ZA-06-104072', 'Parkview', 'CI', 4381, -26.16670000000, 28.03330000000, '104072');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(8701, 'ZA-11-104073', 'Wynberg', 'CI', 4387, -33.98330000000, 18.40000000000, '104073'),
(8702, 'ZA-06-104074', 'Bedfordview', 'CI', 4381, -26.16670000000, 28.15000000000, '104074'),
(8703, 'ZA-11-104075', 'Parow', 'CI', 4387, -33.90000000000, 18.60000000000, '104075'),
(8704, 'ZA-06-104076', 'Vanderbijlpark', 'CI', 4381, -26.70000000000, 27.81670000000, '104076'),
(8705, 'ZA-07-104077', 'Middelburg', 'CI', 4384, -25.78330000000, 29.46670000000, '104077'),
(8706, 'ZA-06-104078', 'Marshalltown', 'CI', 4381, -26.20000000000, 28.08330000000, '104078'),
(8707, 'ZA-05-104079', 'East London', 'CI', 4379, -33.03330000000, 27.91670000000, '104079'),
(8708, 'ZA-06-104080', 'Olifantsfontein', 'CI', 4381, -25.96390000000, 28.23940000000, '104080'),
(8709, 'ZA-06-104081', 'Lynnwood', 'CI', 4381, -25.76170000000, 28.27750000000, '104081'),
(8710, 'ZA-06-104082', 'Rosslyn', 'CI', 4381, -25.62420000000, 28.09420000000, '104082'),
(8711, 'ZA-06-104083', 'Houghton', 'CI', 4381, -26.15000000000, 28.05000000000, '104083'),
(8712, 'ZA-06-104084', 'Silverton', 'CI', 4381, -25.73170000000, 28.33470000000, '104084'),
(8713, 'ZA-11-104085', 'Roggebaai', 'CI', 4387, -33.91670000000, 18.43330000000, '104085'),
(8714, 'ZA-06-104086', 'Midrand', 'CI', 4381, -25.96360000000, 28.13780000000, '104086'),
(8715, 'ZA-05-104087', 'Braamfontein', 'CI', 4379, -31.40000000000, 26.48330000000, '104087'),
(8716, 'BW-09-104088', 'Gaborone', 'CI', 759, -24.64640000000, 25.91190000000, '104088'),
(8717, 'ZA-11-104089', 'Waverley', 'CI', 4387, -33.41670000000, 19.23330000000, '104089'),
(8718, 'ZA-06-104090', 'Parktown', 'CI', 4381, -26.16670000000, 28.03330000000, '104090'),
(8719, 'ZA-05-104091', 'Hogsback', 'CI', 4379, -32.58330000000, 26.95000000000, '104091'),
(8720, 'ZA-08-104092', 'Modderfontein', 'CI', 4386, -28.81670000000, 17.16670000000, '104092'),
(8721, 'ZA-02-104093', 'Umhlanga Rocks', 'CI', 4382, -29.71670000000, 31.06670000000, '104093'),
(8722, 'NE-08-104094', 'Niamey', 'CI', 161, 13.51670000000, 2.11670000000, '104094'),
(8723, 'GA-08-104095', 'Port-Gentil', 'CI', 1339, -0.71670000000, 8.78330000000, '104095'),
(8726, 'ZA-11-104098', 'Faure', 'CI', 4387, -34.03330000000, 18.73330000000, '104098'),
(8727, 'ZA-05-104099', 'Alice', 'CI', 4379, -32.78330000000, 26.83330000000, '104099'),
(8728, 'ZA-10-104100', 'Medunsa', 'CI', 4385, -25.61890000000, 28.02280000000, '104100'),
(8729, 'ZA-05-104101', 'Port Elizabeth', 'CI', 4379, -33.96670000000, 25.58330000000, '104101'),
(8730, 'ZA-11-104102', 'Elsenburg', 'CI', 4387, -33.85000000000, 18.83330000000, '104102'),
(8731, 'ZA-06-104103', 'Craighall', 'CI', 4381, -26.11670000000, 28.01670000000, '104103'),
(8732, 'ZA-06-104104', 'Randburg', 'CI', 4381, -26.10000000000, 27.98330000000, '104104'),
(8733, 'ZA-06-104105', 'Rivonia', 'CI', 4381, -26.05000000000, 28.05000000000, '104105'),
(8734, 'ZA-11-104106', 'Claremont', 'CI', 4387, -33.98330000000, 18.46670000000, '104106'),
(8735, 'ZA-06-104107', 'Honeydew', 'CI', 4381, -26.06670000000, 27.93330000000, '104107'),
(8736, 'ZA-06-104108', 'Halfway House', 'CI', 4381, -25.98330000000, 28.11670000000, '104108'),
(8737, 'ZA-06-104109', 'Centurion', 'CI', 4381, -25.87440000000, 28.17060000000, '104109'),
(8738, 'ZA-05-104110', 'Umtata', 'CI', 4379, -31.58330000000, 28.78330000000, '104110'),
(8739, 'ZA-02-104111', 'Westville', 'CI', 4382, -29.83330000000, 30.93330000000, '104111'),
(8740, 'ZA-06-104112', 'Boksburg', 'CI', 4381, -26.21670000000, 28.25000000000, '104112'),
(8741, 'ZA-02-104113', 'Pinetown', 'CI', 4382, -29.81670000000, 30.85000000000, '104113'),
(8742, 'ZA-05-104114', 'Doornfontein', 'CI', 4379, -33.10000000000, 24.26670000000, '104114'),
(8743, 'ZA-06-104115', 'Onderstepoort', 'CI', 4381, -25.65060000000, 28.18420000000, '104115'),
(8744, 'ZA-02-104116', 'Greytown', 'CI', 4382, -29.06670000000, 30.58330000000, '104116'),
(8745, 'ZA-02-104117', 'Overport', 'CI', 4382, -29.83330000000, 31.00000000000, '104117'),
(8746, 'ZA-06-104118', 'Krugersdorp', 'CI', 4381, -26.10000000000, 27.76670000000, '104118'),
(8747, 'ZA-06-104119', 'Menlo Park', 'CI', 4381, -25.77110000000, 28.30780000000, '104119'),
(8748, 'ZA-05-104120', 'Korsten', 'CI', 4379, -33.91670000000, 25.56670000000, '104120'),
(8749, 'ZA-11-104121', 'Sunnyside', 'CI', 4387, -33.96670000000, 18.51670000000, '104121'),
(8750, 'ZA-03-104122', 'Roodepoort', 'CI', 4380, -27.16670000000, 28.16670000000, '104122'),
(8751, 'GH-08-104123', 'Tema', 'CI', 1671, 5.61670000000, -0.01670000000, '104123'),
(8752, 'GH-02-104124', 'Kumasi', 'CI', 1663, 6.68330000000, -1.61670000000, '104124'),
(8753, 'GH-09-104125', 'Takoradi', 'CI', 1672, 4.88330000000, -1.75000000000, '104125'),
(8754, 'GH-01-104126', 'Accra', 'CI', 1667, 5.55000000000, -0.21670000000, '104126'),
(8755, 'DZ-01-104127', 'Algiers', 'CI', 1147, 36.76310000000, 3.05060000000, '104127'),
(8761, 'TN-26-104133', 'Tunis', 'CI', 220, 36.80280000000, 10.17970000000, '104133'),
(8762, 'TN-26-104134', 'Ariana', 'CI', 220, 36.86250000000, 10.19560000000, '104134'),
(8764, 'MA-07-104136', 'Mohammadia', 'CI', 2439, 33.69420000000, -7.39250000000, '104136'),
(8766, 'MA-24-104138', 'Rabat', 'CI', 2460, 34.02530000000, -6.83610000000, '104138'),
(8769, 'MA-15-104141', 'Media', 'CI', 2449, 34.25000000000, -6.68330000000, '104141'),
(8770, 'MA-39-104142', 'Mansour', 'CI', 2467, 30.88330000000, -7.81670000000, '104142'),
(8773, 'MA-19-104145', 'El Jadida', 'CI', 2455, 31.28330000000, -8.86670000000, '104145'),
(8775, 'MA-07-104147', 'Anfa', 'CI', 2439, 33.59140000000, -7.67470000000, '104147'),
(8776, 'MA-07-104148', 'Mohammedia', 'CI', 2439, 33.69420000000, -7.39250000000, '104148'),
(8779, 'EG-11-104151', 'Cairo', 'CI', 1245, 30.05000000000, 31.25000000000, '104151'),
(8780, 'EG-06-104152', 'Alexandria', 'CI', 1240, 31.19810000000, 29.91920000000, '104152'),
(8781, 'KE-05-104153', 'Nairobi', 'CI', 2174, -1.28330000000, 36.81670000000, '104153'),
(8782, 'KE-08-104154', 'Eldoret', 'CI', 2177, 0.51670000000, 35.28330000000, '104154'),
(8783, 'KE-01-104155', 'Nyeri', 'CI', 2171, -0.41670000000, 36.95000000000, '104155'),
(8784, 'KE-02-104156', 'Mombasa', 'CI', 2172, -4.05000000000, 39.66670000000, '104156'),
(8786, 'CM-11-104158', 'Mbalmayo', 'CI', 923, 3.51670000000, 11.50000000000, '104158'),
(8787, 'CM-05-104159', 'Douala', 'CI', 926, 4.05030000000, 9.70000000000, '104159'),
(8788, 'CM-05-104160', 'Akwa', 'CI', 926, 4.05000000000, 9.70000000000, '104160'),
(8790, 'CM-08-104162', 'Bafoussam', 'CI', 929, 5.46670000000, 10.41670000000, '104162'),
(8791, 'ZA-06-104163', 'Kempton Park', 'CI', 4381, -26.10000000000, 28.25000000000, '104163'),
(8792, 'ZA-05-104164', 'Trust', 'CI', 4379, -31.43330000000, 27.60000000000, '104164'),
(8793, 'ZA-05-104165', 'Walmer', 'CI', 4379, -33.98330000000, 25.58330000000, '104165'),
(8794, 'ZA-11-104166', 'Elandsfontein', 'CI', 4387, -33.16670000000, 19.33330000000, '104166'),
(8795, 'ZA-06-104167', 'Maraisburg', 'CI', 4381, -26.16670000000, 27.93330000000, '104167'),
(8796, 'ZA-06-104168', 'Edenvale', 'CI', 4381, -26.13330000000, 28.18330000000, '104168'),
(8798, 'SZ-03-104170', 'Kwaluseni', 'CI', 3828, -26.48330000000, 31.33330000000, '104170'),
(8799, 'ZA-05-104171', 'Butterworth', 'CI', 4379, -32.33330000000, 28.15000000000, '104171'),
(8800, 'ZA-11-104172', 'Bellville', 'CI', 4387, -33.90000000000, 18.63330000000, '104172'),
(8801, 'ZA-03-104173', 'Welkom', 'CI', 4380, -27.98330000000, 26.73330000000, '104173'),
(8802, 'ZW-04-104174', 'Harare', 'CI', 4401, -17.81780000000, 31.04470000000, '104174'),
(8805, 'NG-11-104177', 'Abuja', 'CI', 2841, 9.17580000000, 7.18080000000, '104177'),
(8806, 'NG-32-104178', 'Saka', 'CI', 2870, 7.34060000000, 3.93560000000, '104178'),
(8807, 'SD-29-104179', 'Khartoum', 'CI', 3562, 15.58810000000, 32.53420000000, '104179'),
(8808, 'ZA-06-104180', 'Isando', 'CI', 4381, -26.15000000000, 28.20000000000, '104180'),
(8810, 'ZA-10-104182', 'Ga-Rankuwa', 'CI', 4385, -25.58830000000, 28.00780000000, '104182'),
(8811, 'ZA-10-104183', 'Mmabatho', 'CI', 4385, -25.85000000000, 25.63330000000, '104183'),
(8812, 'ZA-09-104184', 'Thohoyandou', 'CI', 4383, -22.95000000000, 30.48330000000, '104184'),
(8813, 'ZA-06-104185', 'Ferndale', 'CI', 4381, -26.08330000000, 27.98330000000, '104185'),
(8814, 'ZA-02-104186', 'New Germany', 'CI', 4382, -29.80000000000, 30.88330000000, '104186'),
(8815, 'ZA-02-104187', 'Empangeni', 'CI', 4382, -28.75000000000, 31.90000000000, '104187'),
(8816, 'ZA-06-104188', 'Vereeniging', 'CI', 4381, -26.66670000000, 27.93330000000, '104188'),
(8817, 'ZA-02-104189', 'Martin', 'CI', 4382, -30.85000000000, 30.06670000000, '104189'),
(8818, 'ZA-11-104190', 'Somerset West', 'CI', 4387, -34.08330000000, 18.85000000000, '104190'),
(8819, 'ZA-05-104191', 'Bedford', 'CI', 4379, -32.68330000000, 26.08330000000, '104191'),
(8820, 'ZA-06-104192', 'Bryanston', 'CI', 4381, -26.05000000000, 28.03330000000, '104192'),
(8821, 'ZA-02-104193', 'Kloof', 'CI', 4382, -29.78330000000, 30.83330000000, '104193'),
(8822, 'ZA-11-104194', 'Pinelands', 'CI', 4387, -33.91670000000, 18.50000000000, '104194'),
(8823, 'ZA-06-104195', 'Germiston', 'CI', 4381, -26.21670000000, 28.18330000000, '104195'),
(8824, 'ZA-11-104196', 'Stilbaai', 'CI', 4387, -34.36670000000, 21.41670000000, '104196'),
(8825, 'TZ-26-104197', 'Arusha', 'CI', 226, -3.36670000000, 36.68330000000, '104197'),
(8826, 'ZA-09-104198', 'Pietersburg', 'CI', 4383, -23.90000000000, 29.45000000000, '104198'),
(8827, 'ZA-02-104199', 'Newcastle', 'CI', 4382, -27.75000000000, 29.93330000000, '104199'),
(8828, 'ZA-05-104200', 'Beacon Bay', 'CI', 4379, -32.96670000000, 27.95000000000, '104200'),
(8829, 'ZA-05-104201', 'Westering', 'CI', 4379, -33.93780000000, 25.47560000000, '104201'),
(8830, 'SZ-01-104202', 'Mbabane', 'CI', 3826, -26.31670000000, 31.13330000000, '104202'),
(8831, 'ZA-06-104203', 'Waverly', 'CI', 4381, -26.13330000000, 28.08330000000, '104203'),
(8832, 'ZA-07-104204', 'Witbank', 'CI', 4384, -25.86670000000, 29.23330000000, '104204'),
(8833, 'ZA-06-104205', 'Morningside', 'CI', 4381, -26.06670000000, 28.05000000000, '104205'),
(8834, 'ZA-06-104206', 'Primrose', 'CI', 4381, -26.18330000000, 28.16670000000, '104206'),
(8835, 'ZA-11-104207', 'Hout Bay', 'CI', 4387, -34.03330000000, 18.35000000000, '104207'),
(8836, 'ZA-05-104208', 'Lyndhurst', 'CI', 4379, -30.73330000000, 26.50000000000, '104208'),
(8837, 'ZA-11-104209', 'Muizenberg', 'CI', 4387, -34.11670000000, 18.46670000000, '104209'),
(8838, 'MU-15-104210', 'Reduit', 'CI', 2685, -20.22750000000, 57.49250000000, '104210'),
(8839, 'ZA-06-104211', 'Monument Park', 'CI', 4381, -25.80000000000, 28.23330000000, '104211'),
(8841, 'SN-14-104213', 'Saint-Louis', 'CI', 204, 16.01890000000, -16.49530000000, '104213'),
(8842, 'NG-26-104214', 'Makurdi', 'CI', 2847, 7.73330000000, 8.53330000000, '104214'),
(8843, 'NG-53-104215', 'Ghana', 'CI', 2851, 6.16670000000, 8.61670000000, '104215'),
(8844, 'NG-32-104216', 'Ondo', 'CI', 2870, 7.10000000000, 4.83330000000, '104216'),
(8846, 'NG-28-104218', 'Owerri', 'CI', 2856, 5.48330000000, 7.03330000000, '104218'),
(8847, 'NG-50-104219', 'Port Harcourt', 'CI', 2872, 4.78920000000, 6.99860000000, '104219'),
(8849, 'NG-51-104221', 'Tara', 'CI', 2873, 13.46670000000, 6.36670000000, '104221'),
(8858, 'DZ-31-104230', 'Annaba', 'CI', 1182, 36.90000000000, 7.76670000000, '104230'),
(8861, 'DZ-04-104233', 'Skikda', 'CI', 1158, 36.87920000000, 6.90670000000, '104233'),
(8862, 'EG-03-104234', 'Ramsis', 'CI', 1237, 30.83640000000, 30.64190000000, '104234'),
(8863, 'AO-10-104235', 'Luanda', 'CI', 9, -8.83830000000, 13.23440000000, '104235'),
(8864, 'TN-23-104236', 'Sousse', 'CI', 3966, 35.82560000000, 10.64110000000, '104236'),
(8865, 'TN-16-104237', 'Monastir', 'CI', 3948, 35.78330000000, 10.83330000000, '104237'),
(8867, 'TN-19-104239', 'Nabeul', 'CI', 3959, 36.45000000000, 10.73330000000, '104239'),
(8869, 'TN-32-104241', 'Sfax', 'CI', 3963, 34.74060000000, 10.76030000000, '104241'),
(8870, 'EG-03-104242', 'Nasr', 'CI', 1237, 30.63330000000, 30.38330000000, '104242'),
(8871, 'TN-26-104243', 'Kasbah', 'CI', 220, 36.80000000000, 10.16750000000, '104243'),
(8872, 'TN-26-104244', 'Manouba', 'CI', 220, 36.80780000000, 10.10110000000, '104244'),
(8873, 'TN-03-104245', 'Kairouan', 'CI', 3950, 35.67440000000, 10.10170000000, '104245'),
(8874, 'EG-11-104246', 'Almaza', 'CI', 1245, 30.08330000000, 31.35000000000, '104246'),
(8875, 'EG-11-104247', 'Badr', 'CI', 1245, 30.13360000000, 31.73030000000, '104247'),
(8876, 'EG-04-104248', 'Fayoum', 'CI', 1238, 29.30780000000, 30.84000000000, '104248'),
(8877, 'EG-24-104249', 'Balyana', 'CI', 1260, 26.23860000000, 32.00310000000, '104249'),
(8878, 'EG-09-104250', 'Menouf', 'CI', 1243, 30.46670000000, 30.93330000000, '104250'),
(8879, 'EG-01-104251', 'Mansoura', 'CI', 1235, 31.04310000000, 31.37670000000, '104251'),
(8883, 'SN-07-104255', 'Mbour', 'CI', 3768, 14.40000000000, -16.96670000000, '104255'),
(8884, 'SN-15-104256', 'Matam', 'CI', 204, 15.66670000000, -13.25000000000, '104256'),
(8885, 'SN-07-104257', 'Nianing', 'CI', 3768, 14.35000000000, -16.93330000000, '104257'),
(8886, 'SN-07-104258', 'Joal', 'CI', 3768, 14.16670000000, -16.83330000000, '104258'),
(8887, 'SN-01-104259', 'Rufisque', 'CI', 3760, 14.71610000000, -17.27360000000, '104259'),
(8888, 'SN-11-104260', 'Touba', 'CI', 3764, 12.99280000000, -15.58720000000, '104260'),
(8889, 'SN-07-104261', 'Somone', 'CI', 3768, 14.48610000000, -17.07860000000, '104261'),
(8890, 'SN-07-104262', 'Massar', 'CI', 3768, 15.11670000000, -16.75000000000, '104262'),
(8891, 'SN-01-104263', 'Bargny', 'CI', 3760, 14.69390000000, -17.23360000000, '104263'),
(8892, 'SN-01-104264', 'Ouakam', 'CI', 3760, 14.72390000000, -17.48920000000, '104264'),
(8894, 'SN-01-104266', 'Hann', 'CI', 3760, 14.72110000000, -17.43690000000, '104266'),
(8895, 'NG-05-104267', 'Ikeja', 'CI', 2864, 6.59670000000, 3.34310000000, '104267'),
(8897, 'CM-09-104269', 'Moliko', 'CI', 931, 4.15940000000, 9.28190000000, '104269'),
(8903, 'ZA-05-104275', 'Peninsula', 'CI', 4379, -31.91670000000, 26.83330000000, '104275'),
(8904, 'ZA-06-104276', 'Soshanguve', 'CI', 4381, -25.51470000000, 28.10810000000, '104276'),
(8905, 'AO-12-104277', 'Mundo', 'CI', 345, -9.58470000000, 16.00860000000, '104277'),
(8907, 'ZA-11-104279', 'Newlands', 'CI', 4387, -33.96670000000, 18.48330000000, '104279'),
(8908, 'ZA-10-104280', 'Atlanta', 'CI', 4385, -25.20000000000, 27.56670000000, '104280'),
(8910, 'ZA-06-104282', 'Parkhurst', 'CI', 4381, -26.13330000000, 28.01670000000, '104282'),
(8911, 'ZA-11-104283', 'New Horizons', 'CI', 4387, -34.05000000000, 23.33330000000, '104283'),
(8912, 'ZA-06-104284', 'Springs', 'CI', 4381, -26.25000000000, 28.46670000000, '104284'),
(8913, 'ZA-11-104285', 'Constantia', 'CI', 4387, -34.01670000000, 18.45000000000, '104285'),
(8914, 'MU-17-104286', 'Curepipe', 'CI', 2687, -20.31470000000, 57.52030000000, '104286'),
(8915, 'MU-17-104287', 'Malherbes', 'CI', 2687, -20.30920000000, 57.52470000000, '104287'),
(8916, 'ZA-11-104288', 'Malmesbury', 'CI', 4387, -33.45000000000, 18.73330000000, '104288'),
(8917, 'ZA-11-104289', 'Woodlands', 'CI', 4387, -34.10000000000, 18.38330000000, '104289'),
(8918, 'SZ-03-104290', 'Matsapha', 'CI', 3828, -26.51670000000, 31.31670000000, '104290'),
(8919, 'LS-14-104291', 'Roma', 'CI', 2364, -29.45000000000, 27.73330000000, '104291'),
(8920, 'ZA-09-104292', 'Tzaneen', 'CI', 4383, -23.83330000000, 30.16670000000, '104292'),
(8921, 'ZA-11-104293', 'Mowbray', 'CI', 4387, -33.93330000000, 18.46670000000, '104293'),
(8922, 'ZA-11-104294', 'Rosebank', 'CI', 4387, -33.95000000000, 18.46670000000, '104294'),
(8923, 'ZA-05-104295', 'Riebeek', 'CI', 4379, -31.66670000000, 25.91670000000, '104295'),
(8924, 'ZA-11-104296', 'Oudtshoorn', 'CI', 4387, -33.58330000000, 22.20000000000, '104296'),
(8925, 'ZA-11-104297', 'Edgemead', 'CI', 4387, -33.88330000000, 18.53330000000, '104297'),
(8926, 'ZA-06-104298', 'Hatfield', 'CI', 4381, -25.74670000000, 28.22310000000, '104298'),
(8927, 'ZA-06-104299', 'Capital Park', 'CI', 4381, -25.72750000000, 28.20170000000, '104299'),
(8928, 'ZA-07-104300', 'Nelspruit', 'CI', 4384, -25.46670000000, 30.96670000000, '104300'),
(8929, 'ZA-03-104301', 'Fichardtpark', 'CI', 4380, -29.13330000000, 26.18330000000, '104301'),
(8930, 'ZA-06-104302', 'Northcliff', 'CI', 4381, -26.13330000000, 27.95000000000, '104302'),
(8931, 'ZA-11-104303', 'Bishopscourt', 'CI', 4387, -33.98330000000, 18.45000000000, '104303'),
(8932, 'ZA-06-104304', 'Laudium', 'CI', 4381, -25.78330000000, 28.10000000000, '104304'),
(8933, 'ZA-06-104305', 'Garsfontein', 'CI', 4381, -25.80080000000, 28.29560000000, '104305'),
(8934, 'ZA-03-104306', 'Lusaka', 'CI', 4380, -29.15000000000, 26.76670000000, '104306'),
(8935, 'ZA-08-104307', 'Campbell', 'CI', 4386, -28.80000000000, 23.70000000000, '104307'),
(8936, 'ZA-07-104308', 'Weltevreden', 'CI', 4384, -25.33330000000, 30.56670000000, '104308'),
(8937, 'ZA-06-104309', 'Westdene', 'CI', 4381, -26.16670000000, 27.98330000000, '104309'),
(8938, 'ZA-09-104310', 'Messina', 'CI', 4383, -22.35000000000, 30.05000000000, '104310'),
(8939, 'ZA-06-104311', 'Benoni', 'CI', 4381, -26.18330000000, 28.31670000000, '104311'),
(8940, 'ZA-02-104312', 'Mount Edgecombe', 'CI', 4382, -29.70000000000, 31.03330000000, '104312'),
(8941, 'ZA-11-104313', 'Sauer', 'CI', 4387, -32.85000000000, 18.56670000000, '104313'),
(8942, 'ZA-10-104314', 'Rustenburg', 'CI', 4385, -25.66670000000, 27.25000000000, '104314'),
(8943, 'ZA-05-104315', 'North End', 'CI', 4379, -33.93330000000, 25.60000000000, '104315'),
(8944, 'ZA-05-104316', 'Emerald Hill', 'CI', 4379, -34.00000000000, 25.55000000000, '104316'),
(8945, 'ZA-02-104317', 'Mobeni', 'CI', 4382, -29.95000000000, 30.95000000000, '104317'),
(8946, 'ZA-05-104318', 'Huguenot', 'CI', 4379, -31.08330000000, 26.60000000000, '104318'),
(8947, 'ZA-10-104319', 'Brits', 'CI', 4385, -25.63330000000, 27.78330000000, '104319'),
(8948, 'ZA-02-104320', 'Port Shepstone', 'CI', 4382, -30.75000000000, 30.45000000000, '104320'),
(8949, 'ZA-05-104321', 'Kwa-Zulu', 'CI', 4379, -31.43330000000, 29.40000000000, '104321'),
(8950, 'ZA-02-104322', 'La Lucia', 'CI', 4382, -29.73330000000, 31.05000000000, '104322'),
(8951, 'DZ-01-104323', 'Cheraga', 'CI', 1147, 36.76690000000, 2.96110000000, '104323'),
(8952, 'ZA-07-104324', 'London', 'CI', 4384, -24.76670000000, 30.86670000000, '104324'),
(8953, 'TZ-23-104325', 'Dar Es Salaam', 'CI', 4072, -6.80000000000, 39.28330000000, '104325'),
(8954, 'ZA-03-104326', 'Juta', 'CI', 4380, -30.25000000000, 26.66670000000, '104326'),
(8955, 'ZA-03-104327', 'Florida', 'CI', 4380, -29.93330000000, 26.15000000000, '104327'),
(8956, 'NA-29-104328', 'Swakopmund', 'CI', 2800, -22.68330000000, 14.53330000000, '104328'),
(8961, 'MU-19-104333', 'Goodlands', 'CI', 2689, -20.03500000000, 57.64310000000, '104333'),
(8962, 'MU-16-104334', 'Terre Rouge', 'CI', 2686, -20.04330000000, 57.56830000000, '104334'),
(8963, 'MU-16-104335', 'Triolet', 'CI', 2686, -20.05470000000, 57.54530000000, '104335'),
(8964, 'MU-17-104336', 'Beau Bassin', 'CI', 2687, -20.21940000000, 57.45830000000, '104336'),
(8966, 'MU-15-104338', 'Pailles', 'CI', 2685, -20.18560000000, 57.47720000000, '104338'),
(8967, 'MU-17-104339', 'Vacoas', 'CI', 2687, -20.29810000000, 57.47830000000, '104339'),
(8968, 'ZA-06-104340', 'Brakpan', 'CI', 4381, -26.23330000000, 28.36670000000, '104340'),
(8969, 'ZA-05-104341', 'Zwartkop', 'CI', 4379, -33.86670000000, 25.60000000000, '104341'),
(8970, 'ZA-06-104342', 'Fairland', 'CI', 4381, -26.13330000000, 27.90000000000, '104342'),
(8971, 'ZA-07-104343', 'Ermelo', 'CI', 4384, -26.53330000000, 29.98330000000, '104343'),
(8972, 'MU-19-104344', 'Piton', 'CI', 2689, -20.09030000000, 57.63030000000, '104344'),
(8973, 'MU-12-104345', 'Albion', 'CI', 2681, -20.21170000000, 57.40080000000, '104345'),
(8975, 'EG-05-104347', 'Tanta', 'CI', 1239, 30.79110000000, 30.99810000000, '104347'),
(8976, 'MA-06-104348', 'Poste', 'CI', 2438, 33.55000000000, -4.36670000000, '104348'),
(8977, 'MA-10-104349', 'Smara', 'CI', 2442, 32.15000000000, -8.25000000000, '104349'),
(8978, 'MA-40-104350', 'Charga', 'CI', 2470, 35.56530000000, -5.75640000000, '104350'),
(8982, 'BF-53-104354', 'Ouagadougou', 'CI', 558, 12.37030000000, -1.52470000000, '104354'),
(8984, 'GM-05-104356', 'Fajara', 'CI', 1681, 13.47000000000, -16.69640000000, '104356'),
(8985, 'GH-06-104357', 'Tamale', 'CI', 1668, 9.40000000000, -0.83330000000, '104357'),
(8986, 'UG-37-104358', 'Makerere', 'CI', 4133, 0.33330000000, 32.56670000000, '104358'),
(8987, 'NG-32-104359', 'Adeogun', 'CI', 2870, 7.59280000000, 3.93470000000, '104359'),
(8988, 'EG-11-104360', 'Zamalek', 'CI', 1245, 30.06670000000, 31.21670000000, '104360'),
(8989, 'SN-04-104361', 'Dial', 'CI', 3766, 16.11670000000, -13.51670000000, '104361'),
(8990, 'EG-02-104362', 'Hurghada', 'CI', 1236, 27.23890000000, 33.83610000000, '104362'),
(8991, 'EG-14-104363', 'Kafr El Sheikh', 'CI', 1249, 30.80060000000, 31.59360000000, '104363'),
(8992, 'EG-01-104364', 'Damas', 'CI', 1235, 30.80530000000, 31.32610000000, '104364'),
(8993, 'EG-21-104365', 'Kafr El-Sheikh', 'CI', 1256, 31.11140000000, 30.93640000000, '104365'),
(8994, 'EG-05-104366', 'Kafr El-Zayat', 'CI', 1239, 30.82060000000, 30.81580000000, '104366'),
(8995, 'EG-04-104367', 'Fayyoum', 'CI', 1238, 29.30780000000, 30.84000000000, '104367'),
(8996, 'KE-02-104368', 'Malindi', 'CI', 2172, -3.21670000000, 40.11670000000, '104368'),
(8997, 'EG-14-104369', 'Zagazig', 'CI', 1249, 30.59140000000, 31.51030000000, '104369'),
(8998, 'GA-01-104370', 'Libreville', 'CI', 1332, 0.38330000000, 9.45000000000, '104370'),
(8999, 'ZA-06-104371', 'Sandhurst', 'CI', 4381, -26.11670000000, 28.05000000000, '104371'),
(9000, 'TZ-25-104372', 'Zanzibar', 'CI', 4095, -6.16670000000, 39.18330000000, '104372'),
(9001, 'MU-17-104373', 'Rose Hill', 'CI', 2687, -20.24190000000, 57.47000000000, '104373'),
(9002, 'MU-16-104374', 'Baie Du Tombeau', 'CI', 2686, -20.11940000000, 57.49140000000, '104374'),
(9005, 'NG-10-104377', 'Odua', 'CI', 163, 4.92250000000, 6.45140000000, '104377'),
(9006, 'ZA-11-104378', 'Green Point', 'CI', 4387, -33.91670000000, 18.40000000000, '104378'),
(9007, 'TZ-27-104379', 'Mbezi', 'CI', 226, -3.93330000000, 35.80000000000, '104379'),
(9008, 'LY-34-104380', 'Sebha', 'CI', 2425, 27.03330000000, 14.43330000000, '104380'),
(9009, 'EG-10-104381', 'Minia', 'CI', 1244, 28.11940000000, 30.74440000000, '104381'),
(9010, 'KE-08-104382', 'Nakuru', 'CI', 2177, -0.28330000000, 36.06670000000, '104382'),
(9011, 'KE-03-104383', 'Machakos', 'CI', 2173, -1.51670000000, 37.26670000000, '104383'),
(9012, 'KE-07-104384', 'Kisumu', 'CI', 2176, -0.10000000000, 34.75000000000, '104384'),
(9013, 'KE-07-104385', 'Kisii', 'CI', 2176, -0.68330000000, 34.76670000000, '104385'),
(9014, 'KE-08-104386', 'Narok', 'CI', 2177, -1.08330000000, 35.86670000000, '104386'),
(9016, 'ZA-10-104388', 'Klerksdorp', 'CI', 4385, -26.86670000000, 26.66670000000, '104388'),
(9017, 'ZA-11-104389', 'Lansdowne', 'CI', 4387, -33.98330000000, 18.50000000000, '104389'),
(9018, 'ZA-02-104390', 'Point', 'CI', 4382, -29.86670000000, 31.05000000000, '104390'),
(9019, 'ZA-06-104391', 'Sandown', 'CI', 4381, -26.10000000000, 28.06670000000, '104391'),
(9023, 'NG-30-104395', 'Ilorin', 'CI', 2863, 8.50000000000, 4.55000000000, '104395'),
(9028, 'EG-11-104400', 'Misr', 'CI', 1245, 30.05000000000, 31.25000000000, '104400'),
(9029, 'EG-12-104401', 'Banha', 'CI', 1246, 30.46080000000, 31.18750000000, '104401'),
(9030, 'EG-23-104402', 'Qena', 'CI', 1258, 26.17000000000, 32.72720000000, '104402'),
(9031, 'EG-07-104403', 'Ismailia', 'CI', 1241, 30.58330000000, 32.26670000000, '104403'),
(9032, 'EG-15-104404', 'Suez', 'CI', 1248, 29.96670000000, 32.55000000000, '104404'),
(9035, 'EG-14-104407', 'Belbeis', 'CI', 1249, 30.41670000000, 31.56670000000, '104407'),
(9036, 'EG-14-104408', 'Hehia', 'CI', 1249, 30.67000000000, 31.58720000000, '104408'),
(9037, 'MR-06-104409', 'Nouakchott', 'CI', 2676, 18.08640000000, -15.97530000000, '104409'),
(9038, 'US-NY-104410', 'Valhalla', 'CI', 4200, 41.08770000000, -73.77680000000, '104410'),
(9039, 'US-PA-104411', 'Pittsburgh', 'CI', 4208, 40.44950000000, -79.98800000000, '104411'),
(9040, 'US-MO-104412', 'Bridgeton', 'CI', 4193, 38.76670000000, -90.42010000000, '104412'),
(9041, 'US-CA-104413', 'San Francisco', 'CI', 4169, 37.73120000000, -122.38260000000, '104413'),
(9043, 'US-PA-104415', 'Bear Lake', 'CI', 4208, 41.94910000000, -79.44480000000, '104415'),
(9044, 'US-NJ-104416', 'Piscataway', 'CI', 4198, 40.55160000000, -74.46370000000, '104416'),
(9045, 'US-NY-104417', 'Keuka Park', 'CI', 4200, 42.56690000000, -77.13250000000, '104417'),
(9046, 'US-VT-104418', 'Brattleboro', 'CI', 4216, 42.85530000000, -72.65620000000, '104418'),
(9047, 'US-MA-104419', 'Hanscom Afb', 'CI', 4189, 42.45850000000, -71.27520000000, '104419'),
(9048, 'US-TN-104420', 'Nashville', 'CI', 4213, 36.14730000000, -86.77700000000, '104420'),
(9049, 'US-CT-104421', 'Bethel', 'CI', 4171, 41.38070000000, -73.39150000000, '104421'),
(9050, 'US-NY-104422', 'Jamaica', 'CI', 4200, 40.71480000000, -73.79390000000, '104422'),
(9051, 'US-MI-104423', 'Saginaw', 'CI', 4190, 43.43120000000, -83.93370000000, '104423'),
(9052, 'US-CA-104424', 'San Jose', 'CI', 4169, 37.32390000000, -121.91440000000, '104424'),
(9053, 'US-MA-104425', 'Haverhill', 'CI', 4189, 42.75300000000, -71.08610000000, '104425'),
(9054, 'US-IL-104426', 'Chicago', 'CI', 4180, 41.92880000000, -87.63150000000, '104426'),
(9055, 'US-VA-104427', 'Richmond', 'CI', 4218, 37.58580000000, -77.48880000000, '104427'),
(9056, 'US-NJ-104428', 'Somerset', 'CI', 4198, 40.49810000000, -74.52450000000, '104428'),
(9057, 'US-OH-104429', 'Wilmington', 'CI', 4204, 39.46110000000, -83.81720000000, '104429'),
(9058, 'US-TX-104430', 'Mckinney', 'CI', 4214, 33.25420000000, -96.68630000000, '104430'),
(9059, 'US-TX-104431', 'Round Rock', 'CI', 4214, 30.51740000000, -97.63040000000, '104431'),
(9060, 'US-NY-104432', 'Rego Park', 'CI', 4200, 40.72350000000, -73.86120000000, '104432'),
(9061, 'US-NY-104433', 'Astoria', 'CI', 4200, 40.76220000000, -73.91210000000, '104433'),
(9062, 'US-NY-104434', 'Woodside', 'CI', 4200, 40.74820000000, -73.90680000000, '104434'),
(9063, 'US-PA-104435', 'Lehigh Valley', 'CI', 4208, 40.58410000000, -75.47030000000, '104435'),
(9064, 'US-MD-104436', 'Glen Burnie', 'CI', 4188, 39.16260000000, -76.63160000000, '104436'),
(9065, 'US-MA-104437', 'Boston', 'CI', 4189, 42.34960000000, -71.07460000000, '104437'),
(9066, 'US-VA-104438', 'Hampton', 'CI', 4218, 37.06270000000, -76.40520000000, '104438'),
(9067, 'US-CA-104439', 'Carlsbad', 'CI', 4169, 33.09580000000, -117.27210000000, '104439'),
(9068, 'US-PA-104440', 'Philadelphia', 'CI', 4208, 39.95240000000, -75.16530000000, '104440'),
(9069, 'US-CT-104441', 'Greenwich', 'CI', 4171, 41.08210000000, -73.66360000000, '104441'),
(9070, 'US-MD-104442', 'Baltimore', 'CI', 4188, 39.31810000000, -76.61400000000, '104442'),
(9071, 'US-TX-104443', 'The Colony', 'CI', 4214, 33.07350000000, -96.90320000000, '104443'),
(9072, 'US-NJ-104444', 'Fairfield', 'CI', 4198, 40.87670000000, -74.29740000000, '104444'),
(9073, 'US-NC-104445', 'Rocky Mount', 'CI', 4201, 35.92160000000, -77.73150000000, '104445'),
(9074, 'US-VA-104446', 'Reston', 'CI', 4218, 38.95990000000, -77.34280000000, '104446'),
(9075, 'US-OH-104447', 'Westerville', 'CI', 4204, 40.10710000000, -82.89810000000, '104447'),
(9076, 'US-TX-104448', 'San Marcos', 'CI', 4214, 29.87290000000, -98.01400000000, '104448'),
(9077, 'US-TX-104449', 'Austin', 'CI', 4214, 30.20580000000, -97.80020000000, '104449'),
(9078, 'US-IN-104450', 'Indianapolis', 'CI', 4181, 39.79300000000, -86.28530000000, '104450'),
(9079, 'US-AZ-104451', 'Chandler', 'CI', 4164, 33.32330000000, -111.82440000000, '104451'),
(9080, 'US-NJ-104452', 'Somerville', 'CI', 4198, 40.59180000000, -74.70500000000, '104452'),
(9081, 'US-PA-104453', 'Blue Bell', 'CI', 4208, 40.15760000000, -75.27570000000, '104453'),
(9082, 'US-IL-104454', 'Granville', 'CI', 4180, 41.25630000000, -89.22200000000, '104454'),
(9083, 'US-CA-104455', 'Beverly Hills', 'CI', 4169, 34.06070000000, -118.40320000000, '104455'),
(9084, 'US-MD-104456', 'Silver Spring', 'CI', 4188, 39.06490000000, -76.97980000000, '104456'),
(9085, 'US-IL-104457', 'Huntley', 'CI', 4180, 42.17590000000, -88.46080000000, '104457'),
(9086, 'US-VT-104458', 'Williston', 'CI', 4216, 44.42350000000, -73.08540000000, '104458'),
(9087, 'US-MI-104459', 'Grand Rapids', 'CI', 4190, 42.94250000000, -85.61610000000, '104459'),
(9088, 'US-FL-104460', 'Boca Raton', 'CI', 4175, 26.40950000000, -80.09420000000, '104460'),
(9089, 'US-MA-104461', 'Amesbury', 'CI', 4189, 42.85410000000, -70.95210000000, '104461'),
(9090, 'US-NJ-104462', 'New Brunswick', 'CI', 4198, 40.48350000000, -74.44320000000, '104462'),
(9091, 'US-NJ-104463', 'Princeton', 'CI', 4198, 40.37560000000, -74.65970000000, '104463'),
(9092, 'US-NJ-104464', 'Edison', 'CI', 4198, 40.51860000000, -74.34990000000, '104464'),
(9093, 'US-NJ-104465', 'Cape May', 'CI', 4198, 38.98340000000, -74.90250000000, '104465'),
(9094, 'US-NJ-104466', 'Berkeley Heights', 'CI', 4198, 40.67660000000, -74.42020000000, '104466'),
(9095, 'US-NJ-104467', 'Saddle Brook', 'CI', 4198, 40.90280000000, -74.09600000000, '104467'),
(9096, 'US-NJ-104468', 'South Plainfield', 'CI', 4198, 40.57220000000, -74.41340000000, '104468'),
(9097, 'US-NJ-104469', 'Iselin', 'CI', 4198, 40.56920000000, -74.31570000000, '104469'),
(9098, 'US-NY-104470', 'Hempstead', 'CI', 4200, 40.69630000000, -73.62070000000, '104470'),
(9099, 'US-NJ-104471', 'Moorestown', 'CI', 4198, 39.97570000000, -74.94390000000, '104471'),
(9100, 'US-NJ-104472', 'Riverside', 'CI', 4198, 40.01780000000, -74.94490000000, '104472'),
(9101, 'US-MO-104473', 'Joplin', 'CI', 4193, 37.01700000000, -94.49330000000, '104473'),
(9102, 'US-NC-104474', 'Durham', 'CI', 4201, 35.88960000000, -78.92440000000, '104474'),
(9103, 'US-NJ-104475', 'Thorofare', 'CI', 4198, 39.85020000000, -75.18950000000, '104475'),
(9104, 'US-CA-104476', 'San Diego', 'CI', 4169, 32.90140000000, -117.20790000000, '104476'),
(9105, 'US-NC-104477', 'Matthews', 'CI', 4201, 35.12350000000, -80.71360000000, '104477'),
(9106, 'US-CT-104478', 'Bristol', 'CI', 4171, 41.68160000000, -72.94050000000, '104478'),
(9107, 'US-TN-104479', 'Memphis', 'CI', 4213, 35.18500000000, -90.09360000000, '104479'),
(9108, 'US-NY-104480', 'Brooklyn', 'CI', 4200, 40.69810000000, -73.95710000000, '104480'),
(9109, 'US-NY-104481', 'Westbury', 'CI', 4200, 40.75700000000, -73.58140000000, '104481'),
(9110, 'US-PA-104482', 'King Of Prussia', 'CI', 4208, 40.09020000000, -75.39370000000, '104482'),
(9111, 'US-NY-104483', 'Uniondale', 'CI', 4200, 40.75480000000, -73.60180000000, '104483'),
(9112, 'US-MA-104484', 'Cambridge', 'CI', 4189, 42.37000000000, -71.08120000000, '104484'),
(9113, 'US-FL-104485', 'Miami', 'CI', 4175, 25.93880000000, -80.21440000000, '104485'),
(9114, 'US-CA-104486', 'Irvine', 'CI', 4169, 33.70110000000, -117.79700000000, '104486'),
(9115, 'US-CT-104487', 'Naugatuck', 'CI', 4171, 41.48780000000, -73.06270000000, '104487'),
(9116, 'US-NJ-104488', 'Jersey City', 'CI', 4198, 40.72910000000, -74.03860000000, '104488'),
(9117, 'US-MA-104489', 'Needham Heights', 'CI', 4189, 42.29700000000, -71.21960000000, '104489'),
(9118, 'US-MA-104490', 'Danvers', 'CI', 4189, 42.57670000000, -70.95490000000, '104490'),
(9119, 'US-CT-104491', 'Branford', 'CI', 4171, 41.28640000000, -72.79560000000, '104491'),
(9120, 'US-RI-104492', 'Providence', 'CI', 4210, 41.81950000000, -71.41070000000, '104492'),
(9121, 'US-MA-104493', 'Waltham', 'CI', 4189, 42.40300000000, -71.25900000000, '104493'),
(9122, 'US-MA-104494', 'Middleton', 'CI', 4189, 42.60250000000, -71.01190000000, '104494'),
(9123, 'US-MA-104495', 'Chelsea', 'CI', 4189, 42.39970000000, -71.03160000000, '104495'),
(9124, 'US-MA-104496', 'Newburyport', 'CI', 4189, 42.81350000000, -70.88600000000, '104496'),
(9125, 'US-MA-104497', 'Bedford', 'CI', 4189, 42.48780000000, -71.27640000000, '104497'),
(9126, 'US-OR-104498', 'North Bend', 'CI', 4206, 43.48360000000, -124.16330000000, '104498'),
(9127, 'US-MA-104499', 'Medway', 'CI', 4189, 42.15560000000, -71.42680000000, '104499'),
(9128, 'US-NY-104500', 'Bronx', 'CI', 4200, 40.84240000000, -73.85560000000, '104500'),
(9129, 'US-MA-104501', 'Woburn', 'CI', 4189, 42.48970000000, -71.15950000000, '104501'),
(9130, 'US-NJ-104502', 'Middletown', 'CI', 4198, 40.39650000000, -74.10750000000, '104502'),
(9131, 'US-MA-104503', 'Dedham', 'CI', 4189, 42.24510000000, -71.18400000000, '104503'),
(9132, 'US-MA-104504', 'North Andover', 'CI', 4189, 42.67230000000, -71.08370000000, '104504'),
(9133, 'US-NH-104505', 'Laconia', 'CI', 4197, 43.56450000000, -71.48200000000, '104505'),
(9134, 'US-MA-104506', 'Merrimac', 'CI', 4189, 42.83740000000, -71.01210000000, '104506'),
(9135, 'US-NY-104507', 'Syracuse', 'CI', 4200, 43.03470000000, -76.07290000000, '104507'),
(9136, 'US-TX-104508', 'Addison', 'CI', 4214, 32.96030000000, -96.83000000000, '104508'),
(9137, 'US-MA-104509', 'Norwell', 'CI', 4189, 42.15080000000, -70.82280000000, '104509'),
(9138, 'US-ME-104510', 'Lewiston', 'CI', 4186, 44.08450000000, -70.16960000000, '104510'),
(9139, 'US-TX-104511', 'Dallas', 'CI', 4214, 32.76730000000, -96.77760000000, '104511'),
(9140, 'US-MA-104512', 'Burlington', 'CI', 4189, 42.50510000000, -71.20470000000, '104512'),
(9141, 'US-MA-104513', 'Belmont', 'CI', 4189, 42.39550000000, -71.18160000000, '104513'),
(9142, 'US-OR-104514', 'Beaverton', 'CI', 4206, 45.52220000000, -122.85930000000, '104514'),
(9143, 'US-MA-104515', 'Watertown', 'CI', 4189, 42.37220000000, -71.17870000000, '104515'),
(9144, 'US-TX-104516', 'Bowie', 'CI', 4214, 33.53680000000, -97.96830000000, '104516'),
(9145, 'US-NJ-104517', 'Morristown', 'CI', 4198, 40.76840000000, -74.49420000000, '104517'),
(9146, 'US-DC-104518', 'Washington', 'CI', 4173, 38.87490000000, -77.03250000000, '104518'),
(9147, 'US-NY-104519', 'Staten Island', 'CI', 4200, 40.54530000000, -74.17860000000, '104519'),
(9148, 'US-PA-104520', 'North Wales', 'CI', 4208, 40.22160000000, -75.23800000000, '104520'),
(9149, 'US-MI-104521', 'Waterford', 'CI', 4190, 42.64650000000, -83.35540000000, '104521'),
(9150, 'US-MI-104522', 'Okemos', 'CI', 4190, 42.70420000000, -84.40980000000, '104522'),
(9151, 'US-OH-104523', 'Celina', 'CI', 4204, 40.53450000000, -84.62890000000, '104523'),
(9152, 'US-MN-104524', 'Shakopee', 'CI', 4191, 44.74670000000, -93.50040000000, '104524'),
(9153, 'US-FL-104525', 'Clearwater', 'CI', 4175, 27.98390000000, -82.71810000000, '104525'),
(9154, 'US-NE-104526', 'Omaha', 'CI', 4195, 41.20790000000, -96.11830000000, '104526'),
(9155, 'US-NJ-104527', 'Washington', 'CI', 4198, 40.75200000000, -75.00720000000, '104527'),
(9156, 'US-SC-104528', 'Shaw A F B', 'CI', 4211, 33.97530000000, -80.46100000000, '104528'),
(9157, 'US-CA-104529', 'Mountain View', 'CI', 4169, 37.38850000000, -122.07410000000, '104529'),
(9158, 'US-AL-104530', 'Fort Payne', 'CI', 4161, 34.40180000000, -85.70950000000, '104530'),
(9159, 'US-NC-104531', 'Sanford', 'CI', 4201, 35.51530000000, -79.20070000000, '104531'),
(9160, 'US-MO-104532', 'Saint Louis', 'CI', 4193, 38.63120000000, -90.19220000000, '104532'),
(9161, 'US-ME-104533', 'Auburn', 'CI', 4186, 44.08610000000, -70.24340000000, '104533'),
(9162, 'US-MI-104534', 'Traverse City', 'CI', 4190, 44.78050000000, -85.72890000000, '104534'),
(9163, 'US-NC-104535', 'Hickory', 'CI', 4201, 35.67670000000, -81.38500000000, '104535'),
(9164, 'US-GA-104536', 'Atlanta', 'CI', 4176, 33.84770000000, -84.28140000000, '104536'),
(9165, 'US-MI-104537', 'Albion', 'CI', 4190, 42.29350000000, -84.75090000000, '104537'),
(9166, 'US-IN-104538', 'South Bend', 'CI', 4181, 41.69240000000, -86.23890000000, '104538'),
(9167, 'US-WI-104539', 'Sturtevant', 'CI', 4221, 42.69810000000, -87.93890000000, '104539'),
(9168, 'US-IN-104540', 'Logansport', 'CI', 4181, 40.79240000000, -86.37980000000, '104540'),
(9169, 'US-CA-104541', 'Perris', 'CI', 4169, 33.78180000000, -117.33170000000, '104541'),
(9170, 'US-WA-104542', 'Issaquah', 'CI', 4219, 47.50130000000, -122.00650000000, '104542'),
(9171, 'US-KY-104543', 'Morehead', 'CI', 4184, 38.20750000000, -83.39890000000, '104543'),
(9172, 'US-MI-104544', 'Saint Clair Shores', 'CI', 4190, 42.46550000000, -82.90130000000, '104544'),
(9173, 'US-MI-104545', 'Burton', 'CI', 4190, 42.97570000000, -83.66280000000, '104545'),
(9174, 'US-MN-104546', 'Crookston', 'CI', 4191, 47.75280000000, -96.55630000000, '104546'),
(9175, 'US-GA-104547', 'Warner Robins', 'CI', 4176, 32.58140000000, -83.62860000000, '104547'),
(9176, 'US-ID-104548', 'Caldwell', 'CI', 4179, 43.66040000000, -116.63830000000, '104548'),
(9177, 'US-VA-104549', 'Vienna', 'CI', 4218, 38.93480000000, -77.26720000000, '104549'),
(9178, 'US-TX-104550', 'Friendswood', 'CI', 4214, 29.51420000000, -95.19030000000, '104550'),
(9179, 'US-MN-104551', 'Minneapolis', 'CI', 4191, 45.00590000000, -93.43050000000, '104551'),
(9180, 'US-NY-104552', 'Norwich', 'CI', 4200, 42.54520000000, -75.55880000000, '104552'),
(9181, 'US-IA-104553', 'Urbandale', 'CI', 4182, 41.63270000000, -93.73740000000, '104553'),
(9182, 'US-WI-104554', 'Omro', 'CI', 4221, 44.05370000000, -88.79160000000, '104554'),
(9183, 'US-CA-104555', 'Los Angeles', 'CI', 4169, 34.05300000000, -118.26420000000, '104555'),
(9184, 'US-CA-104556', 'Rosamond', 'CI', 4169, 34.92860000000, -118.40520000000, '104556'),
(9185, 'US-IA-104557', 'Perry', 'CI', 4182, 41.86370000000, -94.11130000000, '104557'),
(9186, 'US-MN-104558', 'Saint Paul', 'CI', 4191, 45.01010000000, -93.15190000000, '104558'),
(9187, 'US-IL-104559', 'Buffalo Grove', 'CI', 4180, 42.16950000000, -87.95880000000, '104559'),
(9188, 'US-IN-104560', 'Evansville', 'CI', 4181, 37.97080000000, -87.48970000000, '104560'),
(9189, 'US-MI-104561', 'Southfield', 'CI', 4190, 42.47530000000, -83.28450000000, '104561'),
(9190, 'US-IL-104562', 'Flora', 'CI', 4180, 38.67120000000, -88.49730000000, '104562'),
(9191, 'US-MI-104563', 'Auburn Hills', 'CI', 4190, 42.66440000000, -83.23030000000, '104563'),
(9192, 'US-IL-104564', 'Lisle', 'CI', 4180, 41.78700000000, -88.08330000000, '104564'),
(9193, 'US-IL-104565', 'Naperville', 'CI', 4180, 41.80320000000, -88.13410000000, '104565'),
(9194, 'US-IL-104566', 'Batavia', 'CI', 4180, 41.83920000000, -88.36120000000, '104566'),
(9195, 'US-IL-104567', 'Normal', 'CI', 4180, 40.52820000000, -88.98010000000, '104567'),
(9196, 'US-IL-104568', 'Bloomington', 'CI', 4180, 40.60610000000, -88.98250000000, '104568'),
(9197, 'US-IL-104569', 'Morris', 'CI', 4180, 41.39260000000, -88.44550000000, '104569'),
(9198, 'US-TX-104570', 'Whitney', 'CI', 4214, 31.95220000000, -97.34590000000, '104570'),
(9199, 'US-IL-104571', 'Streator', 'CI', 4180, 41.12660000000, -88.84530000000, '104571'),
(9200, 'US-IL-104572', 'Franklin Park', 'CI', 4180, 41.93490000000, -87.88510000000, '104572'),
(9201, 'US-IL-104573', 'Downers Grove', 'CI', 4180, 41.81100000000, -88.03020000000, '104573'),
(9202, 'US-MA-104574', 'Leominster', 'CI', 4189, 42.52440000000, -71.76570000000, '104574'),
(9203, 'US-IL-104575', 'Westmont', 'CI', 4180, 41.79490000000, -87.97090000000, '104575'),
(9204, 'US-CA-104576', 'Folsom', 'CI', 4169, 38.67290000000, -121.14880000000, '104576'),
(9205, 'US-TX-104577', 'Freer', 'CI', 4214, 27.91120000000, -98.58650000000, '104577'),
(9206, 'US-IL-104578', 'Oak Brook', 'CI', 4180, 41.83720000000, -87.96130000000, '104578'),
(9207, 'US-IL-104579', 'Heyworth', 'CI', 4180, 40.32780000000, -88.96860000000, '104579'),
(9208, 'US-IL-104580', 'Elmhurst', 'CI', 4180, 41.89170000000, -87.93590000000, '104580'),
(9209, 'US-ME-104581', 'Bangor', 'CI', 4186, 44.86350000000, -68.84020000000, '104581'),
(9210, 'US-IL-104582', 'West Chicago', 'CI', 4180, 41.89690000000, -88.21040000000, '104582'),
(9211, 'US-IL-104583', 'Joliet', 'CI', 4180, 41.50850000000, -88.22780000000, '104583'),
(9212, 'US-IL-104584', 'Lombard', 'CI', 4180, 41.87800000000, -88.01630000000, '104584'),
(9213, 'US-IL-104585', 'Melrose Park', 'CI', 4180, 41.91630000000, -87.89240000000, '104585'),
(9214, 'US-IL-104586', 'Bolingbrook', 'CI', 4180, 41.69890000000, -88.07890000000, '104586'),
(9215, 'US-CA-104587', 'Hacienda Heights', 'CI', 4169, 34.00240000000, -117.97570000000, '104587'),
(9216, 'US-GA-104588', 'Savannah', 'CI', 4176, 32.12130000000, -81.18220000000, '104588'),
(9217, 'US-IL-104589', 'Willowbrook', 'CI', 4180, 41.74390000000, -87.93430000000, '104589'),
(9218, 'US-CT-104590', 'Enfield', 'CI', 4171, 41.98450000000, -72.55710000000, '104590'),
(9219, 'US-CA-104591', 'Chino', 'CI', 4169, 33.98690000000, -117.65550000000, '104591'),
(9220, 'US-WV-104592', 'Glenville', 'CI', 4220, 38.92920000000, -80.86890000000, '104592'),
(9221, 'US-RI-104593', 'Warwick', 'CI', 4210, 41.70500000000, -71.46040000000, '104593'),
(9222, 'US-PA-104594', 'Murrysville', 'CI', 4208, 40.45540000000, -79.66000000000, '104594'),
(9223, 'US-PA-104595', 'Coraopolis', 'CI', 4208, 40.49980000000, -80.18420000000, '104595'),
(9224, 'US-PA-104596', 'Warrendale', 'CI', 4208, 40.65940000000, -80.09330000000, '104596'),
(9225, 'US-TX-104597', 'Amarillo', 'CI', 4214, 35.22010000000, -101.66580000000, '104597'),
(9226, 'US-MD-104598', 'Salisbury', 'CI', 4188, 38.37610000000, -75.60860000000, '104598'),
(9227, 'US-WV-104599', 'Bridgeport', 'CI', 4220, 39.28440000000, -80.23070000000, '104599'),
(9228, 'US-PA-104600', 'Ellwood City', 'CI', 4208, 40.87680000000, -80.26110000000, '104600'),
(9229, 'US-PA-104601', 'New Kensington', 'CI', 4208, 40.57280000000, -79.72480000000, '104601'),
(9230, 'US-PA-104602', 'West Mifflin', 'CI', 4208, 40.36090000000, -79.90150000000, '104602'),
(9231, 'US-MO-104603', 'Licking', 'CI', 4193, 37.50730000000, -91.88280000000, '104603'),
(9232, 'US-PA-104604', 'Cranberry Twp', 'CI', 4208, 40.70970000000, -80.10490000000, '104604'),
(9233, 'US-PA-104605', 'Cheswick', 'CI', 4208, 40.58350000000, -79.84480000000, '104605'),
(9234, 'US-WV-104606', 'Wheeling', 'CI', 4220, 40.05820000000, -80.63620000000, '104606'),
(9235, 'US-NC-104607', 'Morrisville', 'CI', 4201, 35.86010000000, -78.83260000000, '104607'),
(9236, 'US-NC-104608', 'Greenville', 'CI', 4201, 35.68760000000, -77.16610000000, '104608'),
(9237, 'US-NC-104609', 'Wilmington', 'CI', 4201, 34.12560000000, -77.91900000000, '104609'),
(9238, 'US-WI-104610', 'Milwaukee', 'CI', 4221, 43.04340000000, -87.89450000000, '104610'),
(9239, 'US-NC-104611', 'Raleigh', 'CI', 4201, 35.84300000000, -78.63110000000, '104611'),
(9240, 'US-NC-104612', 'New Bern', 'CI', 4201, 35.16200000000, -76.95850000000, '104612'),
(9241, 'US-NC-104613', 'Beulaville', 'CI', 4201, 34.90220000000, -77.74510000000, '104613'),
(9242, 'US-GA-104614', 'Brunswick', 'CI', 4176, 31.18230000000, -81.49260000000, '104614'),
(9243, 'US-NC-104615', 'Cary', 'CI', 4201, 35.75090000000, -78.77890000000, '104615'),
(9244, 'US-NJ-104616', 'Fair Lawn', 'CI', 4198, 40.93640000000, -74.11840000000, '104616'),
(9245, 'US-NC-104617', 'Chapel Hill', 'CI', 4201, 35.96660000000, -79.04100000000, '104617'),
(9246, 'US-NC-104618', 'Wallace', 'CI', 4201, 34.73160000000, -77.93530000000, '104618'),
(9247, 'US-NC-104619', 'Washington', 'CI', 4201, 35.58050000000, -77.01270000000, '104619'),
(9248, 'US-TX-104620', 'Stratford', 'CI', 4214, 36.27790000000, -102.01560000000, '104620'),
(9249, 'US-ID-104621', 'Boise', 'CI', 4179, 43.56100000000, -116.21350000000, '104621'),
(9250, 'US-NC-104622', 'Oriental', 'CI', 4201, 35.06320000000, -76.70170000000, '104622'),
(9251, 'US-VA-104623', 'Alexandria', 'CI', 4218, 38.81770000000, -77.15270000000, '104623'),
(9252, 'US-VA-104624', 'Sterling', 'CI', 4218, 38.98810000000, -77.47550000000, '104624'),
(9253, 'US-VA-104625', 'Manassas', 'CI', 4218, 38.79320000000, -77.53660000000, '104625'),
(9254, 'US-VA-104626', 'Culpeper', 'CI', 4218, 38.43480000000, -77.98660000000, '104626'),
(9255, 'US-FL-104627', 'Jacksonville', 'CI', 4175, 30.35330000000, -81.49900000000, '104627'),
(9256, 'US-VA-104628', 'Fredericksburg', 'CI', 4218, 38.40360000000, -77.53320000000, '104628'),
(9257, 'US-VA-104629', 'Herndon', 'CI', 4218, 38.98410000000, -77.38270000000, '104629'),
(9258, 'US-VA-104630', 'Front Royal', 'CI', 4218, 38.92260000000, -78.13370000000, '104630'),
(9259, 'US-MI-104631', 'Novi', 'CI', 4190, 42.46340000000, -83.46460000000, '104631'),
(9260, 'US-VA-104632', 'Warrenton', 'CI', 4218, 38.71790000000, -77.85210000000, '104632'),
(9261, 'US-VA-104633', 'Arlington', 'CI', 4218, 38.86000000000, -77.09870000000, '104633'),
(9262, 'US-VA-104634', 'Gordonsville', 'CI', 4218, 38.09640000000, -78.18140000000, '104634'),
(9263, 'US-VA-104635', 'Catlett', 'CI', 4218, 38.62490000000, -77.62520000000, '104635'),
(9264, 'US-VA-104636', 'Winchester', 'CI', 4218, 39.14920000000, -78.27800000000, '104636'),
(9265, 'US-CA-104637', 'Piru', 'CI', 4169, 34.42250000000, -118.78460000000, '104637'),
(9266, 'US-VA-104638', 'Leesburg', 'CI', 4218, 39.04870000000, -77.60820000000, '104638'),
(9267, 'US-VA-104639', 'Chesapeake', 'CI', 4218, 36.76460000000, -76.19900000000, '104639'),
(9268, 'US-VA-104640', 'Mc Lean', 'CI', 4218, 38.94990000000, -77.22230000000, '104640'),
(9269, 'US-VA-104641', 'Quantico', 'CI', 4218, 38.53590000000, -77.42190000000, '104641'),
(9270, 'US-NC-104642', 'Fuquay Varina', 'CI', 4201, 35.54460000000, -78.83090000000, '104642'),
(9271, 'US-MI-104643', 'Holland', 'CI', 4190, 42.74230000000, -86.06610000000, '104643'),
(9272, 'US-AL-104644', 'Birmingham', 'CI', 4161, 33.44680000000, -86.74040000000, '104644'),
(9273, 'US-NC-104645', 'Goldsboro', 'CI', 4201, 35.36730000000, -77.91220000000, '104645'),
(9274, 'US-NC-104646', 'Tarboro', 'CI', 4201, 35.90700000000, -77.54240000000, '104646'),
(9275, 'US-NC-104647', 'Jacksonville', 'CI', 4201, 34.75950000000, -77.50190000000, '104647'),
(9276, 'US-NC-104648', 'Southern Pines', 'CI', 4201, 35.17520000000, -79.38340000000, '104648'),
(9277, 'US-NC-104649', 'Edenton', 'CI', 4201, 36.12130000000, -76.64140000000, '104649'),
(9278, 'US-NC-104650', 'Fayetteville', 'CI', 4201, 35.07850000000, -78.93360000000, '104650'),
(9279, 'US-CT-104651', 'Old Greenwich', 'CI', 4171, 41.03310000000, -73.56940000000, '104651'),
(9280, 'US-DE-104652', 'Wilmington', 'CI', 4172, 39.79760000000, -75.53920000000, '104652'),
(9281, 'US-VA-104653', 'Colonial Heights', 'CI', 4218, 37.28790000000, -77.41530000000, '104653'),
(9282, 'US-CA-104654', 'Rancho Cucamonga', 'CI', 4169, 34.09950000000, -117.58080000000, '104654'),
(9283, 'US-OH-104655', 'Newark', 'CI', 4204, 40.12410000000, -82.38280000000, '104655'),
(9284, 'US-IN-104656', 'Wakarusa', 'CI', 4181, 41.54020000000, -86.05240000000, '104656'),
(9285, 'US-GA-104657', 'Duluth', 'CI', 4176, 34.04080000000, -84.16650000000, '104657'),
(9286, 'US-MN-104658', 'Granite Falls', 'CI', 4191, 44.79660000000, -95.58430000000, '104658'),
(9287, 'US-PA-104659', 'Ambridge', 'CI', 4208, 40.59960000000, -80.20780000000, '104659'),
(9288, 'US-MI-104660', 'Troy', 'CI', 4190, 42.59830000000, -83.17850000000, '104660'),
(9289, 'PR-??-104661', 'Carolina', 'CI', 181, 18.32070000000, -65.94190000000, '104661'),
(9290, 'US-NJ-104662', 'Vineland', 'CI', 4198, 39.49680000000, -75.01570000000, '104662'),
(9291, 'US-NY-104663', 'Suffern', 'CI', 4200, 41.15230000000, -74.12170000000, '104663'),
(9292, 'US-AZ-104664', 'Phoenix', 'CI', 4164, 33.55860000000, -112.09550000000, '104664'),
(9293, 'US-SC-104665', 'Greenville', 'CI', 4211, 34.80040000000, -82.32210000000, '104665'),
(9294, 'US-MI-104666', 'Detroit', 'CI', 4190, 42.36790000000, -83.13860000000, '104666'),
(9295, 'US-OH-104667', 'Toledo', 'CI', 4204, 41.70730000000, -83.54300000000, '104667'),
(9296, 'US-IN-104668', 'Jasper', 'CI', 4181, 38.42070000000, -86.92770000000, '104668'),
(9297, 'US-IN-104669', 'Middlebury', 'CI', 4181, 41.67660000000, -85.69590000000, '104669'),
(9298, 'US-KS-104670', 'Overland Park', 'CI', 4183, 38.92470000000, -94.70290000000, '104670'),
(9299, 'US-MI-104671', 'Dearborn', 'CI', 4190, 42.30450000000, -83.17740000000, '104671'),
(9300, 'US-MO-104672', 'Grain Valley', 'CI', 4193, 38.99270000000, -94.21510000000, '104672'),
(9301, 'US-KS-104673', 'Hiawatha', 'CI', 4183, 39.84840000000, -95.55850000000, '104673'),
(9302, 'US-MO-104674', 'Springfield', 'CI', 4193, 37.21900000000, -93.31760000000, '104674'),
(9303, 'US-MO-104675', 'Pineville', 'CI', 4193, 36.57320000000, -94.27470000000, '104675'),
(9304, 'US-IL-104676', 'Winfield', 'CI', 4180, 41.87200000000, -88.16620000000, '104676'),
(9305, 'US-WA-104677', 'Tacoma', 'CI', 4219, 47.15110000000, -122.44920000000, '104677'),
(9306, 'US-MO-104678', 'Blue Eye', 'CI', 4193, 36.55780000000, -93.36910000000, '104678'),
(9307, 'US-SD-104679', 'Sioux Falls', 'CI', 4212, 43.50420000000, -96.83910000000, '104679'),
(9308, 'US-KS-104680', 'Columbus', 'CI', 4183, 37.14930000000, -94.88930000000, '104680'),
(9309, 'US-IL-104681', 'Wheaton', 'CI', 4180, 41.85200000000, -88.12110000000, '104681'),
(9310, 'US-NJ-104682', 'Livingston', 'CI', 4198, 40.78710000000, -74.32910000000, '104682'),
(9311, 'US-AR-104683', 'Flippin', 'CI', 4165, 36.24090000000, -92.53550000000, '104683'),
(9312, 'US-MO-104684', 'Fenton', 'CI', 4193, 38.63830000000, -90.42710000000, '104684'),
(9313, 'US-IL-104685', 'Fairview Heights', 'CI', 4180, 38.59740000000, -90.00710000000, '104685'),
(9314, 'US-TN-104686', 'Cordova', 'CI', 4213, 35.13640000000, -89.77260000000, '104686'),
(9315, 'US-NC-104687', 'Winston Salem', 'CI', 4201, 36.14600000000, -80.32430000000, '104687'),
(9316, 'US-NV-104688', 'Henderson', 'CI', 4196, 36.03120000000, -115.07390000000, '104688'),
(9317, 'US-MO-104689', 'Cape Girardeau', 'CI', 4193, 37.27820000000, -89.54790000000, '104689'),
(9318, 'US-MO-104690', 'Columbia', 'CI', 4193, 39.04370000000, -92.27140000000, '104690'),
(9319, 'US-IL-104691', 'Troy', 'CI', 4180, 38.70310000000, -89.87860000000, '104691'),
(9320, 'US-KY-104692', 'Louisville', 'CI', 4184, 38.08580000000, -85.84950000000, '104692'),
(9321, 'US-MO-104693', 'Poplar Bluff', 'CI', 4193, 36.75270000000, -90.48530000000, '104693'),
(9322, 'US-IN-104694', 'Columbus', 'CI', 4181, 39.23590000000, -85.83600000000, '104694'),
(9323, 'US-IA-104695', 'Dubuque', 'CI', 4182, 42.55070000000, -90.69310000000, '104695'),
(9324, 'US-MO-104696', 'Lake Saint Louis', 'CI', 4193, 38.78590000000, -90.78610000000, '104696'),
(9325, 'US-OK-104697', 'Oklahoma City', 'CI', 4205, 35.57980000000, -97.57310000000, '104697'),
(9326, 'US-IL-104698', 'Staunton', 'CI', 4180, 39.01640000000, -89.78110000000, '104698'),
(9327, 'US-MI-104699', 'Taylor', 'CI', 4190, 42.22560000000, -83.26850000000, '104699'),
(9328, 'US-MO-104700', 'Maryland Heights', 'CI', 4193, 38.72830000000, -90.45090000000, '104700'),
(9329, 'US-CT-104701', 'Norwalk', 'CI', 4171, 41.10030000000, -73.39830000000, '104701'),
(9330, 'US-CT-104702', 'Preston', 'CI', 4171, 41.51740000000, -71.99040000000, '104702'),
(9331, 'US-MA-104703', 'Andover', 'CI', 4189, 42.64890000000, -71.16550000000, '104703');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(9332, 'US-MA-104704', 'Springfield', 'CI', 4189, 42.12100000000, -72.48960000000, '104704'),
(9333, 'US-KS-104705', 'Lenexa', 'CI', 4183, 38.95060000000, -94.77910000000, '104705'),
(9334, 'US-CA-104706', 'El Centro', 'CI', 4169, 32.77360000000, -115.60220000000, '104706'),
(9335, 'US-UT-104707', 'Nephi', 'CI', 4215, 39.68730000000, -111.83090000000, '104707'),
(9336, 'US-UT-104708', 'Clearfield', 'CI', 4215, 41.10440000000, -112.02070000000, '104708'),
(9337, 'US-GA-104709', 'Alpharetta', 'CI', 4176, 34.13300000000, -84.30050000000, '104709'),
(9338, 'US-UT-104710', 'Salt Lake City', 'CI', 4215, 40.72420000000, -111.87870000000, '104710'),
(9339, 'US-UT-104711', 'Hill Afb', 'CI', 4215, 41.12850000000, -111.98340000000, '104711'),
(9340, 'US-UT-104712', 'North Salt Lake', 'CI', 4215, 40.84210000000, -111.90560000000, '104712'),
(9341, 'US-CO-104713', 'Colorado Springs', 'CI', 4170, 38.86090000000, -104.87340000000, '104713'),
(9342, 'US-LA-104714', 'New Orleans', 'CI', 4185, 29.95890000000, -90.15680000000, '104714'),
(9343, 'US-CO-104715', 'Eads', 'CI', 4170, 38.44070000000, -102.78600000000, '104715'),
(9344, 'US-MS-104716', 'Jackson', 'CI', 4192, 32.31340000000, -90.17200000000, '104716'),
(9345, 'US-MO-104717', 'Fort Leonard Wood', 'CI', 4193, 37.76720000000, -92.09910000000, '104717'),
(9346, 'US-AZ-104718', 'Scottsdale', 'CI', 4164, 33.49120000000, -111.92370000000, '104718'),
(9347, 'US-CO-104719', 'Woodland Park', 'CI', 4170, 38.99670000000, -105.11840000000, '104719'),
(9348, 'US-CA-104720', 'Highland', 'CI', 4169, 34.13590000000, -117.15530000000, '104720'),
(9349, 'US-CO-104721', 'Englewood', 'CI', 4170, 39.56900000000, -104.85820000000, '104721'),
(9350, 'US-CO-104722', 'Palmer Lake', 'CI', 4170, 39.11410000000, -104.89840000000, '104722'),
(9351, 'US-CO-104723', 'Fountain', 'CI', 4170, 38.66570000000, -104.68380000000, '104723'),
(9352, 'US-IA-104724', 'Glenwood', 'CI', 4182, 41.03080000000, -95.70900000000, '104724'),
(9353, 'US-NE-104725', 'Winnebago', 'CI', 4195, 42.23440000000, -96.48870000000, '104725'),
(9354, 'US-NE-104726', 'Norfolk', 'CI', 4195, 42.01800000000, -97.45430000000, '104726'),
(9355, 'US-NE-104727', 'Pierce', 'CI', 4195, 42.20630000000, -97.57230000000, '104727'),
(9356, 'US-NM-104728', 'Santa Fe', 'CI', 4199, 35.78470000000, -105.87490000000, '104728'),
(9357, 'US-NM-104729', 'Albuquerque', 'CI', 4199, 35.04410000000, -106.89040000000, '104729'),
(9358, 'US-NJ-104730', 'East Brunswick', 'CI', 4198, 40.42930000000, -74.42030000000, '104730'),
(9359, 'US-TX-104731', 'El Paso', 'CI', 4214, 31.79580000000, -106.37620000000, '104731'),
(9360, 'US-NM-104732', 'Grants', 'CI', 4199, 35.02070000000, -107.95830000000, '104732'),
(9361, 'US-NM-104733', 'Espanola', 'CI', 4199, 36.00080000000, -106.13160000000, '104733'),
(9362, 'US-CA-104734', 'Inglewood', 'CI', 4169, 33.95820000000, -118.36140000000, '104734'),
(9363, 'US-NM-104735', 'Dulce', 'CI', 4199, 36.79660000000, -106.88540000000, '104735'),
(9364, 'US-NM-104736', 'Edgewood', 'CI', 4199, 35.09680000000, -106.14890000000, '104736'),
(9365, 'US-CA-104737', 'Red Bluff', 'CI', 4169, 40.13680000000, -122.43100000000, '104737'),
(9366, 'US-NM-104738', 'Aztec', 'CI', 4199, 36.87160000000, -107.88850000000, '104738'),
(9367, 'US-FL-104739', 'West Palm Beach', 'CI', 4175, 26.72000000000, -80.07020000000, '104739'),
(9368, 'US-NM-104740', 'Deming', 'CI', 4199, 32.22460000000, -107.76350000000, '104740'),
(9369, 'US-NM-104741', 'Anthony', 'CI', 4199, 31.99500000000, -106.73250000000, '104741'),
(9370, 'US-NM-104742', 'Lovington', 'CI', 4199, 32.81860000000, -103.43840000000, '104742'),
(9371, 'US-NM-104743', 'Las Cruces', 'CI', 4199, 32.30470000000, -106.64170000000, '104743'),
(9372, 'US-NC-104744', 'Mocksville', 'CI', 4201, 35.89870000000, -80.57410000000, '104744'),
(9373, 'US-OH-104745', 'Columbus', 'CI', 4204, 40.03450000000, -82.86950000000, '104745'),
(9374, 'US-NM-104746', 'Roswell', 'CI', 4199, 33.56820000000, -104.42250000000, '104746'),
(9375, 'US-IL-104747', 'Elk Grove Village', 'CI', 4180, 42.01520000000, -87.99010000000, '104747'),
(9376, 'US-CA-104748', 'Merced', 'CI', 4169, 37.29000000000, -120.48880000000, '104748'),
(9377, 'US-FL-104749', 'Orlando', 'CI', 4175, 28.58830000000, -81.24390000000, '104749'),
(9378, 'US-NM-104750', 'Carlsbad', 'CI', 4199, 32.29950000000, -104.28750000000, '104750'),
(9379, 'US-NM-104751', 'Maljamar', 'CI', 4199, 32.88540000000, -103.71130000000, '104751'),
(9380, 'US-OH-104752', 'Chillicothe', 'CI', 4204, 39.33350000000, -83.01680000000, '104752'),
(9381, 'US-NM-104753', 'Mountainair', 'CI', 4199, 34.48510000000, -106.22630000000, '104753'),
(9382, 'US-NM-104754', 'Hobbs', 'CI', 4199, 32.71030000000, -103.27640000000, '104754'),
(9383, 'US-MD-104755', 'Bethesda', 'CI', 4188, 38.95430000000, -77.11590000000, '104755'),
(9384, 'US-CO-104756', 'Denver', 'CI', 4170, 39.75250000000, -104.99950000000, '104756'),
(9385, 'US-OR-104757', 'Portland', 'CI', 4206, 45.46910000000, -122.55350000000, '104757'),
(9386, 'US-LA-104758', 'Baton Rouge', 'CI', 4185, 30.43860000000, -91.17030000000, '104758'),
(9387, 'US-MI-104759', 'Livonia', 'CI', 4190, 42.42500000000, -83.37440000000, '104759'),
(9388, 'US-IL-104760', 'Skokie', 'CI', 4180, 42.03470000000, -87.76140000000, '104760'),
(9389, 'US-CO-104761', 'Commerce City', 'CI', 4170, 39.87100000000, -104.78430000000, '104761'),
(9390, 'US-CO-104762', 'Fort Collins', 'CI', 4170, 40.59390000000, -105.12560000000, '104762'),
(9391, 'US-GA-104763', 'Moody A F B', 'CI', 4176, 30.96680000000, -83.18960000000, '104763'),
(9392, 'US-NE-104764', 'Lincoln', 'CI', 4195, 40.81760000000, -96.71140000000, '104764'),
(9393, 'US-NE-104765', 'Fremont', 'CI', 4195, 41.48030000000, -96.47280000000, '104765'),
(9394, 'US-NE-104766', 'Columbus', 'CI', 4195, 41.51200000000, -97.34700000000, '104766'),
(9395, 'US-NE-104767', 'Kearney', 'CI', 4195, 40.74990000000, -99.19800000000, '104767'),
(9396, 'US-SD-104768', 'North Sioux City', 'CI', 4212, 42.52410000000, -96.49980000000, '104768'),
(9397, 'US-NJ-104769', 'Mount Laurel', 'CI', 4198, 39.95720000000, -74.91620000000, '104769'),
(9398, 'US-CO-104770', 'Longmont', 'CI', 4170, 40.16750000000, -105.02260000000, '104770'),
(9399, 'US-GA-104771', 'Gainesville', 'CI', 4176, 34.31380000000, -83.80950000000, '104771'),
(9400, 'US-MI-104772', 'Clare', 'CI', 4190, 43.84890000000, -84.73490000000, '104772'),
(9401, 'US-FL-104773', 'Cape Coral', 'CI', 4175, 26.63560000000, -82.01640000000, '104773'),
(9402, 'US-MI-104774', 'Beaver Island', 'CI', 4190, 45.66590000000, -85.55840000000, '104774'),
(9403, 'US-MD-104775', 'California', 'CI', 4188, 38.29070000000, -76.52210000000, '104775'),
(9404, 'US-MD-104776', 'Columbia', 'CI', 4188, 39.17490000000, -76.83750000000, '104776'),
(9405, 'US-NE-104777', 'Oneill', 'CI', 4195, 42.47260000000, -98.56710000000, '104777'),
(9406, 'US-TX-104778', 'Fort Worth', 'CI', 4214, 32.74060000000, -97.38020000000, '104778'),
(9407, 'US-VA-104779', 'Elkwood', 'CI', 4218, 38.48210000000, -77.81750000000, '104779'),
(9408, 'US-SD-104780', 'Deadwood', 'CI', 4212, 44.27820000000, -103.62970000000, '104780'),
(9409, 'US-OK-104781', 'Tulsa', 'CI', 4205, 36.04920000000, -96.07120000000, '104781'),
(9410, 'US-AR-104782', 'Fort Smith', 'CI', 4165, 35.36590000000, -94.41260000000, '104782'),
(9411, 'US-CA-104783', 'Pasadena', 'CI', 4169, 34.13790000000, -118.12960000000, '104783'),
(9412, 'US-LA-104784', 'Covington', 'CI', 4185, 30.45740000000, -90.14300000000, '104784'),
(9413, 'US-CA-104785', 'Monrovia', 'CI', 4169, 34.15390000000, -117.99190000000, '104785'),
(9414, 'US-AZ-104786', 'Maricopa', 'CI', 4164, 33.01680000000, -112.20280000000, '104786'),
(9415, 'US-GA-104787', 'Hawkinsville', 'CI', 4176, 32.26800000000, -83.52660000000, '104787'),
(9416, 'US-CA-104788', 'Garden Grove', 'CI', 4169, 33.78770000000, -117.97380000000, '104788'),
(9417, 'US-MI-104789', 'Webberville', 'CI', 4190, 42.65420000000, -84.17660000000, '104789'),
(9418, 'US-CO-104790', 'Boulder', 'CI', 4170, 40.08780000000, -105.37350000000, '104790'),
(9419, 'US-CO-104791', 'Vail', 'CI', 4170, 39.64120000000, -106.32280000000, '104791'),
(9420, 'US-WY-104792', 'Casper', 'CI', 4222, 42.80350000000, -106.22450000000, '104792'),
(9421, 'US-MA-104793', 'West Springfield', 'CI', 4189, 42.12350000000, -72.63990000000, '104793'),
(9422, 'US-CA-104794', 'Glendale', 'CI', 4169, 34.13520000000, -118.24160000000, '104794'),
(9423, 'US-MA-104795', 'Canton', 'CI', 4189, 42.18470000000, -71.12200000000, '104795'),
(9424, 'US-AZ-104796', 'Yuma', 'CI', 4164, 32.72440000000, -114.51570000000, '104796'),
(9425, 'US-MD-104797', 'Laurel', 'CI', 4188, 39.09670000000, -76.87790000000, '104797'),
(9426, 'US-CA-104798', 'South San Francisco', 'CI', 4169, 37.65340000000, -122.42310000000, '104798'),
(9427, 'US-CA-104799', 'Burbank', 'CI', 4169, 33.78660000000, -118.29870000000, '104799'),
(9428, 'US-OK-104800', 'Norman', 'CI', 4205, 35.23300000000, -97.41220000000, '104800'),
(9429, 'US-SD-104801', 'Rapid City', 'CI', 4212, 44.03500000000, -103.37820000000, '104801'),
(9430, 'US-SD-104802', 'Mission', 'CI', 4212, 43.19420000000, -100.60590000000, '104802'),
(9431, 'PR-??-104803', 'San Juan', 'CI', 181, 18.45040000000, -66.08490000000, '104803'),
(9432, 'US-OH-104804', 'Miamisburg', 'CI', 4204, 39.61820000000, -84.24880000000, '104804'),
(9433, 'US-TX-104805', 'Arlington', 'CI', 4214, 32.69040000000, -97.13430000000, '104805'),
(9434, 'US-CO-104806', 'Loveland', 'CI', 4170, 40.49990000000, -105.26470000000, '104806'),
(9435, 'US-CO-104807', 'Westminster', 'CI', 4170, 39.83010000000, -105.03450000000, '104807'),
(9436, 'US-NY-104808', 'Rochester', 'CI', 4200, 43.14930000000, -77.50810000000, '104808'),
(9437, 'US-CA-104809', 'Sun Valley', 'CI', 4169, 34.23220000000, -118.34480000000, '104809'),
(9438, 'US-WY-104810', 'Cheyenne', 'CI', 4222, 41.10340000000, -104.90590000000, '104810'),
(9439, 'US-AR-104811', 'Mc Gehee', 'CI', 4165, 33.62840000000, -91.35690000000, '104811'),
(9440, 'US-TX-104812', 'Carrollton', 'CI', 4214, 32.94780000000, -96.89150000000, '104812'),
(9441, 'US-MA-104813', 'Westwood', 'CI', 4189, 42.22110000000, -71.19850000000, '104813'),
(9442, 'US-FL-104814', 'Lakeland', 'CI', 4175, 28.04070000000, -81.90430000000, '104814'),
(9443, 'US-CA-104815', 'El Segundo', 'CI', 4169, 33.91640000000, -118.40410000000, '104815'),
(9444, 'US-TN-104816', 'Greeneville', 'CI', 4213, 36.08280000000, -82.85080000000, '104816'),
(9445, 'US-MO-104817', 'Grandview', 'CI', 4193, 38.87580000000, -94.52590000000, '104817'),
(9446, 'US-MO-104818', 'Kansas City', 'CI', 4193, 39.03620000000, -94.59500000000, '104818'),
(9447, 'US-MO-104819', 'O Fallon', 'CI', 4193, 38.79360000000, -90.78250000000, '104819'),
(9448, 'US-MO-104820', 'Jefferson City', 'CI', 4193, 38.55160000000, -92.27450000000, '104820'),
(9449, 'US-MO-104821', 'Ballwin', 'CI', 4193, 38.60760000000, -90.55970000000, '104821'),
(9450, 'US-IL-104822', 'Scott Air Force Base', 'CI', 4180, 38.54210000000, -89.84480000000, '104822'),
(9451, 'US-IL-104823', 'Granite City', 'CI', 4180, 38.73280000000, -90.10720000000, '104823'),
(9452, 'US-MO-104824', 'Berger', 'CI', 4193, 38.64110000000, -91.30690000000, '104824'),
(9453, 'US-MO-104825', 'Van Buren', 'CI', 4193, 36.95920000000, -90.99660000000, '104825'),
(9454, 'US-IA-104826', 'West Des Moines', 'CI', 4182, 41.56640000000, -93.74050000000, '104826'),
(9455, 'US-KS-104827', 'Dodge City', 'CI', 4183, 37.80200000000, -99.99820000000, '104827'),
(9456, 'US-IA-104828', 'Dakota City', 'CI', 4182, 42.72330000000, -94.19930000000, '104828'),
(9457, 'US-IA-104829', 'Des Moines', 'CI', 4182, 41.58390000000, -93.62890000000, '104829'),
(9458, 'US-AZ-104830', 'Tempe', 'CI', 4164, 33.40010000000, -111.92900000000, '104830'),
(9459, 'US-IA-104831', 'Mason City', 'CI', 4182, 43.14650000000, -93.20750000000, '104831'),
(9460, 'US-IA-104832', 'Oelwein', 'CI', 4182, 42.68400000000, -91.93460000000, '104832'),
(9461, 'US-IA-104833', 'Audubon', 'CI', 4182, 41.73960000000, -94.89940000000, '104833'),
(9462, 'US-KY-104834', 'Elizabethtown', 'CI', 4184, 37.71530000000, -85.85650000000, '104834'),
(9463, 'US-IN-104835', 'New Albany', 'CI', 4181, 38.28130000000, -85.84010000000, '104835'),
(9464, 'US-MD-104836', 'Lanham', 'CI', 4188, 38.96900000000, -76.85370000000, '104836'),
(9465, 'US-NY-104837', 'Mount Kisco', 'CI', 4200, 41.19950000000, -73.71640000000, '104837'),
(9466, 'US-LA-104838', 'Shreveport', 'CI', 4185, 32.61880000000, -93.88520000000, '104838'),
(9467, 'US-AR-104839', 'Murfreesboro', 'CI', 4165, 34.11390000000, -93.70890000000, '104839'),
(9468, 'US-AR-104840', 'Mount Ida', 'CI', 4165, 34.57200000000, -93.41200000000, '104840'),
(9469, 'US-LA-104841', 'Springhill', 'CI', 4185, 32.97860000000, -93.51710000000, '104841'),
(9470, 'US-TX-104842', 'Post', 'CI', 4214, 33.24850000000, -101.33450000000, '104842'),
(9471, 'US-ND-104843', 'Bismarck', 'CI', 4202, 46.81590000000, -100.70610000000, '104843'),
(9472, 'US-MO-104844', 'West Plains', 'CI', 4193, 36.72480000000, -91.89450000000, '104844'),
(9473, 'US-AR-104845', 'Little Rock', 'CI', 4165, 34.63330000000, -92.22670000000, '104845'),
(9474, 'US-LA-104846', 'Bossier City', 'CI', 4185, 32.56950000000, -93.69230000000, '104846'),
(9475, 'US-AR-104847', 'White Hall', 'CI', 4165, 34.22890000000, -92.00090000000, '104847'),
(9476, 'US-AR-104848', 'Hamburg', 'CI', 4165, 33.22650000000, -91.79120000000, '104848'),
(9477, 'US-AR-104849', 'Russellville', 'CI', 4165, 35.27800000000, -93.13730000000, '104849'),
(9478, 'US-AR-104850', 'Pine Bluff', 'CI', 4165, 34.18050000000, -91.90950000000, '104850'),
(9479, 'US-AL-104851', 'Helena', 'CI', 4161, 33.25070000000, -86.92110000000, '104851'),
(9480, 'US-MA-104852', 'Sandwich', 'CI', 4189, 41.71940000000, -70.48030000000, '104852'),
(9481, 'US-AR-104853', 'Hot Springs National Park', 'CI', 4165, 34.41790000000, -93.04930000000, '104853'),
(9482, 'US-AR-104854', 'Maumelle', 'CI', 4165, 34.86750000000, -92.40010000000, '104854'),
(9483, 'US-LA-104855', 'Pleasant Hill', 'CI', 4185, 31.81300000000, -93.49710000000, '104855'),
(9484, 'US-LA-104856', 'Sibley', 'CI', 4185, 32.51780000000, -93.29200000000, '104856'),
(9485, 'US-AR-104857', 'North Little Rock', 'CI', 4165, 34.77420000000, -92.15540000000, '104857'),
(9486, 'US-AR-104858', 'Mabelvale', 'CI', 4165, 34.58250000000, -92.38370000000, '104858'),
(9487, 'US-TX-104859', 'Irving', 'CI', 4214, 32.91930000000, -96.98200000000, '104859'),
(9488, 'US-TN-104860', 'Bells', 'CI', 4213, 35.66290000000, -89.10890000000, '104860'),
(9489, 'US-MS-104861', 'Horn Lake', 'CI', 4192, 34.95920000000, -90.02860000000, '104861'),
(9490, 'US-AR-104862', 'Batesville', 'CI', 4165, 35.78810000000, -91.64580000000, '104862'),
(9491, 'US-AZ-104863', 'Tucson', 'CI', 4164, 32.26860000000, -111.00220000000, '104863'),
(9492, 'US-KS-104864', 'Mission', 'CI', 4183, 38.96900000000, -94.67610000000, '104864'),
(9493, 'US-AZ-104865', 'Mesa', 'CI', 4164, 33.39720000000, -111.78580000000, '104865'),
(9494, 'US-AR-104866', 'Paragould', 'CI', 4165, 36.10410000000, -90.46620000000, '104866'),
(9495, 'US-ID-104867', 'Cottonwood', 'CI', 4179, 45.94890000000, -116.52090000000, '104867'),
(9496, 'US-TX-104868', 'San Antonio', 'CI', 4214, 29.48890000000, -98.39870000000, '104868'),
(9497, 'US-AL-104869', 'Mobile', 'CI', 4161, 30.65860000000, -88.35350000000, '104869'),
(9498, 'US-FL-104870', 'Miami Beach', 'CI', 4175, 25.85820000000, -80.13120000000, '104870'),
(9499, 'US-ID-104871', 'Troy', 'CI', 4179, 46.74360000000, -116.74050000000, '104871'),
(9500, 'US-CA-104872', 'Culver City', 'CI', 4169, 33.99500000000, -118.39170000000, '104872'),
(9501, 'US-MA-104873', 'Newton', 'CI', 4189, 42.35330000000, -71.18830000000, '104873'),
(9502, 'US-MA-104874', 'Westford', 'CI', 4189, 42.58880000000, -71.44160000000, '104874'),
(9503, 'US-MA-104875', 'Newbury', 'CI', 4189, 42.77820000000, -70.87040000000, '104875'),
(9504, 'US-FL-104876', 'Tampa', 'CI', 4175, 27.94300000000, -82.52400000000, '104876'),
(9505, 'US-MA-104877', 'Lowell', 'CI', 4189, 42.62410000000, -71.33890000000, '104877'),
(9506, 'US-MA-104878', 'Quincy', 'CI', 4189, 42.24290000000, -71.00980000000, '104878'),
(9507, 'US-LA-104879', 'Metairie', 'CI', 4185, 30.01330000000, -90.19210000000, '104879'),
(9508, 'US-VA-104880', 'Bluemont', 'CI', 4218, 39.08320000000, -77.89390000000, '104880'),
(9509, 'US-MD-104881', 'Frederick', 'CI', 4188, 39.35550000000, -77.47750000000, '104881'),
(9510, 'US-SC-104882', 'Charleston', 'CI', 4211, 32.93260000000, -79.97980000000, '104882'),
(9511, 'US-PA-104883', 'Bensalem', 'CI', 4208, 40.10300000000, -74.94150000000, '104883'),
(9512, 'US-PA-104884', 'Malvern', 'CI', 4208, 40.04020000000, -75.53320000000, '104884'),
(9513, 'US-PA-104885', 'Horsham', 'CI', 4208, 40.18830000000, -75.15020000000, '104885'),
(9514, 'US-SC-104886', 'Bennettsville', 'CI', 4211, 34.62960000000, -79.70680000000, '104886'),
(9515, 'US-PA-104887', 'Warminster', 'CI', 4208, 40.21400000000, -75.07300000000, '104887'),
(9516, 'US-CA-104888', 'Corona', 'CI', 4169, 33.87780000000, -117.53440000000, '104888'),
(9517, 'US-OH-104889', 'Sylvania', 'CI', 4204, 41.69300000000, -83.72730000000, '104889'),
(9518, 'US-KS-104890', 'Olathe', 'CI', 4183, 38.85180000000, -94.77860000000, '104890'),
(9519, 'US-PA-104891', 'Bala Cynwyd', 'CI', 4208, 40.01430000000, -75.22670000000, '104891'),
(9520, 'US-PA-104892', 'Lancaster', 'CI', 4208, 40.00520000000, -76.32460000000, '104892'),
(9521, 'US-PA-104893', 'Snow Shoe', 'CI', 4208, 41.02870000000, -77.91430000000, '104893'),
(9522, 'US-CA-104894', 'Newport Beach', 'CI', 4169, 33.62750000000, -117.87340000000, '104894'),
(9523, 'US-PA-104895', 'Lewistown', 'CI', 4208, 40.60070000000, -77.57770000000, '104895'),
(9524, 'US-SC-104896', 'Hollywood', 'CI', 4211, 32.70490000000, -80.27160000000, '104896'),
(9525, 'US-SC-104897', 'North Charleston', 'CI', 4211, 32.86880000000, -80.04000000000, '104897'),
(9526, 'US-CA-104898', 'Bakersfield', 'CI', 4169, 35.38320000000, -119.22720000000, '104898'),
(9527, 'US-PA-104899', 'Feasterville Trevose', 'CI', 4208, 40.15840000000, -74.97320000000, '104899'),
(9528, 'US-NJ-104900', 'Maple Shade', 'CI', 4198, 39.95000000000, -74.99290000000, '104900'),
(9529, 'US-PA-104901', 'Middletown', 'CI', 4208, 40.18130000000, -76.69170000000, '104901'),
(9530, 'US-DE-104902', 'Dover', 'CI', 4172, 39.18170000000, -75.59710000000, '104902'),
(9531, 'US-CA-104903', 'Malibu', 'CI', 4169, 34.06970000000, -118.81770000000, '104903'),
(9532, 'US-TN-104904', 'Franklin', 'CI', 4213, 35.90860000000, -86.78110000000, '104904'),
(9533, 'US-PA-104905', 'Croydon', 'CI', 4208, 40.08940000000, -74.89180000000, '104905'),
(9534, 'US-PA-104906', 'Willow Grove', 'CI', 4208, 40.14920000000, -75.12850000000, '104906'),
(9535, 'US-CA-104907', 'Sherman Oaks', 'CI', 4169, 34.14630000000, -118.42930000000, '104907'),
(9536, 'US-DE-104908', 'Bridgeville', 'CI', 4172, 38.72990000000, -75.59050000000, '104908'),
(9537, 'US-CA-104909', 'Fresno', 'CI', 4169, 36.84000000000, -119.82850000000, '104909'),
(9538, 'US-CA-104910', 'Clovis', 'CI', 4169, 36.81120000000, -119.71290000000, '104910'),
(9539, 'US-CA-104911', 'Sunnyvale', 'CI', 4169, 37.36970000000, -122.02140000000, '104911'),
(9540, 'US-CA-104912', 'Hollister', 'CI', 4169, 36.89520000000, -121.24340000000, '104912'),
(9541, 'US-CA-104913', 'Modesto', 'CI', 4169, 37.65270000000, -121.13820000000, '104913'),
(9542, 'US-CA-104914', 'Campbell', 'CI', 4169, 37.28030000000, -121.95670000000, '104914'),
(9543, 'US-CA-104915', 'Santa Clara', 'CI', 4169, 37.39610000000, -121.96170000000, '104915'),
(9544, 'US-CA-104916', 'Pescadero', 'CI', 4169, 37.20610000000, -122.30020000000, '104916'),
(9545, 'US-CA-104917', 'Monterey', 'CI', 4169, 36.36990000000, -121.84060000000, '104917'),
(9546, 'US-IL-104918', 'Carthage', 'CI', 4180, 40.38890000000, -91.09860000000, '104918'),
(9547, 'US-HI-104919', 'Honolulu', 'CI', 4178, 21.29670000000, -157.84980000000, '104919'),
(9548, 'US-CA-104920', 'Santa Monica', 'CI', 4169, 34.01600000000, -118.49250000000, '104920'),
(9549, 'US-NY-104921', 'Lake Placid', 'CI', 4200, 44.23510000000, -73.99130000000, '104921'),
(9550, 'US-AR-104922', 'Searcy', 'CI', 4165, 35.23270000000, -91.70540000000, '104922'),
(9551, 'US-MA-104923', 'Gloucester', 'CI', 4189, 42.61790000000, -70.71540000000, '104923'),
(9552, 'US-CA-104924', 'Milpitas', 'CI', 4169, 37.44040000000, -121.87050000000, '104924'),
(9553, 'US-CA-104925', 'Morgan Hill', 'CI', 4169, 37.17470000000, -121.65180000000, '104925'),
(9554, 'US-CA-104926', 'Cupertino', 'CI', 4169, 37.30420000000, -122.09460000000, '104926'),
(9555, 'US-CA-104927', 'Coarsegold', 'CI', 4169, 37.17400000000, -119.70980000000, '104927'),
(9556, 'US-NY-104928', 'Elmhurst', 'CI', 4200, 40.73540000000, -73.87830000000, '104928'),
(9557, 'US-MI-104929', 'Warren', 'CI', 4190, 42.47360000000, -82.99680000000, '104929'),
(9558, 'US-MI-104930', 'Romulus', 'CI', 4190, 42.20300000000, -83.31660000000, '104930'),
(9559, 'US-MI-104931', 'Allen Park', 'CI', 4190, 42.26540000000, -83.20800000000, '104931'),
(9560, 'US-HI-104932', 'Lihue', 'CI', 4178, 21.97700000000, -159.39110000000, '104932'),
(9561, 'US-OH-104933', 'Franklin', 'CI', 4204, 39.53270000000, -84.29010000000, '104933'),
(9562, 'US-OH-104934', 'Springfield', 'CI', 4204, 39.95860000000, -83.80630000000, '104934'),
(9563, 'US-NY-104935', 'Gloversville', 'CI', 4200, 43.13130000000, -74.35710000000, '104935'),
(9564, 'US-OH-104936', 'Fairborn', 'CI', 4204, 39.82700000000, -84.01870000000, '104936'),
(9565, 'US-GA-104937', 'Byron', 'CI', 4176, 32.66120000000, -83.78540000000, '104937'),
(9566, 'US-OH-104938', 'Dayton', 'CI', 4204, 39.70040000000, -84.21620000000, '104938'),
(9567, 'US-OH-104939', 'Piqua', 'CI', 4204, 40.16760000000, -84.21780000000, '104939'),
(9568, 'US-OH-104940', 'Lima', 'CI', 4204, 40.79880000000, -84.13190000000, '104940'),
(9569, 'US-OH-104941', 'Vandalia', 'CI', 4204, 39.88900000000, -84.22960000000, '104941'),
(9570, 'US-SC-104942', 'Duncan', 'CI', 4211, 34.91040000000, -82.12300000000, '104942'),
(9571, 'US-OH-104943', 'Greenville', 'CI', 4204, 40.08370000000, -84.63880000000, '104943'),
(9572, 'US-CA-104944', 'Valencia', 'CI', 4169, 34.41800000000, -118.56620000000, '104944'),
(9573, 'US-MI-104945', 'Wixom', 'CI', 4190, 42.52000000000, -83.55170000000, '104945'),
(9574, 'US-MI-104946', 'Huntington Woods', 'CI', 4190, 42.48160000000, -83.16800000000, '104946'),
(9575, 'US-MI-104947', 'Farmington', 'CI', 4190, 42.50650000000, -83.34910000000, '104947'),
(9576, 'US-MI-104948', 'Sterling Heights', 'CI', 4190, 42.55870000000, -83.00920000000, '104948'),
(9577, 'US-OH-104949', 'Holland', 'CI', 4204, 41.63250000000, -83.75100000000, '104949'),
(9578, 'US-MI-104950', 'Birmingham', 'CI', 4190, 42.54570000000, -83.21650000000, '104950'),
(9579, 'US-MI-104951', 'Ray', 'CI', 4190, 42.76130000000, -82.91960000000, '104951'),
(9580, 'US-MI-104952', 'Flint', 'CI', 4190, 43.01380000000, -83.68830000000, '104952'),
(9581, 'US-MI-104953', 'Clinton Township', 'CI', 4190, 42.59910000000, -82.93120000000, '104953'),
(9583, 'US-MI-104955', 'Davisburg', 'CI', 4190, 42.74290000000, -83.51820000000, '104955'),
(9584, 'US-IA-104956', 'Percival', 'CI', 4182, 40.73200000000, -95.79650000000, '104956'),
(9585, 'US-CA-104957', 'Lancaster', 'CI', 4169, 34.72970000000, -118.15750000000, '104957'),
(9586, 'US-IA-104958', 'Pella', 'CI', 4182, 41.41300000000, -92.92300000000, '104958'),
(9587, 'US-CA-104959', 'Oroville', 'CI', 4169, 39.45940000000, -121.39720000000, '104959'),
(9588, 'US-NY-104960', 'Ballston Spa', 'CI', 4200, 43.00560000000, -73.86280000000, '104960'),
(9589, 'US-IA-104961', 'Waterloo', 'CI', 4182, 42.45690000000, -92.31500000000, '104961'),
(9590, 'US-TX-104962', 'Houston', 'CI', 4214, 29.83270000000, -95.66270000000, '104962'),
(9591, 'US-IA-104963', 'Forest City', 'CI', 4182, 43.26110000000, -93.68480000000, '104963'),
(9592, 'US-AL-104964', 'Chatom', 'CI', 4161, 31.47220000000, -88.25220000000, '104964'),
(9593, 'US-IA-104965', 'Johnston', 'CI', 4182, 41.70310000000, -93.72040000000, '104965'),
(9594, 'US-MA-104966', 'North Billerica', 'CI', 4189, 42.57100000000, -71.27550000000, '104966'),
(9595, 'US-MA-104967', 'Braintree', 'CI', 4189, 42.20320000000, -71.00960000000, '104967'),
(9596, 'US-MA-104968', 'Hampden', 'CI', 4189, 42.06790000000, -72.41850000000, '104968'),
(9597, 'US-MA-104969', 'Medford', 'CI', 4189, 42.42470000000, -71.11120000000, '104969'),
(9598, 'US-NY-104970', 'Latham', 'CI', 4200, 42.75260000000, -73.78040000000, '104970'),
(9599, 'US-MA-104971', 'Weston', 'CI', 4189, 42.35780000000, -71.29570000000, '104971'),
(9600, 'US-CA-104972', 'Livermore', 'CI', 4169, 37.50380000000, -121.52530000000, '104972'),
(9601, 'US-IA-104973', 'Story City', 'CI', 4182, 42.19430000000, -93.62950000000, '104973'),
(9602, 'US-KY-104974', 'Van Lear', 'CI', 4184, 37.75850000000, -82.71320000000, '104974'),
(9603, 'US-IL-104975', 'Mount Prospect', 'CI', 4180, 42.06240000000, -87.93090000000, '104975'),
(9604, 'US-MO-104976', 'Perryville', 'CI', 4193, 37.73070000000, -89.90600000000, '104976'),
(9605, 'US-MO-104977', 'Eureka', 'CI', 4193, 38.51050000000, -90.63650000000, '104977'),
(9606, 'US-IL-104978', 'Springfield', 'CI', 4180, 39.80110000000, -89.65020000000, '104978'),
(9607, 'US-IL-104979', 'East Saint Louis', 'CI', 4180, 38.61250000000, -90.16780000000, '104979'),
(9609, 'US-VT-104981', 'Springfield', 'CI', 4216, 43.32300000000, -72.47000000000, '104981'),
(9610, 'US-NH-104982', 'Meredith', 'CI', 4197, 43.63220000000, -71.51460000000, '104982'),
(9611, 'US-NH-104983', 'Troy', 'CI', 4197, 42.82960000000, -72.18550000000, '104983'),
(9612, 'US-TX-104984', 'Sugar Land', 'CI', 4214, 29.55570000000, -95.63350000000, '104984'),
(9613, 'US-NH-104985', 'Manchester', 'CI', 4197, 42.94030000000, -71.44350000000, '104985'),
(9614, 'US-MD-104986', 'Hyattsville', 'CI', 4188, 38.95450000000, -76.94430000000, '104986'),
(9615, 'US-IL-104987', 'Murphysboro', 'CI', 4180, 37.76800000000, -89.32750000000, '104987'),
(9616, 'US-MS-104988', 'West Point', 'CI', 4192, 33.65210000000, -88.69530000000, '104988'),
(9617, 'US-TN-104989', 'Dresden', 'CI', 4213, 36.33650000000, -88.67140000000, '104989'),
(9618, 'US-MA-104990', 'Marlborough', 'CI', 4189, 42.34580000000, -71.55060000000, '104990'),
(9619, 'US-NH-104991', 'Spofford', 'CI', 4197, 42.89700000000, -72.41550000000, '104991'),
(9620, 'US-MS-104992', 'Batesville', 'CI', 4192, 34.29880000000, -89.94780000000, '104992'),
(9621, 'US-MS-104993', 'Oxford', 'CI', 4192, 34.34020000000, -89.48330000000, '104993'),
(9622, 'US-TN-104994', 'Savannah', 'CI', 4213, 35.20460000000, -88.14990000000, '104994'),
(9623, 'US-TN-104995', 'Oakland', 'CI', 4213, 35.21990000000, -89.49960000000, '104995'),
(9624, 'US-HI-104996', 'Waipahu', 'CI', 4178, 21.41160000000, -158.01830000000, '104996'),
(9625, 'US-AZ-104997', 'Tolleson', 'CI', 4164, 33.42230000000, -112.27250000000, '104997'),
(9626, 'US-HI-104998', 'Aiea', 'CI', 4178, 21.40940000000, -157.89820000000, '104998'),
(9627, 'US-HI-104999', 'Kahului', 'CI', 4178, 20.88020000000, -156.46890000000, '104999'),
(9628, 'US-HI-105000', 'Kapolei', 'CI', 4178, 21.37750000000, -158.08620000000, '105000'),
(9629, 'US-HI-105001', 'Hilo', 'CI', 4178, 19.69760000000, -155.14130000000, '105001'),
(9630, 'US-IL-105002', 'Collinsville', 'CI', 4180, 38.69180000000, -89.99110000000, '105002'),
(9631, 'US-NY-105003', 'Yonkers', 'CI', 4200, 40.95130000000, -73.87730000000, '105003'),
(9632, 'US-KY-105004', 'Richmond', 'CI', 4184, 37.76660000000, -84.30310000000, '105004'),
(9633, 'US-CT-105005', 'Derby', 'CI', 4171, 41.33330000000, -73.10190000000, '105005'),
(9634, 'US-MO-105006', 'Scott City', 'CI', 4193, 37.17840000000, -89.53830000000, '105006'),
(9635, 'US-HI-105007', 'Kihei', 'CI', 4178, 20.69890000000, -156.44300000000, '105007'),
(9636, 'US-FL-105008', 'Sarasota', 'CI', 4175, 27.31010000000, -82.52140000000, '105008'),
(9637, 'US-VA-105009', 'King George', 'CI', 4218, 38.27330000000, -77.17390000000, '105009'),
(9638, 'US-VA-105010', 'Orange', 'CI', 4218, 38.22070000000, -78.05590000000, '105010'),
(9639, 'US-FL-105011', 'Fort Myers', 'CI', 4175, 26.52990000000, -81.69070000000, '105011'),
(9640, 'US-NY-105012', 'West Harrison', 'CI', 4200, 41.05680000000, -73.73040000000, '105012'),
(9641, 'US-ND-105013', 'Fargo', 'CI', 4202, 46.85430000000, -96.82840000000, '105013'),
(9642, 'US-NH-105014', 'Portsmouth', 'CI', 4197, 43.06770000000, -70.80080000000, '105014'),
(9643, 'US-ND-105015', 'Jamestown', 'CI', 4202, 46.89920000000, -98.74580000000, '105015'),
(9644, 'US-MN-105016', 'Canby', 'CI', 4191, 44.70500000000, -96.25180000000, '105016'),
(9645, 'US-MN-105017', 'Chanhassen', 'CI', 4191, 44.85800000000, -93.55880000000, '105017'),
(9646, 'US-MN-105018', 'Austin', 'CI', 4191, 43.67300000000, -92.95920000000, '105018'),
(9647, 'US-MN-105019', 'Sauk Centre', 'CI', 4191, 45.72650000000, -94.98470000000, '105019'),
(9648, 'US-ND-105020', 'Minot', 'CI', 4202, 48.33600000000, -101.32560000000, '105020'),
(9649, 'US-MA-105021', 'Chelmsford', 'CI', 4189, 42.58790000000, -71.34980000000, '105021'),
(9650, 'US-MN-105022', 'Wheaton', 'CI', 4191, 45.83990000000, -96.44790000000, '105022'),
(9651, 'US-PA-105023', 'Collegeville', 'CI', 4208, 40.18790000000, -75.42540000000, '105023'),
(9652, 'US-PA-105024', 'Coatesville', 'CI', 4208, 39.96830000000, -75.82670000000, '105024'),
(9653, 'US-PA-105025', 'Reading', 'CI', 4208, 40.33770000000, -75.97690000000, '105025'),
(9654, 'US-PA-105026', 'Exton', 'CI', 4208, 40.04090000000, -75.63740000000, '105026'),
(9655, 'US-PA-105027', 'Telford', 'CI', 4208, 40.32650000000, -75.36970000000, '105027'),
(9656, 'US-PA-105028', 'Phoenixville', 'CI', 4208, 40.12460000000, -75.53850000000, '105028'),
(9657, 'US-PA-105029', 'Pottstown', 'CI', 4208, 40.26050000000, -75.61550000000, '105029'),
(9658, 'US-PA-105030', 'Newtown Square', 'CI', 4208, 39.98530000000, -75.43670000000, '105030'),
(9659, 'US-PA-105031', 'Chadds Ford', 'CI', 4208, 39.85540000000, -75.63420000000, '105031'),
(9660, 'US-PA-105032', 'West Grove', 'CI', 4208, 39.84860000000, -75.82200000000, '105032'),
(9661, 'US-PA-105033', 'Bryn Mawr', 'CI', 4208, 40.02660000000, -75.33330000000, '105033'),
(9662, 'US-PA-105034', 'Allentown', 'CI', 4208, 40.58440000000, -75.62460000000, '105034'),
(9663, 'US-PA-105035', 'Lansdale', 'CI', 4208, 40.22620000000, -75.29310000000, '105035'),
(9664, 'US-PA-105036', 'Emmaus', 'CI', 4208, 40.51890000000, -75.50130000000, '105036'),
(9665, 'US-GA-105037', 'Norcross', 'CI', 4176, 33.96810000000, -84.23040000000, '105037'),
(9666, 'US-PA-105038', 'West Chester', 'CI', 4208, 39.92390000000, -75.62030000000, '105038'),
(9667, 'US-PA-105039', 'Montgomeryville', 'CI', 4208, 40.22160000000, -75.22640000000, '105039'),
(9668, 'US-PA-105040', 'Wayne', 'CI', 4208, 40.05480000000, -75.40830000000, '105040'),
(9669, 'US-PA-105041', 'Plymouth Meeting', 'CI', 4208, 40.11580000000, -75.28420000000, '105041'),
(9670, 'US-PA-105042', 'Ardmore', 'CI', 4208, 40.00240000000, -75.30080000000, '105042'),
(9671, 'US-PA-105043', 'Mohnton', 'CI', 4208, 40.23910000000, -75.96600000000, '105043'),
(9672, 'US-PA-105044', 'Bethlehem', 'CI', 4208, 40.66860000000, -75.32950000000, '105044'),
(9673, 'US-DE-105045', 'Newark', 'CI', 4172, 39.61550000000, -75.70440000000, '105045'),
(9674, 'US-PA-105046', 'Media', 'CI', 4208, 39.91930000000, -75.41900000000, '105046'),
(9675, 'US-NC-105047', 'Concord', 'CI', 4201, 35.41980000000, -80.67480000000, '105047'),
(9676, 'US-PA-105048', 'Valley Forge', 'CI', 4208, 40.09440000000, -75.46920000000, '105048'),
(9677, 'US-PA-105049', 'Easton', 'CI', 4208, 40.69100000000, -75.27930000000, '105049'),
(9678, 'US-PA-105050', 'Coopersburg', 'CI', 4208, 40.50210000000, -75.37650000000, '105050'),
(9679, 'US-DE-105051', 'New Castle', 'CI', 4172, 39.63870000000, -75.61950000000, '105051'),
(9680, 'US-PA-105052', 'Conshohocken', 'CI', 4208, 40.07980000000, -75.28550000000, '105052'),
(9681, 'US-DE-105053', 'Bear', 'CI', 4172, 39.60250000000, -75.69450000000, '105053'),
(9682, 'US-PA-105054', 'Oakdale', 'CI', 4208, 40.40640000000, -80.18760000000, '105054'),
(9683, 'US-PA-105055', 'Paoli', 'CI', 4208, 40.04030000000, -75.48540000000, '105055'),
(9684, 'US-MA-105056', 'Hyde Park', 'CI', 4189, 42.25330000000, -71.12930000000, '105056'),
(9685, 'US-MA-105057', 'Hanover', 'CI', 4189, 42.12260000000, -70.85170000000, '105057'),
(9686, 'US-MA-105058', 'Acton', 'CI', 4189, 42.48530000000, -71.44180000000, '105058'),
(9687, 'US-PA-105059', 'Norristown', 'CI', 4208, 40.15450000000, -75.38090000000, '105059'),
(9688, 'US-PA-105060', 'Fogelsville', 'CI', 4208, 40.59960000000, -75.66650000000, '105060'),
(9689, 'US-PA-105061', 'Wynnewood', 'CI', 4208, 39.99840000000, -75.27120000000, '105061'),
(9690, 'US-PA-105062', 'Devon', 'CI', 4208, 40.03960000000, -75.42250000000, '105062'),
(9691, 'US-PA-105063', 'Berwyn', 'CI', 4208, 40.03080000000, -75.44990000000, '105063'),
(9692, 'US-KY-105064', 'Lexington', 'CI', 4184, 38.13460000000, -84.49580000000, '105064'),
(9693, 'US-WA-105065', 'Gig Harbor', 'CI', 4219, 47.36480000000, -122.60480000000, '105065'),
(9694, 'US-WA-105066', 'Woodinville', 'CI', 4219, 47.75700000000, -122.09280000000, '105066'),
(9695, 'US-WA-105067', 'Seattle', 'CI', 4219, 47.60260000000, -122.32840000000, '105067'),
(9696, 'US-NV-105068', 'Las Vegas', 'CI', 4196, 36.11000000000, -115.21180000000, '105068'),
(9697, 'US-WA-105069', 'Bellevue', 'CI', 4219, 47.55270000000, -122.14790000000, '105069'),
(9698, 'US-WA-105070', 'Renton', 'CI', 4219, 47.46370000000, -122.21350000000, '105070'),
(9699, 'US-MT-105071', 'Saint Ignatius', 'CI', 4194, 47.32940000000, -114.02310000000, '105071'),
(9700, 'US-WA-105072', 'Burlington', 'CI', 4219, 48.53230000000, -122.31840000000, '105072'),
(9701, 'US-WA-105073', 'Winlock', 'CI', 4219, 46.48950000000, -122.87810000000, '105073'),
(9702, 'US-CA-105074', 'San Bernardino', 'CI', 4169, 34.07800000000, -117.25780000000, '105074'),
(9703, 'US-CO-105075', 'Mosca', 'CI', 4170, 37.63520000000, -105.71380000000, '105075'),
(9704, 'US-CO-105076', 'Broomfield', 'CI', 4170, 39.89380000000, -105.11440000000, '105076'),
(9705, 'US-ND-105077', 'Velva', 'CI', 4202, 48.02170000000, -100.96050000000, '105077'),
(9706, 'US-KS-105078', 'Ottawa', 'CI', 4183, 38.62270000000, -95.26890000000, '105078'),
(9707, 'US-WA-105079', 'Everett', 'CI', 4219, 48.00300000000, -122.25640000000, '105079'),
(9708, 'US-ND-105080', 'Dickinson', 'CI', 4202, 46.91530000000, -102.83660000000, '105080'),
(9709, 'US-MA-105081', 'Taunton', 'CI', 4189, 41.91130000000, -71.13000000000, '105081'),
(9710, 'US-WA-105082', 'Redmond', 'CI', 4219, 47.68010000000, -122.12060000000, '105082'),
(9711, 'US-WA-105083', 'Auburn', 'CI', 4219, 47.31010000000, -122.20420000000, '105083'),
(9712, 'US-CA-105084', 'Desert Hot Springs', 'CI', 4169, 33.83530000000, -116.29840000000, '105084'),
(9713, 'US-SD-105085', 'Mitchell', 'CI', 4212, 43.71830000000, -98.02620000000, '105085'),
(9714, 'US-WA-105086', 'Yelm', 'CI', 4219, 46.87190000000, -122.57370000000, '105086'),
(9715, 'US-TX-105087', 'San Angelo', 'CI', 4214, 31.54680000000, -100.56100000000, '105087'),
(9716, 'US-IL-105088', 'Bourbonnais', 'CI', 4180, 41.19160000000, -87.85550000000, '105088'),
(9717, 'US-WA-105089', 'Lynnwood', 'CI', 4219, 47.85610000000, -122.28290000000, '105089'),
(9718, 'US-SD-105090', 'Colman', 'CI', 4212, 44.01860000000, -96.82870000000, '105090'),
(9719, 'US-WA-105091', 'Pacific', 'CI', 4219, 47.25850000000, -122.24600000000, '105091'),
(9720, 'US-PA-105092', 'Erie', 'CI', 4208, 42.05770000000, -80.04340000000, '105092'),
(9721, 'US-AK-105093', 'Anchorage', 'CI', 4162, 61.22310000000, -149.85280000000, '105093'),
(9722, 'US-WA-105094', 'Sunnyside', 'CI', 4219, 46.44360000000, -119.91890000000, '105094'),
(9723, 'US-OH-105095', 'Cleveland', 'CI', 4204, 41.43790000000, -81.53660000000, '105095'),
(9724, 'US-WA-105096', 'Edmonds', 'CI', 4219, 47.83540000000, -122.32790000000, '105096'),
(9725, 'US-TX-105097', 'Hearne', 'CI', 4214, 30.86450000000, -96.53910000000, '105097'),
(9726, 'US-WA-105098', 'Mount Vernon', 'CI', 4219, 48.42980000000, -122.42760000000, '105098'),
(9727, 'US-UT-105099', 'Ogden', 'CI', 4215, 41.24710000000, -112.13160000000, '105099'),
(9728, 'US-CA-105100', 'Anaheim', 'CI', 4169, 33.83120000000, -117.86730000000, '105100'),
(9729, 'US-WA-105101', 'Lakebay', 'CI', 4219, 47.28330000000, -122.77470000000, '105101'),
(9730, 'US-WA-105102', 'Selah', 'CI', 4219, 46.76820000000, -120.68720000000, '105102'),
(9731, 'US-WA-105103', 'Bremerton', 'CI', 4219, 47.57100000000, -122.75680000000, '105103'),
(9732, 'US-SD-105104', 'Tabor', 'CI', 4212, 42.94100000000, -97.68450000000, '105104'),
(9733, 'US-NJ-105105', 'Summit', 'CI', 4198, 40.71390000000, -74.36890000000, '105105'),
(9734, 'US-WA-105106', 'Bellingham', 'CI', 4219, 48.73950000000, -122.48090000000, '105106'),
(9735, 'US-MT-105107', 'Billings', 'CI', 4194, 45.76610000000, -108.57890000000, '105107'),
(9736, 'US-FL-105108', 'Hollywood', 'CI', 4175, 25.98250000000, -80.34340000000, '105108'),
(9737, 'US-MA-105109', 'Peabody', 'CI', 4189, 42.53240000000, -70.97360000000, '105109'),
(9738, 'US-WA-105110', 'Elma', 'CI', 4219, 47.10540000000, -123.39760000000, '105110'),
(9739, 'US-WA-105111', 'Port Angeles', 'CI', 4219, 47.99610000000, -123.25190000000, '105111'),
(9740, 'US-WA-105112', 'Puyallup', 'CI', 4219, 47.19530000000, -122.33120000000, '105112'),
(9741, 'US-WA-105113', 'Federal Way', 'CI', 4219, 47.30780000000, -122.31770000000, '105113'),
(9742, 'US-WA-105114', 'Winthrop', 'CI', 4219, 48.50780000000, -120.33620000000, '105114'),
(9743, 'US-VA-105115', 'Harrisonburg', 'CI', 4218, 38.40310000000, -78.89140000000, '105115'),
(9744, 'US-IL-105116', 'Northbrook', 'CI', 4180, 42.11970000000, -87.84450000000, '105116'),
(9745, 'US-GA-105117', 'Kennesaw', 'CI', 4176, 34.03310000000, -84.60110000000, '105117'),
(9746, 'US-KY-105118', 'Pikeville', 'CI', 4184, 37.48790000000, -82.49560000000, '105118'),
(9747, 'US-VA-105119', 'Ashburn', 'CI', 4218, 39.03350000000, -77.48380000000, '105119'),
(9748, 'US-OK-105120', 'Lawton', 'CI', 4205, 34.57980000000, -98.48800000000, '105120'),
(9749, 'US-NE-105121', 'North Platte', 'CI', 4195, 41.11910000000, -100.79150000000, '105121'),
(9750, 'US-IL-105122', 'Trenton', 'CI', 4180, 38.61820000000, -89.70650000000, '105122'),
(9751, 'US-IL-105123', 'Benton', 'CI', 4180, 37.99300000000, -88.92110000000, '105123'),
(9752, 'US-IL-105124', 'Jacksonville', 'CI', 4180, 39.74010000000, -90.23880000000, '105124'),
(9753, 'US-IL-105125', 'Virginia', 'CI', 4180, 39.96720000000, -90.20410000000, '105125'),
(9754, 'US-IL-105126', 'Sullivan', 'CI', 4180, 39.58790000000, -88.58130000000, '105126'),
(9755, 'US-MO-105127', 'Potosi', 'CI', 4193, 37.92990000000, -90.90770000000, '105127'),
(9756, 'US-MO-105128', 'Herculaneum', 'CI', 4193, 38.25910000000, -90.39280000000, '105128'),
(9757, 'US-MO-105129', 'Earth City', 'CI', 4193, 38.76770000000, -90.46780000000, '105129'),
(9758, 'US-IL-105130', 'Casey', 'CI', 4180, 39.30140000000, -87.99990000000, '105130'),
(9759, 'US-CA-105131', 'Palm Desert', 'CI', 4169, 33.77240000000, -116.34580000000, '105131'),
(9760, 'US-HI-105132', 'Pearl Harbor', 'CI', 4178, 24.85980000000, -168.02180000000, '105132'),
(9761, 'US-TX-105133', 'Richardson', 'CI', 4214, 32.99140000000, -96.66450000000, '105133'),
(9762, 'US-TX-105134', 'Plano', 'CI', 4214, 33.08120000000, -96.81330000000, '105134'),
(9763, 'US-KY-105135', 'Hopkinsville', 'CI', 4184, 36.90740000000, -87.45970000000, '105135'),
(9764, 'US-HI-105136', 'Waikoloa', 'CI', 4178, 19.93050000000, -155.79670000000, '105136'),
(9765, 'US-KS-105137', 'Burlingame', 'CI', 4183, 38.78250000000, -95.89010000000, '105137'),
(9766, 'US-KS-105138', 'Atwood', 'CI', 4183, 39.79930000000, -101.09440000000, '105138'),
(9767, 'US-KS-105139', 'De Soto', 'CI', 4183, 38.96440000000, -94.98060000000, '105139'),
(9768, 'US-MO-105140', 'Riverside', 'CI', 4193, 39.17170000000, -94.63230000000, '105140'),
(9769, 'US-KS-105141', 'Kansas City', 'CI', 4183, 39.11850000000, -94.62480000000, '105141'),
(9770, 'US-KS-105142', 'Manhattan', 'CI', 4183, 39.10230000000, -96.52460000000, '105142'),
(9771, 'US-MO-105143', 'Republic', 'CI', 4193, 37.12910000000, -93.51510000000, '105143'),
(9772, 'US-MO-105144', 'Moberly', 'CI', 4193, 39.40370000000, -92.40880000000, '105144'),
(9773, 'US-KS-105145', 'Chase', 'CI', 4183, 38.36220000000, -98.38750000000, '105145'),
(9774, 'US-IL-105146', 'Mokena', 'CI', 4180, 41.53300000000, -87.88980000000, '105146'),
(9775, 'US-SC-105147', 'Rock Hill', 'CI', 4211, 34.88890000000, -81.02370000000, '105147'),
(9776, 'US-KS-105148', 'Oswego', 'CI', 4183, 37.17740000000, -95.17090000000, '105148'),
(9777, 'US-CA-105149', 'Montclair', 'CI', 4169, 34.07100000000, -117.70100000000, '105149'),
(9778, 'US-AZ-105150', 'Rio Rico', 'CI', 4164, 31.50170000000, -111.06880000000, '105150'),
(9779, 'US-VA-105151', 'Williamsburg', 'CI', 4218, 37.35400000000, -76.74670000000, '105151'),
(9780, 'US-TX-105152', 'Port Lavaca', 'CI', 4214, 28.60100000000, -96.69900000000, '105152'),
(9781, 'US-GA-105153', 'Royston', 'CI', 4176, 34.25620000000, -83.16760000000, '105153'),
(9782, 'US-TX-105154', 'Tyler', 'CI', 4214, 32.42180000000, -95.20560000000, '105154'),
(9783, 'US-MD-105155', 'Elkridge', 'CI', 4188, 39.20580000000, -76.74800000000, '105155'),
(9784, 'US-AZ-105156', 'Goodyear', 'CI', 4164, 33.37760000000, -112.38740000000, '105156'),
(9785, 'US-AZ-105157', 'Nogales', 'CI', 4164, 31.45020000000, -110.83110000000, '105157'),
(9786, 'US-NC-105158', 'Cherokee', 'CI', 4201, 35.51610000000, -83.27330000000, '105158'),
(9787, 'US-CA-105159', 'Los Gatos', 'CI', 4169, 37.23040000000, -121.95050000000, '105159'),
(9788, 'US-CA-105160', 'Camarillo', 'CI', 4169, 34.20410000000, -118.98070000000, '105160'),
(9789, 'US-AZ-105161', 'Winslow', 'CI', 4164, 35.10130000000, -110.64730000000, '105161'),
(9790, 'US-NJ-105162', 'Teaneck', 'CI', 4198, 40.88890000000, -74.01190000000, '105162'),
(9791, 'US-AZ-105163', 'Peoria', 'CI', 4164, 33.65740000000, -112.24630000000, '105163'),
(9792, 'US-NC-105164', 'Charlotte', 'CI', 4201, 35.12320000000, -80.93430000000, '105164'),
(9793, 'US-TX-105165', 'Lewisville', 'CI', 4214, 33.03060000000, -96.99260000000, '105165'),
(9794, 'US-NE-105166', 'Shelton', 'CI', 4195, 40.82090000000, -98.74430000000, '105166'),
(9795, 'US-AZ-105167', 'Arizona City', 'CI', 4164, 32.76530000000, -111.65880000000, '105167'),
(9796, 'US-VA-105168', 'Suffolk', 'CI', 4218, 36.82790000000, -76.48000000000, '105168'),
(9797, 'US-IL-105169', 'Savoy', 'CI', 4180, 40.05830000000, -88.25730000000, '105169'),
(9798, 'US-NJ-105170', 'Swedesboro', 'CI', 4198, 39.74370000000, -75.34620000000, '105170'),
(9799, 'US-AL-105171', 'Eufaula', 'CI', 4161, 31.91840000000, -85.20860000000, '105171'),
(9800, 'US-NY-105172', 'Bellerose', 'CI', 4200, 40.73860000000, -73.72240000000, '105172'),
(9801, 'US-NY-105173', 'Valley Stream', 'CI', 4200, 40.65300000000, -73.71450000000, '105173'),
(9802, 'US-PA-105174', 'New Columbia', 'CI', 4208, 41.06310000000, -76.98050000000, '105174'),
(9803, 'US-AL-105175', 'Warrior', 'CI', 4161, 33.81850000000, -86.84000000000, '105175'),
(9804, 'US-AL-105176', 'Montgomery', 'CI', 4161, 32.39200000000, -86.24150000000, '105176'),
(9805, 'US-AL-105177', 'Daleville', 'CI', 4161, 31.25450000000, -85.71330000000, '105177'),
(9806, 'US-AL-105178', 'Trussville', 'CI', 4161, 33.64640000000, -86.56960000000, '105178'),
(9807, 'US-AL-105179', 'Enterprise', 'CI', 4161, 31.30760000000, -85.88060000000, '105179'),
(9808, 'US-MD-105180', 'Lexington Park', 'CI', 4188, 38.23450000000, -76.43080000000, '105180'),
(9809, 'US-AL-105181', 'Arab', 'CI', 4161, 34.31220000000, -86.50490000000, '105181'),
(9810, 'US-AL-105182', 'Moundville', 'CI', 4161, 32.93940000000, -87.58510000000, '105182'),
(9811, 'US-AL-105183', 'Verbena', 'CI', 4161, 32.75810000000, -86.51550000000, '105183'),
(9812, 'US-AL-105184', 'Houston', 'CI', 4161, 34.18490000000, -87.30230000000, '105184'),
(9813, 'US-NJ-105185', 'Voorhees', 'CI', 4198, 39.84130000000, -74.93750000000, '105185'),
(9814, 'US-AL-105186', 'Huntsville', 'CI', 4161, 34.75280000000, -86.69010000000, '105186'),
(9815, 'US-AL-105187', 'Tuscaloosa', 'CI', 4161, 33.33230000000, -87.47410000000, '105187'),
(9816, 'US-AL-105188', 'Scottsboro', 'CI', 4161, 34.80230000000, -86.10280000000, '105188'),
(9817, 'US-NY-105189', 'Port Washington', 'CI', 4200, 40.83730000000, -73.69380000000, '105189'),
(9818, 'US-MI-105190', 'Lansing', 'CI', 4190, 42.74220000000, -84.52550000000, '105190'),
(9819, 'US-CA-105191', 'Escondido', 'CI', 4169, 33.12590000000, -117.10160000000, '105191'),
(9820, 'US-CA-105192', 'Simi Valley', 'CI', 4169, 34.25210000000, -118.78430000000, '105192'),
(9821, 'US-OR-105193', 'Lake Oswego', 'CI', 4206, 45.41140000000, -122.72400000000, '105193'),
(9822, 'US-CA-105194', 'Spring Valley', 'CI', 4169, 32.71500000000, -116.94440000000, '105194'),
(9823, 'US-CA-105195', 'Solana Beach', 'CI', 4169, 32.99590000000, -117.25710000000, '105195'),
(9824, 'US-NY-105196', 'Marlboro', 'CI', 4200, 41.60230000000, -74.00330000000, '105196'),
(9825, 'US-CA-105197', 'Chula Vista', 'CI', 4169, 32.63610000000, -117.05320000000, '105197'),
(9826, 'US-CA-105198', 'San Marcos', 'CI', 4169, 33.15650000000, -117.17070000000, '105198'),
(9827, 'US-CA-105199', 'Tulare', 'CI', 4169, 36.18150000000, -119.36230000000, '105199'),
(9828, 'US-CA-105200', 'Rancho Santa Fe', 'CI', 4169, 33.03800000000, -117.19470000000, '105200'),
(9829, 'US-NJ-105201', 'Island Heights', 'CI', 4198, 39.99440000000, -74.11930000000, '105201'),
(9830, 'US-TX-105202', 'Odessa', 'CI', 4214, 31.90650000000, -102.25130000000, '105202'),
(9831, 'US-CA-105203', 'Encinitas', 'CI', 4169, 33.05010000000, -117.25280000000, '105203'),
(9832, 'US-FL-105204', 'Saint Petersburg', 'CI', 4175, 27.72070000000, -82.73760000000, '105204'),
(9833, 'US-FL-105205', 'North Miami Beach', 'CI', 4175, 25.92660000000, -80.14430000000, '105205'),
(9834, 'US-CA-105206', 'El Cajon', 'CI', 4169, 32.79520000000, -116.96710000000, '105206'),
(9835, 'US-CA-105207', 'La Jolla', 'CI', 4169, 32.86670000000, -117.24810000000, '105207'),
(9836, 'US-NJ-105208', 'North Bergen', 'CI', 4198, 40.79040000000, -74.02460000000, '105208'),
(9837, 'US-CA-105209', 'Vista', 'CI', 4169, 33.18200000000, -117.24680000000, '105209'),
(9838, 'US-CA-105210', 'Sanger', 'CI', 4169, 36.79630000000, -119.44540000000, '105210'),
(9839, 'US-KY-105211', 'La Grange', 'CI', 4184, 38.43700000000, -85.41330000000, '105211'),
(9840, 'US-MI-105212', 'Belleville', 'CI', 4190, 42.17590000000, -83.48070000000, '105212'),
(9841, 'US-CA-105213', 'Coronado', 'CI', 4169, 32.65050000000, -117.14920000000, '105213'),
(9843, 'US-CA-105215', 'Calexico', 'CI', 4169, 32.69140000000, -115.51710000000, '105215'),
(9844, 'US-CA-105216', 'Poway', 'CI', 4169, 32.97750000000, -117.02320000000, '105216'),
(9845, 'US-NY-105217', 'Buffalo', 'CI', 4200, 42.98640000000, -78.72790000000, '105217'),
(9846, 'US-OH-105218', 'Millersburg', 'CI', 4204, 40.51310000000, -81.86890000000, '105218'),
(9847, 'US-CA-105219', 'West Hills', 'CI', 4169, 34.20340000000, -118.69220000000, '105219'),
(9848, 'US-CA-105220', 'Carpinteria', 'CI', 4169, 34.43350000000, -119.52230000000, '105220'),
(9849, 'US-CA-105221', 'Santa Barbara', 'CI', 4169, 34.43860000000, -119.76960000000, '105221'),
(9850, 'US-CA-105222', 'North Hills', 'CI', 4169, 34.23870000000, -118.47720000000, '105222'),
(9851, 'US-CA-105223', 'Redlands', 'CI', 4169, 34.00080000000, -117.12660000000, '105223'),
(9852, 'US-CA-105224', 'Woodland Hills', 'CI', 4169, 34.17490000000, -118.61520000000, '105224'),
(9853, 'US-CA-105225', 'Rohnert Park', 'CI', 4169, 38.34330000000, -122.70410000000, '105225'),
(9854, 'US-CA-105226', 'Northridge', 'CI', 4169, 34.24170000000, -118.55040000000, '105226'),
(9855, 'US-FL-105227', 'Gainesville', 'CI', 4175, 29.68510000000, -82.43240000000, '105227'),
(9856, 'US-CA-105228', 'Lompoc', 'CI', 4169, 34.60450000000, -120.39800000000, '105228'),
(9857, 'US-CA-105229', 'Nipomo', 'CI', 4169, 35.05080000000, -120.48580000000, '105229'),
(9858, 'US-VA-105230', 'Covington', 'CI', 4218, 37.77810000000, -80.05910000000, '105230'),
(9859, 'US-FL-105231', 'Islamorada', 'CI', 4175, 24.86510000000, -80.71300000000, '105231'),
(9860, 'US-CA-105232', 'Santa Ana', 'CI', 4169, 33.76330000000, -117.79420000000, '105232'),
(9861, 'US-CA-105233', 'Palmdale', 'CI', 4169, 34.52000000000, -118.08350000000, '105233'),
(9862, 'US-CA-105234', 'Encino', 'CI', 4169, 34.15400000000, -118.49820000000, '105234'),
(9863, 'US-OH-105235', 'Maumee', 'CI', 4204, 41.57550000000, -83.68470000000, '105235'),
(9864, 'US-CA-105236', 'Sylmar', 'CI', 4169, 34.32100000000, -118.38300000000, '105236'),
(9865, 'US-CA-105237', 'Santa Maria', 'CI', 4169, 34.95560000000, -120.50270000000, '105237'),
(9866, 'US-CA-105238', 'Santa Ynez', 'CI', 4169, 34.64520000000, -120.02440000000, '105238'),
(9867, 'US-PA-105239', 'Saint Marys', 'CI', 4208, 41.44250000000, -78.53410000000, '105239'),
(9868, 'US-NY-105240', 'Ellicottville', 'CI', 4200, 42.29980000000, -78.64890000000, '105240'),
(9869, 'US-NY-105241', 'Lancaster', 'CI', 4200, 42.90570000000, -78.62640000000, '105241'),
(9870, 'US-PA-105242', 'Corry', 'CI', 4208, 41.91440000000, -79.64740000000, '105242'),
(9871, 'US-NY-105243', 'Port Chester', 'CI', 4200, 41.02320000000, -73.67950000000, '105243'),
(9872, 'US-NY-105244', 'Niagara Falls', 'CI', 4200, 43.08360000000, -79.03010000000, '105244'),
(9873, 'US-CA-105245', 'Goleta', 'CI', 4169, 34.50210000000, -120.12870000000, '105245'),
(9874, 'US-NJ-105246', 'Morris Plains', 'CI', 4198, 40.84470000000, -74.47810000000, '105246'),
(9875, 'US-CA-105247', 'Thousand Oaks', 'CI', 4169, 34.21330000000, -118.88000000000, '105247'),
(9876, 'US-MA-105248', 'Tewksbury', 'CI', 4189, 42.61050000000, -71.23060000000, '105248'),
(9877, 'US-MD-105249', 'Montgomery Village', 'CI', 4188, 39.17520000000, -77.17700000000, '105249'),
(9878, 'US-CO-105250', 'Grand Junction', 'CI', 4170, 39.12640000000, -108.53630000000, '105250'),
(9879, 'US-IN-105251', 'Fort Wayne', 'CI', 4181, 41.10050000000, -85.18200000000, '105251'),
(9880, 'US-MA-105252', 'Billerica', 'CI', 4189, 42.54930000000, -71.25580000000, '105252'),
(9881, 'US-TX-105253', 'Katy', 'CI', 4214, 29.73970000000, -95.83020000000, '105253'),
(9882, 'US-SC-105254', 'Fort Mill', 'CI', 4211, 35.01210000000, -80.88210000000, '105254'),
(9883, 'US-MA-105255', 'Beverly', 'CI', 4189, 42.56530000000, -70.85780000000, '105255'),
(9884, 'US-IL-105256', 'Belleville', 'CI', 4180, 38.54200000000, -89.99190000000, '105256'),
(9885, 'US-PA-105257', 'Bradford', 'CI', 4208, 41.90880000000, -78.70630000000, '105257'),
(9886, 'US-NY-105258', 'Tonawanda', 'CI', 4200, 42.99050000000, -78.84200000000, '105258');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(9887, 'US-MA-105259', 'Lexington', 'CI', 4189, 42.44280000000, -71.23170000000, '105259'),
(9888, 'US-MA-105260', 'Revere', 'CI', 4189, 42.41630000000, -70.99690000000, '105260'),
(9889, 'US-MA-105261', 'Randolph', 'CI', 4189, 42.16960000000, -71.06060000000, '105261'),
(9890, 'US-IL-105262', 'Glen Carbon', 'CI', 4180, 38.75490000000, -89.97400000000, '105262'),
(9891, 'US-CO-105263', 'Castle Rock', 'CI', 4170, 39.32760000000, -104.81630000000, '105263'),
(9892, 'US-MI-105264', 'Madison Heights', 'CI', 4190, 42.50530000000, -83.10520000000, '105264'),
(9893, 'US-AZ-105265', 'Sedona', 'CI', 4164, 34.94770000000, -111.93960000000, '105265'),
(9894, 'US-TN-105266', 'Brentwood', 'CI', 4213, 35.99850000000, -86.78060000000, '105266'),
(9895, 'US-NY-105267', 'Rome', 'CI', 4200, 43.22890000000, -75.40840000000, '105267'),
(9896, 'US-CA-105268', 'Ojai', 'CI', 4169, 34.51520000000, -119.28960000000, '105268'),
(9897, 'US-NJ-105269', 'Dunellen', 'CI', 4198, 40.60710000000, -74.48000000000, '105269'),
(9898, 'US-NH-105270', 'Concord', 'CI', 4197, 43.23390000000, -71.55970000000, '105270'),
(9899, 'US-CA-105271', 'Visalia', 'CI', 4169, 36.40630000000, -119.38090000000, '105271'),
(9900, 'US-NH-105272', 'Hampton', 'CI', 4197, 42.93170000000, -70.84270000000, '105272'),
(9901, 'US-NH-105273', 'Bedford', 'CI', 4197, 42.93960000000, -71.53530000000, '105273'),
(9902, 'US-NH-105274', 'Nashua', 'CI', 4197, 42.73050000000, -71.49580000000, '105274'),
(9903, 'US-NH-105275', 'Contoocook', 'CI', 4197, 43.19980000000, -71.69540000000, '105275'),
(9904, 'US-NH-105276', 'Auburn', 'CI', 4197, 42.98890000000, -71.34580000000, '105276'),
(9905, 'US-VT-105277', 'West Wardsboro', 'CI', 4216, 43.02560000000, -72.90100000000, '105277'),
(9906, 'US-VT-105278', 'Ludlow', 'CI', 4216, 43.40810000000, -72.70780000000, '105278'),
(9907, 'US-VT-105279', 'Rutland', 'CI', 4216, 43.64450000000, -72.90050000000, '105279'),
(9908, 'US-NH-105280', 'Berlin', 'CI', 4197, 44.43380000000, -71.27070000000, '105280'),
(9909, 'US-NH-105281', 'Merrimack', 'CI', 4197, 42.85020000000, -71.51550000000, '105281'),
(9910, 'US-IL-105282', 'Highland Park', 'CI', 4180, 42.18900000000, -87.80630000000, '105282'),
(9911, 'US-NH-105283', 'Bow', 'CI', 4197, 43.12750000000, -71.54560000000, '105283'),
(9912, 'US-MD-105284', 'Cockeysville', 'CI', 4188, 39.49180000000, -76.63280000000, '105284'),
(9913, 'US-NH-105285', 'Salem', 'CI', 4197, 42.79500000000, -71.22560000000, '105285'),
(9914, 'US-NH-105286', 'Stratham', 'CI', 4197, 43.01400000000, -70.89900000000, '105286'),
(9915, 'US-CT-105287', 'Southington', 'CI', 4171, 41.60050000000, -72.87640000000, '105287'),
(9916, 'US-NH-105288', 'Colebrook', 'CI', 4197, 44.89320000000, -71.40220000000, '105288'),
(9917, 'US-VT-105289', 'Pittsfield', 'CI', 4216, 43.77820000000, -72.82860000000, '105289'),
(9918, 'US-NH-105290', 'Rochester', 'CI', 4197, 43.30290000000, -71.04600000000, '105290'),
(9919, 'US-VT-105291', 'Windsor', 'CI', 4216, 43.48830000000, -72.45660000000, '105291'),
(9920, 'US-NH-105292', 'South Tamworth', 'CI', 4197, 43.81660000000, -71.31440000000, '105292'),
(9921, 'US-MI-105293', 'Utica', 'CI', 4190, 42.67110000000, -82.99950000000, '105293'),
(9922, 'US-NH-105294', 'Jackson', 'CI', 4197, 44.18410000000, -71.20180000000, '105294'),
(9923, 'US-VT-105295', 'Saint Albans', 'CI', 4216, 44.80910000000, -73.09220000000, '105295'),
(9924, 'US-NJ-105296', 'Lebanon', 'CI', 4198, 40.64210000000, -74.82000000000, '105296'),
(9925, 'US-CA-105297', 'San Leandro', 'CI', 4169, 37.70830000000, -122.12820000000, '105297'),
(9926, 'US-IL-105298', 'Matteson', 'CI', 4180, 41.50610000000, -87.73700000000, '105298'),
(9927, 'US-IL-105299', 'Maryville', 'CI', 4180, 38.72520000000, -89.96710000000, '105299'),
(9928, 'US-MA-105300', 'Duxbury', 'CI', 4189, 42.05020000000, -70.69500000000, '105300'),
(9929, 'US-IL-105301', 'Edwardsville', 'CI', 4180, 38.84900000000, -89.93850000000, '105301'),
(9930, 'US-MA-105302', 'Wakefield', 'CI', 4189, 42.50130000000, -71.06890000000, '105302'),
(9931, 'US-MA-105303', 'Lynn', 'CI', 4189, 42.46420000000, -70.97170000000, '105303'),
(9932, 'US-MA-105304', 'Allston', 'CI', 4189, 42.35960000000, -71.12870000000, '105304'),
(9933, 'US-IL-105305', 'O Fallon', 'CI', 4180, 38.60190000000, -89.91380000000, '105305'),
(9934, 'US-CA-105306', 'Valley Springs', 'CI', 4169, 38.16100000000, -120.84140000000, '105306'),
(9935, 'US-MA-105307', 'Plymouth', 'CI', 4189, 41.87340000000, -70.63940000000, '105307'),
(9936, 'US-IL-105308', 'Bethalto', 'CI', 4180, 38.91750000000, -90.05620000000, '105308'),
(9937, 'US-MI-105309', 'Redford', 'CI', 4190, 42.37580000000, -83.28080000000, '105309'),
(9938, 'US-MN-105310', 'Burnsville', 'CI', 4191, 44.77990000000, -93.27370000000, '105310'),
(9939, 'US-MN-105311', 'Eden Prairie', 'CI', 4191, 44.85580000000, -93.44080000000, '105311'),
(9940, 'US-MN-105312', 'Hopkins', 'CI', 4191, 44.91210000000, -93.40640000000, '105312'),
(9941, 'US-MN-105313', 'Lindstrom', 'CI', 4191, 45.40450000000, -92.83250000000, '105313'),
(9942, 'US-IL-105314', 'River Forest', 'CI', 4180, 41.89400000000, -87.81970000000, '105314'),
(9943, 'US-IL-105315', 'Elmwood Park', 'CI', 4180, 41.92320000000, -87.80570000000, '105315'),
(9944, 'US-PA-105316', 'Thorndale', 'CI', 4208, 39.99910000000, -75.75850000000, '105316'),
(9945, 'US-NC-105317', 'Greensboro', 'CI', 4201, 36.00740000000, -79.87320000000, '105317'),
(9946, 'US-FL-105318', 'Fort Pierce', 'CI', 4175, 27.45940000000, -80.53410000000, '105318'),
(9947, 'US-IL-105319', 'Morton', 'CI', 4180, 40.61080000000, -89.43500000000, '105319'),
(9948, 'US-LA-105320', 'Kaplan', 'CI', 4185, 29.98450000000, -92.32240000000, '105320'),
(9949, 'US-IL-105321', 'Oregon', 'CI', 4180, 41.98950000000, -89.29810000000, '105321'),
(9950, 'US-IA-105322', 'Davenport', 'CI', 4182, 41.57980000000, -90.62500000000, '105322'),
(9951, 'US-IL-105323', 'Peoria', 'CI', 4180, 40.69990000000, -89.59510000000, '105323'),
(9952, 'US-IL-105324', 'Mapleton', 'CI', 4180, 40.62670000000, -89.74180000000, '105324'),
(9953, 'US-IA-105325', 'Cedar Rapids', 'CI', 4182, 41.91060000000, -91.71420000000, '105325'),
(9954, 'US-IL-105326', 'Moline', 'CI', 4180, 41.48700000000, -90.47730000000, '105326'),
(9955, 'US-IL-105327', 'Milan', 'CI', 4180, 41.39740000000, -90.59010000000, '105327'),
(9956, 'US-IL-105328', 'Crystal Lake', 'CI', 4180, 42.23430000000, -88.30680000000, '105328'),
(9957, 'US-PA-105329', 'Philipsburg', 'CI', 4208, 40.86240000000, -78.17340000000, '105329'),
(9958, 'US-IA-105330', 'Iowa City', 'CI', 4182, 41.66950000000, -91.51330000000, '105330'),
(9959, 'US-SC-105331', 'Conway', 'CI', 4211, 33.86340000000, -78.97530000000, '105331'),
(9960, 'US-IL-105332', 'Rock Island', 'CI', 4180, 41.48670000000, -90.57250000000, '105332'),
(9961, 'US-IL-105333', 'Pekin', 'CI', 4180, 40.54940000000, -89.62520000000, '105333'),
(9962, 'US-CA-105334', 'San Dimas', 'CI', 4169, 34.10660000000, -117.81500000000, '105334'),
(9963, 'US-CA-105335', 'Van Nuys', 'CI', 4169, 34.20230000000, -118.44680000000, '105335'),
(9964, 'US-PA-105336', 'Beaver', 'CI', 4208, 40.69740000000, -80.37350000000, '105336'),
(9965, 'US-OK-105337', 'Tonkawa', 'CI', 4205, 36.60520000000, -97.32600000000, '105337'),
(9966, 'US-KY-105338', 'London', 'CI', 4184, 37.13280000000, -84.09640000000, '105338'),
(9967, 'US-FL-105339', 'Fort Lauderdale', 'CI', 4175, 26.18820000000, -80.17110000000, '105339'),
(9968, 'US-MN-105340', 'Lakeville', 'CI', 4191, 44.63070000000, -93.30340000000, '105340'),
(9969, 'US-MN-105341', 'Saint Cloud', 'CI', 4191, 45.52480000000, -94.04140000000, '105341'),
(9970, 'US-WI-105342', 'Minong', 'CI', 4221, 46.12190000000, -91.80090000000, '105342'),
(9971, 'US-VA-105343', 'Fairfax', 'CI', 4218, 38.86050000000, -77.26300000000, '105343'),
(9972, 'US-MI-105344', 'Kalkaska', 'CI', 4190, 44.72080000000, -85.09020000000, '105344'),
(9973, 'US-MI-105345', 'Zeeland', 'CI', 4190, 42.85540000000, -85.97140000000, '105345'),
(9974, 'US-MI-105346', 'Hillman', 'CI', 4190, 45.02950000000, -83.95330000000, '105346'),
(9975, 'US-CA-105347', 'Tustin', 'CI', 4169, 33.74010000000, -117.81960000000, '105347'),
(9976, 'US-MI-105348', 'Kalamazoo', 'CI', 4190, 42.26940000000, -85.56020000000, '105348'),
(9977, 'US-MI-105349', 'Hastings', 'CI', 4190, 42.63180000000, -85.29310000000, '105349'),
(9978, 'US-MN-105350', 'Marshall', 'CI', 4191, 44.44960000000, -95.74580000000, '105350'),
(9979, 'US-CA-105351', 'San Ramon', 'CI', 4169, 37.76790000000, -121.93580000000, '105351'),
(9980, 'US-KS-105352', 'Latham', 'CI', 4183, 37.52660000000, -96.62990000000, '105352'),
(9981, 'US-CO-105353', 'Aurora', 'CI', 4170, 39.73970000000, -104.79400000000, '105353'),
(9982, 'US-VA-105354', 'Stafford', 'CI', 4218, 38.47020000000, -77.49560000000, '105354'),
(9983, 'US-MN-105355', 'Chaska', 'CI', 4191, 44.80540000000, -93.62480000000, '105355'),
(9984, 'US-MN-105356', 'Mahnomen', 'CI', 4191, 47.32520000000, -95.79310000000, '105356'),
(9985, 'US-CA-105357', 'Downey', 'CI', 4169, 33.94150000000, -118.13070000000, '105357'),
(9986, 'US-KS-105358', 'Wichita', 'CI', 4183, 37.70830000000, -97.22510000000, '105358'),
(9987, 'US-CA-105359', 'Loyalton', 'CI', 4169, 39.63250000000, -120.21670000000, '105359'),
(9988, 'US-CA-105360', 'Long Beach', 'CI', 4169, 33.75420000000, -118.20190000000, '105360'),
(9989, 'US-SC-105361', 'Mount Pleasant', 'CI', 4211, 32.82290000000, -79.85490000000, '105361'),
(9990, 'US-OK-105362', 'Bartlesville', 'CI', 4205, 36.75030000000, -96.07050000000, '105362'),
(9991, 'US-OK-105363', 'Bristow', 'CI', 4205, 35.81910000000, -96.38970000000, '105363'),
(9992, 'US-OK-105364', 'Ponca City', 'CI', 4205, 36.71640000000, -97.15360000000, '105364'),
(9993, 'US-AR-105365', 'Waldron', 'CI', 4165, 34.90970000000, -94.07790000000, '105365'),
(9994, 'US-TX-105366', 'Rotan', 'CI', 4214, 32.86620000000, -100.46760000000, '105366'),
(9995, 'US-KS-105367', 'Hutchinson', 'CI', 4183, 37.95200000000, -97.97710000000, '105367'),
(9996, 'US-CA-105368', 'Mather', 'CI', 4169, 38.54960000000, -121.28260000000, '105368'),
(9997, 'US-WI-105369', 'Chippewa Falls', 'CI', 4221, 44.96170000000, -91.44030000000, '105369'),
(9998, 'US-TX-105370', 'Grand Prairie', 'CI', 4214, 32.77810000000, -96.95550000000, '105370'),
(9999, 'US-LA-105371', 'Bastrop', 'CI', 4185, 32.83230000000, -91.89680000000, '105371'),
(10000, 'US-TX-105372', 'Grapevine', 'CI', 4214, 32.92340000000, -97.08100000000, '105372'),
(10001, 'US-MS-105373', 'Starkville', 'CI', 4192, 33.42590000000, -88.83030000000, '105373'),
(10002, 'US-CA-105374', 'Sacramento', 'CI', 4169, 38.55170000000, -121.45010000000, '105374'),
(10003, 'US-TX-105375', 'Longview', 'CI', 4214, 32.45190000000, -94.64140000000, '105375'),
(10004, 'US-CO-105376', 'Rifle', 'CI', 4170, 39.70460000000, -108.03640000000, '105376'),
(10005, 'US-TX-105377', 'Lancaster', 'CI', 4214, 32.58030000000, -96.74400000000, '105377'),
(10006, 'US-MD-105378', 'Linthicum Heights', 'CI', 4188, 39.19500000000, -76.66870000000, '105378'),
(10007, 'US-CT-105379', 'Wallingford', 'CI', 4171, 41.45660000000, -72.81030000000, '105379'),
(10008, 'US-OK-105380', 'Lindsay', 'CI', 4205, 34.85360000000, -97.60290000000, '105380'),
(10009, 'US-VT-105381', 'Burlington', 'CI', 4216, 44.49290000000, -73.22530000000, '105381'),
(10010, 'US-TX-105382', 'Coppell', 'CI', 4214, 32.95880000000, -96.98120000000, '105382'),
(10011, 'US-TX-105383', 'Mount Enterprise', 'CI', 4214, 31.94470000000, -94.69820000000, '105383'),
(10012, 'US-TX-105384', 'Marshall', 'CI', 4214, 32.53520000000, -94.42530000000, '105384'),
(10013, 'US-CO-105385', 'Durango', 'CI', 4170, 37.45090000000, -107.84880000000, '105385'),
(10014, 'US-CT-105386', 'Shelton', 'CI', 4171, 41.31580000000, -73.13540000000, '105386'),
(10015, 'US-MN-105387', 'Jordan', 'CI', 4191, 44.65860000000, -93.59750000000, '105387'),
(10016, 'US-IL-105388', 'Des Plaines', 'CI', 4180, 41.99860000000, -87.90280000000, '105388'),
(10017, 'US-TX-105389', 'Hurst', 'CI', 4214, 32.81510000000, -97.17340000000, '105389'),
(10018, 'US-TX-105390', 'Lubbock', 'CI', 4214, 33.59030000000, -101.85190000000, '105390'),
(10019, 'US-TX-105391', 'Bridgeport', 'CI', 4214, 33.15190000000, -97.83990000000, '105391'),
(10020, 'US-FL-105392', 'Panama City Beach', 'CI', 4175, 30.20920000000, -85.79610000000, '105392'),
(10021, 'US-IL-105393', 'Edelstein', 'CI', 4180, 40.92280000000, -89.62060000000, '105393'),
(10022, 'US-WI-105394', 'Sinsinawa', 'CI', 4221, 42.52380000000, -90.53790000000, '105394'),
(10023, 'US-RI-105395', 'Cranston', 'CI', 4210, 41.77750000000, -71.43330000000, '105395'),
(10024, 'US-IL-105396', 'Sterling', 'CI', 4180, 41.82480000000, -89.73270000000, '105396'),
(10025, 'US-IL-105397', 'East Moline', 'CI', 4180, 41.52120000000, -90.38580000000, '105397'),
(10026, 'US-IA-105398', 'Washington', 'CI', 4182, 41.30730000000, -91.74430000000, '105398'),
(10027, 'US-IL-105399', 'Metamora', 'CI', 4180, 40.81330000000, -89.40870000000, '105399'),
(10028, 'US-IL-105400', 'Tremont', 'CI', 4180, 40.50230000000, -89.48120000000, '105400'),
(10029, 'US-TN-105401', 'Greenbrier', 'CI', 4213, 36.43260000000, -86.82570000000, '105401'),
(10030, 'US-IL-105402', 'Havana', 'CI', 4180, 40.29310000000, -90.02220000000, '105402'),
(10031, 'US-SC-105403', 'Hilton Head Island', 'CI', 4211, 32.17270000000, -80.74880000000, '105403'),
(10032, 'US-FL-105404', 'Groveland', 'CI', 4175, 28.54120000000, -81.87270000000, '105404'),
(10033, 'US-FL-105405', 'Saint Augustine', 'CI', 4175, 30.03120000000, -81.40540000000, '105405'),
(10034, 'US-MD-105406', 'Easton', 'CI', 4188, 38.79670000000, -76.04890000000, '105406'),
(10035, 'US-NV-105407', 'Carson City', 'CI', 4196, 39.14960000000, -119.71780000000, '105407'),
(10036, 'US-CA-105408', 'Stockton', 'CI', 4169, 37.90110000000, -121.39950000000, '105408'),
(10037, 'US-MN-105409', 'Duluth', 'CI', 4191, 46.84880000000, -92.20320000000, '105409'),
(10038, 'US-IL-105410', 'Ottawa', 'CI', 4180, 41.40190000000, -88.87840000000, '105410'),
(10039, 'US-IL-105411', 'Woodridge', 'CI', 4180, 41.73510000000, -88.04470000000, '105411'),
(10040, 'US-IL-105412', 'Hinsdale', 'CI', 4180, 41.80240000000, -87.93060000000, '105412'),
(10041, 'US-IL-105413', 'Sandwich', 'CI', 4180, 41.64520000000, -88.64200000000, '105413'),
(10042, 'US-IL-105414', 'Cabery', 'CI', 4180, 40.98140000000, -88.24530000000, '105414'),
(10043, 'US-IL-105415', 'Warrenville', 'CI', 4180, 41.82510000000, -88.20490000000, '105415'),
(10044, 'US-MI-105416', 'Brighton', 'CI', 4190, 42.50280000000, -83.76940000000, '105416'),
(10045, 'US-IL-105417', 'Saint Charles', 'CI', 4180, 41.94220000000, -88.39600000000, '105417'),
(10046, 'US-MN-105418', 'Osseo', 'CI', 4191, 45.12640000000, -93.45950000000, '105418'),
(10047, 'US-NY-105419', 'Mattituck', 'CI', 4200, 41.00360000000, -72.54580000000, '105419'),
(10048, 'US-MN-105420', 'Le Sueur', 'CI', 4191, 44.43540000000, -93.84500000000, '105420'),
(10049, 'US-WI-105421', 'Hayward', 'CI', 4221, 46.01430000000, -91.29010000000, '105421'),
(10050, 'US-VA-105422', 'Roanoke', 'CI', 4218, 37.21770000000, -79.92100000000, '105422'),
(10051, 'US-VA-105423', 'Danville', 'CI', 4218, 36.61840000000, -79.53720000000, '105423'),
(10052, 'US-CA-105424', 'Wilmington', 'CI', 4169, 33.77880000000, -118.26390000000, '105424'),
(10053, 'US-CA-105425', 'La Crescenta', 'CI', 4169, 34.23870000000, -118.24680000000, '105425'),
(10054, 'US-CT-105426', 'Wilton', 'CI', 4171, 41.20940000000, -73.44090000000, '105426'),
(10055, 'US-CA-105427', 'Temple City', 'CI', 4169, 34.10310000000, -118.05100000000, '105427'),
(10056, 'US-CA-105428', 'Menlo Park', 'CI', 4169, 37.45900000000, -122.17810000000, '105428'),
(10057, 'US-CA-105429', 'Maywood', 'CI', 4169, 33.98830000000, -118.18690000000, '105429'),
(10058, 'US-OH-105430', 'Dublin', 'CI', 4204, 40.11760000000, -83.12650000000, '105430'),
(10059, 'US-OR-105431', 'Bend', 'CI', 4206, 44.07440000000, -121.25740000000, '105431'),
(10060, 'US-ND-105432', 'Mandan', 'CI', 4202, 46.75820000000, -100.89750000000, '105432'),
(10061, 'US-CA-105433', 'San Mateo', 'CI', 4169, 37.55500000000, -122.26870000000, '105433'),
(10062, 'US-MN-105434', 'Elk River', 'CI', 4191, 45.33430000000, -93.56770000000, '105434'),
(10063, 'US-MN-105435', 'Belle Plaine', 'CI', 4191, 44.58340000000, -93.76750000000, '105435'),
(10065, 'US-CA-105437', 'Brisbane', 'CI', 4169, 37.68610000000, -122.41070000000, '105437'),
(10066, 'US-NC-105438', 'Jamestown', 'CI', 4201, 35.99520000000, -79.92940000000, '105438'),
(10067, 'US-CT-105439', 'North Stonington', 'CI', 4171, 41.46870000000, -71.88020000000, '105439'),
(10068, 'US-MN-105440', 'Warroad', 'CI', 4191, 48.85230000000, -95.36230000000, '105440'),
(10069, 'US-ND-105441', 'Grafton', 'CI', 4202, 48.41950000000, -97.37490000000, '105441'),
(10070, 'US-CA-105442', 'La Verne', 'CI', 4169, 34.15440000000, -117.76370000000, '105442'),
(10071, 'US-CA-105443', 'San Clemente', 'CI', 4169, 33.48020000000, -117.61410000000, '105443'),
(10072, 'US-CA-105444', 'Fountain Valley', 'CI', 4169, 33.71000000000, -117.94780000000, '105444'),
(10073, 'US-CA-105445', 'Diamond Bar', 'CI', 4169, 33.99580000000, -117.81890000000, '105445'),
(10074, 'US-CA-105446', 'Costa Mesa', 'CI', 4169, 33.67930000000, -117.90550000000, '105446'),
(10075, 'US-CA-105447', 'Azusa', 'CI', 4169, 34.17480000000, -117.87510000000, '105447'),
(10076, 'US-NE-105448', 'Albion', 'CI', 4195, 41.73850000000, -98.06830000000, '105448'),
(10077, 'US-PA-105449', 'Aliquippa', 'CI', 4208, 40.58900000000, -80.32790000000, '105449'),
(10078, 'US-MO-105450', 'Belton', 'CI', 4193, 38.78430000000, -94.54570000000, '105450'),
(10079, 'US-CA-105451', 'Orange', 'CI', 4169, 33.78850000000, -117.86950000000, '105451'),
(10080, 'US-CA-105452', 'Walnut', 'CI', 4169, 34.01150000000, -117.85350000000, '105452'),
(10081, 'US-MD-105453', 'Crofton', 'CI', 4188, 39.01420000000, -76.67940000000, '105453'),
(10082, 'US-WI-105454', 'Racine', 'CI', 4221, 42.75320000000, -87.81230000000, '105454'),
(10083, 'US-CA-105455', 'Temecula', 'CI', 4169, 33.53000000000, -117.10350000000, '105455'),
(10084, 'US-CA-105456', 'Fullerton', 'CI', 4169, 33.90190000000, -117.91080000000, '105456'),
(10085, 'US-CA-105457', 'Brea', 'CI', 4169, 33.92690000000, -117.86120000000, '105457'),
(10086, 'US-KY-105458', 'Georgetown', 'CI', 4184, 38.25320000000, -84.55240000000, '105458'),
(10087, 'US-NY-105459', 'Hamburg', 'CI', 4200, 42.70910000000, -78.83010000000, '105459'),
(10088, 'US-CA-105460', 'La Puente', 'CI', 4169, 34.03070000000, -117.95000000000, '105460'),
(10089, 'US-CT-105461', 'Fairfield', 'CI', 4171, 41.18540000000, -73.26450000000, '105461'),
(10090, 'US-NY-105462', 'East Aurora', 'CI', 4200, 42.76800000000, -78.58010000000, '105462'),
(10091, 'US-WA-105463', 'Kent', 'CI', 4219, 47.40840000000, -122.19570000000, '105463'),
(10092, 'US-CA-105464', 'Laguna Hills', 'CI', 4169, 33.60530000000, -117.71730000000, '105464'),
(10093, 'US-CA-105465', 'Aliso Viejo', 'CI', 4169, 33.57170000000, -117.72890000000, '105465'),
(10095, 'US-NJ-105467', 'Newark', 'CI', 4198, 40.72110000000, -74.14700000000, '105467'),
(10096, 'US-CA-105468', 'Yorba Linda', 'CI', 4169, 33.88790000000, -117.72860000000, '105468'),
(10097, 'US-CA-105469', 'Pomona', 'CI', 4169, 34.03900000000, -117.75480000000, '105469'),
(10098, 'US-CA-105470', 'Chico', 'CI', 4169, 39.71580000000, -121.81470000000, '105470'),
(10099, 'US-CA-105471', 'Moorpark', 'CI', 4169, 34.31060000000, -118.87870000000, '105471'),
(10100, 'US-IL-105472', 'Schaumburg', 'CI', 4180, 42.05340000000, -88.05400000000, '105472'),
(10101, 'US-IL-105473', 'Elgin', 'CI', 4180, 42.03580000000, -88.38010000000, '105473'),
(10102, 'US-IL-105474', 'Itasca', 'CI', 4180, 41.97080000000, -88.01790000000, '105474'),
(10103, 'US-GA-105475', 'Cairo', 'CI', 4176, 30.88590000000, -84.21350000000, '105475'),
(10104, 'US-IL-105476', 'Mchenry', 'CI', 4180, 42.35950000000, -88.27340000000, '105476'),
(10105, 'US-IL-105477', 'Rolling Meadows', 'CI', 4180, 42.06780000000, -88.01850000000, '105477'),
(10106, 'US-IL-105478', 'Lincolnshire', 'CI', 4180, 42.19730000000, -87.92410000000, '105478'),
(10107, 'US-IL-105479', 'Richmond', 'CI', 4180, 42.45570000000, -88.30380000000, '105479'),
(10108, 'US-PA-105480', 'State College', 'CI', 4208, 40.79750000000, -77.90210000000, '105480'),
(10109, 'US-IL-105481', 'Vernon Hills', 'CI', 4180, 42.23250000000, -87.96340000000, '105481'),
(10110, 'US-IL-105482', 'Wood Dale', 'CI', 4180, 41.96640000000, -87.98110000000, '105482'),
(10111, 'US-CO-105483', 'Greeley', 'CI', 4170, 40.39960000000, -104.80020000000, '105483'),
(10112, 'US-MA-105484', 'Mansfield', 'CI', 4189, 42.01660000000, -71.22310000000, '105484'),
(10113, 'US-IL-105485', 'Amf Ohare', 'CI', 4180, 41.97240000000, -87.89510000000, '105485'),
(10114, 'US-TX-105486', 'North Richland Hills', 'CI', 4214, 32.86590000000, -97.21760000000, '105486'),
(10115, 'US-CA-105487', 'Diamond Springs', 'CI', 4169, 38.67790000000, -120.81030000000, '105487'),
(10116, 'US-IL-105488', 'Hebron', 'CI', 4180, 42.45520000000, -88.43070000000, '105488'),
(10117, 'US-IL-105489', 'Bloomingdale', 'CI', 4180, 41.94840000000, -88.09470000000, '105489'),
(10118, 'US-IL-105490', 'Arlington Heights', 'CI', 4180, 42.11300000000, -87.98070000000, '105490'),
(10119, 'US-IL-105491', 'Wheeling', 'CI', 4180, 42.12860000000, -87.92370000000, '105491'),
(10120, 'US-TX-105492', 'Pampa', 'CI', 4214, 35.54180000000, -100.87750000000, '105492'),
(10121, 'US-IL-105493', 'Mundelein', 'CI', 4180, 42.26670000000, -88.05080000000, '105493'),
(10122, 'US-IL-105494', 'Barrington', 'CI', 4180, 42.15840000000, -88.15920000000, '105494'),
(10123, 'US-IL-105495', 'Dekalb', 'CI', 4180, 41.89630000000, -88.74420000000, '105495'),
(10124, 'US-OK-105496', 'Newcastle', 'CI', 4205, 35.23230000000, -97.60080000000, '105496'),
(10125, 'US-MD-105497', 'Rockville', 'CI', 4188, 39.08920000000, -77.18350000000, '105497'),
(10126, 'US-IL-105498', 'Bensenville', 'CI', 4180, 41.96190000000, -87.94730000000, '105498'),
(10127, 'US-IL-105499', 'Roselle', 'CI', 4180, 41.97920000000, -88.08950000000, '105499'),
(10128, 'US-NY-105500', 'Germantown', 'CI', 4200, 42.12610000000, -73.86330000000, '105500'),
(10129, 'US-NY-105501', 'Albany', 'CI', 4200, 42.65680000000, -73.74690000000, '105501'),
(10130, 'US-VT-105502', 'Shelburne', 'CI', 4216, 44.39600000000, -73.20740000000, '105502'),
(10131, 'US-VT-105503', 'South Burlington', 'CI', 4216, 44.45240000000, -73.18410000000, '105503'),
(10132, 'US-VT-105504', 'North Troy', 'CI', 4216, 44.93810000000, -72.44180000000, '105504'),
(10133, 'US-NY-105505', 'Ballston Lake', 'CI', 4200, 42.92330000000, -73.84070000000, '105505'),
(10134, 'US-NY-105506', 'Clifton Park', 'CI', 4200, 42.85710000000, -73.79930000000, '105506'),
(10135, 'US-VT-105507', 'Newport', 'CI', 4216, 44.92920000000, -72.19190000000, '105507'),
(10136, 'US-CA-105508', 'Westlake Village', 'CI', 4169, 34.14440000000, -118.89350000000, '105508'),
(10137, 'US-VT-105509', 'Jeffersonville', 'CI', 4216, 44.64070000000, -72.80720000000, '105509'),
(10138, 'US-NY-105510', 'East Greenbush', 'CI', 4200, 42.60120000000, -73.65250000000, '105510'),
(10139, 'US-MI-105511', 'Carney', 'CI', 4190, 45.58780000000, -87.48120000000, '105511'),
(10140, 'US-NY-105512', 'Cobleskill', 'CI', 4200, 42.70420000000, -74.52780000000, '105512'),
(10141, 'US-NY-105513', 'Schenectady', 'CI', 4200, 42.88220000000, -73.99160000000, '105513'),
(10142, 'US-NY-105514', 'Voorheesville', 'CI', 4200, 42.62130000000, -73.97210000000, '105514'),
(10143, 'US-NY-105515', 'Gansevoort', 'CI', 4200, 43.19520000000, -73.68460000000, '105515'),
(10144, 'US-NY-105516', 'Somers', 'CI', 4200, 41.32460000000, -73.69760000000, '105516'),
(10145, 'US-CA-105517', 'West Hollywood', 'CI', 4169, 34.09430000000, -118.38110000000, '105517'),
(10146, 'US-CA-105518', 'Chatsworth', 'CI', 4169, 34.28680000000, -118.61400000000, '105518'),
(10147, 'US-NY-105519', 'Watertown', 'CI', 4200, 43.97860000000, -75.90040000000, '105519'),
(10148, 'US-NY-105520', 'Rouses Point', 'CI', 4200, 44.98690000000, -73.37170000000, '105520'),
(10149, 'US-MO-105521', 'Independence', 'CI', 4193, 39.06150000000, -94.26570000000, '105521'),
(10150, 'US-NY-105522', 'Greenville', 'CI', 4200, 42.43100000000, -74.03830000000, '105522'),
(10151, 'US-VT-105523', 'Montpelier', 'CI', 4216, 44.27880000000, -72.61710000000, '105523'),
(10152, 'US-NY-105524', 'Cohoes', 'CI', 4200, 42.78280000000, -73.73280000000, '105524'),
(10153, 'US-NY-105525', 'Hogansburg', 'CI', 4200, 44.97590000000, -74.62030000000, '105525'),
(10154, 'US-NY-105526', 'Elizabethtown', 'CI', 4200, 44.18270000000, -73.61670000000, '105526'),
(10155, 'US-NY-105527', 'Fultonville', 'CI', 4200, 42.87340000000, -74.35870000000, '105527'),
(10156, 'US-NY-105528', 'Saratoga Springs', 'CI', 4200, 43.05350000000, -73.75170000000, '105528'),
(10157, 'US-OH-105529', 'Findlay', 'CI', 4204, 41.02210000000, -83.67890000000, '105529'),
(10158, 'US-IL-105530', 'Elizabeth', 'CI', 4180, 42.30140000000, -90.15340000000, '105530'),
(10159, 'US-NY-105531', 'Keeseville', 'CI', 4200, 44.44130000000, -73.52120000000, '105531'),
(10160, 'US-NY-105532', 'Athens', 'CI', 4200, 42.28230000000, -73.82940000000, '105532'),
(10161, 'US-VT-105533', 'Colchester', 'CI', 4216, 44.55000000000, -73.15520000000, '105533'),
(10162, 'US-VT-105534', 'Stowe', 'CI', 4216, 44.48060000000, -72.71770000000, '105534'),
(10163, 'US-VT-105535', 'Essex Junction', 'CI', 4216, 44.53270000000, -73.05800000000, '105535'),
(10164, 'US-IN-105536', 'Valparaiso', 'CI', 4181, 41.45910000000, -87.13900000000, '105536'),
(10165, 'US-IN-105537', 'Dyer', 'CI', 4181, 41.46100000000, -87.51700000000, '105537'),
(10166, 'US-IN-105538', 'Merrillville', 'CI', 4181, 41.47930000000, -87.31640000000, '105538'),
(10167, 'US-IL-105539', 'Manteno', 'CI', 4180, 41.25410000000, -87.89120000000, '105539'),
(10168, 'US-IL-105540', 'Saint Anne', 'CI', 4180, 41.04120000000, -87.68820000000, '105540'),
(10169, 'US-IL-105541', 'Harvey', 'CI', 4180, 41.60880000000, -87.67390000000, '105541'),
(10170, 'US-IL-105542', 'Sheldon', 'CI', 4180, 40.75170000000, -87.58960000000, '105542'),
(10171, 'US-IL-105543', 'Blue Island', 'CI', 4180, 41.66460000000, -87.68730000000, '105543'),
(10172, 'US-MI-105544', 'New Buffalo', 'CI', 4190, 41.79390000000, -86.74050000000, '105544'),
(10173, 'US-IL-105545', 'Chicago Heights', 'CI', 4180, 41.51380000000, -87.59970000000, '105545'),
(10174, 'US-IL-105546', 'Kankakee', 'CI', 4180, 41.11900000000, -87.92590000000, '105546'),
(10175, 'US-MD-105547', 'Gaithersburg', 'CI', 4188, 39.11480000000, -77.24620000000, '105547'),
(10176, 'US-CA-105548', 'North Hollywood', 'CI', 4169, 34.16830000000, -118.37300000000, '105548'),
(10177, 'US-NC-105549', 'Hillsborough', 'CI', 4201, 36.07550000000, -79.07410000000, '105549'),
(10178, 'US-NC-105550', 'Dunn', 'CI', 4201, 35.27630000000, -78.54680000000, '105550'),
(10179, 'US-OK-105551', 'Sulphur', 'CI', 4205, 34.48470000000, -96.95860000000, '105551'),
(10180, 'US-CA-105552', 'Novato', 'CI', 4169, 38.13480000000, -122.56100000000, '105552'),
(10181, 'US-NC-105553', 'Angier', 'CI', 4201, 35.48320000000, -78.67980000000, '105553'),
(10182, 'US-NC-105554', 'Warsaw', 'CI', 4201, 34.98600000000, -78.05240000000, '105554'),
(10183, 'US-TX-105555', 'Gainesville', 'CI', 4214, 33.70090000000, -97.16290000000, '105555'),
(10184, 'US-FL-105556', 'Riverview', 'CI', 4175, 27.82230000000, -82.27970000000, '105556'),
(10185, 'US-NC-105557', 'Kill Devil Hills', 'CI', 4201, 36.02000000000, -75.66990000000, '105557'),
(10186, 'US-NJ-105558', 'Bedminster', 'CI', 4198, 40.65600000000, -74.67740000000, '105558'),
(10187, 'US-OK-105559', 'Duncan', 'CI', 4205, 34.49260000000, -97.85230000000, '105559'),
(10188, 'US-OK-105560', 'Fort Cobb', 'CI', 4205, 35.12360000000, -98.42490000000, '105560'),
(10189, 'US-NC-105561', 'Southport', 'CI', 4201, 33.99700000000, -78.07290000000, '105561'),
(10190, 'US-NC-105562', 'Pittsboro', 'CI', 4201, 35.75190000000, -79.22480000000, '105562'),
(10191, 'US-ID-105563', 'Lewiston', 'CI', 4179, 46.16830000000, -116.92040000000, '105563'),
(10192, 'US-CA-105564', 'Anderson', 'CI', 4169, 40.44580000000, -122.35480000000, '105564'),
(10193, 'US-GA-105565', 'Hiawassee', 'CI', 4176, 34.89150000000, -83.68610000000, '105565'),
(10194, 'US-CA-105566', 'Bishop', 'CI', 4169, 37.50600000000, -118.31140000000, '105566'),
(10195, 'US-CA-105567', 'West Sacramento', 'CI', 4169, 38.66670000000, -121.62930000000, '105567'),
(10196, 'US-CA-105568', 'Agoura Hills', 'CI', 4169, 34.12670000000, -118.76480000000, '105568'),
(10197, 'US-TX-105569', 'Garland', 'CI', 4214, 32.87560000000, -96.64820000000, '105569'),
(10198, 'US-GA-105570', 'Stockbridge', 'CI', 4176, 33.55470000000, -84.18720000000, '105570'),
(10199, 'US-AL-105571', 'Dothan', 'CI', 4161, 31.15030000000, -85.41140000000, '105571'),
(10200, 'US-CA-105572', 'Placerville', 'CI', 4169, 38.73650000000, -120.80430000000, '105572'),
(10201, 'US-NC-105573', 'Wilson', 'CI', 4201, 35.68000000000, -77.91260000000, '105573'),
(10202, 'US-NC-105574', 'Clinton', 'CI', 4201, 34.98610000000, -78.34340000000, '105574'),
(10203, 'US-MI-105575', 'Williamston', 'CI', 4190, 42.68160000000, -84.27170000000, '105575'),
(10204, 'US-KY-105576', 'Covington', 'CI', 4184, 39.06570000000, -84.52900000000, '105576'),
(10205, 'US-KY-105577', 'Glasgow', 'CI', 4184, 36.93760000000, -85.94630000000, '105577'),
(10206, 'US-NC-105578', 'Asheville', 'CI', 4201, 35.56830000000, -82.62720000000, '105578'),
(10207, 'US-OH-105579', 'Oxford', 'CI', 4204, 39.47920000000, -84.71300000000, '105579'),
(10208, 'US-TN-105580', 'Antioch', 'CI', 4213, 36.03710000000, -86.63720000000, '105580'),
(10209, 'US-TN-105581', 'Livingston', 'CI', 4213, 36.38680000000, -85.30830000000, '105581'),
(10210, 'US-FL-105582', 'Palm Beach Gardens', 'CI', 4175, 26.84570000000, -80.09020000000, '105582'),
(10211, 'US-TN-105583', 'Deer Lodge', 'CI', 4213, 36.20960000000, -84.83650000000, '105583'),
(10212, 'US-TN-105584', 'White House', 'CI', 4213, 36.48170000000, -86.67560000000, '105584'),
(10213, 'US-NV-105585', 'Reno', 'CI', 4196, 39.48960000000, -119.74920000000, '105585'),
(10214, 'US-TN-105586', 'Mount Pleasant', 'CI', 4213, 35.51280000000, -87.21790000000, '105586'),
(10215, 'US-KY-105587', 'Mayfield', 'CI', 4184, 36.73640000000, -88.63880000000, '105587'),
(10216, 'US-TN-105588', 'Columbia', 'CI', 4213, 35.64890000000, -86.99580000000, '105588'),
(10217, 'US-CA-105589', 'Ukiah', 'CI', 4169, 39.12660000000, -123.28050000000, '105589'),
(10218, 'US-GA-105590', 'Fort Valley', 'CI', 4176, 32.57240000000, -83.89210000000, '105590'),
(10219, 'US-KY-105591', 'Madisonville', 'CI', 4184, 37.32680000000, -87.46960000000, '105591'),
(10220, 'US-TN-105592', 'La Vergne', 'CI', 4213, 36.02120000000, -86.55950000000, '105592'),
(10221, 'US-TN-105593', 'Smyrna', 'CI', 4213, 35.95930000000, -86.54200000000, '105593'),
(10222, 'US-KY-105594', 'Bardwell', 'CI', 4184, 36.86690000000, -88.98820000000, '105594'),
(10223, 'US-PA-105595', 'Harrisburg', 'CI', 4208, 40.27620000000, -76.78890000000, '105595'),
(10224, 'US-TN-105596', 'Cookeville', 'CI', 4213, 36.19200000000, -85.45590000000, '105596'),
(10225, 'US-KY-105597', 'Cave City', 'CI', 4184, 37.12430000000, -85.91000000000, '105597'),
(10226, 'US-MI-105598', 'Richmond', 'CI', 4190, 42.84460000000, -82.80000000000, '105598'),
(10227, 'US-KY-105599', 'Paducah', 'CI', 4184, 37.03830000000, -88.71570000000, '105599'),
(10228, 'US-TN-105600', 'Mount Juliet', 'CI', 4213, 36.17180000000, -86.49040000000, '105600'),
(10229, 'US-TN-105601', 'Tullahoma', 'CI', 4213, 35.35120000000, -86.18380000000, '105601'),
(10230, 'US-OH-105602', 'Marysville', 'CI', 4204, 40.25400000000, -83.36850000000, '105602'),
(10231, 'US-TN-105603', 'Goodlettsville', 'CI', 4213, 36.35450000000, -86.76280000000, '105603'),
(10232, 'US-TN-105604', 'Madison', 'CI', 4213, 36.25580000000, -86.69910000000, '105604'),
(10233, 'US-TN-105605', 'Lafayette', 'CI', 4213, 36.52780000000, -86.00580000000, '105605'),
(10234, 'US-KY-105606', 'Oak Grove', 'CI', 4184, 36.69770000000, -87.45270000000, '105606'),
(10235, 'US-KY-105607', 'Morgantown', 'CI', 4184, 37.16700000000, -86.74970000000, '105607'),
(10236, 'US-TN-105608', 'Crossville', 'CI', 4213, 35.87130000000, -84.98350000000, '105608'),
(10237, 'US-MI-105609', 'Harper Woods', 'CI', 4190, 42.43600000000, -82.93170000000, '105609'),
(10238, 'US-CA-105610', 'Avila Beach', 'CI', 4169, 35.18370000000, -120.72560000000, '105610'),
(10239, 'US-TN-105611', 'Martin', 'CI', 4213, 36.38380000000, -88.83190000000, '105611'),
(10240, 'US-SC-105612', 'Greer', 'CI', 4211, 34.94050000000, -82.16720000000, '105612'),
(10241, 'US-SC-105613', 'Spartanburg', 'CI', 4211, 34.99420000000, -81.98250000000, '105613'),
(10242, 'US-NC-105614', 'Huntersville', 'CI', 4201, 35.40340000000, -80.86110000000, '105614'),
(10243, 'US-NJ-105615', 'Clinton', 'CI', 4198, 40.65290000000, -74.92630000000, '105615'),
(10244, 'US-NC-105616', 'Lumberton', 'CI', 4201, 34.60080000000, -78.96730000000, '105616'),
(10245, 'US-NC-105617', 'Forest City', 'CI', 4201, 35.31480000000, -81.86680000000, '105617'),
(10246, 'US-NC-105618', 'Lenoir', 'CI', 4201, 35.97260000000, -81.55130000000, '105618'),
(10247, 'US-SC-105619', 'Lancaster', 'CI', 4211, 34.76010000000, -80.69300000000, '105619'),
(10248, 'US-NY-105620', 'West Nyack', 'CI', 4200, 41.09740000000, -73.97010000000, '105620'),
(10249, 'US-SC-105621', 'Piedmont', 'CI', 4211, 34.72660000000, -82.45980000000, '105621'),
(10250, 'US-NC-105622', 'Statesville', 'CI', 4201, 35.72500000000, -80.90690000000, '105622'),
(10251, 'US-NC-105623', 'Morganton', 'CI', 4201, 35.76120000000, -81.72800000000, '105623'),
(10252, 'US-NC-105624', 'Hendersonville', 'CI', 4201, 35.39020000000, -82.37250000000, '105624'),
(10253, 'US-NC-105625', 'Kings Mountain', 'CI', 4201, 35.25580000000, -81.37070000000, '105625'),
(10254, 'US-NC-105626', 'Mount Holly', 'CI', 4201, 35.32350000000, -81.02150000000, '105626'),
(10255, 'US-NC-105627', 'Mooresville', 'CI', 4201, 35.58900000000, -80.76800000000, '105627'),
(10256, 'US-NC-105628', 'Arden', 'CI', 4201, 35.45890000000, -82.60350000000, '105628'),
(10257, 'US-NC-105629', 'Conover', 'CI', 4201, 35.74270000000, -81.20930000000, '105629'),
(10258, 'US-NC-105630', 'Laurinburg', 'CI', 4201, 34.76780000000, -79.46390000000, '105630'),
(10259, 'US-NC-105631', 'Pineville', 'CI', 4201, 35.07760000000, -80.89070000000, '105631'),
(10260, 'US-TN-105632', 'Kingsport', 'CI', 4213, 36.46010000000, -82.50120000000, '105632'),
(10261, 'US-CT-105633', 'Cheshire', 'CI', 4171, 41.50590000000, -72.90810000000, '105633'),
(10262, 'US-TN-105634', 'Johnson City', 'CI', 4213, 36.38910000000, -82.45110000000, '105634'),
(10263, 'US-NY-105635', 'Sterling Forest', 'CI', 4200, 41.18230000000, -74.31570000000, '105635'),
(10264, 'US-SC-105636', 'Taylors', 'CI', 4211, 34.99650000000, -82.32870000000, '105636'),
(10265, 'US-SC-105637', 'Wellford', 'CI', 4211, 34.97390000000, -82.10120000000, '105637'),
(10266, 'US-WV-105638', 'Berkeley Springs', 'CI', 4220, 39.54360000000, -78.21400000000, '105638'),
(10267, 'US-NJ-105639', 'Trenton', 'CI', 4198, 40.26480000000, -74.82430000000, '105639'),
(10268, 'US-CT-105640', 'Stamford', 'CI', 4171, 41.05110000000, -73.54050000000, '105640'),
(10269, 'US-NJ-105641', 'Mount Holly', 'CI', 4198, 39.99430000000, -74.79180000000, '105641'),
(10270, 'US-NJ-105642', 'Skillman', 'CI', 4198, 40.41120000000, -74.69190000000, '105642'),
(10271, 'US-NJ-105643', 'Cranbury', 'CI', 4198, 40.31790000000, -74.53410000000, '105643'),
(10272, 'US-NJ-105644', 'Stockton', 'CI', 4198, 40.43260000000, -74.97180000000, '105644'),
(10273, 'US-NJ-105645', 'Lumberton', 'CI', 4198, 39.97170000000, -74.80960000000, '105645'),
(10274, 'US-NJ-105646', 'Monroe Township', 'CI', 4198, 40.33050000000, -74.41790000000, '105646'),
(10275, 'US-NJ-105647', 'Plainsboro', 'CI', 4198, 40.32890000000, -74.58570000000, '105647'),
(10276, 'US-NV-105648', 'North Las Vegas', 'CI', 4196, 36.21870000000, -115.12930000000, '105648'),
(10277, 'US-LA-105649', 'Mandeville', 'CI', 4185, 30.41840000000, -90.00690000000, '105649'),
(10278, 'US-CA-105650', 'Oxnard', 'CI', 4169, 34.19800000000, -119.17260000000, '105650'),
(10279, 'US-VA-105651', 'Marion', 'CI', 4218, 36.82430000000, -81.56810000000, '105651'),
(10280, 'US-NY-105652', 'Syosset', 'CI', 4200, 40.82940000000, -73.50520000000, '105652'),
(10281, 'US-NC-105653', 'Kinston', 'CI', 4201, 35.23750000000, -77.61510000000, '105653'),
(10282, 'US-NJ-105654', 'Rancocas', 'CI', 4198, 40.00980000000, -74.87000000000, '105654'),
(10283, 'US-NJ-105655', 'Princeton Junction', 'CI', 4198, 40.28300000000, -74.62170000000, '105655'),
(10284, 'US-NJ-105656', 'Monmouth Junction', 'CI', 4198, 40.39290000000, -74.54120000000, '105656'),
(10285, 'US-NJ-105657', 'Burlington', 'CI', 4198, 40.07070000000, -74.83320000000, '105657'),
(10286, 'US-NJ-105658', 'Hightstown', 'CI', 4198, 40.24850000000, -74.53150000000, '105658'),
(10287, 'US-NJ-105659', 'Hainesport', 'CI', 4198, 39.97100000000, -74.84730000000, '105659'),
(10288, 'US-NJ-105660', 'Dayton', 'CI', 4198, 40.37230000000, -74.49620000000, '105660'),
(10289, 'US-MI-105661', 'Jackson', 'CI', 4190, 42.27490000000, -84.40170000000, '105661'),
(10290, 'US-CA-105662', 'Edwards', 'CI', 4169, 35.29440000000, -118.90520000000, '105662'),
(10291, 'US-OH-105663', 'Fairfield', 'CI', 4204, 39.33670000000, -84.54960000000, '105663'),
(10292, 'US-TX-105664', 'Marble Falls', 'CI', 4214, 30.56320000000, -98.11120000000, '105664'),
(10293, 'US-SC-105665', 'Fountain Inn', 'CI', 4211, 34.67340000000, -82.19980000000, '105665'),
(10294, 'US-CA-105666', 'Hayward', 'CI', 4169, 37.63930000000, -122.04420000000, '105666'),
(10295, 'US-IL-105667', 'Schiller Park', 'CI', 4180, 41.96370000000, -87.88410000000, '105667'),
(10296, 'US-CA-105668', 'Concord', 'CI', 4169, 38.00330000000, -122.03180000000, '105668'),
(10297, 'US-OK-105669', 'Stringtown', 'CI', 4205, 34.46240000000, -95.90260000000, '105669'),
(10298, 'US-OR-105670', 'Sisters', 'CI', 4206, 44.41020000000, -121.92830000000, '105670'),
(10299, 'US-NJ-105671', 'Cherry Hill', 'CI', 4198, 39.90680000000, -74.99660000000, '105671'),
(10300, 'US-NJ-105672', 'Egg Harbor Township', 'CI', 4198, 39.38700000000, -74.62170000000, '105672'),
(10301, 'US-MI-105673', 'Monroe', 'CI', 4190, 41.95050000000, -83.44570000000, '105673'),
(10302, 'US-OK-105674', 'Broken Bow', 'CI', 4205, 34.17440000000, -94.72620000000, '105674'),
(10303, 'US-NJ-105675', 'Paulsboro', 'CI', 4198, 39.83530000000, -75.19540000000, '105675'),
(10304, 'US-NJ-105676', 'Cologne', 'CI', 4198, 39.49920000000, -74.60820000000, '105676'),
(10305, 'US-NJ-105677', 'Hammonton', 'CI', 4198, 39.63630000000, -74.76330000000, '105677'),
(10306, 'US-NJ-105678', 'Tuckerton', 'CI', 4198, 39.59960000000, -74.36870000000, '105678'),
(10307, 'US-OR-105679', 'Roseburg', 'CI', 4206, 43.21790000000, -123.40210000000, '105679'),
(10308, 'US-NJ-105680', 'Absecon', 'CI', 4198, 39.42090000000, -74.49770000000, '105680'),
(10309, 'US-CA-105681', 'San Rafael', 'CI', 4169, 37.97190000000, -122.50230000000, '105681'),
(10310, 'US-PA-105682', 'Altoona', 'CI', 4208, 40.51720000000, -78.36620000000, '105682'),
(10311, 'US-PA-105683', 'Chambersburg', 'CI', 4208, 39.93200000000, -77.70690000000, '105683'),
(10312, 'US-PA-105684', 'Du Bois', 'CI', 4208, 41.11720000000, -78.68610000000, '105684'),
(10313, 'US-PA-105685', 'Bellefonte', 'CI', 4208, 40.93540000000, -77.78310000000, '105685'),
(10314, 'US-MI-105686', 'Manchester', 'CI', 4190, 42.16160000000, -84.02380000000, '105686'),
(10315, 'US-PA-105687', 'Hummelstown', 'CI', 4208, 40.30840000000, -76.69540000000, '105687'),
(10316, 'US-PA-105688', 'Bird In Hand', 'CI', 4208, 40.05060000000, -76.17030000000, '105688'),
(10317, 'US-PA-105689', 'Clearfield', 'CI', 4208, 41.05590000000, -78.41290000000, '105689'),
(10318, 'US-PA-105690', 'York', 'CI', 4208, 40.00200000000, -76.68360000000, '105690'),
(10319, 'US-PA-105691', 'Gratz', 'CI', 4208, 40.60900000000, -76.72730000000, '105691'),
(10320, 'US-PA-105692', 'Mercersburg', 'CI', 4208, 39.82940000000, -77.97850000000, '105692'),
(10321, 'US-PA-105693', 'Mechanicsburg', 'CI', 4208, 40.18140000000, -76.99690000000, '105693'),
(10322, 'US-OH-105694', 'Medina', 'CI', 4204, 41.13430000000, -81.85590000000, '105694'),
(10323, 'US-OH-105695', 'Wadsworth', 'CI', 4204, 41.06210000000, -81.74510000000, '105695'),
(10324, 'US-OR-105696', 'Medford', 'CI', 4206, 42.33930000000, -122.79870000000, '105696'),
(10325, 'US-MD-105697', 'Halethorpe', 'CI', 4188, 39.24340000000, -76.68030000000, '105697'),
(10326, 'US-PA-105698', 'New Castle', 'CI', 4208, 40.97080000000, -80.30100000000, '105698'),
(10327, 'US-MD-105699', 'Oakland', 'CI', 4188, 39.37950000000, -79.35960000000, '105699'),
(10328, 'US-PA-105700', 'Bridgeville', 'CI', 4208, 40.34560000000, -80.13420000000, '105700'),
(10329, 'US-PA-105701', 'Perryopolis', 'CI', 4208, 40.07020000000, -79.74710000000, '105701'),
(10330, 'US-PA-105702', 'Mc Kees Rocks', 'CI', 4208, 40.46730000000, -80.10270000000, '105702'),
(10331, 'US-OH-105703', 'Derwent', 'CI', 4204, 39.93010000000, -81.49980000000, '105703'),
(10332, 'US-PA-105704', 'Friedens', 'CI', 4208, 40.06660000000, -78.96670000000, '105704'),
(10333, 'US-PA-105705', 'New Galilee', 'CI', 4208, 40.87200000000, -80.39410000000, '105705'),
(10334, 'US-PA-105706', 'Mercer', 'CI', 4208, 41.22250000000, -80.25210000000, '105706'),
(10335, 'US-TX-105707', 'Baytown', 'CI', 4214, 29.77090000000, -94.90710000000, '105707'),
(10336, 'US-PA-105708', 'Bedford', 'CI', 4208, 39.94110000000, -78.56780000000, '105708'),
(10337, 'US-FL-105709', 'Panama City', 'CI', 4175, 30.15210000000, -85.72670000000, '105709'),
(10338, 'US-PA-105710', 'Monroeville', 'CI', 4208, 40.42350000000, -79.75880000000, '105710'),
(10339, 'US-PA-105711', 'Portage', 'CI', 4208, 40.36310000000, -78.64480000000, '105711'),
(10340, 'US-MI-105712', 'Ann Arbor', 'CI', 4190, 42.27340000000, -83.71330000000, '105712'),
(10341, 'US-WV-105713', 'Morgantown', 'CI', 4220, 39.64560000000, -79.94330000000, '105713'),
(10342, 'US-MD-105714', 'Friendsville', 'CI', 4188, 39.63680000000, -79.40680000000, '105714'),
(10343, 'US-PA-105715', 'Eighty Four', 'CI', 4208, 40.17560000000, -80.10550000000, '105715'),
(10344, 'US-WV-105716', 'Davis', 'CI', 4220, 39.05980000000, -79.40050000000, '105716'),
(10345, 'US-PA-105717', 'Braddock', 'CI', 4208, 40.40310000000, -79.86380000000, '105717'),
(10346, 'US-MO-105718', 'Maryville', 'CI', 4193, 40.33160000000, -94.87590000000, '105718'),
(10347, 'US-MO-105719', 'Freeman', 'CI', 4193, 38.61210000000, -94.48760000000, '105719'),
(10348, 'US-MO-105720', 'Blue Springs', 'CI', 4193, 39.00500000000, -94.24990000000, '105720'),
(10349, 'US-KS-105721', 'Leawood', 'CI', 4183, 38.95860000000, -94.62020000000, '105721'),
(10350, 'US-OR-105722', 'Shady Cove', 'CI', 4206, 42.61960000000, -122.79980000000, '105722'),
(10351, 'US-OR-105723', 'Salem', 'CI', 4206, 44.90160000000, -122.92230000000, '105723'),
(10352, 'US-KS-105724', 'Topeka', 'CI', 4183, 39.03800000000, -95.72780000000, '105724'),
(10353, 'US-MO-105725', 'Raymore', 'CI', 4193, 38.79700000000, -94.44920000000, '105725'),
(10354, 'US-MO-105726', 'Kearney', 'CI', 4193, 39.37530000000, -94.35700000000, '105726'),
(10355, 'US-MO-105727', 'Bethany', 'CI', 4193, 40.26560000000, -94.01210000000, '105727'),
(10356, 'US-MO-105728', 'Hollister', 'CI', 4193, 36.56910000000, -93.22480000000, '105728'),
(10357, 'US-KS-105729', 'Shawnee', 'CI', 4183, 39.01470000000, -94.73950000000, '105729'),
(10358, 'US-MO-105730', 'Higginsville', 'CI', 4193, 39.03980000000, -93.73670000000, '105730'),
(10359, 'US-KS-105731', 'Lawrence', 'CI', 4183, 38.89160000000, -95.34180000000, '105731'),
(10360, 'US-MO-105732', 'Clinton', 'CI', 4193, 38.38590000000, -93.74310000000, '105732'),
(10361, 'US-CA-105733', 'North Highlands', 'CI', 4169, 38.66810000000, -121.37360000000, '105733'),
(10362, 'US-KS-105734', 'Powhattan', 'CI', 4183, 39.73270000000, -95.67600000000, '105734'),
(10363, 'US-MO-105735', 'Stanberry', 'CI', 4193, 40.22740000000, -94.55580000000, '105735'),
(10364, 'US-MO-105736', 'Saint Joseph', 'CI', 4193, 39.68170000000, -94.90360000000, '105736'),
(10365, 'US-KS-105737', 'Emporia', 'CI', 4183, 38.42700000000, -96.21030000000, '105737'),
(10366, 'US-MO-105738', 'Lees Summit', 'CI', 4193, 38.90410000000, -94.39800000000, '105738'),
(10367, 'US-KS-105739', 'Salina', 'CI', 4183, 38.85220000000, -97.61420000000, '105739'),
(10368, 'US-MO-105740', 'Chillicothe', 'CI', 4193, 39.86040000000, -93.67510000000, '105740'),
(10369, 'US-OR-105741', 'Sheridan', 'CI', 4206, 45.10160000000, -123.41970000000, '105741'),
(10370, 'US-KS-105742', 'Leavenworth', 'CI', 4183, 39.29560000000, -94.98030000000, '105742'),
(10371, 'US-MO-105743', 'Monett', 'CI', 4193, 36.92510000000, -93.91970000000, '105743'),
(10372, 'US-WI-105744', 'Osceola', 'CI', 4221, 45.27700000000, -92.63060000000, '105744'),
(10373, 'US-OK-105745', 'Broken Arrow', 'CI', 4205, 36.02710000000, -95.55760000000, '105745'),
(10374, 'US-IL-105746', 'Orland Park', 'CI', 4180, 41.61630000000, -87.83710000000, '105746'),
(10375, 'US-CT-105747', 'Westbrook', 'CI', 4171, 41.30830000000, -72.46530000000, '105747'),
(10376, 'US-MO-105748', 'Harrisonville', 'CI', 4193, 38.60890000000, -94.30930000000, '105748'),
(10377, 'US-IN-105749', 'New Salisbury', 'CI', 4181, 38.32200000000, -86.10210000000, '105749'),
(10378, 'US-SC-105750', 'Myrtle Beach', 'CI', 4211, 33.75270000000, -78.90710000000, '105750'),
(10379, 'US-NJ-105751', 'Liberty Corner', 'CI', 4198, 40.66060000000, -74.58660000000, '105751'),
(10380, 'US-MO-105752', 'Boonville', 'CI', 4193, 38.90290000000, -92.70710000000, '105752'),
(10381, 'US-CA-105753', 'Burlingame', 'CI', 4169, 37.56710000000, -122.37100000000, '105753'),
(10382, 'US-CA-105754', 'Fremont', 'CI', 4169, 37.50790000000, -121.95990000000, '105754'),
(10383, 'US-CA-105755', 'Dublin', 'CI', 4169, 37.71860000000, -121.91640000000, '105755'),
(10384, 'US-TX-105756', 'Cameron', 'CI', 4214, 30.84700000000, -96.89720000000, '105756'),
(10385, 'US-CA-105757', 'Palo Alto', 'CI', 4169, 37.41350000000, -122.13120000000, '105757'),
(10386, 'US-PA-105758', 'Warrington', 'CI', 4208, 40.24890000000, -75.14980000000, '105758'),
(10387, 'US-CA-105759', 'Newark', 'CI', 4169, 37.51470000000, -122.04230000000, '105759'),
(10388, 'US-TX-105760', 'Temple', 'CI', 4214, 31.10640000000, -97.40710000000, '105760'),
(10389, 'US-CA-105761', 'Redwood City', 'CI', 4169, 37.49140000000, -122.21100000000, '105761'),
(10390, 'US-CA-105762', 'Pleasanton', 'CI', 4169, 37.67040000000, -121.93740000000, '105762'),
(10391, 'US-IN-105763', 'Shelbyville', 'CI', 4181, 39.52390000000, -85.78530000000, '105763'),
(10392, 'US-WI-105764', 'De Pere', 'CI', 4221, 44.39060000000, -88.03100000000, '105764'),
(10393, 'US-WI-105765', 'Baileys Harbor', 'CI', 4221, 45.08550000000, -87.14130000000, '105765'),
(10394, 'US-CO-105766', 'Littleton', 'CI', 4170, 39.54870000000, -105.17450000000, '105766'),
(10395, 'US-CT-105767', 'New Haven', 'CI', 4171, 41.30940000000, -72.92400000000, '105767'),
(10396, 'US-CA-105768', 'San Carlos', 'CI', 4169, 37.49800000000, -122.26720000000, '105768'),
(10397, 'US-CA-105769', 'Los Altos', 'CI', 4169, 37.36220000000, -122.14000000000, '105769'),
(10398, 'US-CT-105770', 'North Haven', 'CI', 4171, 41.38340000000, -72.86260000000, '105770'),
(10399, 'US-CA-105771', 'Millbrae', 'CI', 4169, 37.59810000000, -122.40250000000, '105771'),
(10400, 'US-OR-105772', 'Chiloquin', 'CI', 4206, 42.72670000000, -121.79640000000, '105772'),
(10401, 'US-CA-105773', 'Union City', 'CI', 4169, 37.59630000000, -122.06570000000, '105773'),
(10402, 'US-MO-105774', 'Allendale', 'CI', 4193, 40.48320000000, -94.28820000000, '105774'),
(10403, 'US-NY-105775', 'Oneonta', 'CI', 4200, 42.48670000000, -75.03970000000, '105775'),
(10404, 'US-OR-105776', 'Eugene', 'CI', 4206, 44.06900000000, -123.08250000000, '105776'),
(10405, 'US-OR-105777', 'Grants Pass', 'CI', 4206, 42.53860000000, -123.34780000000, '105777'),
(10406, 'US-IN-105778', 'Connersville', 'CI', 4181, 39.65390000000, -85.15180000000, '105778'),
(10407, 'US-OR-105779', 'Lebanon', 'CI', 4206, 44.52530000000, -122.81780000000, '105779'),
(10408, 'US-CA-105780', 'Nicolaus', 'CI', 4169, 38.83300000000, -121.58860000000, '105780'),
(10409, 'US-VA-105781', 'Ashland', 'CI', 4218, 37.75630000000, -77.48880000000, '105781'),
(10410, 'US-IA-105782', 'Sergeant Bluff', 'CI', 4182, 42.37280000000, -96.27700000000, '105782'),
(10411, 'US-KY-105783', 'Paris', 'CI', 4184, 38.21330000000, -84.22560000000, '105783'),
(10412, 'US-IL-105784', 'Wilmette', 'CI', 4180, 42.07720000000, -87.72860000000, '105784'),
(10413, 'US-IA-105785', 'Sioux City', 'CI', 4182, 42.46320000000, -96.32200000000, '105785'),
(10414, 'US-IA-105786', 'Council Bluffs', 'CI', 4182, 41.23240000000, -95.87620000000, '105786'),
(10415, 'US-MS-105787', 'Southaven', 'CI', 4192, 34.94890000000, -89.96650000000, '105787'),
(10416, 'US-CO-105788', 'Louisville', 'CI', 4170, 39.95580000000, -105.16830000000, '105788'),
(10417, 'US-MD-105789', 'Windsor Mill', 'CI', 4188, 39.33540000000, -76.78880000000, '105789'),
(10418, 'US-IN-105790', 'Kendallville', 'CI', 4181, 41.44640000000, -85.27370000000, '105790'),
(10419, 'US-NE-105791', 'Wahoo', 'CI', 4195, 41.18360000000, -96.61950000000, '105791'),
(10420, 'US-NE-105792', 'Blair', 'CI', 4195, 41.53800000000, -96.19440000000, '105792'),
(10421, 'US-IA-105793', 'Spencer', 'CI', 4182, 43.14740000000, -95.14250000000, '105793'),
(10422, 'US-NJ-105794', 'Little Falls', 'CI', 4198, 40.88340000000, -74.21430000000, '105794'),
(10423, 'US-WI-105795', 'Hartland', 'CI', 4221, 43.13110000000, -88.33590000000, '105795'),
(10424, 'US-IA-105796', 'Denison', 'CI', 4182, 42.02300000000, -95.36340000000, '105796'),
(10425, 'US-OR-105797', 'Newport', 'CI', 4206, 44.66750000000, -124.01550000000, '105797'),
(10426, 'US-OR-105798', 'Klamath Falls', 'CI', 4206, 42.18510000000, -121.61410000000, '105798'),
(10427, 'US-IN-105799', 'Linton', 'CI', 4181, 39.03960000000, -87.15650000000, '105799'),
(10428, 'US-AZ-105800', 'Mohave Valley', 'CI', 4164, 34.86150000000, -114.51930000000, '105800'),
(10429, 'US-WI-105801', 'Mayville', 'CI', 4221, 43.49430000000, -88.54730000000, '105801'),
(10430, 'US-OR-105802', 'Tangent', 'CI', 4206, 44.54080000000, -123.08510000000, '105802'),
(10431, 'US-NE-105803', 'Hooper', 'CI', 4195, 41.64050000000, -96.50210000000, '105803'),
(10432, 'US-NE-105804', 'Wisner', 'CI', 4195, 41.98490000000, -96.89390000000, '105804'),
(10433, 'US-GA-105805', 'Tucker', 'CI', 4176, 33.85600000000, -84.21290000000, '105805'),
(10434, 'US-GA-105806', 'Washington', 'CI', 4176, 33.73190000000, -82.70830000000, '105806'),
(10435, 'US-GA-105807', 'Hartwell', 'CI', 4176, 34.32240000000, -82.88640000000, '105807');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(10436, 'US-AL-105808', 'Demopolis', 'CI', 4161, 32.41500000000, -87.91510000000, '105808'),
(10437, 'US-AL-105809', 'Vernon', 'CI', 4161, 33.74140000000, -88.10010000000, '105809'),
(10438, 'US-AL-105810', 'Andalusia', 'CI', 4161, 31.24870000000, -86.58970000000, '105810'),
(10439, 'US-MS-105811', 'Philadelphia', 'CI', 4192, 32.80560000000, -89.10730000000, '105811'),
(10440, 'US-AL-105812', 'Bessemer', 'CI', 4161, 33.40230000000, -86.93900000000, '105812'),
(10441, 'US-MS-105813', 'Meridian', 'CI', 4192, 32.28830000000, -88.58800000000, '105813'),
(10442, 'US-AL-105814', 'Pelham', 'CI', 4161, 33.31510000000, -86.75600000000, '105814'),
(10443, 'US-AL-105815', 'Elba', 'CI', 4161, 31.42090000000, -86.06090000000, '105815'),
(10444, 'US-AL-105816', 'Union Springs', 'CI', 4161, 32.16560000000, -85.67080000000, '105816'),
(10445, 'US-AL-105817', 'Decatur', 'CI', 4161, 34.60650000000, -87.00780000000, '105817'),
(10446, 'US-OR-105818', 'Corvallis', 'CI', 4206, 44.46980000000, -123.34300000000, '105818'),
(10447, 'US-GA-105819', 'Monroe', 'CI', 4176, 33.78480000000, -83.67310000000, '105819'),
(10448, 'US-IL-105820', 'East Peoria', 'CI', 4180, 40.72250000000, -89.53030000000, '105820'),
(10449, 'US-TX-105821', 'Livingston', 'CI', 4214, 30.72470000000, -94.82300000000, '105821'),
(10450, 'US-GA-105822', 'Conley', 'CI', 4176, 33.65200000000, -84.32010000000, '105822'),
(10451, 'US-MT-105823', 'Big Sky', 'CI', 4194, 45.26500000000, -111.25310000000, '105823'),
(10452, 'US-TN-105824', 'Dandridge', 'CI', 4213, 36.02910000000, -83.45470000000, '105824'),
(10453, 'US-CT-105825', 'Rocky Hill', 'CI', 4171, 41.65770000000, -72.66270000000, '105825'),
(10454, 'US-PA-105826', 'Greensburg', 'CI', 4208, 40.33560000000, -79.55070000000, '105826'),
(10455, 'US-FL-105827', 'Bradenton', 'CI', 4175, 27.41380000000, -82.36980000000, '105827'),
(10456, 'US-OH-105828', 'Youngstown', 'CI', 4204, 41.10020000000, -80.64690000000, '105828'),
(10457, 'US-GA-105829', 'Morrow', 'CI', 4176, 33.58550000000, -84.32790000000, '105829'),
(10458, 'US-CO-105830', 'Steamboat Springs', 'CI', 4170, 40.47740000000, -106.84550000000, '105830'),
(10459, 'US-VA-105831', 'Virginia Beach', 'CI', 4218, 36.79680000000, -76.17670000000, '105831'),
(10460, 'US-PA-105832', 'Butler', 'CI', 4208, 40.91400000000, -79.93200000000, '105832'),
(10461, 'US-OR-105833', 'Gilchrist', 'CI', 4206, 43.51910000000, -121.64810000000, '105833'),
(10462, 'US-WA-105834', 'Vancouver', 'CI', 4219, 45.60230000000, -122.51670000000, '105834'),
(10463, 'US-GA-105835', 'Thomasville', 'CI', 4176, 30.85630000000, -83.89770000000, '105835'),
(10464, 'US-GA-105836', 'Macon', 'CI', 4176, 32.82930000000, -83.49280000000, '105836'),
(10465, 'US-TX-105837', 'Flower Mound', 'CI', 4214, 33.02900000000, -97.11230000000, '105837'),
(10466, 'US-OH-105838', 'Mount Vernon', 'CI', 4204, 40.38140000000, -82.49930000000, '105838'),
(10467, 'US-GA-105839', 'Hampton', 'CI', 4176, 33.40830000000, -84.30420000000, '105839'),
(10468, 'US-SC-105840', 'Bluffton', 'CI', 4211, 32.25280000000, -80.88950000000, '105840'),
(10469, 'US-TX-105841', 'Dripping Springs', 'CI', 4214, 30.22570000000, -98.12680000000, '105841'),
(10470, 'US-IL-105842', 'West Salem', 'CI', 4180, 38.53000000000, -88.00560000000, '105842'),
(10471, 'US-OR-105843', 'Clackamas', 'CI', 4206, 45.41330000000, -122.49920000000, '105843'),
(10472, 'US-OR-105844', 'Oregon City', 'CI', 4206, 45.32180000000, -122.52310000000, '105844'),
(10473, 'US-WA-105845', 'Washougal', 'CI', 4219, 45.61730000000, -122.23600000000, '105845'),
(10474, 'US-NJ-105846', 'Englewood', 'CI', 4198, 40.88950000000, -73.97180000000, '105846'),
(10475, 'US-FL-105847', 'Belle Glade', 'CI', 4175, 26.69510000000, -80.64300000000, '105847'),
(10476, 'US-OR-105848', 'Junction City', 'CI', 4206, 44.21190000000, -123.28500000000, '105848'),
(10477, 'US-OR-105849', 'Wilsonville', 'CI', 4206, 45.30840000000, -122.77990000000, '105849'),
(10478, 'US-OR-105850', 'Redmond', 'CI', 4206, 44.26280000000, -121.22680000000, '105850'),
(10479, 'US-NJ-105851', 'Pennsauken', 'CI', 4198, 39.97200000000, -75.04790000000, '105851'),
(10480, 'US-CA-105852', 'Lakehead', 'CI', 4169, 40.88920000000, -122.38610000000, '105852'),
(10481, 'US-FL-105853', 'Winter Park', 'CI', 4175, 28.60790000000, -81.30550000000, '105853'),
(10482, 'US-FL-105854', 'Kissimmee', 'CI', 4175, 28.24230000000, -81.44560000000, '105854'),
(10483, 'US-GA-105855', 'Fitzgerald', 'CI', 4176, 31.71980000000, -83.21320000000, '105855'),
(10484, 'US-MD-105856', 'Hagerstown', 'CI', 4188, 39.62910000000, -77.71280000000, '105856'),
(10485, 'US-WV-105857', 'Ripley', 'CI', 4220, 38.78690000000, -81.68170000000, '105857'),
(10486, 'US-CA-105858', 'Turlock', 'CI', 4169, 37.53720000000, -120.84870000000, '105858'),
(10487, 'US-FL-105859', 'Lake Mary', 'CI', 4175, 28.75780000000, -81.33970000000, '105859'),
(10488, 'US-FL-105860', 'Ocala', 'CI', 4175, 29.11780000000, -82.31220000000, '105860'),
(10489, 'US-FL-105861', 'Sanford', 'CI', 4175, 28.75240000000, -81.24740000000, '105861'),
(10490, 'US-FL-105862', 'Melbourne', 'CI', 4175, 28.07820000000, -80.75340000000, '105862'),
(10491, 'US-OR-105863', 'Hillsboro', 'CI', 4206, 45.58480000000, -122.91170000000, '105863'),
(10492, 'US-WA-105864', 'Kalama', 'CI', 4219, 46.01330000000, -122.70800000000, '105864'),
(10493, 'US-OR-105865', 'Gresham', 'CI', 4206, 45.50760000000, -122.43070000000, '105865'),
(10494, 'US-NJ-105866', 'Far Hills', 'CI', 4198, 40.71620000000, -74.61830000000, '105866'),
(10495, 'US-FL-105867', 'Lake Worth', 'CI', 4175, 26.57920000000, -80.08060000000, '105867'),
(10496, 'US-FL-105868', 'Hialeah', 'CI', 4175, 25.93720000000, -80.31700000000, '105868'),
(10497, 'US-FL-105869', 'Vero Beach', 'CI', 4175, 27.70850000000, -80.38900000000, '105869'),
(10498, 'US-FL-105870', 'Wabasso', 'CI', 4175, 27.75190000000, -80.44780000000, '105870'),
(10499, 'US-OH-105871', 'Sidney', 'CI', 4204, 40.28390000000, -84.16480000000, '105871'),
(10500, 'US-OH-105872', 'Independence', 'CI', 4204, 41.39170000000, -81.64170000000, '105872'),
(10502, 'US-FL-105874', 'North Fort Myers', 'CI', 4175, 26.71440000000, -81.84340000000, '105874'),
(10503, 'US-NJ-105875', 'Parsippany', 'CI', 4198, 40.85970000000, -74.40260000000, '105875'),
(10504, 'US-TX-105876', 'Spring', 'CI', 4214, 30.14100000000, -95.46940000000, '105876'),
(10505, 'US-FL-105877', 'North Palm Beach', 'CI', 4175, 26.85420000000, -80.05470000000, '105877'),
(10506, 'US-FL-105878', 'Naples', 'CI', 4175, 26.23850000000, -81.76410000000, '105878'),
(10507, 'US-MN-105879', 'Rochester', 'CI', 4191, 43.96210000000, -92.52180000000, '105879'),
(10508, 'US-GA-105880', 'Columbus', 'CI', 4176, 32.46470000000, -84.98840000000, '105880'),
(10509, 'US-FL-105881', 'Polk City', 'CI', 4175, 28.23210000000, -81.81150000000, '105881'),
(10510, 'US-FL-105882', 'Bonita Springs', 'CI', 4175, 26.36330000000, -81.83360000000, '105882'),
(10511, 'US-FL-105883', 'Deerfield Beach', 'CI', 4175, 26.30840000000, -80.14320000000, '105883'),
(10512, 'US-FL-105884', 'Punta Gorda', 'CI', 4175, 26.90230000000, -81.78940000000, '105884'),
(10513, 'US-OH-105885', 'Circleville', 'CI', 4204, 39.59290000000, -82.89120000000, '105885'),
(10514, 'US-FL-105886', 'Auburndale', 'CI', 4175, 28.07950000000, -81.80370000000, '105886'),
(10515, 'US-FL-105887', 'Lake Wales', 'CI', 4175, 27.89340000000, -81.58250000000, '105887'),
(10516, 'US-TX-105888', 'Beaumont', 'CI', 4214, 29.96620000000, -94.20270000000, '105888'),
(10517, 'US-MS-105889', 'Mendenhall', 'CI', 4192, 31.93730000000, -89.81740000000, '105889'),
(10518, 'US-LA-105890', 'Donaldsonville', 'CI', 4185, 30.13610000000, -91.05440000000, '105890'),
(10519, 'US-LA-105891', 'Hammond', 'CI', 4185, 30.53150000000, -90.46280000000, '105891'),
(10520, 'US-MS-105892', 'Long Beach', 'CI', 4192, 30.37490000000, -89.17850000000, '105892'),
(10521, 'US-LA-105893', 'Lafayette', 'CI', 4185, 30.16050000000, -92.03320000000, '105893'),
(10522, 'US-LA-105894', 'Harvey', 'CI', 4185, 29.84850000000, -90.06330000000, '105894'),
(10523, 'US-MS-105895', 'Brandon', 'CI', 4192, 32.21610000000, -89.88990000000, '105895'),
(10524, 'US-TX-105896', 'Encinal', 'CI', 4214, 28.03050000000, -99.41870000000, '105896'),
(10525, 'US-MS-105897', 'Laurel', 'CI', 4192, 31.69090000000, -89.14450000000, '105897'),
(10526, 'US-FL-105898', 'Santa Rosa Beach', 'CI', 4175, 30.35440000000, -86.15940000000, '105898'),
(10527, 'US-OR-105899', 'Willamina', 'CI', 4206, 45.13880000000, -123.51210000000, '105899'),
(10528, 'US-FL-105900', 'Niceville', 'CI', 4175, 30.51430000000, -86.46300000000, '105900'),
(10529, 'US-FL-105901', 'Pensacola', 'CI', 4175, 30.46210000000, -87.21740000000, '105901'),
(10530, 'US-AL-105902', 'Jackson', 'CI', 4161, 31.53690000000, -87.82660000000, '105902'),
(10531, 'US-MS-105903', 'Ridgeland', 'CI', 4192, 32.43260000000, -90.15560000000, '105903'),
(10532, 'US-LA-105904', 'New Iberia', 'CI', 4185, 29.95790000000, -91.87210000000, '105904'),
(10533, 'US-LA-105905', 'Gretna', 'CI', 4185, 29.88740000000, -90.02610000000, '105905'),
(10534, 'US-VA-105906', 'Woodbridge', 'CI', 4218, 38.62570000000, -77.26650000000, '105906'),
(10535, 'US-DE-105907', 'Millsboro', 'CI', 4172, 38.56080000000, -75.33510000000, '105907'),
(10536, 'US-PA-105908', 'Huntingdon Valley', 'CI', 4208, 40.12870000000, -75.05970000000, '105908'),
(10537, 'US-DE-105909', 'Rehoboth Beach', 'CI', 4172, 38.68860000000, -75.07330000000, '105909'),
(10538, 'US-MD-105910', 'Queenstown', 'CI', 4188, 38.93990000000, -76.13320000000, '105910'),
(10539, 'US-PA-105911', 'Bristol', 'CI', 4208, 40.11720000000, -74.84950000000, '105911'),
(10540, 'US-DE-105912', 'Delmar', 'CI', 4172, 38.48640000000, -75.54390000000, '105912'),
(10541, 'US-DE-105913', 'Middletown', 'CI', 4172, 39.47570000000, -75.67240000000, '105913'),
(10542, 'US-MD-105914', 'Savage', 'CI', 4188, 39.13560000000, -76.82760000000, '105914'),
(10543, 'US-KY-105915', 'Bowling Green', 'CI', 4184, 37.09410000000, -86.42860000000, '105915'),
(10544, 'US-PA-105916', 'Langhorne', 'CI', 4208, 40.18040000000, -74.89300000000, '105916'),
(10545, 'US-PA-105917', 'Jenkintown', 'CI', 4208, 40.09790000000, -75.10780000000, '105917'),
(10546, 'US-TX-105918', 'Dickinson', 'CI', 4214, 29.45680000000, -95.01850000000, '105918'),
(10547, 'US-FL-105919', 'Altamonte Springs', 'CI', 4175, 28.66530000000, -81.41880000000, '105919'),
(10548, 'US-TX-105920', 'Galveston', 'CI', 4214, 29.30660000000, -94.77230000000, '105920'),
(10549, 'US-NH-105921', 'Weare', 'CI', 4197, 43.08330000000, -71.72230000000, '105921'),
(10550, 'US-WV-105922', 'Parkersburg', 'CI', 4220, 39.24300000000, -81.57720000000, '105922'),
(10551, 'US-OH-105923', 'Benton Ridge', 'CI', 4204, 41.00460000000, -83.79620000000, '105923'),
(10552, 'US-OH-105924', 'Waverly', 'CI', 4204, 39.15270000000, -83.03910000000, '105924'),
(10553, 'US-OH-105925', 'Marion', 'CI', 4204, 40.59820000000, -83.14250000000, '105925'),
(10554, 'US-OH-105926', 'Hilliard', 'CI', 4204, 40.02310000000, -83.18100000000, '105926'),
(10555, 'US-FL-105927', 'Alva', 'CI', 4175, 26.74160000000, -81.63630000000, '105927'),
(10556, 'US-KY-105928', 'Ashland', 'CI', 4184, 38.41300000000, -82.72570000000, '105928'),
(10557, 'US-OH-105929', 'Akron', 'CI', 4204, 41.15370000000, -81.63740000000, '105929'),
(10558, 'US-IL-105930', 'Roxana', 'CI', 4180, 38.84600000000, -90.06240000000, '105930'),
(10559, 'US-WV-105931', 'Bob White', 'CI', 4220, 37.94750000000, -81.68930000000, '105931'),
(10560, 'US-WV-105932', 'Winfield', 'CI', 4220, 38.50650000000, -81.92520000000, '105932'),
(10561, 'US-OH-105933', 'Plain City', 'CI', 4204, 40.10300000000, -83.28910000000, '105933'),
(10562, 'US-WV-105934', 'Charleston', 'CI', 4220, 38.29440000000, -81.60960000000, '105934'),
(10563, 'US-CA-105935', 'Richmond', 'CI', 4169, 37.92550000000, -122.34370000000, '105935'),
(10564, 'US-SC-105936', 'North Augusta', 'CI', 4211, 33.52440000000, -81.94240000000, '105936'),
(10565, 'US-OH-105937', 'Hebron', 'CI', 4204, 39.97370000000, -82.50910000000, '105937'),
(10566, 'US-KY-105938', 'Grayson', 'CI', 4184, 38.33640000000, -82.99240000000, '105938'),
(10567, 'US-OH-105939', 'Coshocton', 'CI', 4204, 40.25940000000, -81.96410000000, '105939'),
(10568, 'US-WV-105940', 'Saint Albans', 'CI', 4220, 38.36330000000, -81.80890000000, '105940'),
(10569, 'US-OH-105941', 'Carroll', 'CI', 4204, 39.80370000000, -82.70830000000, '105941'),
(10570, 'US-WV-105942', 'Gallagher', 'CI', 4220, 38.07470000000, -81.37570000000, '105942'),
(10571, 'US-OH-105943', 'Grove City', 'CI', 4204, 39.86390000000, -83.12010000000, '105943'),
(10572, 'US-OH-105944', 'Stow', 'CI', 4204, 41.17410000000, -81.43890000000, '105944'),
(10573, 'US-TX-105945', 'Humble', 'CI', 4214, 30.00410000000, -95.29840000000, '105945'),
(10574, 'US-TX-105946', 'Texas City', 'CI', 4214, 29.40090000000, -95.00050000000, '105946'),
(10575, 'US-CA-105947', 'Oakland', 'CI', 4169, 37.73500000000, -122.20880000000, '105947'),
(10576, 'US-WV-105948', 'Scott Depot', 'CI', 4220, 38.45080000000, -81.89480000000, '105948'),
(10577, 'US-OH-105949', 'Dresden', 'CI', 4204, 40.14320000000, -81.95300000000, '105949'),
(10578, 'US-WV-105950', 'Beckley', 'CI', 4220, 37.81640000000, -81.23290000000, '105950'),
(10579, 'US-OH-105951', 'Canal Winchester', 'CI', 4204, 39.82510000000, -82.79580000000, '105951'),
(10580, 'US-OH-105952', 'Reynoldsburg', 'CI', 4204, 39.95480000000, -82.76930000000, '105952'),
(10581, 'US-PA-105953', 'Lock Haven', 'CI', 4208, 41.32520000000, -77.45840000000, '105953'),
(10582, 'US-OH-105954', 'Piketon', 'CI', 4204, 39.04850000000, -83.16620000000, '105954'),
(10583, 'US-MD-105955', 'Annapolis Junction', 'CI', 4188, 39.12930000000, -76.76710000000, '105955'),
(10584, 'US-VA-105956', 'Haymarket', 'CI', 4218, 38.86940000000, -77.63730000000, '105956'),
(10585, 'US-OH-105957', 'Gambier', 'CI', 4204, 40.33640000000, -82.34840000000, '105957'),
(10586, 'US-TX-105958', 'Stafford', 'CI', 4214, 29.62830000000, -95.56240000000, '105958'),
(10587, 'US-TX-105959', 'Cleveland', 'CI', 4214, 30.32210000000, -94.94930000000, '105959'),
(10588, 'US-OR-105960', 'Albany', 'CI', 4206, 44.62510000000, -123.13090000000, '105960'),
(10589, 'US-IL-105961', 'Canton', 'CI', 4180, 40.53970000000, -90.05850000000, '105961'),
(10590, 'US-VA-105962', 'Lorton', 'CI', 4218, 38.69110000000, -77.20600000000, '105962'),
(10591, 'US-VA-105963', 'Chantilly', 'CI', 4218, 38.90360000000, -77.45120000000, '105963'),
(10592, 'US-MD-105964', 'Fort Washington', 'CI', 4188, 38.75510000000, -76.98050000000, '105964'),
(10593, 'US-MD-105965', 'Leonardtown', 'CI', 4188, 38.27640000000, -76.62410000000, '105965'),
(10594, 'US-VA-105966', 'Springfield', 'CI', 4218, 38.80180000000, -77.21010000000, '105966'),
(10595, 'US-VA-105967', 'Madison', 'CI', 4218, 38.38560000000, -78.28370000000, '105967'),
(10596, 'US-MD-105968', 'Forest Hill', 'CI', 4188, 39.58460000000, -76.39180000000, '105968'),
(10597, 'US-MA-105969', 'Auburn', 'CI', 4189, 42.19550000000, -71.84630000000, '105969'),
(10598, 'US-WI-105970', 'Richfield', 'CI', 4221, 43.26950000000, -88.21170000000, '105970'),
(10599, 'US-MD-105971', 'Accokeek', 'CI', 4188, 38.65910000000, -77.03670000000, '105971'),
(10600, 'US-VA-105972', 'Weyers Cave', 'CI', 4218, 38.29270000000, -78.93490000000, '105972'),
(10601, 'US-MD-105973', 'Potomac', 'CI', 4188, 39.02740000000, -77.23650000000, '105973'),
(10602, 'US-MD-105974', 'Waldorf', 'CI', 4188, 38.62520000000, -76.87800000000, '105974'),
(10603, 'US-WI-105975', 'Brookfield', 'CI', 4221, 43.06060000000, -88.09810000000, '105975'),
(10604, 'US-CA-105976', 'Foothill Ranch', 'CI', 4169, 33.70410000000, -117.67240000000, '105976'),
(10605, 'US-VA-105977', 'Mechanicsville', 'CI', 4218, 37.67880000000, -77.32650000000, '105977'),
(10606, 'US-VA-105978', 'Edinburg', 'CI', 4218, 38.84390000000, -78.63540000000, '105978'),
(10607, 'US-MD-105979', 'Clinton', 'CI', 4188, 38.73950000000, -76.91180000000, '105979'),
(10608, 'US-PA-105980', 'Mifflintown', 'CI', 4208, 40.59650000000, -77.35730000000, '105980'),
(10609, 'US-IL-105981', 'Hopedale', 'CI', 4180, 40.42800000000, -89.43530000000, '105981'),
(10610, 'US-VA-105982', 'Bristow', 'CI', 4218, 38.74050000000, -77.56210000000, '105982'),
(10611, 'US-TX-105983', 'Wylie', 'CI', 4214, 33.01620000000, -96.53820000000, '105983'),
(10612, 'US-RI-105984', 'Smithfield', 'CI', 4210, 41.90400000000, -71.52660000000, '105984'),
(10613, 'US-NY-105985', 'New Windsor', 'CI', 4200, 41.44680000000, -74.06890000000, '105985'),
(10614, 'US-NY-105986', 'Blauvelt', 'CI', 4200, 41.06890000000, -73.95990000000, '105986'),
(10615, 'US-NY-105987', 'Tarrytown', 'CI', 4200, 41.08370000000, -73.83970000000, '105987'),
(10616, 'US-NY-105988', 'Rye', 'CI', 4200, 40.97770000000, -73.69350000000, '105988'),
(10617, 'US-NY-105989', 'White Plains', 'CI', 4200, 41.02910000000, -73.75800000000, '105989'),
(10618, 'US-NY-105990', 'Harrison', 'CI', 4200, 40.97950000000, -73.72310000000, '105990'),
(10619, 'US-NY-105991', 'Peekskill', 'CI', 4200, 41.28790000000, -73.91700000000, '105991'),
(10620, 'US-NY-105992', 'Mahopac', 'CI', 4200, 41.37960000000, -73.75370000000, '105992'),
(10621, 'US-NY-105993', 'Kingston', 'CI', 4200, 41.93890000000, -73.99010000000, '105993'),
(10622, 'US-NY-105994', 'New Rochelle', 'CI', 4200, 40.89890000000, -73.78140000000, '105994'),
(10623, 'US-NY-105995', 'Brewster', 'CI', 4200, 41.41720000000, -73.59710000000, '105995'),
(10624, 'US-NY-105996', 'Newburgh', 'CI', 4200, 41.53750000000, -74.05120000000, '105996'),
(10625, 'US-NY-105997', 'Lagrangeville', 'CI', 4200, 41.66840000000, -73.72250000000, '105997'),
(10626, 'US-NC-105998', 'Bakersville', 'CI', 4201, 36.04030000000, -82.15990000000, '105998'),
(10627, 'US-NY-105999', 'Wappingers Falls', 'CI', 4200, 41.58610000000, -73.88300000000, '105999'),
(10628, 'US-NY-106000', 'Valley Cottage', 'CI', 4200, 41.12220000000, -73.93550000000, '106000'),
(10629, 'US-TX-106001', 'College Station', 'CI', 4214, 30.61310000000, -96.32170000000, '106001'),
(10630, 'US-NY-106002', 'Mount Vernon', 'CI', 4200, 40.90830000000, -73.83460000000, '106002'),
(10631, 'US-NY-106003', 'Brentwood', 'CI', 4200, 40.78100000000, -73.25220000000, '106003'),
(10632, 'US-NY-106004', 'Hauppauge', 'CI', 4200, 40.81910000000, -73.21020000000, '106004'),
(10633, 'US-NY-106005', 'Nanuet', 'CI', 4200, 41.09650000000, -74.00930000000, '106005'),
(10634, 'US-NY-106006', 'Briarcliff Manor', 'CI', 4200, 41.14680000000, -73.83180000000, '106006'),
(10635, 'US-NY-106007', 'Woodbury', 'CI', 4200, 40.81810000000, -73.47210000000, '106007'),
(10636, 'US-NY-106008', 'Ossining', 'CI', 4200, 41.18790000000, -73.83150000000, '106008'),
(10637, 'US-NY-106009', 'Melville', 'CI', 4200, 40.78500000000, -73.40620000000, '106009'),
(10638, 'US-NJ-106010', 'Saddle River', 'CI', 4198, 41.04570000000, -74.09810000000, '106010'),
(10639, 'US-NJ-106011', 'Wayne', 'CI', 4198, 40.94870000000, -74.24130000000, '106011'),
(10640, 'US-NJ-106012', 'Carlstadt', 'CI', 4198, 40.82900000000, -74.06720000000, '106012'),
(10641, 'US-NJ-106013', 'Moonachie', 'CI', 4198, 40.83980000000, -74.05770000000, '106013'),
(10642, 'US-NJ-106014', 'Ridgefield', 'CI', 4198, 40.83080000000, -74.01150000000, '106014'),
(10643, 'US-NJ-106015', 'Northvale', 'CI', 4198, 41.00810000000, -73.94410000000, '106015'),
(10644, 'US-NJ-106016', 'Mahwah', 'CI', 4198, 41.07800000000, -74.17640000000, '106016'),
(10645, 'US-NJ-106017', 'Totowa', 'CI', 4198, 40.90370000000, -74.22470000000, '106017'),
(10646, 'US-NJ-106018', 'Cresskill', 'CI', 4198, 40.94030000000, -73.95760000000, '106018'),
(10647, 'US-NJ-106019', 'Hackensack', 'CI', 4198, 40.88590000000, -74.04680000000, '106019'),
(10648, 'US-NJ-106020', 'Lakewood', 'CI', 4198, 40.07210000000, -74.20690000000, '106020'),
(10649, 'US-NJ-106021', 'Oradell', 'CI', 4198, 40.95580000000, -74.02680000000, '106021'),
(10650, 'US-NJ-106022', 'Ridgewood', 'CI', 4198, 40.98160000000, -74.11380000000, '106022'),
(10651, 'US-AR-106023', 'Beebe', 'CI', 4165, 35.11440000000, -91.90670000000, '106023'),
(10652, 'US-AR-106024', 'El Dorado', 'CI', 4165, 33.19290000000, -92.64340000000, '106024'),
(10653, 'US-NJ-106025', 'Chatsworth', 'CI', 4198, 39.76980000000, -74.52250000000, '106025'),
(10654, 'US-AR-106026', 'Stuttgart', 'CI', 4165, 34.43960000000, -91.52980000000, '106026'),
(10655, 'US-LA-106027', 'Collinston', 'CI', 4185, 32.62560000000, -91.89220000000, '106027'),
(10656, 'US-KY-106028', 'Owensboro', 'CI', 4184, 37.75550000000, -87.04340000000, '106028'),
(10657, 'US-AR-106029', 'Arkadelphia', 'CI', 4165, 34.02680000000, -93.06440000000, '106029'),
(10658, 'US-IN-106030', 'Scottsburg', 'CI', 4181, 38.69110000000, -85.85450000000, '106030'),
(10659, 'US-TX-106031', 'Channelview', 'CI', 4214, 29.79080000000, -95.10910000000, '106031'),
(10660, 'US-TX-106032', 'New Boston', 'CI', 4214, 33.45930000000, -94.43010000000, '106032'),
(10661, 'US-TN-106033', 'Sevierville', 'CI', 4213, 35.75020000000, -83.62960000000, '106033'),
(10662, 'US-LA-106034', 'Monroe', 'CI', 4185, 32.52060000000, -92.10660000000, '106034'),
(10663, 'US-LA-106035', 'West Monroe', 'CI', 4185, 32.39380000000, -92.23290000000, '106035'),
(10664, 'US-VA-106036', 'Glen Allen', 'CI', 4218, 37.70890000000, -77.54370000000, '106036'),
(10665, 'US-TX-106037', 'Sherman', 'CI', 4214, 33.63830000000, -96.72450000000, '106037'),
(10666, 'US-AR-106038', 'Camden', 'CI', 4165, 33.61140000000, -92.84520000000, '106038'),
(10667, 'US-LA-106039', 'Farmerville', 'CI', 4185, 32.77380000000, -92.34090000000, '106039'),
(10668, 'US-LA-106040', 'Vivian', 'CI', 4185, 32.85520000000, -93.95670000000, '106040'),
(10669, 'US-NJ-106041', 'Secaucus', 'CI', 4198, 40.78010000000, -74.06330000000, '106041'),
(10670, 'US-WI-106042', 'Burlington', 'CI', 4221, 42.64960000000, -88.29850000000, '106042'),
(10671, 'US-WV-106043', 'Charles Town', 'CI', 4220, 39.25810000000, -77.87050000000, '106043'),
(10672, 'US-AL-106044', 'Cherokee', 'CI', 4161, 34.73930000000, -87.99300000000, '106044'),
(10673, 'US-MO-106045', 'Dexter', 'CI', 4193, 36.78080000000, -89.99990000000, '106045'),
(10674, 'US-TX-106046', 'Merkel', 'CI', 4214, 32.45460000000, -100.02330000000, '106046'),
(10675, 'US-LA-106047', 'Coushatta', 'CI', 4185, 32.06020000000, -93.26910000000, '106047'),
(10676, 'US-KY-106048', 'Calvert City', 'CI', 4184, 37.00340000000, -88.38450000000, '106048'),
(10677, 'US-TX-106049', 'Pasadena', 'CI', 4214, 29.70560000000, -95.15590000000, '106049'),
(10678, 'US-AR-106050', 'Star City', 'CI', 4165, 33.94320000000, -91.83220000000, '106050'),
(10679, 'US-AR-106051', 'Nashville', 'CI', 4165, 33.99930000000, -93.81490000000, '106051'),
(10680, 'US-MS-106052', 'Gulfport', 'CI', 4192, 30.47300000000, -89.14940000000, '106052'),
(10681, 'US-TX-106053', 'League City', 'CI', 4214, 29.50750000000, -95.08950000000, '106053'),
(10682, 'US-TX-106054', 'Midland', 'CI', 4214, 31.99760000000, -102.07740000000, '106054'),
(10683, 'US-IL-106055', 'Elwood', 'CI', 4180, 41.41530000000, -88.10630000000, '106055'),
(10684, 'US-WI-106056', 'Waukesha', 'CI', 4221, 43.02820000000, -88.29490000000, '106056'),
(10685, 'US-WI-106057', 'Kewaunee', 'CI', 4221, 44.43680000000, -87.58800000000, '106057'),
(10686, 'US-VA-106058', 'Lignum', 'CI', 4218, 38.40310000000, -77.82470000000, '106058'),
(10687, 'US-VA-106059', 'Elkton', 'CI', 4218, 38.39290000000, -78.61810000000, '106059'),
(10688, 'US-VA-106060', 'Falls Church', 'CI', 4218, 38.84720000000, -77.14250000000, '106060'),
(10689, 'US-VA-106061', 'Fort Belvoir', 'CI', 4218, 38.71100000000, -77.16210000000, '106061'),
(10690, 'US-NC-106062', 'Columbus', 'CI', 4201, 35.22200000000, -82.06860000000, '106062'),
(10691, 'US-PA-106063', 'Washington Crossing', 'CI', 4208, 40.28550000000, -74.87890000000, '106063'),
(10692, 'US-WI-106064', 'Watertown', 'CI', 4221, 43.12310000000, -88.70630000000, '106064'),
(10693, 'US-VA-106065', 'Centreville', 'CI', 4218, 38.85570000000, -77.46970000000, '106065'),
(10694, 'US-MD-106066', 'White Plains', 'CI', 4188, 38.58530000000, -76.94770000000, '106066'),
(10695, 'US-GA-106067', 'Greensboro', 'CI', 4176, 33.57170000000, -83.17650000000, '106067'),
(10696, 'US-MA-106068', 'Indian Orchard', 'CI', 4189, 42.15100000000, -72.51240000000, '106068'),
(10697, 'US-VA-106069', 'Woodford', 'CI', 4218, 38.11840000000, -77.44130000000, '106069'),
(10698, 'US-IN-106070', 'Madison', 'CI', 4181, 38.83920000000, -85.36690000000, '106070'),
(10699, 'US-IN-106071', 'Muncie', 'CI', 4181, 40.23690000000, -85.46790000000, '106071'),
(10700, 'US-IN-106072', 'Veedersburg', 'CI', 4181, 40.12020000000, -87.23390000000, '106072'),
(10701, 'US-IN-106073', 'Kokomo', 'CI', 4181, 40.43980000000, -86.08930000000, '106073'),
(10702, 'US-IN-106074', 'Seymour', 'CI', 4181, 38.93850000000, -85.88960000000, '106074'),
(10703, 'US-WV-106075', 'Martinsburg', 'CI', 4220, 39.46320000000, -77.95210000000, '106075'),
(10704, 'US-IN-106076', 'Plainfield', 'CI', 4181, 39.68580000000, -86.41060000000, '106076'),
(10705, 'US-NM-106077', 'Thoreau', 'CI', 4199, 35.42110000000, -108.19700000000, '106077'),
(10706, 'US-IN-106078', 'Crothersville', 'CI', 4181, 38.80670000000, -85.87320000000, '106078'),
(10707, 'US-IL-106079', 'Urbana', 'CI', 4180, 40.12020000000, -88.15510000000, '106079'),
(10708, 'US-IN-106080', 'Carmel', 'CI', 4181, 39.97380000000, -86.17650000000, '106080'),
(10709, 'US-IN-106081', 'Mitchell', 'CI', 4181, 38.75000000000, -86.53860000000, '106081'),
(10710, 'US-IN-106082', 'Westfield', 'CI', 4181, 40.03600000000, -86.17050000000, '106082'),
(10711, 'US-NY-106083', 'Hawthorne', 'CI', 4200, 41.09400000000, -73.78940000000, '106083'),
(10712, 'US-IL-106084', 'Champaign', 'CI', 4180, 40.13190000000, -88.29520000000, '106084'),
(10713, 'US-IN-106085', 'Winslow', 'CI', 4181, 38.38520000000, -87.21560000000, '106085'),
(10714, 'US-IN-106086', 'Paoli', 'CI', 4181, 38.51310000000, -86.45520000000, '106086'),
(10715, 'US-IN-106087', 'Terre Haute', 'CI', 4181, 39.35790000000, -87.42450000000, '106087'),
(10716, 'US-IN-106088', 'Anderson', 'CI', 4181, 40.04830000000, -85.68550000000, '106088'),
(10717, 'US-IN-106089', 'Clinton', 'CI', 4181, 39.68170000000, -87.45670000000, '106089'),
(10718, 'US-IL-106090', 'Mahomet', 'CI', 4180, 40.21490000000, -88.40460000000, '106090'),
(10719, 'US-IN-106091', 'Austin', 'CI', 4181, 38.76970000000, -85.80290000000, '106091'),
(10720, 'US-WI-106092', 'Big Bend', 'CI', 4221, 42.88600000000, -88.22540000000, '106092'),
(10721, 'US-IN-106093', 'North Vernon', 'CI', 4181, 39.02820000000, -85.63040000000, '106093'),
(10722, 'US-TX-106094', 'Trinity', 'CI', 4214, 30.96920000000, -95.34860000000, '106094'),
(10723, 'US-TX-106095', 'Danbury', 'CI', 4214, 29.22940000000, -95.32120000000, '106095'),
(10724, 'US-WI-106096', 'Caledonia', 'CI', 4221, 42.81430000000, -87.94230000000, '106096'),
(10725, 'US-PA-106097', 'Girard', 'CI', 4208, 41.97030000000, -80.31250000000, '106097'),
(10726, 'US-VA-106098', 'Midlothian', 'CI', 4218, 37.54150000000, -77.66780000000, '106098'),
(10727, 'US-CA-106099', 'Torrance', 'CI', 4169, 33.86690000000, -118.33120000000, '106099'),
(10728, 'US-IN-106100', 'Frankton', 'CI', 4181, 40.21320000000, -85.78480000000, '106100'),
(10729, 'US-IN-106101', 'Franklin', 'CI', 4181, 39.48350000000, -86.04780000000, '106101'),
(10730, 'US-IN-106102', 'Greenwood', 'CI', 4181, 39.59250000000, -86.11110000000, '106102'),
(10731, 'US-IN-106103', 'Lafayette', 'CI', 4181, 40.42240000000, -86.80310000000, '106103'),
(10732, 'US-FL-106104', 'Homestead', 'CI', 4175, 25.49030000000, -80.41870000000, '106104'),
(10733, 'US-IN-106105', 'West Terre Haute', 'CI', 4181, 39.47820000000, -87.45880000000, '106105'),
(10734, 'US-LA-106106', 'Kinder', 'CI', 4185, 30.53630000000, -92.90540000000, '106106'),
(10735, 'US-NJ-106107', 'Mountain Lakes', 'CI', 4198, 40.89030000000, -74.44170000000, '106107'),
(10736, 'US-CA-106108', 'Suisun City', 'CI', 4169, 38.16990000000, -121.93670000000, '106108'),
(10737, 'US-OH-106109', 'Lewis Center', 'CI', 4204, 40.18320000000, -82.99540000000, '106109'),
(10738, 'US-OH-106110', 'Bellefontaine', 'CI', 4204, 40.37260000000, -83.74770000000, '106110'),
(10739, 'US-WV-106111', 'Huntington', 'CI', 4220, 38.36850000000, -82.42450000000, '106111'),
(10740, 'US-NH-106112', 'Exeter', 'CI', 4197, 42.96610000000, -70.98810000000, '106112'),
(10741, 'US-NH-106113', 'Hollis', 'CI', 4197, 42.75290000000, -71.58370000000, '106113'),
(10742, 'US-NH-106114', 'Dover', 'CI', 4197, 43.18710000000, -70.91000000000, '106114'),
(10743, 'US-IN-106115', 'Munster', 'CI', 4181, 41.55050000000, -87.50260000000, '106115'),
(10744, 'US-MA-106116', 'Framingham', 'CI', 4189, 42.32330000000, -71.43520000000, '106116'),
(10745, 'US-CA-106117', 'Rancho Cordova', 'CI', 4169, 38.57360000000, -121.17570000000, '106117'),
(10746, 'US-MI-106118', 'Grandville', 'CI', 4190, 42.88280000000, -85.78280000000, '106118'),
(10747, 'US-LA-106119', 'Rayne', 'CI', 4185, 30.21610000000, -92.26750000000, '106119'),
(10748, 'US-MA-106120', 'Brockton', 'CI', 4189, 42.08580000000, -70.99990000000, '106120'),
(10749, 'US-OH-106121', 'Mason', 'CI', 4204, 39.35220000000, -84.29940000000, '106121'),
(10750, 'US-PA-106122', 'Matamoras', 'CI', 4208, 41.37930000000, -74.73810000000, '106122'),
(10751, 'US-CA-106123', 'Riverside', 'CI', 4169, 33.99360000000, -117.38320000000, '106123'),
(10752, 'US-MA-106124', 'Wilmington', 'CI', 4189, 42.56530000000, -71.17450000000, '106124'),
(10753, 'US-MA-106125', 'Southborough', 'CI', 4189, 42.29660000000, -71.53520000000, '106125'),
(10754, 'US-MA-106126', 'North Chelmsford', 'CI', 4189, 42.63200000000, -71.38880000000, '106126'),
(10755, 'US-FL-106127', 'Destin', 'CI', 4175, 30.39810000000, -86.45630000000, '106127'),
(10756, 'US-GA-106128', 'Rome', 'CI', 4176, 34.30670000000, -85.27000000000, '106128'),
(10757, 'US-UT-106129', 'Provo', 'CI', 4215, 40.33930000000, -111.57090000000, '106129'),
(10758, 'US-UT-106130', 'Orem', 'CI', 4215, 40.31430000000, -111.71160000000, '106130'),
(10759, 'US-NJ-106131', 'Paramus', 'CI', 4198, 40.94450000000, -74.07000000000, '106131'),
(10761, 'US-NY-106133', 'Flushing', 'CI', 4200, 40.77230000000, -73.87220000000, '106133'),
(10762, 'US-UT-106134', 'Morgan', 'CI', 4215, 41.01050000000, -111.67820000000, '106134'),
(10763, 'US-ID-106135', 'Albion', 'CI', 4179, 42.38080000000, -113.60030000000, '106135'),
(10764, 'US-MD-106136', 'Curtis Bay', 'CI', 4188, 39.18900000000, -76.54820000000, '106136'),
(10765, 'US-MD-106137', 'Bel Air', 'CI', 4188, 39.53820000000, -76.35190000000, '106137'),
(10766, 'US-MD-106138', 'Denton', 'CI', 4188, 38.84750000000, -75.79320000000, '106138'),
(10767, 'US-MD-106139', 'Tracys Landing', 'CI', 4188, 38.76090000000, -76.57640000000, '106139'),
(10768, 'US-MD-106140', 'Woodbine', 'CI', 4188, 39.33900000000, -77.06400000000, '106140'),
(10769, 'US-MD-106141', 'Abingdon', 'CI', 4188, 39.47380000000, -76.28940000000, '106141'),
(10770, 'US-MD-106142', 'Fort George G Meade', 'CI', 4188, 39.10880000000, -76.74540000000, '106142'),
(10771, 'US-MD-106143', 'Sparks Glencoe', 'CI', 4188, 39.54830000000, -76.68590000000, '106143'),
(10772, 'US-MD-106144', 'Towson', 'CI', 4188, 39.41570000000, -76.57180000000, '106144'),
(10773, 'US-MD-106145', 'Cambridge', 'CI', 4188, 38.48720000000, -76.08670000000, '106145'),
(10774, 'US-MD-106146', 'Rosedale', 'CI', 4188, 39.34050000000, -76.49620000000, '106146'),
(10775, 'US-MD-106147', 'Nottingham', 'CI', 4188, 39.38920000000, -76.49200000000, '106147'),
(10776, 'US-MD-106148', 'Middle River', 'CI', 4188, 39.34020000000, -76.40260000000, '106148'),
(10777, 'US-MD-106149', 'East New Market', 'CI', 4188, 38.58730000000, -75.94520000000, '106149'),
(10778, 'US-MD-106150', 'Pasadena', 'CI', 4188, 39.12520000000, -76.51160000000, '106150'),
(10779, 'US-MD-106151', 'Hunt Valley', 'CI', 4188, 39.48780000000, -76.65670000000, '106151'),
(10780, 'US-MD-106152', 'Dunkirk', 'CI', 4188, 38.73630000000, -76.64680000000, '106152'),
(10781, 'US-MD-106153', 'Lutherville Timonium', 'CI', 4188, 39.43630000000, -76.63890000000, '106153'),
(10782, 'US-CT-106154', 'South Windsor', 'CI', 4171, 41.83380000000, -72.57060000000, '106154'),
(10783, 'US-WI-106155', 'Madison', 'CI', 4221, 43.10820000000, -89.27060000000, '106155'),
(10784, 'US-IL-106156', 'Chester', 'CI', 4180, 37.95230000000, -89.78830000000, '106156'),
(10785, 'US-MD-106157', 'Sparrows Point', 'CI', 4188, 39.23030000000, -76.44960000000, '106157'),
(10786, 'US-MD-106158', 'Odenton', 'CI', 4188, 39.05100000000, -76.72850000000, '106158'),
(10787, 'US-MD-106159', 'Owings Mills', 'CI', 4188, 39.43700000000, -76.78180000000, '106159'),
(10788, 'US-TN-106160', 'Henderson', 'CI', 4213, 35.40370000000, -88.67760000000, '106160'),
(10789, 'US-MD-106161', 'Jessup', 'CI', 4188, 39.14410000000, -76.78170000000, '106161'),
(10790, 'US-MD-106162', 'Lusby', 'CI', 4188, 38.38570000000, -76.43980000000, '106162'),
(10791, 'US-MD-106163', 'Edgewater', 'CI', 4188, 38.91090000000, -76.54030000000, '106163'),
(10792, 'US-MD-106164', 'Aberdeen', 'CI', 4188, 39.49840000000, -76.19660000000, '106164'),
(10793, 'US-MD-106165', 'Annapolis', 'CI', 4188, 38.98860000000, -76.46740000000, '106165'),
(10794, 'US-ID-106166', 'Saint Anthony', 'CI', 4179, 43.98640000000, -111.79590000000, '106166'),
(10795, 'US-MD-106167', 'Westminster', 'CI', 4188, 39.55120000000, -76.99470000000, '106167'),
(10796, 'US-MD-106168', 'Ocean City', 'CI', 4188, 38.33840000000, -75.12490000000, '106168'),
(10797, 'US-MD-106169', 'Sykesville', 'CI', 4188, 39.39410000000, -76.96950000000, '106169'),
(10798, 'US-MD-106170', 'Essex', 'CI', 4188, 39.29510000000, -76.43580000000, '106170'),
(10799, 'US-MD-106171', 'Taneytown', 'CI', 4188, 39.65750000000, -77.17480000000, '106171'),
(10800, 'US-MD-106172', 'Dundalk', 'CI', 4188, 39.25750000000, -76.49510000000, '106172'),
(10801, 'US-NJ-106173', 'Maywood', 'CI', 4198, 40.90230000000, -74.06150000000, '106173'),
(10802, 'US-FL-106174', 'Jacksonville Beach', 'CI', 4175, 30.28010000000, -81.40500000000, '106174'),
(10803, 'US-NH-106175', 'Tilton', 'CI', 4197, 43.43290000000, -71.56820000000, '106175'),
(10804, 'US-CT-106176', 'Manchester', 'CI', 4171, 41.77700000000, -72.52360000000, '106176'),
(10805, 'US-VT-106177', 'Chester', 'CI', 4216, 43.22600000000, -72.53510000000, '106177'),
(10806, 'US-NH-106178', 'Durham', 'CI', 4197, 43.12710000000, -70.96270000000, '106178'),
(10807, 'US-NH-106179', 'Littleton', 'CI', 4197, 44.33810000000, -71.83050000000, '106179'),
(10808, 'US-NH-106180', 'Andover', 'CI', 4197, 43.44620000000, -71.79490000000, '106180'),
(10809, 'US-TX-106181', 'Corpus Christi', 'CI', 4214, 27.74790000000, -97.44350000000, '106181'),
(10810, 'US-NJ-106182', 'Holmdel', 'CI', 4198, 40.37540000000, -74.17120000000, '106182'),
(10811, 'US-MA-106183', 'Fitchburg', 'CI', 4189, 42.59080000000, -71.80550000000, '106183'),
(10812, 'US-NH-106184', 'Jaffrey', 'CI', 4197, 42.84500000000, -72.05950000000, '106184'),
(10813, 'US-MA-106185', 'Westminster', 'CI', 4189, 42.36480000000, -71.89690000000, '106185'),
(10814, 'US-MA-106186', 'Dracut', 'CI', 4189, 42.69310000000, -71.30870000000, '106186'),
(10815, 'US-NJ-106187', 'Clark', 'CI', 4198, 40.62240000000, -74.31240000000, '106187'),
(10816, 'US-MT-106188', 'West Yellowstone', 'CI', 4194, 44.69290000000, -111.21350000000, '106188'),
(10817, 'US-MT-106189', 'Helena', 'CI', 4194, 46.51720000000, -112.12110000000, '106189'),
(10818, 'US-MA-106190', 'Everett', 'CI', 4189, 42.40630000000, -71.05120000000, '106190'),
(10819, 'US-NE-106191', 'Lynch', 'CI', 4195, 42.87540000000, -98.42530000000, '106191'),
(10820, 'US-SC-106192', 'Aiken', 'CI', 4211, 33.44830000000, -81.69210000000, '106192'),
(10821, 'US-SC-106193', 'Lamar', 'CI', 4211, 34.19390000000, -80.10240000000, '106193'),
(10822, 'US-MA-106194', 'Newton Highlands', 'CI', 4189, 42.31690000000, -71.20820000000, '106194'),
(10823, 'US-MA-106195', 'Charlestown', 'CI', 4189, 42.38010000000, -71.06420000000, '106195'),
(10824, 'US-WI-106196', 'Grafton', 'CI', 4221, 43.32970000000, -87.92940000000, '106196'),
(10825, 'US-OH-106197', 'Gallipolis', 'CI', 4204, 38.80650000000, -82.27020000000, '106197'),
(10826, 'US-WI-106198', 'Whitewater', 'CI', 4221, 42.80480000000, -88.70720000000, '106198'),
(10827, 'US-MA-106199', 'Methuen', 'CI', 4189, 42.73240000000, -71.18620000000, '106199'),
(10828, 'US-IL-106200', 'Hoopeston', 'CI', 4180, 40.46800000000, -87.67310000000, '106200'),
(10829, 'US-KY-106201', 'Versailles', 'CI', 4184, 37.99690000000, -84.74660000000, '106201'),
(10830, 'VI-??-106202', 'Kingshill', 'CI', 237, 17.73420000000, -64.73470000000, '106202'),
(10831, 'US-UT-106203', 'Woods Cross', 'CI', 4215, 40.89170000000, -111.93110000000, '106203'),
(10832, 'US-CO-106204', 'Florence', 'CI', 4170, 38.33990000000, -105.07920000000, '106204'),
(10833, 'US-NJ-106205', 'Lodi', 'CI', 4198, 40.87830000000, -74.08130000000, '106205'),
(10834, 'US-UT-106206', 'Park City', 'CI', 4215, 40.64830000000, -111.49900000000, '106206'),
(10835, 'US-NY-106207', 'Jordanville', 'CI', 4200, 42.90290000000, -74.88020000000, '106207'),
(10836, 'US-AR-106208', 'Bentonville', 'CI', 4165, 36.34570000000, -94.25140000000, '106208'),
(10837, 'US-TN-106209', 'Murfreesboro', 'CI', 4213, 35.92980000000, -86.46050000000, '106209'),
(10838, 'US-FL-106210', 'Cape Canaveral', 'CI', 4175, 28.38980000000, -80.60510000000, '106210'),
(10839, 'US-FL-106211', 'Longwood', 'CI', 4175, 28.70580000000, -81.34750000000, '106211'),
(10840, 'US-NV-106212', 'Elko', 'CI', 4196, 40.95270000000, -115.79060000000, '106212'),
(10841, 'US-MT-106213', 'Lavina', 'CI', 4194, 46.44160000000, -108.99970000000, '106213'),
(10842, 'US-MT-106214', 'Bozeman', 'CI', 4194, 45.77200000000, -110.93490000000, '106214'),
(10843, 'US-UT-106215', 'Bountiful', 'CI', 4215, 40.88040000000, -111.82330000000, '106215'),
(10844, 'US-MA-106216', 'Natick', 'CI', 4189, 42.28730000000, -71.35240000000, '106216'),
(10845, 'US-FL-106217', 'Brooksville', 'CI', 4175, 28.60680000000, -82.55720000000, '106217'),
(10846, 'US-ME-106218', 'Madison', 'CI', 4186, 44.83510000000, -69.80500000000, '106218'),
(10847, 'US-FL-106219', 'Fernandina Beach', 'CI', 4175, 30.60050000000, -81.52830000000, '106219'),
(10848, 'US-FL-106220', 'Maitland', 'CI', 4175, 28.62940000000, -81.36190000000, '106220'),
(10849, 'US-UT-106221', 'Delta', 'CI', 4215, 39.29020000000, -112.56560000000, '106221'),
(10850, 'US-UT-106222', 'Lehi', 'CI', 4215, 40.32450000000, -111.96180000000, '106222'),
(10851, 'US-UT-106223', 'West Jordan', 'CI', 4215, 40.62360000000, -111.98710000000, '106223'),
(10852, 'US-KS-106224', 'Hartford', 'CI', 4183, 38.26050000000, -95.96890000000, '106224'),
(10853, 'US-IL-106225', 'Lake Forest', 'CI', 4180, 42.24000000000, -87.87170000000, '106225'),
(10854, 'US-IL-106226', 'East Alton', 'CI', 4180, 38.87360000000, -90.07320000000, '106226'),
(10855, 'US-NY-106227', 'Little Neck', 'CI', 4200, 40.75910000000, -73.73580000000, '106227'),
(10857, 'US-UT-106229', 'Wallsburg', 'CI', 4215, 40.36360000000, -111.43310000000, '106229'),
(10858, 'US-NJ-106230', 'Short Hills', 'CI', 4198, 40.73890000000, -74.33070000000, '106230'),
(10859, 'US-MO-106231', 'Arnold', 'CI', 4193, 38.42310000000, -90.40060000000, '106231'),
(10860, 'US-UT-106232', 'American Fork', 'CI', 4215, 40.39300000000, -111.78380000000, '106232'),
(10861, 'US-ID-106233', 'Idaho Falls', 'CI', 4179, 43.42850000000, -112.00410000000, '106233'),
(10862, 'US-MT-106234', 'Gardiner', 'CI', 4194, 45.13030000000, -110.41820000000, '106234'),
(10863, 'US-OH-106235', 'Middletown', 'CI', 4204, 39.44390000000, -84.41680000000, '106235'),
(10864, 'US-IL-106236', 'Libertyville', 'CI', 4180, 42.28330000000, -87.96060000000, '106236'),
(10865, 'US-MO-106237', 'Cassville', 'CI', 4193, 36.68390000000, -93.82180000000, '106237'),
(10866, 'US-NV-106238', 'Carlin', 'CI', 4196, 40.73350000000, -116.10630000000, '106238'),
(10867, 'US-UT-106239', 'Riverton', 'CI', 4215, 40.47740000000, -112.00820000000, '106239'),
(10868, 'US-IA-106240', 'Norwalk', 'CI', 4182, 41.44690000000, -93.68870000000, '106240'),
(10869, 'US-IA-106241', 'Clive', 'CI', 4182, 41.61390000000, -93.78550000000, '106241'),
(10870, 'US-ND-106242', 'Watford City', 'CI', 4202, 47.83420000000, -103.20170000000, '106242'),
(10871, 'US-LA-106243', 'Boyce', 'CI', 4185, 31.30650000000, -92.65420000000, '106243'),
(10872, 'US-MS-106244', 'Robinsonville', 'CI', 4192, 34.78140000000, -90.33020000000, '106244'),
(10873, 'US-NV-106245', 'Spring Creek', 'CI', 4196, 40.55990000000, -115.61550000000, '106245'),
(10874, 'US-ID-106246', 'Blackfoot', 'CI', 4179, 43.27790000000, -112.56270000000, '106246'),
(10875, 'US-CA-106247', 'Twain Harte', 'CI', 4169, 38.08150000000, -120.24790000000, '106247'),
(10876, 'US-UT-106248', 'Springville', 'CI', 4215, 40.20900000000, -111.47400000000, '106248'),
(10877, 'US-MA-106249', 'Boxborough', 'CI', 4189, 42.49170000000, -71.51700000000, '106249'),
(10878, 'US-VA-106250', 'Atkins', 'CI', 4218, 36.88360000000, -81.39190000000, '106250'),
(10879, 'US-MT-106251', 'Miles City', 'CI', 4194, 46.22220000000, -105.60500000000, '106251'),
(10880, 'US-NV-106252', 'Pahrump', 'CI', 4196, 36.36380000000, -116.15000000000, '106252'),
(10881, 'US-SD-106253', 'Madison', 'CI', 4212, 43.98580000000, -97.17920000000, '106253'),
(10882, 'US-NY-106254', 'Champlain', 'CI', 4200, 44.96070000000, -73.43600000000, '106254'),
(10883, 'US-NV-106255', 'Winnemucca', 'CI', 4196, 41.12160000000, -118.05370000000, '106255'),
(10884, 'US-UT-106256', 'Hurricane', 'CI', 4215, 37.13850000000, -112.97900000000, '106256'),
(10885, 'US-UT-106257', 'Beaver', 'CI', 4215, 38.38150000000, -112.66340000000, '106257'),
(10886, 'US-CA-106258', 'South Gate', 'CI', 4169, 33.94850000000, -118.20170000000, '106258'),
(10887, 'US-NY-106259', 'East Elmhurst', 'CI', 4200, 40.76380000000, -73.87090000000, '106259'),
(10888, 'US-NV-106260', 'Mesquite', 'CI', 4196, 36.78890000000, -114.14310000000, '106260'),
(10889, 'US-TX-106261', 'Cedar Park', 'CI', 4214, 30.49980000000, -97.80820000000, '106261'),
(10890, 'US-ID-106262', 'Grangeville', 'CI', 4179, 45.90350000000, -116.13870000000, '106262'),
(10891, 'US-ID-106263', 'Nezperce', 'CI', 4179, 46.28260000000, -116.23200000000, '106263'),
(10892, 'US-ID-106264', 'Athol', 'CI', 4179, 47.96760000000, -116.68090000000, '106264'),
(10893, 'US-ID-106265', 'Sandpoint', 'CI', 4179, 48.34320000000, -116.45360000000, '106265'),
(10894, 'US-OR-106266', 'Pendleton', 'CI', 4206, 45.73540000000, -118.79770000000, '106266'),
(10895, 'US-ID-106267', 'Meridian', 'CI', 4179, 43.59920000000, -116.42340000000, '106267'),
(10896, 'US-OR-106268', 'Hermiston', 'CI', 4206, 45.85040000000, -119.21300000000, '106268'),
(10897, 'US-WA-106269', 'Kennewick', 'CI', 4219, 46.21310000000, -119.16820000000, '106269'),
(10898, 'US-ID-106270', 'Kooskia', 'CI', 4179, 46.08570000000, -115.86280000000, '106270'),
(10899, 'US-WA-106271', 'Pullman', 'CI', 4219, 46.73220000000, -117.24550000000, '106271'),
(10900, 'US-WA-106272', 'Kirkland', 'CI', 4219, 47.67270000000, -122.18730000000, '106272'),
(10901, 'US-PA-106273', 'Pulaski', 'CI', 4208, 41.10250000000, -80.45170000000, '106273'),
(10902, 'US-AK-106274', 'Nuiqsut', 'CI', 4162, 69.83270000000, -152.14890000000, '106274'),
(10903, 'US-WA-106275', 'Enumclaw', 'CI', 4219, 47.10600000000, -121.60290000000, '106275'),
(10904, 'US-MA-106276', 'Clinton', 'CI', 4189, 42.41360000000, -71.69130000000, '106276'),
(10905, 'US-RI-106277', 'Newport', 'CI', 4210, 41.48510000000, -71.30750000000, '106277'),
(10906, 'US-PA-106278', 'Canonsburg', 'CI', 4208, 40.27130000000, -80.17020000000, '106278'),
(10907, 'US-WA-106279', 'Sultan', 'CI', 4219, 47.85590000000, -121.73970000000, '106279'),
(10908, 'US-MD-106280', 'Hanover', 'CI', 4188, 39.17580000000, -76.72980000000, '106280'),
(10909, 'US-MD-106281', 'Belcamp', 'CI', 4188, 39.47520000000, -76.23680000000, '106281'),
(10910, 'US-MD-106282', 'Saint Michaels', 'CI', 4188, 38.79930000000, -76.23340000000, '106282'),
(10911, 'US-IL-106283', 'Venice', 'CI', 4180, 38.67030000000, -90.17040000000, '106283'),
(10912, 'US-MD-106284', 'Rising Sun', 'CI', 4188, 39.67170000000, -76.05460000000, '106284'),
(10913, 'US-ND-106285', 'Fort Yates', 'CI', 4202, 46.10350000000, -100.70290000000, '106285'),
(10914, 'US-CA-106286', 'Cerritos', 'CI', 4169, 33.86610000000, -118.05280000000, '106286'),
(10915, 'US-FL-106287', 'Tallahassee', 'CI', 4175, 30.58020000000, -84.12660000000, '106287'),
(10916, 'US-FL-106288', 'Newberry', 'CI', 4175, 29.63130000000, -82.58140000000, '106288'),
(10917, 'US-GA-106289', 'Rincon', 'CI', 4176, 32.29230000000, -81.21820000000, '106289'),
(10918, 'US-FL-106290', 'Midway', 'CI', 4175, 30.49240000000, -84.44730000000, '106290'),
(10919, 'US-SC-106291', 'Columbia', 'CI', 4211, 33.93560000000, -80.95240000000, '106291'),
(10920, 'US-PA-106292', 'Wexford', 'CI', 4208, 40.62900000000, -80.07930000000, '106292'),
(10921, 'US-FL-106293', 'Ponte Vedra Beach', 'CI', 4175, 30.10230000000, -81.35320000000, '106293'),
(10922, 'US-GA-106294', 'Saint Simons Island', 'CI', 4176, 31.21630000000, -81.36660000000, '106294'),
(10923, 'US-FL-106295', 'Quincy', 'CI', 4175, 30.51170000000, -84.70510000000, '106295'),
(10924, 'US-WI-106296', 'Evansville', 'CI', 4221, 42.77010000000, -89.25010000000, '106296'),
(10925, 'US-WI-106297', 'Loganville', 'CI', 4221, 43.39310000000, -90.04570000000, '106297'),
(10926, 'US-TN-106298', 'Chattanooga', 'CI', 4213, 35.04860000000, -85.15500000000, '106298'),
(10927, 'US-IL-106299', 'Yates City', 'CI', 4180, 40.79490000000, -90.04300000000, '106299'),
(10928, 'US-CA-106300', 'Dana Point', 'CI', 4169, 33.47820000000, -117.70640000000, '106300'),
(10929, 'US-NY-106301', 'Yorktown Heights', 'CI', 4200, 41.28640000000, -73.79080000000, '106301'),
(10930, 'US-FL-106302', 'Green Cove Springs', 'CI', 4175, 29.94300000000, -81.74330000000, '106302'),
(10931, 'US-FL-106303', 'Port Saint Joe', 'CI', 4175, 29.84090000000, -85.26900000000, '106303'),
(10932, 'US-WI-106304', 'Kenosha', 'CI', 4221, 42.62270000000, -87.93770000000, '106304'),
(10933, 'US-IL-106305', 'North Aurora', 'CI', 4180, 41.80440000000, -88.34700000000, '106305'),
(10934, 'US-GA-106306', 'Reidsville', 'CI', 4176, 32.01780000000, -82.09660000000, '106306'),
(10935, 'US-GA-106307', 'Winder', 'CI', 4176, 33.98460000000, -83.69780000000, '106307'),
(10936, 'US-GA-106308', 'Douglas', 'CI', 4176, 31.46480000000, -82.86080000000, '106308'),
(10937, 'US-VA-106309', 'Charlottesville', 'CI', 4218, 38.09800000000, -78.39660000000, '106309'),
(10938, 'US-FL-106310', 'Blountstown', 'CI', 4175, 30.41340000000, -85.06780000000, '106310'),
(10939, 'US-FL-106311', 'Caryville', 'CI', 4175, 30.72070000000, -85.80290000000, '106311'),
(10940, 'US-NJ-106312', 'Englewood Cliffs', 'CI', 4198, 40.89150000000, -73.94710000000, '106312'),
(10941, 'US-OR-106313', 'Tualatin', 'CI', 4206, 45.36530000000, -122.75790000000, '106313'),
(10942, 'US-SC-106314', 'Gaffney', 'CI', 4211, 35.09940000000, -81.70480000000, '106314'),
(10943, 'US-OR-106315', 'Florence', 'CI', 4206, 44.12130000000, -124.00230000000, '106315'),
(10944, 'US-WA-106316', 'Battle Ground', 'CI', 4219, 45.80810000000, -122.48160000000, '106316'),
(10945, 'US-OR-106317', 'Sandy', 'CI', 4206, 45.38430000000, -122.17500000000, '106317'),
(10946, 'US-OK-106318', 'Guymon', 'CI', 4205, 36.74770000000, -101.51560000000, '106318'),
(10947, 'US-OR-106319', 'Coos Bay', 'CI', 4206, 43.37400000000, -124.14770000000, '106319'),
(10948, 'US-OR-106320', 'Reedsport', 'CI', 4206, 43.79170000000, -123.90780000000, '106320'),
(10949, 'US-NY-106321', 'East Meadow', 'CI', 4200, 40.72250000000, -73.55680000000, '106321'),
(10950, 'US-IL-106322', 'Lake Bluff', 'CI', 4180, 42.28530000000, -87.87000000000, '106322'),
(10951, 'US-OR-106323', 'Springfield', 'CI', 4206, 44.05800000000, -123.00630000000, '106323'),
(10952, 'US-OR-106324', 'Glide', 'CI', 4206, 43.24540000000, -123.00000000000, '106324'),
(10953, 'US-OR-106325', 'Sherwood', 'CI', 4206, 45.35520000000, -122.86150000000, '106325'),
(10954, 'US-NJ-106326', 'New Providence', 'CI', 4198, 40.69730000000, -74.40520000000, '106326'),
(10955, 'US-PA-106327', 'Meshoppen', 'CI', 4208, 41.67190000000, -76.02270000000, '106327'),
(10956, 'US-OR-106328', 'Fairview', 'CI', 4206, 45.54460000000, -122.44590000000, '106328'),
(10957, 'US-PA-106329', 'Edgemont', 'CI', 4208, 39.93400000000, -75.40600000000, '106329'),
(10958, 'US-PA-106330', 'Kennett Square', 'CI', 4208, 39.86710000000, -75.71190000000, '106330'),
(10959, 'US-PA-106331', 'Boyertown', 'CI', 4208, 40.34680000000, -75.68090000000, '106331'),
(10960, 'US-NJ-106332', 'Hackettstown', 'CI', 4198, 40.86690000000, -74.82200000000, '106332'),
(10961, 'US-PA-106333', 'Glen Mills', 'CI', 4208, 39.90560000000, -75.48740000000, '106333'),
(10962, 'US-CA-106334', 'Dinuba', 'CI', 4169, 36.52370000000, -119.39530000000, '106334'),
(10963, 'US-NY-106335', 'Central Valley', 'CI', 4200, 41.32370000000, -74.12310000000, '106335'),
(10964, 'US-PA-106336', 'Concordville', 'CI', 4208, 39.88010000000, -75.51980000000, '106336'),
(10965, 'US-OH-106337', 'Mount Hope', 'CI', 4204, 40.62210000000, -81.78770000000, '106337'),
(10966, 'US-IL-106338', 'Rockford', 'CI', 4180, 42.34230000000, -89.08160000000, '106338'),
(10967, 'US-ID-106339', 'Coeur D Alene', 'CI', 4179, 47.59240000000, -116.91190000000, '106339'),
(10968, 'US-NJ-106340', 'Roseland', 'CI', 4198, 40.82220000000, -74.30450000000, '106340'),
(10969, 'US-PA-106341', 'Stockertown', 'CI', 4208, 40.75790000000, -75.26140000000, '106341'),
(10970, 'US-VA-106342', 'Earlysville', 'CI', 4218, 38.15700000000, -78.49480000000, '106342'),
(10971, 'US-PA-106343', 'New Hope', 'CI', 4208, 40.35620000000, -74.99870000000, '106343'),
(10972, 'US-PA-106344', 'Blandon', 'CI', 4208, 40.45630000000, -75.87940000000, '106344'),
(10973, 'US-PA-106345', 'Doylestown', 'CI', 4208, 40.33210000000, -75.11790000000, '106345'),
(10974, 'US-PA-106346', 'Morgantown', 'CI', 4208, 40.17210000000, -75.89550000000, '106346'),
(10975, 'US-PA-106347', 'Marcus Hook', 'CI', 4208, 39.84310000000, -75.46620000000, '106347'),
(10976, 'US-PA-106348', 'Catasauqua', 'CI', 4208, 40.65630000000, -75.46610000000, '106348'),
(10977, 'US-PA-106349', 'Honey Brook', 'CI', 4208, 40.07990000000, -75.86930000000, '106349'),
(10978, 'US-NJ-106350', 'Branchville', 'CI', 4198, 41.12830000000, -74.67900000000, '106350'),
(10979, 'US-CA-106351', 'Santa Rosa', 'CI', 4169, 38.50210000000, -122.76190000000, '106351'),
(10980, 'US-PA-106352', 'Fort Washington', 'CI', 4208, 40.13700000000, -75.20620000000, '106352'),
(10981, 'US-MI-106353', 'Hillsdale', 'CI', 4190, 41.86190000000, -84.60380000000, '106353'),
(10982, 'US-IN-106354', 'Goshen', 'CI', 4181, 41.55950000000, -85.85420000000, '106354'),
(10983, 'US-KY-106355', 'Russellville', 'CI', 4184, 36.87360000000, -86.87490000000, '106355'),
(10984, 'US-OH-106356', 'Napoleon', 'CI', 4204, 41.40070000000, -84.13310000000, '106356');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(10985, 'US-OH-106357', 'Millbury', 'CI', 4204, 41.57010000000, -83.43030000000, '106357'),
(10986, 'US-MI-106358', 'Chelsea', 'CI', 4190, 42.31370000000, -84.02370000000, '106358'),
(10987, 'US-OH-106359', 'Stryker', 'CI', 4204, 41.48790000000, -84.39190000000, '106359'),
(10988, 'US-MI-106360', 'Dexter', 'CI', 4190, 42.35410000000, -83.89670000000, '106360'),
(10989, 'US-MI-106361', 'Plymouth', 'CI', 4190, 42.36550000000, -83.53670000000, '106361'),
(10990, 'US-OH-106362', 'Fremont', 'CI', 4204, 41.35980000000, -83.12550000000, '106362'),
(10991, 'US-MI-106363', 'Ypsilanti', 'CI', 4190, 42.20610000000, -83.62280000000, '106363'),
(10992, 'US-MI-106364', 'Jonesville', 'CI', 4190, 42.01540000000, -84.60860000000, '106364'),
(10993, 'US-MI-106365', 'Grass Lake', 'CI', 4190, 42.28970000000, -84.18410000000, '106365'),
(10994, 'US-MD-106366', 'White Marsh', 'CI', 4188, 39.39020000000, -76.40650000000, '106366'),
(10995, 'US-MI-106367', 'Canton', 'CI', 4190, 42.32910000000, -83.48770000000, '106367'),
(10996, 'US-MI-106368', 'Adrian', 'CI', 4190, 41.89340000000, -84.06590000000, '106368'),
(10997, 'US-OH-106369', 'Sandusky', 'CI', 4204, 41.40160000000, -82.73100000000, '106369'),
(10998, 'US-OH-106370', 'Pioneer', 'CI', 4204, 41.64490000000, -84.53420000000, '106370'),
(10999, 'US-OH-106371', 'Walbridge', 'CI', 4204, 41.56890000000, -83.50180000000, '106371'),
(11000, 'US-OH-106372', 'Defiance', 'CI', 4204, 41.36060000000, -84.37010000000, '106372'),
(11001, 'US-OH-106373', 'Northwood', 'CI', 4204, 41.59610000000, -83.44430000000, '106373'),
(11002, 'US-OH-106374', 'Perrysburg', 'CI', 4204, 41.52950000000, -83.56560000000, '106374'),
(11003, 'US-MI-106375', 'Walled Lake', 'CI', 4190, 42.55300000000, -83.48020000000, '106375'),
(11004, 'US-MI-106376', 'Litchfield', 'CI', 4190, 42.04640000000, -84.77250000000, '106376'),
(11005, 'US-PA-106377', 'Sewickley', 'CI', 4208, 40.57750000000, -80.15030000000, '106377'),
(11006, 'US-UT-106378', 'Sandy', 'CI', 4215, 40.57650000000, -111.89380000000, '106378'),
(11007, 'US-MI-106379', 'Blissfield', 'CI', 4190, 41.81300000000, -83.88150000000, '106379'),
(11008, 'US-MT-106380', 'Missoula', 'CI', 4194, 46.98460000000, -114.12130000000, '106380'),
(11009, 'US-CT-106381', 'Weston', 'CI', 4171, 41.22460000000, -73.37680000000, '106381'),
(11010, 'US-RI-106382', 'Lincoln', 'CI', 4210, 41.91710000000, -71.44230000000, '106382'),
(11011, 'US-NY-106383', 'Elmsford', 'CI', 4200, 41.06120000000, -73.82210000000, '106383'),
(11012, 'US-RI-106384', 'Central Falls', 'CI', 4210, 41.89000000000, -71.39410000000, '106384'),
(11013, 'US-NY-106385', 'Katonah', 'CI', 4200, 41.26400000000, -73.67000000000, '106385'),
(11014, 'US-WA-106386', 'Spokane', 'CI', 4219, 47.65670000000, -117.37850000000, '106386'),
(11015, 'US-CT-106387', 'Trumbull', 'CI', 4171, 41.25990000000, -73.20760000000, '106387'),
(11016, 'US-CT-106388', 'Stratford', 'CI', 4171, 41.17370000000, -73.13650000000, '106388'),
(11017, 'US-MA-106389', 'North Dartmouth', 'CI', 4189, 41.66230000000, -71.01070000000, '106389'),
(11018, 'US-NJ-106390', 'Avenel', 'CI', 4198, 40.58600000000, -74.27130000000, '106390'),
(11019, 'US-CT-106391', 'Madison', 'CI', 4171, 41.34330000000, -72.64130000000, '106391'),
(11020, 'US-CT-106392', 'Danbury', 'CI', 4171, 41.37810000000, -73.46910000000, '106392'),
(11021, 'US-CT-106393', 'Westport', 'CI', 4171, 41.14490000000, -73.34280000000, '106393'),
(11022, 'US-CT-106394', 'Guilford', 'CI', 4171, 41.33870000000, -72.69070000000, '106394'),
(11023, 'US-CT-106395', 'Oxford', 'CI', 4171, 41.42860000000, -73.14240000000, '106395'),
(11024, 'US-NJ-106396', 'East Rutherford', 'CI', 4198, 40.81320000000, -74.07380000000, '106396'),
(11025, 'US-CT-106397', 'Hamden', 'CI', 4171, 41.37450000000, -72.93960000000, '106397'),
(11026, 'US-CT-106398', 'Milford', 'CI', 4171, 41.22410000000, -73.05170000000, '106398'),
(11027, 'US-CT-106399', 'Seymour', 'CI', 4171, 41.38460000000, -73.09430000000, '106399'),
(11028, 'US-CT-106400', 'West Haven', 'CI', 4171, 41.27300000000, -72.95740000000, '106400'),
(11029, 'US-CT-106401', 'Redding', 'CI', 4171, 41.30220000000, -73.38830000000, '106401'),
(11030, 'US-CT-106402', 'Brookfield', 'CI', 4171, 41.46730000000, -73.38830000000, '106402'),
(11031, 'US-NY-106403', 'Lake Grove', 'CI', 4200, 40.85900000000, -73.12000000000, '106403'),
(11032, 'US-NY-106404', 'Ronkonkoma', 'CI', 4200, 40.81560000000, -73.11810000000, '106404'),
(11033, 'US-NY-106405', 'Commack', 'CI', 4200, 40.83930000000, -73.27970000000, '106405'),
(11034, 'US-NY-106406', 'Pleasantville', 'CI', 4200, 41.12520000000, -73.79150000000, '106406'),
(11035, 'US-NY-106407', 'Holbrook', 'CI', 4200, 40.79810000000, -73.06800000000, '106407'),
(11036, 'US-NY-106408', 'Rocky Point', 'CI', 4200, 40.93630000000, -72.93300000000, '106408'),
(11037, 'US-NY-106409', 'Bohemia', 'CI', 4200, 40.76990000000, -73.12630000000, '106409'),
(11038, 'US-NY-106410', 'Holtsville', 'CI', 4200, 40.81070000000, -73.04590000000, '106410'),
(11039, 'US-NY-106411', 'Yaphank', 'CI', 4200, 40.83280000000, -72.91100000000, '106411'),
(11040, 'US-NY-106412', 'Hampton Bays', 'CI', 4200, 40.88170000000, -72.53640000000, '106412'),
(11041, 'US-NY-106413', 'Calverton', 'CI', 4200, 40.91040000000, -72.76590000000, '106413'),
(11042, 'US-NY-106414', 'Patchogue', 'CI', 4200, 40.76990000000, -72.99940000000, '106414'),
(11043, 'US-NY-106415', 'Manorville', 'CI', 4200, 40.86740000000, -72.79430000000, '106415'),
(11044, 'US-NY-106416', 'Shoreham', 'CI', 4200, 40.94410000000, -72.88830000000, '106416'),
(11045, 'US-NY-106417', 'Bridgehampton', 'CI', 4200, 40.96230000000, -72.30620000000, '106417'),
(11046, 'US-CT-106418', 'Southbury', 'CI', 4171, 41.46750000000, -73.24060000000, '106418'),
(11047, 'US-CT-106419', 'New Britain', 'CI', 4171, 41.69030000000, -72.79070000000, '106419'),
(11048, 'US-CT-106420', 'Bridgeport', 'CI', 4171, 41.17230000000, -73.20140000000, '106420'),
(11049, 'US-NY-106421', 'Montgomery', 'CI', 4200, 41.53800000000, -74.28460000000, '106421'),
(11050, 'US-CT-106422', 'East Haven', 'CI', 4171, 41.28330000000, -72.86530000000, '106422'),
(11051, 'US-CT-106423', 'Clinton', 'CI', 4171, 41.29880000000, -72.53630000000, '106423'),
(11052, 'US-CT-106424', 'New Milford', 'CI', 4171, 41.61230000000, -73.41210000000, '106424'),
(11053, 'US-CT-106425', 'Sandy Hook', 'CI', 4171, 41.40470000000, -73.25040000000, '106425'),
(11054, 'US-CT-106426', 'Bethany', 'CI', 4171, 41.43230000000, -72.99330000000, '106426'),
(11055, 'US-NY-106427', 'Armonk', 'CI', 4200, 41.13090000000, -73.69420000000, '106427'),
(11056, 'US-NY-106428', 'Plainview', 'CI', 4200, 40.78200000000, -73.47390000000, '106428'),
(11057, 'US-CT-106429', 'Plainville', 'CI', 4171, 41.67380000000, -72.85440000000, '106429'),
(11058, 'US-PA-106430', 'Midland', 'CI', 4208, 40.67520000000, -80.50690000000, '106430'),
(11059, 'US-CT-106431', 'Windsor', 'CI', 4171, 41.86480000000, -72.68190000000, '106431'),
(11060, 'US-NY-106432', 'Larchmont', 'CI', 4200, 40.93340000000, -73.75630000000, '106432'),
(11061, 'US-CA-106433', 'Fontana', 'CI', 4169, 34.08810000000, -117.46480000000, '106433'),
(11062, 'US-CT-106434', 'Hartford', 'CI', 4171, 41.76860000000, -72.67450000000, '106434'),
(11063, 'US-CT-106435', 'Meriden', 'CI', 4171, 41.53720000000, -72.78010000000, '106435'),
(11064, 'US-CT-106436', 'Cromwell', 'CI', 4171, 41.60610000000, -72.66770000000, '106436'),
(11065, 'US-MA-106437', 'Great Barrington', 'CI', 4189, 42.16170000000, -73.32770000000, '106437'),
(11066, 'US-CT-106438', 'Norwich', 'CI', 4171, 41.55070000000, -72.09360000000, '106438'),
(11067, 'US-CT-106439', 'Bloomfield', 'CI', 4171, 41.85270000000, -72.73620000000, '106439'),
(11068, 'US-MA-106440', 'East Longmeadow', 'CI', 4189, 42.06200000000, -72.49890000000, '106440'),
(11069, 'US-MA-106441', 'Chicopee', 'CI', 4189, 42.18610000000, -72.52550000000, '106441'),
(11070, 'US-NY-106442', 'Mamaroneck', 'CI', 4200, 40.95210000000, -73.73820000000, '106442'),
(11071, 'US-CT-106443', 'West Hartford', 'CI', 4171, 41.76350000000, -72.72660000000, '106443'),
(11072, 'US-CT-106444', 'Wethersfield', 'CI', 4171, 41.70370000000, -72.66280000000, '106444'),
(11073, 'US-CT-106445', 'Groton', 'CI', 4171, 41.35320000000, -72.03860000000, '106445'),
(11074, 'US-CA-106446', 'Fairfield', 'CI', 4169, 38.28320000000, -122.00850000000, '106446'),
(11075, 'US-OH-106447', 'Saint Clairsville', 'CI', 4204, 40.09680000000, -80.91740000000, '106447'),
(11076, 'US-CT-106448', 'East Granby', 'CI', 4171, 41.93940000000, -72.73510000000, '106448'),
(11077, 'US-CT-106449', 'Middletown', 'CI', 4171, 41.54970000000, -72.65310000000, '106449'),
(11078, 'US-CT-106450', 'Waterbury', 'CI', 4171, 41.55140000000, -73.06520000000, '106450'),
(11079, 'US-CT-106451', 'Essex', 'CI', 4171, 41.35240000000, -72.39990000000, '106451'),
(11080, 'US-CT-106452', 'Windsor Locks', 'CI', 4171, 41.92350000000, -72.65570000000, '106452'),
(11081, 'US-MA-106453', 'Pittsfield', 'CI', 4189, 42.47280000000, -73.27440000000, '106453'),
(11083, 'US-NY-106455', 'Pound Ridge', 'CI', 4200, 41.20700000000, -73.56820000000, '106455'),
(11084, 'US-VA-106456', 'Mineral', 'CI', 4218, 37.93520000000, -77.88080000000, '106456'),
(11085, 'US-CA-106457', 'Monterey Park', 'CI', 4169, 34.05260000000, -118.11330000000, '106457'),
(11086, 'US-CA-106458', 'Belmont', 'CI', 4169, 37.50810000000, -122.30100000000, '106458'),
(11087, 'US-AK-106459', 'Elmendorf Afb', 'CI', 4162, 61.27550000000, -149.79240000000, '106459'),
(11088, 'US-NY-106460', 'Nyack', 'CI', 4200, 41.08610000000, -73.92850000000, '106460'),
(11089, 'US-FL-106461', 'Jay', 'CI', 4175, 30.86570000000, -86.98380000000, '106461'),
(11090, 'US-AK-106462', 'Wasilla', 'CI', 4162, 61.52350000000, -149.57480000000, '106462'),
(11091, 'US-AK-106463', 'Palmer', 'CI', 4162, 61.60920000000, -148.46570000000, '106463'),
(11092, 'US-IA-106464', 'Waverly', 'CI', 4182, 42.78040000000, -92.43630000000, '106464'),
(11093, 'US-AK-106465', 'Eagle River', 'CI', 4162, 61.21490000000, -149.25830000000, '106465'),
(11094, 'US-AL-106466', 'Madison', 'CI', 4161, 34.71350000000, -86.74210000000, '106466'),
(11095, 'US-OH-106467', 'Hamilton', 'CI', 4204, 39.42500000000, -84.49820000000, '106467'),
(11096, 'US-NY-106468', 'Lincolndale', 'CI', 4200, 41.34210000000, -73.72150000000, '106468'),
(11097, 'US-WA-106469', 'Yakima', 'CI', 4219, 46.59250000000, -120.53210000000, '106469'),
(11098, 'US-WA-106470', 'Mountlake Terrace', 'CI', 4219, 47.79360000000, -122.30730000000, '106470'),
(11099, 'US-WA-106471', 'Walla Walla', 'CI', 4219, 46.11070000000, -118.30770000000, '106471'),
(11100, 'US-GA-106472', 'Marietta', 'CI', 4176, 34.00170000000, -84.47100000000, '106472'),
(11101, 'US-GA-106473', 'Newnan', 'CI', 4176, 33.37340000000, -84.85410000000, '106473'),
(11102, 'US-CA-106474', 'City Of Industry', 'CI', 4169, 34.01300000000, -117.96720000000, '106474'),
(11103, 'US-CA-106475', 'Westminster', 'CI', 4169, 33.74740000000, -117.99390000000, '106475'),
(11104, 'US-MI-106476', 'Twin Lake', 'CI', 4190, 43.36720000000, -86.15940000000, '106476'),
(11105, 'US-GA-106477', 'Lithia Springs', 'CI', 4176, 33.76140000000, -84.63710000000, '106477'),
(11106, 'US-PA-106478', 'Claysville', 'CI', 4208, 40.10870000000, -80.41150000000, '106478'),
(11107, 'US-GA-106479', 'Decatur', 'CI', 4176, 33.77080000000, -84.29300000000, '106479'),
(11108, 'US-IA-106480', 'Fairfield', 'CI', 4182, 41.01660000000, -91.96820000000, '106480'),
(11109, 'US-IA-106481', 'Spirit Lake', 'CI', 4182, 43.42160000000, -95.09320000000, '106481'),
(11110, 'US-TX-106482', 'Pearland', 'CI', 4214, 29.54470000000, -95.33700000000, '106482'),
(11111, 'US-NE-106483', 'Grand Island', 'CI', 4195, 40.91040000000, -98.35070000000, '106483'),
(11112, 'US-NE-106484', 'Greeley', 'CI', 4195, 41.56040000000, -98.46680000000, '106484'),
(11113, 'US-SD-106485', 'Wall', 'CI', 4212, 44.13300000000, -102.21860000000, '106485'),
(11114, 'US-NE-106486', 'South Sioux City', 'CI', 4195, 42.45550000000, -96.45350000000, '106486'),
(11115, 'US-NC-106487', 'Cherryville', 'CI', 4201, 35.39450000000, -81.38880000000, '106487'),
(11116, 'US-SD-106488', 'Yankton', 'CI', 4212, 42.93590000000, -97.44050000000, '106488'),
(11117, 'US-NE-106489', 'Clay Center', 'CI', 4195, 40.52470000000, -98.01440000000, '106489'),
(11118, 'US-GA-106490', 'Americus', 'CI', 4176, 32.05350000000, -84.12230000000, '106490'),
(11119, 'US-OH-106491', 'Cincinnati', 'CI', 4204, 39.27480000000, -84.39860000000, '106491'),
(11120, 'US-OH-106492', 'Barnesville', 'CI', 4204, 39.98760000000, -81.16100000000, '106492'),
(11121, 'US-TN-106493', 'Knoxville', 'CI', 4213, 35.92170000000, -84.18290000000, '106493'),
(11122, 'US-CA-106494', 'La Quinta', 'CI', 4169, 33.65790000000, -116.27000000000, '106494'),
(11123, 'US-GA-106495', 'Smyrna', 'CI', 4176, 33.85670000000, -84.53510000000, '106495'),
(11124, 'US-GA-106496', 'Dalton', 'CI', 4176, 34.79820000000, -84.90820000000, '106496'),
(11125, 'US-CA-106497', 'Scotts Valley', 'CI', 4169, 37.06140000000, -122.01180000000, '106497'),
(11126, 'US-NY-106498', 'Long Island City', 'CI', 4200, 40.74000000000, -73.93610000000, '106498'),
(11127, 'US-GA-106499', 'Madison', 'CI', 4176, 33.59080000000, -83.47350000000, '106499'),
(11128, 'US-GA-106500', 'Newton', 'CI', 4176, 31.30320000000, -84.37030000000, '106500'),
(11130, 'US-FL-106502', 'Freeport', 'CI', 4175, 30.47110000000, -86.15520000000, '106502'),
(11131, 'US-GA-106503', 'Austell', 'CI', 4176, 33.78140000000, -84.58740000000, '106503'),
(11132, 'GB-E4-106504', 'Colchester', 'CI', 1422, 51.88330000000, 0.90000000000, '106504'),
(11133, 'US-CA-106505', 'San Ysidro', 'CI', 4169, 32.55530000000, -117.04380000000, '106505'),
(11134, 'US-CA-106506', 'Seal Beach', 'CI', 4169, 33.75760000000, -118.07770000000, '106506'),
(11135, 'US-CA-106507', 'Ontario', 'CI', 4169, 34.07780000000, -117.62610000000, '106507'),
(11136, 'US-CA-106508', 'Sun City', 'CI', 4169, 33.74150000000, -117.18890000000, '106508'),
(11137, 'US-CA-106509', 'Barstow', 'CI', 4169, 34.97010000000, -116.99290000000, '106509'),
(11138, 'US-CA-106510', 'Hemet', 'CI', 4169, 33.73610000000, -117.05830000000, '106510'),
(11139, 'US-CA-106511', 'Rialto', 'CI', 4169, 34.10200000000, -117.38680000000, '106511'),
(11140, 'US-MI-106512', 'Pontiac', 'CI', 4190, 42.63150000000, -83.29070000000, '106512'),
(11141, 'US-CA-106513', 'Upland', 'CI', 4169, 34.10400000000, -117.66420000000, '106513'),
(11142, 'US-CA-106514', 'Apple Valley', 'CI', 4169, 34.57760000000, -117.15920000000, '106514'),
(11143, 'US-CO-106515', 'Golden', 'CI', 4170, 39.71460000000, -105.24330000000, '106515'),
(11144, 'US-NE-106516', 'Jackson', 'CI', 4195, 42.45940000000, -96.61710000000, '106516'),
(11145, 'US-MS-106517', 'Scott', 'CI', 4192, 33.59870000000, -91.08010000000, '106517'),
(11146, 'US-CA-106518', 'Los Banos', 'CI', 4169, 36.90360000000, -121.02150000000, '106518'),
(11147, 'US-AL-106519', 'Daphne', 'CI', 4161, 30.60610000000, -87.85800000000, '106519'),
(11148, 'US-FL-106520', 'Delray Beach', 'CI', 4175, 26.45410000000, -80.10410000000, '106520'),
(11149, 'US-GA-106521', 'Douglasville', 'CI', 4176, 33.73500000000, -84.70210000000, '106521'),
(11150, 'US-GA-106522', 'Riverdale', 'CI', 4176, 33.55610000000, -84.45220000000, '106522'),
(11151, 'US-NY-106523', 'Farmingdale', 'CI', 4200, 40.73340000000, -73.42810000000, '106523'),
(11152, 'US-OH-106524', 'Steubenville', 'CI', 4204, 40.39680000000, -80.67490000000, '106524'),
(11153, 'US-CA-106525', 'Hawthorne', 'CI', 4169, 33.91290000000, -118.34390000000, '106525'),
(11154, 'US-CA-106526', 'Marina Del Rey', 'CI', 4169, 33.97770000000, -118.43510000000, '106526'),
(11155, 'US-WA-106527', 'Dayton', 'CI', 4219, 46.31090000000, -117.90040000000, '106527'),
(11156, 'US-NJ-106528', 'Belmar', 'CI', 4198, 40.16580000000, -74.07430000000, '106528'),
(11157, 'US-NJ-106529', 'Eatontown', 'CI', 4198, 40.30390000000, -74.07030000000, '106529'),
(11158, 'US-CA-106530', 'El Dorado Hills', 'CI', 4169, 38.68390000000, -121.05260000000, '106530'),
(11159, 'US-NY-106531', 'Weedsport', 'CI', 4200, 43.03510000000, -76.55520000000, '106531'),
(11160, 'US-TX-106532', 'Burnet', 'CI', 4214, 30.79700000000, -98.24450000000, '106532'),
(11161, 'PR-??-106533', 'Guaynabo', 'CI', 181, 18.42860000000, -66.11520000000, '106533'),
(11162, 'US-TX-106534', 'Laredo', 'CI', 4214, 27.74790000000, -99.59570000000, '106534'),
(11163, 'US-TX-106535', 'Schertz', 'CI', 4214, 29.58920000000, -98.29390000000, '106535'),
(11164, 'US-SC-106536', 'Huger', 'CI', 4211, 33.06080000000, -79.79270000000, '106536'),
(11165, 'US-KY-106537', 'Hazard', 'CI', 4184, 37.30920000000, -83.05680000000, '106537'),
(11166, 'US-IN-106538', 'Colfax', 'CI', 4181, 40.19230000000, -86.67370000000, '106538'),
(11167, 'US-KS-106539', 'Buhler', 'CI', 4183, 38.11920000000, -97.74690000000, '106539'),
(11168, 'US-MD-106540', 'Suitland', 'CI', 4188, 38.83240000000, -76.90840000000, '106540'),
(11169, 'US-CA-106541', 'Crows Landing', 'CI', 4169, 37.39890000000, -121.05740000000, '106541'),
(11170, 'US-TX-106542', 'Frisco', 'CI', 4214, 33.14990000000, -96.85550000000, '106542'),
(11171, 'US-TX-106543', 'Vidor', 'CI', 4214, 30.18210000000, -94.00980000000, '106543'),
(11172, 'US-TX-106544', 'Paris', 'CI', 4214, 33.62010000000, -95.60030000000, '106544'),
(11173, 'US-TX-106545', 'Texarkana', 'CI', 4214, 33.35270000000, -94.21870000000, '106545'),
(11174, 'US-KY-106546', 'Erlanger', 'CI', 4184, 39.01630000000, -84.59810000000, '106546'),
(11175, 'US-TX-106547', 'Kaufman', 'CI', 4214, 32.56860000000, -96.26760000000, '106547'),
(11176, 'US-TX-106548', 'Jacksboro', 'CI', 4214, 33.21890000000, -98.17280000000, '106548'),
(11177, 'US-KY-106549', 'Springfield', 'CI', 4184, 37.73000000000, -85.21470000000, '106549'),
(11178, 'US-IN-106550', 'Floyds Knobs', 'CI', 4181, 38.36200000000, -85.88920000000, '106550'),
(11179, 'US-IN-106551', 'Cedar Lake', 'CI', 4181, 41.36660000000, -87.46720000000, '106551'),
(11180, 'US-NJ-106552', 'Mount Arlington', 'CI', 4198, 40.91680000000, -74.63700000000, '106552'),
(11181, 'US-NJ-106553', 'Lincroft', 'CI', 4198, 40.34330000000, -74.12410000000, '106553'),
(11182, 'US-ME-106554', 'Rockport', 'CI', 4186, 44.17330000000, -69.12480000000, '106554'),
(11183, 'US-NY-106555', 'Maspeth', 'CI', 4200, 40.72480000000, -73.91150000000, '106555'),
(11184, 'US-MI-106556', 'Elk Rapids', 'CI', 4190, 44.91410000000, -85.39880000000, '106556'),
(11185, 'US-NY-106557', 'Garden City', 'CI', 4200, 40.72760000000, -73.63440000000, '106557'),
(11186, 'US-MI-106558', 'Mason', 'CI', 4190, 42.57970000000, -84.46030000000, '106558'),
(11187, 'US-NY-106559', 'Baldwin', 'CI', 4200, 40.65390000000, -73.60820000000, '106559'),
(11188, 'US-NJ-106560', 'Rochelle Park', 'CI', 4198, 40.90570000000, -74.07970000000, '106560'),
(11189, 'US-NY-106561', 'Stony Point', 'CI', 4200, 41.25440000000, -74.04030000000, '106561'),
(11190, 'DE-07-106562', 'Oelde', 'CI', 1078, 51.81670000000, 8.15000000000, '106562'),
(11191, 'US-NY-106563', 'Dobbs Ferry', 'CI', 4200, 41.01130000000, -73.86540000000, '106563'),
(11192, 'US-NY-106564', 'Orangeburg', 'CI', 4200, 41.04840000000, -73.96080000000, '106564'),
(11193, 'US-NY-106565', 'Tuxedo Park', 'CI', 4200, 41.20840000000, -74.21500000000, '106565'),
(11194, 'US-IL-106566', 'Glenview', 'CI', 4180, 42.08550000000, -87.82470000000, '106566'),
(11195, 'US-IL-106567', 'Gurnee', 'CI', 4180, 42.37380000000, -87.94400000000, '106567'),
(11196, 'US-IL-106568', 'Deerfield', 'CI', 4180, 42.17430000000, -87.88100000000, '106568'),
(11197, 'US-IL-106569', 'Waukegan', 'CI', 4180, 42.34790000000, -87.86710000000, '106569'),
(11198, 'US-VT-106570', 'Roxbury', 'CI', 4216, 44.05650000000, -72.74370000000, '106570'),
(11199, 'US-IL-106571', 'Park Ridge', 'CI', 4180, 42.01580000000, -87.84230000000, '106571'),
(11200, 'US-IL-106572', 'Evanston', 'CI', 4180, 42.05620000000, -87.70110000000, '106572'),
(11201, 'US-MI-106573', 'Boyne City', 'CI', 4190, 45.20110000000, -85.01200000000, '106573'),
(11202, 'US-IL-106574', 'Zion', 'CI', 4180, 42.45630000000, -87.87040000000, '106574'),
(11203, 'US-MI-106575', 'Nashville', 'CI', 4190, 42.58520000000, -85.11960000000, '106575'),
(11204, 'US-IL-106576', 'Winnetka', 'CI', 4180, 42.11370000000, -87.76090000000, '106576'),
(11205, 'US-IL-106577', 'Niles', 'CI', 4180, 42.03100000000, -87.81120000000, '106577'),
(11206, 'US-IL-106578', 'Bismarck', 'CI', 4180, 40.22660000000, -87.57680000000, '106578'),
(11207, 'US-MI-106579', 'Saint Charles', 'CI', 4190, 43.29110000000, -84.17070000000, '106579'),
(11208, 'US-NY-106580', 'Fishkill', 'CI', 4200, 41.52770000000, -73.90720000000, '106580'),
(11209, 'US-NY-106581', 'Purchase', 'CI', 4200, 41.03870000000, -73.71730000000, '106581'),
(11210, 'US-PA-106582', 'Plumsteadville', 'CI', 4208, 40.37850000000, -75.14520000000, '106582'),
(11211, 'US-LA-106583', 'Lena', 'CI', 4185, 31.42250000000, -92.81300000000, '106583'),
(11212, 'US-MS-106584', 'Vicksburg', 'CI', 4192, 32.35090000000, -90.87850000000, '106584'),
(11213, 'US-OH-106585', 'West Chester', 'CI', 4204, 39.33760000000, -84.40440000000, '106585'),
(11214, 'US-OH-106586', 'Lebanon', 'CI', 4204, 39.45430000000, -84.22580000000, '106586'),
(11215, 'US-IL-106587', 'North Chicago', 'CI', 4180, 42.31820000000, -87.85970000000, '106587'),
(11216, 'US-NY-106588', 'Skaneateles Falls', 'CI', 4200, 42.99490000000, -76.45290000000, '106588'),
(11217, 'US-FL-106589', 'Spring Hill', 'CI', 4175, 28.37750000000, -82.50050000000, '106589'),
(11218, 'US-NY-106590', 'Carmel', 'CI', 4200, 41.43240000000, -73.71670000000, '106590'),
(11219, 'US-NY-106591', 'Palisades', 'CI', 4200, 41.01780000000, -73.90900000000, '106591'),
(11220, 'US-NY-106592', 'Shrub Oak', 'CI', 4200, 41.32280000000, -73.83370000000, '106592'),
(11221, 'US-NY-106593', 'New Hampton', 'CI', 4200, 41.38040000000, -74.42960000000, '106593'),
(11222, 'US-IL-106594', 'Monticello', 'CI', 4180, 40.03290000000, -88.57650000000, '106594'),
(11223, 'US-IN-106595', 'West Lafayette', 'CI', 4181, 40.47630000000, -86.95710000000, '106595'),
(11224, 'US-MI-106596', 'Cadillac', 'CI', 4190, 44.25640000000, -85.53480000000, '106596'),
(11225, 'US-RI-106597', 'Middletown', 'CI', 4210, 41.51710000000, -71.27890000000, '106597'),
(11226, 'US-ME-106598', 'York', 'CI', 4186, 43.16370000000, -70.67500000000, '106598'),
(11227, 'US-CA-106599', 'Gilroy', 'CI', 4169, 37.06920000000, -121.55670000000, '106599'),
(11228, 'US-MI-106600', 'Manistee', 'CI', 4190, 44.20720000000, -86.19570000000, '106600'),
(11229, 'US-TX-106601', 'Kyle', 'CI', 4214, 29.98930000000, -97.85720000000, '106601'),
(11230, 'US-TX-106602', 'La Grange', 'CI', 4214, 29.94090000000, -96.87720000000, '106602'),
(11231, 'US-TX-106603', 'Bryan', 'CI', 4214, 30.65830000000, -96.32380000000, '106603'),
(11232, 'US-TX-106604', 'Waco', 'CI', 4214, 31.47890000000, -97.09260000000, '106604'),
(11233, 'US-AZ-106605', 'Gilbert', 'CI', 4164, 33.34620000000, -111.81530000000, '106605'),
(11234, 'US-TX-106606', 'Wimberley', 'CI', 4214, 30.02790000000, -98.11790000000, '106606'),
(11235, 'US-OH-106607', 'Sheffield Lake', 'CI', 4204, 41.45980000000, -82.09910000000, '106607'),
(11236, 'US-WA-106608', 'Poulsbo', 'CI', 4219, 47.75370000000, -122.61230000000, '106608'),
(11237, 'US-PA-106609', 'Newtown', 'CI', 4208, 40.26470000000, -74.95350000000, '106609'),
(11238, 'US-WA-106610', 'Mabton', 'CI', 4219, 46.15160000000, -120.09820000000, '106610'),
(11239, 'US-WA-106611', 'Mcchord Afb', 'CI', 4219, 47.12570000000, -122.55680000000, '106611'),
(11240, 'US-VA-106612', 'Milford', 'CI', 4218, 37.96650000000, -77.10580000000, '106612'),
(11241, 'US-WA-106613', 'Arlington', 'CI', 4219, 48.18530000000, -121.67780000000, '106613'),
(11242, 'US-MI-106614', 'Midland', 'CI', 4190, 43.61290000000, -84.19710000000, '106614'),
(11243, 'US-WI-106615', 'Pewaukee', 'CI', 4221, 43.08040000000, -88.25920000000, '106615'),
(11244, 'US-WA-106616', 'Bothell', 'CI', 4219, 47.84350000000, -122.19570000000, '106616'),
(11245, 'US-WA-106617', 'Hoquiam', 'CI', 4219, 47.11300000000, -123.96510000000, '106617'),
(11246, 'US-WA-106618', 'Chehalis', 'CI', 4219, 46.62710000000, -123.00920000000, '106618'),
(11247, 'US-WA-106619', 'Snoqualmie', 'CI', 4219, 47.53360000000, -121.79970000000, '106619'),
(11248, 'US-ME-106620', 'South Portland', 'CI', 4186, 43.62530000000, -70.29550000000, '106620'),
(11249, 'US-MA-106621', 'Hopkinton', 'CI', 4189, 42.22500000000, -71.53150000000, '106621'),
(11250, 'US-TX-106622', 'Rosharon', 'CI', 4214, 29.41850000000, -95.45250000000, '106622'),
(11251, 'US-WI-106623', 'Cudahy', 'CI', 4221, 42.94800000000, -87.86510000000, '106623'),
(11252, 'US-WI-106624', 'Fond Du Lac', 'CI', 4221, 43.75600000000, -88.36660000000, '106624'),
(11253, 'US-NY-106625', 'Ovid', 'CI', 4200, 42.68550000000, -76.80320000000, '106625'),
(11254, 'US-MI-106626', 'Jenison', 'CI', 4190, 42.91560000000, -85.84640000000, '106626'),
(11255, 'US-NJ-106627', 'Bridgewater', 'CI', 4198, 40.59530000000, -74.61730000000, '106627'),
(11256, 'US-NJ-106628', 'Woodbridge', 'CI', 4198, 40.55250000000, -74.29150000000, '106628'),
(11257, 'US-NJ-106629', 'Old Bridge', 'CI', 4198, 40.39580000000, -74.32550000000, '106629'),
(11258, 'US-NJ-106630', 'Ringoes', 'CI', 4198, 40.44070000000, -74.83390000000, '106630'),
(11259, 'US-NJ-106631', 'Raritan', 'CI', 4198, 40.57150000000, -74.64030000000, '106631'),
(11260, 'US-NY-106632', 'Lake Katrine', 'CI', 4200, 41.98800000000, -73.98990000000, '106632'),
(11261, 'US-NJ-106633', 'Warren', 'CI', 4198, 40.63080000000, -74.51220000000, '106633'),
(11262, 'US-FL-106634', 'Apopka', 'CI', 4175, 28.66160000000, -81.53070000000, '106634'),
(11263, 'US-NJ-106635', 'Keyport', 'CI', 4198, 40.44050000000, -74.17540000000, '106635'),
(11264, 'US-OK-106636', 'Sand Springs', 'CI', 4205, 36.07970000000, -96.21780000000, '106636'),
(11265, 'US-NJ-106637', 'Perth Amboy', 'CI', 4198, 40.52140000000, -74.27520000000, '106637'),
(11266, 'US-NJ-106638', 'Glen Gardner', 'CI', 4198, 40.71970000000, -74.90570000000, '106638'),
(11267, 'US-NJ-106639', 'Phillipsburg', 'CI', 4198, 40.69110000000, -75.17560000000, '106639'),
(11268, 'US-NJ-106640', 'Plainfield', 'CI', 4198, 40.61990000000, -74.42740000000, '106640'),
(11269, 'US-NJ-106641', 'Sayreville', 'CI', 4198, 40.46190000000, -74.35610000000, '106641'),
(11270, 'US-NJ-106642', 'Elizabeth', 'CI', 4198, 40.67280000000, -74.17900000000, '106642'),
(11271, 'US-NJ-106643', 'North Brunswick', 'CI', 4198, 40.43600000000, -74.48500000000, '106643'),
(11272, 'US-NJ-106644', 'Flemington', 'CI', 4198, 40.51700000000, -74.86800000000, '106644'),
(11273, 'US-CA-106645', 'San Luis Obispo', 'CI', 4169, 35.27900000000, -120.69680000000, '106645'),
(11274, 'US-NJ-106646', 'Keasbey', 'CI', 4198, 40.50990000000, -74.31160000000, '106646'),
(11275, 'US-NJ-106647', 'Baptistown', 'CI', 4198, 40.52070000000, -75.00920000000, '106647'),
(11276, 'US-NJ-106648', 'Red Bank', 'CI', 4198, 40.36030000000, -74.07280000000, '106648'),
(11277, 'US-CA-106649', 'Watsonville', 'CI', 4169, 36.95120000000, -121.72400000000, '106649'),
(11278, 'US-NJ-106650', 'Parlin', 'CI', 4198, 40.45920000000, -74.30200000000, '106650'),
(11279, 'US-MN-106651', 'Mankato', 'CI', 4191, 44.13080000000, -94.00000000000, '106651'),
(11280, 'US-NJ-106652', 'Hampton', 'CI', 4198, 40.66140000000, -74.96550000000, '106652'),
(11281, 'US-NJ-106653', 'South Amboy', 'CI', 4198, 40.48320000000, -74.28810000000, '106653'),
(11282, 'US-GA-106654', 'Union City', 'CI', 4176, 33.57200000000, -84.54470000000, '106654'),
(11283, 'US-GA-106655', 'Albany', 'CI', 4176, 31.59830000000, -84.21270000000, '106655'),
(11284, 'US-NY-106656', 'Congers', 'CI', 4200, 41.15310000000, -73.93690000000, '106656'),
(11285, 'US-VA-106657', 'Newport News', 'CI', 4218, 37.07360000000, -76.49360000000, '106657'),
(11286, 'US-NY-106658', 'Poughkeepsie', 'CI', 4200, 41.70380000000, -73.92180000000, '106658'),
(11287, 'US-WI-106659', 'Lake Geneva', 'CI', 4221, 42.57470000000, -88.39460000000, '106659'),
(11288, 'US-CT-106660', 'Glastonbury', 'CI', 4171, 41.70390000000, -72.54610000000, '106660'),
(11289, 'US-ME-106661', 'Falmouth', 'CI', 4186, 43.75160000000, -70.27930000000, '106661'),
(11291, 'US-CA-106663', 'Newman', 'CI', 4169, 37.28430000000, -121.20160000000, '106663'),
(11292, 'US-IL-106664', 'Hoffman Estates', 'CI', 4180, 42.07930000000, -88.22370000000, '106664'),
(11293, 'US-IL-106665', 'Harwood Heights', 'CI', 4180, 41.96380000000, -87.81670000000, '106665'),
(11294, 'US-IL-106666', 'Great Lakes', 'CI', 4180, 42.30960000000, -87.84670000000, '106666'),
(11295, 'US-RI-106667', 'Woonsocket', 'CI', 4210, 41.99800000000, -71.49410000000, '106667'),
(11296, 'US-CA-106668', 'Friant', 'CI', 4169, 37.02620000000, -119.69240000000, '106668'),
(11297, 'US-MI-106669', 'Marquette', 'CI', 4190, 46.62880000000, -87.47960000000, '106669'),
(11298, 'US-NY-106670', 'Willsboro', 'CI', 4200, 44.37650000000, -73.42320000000, '106670'),
(11299, 'US-NY-106671', 'Watervliet', 'CI', 4200, 42.73550000000, -73.72040000000, '106671'),
(11300, 'US-NY-106672', 'Queensbury', 'CI', 4200, 43.35230000000, -73.68980000000, '106672'),
(11301, 'US-NY-106673', 'Amsterdam', 'CI', 4200, 42.96940000000, -74.12240000000, '106673'),
(11302, 'US-TX-106674', 'Kerrville', 'CI', 4214, 30.04520000000, -99.16820000000, '106674'),
(11303, 'US-CA-106675', 'Compton', 'CI', 4169, 33.87990000000, -118.21330000000, '106675'),
(11304, 'US-CA-106676', 'Carson', 'CI', 4169, 33.82670000000, -118.26070000000, '106676'),
(11305, 'US-CA-106677', 'San Pedro', 'CI', 4169, 33.73520000000, -118.31500000000, '106677'),
(11306, 'US-CA-106678', 'Avalon', 'CI', 4169, 33.38900000000, -118.45480000000, '106678'),
(11307, 'US-CA-106679', 'La Palma', 'CI', 4169, 33.85080000000, -118.04360000000, '106679'),
(11308, 'US-CA-106680', 'Santa Fe Springs', 'CI', 4169, 33.92750000000, -118.06570000000, '106680'),
(11309, 'US-CA-106681', 'Gardena', 'CI', 4169, 33.89930000000, -118.31690000000, '106681'),
(11310, 'US-CA-106682', 'Los Alamitos', 'CI', 4169, 33.79700000000, -118.06240000000, '106682'),
(11311, 'US-CA-106683', 'Whittier', 'CI', 4169, 34.00690000000, -118.03150000000, '106683'),
(11312, 'US-VA-106684', 'Leon', 'CI', 4218, 38.43620000000, -78.15110000000, '106684'),
(11313, 'US-CA-106685', 'Lakewood', 'CI', 4169, 33.84460000000, -118.14650000000, '106685'),
(11314, 'US-AL-106686', 'Cullman', 'CI', 4161, 34.15430000000, -86.74740000000, '106686'),
(11315, 'US-CA-106687', 'Norwalk', 'CI', 4169, 33.90710000000, -118.07670000000, '106687'),
(11316, 'US-CA-106688', 'Redondo Beach', 'CI', 4169, 33.83100000000, -118.38750000000, '106688'),
(11317, 'US-MI-106689', 'Iron River', 'CI', 4190, 46.17100000000, -88.73710000000, '106689'),
(11318, 'US-ME-106690', 'Burnham', 'CI', 4186, 44.69290000000, -69.38460000000, '106690'),
(11319, 'US-WI-106691', 'Appleton', 'CI', 4221, 44.33850000000, -88.40420000000, '106691'),
(11320, 'US-WI-106692', 'Menomonee Falls', 'CI', 4221, 43.14860000000, -88.12460000000, '106692'),
(11321, 'US-WI-106693', 'Kewaskum', 'CI', 4221, 43.52660000000, -88.20140000000, '106693'),
(11322, 'US-WI-106694', 'New Berlin', 'CI', 4221, 42.97340000000, -88.10310000000, '106694'),
(11323, 'US-WI-106695', 'Oshkosh', 'CI', 4221, 43.96690000000, -88.52570000000, '106695'),
(11324, 'US-WI-106696', 'Pleasant Prairie', 'CI', 4221, 42.52920000000, -87.88450000000, '106696'),
(11325, 'US-TX-106697', 'Kilgore', 'CI', 4214, 32.38010000000, -94.87010000000, '106697'),
(11326, 'US-WI-106698', 'Green Bay', 'CI', 4221, 44.48890000000, -88.07040000000, '106698'),
(11327, 'US-IL-106699', 'Villa Park', 'CI', 4180, 41.88160000000, -87.97610000000, '106699'),
(11328, 'US-WI-106700', 'Oak Creek', 'CI', 4221, 42.88630000000, -87.88830000000, '106700'),
(11329, 'US-WI-106701', 'Thiensville', 'CI', 4221, 43.22140000000, -87.93940000000, '106701'),
(11330, 'US-WI-106702', 'Sheboygan Falls', 'CI', 4221, 43.74320000000, -87.85110000000, '106702'),
(11331, 'US-CA-106703', 'Exeter', 'CI', 4169, 36.28620000000, -119.03100000000, '106703'),
(11332, 'US-WI-106704', 'Sheboygan', 'CI', 4221, 43.70980000000, -87.74780000000, '106704'),
(11333, 'US-WI-106705', 'Bristol', 'CI', 4221, 42.55340000000, -88.02150000000, '106705'),
(11334, 'US-WI-106706', 'Oconomowoc', 'CI', 4221, 43.11600000000, -88.51910000000, '106706'),
(11335, 'US-WI-106707', 'West Bend', 'CI', 4221, 43.38400000000, -88.16370000000, '106707'),
(11336, 'US-WI-106708', 'Manitowoc', 'CI', 4221, 44.10990000000, -87.71000000000, '106708'),
(11337, 'US-WI-106709', 'New Franken', 'CI', 4221, 44.57010000000, -87.83330000000, '106709'),
(11338, 'US-WI-106710', 'Butler', 'CI', 4221, 43.10780000000, -88.07150000000, '106710'),
(11339, 'US-MI-106711', 'Houghton', 'CI', 4190, 47.15440000000, -88.64710000000, '106711'),
(11340, 'US-WI-106712', 'Greendale', 'CI', 4221, 42.93700000000, -87.99810000000, '106712'),
(11341, 'US-WI-106713', 'Redgranite', 'CI', 4221, 44.06930000000, -89.08910000000, '106713'),
(11342, 'US-WI-106714', 'Jefferson', 'CI', 4221, 42.97270000000, -88.71230000000, '106714'),
(11343, 'US-MI-106715', 'Three Rivers', 'CI', 4190, 41.97610000000, -85.64750000000, '106715'),
(11344, 'US-MI-106716', 'Ironwood', 'CI', 4190, 46.48230000000, -90.15400000000, '106716'),
(11345, 'US-MI-106717', 'Iron Mountain', 'CI', 4190, 45.92780000000, -87.99440000000, '106717'),
(11346, 'US-WI-106718', 'Crivitz', 'CI', 4221, 45.24740000000, -88.12590000000, '106718'),
(11347, 'US-NY-106719', 'Elmira', 'CI', 4200, 42.08300000000, -76.77620000000, '106719'),
(11348, 'US-WI-106720', 'Germantown', 'CI', 4221, 43.23580000000, -88.12710000000, '106720'),
(11349, 'US-WI-106721', 'Janesville', 'CI', 4221, 42.66740000000, -88.94550000000, '106721'),
(11350, 'US-WI-106722', 'Algoma', 'CI', 4221, 44.60690000000, -87.51740000000, '106722'),
(11351, 'US-CA-106723', 'Hanford', 'CI', 4169, 36.27600000000, -119.63220000000, '106723'),
(11352, 'US-WI-106724', 'Oconto', 'CI', 4221, 44.88590000000, -87.94070000000, '106724'),
(11353, 'US-MI-106725', 'Caspian', 'CI', 4190, 46.06680000000, -88.62770000000, '106725'),
(11354, 'US-CA-106726', 'Le Grand', 'CI', 4169, 37.25660000000, -120.20460000000, '106726'),
(11355, 'US-WI-106727', 'Port Washington', 'CI', 4221, 43.42660000000, -87.87320000000, '106727'),
(11356, 'US-WI-106728', 'Lake Mills', 'CI', 4221, 43.08450000000, -88.91860000000, '106728'),
(11357, 'US-WI-106729', 'Berlin', 'CI', 4221, 44.00790000000, -88.96660000000, '106729'),
(11358, 'US-GA-106730', 'Athens', 'CI', 4176, 33.90330000000, -83.33060000000, '106730'),
(11359, 'US-WI-106731', 'Mukwonago', 'CI', 4221, 42.88860000000, -88.33300000000, '106731'),
(11360, 'US-WI-106732', 'Fort Atkinson', 'CI', 4221, 42.89870000000, -88.79910000000, '106732'),
(11361, 'US-WI-106733', 'Sussex', 'CI', 4221, 43.14880000000, -88.24510000000, '106733'),
(11362, 'US-WI-106734', 'Salem', 'CI', 4221, 42.58020000000, -88.13740000000, '106734'),
(11363, 'US-WI-106735', 'East Troy', 'CI', 4221, 42.79450000000, -88.39940000000, '106735'),
(11364, 'US-CT-106736', 'Berlin', 'CI', 4171, 41.60340000000, -72.77630000000, '106736'),
(11365, 'US-NY-106737', 'Lewiston', 'CI', 4200, 43.17940000000, -78.98820000000, '106737'),
(11366, 'US-PA-106738', 'Brockway', 'CI', 4208, 41.25290000000, -78.85030000000, '106738'),
(11367, 'US-KY-106739', 'Carlisle', 'CI', 4184, 38.31210000000, -84.03230000000, '106739'),
(11368, 'US-NY-106740', 'Medina', 'CI', 4200, 43.21760000000, -78.36040000000, '106740'),
(11369, 'US-NY-106741', 'Lockport', 'CI', 4200, 43.17510000000, -78.73780000000, '106741'),
(11370, 'US-NY-106742', 'Wellsville', 'CI', 4200, 42.09080000000, -77.94770000000, '106742'),
(11371, 'US-PA-106743', 'Irvine', 'CI', 4208, 41.86650000000, -79.28340000000, '106743'),
(11372, 'US-PA-106744', 'Shippenville', 'CI', 4208, 41.25460000000, -79.46160000000, '106744'),
(11373, 'US-NY-106745', 'Holland', 'CI', 4200, 42.63330000000, -78.55130000000, '106745'),
(11374, 'US-NY-106746', 'Derby', 'CI', 4200, 42.69010000000, -78.99600000000, '106746'),
(11375, 'US-OH-106747', 'Brunswick', 'CI', 4204, 41.23880000000, -81.83150000000, '106747'),
(11376, 'US-PA-106748', 'Warren', 'CI', 4208, 41.81170000000, -79.26430000000, '106748'),
(11377, 'US-IL-106749', 'Belvidere', 'CI', 4180, 42.24910000000, -88.83310000000, '106749'),
(11378, 'US-NY-106750', 'Grand Island', 'CI', 4200, 43.01090000000, -78.95740000000, '106750'),
(11379, 'US-NY-106751', 'Angola', 'CI', 4200, 42.63260000000, -79.02780000000, '106751'),
(11380, 'US-NY-106752', 'Cherry Creek', 'CI', 4200, 42.31380000000, -79.14850000000, '106752'),
(11381, 'US-NY-106753', 'Cuba', 'CI', 4200, 42.22410000000, -78.29000000000, '106753'),
(11382, 'US-NY-106754', 'Fredonia', 'CI', 4200, 42.40800000000, -79.32410000000, '106754'),
(11383, 'US-MO-106755', 'Sikeston', 'CI', 4193, 36.89850000000, -89.56690000000, '106755'),
(11384, 'US-AR-106756', 'Jonesboro', 'CI', 4165, 35.88640000000, -90.64250000000, '106756'),
(11385, 'US-CA-106757', 'Kingsburg', 'CI', 4169, 36.48300000000, -119.50650000000, '106757'),
(11386, 'US-MO-106758', 'Jackson', 'CI', 4193, 37.43850000000, -89.63340000000, '106758'),
(11387, 'US-NY-106759', 'Richmondville', 'CI', 4200, 42.62070000000, -74.56930000000, '106759'),
(11388, 'US-IL-106760', 'Dupo', 'CI', 4180, 38.51910000000, -90.16760000000, '106760'),
(11389, 'US-NY-106761', 'Chatham', 'CI', 4200, 42.34780000000, -73.55490000000, '106761'),
(11390, 'US-MO-106762', 'Malden', 'CI', 4193, 36.56400000000, -89.96990000000, '106762'),
(11391, 'US-TX-106763', 'Pflugerville', 'CI', 4214, 30.44160000000, -97.59860000000, '106763'),
(11392, 'US-CA-106764', 'Buena Park', 'CI', 4169, 33.84170000000, -118.00760000000, '106764'),
(11393, 'US-MA-106765', 'Wellesley Hills', 'CI', 4189, 42.31170000000, -71.27220000000, '106765'),
(11394, 'US-CA-106766', 'Covina', 'CI', 4169, 34.07900000000, -117.84940000000, '106766'),
(11395, 'US-CA-106767', 'Rowland Heights', 'CI', 4169, 33.97820000000, -117.90400000000, '106767'),
(11396, 'US-TX-106768', 'Belton', 'CI', 4214, 31.04500000000, -97.50870000000, '106768'),
(11397, 'US-GA-106769', 'Lawrenceville', 'CI', 4176, 34.00910000000, -84.00880000000, '106769'),
(11398, 'US-CA-106770', 'Lake Elsinore', 'CI', 4169, 33.68480000000, -117.37240000000, '106770'),
(11399, 'US-CA-106771', 'Mission Viejo', 'CI', 4169, 33.60540000000, -117.66750000000, '106771'),
(11400, 'US-MD-106772', 'Chevy Chase', 'CI', 4188, 38.98420000000, -77.08420000000, '106772'),
(11401, 'US-WV-106773', 'Kearneysville', 'CI', 4220, 39.33910000000, -77.90370000000, '106773'),
(11402, 'US-MI-106774', 'Saint Joseph', 'CI', 4190, 42.05690000000, -86.45630000000, '106774'),
(11403, 'US-VA-106775', 'Middleburg', 'CI', 4218, 38.98430000000, -77.74890000000, '106775'),
(11404, 'US-MD-106776', 'New Market', 'CI', 4188, 39.41170000000, -77.27040000000, '106776'),
(11405, 'US-NJ-106777', 'Camden', 'CI', 4198, 39.93350000000, -75.10770000000, '106777'),
(11406, 'US-MD-106778', 'Beltsville', 'CI', 4188, 39.05040000000, -76.90550000000, '106778'),
(11407, 'US-WV-106779', 'Inwood', 'CI', 4220, 39.37960000000, -78.02020000000, '106779'),
(11408, 'US-MD-106780', 'Germantown', 'CI', 4188, 39.20700000000, -77.23800000000, '106780'),
(11409, 'US-MD-106781', 'Greenbelt', 'CI', 4188, 39.00270000000, -76.88070000000, '106781'),
(11410, 'US-VA-106782', 'Bluefield', 'CI', 4218, 37.22810000000, -81.30920000000, '106782'),
(11411, 'US-NC-106783', 'Whitsett', 'CI', 4201, 36.04130000000, -79.60640000000, '106783'),
(11412, 'US-NC-106784', 'Clemmons', 'CI', 4201, 36.00790000000, -80.36970000000, '106784'),
(11413, 'US-VA-106785', 'Duffield', 'CI', 4218, 36.73720000000, -82.80750000000, '106785'),
(11414, 'US-VA-106786', 'Bedford', 'CI', 4218, 37.32110000000, -79.52740000000, '106786'),
(11415, 'US-NC-106787', 'High Point', 'CI', 4201, 36.01620000000, -80.04340000000, '106787'),
(11416, 'US-WV-106788', 'Itmann', 'CI', 4220, 37.57440000000, -81.41990000000, '106788'),
(11417, 'US-VA-106789', 'Fincastle', 'CI', 4218, 37.51150000000, -79.88460000000, '106789'),
(11418, 'US-NC-106790', 'Eden', 'CI', 4201, 36.50540000000, -79.73940000000, '106790'),
(11419, 'US-OH-106791', 'Lithopolis', 'CI', 4204, 39.80450000000, -82.80830000000, '106791'),
(11420, 'US-VA-106792', 'Salem', 'CI', 4218, 37.29060000000, -80.10140000000, '106792'),
(11421, 'US-VA-106793', 'Coeburn', 'CI', 4218, 36.98100000000, -82.48860000000, '106793'),
(11422, 'US-NC-106794', 'Asheboro', 'CI', 4201, 35.66840000000, -79.80850000000, '106794'),
(11423, 'US-WV-106795', 'Bluefield', 'CI', 4220, 37.29420000000, -81.18320000000, '106795'),
(11424, 'US-NC-106796', 'Advance', 'CI', 4201, 35.94460000000, -80.43910000000, '106796'),
(11425, 'US-NC-106797', 'Burlington', 'CI', 4201, 35.98940000000, -79.50470000000, '106797'),
(11426, 'US-NC-106798', 'Troy', 'CI', 4201, 35.42730000000, -79.95820000000, '106798'),
(11427, 'US-WV-106799', 'Fenwick', 'CI', 4220, 38.22400000000, -80.62750000000, '106799'),
(11428, 'US-NC-106800', 'Kernersville', 'CI', 4201, 36.11720000000, -80.07650000000, '106800'),
(11429, 'US-WV-106801', 'Princeton', 'CI', 4220, 37.39100000000, -81.04170000000, '106801'),
(11430, 'US-VA-106802', 'Blacksburg', 'CI', 4218, 37.26690000000, -80.43250000000, '106802'),
(11431, 'US-VA-106803', 'Radford', 'CI', 4218, 37.08660000000, -80.54390000000, '106803'),
(11432, 'US-NC-106804', 'Mebane', 'CI', 4201, 36.13990000000, -79.26650000000, '106804'),
(11433, 'US-VA-106805', 'Christiansburg', 'CI', 4218, 37.10350000000, -80.42070000000, '106805'),
(11434, 'US-NC-106806', 'King', 'CI', 4201, 36.32200000000, -80.33790000000, '106806'),
(11435, 'US-NC-106807', 'Mount Airy', 'CI', 4201, 36.46170000000, -80.61910000000, '106807'),
(11436, 'US-OR-106808', 'Baker City', 'CI', 4206, 44.81410000000, -117.74530000000, '106808'),
(11437, 'US-TX-106809', 'Decatur', 'CI', 4214, 33.28590000000, -97.51270000000, '106809'),
(11438, 'US-NC-106810', 'Sandy Ridge', 'CI', 4201, 36.48020000000, -80.09720000000, '106810'),
(11439, 'US-VA-106811', 'Grundy', 'CI', 4218, 37.31370000000, -82.05220000000, '106811'),
(11440, 'US-NC-106812', 'West Jefferson', 'CI', 4201, 36.35460000000, -81.47280000000, '106812'),
(11441, 'US-NC-106813', 'Jefferson', 'CI', 4201, 36.39640000000, -81.39930000000, '106813'),
(11442, 'US-VA-106814', 'Wise', 'CI', 4218, 37.00240000000, -82.57720000000, '106814'),
(11443, 'US-VA-106815', 'Wytheville', 'CI', 4218, 36.94980000000, -81.12890000000, '106815'),
(11444, 'US-VA-106816', 'Martinsville', 'CI', 4218, 36.72660000000, -79.86670000000, '106816'),
(11445, 'US-VA-106817', 'Elliston', 'CI', 4218, 37.22650000000, -80.25370000000, '106817'),
(11446, 'US-VA-106818', 'South Boston', 'CI', 4218, 36.68820000000, -78.98820000000, '106818'),
(11447, 'US-NC-106819', 'Thomasville', 'CI', 4201, 35.85350000000, -80.10840000000, '106819'),
(11448, 'US-NC-106820', 'Welcome', 'CI', 4201, 35.90770000000, -80.25440000000, '106820'),
(11449, 'US-VA-106821', 'Rocky Mount', 'CI', 4218, 36.95180000000, -79.85920000000, '106821'),
(11450, 'US-VA-106822', 'Independence', 'CI', 4218, 36.64200000000, -81.16930000000, '106822'),
(11451, 'US-MA-106823', 'Newton Upper Falls', 'CI', 4189, 42.31270000000, -71.21870000000, '106823'),
(11452, 'US-MI-106824', 'Highland Park', 'CI', 4190, 42.41780000000, -83.10450000000, '106824'),
(11453, 'US-CA-106825', 'Salinas', 'CI', 4169, 36.64780000000, -121.62590000000, '106825'),
(11454, 'US-CA-106826', 'Reedley', 'CI', 4169, 36.65900000000, -119.40650000000, '106826'),
(11455, 'US-TN-106827', 'Pulaski', 'CI', 4213, 35.21410000000, -87.00970000000, '106827'),
(11456, 'US-CA-106828', 'Madera', 'CI', 4169, 36.91270000000, -120.19560000000, '106828'),
(11457, 'US-IN-106829', 'Bloomington', 'CI', 4181, 39.08360000000, -86.43210000000, '106829'),
(11458, 'US-CA-106830', 'Yosemite National Park', 'CI', 4169, 37.69120000000, -119.59150000000, '106830'),
(11459, 'US-VT-106831', 'Fairlee', 'CI', 4216, 43.91670000000, -72.18810000000, '106831'),
(11460, 'US-AL-106832', 'Auburn', 'CI', 4161, 32.53290000000, -85.50780000000, '106832'),
(11461, 'US-OH-106833', 'Beachwood', 'CI', 4204, 41.47960000000, -81.51100000000, '106833'),
(11462, 'US-OH-106834', 'Xenia', 'CI', 4204, 39.67800000000, -83.90270000000, '106834'),
(11463, 'US-HI-106835', 'Schofield Barracks', 'CI', 4178, 21.49530000000, -158.05800000000, '106835'),
(11464, 'US-CA-106836', 'Corcoran', 'CI', 4169, 36.07870000000, -119.53640000000, '106836'),
(11465, 'US-CA-106837', 'Parlier', 'CI', 4169, 36.62660000000, -119.51940000000, '106837'),
(11466, 'US-CA-106838', 'Porterville', 'CI', 4169, 35.96780000000, -118.91990000000, '106838'),
(11467, 'US-CA-106839', 'Soledad', 'CI', 4169, 36.39520000000, -121.30470000000, '106839'),
(11468, 'US-CA-106840', 'San Juan Bautista', 'CI', 4169, 36.83800000000, -121.51560000000, '106840'),
(11469, 'US-CA-106841', 'Carmel', 'CI', 4169, 36.46910000000, -121.82310000000, '106841'),
(11470, 'US-OH-106842', 'West Jefferson', 'CI', 4204, 39.93990000000, -83.30610000000, '106842'),
(11471, 'US-CA-106843', 'Fowler', 'CI', 4169, 36.62210000000, -119.67160000000, '106843'),
(11472, 'US-FL-106844', 'Stuart', 'CI', 4175, 27.17970000000, -80.24300000000, '106844'),
(11473, 'US-CA-106845', 'Roseville', 'CI', 4169, 38.74390000000, -121.25580000000, '106845'),
(11474, 'US-CA-106846', 'Colfax', 'CI', 4169, 39.09040000000, -120.92940000000, '106846'),
(11475, 'US-CA-106847', 'Granite Bay', 'CI', 4169, 38.76250000000, -121.16490000000, '106847'),
(11476, 'US-CA-106848', 'Yuba City', 'CI', 4169, 39.05290000000, -121.73290000000, '106848'),
(11477, 'US-CA-106849', 'Elk Grove', 'CI', 4169, 38.34450000000, -121.42930000000, '106849'),
(11478, 'US-NC-106850', 'Manson', 'CI', 4201, 36.46750000000, -78.30500000000, '106850'),
(11479, 'US-NC-106851', 'Pope A F B', 'CI', 4201, 35.17340000000, -79.01380000000, '106851'),
(11480, 'US-IL-106852', 'Bradley', 'CI', 4180, 41.14920000000, -87.86080000000, '106852'),
(11481, 'US-NC-106853', 'Roanoke Rapids', 'CI', 4201, 36.42900000000, -77.72470000000, '106853'),
(11482, 'US-NC-106854', 'Henderson', 'CI', 4201, 36.33010000000, -78.40830000000, '106854'),
(11483, 'US-NC-106855', 'Creedmoor', 'CI', 4201, 36.10520000000, -78.68680000000, '106855'),
(11484, 'US-NC-106856', 'New Hill', 'CI', 4201, 35.66580000000, -78.98400000000, '106856'),
(11485, 'US-NC-106857', 'Louisburg', 'CI', 4201, 36.09020000000, -78.21540000000, '106857'),
(11486, 'US-CA-106858', 'Tracy', 'CI', 4169, 37.69680000000, -121.39810000000, '106858'),
(11487, 'US-NC-106859', 'Siler City', 'CI', 4201, 35.71720000000, -79.44600000000, '106859'),
(11489, 'US-NC-106861', 'Smithfield', 'CI', 4201, 35.48130000000, -78.35140000000, '106861'),
(11490, 'US-NC-106862', 'Newport', 'CI', 4201, 34.77660000000, -76.88670000000, '106862'),
(11491, 'US-NC-106863', 'Boone', 'CI', 4201, 36.21910000000, -81.65630000000, '106863'),
(11492, 'US-NC-106864', 'Apex', 'CI', 4201, 35.71140000000, -78.88620000000, '106864'),
(11493, 'US-NC-106865', 'Cherry Point', 'CI', 4201, 34.90380000000, -76.90000000000, '106865'),
(11494, 'US-NC-106866', 'Shallotte', 'CI', 4201, 33.98140000000, -78.41210000000, '106866'),
(11495, 'US-CA-106867', 'Truckee', 'CI', 4169, 39.33380000000, -120.24900000000, '106867'),
(11496, 'US-NC-106868', 'Leland', 'CI', 4201, 34.24320000000, -78.09960000000, '106868'),
(11497, 'US-GA-106869', 'Lake Park', 'CI', 4176, 30.75190000000, -83.08560000000, '106869'),
(11498, 'US-NC-106870', 'Hope Mills', 'CI', 4201, 34.92730000000, -78.90930000000, '106870'),
(11499, 'US-NY-106871', 'Johnson City', 'CI', 4200, 42.16510000000, -76.00480000000, '106871'),
(11500, 'US-MA-106872', 'Maynard', 'CI', 4189, 42.42630000000, -71.45420000000, '106872'),
(11501, 'US-NC-106873', 'Sunset Beach', 'CI', 4201, 33.92690000000, -78.52190000000, '106873'),
(11502, 'US-NC-106874', 'Pinehurst', 'CI', 4201, 35.19360000000, -79.46130000000, '106874'),
(11503, 'US-VA-106875', 'Ruckersville', 'CI', 4218, 38.25500000000, -78.39180000000, '106875'),
(11504, 'US-PA-106876', 'Hollidaysburg', 'CI', 4208, 40.43680000000, -78.33150000000, '106876'),
(11505, 'US-CA-106877', 'Montebello', 'CI', 4169, 34.00920000000, -118.10830000000, '106877'),
(11506, 'US-MD-106878', 'Derwood', 'CI', 4188, 39.14350000000, -77.13880000000, '106878'),
(11507, 'US-CA-106879', 'Arcadia', 'CI', 4169, 34.13790000000, -118.02590000000, '106879'),
(11508, 'US-CA-106880', 'Redding', 'CI', 4169, 40.68720000000, -122.25930000000, '106880'),
(11509, 'US-NV-106881', 'Dayton', 'CI', 4196, 39.26430000000, -119.48040000000, '106881'),
(11510, 'US-CA-106882', 'Sheridan', 'CI', 4169, 38.98750000000, -121.35470000000, '106882'),
(11511, 'US-CA-106883', 'French Camp', 'CI', 4169, 37.86190000000, -121.29090000000, '106883'),
(11512, 'US-CA-106884', 'Davis', 'CI', 4169, 38.48290000000, -121.63980000000, '106884'),
(11513, 'US-NV-106885', 'Incline Village', 'CI', 4196, 39.24130000000, -119.92920000000, '106885'),
(11514, 'US-CA-106886', 'Brooks', 'CI', 4169, 38.80810000000, -122.18080000000, '106886'),
(11515, 'US-NV-106887', 'Zephyr Cove', 'CI', 4196, 39.00160000000, -119.93200000000, '106887'),
(11516, 'US-CA-106888', 'Arbuckle', 'CI', 4169, 39.02740000000, -122.04400000000, '106888'),
(11517, 'US-NY-106889', 'Malden Bridge', 'CI', 4200, 42.46510000000, -73.59380000000, '106889'),
(11518, 'US-NV-106890', 'Minden', 'CI', 4196, 39.01520000000, -119.75060000000, '106890'),
(11519, 'US-CA-106891', 'Dixon', 'CI', 4169, 38.39000000000, -121.81800000000, '106891'),
(11520, 'US-NV-106892', 'Genoa', 'CI', 4196, 39.01100000000, -119.84150000000, '106892'),
(11521, 'US-CA-106893', 'Citrus Heights', 'CI', 4169, 38.69320000000, -121.31160000000, '106893'),
(11522, 'US-CA-106894', 'Weaverville', 'CI', 4169, 40.74380000000, -122.93620000000, '106894'),
(11523, 'US-SC-106895', 'Georgetown', 'CI', 4211, 33.36150000000, -79.27590000000, '106895'),
(11524, 'US-MA-106896', 'Norwood', 'CI', 4189, 42.18180000000, -71.19620000000, '106896'),
(11525, 'US-GA-106897', 'Augusta', 'CI', 4176, 33.48040000000, -82.09410000000, '106897'),
(11526, 'US-SC-106898', 'Newberry', 'CI', 4211, 34.27670000000, -81.63650000000, '106898'),
(11527, 'US-SC-106899', 'Darlington', 'CI', 4211, 34.27770000000, -79.86260000000, '106899'),
(11528, 'US-SC-106900', 'West Columbia', 'CI', 4211, 33.93480000000, -81.14440000000, '106900'),
(11529, 'US-SC-106901', 'Florence', 'CI', 4211, 34.21250000000, -79.82060000000, '106901'),
(11530, 'US-SC-106902', 'Swansea', 'CI', 4211, 33.74580000000, -81.06650000000, '106902'),
(11531, 'US-SC-106903', 'Lexington', 'CI', 4211, 33.90750000000, -81.23010000000, '106903'),
(11532, 'US-SC-106904', 'Moncks Corner', 'CI', 4211, 33.11800000000, -80.03840000000, '106904'),
(11533, 'US-SC-106905', 'Laurens', 'CI', 4211, 34.49160000000, -82.05320000000, '106905'),
(11534, 'US-NV-106906', 'Stateline', 'CI', 4196, 38.97340000000, -119.90750000000, '106906'),
(11535, 'US-SC-106907', 'Pageland', 'CI', 4211, 34.74870000000, -80.41040000000, '106907');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(11536, 'US-SC-106908', 'Awendaw', 'CI', 4211, 33.00100000000, -79.68590000000, '106908'),
(11537, 'US-GA-106909', 'Grovetown', 'CI', 4176, 33.46210000000, -82.22200000000, '106909'),
(11538, 'US-SC-106910', 'Irmo', 'CI', 4211, 34.14220000000, -81.20470000000, '106910'),
(11539, 'US-FL-106911', 'New Port Richey', 'CI', 4175, 28.23970000000, -82.73880000000, '106911'),
(11540, 'US-SC-106912', 'Graniteville', 'CI', 4211, 33.57160000000, -81.84220000000, '106912'),
(11541, 'US-SC-106913', 'Orangeburg', 'CI', 4211, 33.48850000000, -80.85590000000, '106913'),
(11542, 'US-SC-106914', 'Ravenel', 'CI', 4211, 32.80730000000, -80.25840000000, '106914'),
(11543, 'US-TN-106915', 'Bristol', 'CI', 4213, 36.54060000000, -82.17570000000, '106915'),
(11544, 'US-SC-106916', 'Bamberg', 'CI', 4211, 33.25520000000, -81.00480000000, '106916'),
(11545, 'US-SC-106917', 'Early Branch', 'CI', 4211, 32.71800000000, -80.95990000000, '106917'),
(11546, 'US-GA-106918', 'Warrenton', 'CI', 4176, 33.40270000000, -82.65580000000, '106918'),
(11547, 'US-SC-106919', 'Lugoff', 'CI', 4211, 34.18730000000, -80.70640000000, '106919'),
(11548, 'US-SC-106920', 'Beaufort', 'CI', 4211, 32.43890000000, -80.74660000000, '106920'),
(11549, 'US-SC-106921', 'Anderson', 'CI', 4211, 34.43270000000, -82.62720000000, '106921'),
(11550, 'US-SC-106922', 'Due West', 'CI', 4211, 34.29160000000, -82.43170000000, '106922'),
(11551, 'US-SC-106923', 'Timmonsville', 'CI', 4211, 34.10970000000, -79.94270000000, '106923'),
(11552, 'US-NY-106924', 'Wallkill', 'CI', 4200, 41.61780000000, -74.10600000000, '106924'),
(11553, 'US-SC-106925', 'Pawleys Island', 'CI', 4211, 33.44250000000, -79.15880000000, '106925'),
(11554, 'US-SC-106926', 'Johns Island', 'CI', 4211, 32.67250000000, -80.09700000000, '106926'),
(11555, 'US-SC-106927', 'Andrews', 'CI', 4211, 33.44650000000, -79.62510000000, '106927'),
(11556, 'US-GA-106928', 'Thomson', 'CI', 4176, 33.49660000000, -82.52860000000, '106928'),
(11557, 'US-WA-106929', 'Camas', 'CI', 4219, 45.64520000000, -122.37890000000, '106929'),
(11558, 'US-WI-106930', 'Walworth', 'CI', 4221, 42.53880000000, -88.60220000000, '106930'),
(11559, 'US-CA-106931', 'Santa Cruz', 'CI', 4169, 37.04480000000, -122.10210000000, '106931'),
(11560, 'US-AL-106932', 'Robertsdale', 'CI', 4161, 30.61210000000, -87.56530000000, '106932'),
(11561, 'US-NV-106933', 'Sparks', 'CI', 4196, 39.53980000000, -119.73860000000, '106933'),
(11562, 'US-TX-106934', 'Rio Grande City', 'CI', 4214, 26.51060000000, -98.65340000000, '106934'),
(11563, 'US-AK-106935', 'Kodiak', 'CI', 4162, 57.15880000000, -154.08000000000, '106935'),
(11564, 'US-AK-106936', 'Fairbanks', 'CI', 4162, 64.81850000000, -147.72160000000, '106936'),
(11565, 'US-AK-106937', 'Ketchikan', 'CI', 4162, 55.61530000000, -131.58480000000, '106937'),
(11566, 'US-AK-106938', 'Barrow', 'CI', 4162, 71.28500000000, -156.78190000000, '106938'),
(11567, 'US-AK-106939', 'Girdwood', 'CI', 4162, 60.90260000000, -148.91910000000, '106939'),
(11568, 'US-NJ-106940', 'Rockaway', 'CI', 4198, 40.95900000000, -74.49730000000, '106940'),
(11569, 'US-NJ-106941', 'Florham Park', 'CI', 4198, 40.77470000000, -74.39800000000, '106941'),
(11570, 'US-NJ-106942', 'Budd Lake', 'CI', 4198, 40.88380000000, -74.75600000000, '106942'),
(11571, 'US-NJ-106943', 'Franklin', 'CI', 4198, 41.11310000000, -74.59160000000, '106943'),
(11572, 'US-PA-106944', 'Mahanoy City', 'CI', 4208, 40.84130000000, -76.10890000000, '106944'),
(11573, 'US-NE-106945', 'La Vista', 'CI', 4195, 41.17650000000, -96.06130000000, '106945'),
(11574, 'US-PA-106946', 'Moosic', 'CI', 4208, 41.36100000000, -75.67310000000, '106946'),
(11575, 'US-PA-106947', 'White Haven', 'CI', 4208, 41.09420000000, -75.75460000000, '106947'),
(11576, 'US-PA-106948', 'Clarks Summit', 'CI', 4208, 41.44860000000, -75.72800000000, '106948'),
(11577, 'US-PA-106949', 'Scranton', 'CI', 4208, 41.45030000000, -75.65820000000, '106949'),
(11578, 'US-NJ-106950', 'Randolph', 'CI', 4198, 40.84610000000, -74.59140000000, '106950'),
(11579, 'US-PA-106951', 'Tannersville', 'CI', 4208, 41.04630000000, -75.33660000000, '106951'),
(11580, 'US-NJ-106952', 'Denville', 'CI', 4198, 40.88410000000, -74.48630000000, '106952'),
(11581, 'US-PA-106953', 'Wilkes Barre', 'CI', 4208, 41.20290000000, -75.90270000000, '106953'),
(11582, 'US-NJ-106954', 'Montville', 'CI', 4198, 40.91170000000, -74.36310000000, '106954'),
(11583, 'US-NJ-106955', 'Chatham', 'CI', 4198, 40.72230000000, -74.40370000000, '106955'),
(11584, 'US-PA-106956', 'Center Valley', 'CI', 4208, 40.54490000000, -75.40260000000, '106956'),
(11585, 'US-NJ-106957', 'Caldwell', 'CI', 4198, 40.85490000000, -74.28590000000, '106957'),
(11586, 'US-SC-106958', 'Russellville', 'CI', 4211, 33.39800000000, -79.97480000000, '106958'),
(11587, 'US-MD-106959', 'Williamsport', 'CI', 4188, 39.57910000000, -77.82400000000, '106959'),
(11588, 'US-NJ-106960', 'Matawan', 'CI', 4198, 40.41690000000, -74.25790000000, '106960'),
(11589, 'US-PA-106961', 'Hamlin', 'CI', 4208, 41.44270000000, -75.25830000000, '106961'),
(11590, 'US-NJ-106962', 'Peapack', 'CI', 4198, 40.71160000000, -74.65940000000, '106962'),
(11592, 'US-NJ-106964', 'East Hanover', 'CI', 4198, 40.82400000000, -74.36870000000, '106964'),
(11593, 'US-NJ-106965', 'Whippany', 'CI', 4198, 40.82290000000, -74.41970000000, '106965'),
(11594, 'US-LA-106966', 'Abbeville', 'CI', 4185, 29.91240000000, -92.21100000000, '106966'),
(11595, 'US-ME-106967', 'Portland', 'CI', 4186, 43.65890000000, -70.26150000000, '106967'),
(11596, 'US-PA-106968', 'Lake Ariel', 'CI', 4208, 41.43490000000, -75.41240000000, '106968'),
(11597, 'US-WA-106969', 'Richland', 'CI', 4219, 46.32820000000, -119.32220000000, '106969'),
(11598, 'US-LA-106970', 'Houma', 'CI', 4185, 29.51720000000, -90.65810000000, '106970'),
(11599, 'US-NJ-106971', 'Basking Ridge', 'CI', 4198, 40.67610000000, -74.57300000000, '106971'),
(11600, 'US-CT-106972', 'East Hartford', 'CI', 4171, 41.77760000000, -72.62140000000, '106972'),
(11601, 'US-NJ-106973', 'Brookside', 'CI', 4198, 40.80000000000, -74.57160000000, '106973'),
(11602, 'US-IN-106974', 'La Porte', 'CI', 4181, 41.62060000000, -86.73410000000, '106974'),
(11603, 'US-PA-106975', 'Hazleton', 'CI', 4208, 40.93950000000, -75.96950000000, '106975'),
(11604, 'US-NJ-106976', 'Towaco', 'CI', 4198, 40.92580000000, -74.34780000000, '106976'),
(11605, 'US-VA-106977', 'Purcellville', 'CI', 4218, 39.17960000000, -77.73260000000, '106977'),
(11606, 'US-MD-106978', 'Olney', 'CI', 4188, 39.15350000000, -77.07530000000, '106978'),
(11607, 'US-MO-106979', 'Hawk Point', 'CI', 4193, 38.97970000000, -91.14760000000, '106979'),
(11608, 'US-PA-106980', 'Pottsville', 'CI', 4208, 40.68950000000, -76.19580000000, '106980'),
(11609, 'US-PA-106981', 'Towanda', 'CI', 4208, 41.72760000000, -76.46010000000, '106981'),
(11610, 'US-NJ-106982', 'Gladstone', 'CI', 4198, 40.70750000000, -74.70680000000, '106982'),
(11611, 'US-NJ-106983', 'Pine Brook', 'CI', 4198, 40.86580000000, -74.34020000000, '106983'),
(11612, 'US-NJ-106984', 'Madison', 'CI', 4198, 40.76270000000, -74.42080000000, '106984'),
(11613, 'US-NJ-106985', 'Sparta', 'CI', 4198, 41.05440000000, -74.61710000000, '106985'),
(11614, 'US-NY-106986', 'Huntington Station', 'CI', 4200, 40.81520000000, -73.36240000000, '106986'),
(11615, 'US-CT-106987', 'Darien', 'CI', 4171, 41.07530000000, -73.48100000000, '106987'),
(11616, 'US-TX-106988', 'Springtown', 'CI', 4214, 32.95590000000, -97.71440000000, '106988'),
(11617, 'US-TX-106989', 'Borger', 'CI', 4214, 35.68020000000, -101.43100000000, '106989'),
(11618, 'US-TX-106990', 'Hewitt', 'CI', 4214, 31.45070000000, -97.19090000000, '106990'),
(11620, 'US-TX-106992', 'Abilene', 'CI', 4214, 32.34180000000, -99.94140000000, '106992'),
(11621, 'US-TX-106993', 'Woodway', 'CI', 4214, 31.51050000000, -97.26450000000, '106993'),
(11622, 'US-TX-106994', 'Haltom City', 'CI', 4214, 32.80340000000, -97.26650000000, '106994'),
(11623, 'US-TX-106995', 'Westbrook', 'CI', 4214, 32.33660000000, -101.13230000000, '106995'),
(11624, 'US-TX-106996', 'Azle', 'CI', 4214, 32.90240000000, -97.58910000000, '106996'),
(11625, 'US-TX-106997', 'Wichita Falls', 'CI', 4214, 33.84660000000, -98.53010000000, '106997'),
(11626, 'US-TX-106998', 'Levelland', 'CI', 4214, 33.60670000000, -102.38720000000, '106998'),
(11627, 'US-TX-106999', 'Cleburne', 'CI', 4214, 32.28470000000, -97.53920000000, '106999'),
(11628, 'US-OK-107000', 'Hulbert', 'CI', 4205, 35.97090000000, -95.14410000000, '107000'),
(11629, 'US-OK-107001', 'Okmulgee', 'CI', 4205, 35.66020000000, -95.98840000000, '107001'),
(11630, 'US-TX-107002', 'Abernathy', 'CI', 4214, 33.88280000000, -101.88910000000, '107002'),
(11631, 'US-TX-107003', 'Cisco', 'CI', 4214, 32.39320000000, -99.01930000000, '107003'),
(11632, 'US-TX-107004', 'Haslet', 'CI', 4214, 32.98000000000, -97.38310000000, '107004'),
(11633, 'US-TX-107005', 'Lamesa', 'CI', 4214, 32.67390000000, -101.95010000000, '107005'),
(11634, 'US-OK-107006', 'Perry', 'CI', 4205, 36.30410000000, -97.28240000000, '107006'),
(11635, 'US-OK-107007', 'Jones', 'CI', 4205, 35.58930000000, -97.29590000000, '107007'),
(11636, 'US-PA-107008', 'Carnegie', 'CI', 4208, 40.40670000000, -80.11080000000, '107008'),
(11637, 'US-PA-107009', 'Uniontown', 'CI', 4208, 39.89370000000, -79.74920000000, '107009'),
(11638, 'US-MD-107010', 'Frostburg', 'CI', 4188, 39.64080000000, -78.96800000000, '107010'),
(11639, 'US-PA-107011', 'Ebensburg', 'CI', 4208, 40.50840000000, -78.78460000000, '107011'),
(11640, 'US-PA-107012', 'Latrobe', 'CI', 4208, 40.28370000000, -79.38210000000, '107012'),
(11641, 'US-PA-107013', 'New Florence', 'CI', 4208, 40.33830000000, -79.08380000000, '107013'),
(11642, 'US-PA-107014', 'Johnstown', 'CI', 4208, 40.29230000000, -78.98340000000, '107014'),
(11643, 'US-WV-107015', 'Weirton', 'CI', 4220, 40.42240000000, -80.57390000000, '107015'),
(11644, 'US-PA-107016', 'Portersville', 'CI', 4208, 40.94290000000, -80.14700000000, '107016'),
(11645, 'US-WV-107017', 'Rowlesburg', 'CI', 4220, 39.29940000000, -79.72280000000, '107017'),
(11646, 'US-PA-107018', 'Loyalhanna', 'CI', 4208, 40.31920000000, -79.35450000000, '107018'),
(11647, 'US-PA-107019', 'Ford City', 'CI', 4208, 40.71050000000, -79.47740000000, '107019'),
(11648, 'US-MD-107020', 'Grantsville', 'CI', 4188, 39.63920000000, -79.19700000000, '107020'),
(11649, 'US-PA-107021', 'Blairsville', 'CI', 4208, 40.47010000000, -79.20360000000, '107021'),
(11650, 'US-CT-107022', 'New Canaan', 'CI', 4171, 41.16250000000, -73.50210000000, '107022'),
(11651, 'US-PA-107023', 'Strasburg', 'CI', 4208, 39.96200000000, -76.17860000000, '107023'),
(11652, 'US-PA-107024', 'Oakmont', 'CI', 4208, 40.52120000000, -79.83370000000, '107024'),
(11653, 'US-NJ-107025', 'Woodcliff Lake', 'CI', 4198, 41.02990000000, -74.05480000000, '107025'),
(11654, 'US-IA-107026', 'Ames', 'CI', 4182, 42.03000000000, -93.59050000000, '107026'),
(11655, 'US-PA-107027', 'Titusville', 'CI', 4208, 41.62580000000, -79.69640000000, '107027'),
(11656, 'US-PA-107028', 'Hermitage', 'CI', 4208, 41.22920000000, -80.42440000000, '107028'),
(11657, 'US-PA-107029', 'Clairton', 'CI', 4208, 40.30100000000, -79.92420000000, '107029'),
(11658, 'US-PA-107030', 'Irwin', 'CI', 4208, 40.31780000000, -79.71770000000, '107030'),
(11659, 'US-PA-107031', 'Oil City', 'CI', 4208, 41.46710000000, -79.66730000000, '107031'),
(11660, 'US-PA-107032', 'Jamestown', 'CI', 4208, 41.51450000000, -80.44910000000, '107032'),
(11661, 'US-PA-107033', 'Lawrence', 'CI', 4208, 40.30340000000, -80.12260000000, '107033'),
(11662, 'US-PA-107034', 'Mars', 'CI', 4208, 40.69900000000, -80.03340000000, '107034'),
(11663, 'US-PA-107035', 'Washington', 'CI', 4208, 40.15820000000, -80.25530000000, '107035'),
(11664, 'US-PA-107036', 'Somerset', 'CI', 4208, 40.03790000000, -79.12040000000, '107036'),
(11665, 'US-WV-107037', 'Clarksburg', 'CI', 4220, 39.28240000000, -80.36870000000, '107037'),
(11666, 'US-PA-107038', 'Petrolia', 'CI', 4208, 41.04310000000, -79.77470000000, '107038'),
(11667, 'US-PA-107039', 'Meadville', 'CI', 4208, 41.64650000000, -80.17330000000, '107039'),
(11668, 'US-PA-107040', 'West Middlesex', 'CI', 4208, 41.15600000000, -80.48380000000, '107040'),
(11669, 'US-PA-107041', 'Linesville', 'CI', 4208, 41.65910000000, -80.41680000000, '107041'),
(11670, 'US-OH-107042', 'Newcomerstown', 'CI', 4204, 40.23670000000, -81.57340000000, '107042'),
(11671, 'US-MA-107043', 'Worcester', 'CI', 4189, 42.26180000000, -71.80280000000, '107043'),
(11672, 'US-OK-107044', 'Ada', 'CI', 4205, 34.80580000000, -96.70460000000, '107044'),
(11673, 'US-OK-107045', 'Newkirk', 'CI', 4205, 36.90480000000, -97.07730000000, '107045'),
(11674, 'US-OK-107046', 'Maysville', 'CI', 4205, 34.83720000000, -97.42300000000, '107046'),
(11675, 'US-KS-107047', 'Garden City', 'CI', 4183, 38.04390000000, -100.75610000000, '107047'),
(11676, 'US-TX-107048', 'Hereford', 'CI', 4214, 34.84230000000, -102.54460000000, '107048'),
(11677, 'US-OK-107049', 'Marlow', 'CI', 4205, 34.64510000000, -97.90360000000, '107049'),
(11678, 'US-OK-107050', 'Clinton', 'CI', 4205, 35.49380000000, -98.97650000000, '107050'),
(11679, 'US-OK-107051', 'Hooker', 'CI', 4205, 36.83200000000, -101.25050000000, '107051'),
(11680, 'US-OK-107052', 'Taloga', 'CI', 4205, 35.98580000000, -99.01660000000, '107052'),
(11681, 'US-OK-107053', 'Healdton', 'CI', 4205, 34.27450000000, -97.49230000000, '107053'),
(11682, 'US-OK-107054', 'Ratliff City', 'CI', 4205, 34.42840000000, -97.49250000000, '107054'),
(11683, 'US-NJ-107055', 'Riverdale', 'CI', 4198, 40.99250000000, -74.31230000000, '107055'),
(11684, 'US-OK-107056', 'Blair', 'CI', 4205, 34.79230000000, -99.26600000000, '107056'),
(11685, 'US-OK-107057', 'Tipton', 'CI', 4205, 34.49250000000, -99.08080000000, '107057'),
(11686, 'US-OK-107058', 'Edmond', 'CI', 4205, 35.61650000000, -97.47890000000, '107058'),
(11687, 'US-TX-107059', 'Brownwood', 'CI', 4214, 31.63930000000, -98.97700000000, '107059'),
(11688, 'US-NH-107060', 'Greenville', 'CI', 4197, 42.75190000000, -71.76150000000, '107060'),
(11689, 'US-IL-107061', 'Sycamore', 'CI', 4180, 42.01060000000, -88.66710000000, '107061'),
(11690, 'US-CA-107062', 'Valley Center', 'CI', 4169, 33.25810000000, -116.98210000000, '107062'),
(11691, 'US-CA-107063', 'Emeryville', 'CI', 4169, 37.83420000000, -122.28970000000, '107063'),
(11692, 'US-IL-107064', 'Danville', 'CI', 4180, 40.14900000000, -87.67230000000, '107064'),
(11693, 'US-MO-107065', 'Wright City', 'CI', 4193, 38.80080000000, -91.04870000000, '107065'),
(11694, 'US-IL-107066', 'Olney', 'CI', 4180, 38.70740000000, -88.08580000000, '107066'),
(11695, 'US-MO-107067', 'Hannibal', 'CI', 4193, 39.68340000000, -91.43640000000, '107067'),
(11696, 'US-IL-107068', 'Alton', 'CI', 4180, 38.94550000000, -90.12820000000, '107068'),
(11697, 'US-IL-107069', 'Breese', 'CI', 4180, 38.64640000000, -89.52250000000, '107069'),
(11698, 'US-MO-107070', 'Saint Peters', 'CI', 4193, 38.80220000000, -90.62700000000, '107070'),
(11699, 'US-IL-107071', 'Barry', 'CI', 4180, 39.71200000000, -91.01470000000, '107071'),
(11700, 'US-IL-107072', 'Auburn', 'CI', 4180, 39.58900000000, -89.75400000000, '107072'),
(11701, 'US-IL-107073', 'Newton', 'CI', 4180, 38.96530000000, -88.18360000000, '107073'),
(11702, 'US-MO-107074', 'Osage Beach', 'CI', 4193, 38.11220000000, -92.69010000000, '107074'),
(11703, 'US-IL-107075', 'Forsyth', 'CI', 4180, 39.93610000000, -88.95540000000, '107075'),
(11704, 'US-IL-107076', 'Claremont', 'CI', 4180, 38.75980000000, -87.95630000000, '107076'),
(11705, 'US-MO-107077', 'Macks Creek', 'CI', 4193, 37.98010000000, -92.95220000000, '107077'),
(11706, 'US-MO-107078', 'Hazelwood', 'CI', 4193, 38.78900000000, -90.38290000000, '107078'),
(11707, 'US-MO-107079', 'Shelbina', 'CI', 4193, 39.66650000000, -92.01480000000, '107079'),
(11708, 'US-IL-107080', 'Decatur', 'CI', 4180, 39.91550000000, -88.89180000000, '107080'),
(11709, 'US-IL-107081', 'Litchfield', 'CI', 4180, 39.17210000000, -89.69050000000, '107081'),
(11710, 'US-CO-107082', 'Brighton', 'CI', 4170, 39.95370000000, -104.80010000000, '107082'),
(11711, 'US-IL-107083', 'Marion', 'CI', 4180, 37.72290000000, -88.88520000000, '107083'),
(11712, 'US-IL-107084', 'Effingham', 'CI', 4180, 39.11910000000, -88.57020000000, '107084'),
(11713, 'US-IL-107085', 'Centralia', 'CI', 4180, 38.50320000000, -89.14970000000, '107085'),
(11714, 'US-IL-107086', 'Quincy', 'CI', 4180, 39.93150000000, -91.38400000000, '107086'),
(11715, 'US-MO-107087', 'Mexico', 'CI', 4193, 39.21930000000, -91.88600000000, '107087'),
(11716, 'US-IL-107088', 'Salem', 'CI', 4180, 38.63680000000, -88.91980000000, '107088'),
(11717, 'US-MO-107089', 'Linn', 'CI', 4193, 38.47350000000, -91.79530000000, '107089'),
(11718, 'US-MO-107090', 'Saint Charles', 'CI', 4193, 38.85940000000, -90.47580000000, '107090'),
(11719, 'US-VT-107091', 'Bennington', 'CI', 4216, 42.86260000000, -73.09980000000, '107091'),
(11720, 'US-MO-107092', 'Vandalia', 'CI', 4193, 39.30270000000, -91.50640000000, '107092'),
(11721, 'US-MO-107093', 'Chesterfield', 'CI', 4193, 38.63530000000, -90.66730000000, '107093'),
(11722, 'US-CO-107094', 'Nucla', 'CI', 4170, 38.34620000000, -108.44500000000, '107094'),
(11723, 'US-NJ-107095', 'Teterboro', 'CI', 4198, 40.85460000000, -74.06140000000, '107095'),
(11724, 'US-MA-107096', 'Westborough', 'CI', 4189, 42.26580000000, -71.61050000000, '107096'),
(11725, 'US-CO-107097', 'Wheat Ridge', 'CI', 4170, 39.77470000000, -105.10330000000, '107097'),
(11726, 'US-CO-107098', 'Henderson', 'CI', 4170, 39.88650000000, -104.88100000000, '107098'),
(11727, 'US-CO-107099', 'Aspen', 'CI', 4170, 39.15560000000, -106.74540000000, '107099'),
(11728, 'US-CO-107100', 'Avon', 'CI', 4170, 39.64020000000, -106.55100000000, '107100'),
(11729, 'US-NY-107101', 'Windham', 'CI', 4200, 42.32860000000, -74.26730000000, '107101'),
(11730, 'US-SD-107102', 'Pine Ridge', 'CI', 4212, 43.11460000000, -102.56940000000, '107102'),
(11731, 'US-NJ-107103', 'Clifton', 'CI', 4198, 40.87690000000, -74.14330000000, '107103'),
(11732, 'US-WI-107104', 'Slinger', 'CI', 4221, 43.32520000000, -88.26560000000, '107104'),
(11733, 'US-TX-107105', 'Freeport', 'CI', 4214, 28.94870000000, -95.46340000000, '107105'),
(11734, 'US-CA-107106', 'Canyon Country', 'CI', 4169, 34.40650000000, -118.40150000000, '107106'),
(11735, 'US-MA-107107', 'Rowe', 'CI', 4189, 42.68620000000, -72.92490000000, '107107'),
(11736, 'US-MA-107108', 'Westfield', 'CI', 4189, 42.17330000000, -72.77150000000, '107108'),
(11737, 'US-CA-107109', 'Mariposa', 'CI', 4169, 37.49860000000, -120.00920000000, '107109'),
(11738, 'US-CT-107110', 'North Branford', 'CI', 4171, 41.33860000000, -72.73910000000, '107110'),
(11739, 'US-CT-107111', 'Simsbury', 'CI', 4171, 41.86860000000, -72.82340000000, '107111'),
(11740, 'US-CA-107112', 'Grand Terrace', 'CI', 4169, 34.03230000000, -117.31420000000, '107112'),
(11741, 'US-CA-107113', 'Yucca Valley', 'CI', 4169, 34.15370000000, -116.41890000000, '107113'),
(11742, 'US-CA-107114', 'Indio', 'CI', 4169, 33.75570000000, -116.23300000000, '107114'),
(11743, 'US-CA-107115', 'Mira Loma', 'CI', 4169, 33.99050000000, -117.53110000000, '107115'),
(11744, 'US-GA-107116', 'Buford', 'CI', 4176, 34.12120000000, -84.02590000000, '107116'),
(11745, 'US-CA-107117', 'Palm Springs', 'CI', 4169, 33.81480000000, -116.65160000000, '107117'),
(11746, 'US-OK-107118', 'Elk City', 'CI', 4205, 35.39280000000, -99.45620000000, '107118'),
(11747, 'US-MA-107119', 'Agawam', 'CI', 4189, 42.06550000000, -72.62710000000, '107119'),
(11748, 'US-TX-107120', 'Zapata', 'CI', 4214, 26.91200000000, -99.17170000000, '107120'),
(11749, 'US-LA-107121', 'Scott', 'CI', 4185, 30.25160000000, -92.11820000000, '107121'),
(11750, 'US-TX-107122', 'Athens', 'CI', 4214, 32.12230000000, -95.92270000000, '107122'),
(11751, 'US-TX-107123', 'Malakoff', 'CI', 4214, 32.11050000000, -96.00160000000, '107123'),
(11752, 'US-TX-107124', 'Winnsboro', 'CI', 4214, 32.91570000000, -95.28050000000, '107124'),
(11753, 'US-PA-107125', 'Bloomsburg', 'CI', 4208, 41.05300000000, -76.47010000000, '107125'),
(11754, 'US-TX-107126', 'Desoto', 'CI', 4214, 32.60420000000, -96.86530000000, '107126'),
(11755, 'US-VA-107127', 'Moneta', 'CI', 4218, 37.20210000000, -79.62850000000, '107127'),
(11756, 'US-OR-107128', 'Gervais', 'CI', 4206, 45.11360000000, -122.94780000000, '107128'),
(11757, 'US-MA-107129', 'Wilbraham', 'CI', 4189, 42.13430000000, -72.42330000000, '107129'),
(11758, 'US-OR-107130', 'Saint Paul', 'CI', 4206, 45.20890000000, -122.96170000000, '107130'),
(11759, 'US-TX-107131', 'Wadsworth', 'CI', 4214, 28.84220000000, -95.87760000000, '107131'),
(11760, 'US-TX-107132', 'Mesquite', 'CI', 4214, 32.81950000000, -96.63380000000, '107132'),
(11761, 'US-TX-107133', 'Fairfield', 'CI', 4214, 31.80350000000, -96.08940000000, '107133'),
(11762, 'US-CA-107134', 'Lake Arrowhead', 'CI', 4169, 34.27260000000, -117.19680000000, '107134'),
(11763, 'US-NJ-107135', 'Paterson', 'CI', 4198, 40.91110000000, -74.14250000000, '107135'),
(11764, 'US-CT-107136', 'Farmington', 'CI', 4171, 41.72520000000, -72.82950000000, '107136'),
(11765, 'US-CT-107137', 'Old Lyme', 'CI', 4171, 41.35890000000, -72.33960000000, '107137'),
(11766, 'US-WI-107138', 'Sturgeon Bay', 'CI', 4221, 44.79160000000, -87.46700000000, '107138'),
(11767, 'US-CT-107139', 'Chester', 'CI', 4171, 41.40500000000, -72.48340000000, '107139'),
(11768, 'US-MA-107140', 'Deerfield', 'CI', 4189, 42.53880000000, -72.60310000000, '107140'),
(11769, 'US-WI-107141', 'Brodhead', 'CI', 4221, 42.60080000000, -89.36650000000, '107141'),
(11770, 'US-WI-107142', 'Tomah', 'CI', 4221, 43.97530000000, -90.48490000000, '107142'),
(11771, 'US-WI-107143', 'Middleton', 'CI', 4221, 43.11840000000, -89.52070000000, '107143'),
(11772, 'US-WI-107144', 'Eagle River', 'CI', 4221, 45.92030000000, -89.21860000000, '107144'),
(11773, 'US-WI-107145', 'Wisconsin Rapids', 'CI', 4221, 44.33600000000, -89.74030000000, '107145'),
(11774, 'US-WI-107146', 'La Crosse', 'CI', 4221, 43.79820000000, -91.12860000000, '107146'),
(11775, 'US-IL-107147', 'Freeport', 'CI', 4180, 42.32380000000, -89.62180000000, '107147'),
(11776, 'US-WI-107148', 'Mosinee', 'CI', 4221, 44.73500000000, -89.61000000000, '107148'),
(11777, 'US-WI-107149', 'Platteville', 'CI', 4221, 42.75260000000, -90.48910000000, '107149'),
(11778, 'US-WI-107150', 'Marshfield', 'CI', 4221, 44.62710000000, -90.19810000000, '107150'),
(11779, 'US-WI-107151', 'Sun Prairie', 'CI', 4221, 43.19460000000, -89.20250000000, '107151'),
(11780, 'US-WI-107152', 'Bancroft', 'CI', 4221, 44.30960000000, -89.54380000000, '107152'),
(11781, 'US-WI-107153', 'Neillsville', 'CI', 4221, 44.56010000000, -90.67080000000, '107153'),
(11782, 'US-WI-107154', 'Beloit', 'CI', 4221, 42.55840000000, -89.15990000000, '107154'),
(11783, 'US-WI-107155', 'Deerfield', 'CI', 4221, 43.05410000000, -89.09210000000, '107155'),
(11784, 'US-WI-107156', 'Portage', 'CI', 4221, 43.57750000000, -89.48270000000, '107156'),
(11785, 'US-WI-107157', 'Lodi', 'CI', 4221, 43.30830000000, -89.55020000000, '107157'),
(11786, 'US-CA-107158', 'Geyserville', 'CI', 4169, 38.74050000000, -123.13370000000, '107158'),
(11787, 'US-IL-107159', 'Byron', 'CI', 4180, 42.16250000000, -89.24770000000, '107159'),
(11788, 'US-WI-107160', 'Wausau', 'CI', 4221, 45.00330000000, -89.72560000000, '107160'),
(11789, 'US-WI-107161', 'Rothschild', 'CI', 4221, 44.88430000000, -89.61790000000, '107161'),
(11790, 'US-WI-107162', 'Stoughton', 'CI', 4221, 42.92520000000, -89.15620000000, '107162'),
(11791, 'US-WI-107163', 'Baraboo', 'CI', 4221, 43.48070000000, -89.73990000000, '107163'),
(11792, 'US-IL-107164', 'Machesney Park', 'CI', 4180, 42.36310000000, -89.03320000000, '107164'),
(11793, 'US-WI-107165', 'Merrill', 'CI', 4221, 45.17810000000, -89.83360000000, '107165'),
(11794, 'US-IN-107166', 'Huntingburg', 'CI', 4181, 38.29290000000, -86.94640000000, '107166'),
(11795, 'US-CA-107167', 'Windsor', 'CI', 4169, 38.53690000000, -122.81230000000, '107167'),
(11796, 'US-KS-107168', 'Belvue', 'CI', 4183, 39.26920000000, -96.17100000000, '107168'),
(11797, 'US-KS-107169', 'Ellsworth', 'CI', 4183, 38.74730000000, -98.20510000000, '107169'),
(11798, 'US-NJ-107170', 'Colonia', 'CI', 4198, 40.58940000000, -74.31470000000, '107170'),
(11799, 'US-CT-107171', 'Avon', 'CI', 4171, 41.79000000000, -72.87350000000, '107171'),
(11800, 'US-CA-107172', 'Mill Valley', 'CI', 4169, 37.89590000000, -122.56630000000, '107172'),
(11801, 'US-IN-107173', 'Covington', 'CI', 4181, 40.10750000000, -87.36450000000, '107173'),
(11802, 'US-NY-107174', 'Mineola', 'CI', 4200, 40.74580000000, -73.63900000000, '107174'),
(11803, 'US-CT-107175', 'Canton', 'CI', 4171, 41.86430000000, -72.91200000000, '107175'),
(11804, 'US-MA-107176', 'Holliston', 'CI', 4189, 42.19730000000, -71.44100000000, '107176'),
(11805, 'US-MA-107177', 'Walpole', 'CI', 4189, 42.15120000000, -71.25690000000, '107177'),
(11806, 'US-MA-107178', 'Wayland', 'CI', 4189, 42.36130000000, -71.36290000000, '107178'),
(11807, 'US-IL-107179', 'Midlothian', 'CI', 4180, 41.63220000000, -87.74230000000, '107179'),
(11808, 'US-IL-107180', 'Bartlett', 'CI', 4180, 41.97340000000, -88.20650000000, '107180'),
(11809, 'US-MA-107181', 'Milford', 'CI', 4189, 42.15440000000, -71.52100000000, '107181'),
(11810, 'US-MA-107182', 'Franklin', 'CI', 4189, 42.08760000000, -71.40730000000, '107182'),
(11811, 'US-MA-107183', 'Foxboro', 'CI', 4189, 42.06080000000, -71.23370000000, '107183'),
(11812, 'US-NJ-107184', 'Marmora', 'CI', 4198, 39.26370000000, -74.66080000000, '107184'),
(11813, 'US-MA-107185', 'Ayer', 'CI', 4189, 42.55010000000, -71.56040000000, '107185'),
(11814, 'US-MA-107186', 'Attleboro', 'CI', 4189, 41.93950000000, -71.29430000000, '107186'),
(11815, 'US-MA-107187', 'Wrentham', 'CI', 4189, 42.05430000000, -71.37150000000, '107187'),
(11816, 'US-MA-107188', 'Littleton', 'CI', 4189, 42.53840000000, -71.48530000000, '107188'),
(11817, 'US-CA-107189', 'Grass Valley', 'CI', 4169, 39.11100000000, -121.12680000000, '107189'),
(11818, 'US-MA-107190', 'Sudbury', 'CI', 4189, 42.38880000000, -71.42250000000, '107190'),
(11819, 'US-OH-107191', 'Twinsburg', 'CI', 4204, 41.31520000000, -81.44050000000, '107191'),
(11820, 'US-MA-107192', 'East Walpole', 'CI', 4189, 42.15430000000, -71.21540000000, '107192'),
(11821, 'US-CA-107193', 'Blairsden-graeagle', 'CI', 4169, 39.78840000000, -120.65360000000, '107193'),
(11822, 'US-MA-107194', 'Feeding Hills', 'CI', 4189, 42.07040000000, -72.67640000000, '107194'),
(11823, 'US-MA-107195', 'Lee', 'CI', 4189, 42.28490000000, -73.21420000000, '107195'),
(11824, 'US-CT-107196', 'Weatogue', 'CI', 4171, 41.83880000000, -72.83180000000, '107196'),
(11825, 'US-CA-107197', 'Eureka', 'CI', 4169, 40.80040000000, -124.15280000000, '107197'),
(11826, 'US-WV-107198', 'Hico', 'CI', 4220, 38.12500000000, -80.98290000000, '107198'),
(11827, 'US-CA-107199', 'Napa', 'CI', 4169, 38.55750000000, -122.15540000000, '107199'),
(11828, 'US-MI-107200', 'Mount Clemens', 'CI', 4190, 42.59210000000, -82.88380000000, '107200'),
(11829, 'US-MI-107201', 'Fenton', 'CI', 4190, 42.77050000000, -83.74670000000, '107201'),
(11830, 'US-MI-107202', 'Deckerville', 'CI', 4190, 43.52050000000, -82.72410000000, '107202'),
(11831, 'US-MI-107203', 'Bad Axe', 'CI', 4190, 43.79440000000, -83.00250000000, '107203'),
(11832, 'US-AZ-107204', 'Camp Verde', 'CI', 4164, 34.48620000000, -111.78080000000, '107204'),
(11833, 'US-MI-107205', 'Trenton', 'CI', 4190, 42.13310000000, -83.21820000000, '107205'),
(11834, 'US-MI-107206', 'Northville', 'CI', 4190, 42.41650000000, -83.52970000000, '107206'),
(11835, 'US-MI-107207', 'Roseville', 'CI', 4190, 42.50960000000, -82.93610000000, '107207'),
(11836, 'US-MI-107208', 'Dearborn Heights', 'CI', 4190, 42.29010000000, -83.28770000000, '107208'),
(11837, 'US-MI-107209', 'Grosse Pointe', 'CI', 4190, 42.42150000000, -82.89870000000, '107209'),
(11838, 'US-MI-107210', 'Cass City', 'CI', 4190, 43.61060000000, -83.16440000000, '107210'),
(11839, 'US-MI-107211', 'Rochester', 'CI', 4190, 42.72860000000, -83.14760000000, '107211'),
(11840, 'US-MI-107212', 'New Baltimore', 'CI', 4190, 42.67570000000, -82.77730000000, '107212'),
(11841, 'US-MI-107213', 'Minden City', 'CI', 4190, 43.67750000000, -82.74380000000, '107213'),
(11842, 'US-MI-107214', 'Fair Haven', 'CI', 4190, 42.69440000000, -82.66860000000, '107214'),
(11843, 'US-MI-107215', 'West Bloomfield', 'CI', 4190, 42.54280000000, -83.37950000000, '107215'),
(11844, 'US-MI-107216', 'Bloomfield Hills', 'CI', 4190, 42.58480000000, -83.29500000000, '107216'),
(11845, 'US-CA-107217', 'Pinole', 'CI', 4169, 37.99270000000, -122.27610000000, '107217'),
(11846, 'US-CA-107218', 'Berkeley', 'CI', 4169, 37.86720000000, -122.25680000000, '107218'),
(11847, 'US-CT-107219', 'Pomfret Center', 'CI', 4171, 41.86180000000, -71.99460000000, '107219'),
(11848, 'US-KY-107220', 'Carrollton', 'CI', 4184, 38.66060000000, -85.18950000000, '107220'),
(11849, 'US-ID-107221', 'Nampa', 'CI', 4179, 43.60560000000, -116.54150000000, '107221'),
(11850, 'US-CT-107222', 'Rogers', 'CI', 4171, 41.83850000000, -71.90490000000, '107222'),
(11851, 'US-AZ-107223', 'Holbrook', 'CI', 4164, 34.94840000000, -110.09750000000, '107223'),
(11852, 'US-MO-107224', 'Warrenton', 'CI', 4193, 38.81420000000, -91.20760000000, '107224'),
(11853, 'US-CA-107225', 'South El Monte', 'CI', 4169, 34.04690000000, -118.04850000000, '107225'),
(11854, 'US-PA-107226', 'Callery', 'CI', 4208, 40.74000000000, -80.03580000000, '107226'),
(11855, 'US-FL-107227', 'Palm Harbor', 'CI', 4175, 28.09860000000, -82.68600000000, '107227'),
(11856, 'US-IL-107228', 'Teutopolis', 'CI', 4180, 39.11700000000, -88.42070000000, '107228'),
(11857, 'US-IN-107229', 'Elkhart', 'CI', 4181, 41.66710000000, -85.96590000000, '107229'),
(11858, 'US-OK-107230', 'Shawnee', 'CI', 4205, 35.31430000000, -96.96600000000, '107230'),
(11859, 'US-OH-107231', 'Hiram', 'CI', 4204, 41.33210000000, -81.16500000000, '107231'),
(11860, 'US-OH-107232', 'Mentor', 'CI', 4204, 41.68920000000, -81.32660000000, '107232'),
(11861, 'US-OH-107233', 'Solon', 'CI', 4204, 41.38650000000, -81.44010000000, '107233'),
(11862, 'US-OH-107234', 'North Olmsted', 'CI', 4204, 41.41630000000, -81.92250000000, '107234'),
(11863, 'US-OH-107235', 'Chardon', 'CI', 4204, 41.57790000000, -81.19300000000, '107235'),
(11864, 'US-OH-107236', 'Painesville', 'CI', 4204, 41.69720000000, -81.19740000000, '107236'),
(11865, 'US-OH-107237', 'Bedford', 'CI', 4204, 41.38910000000, -81.53680000000, '107237'),
(11866, 'US-OH-107238', 'Wickliffe', 'CI', 4204, 41.59850000000, -81.46430000000, '107238'),
(11867, 'US-OH-107239', 'Brook Park', 'CI', 4204, 41.40260000000, -81.83370000000, '107239'),
(11868, 'US-OH-107240', 'Euclid', 'CI', 4204, 41.56830000000, -81.52600000000, '107240'),
(11869, 'US-OH-107241', 'Rocky River', 'CI', 4204, 41.46980000000, -81.84940000000, '107241'),
(11870, 'US-OH-107242', 'Amherst', 'CI', 4204, 41.35680000000, -82.26200000000, '107242'),
(11871, 'US-OH-107243', 'Elyria', 'CI', 4204, 41.36780000000, -82.09850000000, '107243'),
(11872, 'US-OH-107244', 'Columbia Station', 'CI', 4204, 41.30560000000, -81.94950000000, '107244'),
(11873, 'US-OH-107245', 'Westlake', 'CI', 4204, 41.44460000000, -81.92200000000, '107245'),
(11874, 'US-GA-107246', 'Canton', 'CI', 4176, 34.25770000000, -84.49210000000, '107246'),
(11875, 'US-OH-107247', 'Richfield', 'CI', 4204, 41.23270000000, -81.63570000000, '107247'),
(11876, 'US-OH-107248', 'Ashtabula', 'CI', 4204, 41.85280000000, -80.79050000000, '107248'),
(11877, 'US-OH-107249', 'Macedonia', 'CI', 4204, 41.31340000000, -81.49740000000, '107249'),
(11878, 'US-DE-107250', 'Seaford', 'CI', 4172, 38.63200000000, -75.59010000000, '107250'),
(11879, 'US-OH-107251', 'Aurora', 'CI', 4204, 41.31900000000, -81.33530000000, '107251'),
(11880, 'US-OH-107252', 'Lorain', 'CI', 4204, 41.43080000000, -82.23370000000, '107252'),
(11881, 'US-OH-107253', 'Wellington', 'CI', 4204, 41.16090000000, -82.20850000000, '107253'),
(11882, 'US-CA-107254', 'Healdsburg', 'CI', 4169, 38.63190000000, -122.89710000000, '107254'),
(11883, 'US-CA-107255', 'Belvedere Tiburon', 'CI', 4169, 37.89140000000, -122.47280000000, '107255'),
(11884, 'US-CA-107256', 'Penngrove', 'CI', 4169, 38.31850000000, -122.64410000000, '107256'),
(11885, 'US-CA-107257', 'Angwin', 'CI', 4169, 38.57710000000, -122.44110000000, '107257'),
(11886, 'US-CA-107258', 'Redway', 'CI', 4169, 40.15250000000, -123.89250000000, '107258'),
(11887, 'US-CA-107259', 'Corte Madera', 'CI', 4169, 37.92570000000, -122.51270000000, '107259'),
(11888, 'US-FL-107260', 'Daytona Beach', 'CI', 4175, 29.16220000000, -81.00750000000, '107260'),
(11889, 'PR-??-107261', 'Dorado', 'CI', 181, 18.43160000000, -66.26140000000, '107261'),
(11890, 'US-MA-107262', 'Winchester', 'CI', 4189, 42.45470000000, -71.15020000000, '107262'),
(11891, 'US-CA-107263', 'Saint Helena', 'CI', 4169, 38.55040000000, -122.39230000000, '107263'),
(11892, 'US-CA-107264', 'Clearlake', 'CI', 4169, 38.96780000000, -122.64770000000, '107264'),
(11893, 'US-NJ-107265', 'Atlantic City', 'CI', 4198, 39.36520000000, -74.43780000000, '107265'),
(11894, 'US-CA-107266', 'Petaluma', 'CI', 4169, 38.21840000000, -122.76760000000, '107266'),
(11895, 'US-CA-107267', 'Bell', 'CI', 4169, 33.97610000000, -118.15350000000, '107267'),
(11896, 'US-CA-107268', 'Oceanside', 'CI', 4169, 33.20040000000, -117.29070000000, '107268'),
(11897, 'US-MI-107269', 'Big Rapids', 'CI', 4190, 43.67970000000, -85.56190000000, '107269'),
(11898, 'US-CA-107270', 'Larkspur', 'CI', 4169, 37.93610000000, -122.53670000000, '107270'),
(11899, 'US-FL-107271', 'Hallandale', 'CI', 4175, 25.98630000000, -80.15180000000, '107271'),
(11900, 'US-CA-107272', 'Middletown', 'CI', 4169, 38.78900000000, -122.58460000000, '107272'),
(11901, 'US-CA-107273', 'Sonoma', 'CI', 4169, 38.24330000000, -122.46020000000, '107273'),
(11902, 'US-CA-107274', 'Sebastopol', 'CI', 4169, 38.40320000000, -122.86330000000, '107274'),
(11903, 'US-OK-107275', 'Miami', 'CI', 4205, 36.89940000000, -94.87850000000, '107275'),
(11904, 'US-OK-107276', 'Catoosa', 'CI', 4205, 36.19220000000, -95.70670000000, '107276'),
(11905, 'US-KS-107277', 'Burrton', 'CI', 4183, 37.99890000000, -97.67160000000, '107277'),
(11906, 'US-KS-107278', 'Great Bend', 'CI', 4183, 38.34020000000, -98.81180000000, '107278'),
(11907, 'US-OK-107279', 'Stillwater', 'CI', 4205, 36.18850000000, -97.05740000000, '107279'),
(11908, 'US-OK-107280', 'Dewey', 'CI', 4205, 36.82930000000, -95.88510000000, '107280'),
(11909, 'US-OK-107281', 'Muskogee', 'CI', 4205, 35.67380000000, -95.30560000000, '107281'),
(11910, 'US-TX-107282', 'Kingsland', 'CI', 4214, 30.68780000000, -98.47680000000, '107282'),
(11911, 'US-OK-107283', 'Okemah', 'CI', 4205, 35.46460000000, -96.32880000000, '107283'),
(11912, 'US-TX-107284', 'Burleson', 'CI', 4214, 32.53050000000, -97.30760000000, '107284'),
(11913, 'US-KS-107285', 'Neodesha', 'CI', 4183, 37.41400000000, -95.68890000000, '107285'),
(11914, 'US-OK-107286', 'Kiowa', 'CI', 4205, 34.69100000000, -95.93810000000, '107286'),
(11915, 'US-NY-107287', 'Hicksville', 'CI', 4200, 40.76700000000, -73.52540000000, '107287'),
(11916, 'US-NY-107288', 'College Point', 'CI', 4200, 40.78420000000, -73.84220000000, '107288'),
(11917, 'US-WA-107289', 'Wapato', 'CI', 4219, 46.45120000000, -120.51730000000, '107289'),
(11918, 'US-NY-107290', 'Roslyn Heights', 'CI', 4200, 40.78090000000, -73.64150000000, '107290'),
(11919, 'US-ME-107291', 'Rockland', 'CI', 4186, 44.12720000000, -69.13360000000, '107291'),
(11920, 'US-ME-107292', 'Gardiner', 'CI', 4186, 44.21680000000, -69.85220000000, '107292'),
(11921, 'US-ME-107293', 'Westbrook', 'CI', 4186, 43.71500000000, -70.34520000000, '107293'),
(11922, 'US-NY-107294', 'Hailesboro', 'CI', 4200, 44.30530000000, -75.45140000000, '107294'),
(11923, 'US-ME-107295', 'Clinton', 'CI', 4186, 44.67140000000, -69.53750000000, '107295'),
(11924, 'US-ME-107296', 'Old Town', 'CI', 4186, 45.03600000000, -68.73270000000, '107296'),
(11925, 'US-ME-107297', 'Caribou', 'CI', 4186, 46.91210000000, -68.04310000000, '107297'),
(11926, 'US-ME-107298', 'Waldoboro', 'CI', 4186, 44.10850000000, -69.36590000000, '107298'),
(11927, 'US-ME-107299', 'Kennebunk', 'CI', 4186, 43.39720000000, -70.57220000000, '107299'),
(11928, 'US-ME-107300', 'Scarborough', 'CI', 4186, 43.59230000000, -70.37350000000, '107300'),
(11929, 'US-ME-107301', 'Waterville', 'CI', 4186, 44.56160000000, -69.55590000000, '107301'),
(11930, 'US-ME-107302', 'Brunswick', 'CI', 4186, 43.89880000000, -69.97250000000, '107302'),
(11931, 'US-ME-107303', 'Brooksville', 'CI', 4186, 44.36670000000, -68.74540000000, '107303'),
(11932, 'US-ME-107304', 'Belfast', 'CI', 4186, 44.47350000000, -69.05510000000, '107304'),
(11933, 'US-ME-107305', 'Stockton Springs', 'CI', 4186, 44.52110000000, -68.87040000000, '107305'),
(11934, 'US-ME-107306', 'Kittery', 'CI', 4186, 43.11530000000, -70.70510000000, '107306'),
(11935, 'US-ME-107307', 'Sanford', 'CI', 4186, 43.40420000000, -70.74550000000, '107307'),
(11936, 'US-ME-107308', 'Augusta', 'CI', 4186, 44.40510000000, -69.75670000000, '107308'),
(11937, 'US-ME-107309', 'Madawaska', 'CI', 4186, 47.31630000000, -68.30070000000, '107309'),
(11938, 'US-ME-107310', 'Fort Kent', 'CI', 4186, 47.19230000000, -68.48240000000, '107310'),
(11939, 'US-ID-107311', 'Rexburg', 'CI', 4179, 43.78320000000, -111.76560000000, '107311'),
(11940, 'US-KY-107312', 'Florence', 'CI', 4184, 39.00230000000, -84.65690000000, '107312'),
(11941, 'US-ME-107313', 'Guilford', 'CI', 4186, 45.26770000000, -69.33020000000, '107313'),
(11942, 'US-ME-107314', 'Sedgwick', 'CI', 4186, 44.35020000000, -68.64340000000, '107314'),
(11943, 'US-PA-107315', 'Hatboro', 'CI', 4208, 40.18240000000, -75.10620000000, '107315'),
(11944, 'US-PA-107316', 'Sharon Hill', 'CI', 4208, 39.90080000000, -75.26620000000, '107316'),
(11945, 'US-NJ-107317', 'Montclair', 'CI', 4198, 40.81620000000, -74.21640000000, '107317'),
(11946, 'US-NJ-107318', 'Carteret', 'CI', 4198, 40.58170000000, -74.23150000000, '107318'),
(11947, 'US-NJ-107319', 'Harrison', 'CI', 4198, 40.74410000000, -74.14350000000, '107319'),
(11948, 'US-NJ-107320', 'Roselle', 'CI', 4198, 40.65060000000, -74.26000000000, '107320'),
(11949, 'US-NJ-107321', 'Springfield', 'CI', 4198, 40.69870000000, -74.32960000000, '107321'),
(11950, 'US-NJ-107322', 'Union', 'CI', 4198, 40.69450000000, -74.26900000000, '107322'),
(11951, 'US-NJ-107323', 'Mountainside', 'CI', 4198, 40.68210000000, -74.35880000000, '107323'),
(11952, 'US-NY-107324', 'Bethpage', 'CI', 4200, 40.74050000000, -73.48400000000, '107324'),
(11953, 'US-NJ-107325', 'Hillside', 'CI', 4198, 40.69320000000, -74.22940000000, '107325'),
(11954, 'US-NJ-107326', 'Cranford', 'CI', 4198, 40.65590000000, -74.30450000000, '107326'),
(11955, 'US-NJ-107327', 'South Orange', 'CI', 4198, 40.74900000000, -74.26390000000, '107327'),
(11956, 'US-NJ-107328', 'West Orange', 'CI', 4198, 40.79190000000, -74.26400000000, '107328'),
(11957, 'US-IA-107329', 'Jesup', 'CI', 4182, 42.47010000000, -92.10330000000, '107329'),
(11958, 'US-FL-107330', 'Eglin Afb', 'CI', 4175, 30.46940000000, -86.52800000000, '107330'),
(11959, 'US-NJ-107331', 'Union City', 'CI', 4198, 40.76390000000, -74.03700000000, '107331'),
(11960, 'US-NJ-107332', 'Bayonne', 'CI', 4198, 40.67050000000, -74.10640000000, '107332'),
(11961, 'US-NJ-107333', 'Nutley', 'CI', 4198, 40.82170000000, -74.15740000000, '107333'),
(11962, 'US-PA-107334', 'Glenside', 'CI', 4208, 40.10120000000, -75.17800000000, '107334'),
(11963, 'US-NJ-107335', 'Belleville', 'CI', 4198, 40.79210000000, -74.16270000000, '107335'),
(11964, 'US-ME-107336', 'Camden', 'CI', 4186, 44.22530000000, -69.09230000000, '107336'),
(11965, 'US-NJ-107337', 'Rahway', 'CI', 4198, 40.60970000000, -74.28060000000, '107337'),
(11966, 'US-NJ-107338', 'Cedar Knolls', 'CI', 4198, 40.82210000000, -74.45640000000, '107338'),
(11967, 'US-MI-107339', 'Wayne', 'CI', 4190, 42.27710000000, -83.38770000000, '107339'),
(11968, 'US-NJ-107340', 'Westfield', 'CI', 4198, 40.65340000000, -74.34630000000, '107340'),
(11969, 'US-NJ-107341', 'Hoboken', 'CI', 4198, 40.74580000000, -74.03210000000, '107341'),
(11970, 'US-KY-107342', 'Newport', 'CI', 4184, 39.01090000000, -84.43350000000, '107342'),
(11971, 'US-IN-107343', 'Granger', 'CI', 4181, 41.73500000000, -86.12290000000, '107343'),
(11972, 'US-NJ-107344', 'Kearny', 'CI', 4198, 40.75160000000, -74.12020000000, '107344'),
(11973, 'US-LA-107345', 'Plaquemine', 'CI', 4185, 30.18820000000, -91.32410000000, '107345'),
(11974, 'US-TN-107346', 'Carthage', 'CI', 4213, 36.25030000000, -85.98700000000, '107346'),
(11975, 'US-WA-107347', 'Olympia', 'CI', 4219, 46.94450000000, -123.04930000000, '107347'),
(11976, 'US-MS-107348', 'Tupelo', 'CI', 4192, 34.22170000000, -88.76880000000, '107348'),
(11977, 'US-FL-107349', 'Brandon', 'CI', 4175, 27.90030000000, -82.30240000000, '107349'),
(11978, 'US-GA-107350', 'Moultrie', 'CI', 4176, 31.19300000000, -83.84340000000, '107350'),
(11979, 'US-MA-107351', 'Devens', 'CI', 4189, 42.54360000000, -71.61610000000, '107351'),
(11980, 'US-MA-107352', 'Chilmark', 'CI', 4189, 41.35510000000, -70.72730000000, '107352'),
(11981, 'US-WI-107353', 'Windsor', 'CI', 4221, 43.20240000000, -89.34220000000, '107353'),
(11982, 'US-WI-107354', 'Greenville', 'CI', 4221, 44.30150000000, -88.54670000000, '107354'),
(11983, 'US-TX-107355', 'Southlake', 'CI', 4214, 32.95160000000, -97.15150000000, '107355'),
(11984, 'US-GA-107356', 'Lithonia', 'CI', 4176, 33.65890000000, -84.14300000000, '107356'),
(11985, 'US-CA-107357', 'Santa Paula', 'CI', 4169, 34.40140000000, -119.07530000000, '107357'),
(11986, 'US-MS-107358', 'Clinton', 'CI', 4192, 32.36710000000, -90.35860000000, '107358'),
(11987, 'US-NJ-107359', 'Dover', 'CI', 4198, 40.95590000000, -74.54180000000, '107359'),
(11988, 'US-IL-107360', 'Carlinville', 'CI', 4180, 39.28400000000, -89.86980000000, '107360'),
(11989, 'US-AR-107361', 'Dumas', 'CI', 4165, 33.91550000000, -91.52320000000, '107361'),
(11990, 'US-MA-107362', 'Stoughton', 'CI', 4189, 42.11860000000, -71.10330000000, '107362'),
(11991, 'US-MA-107363', 'Concord', 'CI', 4189, 42.45860000000, -71.35970000000, '107363'),
(11992, 'US-RI-107364', 'Pawtucket', 'CI', 4210, 41.87840000000, -71.35390000000, '107364'),
(11993, 'US-MI-107365', 'Battle Creek', 'CI', 4190, 42.28430000000, -85.22930000000, '107365'),
(11994, 'US-MA-107366', 'West Yarmouth', 'CI', 4189, 41.64940000000, -70.24150000000, '107366'),
(11995, 'US-RI-107367', 'Cumberland', 'CI', 4210, 41.95600000000, -71.43380000000, '107367'),
(11996, 'US-MA-107368', 'Vineyard Haven', 'CI', 4189, 41.44770000000, -70.62100000000, '107368'),
(11997, 'US-MA-107369', 'Fairhaven', 'CI', 4189, 41.63180000000, -70.88010000000, '107369'),
(11998, 'US-RI-107370', 'Fiskeville', 'CI', 4210, 41.73460000000, -71.54600000000, '107370'),
(11999, 'US-IL-107371', 'Chatsworth', 'CI', 4180, 40.73690000000, -88.29830000000, '107371'),
(12000, 'US-IN-107372', 'Greencastle', 'CI', 4181, 39.65970000000, -86.86630000000, '107372'),
(12001, 'US-MA-107373', 'North Attleboro', 'CI', 4189, 41.97930000000, -71.33140000000, '107373'),
(12002, 'US-MO-107374', 'Raymondville', 'CI', 4193, 37.35480000000, -91.75840000000, '107374'),
(12003, 'US-MA-107375', 'Somerville', 'CI', 4189, 42.38280000000, -71.09550000000, '107375'),
(12004, 'US-CA-107376', 'Greenbrae', 'CI', 4169, 37.94940000000, -122.56260000000, '107376'),
(12005, 'US-MA-107377', 'Newton Center', 'CI', 4189, 42.31370000000, -71.19470000000, '107377'),
(12006, 'US-MO-107378', 'Oak Grove', 'CI', 4193, 39.01320000000, -94.15020000000, '107378'),
(12007, 'US-NJ-107379', 'Montvale', 'CI', 4198, 41.05500000000, -74.04600000000, '107379'),
(12008, 'US-IL-107380', 'Lake Zurich', 'CI', 4180, 42.20080000000, -88.04300000000, '107380'),
(12009, 'US-TX-107381', 'Cedar Creek', 'CI', 4214, 30.09420000000, -97.49180000000, '107381'),
(12010, 'US-NY-107382', 'Penn Yan', 'CI', 4200, 42.64990000000, -76.98790000000, '107382'),
(12011, 'US-IL-107383', 'Glendale Heights', 'CI', 4180, 41.92140000000, -88.07450000000, '107383'),
(12012, 'US-MN-107384', 'Wyoming', 'CI', 4191, 45.33490000000, -93.01320000000, '107384'),
(12013, 'US-IL-107385', 'Addison', 'CI', 4180, 41.93100000000, -88.00900000000, '107385'),
(12014, 'US-MI-107386', 'Ferndale', 'CI', 4190, 42.46080000000, -83.14070000000, '107386'),
(12015, 'US-NY-107387', 'Ithaca', 'CI', 4200, 42.40720000000, -76.51590000000, '107387'),
(12016, 'US-NM-107388', 'Farmington', 'CI', 4199, 36.47140000000, -108.25100000000, '107388'),
(12017, 'US-NJ-107389', 'Woodbury', 'CI', 4198, 39.82400000000, -75.13180000000, '107389'),
(12018, 'US-TX-107390', 'Canton', 'CI', 4214, 32.53370000000, -95.86550000000, '107390'),
(12019, 'US-MN-107391', 'Anoka', 'CI', 4191, 45.28740000000, -93.43360000000, '107391'),
(12020, 'US-IL-107392', 'Sugar Grove', 'CI', 4180, 41.77680000000, -88.46040000000, '107392'),
(12021, 'US-FL-107393', 'Umatilla', 'CI', 4175, 28.98220000000, -81.73510000000, '107393'),
(12022, 'US-OK-107394', 'Chelsea', 'CI', 4205, 36.53220000000, -95.46780000000, '107394'),
(12023, 'US-GA-107395', 'Roswell', 'CI', 4176, 34.02660000000, -84.31520000000, '107395'),
(12024, 'US-GA-107396', 'Stone Mountain', 'CI', 4176, 33.78440000000, -84.21350000000, '107396'),
(12025, 'US-GA-107397', 'Conyers', 'CI', 4176, 33.62070000000, -83.97370000000, '107397'),
(12026, 'US-GA-107398', 'Suwanee', 'CI', 4176, 34.05350000000, -84.06590000000, '107398'),
(12027, 'US-GA-107399', 'Ellijay', 'CI', 4176, 34.70440000000, -84.42530000000, '107399'),
(12028, 'US-GA-107400', 'Loganville', 'CI', 4176, 33.80420000000, -83.88930000000, '107400'),
(12029, 'US-TN-107401', 'Mascot', 'CI', 4213, 36.09200000000, -83.72880000000, '107401'),
(12030, 'US-TN-107402', 'Alcoa', 'CI', 4213, 35.80120000000, -83.98530000000, '107402'),
(12031, 'US-AR-107403', 'Fayetteville', 'CI', 4165, 36.11890000000, -93.98400000000, '107403'),
(12032, 'US-GA-107404', 'Covington', 'CI', 4176, 33.56410000000, -83.84390000000, '107404'),
(12033, 'US-GA-107405', 'Dawsonville', 'CI', 4176, 34.46300000000, -84.15100000000, '107405'),
(12034, 'US-GA-107406', 'Waleska', 'CI', 4176, 34.33190000000, -84.59480000000, '107406'),
(12035, 'US-GA-107407', 'Cleveland', 'CI', 4176, 34.62220000000, -83.79010000000, '107407'),
(12036, 'US-GA-107408', 'Dahlonega', 'CI', 4176, 34.57280000000, -84.02630000000, '107408'),
(12037, 'US-TN-107409', 'Oneida', 'CI', 4213, 36.51010000000, -84.46930000000, '107409'),
(12038, 'US-TN-107410', 'Clinton', 'CI', 4213, 36.10330000000, -84.20620000000, '107410'),
(12039, 'US-GA-107411', 'Pendergrass', 'CI', 4176, 34.18510000000, -83.67600000000, '107411'),
(12040, 'US-IL-107412', 'Milford', 'CI', 4180, 40.62300000000, -87.69700000000, '107412'),
(12041, 'US-GA-107413', 'Waycross', 'CI', 4176, 31.21770000000, -82.34290000000, '107413'),
(12042, 'US-TN-107414', 'Vonore', 'CI', 4213, 35.48410000000, -84.09400000000, '107414'),
(12043, 'US-GA-107415', 'Commerce', 'CI', 4176, 34.13060000000, -83.58740000000, '107415'),
(12044, 'US-TN-107416', 'Morristown', 'CI', 4213, 36.21360000000, -83.29370000000, '107416'),
(12045, 'US-IL-107417', 'Lockport', 'CI', 4180, 41.60450000000, -87.99560000000, '107417'),
(12046, 'US-NC-107418', 'Taylorsville', 'CI', 4201, 35.91830000000, -81.20020000000, '107418'),
(12047, 'US-NC-107419', 'Murphy', 'CI', 4201, 35.13970000000, -84.09230000000, '107419'),
(12048, 'US-SC-107420', 'York', 'CI', 4211, 34.98850000000, -81.20480000000, '107420'),
(12049, 'US-NC-107421', 'Cashiers', 'CI', 4201, 35.08420000000, -83.09400000000, '107421'),
(12050, 'US-NC-107422', 'Marion', 'CI', 4201, 35.73870000000, -82.05480000000, '107422'),
(12051, 'US-PA-107423', 'Morrisville', 'CI', 4208, 40.19570000000, -74.81270000000, '107423'),
(12052, 'US-TN-107424', 'Elizabethton', 'CI', 4213, 36.41990000000, -82.11390000000, '107424'),
(12053, 'US-TN-107425', 'Smithville', 'CI', 4213, 35.92930000000, -85.77940000000, '107425'),
(12054, 'US-TX-107426', 'Denison', 'CI', 4214, 33.77620000000, -96.60670000000, '107426'),
(12055, 'US-MI-107427', 'Wyoming', 'CI', 4190, 42.89880000000, -85.70590000000, '107427'),
(12056, 'US-FL-107428', 'Immokalee', 'CI', 4175, 26.23040000000, -81.22150000000, '107428'),
(12057, 'US-AL-107429', 'Winfield', 'CI', 4161, 33.94630000000, -87.78280000000, '107429'),
(12058, 'US-AL-107430', 'Fayette', 'CI', 4161, 33.64360000000, -87.82750000000, '107430'),
(12059, 'US-AL-107431', 'Elkmont', 'CI', 4161, 34.92660000000, -86.95700000000, '107431'),
(12060, 'US-AL-107432', 'Blountsville', 'CI', 4161, 34.11870000000, -86.56210000000, '107432'),
(12061, 'US-AL-107433', 'Hamilton', 'CI', 4161, 34.16130000000, -87.99640000000, '107433'),
(12063, 'US-FL-107435', 'Crestview', 'CI', 4175, 30.63670000000, -86.66350000000, '107435'),
(12064, 'US-AL-107436', 'Billingsley', 'CI', 4161, 32.62950000000, -86.71510000000, '107436'),
(12065, 'US-AL-107437', 'Sylacauga', 'CI', 4161, 33.11670000000, -86.33230000000, '107437'),
(12066, 'US-AL-107438', 'Albertville', 'CI', 4161, 34.25190000000, -86.25710000000, '107438'),
(12067, 'US-AL-107439', 'Muscle Shoals', 'CI', 4161, 34.76860000000, -87.55830000000, '107439'),
(12068, 'US-AL-107440', 'Tanner', 'CI', 4161, 34.66200000000, -86.96520000000, '107440'),
(12069, 'US-AL-107441', 'Russellville', 'CI', 4161, 34.52960000000, -87.86640000000, '107441'),
(12070, 'US-AL-107442', 'Tallassee', 'CI', 4161, 32.55540000000, -85.93350000000, '107442'),
(12071, 'US-AL-107443', 'Fort Rucker', 'CI', 4161, 31.34970000000, -85.68460000000, '107443'),
(12072, 'US-AL-107444', 'Trinity', 'CI', 4161, 34.58670000000, -87.14060000000, '107444'),
(12073, 'US-AL-107445', 'Alabaster', 'CI', 4161, 33.22400000000, -86.77300000000, '107445'),
(12074, 'US-AL-107446', 'Ward', 'CI', 4161, 32.29250000000, -88.09790000000, '107446'),
(12075, 'US-AL-107447', 'Boaz', 'CI', 4161, 34.19170000000, -86.19340000000, '107447'),
(12076, 'US-AL-107448', 'Mathews', 'CI', 4161, 32.17750000000, -86.06040000000, '107448'),
(12077, 'US-AL-107449', 'Troy', 'CI', 4161, 31.90510000000, -85.89370000000, '107449'),
(12078, 'US-PA-107450', 'Ridley Park', 'CI', 4208, 39.87510000000, -75.32140000000, '107450'),
(12079, 'US-MI-107451', 'Gaylord', 'CI', 4190, 44.98670000000, -84.63930000000, '107451'),
(12080, 'US-MI-107452', 'Mount Pleasant', 'CI', 4190, 43.61470000000, -84.79270000000, '107452'),
(12081, 'US-MI-107453', 'Muskegon', 'CI', 4190, 43.17460000000, -86.18340000000, '107453'),
(12082, 'US-MI-107454', 'Douglas', 'CI', 4190, 42.63960000000, -86.21400000000, '107454'),
(12083, 'US-MI-107455', 'Ionia', 'CI', 4190, 43.03200000000, -85.05750000000, '107455'),
(12084, 'US-MI-107456', 'Allegan', 'CI', 4190, 42.56020000000, -85.85860000000, '107456'),
(12085, 'US-OH-107457', 'Warren', 'CI', 4204, 41.25870000000, -80.82980000000, '107457'),
(12086, 'US-AR-107458', 'Blytheville', 'CI', 4165, 35.87110000000, -89.90460000000, '107458'),
(12087, 'US-MI-107459', 'Sturgis', 'CI', 4190, 41.84290000000, -85.44750000000, '107459');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(12088, 'US-IN-107460', 'Howe', 'CI', 4181, 41.71190000000, -85.36920000000, '107460'),
(12089, 'US-IN-107461', 'Albion', 'CI', 4181, 41.35920000000, -85.43050000000, '107461'),
(12090, 'US-MI-107462', 'Caledonia', 'CI', 4190, 42.78640000000, -85.55060000000, '107462'),
(12091, 'US-MI-107463', 'Vanderbilt', 'CI', 4190, 45.17250000000, -84.58330000000, '107463'),
(12092, 'US-NC-107464', 'Granite Quarry', 'CI', 4201, 35.61410000000, -80.43910000000, '107464'),
(12093, 'US-MI-107465', 'Spring Lake', 'CI', 4190, 43.10270000000, -86.22390000000, '107465'),
(12094, 'US-AR-107466', 'West Helena', 'CI', 4165, 34.53010000000, -90.65120000000, '107466'),
(12095, 'US-AR-107467', 'Harrisburg', 'CI', 4165, 35.57410000000, -90.74760000000, '107467'),
(12096, 'US-PA-107468', 'Fairless Hills', 'CI', 4208, 40.17410000000, -74.84530000000, '107468'),
(12097, 'US-PA-107469', 'Dresher', 'CI', 4208, 40.15180000000, -75.16070000000, '107469'),
(12098, 'US-MI-107470', 'Grayling', 'CI', 4190, 44.71430000000, -84.67170000000, '107470'),
(12099, 'US-NJ-107471', 'Marlton', 'CI', 4198, 39.85060000000, -74.90990000000, '107471'),
(12100, 'US-PA-107472', 'Springfield', 'CI', 4208, 39.93240000000, -75.34070000000, '107472'),
(12101, 'US-RI-107473', 'Westerly', 'CI', 4210, 41.36170000000, -71.80240000000, '107473'),
(12102, 'US-MI-107474', 'Ada', 'CI', 4190, 43.03140000000, -85.55030000000, '107474'),
(12103, 'US-NC-107475', 'Mill Spring', 'CI', 4201, 35.35660000000, -82.15740000000, '107475'),
(12104, 'US-MI-107476', 'Cheboygan', 'CI', 4190, 45.54520000000, -84.35500000000, '107476'),
(12105, 'US-MT-107477', 'Kalispell', 'CI', 4194, 48.19870000000, -114.38570000000, '107477'),
(12106, 'US-WA-107478', 'Nespelem', 'CI', 4219, 48.25510000000, -119.23960000000, '107478'),
(12107, 'US-WA-107479', 'Cheney', 'CI', 4219, 47.43130000000, -117.62920000000, '107479'),
(12108, 'US-WA-107480', 'Liberty Lake', 'CI', 4219, 47.63910000000, -117.09740000000, '107480'),
(12109, 'US-ID-107481', 'Mountain Home', 'CI', 4179, 43.36400000000, -115.52020000000, '107481'),
(12110, 'US-ID-107482', 'Twin Falls', 'CI', 4179, 42.41990000000, -114.59150000000, '107482'),
(12111, 'US-ID-107483', 'Moscow', 'CI', 4179, 46.71720000000, -116.91790000000, '107483'),
(12112, 'US-WA-107484', 'Fairfield', 'CI', 4219, 47.39100000000, -117.18280000000, '107484'),
(12113, 'US-WA-107485', 'Fairchild Air Force Base', 'CI', 4219, 47.61600000000, -117.65750000000, '107485'),
(12114, 'US-ID-107486', 'Rupert', 'CI', 4179, 42.70340000000, -113.62800000000, '107486'),
(12115, 'US-WA-107487', 'Rosalia', 'CI', 4219, 47.25990000000, -117.38420000000, '107487'),
(12116, 'US-TN-107488', 'Kodak', 'CI', 4213, 35.97130000000, -83.61930000000, '107488'),
(12117, 'US-TN-107489', 'Rogersville', 'CI', 4213, 36.45460000000, -83.03550000000, '107489'),
(12118, 'US-OH-107490', 'Dennison', 'CI', 4204, 40.42760000000, -81.29270000000, '107490'),
(12119, 'US-PA-107491', 'Mc Veytown', 'CI', 4208, 40.47950000000, -77.78640000000, '107491'),
(12120, 'US-NY-107492', 'Lynbrook', 'CI', 4200, 40.65780000000, -73.67200000000, '107492'),
(12121, 'US-NY-107493', 'Plattsburgh', 'CI', 4200, 44.74540000000, -73.46280000000, '107493'),
(12122, 'US-MA-107494', 'West Bridgewater', 'CI', 4189, 42.01780000000, -71.02420000000, '107494'),
(12123, 'US-CA-107495', 'Coachella', 'CI', 4169, 33.70210000000, -116.17120000000, '107495'),
(12124, 'US-MA-107496', 'Malden', 'CI', 4189, 42.42810000000, -71.05460000000, '107496'),
(12125, 'US-MA-107497', 'Hingham', 'CI', 4189, 42.21590000000, -70.87930000000, '107497'),
(12126, 'US-MA-107498', 'Avon', 'CI', 4189, 42.12850000000, -71.04690000000, '107498'),
(12127, 'US-MA-107499', 'Brighton', 'CI', 4189, 42.34840000000, -71.15510000000, '107499'),
(12128, 'US-MA-107500', 'Uxbridge', 'CI', 4189, 42.06280000000, -71.64370000000, '107500'),
(12129, 'US-PA-107501', 'Wellsville', 'CI', 4208, 40.05930000000, -76.93220000000, '107501'),
(12130, 'US-PA-107502', 'Millersburg', 'CI', 4208, 40.56710000000, -76.90430000000, '107502'),
(12131, 'US-PA-107503', 'Glen Rock', 'CI', 4208, 39.78750000000, -76.75390000000, '107503'),
(12132, 'US-PA-107504', 'Loganville', 'CI', 4208, 39.85260000000, -76.70700000000, '107504'),
(12133, 'US-PA-107505', 'Punxsutawney', 'CI', 4208, 40.95150000000, -78.97780000000, '107505'),
(12134, 'US-PA-107506', 'East Petersburg', 'CI', 4208, 40.09700000000, -76.35110000000, '107506'),
(12135, 'US-PA-107507', 'Grantville', 'CI', 4208, 40.40170000000, -76.65440000000, '107507'),
(12136, 'US-PA-107508', 'Mc Elhattan', 'CI', 4208, 41.15930000000, -77.36290000000, '107508'),
(12137, 'US-PA-107509', 'Hanover', 'CI', 4208, 39.79680000000, -76.99300000000, '107509'),
(12138, 'US-AL-107510', 'Florence', 'CI', 4161, 34.83150000000, -87.66640000000, '107510'),
(12139, 'US-LA-107511', 'Lake Charles', 'CI', 4185, 30.23330000000, -93.20150000000, '107511'),
(12140, 'US-MS-107512', 'Olive Branch', 'CI', 4192, 34.91800000000, -89.82160000000, '107512'),
(12141, 'US-TN-107513', 'Dyersburg', 'CI', 4213, 36.01240000000, -89.37790000000, '107513'),
(12142, 'US-IA-107514', 'Preston', 'CI', 4182, 42.04800000000, -90.44220000000, '107514'),
(12143, 'US-MS-107515', 'New Albany', 'CI', 4192, 34.48880000000, -88.99020000000, '107515'),
(12144, 'US-TN-107516', 'Adamsville', 'CI', 4213, 35.24310000000, -88.41520000000, '107516'),
(12145, 'US-TN-107517', 'Brownsville', 'CI', 4213, 35.61290000000, -89.28840000000, '107517'),
(12146, 'US-MI-107518', 'Orleans', 'CI', 4190, 43.07910000000, -85.10490000000, '107518'),
(12147, 'US-GA-107519', 'Dry Branch', 'CI', 4176, 32.68370000000, -83.51550000000, '107519'),
(12148, 'US-MS-107520', 'Grenada', 'CI', 4192, 33.74040000000, -89.83240000000, '107520'),
(12149, 'US-MS-107521', 'Leland', 'CI', 4192, 33.39340000000, -90.87170000000, '107521'),
(12150, 'US-MS-107522', 'Ashland', 'CI', 4192, 34.85730000000, -89.14020000000, '107522'),
(12151, 'US-NY-107523', 'Seneca Falls', 'CI', 4200, 42.86850000000, -76.78480000000, '107523'),
(12152, 'US-MS-107524', 'Smithville', 'CI', 4192, 34.07790000000, -88.33260000000, '107524'),
(12153, 'US-TN-107525', 'Selmer', 'CI', 4213, 35.15990000000, -88.60350000000, '107525'),
(12154, 'US-TN-107526', 'Toone', 'CI', 4213, 35.35730000000, -88.97730000000, '107526'),
(12155, 'US-AR-107527', 'Corning', 'CI', 4165, 36.39060000000, -90.56420000000, '107527'),
(12156, 'US-MS-107528', 'Cleveland', 'CI', 4192, 33.75680000000, -90.72970000000, '107528'),
(12157, 'US-PA-107529', 'Annville', 'CI', 4208, 40.34430000000, -76.55120000000, '107529'),
(12158, 'US-PA-107530', 'Spring Mills', 'CI', 4208, 40.83220000000, -77.58860000000, '107530'),
(12159, 'US-PA-107531', 'Coal Township', 'CI', 4208, 40.79420000000, -76.55760000000, '107531'),
(12160, 'US-PA-107532', 'Williamsport', 'CI', 4208, 41.17030000000, -77.04860000000, '107532'),
(12161, 'US-PA-107533', 'Ephrata', 'CI', 4208, 40.17570000000, -76.16580000000, '107533'),
(12162, 'US-PA-107534', 'Blue Ridge Summit', 'CI', 4208, 39.76510000000, -77.47550000000, '107534'),
(12163, 'US-TN-107535', 'Millington', 'CI', 4213, 35.33410000000, -89.87060000000, '107535'),
(12164, 'US-MO-107536', 'Excelsior Springs', 'CI', 4193, 39.31800000000, -94.21800000000, '107536'),
(12165, 'US-AR-107537', 'Weiner', 'CI', 4165, 35.61740000000, -90.88640000000, '107537'),
(12166, 'US-MS-107538', 'Greenville', 'CI', 4192, 33.32460000000, -90.98050000000, '107538'),
(12167, 'US-TN-107539', 'Atwood', 'CI', 4213, 35.99340000000, -88.65970000000, '107539'),
(12168, 'US-AR-107540', 'Pocahontas', 'CI', 4165, 36.30640000000, -90.97720000000, '107540'),
(12169, 'US-MS-107541', 'Holly Springs', 'CI', 4192, 34.77460000000, -89.45330000000, '107541'),
(12170, 'US-TN-107542', 'Mc Kenzie', 'CI', 4213, 36.15040000000, -88.53310000000, '107542'),
(12171, 'US-AR-107543', 'Walnut Ridge', 'CI', 4165, 36.03760000000, -90.90630000000, '107543'),
(12172, 'US-TN-107544', 'Milan', 'CI', 4213, 35.92510000000, -88.78580000000, '107544'),
(12173, 'US-PA-107545', 'Huntingdon', 'CI', 4208, 40.56220000000, -77.85450000000, '107545'),
(12174, 'US-PA-107546', 'New Cumberland', 'CI', 4208, 40.20720000000, -76.84780000000, '107546'),
(12175, 'US-PA-107547', 'New Holland', 'CI', 4208, 40.10860000000, -76.07070000000, '107547'),
(12176, 'US-VA-107548', 'Chester', 'CI', 4218, 37.33980000000, -77.45860000000, '107548'),
(12177, 'US-PA-107549', 'Troy', 'CI', 4208, 41.75490000000, -76.80550000000, '107549'),
(12178, 'US-OH-107550', 'Hillsboro', 'CI', 4204, 39.16690000000, -83.56550000000, '107550'),
(12179, 'US-PA-107551', 'Hatfield', 'CI', 4208, 40.28650000000, -75.29520000000, '107551'),
(12180, 'US-PA-107552', 'Imler', 'CI', 4208, 40.25910000000, -78.47050000000, '107552'),
(12181, 'US-PA-107553', 'Red Lion', 'CI', 4208, 39.89390000000, -76.55800000000, '107553'),
(12182, 'US-PA-107554', 'Montgomery', 'CI', 4208, 41.18170000000, -76.94920000000, '107554'),
(12183, 'US-IN-107555', 'Richmond', 'CI', 4181, 39.83810000000, -84.90540000000, '107555'),
(12184, 'US-PA-107556', 'Elizabethtown', 'CI', 4208, 40.16800000000, -76.60930000000, '107556'),
(12185, 'US-PA-107557', 'Leola', 'CI', 4208, 40.09440000000, -76.17700000000, '107557'),
(12186, 'US-CA-107558', 'American Canyon', 'CI', 4169, 38.18900000000, -122.25410000000, '107558'),
(12187, 'US-PA-107559', 'Palmyra', 'CI', 4208, 40.29230000000, -76.59090000000, '107559'),
(12188, 'US-CA-107560', 'Five Points', 'CI', 4169, 36.39600000000, -120.12930000000, '107560'),
(12189, 'US-PA-107561', 'Reynoldsville', 'CI', 4208, 41.11580000000, -78.90980000000, '107561'),
(12190, 'US-WI-107562', 'Random Lake', 'CI', 4221, 43.57170000000, -88.01050000000, '107562'),
(12191, 'US-PA-107563', 'Tyrone', 'CI', 4208, 40.65970000000, -78.24160000000, '107563'),
(12192, 'US-PA-107564', 'Lititz', 'CI', 4208, 40.17500000000, -76.30780000000, '107564'),
(12193, 'US-FL-107565', 'Astor', 'CI', 4175, 29.16130000000, -81.56000000000, '107565'),
(12194, 'US-CA-107566', 'Alameda', 'CI', 4169, 37.77350000000, -122.27880000000, '107566'),
(12195, 'US-OK-107567', 'Krebs', 'CI', 4205, 34.93080000000, -95.72230000000, '107567'),
(12196, 'US-MS-107568', 'Forest', 'CI', 4192, 32.33220000000, -89.47670000000, '107568'),
(12197, 'US-VT-107569', 'Cambridge', 'CI', 4216, 44.65790000000, -72.91920000000, '107569'),
(12198, 'US-AL-107570', 'Gilbertown', 'CI', 4161, 31.90660000000, -88.22500000000, '107570'),
(12199, 'US-MS-107571', 'Madison', 'CI', 4192, 32.51710000000, -90.13670000000, '107571'),
(12200, 'US-AL-107572', 'Atmore', 'CI', 4161, 31.17420000000, -87.49850000000, '107572'),
(12201, 'US-MS-107573', 'Magee', 'CI', 4192, 31.92870000000, -89.64690000000, '107573'),
(12202, 'US-VA-107574', 'Stuart', 'CI', 4218, 36.69460000000, -80.23090000000, '107574'),
(12203, 'US-AL-107575', 'Loxley', 'CI', 4161, 30.63880000000, -87.73780000000, '107575'),
(12204, 'US-LA-107576', 'Erath', 'CI', 4185, 29.91260000000, -92.04200000000, '107576'),
(12205, 'US-LA-107577', 'Alexandria', 'CI', 4185, 31.19990000000, -92.35080000000, '107577'),
(12206, 'US-AL-107578', 'Brewton', 'CI', 4161, 31.16650000000, -87.07610000000, '107578'),
(12207, 'US-MS-107579', 'Moselle', 'CI', 4192, 31.49550000000, -89.30120000000, '107579'),
(12208, 'US-FL-107580', 'Pompano Beach', 'CI', 4175, 26.24180000000, -80.16450000000, '107580'),
(12209, 'US-AL-107581', 'Bay Minette', 'CI', 4161, 30.88330000000, -87.72630000000, '107581'),
(12210, 'US-TN-107582', 'Jackson', 'CI', 4213, 35.57520000000, -88.85860000000, '107582'),
(12211, 'US-NY-107583', 'Binghamton', 'CI', 4200, 42.17940000000, -75.94910000000, '107583'),
(12212, 'US-NY-107584', 'Cazenovia', 'CI', 4200, 42.94190000000, -75.80330000000, '107584'),
(12213, 'US-NY-107585', 'Clinton', 'CI', 4200, 43.03610000000, -75.38170000000, '107585'),
(12214, 'US-CA-107586', 'Pleasant Hill', 'CI', 4169, 37.95360000000, -122.07800000000, '107586'),
(12215, 'US-NY-107587', 'Marion', 'CI', 4200, 43.15550000000, -77.16670000000, '107587'),
(12216, 'US-NY-107588', 'Canastota', 'CI', 4200, 43.07150000000, -75.76540000000, '107588'),
(12217, 'US-NY-107589', 'East Syracuse', 'CI', 4200, 43.08920000000, -76.02500000000, '107589'),
(12218, 'US-CA-107590', 'San Joaquin', 'CI', 4169, 36.59250000000, -120.19320000000, '107590'),
(12219, 'US-CA-107591', 'Groveland', 'CI', 4169, 37.85970000000, -119.76800000000, '107591'),
(12220, 'US-CA-107592', 'Walnut Creek', 'CI', 4169, 37.91810000000, -122.07350000000, '107592'),
(12221, 'US-NY-107593', 'Sidney', 'CI', 4200, 42.28750000000, -75.38610000000, '107593'),
(12222, 'US-NY-107594', 'Liverpool', 'CI', 4200, 43.15320000000, -76.21160000000, '107594'),
(12223, 'US-NY-107595', 'Herkimer', 'CI', 4200, 43.07620000000, -75.00610000000, '107595'),
(12224, 'US-NY-107596', 'Conklin', 'CI', 4200, 42.04540000000, -75.82240000000, '107596'),
(12225, 'US-NY-107597', 'Horseheads', 'CI', 4200, 42.21250000000, -76.78680000000, '107597'),
(12226, 'US-NY-107598', 'Phoenix', 'CI', 4200, 43.26290000000, -76.31050000000, '107598'),
(12227, 'US-CA-107599', 'Rio Vista', 'CI', 4169, 38.18850000000, -121.73210000000, '107599'),
(12228, 'US-NY-107600', 'Scipio Center', 'CI', 4200, 42.77030000000, -76.56470000000, '107600'),
(12229, 'US-NY-107601', 'Delhi', 'CI', 4200, 42.31790000000, -74.93080000000, '107601'),
(12230, 'US-NC-107602', 'Mount Ulla', 'CI', 4201, 35.66050000000, -80.70460000000, '107602'),
(12231, 'US-NC-107603', 'Highlands', 'CI', 4201, 35.07510000000, -83.21010000000, '107603'),
(12232, 'US-DE-107604', 'Harrington', 'CI', 4172, 38.90330000000, -75.61130000000, '107604'),
(12233, 'US-OR-107605', 'Scotts Mills', 'CI', 4206, 44.96760000000, -122.57800000000, '107605'),
(12234, 'US-NC-107606', 'Fletcher', 'CI', 4201, 35.46080000000, -82.47150000000, '107606'),
(12235, 'US-NC-107607', 'Burnsville', 'CI', 4201, 35.88070000000, -82.30950000000, '107607'),
(12236, 'US-UT-107608', 'Price', 'CI', 4215, 39.57510000000, -110.80240000000, '107608'),
(12237, 'US-CA-107609', 'Vacaville', 'CI', 4169, 38.41660000000, -122.01010000000, '107609'),
(12238, 'US-OH-107610', 'Canton', 'CI', 4204, 40.89960000000, -81.43960000000, '107610'),
(12239, 'US-UT-107611', 'Draper', 'CI', 4215, 40.49820000000, -111.84360000000, '107611'),
(12240, 'US-AL-107612', 'Mc Intosh', 'CI', 4161, 31.22700000000, -88.08690000000, '107612'),
(12241, 'US-IA-107613', 'Fayette', 'CI', 4182, 42.81860000000, -91.77560000000, '107613'),
(12242, 'US-FL-107614', 'Gulf Breeze', 'CI', 4175, 30.34520000000, -87.07290000000, '107614'),
(12243, 'US-IA-107615', 'Albia', 'CI', 4182, 41.03360000000, -92.84500000000, '107615'),
(12244, 'US-IA-107616', 'Iowa Falls', 'CI', 4182, 42.52080000000, -93.24730000000, '107616'),
(12245, 'US-IA-107617', 'Boone', 'CI', 4182, 42.10190000000, -93.84200000000, '107617'),
(12247, 'US-IA-107619', 'Lakota', 'CI', 4182, 43.40670000000, -94.09880000000, '107619'),
(12248, 'US-IA-107620', 'Independence', 'CI', 4182, 42.47390000000, -91.88700000000, '107620'),
(12249, 'US-IA-107621', 'Grundy Center', 'CI', 4182, 42.36930000000, -92.80750000000, '107621'),
(12250, 'US-IL-107622', 'White Hall', 'CI', 4180, 39.41240000000, -90.39730000000, '107622'),
(12251, 'US-IA-107623', 'Marion', 'CI', 4182, 42.06040000000, -91.58580000000, '107623'),
(12252, 'US-IA-107624', 'Lansing', 'CI', 4182, 43.36500000000, -91.27610000000, '107624'),
(12253, 'US-IA-107625', 'Sheldon', 'CI', 4182, 43.18580000000, -95.88070000000, '107625'),
(12254, 'US-IA-107626', 'Lamoni', 'CI', 4182, 40.67010000000, -93.93370000000, '107626'),
(12255, 'US-IA-107627', 'Newton', 'CI', 4182, 41.72320000000, -93.03340000000, '107627'),
(12256, 'US-CA-107628', 'Lomita', 'CI', 4169, 33.79190000000, -118.31840000000, '107628'),
(12257, 'US-NY-107629', 'Copake Falls', 'CI', 4200, 42.13990000000, -73.50810000000, '107629'),
(12258, 'US-NJ-107630', 'Bellmawr', 'CI', 4198, 39.86770000000, -75.09070000000, '107630'),
(12259, 'US-NY-107631', 'Rensselaer', 'CI', 4200, 42.61890000000, -73.70650000000, '107631'),
(12260, 'US-NY-107632', 'Malone', 'CI', 4200, 44.73840000000, -74.24880000000, '107632'),
(12261, 'US-NY-107633', 'Saranac Lake', 'CI', 4200, 44.35110000000, -74.10340000000, '107633'),
(12262, 'US-VT-107634', 'Waterbury Center', 'CI', 4216, 44.38330000000, -72.70470000000, '107634'),
(12263, 'US-VT-107635', 'Hardwick', 'CI', 4216, 44.51320000000, -72.38200000000, '107635'),
(12264, 'US-MO-107636', 'Camden Point', 'CI', 4193, 39.45730000000, -94.72200000000, '107636'),
(12265, 'US-NY-107637', 'Selkirk', 'CI', 4200, 42.53570000000, -73.83180000000, '107637'),
(12266, 'US-NY-107638', 'Rexford', 'CI', 4200, 42.84300000000, -73.85830000000, '107638'),
(12267, 'US-NY-107639', 'Hillsdale', 'CI', 4200, 42.21640000000, -73.54130000000, '107639'),
(12268, 'US-NM-107640', 'Santa Teresa', 'CI', 4199, 31.94600000000, -106.80820000000, '107640'),
(12269, 'US-NY-107641', 'Delmar', 'CI', 4200, 42.60970000000, -73.86790000000, '107641'),
(12270, 'US-NY-107642', 'Troy', 'CI', 4200, 42.74950000000, -73.59510000000, '107642'),
(12271, 'US-NY-107643', 'Hudson Falls', 'CI', 4200, 43.33990000000, -73.55100000000, '107643'),
(12272, 'US-VT-107644', 'Waitsfield', 'CI', 4216, 44.20300000000, -72.84280000000, '107644'),
(12273, 'US-IN-107645', 'Michigan City', 'CI', 4181, 41.68090000000, -86.86580000000, '107645'),
(12274, 'US-CO-107646', 'Hugo', 'CI', 4170, 38.99590000000, -103.46010000000, '107646'),
(12275, 'US-MA-107647', 'Auburndale', 'CI', 4189, 42.34440000000, -71.24790000000, '107647'),
(12276, 'US-NJ-107648', 'Lyndhurst', 'CI', 4198, 40.79230000000, -74.10010000000, '107648'),
(12277, 'US-CA-107649', 'Nicasio', 'CI', 4169, 38.07140000000, -122.67990000000, '107649'),
(12278, 'US-NE-107650', 'Central City', 'CI', 4195, 41.15960000000, -98.00080000000, '107650'),
(12279, 'US-AZ-107651', 'Vail', 'CI', 4164, 31.95820000000, -110.69300000000, '107651'),
(12280, 'US-FL-107652', 'Miramar Beach', 'CI', 4175, 30.39090000000, -86.31610000000, '107652'),
(12281, 'US-MO-107653', 'Ozark', 'CI', 4193, 36.97840000000, -93.23320000000, '107653'),
(12282, 'US-MS-107654', 'Canton', 'CI', 4192, 32.62520000000, -90.02290000000, '107654'),
(12283, 'US-MO-107655', 'Neosho', 'CI', 4193, 36.85410000000, -94.39900000000, '107655'),
(12284, 'US-MS-107656', 'Pearl', 'CI', 4192, 32.25390000000, -90.09480000000, '107656'),
(12285, 'US-MA-107657', 'Warren', 'CI', 4189, 42.21270000000, -72.19410000000, '107657'),
(12286, 'US-NY-107658', 'Rockville Centre', 'CI', 4200, 40.66590000000, -73.63950000000, '107658'),
(12287, 'US-TX-107659', 'Clifton', 'CI', 4214, 31.80140000000, -97.54320000000, '107659'),
(12288, 'US-TN-107660', 'Portland', 'CI', 4213, 36.55220000000, -86.52720000000, '107660'),
(12289, 'US-TN-107661', 'Shelbyville', 'CI', 4213, 35.46150000000, -86.48980000000, '107661'),
(12290, 'US-KY-107662', 'Glendale', 'CI', 4184, 37.58030000000, -85.94330000000, '107662'),
(12291, 'US-TN-107663', 'New Johnsonville', 'CI', 4213, 36.00390000000, -87.94280000000, '107663'),
(12292, 'US-TN-107664', 'Manchester', 'CI', 4213, 35.52060000000, -86.07030000000, '107664'),
(12293, 'US-AZ-107665', 'Fort Huachuca', 'CI', 4164, 31.52730000000, -110.36070000000, '107665'),
(12294, 'US-KY-107666', 'Scottsville', 'CI', 4184, 36.78470000000, -86.21190000000, '107666'),
(12295, 'US-TN-107667', 'Clarksville', 'CI', 4213, 36.46420000000, -87.37970000000, '107667'),
(12296, 'US-MS-107668', 'Bruce', 'CI', 4192, 34.02370000000, -89.36800000000, '107668'),
(12297, 'US-KY-107669', 'Franklin', 'CI', 4184, 36.73010000000, -86.56150000000, '107669'),
(12298, 'US-TN-107670', 'Lawrenceburg', 'CI', 4213, 35.27720000000, -87.41270000000, '107670'),
(12299, 'US-NJ-107671', 'Roebling', 'CI', 4198, 40.11470000000, -74.77940000000, '107671'),
(12300, 'US-TN-107672', 'Waynesboro', 'CI', 4213, 35.33040000000, -87.79000000000, '107672'),
(12301, 'US-TN-107673', 'Ethridge', 'CI', 4213, 35.32920000000, -87.27170000000, '107673'),
(12302, 'US-TN-107674', 'Sparta', 'CI', 4213, 35.92530000000, -85.45560000000, '107674'),
(12303, 'US-VA-107675', 'Waterford', 'CI', 4218, 39.18850000000, -77.62560000000, '107675'),
(12304, 'US-VA-107676', 'Berryville', 'CI', 4218, 39.16510000000, -77.97590000000, '107676'),
(12305, 'US-CA-107677', 'Big Sur', 'CI', 4169, 36.08580000000, -121.60860000000, '107677'),
(12306, 'US-MD-107678', 'Mount Airy', 'CI', 4188, 39.37950000000, -77.16560000000, '107678'),
(12307, 'US-MD-107679', 'Takoma Park', 'CI', 4188, 38.98270000000, -77.00400000000, '107679'),
(12308, 'US-VA-107680', 'Hume', 'CI', 4218, 38.81570000000, -78.03540000000, '107680'),
(12309, 'US-TX-107681', 'Orange', 'CI', 4214, 30.05660000000, -93.87540000000, '107681'),
(12310, 'US-MA-107682', 'Lawrence', 'CI', 4189, 42.70730000000, -71.16080000000, '107682'),
(12311, 'US-MD-107683', 'Kensington', 'CI', 4188, 39.02560000000, -77.07720000000, '107683'),
(12312, 'US-MD-107684', 'Clarksburg', 'CI', 4188, 39.26210000000, -77.30260000000, '107684'),
(12313, 'US-VA-107685', 'Upperville', 'CI', 4218, 39.00540000000, -77.88680000000, '107685'),
(12314, 'US-WI-107686', 'Eleva', 'CI', 4221, 44.58370000000, -91.49760000000, '107686'),
(12315, 'US-FL-107687', 'Largo', 'CI', 4175, 27.88460000000, -82.82770000000, '107687'),
(12316, 'US-OH-107688', 'Belpre', 'CI', 4204, 39.31320000000, -81.62460000000, '107688'),
(12317, 'US-FL-107689', 'Winter Haven', 'CI', 4175, 28.06190000000, -81.70710000000, '107689'),
(12318, 'US-WV-107690', 'Jane Lew', 'CI', 4220, 39.12110000000, -80.44810000000, '107690'),
(12319, 'US-FL-107691', 'Sebring', 'CI', 4175, 27.50330000000, -81.45390000000, '107691'),
(12320, 'US-MN-107692', 'Owatonna', 'CI', 4191, 44.04790000000, -93.22600000000, '107692'),
(12321, 'US-FL-107693', 'Plant City', 'CI', 4175, 28.01840000000, -82.14190000000, '107693'),
(12322, 'US-FL-107694', 'Lecanto', 'CI', 4175, 28.80010000000, -82.48600000000, '107694'),
(12323, 'US-FL-107695', 'Land O Lakes', 'CI', 4175, 28.25800000000, -82.47970000000, '107695'),
(12324, 'US-ID-107696', 'Mullan', 'CI', 4179, 47.46970000000, -115.74260000000, '107696'),
(12325, 'US-FL-107697', 'Bartow', 'CI', 4175, 27.88890000000, -81.81360000000, '107697'),
(12326, 'US-MD-107698', 'Prince Frederick', 'CI', 4188, 38.51850000000, -76.59210000000, '107698'),
(12327, 'US-KY-107699', 'Leitchfield', 'CI', 4184, 37.45640000000, -86.30930000000, '107699'),
(12328, 'US-KY-107700', 'Shelbyville', 'CI', 4184, 38.21450000000, -85.20530000000, '107700'),
(12329, 'US-IN-107701', 'Tell City', 'CI', 4181, 38.03360000000, -86.68530000000, '107701'),
(12330, 'US-KY-107702', 'Coxs Creek', 'CI', 4184, 37.93480000000, -85.52330000000, '107702'),
(12331, 'US-KY-107703', 'Lawrenceburg', 'CI', 4184, 38.00520000000, -84.98300000000, '107703'),
(12332, 'US-IN-107704', 'Princeton', 'CI', 4181, 38.33530000000, -87.59680000000, '107704'),
(12333, 'US-KY-107705', 'Berea', 'CI', 4184, 37.57420000000, -84.27000000000, '107705'),
(12334, 'US-KY-107706', 'Gray', 'CI', 4184, 36.92060000000, -83.97080000000, '107706'),
(12335, 'US-IN-107707', 'Jeffersonville', 'CI', 4181, 38.32830000000, -85.69570000000, '107707'),
(12336, 'US-IN-107708', 'Shoals', 'CI', 4181, 38.62880000000, -86.78630000000, '107708'),
(12337, 'US-KY-107709', 'Barbourville', 'CI', 4184, 36.91840000000, -83.90490000000, '107709'),
(12338, 'US-KY-107710', 'Henderson', 'CI', 4184, 37.82490000000, -87.53340000000, '107710'),
(12339, 'US-KY-107711', 'Frankfort', 'CI', 4184, 38.23570000000, -84.95920000000, '107711'),
(12340, 'US-NY-107712', 'Southampton', 'CI', 4200, 40.90770000000, -72.41780000000, '107712'),
(12341, 'US-VT-107713', 'Shoreham', 'CI', 4216, 43.87510000000, -73.32340000000, '107713'),
(12342, 'US-KY-107714', 'Irvine', 'CI', 4184, 37.66000000000, -83.96710000000, '107714'),
(12343, 'US-NY-107715', 'Quogue', 'CI', 4200, 40.82300000000, -72.60160000000, '107715'),
(12344, 'US-NY-107716', 'Medford', 'CI', 4200, 40.83140000000, -72.97580000000, '107716'),
(12345, 'US-NY-107717', 'Sag Harbor', 'CI', 4200, 40.99670000000, -72.32260000000, '107717'),
(12346, 'US-NY-107718', 'Bay Shore', 'CI', 4200, 40.73380000000, -73.26520000000, '107718'),
(12347, 'US-NY-107719', 'Riverhead', 'CI', 4200, 40.95390000000, -72.64650000000, '107719'),
(12348, 'US-NY-107720', 'Farmingville', 'CI', 4200, 40.84080000000, -73.03950000000, '107720'),
(12349, 'US-NY-107721', 'Port Jefferson Station', 'CI', 4200, 40.91300000000, -73.04320000000, '107721'),
(12350, 'US-NY-107722', 'East Setauket', 'CI', 4200, 40.93170000000, -73.11420000000, '107722'),
(12351, 'US-NY-107723', 'Montauk', 'CI', 4200, 41.03100000000, -71.98070000000, '107723'),
(12352, 'US-NY-107724', 'Mastic Beach', 'CI', 4200, 40.76620000000, -72.83770000000, '107724'),
(12353, 'US-RI-107725', 'Warren', 'CI', 4210, 41.72990000000, -71.25820000000, '107725'),
(12354, 'US-MA-107726', 'Fall River', 'CI', 4189, 41.67340000000, -71.15110000000, '107726'),
(12355, 'US-RI-107727', 'East Providence', 'CI', 4210, 41.81330000000, -71.36190000000, '107727'),
(12356, 'US-CT-107728', 'Pawcatuck', 'CI', 4171, 41.36860000000, -71.86370000000, '107728'),
(12357, 'US-RI-107729', 'Riverside', 'CI', 4210, 41.77270000000, -71.35030000000, '107729'),
(12358, 'US-OH-107730', 'Delta', 'CI', 4204, 41.58610000000, -84.01810000000, '107730'),
(12359, 'US-RI-107731', 'Bristol', 'CI', 4210, 41.67830000000, -71.27080000000, '107731'),
(12360, 'US-RI-107732', 'North Kingstown', 'CI', 4210, 41.58770000000, -71.46230000000, '107732'),
(12361, 'US-RI-107733', 'Greenville', 'CI', 4210, 41.88140000000, -71.55670000000, '107733'),
(12362, 'US-MA-107734', 'Seekonk', 'CI', 4189, 41.83870000000, -71.31870000000, '107734'),
(12363, 'US-MA-107735', 'Middleboro', 'CI', 4189, 41.88030000000, -70.88150000000, '107735'),
(12364, 'US-IN-107736', 'Rockport', 'CI', 4181, 37.89270000000, -87.13870000000, '107736'),
(12365, 'US-MA-107737', 'Hyannis', 'CI', 4189, 41.66130000000, -70.29880000000, '107737'),
(12366, 'US-RI-107738', 'Exeter', 'CI', 4210, 41.55320000000, -71.56180000000, '107738'),
(12367, 'US-MA-107739', 'Eastham', 'CI', 4189, 41.83750000000, -69.97480000000, '107739'),
(12368, 'US-MA-107740', 'New Bedford', 'CI', 4189, 41.70570000000, -70.94690000000, '107740'),
(12369, 'US-MA-107741', 'Mattapoisett', 'CI', 4189, 41.66490000000, -70.81090000000, '107741'),
(12370, 'US-MA-107742', 'Buzzards Bay', 'CI', 4189, 41.76830000000, -70.60070000000, '107742'),
(12371, 'US-MA-107743', 'Woods Hole', 'CI', 4189, 41.52810000000, -70.65350000000, '107743'),
(12372, 'US-RI-107744', 'Johnston', 'CI', 4210, 41.82870000000, -71.51850000000, '107744'),
(12373, 'US-MA-107745', 'Rochester', 'CI', 4189, 41.75340000000, -70.84810000000, '107745'),
(12374, 'US-CA-107746', 'Lake Forest', 'CI', 4169, 33.64510000000, -117.67860000000, '107746'),
(12375, 'US-OR-107747', 'Brookings', 'CI', 4206, 42.13860000000, -124.24640000000, '107747'),
(12376, 'US-OR-107748', 'Canby', 'CI', 4206, 45.21600000000, -122.66670000000, '107748'),
(12377, 'US-OR-107749', 'Dufur', 'CI', 4206, 45.40470000000, -121.16110000000, '107749'),
(12378, 'US-NY-107750', 'New Hyde Park', 'CI', 4200, 40.76010000000, -73.69570000000, '107750'),
(12379, 'US-IL-107751', 'La Salle', 'CI', 4180, 41.39270000000, -89.07760000000, '107751'),
(12380, 'US-NY-107752', 'Old Westbury', 'CI', 4200, 40.78980000000, -73.59640000000, '107752'),
(12381, 'US-IN-107753', 'Portage', 'CI', 4181, 41.59330000000, -87.15620000000, '107753'),
(12382, 'US-NY-107754', 'Glen Cove', 'CI', 4200, 40.87420000000, -73.62320000000, '107754'),
(12383, 'US-NY-107755', 'Jackson Heights', 'CI', 4200, 40.75170000000, -73.88320000000, '107755'),
(12384, 'US-IL-107756', 'Channahon', 'CI', 4180, 41.45100000000, -88.20140000000, '107756'),
(12385, 'US-UT-107757', 'Hildale', 'CI', 4215, 37.01010000000, -112.96600000000, '107757'),
(12386, 'US-IL-107758', 'Plainfield', 'CI', 4180, 41.61130000000, -88.24840000000, '107758'),
(12387, 'US-IL-107759', 'Lemont', 'CI', 4180, 41.68150000000, -87.97060000000, '107759'),
(12388, 'US-IL-107760', 'Minooka', 'CI', 4180, 41.48780000000, -88.32540000000, '107760'),
(12389, 'US-IL-107761', 'Romeoville', 'CI', 4180, 41.63980000000, -88.10600000000, '107761'),
(12390, 'US-NY-107762', 'Whitestone', 'CI', 4200, 40.78730000000, -73.81130000000, '107762'),
(12391, 'US-VA-107763', 'Sperryville', 'CI', 4218, 38.63530000000, -78.25480000000, '107763'),
(12392, 'US-MD-107764', 'Brandywine', 'CI', 4188, 38.65000000000, -76.82570000000, '107764'),
(12393, 'US-CA-107765', 'Hidden Valley Lake', 'CI', 4169, 38.80570000000, -122.55520000000, '107765'),
(12394, 'US-ME-107766', 'Harborside', 'CI', 4186, 44.33410000000, -68.80910000000, '107766'),
(12395, 'US-KY-107767', 'Somerset', 'CI', 4184, 37.05500000000, -84.45510000000, '107767'),
(12396, 'US-IN-107768', 'Clarksville', 'CI', 4181, 38.31360000000, -85.77160000000, '107768'),
(12398, 'US-VA-107770', 'Rustburg', 'CI', 4218, 37.25440000000, -79.09850000000, '107770'),
(12399, 'US-VA-107771', 'Lexington', 'CI', 4218, 37.80150000000, -79.51230000000, '107771'),
(12400, 'US-VA-107772', 'Prince George', 'CI', 4218, 37.22920000000, -77.25180000000, '107772'),
(12401, 'US-VA-107773', 'University Of Richmond', 'CI', 4218, 37.57780000000, -77.53460000000, '107773'),
(12402, 'US-VA-107774', 'Madison Heights', 'CI', 4218, 37.47020000000, -79.06520000000, '107774'),
(12403, 'US-VA-107775', 'Staunton', 'CI', 4218, 38.13610000000, -79.06230000000, '107775'),
(12404, 'US-VA-107776', 'Bowling Green', 'CI', 4218, 38.08590000000, -77.26570000000, '107776'),
(12405, 'US-VA-107777', 'Brookneal', 'CI', 4218, 37.07540000000, -78.92490000000, '107777'),
(12406, 'US-VA-107778', 'Lanexa', 'CI', 4218, 37.46970000000, -76.89640000000, '107778'),
(12407, 'US-VA-107779', 'Doswell', 'CI', 4218, 37.85160000000, -77.48200000000, '107779'),
(12408, 'US-CA-107780', 'Bellflower', 'CI', 4169, 33.88800000000, -118.13040000000, '107780'),
(12409, 'US-VA-107781', 'Lynchburg', 'CI', 4218, 37.34400000000, -79.20640000000, '107781'),
(12410, 'US-VA-107782', 'Altavista', 'CI', 4218, 37.14930000000, -79.23280000000, '107782'),
(12411, 'US-TX-107783', 'Pharr', 'CI', 4214, 26.15460000000, -98.20450000000, '107783'),
(12412, 'US-VA-107784', 'Millboro', 'CI', 4218, 38.02190000000, -79.65490000000, '107784'),
(12413, 'US-VA-107785', 'Scottsville', 'CI', 4218, 37.85360000000, -78.46410000000, '107785'),
(12414, 'US-VA-107786', 'Manakin Sabot', 'CI', 4218, 37.65290000000, -77.72230000000, '107786'),
(12415, 'US-VA-107787', 'Nellysford', 'CI', 4218, 37.90190000000, -78.90430000000, '107787'),
(12416, 'US-VA-107788', 'Arrington', 'CI', 4218, 37.70710000000, -78.93760000000, '107788'),
(12417, 'US-VA-107789', 'Deerfield', 'CI', 4218, 38.14060000000, -79.43790000000, '107789'),
(12418, 'US-VA-107790', 'Forest', 'CI', 4218, 37.36500000000, -79.30990000000, '107790'),
(12419, 'US-CA-107791', 'Newbury Park', 'CI', 4169, 34.17020000000, -118.95580000000, '107791'),
(12420, 'US-CA-107792', 'Port Hueneme Cbc Base', 'CI', 4169, 34.16210000000, -119.20740000000, '107792'),
(12421, 'US-NE-107793', 'Benkelman', 'CI', 4195, 40.17610000000, -101.53840000000, '107793'),
(12422, 'US-GA-107794', 'Lavonia', 'CI', 4176, 34.41680000000, -83.07380000000, '107794'),
(12423, 'US-CO-107795', 'Snowmass', 'CI', 4170, 39.21750000000, -107.01640000000, '107795'),
(12424, 'US-CO-107796', 'Montrose', 'CI', 4170, 38.40650000000, -107.89020000000, '107796'),
(12425, 'US-CO-107797', 'Fruita', 'CI', 4170, 39.19100000000, -108.70940000000, '107797'),
(12426, 'US-CO-107798', 'Sterling', 'CI', 4170, 40.63510000000, -103.23050000000, '107798'),
(12427, 'US-WY-107799', 'Jackson', 'CI', 4222, 43.45600000000, -110.51500000000, '107799'),
(12428, 'US-CA-107800', 'Pittsburg', 'CI', 4169, 38.00510000000, -121.83870000000, '107800'),
(12429, 'US-CA-107801', 'Vallejo', 'CI', 4169, 38.13850000000, -122.25240000000, '107801'),
(12430, 'US-OH-107802', 'Burton', 'CI', 4204, 41.44450000000, -81.15710000000, '107802'),
(12431, 'US-CA-107803', 'Lafayette', 'CI', 4169, 37.90210000000, -122.11570000000, '107803'),
(12432, 'US-MS-107804', 'Greenwood', 'CI', 4192, 33.52360000000, -90.14050000000, '107804'),
(12433, 'US-CA-107805', 'Brentwood', 'CI', 4169, 37.87540000000, -121.68680000000, '107805'),
(12434, 'US-GA-107806', 'Lagrange', 'CI', 4176, 33.00540000000, -85.10630000000, '107806'),
(12435, 'US-GA-107807', 'Trenton', 'CI', 4176, 34.89670000000, -85.52060000000, '107807'),
(12436, 'US-MA-107808', 'Nantucket', 'CI', 4189, 41.31520000000, -70.00900000000, '107808'),
(12437, 'US-GA-107809', 'Woodstock', 'CI', 4176, 34.12680000000, -84.57400000000, '107809'),
(12438, 'US-GA-107810', 'Dallas', 'CI', 4176, 33.99220000000, -84.85500000000, '107810'),
(12439, 'US-GA-107811', 'Manchester', 'CI', 4176, 32.88140000000, -84.60370000000, '107811'),
(12440, 'US-GA-107812', 'Cartersville', 'CI', 4176, 34.21870000000, -84.85400000000, '107812'),
(12441, 'US-AR-107813', 'Wynne', 'CI', 4165, 35.24180000000, -90.84600000000, '107813'),
(12442, 'US-CA-107814', 'Huntington Beach', 'CI', 4169, 33.71100000000, -118.04380000000, '107814'),
(12443, 'US-OH-107815', 'Mansfield', 'CI', 4204, 40.77880000000, -82.45720000000, '107815'),
(12444, 'US-OR-107816', 'White City', 'CI', 4206, 42.56500000000, -122.92190000000, '107816'),
(12445, 'US-WI-107817', 'Franklin', 'CI', 4221, 42.88690000000, -88.00960000000, '107817'),
(12446, 'US-WI-107818', 'Elkhorn', 'CI', 4221, 42.71300000000, -88.54290000000, '107818'),
(12447, 'US-IL-107819', 'Lostant', 'CI', 4180, 41.14820000000, -89.08920000000, '107819'),
(12448, 'US-WI-107820', 'Two Rivers', 'CI', 4221, 44.22550000000, -87.61440000000, '107820'),
(12449, 'US-WI-107821', 'Sullivan', 'CI', 4221, 43.02650000000, -88.60080000000, '107821'),
(12450, 'US-CA-107822', 'El Monte', 'CI', 4169, 34.07340000000, -118.01390000000, '107822'),
(12451, 'US-SC-107823', 'Donalds', 'CI', 4211, 34.36410000000, -82.34400000000, '107823'),
(12452, 'US-VA-107824', 'Stony Creek', 'CI', 4218, 36.91260000000, -77.44030000000, '107824'),
(12453, 'US-IL-107825', 'Taylorville', 'CI', 4180, 39.55460000000, -89.29290000000, '107825'),
(12454, 'US-MO-107826', 'Palmyra', 'CI', 4193, 39.79510000000, -91.53720000000, '107826'),
(12455, 'US-IL-107827', 'Brighton', 'CI', 4180, 39.04130000000, -90.15000000000, '107827'),
(12456, 'US-MO-107828', 'Mineral Point', 'CI', 4193, 37.91490000000, -90.70770000000, '107828'),
(12457, 'US-MO-107829', 'Shell Knob', 'CI', 4193, 36.62760000000, -93.47440000000, '107829'),
(12458, 'US-AR-107830', 'Rogers', 'CI', 4165, 36.30180000000, -94.12150000000, '107830'),
(12459, 'US-MO-107831', 'Bolivar', 'CI', 4193, 37.64220000000, -93.39960000000, '107831'),
(12460, 'US-AR-107832', 'Siloam Springs', 'CI', 4165, 36.16900000000, -94.45640000000, '107832'),
(12461, 'US-MO-107833', 'Miller', 'CI', 4193, 37.23060000000, -93.84850000000, '107833'),
(12462, 'US-TX-107834', 'Hemphill', 'CI', 4214, 31.32810000000, -93.80820000000, '107834'),
(12463, 'US-TX-107835', 'Kingwood', 'CI', 4214, 30.05400000000, -95.22300000000, '107835'),
(12464, 'US-TX-107836', 'Big Sandy', 'CI', 4214, 32.64310000000, -95.11170000000, '107836'),
(12465, 'US-TX-107837', 'Weslaco', 'CI', 4214, 26.17220000000, -97.98120000000, '107837'),
(12466, 'US-UT-107838', 'Pleasant Grove', 'CI', 4215, 40.46470000000, -111.63320000000, '107838'),
(12467, 'US-GA-107839', 'Kingsland', 'CI', 4176, 30.79850000000, -81.72070000000, '107839'),
(12468, 'US-SC-107840', 'Okatie', 'CI', 4211, 32.30990000000, -80.92110000000, '107840'),
(12469, 'US-GA-107841', 'Richmond Hill', 'CI', 4176, 31.85460000000, -81.27380000000, '107841'),
(12470, 'US-OH-107842', 'Kent', 'CI', 4204, 41.13520000000, -81.32600000000, '107842'),
(12471, 'US-WA-107843', 'Elk', 'CI', 4219, 48.01300000000, -117.22400000000, '107843'),
(12472, 'US-OR-107844', 'La Grande', 'CI', 4206, 45.32300000000, -118.20270000000, '107844'),
(12473, 'US-NV-107845', 'Jackpot', 'CI', 4196, 41.85400000000, -114.75610000000, '107845'),
(12474, 'US-MT-107846', 'Havre', 'CI', 4194, 48.56660000000, -109.73890000000, '107846'),
(12475, 'US-ID-107847', 'Parma', 'CI', 4179, 43.80730000000, -116.91700000000, '107847'),
(12476, 'US-ID-107848', 'Orofino', 'CI', 4179, 46.48670000000, -116.12680000000, '107848'),
(12477, 'US-MT-107849', 'Great Falls', 'CI', 4194, 47.29940000000, -111.34410000000, '107849'),
(12478, 'US-ID-107850', 'Saint Maries', 'CI', 4179, 47.20100000000, -116.55210000000, '107850'),
(12479, 'US-SC-107851', 'Chapin', 'CI', 4211, 34.14040000000, -81.33690000000, '107851'),
(12480, 'US-SC-107852', 'Sumter', 'CI', 4211, 33.88080000000, -80.35360000000, '107852'),
(12481, 'US-MI-107853', 'Roscommon', 'CI', 4190, 44.46690000000, -84.61290000000, '107853'),
(12482, 'US-MI-107854', 'Grand Haven', 'CI', 4190, 43.01610000000, -86.12670000000, '107854'),
(12483, 'US-MI-107855', 'Benton Harbor', 'CI', 4190, 42.12730000000, -86.30730000000, '107855'),
(12484, 'US-WI-107856', 'Rice Lake', 'CI', 4221, 45.52330000000, -91.69990000000, '107856'),
(12485, 'US-IL-107857', 'Glen Ellyn', 'CI', 4180, 41.86610000000, -88.05830000000, '107857'),
(12486, 'US-IL-107858', 'Hillside', 'CI', 4180, 41.86490000000, -87.90140000000, '107858'),
(12487, 'US-GA-107859', 'Statesboro', 'CI', 4176, 32.37290000000, -81.84430000000, '107859'),
(12488, 'US-FL-107860', 'Bonifay', 'CI', 4175, 30.82570000000, -85.73570000000, '107860'),
(12489, 'US-AL-107861', 'Gadsden', 'CI', 4161, 34.03790000000, -85.81050000000, '107861'),
(12490, 'US-FL-107862', 'Marianna', 'CI', 4175, 30.67550000000, -85.20140000000, '107862'),
(12491, 'US-FL-107863', 'Perry', 'CI', 4175, 30.18830000000, -83.55140000000, '107863'),
(12492, 'US-FL-107864', 'Orange Park', 'CI', 4175, 30.16720000000, -81.77150000000, '107864'),
(12493, 'US-FL-107865', 'Graceville', 'CI', 4175, 30.91360000000, -85.51120000000, '107865'),
(12494, 'US-TX-107866', 'Aledo', 'CI', 4214, 32.66550000000, -97.61250000000, '107866'),
(12495, 'US-KS-107867', 'Fort Leavenworth', 'CI', 4183, 39.36030000000, -94.91510000000, '107867'),
(12496, 'US-KS-107868', 'New Century', 'CI', 4183, 38.82490000000, -94.89920000000, '107868'),
(12497, 'US-TX-107869', 'Monahans', 'CI', 4214, 31.53980000000, -102.88120000000, '107869'),
(12498, 'US-IL-107870', 'Carol Stream', 'CI', 4180, 41.91530000000, -88.12870000000, '107870'),
(12499, 'US-IL-107871', 'Aurora', 'CI', 4180, 41.76530000000, -88.37700000000, '107871'),
(12500, 'US-KS-107872', 'Council Grove', 'CI', 4183, 38.66410000000, -96.46300000000, '107872'),
(12501, 'US-IL-107873', 'Maywood', 'CI', 4180, 41.88130000000, -87.84410000000, '107873'),
(12502, 'US-KS-107874', 'Home', 'CI', 4183, 39.84150000000, -96.50420000000, '107874'),
(12503, 'US-KS-107875', 'Riley', 'CI', 4183, 39.29820000000, -96.84610000000, '107875'),
(12504, 'US-TX-107876', 'New Braunfels', 'CI', 4214, 29.70440000000, -98.07420000000, '107876'),
(12505, 'US-KS-107877', 'Solomon', 'CI', 4183, 38.95770000000, -97.40860000000, '107877'),
(12506, 'US-IL-107878', 'Toluca', 'CI', 4180, 40.98500000000, -89.15210000000, '107878'),
(12507, 'PR-??-107879', 'Catano', 'CI', 181, 18.44150000000, -66.14480000000, '107879'),
(12508, 'US-IL-107880', 'La Grange', 'CI', 4180, 41.77760000000, -87.86050000000, '107880'),
(12509, 'US-MO-107881', 'Liberty', 'CI', 4193, 39.26920000000, -94.38910000000, '107881'),
(12510, 'US-CA-107882', 'Mountain Ranch', 'CI', 4169, 38.23100000000, -120.49870000000, '107882'),
(12511, 'US-NV-107883', 'Fallon', 'CI', 4196, 39.50490000000, -118.28990000000, '107883'),
(12512, 'US-CA-107884', 'Grover Beach', 'CI', 4169, 35.12120000000, -120.61930000000, '107884'),
(12513, 'US-IL-107885', 'Westchester', 'CI', 4180, 41.84870000000, -87.89210000000, '107885'),
(12514, 'US-IL-107886', 'Cornell', 'CI', 4180, 41.02510000000, -88.72960000000, '107886'),
(12515, 'US-TN-107887', 'Humboldt', 'CI', 4213, 35.81930000000, -88.95220000000, '107887'),
(12516, 'US-NC-107888', 'Tryon', 'CI', 4201, 35.24060000000, -82.04870000000, '107888'),
(12517, 'US-AL-107889', 'Owens Cross Roads', 'CI', 4161, 34.63400000000, -86.45700000000, '107889'),
(12518, 'US-WI-107890', 'Eau Claire', 'CI', 4221, 44.83400000000, -91.57290000000, '107890'),
(12519, 'US-WI-107891', 'New Richmond', 'CI', 4221, 45.12610000000, -92.51280000000, '107891'),
(12520, 'US-WI-107892', 'Mondovi', 'CI', 4221, 44.57840000000, -91.71480000000, '107892'),
(12521, 'US-MN-107893', 'Caledonia', 'CI', 4191, 43.62350000000, -91.41550000000, '107893'),
(12522, 'US-WI-107894', 'Wisconsin Dells', 'CI', 4221, 43.69640000000, -89.75750000000, '107894'),
(12523, 'US-MS-107895', 'Hattiesburg', 'CI', 4192, 31.31560000000, -89.41310000000, '107895'),
(12524, 'US-MN-107896', 'Floodwood', 'CI', 4191, 46.98100000000, -92.89710000000, '107896'),
(12525, 'US-NJ-107897', 'Allendale', 'CI', 4198, 41.03340000000, -74.13500000000, '107897'),
(12526, 'US-MN-107898', 'Warren', 'CI', 4191, 48.19530000000, -96.73930000000, '107898'),
(12527, 'US-PA-107899', 'Drums', 'CI', 4208, 41.04840000000, -76.00190000000, '107899'),
(12528, 'US-IL-107900', 'Bellwood', 'CI', 4180, 41.88110000000, -87.87860000000, '107900'),
(12529, 'US-CA-107901', 'Venice', 'CI', 4169, 33.99440000000, -118.46380000000, '107901'),
(12530, 'US-IL-107902', 'Plano', 'CI', 4180, 41.67250000000, -88.52700000000, '107902'),
(12531, 'US-IL-107903', 'Broadview', 'CI', 4180, 41.85690000000, -87.85520000000, '107903'),
(12532, 'US-MA-107904', 'Georgetown', 'CI', 4189, 42.72460000000, -70.97900000000, '107904'),
(12533, 'US-IL-107905', 'Oswego', 'CI', 4180, 41.66350000000, -88.31550000000, '107905'),
(12534, 'US-IL-107906', 'Pontiac', 'CI', 4180, 40.87300000000, -88.62440000000, '107906'),
(12535, 'US-IL-107907', 'Manhattan', 'CI', 4180, 41.38820000000, -87.95430000000, '107907'),
(12536, 'US-NJ-107908', 'Edgewater', 'CI', 4198, 40.82690000000, -73.97650000000, '107908'),
(12537, 'US-LA-107909', 'Sterlington', 'CI', 4185, 32.72450000000, -92.12150000000, '107909'),
(12538, 'US-IL-107910', 'Lafox', 'CI', 4180, 41.88420000000, -88.43240000000, '107910'),
(12539, 'US-KY-107911', 'Maysville', 'CI', 4184, 38.60750000000, -83.79280000000, '107911'),
(12540, 'US-KY-107912', 'Paintsville', 'CI', 4184, 37.81560000000, -82.78280000000, '107912'),
(12541, 'US-IL-107913', 'Forrest', 'CI', 4180, 40.75770000000, -88.39610000000, '107913'),
(12542, 'US-CA-107914', 'Rancho Mirage', 'CI', 4169, 33.78540000000, -116.41900000000, '107914'),
(12543, 'US-CA-107915', 'Bloomington', 'CI', 4169, 34.06080000000, -117.39360000000, '107915'),
(12544, 'US-NJ-107916', 'Englishtown', 'CI', 4198, 40.27870000000, -74.36830000000, '107916'),
(12545, 'US-CA-107917', 'North Palm Springs', 'CI', 4169, 33.92290000000, -116.54940000000, '107917'),
(12546, 'US-CA-107918', 'Forest Falls', 'CI', 4169, 34.08480000000, -116.90630000000, '107918'),
(12547, 'US-NJ-107919', 'Newton', 'CI', 4198, 41.06670000000, -74.81280000000, '107919'),
(12548, 'US-CA-107920', 'Fort Irwin', 'CI', 4169, 35.30010000000, -116.74420000000, '107920'),
(12549, 'US-IL-107921', 'Lincoln', 'CI', 4180, 40.12910000000, -89.36410000000, '107921'),
(12550, 'US-IL-107922', 'Clinton', 'CI', 4180, 40.14620000000, -88.97460000000, '107922'),
(12551, 'US-GA-107923', 'Fort Stewart', 'CI', 4176, 31.86670000000, -81.60960000000, '107923'),
(12552, 'US-FL-107924', 'Casselberry', 'CI', 4175, 28.66160000000, -81.31200000000, '107924'),
(12553, 'US-MA-107925', 'Needham', 'CI', 4189, 42.27930000000, -71.24500000000, '107925'),
(12554, 'US-MA-107926', 'Stow', 'CI', 4189, 42.42810000000, -71.51170000000, '107926'),
(12555, 'US-AR-107927', 'Van Buren', 'CI', 4165, 35.48300000000, -94.34690000000, '107927'),
(12556, 'US-MD-107928', 'Chester', 'CI', 4188, 38.94960000000, -76.27750000000, '107928'),
(12557, 'US-MD-107929', 'Solomons', 'CI', 4188, 38.33460000000, -76.46810000000, '107929'),
(12558, 'US-MD-107930', 'Severna Park', 'CI', 4188, 39.07350000000, -76.56540000000, '107930'),
(12559, 'US-MD-107931', 'Glen Arm', 'CI', 4188, 39.45230000000, -76.50220000000, '107931'),
(12560, 'US-MD-107932', 'Catonsville', 'CI', 4188, 39.26940000000, -76.74470000000, '107932'),
(12561, 'US-MD-107933', 'Street', 'CI', 4188, 39.64480000000, -76.36880000000, '107933'),
(12562, 'US-MD-107934', 'Ellicott City', 'CI', 4188, 39.27680000000, -76.90150000000, '107934'),
(12563, 'US-MD-107935', 'Chestertown', 'CI', 4188, 39.19340000000, -76.09690000000, '107935'),
(12564, 'US-MD-107936', 'Stevensville', 'CI', 4188, 38.93800000000, -76.33250000000, '107936'),
(12565, 'US-MD-107937', 'Davidsonville', 'CI', 4188, 38.93920000000, -76.63500000000, '107937'),
(12566, 'US-MD-107938', 'Pikesville', 'CI', 4188, 39.38170000000, -76.72650000000, '107938'),
(12567, 'US-MD-107939', 'Edgewood', 'CI', 4188, 39.43290000000, -76.29310000000, '107939'),
(12568, 'US-MD-107940', 'Earleville', 'CI', 4188, 39.42110000000, -75.94360000000, '107940'),
(12569, 'US-MD-107941', 'Brooklyn', 'CI', 4188, 39.22530000000, -76.61580000000, '107941'),
(12570, 'US-MD-107942', 'Deale', 'CI', 4188, 38.78720000000, -76.54360000000, '107942'),
(12571, 'US-MD-107943', 'Owings', 'CI', 4188, 38.68910000000, -76.61480000000, '107943'),
(12572, 'US-MD-107944', 'Bowie', 'CI', 4188, 38.99270000000, -76.73830000000, '107944'),
(12573, 'US-NC-107945', 'Autryville', 'CI', 4201, 35.03130000000, -78.62620000000, '107945'),
(12574, 'US-IN-107946', 'Batesville', 'CI', 4181, 39.29510000000, -85.21070000000, '107946'),
(12575, 'US-IN-107947', 'Vincennes', 'CI', 4181, 38.63890000000, -87.52760000000, '107947'),
(12576, 'US-IN-107948', 'Worthington', 'CI', 4181, 39.14640000000, -86.99930000000, '107948'),
(12577, 'US-IN-107949', 'Rensselaer', 'CI', 4181, 40.99430000000, -87.12290000000, '107949'),
(12578, 'US-IN-107950', 'Gary', 'CI', 4181, 41.60800000000, -87.34110000000, '107950'),
(12579, 'US-IL-107951', 'Calumet City', 'CI', 4180, 41.60920000000, -87.55340000000, '107951'),
(12580, 'US-IL-107952', 'Bridgeview', 'CI', 4180, 41.73980000000, -87.80950000000, '107952'),
(12581, 'US-IN-107953', 'Crown Point', 'CI', 4181, 41.39690000000, -87.32740000000, '107953'),
(12582, 'US-IN-107954', 'Warsaw', 'CI', 4181, 41.20230000000, -85.86300000000, '107954'),
(12583, 'US-IL-107955', 'Tinley Park', 'CI', 4180, 41.56960000000, -87.79940000000, '107955'),
(12584, 'US-IL-107956', 'Alsip', 'CI', 4180, 41.67140000000, -87.73710000000, '107956'),
(12585, 'US-IN-107957', 'Griffith', 'CI', 4181, 41.52290000000, -87.41830000000, '107957'),
(12586, 'US-IL-107958', 'Palos Hills', 'CI', 4180, 41.69950000000, -87.83660000000, '107958'),
(12587, 'US-IN-107959', 'Chesterton', 'CI', 4181, 41.61620000000, -87.04890000000, '107959'),
(12588, 'US-MI-107960', 'Macomb', 'CI', 4190, 42.67350000000, -82.91650000000, '107960'),
(12589, 'US-MI-107961', 'Marysville', 'CI', 4190, 42.90660000000, -82.47670000000, '107961'),
(12590, 'US-MI-107962', 'Brown City', 'CI', 4190, 43.21640000000, -82.99740000000, '107962'),
(12591, 'US-MI-107963', 'Port Huron', 'CI', 4190, 42.98750000000, -82.46660000000, '107963'),
(12592, 'US-MI-107964', 'East China', 'CI', 4190, 42.77090000000, -82.54280000000, '107964'),
(12593, 'US-MI-107965', 'Saint Clair', 'CI', 4190, 42.85490000000, -82.54610000000, '107965'),
(12594, 'US-MI-107966', 'Bay City', 'CI', 4190, 43.56740000000, -83.82210000000, '107966'),
(12595, 'US-MI-107967', 'Lapeer', 'CI', 4190, 43.05190000000, -83.33460000000, '107967'),
(12596, 'US-MI-107968', 'Hartland', 'CI', 4190, 42.64140000000, -83.71880000000, '107968'),
(12597, 'US-MI-107969', 'Leonard', 'CI', 4190, 42.84370000000, -83.14090000000, '107969'),
(12598, 'US-FL-107970', 'Summerfield', 'CI', 4175, 29.00710000000, -82.05130000000, '107970'),
(12599, 'US-IN-107971', 'Monroe', 'CI', 4181, 40.72010000000, -84.90780000000, '107971'),
(12600, 'US-MI-107972', 'Durand', 'CI', 4190, 42.89490000000, -84.00920000000, '107972'),
(12601, 'US-MI-107973', 'Washington', 'CI', 4190, 42.73640000000, -83.03740000000, '107973'),
(12602, 'US-IL-107974', 'Mount Vernon', 'CI', 4180, 38.31780000000, -88.89210000000, '107974'),
(12603, 'US-MI-107975', 'Royal Oak', 'CI', 4190, 42.48950000000, -83.14190000000, '107975'),
(12604, 'US-MI-107976', 'Davison', 'CI', 4190, 43.04430000000, -83.51920000000, '107976'),
(12605, 'US-MI-107977', 'Clarkston', 'CI', 4190, 42.72370000000, -83.42220000000, '107977'),
(12606, 'US-NH-107978', 'Franconia', 'CI', 4197, 44.16350000000, -71.76120000000, '107978'),
(12607, 'US-MA-107979', 'Rockland', 'CI', 4189, 42.12950000000, -70.91230000000, '107979'),
(12608, 'US-TX-107980', 'Montgomery', 'CI', 4214, 30.43490000000, -95.71190000000, '107980'),
(12609, 'US-OH-107981', 'Bellevue', 'CI', 4204, 41.24460000000, -82.84590000000, '107981'),
(12610, 'US-NC-107982', 'Canton', 'CI', 4201, 35.45970000000, -82.86770000000, '107982'),
(12611, 'US-TN-107983', 'Church Hill', 'CI', 4213, 36.55320000000, -82.72900000000, '107983'),
(12612, 'US-SC-107984', 'Hartsville', 'CI', 4211, 34.40210000000, -80.07670000000, '107984'),
(12613, 'US-FL-107985', 'Ormond Beach', 'CI', 4175, 29.30050000000, -81.19480000000, '107985'),
(12614, 'US-AZ-107986', 'Surprise', 'CI', 4164, 33.64750000000, -112.38840000000, '107986'),
(12615, 'US-CA-107987', 'Orland', 'CI', 4169, 39.73040000000, -122.33790000000, '107987'),
(12616, 'US-NC-107988', 'Monroe', 'CI', 4201, 35.06910000000, -80.53020000000, '107988'),
(12617, 'US-PA-107989', 'Mc Sherrystown', 'CI', 4208, 39.80780000000, -77.01820000000, '107989'),
(12618, 'US-NY-107990', 'Forest Hills', 'CI', 4200, 40.72290000000, -73.84240000000, '107990'),
(12619, 'US-IA-107991', 'Coralville', 'CI', 4182, 41.69460000000, -91.59540000000, '107991'),
(12620, 'US-FL-107992', 'San Antonio', 'CI', 4175, 28.32000000000, -82.26090000000, '107992'),
(12621, 'US-CA-107993', 'San Bruno', 'CI', 4169, 37.62280000000, -122.43640000000, '107993'),
(12622, 'US-FL-107994', 'Orange City', 'CI', 4175, 28.94040000000, -81.30390000000, '107994'),
(12623, 'VI-??-107995', 'St Thomas', 'CI', 237, 18.32230000000, -64.96370000000, '107995'),
(12624, 'US-MA-107996', 'Spencer', 'CI', 4189, 42.24730000000, -71.99030000000, '107996'),
(12625, 'US-MA-107997', 'Northborough', 'CI', 4189, 42.32180000000, -71.63500000000, '107997'),
(12626, 'US-PA-107998', 'Claysburg', 'CI', 4208, 40.28390000000, -78.50620000000, '107998'),
(12627, 'US-KS-107999', 'Weir', 'CI', 4183, 37.28070000000, -94.74110000000, '107999'),
(12628, 'US-MO-108000', 'Aurora', 'CI', 4193, 36.87880000000, -93.72060000000, '108000'),
(12629, 'US-AR-108001', 'Mountain Home', 'CI', 4165, 36.33160000000, -92.41030000000, '108001'),
(12630, 'US-AR-108002', 'Harrison', 'CI', 4165, 36.22700000000, -93.11510000000, '108002'),
(12631, 'US-MO-108003', 'Branson', 'CI', 4193, 36.66960000000, -93.26150000000, '108003'),
(12632, 'US-AR-108004', 'Clarksville', 'CI', 4165, 35.50710000000, -93.51190000000, '108004'),
(12633, 'US-KS-108005', 'Pittsburg', 'CI', 4183, 37.35060000000, -94.68190000000, '108005'),
(12634, 'US-NY-108006', 'Wainscott', 'CI', 4200, 40.95280000000, -72.24980000000, '108006'),
(12635, 'US-MO-108007', 'Marionville', 'CI', 4193, 37.05580000000, -93.62820000000, '108007'),
(12636, 'US-AR-108008', 'Paris', 'CI', 4165, 35.28380000000, -93.72460000000, '108008');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(12637, 'US-MI-108009', 'Watervliet', 'CI', 4190, 42.17190000000, -86.24180000000, '108009'),
(12638, 'US-AR-108010', 'Springdale', 'CI', 4165, 36.17370000000, -94.08000000000, '108010'),
(12639, 'US-MO-108011', 'Gainesville', 'CI', 4193, 36.60820000000, -92.43480000000, '108011'),
(12640, 'US-MO-108012', 'Ash Grove', 'CI', 4193, 37.26470000000, -93.60260000000, '108012'),
(12641, 'US-MO-108013', 'Kimberling City', 'CI', 4193, 36.62910000000, -93.44400000000, '108013'),
(12642, 'US-MO-108014', 'Farmington', 'CI', 4193, 37.77210000000, -90.36720000000, '108014'),
(12643, 'US-MO-108015', 'New Florence', 'CI', 4193, 38.88320000000, -91.45210000000, '108015'),
(12644, 'US-KY-108016', 'Kuttawa', 'CI', 4184, 37.07530000000, -88.16490000000, '108016'),
(12645, 'US-IL-108017', 'Chatham', 'CI', 4180, 39.68430000000, -89.72370000000, '108017'),
(12646, 'US-MO-108018', 'Ashland', 'CI', 4193, 38.78120000000, -92.25420000000, '108018'),
(12647, 'US-IL-108019', 'Mounds', 'CI', 4180, 37.12160000000, -89.20800000000, '108019'),
(12648, 'US-MO-108020', 'Bowling Green', 'CI', 4193, 39.29780000000, -91.18890000000, '108020'),
(12649, 'US-IL-108021', 'Du Quoin', 'CI', 4180, 38.00270000000, -89.24790000000, '108021'),
(12650, 'US-IL-108022', 'Greenup', 'CI', 4180, 39.26400000000, -88.11950000000, '108022'),
(12651, 'US-NH-108023', 'Kearsarge', 'CI', 4197, 44.07280000000, -71.13300000000, '108023'),
(12652, 'US-IL-108024', 'Cicero', 'CI', 4180, 41.84060000000, -87.75880000000, '108024'),
(12653, 'US-NJ-108025', 'Asbury Park', 'CI', 4198, 40.24340000000, -74.03870000000, '108025'),
(12654, 'US-NJ-108026', 'Toms River', 'CI', 4198, 40.00400000000, -74.22580000000, '108026'),
(12655, 'US-NJ-108027', 'Farmingdale', 'CI', 4198, 40.20930000000, -74.15880000000, '108027'),
(12656, 'US-NJ-108028', 'Freehold', 'CI', 4198, 40.23210000000, -74.29860000000, '108028'),
(12657, 'US-NJ-108029', 'Howell', 'CI', 4198, 40.15240000000, -74.19780000000, '108029'),
(12658, 'US-NJ-108030', 'Atlantic Highlands', 'CI', 4198, 40.40330000000, -74.03640000000, '108030'),
(12659, 'US-NJ-108031', 'Neptune', 'CI', 4198, 40.21820000000, -74.07100000000, '108031'),
(12660, 'US-NJ-108032', 'Fair Haven', 'CI', 4198, 40.35940000000, -74.03640000000, '108032'),
(12661, 'US-NJ-108033', 'Leonardo', 'CI', 4198, 40.41140000000, -74.06470000000, '108033'),
(12662, 'US-PA-108034', 'Downingtown', 'CI', 4208, 40.03260000000, -75.71900000000, '108034'),
(12663, 'US-NJ-108035', 'Marlboro', 'CI', 4198, 40.31610000000, -74.25770000000, '108035'),
(12664, 'US-NJ-108036', 'Shrewsbury', 'CI', 4198, 40.32540000000, -74.05790000000, '108036'),
(12665, 'US-NJ-108037', 'Manasquan', 'CI', 4198, 40.12020000000, -74.06730000000, '108037'),
(12666, 'US-NJ-108038', 'Point Pleasant Beach', 'CI', 4198, 40.08080000000, -74.04920000000, '108038'),
(12667, 'US-NJ-108039', 'Highlands', 'CI', 4198, 40.43790000000, -73.98510000000, '108039'),
(12668, 'US-NJ-108040', 'Morganville', 'CI', 4198, 40.35950000000, -74.26280000000, '108040'),
(12669, 'US-NJ-108041', 'Long Branch', 'CI', 4198, 40.29440000000, -73.99320000000, '108041'),
(12670, 'US-NJ-108042', 'Brick', 'CI', 4198, 40.09560000000, -74.10950000000, '108042'),
(12671, 'US-NH-108043', 'Lisbon', 'CI', 4197, 44.20790000000, -71.88390000000, '108043'),
(12672, 'US-VT-108044', 'Townshend', 'CI', 4216, 43.07660000000, -72.66870000000, '108044'),
(12673, 'US-NH-108045', 'Alton Bay', 'CI', 4197, 43.49930000000, -71.27510000000, '108045'),
(12674, 'US-NH-108046', 'Somersworth', 'CI', 4197, 43.25550000000, -70.88290000000, '108046'),
(12675, 'US-NH-108047', 'Conway', 'CI', 4197, 43.97320000000, -71.23260000000, '108047'),
(12676, 'US-MT-108048', 'Willow Creek', 'CI', 4194, 45.82360000000, -111.63590000000, '108048'),
(12677, 'US-NH-108049', 'Keene', 'CI', 4197, 42.97030000000, -72.28000000000, '108049'),
(12678, 'US-NH-108050', 'Campton', 'CI', 4197, 43.88960000000, -71.61320000000, '108050'),
(12679, 'US-NH-108051', 'Lebanon', 'CI', 4197, 43.63610000000, -72.24130000000, '108051'),
(12680, 'US-NH-108052', 'Derry', 'CI', 4197, 42.89150000000, -71.27870000000, '108052'),
(12681, 'US-NH-108053', 'Bradford', 'CI', 4197, 43.24130000000, -71.95680000000, '108053'),
(12682, 'US-NH-108054', 'Chester', 'CI', 4197, 42.97070000000, -71.23950000000, '108054'),
(12683, 'US-VT-108055', 'Bridgewater', 'CI', 4216, 43.56760000000, -72.64200000000, '108055'),
(12684, 'US-VT-108056', 'Saint Johnsbury', 'CI', 4216, 44.41600000000, -71.98490000000, '108056'),
(12685, 'US-VT-108057', 'Pownal', 'CI', 4216, 42.79050000000, -73.21580000000, '108057'),
(12686, 'US-NH-108058', 'West Lebanon', 'CI', 4197, 43.64420000000, -72.30660000000, '108058'),
(12687, 'US-NH-108059', 'Farmington', 'CI', 4197, 43.37130000000, -71.07590000000, '108059'),
(12688, 'US-VT-108060', 'Woodstock', 'CI', 4216, 43.64700000000, -72.56170000000, '108060'),
(12689, 'US-VT-108061', 'Norwich', 'CI', 4216, 43.75110000000, -72.31420000000, '108061'),
(12690, 'US-NH-108062', 'Canaan', 'CI', 4197, 43.67300000000, -71.99720000000, '108062'),
(12691, 'US-CA-108063', 'Alpine', 'CI', 4169, 32.80020000000, -116.71000000000, '108063'),
(12692, 'US-PA-108064', 'Chester', 'CI', 4208, 39.84890000000, -75.38230000000, '108064'),
(12693, 'US-MD-108065', 'Upper Marlboro', 'CI', 4188, 38.89220000000, -76.76810000000, '108065'),
(12694, 'US-TX-108066', 'Universal City', 'CI', 4214, 29.54230000000, -98.29640000000, '108066'),
(12695, 'US-VA-108067', 'Seaford', 'CI', 4218, 37.19150000000, -76.39190000000, '108067'),
(12696, 'US-VA-108068', 'Yorktown', 'CI', 4218, 37.21430000000, -76.51730000000, '108068'),
(12697, 'US-VA-108069', 'Portsmouth', 'CI', 4218, 36.82330000000, -76.31800000000, '108069'),
(12698, 'US-MO-108070', 'Florissant', 'CI', 4193, 38.79550000000, -90.27550000000, '108070'),
(12699, 'US-VA-108071', 'Norfolk', 'CI', 4218, 36.85300000000, -76.28820000000, '108071'),
(12700, 'US-VA-108072', 'Saluda', 'CI', 4218, 37.57220000000, -76.61330000000, '108072'),
(12701, 'US-AL-108073', 'Columbiana', 'CI', 4161, 33.22270000000, -86.60850000000, '108073'),
(12702, 'US-VA-108074', 'Gloucester', 'CI', 4218, 37.44690000000, -76.55310000000, '108074'),
(12703, 'US-VA-108075', 'Kilmarnock', 'CI', 4218, 37.74360000000, -76.35230000000, '108075'),
(12704, 'US-VA-108076', 'Lancaster', 'CI', 4218, 37.75370000000, -76.49900000000, '108076'),
(12705, 'US-WA-108077', 'Sumner', 'CI', 4219, 47.17250000000, -122.18450000000, '108077'),
(12706, 'US-WY-108078', 'Story', 'CI', 4222, 44.57950000000, -106.90580000000, '108078'),
(12707, 'US-AR-108079', 'Berryville', 'CI', 4165, 36.31150000000, -93.55730000000, '108079'),
(12708, 'US-MO-108080', 'Nevada', 'CI', 4193, 37.83130000000, -94.33870000000, '108080'),
(12709, 'US-AR-108081', 'Clinton', 'CI', 4165, 35.60140000000, -92.57380000000, '108081'),
(12710, 'US-PA-108082', 'New Park', 'CI', 4208, 39.76440000000, -76.49230000000, '108082'),
(12711, 'US-MO-108083', 'Noel', 'CI', 4193, 36.56170000000, -94.43110000000, '108083'),
(12712, 'US-NJ-108084', 'Pomona', 'CI', 4198, 39.47990000000, -74.56540000000, '108084'),
(12713, 'US-PA-108085', 'South Canaan', 'CI', 4208, 41.50360000000, -75.41370000000, '108085'),
(12714, 'US-OH-108086', 'Blanchester', 'CI', 4204, 39.28310000000, -83.96680000000, '108086'),
(12715, 'US-GA-108087', 'Demorest', 'CI', 4176, 34.58190000000, -83.56990000000, '108087'),
(12716, 'US-IN-108088', 'Rushville', 'CI', 4181, 39.60320000000, -85.43010000000, '108088'),
(12717, 'US-IN-108089', 'Carthage', 'CI', 4181, 39.73170000000, -85.56750000000, '108089'),
(12718, 'US-OH-108090', 'Versailles', 'CI', 4204, 40.25190000000, -84.51510000000, '108090'),
(12719, 'US-OH-108091', 'Urbana', 'CI', 4204, 40.11830000000, -83.78340000000, '108091'),
(12720, 'US-IN-108092', 'Winchester', 'CI', 4181, 40.16440000000, -84.99240000000, '108092'),
(12721, 'US-OH-108093', 'Troy', 'CI', 4204, 40.03580000000, -84.17750000000, '108093'),
(12722, 'US-OH-108094', 'Springboro', 'CI', 4204, 39.54070000000, -84.22120000000, '108094'),
(12723, 'US-OH-108095', 'Bellbrook', 'CI', 4204, 39.63390000000, -84.07400000000, '108095'),
(12724, 'US-OH-108096', 'Latty', 'CI', 4204, 41.08830000000, -84.58550000000, '108096'),
(12725, 'US-OH-108097', 'Englewood', 'CI', 4204, 39.88480000000, -84.33210000000, '108097'),
(12726, 'US-OH-108098', 'Sabina', 'CI', 4204, 39.49510000000, -83.64840000000, '108098'),
(12727, 'US-TX-108099', 'Killeen', 'CI', 4214, 31.21640000000, -97.74180000000, '108099'),
(12728, 'US-NJ-108100', 'Riverton', 'CI', 4198, 40.00010000000, -74.99320000000, '108100'),
(12729, 'US-GA-108101', 'Villa Rica', 'CI', 4176, 33.71050000000, -84.91120000000, '108101'),
(12730, 'US-NJ-108102', 'Pleasantville', 'CI', 4198, 39.39140000000, -74.51820000000, '108102'),
(12731, 'US-NJ-108103', 'Merchantville', 'CI', 4198, 39.95000000000, -75.05930000000, '108103'),
(12732, 'US-NJ-108104', 'Mays Landing', 'CI', 4198, 39.45430000000, -74.73210000000, '108104'),
(12733, 'US-NJ-108105', 'Penns Grove', 'CI', 4198, 39.70640000000, -75.44980000000, '108105'),
(12734, 'US-NJ-108106', 'Winslow', 'CI', 4198, 39.65770000000, -74.86710000000, '108106'),
(12735, 'US-NJ-108107', 'Salem', 'CI', 4198, 39.53170000000, -75.43760000000, '108107'),
(12736, 'US-NJ-108108', 'Blackwood', 'CI', 4198, 39.77960000000, -75.05050000000, '108108'),
(12737, 'US-NJ-108109', 'Millville', 'CI', 4198, 39.37840000000, -75.02360000000, '108109'),
(12738, 'US-NJ-108110', 'Pedricktown', 'CI', 4198, 39.73430000000, -75.41610000000, '108110'),
(12739, 'US-WA-108111', 'Port Hadlock', 'CI', 4219, 48.00470000000, -122.74950000000, '108111'),
(12740, 'US-WV-108112', 'Moorefield', 'CI', 4220, 39.00260000000, -78.96160000000, '108112'),
(12741, 'US-PA-108113', 'Boyers', 'CI', 4208, 41.11080000000, -79.89750000000, '108113'),
(12742, 'US-WV-108114', 'Newell', 'CI', 4220, 40.60460000000, -80.60950000000, '108114'),
(12743, 'US-NJ-108115', 'Glassboro', 'CI', 4198, 39.69690000000, -75.12500000000, '108115'),
(12744, 'US-NJ-108116', 'Bridgeton', 'CI', 4198, 39.42380000000, -75.25770000000, '108116'),
(12745, 'US-OH-108117', 'Bellaire', 'CI', 4204, 40.02450000000, -80.80050000000, '108117'),
(12746, 'US-VA-108118', 'Troutdale', 'CI', 4218, 36.69830000000, -81.45620000000, '108118'),
(12747, 'US-PA-108119', 'Monongahela', 'CI', 4208, 40.17510000000, -79.92840000000, '108119'),
(12748, 'US-PA-108120', 'Champion', 'CI', 4208, 40.03030000000, -79.32170000000, '108120'),
(12749, 'US-MD-108121', 'Cumberland', 'CI', 4188, 39.63510000000, -78.76650000000, '108121'),
(12750, 'US-PA-108122', 'Farrell', 'CI', 4208, 41.20980000000, -80.49340000000, '108122'),
(12751, 'US-PA-108123', 'Gettysburg', 'CI', 4208, 39.84180000000, -77.22910000000, '108123'),
(12752, 'US-NJ-108124', 'Berlin', 'CI', 4198, 39.75810000000, -74.92560000000, '108124'),
(12753, 'US-TX-108125', 'Mexia', 'CI', 4214, 31.66260000000, -96.49350000000, '108125'),
(12754, 'US-TX-108126', 'Cresson', 'CI', 4214, 32.54210000000, -97.60090000000, '108126'),
(12755, 'US-PA-108127', 'North Versailles', 'CI', 4208, 40.38170000000, -79.78930000000, '108127'),
(12756, 'US-WV-108128', 'Grafton', 'CI', 4220, 39.35850000000, -79.99840000000, '108128'),
(12757, 'US-PA-108129', 'Monaca', 'CI', 4208, 40.65920000000, -80.32470000000, '108129'),
(12758, 'US-WV-108130', 'Riverton', 'CI', 4220, 38.74610000000, -79.43920000000, '108130'),
(12759, 'US-NJ-108131', 'South River', 'CI', 4198, 40.44640000000, -74.37880000000, '108131'),
(12760, 'US-NJ-108132', 'Hillsborough', 'CI', 4198, 40.49810000000, -74.68660000000, '108132'),
(12761, 'US-NJ-108133', 'Whitehouse Station', 'CI', 4198, 40.61300000000, -74.76820000000, '108133'),
(12762, 'US-NJ-108134', 'Willingboro', 'CI', 4198, 40.02570000000, -74.89160000000, '108134'),
(12763, 'US-NJ-108135', 'Bound Brook', 'CI', 4198, 40.57080000000, -74.53740000000, '108135'),
(12764, 'US-NJ-108136', 'Asbury', 'CI', 4198, 40.67530000000, -75.02230000000, '108136'),
(12765, 'US-NJ-108137', 'Fords', 'CI', 4198, 40.53770000000, -74.31110000000, '108137'),
(12766, 'US-NJ-108138', 'West Creek', 'CI', 4198, 39.65310000000, -74.27260000000, '108138'),
(12767, 'US-NJ-108139', 'Califon', 'CI', 4198, 40.72370000000, -74.80510000000, '108139'),
(12768, 'US-NJ-108140', 'Manville', 'CI', 4198, 40.54220000000, -74.57700000000, '108140'),
(12769, 'US-NJ-108141', 'Gibbsboro', 'CI', 4198, 39.83150000000, -74.96680000000, '108141'),
(12770, 'US-NJ-108142', 'Linwood', 'CI', 4198, 39.34450000000, -74.56980000000, '108142'),
(12771, 'US-FL-108143', 'Boynton Beach', 'CI', 4175, 26.52820000000, -80.08430000000, '108143'),
(12772, 'US-FL-108144', 'Port Saint Lucie', 'CI', 4175, 27.29650000000, -80.29200000000, '108144'),
(12773, 'US-FL-108145', 'Palm Beach', 'CI', 4175, 26.67790000000, -80.03800000000, '108145'),
(12774, 'US-FL-108146', 'Jupiter', 'CI', 4175, 26.91970000000, -80.07340000000, '108146'),
(12775, 'US-PA-108147', 'Lewis Run', 'CI', 4208, 41.82000000000, -78.67030000000, '108147'),
(12776, 'US-TN-108148', 'Gallatin', 'CI', 4213, 36.39130000000, -86.45470000000, '108148'),
(12777, 'US-FL-108149', 'Palm City', 'CI', 4175, 27.11880000000, -80.36660000000, '108149'),
(12778, 'US-NJ-108150', 'Bridgeport', 'CI', 4198, 39.79900000000, -75.35330000000, '108150'),
(12779, 'US-NJ-108151', 'Monroeville', 'CI', 4198, 39.64350000000, -75.17480000000, '108151'),
(12780, 'US-NJ-108152', 'Gloucester City', 'CI', 4198, 39.89040000000, -75.11520000000, '108152'),
(12781, 'US-WA-108153', 'Kingston', 'CI', 4219, 47.81730000000, -122.53030000000, '108153'),
(12782, 'US-TX-108154', 'Georgetown', 'CI', 4214, 30.65350000000, -97.58280000000, '108154'),
(12783, 'US-TX-108155', 'Round Top', 'CI', 4214, 30.04980000000, -96.67780000000, '108155'),
(12784, 'US-TX-108156', 'Granger', 'CI', 4214, 30.70760000000, -97.41590000000, '108156'),
(12785, 'US-TX-108157', 'Lexington', 'CI', 4214, 30.41510000000, -97.04790000000, '108157'),
(12786, 'US-NJ-108158', 'Passaic', 'CI', 4198, 40.85550000000, -74.12680000000, '108158'),
(12787, 'US-NJ-108159', 'Elmwood Park', 'CI', 4198, 40.90580000000, -74.11730000000, '108159'),
(12788, 'US-NJ-108160', 'Pompton Plains', 'CI', 4198, 40.96970000000, -74.30420000000, '108160'),
(12789, 'US-NJ-108161', 'Ramsey', 'CI', 4198, 41.05900000000, -74.14540000000, '108161'),
(12790, 'US-AR-108162', 'Magnolia', 'CI', 4165, 33.24090000000, -93.19920000000, '108162'),
(12791, 'US-NJ-108163', 'Glen Rock', 'CI', 4198, 40.96040000000, -74.12300000000, '108163'),
(12792, 'US-NJ-108164', 'Hasbrouck Heights', 'CI', 4198, 40.86170000000, -74.07370000000, '108164'),
(12793, 'US-NJ-108165', 'Hawthorne', 'CI', 4198, 40.95900000000, -74.15620000000, '108165'),
(12794, 'US-NJ-108166', 'Fort Lee', 'CI', 4198, 40.84830000000, -73.97250000000, '108166'),
(12795, 'US-NJ-108167', 'Westwood', 'CI', 4198, 41.00990000000, -74.00730000000, '108167'),
(12796, 'US-WA-108168', 'Ellensburg', 'CI', 4219, 46.97900000000, -120.47030000000, '108168'),
(12797, 'US-NJ-108169', 'Waldwick', 'CI', 4198, 41.01380000000, -74.12280000000, '108169'),
(12798, 'US-NY-108170', 'Freeport', 'CI', 4200, 40.64890000000, -73.58250000000, '108170'),
(12799, 'US-NJ-108171', 'Rutherford', 'CI', 4198, 40.82590000000, -74.10790000000, '108171'),
(12800, 'US-NJ-108172', 'Leonia', 'CI', 4198, 40.86330000000, -73.98990000000, '108172'),
(12801, 'US-NJ-108173', 'South Hackensack', 'CI', 4198, 40.86390000000, -74.04830000000, '108173'),
(12802, 'US-TX-108174', 'Victoria', 'CI', 4214, 28.92350000000, -97.00630000000, '108174'),
(12803, 'US-TX-108175', 'Harlingen', 'CI', 4214, 26.20740000000, -97.73510000000, '108175'),
(12804, 'US-TX-108176', 'Mcallen', 'CI', 4214, 26.15620000000, -98.25010000000, '108176'),
(12805, 'US-TX-108177', 'Crane', 'CI', 4214, 31.35040000000, -102.38810000000, '108177'),
(12806, 'US-TX-108178', 'Mc Queeney', 'CI', 4214, 29.60020000000, -98.04930000000, '108178'),
(12807, 'US-TX-108179', 'Converse', 'CI', 4214, 29.48860000000, -98.27350000000, '108179'),
(12808, 'US-TX-108180', 'Del Rio', 'CI', 4214, 29.61950000000, -100.80890000000, '108180'),
(12809, 'US-ID-108181', 'Post Falls', 'CI', 4179, 47.78920000000, -117.02660000000, '108181'),
(12810, 'US-TX-108182', 'Mathis', 'CI', 4214, 28.10870000000, -97.80610000000, '108182'),
(12811, 'US-TX-108183', 'Johnson City', 'CI', 4214, 30.31570000000, -98.39440000000, '108183'),
(12812, 'US-TX-108184', 'Port Aransas', 'CI', 4214, 27.75930000000, -97.11610000000, '108184'),
(12813, 'US-KY-108185', 'Shepherdsville', 'CI', 4184, 37.96330000000, -85.70260000000, '108185'),
(12814, 'US-OH-108186', 'Tiffin', 'CI', 4204, 41.12450000000, -83.12120000000, '108186'),
(12815, 'US-OH-108187', 'Delaware', 'CI', 4204, 40.28270000000, -83.05590000000, '108187'),
(12816, 'US-CA-108188', 'Half Moon Bay', 'CI', 4169, 37.44360000000, -122.41240000000, '108188'),
(12817, 'US-MN-108189', 'Avon', 'CI', 4191, 45.62720000000, -94.43610000000, '108189'),
(12818, 'US-OH-108190', 'Williamsport', 'CI', 4204, 39.58940000000, -83.12140000000, '108190'),
(12819, 'US-ND-108191', 'Minot Afb', 'CI', 4202, 48.23420000000, -101.29720000000, '108191'),
(12820, 'US-MN-108192', 'Saint Bonifacius', 'CI', 4191, 44.90430000000, -93.74630000000, '108192'),
(12821, 'US-MN-108193', 'Wabasso', 'CI', 4191, 44.42440000000, -95.24890000000, '108193'),
(12822, 'US-ND-108194', 'Grand Forks', 'CI', 4202, 47.88040000000, -97.06220000000, '108194'),
(12823, 'US-CA-108195', 'Montara', 'CI', 4169, 37.54320000000, -122.50760000000, '108195'),
(12824, 'US-IN-108196', 'Bristol', 'CI', 4181, 41.71270000000, -85.79720000000, '108196'),
(12825, 'US-MI-108197', 'Niles', 'CI', 4190, 41.84390000000, -86.21640000000, '108197'),
(12826, 'US-IN-108198', 'Sullivan', 'CI', 4181, 39.08430000000, -87.42100000000, '108198'),
(12827, 'US-IN-108199', 'Mentone', 'CI', 4181, 41.16580000000, -86.01610000000, '108199'),
(12828, 'US-IN-108200', 'Huntington', 'CI', 4181, 40.91200000000, -85.47620000000, '108200'),
(12829, 'US-MI-108201', 'Cassopolis', 'CI', 4190, 41.89800000000, -86.00150000000, '108201'),
(12830, 'US-IN-108202', 'New Carlisle', 'CI', 4181, 41.69780000000, -86.48150000000, '108202'),
(12831, 'US-MI-108203', 'Bridgman', 'CI', 4190, 41.94110000000, -86.55220000000, '108203'),
(12832, 'US-IL-108204', 'Woodstock', 'CI', 4180, 42.32220000000, -88.46710000000, '108204'),
(12833, 'US-CA-108205', 'Portola Valley', 'CI', 4169, 37.37020000000, -122.21450000000, '108205'),
(12834, 'US-IN-108206', 'Lagrange', 'CI', 4181, 41.63250000000, -85.37920000000, '108206'),
(12835, 'US-IN-108207', 'Garrett', 'CI', 4181, 41.32250000000, -85.13880000000, '108207'),
(12836, 'US-IN-108208', 'Fremont', 'CI', 4181, 41.70960000000, -84.94790000000, '108208'),
(12837, 'US-IN-108209', 'Urbana', 'CI', 4181, 40.89890000000, -85.74030000000, '108209'),
(12838, 'US-IN-108210', 'Columbia City', 'CI', 4181, 41.15320000000, -85.48100000000, '108210'),
(12839, 'US-MI-108211', 'Covert', 'CI', 4190, 42.28730000000, -86.26970000000, '108211'),
(12840, 'US-IN-108212', 'Angola', 'CI', 4181, 41.66410000000, -85.00030000000, '108212'),
(12841, 'US-IN-108213', 'Monroeville', 'CI', 4181, 40.97630000000, -84.90070000000, '108213'),
(12842, 'US-MI-108214', 'South Haven', 'CI', 4190, 42.42310000000, -86.21870000000, '108214'),
(12843, 'US-IN-108215', 'Milford', 'CI', 4181, 41.39720000000, -85.86990000000, '108215'),
(12844, 'US-IN-108216', 'Berne', 'CI', 4181, 40.65880000000, -84.93500000000, '108216'),
(12845, 'US-IN-108217', 'Knox', 'CI', 4181, 41.28100000000, -86.62100000000, '108217'),
(12846, 'US-MI-108218', 'Buchanan', 'CI', 4190, 41.84240000000, -86.42340000000, '108218'),
(12847, 'US-IN-108219', 'Winona Lake', 'CI', 4181, 41.21870000000, -85.81480000000, '108219'),
(12848, 'US-IN-108220', 'Syracuse', 'CI', 4181, 41.40940000000, -85.73520000000, '108220'),
(12849, 'US-MI-108221', 'Dowagiac', 'CI', 4190, 41.98810000000, -86.10890000000, '108221'),
(12850, 'US-IN-108222', 'Mishawaka', 'CI', 4181, 41.69250000000, -86.14480000000, '108222'),
(12851, 'US-IN-108223', 'Winamac', 'CI', 4181, 41.04580000000, -86.62220000000, '108223'),
(12852, 'US-NJ-108224', 'Oakland', 'CI', 4198, 41.02810000000, -74.23710000000, '108224'),
(12853, 'US-NJ-108225', 'Norwood', 'CI', 4198, 40.99450000000, -73.94830000000, '108225'),
(12854, 'US-TN-108226', 'Tellico Plains', 'CI', 4213, 35.34200000000, -84.22530000000, '108226'),
(12855, 'US-GA-108227', 'Suches', 'CI', 4176, 34.74790000000, -84.06730000000, '108227'),
(12856, 'US-GA-108228', 'Redan', 'CI', 4176, 33.74460000000, -84.13600000000, '108228'),
(12857, 'US-TN-108229', 'Athens', 'CI', 4213, 35.42390000000, -84.66810000000, '108229'),
(12858, 'US-GA-108230', 'Peachtree City', 'CI', 4176, 33.39100000000, -84.56150000000, '108230'),
(12859, 'US-GA-108231', 'Snellville', 'CI', 4176, 33.86300000000, -84.00760000000, '108231'),
(12860, 'US-GA-108232', 'Talking Rock', 'CI', 4176, 34.55140000000, -84.49970000000, '108232'),
(12861, 'US-TN-108233', 'Oak Ridge', 'CI', 4213, 35.97240000000, -84.29040000000, '108233'),
(12862, 'US-MA-108234', 'Easton', 'CI', 4189, 42.02380000000, -71.12920000000, '108234'),
(12863, 'US-NJ-108235', 'Pennington', 'CI', 4198, 40.33380000000, -74.79090000000, '108235'),
(12864, 'US-TX-108236', 'Brenham', 'CI', 4214, 30.19910000000, -96.38780000000, '108236'),
(12865, 'US-TX-108237', 'Alvin', 'CI', 4214, 29.36560000000, -95.25250000000, '108237'),
(12866, 'US-TX-108238', 'Nederland', 'CI', 4214, 29.98040000000, -94.00270000000, '108238'),
(12867, 'US-TX-108239', 'Conroe', 'CI', 4214, 30.30790000000, -95.43150000000, '108239'),
(12868, 'US-TX-108240', 'Wharton', 'CI', 4214, 29.28080000000, -96.07680000000, '108240'),
(12869, 'US-TX-108241', 'Electra', 'CI', 4214, 34.00960000000, -98.89010000000, '108241'),
(12870, 'US-TX-108242', 'Angleton', 'CI', 4214, 29.18510000000, -95.45540000000, '108242'),
(12871, 'US-KY-108243', 'Nicholasville', 'CI', 4184, 37.86470000000, -84.56420000000, '108243'),
(12872, 'US-TX-108244', 'Gilmer', 'CI', 4214, 32.77340000000, -94.98890000000, '108244'),
(12873, 'US-TX-108245', 'Webster', 'CI', 4214, 29.54890000000, -95.13910000000, '108245'),
(12874, 'US-LA-108246', 'Oberlin', 'CI', 4185, 30.63260000000, -92.73050000000, '108246'),
(12875, 'US-NY-108247', 'Goshen', 'CI', 4200, 41.37890000000, -74.36370000000, '108247'),
(12876, 'US-TX-108248', 'Lake Jackson', 'CI', 4214, 29.03220000000, -95.46990000000, '108248'),
(12877, 'US-TX-108249', 'Fulshear', 'CI', 4214, 29.70180000000, -95.91380000000, '108249'),
(12878, 'US-CA-108250', 'Cypress', 'CI', 4169, 33.81880000000, -118.03770000000, '108250'),
(12879, 'US-TX-108251', 'Euless', 'CI', 4214, 32.81010000000, -97.10610000000, '108251'),
(12880, 'US-TX-108252', 'Port Arthur', 'CI', 4214, 29.94220000000, -93.87840000000, '108252'),
(12881, 'US-TX-108253', 'Corsicana', 'CI', 4214, 32.07950000000, -96.51140000000, '108253'),
(12882, 'US-TX-108254', 'Honey Grove', 'CI', 4214, 33.65740000000, -95.91110000000, '108254'),
(12883, 'US-KY-108255', 'Flemingsburg', 'CI', 4184, 38.40220000000, -83.72290000000, '108255'),
(12884, 'US-MA-108256', 'Pembroke', 'CI', 4189, 42.06470000000, -70.79860000000, '108256'),
(12885, 'US-CA-108257', 'San Lorenzo', 'CI', 4169, 37.68120000000, -122.13450000000, '108257'),
(12886, 'US-KY-108258', 'Hebron', 'CI', 4184, 39.09040000000, -84.70110000000, '108258'),
(12887, 'US-KY-108259', 'Ft Mitchell', 'CI', 4184, 39.02400000000, -84.56240000000, '108259'),
(12888, 'US-TX-108260', 'Savoy', 'CI', 4214, 33.63160000000, -96.32550000000, '108260'),
(12889, 'US-KY-108261', 'David', 'CI', 4184, 37.57360000000, -82.87080000000, '108261'),
(12890, 'US-TX-108262', 'Whitesboro', 'CI', 4214, 33.75980000000, -96.90150000000, '108262'),
(12891, 'US-IL-108263', 'Astoria', 'CI', 4180, 40.24050000000, -90.30810000000, '108263'),
(12892, 'US-IL-108264', 'Leaf River', 'CI', 4180, 42.16220000000, -89.40580000000, '108264'),
(12893, 'US-IL-108265', 'Chillicothe', 'CI', 4180, 40.91340000000, -89.53260000000, '108265'),
(12894, 'US-IL-108266', 'Warsaw', 'CI', 4180, 40.26050000000, -91.45090000000, '108266'),
(12895, 'US-IL-108267', 'Rock Falls', 'CI', 4180, 41.73640000000, -89.70420000000, '108267'),
(12896, 'US-IL-108268', 'Washburn', 'CI', 4180, 40.90940000000, -89.24500000000, '108268'),
(12897, 'US-IL-108269', 'Galena', 'CI', 4180, 42.41200000000, -90.38170000000, '108269'),
(12898, 'US-IL-108270', 'Dixon', 'CI', 4180, 41.81570000000, -89.48180000000, '108270'),
(12899, 'US-IA-108271', 'West Burlington', 'CI', 4182, 40.85330000000, -91.21070000000, '108271'),
(12900, 'US-IL-108272', 'Morrison', 'CI', 4180, 41.82280000000, -89.96100000000, '108272'),
(12901, 'US-IL-108273', 'Silvis', 'CI', 4180, 41.49480000000, -90.40930000000, '108273'),
(12902, 'US-IA-108274', 'Tipton', 'CI', 4182, 41.74450000000, -91.15600000000, '108274'),
(12903, 'US-IL-108275', 'Amboy', 'CI', 4180, 41.70750000000, -89.35240000000, '108275'),
(12904, 'US-MA-108276', 'East Taunton', 'CI', 4189, 41.87240000000, -71.01370000000, '108276'),
(12905, 'US-IL-108277', 'Washington', 'CI', 4180, 40.69550000000, -89.42930000000, '108277'),
(12906, 'US-IA-108278', 'Burlington', 'CI', 4182, 40.84240000000, -91.10730000000, '108278'),
(12907, 'US-IL-108279', 'Kewanee', 'CI', 4180, 41.26080000000, -89.94410000000, '108279'),
(12908, 'US-IL-108280', 'Mattoon', 'CI', 4180, 39.48850000000, -88.35960000000, '108280'),
(12909, 'US-IL-108281', 'Chadwick', 'CI', 4180, 41.97740000000, -89.88100000000, '108281'),
(12910, 'US-IL-108282', 'Galesburg', 'CI', 4180, 40.94210000000, -90.37800000000, '108282'),
(12911, 'US-IL-108283', 'Fulton', 'CI', 4180, 41.84120000000, -90.11160000000, '108283'),
(12912, 'US-IL-108284', 'East Dubuque', 'CI', 4180, 42.46420000000, -90.56150000000, '108284'),
(12913, 'US-IL-108285', 'Dunlap', 'CI', 4180, 40.85680000000, -89.65950000000, '108285'),
(12914, 'US-IL-108286', 'Eureka', 'CI', 4180, 40.71870000000, -89.25330000000, '108286'),
(12915, 'US-IL-108287', 'Mossville', 'CI', 4180, 40.81760000000, -89.56360000000, '108287'),
(12916, 'US-IA-108288', 'Muscatine', 'CI', 4182, 41.40460000000, -91.03210000000, '108288'),
(12917, 'US-WI-108289', 'Fish Creek', 'CI', 4221, 45.11480000000, -87.21680000000, '108289'),
(12918, 'US-PA-108290', 'Mansfield', 'CI', 4208, 41.82080000000, -77.07520000000, '108290'),
(12919, 'US-PA-108291', 'Ashland', 'CI', 4208, 40.73860000000, -76.35790000000, '108291'),
(12920, 'US-PA-108292', 'Friedensburg', 'CI', 4208, 40.60070000000, -76.23960000000, '108292'),
(12921, 'US-PA-108293', 'Intercourse', 'CI', 4208, 40.05540000000, -76.12320000000, '108293'),
(12922, 'US-PA-108294', 'Mount Joy', 'CI', 4208, 40.11420000000, -76.50880000000, '108294'),
(12923, 'US-PA-108295', 'Thomasville', 'CI', 4208, 39.92360000000, -76.90500000000, '108295'),
(12924, 'US-PA-108296', 'Loretto', 'CI', 4208, 40.51950000000, -78.62490000000, '108296'),
(12925, 'US-PA-108297', 'Littlestown', 'CI', 4208, 39.76460000000, -77.11660000000, '108297'),
(12926, 'US-PA-108298', 'Lebanon', 'CI', 4208, 40.29210000000, -76.42590000000, '108298'),
(12927, 'US-PA-108299', 'Mc Connellsburg', 'CI', 4208, 39.93730000000, -77.98650000000, '108299'),
(12928, 'US-PA-108300', 'Camp Hill', 'CI', 4208, 40.23790000000, -76.92280000000, '108300'),
(12929, 'US-TX-108301', 'Jacksonville', 'CI', 4214, 31.94540000000, -95.21940000000, '108301'),
(12930, 'US-GA-108302', 'Young Harris', 'CI', 4176, 34.94350000000, -83.90630000000, '108302'),
(12931, 'US-FL-108303', 'Leesburg', 'CI', 4175, 28.73940000000, -81.85550000000, '108303'),
(12932, 'US-AZ-108304', 'Laveen', 'CI', 4164, 33.30540000000, -112.19970000000, '108304'),
(12933, 'US-CA-108305', 'Ventura', 'CI', 4169, 34.28630000000, -119.22670000000, '108305'),
(12934, 'US-MI-108306', 'Coldwater', 'CI', 4190, 41.90150000000, -85.03460000000, '108306'),
(12935, 'US-MI-108307', 'Coopersville', 'CI', 4190, 43.07060000000, -85.97330000000, '108307'),
(12936, 'US-AZ-108308', 'Youngtown', 'CI', 4164, 33.58630000000, -112.30620000000, '108308'),
(12937, 'US-VA-108309', 'Petersburg', 'CI', 4218, 37.19520000000, -77.45970000000, '108309'),
(12938, 'US-MI-108310', 'Belmont', 'CI', 4190, 43.07260000000, -85.48510000000, '108310'),
(12939, 'US-FL-108311', 'Mount Dora', 'CI', 4175, 28.76200000000, -81.63000000000, '108311'),
(12940, 'US-AZ-108312', 'Tonopah', 'CI', 4164, 33.57780000000, -113.02340000000, '108312'),
(12941, 'US-MI-108313', 'Mattawan', 'CI', 4190, 42.23220000000, -85.77360000000, '108313'),
(12942, 'US-FL-108314', 'Port Orange', 'CI', 4175, 29.10990000000, -80.97300000000, '108314'),
(12943, 'US-AZ-108315', 'Flagstaff', 'CI', 4164, 35.29850000000, -111.32520000000, '108315'),
(12944, 'US-OK-108316', 'Piedmont', 'CI', 4205, 35.65310000000, -97.76290000000, '108316'),
(12945, 'US-AZ-108317', 'Apache Junction', 'CI', 4164, 33.41710000000, -111.57320000000, '108317'),
(12946, 'US-AZ-108318', 'Benson', 'CI', 4164, 32.19240000000, -110.38620000000, '108318'),
(12947, 'US-TX-108319', 'Rockwall', 'CI', 4214, 32.86850000000, -96.40310000000, '108319'),
(12948, 'US-CA-108320', 'Acton', 'CI', 4169, 34.49040000000, -118.21960000000, '108320'),
(12949, 'US-PA-108321', 'Nazareth', 'CI', 4208, 40.75300000000, -75.30620000000, '108321'),
(12950, 'US-PA-108322', 'Souderton', 'CI', 4208, 40.29550000000, -75.32540000000, '108322'),
(12951, 'US-PA-108323', 'Pipersville', 'CI', 4208, 40.42780000000, -75.11470000000, '108323'),
(12952, 'US-CA-108324', 'Baldwin Park', 'CI', 4169, 34.09640000000, -117.96680000000, '108324'),
(12953, 'US-PA-108325', 'Ambler', 'CI', 4208, 40.18430000000, -75.21680000000, '108325'),
(12954, 'US-CA-108326', 'La Mirada', 'CI', 4169, 33.90090000000, -118.00730000000, '108326'),
(12955, 'US-TX-108327', 'Princeton', 'CI', 4214, 33.14940000000, -96.48330000000, '108327'),
(12956, 'US-IA-108328', 'Bettendorf', 'CI', 4182, 41.57380000000, -90.45820000000, '108328'),
(12957, 'US-ID-108329', 'Pocatello', 'CI', 4179, 42.90610000000, -112.39750000000, '108329'),
(12958, 'US-UT-108330', 'Layton', 'CI', 4215, 41.07130000000, -111.98740000000, '108330'),
(12959, 'US-CA-108331', 'Mammoth Lakes', 'CI', 4169, 37.58700000000, -118.84220000000, '108331'),
(12960, 'US-UT-108332', 'Syracuse', 'CI', 4215, 41.05040000000, -112.06100000000, '108332'),
(12961, 'US-MT-108333', 'Belgrade', 'CI', 4194, 45.96660000000, -111.11240000000, '108333'),
(12962, 'US-UT-108334', 'Logan', 'CI', 4215, 41.70480000000, -111.87090000000, '108334'),
(12963, 'US-UT-108335', 'Midvale', 'CI', 4215, 40.60920000000, -111.88190000000, '108335'),
(12964, 'US-NJ-108336', 'Kenilworth', 'CI', 4198, 40.67780000000, -74.29170000000, '108336'),
(12965, 'US-MO-108337', 'Weston', 'CI', 4193, 39.45140000000, -94.89350000000, '108337'),
(12966, 'US-IL-108338', 'Geneva', 'CI', 4180, 41.88000000000, -88.35870000000, '108338'),
(12967, 'US-MI-108339', 'Howell', 'CI', 4190, 42.56820000000, -83.90620000000, '108339'),
(12968, 'US-CT-108340', 'Mystic', 'CI', 4171, 41.37490000000, -71.97660000000, '108340'),
(12969, 'US-MI-108341', 'Saline', 'CI', 4190, 42.14820000000, -83.81480000000, '108341'),
(12970, 'US-OH-108342', 'Bowling Green', 'CI', 4204, 41.39890000000, -83.65390000000, '108342'),
(12971, 'US-MI-108343', 'Rives Junction', 'CI', 4190, 42.37810000000, -84.47980000000, '108343'),
(12972, 'US-OH-108344', 'Bryan', 'CI', 4204, 41.46150000000, -84.55310000000, '108344'),
(12973, 'US-MI-108345', 'Clinton', 'CI', 4190, 42.08070000000, -83.95870000000, '108345'),
(12974, 'US-OH-108346', 'Pemberville', 'CI', 4204, 41.39150000000, -83.48880000000, '108346'),
(12975, 'US-MI-108347', 'New Hudson', 'CI', 4190, 42.49820000000, -83.61760000000, '108347'),
(12976, 'US-VA-108348', 'Amissville', 'CI', 4218, 38.70160000000, -78.00090000000, '108348'),
(12977, 'US-VA-108349', 'Rapidan', 'CI', 4218, 38.33320000000, -78.04620000000, '108349'),
(12978, 'US-CA-108350', 'Benicia', 'CI', 4169, 38.11290000000, -122.13310000000, '108350'),
(12979, 'US-MD-108351', 'Bloomington', 'CI', 4188, 39.48760000000, -79.07460000000, '108351'),
(12980, 'US-OK-108352', 'Sweetwater', 'CI', 4205, 35.47310000000, -99.89430000000, '108352'),
(12981, 'US-OK-108353', 'Fort Sill', 'CI', 4205, 34.68130000000, -98.49250000000, '108353'),
(12982, 'US-OK-108354', 'Seminole', 'CI', 4205, 35.24450000000, -96.63400000000, '108354'),
(12983, 'US-OK-108355', 'Snyder', 'CI', 4205, 34.62340000000, -98.97920000000, '108355'),
(12984, 'US-IN-108356', 'Salem', 'CI', 4181, 38.60790000000, -86.06940000000, '108356'),
(12985, 'US-CA-108357', 'West Covina', 'CI', 4169, 34.06270000000, -117.88960000000, '108357'),
(12986, 'US-IL-108358', 'Highland', 'CI', 4180, 38.76650000000, -89.65330000000, '108358'),
(12987, 'US-GA-108359', 'Andersonville', 'CI', 4176, 32.18310000000, -84.04560000000, '108359'),
(12988, 'US-VA-108360', 'Lovettsville', 'CI', 4218, 39.26870000000, -77.63050000000, '108360'),
(12989, 'US-GA-108361', 'Tifton', 'CI', 4176, 31.43820000000, -83.43910000000, '108361'),
(12990, 'US-GA-108362', 'Fairburn', 'CI', 4176, 33.58790000000, -84.64670000000, '108362'),
(12991, 'US-AK-108363', 'Galena', 'CI', 4162, 64.74520000000, -156.85650000000, '108363'),
(12992, 'US-IL-108364', 'Paris', 'CI', 4180, 39.60450000000, -87.72370000000, '108364'),
(12993, 'US-IA-108365', 'Grinnell', 'CI', 4182, 41.72170000000, -92.71760000000, '108365'),
(12994, 'US-GA-108366', 'Watkinsville', 'CI', 4176, 33.76940000000, -83.38970000000, '108366'),
(12995, 'US-CA-108367', 'Antioch', 'CI', 4169, 37.99120000000, -121.80980000000, '108367'),
(12996, 'US-GA-108368', 'Jefferson', 'CI', 4176, 34.09640000000, -83.57400000000, '108368'),
(12997, 'US-GA-108369', 'Jasper', 'CI', 4176, 34.46100000000, -84.42780000000, '108369'),
(12998, 'US-GA-108370', 'Toccoa', 'CI', 4176, 34.54390000000, -83.30820000000, '108370'),
(12999, 'US-GA-108371', 'Barnesville', 'CI', 4176, 33.07470000000, -84.13890000000, '108371'),
(13000, 'US-NC-108372', 'Hayesville', 'CI', 4201, 35.07390000000, -83.70510000000, '108372'),
(13001, 'US-GA-108373', 'Rabun Gap', 'CI', 4176, 34.95230000000, -83.42690000000, '108373'),
(13002, 'US-GA-108374', 'Mcdonough', 'CI', 4176, 33.45140000000, -84.18700000000, '108374'),
(13003, 'US-GA-108375', 'Blairsville', 'CI', 4176, 34.85490000000, -83.97140000000, '108375'),
(13004, 'US-CA-108376', 'Danville', 'CI', 4169, 37.81290000000, -121.97430000000, '108376'),
(13005, 'US-TN-108377', 'Jefferson City', 'CI', 4213, 36.10150000000, -83.45220000000, '108377'),
(13006, 'US-PA-108378', 'Tamaqua', 'CI', 4208, 40.78180000000, -75.98700000000, '108378'),
(13007, 'US-PA-108379', 'Lake Harmony', 'CI', 4208, 41.04990000000, -75.62010000000, '108379'),
(13008, 'US-PA-108380', 'Rome', 'CI', 4208, 41.91010000000, -76.28570000000, '108380'),
(13009, 'US-PA-108381', 'Cresco', 'CI', 4208, 41.14570000000, -75.26640000000, '108381'),
(13010, 'US-AL-108382', 'Chelsea', 'CI', 4161, 33.31430000000, -86.67110000000, '108382'),
(13011, 'US-AL-108383', 'Prattville', 'CI', 4161, 32.51410000000, -86.58630000000, '108383'),
(13012, 'US-AL-108384', 'Ashford', 'CI', 4161, 31.18410000000, -85.24920000000, '108384'),
(13013, 'US-AL-108385', 'Pell City', 'CI', 4161, 33.63320000000, -86.29500000000, '108385'),
(13014, 'US-AL-108386', 'Guntersville', 'CI', 4161, 34.31960000000, -86.27350000000, '108386'),
(13015, 'US-AL-108387', 'Athens', 'CI', 4161, 34.76750000000, -87.10570000000, '108387'),
(13016, 'US-MD-108388', 'Glenwood', 'CI', 4188, 39.28710000000, -77.02690000000, '108388'),
(13017, 'US-MD-108389', 'Elkton', 'CI', 4188, 39.61720000000, -75.86780000000, '108389'),
(13018, 'US-MD-108390', 'Arnold', 'CI', 4188, 39.04110000000, -76.49420000000, '108390'),
(13019, 'US-AZ-108391', 'Sonoita', 'CI', 4164, 31.75960000000, -110.66380000000, '108391'),
(13020, 'US-MD-108392', 'Preston', 'CI', 4188, 38.75190000000, -75.92700000000, '108392'),
(13021, 'US-MD-108393', 'Wittman', 'CI', 4188, 38.78810000000, -76.30310000000, '108393'),
(13022, 'US-MD-108394', 'Chesapeake Beach', 'CI', 4188, 38.65990000000, -76.53990000000, '108394'),
(13023, 'US-MD-108395', 'Newark', 'CI', 4188, 38.25100000000, -75.29510000000, '108395'),
(13024, 'US-MN-108396', 'Willmar', 'CI', 4191, 45.10600000000, -95.02780000000, '108396'),
(13025, 'US-MN-108397', 'Winsted', 'CI', 4191, 44.95130000000, -94.05270000000, '108397'),
(13026, 'US-GA-108398', 'Shady Dale', 'CI', 4176, 33.41790000000, -83.63840000000, '108398'),
(13027, 'US-NE-108399', 'Keystone', 'CI', 4195, 41.30610000000, -101.54790000000, '108399'),
(13028, 'US-AZ-108400', 'Superior', 'CI', 4164, 33.28180000000, -111.11320000000, '108400'),
(13029, 'US-ME-108401', 'Prospect Harbor', 'CI', 4186, 44.42860000000, -68.00520000000, '108401'),
(13030, 'US-ME-108402', 'New Gloucester', 'CI', 4186, 43.95640000000, -70.30240000000, '108402'),
(13031, 'US-ME-108403', 'Millinocket', 'CI', 4186, 45.72260000000, -68.79510000000, '108403'),
(13032, 'US-ME-108404', 'Brewer', 'CI', 4186, 44.78070000000, -68.73510000000, '108404'),
(13033, 'US-IN-108405', 'Nashville', 'CI', 4181, 39.17470000000, -86.21060000000, '108405'),
(13034, 'US-NE-108406', 'Imperial', 'CI', 4195, 40.54640000000, -101.68540000000, '108406'),
(13035, 'US-NE-108407', 'Clarks', 'CI', 4195, 41.23720000000, -97.84870000000, '108407'),
(13036, 'US-KS-108408', 'Prairie Village', 'CI', 4183, 39.00610000000, -94.63370000000, '108408'),
(13037, 'US-MO-108409', 'Gower', 'CI', 4193, 39.61440000000, -94.60430000000, '108409'),
(13038, 'US-MO-108410', 'Princeton', 'CI', 4193, 40.38650000000, -93.58360000000, '108410'),
(13039, 'US-MO-108411', 'Cameron', 'CI', 4193, 39.73400000000, -94.22280000000, '108411'),
(13040, 'US-KS-108412', 'Kanopolis', 'CI', 4183, 38.66770000000, -98.12810000000, '108412'),
(13041, 'US-VA-108413', 'Norton', 'CI', 4218, 36.98080000000, -82.64340000000, '108413'),
(13042, 'US-NC-108414', 'Jonesville', 'CI', 4201, 36.21900000000, -80.81260000000, '108414'),
(13043, 'US-VA-108415', 'Blue Ridge', 'CI', 4218, 37.36180000000, -79.77810000000, '108415'),
(13044, 'US-VA-108416', 'Hot Springs', 'CI', 4218, 37.95440000000, -79.88730000000, '108416'),
(13045, 'US-VA-108417', 'Galax', 'CI', 4218, 36.66940000000, -80.93950000000, '108417'),
(13046, 'US-VA-108418', 'Low Moor', 'CI', 4218, 37.78990000000, -79.88540000000, '108418'),
(13047, 'US-NC-108419', 'Wilkesboro', 'CI', 4201, 36.14250000000, -81.16350000000, '108419'),
(13048, 'US-NC-108420', 'Lexington', 'CI', 4201, 35.73620000000, -80.19310000000, '108420'),
(13049, 'US-VA-108421', 'Rocky Gap', 'CI', 4218, 37.22340000000, -81.07580000000, '108421'),
(13050, 'US-VA-108422', 'Richlands', 'CI', 4218, 37.10920000000, -81.81630000000, '108422'),
(13051, 'US-FL-108423', 'South Bay', 'CI', 4175, 26.65470000000, -80.72800000000, '108423'),
(13052, 'US-TN-108424', 'Parsons', 'CI', 4213, 35.68840000000, -88.10980000000, '108424'),
(13053, 'US-MS-108425', 'Marks', 'CI', 4192, 34.27110000000, -90.29070000000, '108425'),
(13054, 'US-TN-108426', 'Collierville', 'CI', 4213, 35.09110000000, -89.65100000000, '108426'),
(13055, 'US-WV-108427', 'Mount Olive', 'CI', 4220, 38.04130000000, -81.06480000000, '108427'),
(13056, 'US-TN-108428', 'Germantown', 'CI', 4213, 35.08440000000, -89.81040000000, '108428'),
(13057, 'US-AR-108429', 'West Memphis', 'CI', 4165, 35.13850000000, -90.15320000000, '108429'),
(13058, 'US-MS-108430', 'Shannon', 'CI', 4192, 34.11050000000, -88.75760000000, '108430'),
(13059, 'US-MA-108431', 'Lynnfield', 'CI', 4189, 42.53800000000, -71.03050000000, '108431'),
(13060, 'US-MS-108432', 'Walnut', 'CI', 4192, 34.89090000000, -88.85060000000, '108432'),
(13061, 'US-AR-108433', 'Cave City', 'CI', 4165, 35.94110000000, -91.54060000000, '108433'),
(13062, 'US-TN-108434', 'Bruceton', 'CI', 4213, 36.06080000000, -88.27160000000, '108434'),
(13063, 'US-MS-108435', 'Plantersville', 'CI', 4192, 34.16660000000, -88.61960000000, '108435'),
(13064, 'US-OH-108436', 'Willoughby', 'CI', 4204, 41.63840000000, -81.37870000000, '108436'),
(13065, 'US-OH-108437', 'Madison', 'CI', 4204, 41.79320000000, -81.05780000000, '108437'),
(13066, 'US-OH-108438', 'Chagrin Falls', 'CI', 4204, 41.38640000000, -81.30420000000, '108438'),
(13067, 'US-WI-108439', 'Stevens Point', 'CI', 4221, 44.55260000000, -89.51670000000, '108439'),
(13068, 'US-OH-108440', 'Salem', 'CI', 4204, 40.90790000000, -80.86150000000, '108440'),
(13069, 'US-OH-108441', 'Avon', 'CI', 4204, 41.44850000000, -82.01860000000, '108441'),
(13070, 'US-OH-108442', 'Conneaut', 'CI', 4204, 41.89090000000, -80.61640000000, '108442'),
(13071, 'US-OH-108443', 'North Ridgeville', 'CI', 4204, 41.38530000000, -82.01950000000, '108443'),
(13072, 'US-OR-108444', 'Halsey', 'CI', 4206, 44.38670000000, -123.11730000000, '108444'),
(13073, 'US-OR-108445', 'Woodburn', 'CI', 4206, 45.13690000000, -122.82240000000, '108445'),
(13074, 'US-WV-108446', 'Weston', 'CI', 4220, 39.05090000000, -80.52070000000, '108446'),
(13075, 'US-NY-108447', 'Victor', 'CI', 4200, 42.98580000000, -77.42800000000, '108447'),
(13076, 'US-IL-108448', 'South Holland', 'CI', 4180, 41.60030000000, -87.59750000000, '108448'),
(13077, 'US-OH-108449', 'Westfield Center', 'CI', 4204, 41.02800000000, -81.93830000000, '108449'),
(13078, 'US-OH-108450', 'Sugarcreek', 'CI', 4204, 40.48550000000, -81.67510000000, '108450'),
(13079, 'US-OH-108451', 'Cuyahoga Falls', 'CI', 4204, 41.16840000000, -81.53120000000, '108451'),
(13080, 'US-OH-108452', 'Uniontown', 'CI', 4204, 40.96110000000, -81.43260000000, '108452'),
(13081, 'US-OH-108453', 'Wooster', 'CI', 4204, 40.80770000000, -81.97300000000, '108453'),
(13082, 'US-OH-108454', 'Garrettsville', 'CI', 4204, 41.31290000000, -81.08050000000, '108454'),
(13083, 'US-IN-108455', 'Hobart', 'CI', 4181, 41.51790000000, -87.23530000000, '108455'),
(13084, 'US-OH-108456', 'Hudson', 'CI', 4204, 41.25010000000, -81.45770000000, '108456'),
(13085, 'US-OH-108457', 'Ravenna', 'CI', 4204, 41.16010000000, -81.16750000000, '108457'),
(13086, 'US-OH-108458', 'Wilmot', 'CI', 4204, 40.64300000000, -81.66370000000, '108458'),
(13087, 'US-OH-108459', 'Hubbard', 'CI', 4204, 41.17430000000, -80.58410000000, '108459'),
(13088, 'US-OH-108460', 'Fredericktown', 'CI', 4204, 40.48950000000, -82.56010000000, '108460'),
(13089, 'US-OH-108461', 'Dover', 'CI', 4204, 40.56410000000, -81.48360000000, '108461'),
(13090, 'US-OH-108462', 'Orrville', 'CI', 4204, 40.82890000000, -81.75570000000, '108462'),
(13091, 'US-OH-108463', 'Valley City', 'CI', 4204, 41.23610000000, -81.92240000000, '108463'),
(13092, 'US-OH-108464', 'Alliance', 'CI', 4204, 40.91570000000, -81.13300000000, '108464'),
(13093, 'US-OH-108465', 'Streetsboro', 'CI', 4204, 41.23500000000, -81.34340000000, '108465'),
(13094, 'US-KS-108466', 'Oskaloosa', 'CI', 4183, 39.19840000000, -95.33780000000, '108466'),
(13095, 'US-OH-108467', 'Peninsula', 'CI', 4204, 41.23460000000, -81.55240000000, '108467'),
(13096, 'US-OH-108468', 'Sherrodsville', 'CI', 4204, 40.50470000000, -81.25020000000, '108468'),
(13097, 'US-OH-108469', 'Bucyrus', 'CI', 4204, 40.81920000000, -82.96910000000, '108469'),
(13098, 'US-PA-108470', 'Myerstown', 'CI', 4208, 40.38980000000, -76.31750000000, '108470'),
(13099, 'US-IA-108471', 'Fort Dodge', 'CI', 4182, 42.44880000000, -94.22540000000, '108471'),
(13100, 'US-IA-108472', 'Altoona', 'CI', 4182, 41.64720000000, -93.46000000000, '108472'),
(13101, 'US-PA-108473', 'Mammoth', 'CI', 4208, 40.31080000000, -79.61720000000, '108473'),
(13102, 'US-WA-108474', 'Palouse', 'CI', 4219, 46.88850000000, -117.15500000000, '108474'),
(13103, 'US-ID-108475', 'Kellogg', 'CI', 4179, 47.57040000000, -116.11570000000, '108475'),
(13104, 'US-OR-108476', 'Mount Vernon', 'CI', 4206, 44.44460000000, -119.16340000000, '108476'),
(13105, 'US-IL-108477', 'Roscoe', 'CI', 4180, 42.42570000000, -88.98780000000, '108477'),
(13106, 'US-ID-108478', 'Hailey', 'CI', 4179, 43.57700000000, -114.21400000000, '108478'),
(13107, 'US-ID-108479', 'Jerome', 'CI', 4179, 42.75950000000, -114.36500000000, '108479'),
(13108, 'US-WA-108480', 'Mead', 'CI', 4219, 47.83450000000, -117.21040000000, '108480'),
(13109, 'US-WA-108481', 'Moses Lake', 'CI', 4219, 47.19010000000, -119.30740000000, '108481'),
(13110, 'US-IN-108482', 'Palmyra', 'CI', 4181, 38.40730000000, -86.10120000000, '108482'),
(13111, 'US-KY-108483', 'Harrodsburg', 'CI', 4184, 37.79090000000, -84.89460000000, '108483'),
(13112, 'US-KY-108484', 'Corbin', 'CI', 4184, 36.91990000000, -84.16790000000, '108484'),
(13113, 'US-IN-108485', 'Loogootee', 'CI', 4181, 38.64750000000, -86.90360000000, '108485'),
(13114, 'US-IN-108486', 'Leavenworth', 'CI', 4181, 38.19200000000, -86.31700000000, '108486'),
(13115, 'US-KY-108487', 'Hawesville', 'CI', 4184, 37.84880000000, -86.77850000000, '108487'),
(13116, 'US-KY-108488', 'Campbellsville', 'CI', 4184, 37.36460000000, -85.37580000000, '108488'),
(13117, 'US-IN-108489', 'Ferdinand', 'CI', 4181, 38.20790000000, -86.83790000000, '108489'),
(13118, 'US-IN-108490', 'Boonville', 'CI', 4181, 38.05190000000, -87.24850000000, '108490'),
(13119, 'US-IN-108491', 'Birdseye', 'CI', 4181, 38.30780000000, -86.70060000000, '108491'),
(13120, 'US-IN-108492', 'Branchville', 'CI', 4181, 38.13820000000, -86.58880000000, '108492'),
(13121, 'US-KY-108493', 'Greensburg', 'CI', 4184, 37.25070000000, -85.51770000000, '108493'),
(13122, 'US-KY-108494', 'Hindman', 'CI', 4184, 37.33540000000, -82.95660000000, '108494'),
(13123, 'US-WI-108495', 'Rock Springs', 'CI', 4221, 43.45990000000, -89.93190000000, '108495'),
(13124, 'US-OH-108496', 'Milford', 'CI', 4204, 39.16590000000, -84.22950000000, '108496'),
(13125, 'US-OH-108497', 'Okeana', 'CI', 4204, 39.35550000000, -84.77930000000, '108497'),
(13126, 'US-KY-108498', 'Walton', 'CI', 4184, 38.88820000000, -84.64170000000, '108498'),
(13127, 'US-KY-108499', 'Falmouth', 'CI', 4184, 38.66880000000, -84.34690000000, '108499'),
(13128, 'US-KY-108500', 'Mount Sterling', 'CI', 4184, 38.06350000000, -83.93630000000, '108500'),
(13129, 'US-KY-108501', 'Hyden', 'CI', 4184, 37.17830000000, -83.43230000000, '108501'),
(13130, 'US-AR-108502', 'Bono', 'CI', 4165, 35.95640000000, -90.78410000000, '108502'),
(13131, 'US-AL-108503', 'Stevenson', 'CI', 4161, 34.87870000000, -85.90780000000, '108503'),
(13132, 'US-TN-108504', 'Jasper', 'CI', 4213, 35.06800000000, -85.61290000000, '108504'),
(13133, 'US-AL-108505', 'Shorter', 'CI', 4161, 32.38930000000, -85.90640000000, '108505'),
(13134, 'US-GA-108506', 'Acworth', 'CI', 4176, 34.02640000000, -84.69980000000, '108506'),
(13135, 'US-CT-108507', 'Torrington', 'CI', 4171, 41.83940000000, -73.12550000000, '108507'),
(13136, 'US-GA-108508', 'Pine Mountain', 'CI', 4176, 32.86070000000, -84.90510000000, '108508'),
(13137, 'US-IA-108509', 'Chariton', 'CI', 4182, 41.02970000000, -93.27020000000, '108509'),
(13138, 'US-TX-108510', 'Midlothian', 'CI', 4214, 32.46800000000, -96.98730000000, '108510'),
(13139, 'US-TX-108511', 'Rosenberg', 'CI', 4214, 29.52720000000, -95.87640000000, '108511'),
(13140, 'US-MI-108512', 'Fraser', 'CI', 4190, 42.53870000000, -82.94940000000, '108512'),
(13141, 'US-MI-108513', 'Grand Blanc', 'CI', 4190, 42.91960000000, -83.64960000000, '108513'),
(13142, 'US-MI-108514', 'Armada', 'CI', 4190, 42.85000000000, -82.92340000000, '108514'),
(13143, 'US-WA-108515', 'Ashford', 'CI', 4219, 46.77180000000, -122.00210000000, '108515'),
(13144, 'US-TX-108516', 'Brownsville', 'CI', 4214, 25.95090000000, -97.32540000000, '108516'),
(13145, 'US-ID-108517', 'Gooding', 'CI', 4179, 43.01860000000, -114.70240000000, '108517'),
(13146, 'US-WA-108518', 'Port Townsend', 'CI', 4219, 48.03540000000, -122.81450000000, '108518'),
(13147, 'US-ID-108519', 'Lapwai', 'CI', 4179, 46.32380000000, -116.78160000000, '108519'),
(13148, 'US-ID-108520', 'Plummer', 'CI', 4179, 47.28640000000, -116.88760000000, '108520'),
(13149, 'US-ID-108521', 'Hope', 'CI', 4179, 48.26020000000, -116.24550000000, '108521'),
(13150, 'US-CA-108522', 'Pacific Palisades', 'CI', 4169, 34.07970000000, -118.54840000000, '108522'),
(13151, 'US-WV-108523', 'Foster', 'CI', 4220, 38.08300000000, -81.77870000000, '108523'),
(13152, 'US-NY-108524', 'Baldwinsville', 'CI', 4200, 43.17650000000, -76.36400000000, '108524'),
(13153, 'US-VA-108525', 'Somerset', 'CI', 4218, 38.21180000000, -78.23350000000, '108525'),
(13154, 'US-SC-108526', 'Seneca', 'CI', 4211, 34.74190000000, -82.90670000000, '108526'),
(13155, 'US-NY-108527', 'Owego', 'CI', 4200, 42.13360000000, -76.26460000000, '108527'),
(13156, 'US-OH-108528', 'Powell', 'CI', 4204, 40.17680000000, -83.07920000000, '108528'),
(13157, 'US-WY-108529', 'Evansville', 'CI', 4222, 42.79900000000, -106.07620000000, '108529'),
(13158, 'US-WY-108530', 'Buffalo', 'CI', 4222, 44.21950000000, -106.60020000000, '108530'),
(13159, 'US-CO-108531', 'Eaton', 'CI', 4170, 40.55230000000, -104.65120000000, '108531'),
(13160, 'US-WV-108532', 'Logan', 'CI', 4220, 37.83070000000, -81.96990000000, '108532'),
(13161, 'US-MD-108533', 'Thurmont', 'CI', 4188, 39.59280000000, -77.42390000000, '108533'),
(13162, 'US-SC-108534', 'Lobeco', 'CI', 4211, 32.55390000000, -80.74540000000, '108534'),
(13163, 'US-MO-108535', 'Plattsburg', 'CI', 4193, 39.57060000000, -94.45960000000, '108535'),
(13164, 'US-NY-108536', 'Middletown', 'CI', 4200, 41.48710000000, -74.34330000000, '108536'),
(13165, 'US-NY-108537', 'Port Jervis', 'CI', 4200, 41.37290000000, -74.64070000000, '108537'),
(13166, 'US-NY-108538', 'West Babylon', 'CI', 4200, 40.70660000000, -73.35010000000, '108538'),
(13167, 'US-NY-108539', 'Walden', 'CI', 4200, 41.55890000000, -74.14810000000, '108539'),
(13168, 'US-NY-108540', 'Poughquag', 'CI', 4200, 41.63130000000, -73.67890000000, '108540'),
(13169, 'US-PA-108541', 'Milford', 'CI', 4208, 41.34020000000, -74.86860000000, '108541'),
(13170, 'US-TX-108542', 'Robstown', 'CI', 4214, 27.76040000000, -97.74290000000, '108542'),
(13171, 'US-NY-108543', 'Chappaqua', 'CI', 4200, 41.17260000000, -73.77120000000, '108543'),
(13172, 'US-NY-108544', 'Tappan', 'CI', 4200, 41.02590000000, -73.94840000000, '108544'),
(13173, 'US-NY-108545', 'Spring Valley', 'CI', 4200, 41.11630000000, -74.04600000000, '108545'),
(13174, 'US-TX-108546', 'South Padre Island', 'CI', 4214, 26.23940000000, -97.18530000000, '108546'),
(13175, 'US-NY-108547', 'Hopewell Junction', 'CI', 4200, 41.54580000000, -73.78150000000, '108547'),
(13176, 'US-NY-108548', 'Chester', 'CI', 4200, 41.34670000000, -74.26190000000, '108548'),
(13177, 'US-NY-108549', 'Monsey', 'CI', 4200, 41.11810000000, -74.08330000000, '108549'),
(13178, 'US-NY-108550', 'Huntington', 'CI', 4200, 40.87190000000, -73.43470000000, '108550'),
(13179, 'US-NY-108551', 'Manhasset', 'CI', 4200, 40.79390000000, -73.68620000000, '108551'),
(13180, 'US-MO-108552', 'Camdenton', 'CI', 4193, 37.98870000000, -92.75360000000, '108552'),
(13181, 'US-IL-108553', 'Charleston', 'CI', 4180, 39.49950000000, -88.15810000000, '108553'),
(13182, 'US-IL-108554', 'Nashville', 'CI', 4180, 38.32910000000, -89.40460000000, '108554'),
(13183, 'US-IL-108555', 'Fairfield', 'CI', 4180, 38.36190000000, -88.35960000000, '108555'),
(13184, 'US-IL-108556', 'Lawrenceville', 'CI', 4180, 38.73990000000, -87.63410000000, '108556');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(13185, 'US-IL-108557', 'Pinckneyville', 'CI', 4180, 38.08340000000, -89.39880000000, '108557'),
(13186, 'US-IL-108558', 'Albion', 'CI', 4180, 38.38360000000, -88.06530000000, '108558'),
(13187, 'US-IL-108559', 'Pittsfield', 'CI', 4180, 39.57770000000, -90.77550000000, '108559'),
(13188, 'US-IL-108560', 'Metropolis', 'CI', 4180, 37.23000000000, -88.71390000000, '108560'),
(13189, 'US-MO-108561', 'De Soto', 'CI', 4193, 38.11250000000, -90.56740000000, '108561'),
(13190, 'US-IL-108562', 'Eldorado', 'CI', 4180, 37.82740000000, -88.44150000000, '108562'),
(13191, 'US-IL-108563', 'Goreville', 'CI', 4180, 37.54980000000, -88.98600000000, '108563'),
(13192, 'US-MO-108564', 'Saint Ann', 'CI', 4193, 38.72620000000, -90.38900000000, '108564'),
(13193, 'US-IL-108565', 'Greenville', 'CI', 4180, 38.88450000000, -89.44430000000, '108565'),
(13194, 'US-IL-108566', 'Berwyn', 'CI', 4180, 41.83210000000, -87.78970000000, '108566'),
(13195, 'US-TX-108567', 'Fannin', 'CI', 4214, 28.65620000000, -97.42250000000, '108567'),
(13196, 'US-IL-108568', 'Fisher', 'CI', 4180, 40.32170000000, -88.34620000000, '108568'),
(13197, 'US-NY-108569', 'Buchanan', 'CI', 4200, 41.26280000000, -73.94560000000, '108569'),
(13198, 'US-TX-108570', 'Comanche', 'CI', 4214, 31.88920000000, -98.63850000000, '108570'),
(13199, 'US-TX-108571', 'Millsap', 'CI', 4214, 32.70350000000, -97.98890000000, '108571'),
(13200, 'US-TX-108572', 'Crowley', 'CI', 4214, 32.58380000000, -97.41420000000, '108572'),
(13201, 'US-CT-108573', 'Sharon', 'CI', 4171, 41.85510000000, -73.44150000000, '108573'),
(13202, 'US-MD-108574', 'Havre De Grace', 'CI', 4188, 39.55640000000, -76.12420000000, '108574'),
(13203, 'US-OH-108575', 'Willard', 'CI', 4204, 41.09050000000, -82.69720000000, '108575'),
(13204, 'US-KY-108576', 'Drakesboro', 'CI', 4184, 37.23850000000, -87.00350000000, '108576'),
(13205, 'US-CO-108577', 'Elizabeth', 'CI', 4170, 39.40360000000, -104.56040000000, '108577'),
(13206, 'US-IL-108578', 'River Grove', 'CI', 4180, 41.92310000000, -87.83960000000, '108578'),
(13207, 'US-IL-108579', 'Rochelle', 'CI', 4180, 41.96270000000, -89.05110000000, '108579'),
(13208, 'US-IN-108580', 'Schererville', 'CI', 4181, 41.48810000000, -87.44240000000, '108580'),
(13209, 'US-IL-108581', 'Lincolnwood', 'CI', 4180, 42.00660000000, -87.73690000000, '108581'),
(13210, 'US-IL-108582', 'Dundee', 'CI', 4180, 42.11210000000, -88.34310000000, '108582'),
(13211, 'US-CA-108583', 'Colusa', 'CI', 4169, 39.27390000000, -122.05460000000, '108583'),
(13212, 'US-WV-108584', 'Poca', 'CI', 4220, 38.51450000000, -81.78140000000, '108584'),
(13213, 'US-CA-108585', 'Bella Vista', 'CI', 4169, 40.70160000000, -122.09660000000, '108585'),
(13214, 'US-CA-108586', 'Auburn', 'CI', 4169, 38.92340000000, -121.07050000000, '108586'),
(13215, 'US-CA-108587', 'Woodland', 'CI', 4169, 38.71440000000, -121.85290000000, '108587'),
(13216, 'US-CA-108588', 'Plymouth', 'CI', 4169, 38.46730000000, -120.88680000000, '108588'),
(13217, 'US-OH-108589', 'Pickerington', 'CI', 4204, 39.89800000000, -82.74590000000, '108589'),
(13218, 'US-TX-108590', 'Sunnyvale', 'CI', 4214, 32.80300000000, -96.56230000000, '108590'),
(13219, 'US-TX-108591', 'Jewett', 'CI', 4214, 31.31720000000, -96.17130000000, '108591'),
(13220, 'US-TX-108592', 'Daingerfield', 'CI', 4214, 33.01620000000, -94.73660000000, '108592'),
(13221, 'US-OH-108593', 'Lancaster', 'CI', 4204, 39.68780000000, -82.60460000000, '108593'),
(13222, 'US-TX-108594', 'Bonham', 'CI', 4214, 33.57900000000, -96.18890000000, '108594'),
(13223, 'US-NJ-108595', 'Maplewood', 'CI', 4198, 40.72980000000, -74.26620000000, '108595'),
(13224, 'US-TX-108596', 'Ben Wheeler', 'CI', 4214, 32.44190000000, -95.63350000000, '108596'),
(13225, 'US-UT-108597', 'Cedar City', 'CI', 4215, 37.81160000000, -113.22410000000, '108597'),
(13226, 'US-PA-108598', 'Enola', 'CI', 4208, 40.29180000000, -77.00220000000, '108598'),
(13227, 'US-PA-108599', 'Pine Grove Mills', 'CI', 4208, 40.73090000000, -77.88610000000, '108599'),
(13228, 'US-PA-108600', 'Shrewsbury', 'CI', 4208, 39.76690000000, -76.67890000000, '108600'),
(13229, 'US-MA-108601', 'Pepperell', 'CI', 4189, 42.66550000000, -71.59520000000, '108601'),
(13230, 'US-PA-108602', 'Mountville', 'CI', 4208, 40.03780000000, -76.42090000000, '108602'),
(13231, 'US-FL-108603', 'Eastpoint', 'CI', 4175, 29.86130000000, -84.90550000000, '108603'),
(13232, 'US-FL-108604', 'Vernon', 'CI', 4175, 30.57800000000, -85.77820000000, '108604'),
(13233, 'US-FL-108605', 'Keystone Heights', 'CI', 4175, 29.82280000000, -81.96480000000, '108605'),
(13234, 'US-GA-108606', 'East Dublin', 'CI', 4176, 32.55990000000, -82.81840000000, '108606'),
(13235, 'US-CA-108607', 'Placentia', 'CI', 4169, 33.88180000000, -117.85030000000, '108607'),
(13236, 'US-VA-108608', 'Beaverdam', 'CI', 4218, 37.93480000000, -77.55910000000, '108608'),
(13237, 'US-VA-108609', 'Buena Vista', 'CI', 4218, 37.72980000000, -79.32680000000, '108609'),
(13238, 'US-VA-108610', 'Roseland', 'CI', 4218, 37.81200000000, -78.95880000000, '108610'),
(13239, 'US-MI-108611', 'Lake Orion', 'CI', 4190, 42.72510000000, -83.27160000000, '108611'),
(13240, 'US-MI-108612', 'Clawson', 'CI', 4190, 42.53680000000, -83.14640000000, '108612'),
(13241, 'US-GA-108613', 'Cumming', 'CI', 4176, 34.22810000000, -84.17800000000, '108613'),
(13242, 'US-MI-108614', 'Birch Run', 'CI', 4190, 43.27120000000, -83.80790000000, '108614'),
(13243, 'US-NY-108615', 'Great Neck', 'CI', 4200, 40.78520000000, -73.72790000000, '108615'),
(13244, 'US-MD-108616', 'North East', 'CI', 4188, 39.57540000000, -75.92690000000, '108616'),
(13245, 'US-OH-108617', 'North Baltimore', 'CI', 4204, 41.19080000000, -83.68640000000, '108617'),
(13246, 'US-MD-108618', 'College Park', 'CI', 4188, 39.00120000000, -76.93170000000, '108618'),
(13247, 'US-VA-108619', 'Delaplane', 'CI', 4218, 38.91870000000, -77.93620000000, '108619'),
(13248, 'US-MS-108620', 'Biloxi', 'CI', 4192, 30.40300000000, -88.96600000000, '108620'),
(13249, 'US-AL-108621', 'Florala', 'CI', 4161, 31.10800000000, -86.36220000000, '108621'),
(13250, 'US-LA-108622', 'Duson', 'CI', 4185, 30.18150000000, -92.18250000000, '108622'),
(13251, 'US-LA-108623', 'Kenner', 'CI', 4185, 29.98940000000, -90.25290000000, '108623'),
(13252, 'US-MS-108624', 'Poplarville', 'CI', 4192, 30.81710000000, -89.58820000000, '108624'),
(13253, 'US-LA-108625', 'Zachary', 'CI', 4185, 30.63790000000, -91.17970000000, '108625'),
(13254, 'US-LA-108626', 'Maurice', 'CI', 4185, 30.07420000000, -92.14830000000, '108626'),
(13255, 'US-PA-108627', 'Woolrich', 'CI', 4208, 41.20160000000, -77.36430000000, '108627'),
(13256, 'US-PA-108628', 'Mount Union', 'CI', 4208, 40.34000000000, -77.85580000000, '108628'),
(13257, 'US-VA-108629', 'Hardy', 'CI', 4218, 37.17590000000, -79.80130000000, '108629'),
(13258, 'US-NC-108630', 'Clayton', 'CI', 4201, 35.62630000000, -78.43710000000, '108630'),
(13259, 'US-NC-108631', 'Snow Hill', 'CI', 4201, 35.44480000000, -77.68920000000, '108631'),
(13260, 'US-NC-108632', 'Morehead City', 'CI', 4201, 34.73860000000, -76.76770000000, '108632'),
(13261, 'US-NC-108633', 'Camp Lejeune', 'CI', 4201, 34.64030000000, -77.30430000000, '108633'),
(13262, 'US-NC-108634', 'Mccutcheon Field', 'CI', 4201, 34.69210000000, -77.39120000000, '108634'),
(13263, 'US-CA-108635', 'Aptos', 'CI', 4169, 37.00820000000, -121.87770000000, '108635'),
(13264, 'US-ID-108636', 'Fruitland', 'CI', 4179, 43.96700000000, -116.91230000000, '108636'),
(13265, 'US-FL-108637', 'Ocoee', 'CI', 4175, 28.57040000000, -81.52980000000, '108637'),
(13266, 'US-FL-108638', 'Zolfo Springs', 'CI', 4175, 27.46620000000, -81.70840000000, '108638'),
(13267, 'US-FL-108639', 'Fort Myers Beach', 'CI', 4175, 26.47070000000, -81.91810000000, '108639'),
(13268, 'PR-??-108640', 'Gurabo', 'CI', 181, 18.28080000000, -65.97410000000, '108640'),
(13269, 'US-MO-108641', 'Clarksville', 'CI', 4193, 39.33860000000, -90.93680000000, '108641'),
(13270, 'PR-??-108642', 'Guayama', 'CI', 181, 17.97890000000, -66.11020000000, '108642'),
(13271, 'PR-??-108643', 'Caguas', 'CI', 181, 18.22730000000, -66.05800000000, '108643'),
(13272, 'VI-??-108644', 'Christiansted', 'CI', 237, 17.73420000000, -64.73470000000, '108644'),
(13273, 'US-ID-108645', 'Preston', 'CI', 4179, 42.20740000000, -111.74600000000, '108645'),
(13274, 'US-PA-108646', 'Fredonia', 'CI', 4208, 41.33180000000, -80.26220000000, '108646'),
(13275, 'US-WI-108647', 'Prairie Du Sac', 'CI', 4221, 43.31490000000, -89.80560000000, '108647'),
(13276, 'US-WI-108648', 'Monroe', 'CI', 4221, 42.61060000000, -89.65140000000, '108648'),
(13277, 'US-WI-108649', 'Antigo', 'CI', 4221, 45.10270000000, -89.19100000000, '108649'),
(13278, 'US-WI-108650', 'Waupaca', 'CI', 4221, 44.32230000000, -89.12070000000, '108650'),
(13279, 'US-WI-108651', 'Avalon', 'CI', 4221, 42.65920000000, -88.83070000000, '108651'),
(13280, 'US-WI-108652', 'Elroy', 'CI', 4221, 43.75280000000, -90.29230000000, '108652'),
(13281, 'US-NJ-108653', 'Wharton', 'CI', 4198, 40.93740000000, -74.58360000000, '108653'),
(13282, 'US-WI-108654', 'Delavan', 'CI', 4221, 42.64950000000, -88.65940000000, '108654'),
(13283, 'US-WI-108655', 'Onalaska', 'CI', 4221, 43.91020000000, -91.24320000000, '108655'),
(13284, 'US-WI-108656', 'Verona', 'CI', 4221, 42.99250000000, -89.56790000000, '108656'),
(13285, 'US-PA-108657', 'Whitehall', 'CI', 4208, 40.65710000000, -75.50300000000, '108657'),
(13286, 'US-PA-108658', 'Mifflinburg', 'CI', 4208, 40.96510000000, -77.09990000000, '108658'),
(13287, 'US-PA-108659', 'Temple', 'CI', 4208, 40.40510000000, -75.88330000000, '108659'),
(13288, 'US-NC-108660', 'Winterville', 'CI', 4201, 35.51270000000, -77.41460000000, '108660'),
(13289, 'US-NC-108661', 'Fort Bragg', 'CI', 4201, 35.05060000000, -78.80380000000, '108661'),
(13290, 'US-WI-108662', 'Marathon', 'CI', 4221, 44.93700000000, -89.82680000000, '108662'),
(13291, 'US-FL-108663', 'Clermont', 'CI', 4175, 28.50500000000, -81.78970000000, '108663'),
(13292, 'US-TX-108664', 'Hallettsville', 'CI', 4214, 29.35250000000, -96.82810000000, '108664'),
(13293, 'US-TX-108665', 'Sinton', 'CI', 4214, 28.04820000000, -97.49100000000, '108665'),
(13294, 'US-TX-108666', 'Portland', 'CI', 4214, 27.89230000000, -97.31870000000, '108666'),
(13295, 'US-WI-108667', 'Merrimac', 'CI', 4221, 43.40140000000, -89.65420000000, '108667'),
(13296, 'US-IL-108668', 'Winslow', 'CI', 4180, 42.46440000000, -89.82630000000, '108668'),
(13297, 'US-IA-108669', 'Hamburg', 'CI', 4182, 40.62560000000, -95.68740000000, '108669'),
(13298, 'US-TX-108670', 'Gardendale', 'CI', 4214, 32.00260000000, -102.35870000000, '108670'),
(13299, 'US-TX-108671', 'Beeville', 'CI', 4214, 28.47310000000, -97.70710000000, '108671'),
(13300, 'US-TX-108672', 'Sierra Blanca', 'CI', 4214, 31.22450000000, -105.32030000000, '108672'),
(13301, 'US-CO-108673', 'Joes', 'CI', 4170, 39.69940000000, -102.67980000000, '108673'),
(13302, 'US-OK-108674', 'Harrah', 'CI', 4205, 35.50180000000, -97.13240000000, '108674'),
(13303, 'US-WI-108675', 'Montello', 'CI', 4221, 43.78290000000, -89.29830000000, '108675'),
(13304, 'US-IL-108676', 'Cherry Valley', 'CI', 4180, 42.20300000000, -88.95980000000, '108676'),
(13305, 'US-WI-108677', 'Rosholt', 'CI', 4221, 44.65940000000, -89.35690000000, '108677'),
(13306, 'US-WI-108678', 'Clinton', 'CI', 4221, 42.55810000000, -88.84530000000, '108678'),
(13307, 'US-IL-108679', 'Peru', 'CI', 4180, 41.38320000000, -89.14610000000, '108679'),
(13308, 'US-WI-108680', 'Bowler', 'CI', 4221, 44.87320000000, -88.95500000000, '108680'),
(13309, 'US-OH-108681', 'Union City', 'CI', 4204, 40.20830000000, -84.75700000000, '108681'),
(13310, 'US-IN-108682', 'Plymouth', 'CI', 4181, 41.35810000000, -86.31220000000, '108682'),
(13311, 'US-NJ-108683', 'Sea Girt', 'CI', 4198, 40.13200000000, -74.04610000000, '108683'),
(13312, 'US-NJ-108684', 'Hazlet', 'CI', 4198, 40.42420000000, -74.17460000000, '108684'),
(13313, 'US-NJ-108685', 'Oakhurst', 'CI', 4198, 40.26450000000, -74.02100000000, '108685'),
(13314, 'US-IN-108686', 'Hammond', 'CI', 4181, 41.60860000000, -87.49310000000, '108686'),
(13315, 'US-IN-108687', 'Demotte', 'CI', 4181, 41.18980000000, -87.25800000000, '108687'),
(13316, 'US-TX-108688', 'Nocona', 'CI', 4214, 33.82040000000, -97.73740000000, '108688'),
(13317, 'US-TX-108689', 'Bedford', 'CI', 4214, 32.85230000000, -97.13420000000, '108689'),
(13318, 'US-KS-108690', 'Osage City', 'CI', 4183, 38.59880000000, -95.83710000000, '108690'),
(13319, 'US-TX-108691', 'Seagraves', 'CI', 4214, 32.93990000000, -102.49610000000, '108691'),
(13320, 'US-VA-108692', 'Ridgeway', 'CI', 4218, 36.60060000000, -79.85450000000, '108692'),
(13321, 'US-NC-108693', 'Lowgap', 'CI', 4201, 36.51800000000, -80.83480000000, '108693'),
(13322, 'US-NC-108694', 'Denton', 'CI', 4201, 35.61400000000, -80.09520000000, '108694'),
(13323, 'US-WV-108695', 'Peterstown', 'CI', 4220, 37.43160000000, -80.76760000000, '108695'),
(13324, 'US-IN-108696', 'Brookville', 'CI', 4181, 39.40470000000, -84.97360000000, '108696'),
(13325, 'US-NH-108697', 'Grafton', 'CI', 4197, 43.57800000000, -71.96680000000, '108697'),
(13326, 'US-VT-108698', 'Bethel', 'CI', 4216, 43.79950000000, -72.65610000000, '108698'),
(13327, 'US-NY-108699', 'Auburn', 'CI', 4200, 42.91290000000, -76.56590000000, '108699'),
(13328, 'US-PA-108700', 'Frackville', 'CI', 4208, 40.78520000000, -76.22300000000, '108700'),
(13329, 'US-PA-108701', 'Tipton', 'CI', 4208, 40.63480000000, -78.30210000000, '108701'),
(13330, 'US-PA-108702', 'Greencastle', 'CI', 4208, 39.79910000000, -77.75400000000, '108702'),
(13331, 'US-PA-108703', 'Columbia', 'CI', 4208, 40.04750000000, -76.48440000000, '108703'),
(13332, 'US-PA-108704', 'Lemoyne', 'CI', 4208, 40.25250000000, -76.89700000000, '108704'),
(13333, 'US-PA-108705', 'Shippensburg', 'CI', 4208, 40.04580000000, -77.48070000000, '108705'),
(13334, 'US-PA-108706', 'Fredericksburg', 'CI', 4208, 40.47100000000, -76.43130000000, '108706'),
(13335, 'US-IN-108707', 'Nabb', 'CI', 4181, 38.58640000000, -85.53180000000, '108707'),
(13336, 'US-TX-108708', 'Hockley', 'CI', 4214, 30.05510000000, -95.81870000000, '108708'),
(13337, 'US-PA-108709', 'Stroudsburg', 'CI', 4208, 40.95880000000, -75.30060000000, '108709'),
(13338, 'US-TX-108710', 'Navasota', 'CI', 4214, 30.37060000000, -96.05650000000, '108710'),
(13339, 'US-PA-108711', 'New Freedom', 'CI', 4208, 39.76970000000, -76.65630000000, '108711'),
(13340, 'US-TX-108712', 'Farmersville', 'CI', 4214, 33.17560000000, -96.34410000000, '108712'),
(13341, 'US-VA-108713', 'Elberon', 'CI', 4218, 37.07190000000, -76.83100000000, '108713'),
(13342, 'US-CO-108714', 'Hotchkiss', 'CI', 4170, 38.96270000000, -107.72230000000, '108714'),
(13343, 'US-WY-108715', 'Teton Village', 'CI', 4222, 43.55210000000, -110.82330000000, '108715'),
(13344, 'US-WY-108716', 'Baggs', 'CI', 4222, 41.09340000000, -107.70980000000, '108716'),
(13345, 'US-WY-108717', 'Riverton', 'CI', 4222, 42.92000000000, -108.04670000000, '108717'),
(13346, 'US-CO-108718', 'Breckenridge', 'CI', 4170, 39.46780000000, -105.99620000000, '108718'),
(13347, 'US-CO-108719', 'Granby', 'CI', 4170, 40.17660000000, -105.89710000000, '108719'),
(13348, 'US-PA-108720', 'Upper Black Eddy', 'CI', 4208, 40.53010000000, -75.12490000000, '108720'),
(13349, 'US-CT-108721', 'Putnam', 'CI', 4171, 41.90090000000, -71.86530000000, '108721'),
(13350, 'US-DE-108722', 'Claymont', 'CI', 4172, 39.80410000000, -75.45590000000, '108722'),
(13351, 'US-PA-108723', 'Atglen', 'CI', 4208, 39.93500000000, -75.96320000000, '108723'),
(13352, 'US-MI-108724', 'Fowlerville', 'CI', 4190, 42.66250000000, -84.06740000000, '108724'),
(13353, 'US-GA-108725', 'Braselton', 'CI', 4176, 34.13660000000, -83.78370000000, '108725'),
(13354, 'US-TN-108726', 'Loudon', 'CI', 4213, 35.71020000000, -84.37430000000, '108726'),
(13355, 'US-CT-108727', 'Old Saybrook', 'CI', 4171, 41.30090000000, -72.38760000000, '108727'),
(13356, 'US-CT-108728', 'Moosup', 'CI', 4171, 41.70460000000, -71.84900000000, '108728'),
(13357, 'US-CT-108729', 'Uncasville', 'CI', 4171, 41.46260000000, -72.13090000000, '108729'),
(13358, 'US-CT-108730', 'Willimantic', 'CI', 4171, 41.70940000000, -72.21120000000, '108730'),
(13359, 'US-CT-108731', 'East Windsor', 'CI', 4171, 41.90330000000, -72.58540000000, '108731'),
(13360, 'US-MA-108732', 'Ludlow', 'CI', 4189, 42.19260000000, -72.45980000000, '108732'),
(13361, 'US-MA-108733', 'Lenox', 'CI', 4189, 42.36650000000, -73.26360000000, '108733'),
(13362, 'US-MA-108734', 'Sheffield', 'CI', 4189, 42.10390000000, -73.36780000000, '108734'),
(13363, 'US-CT-108735', 'Dayville', 'CI', 4171, 41.85310000000, -71.86010000000, '108735'),
(13364, 'US-CT-108736', 'Newington', 'CI', 4171, 41.68560000000, -72.73120000000, '108736'),
(13365, 'US-MA-108737', 'North Adams', 'CI', 4189, 42.68810000000, -73.06300000000, '108737'),
(13366, 'US-NY-108738', 'Bedford Hills', 'CI', 4200, 41.23000000000, -73.68940000000, '108738'),
(13367, 'US-CT-108739', 'Ledyard', 'CI', 4171, 41.44430000000, -71.99960000000, '108739'),
(13368, 'US-CT-108740', 'East Berlin', 'CI', 4171, 41.61390000000, -72.72060000000, '108740'),
(13369, 'US-CT-108741', 'Gales Ferry', 'CI', 4171, 41.43960000000, -72.06090000000, '108741'),
(13370, 'US-CT-108742', 'North Franklin', 'CI', 4171, 41.61430000000, -72.14910000000, '108742'),
(13371, 'US-LA-108743', 'Greenwood', 'CI', 4185, 32.44360000000, -93.98870000000, '108743'),
(13372, 'US-LA-108744', 'Elm Grove', 'CI', 4185, 32.33990000000, -93.51190000000, '108744'),
(13373, 'US-LA-108745', 'Winnsboro', 'CI', 4185, 32.13440000000, -91.71120000000, '108745'),
(13374, 'US-WA-108746', 'Coupeville', 'CI', 4219, 48.18550000000, -122.66800000000, '108746'),
(13375, 'US-TX-108747', 'Lumberton', 'CI', 4214, 30.23110000000, -94.20660000000, '108747'),
(13376, 'US-KS-108748', 'Chapman', 'CI', 4183, 38.88710000000, -97.00670000000, '108748'),
(13377, 'US-FL-108749', 'Christmas', 'CI', 4175, 28.48040000000, -80.98490000000, '108749'),
(13378, 'US-FL-108750', 'Homosassa', 'CI', 4175, 28.75010000000, -82.51660000000, '108750'),
(13379, 'US-FL-108751', 'Palm Bay', 'CI', 4175, 28.03810000000, -80.61150000000, '108751'),
(13380, 'US-NC-108752', 'Oxford', 'CI', 4201, 36.34820000000, -78.64630000000, '108752'),
(13381, 'US-IA-108753', 'Fairfax', 'CI', 4182, 41.89830000000, -91.79380000000, '108753'),
(13382, 'US-LA-108754', 'Sulphur', 'CI', 4185, 30.25850000000, -93.40630000000, '108754'),
(13383, 'US-IA-108755', 'Williamsburg', 'CI', 4182, 41.64420000000, -92.00810000000, '108755'),
(13384, 'US-VA-108756', 'Abingdon', 'CI', 4218, 36.76200000000, -82.03880000000, '108756'),
(13385, 'US-NC-108757', 'Rutherfordton', 'CI', 4201, 35.34040000000, -82.02610000000, '108757'),
(13386, 'US-NC-108758', 'Norwood', 'CI', 4201, 35.21830000000, -80.15970000000, '108758'),
(13387, 'US-NC-108759', 'Salisbury', 'CI', 4201, 35.68720000000, -80.56690000000, '108759'),
(13388, 'US-NC-108760', 'Waynesville', 'CI', 4201, 35.63460000000, -83.02300000000, '108760'),
(13389, 'US-SC-108761', 'Simpsonville', 'CI', 4211, 34.76640000000, -82.22020000000, '108761'),
(13390, 'US-TX-108762', 'Commerce', 'CI', 4214, 33.28440000000, -95.92060000000, '108762'),
(13391, 'US-IN-108763', 'New Richmond', 'CI', 4181, 40.19030000000, -87.00780000000, '108763'),
(13393, 'US-WA-108765', 'Mukilteo', 'CI', 4219, 47.91300000000, -122.30420000000, '108765'),
(13394, 'US-NY-108766', 'Canandaigua', 'CI', 4200, 42.83260000000, -77.30960000000, '108766'),
(13395, 'US-KY-108767', 'Owingsville', 'CI', 4184, 38.15920000000, -83.77360000000, '108767'),
(13396, 'US-NJ-108768', 'Ridgefield Park', 'CI', 4198, 40.85360000000, -74.02090000000, '108768'),
(13397, 'US-WA-108769', 'Silverdale', 'CI', 4219, 47.72440000000, -122.71910000000, '108769'),
(13398, 'US-WA-108770', 'Darrington', 'CI', 4219, 48.19660000000, -121.53720000000, '108770'),
(13399, 'US-WA-108771', 'Blaine', 'CI', 4219, 48.93010000000, -122.72530000000, '108771'),
(13400, 'US-WA-108772', 'Maple Valley', 'CI', 4219, 47.40610000000, -121.99530000000, '108772'),
(13401, 'US-WA-108773', 'Lakewood', 'CI', 4219, 47.16800000000, -122.50270000000, '108773'),
(13402, 'US-WA-108774', 'Monroe', 'CI', 4219, 47.87030000000, -121.88100000000, '108774'),
(13403, 'US-WA-108775', 'Gold Bar', 'CI', 4219, 47.86360000000, -121.66230000000, '108775'),
(13404, 'US-OR-108776', 'Milton Freewater', 'CI', 4206, 45.90290000000, -118.34010000000, '108776'),
(13405, 'US-OR-108777', 'Central Point', 'CI', 4206, 42.39140000000, -122.93670000000, '108777'),
(13406, 'US-OH-108778', 'New Philadelphia', 'CI', 4204, 40.44100000000, -81.49200000000, '108778'),
(13407, 'US-GA-108779', 'Forest Park', 'CI', 4176, 33.61160000000, -84.37260000000, '108779'),
(13408, 'US-TX-108780', 'Seguin', 'CI', 4214, 29.56730000000, -97.93090000000, '108780'),
(13409, 'US-MT-108781', 'Butte', 'CI', 4194, 46.00920000000, -112.44210000000, '108781'),
(13410, 'US-PA-108782', 'Greenville', 'CI', 4208, 41.40820000000, -80.36660000000, '108782'),
(13411, 'US-WV-108783', 'Salem', 'CI', 4220, 39.29100000000, -80.57030000000, '108783'),
(13412, 'US-PA-108784', 'New Wilmington', 'CI', 4208, 41.13500000000, -80.33550000000, '108784'),
(13413, 'US-PA-108785', 'Stoystown', 'CI', 4208, 40.08950000000, -78.95610000000, '108785'),
(13414, 'US-PA-108786', 'Point Marion', 'CI', 4208, 39.75720000000, -79.90220000000, '108786'),
(13415, 'US-MI-108787', 'Escanaba', 'CI', 4190, 45.75660000000, -87.15710000000, '108787'),
(13416, 'US-NY-108788', 'Roslyn', 'CI', 4200, 40.80820000000, -73.63860000000, '108788'),
(13417, 'US-WI-108789', 'Waterford', 'CI', 4221, 42.78700000000, -88.20910000000, '108789'),
(13418, 'US-VA-108790', 'Surry', 'CI', 4218, 37.11660000000, -76.75340000000, '108790'),
(13419, 'US-TN-108791', 'South Fulton', 'CI', 4213, 36.44800000000, -88.88100000000, '108791'),
(13420, 'US-WA-108792', 'Woodland', 'CI', 4219, 45.94200000000, -122.67230000000, '108792'),
(13421, 'US-OR-108793', 'Prineville', 'CI', 4206, 44.10660000000, -120.66420000000, '108793'),
(13422, 'US-OR-108794', 'Gold Beach', 'CI', 4206, 42.45170000000, -124.30620000000, '108794'),
(13423, 'US-ID-108795', 'Garden City', 'CI', 4179, 43.64610000000, -116.26750000000, '108795'),
(13424, 'US-AL-108796', 'Opp', 'CI', 4161, 31.29360000000, -86.25950000000, '108796'),
(13425, 'US-NJ-108797', 'Browns Mills', 'CI', 4198, 39.94560000000, -74.55580000000, '108797'),
(13426, 'US-TX-108798', 'Poolville', 'CI', 4214, 32.98420000000, -97.87130000000, '108798'),
(13427, 'US-TX-108799', 'Boyd', 'CI', 4214, 33.05300000000, -97.59940000000, '108799'),
(13428, 'US-AL-108800', 'Remlap', 'CI', 4161, 33.83080000000, -86.59470000000, '108800'),
(13429, 'US-IN-108801', 'Pendleton', 'CI', 4181, 39.98090000000, -85.74890000000, '108801'),
(13430, 'US-NJ-108802', 'Pittstown', 'CI', 4198, 40.57140000000, -74.97250000000, '108802'),
(13431, 'US-MN-108803', 'Tyler', 'CI', 4191, 44.29870000000, -96.12450000000, '108803'),
(13432, 'US-MI-108804', 'Columbiaville', 'CI', 4190, 43.14680000000, -83.38350000000, '108804'),
(13433, 'US-WV-108805', 'Kenova', 'CI', 4220, 38.34270000000, -82.54450000000, '108805'),
(13434, 'US-OH-108806', 'Frazeysburg', 'CI', 4204, 40.17470000000, -82.15760000000, '108806'),
(13435, 'US-OH-108807', 'Zanesville', 'CI', 4204, 39.95530000000, -82.07180000000, '108807'),
(13436, 'US-OH-108808', 'Athens', 'CI', 4204, 39.30310000000, -82.08280000000, '108808'),
(13437, 'US-KY-108809', 'Vanceburg', 'CI', 4184, 38.50840000000, -83.41060000000, '108809'),
(13438, 'US-KY-108810', 'Louisa', 'CI', 4184, 38.09540000000, -82.72110000000, '108810'),
(13439, 'US-OH-108811', 'Sunbury', 'CI', 4204, 40.26670000000, -82.84770000000, '108811'),
(13440, 'US-IL-108812', 'Elburn', 'CI', 4180, 41.86600000000, -88.48280000000, '108812'),
(13441, 'US-WV-108813', 'Barboursville', 'CI', 4220, 38.38810000000, -82.22580000000, '108813'),
(13442, 'US-OH-108814', 'Blacklick', 'CI', 4204, 40.01220000000, -82.80950000000, '108814'),
(13443, 'US-NY-108815', 'Springfield Gardens', 'CI', 4200, 40.66500000000, -73.75020000000, '108815'),
(13444, 'US-NY-108816', 'Jericho', 'CI', 4200, 40.79320000000, -73.54240000000, '108816'),
(13445, 'US-NY-108817', 'Wantagh', 'CI', 4200, 40.66950000000, -73.51100000000, '108817'),
(13446, 'US-NY-108818', 'Hollis', 'CI', 4200, 40.71610000000, -73.76750000000, '108818'),
(13447, 'US-MI-108819', 'Pinckney', 'CI', 4190, 42.45810000000, -83.94680000000, '108819'),
(13448, 'US-IN-108820', 'Hartford City', 'CI', 4181, 40.47250000000, -85.34220000000, '108820'),
(13449, 'US-TX-108821', 'Granbury', 'CI', 4214, 32.42720000000, -97.79820000000, '108821'),
(13450, 'US-NY-108822', 'Canajoharie', 'CI', 4200, 42.85270000000, -74.59740000000, '108822'),
(13451, 'US-NE-108823', 'David City', 'CI', 4195, 41.24230000000, -97.14810000000, '108823'),
(13452, 'US-MD-108824', 'Woodstock', 'CI', 4188, 39.34060000000, -76.85930000000, '108824'),
(13453, 'US-MD-108825', 'New Windsor', 'CI', 4188, 39.51000000000, -77.10650000000, '108825'),
(13454, 'US-VA-108826', 'Goodview', 'CI', 4218, 37.21140000000, -79.75500000000, '108826'),
(13455, 'US-NC-108827', 'Climax', 'CI', 4201, 35.89330000000, -79.70660000000, '108827'),
(13456, 'US-AR-108828', 'Benton', 'CI', 4165, 34.58520000000, -92.67420000000, '108828'),
(13457, 'US-SC-108829', 'Elloree', 'CI', 4211, 33.53280000000, -80.58680000000, '108829'),
(13458, 'US-SC-108830', 'Cayce', 'CI', 4211, 33.95410000000, -81.06010000000, '108830'),
(13459, 'US-SC-108831', 'Jackson', 'CI', 4211, 33.33670000000, -81.82810000000, '108831'),
(13460, 'US-CA-108832', 'Ridgecrest', 'CI', 4169, 35.55320000000, -117.67650000000, '108832'),
(13461, 'US-CA-108833', 'Morongo Valley', 'CI', 4169, 34.10580000000, -116.58860000000, '108833'),
(13462, 'US-NJ-108834', 'West Milford', 'CI', 4198, 41.08490000000, -74.38710000000, '108834'),
(13463, 'US-NJ-108835', 'Bloomfield', 'CI', 4198, 40.80860000000, -74.18690000000, '108835'),
(13464, 'US-FL-108836', 'Key Biscayne', 'CI', 4175, 25.69680000000, -80.16110000000, '108836'),
(13465, 'US-NY-108837', 'Bellport', 'CI', 4200, 40.77160000000, -72.94070000000, '108837'),
(13466, 'US-CA-108838', 'Martinez', 'CI', 4169, 37.98760000000, -122.15320000000, '108838'),
(13467, 'US-NY-108839', 'Huguenot', 'CI', 4200, 41.42480000000, -74.64990000000, '108839'),
(13468, 'US-NY-108840', 'Margaretville', 'CI', 4200, 42.13340000000, -74.63960000000, '108840'),
(13469, 'US-NY-108841', 'Rhinebeck', 'CI', 4200, 41.92870000000, -73.85780000000, '108841'),
(13470, 'US-MO-108842', 'Kingdom City', 'CI', 4193, 38.96160000000, -91.93410000000, '108842'),
(13471, 'US-IL-108843', 'Shelbyville', 'CI', 4180, 39.40840000000, -88.80440000000, '108843'),
(13472, 'US-CA-108844', 'El Granada', 'CI', 4169, 37.50520000000, -122.47100000000, '108844'),
(13473, 'US-OK-108845', 'Enid', 'CI', 4205, 36.44860000000, -97.76970000000, '108845'),
(13474, 'US-OK-108846', 'Poteau', 'CI', 4205, 35.02620000000, -94.52250000000, '108846'),
(13475, 'PR-??-108847', 'Vega Baja', 'CI', 181, 18.41830000000, -66.39320000000, '108847'),
(13476, 'US-MI-108848', 'White Pigeon', 'CI', 4190, 41.79890000000, -85.66040000000, '108848'),
(13477, 'US-MI-108849', 'Boyne Falls', 'CI', 4190, 45.21800000000, -84.85540000000, '108849'),
(13478, 'US-CA-108850', 'Copperopolis', 'CI', 4169, 37.94540000000, -120.66830000000, '108850'),
(13479, 'US-MA-108851', 'Holyoke', 'CI', 4189, 42.22380000000, -72.64090000000, '108851'),
(13480, 'US-CO-108852', 'Westcliffe', 'CI', 4170, 38.07740000000, -105.45990000000, '108852'),
(13481, 'US-AR-108853', 'Armorel', 'CI', 4165, 35.91940000000, -89.77670000000, '108853'),
(13482, 'US-AR-108854', 'Sherwood', 'CI', 4165, 34.90240000000, -92.23020000000, '108854'),
(13483, 'US-LA-108855', 'Mansfield', 'CI', 4185, 32.03960000000, -93.67120000000, '108855'),
(13484, 'US-NY-108856', 'Orchard Park', 'CI', 4200, 42.74420000000, -78.74420000000, '108856'),
(13485, 'US-PA-108857', 'Waterford', 'CI', 4208, 41.95640000000, -80.00690000000, '108857'),
(13486, 'US-TN-108858', 'Harriman', 'CI', 4213, 35.97700000000, -84.46250000000, '108858'),
(13487, 'US-WY-108859', 'Ranchester', 'CI', 4222, 44.91030000000, -107.14170000000, '108859'),
(13488, 'US-NY-108860', 'Houghton', 'CI', 4200, 42.42650000000, -78.21340000000, '108860'),
(13489, 'US-CT-108861', 'Newtown', 'CI', 4171, 41.39470000000, -73.31420000000, '108861'),
(13490, 'US-GA-108862', 'Valdosta', 'CI', 4176, 30.87170000000, -83.33340000000, '108862'),
(13491, 'US-NC-108863', 'Gastonia', 'CI', 4201, 35.22980000000, -81.24280000000, '108863'),
(13492, 'US-NC-108864', 'Hamlet', 'CI', 4201, 34.87690000000, -79.66760000000, '108864'),
(13493, 'US-NC-108865', 'Rockingham', 'CI', 4201, 34.93020000000, -79.76700000000, '108865'),
(13494, 'US-MN-108866', 'Rockford', 'CI', 4191, 45.09050000000, -93.71710000000, '108866'),
(13495, 'US-TN-108867', 'Piney Flats', 'CI', 4213, 36.44050000000, -82.34950000000, '108867'),
(13496, 'US-SC-108868', 'Pauline', 'CI', 4211, 34.77380000000, -81.84700000000, '108868'),
(13497, 'US-VA-108869', 'Bristol', 'CI', 4218, 36.59720000000, -82.18860000000, '108869'),
(13498, 'US-NC-108870', 'New London', 'CI', 4201, 35.45200000000, -80.17270000000, '108870'),
(13499, 'US-TN-108871', 'Friendsville', 'CI', 4213, 35.75900000000, -84.11760000000, '108871'),
(13500, 'US-CT-108872', 'Wolcott', 'CI', 4171, 41.59890000000, -72.97760000000, '108872'),
(13501, 'US-NC-108873', 'Cornelius', 'CI', 4201, 35.46990000000, -80.88010000000, '108873'),
(13502, 'US-SC-108874', 'Lyman', 'CI', 4211, 34.98380000000, -82.16270000000, '108874'),
(13503, 'US-TX-108875', 'Flint', 'CI', 4214, 32.22590000000, -95.38830000000, '108875'),
(13504, 'US-TX-108876', 'Denton', 'CI', 4214, 33.23240000000, -97.11080000000, '108876'),
(13505, 'US-TX-108877', 'Sanger', 'CI', 4214, 33.35380000000, -97.19650000000, '108877'),
(13506, 'US-TX-108878', 'Argyle', 'CI', 4214, 33.10880000000, -97.16650000000, '108878'),
(13507, 'US-TX-108879', 'Duncanville', 'CI', 4214, 32.63230000000, -96.91250000000, '108879'),
(13508, 'US-NE-108880', 'Hastings', 'CI', 4195, 40.59700000000, -98.33110000000, '108880'),
(13509, 'US-WI-108881', 'Allenton', 'CI', 4221, 43.46840000000, -88.37140000000, '108881'),
(13510, 'US-CA-108882', 'Solvang', 'CI', 4169, 34.61450000000, -120.14140000000, '108882'),
(13511, 'US-MN-108883', 'Kenyon', 'CI', 4191, 44.28160000000, -92.95110000000, '108883'),
(13512, 'US-WI-108884', 'Luck', 'CI', 4221, 45.57730000000, -92.43750000000, '108884'),
(13513, 'US-MN-108885', 'Hastings', 'CI', 4191, 44.68490000000, -92.88490000000, '108885'),
(13514, 'US-IL-108886', 'Loves Park', 'CI', 4180, 42.35190000000, -88.99590000000, '108886'),
(13515, 'US-NY-108887', 'Genoa', 'CI', 4200, 42.68170000000, -76.53730000000, '108887'),
(13516, 'US-IL-108888', 'Oak Park', 'CI', 4180, 41.88890000000, -87.79780000000, '108888'),
(13517, 'US-PA-108889', 'Hickory', 'CI', 4208, 40.29030000000, -80.31290000000, '108889'),
(13518, 'US-OH-108890', 'Massillon', 'CI', 4204, 40.81820000000, -81.49180000000, '108890'),
(13519, 'US-PA-108891', 'Shenandoah', 'CI', 4208, 40.82180000000, -76.20350000000, '108891'),
(13520, 'US-NJ-108892', 'Millington', 'CI', 4198, 40.67870000000, -74.51760000000, '108892'),
(13521, 'US-IL-108893', 'Spring Grove', 'CI', 4180, 42.45100000000, -88.22130000000, '108893'),
(13522, 'US-IA-108894', 'Moscow', 'CI', 4182, 41.57680000000, -91.07200000000, '108894'),
(13523, 'US-IN-108895', 'Aurora', 'CI', 4181, 39.08320000000, -84.97690000000, '108895'),
(13524, 'US-FL-108896', 'Astatula', 'CI', 4175, 28.70170000000, -81.72040000000, '108896'),
(13525, 'US-WI-108897', 'Medford', 'CI', 4221, 45.17260000000, -90.36960000000, '108897'),
(13526, 'US-WI-108898', 'New Lisbon', 'CI', 4221, 43.90090000000, -90.13640000000, '108898'),
(13527, 'US-IL-108899', 'Assumption', 'CI', 4180, 39.53670000000, -89.02050000000, '108899'),
(13528, 'US-IN-108900', 'Westpoint', 'CI', 4181, 40.32060000000, -87.05190000000, '108900'),
(13529, 'US-IN-108901', 'Marion', 'CI', 4181, 40.50990000000, -85.62640000000, '108901'),
(13530, 'US-IN-108902', 'Royal Center', 'CI', 4181, 40.85630000000, -86.51550000000, '108902'),
(13531, 'US-IN-108903', 'Petersburg', 'CI', 4181, 38.46320000000, -87.30490000000, '108903'),
(13532, 'US-IN-108904', 'Lebanon', 'CI', 4181, 40.05000000000, -86.47390000000, '108904'),
(13533, 'US-IN-108905', 'Osgood', 'CI', 4181, 39.16950000000, -85.31050000000, '108905'),
(13534, 'US-IN-108906', 'Brownsburg', 'CI', 4181, 39.87250000000, -86.38260000000, '108906'),
(13535, 'US-IN-108907', 'Middletown', 'CI', 4181, 40.02630000000, -85.50460000000, '108907'),
(13536, 'US-IN-108908', 'Hope', 'CI', 4181, 39.28960000000, -85.77040000000, '108908'),
(13537, 'US-IN-108909', 'Crawfordsville', 'CI', 4181, 40.04070000000, -86.90030000000, '108909'),
(13538, 'US-IN-108910', 'Greenfield', 'CI', 4181, 39.81500000000, -85.78350000000, '108910'),
(13539, 'US-IN-108911', 'Attica', 'CI', 4181, 40.27750000000, -87.20400000000, '108911'),
(13540, 'US-IN-108912', 'Yorktown', 'CI', 4181, 40.21760000000, -85.51900000000, '108912'),
(13541, 'US-IN-108913', 'Edinburgh', 'CI', 4181, 39.38470000000, -85.90230000000, '108913'),
(13542, 'US-MN-108914', 'Henning', 'CI', 4191, 46.32370000000, -95.45490000000, '108914'),
(13543, 'US-VA-108915', 'Manquin', 'CI', 4218, 37.72320000000, -77.22250000000, '108915'),
(13544, 'US-OH-108916', 'Lowellville', 'CI', 4204, 41.05630000000, -80.54820000000, '108916'),
(13545, 'US-MI-108917', 'Ludington', 'CI', 4190, 43.96240000000, -86.39790000000, '108917'),
(13546, 'US-MI-108918', 'Lewiston', 'CI', 4190, 44.80150000000, -84.24270000000, '108918'),
(13547, 'US-MI-108919', 'Howard City', 'CI', 4190, 43.40290000000, -85.50260000000, '108919'),
(13548, 'US-MI-108920', 'Farwell', 'CI', 4190, 43.82130000000, -84.88400000000, '108920'),
(13549, 'US-MI-108921', 'Portage', 'CI', 4190, 42.19750000000, -85.55560000000, '108921'),
(13550, 'US-MI-108922', 'Evart', 'CI', 4190, 43.97760000000, -85.25780000000, '108922'),
(13551, 'US-NC-108923', 'Woodleaf', 'CI', 4201, 35.79090000000, -80.60230000000, '108923'),
(13552, 'US-MI-108924', 'Erie', 'CI', 4190, 41.78470000000, -83.48880000000, '108924'),
(13553, 'US-MI-108925', 'Temperance', 'CI', 4190, 41.79400000000, -83.58790000000, '108925'),
(13554, 'US-MI-108926', 'Westland', 'CI', 4190, 42.33180000000, -83.37100000000, '108926'),
(13555, 'US-MI-108927', 'Dundee', 'CI', 4190, 41.96030000000, -83.67350000000, '108927'),
(13556, 'US-OH-108928', 'Portsmouth', 'CI', 4204, 38.79150000000, -82.92170000000, '108928'),
(13557, 'US-KY-108929', 'Catlettsburg', 'CI', 4184, 38.30920000000, -82.64600000000, '108929'),
(13558, 'US-OH-108930', 'Nelsonville', 'CI', 4204, 39.46160000000, -82.24600000000, '108930'),
(13559, 'US-WV-108931', 'Mineral Wells', 'CI', 4220, 39.14910000000, -81.52570000000, '108931'),
(13560, 'US-MD-108932', 'Adamstown', 'CI', 4188, 39.29840000000, -77.45430000000, '108932'),
(13561, 'US-NJ-108933', 'Landing', 'CI', 4198, 40.90640000000, -74.66580000000, '108933'),
(13562, 'US-OH-108934', 'Mantua', 'CI', 4204, 41.33080000000, -81.22940000000, '108934'),
(13563, 'US-OH-108935', 'Struthers', 'CI', 4204, 41.04870000000, -80.59040000000, '108935'),
(13564, 'US-IA-108936', 'Osage', 'CI', 4182, 43.29930000000, -92.79930000000, '108936'),
(13565, 'US-PA-108937', 'Dalton', 'CI', 4208, 41.53250000000, -75.74580000000, '108937'),
(13566, 'US-IA-108938', 'Guthrie Center', 'CI', 4182, 41.69080000000, -94.55780000000, '108938'),
(13567, 'US-PA-108939', 'Oaks', 'CI', 4208, 40.13530000000, -75.45360000000, '108939'),
(13568, 'US-OK-108940', 'Durant', 'CI', 4205, 33.99500000000, -96.39170000000, '108940'),
(13569, 'US-OK-108941', 'Chickasha', 'CI', 4205, 35.05830000000, -97.93470000000, '108941'),
(13570, 'US-OK-108942', 'Woodward', 'CI', 4205, 36.45450000000, -99.41700000000, '108942'),
(13571, 'US-MO-108943', 'Pacific', 'CI', 4193, 38.52240000000, -90.74340000000, '108943'),
(13572, 'US-IL-108944', 'Jerseyville', 'CI', 4180, 39.09710000000, -90.31480000000, '108944'),
(13573, 'US-PA-108945', 'Effort', 'CI', 4208, 40.96190000000, -75.46880000000, '108945'),
(13574, 'US-IL-108946', 'Winchester', 'CI', 4180, 39.62870000000, -90.46100000000, '108946'),
(13575, 'US-CT-108947', 'Cornwall Bridge', 'CI', 4171, 41.79190000000, -73.35790000000, '108947'),
(13576, 'US-IL-108948', 'Clay City', 'CI', 4180, 38.68460000000, -88.34120000000, '108948'),
(13577, 'US-TX-108949', 'Marlin', 'CI', 4214, 31.30240000000, -96.84340000000, '108949'),
(13578, 'US-GA-108950', 'Social Circle', 'CI', 4176, 33.64760000000, -83.69690000000, '108950'),
(13579, 'US-SC-108951', 'Easley', 'CI', 4211, 34.88610000000, -82.58570000000, '108951'),
(13580, 'US-NC-108952', 'Pinebluff', 'CI', 4201, 35.09470000000, -79.48570000000, '108952'),
(13581, 'US-NC-108953', 'Denver', 'CI', 4201, 35.50640000000, -81.03710000000, '108953'),
(13582, 'US-NC-108954', 'Maiden', 'CI', 4201, 35.57790000000, -81.16770000000, '108954'),
(13583, 'US-MS-108955', 'Prentiss', 'CI', 4192, 31.61450000000, -89.82710000000, '108955'),
(13584, 'US-SC-108956', 'Walterboro', 'CI', 4211, 32.91830000000, -80.68790000000, '108956'),
(13585, 'US-SC-108957', 'Blackville', 'CI', 4211, 33.36680000000, -81.25810000000, '108957'),
(13586, 'US-VA-108958', 'Arvonia', 'CI', 4218, 37.67140000000, -78.39970000000, '108958'),
(13587, 'US-SC-108959', 'Ridgeland', 'CI', 4211, 32.48350000000, -81.00690000000, '108959'),
(13588, 'US-SC-108960', 'Ware Shoals', 'CI', 4211, 34.42950000000, -82.21640000000, '108960'),
(13589, 'US-SC-108961', 'Camden', 'CI', 4211, 34.31770000000, -80.57710000000, '108961'),
(13590, 'US-GA-108962', 'Waynesboro', 'CI', 4176, 33.08920000000, -81.98610000000, '108962'),
(13591, 'US-SC-108963', 'Mc Bee', 'CI', 4211, 34.45750000000, -80.25540000000, '108963'),
(13592, 'US-SC-108964', 'Loris', 'CI', 4211, 34.02100000000, -78.90980000000, '108964'),
(13593, 'US-SC-108965', 'Chester', 'CI', 4211, 34.69310000000, -81.25820000000, '108965'),
(13594, 'US-SC-108966', 'Ladson', 'CI', 4211, 32.98310000000, -80.12230000000, '108966'),
(13595, 'US-NC-108967', 'Hildebran', 'CI', 4201, 35.71990000000, -81.42080000000, '108967'),
(13596, 'US-TN-108968', 'Mountain City', 'CI', 4213, 36.47130000000, -81.81440000000, '108968'),
(13597, 'US-FL-108969', 'Dania', 'CI', 4175, 26.05770000000, -80.14190000000, '108969'),
(13598, 'US-NJ-108970', 'Avalon', 'CI', 4198, 39.08930000000, -74.72940000000, '108970'),
(13599, 'US-WI-108971', 'Delafield', 'CI', 4221, 43.04600000000, -88.38890000000, '108971'),
(13600, 'US-WI-108972', 'Kiel', 'CI', 4221, 43.96090000000, -87.97510000000, '108972'),
(13601, 'US-WI-108973', 'Waterloo', 'CI', 4221, 43.16290000000, -88.96490000000, '108973'),
(13602, 'US-OH-108974', 'Brecksville', 'CI', 4204, 41.30200000000, -81.61450000000, '108974'),
(13603, 'US-IL-108975', 'Carbondale', 'CI', 4180, 37.73270000000, -89.20340000000, '108975'),
(13604, 'US-CA-108976', 'Firebaugh', 'CI', 4169, 36.85240000000, -120.54670000000, '108976'),
(13605, 'US-WI-108977', 'Jackson', 'CI', 4221, 43.31400000000, -88.15400000000, '108977'),
(13606, 'US-NJ-108978', 'Sussex', 'CI', 4198, 41.24870000000, -74.60970000000, '108978'),
(13607, 'US-OH-108979', 'Broadview Heights', 'CI', 4204, 41.31410000000, -81.67310000000, '108979'),
(13608, 'US-CA-108980', 'Templeton', 'CI', 4169, 35.54220000000, -120.75050000000, '108980'),
(13609, 'US-FL-108981', 'Neptune Beach', 'CI', 4175, 30.31590000000, -81.41450000000, '108981'),
(13610, 'US-CA-108982', 'Colton', 'CI', 4169, 34.01440000000, -117.27720000000, '108982'),
(13611, 'US-CA-108983', 'Victorville', 'CI', 4169, 34.49540000000, -117.36860000000, '108983'),
(13612, 'US-CA-108984', 'Beaumont', 'CI', 4169, 33.94940000000, -116.97750000000, '108984'),
(13613, 'US-CA-108985', 'Cathedral City', 'CI', 4169, 33.82050000000, -116.45860000000, '108985'),
(13614, 'US-IA-108986', 'Strawberry Point', 'CI', 4182, 42.69860000000, -91.49740000000, '108986'),
(13615, 'US-IA-108987', 'Oskaloosa', 'CI', 4182, 41.28120000000, -92.65020000000, '108987'),
(13616, 'US-MS-108988', 'Richland', 'CI', 4192, 32.23660000000, -90.16880000000, '108988'),
(13617, 'US-IL-108989', 'Mount Sterling', 'CI', 4180, 39.98390000000, -90.71430000000, '108989'),
(13618, 'US-NE-108990', 'Hershey', 'CI', 4195, 41.16750000000, -101.01040000000, '108990'),
(13619, 'US-NE-108991', 'Auburn', 'CI', 4195, 40.37800000000, -95.88130000000, '108991'),
(13620, 'US-NE-108992', 'Gretna', 'CI', 4195, 41.10280000000, -96.24290000000, '108992'),
(13621, 'US-LA-108993', 'Breaux Bridge', 'CI', 4185, 30.28530000000, -91.79870000000, '108993'),
(13622, 'US-IA-108994', 'Rock Valley', 'CI', 4182, 43.19440000000, -96.35290000000, '108994'),
(13623, 'US-NE-108995', 'York', 'CI', 4195, 40.87240000000, -97.59720000000, '108995'),
(13624, 'US-OH-108996', 'Newport', 'CI', 4204, 39.40920000000, -81.26680000000, '108996'),
(13625, 'US-MN-108997', 'Harmony', 'CI', 4191, 43.56550000000, -92.05970000000, '108997'),
(13626, 'US-LA-108998', 'Ponchatoula', 'CI', 4185, 30.40090000000, -90.39360000000, '108998'),
(13627, 'US-LA-108999', 'Crowley', 'CI', 4185, 30.22110000000, -92.38010000000, '108999'),
(13628, 'US-VA-109000', 'Natural Bridge Station', 'CI', 4218, 37.57950000000, -79.50590000000, '109000'),
(13629, 'US-MD-109001', 'Joppa', 'CI', 4188, 39.45260000000, -76.35280000000, '109001'),
(13630, 'US-MD-109002', 'Hampstead', 'CI', 4188, 39.61620000000, -76.82580000000, '109002'),
(13631, 'US-CA-109003', 'Dutch Flat', 'CI', 4169, 39.19770000000, -120.83670000000, '109003'),
(13632, 'US-CA-109004', 'Tahoe City', 'CI', 4169, 39.18390000000, -120.14680000000, '109004'),
(13633, 'US-NV-109005', 'Yerington', 'CI', 4196, 38.87270000000, -119.14890000000, '109005'),
(13634, 'US-CA-109006', 'Rocklin', 'CI', 4169, 38.81850000000, -121.28190000000, '109006'),
(13635, 'US-OH-109007', 'Strongsville', 'CI', 4204, 41.31320000000, -81.81110000000, '109007'),
(13636, 'US-OR-109008', 'Mcminnville', 'CI', 4206, 45.19490000000, -123.24660000000, '109008'),
(13637, 'US-OR-109009', 'Silverton', 'CI', 4206, 44.95440000000, -122.71380000000, '109009'),
(13638, 'US-MA-109010', 'East Weymouth', 'CI', 4189, 42.20930000000, -70.93260000000, '109010'),
(13639, 'US-CA-109011', 'Mendota', 'CI', 4169, 36.67120000000, -120.43870000000, '109011'),
(13640, 'US-NV-109012', 'Virginia City', 'CI', 4196, 39.30700000000, -119.63530000000, '109012'),
(13641, 'US-CA-109013', 'Manteca', 'CI', 4169, 37.83110000000, -121.18720000000, '109013'),
(13642, 'US-NJ-109014', 'Linden', 'CI', 4198, 40.62470000000, -74.24940000000, '109014'),
(13643, 'US-WI-109015', 'Galesville', 'CI', 4221, 44.09450000000, -91.34270000000, '109015'),
(13644, 'US-CA-109016', 'Atherton', 'CI', 4169, 37.44980000000, -122.20040000000, '109016'),
(13645, 'US-CA-109017', 'Mcclellan', 'CI', 4169, 38.66790000000, -121.40320000000, '109017'),
(13646, 'US-ID-109018', 'Mountain Home A F B', 'CI', 4179, 43.05260000000, -115.86600000000, '109018'),
(13647, 'US-CA-109019', 'Cottonwood', 'CI', 4169, 40.33440000000, -122.45020000000, '109019'),
(13648, 'US-CA-109020', 'Portola', 'CI', 4169, 39.79630000000, -120.46730000000, '109020'),
(13649, 'US-CA-109021', 'Santa Clarita', 'CI', 4169, 34.43020000000, -118.51930000000, '109021'),
(13650, 'US-CA-109022', 'Mc Kittrick', 'CI', 4169, 35.41710000000, -119.76080000000, '109022'),
(13651, 'US-CA-109023', 'Maricopa', 'CI', 4169, 34.84230000000, -119.27220000000, '109023'),
(13652, 'US-CA-109024', 'Paso Robles', 'CI', 4169, 35.61890000000, -120.76690000000, '109024'),
(13653, 'US-OH-109025', 'Lagrange', 'CI', 4204, 41.25460000000, -82.12470000000, '109025'),
(13654, 'US-CA-109026', 'Manhattan Beach', 'CI', 4169, 33.88930000000, -118.40100000000, '109026'),
(13655, 'US-MO-109027', 'Nixa', 'CI', 4193, 37.02710000000, -93.31930000000, '109027'),
(13656, 'US-VT-109028', 'Killington', 'CI', 4216, 43.65430000000, -72.78560000000, '109028'),
(13657, 'US-NJ-109029', 'Ventnor City', 'CI', 4198, 39.34180000000, -74.48170000000, '109029'),
(13658, 'US-FL-109030', 'Sebastian', 'CI', 4175, 27.80070000000, -80.49190000000, '109030'),
(13659, 'US-MI-109031', 'Frankenmuth', 'CI', 4190, 43.35460000000, -83.74140000000, '109031'),
(13660, 'US-AZ-109032', 'Prescott', 'CI', 4164, 34.62480000000, -112.42200000000, '109032'),
(13661, 'US-AZ-109033', 'Peach Springs', 'CI', 4164, 35.64400000000, -113.61890000000, '109033'),
(13662, 'US-IL-109034', 'Bristol', 'CI', 4180, 41.69890000000, -88.42920000000, '109034'),
(13663, 'US-AL-109035', 'Harvest', 'CI', 4161, 34.81680000000, -86.68250000000, '109035'),
(13664, 'US-MN-109036', 'Rogers', 'CI', 4191, 45.17080000000, -93.57580000000, '109036'),
(13665, 'US-WV-109037', 'Snowshoe', 'CI', 4220, 38.38790000000, -80.06460000000, '109037'),
(13666, 'US-GA-109038', 'Hiram', 'CI', 4176, 33.86020000000, -84.76540000000, '109038'),
(13667, 'US-VA-109039', 'Toano', 'CI', 4218, 37.41790000000, -76.83290000000, '109039'),
(13668, 'US-NJ-109040', 'Sewell', 'CI', 4198, 39.76150000000, -75.12450000000, '109040'),
(13669, 'US-WV-109041', 'Reedsville', 'CI', 4220, 39.51330000000, -79.81390000000, '109041'),
(13670, 'US-MO-109042', 'Dittmer', 'CI', 4193, 38.26760000000, -90.70650000000, '109042'),
(13671, 'US-KY-109043', 'Whitesburg', 'CI', 4184, 37.13380000000, -82.87470000000, '109043'),
(13672, 'US-MA-109044', 'Edgartown', 'CI', 4189, 41.38430000000, -70.55350000000, '109044'),
(13673, 'US-TN-109045', 'Etowah', 'CI', 4213, 35.33210000000, -84.53010000000, '109045'),
(13674, 'US-MN-109046', 'Cambridge', 'CI', 4191, 45.56500000000, -93.27290000000, '109046'),
(13675, 'US-MD-109047', 'Oxon Hill', 'CI', 4188, 38.80460000000, -76.99470000000, '109047'),
(13676, 'US-OH-109048', 'East Liverpool', 'CI', 4204, 40.68050000000, -80.59480000000, '109048'),
(13677, 'US-OH-109049', 'Sharon Center', 'CI', 4204, 41.09640000000, -81.73870000000, '109049'),
(13678, 'US-WV-109050', 'Bruceton Mills', 'CI', 4220, 39.64160000000, -79.63510000000, '109050'),
(13679, 'US-OH-109051', 'Cadiz', 'CI', 4204, 40.26120000000, -81.01990000000, '109051'),
(13680, 'US-IL-109052', 'Farina', 'CI', 4180, 38.88070000000, -88.75490000000, '109052'),
(13681, 'US-TX-109053', 'La Porte', 'CI', 4214, 29.68830000000, -95.06080000000, '109053'),
(13682, 'US-NY-109054', 'Inwood', 'CI', 4200, 40.62010000000, -73.75190000000, '109054'),
(13683, 'US-CO-109055', 'Wolcott', 'CI', 4170, 39.68310000000, -106.67390000000, '109055'),
(13684, 'US-MN-109056', 'Audubon', 'CI', 4191, 46.85470000000, -96.00260000000, '109056'),
(13685, 'CA-MB-109057', 'Winnipeg', 'CI', 38, 49.88330000000, -97.16670000000, '109057'),
(13686, 'US-MN-109058', 'Faribault', 'CI', 4191, 44.32780000000, -93.27760000000, '109058'),
(13687, 'US-CA-109059', 'Paradise', 'CI', 4169, 39.74130000000, -121.61210000000, '109059'),
(13688, 'US-CA-109060', 'Weed', 'CI', 4169, 41.51090000000, -122.36480000000, '109060'),
(13689, 'US-IL-109061', 'Antioch', 'CI', 4180, 42.46690000000, -88.05500000000, '109061'),
(13690, 'US-MN-109062', 'Victoria', 'CI', 4191, 44.86390000000, -93.68550000000, '109062'),
(13691, 'US-PA-109063', 'Muncy', 'CI', 4208, 41.22400000000, -76.61800000000, '109063'),
(13692, 'US-CA-109064', 'Maxwell', 'CI', 4169, 39.31690000000, -122.17760000000, '109064'),
(13693, 'US-PA-109065', 'Dushore', 'CI', 4208, 41.46710000000, -76.21940000000, '109065'),
(13694, 'US-AL-109066', 'Newton', 'CI', 4161, 31.26750000000, -85.62520000000, '109066'),
(13695, 'US-KY-109067', 'Fort Campbell', 'CI', 4184, 36.64080000000, -87.47180000000, '109067'),
(13696, 'US-TN-109068', 'Old Hickory', 'CI', 4213, 36.24940000000, -86.56790000000, '109068'),
(13697, 'US-TX-109069', 'Pilot Point', 'CI', 4214, 33.36350000000, -96.91700000000, '109069'),
(13698, 'US-KY-109070', 'Adairville', 'CI', 4184, 36.69510000000, -86.85940000000, '109070'),
(13699, 'US-TN-109071', 'Ashland City', 'CI', 4213, 36.28330000000, -87.01210000000, '109071'),
(13700, 'US-TN-109072', 'Springfield', 'CI', 4213, 36.50860000000, -86.85630000000, '109072'),
(13701, 'US-KY-109073', 'Tompkinsville', 'CI', 4184, 36.72640000000, -85.69230000000, '109073'),
(13702, 'US-VT-109074', 'Sheldon', 'CI', 4216, 44.89260000000, -72.95380000000, '109074'),
(13703, 'US-PA-109075', 'Danville', 'CI', 4208, 41.04150000000, -76.65070000000, '109075'),
(13704, 'US-GA-109076', 'Bremen', 'CI', 4176, 33.75220000000, -85.14440000000, '109076'),
(13705, 'US-IA-109077', 'North Liberty', 'CI', 4182, 41.76430000000, -91.63260000000, '109077'),
(13706, 'US-IL-109078', 'Brimfield', 'CI', 4180, 40.81670000000, -89.86030000000, '109078'),
(13707, 'US-CT-109079', 'Lakeville', 'CI', 4171, 41.96740000000, -73.43210000000, '109079'),
(13708, 'US-CT-109080', 'Tariffville', 'CI', 4171, 41.90750000000, -72.76780000000, '109080'),
(13709, 'US-NM-109081', 'Jemez Springs', 'CI', 4199, 35.83520000000, -106.66960000000, '109081'),
(13710, 'US-NM-109082', 'Artesia', 'CI', 4199, 32.74840000000, -104.43590000000, '109082'),
(13711, 'US-CO-109083', 'Cpu Louis Guzzo Ent', 'CI', 4170, 37.94350000000, -104.84660000000, '109083'),
(13712, 'US-CO-109084', 'U S A F Academy', 'CI', 4170, 38.99170000000, -104.86720000000, '109084'),
(13713, 'US-CO-109085', 'Alamosa', 'CI', 4170, 37.46250000000, -105.78040000000, '109085'),
(13714, 'US-PA-109086', 'Ottsville', 'CI', 4208, 40.46980000000, -75.16360000000, '109086'),
(13715, 'US-NY-109087', 'King Ferry', 'CI', 4200, 42.67460000000, -76.62910000000, '109087'),
(13716, 'US-WA-109088', 'Greenacres', 'CI', 4219, 47.63170000000, -117.14100000000, '109088'),
(13717, 'US-WA-109089', 'Cle Elum', 'CI', 4219, 47.20730000000, -120.90220000000, '109089'),
(13718, 'US-MA-109090', 'Holden', 'CI', 4189, 42.33860000000, -71.85310000000, '109090'),
(13719, 'US-GA-109091', 'Carrollton', 'CI', 4176, 33.57560000000, -85.13400000000, '109091'),
(13720, 'US-IL-109092', 'New Berlin', 'CI', 4180, 39.74090000000, -89.87880000000, '109092'),
(13721, 'US-FL-109093', 'Winter Garden', 'CI', 4175, 28.47680000000, -81.63190000000, '109093'),
(13722, 'US-FL-109094', 'Williston', 'CI', 4175, 29.39920000000, -82.44550000000, '109094'),
(13723, 'US-TX-109095', 'Big Spring', 'CI', 4214, 32.18640000000, -101.45100000000, '109095'),
(13724, 'US-TX-109096', 'Lolita', 'CI', 4214, 28.83730000000, -96.51950000000, '109096'),
(13725, 'US-NC-109097', 'Belhaven', 'CI', 4201, 35.61690000000, -76.48500000000, '109097'),
(13726, 'US-MA-109098', 'Marblehead', 'CI', 4189, 42.50020000000, -70.86520000000, '109098'),
(13727, 'US-TX-109099', 'Dike', 'CI', 4214, 33.26490000000, -95.45140000000, '109099'),
(13728, 'US-OR-109100', 'Forest Grove', 'CI', 4206, 45.55590000000, -123.15110000000, '109100'),
(13729, 'US-NY-109101', 'Painted Post', 'CI', 4200, 42.17530000000, -77.12690000000, '109101'),
(13730, 'US-CT-109102', 'Pine Meadow', 'CI', 4171, 41.91720000000, -73.06370000000, '109102'),
(13731, 'US-MA-109103', 'West Warren', 'CI', 4189, 42.20000000000, -72.22860000000, '109103'),
(13732, 'US-MA-109104', 'Dalton', 'CI', 4189, 42.47680000000, -73.09590000000, '109104'),
(13733, 'US-MA-109105', 'Stockbridge', 'CI', 4189, 42.28220000000, -73.32620000000, '109105');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(13734, 'US-MA-109106', 'Rutland', 'CI', 4189, 42.38300000000, -71.96140000000, '109106'),
(13735, 'US-FL-109107', 'Oviedo', 'CI', 4175, 28.67660000000, -81.19910000000, '109107'),
(13736, 'US-FL-109108', 'Cocoa Beach', 'CI', 4175, 28.32570000000, -80.61220000000, '109108'),
(13737, 'US-FL-109109', 'Floral City', 'CI', 4175, 28.73090000000, -82.29240000000, '109109'),
(13738, 'US-FL-109110', 'Key Largo', 'CI', 4175, 25.18420000000, -80.37910000000, '109110'),
(13739, 'US-IN-109111', 'Washington', 'CI', 4181, 38.66580000000, -87.17590000000, '109111'),
(13740, 'US-IN-109112', 'Greensburg', 'CI', 4181, 39.32510000000, -85.47920000000, '109112'),
(13741, 'US-WI-109113', 'Rhinelander', 'CI', 4221, 45.67990000000, -89.34600000000, '109113'),
(13742, 'US-IL-109114', 'Arcola', 'CI', 4180, 39.67530000000, -88.29600000000, '109114'),
(13743, 'US-CA-109115', 'Lodi', 'CI', 4169, 38.11650000000, -121.16760000000, '109115'),
(13744, 'US-CA-109116', 'Woodlake', 'CI', 4169, 36.46590000000, -119.10220000000, '109116'),
(13745, 'US-OH-109117', 'Carrollton', 'CI', 4204, 40.57580000000, -81.06460000000, '109117'),
(13746, 'US-IN-109118', 'Noblesville', 'CI', 4181, 40.06980000000, -85.98170000000, '109118'),
(13747, 'US-IL-109119', 'Rantoul', 'CI', 4180, 40.31180000000, -88.14670000000, '109119'),
(13748, 'US-IN-109120', 'West Lebanon', 'CI', 4181, 40.28350000000, -87.43390000000, '109120'),
(13749, 'US-KY-109121', 'Winchester', 'CI', 4184, 37.96850000000, -84.14600000000, '109121'),
(13750, 'US-CA-109122', 'Tranquillity', 'CI', 4169, 36.65380000000, -120.28790000000, '109122'),
(13751, 'US-CA-109123', 'Galt', 'CI', 4169, 38.27220000000, -121.22890000000, '109123'),
(13752, 'US-CA-109124', 'Meridian', 'CI', 4169, 39.07650000000, -121.84340000000, '109124'),
(13753, 'US-CA-109125', 'Dunnigan', 'CI', 4169, 38.88310000000, -122.00220000000, '109125'),
(13754, 'US-IA-109126', 'Atlantic', 'CI', 4182, 41.41100000000, -95.01220000000, '109126'),
(13755, 'US-IL-109127', 'Roodhouse', 'CI', 4180, 39.50080000000, -90.33220000000, '109127'),
(13756, 'US-IN-109128', 'Rochester', 'CI', 4181, 41.04090000000, -86.27170000000, '109128'),
(13757, 'US-MI-109129', 'Hamtramck', 'CI', 4190, 42.40560000000, -83.05310000000, '109129'),
(13758, 'US-NY-109130', 'New Hartford', 'CI', 4200, 43.05820000000, -75.27050000000, '109130'),
(13759, 'US-CA-109131', 'Creston', 'CI', 4169, 35.47800000000, -120.48910000000, '109131'),
(13760, 'US-CA-109132', 'San Gabriel', 'CI', 4169, 34.08910000000, -118.09240000000, '109132'),
(13761, 'US-NC-109133', 'Battleboro', 'CI', 4201, 36.01360000000, -77.75750000000, '109133'),
(13762, 'US-CA-109134', 'Alhambra', 'CI', 4169, 34.09050000000, -118.13440000000, '109134'),
(13763, 'US-MS-109135', 'Columbia', 'CI', 4192, 31.21700000000, -89.81100000000, '109135'),
(13764, 'US-PA-109136', 'Centerport', 'CI', 4208, 40.48420000000, -76.00850000000, '109136'),
(13765, 'US-NY-109137', 'Island Park', 'CI', 4200, 40.60700000000, -73.65100000000, '109137'),
(13766, 'US-CA-109138', 'Rutherford', 'CI', 4169, 38.45790000000, -122.41340000000, '109138'),
(13767, 'US-TN-109139', 'Pleasant View', 'CI', 4213, 36.40250000000, -87.03400000000, '109139'),
(13768, 'US-IN-109140', 'Spencer', 'CI', 4181, 39.28830000000, -86.80490000000, '109140'),
(13769, 'US-AR-109141', 'Gassville', 'CI', 4165, 36.31780000000, -92.48250000000, '109141'),
(13770, 'US-OK-109142', 'Ardmore', 'CI', 4205, 34.18940000000, -97.16030000000, '109142'),
(13771, 'US-OK-109143', 'Velma', 'CI', 4205, 34.46130000000, -97.67130000000, '109143'),
(13772, 'US-OK-109144', 'El Reno', 'CI', 4205, 35.49310000000, -97.98120000000, '109144'),
(13773, 'US-OK-109145', 'Guthrie', 'CI', 4205, 35.85900000000, -97.43400000000, '109145'),
(13774, 'US-OK-109146', 'Watonga', 'CI', 4205, 35.89120000000, -98.41020000000, '109146'),
(13775, 'US-OK-109147', 'Walters', 'CI', 4205, 34.36840000000, -98.40040000000, '109147'),
(13776, 'US-TX-109148', 'Fort Stockton', 'CI', 4214, 30.67910000000, -102.78750000000, '109148'),
(13777, 'US-OR-109149', 'Newberg', 'CI', 4206, 45.32340000000, -122.98200000000, '109149'),
(13778, 'US-OR-109150', 'Boring', 'CI', 4206, 45.42430000000, -122.37270000000, '109150'),
(13779, 'US-OR-109151', 'Aurora', 'CI', 4206, 45.23910000000, -122.80850000000, '109151'),
(13780, 'US-NV-109152', 'Gardnerville', 'CI', 4196, 38.75990000000, -119.61350000000, '109152'),
(13781, 'US-VA-109153', 'White Stone', 'CI', 4218, 37.65180000000, -76.35940000000, '109153'),
(13782, 'US-CA-109154', 'Alturas', 'CI', 4169, 41.43840000000, -120.53400000000, '109154'),
(13783, 'US-NV-109155', 'Silverpeak', 'CI', 4196, 37.76830000000, -117.65340000000, '109155'),
(13784, 'US-CA-109156', 'Lathrop', 'CI', 4169, 37.82270000000, -121.29000000000, '109156'),
(13785, 'US-MA-109157', 'Lincoln', 'CI', 4189, 42.42820000000, -71.31630000000, '109157'),
(13786, 'US-NY-109158', 'Skaneateles', 'CI', 4200, 42.90510000000, -76.35630000000, '109158'),
(13787, 'US-IN-109159', 'Sunman', 'CI', 4181, 39.23710000000, -85.09810000000, '109159'),
(13788, 'US-AK-109160', 'Delta Junction', 'CI', 4162, 63.70470000000, -144.89660000000, '109160'),
(13789, 'US-ND-109161', 'Wahpeton', 'CI', 4202, 46.29000000000, -96.72580000000, '109161'),
(13790, 'US-OH-109162', 'Dalton', 'CI', 4204, 40.77110000000, -81.67690000000, '109162'),
(13791, 'US-PA-109163', 'Mc Donald', 'CI', 4208, 40.35480000000, -80.23640000000, '109163'),
(13792, 'US-MO-109164', 'Festus', 'CI', 4193, 38.11770000000, -90.39760000000, '109164'),
(13793, 'US-MA-109165', 'Saugus', 'CI', 4189, 42.46750000000, -71.01310000000, '109165'),
(13794, 'US-MS-109166', 'Sunflower', 'CI', 4192, 33.54790000000, -90.54330000000, '109166'),
(13795, 'US-CA-109167', 'Willow Creek', 'CI', 4169, 40.94680000000, -123.65420000000, '109167'),
(13796, 'US-MA-109168', 'Brookline', 'CI', 4189, 42.34310000000, -71.12300000000, '109168'),
(13797, 'US-MA-109169', 'Raynham', 'CI', 4189, 41.93910000000, -71.05860000000, '109169'),
(13798, 'US-MA-109170', 'West Wareham', 'CI', 4189, 41.77970000000, -70.76780000000, '109170'),
(13799, 'US-ME-109171', 'Nobleboro', 'CI', 4186, 44.11090000000, -69.48200000000, '109171'),
(13800, 'US-ME-109172', 'Newport', 'CI', 4186, 44.85950000000, -69.23460000000, '109172'),
(13801, 'US-ME-109173', 'Fairfield', 'CI', 4186, 44.63700000000, -69.68040000000, '109173'),
(13802, 'US-ME-109174', 'Skowhegan', 'CI', 4186, 44.80710000000, -69.67400000000, '109174'),
(13803, 'US-OH-109175', 'Marietta', 'CI', 4204, 39.44110000000, -81.34660000000, '109175'),
(13804, 'US-MA-109176', 'Attleboro Falls', 'CI', 4189, 41.96580000000, -71.30940000000, '109176'),
(13805, 'US-NY-109177', 'Irving', 'CI', 4200, 42.56690000000, -79.05760000000, '109177'),
(13806, 'US-NY-109178', 'Little Valley', 'CI', 4200, 42.24570000000, -78.80200000000, '109178'),
(13807, 'US-VA-109179', 'Dyke', 'CI', 4218, 38.25220000000, -78.56290000000, '109179'),
(13808, 'US-WI-109180', 'Franksville', 'CI', 4221, 42.79080000000, -87.98790000000, '109180'),
(13809, 'US-TX-109181', 'Sheppard Afb', 'CI', 4214, 33.98490000000, -98.50400000000, '109181'),
(13810, 'US-KY-109182', 'Brooks', 'CI', 4184, 38.05700000000, -85.77580000000, '109182'),
(13811, 'US-IN-109183', 'Elwood', 'CI', 4181, 40.28510000000, -85.82850000000, '109183'),
(13812, 'US-VA-109184', 'Louisa', 'CI', 4218, 37.98710000000, -78.05840000000, '109184'),
(13813, 'US-KY-109185', 'Williamstown', 'CI', 4184, 38.64000000000, -84.59350000000, '109185'),
(13814, 'US-CT-109186', 'Terryville', 'CI', 4171, 41.66420000000, -73.01950000000, '109186'),
(13815, 'US-IN-109187', 'Zionsville', 'CI', 4181, 39.98310000000, -86.28760000000, '109187'),
(13816, 'US-IN-109188', 'Martinsville', 'CI', 4181, 39.45200000000, -86.46730000000, '109188'),
(13817, 'US-TX-109189', 'Alpine', 'CI', 4214, 29.95100000000, -103.46820000000, '109189'),
(13818, 'US-IN-109190', 'Frankfort', 'CI', 4181, 40.31870000000, -86.46880000000, '109190'),
(13819, 'US-TX-109191', 'Buffalo Gap', 'CI', 4214, 32.27020000000, -99.82900000000, '109191'),
(13820, 'US-VA-109192', 'Buffalo Junction', 'CI', 4218, 36.60000000000, -78.61160000000, '109192'),
(13821, 'US-CA-109193', 'Banning', 'CI', 4169, 33.92270000000, -116.83360000000, '109193'),
(13822, 'US-CA-109194', 'Moreno Valley', 'CI', 4169, 33.92240000000, -117.24760000000, '109194'),
(13823, 'US-VA-109195', 'Smithfield', 'CI', 4218, 37.00580000000, -76.66560000000, '109195'),
(13824, 'US-MD-109196', 'Mechanicsville', 'CI', 4188, 38.42510000000, -76.73170000000, '109196'),
(13825, 'US-MD-109197', 'Indian Head', 'CI', 4188, 38.55840000000, -77.14330000000, '109197'),
(13826, 'US-NC-109198', 'Trinity', 'CI', 4201, 35.80320000000, -79.98270000000, '109198'),
(13827, 'US-NC-109199', 'Star', 'CI', 4201, 35.43550000000, -79.79670000000, '109199'),
(13828, 'US-WA-109200', 'Centralia', 'CI', 4219, 46.74750000000, -122.95070000000, '109200'),
(13829, 'US-FL-109201', 'Lady Lake', 'CI', 4175, 28.92350000000, -81.91850000000, '109201'),
(13830, 'US-FL-109202', 'Saint Cloud', 'CI', 4175, 28.16690000000, -81.27000000000, '109202'),
(13831, 'US-FL-109203', 'Branford', 'CI', 4175, 29.89590000000, -82.89920000000, '109203'),
(13832, 'US-TX-109204', 'Hondo', 'CI', 4214, 29.38770000000, -99.16830000000, '109204'),
(13833, 'US-KY-109205', 'Cumberland', 'CI', 4184, 36.95830000000, -83.00770000000, '109205'),
(13834, 'US-KY-109206', 'Latonia', 'CI', 4184, 38.97650000000, -84.47980000000, '109206'),
(13835, 'US-NY-109207', 'New City', 'CI', 4200, 41.15570000000, -73.99000000000, '109207'),
(13836, 'US-CT-109208', 'Danielson', 'CI', 4171, 41.78900000000, -71.85520000000, '109208'),
(13837, 'US-CT-109209', 'Watertown', 'CI', 4171, 41.61520000000, -73.11540000000, '109209'),
(13838, 'US-MA-109210', 'Hadley', 'CI', 4189, 42.35670000000, -72.58640000000, '109210'),
(13839, 'US-NJ-109211', 'Wrightstown', 'CI', 4198, 40.06880000000, -74.59560000000, '109211'),
(13840, 'US-NJ-109212', 'Hopewell', 'CI', 4198, 40.39330000000, -74.78550000000, '109212'),
(13841, 'US-TX-109213', 'Allen', 'CI', 4214, 33.11220000000, -96.69380000000, '109213'),
(13842, 'US-PA-109214', 'Mountain Top', 'CI', 4208, 41.12350000000, -75.96850000000, '109214'),
(13843, 'US-MD-109215', 'La Plata', 'CI', 4188, 38.51630000000, -77.01540000000, '109215'),
(13844, 'US-VA-109216', 'Stevensburg', 'CI', 4218, 38.45190000000, -77.87960000000, '109216'),
(13845, 'CA-ON-109217', 'Ottawa', 'CI', 38, 45.41670000000, -75.70000000000, '109217'),
(13846, 'US-VA-109218', 'Stephens City', 'CI', 4218, 39.04570000000, -78.22760000000, '109218'),
(13847, 'US-MD-109219', 'Reisterstown', 'CI', 4188, 39.47930000000, -76.79810000000, '109219'),
(13848, 'US-MD-109220', 'Harmans', 'CI', 4188, 39.16350000000, -76.69730000000, '109220'),
(13849, 'US-MD-109221', 'Fallston', 'CI', 4188, 39.53380000000, -76.44500000000, '109221'),
(13850, 'US-MD-109222', 'Gunpowder', 'CI', 4188, 39.36750000000, -76.29610000000, '109222'),
(13851, 'US-NY-109223', 'Corona', 'CI', 4200, 40.74970000000, -73.85340000000, '109223'),
(13852, 'US-NY-109224', 'Kinderhook', 'CI', 4200, 42.38580000000, -73.71490000000, '109224'),
(13853, 'US-FL-109225', 'Alachua', 'CI', 4175, 29.81420000000, -82.49090000000, '109225'),
(13854, 'US-CA-109226', 'Fallbrook', 'CI', 4169, 33.39890000000, -117.29570000000, '109226'),
(13855, 'US-CA-109227', 'South Pasadena', 'CI', 4169, 34.11210000000, -118.15640000000, '109227'),
(13856, 'US-CA-109228', 'Mojave', 'CI', 4169, 35.09790000000, -118.13020000000, '109228'),
(13857, 'US-CA-109229', 'Stevenson Ranch', 'CI', 4169, 34.37590000000, -118.61620000000, '109229'),
(13858, 'US-CA-109230', 'Shingle Springs', 'CI', 4169, 38.61530000000, -120.97680000000, '109230'),
(13859, 'US-MA-109231', 'Hudson', 'CI', 4189, 42.38970000000, -71.54010000000, '109231'),
(13860, 'US-MA-109232', 'Hopedale', 'CI', 4189, 42.12940000000, -71.53530000000, '109232'),
(13861, 'US-MN-109233', 'Hawley', 'CI', 4191, 46.84980000000, -96.31460000000, '109233'),
(13862, 'US-KY-109234', 'Annville', 'CI', 4184, 37.30210000000, -83.96950000000, '109234'),
(13863, 'US-OK-109235', 'Ramona', 'CI', 4205, 36.53960000000, -95.90540000000, '109235'),
(13864, 'US-AR-109236', 'Forrest City', 'CI', 4165, 35.02570000000, -90.78070000000, '109236'),
(13865, 'US-GA-109237', 'Chatsworth', 'CI', 4176, 34.74170000000, -84.76350000000, '109237'),
(13866, 'US-TN-109238', 'Cleveland', 'CI', 4213, 35.09780000000, -84.91150000000, '109238'),
(13867, 'US-MN-109239', 'Lester Prairie', 'CI', 4191, 44.88260000000, -94.08060000000, '109239'),
(13868, 'US-TN-109240', 'Hendersonville', 'CI', 4213, 36.34790000000, -86.60050000000, '109240'),
(13869, 'US-LA-109241', 'Reserve', 'CI', 4185, 30.06840000000, -90.58040000000, '109241'),
(13870, 'US-AL-109242', 'Spanish Fort', 'CI', 4161, 30.70210000000, -87.86370000000, '109242'),
(13871, 'US-OH-109243', 'Groveport', 'CI', 4204, 39.84370000000, -82.89330000000, '109243'),
(13872, 'US-OH-109244', 'Washington Court House', 'CI', 4204, 39.53720000000, -83.43430000000, '109244'),
(13873, 'US-WV-109245', 'Madison', 'CI', 4220, 38.03460000000, -81.75920000000, '109245'),
(13874, 'US-MN-109246', 'Deerwood', 'CI', 4191, 46.42890000000, -93.88310000000, '109246'),
(13875, 'US-MN-109247', 'Pierz', 'CI', 4191, 46.01590000000, -94.05420000000, '109247'),
(13876, 'US-WI-109248', 'Superior', 'CI', 4221, 46.57540000000, -92.13780000000, '109248'),
(13877, 'US-OH-109249', 'Granville', 'CI', 4204, 40.08670000000, -82.54610000000, '109249'),
(13878, 'US-CA-109250', 'Huntington Park', 'CI', 4169, 33.97750000000, -118.21330000000, '109250'),
(13879, 'US-OH-109251', 'Norwich', 'CI', 4204, 40.01430000000, -81.78840000000, '109251'),
(13880, 'US-CA-109252', 'Rosemead', 'CI', 4169, 34.06160000000, -118.08180000000, '109252'),
(13881, 'US-WV-109253', 'Vienna', 'CI', 4220, 39.32800000000, -81.52550000000, '109253'),
(13882, 'US-AR-109254', 'Malvern', 'CI', 4165, 34.34220000000, -92.79600000000, '109254'),
(13883, 'US-VA-109255', 'Burke', 'CI', 4218, 38.78510000000, -77.28660000000, '109255'),
(13884, 'US-MI-109256', 'Cedar Springs', 'CI', 4190, 43.23340000000, -85.52390000000, '109256'),
(13885, 'US-MN-109257', 'Norwood Young America', 'CI', 4191, 44.73890000000, -93.90960000000, '109257'),
(13886, 'US-MI-109258', 'Whitmore Lake', 'CI', 4190, 42.40540000000, -83.79430000000, '109258'),
(13887, 'US-OH-109259', 'Archbold', 'CI', 4204, 41.53750000000, -84.30100000000, '109259'),
(13888, 'US-KS-109260', 'Winchester', 'CI', 4183, 39.33220000000, -95.24990000000, '109260'),
(13889, 'US-TN-109261', 'Trenton', 'CI', 4213, 35.98070000000, -88.99780000000, '109261'),
(13890, 'US-AZ-109262', 'Bapchule', 'CI', 4164, 33.13650000000, -111.87510000000, '109262'),
(13891, 'US-VA-109263', 'Locust Grove', 'CI', 4218, 38.31130000000, -77.78710000000, '109263'),
(13892, 'US-MO-109264', 'Kingsville', 'CI', 4193, 38.78170000000, -94.09190000000, '109264'),
(13893, 'US-KS-109265', 'Clearwater', 'CI', 4183, 37.50500000000, -97.50670000000, '109265'),
(13894, 'US-MO-109266', 'Warrensburg', 'CI', 4193, 38.78620000000, -93.72390000000, '109266'),
(13895, 'US-VA-109267', 'Daleville', 'CI', 4218, 37.41700000000, -79.91310000000, '109267'),
(13896, 'US-VA-109268', 'Midland', 'CI', 4218, 38.57210000000, -77.64530000000, '109268'),
(13897, 'US-PA-109269', 'Hawley', 'CI', 4208, 41.41650000000, -75.15520000000, '109269'),
(13898, 'US-PA-109270', 'Damascus', 'CI', 4208, 41.74540000000, -75.12080000000, '109270'),
(13899, 'US-NY-109271', 'Akron', 'CI', 4200, 43.03340000000, -78.50680000000, '109271'),
(13900, 'US-NJ-109272', 'Glen Ridge', 'CI', 4198, 40.80730000000, -74.20510000000, '109272'),
(13901, 'US-NJ-109273', 'Orange', 'CI', 4198, 40.77090000000, -74.23690000000, '109273'),
(13902, 'US-MI-109274', 'Bangor', 'CI', 4190, 42.31280000000, -86.08130000000, '109274'),
(13903, 'US-OH-109275', 'Canfield', 'CI', 4204, 41.01370000000, -80.77060000000, '109275'),
(13904, 'US-OH-109276', 'Galion', 'CI', 4204, 40.71360000000, -82.80120000000, '109276'),
(13905, 'US-VA-109277', 'Lightfoot', 'CI', 4218, 37.32320000000, -76.73900000000, '109277'),
(13906, 'US-OK-109278', 'Geary', 'CI', 4205, 35.65590000000, -98.38290000000, '109278'),
(13907, 'US-OK-109279', 'Checotah', 'CI', 4205, 35.43640000000, -95.48650000000, '109279'),
(13908, 'US-KS-109280', 'Zenda', 'CI', 4183, 37.42790000000, -98.29770000000, '109280'),
(13909, 'US-WI-109281', 'Hartford', 'CI', 4221, 43.31760000000, -88.36620000000, '109281'),
(13910, 'US-MT-109282', 'Stevensville', 'CI', 4194, 46.50810000000, -114.10570000000, '109282'),
(13911, 'US-IA-109283', 'Albert City', 'CI', 4182, 42.75620000000, -94.98770000000, '109283'),
(13912, 'US-IA-109284', 'Ralston', 'CI', 4182, 42.07880000000, -94.56770000000, '109284'),
(13913, 'US-CA-109285', 'Paramount', 'CI', 4169, 33.89900000000, -118.16510000000, '109285'),
(13914, 'US-CA-109286', 'Lynwood', 'CI', 4169, 33.92510000000, -118.20320000000, '109286'),
(13915, 'US-MI-109287', 'Saint Johns', 'CI', 4190, 43.01250000000, -84.57220000000, '109287'),
(13916, 'US-UT-109288', 'Milford', 'CI', 4215, 38.36240000000, -113.10980000000, '109288'),
(13917, 'US-NY-109289', 'Altamont', 'CI', 4200, 42.69070000000, -74.02250000000, '109289'),
(13918, 'US-OH-109290', 'Monroe', 'CI', 4204, 39.44450000000, -84.36780000000, '109290'),
(13919, 'US-OR-109291', 'Molalla', 'CI', 4206, 45.07300000000, -122.55480000000, '109291'),
(13920, 'US-OR-109292', 'Eagle Point', 'CI', 4206, 42.46240000000, -122.66400000000, '109292'),
(13921, 'US-PA-109293', 'Export', 'CI', 4208, 40.43540000000, -79.61920000000, '109293'),
(13922, 'US-PA-109294', 'Darlington', 'CI', 4208, 40.78570000000, -80.43740000000, '109294'),
(13923, 'US-PA-109295', 'Utica', 'CI', 4208, 41.42000000000, -79.97810000000, '109295'),
(13924, 'US-WV-109296', 'Chester', 'CI', 4220, 40.59270000000, -80.55840000000, '109296'),
(13925, 'US-PA-109297', 'Mount Pleasant', 'CI', 4208, 40.14900000000, -79.51810000000, '109297'),
(13926, 'US-PA-109298', 'Smithfield', 'CI', 4208, 39.79310000000, -79.81280000000, '109298'),
(13927, 'US-WV-109299', 'Elkins', 'CI', 4220, 38.91430000000, -79.84070000000, '109299'),
(13928, 'US-PA-109300', 'Wrightsville', 'CI', 4208, 39.98650000000, -76.53180000000, '109300'),
(13929, 'US-WV-109301', 'Prichard', 'CI', 4220, 38.23930000000, -82.54810000000, '109301'),
(13930, 'US-PA-109302', 'Carlisle', 'CI', 4208, 40.18080000000, -77.21390000000, '109302'),
(13931, 'US-NJ-109303', 'Harrington Park', 'CI', 4198, 40.99070000000, -73.98330000000, '109303'),
(13932, 'US-NY-109304', 'Woodmere', 'CI', 4200, 40.63090000000, -73.71160000000, '109304'),
(13933, 'US-NJ-109305', 'Park Ridge', 'CI', 4198, 41.03480000000, -74.04390000000, '109305'),
(13934, 'US-NJ-109306', 'Pequannock', 'CI', 4198, 40.94730000000, -74.29560000000, '109306'),
(13935, 'US-CT-109307', 'Sherman', 'CI', 4171, 41.58130000000, -73.48740000000, '109307'),
(13936, 'US-CT-109308', 'Orange', 'CI', 4171, 41.27940000000, -73.03290000000, '109308'),
(13937, 'US-CT-109309', 'Monroe', 'CI', 4171, 41.34180000000, -73.23170000000, '109309'),
(13938, 'US-NY-109310', 'Pine Plains', 'CI', 4200, 41.98180000000, -73.65780000000, '109310'),
(13939, 'US-OH-109311', 'Litchfield', 'CI', 4204, 41.16020000000, -82.02580000000, '109311'),
(13940, 'US-CA-109312', 'Sausalito', 'CI', 4169, 37.86590000000, -122.49690000000, '109312'),
(13941, 'US-OH-109313', 'Canal Fulton', 'CI', 4204, 40.88430000000, -81.59460000000, '109313'),
(13942, 'US-NY-109314', 'Deer Park', 'CI', 4200, 40.76270000000, -73.32270000000, '109314'),
(13943, 'US-GA-109315', 'Jonesboro', 'CI', 4176, 33.52090000000, -84.32380000000, '109315'),
(13944, 'US-WA-109316', 'Chewelah', 'CI', 4219, 48.26600000000, -117.76350000000, '109316'),
(13945, 'US-NJ-109317', 'Haddonfield', 'CI', 4198, 39.89420000000, -75.03940000000, '109317'),
(13946, 'US-KY-109318', 'Benton', 'CI', 4184, 36.85960000000, -88.33670000000, '109318'),
(13947, 'US-MI-109319', 'East Lansing', 'CI', 4190, 42.76270000000, -84.44270000000, '109319'),
(13948, 'US-NY-109320', 'Pulaski', 'CI', 4200, 43.52350000000, -76.13830000000, '109320'),
(13949, 'US-TN-109321', 'Celina', 'CI', 4213, 36.56260000000, -85.55540000000, '109321'),
(13950, 'US-NY-109322', 'Oneida', 'CI', 4200, 43.06720000000, -75.63780000000, '109322'),
(13951, 'US-NY-109323', 'Albertson', 'CI', 4200, 40.77020000000, -73.65140000000, '109323'),
(13952, 'US-VA-109324', 'Fort Lee', 'CI', 4218, 37.23570000000, -77.33660000000, '109324'),
(13953, 'US-CT-109325', 'New Preston Marble Dale', 'CI', 4171, 41.70060000000, -73.34010000000, '109325'),
(13954, 'US-NY-109326', 'Glens Falls', 'CI', 4200, 43.31010000000, -73.64320000000, '109326'),
(13955, 'US-NE-109327', 'Blue Hill', 'CI', 4195, 40.28600000000, -98.41770000000, '109327'),
(13956, 'US-NY-109328', 'Maybrook', 'CI', 4200, 41.48820000000, -74.22030000000, '109328'),
(13957, 'US-NJ-109329', 'Millburn', 'CI', 4198, 40.73350000000, -74.30300000000, '109329'),
(13958, 'US-VA-109330', 'Blue Grass', 'CI', 4218, 38.51930000000, -79.59070000000, '109330'),
(13959, 'US-FL-109331', 'Dade City', 'CI', 4175, 28.34660000000, -82.24800000000, '109331'),
(13960, 'US-IN-109332', 'Bloomingdale', 'CI', 4181, 39.87330000000, -87.26000000000, '109332'),
(13961, 'US-MN-109333', 'Clear Lake', 'CI', 4191, 45.46950000000, -93.95860000000, '109333'),
(13962, 'US-NJ-109334', 'Little Ferry', 'CI', 4198, 40.84420000000, -74.04160000000, '109334'),
(13963, 'US-NJ-109335', 'Malaga', 'CI', 4198, 39.57960000000, -75.05660000000, '109335'),
(13964, 'US-CA-109336', 'La Habra', 'CI', 4169, 33.94140000000, -117.95550000000, '109336'),
(13965, 'US-MA-109337', 'West Newton', 'CI', 4189, 42.35000000000, -71.22690000000, '109337'),
(13966, 'US-MA-109338', 'Ware', 'CI', 4189, 42.29910000000, -72.27570000000, '109338'),
(13967, 'US-IA-109339', 'Peosta', 'CI', 4182, 42.42450000000, -90.80830000000, '109339'),
(13968, 'US-IA-109340', 'Keosauqua', 'CI', 4182, 40.73260000000, -91.96440000000, '109340'),
(13969, 'US-VT-109341', 'North Springfield', 'CI', 4216, 43.33560000000, -72.52420000000, '109341'),
(13970, 'US-NH-109342', 'Londonderry', 'CI', 4197, 42.87310000000, -71.39040000000, '109342'),
(13971, 'US-IL-109343', 'Mendota', 'CI', 4180, 41.55150000000, -89.07880000000, '109343'),
(13972, 'US-IA-109344', 'Walcott', 'CI', 4182, 41.61090000000, -90.76320000000, '109344'),
(13973, 'US-AZ-109345', 'Cottonwood', 'CI', 4164, 34.75820000000, -112.01180000000, '109345'),
(13974, 'US-VT-109346', 'White River Junction', 'CI', 4216, 43.65430000000, -72.39040000000, '109346'),
(13975, 'US-NH-109347', 'North Conway', 'CI', 4197, 44.03540000000, -71.13480000000, '109347'),
(13976, 'US-IL-109348', 'Rockton', 'CI', 4180, 42.46560000000, -89.17150000000, '109348'),
(13977, 'US-KS-109349', 'Seneca', 'CI', 4183, 39.86300000000, -96.03280000000, '109349'),
(13978, 'US-KS-109350', 'Louisburg', 'CI', 4183, 38.55500000000, -94.68990000000, '109350'),
(13979, 'US-IN-109351', 'Newburgh', 'CI', 4181, 37.95680000000, -87.35150000000, '109351'),
(13980, 'US-IN-109352', 'Corydon', 'CI', 4181, 38.18410000000, -86.15230000000, '109352'),
(13981, 'US-KY-109353', 'Russell Springs', 'CI', 4184, 37.07070000000, -85.04790000000, '109353'),
(13982, 'US-KY-109354', 'Hodgenville', 'CI', 4184, 37.56520000000, -85.72640000000, '109354'),
(13983, 'US-IN-109355', 'Charlestown', 'CI', 4181, 38.45410000000, -85.60880000000, '109355'),
(13984, 'US-KY-109356', 'Artemus', 'CI', 4184, 36.79080000000, -83.81900000000, '109356'),
(13985, 'US-KY-109357', 'Beverly', 'CI', 4184, 37.02300000000, -83.55930000000, '109357'),
(13986, 'US-KY-109358', 'Philpot', 'CI', 4184, 37.71600000000, -86.92710000000, '109358'),
(13987, 'US-CA-109359', 'Santa Ysabel', 'CI', 4169, 33.18580000000, -116.73170000000, '109359'),
(13988, 'US-AR-109360', 'Harvey', 'CI', 4165, 34.87620000000, -93.75300000000, '109360'),
(13989, 'US-LA-109361', 'Hodge', 'CI', 4185, 32.27800000000, -92.71220000000, '109361'),
(13990, 'US-AR-109362', 'Alexander', 'CI', 4165, 34.65740000000, -92.52950000000, '109362'),
(13991, 'US-UT-109363', 'Lindon', 'CI', 4215, 40.32200000000, -111.74670000000, '109363'),
(13992, 'US-NV-109364', 'Golconda', 'CI', 4196, 40.93610000000, -117.33120000000, '109364'),
(13993, 'US-ID-109365', 'Cobalt', 'CI', 4179, 44.96810000000, -113.81670000000, '109365'),
(13994, 'US-MA-109366', 'Tyngsboro', 'CI', 4189, 42.65900000000, -71.44840000000, '109366'),
(13995, 'US-UT-109367', 'Fillmore', 'CI', 4215, 39.01860000000, -112.27290000000, '109367'),
(13996, 'US-UT-109368', 'East Carbon', 'CI', 4215, 39.51480000000, -110.45150000000, '109368'),
(13997, 'US-UT-109369', 'Huntington', 'CI', 4215, 39.41130000000, -111.00560000000, '109369'),
(13998, 'US-MT-109370', 'Red Lodge', 'CI', 4194, 45.23310000000, -109.44030000000, '109370'),
(13999, 'US-NY-109371', 'Lakewood', 'CI', 4200, 42.08190000000, -79.33120000000, '109371'),
(14000, 'US-NY-109372', 'Sanborn', 'CI', 4200, 43.14760000000, -78.87540000000, '109372'),
(14001, 'US-NY-109373', 'Clarence', 'CI', 4200, 42.99860000000, -78.61420000000, '109373'),
(14002, 'US-PA-109374', 'Clarion', 'CI', 4208, 41.17550000000, -79.37910000000, '109374'),
(14003, 'US-NY-109375', 'Central Islip', 'CI', 4200, 40.78000000000, -73.19830000000, '109375'),
(14004, 'US-NY-109376', 'Babylon', 'CI', 4200, 40.62780000000, -73.36500000000, '109376'),
(14005, 'US-CA-109377', 'Signal Hill', 'CI', 4169, 33.80080000000, -118.16730000000, '109377'),
(14006, 'US-OR-109378', 'Aumsville', 'CI', 4206, 44.82680000000, -122.85480000000, '109378'),
(14007, 'US-NY-109379', 'Pittsford', 'CI', 4200, 43.05110000000, -77.52240000000, '109379'),
(14008, 'US-NY-109380', 'Perry', 'CI', 4200, 42.73280000000, -78.01970000000, '109380'),
(14010, 'US-CO-109382', 'Hudson', 'CI', 4170, 40.03660000000, -104.58740000000, '109382'),
(14011, 'US-PA-109383', 'Folcroft', 'CI', 4208, 39.89180000000, -75.27590000000, '109383'),
(14012, 'US-DE-109384', 'Bethany Beach', 'CI', 4172, 38.55620000000, -75.06920000000, '109384'),
(14013, 'US-NY-109385', 'Far Rockaway', 'CI', 4200, 40.60240000000, -73.76370000000, '109385'),
(14014, 'US-IL-109386', 'Orion', 'CI', 4180, 41.36190000000, -90.41420000000, '109386'),
(14015, 'US-MA-109387', 'Sterling', 'CI', 4189, 42.43930000000, -71.77690000000, '109387'),
(14016, 'US-MA-109388', 'Charlton', 'CI', 4189, 42.13180000000, -71.97310000000, '109388'),
(14017, 'US-MA-109389', 'Athol', 'CI', 4189, 42.56470000000, -72.17880000000, '109389'),
(14018, 'US-MA-109390', 'North Brookfield', 'CI', 4189, 42.26910000000, -72.08260000000, '109390'),
(14019, 'US-MA-109391', 'North Grafton', 'CI', 4189, 42.22440000000, -71.68940000000, '109391'),
(14020, 'US-MA-109392', 'Shrewsbury', 'CI', 4189, 42.28650000000, -71.71470000000, '109392'),
(14021, 'US-NH-109393', 'Milford', 'CI', 4197, 42.82570000000, -71.67370000000, '109393'),
(14022, 'US-MN-109394', 'Waseca', 'CI', 4191, 44.06560000000, -93.52700000000, '109394'),
(14023, 'US-MN-109395', 'Inver Grove Heights', 'CI', 4191, 44.82190000000, -93.05780000000, '109395'),
(14024, 'US-MN-109396', 'Stillwater', 'CI', 4191, 45.06480000000, -92.84730000000, '109396'),
(14025, 'US-MN-109397', 'South Saint Paul', 'CI', 4191, 44.88390000000, -93.04000000000, '109397'),
(14026, 'US-WI-109398', 'Gilman', 'CI', 4221, 45.21580000000, -90.84980000000, '109398'),
(14027, 'US-MN-109399', 'Brownsdale', 'CI', 4191, 43.74210000000, -92.84960000000, '109399'),
(14028, 'US-IN-109400', 'Bedford', 'CI', 4181, 38.86200000000, -86.47110000000, '109400'),
(14029, 'US-IL-109401', 'Newman', 'CI', 4180, 39.80080000000, -88.01560000000, '109401'),
(14030, 'US-IN-109402', 'Van Buren', 'CI', 4181, 40.62430000000, -85.51070000000, '109402'),
(14031, 'US-IL-109403', 'Wauconda', 'CI', 4180, 42.27110000000, -88.13900000000, '109403'),
(14032, 'US-IL-109404', 'Glenwood', 'CI', 4180, 41.54160000000, -87.61160000000, '109404'),
(14033, 'US-IL-109405', 'Momence', 'CI', 4180, 41.11660000000, -87.62780000000, '109405'),
(14034, 'US-IN-109406', 'Lake Station', 'CI', 4181, 41.57270000000, -87.26810000000, '109406'),
(14035, 'US-IN-109407', 'Lawrenceburg', 'CI', 4181, 39.16230000000, -84.89110000000, '109407'),
(14036, 'US-MN-109408', 'Annandale', 'CI', 4191, 45.26030000000, -94.13080000000, '109408'),
(14037, 'US-MN-109409', 'Pengilly', 'CI', 4191, 47.28340000000, -93.19290000000, '109409'),
(14038, 'US-AR-109410', 'Mc Crory', 'CI', 4165, 35.24600000000, -91.17520000000, '109410'),
(14039, 'US-WI-109411', 'Wautoma', 'CI', 4221, 44.06540000000, -89.28210000000, '109411'),
(14040, 'US-WI-109412', 'Iola', 'CI', 4221, 44.46190000000, -88.91500000000, '109412'),
(14041, 'US-WI-109413', 'Mauston', 'CI', 4221, 43.77200000000, -90.03370000000, '109413'),
(14042, 'US-WI-109414', 'Plain', 'CI', 4221, 43.31200000000, -90.05030000000, '109414'),
(14043, 'US-NY-109415', 'Salamanca', 'CI', 4200, 42.08260000000, -78.76010000000, '109415'),
(14044, 'US-CA-109416', 'San Fernando', 'CI', 4169, 34.28460000000, -118.43990000000, '109416'),
(14045, 'US-PA-109417', 'Lewisburg', 'CI', 4208, 40.98120000000, -76.95870000000, '109417'),
(14046, 'US-CA-109418', 'Rancho Santa Margarita', 'CI', 4169, 33.61990000000, -117.61190000000, '109418'),
(14047, 'US-AL-109419', 'Sulligent', 'CI', 4161, 33.83960000000, -88.10660000000, '109419'),
(14048, 'US-OK-109420', 'Skiatook', 'CI', 4205, 36.42180000000, -96.05430000000, '109420'),
(14049, 'US-KS-109421', 'Norwich', 'CI', 4183, 37.48560000000, -97.86180000000, '109421'),
(14050, 'US-AL-109422', 'Piedmont', 'CI', 4161, 33.92380000000, -85.59800000000, '109422'),
(14051, 'US-TX-109423', 'Goodfellow Afb', 'CI', 4214, 31.43290000000, -100.40260000000, '109423'),
(14052, 'US-NY-109424', 'Highland', 'CI', 4200, 41.71670000000, -74.00790000000, '109424'),
(14053, 'US-MI-109425', 'Marlette', 'CI', 4190, 43.35300000000, -83.01420000000, '109425'),
(14054, 'US-MI-109426', 'Almont', 'CI', 4190, 42.93580000000, -83.04400000000, '109426'),
(14055, 'US-VA-109427', 'Aldie', 'CI', 4218, 38.96360000000, -77.61310000000, '109427'),
(14056, 'US-CA-109428', 'Borrego Springs', 'CI', 4169, 33.17990000000, -116.27310000000, '109428'),
(14057, 'US-CA-109429', 'Winterhaven', 'CI', 4169, 32.87010000000, -114.72230000000, '109429'),
(14058, 'US-NY-109430', 'Wolcott', 'CI', 4200, 43.22670000000, -76.84040000000, '109430'),
(14059, 'US-NY-109431', 'Cortland', 'CI', 4200, 42.61780000000, -76.19260000000, '109431'),
(14060, 'US-NY-109432', 'Bath', 'CI', 4200, 42.36290000000, -77.35390000000, '109432'),
(14061, 'US-OH-109433', 'Middlefield', 'CI', 4204, 41.45580000000, -81.01840000000, '109433'),
(14062, 'US-TX-109434', 'Salado', 'CI', 4214, 30.92870000000, -97.58190000000, '109434'),
(14063, 'US-NY-109435', 'Greene', 'CI', 4200, 42.33840000000, -75.75440000000, '109435'),
(14064, 'US-NY-109436', 'Sodus', 'CI', 4200, 43.21520000000, -77.04150000000, '109436'),
(14065, 'US-NY-109437', 'Jamesville', 'CI', 4200, 42.96050000000, -76.05890000000, '109437'),
(14066, 'US-NY-109438', 'Fulton', 'CI', 4200, 43.34800000000, -76.34220000000, '109438'),
(14067, 'US-NY-109439', 'Maine', 'CI', 4200, 42.25860000000, -76.05480000000, '109439'),
(14068, 'US-IL-109440', 'Morton Grove', 'CI', 4180, 42.03900000000, -87.79380000000, '109440'),
(14069, 'US-TX-109441', 'Ferris', 'CI', 4214, 32.54270000000, -96.61760000000, '109441'),
(14070, 'US-WI-109442', 'Kansasville', 'CI', 4221, 42.69030000000, -88.12560000000, '109442'),
(14071, 'US-NY-109443', 'Odessa', 'CI', 4200, 42.36800000000, -76.77280000000, '109443'),
(14072, 'US-TX-109444', 'Catarina', 'CI', 4214, 28.34710000000, -99.61280000000, '109444'),
(14073, 'US-NY-109445', 'New Berlin', 'CI', 4200, 42.63880000000, -75.29970000000, '109445'),
(14074, 'US-VA-109446', 'Remington', 'CI', 4218, 38.53900000000, -77.80670000000, '109446'),
(14075, 'US-AZ-109447', 'Sierra Vista', 'CI', 4164, 31.59180000000, -110.17190000000, '109447'),
(14076, 'US-OH-109448', 'Tipp City', 'CI', 4204, 39.94020000000, -84.17270000000, '109448'),
(14077, 'US-IN-109449', 'Parker City', 'CI', 4181, 40.17780000000, -85.20090000000, '109449'),
(14078, 'US-IN-109450', 'Bluffton', 'CI', 4181, 40.71340000000, -85.16480000000, '109450'),
(14079, 'US-MA-109451', 'Three Rivers', 'CI', 4189, 42.17590000000, -72.36420000000, '109451'),
(14080, 'US-TX-109452', 'Port Neches', 'CI', 4214, 29.98010000000, -93.95870000000, '109452'),
(14081, 'US-TX-109453', 'Columbus', 'CI', 4214, 29.76790000000, -96.58740000000, '109453'),
(14082, 'US-PA-109454', 'West Point', 'CI', 4208, 40.20980000000, -75.30340000000, '109454'),
(14083, 'US-AL-109455', 'Eclectic', 'CI', 4161, 32.64490000000, -86.03390000000, '109455'),
(14084, 'US-NJ-109456', 'Boonton', 'CI', 4198, 40.94220000000, -74.41960000000, '109456'),
(14085, 'US-CT-109457', 'New London', 'CI', 4171, 41.34520000000, -72.10880000000, '109457'),
(14086, 'US-PA-109458', 'Saint Clair', 'CI', 4208, 40.72210000000, -76.19040000000, '109458'),
(14087, 'US-PA-109459', 'Berwick', 'CI', 4208, 41.09510000000, -76.26190000000, '109459'),
(14088, 'US-NY-109460', 'Jamestown', 'CI', 4200, 42.10450000000, -79.25200000000, '109460'),
(14089, 'US-MT-109461', 'Corvallis', 'CI', 4194, 46.34780000000, -113.95560000000, '109461'),
(14090, 'US-ID-109462', 'Horseshoe Bend', 'CI', 4179, 43.92700000000, -116.17680000000, '109462'),
(14092, 'US-MI-109464', 'Berkley', 'CI', 4190, 42.49920000000, -83.18110000000, '109464'),
(14093, 'US-OH-109465', 'Wayne', 'CI', 4204, 41.29820000000, -83.51510000000, '109465'),
(14094, 'US-OH-109466', 'Ashville', 'CI', 4204, 39.72200000000, -82.92150000000, '109466'),
(14095, 'US-OH-109467', 'Hayesville', 'CI', 4204, 40.77260000000, -82.25900000000, '109467'),
(14096, 'US-WV-109468', 'Waverly', 'CI', 4220, 39.29930000000, -81.34830000000, '109468'),
(14097, 'US-WV-109469', 'Nitro', 'CI', 4220, 38.41790000000, -81.81800000000, '109469'),
(14098, 'US-OH-109470', 'Mc Arthur', 'CI', 4204, 39.28600000000, -82.47560000000, '109470'),
(14099, 'US-WV-109471', 'Eleanor', 'CI', 4220, 38.53790000000, -81.92820000000, '109471'),
(14100, 'US-MI-109472', 'Dewitt', 'CI', 4190, 42.86020000000, -84.59410000000, '109472'),
(14101, 'US-MI-109473', 'Milford', 'CI', 4190, 42.56260000000, -83.60990000000, '109473'),
(14102, 'US-MI-109474', 'Grand Junction', 'CI', 4190, 42.40010000000, -86.06100000000, '109474'),
(14103, 'US-MI-109475', 'Freeland', 'CI', 4190, 43.49890000000, -84.15600000000, '109475'),
(14104, 'US-FL-109476', 'Bowling Green', 'CI', 4175, 27.61460000000, -82.04550000000, '109476'),
(14105, 'US-FL-109477', 'Englewood', 'CI', 4175, 26.95540000000, -82.29870000000, '109477'),
(14106, 'US-CA-109478', 'Marina', 'CI', 4169, 36.67990000000, -121.78970000000, '109478'),
(14107, 'US-CA-109479', 'Jamestown', 'CI', 4169, 37.85510000000, -120.49170000000, '109479'),
(14108, 'US-NY-109480', 'Phelps', 'CI', 4200, 42.95750000000, -77.01170000000, '109480'),
(14109, 'US-PA-109481', 'Southampton', 'CI', 4208, 40.18770000000, -75.00580000000, '109481'),
(14110, 'US-CT-109482', 'Canton Center', 'CI', 4171, 41.85390000000, -72.90280000000, '109482'),
(14111, 'US-PA-109483', 'Womelsdorf', 'CI', 4208, 40.39410000000, -76.20670000000, '109483'),
(14112, 'US-CA-109484', 'South Lake Tahoe', 'CI', 4169, 38.84790000000, -120.01390000000, '109484'),
(14113, 'US-NY-109485', 'Webster', 'CI', 4200, 43.21860000000, -77.44940000000, '109485'),
(14114, 'US-CA-109486', 'Corning', 'CI', 4169, 39.92590000000, -122.28350000000, '109486'),
(14115, 'US-TX-109487', 'Muleshoe', 'CI', 4214, 34.20070000000, -102.74390000000, '109487'),
(14116, 'US-MN-109488', 'Isanti', 'CI', 4191, 45.47530000000, -93.28730000000, '109488'),
(14117, 'US-MN-109489', 'Ottertail', 'CI', 4191, 46.43890000000, -95.53240000000, '109489'),
(14118, 'US-MN-109490', 'Lutsen', 'CI', 4191, 47.75070000000, -90.60450000000, '109490'),
(14119, 'US-IA-109491', 'Primghar', 'CI', 4182, 43.07340000000, -95.60470000000, '109491'),
(14120, 'US-IL-109492', 'Country Club Hills', 'CI', 4180, 41.55770000000, -87.72740000000, '109492'),
(14121, 'US-OR-109493', 'Bandon', 'CI', 4206, 43.05960000000, -124.36800000000, '109493'),
(14122, 'US-IL-109494', 'Oak Lawn', 'CI', 4180, 41.70910000000, -87.75960000000, '109494'),
(14123, 'US-IL-109495', 'Dunfermline', 'CI', 4180, 40.49160000000, -90.03340000000, '109495'),
(14124, 'US-IL-109496', 'Lansing', 'CI', 4180, 41.56740000000, -87.56010000000, '109496'),
(14125, 'US-IN-109497', 'Thorntown', 'CI', 4181, 40.10890000000, -86.58180000000, '109497'),
(14126, 'US-IN-109498', 'Daleville', 'CI', 4181, 40.10930000000, -85.51550000000, '109498'),
(14127, 'US-IN-109499', 'Peru', 'CI', 4181, 40.76310000000, -86.09180000000, '109499'),
(14128, 'US-IL-109500', 'Tuscola', 'CI', 4180, 39.79420000000, -88.27340000000, '109500'),
(14129, 'US-OH-109501', 'Grafton', 'CI', 4204, 41.27020000000, -82.04200000000, '109501'),
(14130, 'US-OH-109502', 'Batavia', 'CI', 4204, 39.09720000000, -84.12250000000, '109502'),
(14131, 'US-WI-109503', 'Fall Creek', 'CI', 4221, 44.74150000000, -91.30120000000, '109503'),
(14132, 'US-MN-109504', 'New Ulm', 'CI', 4191, 44.30410000000, -94.43560000000, '109504'),
(14133, 'US-MN-109505', 'Lewiston', 'CI', 4191, 43.95860000000, -91.86990000000, '109505'),
(14134, 'US-VT-109506', 'Manchester', 'CI', 4216, 43.16290000000, -73.07030000000, '109506'),
(14135, 'US-CT-109507', 'Ridgefield', 'CI', 4171, 41.30740000000, -73.49470000000, '109507'),
(14136, 'US-CA-109508', 'Selma', 'CI', 4169, 36.53960000000, -119.64520000000, '109508'),
(14137, 'US-NY-109509', 'Raquette Lake', 'CI', 4200, 43.77120000000, -74.63690000000, '109509'),
(14138, 'US-NY-109510', 'Inlet', 'CI', 4200, 43.74260000000, -74.74020000000, '109510'),
(14139, 'US-NY-109511', 'Old Forge', 'CI', 4200, 43.71880000000, -74.90400000000, '109511'),
(14140, 'US-NY-109512', 'Hannibal', 'CI', 4200, 43.31990000000, -76.54730000000, '109512'),
(14141, 'US-NY-109513', 'Frankfort', 'CI', 4200, 43.03840000000, -75.10780000000, '109513'),
(14142, 'US-NY-109514', 'Oriskany', 'CI', 4200, 43.15110000000, -75.36290000000, '109514'),
(14143, 'US-NY-109515', 'Little Falls', 'CI', 4200, 43.10920000000, -74.86420000000, '109515'),
(14144, 'US-NY-109516', 'Utica', 'CI', 4200, 43.07440000000, -75.21170000000, '109516'),
(14145, 'US-NY-109517', 'Bainbridge', 'CI', 4200, 42.32300000000, -75.50740000000, '109517'),
(14146, 'US-NY-109518', 'Vestal', 'CI', 4200, 42.05670000000, -76.02720000000, '109518'),
(14147, 'US-NJ-109519', 'Fairview', 'CI', 4198, 40.81760000000, -74.00220000000, '109519'),
(14148, 'US-NJ-109520', 'Garfield', 'CI', 4198, 40.87750000000, -74.11050000000, '109520'),
(14149, 'US-NY-109521', 'Garrison', 'CI', 4200, 41.37800000000, -73.93150000000, '109521'),
(14150, 'US-NY-109522', 'Dover Plains', 'CI', 4200, 41.71520000000, -73.58200000000, '109522'),
(14151, 'US-NY-109523', 'Palmyra', 'CI', 4200, 43.06220000000, -77.21960000000, '109523'),
(14152, 'US-MD-109524', 'Ridgely', 'CI', 4188, 38.95980000000, -75.89040000000, '109524'),
(14153, 'US-TX-109525', 'Palestine', 'CI', 4214, 31.86640000000, -95.65070000000, '109525'),
(14154, 'US-PA-109526', 'Mckeesport', 'CI', 4208, 40.33770000000, -79.84280000000, '109526'),
(14155, 'US-VA-109527', 'Tasley', 'CI', 4218, 37.72010000000, -75.77600000000, '109527'),
(14156, 'US-PA-109528', 'Verona', 'CI', 4208, 40.49780000000, -79.83230000000, '109528'),
(14157, 'US-PA-109529', 'Saxonburg', 'CI', 4208, 40.72360000000, -79.83540000000, '109529'),
(14158, 'US-IL-109530', 'Mt Zion', 'CI', 4180, 39.77060000000, -88.86620000000, '109530'),
(14159, 'US-PA-109531', 'Gibsonia', 'CI', 4208, 40.64210000000, -79.94450000000, '109531'),
(14160, 'US-KY-109532', 'Munfordville', 'CI', 4184, 37.30530000000, -85.91400000000, '109532'),
(14161, 'US-MO-109533', 'Owensville', 'CI', 4193, 38.34570000000, -91.48140000000, '109533'),
(14162, 'US-NJ-109534', 'Jackson', 'CI', 4198, 40.10460000000, -74.34590000000, '109534'),
(14163, 'US-NJ-109535', 'Lakehurst', 'CI', 4198, 40.02390000000, -74.36650000000, '109535'),
(14164, 'US-PA-109536', 'Springdale', 'CI', 4208, 40.54890000000, -79.78440000000, '109536'),
(14165, 'US-TX-109537', 'Von Ormy', 'CI', 4214, 29.23290000000, -98.63120000000, '109537'),
(14166, 'US-TX-109538', 'Alice', 'CI', 4214, 27.70390000000, -98.08440000000, '109538'),
(14167, 'US-TX-109539', 'Waelder', 'CI', 4214, 29.70460000000, -97.27410000000, '109539'),
(14168, 'US-TX-109540', 'Leonard', 'CI', 4214, 33.38720000000, -96.26650000000, '109540'),
(14169, 'US-TX-109541', 'Tennessee Colony', 'CI', 4214, 31.86900000000, -95.89780000000, '109541'),
(14170, 'US-TX-109542', 'Roanoke', 'CI', 4214, 33.02170000000, -97.22240000000, '109542'),
(14171, 'US-TX-109543', 'Little Elm', 'CI', 4214, 33.18090000000, -96.91770000000, '109543'),
(14172, 'US-TX-109544', 'Gatesville', 'CI', 4214, 31.43970000000, -97.78530000000, '109544'),
(14173, 'US-NC-109545', 'Lewisville', 'CI', 4201, 36.09100000000, -80.43980000000, '109545'),
(14174, 'US-MI-109546', 'Colon', 'CI', 4190, 41.97410000000, -85.33670000000, '109546'),
(14175, 'US-MI-109547', 'Charlotte', 'CI', 4190, 42.56890000000, -84.83610000000, '109547'),
(14176, 'US-MI-109548', 'Harbor Springs', 'CI', 4190, 45.54420000000, -84.99150000000, '109548'),
(14177, 'US-MI-109549', 'Belding', 'CI', 4190, 43.05790000000, -85.27790000000, '109549'),
(14178, 'US-WV-109550', 'Grantsville', 'CI', 4220, 38.89980000000, -81.06820000000, '109550'),
(14179, 'US-OH-109551', 'Logan', 'CI', 4204, 39.52250000000, -82.41700000000, '109551'),
(14180, 'US-AL-109552', 'Grand Bay', 'CI', 4161, 30.49220000000, -88.33130000000, '109552'),
(14181, 'US-NY-109553', 'Oswego', 'CI', 4200, 43.44640000000, -76.39710000000, '109553'),
(14182, 'PR-??-109554', 'Las Piedras', 'CI', 181, 18.19660000000, -65.87200000000, '109554'),
(14183, 'PR-??-109555', 'Bayamon', 'CI', 181, 18.37410000000, -66.14030000000, '109555'),
(14184, 'PR-??-109556', 'Mercedita', 'CI', 181, 18.00060000000, -66.56490000000, '109556'),
(14185, 'VI-??-109557', 'Frederiksted', 'CI', 237, 17.73420000000, -64.73470000000, '109557'),
(14186, 'US-FL-109558', 'Monticello', 'CI', 4175, 30.47210000000, -83.77580000000, '109558'),
(14187, 'US-GA-109559', 'Ellabell', 'CI', 4176, 32.18100000000, -81.51460000000, '109559'),
(14188, 'US-FL-109560', 'Titusville', 'CI', 4175, 28.53110000000, -80.85230000000, '109560'),
(14189, 'US-FL-109561', 'Bushnell', 'CI', 4175, 28.68330000000, -82.16460000000, '109561'),
(14190, 'US-VA-109562', 'Annandale', 'CI', 4218, 38.83810000000, -77.21210000000, '109562'),
(14191, 'US-VA-109563', 'Woodberry Forest', 'CI', 4218, 38.21320000000, -78.05220000000, '109563'),
(14192, 'US-VA-109564', 'Dumfries', 'CI', 4218, 38.58300000000, -77.31580000000, '109564'),
(14193, 'US-VA-109565', 'Gainesville', 'CI', 4218, 38.81750000000, -77.63080000000, '109565'),
(14194, 'US-FL-109566', 'Deland', 'CI', 4175, 29.04530000000, -81.39760000000, '109566'),
(14195, 'US-TX-109567', 'Prosper', 'CI', 4214, 33.26170000000, -96.81170000000, '109567'),
(14196, 'US-CA-109568', 'Loma Linda', 'CI', 4169, 34.05300000000, -117.24890000000, '109568'),
(14197, 'US-CA-109569', 'March Air Reserve Base', 'CI', 4169, 33.89140000000, -117.27880000000, '109569'),
(14198, 'US-VA-109570', 'Dublin', 'CI', 4218, 37.12830000000, -80.59350000000, '109570'),
(14199, 'US-PA-109571', 'Taylor', 'CI', 4208, 41.39490000000, -75.70890000000, '109571'),
(14200, 'US-IL-109572', 'Penfield', 'CI', 4180, 40.31240000000, -87.95130000000, '109572'),
(14201, 'US-NJ-109573', 'Oaklyn', 'CI', 4198, 39.90790000000, -75.08160000000, '109573'),
(14202, 'US-NJ-109574', 'Somers Point', 'CI', 4198, 39.32040000000, -74.60090000000, '109574'),
(14203, 'US-NJ-109575', 'Manahawkin', 'CI', 4198, 39.70420000000, -74.25460000000, '109575'),
(14204, 'US-CA-109576', 'Lebec', 'CI', 4169, 34.86300000000, -118.87150000000, '109576'),
(14205, 'US-GA-109577', 'Clinchfield', 'CI', 4176, 32.33770000000, -83.73140000000, '109577'),
(14206, 'US-GA-109578', 'Gray', 'CI', 4176, 33.01610000000, -83.57100000000, '109578'),
(14207, 'US-CA-109579', 'Daly City', 'CI', 4169, 37.68690000000, -122.43890000000, '109579'),
(14208, 'US-HI-109580', 'Lahaina', 'CI', 4178, 20.90910000000, -156.62160000000, '109580'),
(14209, 'US-HI-109581', 'Kahuku', 'CI', 4178, 21.66450000000, -157.98000000000, '109581'),
(14210, 'US-HI-109582', 'Princeville', 'CI', 4178, 22.22250000000, -159.48010000000, '109582'),
(14211, 'US-HI-109583', 'Camp H M Smith', 'CI', 4178, 24.85980000000, -168.02180000000, '109583'),
(14212, 'US-TX-109584', 'Alvarado', 'CI', 4214, 32.43000000000, -97.19290000000, '109584'),
(14213, 'US-CA-109585', 'Tipton', 'CI', 4169, 36.04240000000, -119.34890000000, '109585'),
(14214, 'US-GA-109586', 'Gordon', 'CI', 4176, 32.88130000000, -83.31330000000, '109586'),
(14215, 'US-AZ-109587', 'Williams', 'CI', 4164, 35.37130000000, -112.26650000000, '109587'),
(14216, 'US-PA-109588', 'Manheim', 'CI', 4208, 40.17670000000, -76.42970000000, '109588'),
(14217, 'US-VA-109589', 'Cloverdale', 'CI', 4218, 37.37390000000, -79.90380000000, '109589'),
(14218, 'US-PA-109590', 'Middleburg', 'CI', 4208, 40.79700000000, -77.05380000000, '109590'),
(14219, 'US-OH-109591', 'Cardington', 'CI', 4204, 40.48960000000, -82.85910000000, '109591'),
(14220, 'US-OH-109592', 'Dundee', 'CI', 4204, 40.61720000000, -81.65320000000, '109592'),
(14221, 'US-CA-109593', 'Del Rey', 'CI', 4169, 36.65590000000, -119.59610000000, '109593'),
(14222, 'US-OH-109594', 'Andover', 'CI', 4204, 41.62430000000, -80.60740000000, '109594'),
(14223, 'US-OH-109595', 'Kinsman', 'CI', 4204, 41.44060000000, -80.59220000000, '109595'),
(14224, 'US-OH-109596', 'Louisville', 'CI', 4204, 40.87420000000, -81.23260000000, '109596'),
(14225, 'US-OH-109597', 'Berlin', 'CI', 4204, 40.55860000000, -81.80910000000, '109597'),
(14226, 'US-NE-109598', 'Brady', 'CI', 4195, 41.03200000000, -100.38040000000, '109598'),
(14227, 'US-NE-109599', 'Bellevue', 'CI', 4195, 41.14250000000, -95.89510000000, '109599'),
(14228, 'US-NE-109600', 'Hay Springs', 'CI', 4195, 42.65360000000, -102.70500000000, '109600'),
(14229, 'US-VA-109601', 'Tappahannock', 'CI', 4218, 37.90830000000, -76.96440000000, '109601'),
(14230, 'US-SC-109602', 'Summerville', 'CI', 4211, 33.09750000000, -80.17530000000, '109602'),
(14231, 'US-AL-109603', 'Monroeville', 'CI', 4161, 31.52020000000, -87.32070000000, '109603'),
(14232, 'US-WY-109604', 'Mountain View', 'CI', 4222, 41.21740000000, -110.36860000000, '109604'),
(14233, 'US-IN-109605', 'Rising Sun', 'CI', 4181, 38.96580000000, -84.94160000000, '109605'),
(14234, 'US-VA-109606', 'Sandston', 'CI', 4218, 37.50360000000, -77.26080000000, '109606'),
(14235, 'US-CO-109607', 'Parker', 'CI', 4170, 39.50760000000, -104.67730000000, '109607'),
(14236, 'US-IL-109608', 'Palatine', 'CI', 4180, 42.10320000000, -88.06990000000, '109608'),
(14237, 'US-VA-109609', 'Boyce', 'CI', 4218, 39.08380000000, -78.04610000000, '109609'),
(14238, 'US-OH-109610', 'Jamestown', 'CI', 4204, 39.64280000000, -83.74600000000, '109610'),
(14239, 'US-OH-109611', 'East Liberty', 'CI', 4204, 40.30770000000, -83.58110000000, '109611'),
(14240, 'US-OH-109612', 'Wapakoneta', 'CI', 4204, 40.57670000000, -84.13990000000, '109612'),
(14241, 'US-OH-109613', 'Milford Center', 'CI', 4204, 40.17570000000, -83.44590000000, '109613'),
(14242, 'US-HI-109614', 'Wailuku', 'CI', 4178, 20.89990000000, -156.53890000000, '109614'),
(14243, 'US-CA-109615', 'Dobbins', 'CI', 4169, 39.36800000000, -121.20670000000, '109615'),
(14244, 'US-WI-109616', 'South Milwaukee', 'CI', 4221, 42.91170000000, -87.86070000000, '109616'),
(14245, 'US-WI-109617', 'Combined Locks', 'CI', 4221, 44.26620000000, -88.30880000000, '109617'),
(14246, 'US-KS-109618', 'Tonganoxie', 'CI', 4183, 39.11200000000, -95.07940000000, '109618'),
(14247, 'US-MN-109619', 'Northfield', 'CI', 4191, 44.46140000000, -93.20070000000, '109619'),
(14248, 'US-OH-109620', 'Brookville', 'CI', 4204, 39.83740000000, -84.40790000000, '109620'),
(14249, 'US-OH-109621', 'Bradford', 'CI', 4204, 40.11930000000, -84.46610000000, '109621'),
(14250, 'US-IN-109622', 'Spiceland', 'CI', 4181, 39.83470000000, -85.45430000000, '109622'),
(14251, 'US-OH-109623', 'Ada', 'CI', 4204, 40.77260000000, -83.80400000000, '109623'),
(14252, 'US-OH-109624', 'Columbus Grove', 'CI', 4204, 40.90680000000, -84.09880000000, '109624'),
(14253, 'US-MI-109625', 'Bridgeport', 'CI', 4190, 43.34990000000, -83.85170000000, '109625'),
(14254, 'US-VT-109626', 'Wells River', 'CI', 4216, 44.12880000000, -72.09100000000, '109626'),
(14255, 'US-IL-109627', 'Dolton', 'CI', 4180, 41.62590000000, -87.60360000000, '109627'),
(14256, 'US-MI-109628', 'Hartford', 'CI', 4190, 42.17190000000, -86.16330000000, '109628'),
(14257, 'US-AZ-109629', 'Glendale', 'CI', 4164, 33.62220000000, -112.17720000000, '109629'),
(14258, 'US-PA-109630', 'Cambridge Springs', 'CI', 4208, 41.78790000000, -80.06780000000, '109630'),
(14259, 'US-AL-109631', 'Harpersville', 'CI', 4161, 33.33680000000, -86.45480000000, '109631'),
(14260, 'US-IL-109632', 'Flossmoor', 'CI', 4180, 41.53810000000, -87.68420000000, '109632'),
(14261, 'US-TX-109633', 'Kingsville', 'CI', 4214, 27.46150000000, -97.84370000000, '109633'),
(14262, 'US-GA-109634', 'Mauk', 'CI', 4176, 32.50500000000, -84.43980000000, '109634'),
(14263, 'US-SC-109635', 'Greenwood', 'CI', 4211, 34.18920000000, -82.15610000000, '109635'),
(14264, 'US-IL-109636', 'Park Forest', 'CI', 4180, 41.46320000000, -87.69300000000, '109636'),
(14265, 'US-IL-109637', 'Frankfort', 'CI', 4180, 41.47380000000, -87.83770000000, '109637'),
(14266, 'US-IA-109638', 'Ottumwa', 'CI', 4182, 41.03870000000, -92.35790000000, '109638'),
(14267, 'US-MA-109639', 'Whitman', 'CI', 4189, 42.08040000000, -70.93930000000, '109639'),
(14268, 'US-KS-109640', 'Fort Scott', 'CI', 4183, 37.82660000000, -94.79250000000, '109640'),
(14269, 'US-MI-109641', 'Ontonagon', 'CI', 4190, 46.77810000000, -89.59680000000, '109641'),
(14270, 'US-TX-109642', 'Lindale', 'CI', 4214, 32.53160000000, -95.39160000000, '109642'),
(14271, 'US-TX-109643', 'Greenville', 'CI', 4214, 33.19280000000, -96.10550000000, '109643'),
(14272, 'US-WI-109644', 'Kohler', 'CI', 4221, 43.73940000000, -87.78890000000, '109644'),
(14273, 'US-TX-109645', 'Van Horn', 'CI', 4214, 31.27850000000, -104.53650000000, '109645'),
(14274, 'US-MS-109646', 'University', 'CI', 4192, 34.36470000000, -89.53750000000, '109646'),
(14275, 'US-IN-109647', 'New Castle', 'CI', 4181, 39.93410000000, -85.37180000000, '109647'),
(14276, 'US-IN-109648', 'Helmsburg', 'CI', 4181, 39.31070000000, -86.31370000000, '109648'),
(14278, 'US-OH-109650', 'Port Clinton', 'CI', 4204, 41.52270000000, -82.85890000000, '109650'),
(14279, 'US-NJ-109651', 'Bernardsville', 'CI', 4198, 40.72620000000, -74.59490000000, '109651'),
(14280, 'US-IL-109652', 'Montgomery', 'CI', 4180, 41.71910000000, -88.31760000000, '109652'),
(14281, 'US-NV-109653', 'Jean', 'CI', 4196, 35.75910000000, -115.53760000000, '109653'),
(14282, 'US-VA-109654', 'Ruther Glen', 'CI', 4218, 37.95500000000, -77.43720000000, '109654'),
(14283, 'US-VA-109655', 'Nathalie', 'CI', 4218, 36.93400000000, -78.95330000000, '109655');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(14284, 'US-VA-109656', 'Montpelier', 'CI', 4218, 37.82580000000, -77.67690000000, '109656'),
(14285, 'US-VA-109657', 'Verona', 'CI', 4218, 38.20220000000, -78.99750000000, '109657'),
(14286, 'US-MA-109658', 'Gardner', 'CI', 4189, 42.58990000000, -71.98870000000, '109658'),
(14287, 'US-MA-109659', 'Shirley', 'CI', 4189, 42.58010000000, -71.63670000000, '109659'),
(14288, 'US-MA-109660', 'Whitinsville', 'CI', 4189, 42.12440000000, -71.66530000000, '109660'),
(14289, 'US-NC-109661', 'Selma', 'CI', 4201, 35.58480000000, -78.24610000000, '109661'),
(14290, 'US-MA-109662', 'Webster', 'CI', 4189, 42.05810000000, -71.84660000000, '109662'),
(14291, 'US-CA-109663', 'Olympic Valley', 'CI', 4169, 39.19240000000, -120.22000000000, '109663'),
(14292, 'US-NJ-109664', 'West Long Branch', 'CI', 4198, 40.28840000000, -74.01950000000, '109664'),
(14293, 'US-MI-109665', 'Parma', 'CI', 4190, 42.29840000000, -84.59720000000, '109665'),
(14294, 'US-VA-109666', 'Dutton', 'CI', 4218, 37.48890000000, -76.44450000000, '109666'),
(14295, 'US-NC-109667', 'Bolivia', 'CI', 4201, 34.01500000000, -78.16850000000, '109667'),
(14296, 'US-TX-109668', 'Los Fresnos', 'CI', 4214, 26.10200000000, -97.41130000000, '109668'),
(14297, 'US-NY-109669', 'Ridgewood', 'CI', 4200, 40.69830000000, -73.88800000000, '109669'),
(14298, 'US-MD-109670', 'Sharpsburg', 'CI', 4188, 39.44970000000, -77.77450000000, '109670'),
(14299, 'US-NY-109671', 'Chenango Forks', 'CI', 4200, 42.29010000000, -75.85070000000, '109671'),
(14300, 'US-TX-109672', 'Hidalgo', 'CI', 4214, 26.11050000000, -98.25260000000, '109672'),
(14301, 'US-TX-109673', 'Grapeland', 'CI', 4214, 31.51600000000, -95.42760000000, '109673'),
(14302, 'US-MA-109674', 'North Reading', 'CI', 4189, 42.58040000000, -71.08700000000, '109674'),
(14303, 'US-CA-109675', 'Esparto', 'CI', 4169, 38.78730000000, -122.12590000000, '109675'),
(14304, 'US-KY-109676', 'Leburn', 'CI', 4184, 37.38720000000, -82.94060000000, '109676'),
(14305, 'US-MA-109677', 'North Easton', 'CI', 4189, 42.05640000000, -71.11990000000, '109677'),
(14306, 'US-PA-109678', 'Addison', 'CI', 4208, 39.76460000000, -79.35600000000, '109678'),
(14307, 'US-MD-109679', 'Ijamsville', 'CI', 4188, 39.34520000000, -77.31180000000, '109679'),
(14308, 'US-IN-109680', 'Argos', 'CI', 4181, 41.22300000000, -86.25000000000, '109680'),
(14309, 'US-VA-109681', 'Locust Hill', 'CI', 4218, 37.59140000000, -76.50070000000, '109681'),
(14310, 'US-ID-109682', 'Rockland', 'CI', 4179, 42.50570000000, -112.85030000000, '109682'),
(14311, 'US-FL-109683', 'Debary', 'CI', 4175, 28.89390000000, -81.31940000000, '109683'),
(14312, 'US-FL-109684', 'Patrick Afb', 'CI', 4175, 28.24210000000, -80.60810000000, '109684'),
(14313, 'US-AL-109685', 'Anniston', 'CI', 4161, 33.69650000000, -85.68200000000, '109685'),
(14314, 'US-VA-109686', 'Churchville', 'CI', 4218, 38.26840000000, -79.17720000000, '109686'),
(14315, 'US-UT-109687', 'Midway', 'CI', 4215, 40.50890000000, -111.52510000000, '109687'),
(14316, 'US-KY-109688', 'Pippa Passes', 'CI', 4184, 37.32710000000, -82.88510000000, '109688'),
(14317, 'US-OH-109689', 'Toronto', 'CI', 4204, 40.49030000000, -80.67090000000, '109689'),
(14318, 'US-NY-109690', 'Brockport', 'CI', 4200, 43.25080000000, -77.92460000000, '109690'),
(14319, 'US-NY-109691', 'East Rochester', 'CI', 4200, 43.11130000000, -77.49420000000, '109691'),
(14320, 'US-WI-109692', 'White Lake', 'CI', 4221, 45.24770000000, -88.73130000000, '109692'),
(14321, 'US-TX-109693', 'Kountze', 'CI', 4214, 30.35380000000, -94.38820000000, '109693'),
(14322, 'US-NC-109694', 'Severn', 'CI', 4201, 36.51470000000, -77.19170000000, '109694'),
(14323, 'US-VT-109695', 'Poultney', 'CI', 4216, 43.49800000000, -73.18310000000, '109695'),
(14324, 'US-MI-109696', 'Three Oaks', 'CI', 4190, 41.81820000000, -86.59390000000, '109696'),
(14325, 'US-WV-109697', 'Hedgesville', 'CI', 4220, 39.52350000000, -78.07040000000, '109697'),
(14326, 'US-OK-109698', 'Wagoner', 'CI', 4205, 35.96120000000, -95.39790000000, '109698'),
(14327, 'US-OK-109699', 'Roland', 'CI', 4205, 35.43940000000, -94.52720000000, '109699'),
(14328, 'US-OK-109700', 'Sapulpa', 'CI', 4205, 35.96640000000, -96.16300000000, '109700'),
(14329, 'US-KS-109701', 'Lyons', 'CI', 4183, 38.37700000000, -98.21100000000, '109701'),
(14330, 'US-KS-109702', 'Sterling', 'CI', 4183, 38.22450000000, -98.14880000000, '109702'),
(14331, 'US-OK-109703', 'Tahlequah', 'CI', 4205, 35.95820000000, -94.96240000000, '109703'),
(14332, 'US-NY-109704', 'Geneva', 'CI', 4200, 42.85630000000, -77.02510000000, '109704'),
(14333, 'US-NV-109705', 'Laughlin', 'CI', 4196, 35.10230000000, -114.71210000000, '109705'),
(14334, 'US-AZ-109706', 'Douglas', 'CI', 4164, 31.54520000000, -109.46770000000, '109706'),
(14335, 'US-IL-109707', 'Congerville', 'CI', 4180, 40.63820000000, -89.21770000000, '109707'),
(14336, 'US-ID-109708', 'Ponderay', 'CI', 4179, 48.30530000000, -116.52400000000, '109708'),
(14337, 'US-KS-109709', 'Moran', 'CI', 4183, 37.91450000000, -95.16600000000, '109709'),
(14338, 'US-OK-109710', 'Jenks', 'CI', 4205, 36.00270000000, -95.97750000000, '109710'),
(14339, 'US-TX-109711', 'Groves', 'CI', 4214, 29.94460000000, -93.91750000000, '109711'),
(14340, 'US-TX-109712', 'Jasper', 'CI', 4214, 30.92590000000, -94.07380000000, '109712'),
(14341, 'US-TX-109713', 'Garrison', 'CI', 4214, 31.81810000000, -94.52210000000, '109713'),
(14342, 'US-TX-109714', 'Sealy', 'CI', 4214, 29.77840000000, -96.18170000000, '109714'),
(14343, 'US-NC-109715', 'Corolla', 'CI', 4201, 36.38970000000, -75.83470000000, '109715'),
(14344, 'US-NC-109716', 'Elizabethtown', 'CI', 4201, 34.68490000000, -78.54350000000, '109716'),
(14345, 'US-NC-109717', 'Ocracoke', 'CI', 4201, 35.13040000000, -75.91640000000, '109717'),
(14346, 'US-NC-109718', 'Aberdeen', 'CI', 4201, 35.10600000000, -79.45070000000, '109718'),
(14347, 'US-IN-109719', 'Bremen', 'CI', 4181, 41.46310000000, -86.17010000000, '109719'),
(14348, 'US-MI-109720', 'Perry', 'CI', 4190, 42.80380000000, -84.21340000000, '109720'),
(14349, 'US-VA-109721', 'Waverly', 'CI', 4218, 37.00510000000, -77.11820000000, '109721'),
(14350, 'US-VA-109722', 'Maidens', 'CI', 4218, 37.70520000000, -77.82000000000, '109722'),
(14351, 'US-VA-109723', 'Clarksville', 'CI', 4218, 36.63620000000, -78.51470000000, '109723'),
(14352, 'US-VA-109724', 'South Hill', 'CI', 4218, 36.75310000000, -78.19670000000, '109724'),
(14353, 'US-VA-109725', 'Goshen', 'CI', 4218, 37.99940000000, -79.49210000000, '109725'),
(14354, 'US-VA-109726', 'The Plains', 'CI', 4218, 38.88340000000, -77.75970000000, '109726'),
(14355, 'US-OH-109727', 'Fostoria', 'CI', 4204, 41.16280000000, -83.39760000000, '109727'),
(14356, 'US-PA-109728', 'Petersburg', 'CI', 4208, 40.63890000000, -77.89290000000, '109728'),
(14357, 'US-MA-109729', 'Manchester', 'CI', 4189, 42.57190000000, -70.76500000000, '109729'),
(14358, 'US-OR-109730', 'Helix', 'CI', 4206, 45.90550000000, -118.77840000000, '109730'),
(14359, 'US-NY-109731', 'Alfred', 'CI', 4200, 42.25410000000, -77.79070000000, '109731'),
(14360, 'US-IL-109732', 'Buckley', 'CI', 4180, 40.60340000000, -88.02000000000, '109732'),
(14361, 'US-MT-109733', 'Saint Marie', 'CI', 4194, 48.40290000000, -106.54370000000, '109733'),
(14362, 'US-MD-109734', 'Flintstone', 'CI', 4188, 39.67680000000, -78.53390000000, '109734'),
(14363, 'US-NY-109735', 'Irvington', 'CI', 4200, 41.04130000000, -73.85670000000, '109735'),
(14364, 'US-NY-109736', 'Red Hook', 'CI', 4200, 42.00800000000, -73.81750000000, '109736'),
(14365, 'US-TX-109737', 'Coupland', 'CI', 4214, 30.47670000000, -97.34080000000, '109737'),
(14366, 'US-GA-109738', 'Franklin', 'CI', 4176, 33.27810000000, -85.15100000000, '109738'),
(14367, 'US-KY-109739', 'Salyersville', 'CI', 4184, 37.73390000000, -83.08360000000, '109739'),
(14368, 'US-OK-109740', 'Welch', 'CI', 4205, 36.90020000000, -95.20080000000, '109740'),
(14369, 'US-NJ-109741', 'Oceanport', 'CI', 4198, 40.31540000000, -74.01870000000, '109741'),
(14370, 'US-MI-109742', 'Vicksburg', 'CI', 4190, 42.10950000000, -85.47340000000, '109742'),
(14371, 'US-MA-109743', 'Wenham', 'CI', 4189, 42.60070000000, -70.87190000000, '109743'),
(14372, 'US-SC-109744', 'Murrells Inlet', 'CI', 4211, 33.56030000000, -79.04410000000, '109744'),
(14373, 'US-IL-109745', 'Newark', 'CI', 4180, 41.52230000000, -88.50230000000, '109745'),
(14374, 'US-NY-109746', 'Corning', 'CI', 4200, 42.08430000000, -77.02780000000, '109746'),
(14375, 'US-IL-109747', 'Sibley', 'CI', 4180, 40.56630000000, -88.38480000000, '109747'),
(14376, 'US-NY-109748', 'Remsen', 'CI', 4200, 43.34530000000, -75.12850000000, '109748'),
(14377, 'US-NE-109749', 'Merna', 'CI', 4195, 41.48920000000, -99.85690000000, '109749'),
(14378, 'US-CT-109750', 'Washington', 'CI', 4171, 41.63550000000, -73.29720000000, '109750'),
(14379, 'US-NC-109751', 'Youngsville', 'CI', 4201, 35.99480000000, -78.44050000000, '109751'),
(14380, 'US-VA-109752', 'Linden', 'CI', 4218, 38.91880000000, -78.03990000000, '109752'),
(14381, 'US-VA-109753', 'Luray', 'CI', 4218, 38.65900000000, -78.45150000000, '109753'),
(14382, 'US-PA-109754', 'Duncansville', 'CI', 4208, 40.41710000000, -78.48990000000, '109754'),
(14383, 'US-NC-109755', 'Madison', 'CI', 4201, 36.37020000000, -79.96800000000, '109755'),
(14384, 'US-VA-109756', 'Chatham', 'CI', 4218, 36.83850000000, -79.43340000000, '109756'),
(14385, 'US-KY-109757', 'Shelby Gap', 'CI', 4184, 37.23580000000, -82.53510000000, '109757'),
(14386, 'US-OH-109758', 'Niles', 'CI', 4204, 41.18510000000, -80.74220000000, '109758'),
(14387, 'US-OH-109759', 'Ashland', 'CI', 4204, 40.86840000000, -82.31490000000, '109759'),
(14388, 'US-PA-109760', 'Morgan', 'CI', 4208, 40.35180000000, -80.14800000000, '109760'),
(14389, 'US-OH-109761', 'Hannibal', 'CI', 4204, 39.66480000000, -80.87750000000, '109761'),
(14390, 'US-OH-109762', 'Beverly', 'CI', 4204, 39.60680000000, -81.62460000000, '109762'),
(14391, 'US-WV-109763', 'Keyser', 'CI', 4220, 39.45300000000, -78.94940000000, '109763'),
(14392, 'US-MD-109764', 'Temple Hills', 'CI', 4188, 38.81790000000, -76.94250000000, '109764'),
(14393, 'US-PA-109765', 'Waynesboro', 'CI', 4208, 39.79360000000, -77.59800000000, '109765'),
(14394, 'US-TX-109766', 'Cedar Hill', 'CI', 4214, 32.59010000000, -96.96760000000, '109766'),
(14395, 'US-VA-109767', 'Great Falls', 'CI', 4218, 39.00400000000, -77.30310000000, '109767'),
(14396, 'US-VA-109768', 'New Market', 'CI', 4218, 38.63780000000, -78.67840000000, '109768'),
(14397, 'US-MD-109769', 'Fork', 'CI', 4188, 39.47100000000, -76.44830000000, '109769'),
(14398, 'US-OH-109770', 'Newbury', 'CI', 4204, 41.46240000000, -81.24390000000, '109770'),
(14399, 'US-PA-109771', 'Pen Argyl', 'CI', 4208, 40.84380000000, -75.25580000000, '109771'),
(14400, 'US-NC-109772', 'Franklin', 'CI', 4201, 35.18330000000, -83.43070000000, '109772'),
(14401, 'US-SC-109773', 'Johnsonville', 'CI', 4211, 33.85660000000, -79.46100000000, '109773'),
(14402, 'US-PA-109774', 'Spring House', 'CI', 4208, 40.18590000000, -75.23240000000, '109774'),
(14403, 'US-CA-109775', 'Marysville', 'CI', 4169, 39.15870000000, -121.47260000000, '109775'),
(14404, 'US-IN-109776', 'Millersburg', 'CI', 4181, 41.53740000000, -85.68320000000, '109776'),
(14405, 'US-IN-109777', 'Auburn', 'CI', 4181, 41.33460000000, -85.02170000000, '109777'),
(14406, 'US-IN-109778', 'Culver', 'CI', 4181, 41.21400000000, -86.42620000000, '109778'),
(14407, 'US-TX-109779', 'Sulphur Springs', 'CI', 4214, 33.14820000000, -95.59960000000, '109779'),
(14408, 'US-MI-109780', 'Sawyer', 'CI', 4190, 41.89260000000, -86.57230000000, '109780'),
(14409, 'US-LA-109781', 'Columbia', 'CI', 4185, 32.08410000000, -91.98270000000, '109781'),
(14410, 'US-IN-109782', 'Walkerton', 'CI', 4181, 41.48350000000, -86.48520000000, '109782'),
(14411, 'US-VT-109783', 'Stamford', 'CI', 4216, 42.78830000000, -73.07880000000, '109783'),
(14412, 'US-MN-109784', 'Rosemount', 'CI', 4191, 44.72580000000, -93.06560000000, '109784'),
(14413, 'US-MN-109785', 'Delano', 'CI', 4191, 45.03670000000, -93.81660000000, '109785'),
(14414, 'US-MN-109786', 'Prinsburg', 'CI', 4191, 44.94940000000, -95.15630000000, '109786'),
(14415, 'US-MN-109787', 'Champlin', 'CI', 4191, 45.18030000000, -93.40170000000, '109787'),
(14416, 'US-MN-109788', 'Bemidji', 'CI', 4191, 47.50360000000, -94.68500000000, '109788'),
(14417, 'US-ND-109789', 'Carrington', 'CI', 4202, 47.43580000000, -99.05340000000, '109789'),
(14418, 'US-ND-109790', 'West Fargo', 'CI', 4202, 46.89140000000, -96.92940000000, '109790'),
(14419, 'US-MN-109791', 'Hill City', 'CI', 4191, 46.94940000000, -93.57740000000, '109791'),
(14420, 'US-MN-109792', 'Morgan', 'CI', 4191, 44.41640000000, -94.91170000000, '109792'),
(14421, 'US-CA-109793', 'Nevada City', 'CI', 4169, 39.34960000000, -120.87660000000, '109793'),
(14422, 'US-CT-109794', 'Litchfield', 'CI', 4171, 41.75590000000, -73.21540000000, '109794'),
(14423, 'US-CT-109795', 'Waterford', 'CI', 4171, 41.35950000000, -72.16020000000, '109795'),
(14424, 'US-MA-109796', 'Easthampton', 'CI', 4189, 42.29030000000, -72.64040000000, '109796'),
(14425, 'US-CT-109797', 'Plantsville', 'CI', 4171, 41.57660000000, -72.90070000000, '109797'),
(14426, 'US-KS-109798', 'Paola', 'CI', 4183, 38.57080000000, -94.88030000000, '109798'),
(14427, 'US-MO-109799', 'Bates City', 'CI', 4193, 38.95680000000, -94.06730000000, '109799'),
(14428, 'US-KS-109800', 'Eureka', 'CI', 4183, 37.87550000000, -96.29680000000, '109800'),
(14429, 'US-KS-109801', 'Oakley', 'CI', 4183, 39.04650000000, -100.85120000000, '109801'),
(14430, 'US-KS-109802', 'Phillipsburg', 'CI', 4183, 39.78470000000, -99.31170000000, '109802'),
(14431, 'US-KS-109803', 'Holton', 'CI', 4183, 39.47450000000, -95.69550000000, '109803'),
(14432, 'US-MO-109804', 'Buckner', 'CI', 4193, 39.11700000000, -94.21180000000, '109804'),
(14433, 'US-WA-109805', 'Snohomish', 'CI', 4219, 47.94020000000, -122.00620000000, '109805'),
(14434, 'US-MA-109806', 'Harvard', 'CI', 4189, 42.49900000000, -71.57760000000, '109806'),
(14435, 'US-IL-109807', 'Willow Springs', 'CI', 4180, 41.74030000000, -87.86200000000, '109807'),
(14436, 'US-IL-109808', 'Darien', 'CI', 4180, 41.74010000000, -87.98800000000, '109808'),
(14437, 'US-DE-109809', 'Clayton', 'CI', 4172, 39.25820000000, -75.69090000000, '109809'),
(14438, 'US-DE-109810', 'Georgetown', 'CI', 4172, 38.66800000000, -75.39730000000, '109810'),
(14439, 'PR-??-109811', 'Toa Alta', 'CI', 181, 18.36100000000, -66.25340000000, '109811'),
(14440, 'PR-??-109812', 'Naguabo', 'CI', 181, 18.23530000000, -65.74450000000, '109812'),
(14441, 'PR-??-109813', 'Hatillo', 'CI', 181, 18.40700000000, -66.80180000000, '109813'),
(14442, 'PR-??-109814', 'Ponce', 'CI', 181, 17.97990000000, -66.64810000000, '109814'),
(14443, 'US-CA-109815', 'Tehachapi', 'CI', 4169, 35.12930000000, -118.51100000000, '109815'),
(14444, 'US-CA-109816', 'Valley Village', 'CI', 4169, 34.16480000000, -118.40080000000, '109816'),
(14445, 'US-NM-109817', 'Eunice', 'CI', 4199, 32.43140000000, -103.39380000000, '109817'),
(14446, 'US-NM-109818', 'Pecos', 'CI', 4199, 35.65870000000, -105.61300000000, '109818'),
(14447, 'US-NM-109819', 'Loving', 'CI', 4199, 32.28600000000, -103.97190000000, '109819'),
(14448, 'US-CO-109820', 'Pueblo', 'CI', 4170, 38.09340000000, -104.66520000000, '109820'),
(14449, 'US-FL-109821', 'Key West', 'CI', 4175, 24.58570000000, -81.68100000000, '109821'),
(14450, 'US-TN-109822', 'Ripley', 'CI', 4213, 35.73280000000, -89.65930000000, '109822'),
(14451, 'US-CA-109823', 'Arroyo Grande', 'CI', 4169, 35.16650000000, -120.43760000000, '109823'),
(14452, 'US-AR-109824', 'Little Rock Air Force Base', 'CI', 4165, 34.78800000000, -92.21730000000, '109824'),
(14453, 'US-IL-109825', 'Flat Rock', 'CI', 4180, 38.86820000000, -87.66580000000, '109825'),
(14454, 'US-CT-109826', 'Middlebury', 'CI', 4171, 41.52890000000, -73.11750000000, '109826'),
(14455, 'US-PA-109827', 'New Alexandria', 'CI', 4208, 40.42340000000, -79.42980000000, '109827'),
(14456, 'US-CA-109828', 'Pacoima', 'CI', 4169, 34.25720000000, -118.41950000000, '109828'),
(14457, 'US-FL-109829', 'Cocoa', 'CI', 4175, 28.39040000000, -80.82330000000, '109829'),
(14458, 'US-FL-109830', 'Palm Coast', 'CI', 4175, 29.57060000000, -81.21750000000, '109830'),
(14459, 'US-GA-109831', 'Townsend', 'CI', 4176, 31.51120000000, -81.45290000000, '109831'),
(14460, 'US-UT-109832', 'New Harmony', 'CI', 4215, 37.38630000000, -113.32450000000, '109832'),
(14461, 'US-ID-109833', 'Challis', 'CI', 4179, 44.65200000000, -114.15430000000, '109833'),
(14462, 'US-NV-109834', 'Mc Dermitt', 'CI', 4196, 41.99080000000, -117.71280000000, '109834'),
(14463, 'US-ID-109835', 'Hamer', 'CI', 4179, 43.98550000000, -112.18110000000, '109835'),
(14464, 'US-NV-109836', 'Crescent Valley', 'CI', 4196, 40.52790000000, -116.36730000000, '109836'),
(14465, 'US-UT-109837', 'Magna', 'CI', 4215, 40.70530000000, -112.08480000000, '109837'),
(14466, 'US-UT-109838', 'Plymouth', 'CI', 4215, 41.91970000000, -112.12270000000, '109838'),
(14467, 'US-CA-109839', 'Studio City', 'CI', 4169, 34.13790000000, -118.39190000000, '109839'),
(14468, 'US-MI-109840', 'Center Line', 'CI', 4190, 42.48020000000, -83.02860000000, '109840'),
(14469, 'US-AZ-109841', 'Kingman', 'CI', 4164, 35.24810000000, -113.76400000000, '109841'),
(14470, 'US-AZ-109842', 'Paradise Valley', 'CI', 4164, 33.54220000000, -111.96790000000, '109842'),
(14471, 'US-CA-109843', 'Bolinas', 'CI', 4169, 37.94690000000, -122.73210000000, '109843'),
(14472, 'US-TX-109844', 'Florence', 'CI', 4214, 30.83960000000, -97.79530000000, '109844'),
(14473, 'US-PA-109845', 'Swiftwater', 'CI', 4208, 41.08950000000, -75.33460000000, '109845'),
(14474, 'US-PA-109846', 'Pittston', 'CI', 4208, 41.36560000000, -75.83960000000, '109846'),
(14475, 'US-PA-109847', 'Lehighton', 'CI', 4208, 40.79990000000, -75.73390000000, '109847'),
(14476, 'US-PA-109848', 'Lakeville', 'CI', 4208, 41.42150000000, -75.25570000000, '109848'),
(14477, 'US-PA-109849', 'Luzerne', 'CI', 4208, 41.28630000000, -75.89530000000, '109849'),
(14478, 'US-PA-109850', 'Honesdale', 'CI', 4208, 41.62940000000, -75.24240000000, '109850'),
(14479, 'US-TX-109851', 'Brackettville', 'CI', 4214, 29.36780000000, -100.41450000000, '109851'),
(14480, 'US-NY-109852', 'Pomona', 'CI', 4200, 41.18930000000, -74.07120000000, '109852'),
(14481, 'US-NY-109853', 'Monroe', 'CI', 4200, 41.32180000000, -74.20080000000, '109853'),
(14482, 'US-NY-109854', 'West Islip', 'CI', 4200, 40.71280000000, -73.29620000000, '109854'),
(14483, 'US-NY-109855', 'Pawling', 'CI', 4200, 41.58100000000, -73.59100000000, '109855'),
(14484, 'US-NY-109856', 'Saugerties', 'CI', 4200, 42.09780000000, -73.99670000000, '109856'),
(14485, 'US-NY-109857', 'Islandia', 'CI', 4200, 40.80640000000, -73.17380000000, '109857'),
(14486, 'US-NY-109858', 'Rock Tavern', 'CI', 4200, 41.49270000000, -74.16100000000, '109858'),
(14487, 'US-NY-109859', 'Pelham', 'CI', 4200, 40.90500000000, -73.80570000000, '109859'),
(14488, 'US-TX-109860', 'Olmito', 'CI', 4214, 26.02630000000, -97.54030000000, '109860'),
(14489, 'US-TX-109861', 'George West', 'CI', 4214, 28.25270000000, -98.10740000000, '109861'),
(14490, 'US-FL-109862', 'New Smyrna Beach', 'CI', 4175, 28.99700000000, -81.05630000000, '109862'),
(14491, 'US-CO-109863', 'Lafayette', 'CI', 4170, 40.01530000000, -105.10760000000, '109863'),
(14492, 'US-KS-109864', 'Riverton', 'CI', 4183, 37.08000000000, -94.71940000000, '109864'),
(14493, 'US-NY-109865', 'Westhampton Beach', 'CI', 4200, 40.83310000000, -72.64600000000, '109865'),
(14494, 'US-PA-109866', 'Montoursville', 'CI', 4208, 41.28750000000, -76.88010000000, '109866'),
(14495, 'US-OH-109867', 'Shreve', 'CI', 4204, 40.68040000000, -82.02950000000, '109867'),
(14496, 'US-OH-109868', 'Newton Falls', 'CI', 4204, 41.17640000000, -80.96850000000, '109868'),
(14497, 'US-OH-109869', 'Rittman', 'CI', 4204, 40.95950000000, -81.77260000000, '109869'),
(14498, 'US-VA-109870', 'Honaker', 'CI', 4218, 37.03670000000, -81.99470000000, '109870'),
(14499, 'US-WV-109871', 'Union', 'CI', 4220, 37.58780000000, -80.50710000000, '109871'),
(14500, 'US-IL-109872', 'Greenfield', 'CI', 4180, 39.35890000000, -90.25020000000, '109872'),
(14501, 'US-MI-109873', 'Thompsonville', 'CI', 4190, 44.52320000000, -85.94090000000, '109873'),
(14502, 'US-MI-109874', 'Hamilton', 'CI', 4190, 42.69180000000, -85.99310000000, '109874'),
(14503, 'US-KY-109875', 'Prospect', 'CI', 4184, 38.37720000000, -85.58230000000, '109875'),
(14504, 'US-TX-109876', 'Floresville', 'CI', 4214, 29.11910000000, -98.17330000000, '109876'),
(14505, 'US-TX-109877', 'Fort Davis', 'CI', 4214, 30.75870000000, -103.92490000000, '109877'),
(14506, 'US-TX-109878', 'Bulverde', 'CI', 4214, 29.76380000000, -98.46130000000, '109878'),
(14507, 'US-TX-109879', 'Penwell', 'CI', 4214, 31.73500000000, -102.59020000000, '109879'),
(14508, 'US-CA-109880', 'Winchester', 'CI', 4169, 33.63360000000, -117.07050000000, '109880'),
(14509, 'US-MI-109881', 'Mears', 'CI', 4190, 43.69010000000, -86.46920000000, '109881'),
(14510, 'US-CA-109882', 'Willits', 'CI', 4169, 39.49710000000, -123.36600000000, '109882'),
(14511, 'US-CA-109883', 'Bodega Bay', 'CI', 4169, 38.35580000000, -123.06290000000, '109883'),
(14512, 'US-CA-109884', 'Cloverdale', 'CI', 4169, 38.78270000000, -122.92320000000, '109884'),
(14513, 'US-AR-109885', 'Greenbrier', 'CI', 4165, 35.25180000000, -92.36770000000, '109885'),
(14514, 'US-NE-109886', 'Arapahoe', 'CI', 4195, 40.37440000000, -99.88120000000, '109886'),
(14515, 'US-MO-109887', 'Wentzville', 'CI', 4193, 38.79000000000, -90.85490000000, '109887'),
(14516, 'US-MO-109888', 'Saint Robert', 'CI', 4193, 37.83340000000, -92.12490000000, '109888'),
(14517, 'US-IL-109889', 'Baylis', 'CI', 4180, 39.78020000000, -90.86890000000, '109889'),
(14518, 'US-MO-109890', 'Rolla', 'CI', 4193, 37.92650000000, -91.77910000000, '109890'),
(14519, 'US-NJ-109891', 'Jobstown', 'CI', 4198, 40.03640000000, -74.68420000000, '109891'),
(14520, 'US-WA-109892', 'Colville', 'CI', 4219, 48.67910000000, -117.75270000000, '109892'),
(14521, 'US-OH-109893', 'Rockford', 'CI', 4204, 40.67370000000, -84.65790000000, '109893'),
(14522, 'US-MS-109894', 'Ackerman', 'CI', 4192, 33.32900000000, -89.21190000000, '109894'),
(14523, 'US-KY-109895', 'Cynthiana', 'CI', 4184, 38.43020000000, -84.29040000000, '109895'),
(14524, 'US-OH-109896', 'Liberty Center', 'CI', 4204, 41.45160000000, -83.97970000000, '109896'),
(14525, 'US-CA-109897', 'Sonora', 'CI', 4169, 37.98430000000, -120.39000000000, '109897'),
(14526, 'US-PA-109898', 'Duquesne', 'CI', 4208, 40.37300000000, -79.85320000000, '109898'),
(14527, 'US-PA-109899', 'Grove City', 'CI', 4208, 41.16600000000, -80.06150000000, '109899'),
(14528, 'US-KY-109900', 'Lewisport', 'CI', 4184, 37.89510000000, -86.88400000000, '109900'),
(14529, 'US-IN-109901', 'Oakland City', 'CI', 4181, 38.29670000000, -87.32130000000, '109901'),
(14530, 'US-KY-109902', 'Whitley City', 'CI', 4184, 36.78640000000, -84.47200000000, '109902'),
(14531, 'US-IA-109903', 'Adel', 'CI', 4182, 41.62590000000, -94.04270000000, '109903'),
(14532, 'US-KY-109904', 'Danville', 'CI', 4184, 37.64540000000, -84.81710000000, '109904'),
(14533, 'US-KY-109905', 'Columbia', 'CI', 4184, 37.11870000000, -85.29060000000, '109905'),
(14534, 'US-KY-109906', 'Stanford', 'CI', 4184, 37.51590000000, -84.68160000000, '109906'),
(14535, 'US-IN-109907', 'Sellersburg', 'CI', 4181, 38.40040000000, -85.77250000000, '109907'),
(14536, 'US-NJ-109908', 'Lake Hopatcong', 'CI', 4198, 40.96770000000, -74.60800000000, '109908'),
(14537, 'US-NJ-109909', 'Flanders', 'CI', 4198, 40.84780000000, -74.70970000000, '109909'),
(14538, 'US-PA-109910', 'Ransom', 'CI', 4208, 41.39400000000, -75.82460000000, '109910'),
(14539, 'US-TX-109911', 'Seminole', 'CI', 4214, 32.72610000000, -102.64440000000, '109911'),
(14540, 'US-NJ-109912', 'Hamburg', 'CI', 4198, 41.15020000000, -74.57140000000, '109912'),
(14541, 'US-NV-109913', 'Fernley', 'CI', 4196, 39.66880000000, -119.06870000000, '109913'),
(14542, 'US-VA-109914', 'Parksley', 'CI', 4218, 37.77170000000, -75.63350000000, '109914'),
(14543, 'US-VA-109915', 'Kinsale', 'CI', 4218, 38.04160000000, -76.58520000000, '109915'),
(14544, 'US-CA-109916', 'Calabasas', 'CI', 4169, 34.11820000000, -118.67390000000, '109916'),
(14545, 'US-OR-109917', 'Condon', 'CI', 4206, 45.28550000000, -120.15770000000, '109917'),
(14546, 'US-IA-109918', 'Sheffield', 'CI', 4182, 42.87720000000, -93.21280000000, '109918'),
(14547, 'US-NJ-109919', 'Lincoln Park', 'CI', 4198, 40.92720000000, -74.30390000000, '109919'),
(14548, 'US-MD-109920', 'Monrovia', 'CI', 4188, 39.34620000000, -77.26070000000, '109920'),
(14549, 'US-NJ-109921', 'Franklin Lakes', 'CI', 4198, 41.01120000000, -74.20810000000, '109921'),
(14550, 'US-NJ-109922', 'Ho Ho Kus', 'CI', 4198, 40.99910000000, -74.09920000000, '109922'),
(14551, 'US-NJ-109923', 'Dumont', 'CI', 4198, 40.94670000000, -73.99300000000, '109923'),
(14552, 'US-NJ-109924', 'Hewitt', 'CI', 4198, 41.16610000000, -74.38230000000, '109924'),
(14553, 'US-TX-109925', 'Mansfield', 'CI', 4214, 32.57020000000, -97.13130000000, '109925'),
(14554, 'US-IA-109926', 'Rock Rapids', 'CI', 4182, 43.40800000000, -96.14930000000, '109926'),
(14555, 'US-IA-109927', 'Keota', 'CI', 4182, 41.35670000000, -91.91810000000, '109927'),
(14556, 'US-TX-109928', 'Breckenridge', 'CI', 4214, 32.76470000000, -98.85330000000, '109928'),
(14557, 'US-CO-109929', 'Watkins', 'CI', 4170, 39.72500000000, -104.58590000000, '109929'),
(14558, 'US-CO-109930', 'Glenwood Springs', 'CI', 4170, 39.58460000000, -107.30160000000, '109930'),
(14559, 'US-PA-109931', 'New Kingstown', 'CI', 4208, 40.26980000000, -76.98410000000, '109931'),
(14560, 'US-PA-109932', 'Blue Ball', 'CI', 4208, 40.11640000000, -76.05040000000, '109932'),
(14561, 'US-CO-109933', 'Fort Morgan', 'CI', 4170, 40.05980000000, -103.85840000000, '109933'),
(14562, 'US-CA-109934', 'Anza', 'CI', 4169, 33.53250000000, -116.68150000000, '109934'),
(14563, 'US-TX-109935', 'Hawkins', 'CI', 4214, 32.62890000000, -95.24820000000, '109935'),
(14564, 'US-TX-109936', 'Lillian', 'CI', 4214, 32.50390000000, -97.19070000000, '109936'),
(14565, 'US-IA-109937', 'Clarion', 'CI', 4182, 42.71760000000, -93.74970000000, '109937'),
(14566, 'US-NC-109938', 'Newton', 'CI', 4201, 35.63480000000, -81.23910000000, '109938'),
(14567, 'US-IA-109939', 'Winterset', 'CI', 4182, 41.35160000000, -94.05140000000, '109939'),
(14568, 'US-NJ-109940', 'Rumson', 'CI', 4198, 40.35920000000, -74.00640000000, '109940'),
(14569, 'US-NY-109941', 'Dunkirk', 'CI', 4200, 42.48170000000, -79.32820000000, '109941'),
(14570, 'US-TX-109942', 'New Waverly', 'CI', 4214, 30.55190000000, -95.43110000000, '109942'),
(14571, 'US-PA-109943', 'Mount Pocono', 'CI', 4208, 41.11890000000, -75.33890000000, '109943'),
(14572, 'US-LA-109944', 'Westlake', 'CI', 4185, 30.24130000000, -93.26900000000, '109944'),
(14573, 'US-TX-109945', 'Porter', 'CI', 4214, 30.10940000000, -95.25190000000, '109945'),
(14574, 'US-IA-109946', 'Ankeny', 'CI', 4182, 41.72480000000, -93.60170000000, '109946'),
(14575, 'US-TX-109947', 'Lufkin', 'CI', 4214, 31.26710000000, -94.64670000000, '109947'),
(14576, 'US-TX-109948', 'Nacogdoches', 'CI', 4214, 31.73010000000, -94.47850000000, '109948'),
(14577, 'US-TX-109949', 'Woodville', 'CI', 4214, 30.78480000000, -94.37230000000, '109949'),
(14578, 'US-TX-109950', 'Silsbee', 'CI', 4214, 30.46110000000, -94.16110000000, '109950'),
(14579, 'US-MA-109951', 'Newton Lower Falls', 'CI', 4189, 42.33290000000, -71.25960000000, '109951'),
(14580, 'US-CT-109952', 'Storrs Mansfield', 'CI', 4171, 41.79110000000, -72.25340000000, '109952'),
(14581, 'US-ME-109953', 'Presque Isle', 'CI', 4186, 46.68850000000, -67.99110000000, '109953'),
(14582, 'US-ME-109954', 'Princeton', 'CI', 4186, 45.18440000000, -67.62040000000, '109954'),
(14583, 'US-ME-109955', 'Parsonsfield', 'CI', 4186, 43.74210000000, -70.91410000000, '109955'),
(14584, 'US-ME-109956', 'Bridgton', 'CI', 4186, 44.03360000000, -70.75700000000, '109956'),
(14585, 'US-ME-109957', 'Pittsfield', 'CI', 4186, 44.76950000000, -69.42830000000, '109957'),
(14586, 'US-ME-109958', 'Biddeford', 'CI', 4186, 43.49610000000, -70.48860000000, '109958'),
(14587, 'US-ME-109959', 'Dexter', 'CI', 4186, 45.02920000000, -69.31640000000, '109959'),
(14588, 'US-TX-109960', 'Magnolia', 'CI', 4214, 30.20350000000, -95.66330000000, '109960'),
(14589, 'US-WA-109961', 'Oak Harbor', 'CI', 4219, 48.32180000000, -122.63050000000, '109961'),
(14590, 'US-WA-109962', 'Marysville', 'CI', 4219, 48.05850000000, -122.14820000000, '109962'),
(14591, 'US-OR-109963', 'Philomath', 'CI', 4206, 44.59110000000, -123.46410000000, '109963'),
(14592, 'US-FL-109964', 'Rockledge', 'CI', 4175, 28.28160000000, -80.76450000000, '109964'),
(14593, 'US-TX-109965', 'Mount Pleasant', 'CI', 4214, 33.21760000000, -94.96730000000, '109965'),
(14594, 'US-WI-109966', 'Holcombe', 'CI', 4221, 45.22740000000, -91.04360000000, '109966'),
(14595, 'US-FL-109967', 'Seffner', 'CI', 4175, 28.00420000000, -82.29360000000, '109967'),
(14596, 'US-FL-109968', 'Venice', 'CI', 4175, 27.10190000000, -82.38260000000, '109968'),
(14598, 'US-CO-109970', 'Conifer', 'CI', 4170, 39.49940000000, -105.26090000000, '109970'),
(14599, 'US-MA-109971', 'Lanesboro', 'CI', 4189, 42.55840000000, -73.21970000000, '109971'),
(14600, 'US-MA-109972', 'Yarmouth Port', 'CI', 4189, 41.70720000000, -70.22990000000, '109972'),
(14601, 'US-OR-109973', 'Sutherlin', 'CI', 4206, 43.41590000000, -123.11340000000, '109973'),
(14602, 'US-MA-109974', 'Swansea', 'CI', 4189, 41.76610000000, -71.23460000000, '109974'),
(14603, 'US-MA-109975', 'Orleans', 'CI', 4189, 41.74570000000, -69.97530000000, '109975'),
(14604, 'US-MA-109976', 'Centerville', 'CI', 4189, 41.65620000000, -70.34930000000, '109976'),
(14605, 'US-RI-109977', 'West Greenwich', 'CI', 4210, 41.62980000000, -71.66770000000, '109977'),
(14606, 'US-KS-109978', 'Newton', 'CI', 4183, 38.10090000000, -97.24690000000, '109978'),
(14607, 'US-CA-109979', 'El Sobrante', 'CI', 4169, 37.95580000000, -122.26890000000, '109979'),
(14608, 'US-CA-109980', 'San Pablo', 'CI', 4169, 37.98090000000, -122.33320000000, '109980'),
(14609, 'US-CO-109981', 'Estes Park', 'CI', 4170, 40.39740000000, -105.62340000000, '109981'),
(14610, 'US-CO-109982', 'Somerset', 'CI', 4170, 38.97850000000, -107.32000000000, '109982'),
(14611, 'US-MA-109983', 'South Deerfield', 'CI', 4189, 42.47640000000, -72.62640000000, '109983'),
(14612, 'US-LA-109984', 'Pine Grove', 'CI', 4185, 30.68260000000, -90.76360000000, '109984'),
(14613, 'US-MD-109985', 'Chesapeake City', 'CI', 4188, 39.49790000000, -75.85040000000, '109985'),
(14614, 'US-MD-109986', 'Sudlersville', 'CI', 4188, 39.19490000000, -75.86430000000, '109986'),
(14615, 'US-PA-109987', 'Everett', 'CI', 4208, 39.96300000000, -78.39770000000, '109987'),
(14616, 'US-ID-109988', 'Craigmont', 'CI', 4179, 46.23060000000, -116.48910000000, '109988'),
(14617, 'US-WA-109989', 'Ritzville', 'CI', 4219, 47.07960000000, -118.47050000000, '109989'),
(14618, 'US-MT-109990', 'Jefferson City', 'CI', 4194, 46.38390000000, -112.05930000000, '109990'),
(14619, 'US-ID-109991', 'Moyie Springs', 'CI', 4179, 48.70780000000, -116.12630000000, '109991'),
(14620, 'US-ID-109992', 'Ketchum', 'CI', 4179, 43.77700000000, -114.62510000000, '109992'),
(14621, 'US-ID-109993', 'Kendrick', 'CI', 4179, 46.64110000000, -116.54230000000, '109993'),
(14622, 'US-WA-109994', 'Newport', 'CI', 4219, 48.15540000000, -117.24030000000, '109994'),
(14623, 'US-IL-109995', 'Algonquin', 'CI', 4180, 42.16170000000, -88.32850000000, '109995'),
(14624, 'US-KS-109996', 'Bushton', 'CI', 4183, 38.50720000000, -98.39650000000, '109996'),
(14625, 'US-KY-109997', 'Prestonsburg', 'CI', 4184, 37.65760000000, -82.75480000000, '109997'),
(14626, 'US-KY-109998', 'Jenkins', 'CI', 4184, 37.22970000000, -82.61640000000, '109998'),
(14627, 'US-KY-109999', 'Ivel', 'CI', 4184, 37.59420000000, -82.65210000000, '109999'),
(14628, 'US-VA-110000', 'Locust Dale', 'CI', 4218, 38.37970000000, -78.12310000000, '110000'),
(14629, 'US-MD-110001', 'Poolesville', 'CI', 4188, 39.12370000000, -77.40510000000, '110001'),
(14630, 'US-TX-110002', 'Lissie', 'CI', 4214, 29.53530000000, -96.23040000000, '110002'),
(14631, 'US-TX-110003', 'Dyess Afb', 'CI', 4214, 32.41900000000, -99.83790000000, '110003'),
(14632, 'US-TX-110004', 'Weatherford', 'CI', 4214, 32.75460000000, -97.78760000000, '110004'),
(14633, 'US-OH-110005', 'Hopedale', 'CI', 4204, 40.36550000000, -80.91160000000, '110005'),
(14634, 'US-TX-110006', 'Henrietta', 'CI', 4214, 33.72070000000, -98.18440000000, '110006'),
(14635, 'US-WI-110007', 'Dodgeville', 'CI', 4221, 42.99760000000, -90.13310000000, '110007'),
(14636, 'US-TX-110008', 'Baird', 'CI', 4214, 32.29760000000, -99.30570000000, '110008'),
(14637, 'US-IL-110009', 'Berkeley', 'CI', 4180, 41.88640000000, -87.90190000000, '110009'),
(14638, 'US-IL-110010', 'Lyons', 'CI', 4180, 41.81280000000, -87.82130000000, '110010'),
(14639, 'US-AZ-110011', 'Sahuarita', 'CI', 4164, 31.91020000000, -110.89960000000, '110011'),
(14640, 'US-AZ-110012', 'Clarkdale', 'CI', 4164, 34.79170000000, -112.10640000000, '110012'),
(14641, 'US-AZ-110013', 'Pinetop', 'CI', 4164, 34.08480000000, -109.90870000000, '110013'),
(14642, 'US-AZ-110014', 'Oracle', 'CI', 4164, 32.64180000000, -110.83970000000, '110014'),
(14643, 'US-CT-110015', 'Broad Brook', 'CI', 4171, 41.90680000000, -72.55160000000, '110015'),
(14644, 'US-CT-110016', 'Taftville', 'CI', 4171, 41.56910000000, -72.05450000000, '110016'),
(14645, 'US-ME-110017', 'Poland', 'CI', 4186, 44.04520000000, -70.38710000000, '110017'),
(14646, 'US-NC-110018', 'Alexander', 'CI', 4201, 35.69020000000, -82.64760000000, '110018'),
(14647, 'US-VA-110019', 'Farmville', 'CI', 4218, 37.29810000000, -78.40440000000, '110019'),
(14648, 'US-GA-110020', 'Ringgold', 'CI', 4176, 34.89140000000, -85.12070000000, '110020'),
(14649, 'US-IN-110021', 'Decatur', 'CI', 4181, 40.83210000000, -84.94510000000, '110021'),
(14650, 'US-IN-110022', 'Wabash', 'CI', 4181, 40.74140000000, -85.79360000000, '110022'),
(14651, 'US-IN-110023', 'Nappanee', 'CI', 4181, 41.44190000000, -85.99230000000, '110023'),
(14652, 'US-IN-110024', 'New Haven', 'CI', 4181, 41.10220000000, -84.97800000000, '110024'),
(14653, 'US-MI-110025', 'Grand Ledge', 'CI', 4190, 42.75120000000, -84.76910000000, '110025'),
(14654, 'US-MI-110026', 'White Cloud', 'CI', 4190, 43.58710000000, -85.75600000000, '110026'),
(14655, 'US-MI-110027', 'Marshall', 'CI', 4190, 42.26070000000, -84.94410000000, '110027'),
(14656, 'US-IN-110028', 'Hanover', 'CI', 4181, 38.66690000000, -85.48430000000, '110028'),
(14657, 'US-IN-110029', 'Bunker Hill', 'CI', 4181, 40.63600000000, -86.09000000000, '110029'),
(14658, 'US-MN-110030', 'Cannon Falls', 'CI', 4191, 44.47950000000, -92.87270000000, '110030'),
(14659, 'US-WI-110031', 'Menomonie', 'CI', 4221, 44.84710000000, -92.00090000000, '110031'),
(14660, 'US-IN-110032', 'Lakeville', 'CI', 4181, 41.51260000000, -86.28480000000, '110032'),
(14661, 'US-WI-110033', 'Maiden Rock', 'CI', 4221, 44.63150000000, -92.28090000000, '110033'),
(14662, 'US-WI-110034', 'Hudson', 'CI', 4221, 44.98220000000, -92.69950000000, '110034'),
(14663, 'US-MN-110035', 'Saint James', 'CI', 4191, 43.99680000000, -94.64410000000, '110035'),
(14664, 'US-MN-110036', 'Marine On Saint Croix', 'CI', 4191, 45.19580000000, -92.82570000000, '110036'),
(14665, 'US-OH-110037', 'Oak Harbor', 'CI', 4204, 41.55750000000, -83.15100000000, '110037'),
(14666, 'US-NE-110038', 'Falls City', 'CI', 4195, 40.13100000000, -95.57230000000, '110038'),
(14667, 'US-TX-110039', 'Hempstead', 'CI', 4214, 30.06120000000, -96.07040000000, '110039'),
(14668, 'US-KS-110040', 'Wakarusa', 'CI', 4183, 38.89160000000, -95.74190000000, '110040'),
(14669, 'US-MN-110041', 'Maple Plain', 'CI', 4191, 44.99090000000, -93.68310000000, '110041'),
(14670, 'US-MN-110042', 'Thief River Falls', 'CI', 4191, 48.14640000000, -96.17650000000, '110042'),
(14672, 'US-OH-110044', 'Harrison', 'CI', 4204, 39.24860000000, -84.73130000000, '110044'),
(14673, 'US-PA-110045', 'Townville', 'CI', 4208, 41.67650000000, -79.89630000000, '110045'),
(14674, 'US-OH-110046', 'Bloomingdale', 'CI', 4204, 40.37880000000, -80.79450000000, '110046'),
(14675, 'US-AL-110047', 'Abbeville', 'CI', 4161, 31.59510000000, -85.21080000000, '110047'),
(14676, 'US-AL-110048', 'Moody', 'CI', 4161, 33.60630000000, -86.49160000000, '110048'),
(14677, 'US-OK-110049', 'Perkins', 'CI', 4205, 35.91450000000, -97.05210000000, '110049'),
(14678, 'US-PA-110050', 'Wampum', 'CI', 4208, 40.89610000000, -80.33530000000, '110050'),
(14679, 'US-TX-110051', 'Miles', 'CI', 4214, 31.57680000000, -100.18230000000, '110051'),
(14680, 'US-PA-110052', 'Charleroi', 'CI', 4208, 40.13570000000, -79.93450000000, '110052'),
(14681, 'US-TX-110053', 'Weimar', 'CI', 4214, 29.63710000000, -96.72530000000, '110053'),
(14682, 'US-TX-110054', 'Deanville', 'CI', 4214, 30.43140000000, -96.75720000000, '110054'),
(14683, 'US-TX-110055', 'Caldwell', 'CI', 4214, 30.55500000000, -96.69190000000, '110055'),
(14684, 'US-TX-110056', 'Elgin', 'CI', 4214, 30.33680000000, -97.34460000000, '110056'),
(14685, 'US-TX-110057', 'Schulenburg', 'CI', 4214, 29.67910000000, -96.93570000000, '110057'),
(14686, 'US-KS-110058', 'Eudora', 'CI', 4183, 38.88380000000, -95.08410000000, '110058'),
(14687, 'US-KS-110059', 'Sabetha', 'CI', 4183, 39.86690000000, -95.83590000000, '110059'),
(14688, 'US-KS-110060', 'Hays', 'CI', 4183, 38.90010000000, -99.34700000000, '110060'),
(14689, 'US-LA-110061', 'Fort Polk', 'CI', 4185, 31.10730000000, -93.18080000000, '110061'),
(14690, 'US-OK-110062', 'Claremore', 'CI', 4205, 36.35550000000, -95.60290000000, '110062'),
(14691, 'US-KS-110063', 'Burden', 'CI', 4183, 37.29910000000, -96.78690000000, '110063'),
(14692, 'US-KS-110064', 'Coffeyville', 'CI', 4183, 37.07300000000, -95.61840000000, '110064'),
(14693, 'US-OK-110065', 'Altus', 'CI', 4205, 34.61820000000, -99.27320000000, '110065'),
(14694, 'US-PA-110066', 'East Berlin', 'CI', 4208, 39.97070000000, -77.01050000000, '110066'),
(14695, 'US-MO-110067', 'Pleasant Hill', 'CI', 4193, 38.75990000000, -94.26150000000, '110067'),
(14696, 'US-KS-110068', 'Rantoul', 'CI', 4183, 38.54280000000, -95.11990000000, '110068'),
(14697, 'US-OH-110069', 'Homerville', 'CI', 4204, 41.03420000000, -82.11220000000, '110069'),
(14698, 'US-NY-110070', 'North Babylon', 'CI', 4200, 40.73240000000, -73.32560000000, '110070'),
(14699, 'US-TX-110071', 'Somerset', 'CI', 4214, 29.18270000000, -98.68090000000, '110071'),
(14700, 'CA-BC-110072', 'Victoria', 'CI', 38, 48.43330000000, -123.35000000000, '110072'),
(14701, 'US-PA-110073', 'Bethel Park', 'CI', 4208, 40.32240000000, -80.03550000000, '110073'),
(14702, 'US-PA-110074', 'Sharon', 'CI', 4208, 41.23500000000, -80.49710000000, '110074'),
(14703, 'US-OH-110075', 'Bainbridge', 'CI', 4204, 39.21870000000, -83.26050000000, '110075'),
(14704, 'US-GA-110076', 'Sandersville', 'CI', 4176, 32.97520000000, -82.85750000000, '110076'),
(14705, 'US-TX-110077', 'Calvert', 'CI', 4214, 31.00140000000, -96.67190000000, '110077'),
(14706, 'US-OK-110078', 'Atoka', 'CI', 4205, 34.37260000000, -96.19180000000, '110078'),
(14707, 'US-PA-110079', 'Warfordsburg', 'CI', 4208, 39.83430000000, -78.25550000000, '110079'),
(14708, 'US-LA-110080', 'Pineville', 'CI', 4185, 31.28840000000, -92.38800000000, '110080'),
(14709, 'US-IN-110081', 'Orleans', 'CI', 4181, 38.59950000000, -86.35850000000, '110081'),
(14710, 'US-NC-110082', 'Old Fort', 'CI', 4201, 35.62840000000, -82.19590000000, '110082'),
(14711, 'US-TN-110083', 'Powell', 'CI', 4213, 36.06840000000, -84.01970000000, '110083'),
(14712, 'US-GA-110084', 'Dublin', 'CI', 4176, 32.46430000000, -82.94950000000, '110084'),
(14713, 'US-GA-110085', 'Griffin', 'CI', 4176, 33.20230000000, -84.23060000000, '110085'),
(14714, 'US-KY-110086', 'Murray', 'CI', 4184, 36.63550000000, -88.28300000000, '110086'),
(14715, 'US-MA-110087', 'South Easton', 'CI', 4189, 42.02620000000, -71.08450000000, '110087'),
(14716, 'US-IN-110088', 'Marengo', 'CI', 4181, 38.37180000000, -86.36770000000, '110088'),
(14717, 'US-VT-110089', 'Arlington', 'CI', 4216, 43.12170000000, -73.17540000000, '110089'),
(14718, 'US-IN-110090', 'Chandler', 'CI', 4181, 38.04470000000, -87.41210000000, '110090'),
(14719, 'US-FL-110091', 'Fort Walton Beach', 'CI', 4175, 30.42180000000, -86.62980000000, '110091'),
(14720, 'US-AL-110092', 'Fairhope', 'CI', 4161, 30.47980000000, -87.86580000000, '110092'),
(14721, 'US-MS-110093', 'Yazoo City', 'CI', 4192, 32.83420000000, -90.55530000000, '110093'),
(14722, 'US-FL-110094', 'Century', 'CI', 4175, 30.95370000000, -87.33360000000, '110094'),
(14723, 'US-MN-110095', 'Grand Meadow', 'CI', 4191, 43.71030000000, -92.57860000000, '110095'),
(14724, 'US-LA-110096', 'Cade', 'CI', 4185, 30.10510000000, -91.91360000000, '110096'),
(14725, 'US-LA-110097', 'Deville', 'CI', 4185, 31.35020000000, -92.19420000000, '110097'),
(14726, 'US-CA-110098', 'Jenner', 'CI', 4169, 38.51720000000, -123.21220000000, '110098'),
(14727, 'US-OH-110099', 'Amelia', 'CI', 4204, 39.01310000000, -84.20490000000, '110099'),
(14728, 'US-VA-110100', 'Chesterfield', 'CI', 4218, 37.31200000000, -77.63440000000, '110100'),
(14729, 'US-NH-110101', 'Hudson', 'CI', 4197, 42.76180000000, -71.41190000000, '110101'),
(14730, 'US-TX-110102', 'Diboll', 'CI', 4214, 31.19610000000, -94.74470000000, '110102'),
(14731, 'US-WV-110103', 'Ravenswood', 'CI', 4220, 38.98220000000, -81.70380000000, '110103'),
(14732, 'US-NY-110104', 'Feura Bush', 'CI', 4200, 42.54970000000, -73.92380000000, '110104'),
(14733, 'US-PA-110105', 'North East', 'CI', 4208, 42.17810000000, -79.84170000000, '110105'),
(14734, 'US-FL-110106', 'Seminole', 'CI', 4175, 27.85120000000, -82.75450000000, '110106'),
(14735, 'US-MS-110107', 'Pascagoula', 'CI', 4192, 30.35610000000, -88.49240000000, '110107'),
(14736, 'US-MS-110108', 'Fulton', 'CI', 4192, 34.27580000000, -88.32230000000, '110108'),
(14737, 'US-IA-110109', 'Indianola', 'CI', 4182, 41.30680000000, -93.58260000000, '110109'),
(14738, 'US-SC-110110', 'Ninety Six', 'CI', 4211, 34.11860000000, -81.99020000000, '110110'),
(14739, 'US-KY-110111', 'Liberty', 'CI', 4184, 37.30700000000, -84.95270000000, '110111'),
(14740, 'US-OH-110112', 'Cleves', 'CI', 4204, 39.20390000000, -84.72250000000, '110112'),
(14741, 'US-UT-110113', 'Tremonton', 'CI', 4215, 41.69560000000, -112.27590000000, '110113'),
(14742, 'US-MD-110114', 'Finksburg', 'CI', 4188, 39.49420000000, -76.91150000000, '110114'),
(14743, 'US-MD-110115', 'Hurlock', 'CI', 4188, 38.64020000000, -75.86720000000, '110115'),
(14744, 'US-IL-110116', 'Prospect Heights', 'CI', 4180, 42.10580000000, -87.87710000000, '110116'),
(14745, 'US-AL-110117', 'Alpine', 'CI', 4161, 33.34220000000, -86.22490000000, '110117'),
(14746, 'US-DE-110118', 'Lewes', 'CI', 4172, 38.72590000000, -75.16780000000, '110118'),
(14747, 'US-WV-110119', 'Walker', 'CI', 4220, 39.19450000000, -81.37090000000, '110119'),
(14748, 'US-VA-110120', 'Boston', 'CI', 4218, 38.54430000000, -78.13010000000, '110120'),
(14749, 'US-VA-110121', 'Nora', 'CI', 4218, 37.01370000000, -82.34050000000, '110121'),
(14750, 'US-OH-110122', 'Shelby', 'CI', 4204, 40.88850000000, -82.63960000000, '110122'),
(14751, 'US-PA-110123', 'Selinsgrove', 'CI', 4208, 40.81650000000, -76.88120000000, '110123'),
(14752, 'US-VA-110124', 'Clinchco', 'CI', 4218, 37.12890000000, -82.32810000000, '110124'),
(14753, 'US-NY-110125', 'Modena', 'CI', 4200, 41.66010000000, -74.11050000000, '110125'),
(14754, 'US-CA-110126', 'Capay', 'CI', 4169, 38.69040000000, -122.12830000000, '110126'),
(14755, 'US-AL-110127', 'Alexander City', 'CI', 4161, 32.90610000000, -85.93700000000, '110127'),
(14756, 'US-WA-110128', 'Kenmore', 'CI', 4219, 47.75420000000, -122.24440000000, '110128'),
(14757, 'US-CT-110129', 'East Lyme', 'CI', 4171, 41.38290000000, -72.23680000000, '110129'),
(14758, 'US-CA-110130', 'Fish Camp', 'CI', 4169, 37.47630000000, -119.66160000000, '110130'),
(14759, 'US-FL-110131', 'Lehigh Acres', 'CI', 4175, 26.60250000000, -81.62330000000, '110131'),
(14760, 'US-FL-110132', 'Pinellas Park', 'CI', 4175, 27.83860000000, -82.71660000000, '110132'),
(14761, 'US-TX-110133', 'Aransas Pass', 'CI', 4214, 27.97090000000, -97.15500000000, '110133'),
(14762, 'US-KS-110134', 'Junction City', 'CI', 4183, 38.96610000000, -96.76510000000, '110134'),
(14763, 'US-FL-110135', 'Bunnell', 'CI', 4175, 29.42540000000, -81.33840000000, '110135'),
(14764, 'US-FL-110136', 'Odessa', 'CI', 4175, 28.17640000000, -82.59540000000, '110136'),
(14765, 'US-FL-110137', 'Captiva', 'CI', 4175, 26.51670000000, -82.19190000000, '110137'),
(14766, 'US-VA-110138', 'Clintwood', 'CI', 4218, 37.16350000000, -82.43970000000, '110138'),
(14767, 'US-KY-110139', 'Morganfield', 'CI', 4184, 37.66230000000, -87.93170000000, '110139'),
(14768, 'US-FL-110140', 'Oldsmar', 'CI', 4175, 28.04440000000, -82.67950000000, '110140'),
(14769, 'US-FL-110141', 'Nokomis', 'CI', 4175, 27.17990000000, -82.38940000000, '110141'),
(14770, 'US-FL-110142', 'Dover', 'CI', 4175, 27.96710000000, -82.21780000000, '110142'),
(14771, 'US-FL-110143', 'Opa Locka', 'CI', 4175, 25.90420000000, -80.25580000000, '110143'),
(14772, 'US-IL-110144', 'New Baden', 'CI', 4180, 38.49200000000, -89.67360000000, '110144'),
(14773, 'US-VA-110145', 'Middletown', 'CI', 4218, 39.02550000000, -78.26960000000, '110145'),
(14774, 'US-FL-110146', 'Lake Placid', 'CI', 4175, 27.24190000000, -81.35640000000, '110146'),
(14775, 'US-FL-110147', 'Merritt Island', 'CI', 4175, 28.25190000000, -80.66070000000, '110147'),
(14776, 'US-SC-110148', 'Hampton', 'CI', 4211, 32.87360000000, -81.09440000000, '110148'),
(14777, 'US-CA-110149', 'Riverdale', 'CI', 4169, 36.48030000000, -119.94820000000, '110149'),
(14778, 'US-TX-110150', 'Aubrey', 'CI', 4214, 33.26370000000, -96.95280000000, '110150'),
(14779, 'US-OK-110151', 'Cleveland', 'CI', 4205, 36.25200000000, -96.41830000000, '110151'),
(14780, 'US-LA-110152', 'Port Allen', 'CI', 4185, 30.45950000000, -91.34280000000, '110152'),
(14781, 'US-AZ-110153', 'Arlington', 'CI', 4164, 33.18980000000, -112.79110000000, '110153'),
(14782, 'US-CA-110154', 'Murrieta', 'CI', 4169, 33.57890000000, -117.14120000000, '110154'),
(14783, 'US-CA-110155', 'Palos Verdes Peninsula', 'CI', 4169, 33.77320000000, -118.33980000000, '110155'),
(14784, 'US-CA-110156', 'Tupman', 'CI', 4169, 35.32000000000, -119.39520000000, '110156'),
(14785, 'US-TX-110157', 'Hutto', 'CI', 4214, 30.55430000000, -97.55200000000, '110157'),
(14786, 'US-CA-110158', 'Panorama City', 'CI', 4169, 34.22870000000, -118.44410000000, '110158'),
(14787, 'US-VA-110159', 'Marshall', 'CI', 4218, 38.83800000000, -77.89590000000, '110159'),
(14788, 'US-CA-110160', 'Laguna Beach', 'CI', 4169, 33.55580000000, -117.78580000000, '110160'),
(14789, 'US-PA-110161', 'Windber', 'CI', 4208, 40.22670000000, -78.77940000000, '110161'),
(14790, 'US-LA-110162', 'Saint Rose', 'CI', 4185, 29.97670000000, -90.31210000000, '110162'),
(14791, 'US-AL-110163', 'Foley', 'CI', 4161, 30.38800000000, -87.71990000000, '110163'),
(14792, 'US-LA-110164', 'Broussard', 'CI', 4185, 30.12030000000, -91.92790000000, '110164'),
(14793, 'US-TX-110165', 'El Campo', 'CI', 4214, 29.18860000000, -96.29730000000, '110165'),
(14794, 'US-IL-110166', 'Hampshire', 'CI', 4180, 42.06810000000, -88.50950000000, '110166'),
(14795, 'US-NY-110167', 'Worcester', 'CI', 4200, 42.59940000000, -74.72940000000, '110167'),
(14796, 'US-NY-110168', 'Martville', 'CI', 4200, 43.25740000000, -76.62070000000, '110168'),
(14797, 'US-PA-110169', 'Sayre', 'CI', 4208, 41.96420000000, -76.61600000000, '110169'),
(14798, 'US-NM-110170', 'Las Vegas', 'CI', 4199, 35.49880000000, -104.93700000000, '110170'),
(14799, 'US-NM-110171', 'Sunland Park', 'CI', 4199, 31.80700000000, -106.60020000000, '110171'),
(14800, 'US-NM-110172', 'Rio Rancho', 'CI', 4199, 35.24670000000, -106.72320000000, '110172'),
(14801, 'US-NM-110173', 'Casa Blanca', 'CI', 4199, 35.00300000000, -107.47480000000, '110173'),
(14802, 'US-NM-110174', 'Jemez Pueblo', 'CI', 4199, 35.64910000000, -106.73810000000, '110174'),
(14803, 'US-NM-110175', 'Mescalero', 'CI', 4199, 33.19720000000, -105.67770000000, '110175'),
(14804, 'US-NM-110176', 'Chama', 'CI', 4199, 36.86800000000, -106.61190000000, '110176'),
(14805, 'US-IL-110177', 'Sparta', 'CI', 4180, 38.11740000000, -89.72180000000, '110177'),
(14806, 'US-NM-110178', 'Clovis', 'CI', 4199, 34.50280000000, -103.27570000000, '110178'),
(14807, 'US-NM-110179', 'Los Alamos', 'CI', 4199, 35.83660000000, -106.30930000000, '110179'),
(14808, 'US-NM-110180', 'Zuni', 'CI', 4199, 35.08240000000, -108.75770000000, '110180'),
(14809, 'US-VA-110181', 'Keswick', 'CI', 4218, 38.03610000000, -78.33280000000, '110181'),
(14810, 'US-VA-110182', 'Fishersville', 'CI', 4218, 38.11420000000, -78.98450000000, '110182'),
(14811, 'US-VA-110183', 'Monroe', 'CI', 4218, 37.61050000000, -79.25860000000, '110183'),
(14812, 'US-PA-110184', 'Westfield', 'CI', 4208, 41.87370000000, -77.45080000000, '110184'),
(14813, 'US-VA-110185', 'Axton', 'CI', 4218, 36.66950000000, -79.71480000000, '110185'),
(14814, 'US-PA-110186', 'Mc Alisterville', 'CI', 4208, 40.64410000000, -77.25200000000, '110186'),
(14815, 'US-OH-110187', 'Minerva', 'CI', 4204, 40.73800000000, -81.09700000000, '110187'),
(14816, 'US-TX-110188', 'Tomball', 'CI', 4214, 30.08720000000, -95.58800000000, '110188'),
(14817, 'US-NJ-110189', 'Barrington', 'CI', 4198, 39.86340000000, -75.05380000000, '110189'),
(14818, 'US-NJ-110190', 'Palmyra', 'CI', 4198, 40.00200000000, -75.03230000000, '110190'),
(14819, 'US-NJ-110191', 'Cape May Court House', 'CI', 4198, 39.11560000000, -74.81800000000, '110191'),
(14820, 'US-NJ-110192', 'Buena', 'CI', 4198, 39.52280000000, -74.89540000000, '110192'),
(14821, 'US-NJ-110193', 'Grenloch', 'CI', 4198, 39.77880000000, -75.06010000000, '110193'),
(14822, 'US-IL-110194', 'Williamsville', 'CI', 4180, 39.95930000000, -89.55150000000, '110194'),
(14823, 'US-WV-110195', 'White Sulphur Springs', 'CI', 4220, 37.87480000000, -80.17090000000, '110195'),
(14824, 'US-FL-110196', 'Tarpon Springs', 'CI', 4175, 28.14760000000, -82.76410000000, '110196'),
(14825, 'US-FL-110197', 'Marco Island', 'CI', 4175, 25.93760000000, -81.69770000000, '110197'),
(14826, 'US-MN-110198', 'Lake City', 'CI', 4191, 44.40740000000, -92.30720000000, '110198'),
(14827, 'US-IL-110199', 'Wood River', 'CI', 4180, 38.86320000000, -90.10860000000, '110199'),
(14828, 'US-IN-110200', 'Tipton', 'CI', 4181, 40.28950000000, -86.05400000000, '110200'),
(14829, 'US-IL-110201', 'Roberts', 'CI', 4180, 40.63210000000, -88.17820000000, '110201'),
(14830, 'US-TN-110202', 'Soddy Daisy', 'CI', 4213, 35.30070000000, -85.18070000000, '110202'),
(14831, 'US-IL-110203', 'Gifford', 'CI', 4180, 40.31290000000, -88.01540000000, '110203'),
(14832, 'US-CA-110204', 'Mc Farland', 'CI', 4169, 35.65260000000, -119.19590000000, '110204'),
(14833, 'US-NJ-110205', 'Ringwood', 'CI', 4198, 41.11190000000, -74.27970000000, '110205');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(14834, 'US-IN-110206', 'Carlisle', 'CI', 4181, 38.96680000000, -87.39150000000, '110206'),
(14835, 'US-TN-110207', 'Bluff City', 'CI', 4213, 36.45540000000, -82.20880000000, '110207'),
(14836, 'US-NY-110208', 'Kirkwood', 'CI', 4200, 42.06130000000, -75.78210000000, '110208'),
(14837, 'US-MI-110209', 'Flat Rock', 'CI', 4190, 42.11250000000, -83.30170000000, '110209'),
(14838, 'US-TX-110210', 'Llano', 'CI', 4214, 30.63860000000, -98.68410000000, '110210'),
(14839, 'US-KS-110211', 'Abilene', 'CI', 4183, 39.02790000000, -97.22130000000, '110211'),
(14840, 'US-KS-110212', 'Horton', 'CI', 4183, 39.65880000000, -95.55050000000, '110212'),
(14841, 'US-MN-110213', 'Clearwater', 'CI', 4191, 45.38960000000, -94.06560000000, '110213'),
(14842, 'US-IA-110214', 'Pacific Junction', 'CI', 4182, 41.02580000000, -95.80970000000, '110214'),
(14843, 'US-CT-110215', 'Southport', 'CI', 4171, 41.14350000000, -73.28940000000, '110215'),
(14844, 'US-PA-110216', 'Delmont', 'CI', 4208, 40.41390000000, -79.57960000000, '110216'),
(14845, 'US-WV-110217', 'Benwood', 'CI', 4220, 40.01230000000, -80.73250000000, '110217'),
(14846, 'US-TX-110218', 'Brazoria', 'CI', 4214, 28.97150000000, -95.57860000000, '110218'),
(14847, 'US-TX-110219', 'Wallis', 'CI', 4214, 29.61430000000, -96.04170000000, '110219'),
(14848, 'US-MI-110220', 'Marine City', 'CI', 4190, 42.69140000000, -82.54960000000, '110220'),
(14849, 'US-IA-110221', 'Durant', 'CI', 4182, 41.62600000000, -90.91770000000, '110221'),
(14850, 'US-IL-110222', 'Gladstone', 'CI', 4180, 40.84050000000, -90.99230000000, '110222'),
(14851, 'US-ID-110223', 'Hayden', 'CI', 4179, 47.78870000000, -116.71120000000, '110223'),
(14852, 'US-MO-110224', 'House Springs', 'CI', 4193, 38.39920000000, -90.55660000000, '110224'),
(14853, 'US-IN-110225', 'Pierceton', 'CI', 4181, 41.21840000000, -85.70720000000, '110225'),
(14854, 'US-NM-110226', 'Red River', 'CI', 4199, 36.73130000000, -105.59130000000, '110226'),
(14855, 'US-CA-110227', 'San Jacinto', 'CI', 4169, 33.79940000000, -116.93210000000, '110227'),
(14856, 'US-KY-110228', 'Independence', 'CI', 4184, 38.92240000000, -84.54710000000, '110228'),
(14857, 'US-AL-110229', 'Tuscumbia', 'CI', 4161, 34.66390000000, -87.77870000000, '110229'),
(14858, 'US-NY-110230', 'Hudson', 'CI', 4200, 42.22570000000, -73.74290000000, '110230'),
(14859, 'US-CA-110231', 'Newport Coast', 'CI', 4169, 33.60010000000, -117.82870000000, '110231'),
(14860, 'US-MI-110232', 'Homer', 'CI', 4190, 42.14760000000, -84.82230000000, '110232'),
(14861, 'US-OK-110233', 'Glenpool', 'CI', 4205, 35.92610000000, -96.01930000000, '110233'),
(14862, 'US-FL-110234', 'Yulee', 'CI', 4175, 30.64580000000, -81.62990000000, '110234'),
(14863, 'US-NH-110235', 'Suncook', 'CI', 4197, 43.17560000000, -71.41040000000, '110235'),
(14864, 'US-IL-110236', 'Macomb', 'CI', 4180, 40.41200000000, -90.62380000000, '110236'),
(14865, 'US-TN-110237', 'Seymour', 'CI', 4213, 35.85560000000, -83.74490000000, '110237'),
(14866, 'US-WA-110238', 'Endicott', 'CI', 4219, 46.95720000000, -117.73630000000, '110238'),
(14867, 'US-TX-110239', 'Boerne', 'CI', 4214, 29.73290000000, -98.65920000000, '110239'),
(14868, 'US-PA-110240', 'Emlenton', 'CI', 4208, 41.22420000000, -79.63520000000, '110240'),
(14869, 'US-MA-110241', 'Bellingham', 'CI', 4189, 42.07660000000, -71.47190000000, '110241'),
(14870, 'US-CO-110242', 'Arvada', 'CI', 4170, 39.79410000000, -105.10190000000, '110242'),
(14871, 'US-CO-110243', 'Mesa', 'CI', 4170, 39.10980000000, -108.17360000000, '110243'),
(14872, 'US-CO-110244', 'Paonia', 'CI', 4170, 38.95570000000, -107.59410000000, '110244'),
(14873, 'US-VA-110245', 'Franklin', 'CI', 4218, 36.67380000000, -76.85700000000, '110245'),
(14874, 'US-MN-110246', 'Fairmont', 'CI', 4191, 43.63650000000, -94.48080000000, '110246'),
(14875, 'US-IA-110247', 'Lake Park', 'CI', 4182, 43.39970000000, -95.29920000000, '110247'),
(14876, 'US-TX-110248', 'Missouri City', 'CI', 4214, 29.52880000000, -95.52520000000, '110248'),
(14877, 'US-NY-110249', 'Coxsackie', 'CI', 4200, 42.34610000000, -73.84120000000, '110249'),
(14878, 'US-NC-110250', 'Benson', 'CI', 4201, 35.41780000000, -78.50050000000, '110250'),
(14879, 'US-NY-110251', 'Austerlitz', 'CI', 4200, 42.30960000000, -73.46100000000, '110251'),
(14880, 'US-TN-110252', 'Maryville', 'CI', 4213, 35.78850000000, -83.88840000000, '110252'),
(14881, 'US-MS-110253', 'Columbus', 'CI', 4192, 33.43410000000, -88.35650000000, '110253'),
(14882, 'US-NH-110254', 'Franklin', 'CI', 4197, 43.44730000000, -71.67640000000, '110254'),
(14883, 'US-MI-110255', 'Franklin', 'CI', 4190, 42.51810000000, -83.26300000000, '110255'),
(14884, 'US-MO-110256', 'Crystal City', 'CI', 4193, 38.23480000000, -90.37740000000, '110256'),
(14885, 'US-TN-110257', 'Christiana', 'CI', 4213, 35.69620000000, -86.35990000000, '110257'),
(14886, 'US-IL-110258', 'Bement', 'CI', 4180, 39.90840000000, -88.56560000000, '110258'),
(14887, 'US-UT-110259', 'Holden', 'CI', 4215, 39.10410000000, -112.26980000000, '110259'),
(14888, 'US-FL-110260', 'Navarre', 'CI', 4175, 30.44670000000, -86.87500000000, '110260'),
(14889, 'US-CA-110261', 'San Juan Capistrano', 'CI', 4169, 33.52560000000, -117.61910000000, '110261'),
(14890, 'US-NE-110262', 'Fairbury', 'CI', 4195, 40.16100000000, -97.18990000000, '110262'),
(14891, 'US-IA-110263', 'Delhi', 'CI', 4182, 42.40820000000, -91.31030000000, '110263'),
(14892, 'US-OH-110264', 'Gates Mills', 'CI', 4204, 41.53440000000, -81.41460000000, '110264'),
(14893, 'US-OH-110265', 'Bay Village', 'CI', 4204, 41.49160000000, -81.95370000000, '110265'),
(14894, 'US-NY-110266', 'Amityville', 'CI', 4200, 40.68620000000, -73.41230000000, '110266'),
(14895, 'US-KY-110267', 'Mount Washington', 'CI', 4184, 38.04170000000, -85.57530000000, '110267'),
(14896, 'US-IN-110268', 'Elizabeth', 'CI', 4181, 38.10470000000, -85.98640000000, '110268'),
(14897, 'US-MA-110269', 'Millbury', 'CI', 4189, 42.19120000000, -71.77890000000, '110269'),
(14898, 'US-MN-110270', 'Saint Joseph', 'CI', 4191, 45.61630000000, -94.29450000000, '110270'),
(14899, 'US-NY-110271', 'Millbrook', 'CI', 4200, 41.79120000000, -73.66000000000, '110271'),
(14900, 'US-PA-110272', 'Freeland', 'CI', 4208, 41.02190000000, -75.87560000000, '110272'),
(14901, 'US-NY-110273', 'East Amherst', 'CI', 4200, 43.04410000000, -78.69490000000, '110273'),
(14902, 'US-VA-110274', 'Alberta', 'CI', 4218, 36.86790000000, -77.92590000000, '110274'),
(14903, 'US-IN-110275', 'Hagerstown', 'CI', 4181, 39.92510000000, -85.16770000000, '110275'),
(14904, 'US-MS-110276', 'Hickory Flat', 'CI', 4192, 34.64100000000, -89.19530000000, '110276'),
(14905, 'US-TN-110277', 'Middleton', 'CI', 4213, 35.10460000000, -88.92110000000, '110277'),
(14906, 'US-NY-110278', 'West Coxsackie', 'CI', 4200, 42.39840000000, -73.83170000000, '110278'),
(14907, 'US-OH-110279', 'Baltimore', 'CI', 4204, 39.86190000000, -82.61090000000, '110279'),
(14908, 'US-OH-110280', 'Willow Wood', 'CI', 4204, 38.59700000000, -82.45250000000, '110280'),
(14909, 'US-WI-110281', 'Reedsburg', 'CI', 4221, 43.53090000000, -89.97340000000, '110281'),
(14910, 'US-WI-110282', 'Lancaster', 'CI', 4221, 42.84120000000, -90.71120000000, '110282'),
(14911, 'US-VA-110283', 'Weber City', 'CI', 4218, 36.62430000000, -82.58090000000, '110283'),
(14912, 'US-CA-110284', 'Wasco', 'CI', 4169, 35.64540000000, -119.44350000000, '110284'),
(14913, 'US-MI-110285', 'Romeo', 'CI', 4190, 42.84360000000, -83.04030000000, '110285'),
(14914, 'US-NJ-110286', 'Ocean View', 'CI', 4198, 39.20040000000, -74.70510000000, '110286'),
(14915, 'US-WV-110287', 'Dunbar', 'CI', 4220, 38.37600000000, -81.74770000000, '110287'),
(14916, 'US-ND-110288', 'Lamoure', 'CI', 4202, 46.36010000000, -98.26460000000, '110288'),
(14917, 'US-MD-110289', 'Centreville', 'CI', 4188, 39.05430000000, -76.01850000000, '110289'),
(14918, 'US-VA-110290', 'Appalachia', 'CI', 4218, 36.94570000000, -82.77790000000, '110290'),
(14919, 'US-IN-110291', 'Gas City', 'CI', 4181, 40.48940000000, -85.59770000000, '110291'),
(14920, 'US-IN-110292', 'Dupont', 'CI', 4181, 38.89440000000, -85.49770000000, '110292'),
(14921, 'US-IN-110293', 'Brookston', 'CI', 4181, 40.61410000000, -86.92030000000, '110293'),
(14922, 'US-SC-110294', 'North Myrtle Beach', 'CI', 4211, 33.83220000000, -78.64910000000, '110294'),
(14923, 'US-CA-110295', 'Lawndale', 'CI', 4169, 33.88720000000, -118.35480000000, '110295'),
(14924, 'US-WA-110296', 'Bonney Lake', 'CI', 4219, 47.19370000000, -122.18520000000, '110296'),
(14925, 'US-NC-110297', 'Richfield', 'CI', 4201, 35.50590000000, -80.23480000000, '110297'),
(14926, 'US-TX-110298', 'Kemp', 'CI', 4214, 32.36050000000, -96.28130000000, '110298'),
(14927, 'US-TX-110299', 'Ennis', 'CI', 4214, 32.32420000000, -96.58730000000, '110299'),
(14928, 'US-MS-110300', 'Mccomb', 'CI', 4192, 31.20320000000, -90.39560000000, '110300'),
(14929, 'US-OK-110301', 'Pawhuska', 'CI', 4205, 36.76430000000, -96.30080000000, '110301'),
(14930, 'US-WV-110302', 'Welch', 'CI', 4220, 37.39560000000, -81.57570000000, '110302'),
(14931, 'US-NY-110303', 'Corfu', 'CI', 4200, 42.98370000000, -78.37280000000, '110303'),
(14932, 'US-TX-110304', 'Mc Gregor', 'CI', 4214, 31.42060000000, -97.40100000000, '110304'),
(14933, 'US-OK-110305', 'Wewoka', 'CI', 4205, 35.20320000000, -96.52050000000, '110305'),
(14934, 'US-WI-110306', 'Cambridge', 'CI', 4221, 42.98910000000, -89.03720000000, '110306'),
(14935, 'US-MO-110307', 'Marceline', 'CI', 4193, 39.65390000000, -92.91570000000, '110307'),
(14936, 'US-MA-110308', 'West Tisbury', 'CI', 4189, 41.42780000000, -70.63460000000, '110308'),
(14937, 'US-OH-110309', 'Clarksville', 'CI', 4204, 39.39880000000, -83.97010000000, '110309'),
(14938, 'US-PA-110310', 'Ligonier', 'CI', 4208, 40.24820000000, -79.19720000000, '110310'),
(14939, 'US-CA-110311', 'Shasta Lake', 'CI', 4169, 40.68930000000, -122.37680000000, '110311'),
(14940, 'US-CA-110312', 'Sloughhouse', 'CI', 4169, 38.51230000000, -121.12520000000, '110312'),
(14941, 'US-CA-110313', 'Applegate', 'CI', 4169, 39.00060000000, -120.99700000000, '110313'),
(14942, 'US-IL-110314', 'Philo', 'CI', 4180, 39.97450000000, -88.14270000000, '110314'),
(14943, 'US-IL-110315', 'Elkville', 'CI', 4180, 37.89940000000, -89.21850000000, '110315'),
(14944, 'US-PA-110316', 'Nicktown', 'CI', 4208, 40.59880000000, -78.83520000000, '110316'),
(14945, 'US-IN-110317', 'Avon', 'CI', 4181, 39.76020000000, -86.39420000000, '110317'),
(14946, 'US-IN-110318', 'Fishers', 'CI', 4181, 39.96100000000, -85.98370000000, '110318'),
(14947, 'US-CA-110319', 'Tarzana', 'CI', 4169, 34.15530000000, -118.54760000000, '110319'),
(14948, 'US-TX-110320', 'Pinehurst', 'CI', 4214, 30.15460000000, -95.66480000000, '110320'),
(14949, 'US-WI-110321', 'Prentice', 'CI', 4221, 45.52650000000, -90.31310000000, '110321'),
(14950, 'US-TX-110322', 'Albany', 'CI', 4214, 32.77080000000, -99.26410000000, '110322'),
(14951, 'US-NY-110323', 'Richfield Springs', 'CI', 4200, 42.84880000000, -74.97780000000, '110323'),
(14952, 'US-IA-110324', 'Red Oak', 'CI', 4182, 41.01610000000, -95.21840000000, '110324'),
(14953, 'US-CA-110325', 'Boulder Creek', 'CI', 4169, 37.16150000000, -122.15140000000, '110325'),
(14954, 'US-CA-110326', 'Saratoga', 'CI', 4169, 37.25390000000, -122.06380000000, '110326'),
(14955, 'US-CA-110327', 'Cutler', 'CI', 4169, 36.49870000000, -119.27970000000, '110327'),
(14956, 'US-KS-110328', 'Spring Hill', 'CI', 4183, 38.73140000000, -94.82820000000, '110328'),
(14957, 'US-CA-110329', 'Cobb', 'CI', 4169, 38.84020000000, -122.72390000000, '110329'),
(14958, 'US-ME-110330', 'Unity', 'CI', 4186, 44.59940000000, -69.34060000000, '110330'),
(14959, 'US-MI-110331', 'Portland', 'CI', 4190, 42.86270000000, -84.99550000000, '110331'),
(14960, 'US-AR-110332', 'Helena', 'CI', 4165, 34.47970000000, -90.69770000000, '110332'),
(14961, 'US-AR-110333', 'Dell', 'CI', 4165, 35.85400000000, -90.05560000000, '110333'),
(14962, 'US-IL-110334', 'Seneca', 'CI', 4180, 41.39290000000, -88.56830000000, '110334'),
(14963, 'US-NJ-110335', 'Township Of Washington', 'CI', 4198, 40.98600000000, -74.06310000000, '110335'),
(14964, 'US-CA-110336', 'Somerset', 'CI', 4169, 38.62570000000, -120.62820000000, '110336'),
(14965, 'US-CA-110337', 'Westwood', 'CI', 4169, 40.26310000000, -121.02210000000, '110337'),
(14966, 'US-NV-110338', 'Tonopah', 'CI', 4196, 38.35210000000, -116.61830000000, '110338'),
(14967, 'US-CA-110339', 'Acampo', 'CI', 4169, 38.19430000000, -121.24970000000, '110339'),
(14968, 'US-CA-110340', 'Tahoe Vista', 'CI', 4169, 39.24460000000, -120.05170000000, '110340'),
(14969, 'US-OK-110341', 'Hugo', 'CI', 4205, 34.01440000000, -95.48850000000, '110341'),
(14970, 'US-OK-110342', 'Blanchard', 'CI', 4205, 35.12400000000, -97.67070000000, '110342'),
(14971, 'US-MI-110343', 'Stockbridge', 'CI', 4190, 42.47520000000, -84.20890000000, '110343'),
(14972, 'US-OH-110344', 'Bluffton', 'CI', 4204, 40.87540000000, -83.88090000000, '110344'),
(14973, 'US-MO-110345', 'West Alton', 'CI', 4193, 38.86950000000, -90.21910000000, '110345'),
(14974, 'US-IL-110346', 'Genoa', 'CI', 4180, 42.10860000000, -88.68600000000, '110346'),
(14975, 'US-MI-110347', 'Fort Gratiot', 'CI', 4190, 43.08410000000, -82.49050000000, '110347'),
(14976, 'US-AR-110348', 'Hazen', 'CI', 4165, 34.79400000000, -91.58370000000, '110348'),
(14977, 'US-AR-110349', 'Mayflower', 'CI', 4165, 34.97410000000, -92.43120000000, '110349'),
(14978, 'US-TX-110350', 'Edinburg', 'CI', 4214, 26.46280000000, -98.25680000000, '110350'),
(14979, 'US-TX-110351', 'Colleyville', 'CI', 4214, 32.89180000000, -97.14670000000, '110351'),
(14980, 'US-CA-110352', 'Hopland', 'CI', 4169, 38.93840000000, -123.11010000000, '110352'),
(14981, 'US-WA-110353', 'Anacortes', 'CI', 4219, 48.46480000000, -122.60920000000, '110353'),
(14982, 'US-PA-110354', 'Gordonville', 'CI', 4208, 40.04320000000, -76.10590000000, '110354'),
(14983, 'US-IN-110355', 'Brazil', 'CI', 4181, 39.55450000000, -87.12510000000, '110355'),
(14984, 'US-IN-110356', 'Camby', 'CI', 4181, 39.63190000000, -86.30260000000, '110356'),
(14985, 'US-IN-110357', 'Linden', 'CI', 4181, 40.19590000000, -86.85610000000, '110357'),
(14986, 'US-IL-110358', 'Oakwood', 'CI', 4180, 40.13070000000, -87.75640000000, '110358'),
(14987, 'US-MN-110359', 'Wanamingo', 'CI', 4191, 44.27320000000, -92.81090000000, '110359'),
(14988, 'US-MI-110360', 'Stevensville', 'CI', 4190, 42.00920000000, -86.51010000000, '110360'),
(14989, 'US-TX-110361', 'Huntsville', 'CI', 4214, 30.65180000000, -95.55430000000, '110361'),
(14990, 'US-TX-110362', 'Madisonville', 'CI', 4214, 30.96890000000, -95.89120000000, '110362'),
(14991, 'US-AZ-110363', 'Tsaile', 'CI', 4164, 36.27400000000, -109.26570000000, '110363'),
(14992, 'US-CA-110364', 'Canoga Park', 'CI', 4169, 34.19740000000, -118.60150000000, '110364'),
(14993, 'US-WA-110365', 'Stanwood', 'CI', 4219, 48.21240000000, -122.28460000000, '110365'),
(14994, 'US-KY-110366', 'Hartford', 'CI', 4184, 37.52100000000, -86.86480000000, '110366'),
(14995, 'US-KY-110367', 'Irvington', 'CI', 4184, 37.82850000000, -86.27790000000, '110367'),
(14996, 'US-KY-110368', 'Radcliff', 'CI', 4184, 37.85460000000, -85.89610000000, '110368'),
(14997, 'US-AZ-110369', 'Fountain Hills', 'CI', 4164, 33.60400000000, -111.74260000000, '110369'),
(14998, 'US-OH-110370', 'New Albany', 'CI', 4204, 40.08480000000, -82.81260000000, '110370'),
(14999, 'US-OH-110371', 'Mount Sterling', 'CI', 4204, 39.71430000000, -83.29530000000, '110371'),
(15000, 'US-OH-110372', 'Leipsic', 'CI', 4204, 41.10170000000, -84.01980000000, '110372'),
(15001, 'US-LA-110373', 'Norco', 'CI', 4185, 30.00670000000, -90.41630000000, '110373'),
(15002, 'US-MS-110374', 'Bassfield', 'CI', 4192, 31.47600000000, -89.71810000000, '110374'),
(15003, 'US-IL-110375', 'Lacon', 'CI', 4180, 41.01730000000, -89.36190000000, '110375'),
(15004, 'US-IL-110376', 'Princeton', 'CI', 4180, 41.37310000000, -89.44250000000, '110376'),
(15005, 'US-GA-110377', 'Cedartown', 'CI', 4176, 34.01470000000, -85.26540000000, '110377'),
(15006, 'PR-??-110378', 'San Lorenzo', 'CI', 181, 18.15250000000, -65.98660000000, '110378'),
(15007, 'US-WI-110379', 'Arcadia', 'CI', 4221, 44.25090000000, -91.50900000000, '110379'),
(15008, 'US-FL-110380', 'Flagler Beach', 'CI', 4175, 29.49310000000, -81.13500000000, '110380'),
(15009, 'US-FL-110381', 'Orange Springs', 'CI', 4175, 29.48020000000, -81.94080000000, '110381'),
(15010, 'US-GA-110382', 'Mableton', 'CI', 4176, 33.81190000000, -84.55040000000, '110382'),
(15011, 'US-MI-110383', 'Hopkins', 'CI', 4190, 42.61800000000, -85.72120000000, '110383'),
(15012, 'US-NC-110384', 'Robersonville', 'CI', 4201, 35.80370000000, -77.23400000000, '110384'),
(15013, 'US-TN-110385', 'Louisville', 'CI', 4213, 35.81340000000, -84.08550000000, '110385'),
(15014, 'US-CA-110386', 'Patterson', 'CI', 4169, 37.49570000000, -121.25460000000, '110386'),
(15015, 'US-PA-110387', 'Buckingham', 'CI', 4208, 40.29390000000, -75.05960000000, '110387'),
(15016, 'US-PA-110388', 'Kunkletown', 'CI', 4208, 40.84570000000, -75.49480000000, '110388'),
(15017, 'US-PA-110389', 'Perkasie', 'CI', 4208, 40.39790000000, -75.23200000000, '110389'),
(15018, 'US-PA-110390', 'Lenhartsville', 'CI', 4208, 40.57400000000, -75.86520000000, '110390'),
(15019, 'US-PA-110391', 'Chalfont', 'CI', 4208, 40.29640000000, -75.20530000000, '110391'),
(15020, 'US-WV-110392', 'Franklin', 'CI', 4220, 38.61910000000, -79.32890000000, '110392'),
(15021, 'US-IA-110393', 'Cascade', 'CI', 4182, 42.27410000000, -91.01410000000, '110393'),
(15022, 'US-IL-110394', 'Cuba', 'CI', 4180, 40.50120000000, -90.18410000000, '110394'),
(15023, 'US-IA-110395', 'Clinton', 'CI', 4182, 41.91370000000, -90.27110000000, '110395'),
(15024, 'US-IL-110396', 'Cordova', 'CI', 4180, 41.70950000000, -90.27600000000, '110396'),
(15025, 'US-IL-110397', 'Port Byron', 'CI', 4180, 41.59390000000, -90.30350000000, '110397'),
(15026, 'US-IL-110398', 'Peoria Heights', 'CI', 4180, 40.74260000000, -89.57110000000, '110398'),
(15027, 'US-IA-110399', 'Center Point', 'CI', 4182, 42.19790000000, -91.76820000000, '110399'),
(15028, 'US-IA-110400', 'Anamosa', 'CI', 4182, 42.13860000000, -91.24830000000, '110400'),
(15029, 'US-IA-110401', 'Camanche', 'CI', 4182, 41.77160000000, -90.33850000000, '110401'),
(15030, 'US-IL-110402', 'Sheffield', 'CI', 4180, 41.42340000000, -89.75960000000, '110402'),
(15031, 'US-IA-110403', 'Monticello', 'CI', 4182, 42.22060000000, -91.22820000000, '110403'),
(15032, 'US-IL-110404', 'Tiskilwa', 'CI', 4180, 41.24500000000, -89.52170000000, '110404'),
(15033, 'US-IA-110405', 'Mediapolis', 'CI', 4182, 41.01870000000, -91.13140000000, '110405'),
(15034, 'US-CO-110406', 'Sedalia', 'CI', 4170, 39.30610000000, -105.10690000000, '110406'),
(15035, 'US-MN-110407', 'Wayzata', 'CI', 4191, 44.97520000000, -93.52750000000, '110407'),
(15036, 'US-ND-110408', 'Garrison', 'CI', 4202, 47.66290000000, -101.67140000000, '110408'),
(15037, 'US-ND-110409', 'Williston', 'CI', 4202, 48.22300000000, -103.70710000000, '110409'),
(15038, 'US-MN-110410', 'Arlington', 'CI', 4191, 44.60080000000, -94.09380000000, '110410'),
(15039, 'US-MD-110411', 'Boonsboro', 'CI', 4188, 39.51900000000, -77.68780000000, '110411'),
(15040, 'US-OR-110412', 'Saint Benedict', 'CI', 4206, 45.05650000000, -122.78440000000, '110412'),
(15041, 'US-PA-110413', 'Saltsburg', 'CI', 4208, 40.53770000000, -79.39870000000, '110413'),
(15042, 'US-OH-110414', 'Powhatan Point', 'CI', 4204, 39.87110000000, -80.85520000000, '110414'),
(15043, 'US-PA-110415', 'Homestead', 'CI', 4208, 40.39480000000, -79.90560000000, '110415'),
(15044, 'US-CA-110416', 'La Mesa', 'CI', 4169, 32.75960000000, -116.99400000000, '110416'),
(15045, 'US-CA-110417', 'Calipatria', 'CI', 4169, 33.13750000000, -115.52380000000, '110417'),
(15046, 'US-CA-110418', 'Bonsall', 'CI', 4169, 33.28800000000, -117.19380000000, '110418'),
(15047, 'US-WI-110419', 'Brillion', 'CI', 4221, 44.16830000000, -88.11050000000, '110419'),
(15048, 'US-KY-110420', 'Guthrie', 'CI', 4184, 36.72220000000, -87.17360000000, '110420'),
(15049, 'US-FL-110421', 'Eustis', 'CI', 4175, 28.87430000000, -81.68600000000, '110421'),
(15050, 'US-FL-110422', 'Edgewater', 'CI', 4175, 28.97170000000, -80.92380000000, '110422'),
(15051, 'US-FL-110423', 'Tavares', 'CI', 4175, 28.77600000000, -81.71520000000, '110423'),
(15052, 'US-CA-110424', 'Woodbridge', 'CI', 4169, 38.16360000000, -121.29750000000, '110424'),
(15053, 'US-CA-110425', 'Princeton', 'CI', 4169, 39.41490000000, -122.04640000000, '110425'),
(15054, 'US-TX-110426', 'Richmond', 'CI', 4214, 29.50160000000, -95.68900000000, '110426'),
(15055, 'US-PA-110427', 'Dawson', 'CI', 4208, 40.08180000000, -79.68590000000, '110427'),
(15056, 'US-MI-110428', 'Chase', 'CI', 4190, 43.90090000000, -85.67850000000, '110428'),
(15057, 'US-WI-110429', 'Horicon', 'CI', 4221, 43.45660000000, -88.63160000000, '110429'),
(15058, 'US-OH-110430', 'Glenmont', 'CI', 4204, 40.53250000000, -82.14870000000, '110430'),
(15059, 'US-IL-110431', 'Burbank', 'CI', 4180, 41.74520000000, -87.77030000000, '110431'),
(15060, 'US-OK-110432', 'Wilburton', 'CI', 4205, 34.89480000000, -95.28360000000, '110432'),
(15061, 'US-OK-110433', 'Grove', 'CI', 4205, 36.59200000000, -94.72970000000, '110433'),
(15062, 'US-MD-110434', 'Fulton', 'CI', 4188, 39.16340000000, -76.93590000000, '110434'),
(15063, 'US-CA-110435', 'Seaside', 'CI', 4169, 36.62490000000, -121.82570000000, '110435'),
(15064, 'US-PA-110436', 'Centre Hall', 'CI', 4208, 40.82140000000, -77.69450000000, '110436'),
(15065, 'US-CA-110437', 'Lincoln', 'CI', 4169, 38.93700000000, -121.25190000000, '110437'),
(15066, 'US-MI-110438', 'Imlay City', 'CI', 4190, 43.06800000000, -83.03790000000, '110438'),
(15067, 'US-CA-110439', 'Boonville', 'CI', 4169, 38.99750000000, -123.36220000000, '110439'),
(15068, 'US-CA-110440', 'Oakley', 'CI', 4169, 37.99420000000, -121.68870000000, '110440'),
(15069, 'US-IN-110441', 'Highland', 'CI', 4181, 41.54800000000, -87.45640000000, '110441'),
(15070, 'US-NJ-110442', 'Watchung', 'CI', 4198, 40.64280000000, -74.44220000000, '110442'),
(15071, 'US-IA-110443', 'Manchester', 'CI', 4182, 42.48930000000, -91.45490000000, '110443'),
(15072, 'US-OR-110444', 'Days Creek', 'CI', 4206, 42.97750000000, -123.06260000000, '110444'),
(15073, 'US-IL-110445', 'Saint Elmo', 'CI', 4180, 39.01750000000, -88.85290000000, '110445'),
(15074, 'US-CA-110446', 'Upper Lake', 'CI', 4169, 39.26610000000, -122.96670000000, '110446'),
(15075, 'US-PA-110447', 'Colmar', 'CI', 4208, 40.27310000000, -75.25580000000, '110447'),
(15076, 'US-TX-110448', 'Lipan', 'CI', 4214, 32.52260000000, -98.04830000000, '110448'),
(15077, 'US-IL-110449', 'Beecher', 'CI', 4180, 41.34360000000, -87.61710000000, '110449'),
(15078, 'US-TX-110450', 'Carthage', 'CI', 4214, 32.11930000000, -94.31950000000, '110450'),
(15079, 'US-TX-110451', 'Quitman', 'CI', 4214, 32.83500000000, -95.42300000000, '110451'),
(15080, 'US-TX-110452', 'Sumner', 'CI', 4214, 33.76300000000, -95.73040000000, '110452'),
(15081, 'US-AR-110453', 'Brinkley', 'CI', 4165, 34.83890000000, -91.17780000000, '110453'),
(15082, 'US-TX-110454', 'Deer Park', 'CI', 4214, 29.68770000000, -95.11570000000, '110454'),
(15083, 'US-CA-110455', 'Carmichael', 'CI', 4169, 38.62620000000, -121.32480000000, '110455'),
(15084, 'US-MO-110456', 'Gallatin', 'CI', 4193, 39.89160000000, -93.94720000000, '110456'),
(15085, 'US-CT-110457', 'Roxbury', 'CI', 4171, 41.55380000000, -73.30150000000, '110457'),
(15086, 'US-CT-110458', 'Woodbury', 'CI', 4171, 41.56060000000, -73.20620000000, '110458'),
(15087, 'US-CA-110459', 'San Simeon', 'CI', 4169, 35.69500000000, -121.20460000000, '110459'),
(15088, 'US-IL-110460', 'Homer Glen', 'CI', 4180, 41.62280000000, -87.94160000000, '110460'),
(15089, 'US-AR-110461', 'Ozark', 'CI', 4165, 35.57530000000, -93.79230000000, '110461'),
(15090, 'US-CT-110462', 'Colchester', 'CI', 4171, 41.54710000000, -72.34300000000, '110462'),
(15091, 'US-NC-110463', 'Reidsville', 'CI', 4201, 36.34000000000, -79.62880000000, '110463'),
(15092, 'US-MO-110464', 'Charleston', 'CI', 4193, 36.95330000000, -89.28200000000, '110464'),
(15093, 'US-IL-110465', 'Columbia', 'CI', 4180, 38.44070000000, -90.20950000000, '110465'),
(15094, 'US-TX-110466', 'Waxahachie', 'CI', 4214, 32.36940000000, -96.78730000000, '110466'),
(15095, 'US-SC-110467', 'Landrum', 'CI', 4211, 35.13450000000, -82.25570000000, '110467'),
(15096, 'US-OK-110468', 'Anadarko', 'CI', 4205, 35.05830000000, -98.24240000000, '110468'),
(15097, 'US-OK-110469', 'Mill Creek', 'CI', 4205, 34.39740000000, -96.82680000000, '110469'),
(15098, 'US-LA-110470', 'Slidell', 'CI', 4185, 30.27120000000, -89.77050000000, '110470'),
(15099, 'US-CA-110471', 'Lemon Cove', 'CI', 4169, 36.46060000000, -118.98080000000, '110471'),
(15100, 'US-CA-110472', 'Downieville', 'CI', 4169, 39.58130000000, -120.79240000000, '110472'),
(15101, 'US-NY-110473', 'East Northport', 'CI', 4200, 40.86180000000, -73.31510000000, '110473'),
(15102, 'US-NY-110474', 'Fairport', 'CI', 4200, 43.10050000000, -77.42600000000, '110474'),
(15103, 'US-PA-110475', 'Rochester', 'CI', 4208, 40.73220000000, -80.18620000000, '110475'),
(15104, 'US-WI-110476', 'Ixonia', 'CI', 4221, 43.15330000000, -88.60120000000, '110476'),
(15105, 'US-CA-110477', 'Idyllwild', 'CI', 4169, 33.76310000000, -116.73640000000, '110477'),
(15106, 'US-HI-110478', 'Hickam Afb', 'CI', 4178, 24.85980000000, -168.02180000000, '110478'),
(15107, 'US-OK-110479', 'Stilwell', 'CI', 4205, 35.80160000000, -94.67200000000, '110479'),
(15108, 'US-OK-110480', 'Mcalester', 'CI', 4205, 34.96650000000, -95.82570000000, '110480'),
(15109, 'US-NY-110481', 'Rosedale', 'CI', 4200, 40.65070000000, -73.77890000000, '110481'),
(15110, 'US-CA-110482', 'Philo', 'CI', 4169, 39.07260000000, -123.52700000000, '110482'),
(15111, 'US-VA-110483', 'Bastian', 'CI', 4218, 37.15780000000, -81.21670000000, '110483'),
(15112, 'US-TX-110484', 'Cat Spring', 'CI', 4214, 29.78920000000, -96.36240000000, '110484'),
(15113, 'US-PA-110485', 'Dillsburg', 'CI', 4208, 40.08110000000, -77.03140000000, '110485'),
(15114, 'US-CA-110486', 'Coalinga', 'CI', 4169, 36.19660000000, -120.39060000000, '110486'),
(15115, 'US-CA-110487', 'Chowchilla', 'CI', 4169, 37.07710000000, -120.27380000000, '110487'),
(15116, 'US-MI-110488', 'Sparta', 'CI', 4190, 43.15420000000, -85.68570000000, '110488'),
(15117, 'US-SC-110489', 'Clover', 'CI', 4211, 35.07400000000, -81.21290000000, '110489'),
(15118, 'US-IN-110490', 'Mount Vernon', 'CI', 4181, 37.91060000000, -87.78150000000, '110490'),
(15119, 'US-NC-110491', 'Weldon', 'CI', 4201, 36.41390000000, -77.59440000000, '110491'),
(15120, 'US-LA-110492', 'Ville Platte', 'CI', 4185, 30.74090000000, -92.34550000000, '110492'),
(15121, 'US-OH-110493', 'Bidwell', 'CI', 4204, 38.92630000000, -82.26800000000, '110493'),
(15122, 'US-TX-110494', 'Bartlett', 'CI', 4214, 30.81150000000, -97.41190000000, '110494'),
(15123, 'US-MA-110495', 'Ashland', 'CI', 4189, 42.25960000000, -71.47030000000, '110495'),
(15124, 'US-CA-110496', 'Gualala', 'CI', 4169, 38.82700000000, -123.51460000000, '110496'),
(15125, 'US-ME-110497', 'Deer Isle', 'CI', 4186, 44.22370000000, -68.64870000000, '110497'),
(15126, 'US-MI-110498', 'Freeport', 'CI', 4190, 42.76920000000, -85.28580000000, '110498'),
(15127, 'US-MI-110499', 'Gladwin', 'CI', 4190, 44.07470000000, -84.43470000000, '110499'),
(15128, 'US-MI-110500', 'Morley', 'CI', 4190, 43.49670000000, -85.42340000000, '110500'),
(15129, 'US-AR-110501', 'Osceola', 'CI', 4165, 35.69060000000, -90.00680000000, '110501'),
(15130, 'US-AR-110502', 'Piggott', 'CI', 4165, 36.40720000000, -90.24000000000, '110502'),
(15131, 'US-IA-110503', 'Grimes', 'CI', 4182, 41.68970000000, -93.79510000000, '110503'),
(15132, 'US-CA-110504', 'Alamo', 'CI', 4169, 37.84950000000, -121.97640000000, '110504'),
(15133, 'US-IL-110505', 'Chicago Ridge', 'CI', 4180, 41.70500000000, -87.78050000000, '110505'),
(15134, 'US-MO-110506', 'Lebanon', 'CI', 4193, 37.69890000000, -92.66200000000, '110506'),
(15135, 'US-TX-110507', 'East Bernard', 'CI', 4214, 29.48270000000, -96.11460000000, '110507'),
(15136, 'US-TN-110508', 'Pigeon Forge', 'CI', 4213, 35.77780000000, -83.57330000000, '110508'),
(15137, 'US-OH-110509', 'Caldwell', 'CI', 4204, 39.73440000000, -81.50810000000, '110509'),
(15138, 'US-KS-110510', 'Independence', 'CI', 4183, 37.20410000000, -95.73860000000, '110510'),
(15139, 'US-KS-110511', 'Augusta', 'CI', 4183, 37.66630000000, -96.95720000000, '110511'),
(15140, 'US-MI-110512', 'Sandusky', 'CI', 4190, 43.42010000000, -82.85770000000, '110512'),
(15141, 'US-FL-110513', 'North Port', 'CI', 4175, 27.13410000000, -82.25010000000, '110513'),
(15142, 'US-TX-110514', 'Wickett', 'CI', 4214, 31.56560000000, -103.00540000000, '110514'),
(15143, 'US-MO-110515', 'Bronaugh', 'CI', 4193, 37.71400000000, -94.50630000000, '110515'),
(15144, 'US-TX-110516', 'Brady', 'CI', 4214, 31.14510000000, -99.34780000000, '110516'),
(15145, 'US-IL-110517', 'Summit Argo', 'CI', 4180, 41.78340000000, -87.82380000000, '110517'),
(15146, 'US-IL-110518', 'Murrayville', 'CI', 4180, 39.58530000000, -90.24160000000, '110518'),
(15147, 'US-OH-110519', 'Cortland', 'CI', 4204, 41.35980000000, -80.71480000000, '110519'),
(15148, 'US-OH-110520', 'Barberton', 'CI', 4204, 41.02320000000, -81.62800000000, '110520'),
(15149, 'US-WI-110521', 'Stratford', 'CI', 4221, 44.79280000000, -90.08300000000, '110521'),
(15150, 'US-WI-110522', 'Cottage Grove', 'CI', 4221, 43.07090000000, -89.18850000000, '110522'),
(15151, 'US-WI-110523', 'Edgerton', 'CI', 4221, 42.85750000000, -89.10260000000, '110523'),
(15152, 'US-CA-110524', 'Sunol', 'CI', 4169, 37.56100000000, -121.84890000000, '110524'),
(15153, 'US-TX-110525', 'Dayton', 'CI', 4214, 30.04540000000, -94.90580000000, '110525'),
(15154, 'US-TX-110526', 'Sandia', 'CI', 4214, 28.03430000000, -97.86020000000, '110526'),
(15155, 'US-IL-110527', 'Big Rock', 'CI', 4180, 41.75990000000, -88.56270000000, '110527'),
(15156, 'US-WY-110528', 'Cody', 'CI', 4222, 44.40230000000, -109.53470000000, '110528'),
(15157, 'US-CA-110529', 'Lake Isabella', 'CI', 4169, 35.58480000000, -118.38290000000, '110529'),
(15158, 'US-WV-110530', 'Hinton', 'CI', 4220, 37.68620000000, -80.83670000000, '110530'),
(15159, 'US-NC-110531', 'Roxboro', 'CI', 4201, 36.39950000000, -78.97600000000, '110531'),
(15160, 'US-NC-110532', 'North Wilkesboro', 'CI', 4201, 36.21740000000, -81.11970000000, '110532'),
(15161, 'US-TN-110533', 'Arlington', 'CI', 4213, 35.28600000000, -89.70810000000, '110533'),
(15162, 'US-MO-110534', 'Park Hills', 'CI', 4193, 37.81460000000, -90.55210000000, '110534'),
(15163, 'US-MO-110535', 'Washington', 'CI', 4193, 38.52340000000, -91.03320000000, '110535'),
(15164, 'US-IL-110536', 'Robinson', 'CI', 4180, 38.98870000000, -87.74520000000, '110536'),
(15165, 'US-KS-110537', 'Stilwell', 'CI', 4183, 38.79740000000, -94.65670000000, '110537'),
(15166, 'US-KS-110538', 'Atchison', 'CI', 4183, 39.55050000000, -95.12730000000, '110538'),
(15167, 'US-MO-110539', 'Sedalia', 'CI', 4193, 38.70290000000, -93.23680000000, '110539'),
(15168, 'US-MO-110540', 'Rockville', 'CI', 4193, 38.05810000000, -94.06910000000, '110540'),
(15169, 'US-CA-110541', 'Imperial', 'CI', 4169, 32.86850000000, -115.65050000000, '110541'),
(15170, 'US-CT-110542', 'Collinsville', 'CI', 4171, 41.85160000000, -72.91810000000, '110542'),
(15171, 'US-NM-110543', 'Holloman Air Force Base', 'CI', 4199, 32.84920000000, -106.06190000000, '110543'),
(15172, 'US-TX-110544', 'La Marque', 'CI', 4214, 29.37320000000, -95.00350000000, '110544'),
(15173, 'US-IL-110545', 'Compton', 'CI', 4180, 41.71510000000, -89.09140000000, '110545'),
(15174, 'US-PA-110546', 'Jackson Center', 'CI', 4208, 41.28150000000, -80.10950000000, '110546'),
(15175, 'US-OH-110547', 'Cambridge', 'CI', 4204, 40.03930000000, -81.58430000000, '110547'),
(15176, 'US-MO-110548', 'Burfordville', 'CI', 4193, 37.35980000000, -89.75080000000, '110548'),
(15177, 'US-WY-110549', 'Rawlins', 'CI', 4222, 42.04420000000, -107.42980000000, '110549'),
(15178, 'US-MD-110550', 'Woodsboro', 'CI', 4188, 39.53330000000, -77.29700000000, '110550'),
(15179, 'US-SC-110551', 'Chesnee', 'CI', 4211, 35.11210000000, -81.91540000000, '110551'),
(15180, 'US-NE-110552', 'Neligh', 'CI', 4195, 42.18260000000, -97.98130000000, '110552'),
(15181, 'US-CA-110553', 'Glenn', 'CI', 4169, 39.60390000000, -122.02520000000, '110553'),
(15182, 'US-IN-110554', 'Morgantown', 'CI', 4181, 39.37020000000, -86.27740000000, '110554'),
(15183, 'US-KS-110555', 'Elwood', 'CI', 4183, 39.75960000000, -94.87520000000, '110555'),
(15184, 'US-OH-110556', 'London', 'CI', 4204, 39.89790000000, -83.38660000000, '110556'),
(15185, 'US-MI-110557', 'Negaunee', 'CI', 4190, 46.51720000000, -87.60340000000, '110557'),
(15186, 'US-NC-110558', 'Calabash', 'CI', 4201, 33.91820000000, -78.59990000000, '110558'),
(15187, 'US-KS-110559', 'Arkansas City', 'CI', 4183, 37.09310000000, -96.95580000000, '110559'),
(15188, 'US-AK-110560', 'Homer', 'CI', 4162, 59.40390000000, -151.32390000000, '110560'),
(15189, 'US-PA-110561', 'Elverson', 'CI', 4208, 40.15930000000, -75.80400000000, '110561'),
(15190, 'US-MS-110562', 'Waynesboro', 'CI', 4192, 31.68650000000, -88.68450000000, '110562'),
(15191, 'US-MD-110563', 'Barnesville', 'CI', 4188, 39.22300000000, -77.37460000000, '110563'),
(15192, 'US-TX-110564', 'Kempner', 'CI', 4214, 31.09790000000, -97.99650000000, '110564'),
(15193, 'US-TX-110565', 'Lampasas', 'CI', 4214, 31.17030000000, -98.22320000000, '110565'),
(15194, 'US-WI-110566', 'Neenah', 'CI', 4221, 44.18430000000, -88.53050000000, '110566'),
(15195, 'US-WI-110567', 'Fall River', 'CI', 4221, 43.42080000000, -89.05120000000, '110567'),
(15196, 'US-TX-110568', 'Riesel', 'CI', 4214, 31.45610000000, -96.89170000000, '110568'),
(15197, 'US-TX-110569', 'Itasca', 'CI', 4214, 32.15640000000, -97.15090000000, '110569'),
(15198, 'US-MI-110570', 'Charlevoix', 'CI', 4190, 45.25100000000, -85.28070000000, '110570'),
(15199, 'US-MI-110571', 'Eaton Rapids', 'CI', 4190, 42.51030000000, -84.66370000000, '110571'),
(15200, 'US-LA-110572', 'Belle Chasse', 'CI', 4185, 29.78130000000, -90.04440000000, '110572'),
(15201, 'US-VA-110573', 'Fairfield', 'CI', 4218, 37.87700000000, -79.28930000000, '110573'),
(15202, 'US-IL-110574', 'Wasco', 'CI', 4180, 41.93950000000, -88.40150000000, '110574'),
(15203, 'US-IL-110575', 'Onarga', 'CI', 4180, 40.70100000000, -87.98310000000, '110575'),
(15204, 'US-CA-110576', 'Harbor City', 'CI', 4169, 33.79600000000, -118.29860000000, '110576'),
(15205, 'US-IL-110577', 'Oak Forest', 'CI', 4180, 41.60330000000, -87.75470000000, '110577'),
(15206, 'US-KS-110578', 'Baxter Springs', 'CI', 4183, 37.04790000000, -94.82230000000, '110578'),
(15207, 'US-PA-110579', 'Fombell', 'CI', 4208, 40.83690000000, -80.19980000000, '110579'),
(15208, 'US-NJ-110580', 'West New York', 'CI', 4198, 40.78790000000, -74.01020000000, '110580'),
(15209, 'US-TX-110581', 'Joaquin', 'CI', 4214, 31.92810000000, -94.06820000000, '110581'),
(15210, 'US-AR-110582', 'Crawfordsville', 'CI', 4165, 35.24850000000, -90.32640000000, '110582'),
(15211, 'US-CO-110583', 'Eagle', 'CI', 4170, 39.61010000000, -106.79910000000, '110583'),
(15212, 'US-TX-110584', 'Bandera', 'CI', 4214, 29.73310000000, -99.12940000000, '110584'),
(15213, 'US-CT-110585', 'Deep River', 'CI', 4171, 41.36800000000, -72.45640000000, '110585'),
(15214, 'US-NC-110586', 'Hudson', 'CI', 4201, 35.84480000000, -81.47880000000, '110586'),
(15215, 'US-MO-110587', 'Gravois Mills', 'CI', 4193, 38.24190000000, -92.85480000000, '110587'),
(15216, 'US-MO-110588', 'Cuba', 'CI', 4193, 38.11550000000, -91.41840000000, '110588'),
(15217, 'US-IL-110589', 'Mound City', 'CI', 4180, 37.09130000000, -89.16470000000, '110589'),
(15218, 'US-FL-110590', 'Middleburg', 'CI', 4175, 30.08310000000, -81.86300000000, '110590'),
(15219, 'US-FL-110591', 'Sanderson', 'CI', 4175, 30.35460000000, -82.32980000000, '110591'),
(15220, 'US-TX-110592', 'Rockport', 'CI', 4214, 28.03800000000, -97.09370000000, '110592'),
(15221, 'US-WA-110593', 'Port Gamble', 'CI', 4219, 47.83690000000, -122.59440000000, '110593'),
(15222, 'US-IN-110594', 'Fortville', 'CI', 4181, 39.92680000000, -85.84140000000, '110594'),
(15223, 'US-CA-110595', 'Byron', 'CI', 4169, 37.85260000000, -121.62310000000, '110595'),
(15224, 'US-TX-110596', 'Edna', 'CI', 4214, 29.03520000000, -96.73700000000, '110596'),
(15225, 'US-TX-110597', 'Cuero', 'CI', 4214, 29.11590000000, -97.27120000000, '110597'),
(15226, 'US-OH-110598', 'Chippewa Lake', 'CI', 4204, 41.06960000000, -81.89820000000, '110598'),
(15227, 'US-OH-110599', 'Columbiana', 'CI', 4204, 40.89060000000, -80.67560000000, '110599'),
(15228, 'US-VA-110600', 'Callaway', 'CI', 4218, 37.05320000000, -80.09630000000, '110600'),
(15229, 'US-OH-110601', 'Lockbourne', 'CI', 4204, 39.80140000000, -82.98950000000, '110601'),
(15230, 'US-AR-110602', 'Bauxite', 'CI', 4165, 34.51370000000, -92.47740000000, '110602'),
(15231, 'US-MT-110603', 'Ennis', 'CI', 4194, 45.28740000000, -111.71910000000, '110603'),
(15232, 'US-CA-110604', 'Jamul', 'CI', 4169, 32.69980000000, -116.80380000000, '110604'),
(15233, 'US-CA-110605', 'Pauma Valley', 'CI', 4169, 33.30430000000, -116.92390000000, '110605'),
(15234, 'US-WI-110606', 'Randolph', 'CI', 4221, 43.54970000000, -89.02380000000, '110606'),
(15235, 'US-IN-110607', 'Lynnville', 'CI', 4181, 38.18390000000, -87.30120000000, '110607'),
(15236, 'US-IN-110608', 'Memphis', 'CI', 4181, 38.48540000000, -85.75890000000, '110608'),
(15237, 'US-IN-110609', 'Georgetown', 'CI', 4181, 38.30820000000, -85.98420000000, '110609'),
(15238, 'US-NJ-110610', 'Wyckoff', 'CI', 4198, 40.99870000000, -74.16450000000, '110610'),
(15239, 'US-CT-110611', 'Jewett City', 'CI', 4171, 41.58110000000, -71.95540000000, '110611'),
(15240, 'US-PA-110612', 'Indiana', 'CI', 4208, 40.62240000000, -79.14540000000, '110612'),
(15241, 'US-FL-110613', 'Beverly Hills', 'CI', 4175, 28.93450000000, -82.47230000000, '110613'),
(15242, 'US-AR-110614', 'Bella Vista', 'CI', 4165, 36.45050000000, -94.23140000000, '110614'),
(15243, 'US-NE-110615', 'Henderson', 'CI', 4195, 40.77120000000, -97.78800000000, '110615'),
(15244, 'US-CA-110616', 'Santee', 'CI', 4169, 32.85610000000, -116.99680000000, '110616'),
(15245, 'US-NJ-110617', 'Manchester Township', 'CI', 4198, 39.97420000000, -74.34510000000, '110617'),
(15246, 'US-NC-110618', 'Ocean Isle Beach', 'CI', 4201, 33.92590000000, -78.44980000000, '110618'),
(15247, 'US-MN-110619', 'Prior Lake', 'CI', 4191, 44.67420000000, -93.41030000000, '110619'),
(15248, 'US-MO-110620', 'Old Appleton', 'CI', 4193, 37.59110000000, -89.70450000000, '110620'),
(15249, 'US-LA-110621', 'New Roads', 'CI', 4185, 30.68760000000, -91.46560000000, '110621'),
(15250, 'US-CA-110622', 'Pico Rivera', 'CI', 4169, 33.98640000000, -118.08840000000, '110622'),
(15251, 'US-IL-110623', 'Mascoutah', 'CI', 4180, 38.45560000000, -89.77090000000, '110623'),
(15252, 'US-WY-110624', 'Chugwater', 'CI', 4222, 41.75490000000, -104.77850000000, '110624'),
(15253, 'US-VA-110625', 'Hamilton', 'CI', 4218, 39.13880000000, -77.65160000000, '110625'),
(15254, 'US-CA-110626', 'Carmel Valley', 'CI', 4169, 36.39170000000, -121.65380000000, '110626'),
(15255, 'US-NY-110627', 'Mechanicville', 'CI', 4200, 42.91730000000, -73.73490000000, '110627'),
(15256, 'US-KY-110628', 'Woodburn', 'CI', 4184, 36.84590000000, -86.56600000000, '110628'),
(15257, 'US-MA-110629', 'Sutton', 'CI', 4189, 42.13650000000, -71.75590000000, '110629'),
(15258, 'US-MI-110630', 'Ecorse', 'CI', 4190, 42.24960000000, -83.14360000000, '110630'),
(15259, 'US-WI-110631', 'Sister Bay', 'CI', 4221, 45.18950000000, -87.10020000000, '110631'),
(15260, 'US-HI-110632', 'Mililani', 'CI', 4178, 21.47010000000, -157.96370000000, '110632'),
(15261, 'US-WI-110633', 'New London', 'CI', 4221, 44.40330000000, -88.78620000000, '110633'),
(15262, 'US-WI-110634', 'Saukville', 'CI', 4221, 43.41060000000, -87.97960000000, '110634'),
(15263, 'US-IL-110635', 'Olympia Fields', 'CI', 4180, 41.51600000000, -87.68890000000, '110635'),
(15264, 'US-TX-110636', 'Royse City', 'CI', 4214, 32.94780000000, -96.31390000000, '110636'),
(15265, 'US-CA-110637', 'Three Rivers', 'CI', 4169, 36.44070000000, -118.86040000000, '110637'),
(15266, 'US-MS-110638', 'Louisville', 'CI', 4192, 33.10280000000, -89.05190000000, '110638'),
(15267, 'US-CA-110639', 'Niland', 'CI', 4169, 33.30550000000, -115.55730000000, '110639'),
(15268, 'US-CA-110640', 'Campo', 'CI', 4169, 32.68660000000, -116.47520000000, '110640'),
(15269, 'US-PA-110641', 'Colver', 'CI', 4208, 40.54020000000, -78.78350000000, '110641'),
(15270, 'US-SC-110642', 'Holly Hill', 'CI', 4211, 33.30150000000, -80.42880000000, '110642'),
(15271, 'US-IL-110643', 'Louisville', 'CI', 4180, 38.81460000000, -88.51920000000, '110643'),
(15272, 'US-IL-110644', 'Girard', 'CI', 4180, 39.41200000000, -89.81280000000, '110644'),
(15273, 'US-TX-110645', 'Lorena', 'CI', 4214, 31.39680000000, -97.17480000000, '110645'),
(15274, 'US-WI-110646', 'Plover', 'CI', 4221, 44.42290000000, -89.53690000000, '110646'),
(15275, 'US-CA-110647', 'Klamath', 'CI', 4169, 41.59930000000, -124.06950000000, '110647'),
(15276, 'US-MI-110648', 'Rockford', 'CI', 4190, 43.11880000000, -85.49430000000, '110648'),
(15277, 'US-ID-110649', 'Kootenai', 'CI', 4179, 48.33530000000, -116.47000000000, '110649'),
(15278, 'US-TX-110650', 'Seagoville', 'CI', 4214, 32.59560000000, -96.55840000000, '110650'),
(15279, 'US-TX-110651', 'Quinlan', 'CI', 4214, 32.91870000000, -96.11410000000, '110651'),
(15280, 'US-IN-110652', 'Grammer', 'CI', 4181, 39.15220000000, -85.72610000000, '110652'),
(15281, 'US-IL-110653', 'Villa Grove', 'CI', 4180, 39.85420000000, -88.15070000000, '110653'),
(15282, 'US-IN-110654', 'Cannelburg', 'CI', 4181, 38.60440000000, -86.99120000000, '110654'),
(15283, 'US-IN-110655', 'Trafalgar', 'CI', 4181, 39.36650000000, -86.15940000000, '110655'),
(15284, 'US-MI-110656', 'Auburn', 'CI', 4190, 43.63930000000, -84.08830000000, '110656'),
(15285, 'US-CA-110657', 'Quincy', 'CI', 4169, 39.96740000000, -121.00220000000, '110657'),
(15286, 'US-CA-110658', 'Ione', 'CI', 4169, 38.33890000000, -120.88750000000, '110658'),
(15287, 'US-IL-110659', 'Sheridan', 'CI', 4180, 41.50600000000, -88.65200000000, '110659'),
(15288, 'US-TX-110660', 'Keller', 'CI', 4214, 32.93420000000, -97.25150000000, '110660'),
(15289, 'US-TX-110661', 'Haskell', 'CI', 4214, 33.10980000000, -99.65910000000, '110661'),
(15290, 'US-TX-110662', 'Munday', 'CI', 4214, 33.49970000000, -99.61630000000, '110662'),
(15291, 'US-TX-110663', 'Mineral Wells', 'CI', 4214, 32.79230000000, -98.13880000000, '110663'),
(15292, 'US-TX-110664', 'Graham', 'CI', 4214, 33.11770000000, -98.68690000000, '110664'),
(15293, 'US-CA-110665', 'Bonita', 'CI', 4169, 32.67730000000, -117.01230000000, '110665'),
(15294, 'US-CT-110666', 'Marlborough', 'CI', 4171, 41.63630000000, -72.45680000000, '110666'),
(15295, 'US-MA-110667', 'Williamstown', 'CI', 4189, 42.64420000000, -73.24630000000, '110667'),
(15296, 'US-NC-110668', 'Midland', 'CI', 4201, 35.24450000000, -80.51640000000, '110668'),
(15297, 'US-IL-110669', 'Hartsburg', 'CI', 4180, 40.24020000000, -89.47400000000, '110669'),
(15298, 'US-TX-110670', 'Eagle Pass', 'CI', 4214, 28.73640000000, -100.45210000000, '110670'),
(15299, 'US-TX-110671', 'San Ygnacio', 'CI', 4214, 27.14590000000, -99.29180000000, '110671'),
(15300, 'US-TX-110672', 'Karnes City', 'CI', 4214, 28.92270000000, -97.90220000000, '110672'),
(15301, 'US-TX-110673', 'Marquez', 'CI', 4214, 31.22750000000, -96.21080000000, '110673'),
(15302, 'US-TX-110674', 'Pittsburg', 'CI', 4214, 32.96420000000, -94.92750000000, '110674'),
(15303, 'US-TX-110675', 'Nash', 'CI', 4214, 33.43440000000, -94.12190000000, '110675'),
(15304, 'US-MI-110676', 'Clio', 'CI', 4190, 43.17760000000, -83.70720000000, '110676'),
(15305, 'US-MI-110677', 'Kawkawlin', 'CI', 4190, 43.68840000000, -84.00860000000, '110677'),
(15306, 'US-LA-110678', 'Haughton', 'CI', 4185, 32.57610000000, -93.59090000000, '110678'),
(15307, 'US-AR-110679', 'Hope', 'CI', 4165, 33.65250000000, -93.60390000000, '110679'),
(15308, 'US-TX-110680', 'Warren', 'CI', 4214, 30.60770000000, -94.41630000000, '110680'),
(15309, 'US-TX-110681', 'Simonton', 'CI', 4214, 29.67780000000, -95.99210000000, '110681'),
(15310, 'US-MO-110682', 'High Ridge', 'CI', 4193, 38.47790000000, -90.53470000000, '110682'),
(15311, 'US-MO-110683', 'Ellington', 'CI', 4193, 37.22920000000, -90.97130000000, '110683'),
(15312, 'US-CA-110684', 'Castro Valley', 'CI', 4169, 37.70900000000, -122.08850000000, '110684'),
(15313, 'US-NE-110685', 'Gibbon', 'CI', 4195, 40.77420000000, -98.88420000000, '110685'),
(15314, 'US-NE-110686', 'Cozad', 'CI', 4195, 40.93870000000, -99.98600000000, '110686'),
(15315, 'US-MS-110687', 'De Kalb', 'CI', 4192, 32.75390000000, -88.72190000000, '110687'),
(15316, 'US-IL-110688', 'Homewood', 'CI', 4180, 41.55830000000, -87.66120000000, '110688'),
(15317, 'US-IN-110689', 'East Chicago', 'CI', 4181, 41.64630000000, -87.45280000000, '110689'),
(15318, 'US-OK-110690', 'Amber', 'CI', 4205, 35.15260000000, -97.85140000000, '110690'),
(15319, 'US-OK-110691', 'Purcell', 'CI', 4205, 35.02980000000, -97.47100000000, '110691'),
(15320, 'US-OK-110692', 'Bethany', 'CI', 4205, 35.51850000000, -97.64280000000, '110692'),
(15321, 'US-CA-110693', 'Atascadero', 'CI', 4169, 35.45730000000, -120.71920000000, '110693'),
(15322, 'US-IL-110694', 'Petersburg', 'CI', 4180, 40.01800000000, -89.86230000000, '110694'),
(15323, 'US-IL-110695', 'Warrensburg', 'CI', 4180, 39.94290000000, -89.07760000000, '110695'),
(15324, 'US-TX-110696', 'Uvalde', 'CI', 4214, 29.35660000000, -99.83130000000, '110696'),
(15325, 'US-WI-110697', 'River Falls', 'CI', 4221, 44.83710000000, -92.59170000000, '110697'),
(15326, 'US-WI-110698', 'Amery', 'CI', 4221, 45.33140000000, -92.36950000000, '110698'),
(15327, 'US-WI-110699', 'Ellsworth', 'CI', 4221, 44.70140000000, -92.47350000000, '110699'),
(15328, 'US-FL-110700', 'Wesley Chapel', 'CI', 4175, 28.27220000000, -82.33220000000, '110700'),
(15329, 'US-VA-110701', 'Henry', 'CI', 4218, 36.84270000000, -79.99710000000, '110701'),
(15330, 'US-WV-110702', 'Pineville', 'CI', 4220, 37.56720000000, -81.52860000000, '110702'),
(15331, 'US-NM-110703', 'Mayhill', 'CI', 4199, 32.96330000000, -105.30570000000, '110703'),
(15332, 'US-AZ-110704', 'Window Rock', 'CI', 4164, 35.66100000000, -109.10220000000, '110704'),
(15333, 'US-MA-110705', 'Newtonville', 'CI', 4189, 42.35220000000, -71.20980000000, '110705'),
(15334, 'US-MS-110706', 'Eupora', 'CI', 4192, 33.55640000000, -89.32950000000, '110706'),
(15335, 'US-AR-110707', 'Marion', 'CI', 4165, 35.22790000000, -90.18780000000, '110707'),
(15336, 'US-ID-110708', 'Smelterville', 'CI', 4179, 47.52150000000, -116.18630000000, '110708'),
(15337, 'US-AR-110709', 'Heber Springs', 'CI', 4165, 35.44790000000, -91.99770000000, '110709'),
(15338, 'US-AR-110710', 'Mena', 'CI', 4165, 34.59140000000, -94.19510000000, '110710'),
(15339, 'US-AR-110711', 'Drasco', 'CI', 4165, 35.62900000000, -91.93240000000, '110711'),
(15340, 'US-SD-110712', 'Aberdeen', 'CI', 4212, 45.48190000000, -98.50640000000, '110712'),
(15341, 'US-NE-110713', 'Carleton', 'CI', 4195, 40.28700000000, -97.66130000000, '110713'),
(15342, 'US-MN-110714', 'Monticello', 'CI', 4191, 45.29570000000, -93.81130000000, '110714'),
(15343, 'US-TX-110715', 'Ransom Canyon', 'CI', 4214, 33.51510000000, -101.67560000000, '110715'),
(15344, 'US-IL-110716', 'National Stock Yards', 'CI', 4180, 38.64670000000, -90.15790000000, '110716'),
(15345, 'US-LA-110717', 'Carencro', 'CI', 4185, 30.33600000000, -92.04650000000, '110717'),
(15346, 'US-LA-110718', 'Morgan City', 'CI', 4185, 29.69970000000, -91.06550000000, '110718'),
(15347, 'US-MS-110719', 'Flowood', 'CI', 4192, 32.32230000000, -90.10870000000, '110719'),
(15348, 'US-TX-110720', 'Lockhart', 'CI', 4214, 29.89730000000, -97.67830000000, '110720'),
(15349, 'US-NY-110721', 'Ghent', 'CI', 4200, 42.30850000000, -73.61440000000, '110721'),
(15350, 'US-IA-110722', 'Fort Madison', 'CI', 4182, 40.66620000000, -91.34920000000, '110722'),
(15351, 'US-WI-110723', 'Nashotah', 'CI', 4221, 43.11080000000, -88.40310000000, '110723'),
(15352, 'US-MI-110724', 'Eastpointe', 'CI', 4190, 42.46510000000, -82.94410000000, '110724'),
(15353, 'US-IL-110725', 'Poplar Grove', 'CI', 4180, 42.39980000000, -88.82710000000, '110725'),
(15354, 'US-AL-110726', 'Centreville', 'CI', 4161, 32.90390000000, -87.08510000000, '110726'),
(15355, 'US-KS-110727', 'Pleasanton', 'CI', 4183, 38.18610000000, -94.70570000000, '110727'),
(15356, 'US-KS-110728', 'Mcconnell Afb', 'CI', 4183, 37.62820000000, -97.26630000000, '110728'),
(15357, 'US-OK-110729', 'Owasso', 'CI', 4205, 36.26430000000, -95.82770000000, '110729'),
(15358, 'US-KS-110730', 'South Hutchinson', 'CI', 4183, 38.02820000000, -97.94850000000, '110730'),
(15359, 'US-KS-110731', 'Spivey', 'CI', 4183, 37.47180000000, -98.12670000000, '110731'),
(15360, 'US-KS-110732', 'Winfield', 'CI', 4183, 37.25480000000, -96.98130000000, '110732'),
(15361, 'US-NY-110733', 'Morrisville', 'CI', 4200, 42.92440000000, -75.65720000000, '110733'),
(15362, 'US-CO-110734', 'Brush', 'CI', 4170, 40.16770000000, -103.53680000000, '110734'),
(15363, 'US-NV-110735', 'Caliente', 'CI', 4196, 37.32440000000, -114.53910000000, '110735'),
(15364, 'US-MI-110736', 'Olivet', 'CI', 4190, 42.43640000000, -84.88550000000, '110736'),
(15365, 'US-WI-110737', 'Menasha', 'CI', 4221, 44.20880000000, -88.34200000000, '110737'),
(15366, 'US-WI-110738', 'Marinette', 'CI', 4221, 45.09010000000, -87.71010000000, '110738'),
(15367, 'US-CA-110739', 'Point Reyes Station', 'CI', 4169, 38.07380000000, -122.86200000000, '110739'),
(15368, 'US-ME-110740', 'Brooklin', 'CI', 4186, 44.28550000000, -68.57270000000, '110740'),
(15369, 'US-UT-110741', 'Castle Dale', 'CI', 4215, 39.20750000000, -110.92040000000, '110741'),
(15370, 'US-IN-110742', 'Bloomfield', 'CI', 4181, 39.03590000000, -86.83930000000, '110742'),
(15371, 'US-IL-110743', 'Marshall', 'CI', 4180, 39.38830000000, -87.70470000000, '110743'),
(15372, 'US-IN-110744', 'Cicero', 'CI', 4181, 40.12660000000, -86.08070000000, '110744'),
(15373, 'US-CA-110745', 'Frazier Park', 'CI', 4169, 34.80470000000, -119.01850000000, '110745'),
(15374, 'US-MO-110746', 'Webb City', 'CI', 4193, 37.18470000000, -94.47380000000, '110746'),
(15375, 'US-AR-110747', 'Eureka Springs', 'CI', 4165, 36.43370000000, -93.81620000000, '110747'),
(15376, 'US-OH-110748', 'Covington', 'CI', 4204, 40.12450000000, -84.34060000000, '110748'),
(15377, 'US-MI-110749', 'Hazel Park', 'CI', 4190, 42.46180000000, -83.09850000000, '110749'),
(15378, 'US-MI-110750', 'Genesee', 'CI', 4190, 43.10430000000, -83.63870000000, '110750'),
(15379, 'US-MI-110751', 'Metamora', 'CI', 4190, 42.94310000000, -83.29980000000, '110751'),
(15380, 'US-WI-110752', 'Cedarburg', 'CI', 4221, 43.32080000000, -88.03140000000, '110752'),
(15381, 'US-IL-110753', 'Coal City', 'CI', 4180, 41.29530000000, -88.28700000000, '110753');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(15382, 'US-MD-110754', 'Myersville', 'CI', 4188, 39.53650000000, -77.55630000000, '110754'),
(15383, 'US-FL-110755', 'Webster', 'CI', 4175, 28.52990000000, -82.09020000000, '110755'),
(15384, 'US-IN-110756', 'Boswell', 'CI', 4181, 40.47310000000, -87.36620000000, '110756'),
(15385, 'US-VA-110757', 'Broad Run', 'CI', 4218, 38.81500000000, -77.70970000000, '110757'),
(15386, 'US-TX-110758', 'Powderly', 'CI', 4214, 33.80900000000, -95.46190000000, '110758'),
(15387, 'US-MN-110759', 'Minnetonka', 'CI', 4191, 44.91980000000, -93.48320000000, '110759'),
(15388, 'US-IL-110760', 'Riverton', 'CI', 4180, 39.86060000000, -89.50580000000, '110760'),
(15389, 'US-MO-110761', 'Bloomsdale', 'CI', 4193, 38.03810000000, -90.23040000000, '110761'),
(15390, 'US-OK-110762', 'Canton', 'CI', 4205, 36.03180000000, -98.68080000000, '110762'),
(15391, 'US-OK-110763', 'Beaver', 'CI', 4205, 36.74740000000, -100.47680000000, '110763'),
(15392, 'US-WI-110764', 'Sauk City', 'CI', 4221, 43.26260000000, -89.84670000000, '110764'),
(15393, 'US-CA-110765', 'Tecopa', 'CI', 4169, 35.85190000000, -116.22510000000, '110765'),
(15394, 'US-WI-110766', 'Hammond', 'CI', 4221, 45.00700000000, -92.45910000000, '110766'),
(15395, 'US-FL-110767', 'Dunedin', 'CI', 4175, 28.02880000000, -82.76890000000, '110767'),
(15396, 'US-WY-110768', 'Mills', 'CI', 4222, 42.86640000000, -106.41020000000, '110768'),
(15397, 'US-VA-110769', 'Fancy Gap', 'CI', 4218, 36.65610000000, -80.68220000000, '110769'),
(15398, 'US-IA-110770', 'Keokuk', 'CI', 4182, 40.45200000000, -91.45580000000, '110770'),
(15399, 'US-CA-110771', 'Corona Del Mar', 'CI', 4169, 33.60230000000, -117.86480000000, '110771'),
(15400, 'US-CA-110772', 'Wilton', 'CI', 4169, 38.39260000000, -121.24290000000, '110772'),
(15401, 'US-CA-110773', 'Jackson', 'CI', 4169, 38.35180000000, -120.77470000000, '110773'),
(15402, 'US-NE-110774', 'Mead', 'CI', 4195, 41.24110000000, -96.48860000000, '110774'),
(15403, 'US-VA-110775', 'Windsor', 'CI', 4218, 36.84840000000, -76.71040000000, '110775'),
(15404, 'US-TX-110776', 'Jourdanton', 'CI', 4214, 28.82910000000, -98.55060000000, '110776'),
(15405, 'US-TX-110777', 'Yoakum', 'CI', 4214, 29.18140000000, -97.10550000000, '110777'),
(15406, 'US-TX-110778', 'Mercedes', 'CI', 4214, 26.18840000000, -97.92320000000, '110778'),
(15407, 'US-TX-110779', 'Coyanosa', 'CI', 4214, 31.18210000000, -103.09650000000, '110779'),
(15408, 'US-PA-110780', 'Upper Darby', 'CI', 4208, 39.95940000000, -75.27280000000, '110780'),
(15409, 'US-NC-110781', 'Rougemont', 'CI', 4201, 36.25350000000, -78.89850000000, '110781'),
(15410, 'US-NC-110782', 'Winnabow', 'CI', 4201, 34.12660000000, -78.06520000000, '110782'),
(15411, 'US-MO-110783', 'Marquand', 'CI', 4193, 37.39060000000, -90.19730000000, '110783'),
(15412, 'US-TX-110784', 'Bastrop', 'CI', 4214, 30.14060000000, -97.32750000000, '110784'),
(15413, 'US-NC-110785', 'Albemarle', 'CI', 4201, 35.34000000000, -80.21080000000, '110785'),
(15414, 'US-NY-110786', 'Fayetteville', 'CI', 4200, 43.03080000000, -75.99970000000, '110786'),
(15415, 'US-MI-110787', 'South Lyon', 'CI', 4190, 42.44140000000, -83.65420000000, '110787'),
(15416, 'US-MI-110788', 'Beulah', 'CI', 4190, 44.64000000000, -86.03650000000, '110788'),
(15417, 'US-OK-110789', 'Weatherford', 'CI', 4205, 35.52240000000, -98.73310000000, '110789'),
(15418, 'US-IL-110790', 'Carterville', 'CI', 4180, 37.78610000000, -89.07760000000, '110790'),
(15419, 'US-LA-110791', 'Golden Meadow', 'CI', 4185, 29.29220000000, -90.20200000000, '110791'),
(15420, 'US-FL-110792', 'Milton', 'CI', 4175, 30.66680000000, -87.18500000000, '110792'),
(15421, 'US-LA-110793', 'Saint Gabriel', 'CI', 4185, 30.25100000000, -91.08750000000, '110793'),
(15422, 'US-OH-110794', 'North Royalton', 'CI', 4204, 41.31460000000, -81.74490000000, '110794'),
(15423, 'US-WI-110795', 'Columbus', 'CI', 4221, 43.34160000000, -89.05530000000, '110795'),
(15424, 'US-NC-110796', 'Andrews', 'CI', 4201, 35.19760000000, -83.80490000000, '110796'),
(15425, 'US-IL-110797', 'Wilmington', 'CI', 4180, 41.30660000000, -88.11970000000, '110797'),
(15426, 'US-NV-110798', 'Verdi', 'CI', 4196, 39.51650000000, -119.98050000000, '110798'),
(15427, 'US-TX-110799', 'Cypress', 'CI', 4214, 29.98780000000, -95.65500000000, '110799'),
(15428, 'US-TX-110800', 'Buna', 'CI', 4214, 30.39910000000, -93.90880000000, '110800'),
(15429, 'US-NE-110801', 'Stuart', 'CI', 4195, 42.64020000000, -99.13420000000, '110801'),
(15430, 'US-OK-110802', 'Luther', 'CI', 4205, 35.68850000000, -97.19620000000, '110802'),
(15431, 'US-VA-110803', 'Spotsylvania', 'CI', 4218, 38.19720000000, -77.68210000000, '110803'),
(15432, 'US-NE-110804', 'Seward', 'CI', 4195, 40.91950000000, -97.11090000000, '110804'),
(15433, 'US-NM-110805', 'Pueblo Of Acoma', 'CI', 4199, 35.08470000000, -107.59850000000, '110805'),
(15434, 'US-NM-110806', 'Santa Rosa', 'CI', 4199, 34.89980000000, -104.81850000000, '110806'),
(15435, 'US-IA-110807', 'Waukee', 'CI', 4182, 41.60370000000, -93.87530000000, '110807'),
(15436, 'US-IL-110808', 'Lake In The Hills', 'CI', 4180, 42.18700000000, -88.34650000000, '110808'),
(15437, 'US-IL-110809', 'Harvard', 'CI', 4180, 42.40410000000, -88.60230000000, '110809'),
(15438, 'US-FL-110810', 'Belleview', 'CI', 4175, 29.05630000000, -82.02570000000, '110810'),
(15439, 'US-IL-110811', 'Hazel Crest', 'CI', 4180, 41.56800000000, -87.69340000000, '110811'),
(15440, 'US-IL-110812', 'Riverdale', 'CI', 4180, 41.64490000000, -87.62460000000, '110812'),
(15441, 'US-GA-110813', 'Calhoun', 'CI', 4176, 34.49430000000, -84.91120000000, '110813'),
(15442, 'US-DE-110814', 'Milford', 'CI', 4172, 38.94180000000, -75.36760000000, '110814'),
(15443, 'US-NC-110815', 'Coats', 'CI', 4201, 35.41660000000, -78.65730000000, '110815'),
(15444, 'US-NC-110816', 'Richlands', 'CI', 4201, 34.87910000000, -77.59060000000, '110816'),
(15445, 'US-AL-110817', 'Northport', 'CI', 4161, 33.21990000000, -87.58510000000, '110817'),
(15446, 'US-AL-110818', 'Ozark', 'CI', 4161, 31.46270000000, -85.62670000000, '110818'),
(15447, 'US-IL-110819', 'Saint Jacob', 'CI', 4180, 38.70880000000, -89.79820000000, '110819'),
(15448, 'US-NJ-110820', 'Colts Neck', 'CI', 4198, 40.29090000000, -74.16520000000, '110820'),
(15449, 'US-CA-110821', 'Lakeport', 'CI', 4169, 39.04860000000, -122.93900000000, '110821'),
(15450, 'US-CA-110822', 'Mount Hermon', 'CI', 4169, 37.04820000000, -122.05120000000, '110822'),
(15451, 'US-TX-110823', 'Burkburnett', 'CI', 4214, 34.09780000000, -98.61630000000, '110823'),
(15452, 'US-OK-110824', 'Yukon', 'CI', 4205, 35.53310000000, -97.77070000000, '110824'),
(15453, 'US-TX-110825', 'Hillsboro', 'CI', 4214, 31.99690000000, -97.13740000000, '110825'),
(15454, 'US-TX-110826', 'Graford', 'CI', 4214, 32.89440000000, -98.30870000000, '110826'),
(15455, 'US-KS-110827', 'Parsons', 'CI', 4183, 37.33230000000, -95.26120000000, '110827'),
(15456, 'US-OK-110828', 'Chandler', 'CI', 4205, 35.70280000000, -96.86270000000, '110828'),
(15457, 'US-TX-110829', 'Snyder', 'CI', 4214, 32.89890000000, -100.91470000000, '110829'),
(15458, 'US-TX-110830', 'Desdemona', 'CI', 4214, 32.31140000000, -98.55980000000, '110830'),
(15459, 'US-OK-110831', 'Pond Creek', 'CI', 4205, 36.66240000000, -97.83970000000, '110831'),
(15460, 'US-OH-110832', 'Brookfield', 'CI', 4204, 41.24350000000, -80.57590000000, '110832'),
(15461, 'US-UT-110833', 'Saint George', 'CI', 4215, 37.06450000000, -113.57460000000, '110833'),
(15462, 'US-IL-110834', 'Anna', 'CI', 4180, 37.44440000000, -89.17050000000, '110834'),
(15463, 'US-CA-110835', 'Oakdale', 'CI', 4169, 37.80340000000, -120.74640000000, '110835'),
(15464, 'US-OH-110836', 'Bradner', 'CI', 4204, 41.33400000000, -83.43280000000, '110836'),
(15465, 'US-PA-110837', 'Darby', 'CI', 4208, 39.91800000000, -75.26920000000, '110837'),
(15466, 'US-PA-110838', 'Apollo', 'CI', 4208, 40.54050000000, -79.58620000000, '110838'),
(15467, 'US-AR-110839', 'Eudora', 'CI', 4165, 33.14780000000, -91.26380000000, '110839'),
(15468, 'US-IN-110840', 'Rolling Prairie', 'CI', 4181, 41.68000000000, -86.60300000000, '110840'),
(15469, 'US-AR-110841', 'Bryant', 'CI', 4165, 34.60080000000, -92.49110000000, '110841'),
(15470, 'US-IN-110842', 'Remington', 'CI', 4181, 40.75110000000, -87.16080000000, '110842'),
(15471, 'US-MO-110843', 'Seneca', 'CI', 4193, 36.84070000000, -94.56130000000, '110843'),
(15472, 'US-IL-110844', 'Griggsville', 'CI', 4180, 39.72880000000, -90.72980000000, '110844'),
(15473, 'US-PA-110845', 'Worthington', 'CI', 4208, 40.83890000000, -79.64020000000, '110845'),
(15474, 'US-TX-110846', 'Wilmer', 'CI', 4214, 32.60080000000, -96.67340000000, '110846'),
(15475, 'US-TX-110847', 'Liberty', 'CI', 4214, 30.09290000000, -94.74250000000, '110847'),
(15476, 'US-TX-110848', 'Pettus', 'CI', 4214, 28.61500000000, -97.80300000000, '110848'),
(15477, 'US-LA-110849', 'Lecompte', 'CI', 4185, 31.12550000000, -92.36790000000, '110849'),
(15478, 'US-MO-110850', 'Troy', 'CI', 4193, 38.99770000000, -90.98460000000, '110850'),
(15479, 'US-OH-110851', 'Mogadore', 'CI', 4204, 41.02990000000, -81.33670000000, '110851'),
(15480, 'US-CA-110852', 'Live Oak', 'CI', 4169, 39.23820000000, -121.78160000000, '110852'),
(15481, 'US-CA-110853', 'Richvale', 'CI', 4169, 39.49460000000, -121.74930000000, '110853'),
(15482, 'US-NV-110854', 'Washoe Valley', 'CI', 4196, 39.26330000000, -119.79900000000, '110854'),
(15483, 'US-CA-110855', 'Durham', 'CI', 4169, 39.61170000000, -121.77390000000, '110855'),
(15484, 'US-UT-110856', 'Vernal', 'CI', 4215, 40.55120000000, -109.56960000000, '110856'),
(15485, 'US-NV-110857', 'Duckwater', 'CI', 4196, 38.89270000000, -115.68020000000, '110857'),
(15486, 'US-TX-110858', 'Rio Hondo', 'CI', 4214, 26.26150000000, -97.48720000000, '110858'),
(15487, 'US-FL-110859', 'Valparaiso', 'CI', 4175, 30.50000000000, -86.52270000000, '110859'),
(15488, 'US-LA-110860', 'Geismar', 'CI', 4185, 30.19480000000, -91.00840000000, '110860'),
(15489, 'US-CA-110861', 'Phelan', 'CI', 4169, 34.42770000000, -117.48210000000, '110861'),
(15490, 'US-SD-110862', 'Clear Lake', 'CI', 4212, 44.78210000000, -96.71090000000, '110862'),
(15491, 'US-CT-110863', 'Greens Farms', 'CI', 4171, 41.12440000000, -73.31390000000, '110863'),
(15492, 'US-MA-110864', 'Salem', 'CI', 4189, 42.51530000000, -70.90750000000, '110864'),
(15493, 'US-IN-110865', 'Crane', 'CI', 4181, 38.85950000000, -86.84940000000, '110865'),
(15494, 'US-NJ-110866', 'North Arlington', 'CI', 4198, 40.78760000000, -74.12240000000, '110866'),
(15495, 'US-VA-110867', 'Emporia', 'CI', 4218, 36.72150000000, -77.53200000000, '110867'),
(15496, 'US-GA-110868', 'Sparks', 'CI', 4176, 31.20560000000, -83.42740000000, '110868'),
(15497, 'US-GA-110869', 'Wrens', 'CI', 4176, 33.18870000000, -82.35520000000, '110869'),
(15498, 'US-NC-110870', 'Ayden', 'CI', 4201, 35.44250000000, -77.40450000000, '110870'),
(15499, 'US-WA-110871', 'Vashon', 'CI', 4219, 47.42060000000, -122.45090000000, '110871'),
(15500, 'US-IL-110872', 'Marengo', 'CI', 4180, 42.24790000000, -88.60830000000, '110872'),
(15501, 'US-OH-110873', 'Clayton', 'CI', 4204, 39.85450000000, -84.33750000000, '110873'),
(15502, 'US-CA-110874', 'Chinese Camp', 'CI', 4169, 37.86910000000, -120.44290000000, '110874'),
(15503, 'US-CA-110875', 'Kerman', 'CI', 4169, 36.71440000000, -120.15610000000, '110875'),
(15504, 'US-CA-110876', 'Keyes', 'CI', 4169, 37.56070000000, -120.91360000000, '110876'),
(15505, 'US-CA-110877', 'Kings Canyon National Pk', 'CI', 4169, 36.72850000000, -118.95580000000, '110877'),
(15506, 'US-AR-110878', 'Lepanto', 'CI', 4165, 35.62470000000, -90.30710000000, '110878'),
(15507, 'US-OK-110879', 'Pauls Valley', 'CI', 4205, 34.73890000000, -97.23370000000, '110879'),
(15508, 'US-TX-110880', 'Rio Vista', 'CI', 4214, 32.22320000000, -97.40580000000, '110880'),
(15509, 'US-OH-110881', 'Berea', 'CI', 4204, 41.36700000000, -81.86470000000, '110881'),
(15510, 'US-TX-110882', 'Dumas', 'CI', 4214, 35.87870000000, -101.95080000000, '110882'),
(15511, 'US-AZ-110883', 'Avondale', 'CI', 4164, 33.44420000000, -112.31780000000, '110883'),
(15512, 'US-VA-110884', 'Laurel Fork', 'CI', 4218, 36.71110000000, -80.53810000000, '110884'),
(15513, 'US-TN-110885', 'Limestone', 'CI', 4213, 36.25700000000, -82.62320000000, '110885'),
(15514, 'US-OH-110886', 'Pataskala', 'CI', 4204, 40.00970000000, -82.67180000000, '110886'),
(15515, 'US-IL-110887', 'Hines', 'CI', 4180, 41.85400000000, -87.83340000000, '110887'),
(15516, 'US-OH-110888', 'Ironton', 'CI', 4204, 38.56500000000, -82.67720000000, '110888'),
(15517, 'US-TX-110889', 'Gordon', 'CI', 4214, 32.55760000000, -98.34570000000, '110889'),
(15518, 'US-CA-110890', 'Willows', 'CI', 4169, 39.50410000000, -122.28250000000, '110890'),
(15519, 'US-WA-110891', 'Pasco', 'CI', 4219, 46.41820000000, -118.90030000000, '110891'),
(15520, 'US-ID-110892', 'Harrison', 'CI', 4179, 47.54560000000, -116.70620000000, '110892'),
(15521, 'US-PA-110893', 'Havertown', 'CI', 4208, 39.97520000000, -75.31220000000, '110893'),
(15522, 'US-TX-110894', 'Celina', 'CI', 4214, 33.33600000000, -96.74910000000, '110894'),
(15523, 'US-CA-110895', 'Atwater', 'CI', 4169, 37.32550000000, -120.63670000000, '110895'),
(15524, 'US-CA-110896', 'Cabazon', 'CI', 4169, 33.93260000000, -116.77200000000, '110896'),
(15525, 'US-KS-110897', 'Marion', 'CI', 4183, 38.36960000000, -96.98510000000, '110897'),
(15526, 'US-KS-110898', 'Frontenac', 'CI', 4183, 37.46230000000, -94.69990000000, '110898'),
(15527, 'US-KS-110899', 'Lansing', 'CI', 4183, 39.25600000000, -94.88350000000, '110899'),
(15528, 'US-ME-110900', 'Phippsburg', 'CI', 4186, 43.79000000000, -69.82710000000, '110900'),
(15529, 'US-NH-110901', 'Peterborough', 'CI', 4197, 42.86650000000, -71.96050000000, '110901'),
(15530, 'US-IL-110902', 'Cairo', 'CI', 4180, 37.04040000000, -89.20080000000, '110902'),
(15531, 'US-CT-110903', 'Killingworth', 'CI', 4171, 41.37640000000, -72.58330000000, '110903'),
(15532, 'US-MI-110904', 'West Branch', 'CI', 4190, 44.34150000000, -84.18760000000, '110904'),
(15533, 'US-IN-110905', 'Danville', 'CI', 4181, 39.76120000000, -86.55220000000, '110905'),
(15534, 'US-OK-110906', 'Pryor', 'CI', 4205, 36.32190000000, -95.28260000000, '110906'),
(15535, 'US-MS-110907', 'Clarksdale', 'CI', 4192, 34.17290000000, -90.60750000000, '110907'),
(15536, 'US-MS-110908', 'Tutwiler', 'CI', 4192, 34.01480000000, -90.37650000000, '110908'),
(15537, 'US-CA-110909', 'National City', 'CI', 4169, 32.67070000000, -117.09460000000, '110909'),
(15538, 'US-CA-110910', 'Laguna Niguel', 'CI', 4169, 33.53510000000, -117.70520000000, '110910'),
(15539, 'US-TX-110911', 'Kemah', 'CI', 4214, 29.53320000000, -95.02150000000, '110911'),
(15540, 'US-HI-110912', 'Fort Shafter', 'CI', 4178, 24.85980000000, -168.02180000000, '110912'),
(15541, 'US-IL-110913', 'Durand', 'CI', 4180, 42.43020000000, -89.28390000000, '110913'),
(15542, 'US-NY-110914', 'Canaan', 'CI', 4200, 42.40570000000, -73.43010000000, '110914'),
(15543, 'US-VA-110915', 'Tazewell', 'CI', 4218, 37.05950000000, -81.52200000000, '110915'),
(15544, 'US-NC-110916', 'Shelby', 'CI', 4201, 35.36250000000, -81.57410000000, '110916'),
(15545, 'US-NC-110917', 'Zebulon', 'CI', 4201, 35.80800000000, -78.31690000000, '110917'),
(15546, 'US-PA-110918', 'Landisburg', 'CI', 4208, 40.31600000000, -77.32690000000, '110918'),
(15547, 'US-PA-110919', 'Emigsville', 'CI', 4208, 40.01770000000, -76.73170000000, '110919'),
(15548, 'US-PA-110920', 'Bangor', 'CI', 4208, 40.86860000000, -75.16410000000, '110920'),
(15549, 'US-WV-110921', 'Fairmont', 'CI', 4220, 39.48410000000, -80.06010000000, '110921'),
(15550, 'US-PA-110922', 'Burgettstown', 'CI', 4208, 40.38490000000, -80.42410000000, '110922'),
(15551, 'US-MI-110923', 'Southgate', 'CI', 4190, 42.20610000000, -83.20600000000, '110923'),
(15552, 'US-PA-110924', 'Trout Run', 'CI', 4208, 41.44690000000, -77.04020000000, '110924'),
(15553, 'US-MD-110925', 'Hancock', 'CI', 4188, 39.67140000000, -78.04900000000, '110925'),
(15554, 'US-VA-110926', 'Castleton', 'CI', 4218, 38.63660000000, -78.11160000000, '110926'),
(15555, 'US-CA-110927', 'Yucaipa', 'CI', 4169, 34.04860000000, -117.01430000000, '110927'),
(15556, 'US-PA-110928', 'Sheffield', 'CI', 4208, 41.66420000000, -79.07860000000, '110928'),
(15557, 'US-AL-110929', 'Calera', 'CI', 4161, 33.10080000000, -86.70830000000, '110929'),
(15558, 'US-TN-110930', 'Madisonville', 'CI', 4213, 35.51370000000, -84.35000000000, '110930'),
(15559, 'US-AL-110931', 'Vance', 'CI', 4161, 33.21840000000, -87.22870000000, '110931'),
(15560, 'US-MS-110932', 'Piney Woods', 'CI', 4192, 32.06540000000, -89.99440000000, '110932'),
(15561, 'US-CA-110933', 'Meadow Vista', 'CI', 4169, 39.00200000000, -121.03310000000, '110933'),
(15562, 'US-CA-110934', 'Norco', 'CI', 4169, 33.93000000000, -117.56420000000, '110934'),
(15563, 'US-TX-110935', 'Denver City', 'CI', 4214, 32.95300000000, -102.88150000000, '110935'),
(15564, 'US-GA-110936', 'Leesburg', 'CI', 4176, 31.75150000000, -84.13550000000, '110936'),
(15565, 'US-WI-110937', 'Union Grove', 'CI', 4221, 42.70970000000, -88.04180000000, '110937'),
(15566, 'US-MT-110938', 'Hardin', 'CI', 4194, 45.75530000000, -107.79020000000, '110938'),
(15567, 'US-ID-110939', 'American Falls', 'CI', 4179, 42.72750000000, -112.99020000000, '110939'),
(15568, 'US-MS-110940', 'Carriere', 'CI', 4192, 30.64330000000, -89.65820000000, '110940'),
(15569, 'US-IA-110941', 'Hawarden', 'CI', 4182, 43.03330000000, -96.42710000000, '110941'),
(15570, 'US-AR-110942', 'Gravette', 'CI', 4165, 36.41500000000, -94.47150000000, '110942'),
(15571, 'US-MO-110943', 'Carthage', 'CI', 4193, 37.18270000000, -94.28960000000, '110943'),
(15572, 'US-AR-110944', 'Lincoln', 'CI', 4165, 35.97160000000, -94.43380000000, '110944'),
(15573, 'US-MO-110945', 'Milan', 'CI', 4193, 40.19520000000, -93.10760000000, '110945'),
(15574, 'US-KS-110946', 'Fort Riley', 'CI', 4183, 39.08880000000, -96.78850000000, '110946'),
(15575, 'US-CA-110947', 'Tecate', 'CI', 4169, 32.59250000000, -116.58550000000, '110947'),
(15576, 'US-AZ-110948', 'Tonto Basin', 'CI', 4164, 34.09030000000, -111.17070000000, '110948'),
(15577, 'US-CA-110949', 'San Marino', 'CI', 4169, 34.12140000000, -118.11630000000, '110949'),
(15578, 'US-NV-110950', 'Indian Springs', 'CI', 4196, 35.92790000000, -114.97210000000, '110950'),
(15579, 'US-WI-110951', 'Genoa City', 'CI', 4221, 42.53820000000, -88.33450000000, '110951'),
(15580, 'US-OH-110952', 'Perry', 'CI', 4204, 41.76960000000, -81.14960000000, '110952'),
(15581, 'US-WI-110953', 'Palmyra', 'CI', 4221, 42.90250000000, -88.60260000000, '110953'),
(15582, 'US-TX-110954', 'Devine', 'CI', 4214, 29.19450000000, -98.94800000000, '110954'),
(15583, 'US-TX-110955', 'Refugio', 'CI', 4214, 28.34780000000, -97.19040000000, '110955'),
(15584, 'US-CO-110956', 'Erie', 'CI', 4170, 40.06570000000, -105.01330000000, '110956'),
(15585, 'US-CA-110957', 'Valyermo', 'CI', 4169, 34.39730000000, -117.74460000000, '110957'),
(15586, 'US-CA-110958', 'Lakeside', 'CI', 4169, 32.90170000000, -116.89330000000, '110958'),
(15587, 'US-MI-110959', 'Newaygo', 'CI', 4190, 43.43320000000, -85.71100000000, '110959'),
(15588, 'US-MI-110960', 'Munith', 'CI', 4190, 42.37330000000, -84.25850000000, '110960'),
(15589, 'US-FL-110961', 'Jensen Beach', 'CI', 4175, 27.25500000000, -80.24760000000, '110961'),
(15590, 'US-OH-110962', 'Lakewood', 'CI', 4204, 41.48170000000, -81.80240000000, '110962'),
(15591, 'US-IA-110963', 'Marengo', 'CI', 4182, 41.78950000000, -92.08960000000, '110963'),
(15592, 'US-GA-110964', 'Quitman', 'CI', 4176, 30.79750000000, -83.55040000000, '110964'),
(15593, 'US-MI-110965', 'Inkster', 'CI', 4190, 42.29330000000, -83.31470000000, '110965'),
(15594, 'US-SC-110966', 'Inman', 'CI', 4211, 35.04840000000, -82.08520000000, '110966'),
(15595, 'US-SC-110967', 'Westminster', 'CI', 4211, 34.64820000000, -83.16550000000, '110967'),
(15596, 'US-NC-110968', 'Linville', 'CI', 4201, 36.06780000000, -81.87740000000, '110968'),
(15597, 'US-NC-110969', 'Garner', 'CI', 4201, 35.64610000000, -78.57910000000, '110969'),
(15598, 'US-KS-110970', 'Liberal', 'CI', 4183, 37.13470000000, -100.88620000000, '110970'),
(15599, 'US-TX-110971', 'Waskom', 'CI', 4214, 32.47590000000, -94.13400000000, '110971'),
(15600, 'US-MN-110972', 'Lake Elmo', 'CI', 4191, 44.99280000000, -92.89880000000, '110972'),
(15601, 'US-MI-110973', 'Stephenson', 'CI', 4190, 45.44590000000, -87.44330000000, '110973'),
(15602, 'US-CA-110974', 'Loomis', 'CI', 4169, 38.81390000000, -121.16620000000, '110974'),
(15603, 'US-CA-110975', 'Delano', 'CI', 4169, 35.78330000000, -119.23610000000, '110975'),
(15604, 'US-ID-110976', 'Priest River', 'CI', 4179, 48.38760000000, -116.88980000000, '110976'),
(15605, 'US-AR-110977', 'Vilonia', 'CI', 4165, 35.09860000000, -92.21750000000, '110977'),
(15606, 'US-MS-110978', 'Corinth', 'CI', 4192, 34.89790000000, -88.57940000000, '110978'),
(15607, 'US-MO-110979', 'Barnhart', 'CI', 4193, 38.33450000000, -90.44620000000, '110979'),
(15608, 'US-TN-110980', 'Wildersville', 'CI', 4213, 35.75360000000, -88.22920000000, '110980'),
(15609, 'US-NJ-110981', 'Medford', 'CI', 4198, 39.87410000000, -74.80900000000, '110981'),
(15610, 'US-PA-110982', 'Dallas', 'CI', 4208, 41.34240000000, -75.99040000000, '110982'),
(15611, 'US-VA-110983', 'Crozet', 'CI', 4218, 38.12830000000, -78.70590000000, '110983'),
(15612, 'US-MA-110984', 'Gilbertville', 'CI', 4189, 42.33230000000, -72.18880000000, '110984'),
(15613, 'US-NY-110985', 'Cassville', 'CI', 4200, 42.92220000000, -75.26040000000, '110985'),
(15614, 'US-NJ-110986', 'Chester', 'CI', 4198, 40.77520000000, -74.68240000000, '110986'),
(15615, 'US-MS-110987', 'Union', 'CI', 4192, 32.60070000000, -89.12100000000, '110987'),
(15616, 'US-TN-110988', 'Jellico', 'CI', 4213, 36.52030000000, -84.19200000000, '110988'),
(15617, 'US-TN-110989', 'La Follette', 'CI', 4213, 36.40400000000, -84.07210000000, '110989'),
(15618, 'US-GA-110990', 'Lenox', 'CI', 4176, 31.29570000000, -83.43520000000, '110990'),
(15619, 'US-GA-110991', 'Elberton', 'CI', 4176, 34.13020000000, -82.80380000000, '110991'),
(15620, 'US-TN-110992', 'Oliver Springs', 'CI', 4213, 36.05220000000, -84.36080000000, '110992'),
(15621, 'US-GA-110993', 'Omega', 'CI', 4176, 31.32740000000, -83.60510000000, '110993'),
(15622, 'US-SC-110994', 'Edisto Island', 'CI', 4211, 32.55790000000, -80.21920000000, '110994'),
(15623, 'US-CA-110995', 'Hercules', 'CI', 4169, 38.01000000000, -122.25920000000, '110995'),
(15624, 'US-CA-110996', 'Winnetka', 'CI', 4169, 34.20930000000, -118.57520000000, '110996'),
(15625, 'US-MO-110997', 'Marshfield', 'CI', 4193, 37.33110000000, -92.88180000000, '110997'),
(15626, 'US-OK-110998', 'Mustang', 'CI', 4205, 35.37980000000, -97.75980000000, '110998'),
(15627, 'US-TX-110999', 'Red Oak', 'CI', 4214, 32.52270000000, -96.80480000000, '110999'),
(15628, 'US-TX-111000', 'Wills Point', 'CI', 4214, 32.69930000000, -95.99720000000, '111000'),
(15629, 'US-OH-111001', 'North Jackson', 'CI', 4204, 41.07930000000, -80.86600000000, '111001'),
(15630, 'US-WI-111002', 'Beaver Dam', 'CI', 4221, 43.45880000000, -88.80520000000, '111002'),
(15631, 'US-MI-111003', 'Flushing', 'CI', 4190, 43.07380000000, -83.86080000000, '111003'),
(15632, 'US-IL-111004', 'Watseka', 'CI', 4180, 40.78860000000, -87.74810000000, '111004'),
(15633, 'US-MI-111005', 'Lincoln Park', 'CI', 4190, 42.24620000000, -83.17900000000, '111005'),
(15634, 'US-MI-111006', 'Commerce Township', 'CI', 4190, 42.58600000000, -83.50060000000, '111006'),
(15635, 'US-WI-111007', 'Fredonia', 'CI', 4221, 43.48080000000, -87.99920000000, '111007'),
(15636, 'US-IL-111008', 'Rock City', 'CI', 4180, 42.41660000000, -89.47250000000, '111008'),
(15637, 'US-KY-111009', 'Monticello', 'CI', 4184, 36.79210000000, -84.81030000000, '111009'),
(15638, 'US-IN-111010', 'Matthews', 'CI', 4181, 40.38870000000, -85.49570000000, '111010'),
(15639, 'US-MI-111011', 'Middleville', 'CI', 4190, 42.68620000000, -85.45150000000, '111011'),
(15640, 'US-IL-111012', 'Union Hill', 'CI', 4180, 41.10920000000, -88.14470000000, '111012'),
(15641, 'US-MI-111013', 'Keego Harbor', 'CI', 4190, 42.61100000000, -83.33840000000, '111013'),
(15642, 'US-OH-111014', 'Girard', 'CI', 4204, 41.17090000000, -80.67990000000, '111014'),
(15643, 'US-OH-111015', 'Eastlake', 'CI', 4204, 41.65020000000, -81.45330000000, '111015'),
(15644, 'US-IL-111016', 'Pawnee', 'CI', 4180, 39.58620000000, -89.53090000000, '111016'),
(15645, 'US-KS-111017', 'Lindsborg', 'CI', 4183, 38.62370000000, -97.68760000000, '111017'),
(15646, 'US-MO-111018', 'Bonne Terre', 'CI', 4193, 37.94500000000, -90.52180000000, '111018'),
(15647, 'US-LA-111019', 'Ruston', 'CI', 4185, 32.51510000000, -92.62620000000, '111019'),
(15648, 'US-AZ-111020', 'Colorado City', 'CI', 4164, 36.97360000000, -112.98290000000, '111020'),
(15649, 'US-LA-111021', 'Dodson', 'CI', 4185, 32.05950000000, -92.64450000000, '111021'),
(15650, 'US-MS-111022', 'Natchez', 'CI', 4192, 31.56920000000, -91.32890000000, '111022'),
(15651, 'US-TX-111023', 'Waller', 'CI', 4214, 30.08940000000, -95.92850000000, '111023'),
(15652, 'US-LA-111024', 'Darrow', 'CI', 4185, 30.14680000000, -90.96400000000, '111024'),
(15653, 'US-LA-111025', 'Luling', 'CI', 4185, 29.82910000000, -90.31660000000, '111025'),
(15654, 'US-TX-111026', 'Mission', 'CI', 4214, 26.17880000000, -98.35950000000, '111026'),
(15655, 'US-AL-111027', 'Saraland', 'CI', 4161, 30.83950000000, -88.09680000000, '111027'),
(15656, 'US-TX-111028', 'Normanna', 'CI', 4214, 28.53020000000, -97.78320000000, '111028'),
(15657, 'US-LA-111029', 'Pearl River', 'CI', 4185, 30.43190000000, -89.79400000000, '111029'),
(15658, 'US-IL-111030', 'Lake Villa', 'CI', 4180, 42.40850000000, -88.06340000000, '111030'),
(15659, 'US-CA-111031', 'Livingston', 'CI', 4169, 37.34180000000, -120.75910000000, '111031'),
(15660, 'US-CA-111032', 'Pope Valley', 'CI', 4169, 38.67200000000, -122.44770000000, '111032'),
(15661, 'US-CA-111033', 'Topanga', 'CI', 4169, 34.10490000000, -118.60890000000, '111033'),
(15662, 'US-KY-111034', 'Williamsburg', 'CI', 4184, 36.72220000000, -84.16600000000, '111034'),
(15663, 'US-NE-111035', 'Nebraska City', 'CI', 4195, 40.65360000000, -95.87840000000, '111035'),
(15664, 'US-AZ-111036', 'Whiteriver', 'CI', 4164, 33.80480000000, -109.99570000000, '111036'),
(15665, 'US-WY-111037', 'Laramie', 'CI', 4222, 41.33860000000, -105.86020000000, '111037'),
(15666, 'US-IL-111038', 'Royal', 'CI', 4180, 40.19200000000, -87.96880000000, '111038'),
(15667, 'US-IN-111039', 'Sheridan', 'CI', 4181, 40.13220000000, -86.23870000000, '111039'),
(15668, 'US-IL-111040', 'Jonesboro', 'CI', 4180, 37.40710000000, -89.35680000000, '111040'),
(15669, 'US-MI-111041', 'Mancelona', 'CI', 4190, 44.90620000000, -85.02930000000, '111041'),
(15670, 'US-OH-111042', 'Beloit', 'CI', 4204, 40.90830000000, -80.98810000000, '111042'),
(15671, 'US-OH-111043', 'Fleming', 'CI', 4204, 39.41040000000, -81.60770000000, '111043'),
(15672, 'US-ME-111044', 'Hampden', 'CI', 4186, 44.72380000000, -68.93190000000, '111044'),
(15673, 'US-OH-111045', 'Ottawa', 'CI', 4204, 41.02820000000, -84.05370000000, '111045'),
(15674, 'US-CA-111046', 'El Cerrito', 'CI', 4169, 37.91800000000, -122.30320000000, '111046'),
(15675, 'US-CA-111047', 'Mentone', 'CI', 4169, 34.10440000000, -117.04860000000, '111047'),
(15676, 'US-IL-111048', 'Millstadt', 'CI', 4180, 38.46500000000, -90.09780000000, '111048'),
(15677, 'US-IL-111049', 'Freeburg', 'CI', 4180, 38.41530000000, -89.90640000000, '111049'),
(15678, 'US-IL-111050', 'Bunker Hill', 'CI', 4180, 39.04970000000, -89.95130000000, '111050'),
(15679, 'US-MD-111051', 'Trappe', 'CI', 4188, 38.65300000000, -76.05350000000, '111051'),
(15680, 'US-WI-111052', 'De Forest', 'CI', 4221, 43.23820000000, -89.33650000000, '111052'),
(15681, 'US-LA-111053', 'Madisonville', 'CI', 4185, 30.42170000000, -90.19560000000, '111053'),
(15682, 'US-KS-111054', 'Lincoln', 'CI', 4183, 39.04500000000, -98.15150000000, '111054'),
(15683, 'US-LA-111055', 'Braithwaite', 'CI', 4185, 29.70650000000, -89.96100000000, '111055'),
(15684, 'US-TX-111056', 'Manvel', 'CI', 4214, 29.47510000000, -95.35980000000, '111056'),
(15685, 'US-OK-111057', 'Lexington', 'CI', 4205, 35.03710000000, -97.25630000000, '111057'),
(15686, 'US-LA-111058', 'Hahnville', 'CI', 4185, 29.96260000000, -90.41200000000, '111058'),
(15687, 'US-TX-111059', 'Forney', 'CI', 4214, 32.73800000000, -96.44630000000, '111059'),
(15688, 'US-TX-111060', 'Hamshire', 'CI', 4214, 29.86470000000, -94.27430000000, '111060'),
(15689, 'US-CA-111061', 'Castroville', 'CI', 4169, 36.76190000000, -121.75730000000, '111061'),
(15690, 'US-CA-111062', 'Potter Valley', 'CI', 4169, 39.37760000000, -123.01960000000, '111062'),
(15691, 'US-CA-111063', 'Orangevale', 'CI', 4169, 38.68450000000, -121.22230000000, '111063'),
(15692, 'US-CA-111064', 'Fair Oaks', 'CI', 4169, 38.65010000000, -121.25340000000, '111064'),
(15693, 'US-CA-111065', 'Mccloud', 'CI', 4169, 41.26610000000, -122.10760000000, '111065'),
(15694, 'US-CA-111066', 'Fort Bragg', 'CI', 4169, 39.47970000000, -123.63910000000, '111066'),
(15695, 'US-WA-111067', 'Kelso', 'CI', 4219, 46.14910000000, -122.80890000000, '111067'),
(15696, 'US-ID-111068', 'Burley', 'CI', 4179, 42.39840000000, -113.78140000000, '111068'),
(15697, 'US-WA-111069', 'Conway', 'CI', 4219, 48.33880000000, -122.34380000000, '111069'),
(15698, 'US-OR-111070', 'Cave Junction', 'CI', 4206, 42.11930000000, -123.60280000000, '111070'),
(15699, 'US-MT-111071', 'Sheridan', 'CI', 4194, 45.43980000000, -112.12880000000, '111071'),
(15700, 'US-MO-111072', 'Dudley', 'CI', 4193, 36.79740000000, -90.13480000000, '111072'),
(15701, 'US-AR-111073', 'Monticello', 'CI', 4165, 33.62300000000, -91.70850000000, '111073'),
(15702, 'US-MS-111074', 'Kosciusko', 'CI', 4192, 32.99110000000, -89.51680000000, '111074'),
(15703, 'US-IL-111075', 'Waverly', 'CI', 4180, 39.59640000000, -89.94690000000, '111075'),
(15704, 'US-IL-111076', 'Pleasant Hill', 'CI', 4180, 39.47290000000, -90.90690000000, '111076'),
(15705, 'US-IL-111077', 'Camp Point', 'CI', 4180, 40.01960000000, -91.07940000000, '111077'),
(15706, 'US-IL-111078', 'Palmyra', 'CI', 4180, 39.43810000000, -90.02480000000, '111078'),
(15707, 'US-IL-111079', 'Virden', 'CI', 4180, 39.50110000000, -89.74820000000, '111079'),
(15708, 'US-KS-111080', 'Effingham', 'CI', 4183, 39.50750000000, -95.38500000000, '111080'),
(15709, 'US-AR-111081', 'Higden', 'CI', 4165, 35.57860000000, -92.11990000000, '111081'),
(15710, 'US-VA-111082', 'Bealeton', 'CI', 4218, 38.54820000000, -77.76020000000, '111082'),
(15711, 'US-NJ-111083', 'Audubon', 'CI', 4198, 39.89130000000, -75.07300000000, '111083'),
(15712, 'US-PA-111084', 'Bath', 'CI', 4208, 40.75850000000, -75.41850000000, '111084'),
(15713, 'US-PA-111085', 'Leetsdale', 'CI', 4208, 40.56640000000, -80.21250000000, '111085'),
(15714, 'US-VA-111086', 'North Tazewell', 'CI', 4218, 37.17840000000, -81.46830000000, '111086'),
(15715, 'US-AL-111087', 'Moulton', 'CI', 4161, 34.46200000000, -87.29510000000, '111087'),
(15716, 'US-AL-111088', 'Eastaboga', 'CI', 4161, 33.60200000000, -86.00370000000, '111088'),
(15717, 'US-GA-111089', 'Rising Fawn', 'CI', 4176, 34.80210000000, -85.47080000000, '111089'),
(15718, 'US-SC-111090', 'Travelers Rest', 'CI', 4211, 35.07680000000, -82.43610000000, '111090'),
(15719, 'US-TX-111091', 'Meridian', 'CI', 4214, 31.92130000000, -97.70700000000, '111091'),
(15720, 'US-TX-111092', 'Venus', 'CI', 4214, 32.43520000000, -97.07670000000, '111092'),
(15721, 'US-IN-111093', 'Knightstown', 'CI', 4181, 39.81540000000, -85.51510000000, '111093'),
(15722, 'US-IL-111094', 'Forreston', 'CI', 4180, 42.10980000000, -89.58550000000, '111094'),
(15723, 'US-IL-111095', 'Blandinsville', 'CI', 4180, 40.56310000000, -90.86520000000, '111095'),
(15724, 'US-IL-111096', 'Peotone', 'CI', 4180, 41.33080000000, -87.80180000000, '111096'),
(15725, 'US-WI-111097', 'Malone', 'CI', 4221, 43.88330000000, -88.28720000000, '111097'),
(15726, 'US-WI-111098', 'Plymouth', 'CI', 4221, 43.76850000000, -88.01610000000, '111098'),
(15727, 'US-WI-111099', 'Hortonville', 'CI', 4221, 44.31620000000, -88.61170000000, '111099'),
(15728, 'US-TN-111100', 'Lexington', 'CI', 4213, 35.65550000000, -88.41880000000, '111100'),
(15729, 'US-SC-111101', 'Williston', 'CI', 4211, 33.38880000000, -81.41430000000, '111101'),
(15730, 'US-MS-111102', 'Raymond', 'CI', 4192, 32.21800000000, -90.46470000000, '111102'),
(15731, 'US-IA-111103', 'Montezuma', 'CI', 4182, 41.59140000000, -92.53440000000, '111103'),
(15732, 'US-MO-111104', 'Smithville', 'CI', 4193, 39.39400000000, -94.57430000000, '111104'),
(15733, 'US-IA-111105', 'Farnhamville', 'CI', 4182, 42.28160000000, -94.42690000000, '111105'),
(15734, 'US-IN-111106', 'Whitestown', 'CI', 4181, 40.01960000000, -86.32940000000, '111106'),
(15735, 'US-WI-111107', 'Elm Grove', 'CI', 4221, 43.04820000000, -88.08790000000, '111107'),
(15736, 'US-MI-111108', 'Greenville', 'CI', 4190, 43.20880000000, -85.26650000000, '111108'),
(15737, 'US-NJ-111109', 'Midland Park', 'CI', 4198, 40.99470000000, -74.14250000000, '111109'),
(15738, 'US-MS-111110', 'Red Banks', 'CI', 4192, 34.89730000000, -89.55620000000, '111110'),
(15739, 'US-IN-111111', 'Upland', 'CI', 4181, 40.44410000000, -85.48890000000, '111111'),
(15740, 'US-TN-111112', 'Clifton', 'CI', 4213, 35.39650000000, -87.95350000000, '111112'),
(15741, 'US-KY-111113', 'Mount Vernon', 'CI', 4184, 37.34460000000, -84.30920000000, '111113'),
(15742, 'US-TN-111114', 'Winchester', 'CI', 4213, 35.19110000000, -86.16150000000, '111114'),
(15743, 'US-KY-111115', 'Marion', 'CI', 4184, 37.35480000000, -88.07840000000, '111115'),
(15744, 'US-AR-111116', 'Conway', 'CI', 4165, 35.06400000000, -92.38020000000, '111116'),
(15745, 'US-NY-111117', 'Fresh Meadows', 'CI', 4200, 40.73950000000, -73.79390000000, '111117'),
(15746, 'US-CA-111118', 'Hermosa Beach', 'CI', 4169, 33.86490000000, -118.39710000000, '111118'),
(15747, 'US-TX-111119', 'Crandall', 'CI', 4214, 32.59270000000, -96.43140000000, '111119'),
(15748, 'US-IL-111120', 'Glencoe', 'CI', 4180, 42.13060000000, -87.76780000000, '111120'),
(15749, 'US-CA-111121', 'San Andreas', 'CI', 4169, 38.20680000000, -120.62140000000, '111121'),
(15750, 'US-CA-111122', 'King City', 'CI', 4169, 36.20850000000, -120.94490000000, '111122'),
(15751, 'US-CO-111123', 'Nunn', 'CI', 4170, 40.76930000000, -104.70500000000, '111123'),
(15752, 'US-PA-111124', 'Tobyhanna', 'CI', 4208, 41.18800000000, -75.38040000000, '111124'),
(15753, 'US-CA-111125', 'Universal City', 'CI', 4169, 34.13740000000, -118.35280000000, '111125'),
(15754, 'US-CA-111126', 'Reseda', 'CI', 4169, 34.20050000000, -118.54040000000, '111126'),
(15755, 'US-WI-111127', 'Colgate', 'CI', 4221, 43.20310000000, -88.25070000000, '111127'),
(15756, 'US-NC-111128', 'Browns Summit', 'CI', 4201, 36.20480000000, -79.67340000000, '111128'),
(15757, 'US-AL-111129', 'Hanceville', 'CI', 4161, 34.00400000000, -86.83160000000, '111129'),
(15758, 'US-GA-111130', 'Eastanollee', 'CI', 4176, 34.49900000000, -83.27000000000, '111130'),
(15759, 'US-GA-111131', 'Keysville', 'CI', 4176, 33.16160000000, -82.15930000000, '111131'),
(15760, 'US-GA-111132', 'Camilla', 'CI', 4176, 31.21540000000, -84.26850000000, '111132'),
(15761, 'US-GA-111133', 'Flowery Branch', 'CI', 4176, 34.16750000000, -83.91200000000, '111133'),
(15762, 'US-AL-111134', 'Mulga', 'CI', 4161, 33.53470000000, -87.05830000000, '111134'),
(15763, 'US-CA-111135', 'Farmersville', 'CI', 4169, 36.30860000000, -119.19390000000, '111135'),
(15764, 'US-AZ-111136', 'Tubac', 'CI', 4164, 31.60910000000, -111.05130000000, '111136'),
(15765, 'US-AZ-111137', 'Miami', 'CI', 4164, 33.40960000000, -110.97750000000, '111137'),
(15766, 'US-IL-111138', 'Island Lake', 'CI', 4180, 42.28040000000, -88.20190000000, '111138'),
(15767, 'US-OH-111139', 'Lakeside Marblehead', 'CI', 4204, 41.52780000000, -82.78100000000, '111139'),
(15768, 'US-NY-111140', 'Sonyea', 'CI', 4200, 42.67970000000, -77.82660000000, '111140'),
(15769, 'US-CT-111141', 'Prospect', 'CI', 4171, 41.49940000000, -72.97640000000, '111141'),
(15770, 'US-CA-111142', 'Garden Valley', 'CI', 4169, 38.84950000000, -120.83920000000, '111142'),
(15771, 'US-CA-111143', 'Huron', 'CI', 4169, 36.20130000000, -120.09700000000, '111143'),
(15772, 'US-MI-111144', 'Bronson', 'CI', 4190, 41.87240000000, -85.16590000000, '111144'),
(15773, 'US-OH-111145', 'Lisbon', 'CI', 4204, 40.74420000000, -80.75460000000, '111145'),
(15774, 'US-OH-111146', 'Rio Grande', 'CI', 4204, 38.88260000000, -82.38080000000, '111146'),
(15775, 'US-IN-111147', 'Mooresville', 'CI', 4181, 39.58250000000, -86.36790000000, '111147'),
(15776, 'US-PA-111148', 'New Stanton', 'CI', 4208, 40.23870000000, -79.62910000000, '111148'),
(15777, 'US-PA-111149', 'New Bloomfield', 'CI', 4208, 40.40800000000, -77.17600000000, '111149'),
(15778, 'US-MD-111150', 'Clarksville', 'CI', 4188, 39.20180000000, -76.93100000000, '111150'),
(15779, 'US-MO-111151', 'Rogersville', 'CI', 4193, 37.14670000000, -93.08270000000, '111151'),
(15780, 'US-CA-111152', 'Marshall', 'CI', 4169, 38.16950000000, -122.84080000000, '111152'),
(15781, 'US-AR-111153', 'Turrell', 'CI', 4165, 35.36900000000, -90.24650000000, '111153'),
(15782, 'US-AR-111154', 'Hermitage', 'CI', 4165, 33.34550000000, -92.12820000000, '111154'),
(15783, 'US-IL-111155', 'Gilman', 'CI', 4180, 40.77490000000, -87.99460000000, '111155'),
(15784, 'US-VA-111156', 'Hillsville', 'CI', 4218, 36.78040000000, -80.70910000000, '111156'),
(15785, 'US-IL-111157', 'Strasburg', 'CI', 4180, 39.34610000000, -88.64170000000, '111157'),
(15786, 'US-MO-111158', 'Fredericktown', 'CI', 4193, 37.53640000000, -90.31970000000, '111158'),
(15787, 'US-MO-111159', 'Grover', 'CI', 4193, 38.57220000000, -90.62790000000, '111159'),
(15788, 'US-AR-111160', 'Cabot', 'CI', 4165, 34.94610000000, -92.08580000000, '111160'),
(15789, 'US-MO-111161', 'Hillsboro', 'CI', 4193, 38.26310000000, -90.56890000000, '111161'),
(15790, 'US-LA-111162', 'Opelousas', 'CI', 4185, 30.53350000000, -92.11630000000, '111162'),
(15791, 'US-LA-111163', 'Eunice', 'CI', 4185, 30.47500000000, -92.42200000000, '111163'),
(15792, 'US-TX-111164', 'Blessing', 'CI', 4214, 28.85600000000, -96.23520000000, '111164'),
(15793, 'US-TX-111165', 'Leander', 'CI', 4214, 30.54230000000, -97.91760000000, '111165'),
(15794, 'US-LA-111166', 'Saint Martinville', 'CI', 4185, 30.17450000000, -91.77770000000, '111166'),
(15795, 'US-LA-111167', 'Iowa', 'CI', 4185, 30.24350000000, -93.00920000000, '111167'),
(15796, 'US-TX-111168', 'Port Bolivar', 'CI', 4214, 29.42600000000, -94.69770000000, '111168'),
(15797, 'US-TN-111169', 'Hermitage', 'CI', 4213, 36.17820000000, -86.60980000000, '111169'),
(15798, 'US-AL-111170', 'Cottondale', 'CI', 4161, 33.17300000000, -87.38740000000, '111170'),
(15799, 'US-SC-111171', 'Mullins', 'CI', 4211, 34.16320000000, -79.25740000000, '111171'),
(15800, 'US-AL-111172', 'Childersburg', 'CI', 4161, 33.25910000000, -86.36280000000, '111172'),
(15801, 'US-WV-111173', 'Glen Jean', 'CI', 4220, 37.89840000000, -81.16100000000, '111173'),
(15802, 'US-AL-111174', 'Logan', 'CI', 4161, 34.12030000000, -86.96220000000, '111174'),
(15803, 'US-AL-111175', 'Tuskegee', 'CI', 4161, 32.38070000000, -85.68080000000, '111175'),
(15804, 'US-AL-111176', 'Maplesville', 'CI', 4161, 32.78270000000, -86.85890000000, '111176'),
(15805, 'US-AL-111177', 'Selma', 'CI', 4161, 32.52370000000, -87.09650000000, '111177'),
(15806, 'US-IL-111178', 'Medinah', 'CI', 4180, 41.97550000000, -88.05610000000, '111178'),
(15807, 'US-MI-111179', 'Berrien Springs', 'CI', 4190, 41.95990000000, -86.39320000000, '111179'),
(15808, 'US-KY-111180', 'Arjay', 'CI', 4184, 36.85670000000, -83.63280000000, '111180'),
(15809, 'US-KY-111181', 'Fort Knox', 'CI', 4184, 37.92630000000, -85.94810000000, '111181'),
(15810, 'US-IL-111182', 'South Elgin', 'CI', 4180, 41.99090000000, -88.32010000000, '111182'),
(15811, 'US-MI-111183', 'Toivola', 'CI', 4190, 46.95890000000, -88.77520000000, '111183'),
(15812, 'US-WI-111184', 'Bagley', 'CI', 4221, 42.92230000000, -91.05710000000, '111184'),
(15813, 'US-WI-111185', 'Coloma', 'CI', 4221, 44.02380000000, -89.56990000000, '111185'),
(15814, 'US-WI-111186', 'Muskego', 'CI', 4221, 42.87760000000, -88.13380000000, '111186'),
(15815, 'US-MI-111187', 'Byron Center', 'CI', 4190, 42.79770000000, -85.73330000000, '111187'),
(15816, 'US-MI-111188', 'Northport', 'CI', 4190, 45.12540000000, -85.62510000000, '111188'),
(15817, 'US-PA-111189', 'Kane', 'CI', 4208, 41.61820000000, -78.78310000000, '111189'),
(15818, 'US-MI-111190', 'Shelbyville', 'CI', 4190, 42.58800000000, -85.58630000000, '111190'),
(15819, 'US-OH-111191', 'Chesterland', 'CI', 4204, 41.53480000000, -81.31710000000, '111191'),
(15820, 'US-NJ-111192', 'Barnegat', 'CI', 4198, 39.76460000000, -74.28780000000, '111192'),
(15821, 'US-CA-111193', 'Shafter', 'CI', 4169, 35.49610000000, -119.30060000000, '111193'),
(15822, 'US-GA-111194', 'Fayetteville', 'CI', 4176, 33.48110000000, -84.47980000000, '111194'),
(15823, 'US-AL-111195', 'Dadeville', 'CI', 4161, 32.79680000000, -85.75850000000, '111195'),
(15824, 'US-CA-111196', 'Dillon Beach', 'CI', 4169, 38.24820000000, -122.95750000000, '111196'),
(15825, 'US-CA-111197', 'Hoopa', 'CI', 4169, 41.11430000000, -123.64310000000, '111197'),
(15826, 'US-CA-111198', 'Freedom', 'CI', 4169, 36.93520000000, -121.78450000000, '111198'),
(15827, 'US-PA-111199', 'Breinigsville', 'CI', 4208, 40.54890000000, -75.66580000000, '111199'),
(15828, 'US-OH-111200', 'New Carlisle', 'CI', 4204, 39.96160000000, -83.99870000000, '111200'),
(15829, 'US-IN-111201', 'Ladoga', 'CI', 4181, 39.90990000000, -86.82540000000, '111201'),
(15830, 'US-IN-111202', 'Taylorsville', 'CI', 4181, 39.29830000000, -85.94790000000, '111202'),
(15831, 'US-HI-111203', 'Keaau', 'CI', 4178, 19.58460000000, -155.02420000000, '111203'),
(15832, 'US-CA-111204', 'Arcata', 'CI', 4169, 40.85360000000, -124.05020000000, '111204'),
(15833, 'US-SC-111205', 'Santee', 'CI', 4211, 33.46420000000, -80.44860000000, '111205'),
(15834, 'US-KS-111206', 'Marysville', 'CI', 4183, 39.86370000000, -96.65390000000, '111206'),
(15835, 'US-MS-111207', 'Mc Call Creek', 'CI', 4192, 31.50690000000, -90.72250000000, '111207'),
(15836, 'US-AL-111208', 'Semmes', 'CI', 4161, 30.75640000000, -88.27230000000, '111208'),
(15837, 'US-FL-111209', 'Marathon', 'CI', 4175, 24.71630000000, -81.07670000000, '111209'),
(15838, 'US-WA-111210', 'Ferndale', 'CI', 4219, 48.86450000000, -122.63070000000, '111210'),
(15839, 'US-WA-111211', 'North Bend', 'CI', 4219, 47.47930000000, -121.54300000000, '111211'),
(15840, 'US-MT-111212', 'Boulder', 'CI', 4194, 46.17660000000, -111.99300000000, '111212'),
(15841, 'US-OR-111213', 'Hubbard', 'CI', 4206, 45.18890000000, -122.79730000000, '111213'),
(15842, 'US-OK-111214', 'Coalgate', 'CI', 4205, 34.59290000000, -96.28640000000, '111214'),
(15843, 'US-MO-111215', 'Sunrise Beach', 'CI', 4193, 38.14800000000, -92.74480000000, '111215'),
(15844, 'US-IL-111216', 'Neoga', 'CI', 4180, 39.31030000000, -88.44850000000, '111216'),
(15845, 'US-IL-111217', 'Oblong', 'CI', 4180, 39.02690000000, -87.91290000000, '111217'),
(15846, 'US-MD-111218', 'Taylors Island', 'CI', 4188, 38.45930000000, -76.30540000000, '111218'),
(15847, 'US-NY-111219', 'Stanfordville', 'CI', 4200, 41.91350000000, -73.69060000000, '111219'),
(15848, 'US-UT-111220', 'South Jordan', 'CI', 4215, 40.55980000000, -111.96650000000, '111220'),
(15849, 'US-LA-111221', 'Jennings', 'CI', 4185, 30.25470000000, -92.67590000000, '111221'),
(15850, 'US-TX-111222', 'Vernon', 'CI', 4214, 34.17300000000, -99.29750000000, '111222'),
(15851, 'US-TX-111223', 'Pleasanton', 'CI', 4214, 28.94920000000, -98.43160000000, '111223'),
(15852, 'US-OK-111224', 'Roff', 'CI', 4205, 34.62210000000, -96.82000000000, '111224'),
(15853, 'US-TX-111225', 'Floydada', 'CI', 4214, 33.94680000000, -101.25550000000, '111225'),
(15854, 'US-TX-111226', 'Rio Medina', 'CI', 4214, 29.46560000000, -98.88280000000, '111226'),
(15855, 'US-TX-111227', 'Idalou', 'CI', 4214, 33.73150000000, -101.67770000000, '111227'),
(15856, 'US-TX-111228', 'Hermleigh', 'CI', 4214, 32.69490000000, -100.69430000000, '111228'),
(15857, 'US-KS-111229', 'Gardner', 'CI', 4183, 38.80770000000, -94.94520000000, '111229'),
(15858, 'US-KS-111230', 'Wellsville', 'CI', 4183, 38.70490000000, -95.11140000000, '111230'),
(15859, 'US-IA-111231', 'Kensett', 'CI', 4182, 43.34260000000, -93.22210000000, '111231'),
(15860, 'US-GA-111232', 'Pooler', 'CI', 4176, 32.09570000000, -81.25310000000, '111232'),
(15861, 'US-FL-111233', 'Crawfordville', 'CI', 4175, 30.17550000000, -84.33860000000, '111233'),
(15862, 'US-TN-111234', 'Paris', 'CI', 4213, 36.30810000000, -88.38250000000, '111234'),
(15863, 'US-LA-111235', 'Keithville', 'CI', 4185, 32.30490000000, -93.89780000000, '111235'),
(15864, 'US-MS-111236', 'Indianola', 'CI', 4192, 33.44050000000, -90.66240000000, '111236'),
(15865, 'US-TN-111237', 'Mc Minnville', 'CI', 4213, 35.65250000000, -85.72840000000, '111237'),
(15866, 'US-AR-111238', 'Fountain Hill', 'CI', 4165, 33.37910000000, -91.87600000000, '111238'),
(15867, 'US-WI-111239', 'Orfordville', 'CI', 4221, 42.62880000000, -89.23000000000, '111239'),
(15868, 'US-CT-111240', 'Woodbridge', 'CI', 4171, 41.35300000000, -73.00180000000, '111240'),
(15869, 'US-NJ-111241', 'Bergenfield', 'CI', 4198, 40.92330000000, -73.99840000000, '111241'),
(15870, 'US-NY-111242', 'New Lebanon', 'CI', 4200, 42.46970000000, -73.41430000000, '111242'),
(15871, 'US-NY-111243', 'Livingston Manor', 'CI', 4200, 41.93460000000, -74.72450000000, '111243'),
(15872, 'CA-ON-111244', 'Toronto', 'CI', 38, 43.66670000000, -79.41670000000, '111244'),
(15873, 'US-FL-111245', 'Palmetto', 'CI', 4175, 27.59310000000, -82.50510000000, '111245'),
(15874, 'CA-BC-111246', 'Parksville', 'CI', 38, 49.30000000000, -124.31670000000, '111246'),
(15875, 'US-PA-111247', 'University Park', 'CI', 4208, 40.80770000000, -77.86140000000, '111247'),
(15876, 'US-MA-111248', 'Amherst', 'CI', 4189, 42.40520000000, -72.52840000000, '111248'),
(15877, 'US-CA-111249', 'Stanford', 'CI', 4169, 37.41780000000, -122.17200000000, '111249'),
(15878, 'CA-AB-111250', 'Edmonton', 'CI', 38, 53.55000000000, -113.50000000000, '111250'),
(15879, 'US-NY-111251', 'Potsdam', 'CI', 4200, 44.66090000000, -74.92580000000, '111251'),
(15880, 'US-MS-111252', 'Stennis Space Center', 'CI', 4192, 30.40320000000, -89.49820000000, '111252'),
(15881, 'CA-BC-111253', 'Vancouver', 'CI', 38, 49.25000000000, -123.13330000000, '111253'),
(15883, 'CA-SK-111255', 'Saskatoon', 'CI', 38, 52.13330000000, -106.66670000000, '111255'),
(15884, 'US-MA-111256', 'Winthrop', 'CI', 4189, 42.36780000000, -70.96900000000, '111256'),
(15885, 'US-VA-111257', 'Dahlgren', 'CI', 4218, 38.34040000000, -77.03270000000, '111257'),
(15886, 'US-NJ-111258', 'Fort Monmouth', 'CI', 4198, 40.31390000000, -74.04810000000, '111258'),
(15888, 'CA-ON-111260', 'London', 'CI', 38, 42.98330000000, -81.25000000000, '111260'),
(15889, 'US-NM-111261', 'Socorro', 'CI', 4199, 33.89740000000, -107.02610000000, '111261'),
(15890, 'US-NJ-111262', 'Picatinny Arsenal', 'CI', 4198, 40.86730000000, -74.57830000000, '111262'),
(15891, 'US-AE-111263', 'Fpo', 'CI', 4167, NULL, NULL, '111263'),
(15892, 'US-NH-111264', 'Hanover', 'CI', 4197, 43.72260000000, -72.13420000000, '111264'),
(15893, 'CA-NS-111265', 'Halifax', 'CI', 38, 44.65000000000, -63.60000000000, '111265'),
(15894, 'US-TX-111266', 'Prairie View', 'CI', 4214, 30.08280000000, -95.98630000000, '111266'),
(15895, 'US-NM-111267', 'Kirtland Afb', 'CI', 4199, 35.05670000000, -106.57200000000, '111267'),
(15896, 'US-NY-111268', 'West Point', 'CI', 4200, 41.39310000000, -73.97330000000, '111268'),
(15897, 'US-NY-111269', 'South Glens Falls', 'CI', 4200, 43.28240000000, -73.63410000000, '111269'),
(15898, 'US-NY-111270', 'Warsaw', 'CI', 4200, 42.74010000000, -78.16480000000, '111270'),
(15899, 'US-NY-111271', 'Westons Mills', 'CI', 4200, 42.06050000000, -78.38040000000, '111271'),
(15900, 'US-NY-111272', 'North Tonawanda', 'CI', 4200, 43.07080000000, -78.82010000000, '111272'),
(15901, 'US-NY-111273', 'Hartsdale', 'CI', 4200, 41.02220000000, -73.81250000000, '111273'),
(15902, 'US-NY-111274', 'Saint Albans', 'CI', 4200, 40.69660000000, -73.76040000000, '111274'),
(15903, 'US-NY-111275', 'Oceanside', 'CI', 4200, 40.63430000000, -73.63810000000, '111275'),
(15904, 'US-NY-111276', 'Scarsdale', 'CI', 4200, 40.98830000000, -73.79540000000, '111276'),
(15905, 'US-NY-111277', 'Stony Brook', 'CI', 4200, 40.92230000000, -72.63710000000, '111277'),
(15906, 'US-IN-111278', 'Notre Dame', 'CI', 4181, 41.70070000000, -86.25010000000, '111278'),
(15907, 'US-IA-111279', 'Marshalltown', 'CI', 4182, 42.05420000000, -92.93050000000, '111279'),
(15908, 'CA-ON-111280', 'Waterloo', 'CI', 38, 43.46670000000, -80.53330000000, '111280'),
(15909, 'US-NY-111281', 'Copiague', 'CI', 4200, 40.67880000000, -73.39420000000, '111281'),
(15910, 'US-MA-111282', 'Milton', 'CI', 4189, 42.23890000000, -71.08100000000, '111282'),
(15911, 'US-NY-111283', 'Canton', 'CI', 4200, 44.59240000000, -75.10600000000, '111283'),
(15912, 'US-NY-111284', 'Tuckahoe', 'CI', 4200, 40.96180000000, -73.82390000000, '111284'),
(15913, 'US-ME-111285', 'Orono', 'CI', 4186, 45.00280000000, -68.63340000000, '111285'),
(15914, 'CA-ON-111286', 'Hamilton', 'CI', 38, 43.25000000000, -79.83330000000, '111286'),
(15915, 'US-MD-111287', 'Aberdeen Proving Ground', 'CI', 4188, 39.47380000000, -76.12880000000, '111287'),
(15916, 'CA-ON-111288', 'Kingston', 'CI', 38, 44.23330000000, -76.48330000000, '111288'),
(15917, 'US-MS-111289', 'Mississippi State', 'CI', 4192, 33.45310000000, -88.79320000000, '111289'),
(15918, 'US-NY-111290', 'Upton', 'CI', 4200, 40.84980000000, -72.88970000000, '111290'),
(15919, 'US-GA-111291', 'Lilburn', 'CI', 4176, 33.86390000000, -84.12430000000, '111291'),
(15920, 'US-PA-111292', 'Swarthmore', 'CI', 4208, 39.89640000000, -75.34630000000, '111292'),
(15921, 'US-LA-111293', 'Barksdale Afb', 'CI', 4185, 32.49710000000, -93.61200000000, '111293'),
(15922, 'CA-ON-111294', 'Guelph', 'CI', 38, 43.55000000000, -80.25000000000, '111294'),
(15923, 'US-RI-111295', 'Kingston', 'CI', 4210, 41.47730000000, -71.52080000000, '111295'),
(15924, 'CA-ON-111296', 'Nepean', 'CI', 38, 45.34670000000, -75.77000000000, '111296'),
(15925, 'CA-NS-111297', 'Wolfville', 'CI', 38, 45.08330000000, -64.36670000000, '111297'),
(15926, 'CA-AB-111298', 'Calgary', 'CI', 38, 51.08330000000, -114.08330000000, '111298'),
(15927, 'US-MD-111299', 'Andrews Air Force Base', 'CI', 4188, 38.80610000000, -76.87540000000, '111299'),
(15928, 'CA-QC-111300', 'Varennes', 'CI', 38, 45.68330000000, -73.43330000000, '111300'),
(15929, 'CA-NB-111301', 'Fredericton', 'CI', 38, 45.95000000000, -66.63330000000, '111301'),
(15930, 'US-AL-111302', 'Auburn University', 'CI', 4161, 32.57820000000, -85.34900000000, '111302'),
(15931, 'US-MA-111303', 'Northampton', 'CI', 4189, 42.31790000000, -72.64020000000, '111303'),
(15932, 'CA-AB-111304', 'Athabasca', 'CI', 38, 54.71670000000, -113.26670000000, '111304');
INSERT INTO `meta_location` (`id`, `iso`, `local_name`, `type`, `in_location`, `geo_lat`, `geo_lng`, `db_id`) VALUES
(15933, 'CA-QC-111305', 'Dorval', 'CI', 38, 45.45000000000, -73.75000000000, '111305'),
(15934, 'US-AE-111306', 'Apo', 'CI', 4167, NULL, NULL, '111306'),
(15935, 'US-AP-111307', 'Apo', 'CI', 4168, NULL, NULL, '111307'),
(15936, 'US-AK-111308', 'Eielson Afb', 'CI', 4162, 64.67480000000, -147.04850000000, '111308'),
(15937, 'US-AZ-111309', 'Luke Afb', 'CI', 4164, 33.53530000000, -112.38040000000, '111309'),
(15938, 'US-MT-111310', 'Malmstrom A F B', 'CI', 4194, 47.51020000000, -111.19590000000, '111310'),
(15939, 'US-NE-111311', 'Offutt A F B', 'CI', 4195, 41.11990000000, -95.90820000000, '111311'),
(15940, 'US-UT-111312', 'Roy', 'CI', 4215, 41.17870000000, -112.04930000000, '111312'),
(15941, 'US-MA-111313', 'Southbridge', 'CI', 4189, 42.07070000000, -72.04400000000, '111313'),
(15942, 'US-MA-111314', 'Oxford', 'CI', 4189, 42.11930000000, -71.85440000000, '111314'),
(15943, 'US-ND-111315', 'Grand Forks Afb', 'CI', 4202, 47.93350000000, -97.39440000000, '111315'),
(15944, 'US-NY-111316', 'South Salem', 'CI', 4200, 41.25500000000, -73.54090000000, '111316'),
(15945, 'CA-QC-111317', 'Montreal', 'CI', 38, 45.50000000000, -73.58330000000, '111317'),
(15946, 'CA-QC-111318', 'Quebec', 'CI', 38, 46.80000000000, -71.25000000000, '111318'),
(15948, 'CA-QC-111320', 'Sherbrooke', 'CI', 38, 45.40000000000, -71.90000000000, '111320'),
(15949, 'CA-QC-111321', 'Chicoutimi', 'CI', 38, 48.43330000000, -71.06670000000, '111321'),
(15950, 'CA-QC-111322', 'Gatineau', 'CI', 38, 45.48330000000, -75.65000000000, '111322'),
(15951, 'CA-QC-111323', 'Rimouski', 'CI', 38, 48.43330000000, -68.51670000000, '111323'),
(15952, 'CA-ON-111324', 'Chalk River', 'CI', 38, 46.01670000000, -77.45000000000, '111324'),
(15953, 'US-DE-111325', 'Dover Afb', 'CI', 4172, 39.12750000000, -75.46840000000, '111325'),
(15954, 'US-ME-111326', 'Limestone', 'CI', 4186, 46.89290000000, -67.96430000000, '111326'),
(15955, 'US-CA-111327', 'Travis Afb', 'CI', 4169, 38.26220000000, -121.93360000000, '111327'),
(15956, 'US-NM-111328', 'Cannon Afb', 'CI', 4199, 34.52020000000, -103.25190000000, '111328'),
(15957, 'US-OK-111329', 'Altus Afb', 'CI', 4205, 34.59820000000, -99.44080000000, '111329'),
(15958, 'US-TN-111330', 'Arnold A F B', 'CI', 4213, 35.49760000000, -86.07480000000, '111330'),
(15959, 'US-WY-111331', 'Fe Warren Afb', 'CI', 4222, 41.13910000000, -104.86290000000, '111331'),
(15960, 'US-TX-111332', 'Laughlin A F B', 'CI', 4214, 29.35640000000, -100.79270000000, '111332'),
(15961, 'US-CA-111333', 'Beale Afb', 'CI', 4169, 39.12480000000, -121.39940000000, '111333'),
(15962, 'US-MO-111334', 'Climax Springs', 'CI', 4193, 38.12100000000, -92.97790000000, '111334'),
(15963, 'US-NV-111335', 'Nellis Afb', 'CI', 4196, 36.24620000000, -114.96460000000, '111335'),
(15964, 'US-SD-111336', 'Ellsworth Afb', 'CI', 4212, 44.15090000000, -103.09440000000, '111336'),
(15965, 'US-IA-111337', 'Cedar Falls', 'CI', 4182, 42.46980000000, -92.30950000000, '111337'),
(15967, 'US-CA-111339', 'Claremont', 'CI', 4169, 34.12230000000, -117.71430000000, '111339'),
(15968, 'CA-ON-111340', 'Kanata', 'CI', 38, 45.33330000000, -75.90000000000, '111340'),
(15969, 'CA-ON-111341', 'Downsview', 'CI', 38, 43.71670000000, -79.48330000000, '111341'),
(15970, 'US-CA-111342', 'Moss Landing', 'CI', 4169, 36.84680000000, -121.77580000000, '111342'),
(15971, 'US-MD-111343', 'Smithsburg', 'CI', 4188, 39.64880000000, -77.56190000000, '111343'),
(15972, 'US-MA-111344', 'Chestnut Hill', 'CI', 4189, 42.31890000000, -71.15040000000, '111344'),
(15973, 'AU-04-111345', 'Brisbane', 'CI', 385, -27.50000000000, 153.01670000000, '111345'),
(15974, 'CH-11-111346', 'Ebikon', 'CI', 837, 47.08330000000, 8.33330000000, '111346'),
(15975, 'US-MO-111347', 'Whiteman Air Force Base', 'CI', 4193, 38.72830000000, -93.55490000000, '111347'),
(15976, 'US-WY-111348', 'Sheridan', 'CI', 4222, 44.77770000000, -106.83860000000, '111348'),
(15977, 'US-PA-111349', 'Stahlstown', 'CI', 4208, 40.13820000000, -79.31140000000, '111349'),
(15978, 'US-OR-111350', 'Halfway', 'CI', 4206, 44.94610000000, -117.10820000000, '111350'),
(15979, 'US-OR-111351', 'Nehalem', 'CI', 4206, 45.70460000000, -123.86180000000, '111351'),
(15981, 'US-NY-111353', 'New Paltz', 'CI', 4200, 41.75830000000, -74.06570000000, '111353'),
(15982, 'CA-PE-111354', 'Charlottetown', 'CI', 38, 46.23330000000, -63.13330000000, '111354'),
(15983, 'CA-BC-111355', 'Burnaby', 'CI', 38, 49.25000000000, -122.95000000000, '111355'),
(15984, 'CA-NB-111356', 'Dieppe', 'CI', 38, 46.10000000000, -64.75000000000, '111356'),
(15985, 'CA-NS-111357', 'Bedford', 'CI', 38, 44.72890000000, -63.66440000000, '111357'),
(15986, 'CA-NS-111358', 'Dartmouth', 'CI', 38, 44.66670000000, -63.56670000000, '111358'),
(15987, 'CA-NS-111359', 'Sydney', 'CI', 38, 46.15000000000, -60.16670000000, '111359'),
(15988, 'CA-ON-111360', 'Windsor', 'CI', 38, 42.33330000000, -83.03330000000, '111360'),
(15989, 'US-SD-111361', 'Brookings', 'CI', 4212, 44.36970000000, -96.79070000000, '111361'),
(15990, 'US-NY-111362', 'Geneseo', 'CI', 4200, 42.78120000000, -77.77780000000, '111362'),
(15993, 'US-SC-111365', 'Charleston Afb', 'CI', 4211, 32.90050000000, -80.05420000000, '111365'),
(15994, 'CA-QC-111366', 'Lachine', 'CI', 38, 45.41670000000, -73.66670000000, '111366'),
(15995, 'US-WY-111367', 'Torrington', 'CI', 4222, 42.29770000000, -104.24150000000, '111367'),
(15996, 'US-WY-111368', 'Powell', 'CI', 4222, 44.82900000000, -109.11100000000, '111368'),
(15997, 'US-WY-111369', 'Rock Springs', 'CI', 4222, 41.51590000000, -108.99420000000, '111369'),
(15998, 'US-NM-111370', 'Cochiti Pueblo', 'CI', 4199, 35.60910000000, -106.34450000000, '111370'),
(15999, 'US-MA-111371', 'South Hadley', 'CI', 4189, 42.25860000000, -72.57520000000, '111371'),
(16000, 'CA-NB-111372', 'Saint John', 'CI', 38, 45.26670000000, -66.06670000000, '111372'),
(16001, 'US-NJ-111373', 'Northfield', 'CI', 4198, 39.36250000000, -74.54950000000, '111373'),
(16002, 'US-MN-111374', 'Moorhead', 'CI', 4191, 46.84640000000, -96.74510000000, '111374'),
(16003, 'US-DC-111375', 'Washington Navy Yard', 'CI', 4173, 38.85550000000, -77.00220000000, '111375'),
(16004, 'US-AP-111376', 'Fpo', 'CI', 4168, NULL, NULL, '111376'),
(16005, 'CA-ON-111377', 'Weston', 'CI', 38, 43.70000000000, -79.50000000000, '111377'),
(16006, 'US-KS-111378', 'Burlington', 'CI', 4183, 38.22090000000, -95.74750000000, '111378'),
(16007, 'US-MN-111379', 'Saint Peter', 'CI', 4191, 44.33410000000, -94.06170000000, '111379'),
(16008, 'CA-ON-111380', 'Bancroft', 'CI', 38, 45.05000000000, -77.85000000000, '111380'),
(16009, 'CA-NB-111381', 'Sackville', 'CI', 38, 45.88330000000, -64.35000000000, '111381'),
(16010, 'US-MD-111382', 'Great Mills', 'CI', 4188, 38.21080000000, -76.48560000000, '111382'),
(16011, 'CA-BC-111383', 'Extension', 'CI', 38, 49.10000000000, -123.96670000000, '111383'),
(16012, 'US-KY-111384', 'Greenup', 'CI', 4184, 38.55060000000, -82.90320000000, '111384'),
(16013, 'CA-BC-111385', 'Prince George', 'CI', 38, 53.91670000000, -122.76670000000, '111385'),
(16014, 'CA-MB-111386', 'Saskatoon', 'CI', 38, 52.13330000000, -106.66670000000, '111386'),
(16015, 'CA-BC-111387', 'Winfield', 'CI', 38, 52.96670000000, -114.43330000000, '111387'),
(16016, 'CA-BC-111388', 'Sidney', 'CI', 38, 48.65000000000, -123.41670000000, '111388'),
(16017, 'CA-AB-111389', 'Red Deer', 'CI', 38, 52.26670000000, -113.80000000000, '111389'),
(16018, 'CA-AB-111390', 'Peace River', 'CI', 38, 56.23330000000, -117.28330000000, '111390'),
(16019, 'CA-AB-111391', 'Lloydminster', 'CI', 38, 53.28330000000, -110.00000000000, '111391'),
(16020, 'US-KY-111392', 'Russell', 'CI', 4184, 38.52410000000, -82.69350000000, '111392'),
(16021, 'CA-AB-111393', 'Fort Vermillion', 'CI', 38, 58.40000000000, -116.00000000000, '111393'),
(16022, 'CA-AB-111394', 'Airdrie', 'CI', 38, 51.26670000000, -114.01670000000, '111394'),
(16023, 'US-VA-111395', 'Gloucester Point', 'CI', 4218, 37.25710000000, -76.49360000000, '111395'),
(16024, 'CA-AB-111396', 'Sherwood Park', 'CI', 38, 53.51670000000, -113.31670000000, '111396'),
(16025, 'CA-AB-111397', 'Medicine Hat', 'CI', 38, 50.03330000000, -110.68330000000, '111397'),
(16026, 'US-KY-111398', 'Wilmore', 'CI', 4184, 37.84480000000, -84.67150000000, '111398'),
(16027, 'US-KY-111399', 'Paint Lick', 'CI', 4184, 37.58140000000, -84.40770000000, '111399'),
(16028, 'US-KY-111400', 'Burkesville', 'CI', 4184, 36.74890000000, -85.36600000000, '111400'),
(16029, 'US-KY-111401', 'Manchester', 'CI', 4184, 37.14100000000, -83.73720000000, '111401'),
(16030, 'US-NE-111402', 'Louisville', 'CI', 4195, 40.99290000000, -96.14440000000, '111402'),
(16031, 'CA-BC-111403', 'Salmon Arm', 'CI', 38, 50.70000000000, -119.28330000000, '111403'),
(16032, 'CA-SK-111404', 'Plunkett', 'CI', 38, 51.90000000000, -105.45000000000, '111404'),
(16033, 'US-KY-111405', 'Lancaster', 'CI', 4184, 37.68770000000, -84.59070000000, '111405'),
(16034, 'US-KY-111406', 'Lebanon', 'CI', 4184, 37.54080000000, -85.25100000000, '111406'),
(16035, 'US-KY-111407', 'Brownsville', 'CI', 4184, 37.23750000000, -86.33480000000, '111407'),
(16036, 'US-KY-111408', 'Cecilia', 'CI', 4184, 37.66470000000, -86.06070000000, '111408'),
(16037, 'US-KY-111409', 'Albany', 'CI', 4184, 36.75150000000, -85.12010000000, '111409'),
(16038, 'US-KY-111410', 'Bronston', 'CI', 4184, 36.93180000000, -84.63790000000, '111410'),
(16039, 'CA-BC-111411', 'Nanaimo', 'CI', 38, 49.15000000000, -123.91670000000, '111411'),
(16040, 'CA-BC-111412', 'Duncan', 'CI', 38, 48.78330000000, -123.70000000000, '111412'),
(16041, 'CA-AB-111413', 'Leduc', 'CI', 38, 53.26670000000, -113.53330000000, '111413'),
(16042, 'CA-AB-111414', 'Nisku', 'CI', 38, 53.33330000000, -113.53330000000, '111414'),
(16043, 'CA-AB-111415', 'Wainwright', 'CI', 38, 52.83330000000, -110.86670000000, '111415'),
(16044, 'CA-AB-111416', 'Grande Prairie', 'CI', 38, 55.16670000000, -118.80000000000, '111416'),
(16045, 'US-MA-111417', 'South Dennis', 'CI', 4189, 41.71380000000, -70.15430000000, '111417'),
(16046, 'CA-BC-111418', 'New Westminster', 'CI', 38, 49.21670000000, -122.91670000000, '111418'),
(16047, 'CA-ON-111419', 'Mississauga', 'CI', 38, 43.15000000000, -79.50000000000, '111419'),
(16048, 'US-WA-111420', 'Keyport', 'CI', 4219, 47.69800000000, -122.62340000000, '111420'),
(16049, 'US-MA-111421', 'South Yarmouth', 'CI', 4189, 41.67130000000, -70.19160000000, '111421'),
(16050, 'US-MA-111422', 'Falmouth', 'CI', 4189, 41.57480000000, -70.62750000000, '111422'),
(16051, 'US-MA-111423', 'North Falmouth', 'CI', 4189, 41.63780000000, -70.62780000000, '111423'),
(16052, 'US-MA-111424', 'Mashpee', 'CI', 4189, 41.61620000000, -70.49310000000, '111424'),
(16053, 'US-MA-111425', 'Osterville', 'CI', 4189, 41.63630000000, -70.38560000000, '111425'),
(16054, 'US-MA-111426', 'Provincetown', 'CI', 4189, 42.05110000000, -70.19600000000, '111426'),
(16055, 'US-MA-111427', 'Barnstable', 'CI', 4189, 41.70010000000, -70.30880000000, '111427'),
(16056, 'US-MA-111428', 'East Falmouth', 'CI', 4189, 41.59980000000, -70.56310000000, '111428'),
(16057, 'US-MA-111429', 'Hinsdale', 'CI', 4189, 42.43190000000, -73.07400000000, '111429'),
(16058, 'US-MA-111430', 'Sharon', 'CI', 4189, 42.11090000000, -71.18490000000, '111430'),
(16059, 'US-MA-111431', 'Stoneham', 'CI', 4189, 42.47300000000, -71.09820000000, '111431'),
(16060, 'US-MA-111432', 'East Sandwich', 'CI', 4189, 41.72850000000, -70.43340000000, '111432'),
(16061, 'US-MA-111433', 'Dennis Port', 'CI', 4189, 41.66860000000, -70.13740000000, '111433'),
(16062, 'US-MA-111434', 'Cataumet', 'CI', 4189, 41.66600000000, -70.61370000000, '111434'),
(16063, 'US-MA-111435', 'Marstons Mills', 'CI', 4189, 41.66860000000, -70.41400000000, '111435'),
(16064, 'US-MN-111436', 'Winona', 'CI', 4191, 43.98480000000, -91.60640000000, '111436'),
(16065, 'US-UT-111437', 'Dugway', 'CI', 4215, 40.32360000000, -112.79750000000, '111437'),
(16066, 'US-OH-111438', 'Rootstown', 'CI', 4204, 41.09080000000, -81.18440000000, '111438'),
(16067, 'US-MD-111439', 'Patuxent River', 'CI', 4188, 38.27830000000, -76.41870000000, '111439'),
(16068, 'US-VT-111440', 'Middlebury', 'CI', 4216, 43.99570000000, -73.15960000000, '111440'),
(16069, 'US-MA-111441', 'Wellesley', 'CI', 4189, 42.29360000000, -71.29600000000, '111441'),
(16070, 'US-MA-111442', 'Arlington', 'CI', 4189, 42.41550000000, -71.17560000000, '111442'),
(16071, 'US-MA-111443', 'West Roxbury', 'CI', 4189, 42.27930000000, -71.16570000000, '111443'),
(16072, 'US-MA-111444', 'Reading', 'CI', 4189, 42.53350000000, -71.10360000000, '111444'),
(16073, 'US-AZ-111445', 'Casa Grande', 'CI', 4164, 32.83450000000, -111.73060000000, '111445'),
(16074, 'US-MA-111446', 'Salisbury', 'CI', 4189, 42.85090000000, -70.86410000000, '111446'),
(16075, 'US-MA-111447', 'East Orleans', 'CI', 4189, 41.78860000000, -69.96250000000, '111447'),
(16076, 'US-MA-111448', 'Melrose', 'CI', 4189, 42.45740000000, -71.05400000000, '111448'),
(16077, 'US-MA-111449', 'Jamaica Plain', 'CI', 4189, 42.30990000000, -71.12020000000, '111449'),
(16078, 'US-MA-111450', 'New Town', 'CI', 4189, 42.33360000000, -71.20410000000, '111450'),
(16079, 'US-MA-111451', 'West Dennis', 'CI', 4189, 41.66020000000, -70.17100000000, '111451'),
(16080, 'US-MA-111452', 'Turners Falls', 'CI', 4189, 42.63760000000, -72.50960000000, '111452'),
(16081, 'US-MA-111453', 'Marshfield', 'CI', 4189, 42.11120000000, -70.71270000000, '111453'),
(16082, 'US-MA-111454', 'Richmond', 'CI', 4189, 42.38850000000, -73.36540000000, '111454'),
(16083, 'US-MA-111455', 'Groton', 'CI', 4189, 42.61650000000, -71.57700000000, '111455'),
(16084, 'US-MA-111456', 'West Boylston', 'CI', 4189, 42.36380000000, -71.77490000000, '111456'),
(16085, 'US-MA-111457', 'Medfield', 'CI', 4189, 42.18200000000, -71.31000000000, '111457'),
(16086, 'US-NH-111458', 'Amherst', 'CI', 4197, 42.87060000000, -71.61240000000, '111458'),
(16087, 'US-MA-111459', 'Wareham', 'CI', 4189, 41.76360000000, -70.71600000000, '111459'),
(16088, 'US-MA-111460', 'Westport', 'CI', 4189, 41.60770000000, -71.06760000000, '111460'),
(16089, 'US-MA-111461', 'Ipswich', 'CI', 4189, 42.68250000000, -70.84700000000, '111461'),
(16090, 'US-MA-111462', 'Hull', 'CI', 4189, 42.28460000000, -70.87410000000, '111462'),
(16091, 'US-NH-111463', 'Hampton Falls', 'CI', 4197, 42.93190000000, -70.87510000000, '111463'),
(16092, 'US-MA-111464', 'Cohasset', 'CI', 4189, 42.23280000000, -70.81760000000, '111464'),
(16093, 'US-MA-111465', 'Carlisle', 'CI', 4189, 42.53280000000, -71.35200000000, '111465'),
(16094, 'US-NH-111466', 'Plaistow', 'CI', 4197, 42.84300000000, -71.09500000000, '111466'),
(16095, 'US-MA-111467', 'Roslindale', 'CI', 4189, 42.28300000000, -71.12090000000, '111467'),
(16096, 'US-MA-111468', 'West Medford', 'CI', 4189, 42.42430000000, -71.13230000000, '111468'),
(16097, 'US-MA-111469', 'Oak Bluffs', 'CI', 4189, 41.45370000000, -70.56340000000, '111469'),
(16098, 'US-NH-111470', 'Pelham', 'CI', 4197, 42.74100000000, -71.31610000000, '111470'),
(16099, 'US-MA-111471', 'Norton', 'CI', 4189, 41.96090000000, -71.18040000000, '111471'),
(16100, 'US-MA-111472', 'Longmeadow', 'CI', 4189, 42.05350000000, -72.56850000000, '111472'),
(16101, 'US-RI-111473', 'Rumford', 'CI', 4210, 41.84420000000, -71.35320000000, '111473'),
(16102, 'US-MA-111474', 'Sturbridge', 'CI', 4189, 42.10170000000, -72.07980000000, '111474'),
(16103, 'US-MA-111475', 'Rowley', 'CI', 4189, 42.71770000000, -70.89570000000, '111475'),
(16104, 'US-MA-111476', 'Plainville', 'CI', 4189, 42.01500000000, -71.33420000000, '111476'),
(16105, 'US-MA-111477', 'Swampscott', 'CI', 4189, 42.47550000000, -70.90690000000, '111477'),
(16106, 'DK-05-111478', 'Gentofte', 'CI', 1093, 55.75000000000, 12.55000000000, '111478'),
(16107, 'US-AZ-111479', 'Somerton', 'CI', 4164, 32.53760000000, -114.71380000000, '111479'),
(16108, 'US-AZ-111480', 'Buckeye', 'CI', 4164, 33.38460000000, -112.55170000000, '111480'),
(16109, 'CA-NS-111481', 'Antigonish', 'CI', 38, 45.61670000000, -61.96670000000, '111481'),
(16110, 'CA-QC-111482', 'Longueuil', 'CI', 38, 45.53330000000, -73.51670000000, '111482'),
(16111, 'CH-23-111483', 'Vevey', 'CI', 849, 46.45000000000, 6.85000000000, '111483'),
(16112, 'FI-13-111484', 'Helsinki', 'CI', 1299, 60.17560000000, 24.93420000000, '111484'),
(16113, 'US-NJ-111485', 'East Orange', 'CI', 4198, 40.75990000000, -74.20790000000, '111485'),
(16114, 'US-PA-111486', 'Sidman', 'CI', 4208, 40.31070000000, -78.69590000000, '111486'),
(16115, 'US-WV-111487', 'Mannington', 'CI', 4220, 39.52250000000, -80.38730000000, '111487'),
(16116, 'US-NY-111488', 'Kerhonkson', 'CI', 4200, 41.79540000000, -74.30920000000, '111488'),
(16117, 'US-MA-111489', 'Cheshire', 'CI', 4189, 42.55860000000, -73.14620000000, '111489'),
(16118, 'US-NY-111490', 'Gouverneur', 'CI', 4200, 44.34800000000, -75.46990000000, '111490'),
(16119, 'US-NY-111491', 'Locke', 'CI', 4200, 42.65660000000, -76.41600000000, '111491'),
(16120, 'US-NY-111492', 'Camden', 'CI', 4200, 43.44560000000, -75.76360000000, '111492'),
(16121, 'US-NY-111493', 'Ogdensburg', 'CI', 4200, 44.60520000000, -75.59470000000, '111493'),
(16122, 'US-NY-111494', 'Cooperstown', 'CI', 4200, 42.71280000000, -74.91730000000, '111494'),
(16124, 'US-NJ-111496', 'Scotch Plains', 'CI', 4198, 40.63960000000, -74.36480000000, '111496'),
(16125, 'US-NJ-111497', 'Seaside Heights', 'CI', 4198, 39.94920000000, -74.08730000000, '111497'),
(16126, 'US-NJ-111498', 'Weehawken', 'CI', 4198, 40.76860000000, -74.01990000000, '111498'),
(16127, 'US-NJ-111499', 'Wildwood', 'CI', 4198, 38.98280000000, -74.82950000000, '111499'),
(16128, 'US-PA-111500', 'Crum Lynne', 'CI', 4208, 39.86190000000, -75.33480000000, '111500'),
(16129, 'US-NJ-111501', 'Ocean City', 'CI', 4198, 39.25480000000, -74.60290000000, '111501'),
(16130, 'US-NJ-111502', 'Runnemede', 'CI', 4198, 39.85080000000, -75.07520000000, '111502'),
(16131, 'US-NJ-111503', 'Bordentown', 'CI', 4198, 40.10050000000, -74.72030000000, '111503'),
(16132, 'US-NJ-111504', 'Wood Ridge', 'CI', 4198, 40.85130000000, -74.08680000000, '111504'),
(16133, 'US-NJ-111505', 'Butler', 'CI', 4198, 40.98750000000, -74.37880000000, '111505'),
(16134, 'US-NJ-111506', 'Verona', 'CI', 4198, 40.83310000000, -74.24270000000, '111506'),
(16135, 'US-NJ-111507', 'Cedarville', 'CI', 4198, 39.32820000000, -75.20540000000, '111507'),
(16136, 'US-PA-111508', 'Shawnee On Delaware', 'CI', 4208, 41.00970000000, -75.11140000000, '111508'),
(16137, 'US-PA-111509', 'East Stroudsburg', 'CI', 4208, 41.07150000000, -75.12780000000, '111509'),
(16138, 'US-PA-111510', 'Richland', 'CI', 4208, 40.43160000000, -76.27760000000, '111510'),
(16139, 'US-PA-111511', 'Cornwall', 'CI', 4208, 40.27640000000, -76.40850000000, '111511'),
(16140, 'US-MA-111512', 'Housatonic', 'CI', 4189, 42.26490000000, -73.38350000000, '111512'),
(16141, 'US-PA-111513', 'East Freedom', 'CI', 4208, 40.33690000000, -78.47460000000, '111513'),
(16142, 'US-PA-111514', 'Royersford', 'CI', 4208, 40.20400000000, -75.53810000000, '111514'),
(16143, 'US-VA-111515', 'Lynch Station', 'CI', 4218, 37.13250000000, -79.36870000000, '111515'),
(16144, 'US-PA-111516', 'Harleysville', 'CI', 4208, 40.27010000000, -75.40400000000, '111516'),
(16145, 'US-PA-111517', 'East Greenville', 'CI', 4208, 40.41800000000, -75.51570000000, '111517'),
(16146, 'US-PA-111518', 'Aston', 'CI', 4208, 39.86710000000, -75.42800000000, '111518'),
(16147, 'US-PA-111519', 'Barnesville', 'CI', 4208, 40.80130000000, -76.09160000000, '111519'),
(16148, 'US-VA-111520', 'Lebanon', 'CI', 4218, 36.86290000000, -82.14230000000, '111520'),
(16149, 'US-VA-111521', 'Wallops Island', 'CI', 4218, 37.92190000000, -75.47090000000, '111521'),
(16150, 'US-VA-111522', 'Nelsonia', 'CI', 4218, 37.83230000000, -75.57000000000, '111522'),
(16151, 'US-VA-111523', 'Eastville', 'CI', 4218, 37.27860000000, -75.96030000000, '111523'),
(16152, 'US-VA-111524', 'Cape Charles', 'CI', 4218, 37.25420000000, -75.96020000000, '111524'),
(16153, 'US-VA-111525', 'Melfa', 'CI', 4218, 37.62190000000, -75.72900000000, '111525'),
(16154, 'US-MD-111526', 'Grasonville', 'CI', 4188, 38.93660000000, -76.20810000000, '111526'),
(16155, 'US-VA-111527', 'Appomattox', 'CI', 4218, 37.35430000000, -78.75830000000, '111527'),
(16156, 'US-VA-111528', 'King William', 'CI', 4218, 37.67420000000, -77.02310000000, '111528'),
(16157, 'US-VA-111529', 'Irvington', 'CI', 4218, 37.66500000000, -76.41470000000, '111529'),
(16158, 'US-VA-111530', 'Stuarts Draft', 'CI', 4218, 38.00700000000, -79.04830000000, '111530'),
(16159, 'US-WV-111531', 'Sugar Grove', 'CI', 4220, 38.51080000000, -79.34860000000, '111531'),
(16160, 'US-WV-111532', 'Buckhannon', 'CI', 4220, 38.98220000000, -80.20080000000, '111532'),
(16161, 'US-WV-111533', 'Romney', 'CI', 4220, 39.29540000000, -78.73110000000, '111533'),
(16162, 'US-MT-111534', 'Columbia Falls', 'CI', 4194, 48.54480000000, -114.34730000000, '111534'),
(16163, 'US-WV-111535', 'Baisden', 'CI', 4220, 37.56570000000, -81.89850000000, '111535'),
(16164, 'US-WV-111536', 'Iaeger', 'CI', 4220, 37.46790000000, -81.76340000000, '111536'),
(16165, 'US-MA-111537', 'Lakeville', 'CI', 4189, 41.84350000000, -70.96520000000, '111537'),
(16166, 'US-PA-111538', 'Clarendon', 'CI', 4208, 41.72680000000, -79.11340000000, '111538'),
(16167, 'US-MA-111539', 'Chartley', 'CI', 4189, 41.96730000000, -71.24160000000, '111539'),
(16168, 'US-MA-111540', 'Prides Crossing', 'CI', 4189, 42.56160000000, -70.83370000000, '111540'),
(16169, 'US-MA-111541', 'South Weymouth', 'CI', 4189, 42.16580000000, -70.95060000000, '111541'),
(16170, 'US-MA-111542', 'Lancaster', 'CI', 4189, 42.47210000000, -71.66600000000, '111542'),
(16171, 'US-NY-111543', 'Bear Mountain', 'CI', 4200, 41.16090000000, -74.06080000000, '111543'),
(16172, 'US-NY-111544', 'Sloatsburg', 'CI', 4200, 41.15370000000, -74.20140000000, '111544'),
(16173, 'US-NY-111545', 'East Moriches', 'CI', 4200, 40.80790000000, -72.75770000000, '111545'),
(16174, 'US-VA-111546', 'Exmore', 'CI', 4218, 37.51420000000, -75.87800000000, '111546'),
(16175, 'US-NY-111547', 'Jefferson Valley', 'CI', 4200, 41.33390000000, -73.79840000000, '111547'),
(16176, 'US-NY-111548', 'Carle Place', 'CI', 4200, 40.75050000000, -73.61160000000, '111548'),
(16177, 'US-NY-111549', 'Floral Park', 'CI', 4200, 40.72510000000, -73.70700000000, '111549'),
(16178, 'US-NY-111550', 'West Hempstead', 'CI', 4200, 40.68940000000, -73.65020000000, '111550'),
(16179, 'US-NY-111551', 'Massapequa', 'CI', 4200, 40.68260000000, -73.46700000000, '111551'),
(16180, 'US-NY-111552', 'Smithtown', 'CI', 4200, 40.85940000000, -73.21210000000, '111552'),
(16181, 'US-OR-111553', 'Amity', 'CI', 4206, 45.10760000000, -123.23250000000, '111553'),
(16182, 'US-NY-111554', 'Honeoye Falls', 'CI', 4200, 42.96800000000, -77.59760000000, '111554'),
(16183, 'US-MD-111555', 'Capitol Heights', 'CI', 4188, 38.89120000000, -76.89530000000, '111555'),
(16184, 'US-MD-111556', 'Riverdale', 'CI', 4188, 38.96600000000, -76.90760000000, '111556'),
(16185, 'US-VA-111557', 'Mclean', 'CI', 4218, 38.94280000000, -77.19220000000, '111557'),
(16186, 'US-MD-111558', 'Mc Henry', 'CI', 4188, 39.55860000000, -79.37360000000, '111558'),
(16187, 'US-VA-111559', 'Round Hill', 'CI', 4218, 39.13500000000, -77.77180000000, '111559'),
(16188, 'US-MD-111560', 'Middletown', 'CI', 4188, 39.45620000000, -77.56670000000, '111560'),
(16189, 'US-MD-111561', 'Marriottsville', 'CI', 4188, 39.34560000000, -76.90500000000, '111561'),
(16190, 'US-PA-111562', 'Broomall', 'CI', 4208, 39.97590000000, -75.36460000000, '111562'),
(16191, 'US-PA-111563', 'Essington', 'CI', 4208, 39.86840000000, -75.22230000000, '111563'),
(16192, 'US-PA-111564', 'Pitman', 'CI', 4208, 40.71290000000, -76.49060000000, '111564'),
(16193, 'US-PA-111565', 'Woodlyn', 'CI', 4208, 39.87480000000, -75.34610000000, '111565'),
(16194, 'US-PA-111566', 'Gwynedd Valley', 'CI', 4208, 40.18260000000, -75.25870000000, '111566'),
(16195, 'US-PA-111567', 'West Willow', 'CI', 4208, 39.97120000000, -76.28810000000, '111567'),
(16196, 'US-PA-111568', 'Quakertown', 'CI', 4208, 40.46390000000, -75.32630000000, '111568'),
(16197, 'US-PA-111569', 'Levittown', 'CI', 4208, 40.14420000000, -74.84830000000, '111569'),
(16198, 'US-PA-111570', 'Smethport', 'CI', 4208, 41.76630000000, -78.45660000000, '111570'),
(16199, 'US-PA-111571', 'Morrisdale', 'CI', 4208, 41.00160000000, -78.18120000000, '111571'),
(16200, 'US-PA-111572', 'Bellwood', 'CI', 4208, 40.60480000000, -78.33490000000, '111572'),
(16201, 'US-PA-111573', 'Northern Cambria', 'CI', 4208, 40.62690000000, -78.83610000000, '111573'),
(16202, 'US-NJ-111574', 'Garwood', 'CI', 4198, 40.65030000000, -74.32310000000, '111574'),
(16203, 'US-PA-111575', 'Natrona Heights', 'CI', 4208, 40.63740000000, -79.72640000000, '111575'),
(16204, 'US-PA-111576', 'Turtle Creek', 'CI', 4208, 40.41690000000, -79.82350000000, '111576'),
(16205, 'US-PA-111577', 'Connellsville', 'CI', 4208, 40.03060000000, -79.53900000000, '111577'),
(16206, 'US-PA-111578', 'Sharpsville', 'CI', 4208, 41.29880000000, -80.48880000000, '111578'),
(16207, 'FR-B9-111579', 'Lyon', 'CI', 1331, 45.75000000000, 4.85000000000, '111579'),
(16209, 'US-CA-111581', 'Del Mar', 'CI', 4169, 32.96720000000, -117.25860000000, '111581'),
(16210, 'US-NY-111582', 'Pearl River', 'CI', 4200, 41.06050000000, -74.01660000000, '111582'),
(16211, 'US-DC-111583', 'Naval Anacost Annex', 'CI', 4173, 38.89330000000, -77.01460000000, '111583'),
(16212, 'US-PA-111584', 'Haverford', 'CI', 4208, 40.00700000000, -75.31770000000, '111584'),
(16213, 'US-PA-111585', 'Tidioute', 'CI', 4208, 41.68740000000, -79.31570000000, '111585'),
(16214, 'US-NY-111586', 'Islip Terrace', 'CI', 4200, 40.75870000000, -73.17370000000, '111586'),
(16215, 'US-VA-111587', 'Clifton', 'CI', 4218, 38.77640000000, -77.38780000000, '111587'),
(16216, 'US-DE-111588', 'Hockessin', 'CI', 4172, 39.78500000000, -75.68230000000, '111588'),
(16217, 'US-WV-111589', 'Beaver', 'CI', 4220, 37.79160000000, -81.07890000000, '111589'),
(16218, 'US-NY-111590', 'Hewlett', 'CI', 4200, 40.63640000000, -73.69390000000, '111590'),
(16219, 'US-MD-111591', 'Bladensburg', 'CI', 4188, 38.94320000000, -76.92680000000, '111591'),
(16220, 'US-MA-111592', 'Greenfield', 'CI', 4189, 42.63420000000, -72.60260000000, '111592'),
(16221, 'US-MA-111593', 'Worthington', 'CI', 4189, 42.39920000000, -72.94230000000, '111593'),
(16222, 'US-NY-111594', 'Edmeston', 'CI', 4200, 42.69880000000, -75.25460000000, '111594'),
(16223, 'US-WV-111595', 'Lyburn', 'CI', 4220, 37.72570000000, -81.91500000000, '111595'),
(16224, 'US-MD-111596', 'District Heights', 'CI', 4188, 38.85160000000, -76.88390000000, '111596'),
(16225, 'US-PA-111597', 'Halifax', 'CI', 4208, 40.48000000000, -76.79290000000, '111597'),
(16226, 'US-PA-111598', 'Woodward', 'CI', 4208, 40.91910000000, -77.32180000000, '111598'),
(16227, 'US-NY-111599', 'Bedford', 'CI', 4200, 41.18860000000, -73.62180000000, '111599'),
(16228, 'US-PA-111600', 'Be