<?php
/**
 * Home Buyer Feedback Form template.
 *
 * @package    WPFormsFormTemplates
 * @author     WPForms
 * @since      1.0.0
 * @license    GPL-2.0+
 * @copyright  Copyright (c) 2017, WPForms LLC
 */
class WPForms_Template_Home_Buyer_Feedback extends WPForms_Template {

	/**
	 * Primary class constructor.
	 *
	 * @since 1.0.0
	 */
	public function init() {

		$this->name = __( 'Home Buyer Feedback Form', 'wpforms-form-templates-pack' );
		$this->slug = 'home-buyer-feedback';
		$this->data = array(
			'field_id' => 8,
			'fields' => array(
				1 => array(
					'id' => '1',
					'type' => 'radio',
					'label' => __( 'Are you a first-time home buyer, or have you purchased a home before?', 'wpforms-form-templates-pack' ),
					'choices' => array(
						1 => array(
							'label' => __( 'First time home buyer', 'wpforms-form-templates-pack' ),
						),
						2 => array(
							'label' => __( 'Purchased home before', 'wpforms-form-templates-pack' ),
						),
					),
				),
				2 => array(
					'id' => '2',
					'type' => 'radio',
					'label' => __( 'How did you begin your most recent search for a home?', 'wpforms-form-templates-pack' ),
					'choices' => array(
						1 => array(
							'label' => __( 'Searched the internet', 'wpforms-form-templates-pack' ),
						),
						2 => array(
							'label' => __( 'Drove through neighborhoods looking for home sales', 'wpforms-form-templates-pack' ),
						),
						3 => array(
							'label' => __( 'Contacted real estate agent', 'wpforms-form-templates-pack' ),
						),
						4 => array(
							'label' => __( 'Attended open house event', 'wpforms-form-templates-pack' ),
						),
						5 => array(
							'label' => __( 'Searched magazines', 'wpforms-form-templates-pack' ),
						),
						6 => array(
							'label' => __( 'Searched newspapers', 'wpforms-form-templates-pack' ),
						),
					),
				),
				3 => array(
					'id' => '3',
					'type' => 'checkbox',
					'label' => __( 'Which sources of information did you use during your most recent search for a home?', 'wpforms-form-templates-pack' ),
					'choices' => array(
						1 => array(
							'label' => __( 'Internet', 'wpforms-form-templates-pack' ),
						),
						2 => array(
							'label' => __( 'Newspapers', 'wpforms-form-templates-pack' ),
						),
						3 => array(
							'label' => __( 'Magazines', 'wpforms-form-templates-pack' ),
						),
						4 => array(
							'label' => __( 'Open houses', 'wpforms-form-templates-pack' ),
						),
						5 => array(
							'label' => __( 'Real estate agents', 'wpforms-form-templates-pack' ),
						),
						6 => array(
							'label' => __( 'Yard signs', 'wpforms-form-templates-pack' ),
						),
					),
				),
				5 => array(
					'id' => '5',
					'type' => 'radio',
					'label' => __( 'Which of the following internet websites did you find most helpful during your most recent search for a home?', 'wpforms-form-templates-pack' ),
					'choices' => array(
						1 => array(
							'label' => __( 'Realtor.com', 'wpforms-form-templates-pack' ),
						),
						2 => array(
							'label' => __( 'Real estate companies\' websites', 'wpforms-form-templates-pack' ),
						),
						3 => array(
							'label' => __( 'Social networking websites', 'wpforms-form-templates-pack' ),
						),
						4 => array(
							'label' => __( 'Zillow', 'wpforms-form-templates-pack' ),
						),
						5 => array(
							'label' => __( 'Redfin', 'wpforms-form-templates-pack' ),
						),
						6 => array(
							'label' => __( 'Other', 'wpforms-form-templates-pack' ),
						),
					),
				),
				6 => array(
					'id' => '6',
					'type' => 'radio',
					'label' => __( 'Where did you find the home you most recently purchased?', 'wpforms-form-templates-pack' ),
					'choices' => array(
						1 => array(
							'label' => __( 'Newspaper', 'wpforms-form-templates-pack' ),
						),
						2 => array(
							'label' => __( 'Open house', 'wpforms-form-templates-pack' ),
						),
						3 => array(
							'label' => __( 'Internet', 'wpforms-form-templates-pack' ),
						),
						4 => array(
							'label' => __( 'Magazine', 'wpforms-form-templates-pack' ),
						),
						5 => array(
							'label' => __( 'Real estate agent', 'wpforms-form-templates-pack' ),
						),
						6 => array(
							'label' => __( 'Yard sign', 'wpforms-form-templates-pack' ),
						),
					),
				),
			),
			'settings' => array(
				'honeypot' => '1',
				'confirmation_message_scroll' => '1',
				'submit_text_processing' => __( 'Sending...', 'wpforms-form-templates-pack' ),
			),
			'meta' => array(
				'template' => $this->slug,
			),
		);
	}
}
new WPForms_Template_Home_Buyer_Feedback;
