<?php

namespace WPFormsDrip;

use WPForms\Providers\Loader as ProvidersLoader;

/**
 * Class Plugin that loads the plugin.
 *
 * @package    WPFormsDrip
 * @author     WPForms
 * @since      1.0.0
 * @license    GPL-2.0+
 * @copyright  Copyright (c) 2018, WPForms LLC
 */
class Plugin {

	/**
	 * Get a single instance of the plugin.
	 *
	 * @since 1.0.0
	 *
	 * @return \WPFormsDrip\Plugin
	 */
	public static function get_instance() {

		static $instance;

		if ( ! $instance ) {
			$instance = new Plugin();
		}

		return $instance;
	}

	/**
	 * Plugin constructor.
	 *
	 * @since 1.0.0
	 */
	public function __construct() {

		$this->load_translations();

		$providers_loader = ProvidersLoader::get_instance();

		$providers_loader->register(
			Provider\Core::get_instance()
		);
	}

	/**
	 * Load translated strings.
	 *
	 * @since 1.0.0
	 */
	protected function load_translations() {
		load_plugin_textdomain( 'wpforms-drip', false, dirname( plugin_basename( WPFORMS_DRIP_FILE ) ) . '/languages/' );
	}
}
