<?php
/**
 * Schema Pro Init
 *
 * @package Schema Pro
 */

// Refresh bundled products on activate.
register_activation_hook( __FILE__, 'on_bsf_aiosrs_pro_activate' );

/**
 * Bsf aiosrs pro activate
 *
 * @since 1.1.0
 * @return void
 */
function on_bsf_aiosrs_pro_activate() {
	update_site_option( 'bsf_force_check_extensions', true );
}

define( 'BSF_REMOVE_WP-SCHEMA-PRO_FROM_REGISTRATION_LISTING', true );

if ( ! class_exists( 'BSF_AIOSRS_Pro' ) ) {

	/**
	 * BSF_AIOSRS_Pro initial setup
	 *
	 * @since 1.0.0
	 */
	class BSF_AIOSRS_Pro {

		/**
		 * Class instance.
		 *
		 * @access private
		 * @var $instance Class instance.
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 *  Constructor
		 */
		public function __construct() {

			// Includes Required Files.
			$this->includes();
			add_action( 'admin_notices', array( $this, 'setup_wizard_notice' ) );
			add_action( 'wp_ajax_wp_schema_pro_setup_wizard_notice', array( $this, 'wp_schema_pro_setup_wizard_notice_callback' ) );

			// Add popup license form on plugin list page.
			add_action( 'plugin_action_links_' . BSF_AIOSRS_PRO_BASE, array( $this, 'bsf_aiosrs_pro_license_form_and_links' ) );
			add_action( 'network_admin_plugin_action_links_' . BSF_AIOSRS_PRO_BASE, array( $this, 'bsf_aiosrs_pro_license_form_and_links' ) );
			add_filter( 'bsf_skip_braisntorm_menu', array( $this, 'bsf_aiosrs_pro_skip_brainstorm_menu' ) );
			add_filter( 'bsf_registration_page_url_wp-schema-pro', array( $this, 'bsf_aiosrs_pro_bsf_registration_page_url' ) );
		}

		/**
		 * Show action links on the plugin screen.
		 *
		 * @param   mixed $links Plugin Action links.
		 * @return  array        Filtered plugin action links.
		 */
		function bsf_aiosrs_pro_license_form_and_links( $links = array() ) {
			if ( function_exists( 'get_bsf_inline_license_form' ) ) {

				$args = array(
					'product_id'              => 'wp-schema-pro',
					'popup_license_form'      => true,
					'bsf_license_allow_email' => true,
				);

				return get_bsf_inline_license_form( $links, $args, 'envato' );
			}

			return $links;
		}

		/**
		 * Skip brainstorm menu
		 *
		 * @param string $products ID.
		 * @since 1.1.0
		 * @return $products
		 */
		function bsf_aiosrs_pro_skip_brainstorm_menu( $products ) {

			$products[] = 'wp-schema-pro'; // Brainstorm ID of the product.

			return $products;
		}

		/**
		 * Bsf registration page
		 *
		 * @since 1.1.0
		 */
		function bsf_aiosrs_pro_bsf_registration_page_url() {
			if ( is_multisite() ) {
				return network_admin_url( 'plugins.php?bsf-inline-license-form=wp-schema-pro' );
			} else {
				return admin_url( 'plugins.php?bsf-inline-license-form=wp-schema-pro' );
			}
		}

		/**
		 * Setup Wizard
		 *
		 * @since 1.1.0
		 */
		public function setup_wizard_notice() {

			if ( get_transient( 'wp-schema-pro-activated' ) ) {
				$url = admin_url( 'index.php?page=aiosrs-pro-setup-wizard' );

				echo '<div class="wp-schema-pro-setup-wizard-notice notice notice-success is-dismissible">';
				echo '<p>' . __( 'Configure Schema Pro step by step. ', 'wp-schema-pro' ) . '<a href="' . esc_url( $url ) . '">' . __( 'Start setup wizard &raquo;', 'wp-schema-pro' ) . '</a></p>';
				echo '</div>';
				?>
				<script type="text/javascript">
					(function($){
						$(document).on('click', '.wp-schema-pro-setup-wizard-notice .notice-dismiss', function(){
							$.ajax({
								url: ajaxurl,
								type: 'POST',
								data: {
									action 	: 'wp_schema_pro_setup_wizard_notice',
									nonce : '<?php echo wp_create_nonce( 'wp-schema-pro-setup-wizard-notice' ); ?>'
								},
							});
						});
					})(jQuery);
				</script>
				<?php
			}
		}

		/**
		 * Dismiss Notice
		 *
		 * @return void
		 */
		public function wp_schema_pro_setup_wizard_notice_callback() {
			wp_verify_nonce( $_POST['nonce'], 'wp-schema-pro-setup-wizard-notice' );

			delete_transient( 'wp-schema-pro-activated' );
			wp_send_json_success();
		}

		/**
		 * Include required files.
		 *
		 * @since 1.0.0
		 * @return void
		 */
		public function includes() {
			require_once BSF_AIOSRS_PRO_DIR . 'classes/lib/target-rule/class-bsf-target-rule-fields.php';
			require_once BSF_AIOSRS_PRO_DIR . 'classes/lib/class-bsf-custom-post-list-table.php';
			require_once BSF_AIOSRS_PRO_DIR . 'classes/class-wp-schema-pro-yoast-compatibility.php';
			require_once BSF_AIOSRS_PRO_DIR . 'classes/class-bsf-aiosrs-pro-admin.php';
			require_once BSF_AIOSRS_PRO_DIR . 'classes/class-bsf-aiosrs-pro-schema.php';
			require_once BSF_AIOSRS_PRO_DIR . 'classes/class-bsf-aiosrs-pro-custom-fields-markup.php';

			/**
			 * Frontend.
			 */
			require_once BSF_AIOSRS_PRO_DIR . 'classes/class-bsf-aiosrs-pro-schema-template.php';
			require_once BSF_AIOSRS_PRO_DIR . 'classes/class-bsf-aiosrs-pro-markup.php';
		}

	}
}

/**
 * Kicking this off by calling 'get_instance()' method
 */
BSF_AIOSRS_Pro::get_instance();
