<?php
// don't load directly
if (!defined('ABSPATH')) die('-1');



class WPPAS_VC_Addon
{
    function __construct() 
	{
		add_action( 'admin_init', array( $this, 'register_params' ), 15 );
		add_action( 'vc_before_init', array($this, 'integrateADPLUGWithVC') );
	}
	
	public function integrateADPLUGWithVC() 
	{	
        // Check if Visual Composer is installed
        if ( ! defined( 'WPB_VC_VERSION' ) ) {
			// Display notice that Visual Compser is required
			//add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
			return;
		}
		
		global $wppas_banner_creator, $pro_ads_adzones;
		
		// Select all available banners
		$banners = $wppas_banner_creator->all_banners_query();
		$banner_arr = array();
		$banner_arr['Select Banner or Adzone'] = '';
		$banner_arr['--------------------- BANNERS ---------------------'] = '';
		foreach( $banners as $banner )
		{
			$banner_arr[$banner->post_title] = $banner->ID;
		}
		
		// Select all available adzones
		$adzones = $wppas_banner_creator->all_banners_query(array('post_type' => 'wppas_adzones'));
		$adzone_arr = array();
		$adzone_arr['--------------------- ADZONES ---------------------'] = '';
		foreach( $adzones as $adzone )
		{
			$adzone_arr[$adzone->post_title] = $adzone->ID;
		}
		// alternative adzones
		$adzones = $pro_ads_adzones->get_adzones();
		foreach( $adzones as $adzone )
		{
			$adzone_arr[$adzone->post_title] = $adzone->ID;
		}
		
		$options = wp_parse_args( $adzone_arr, $banner_arr );
		
		vc_map( array(
			"name" => __("Advertising"),
			"description" => __("Add advertisements to your website", 'wpproads'),
			"base" => "wpproads",
			"icon" => plugins_url('../images/logo_32.png', __FILE__),
			"class" => "",
			"category" => __('Content','wpproads'),
			//'admin_enqueue_js' => array(get_template_directory_uri().'/vc_extend/bartag.js'),
			//'admin_enqueue_css' => array(get_template_directory_uri().'/vc_extend/bartag.css'),
			"params" => array(
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __("Banner/Adzone", "wpproads"),
					"param_name" => "id",
					"admin_label" => true,
					"value" => $options,
					"description" => __("Select the banner/adzone you want to use.", "wpproads"),
					//'save_always' => true,
				),
				/*array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __("Center"),
					"param_name" => "center",
					"value" => array(1, 0),
					"description" => __("Center the banner/adzone on the page.<br><br>", "wpproads") 
				),*/
				
				array(
					"type" => "wppas_switch",
					"holder" => "div",
					"class" => "",
					"heading" => __("Center"),
					"param_name" => "center",
					"value" => 1,
					"description" => __("Center the banner/adzone on the page.<br><br>", "wpproads") 
				),
				/*
				// Needs to work...
				array(
					'type' => 'css_editor',
					'heading' => __( 'CSS box', 'wpproads' ),
					'param_name' => 'wppas_css_vc_design',
					'group' => __( 'Design Options', 'wpproads' )
				),*/
				
				
				
				
				
				/*array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __("Container", 'wpproads'),
					"param_name" => "container",
					"value" => __("", 'wpproads'),
					"description" => __("Add the ID of your websites main container. (default <strong>body</strong>)", 'wpproads')
				),*/
				/*array(
					"type" => "html",
					"holder" => "div",
					"class" => "",
					//"heading" => __("<h2 style='margin-bottom:0'>Popup Ads</h2>", 'wpproads'),
					"description" => __("<div style='background:#EEE; padding:5px;'><h2 style='margin:0'><small><em>Optional</em> - </small> Popup Ads</h2> Popup ads allow you to open the adzone in a popup window.<hr></div>", 'wpproads')
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __("Adzone is Popup"),
					"param_name" => "popup",
					"value" => array( __('No','wpproads') => "", __('Yes','wpproads') => "1"),
					"description" => __("Select if you want the adzone to open as a popup.<br><br>", "wpproads") 
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __("Popup Background Color", 'wpproads'),
					"param_name" => "popup_bg",
					"value" => '', //Default Red color
					"description" => __("Select the Popup background color", 'wpproads')
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __("Banner is Popup"),
					"param_name" => "popup_opacity",
					"value" => array('', 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1),
					"description" => __("Select the Popup background opacity.<br><br>", "wpproads") 
				),
				array(
					"type" => "html",
					"holder" => "div",
					"class" => "",
					//"heading" => __("<h2 style='margin-bottom:0'>Popup Ads</h2>", 'wpproads'),
					"description" => __("<div style='background:#EEE; padding:5px;'><h2 style='margin:0'><small><em>Optional</em> - </small> Background Ads</h2> Background ads make it possible to load your adzone as the post/page background.<hr></div>", 'wpproads')
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __("Adzone is Background"),
					"param_name" => "background",
					"value" => array( __('No','wpproads') => "", __('Yes','wpproads') => "1"),
					"description" => __("Select if you want the adzone to loaded as the page background.", "wpproads") 
				),
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => __("Container", 'wpproads'),
					"param_name" => "container",
					"value" => __("", 'wpproads'),
					"description" => __("Add the ID of your websites main container. (default <strong>body</strong>)", 'wpproads')
				),
				array(
					"type" => "colorpicker",
					"holder" => "div",
					"class" => "",
					"heading" => __("Background Color", 'wpproads'),
					"param_name" => "bg_color",
					"value" => '', //Default Red color
					"description" => __("Select the page background color", 'wpproads')
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __("Stretch"),
					"param_name" => "stretch",
					"value" => array( __('No','wpproads') => "", __('Yes','wpproads') => "1"),
					"description" => __("Stretch the background image to the full width of the page.", "wpproads") 
				),
				array(
					"type" => "dropdown",
					"holder" => "div",
					"class" => "",
					"heading" => __("Repeat"),
					"param_name" => "repeat",
					"value" => array( __('No','wpproads') => "", __('Yes','wpproads') => "1"),
					"description" => __("", "wpproads") 
				),*/
			)
		) );
	}
	
	
	
	
	public function compatible_vc_add_shortcode_param($name, $form_field_callback, $script_url = '' )
	{
		if(defined('WPB_VC_VERSION') && version_compare(WPB_VC_VERSION, 4.4) >= 0) {
			if(function_exists('vc_add_shortcode_param'))
			{
				vc_add_shortcode_param( $name, $form_field_callback, $script_url );
			}
		}
	}
	
	
	
	
	public function register_params()
	{
		wp_enqueue_script('jquery');
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script("jquery-effects-core");
		wp_enqueue_script('WPPAS_VBC');
		wp_enqueue_script('wp_pro_ads_js_switch_button');
		wp_enqueue_style("wp_pro_ads_main_style", WP_ADS_TPL_URL."/css/wppas.min.css", false, WP_ADS_VERSION, "all");
		wp_enqueue_style("WPPAS_VBC_EDITR_STYLE", WP_ADS_URL."public/assets/css/vbc/wppas_vbc_editor.css", false, WP_ADS_VERSION, "all");
		
		
		$this->compatible_vc_add_shortcode_param( 'wppas_switch', array( $this, 'switch_param' ), WP_ADS_URL . 'public/assets/js/vbc/vc_extend/wppas-vc-scripts.js' ); //  jquery.wppas.vbc.js
	}	
	
	
	
	
	/**
	 * Return Switch Button - Checkbox
	 *
	 * @param array $settings
	 * @param string $value
	 *
	 * @return string
	 */
	public function switch_param( $settings, $value ) 
	{
		$param_name = $settings['param_name'];
		$html = '';
		
		return WPPAS_TPL::checkbox_cont(array(
			'title' => __('','wpproads'),
			'desc' => __('','wpproads'),
			'id' => 'wppas-'.$param_name ,
			'class' => 'wpb_vc_param_value ' . esc_attr( $param_name ).' '.esc_attr( $value ),
			'name' => esc_attr( $param_name ),
			'value' => esc_attr( $value )
		));
	}
	
	
    /*Show notice if your plugin is activated but Visual Composer is not
    
    public function showVcVersionNotice() 
	{
        $plugin_data = get_plugin_data(__FILE__);
        echo '<div class="updated"><p>'.sprintf(__('<strong>%s</strong> requires <strong><a href="http://bit.ly/vcomposer" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', 'wpproads'), $plugin_data['Name']).'</p></div>';
    }
	*/
}
?>