<?php
class WPPAS_Shape_Items {
	
	
	/**
	 * CREATE ARRAY WITH SHAPE ITEMS
	 */
	public function shape_items($args = array())
	{
		$items = array();
		$shapes = $this->shape_items_arr();
		$i = 0;
		foreach($shapes as $key => $shape)
		{
			$items[$i]['name'] = $key;
			$items[$i]['colors'] = array_key_exists('colors', $shape) ? $shape['colors'] : array('#000000');
			$items[$i]['code'] = $shape['code'];
			
			$i++;
		}
		
		$shape_array = apply_filters( 'wppas_shape_items', $items );
		
		// Loop to remove line breaks.
		$items = array();
		$i = 0;
		foreach($shape_array as $shape)
		{
			$items[$i]['name'] = $shape['name'];
			$items[$i]['colors'] = array_key_exists('colors', $shape) ? $shape['colors'] : array('#000000');
			$items[$i]['code'] = str_replace(array("\r", "\n"), '', $shape['code']);
			$i++;
		}
	
		return $items;
	}
	
	
	
	
	public function shape_items_arr($args = array())
	{
		$defaults = array(
			'item'        => '',
			'colors'      => array('#000000')
		);
		$args = wp_parse_args( $args, $defaults );
		
		$shape = array();
		
		/**
		 * Square
		 */
		$shape['square']['colors'] = array('#000000');
		/*$shape['square']['css'] = array(
			'background-color' => $shape['square']['colors'][0],
			'border-width' => 0,
			'border-style' => 'solid',
			'border-color' => 'transparent',
			'border-radius' => 0
		);*/
		$shape['square']['code'] = '<div class="shape c1" style="background-color:'.$shape['square']['colors'][0].'; border: 0px solid rgb(0, 0, 0); border-radius: 0px;"></div>';
		
		/**
		 * Square Border
		 */
		$shape['square_border']['colors'] = array('#000000');
		$shape['square_border']['code'] = '<div class="shape c1" style="border-width:2px;border-style:solid;border-color:'.$shape['square']['colors'][0].';border-radius:0px;"></div>';
		
		/**
		 * Square Rounded corners
		 */
		$shape['square_rounded']['colors'] = array('#000000');
		$shape['square_rounded']['code'] = '<div class="shape c1" style="background-color:'.$shape['square']['colors'][0].'; border: 0px solid rgb(0, 0, 0); border-radius: 10px;"></div>';
		
		/**
		 * Circle
		 */
		$shape['circle']['colors'] = array('#000000');
		$shape['circle']['code'] = '<div class="shape c1" style="background-color:'.$shape['circle']['colors'][0].'; border: 0px solid rgb(0, 0, 0); border-radius: 100%;"></div>';
		
		/**
		 * Circle Border
		 */
		$shape['circle_border']['colors'] = array('#000000');
		$shape['circle_border']['code'] = '<div class="shape c1" style="border-width:2px;border-style:solid;border-color:'.$shape['circle_border']['colors'][0].';border-radius:100%;"></div>';
		
		
		/**
		 * Triangle Border
		 */
		$shape['triangle_border']['colors'] = array('#000000');
		$shape['triangle_border']['code'] = '<svg height="100%" width="100%" viewBox="0 0 64 64" class="shape"><polygon class="colorful c1" style="fill:transparent;stroke:'.$shape['triangle_border']['colors'][0].';stroke-width:4px;" points="30,4 4,60 60,60"/><polygon></svg>';
		
		
		/**
		 * Play Button
		 */
		$shape['play_button']['colors'] = array('#000000');
		$shape['play_button']['code'] = '<svg height="100%" width="100%" viewBox="0 0 64 64"><g><path class="colorful c1" style="fill:'.$shape['play_button']['colors'][0].';stroke:transparent;stroke-width:0;" d="M30.9,16.9L58,32L11.5,57.5L5,61V3L30.9,16.9z"></path></g></svg>';
		
		
		/**
		 * STAR
		 */
		$shape['star_1']['colors'] = array('#000000');
		$shape['star_1']['code'] = '<svg height="100%" width="100%" viewBox="0 0 64 64"><g><path id="outline" class="colorful c1" style="stroke:'.$shape['star_1']['colors'][0].';stroke-width:2px;fill:transparent;" d="M12.6,62.2L20,38.6L0.7,24h23.9L32,0.6L39.4,24h23.9L44,38.6l7.4,23.5L32,47.7L12.6,62.2z M6.6,26l15.7,11.8l-6,19L32,45.2l15.6,11.6l-6-18.9L57.4,26H38L32,7.2L26,26H6.6z"></path></g></svg>';
		
		
		/**
		 * Text Baloon 1
		 */
		$shape['txt_baloon_1']['colors'] = array('#000000');
		$shape['txt_baloon_1']['code'] = '<svg width="100%" height="100%" viewBox="0 0 100 85"><path style="fill:'.$shape['txt_baloon_1']['colors'][0].';" class="colorful c1" d="m23.235,81.5 l0.001-14.408 H0 V0 h100 v67 H51.487 L23.235,81.5z"></path></svg>';
		
		
		
		return !empty($args['item']) ? $shape[$args['item']]['code'] : $shape;
	}
	
	
}
?>