<?php
class WPPAS_SVG_Items {
	
	/**
	 * CREATE ARRAY WITH SVG ITEMS
	 * @since v5.1.6
	 */
	public function svg_items($args = array())
	{
		$items = array();
		$svgs = $this->svg_items_arr();
		$i = 0;
		foreach($svgs as $key => $svg)
		{
			$items[$i]['name'] = $key;
			$items[$i]['colors'] = array_key_exists('colors', $svg) ? $svg['colors'] : array('#000000');
			$items[$i]['code'] = $svg['code'];
			
			$i++;
		}
		
		$svg_array = apply_filters( 'wppas_svg_items', $items );
		
		// Loop to remove line breaks.
		$items = array();
		$i = 0;
		foreach($svg_array as $svg)
		{
			$items[$i]['name'] = $svg['name'];
			$items[$i]['colors'] = array_key_exists('colors', $svg) ? $svg['colors'] : array('#000000');
			$items[$i]['code'] = str_replace(array("\r", "\n"), '', $svg['code']);
			$i++;
		}
	
		return $items;
	}
	
	
	
	public function svg_color_data($colors = array())
	{
		$str = '';
		if( !empty($colors))
		{
			$str.= ' data-colors="';
			foreach($colors as $i => $color)
			{
				$coma = $i == 0 ? '' : ',';
				$str.= $coma.$color;
			}
			$str.= '"';
		}
		
		return $str;	
	}
	
	
	
	
	public function svg_items_arr($args = array())
	{
		$defaults = array(
			'item'        => '',
			'colors'      => array('#000000')
		);
		$args = wp_parse_args( $args, $defaults );
		
		$svg = array();
		
		/**
		 * Heart
		 */
		$svg['heart']['colors'] = array('#DD3333');
		$svg['heart']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['heart']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 113.807 100.293" enable-background="new 0 0 113.807 100.293" xml:space="preserve"><path class="colorful c1" fill="'.$svg['heart']['colors'][0].'" d="M56.91,16.84C46.017-9.636-7.452-6.682,0.877,38.533C6.425,68.738,48.23,97.17,56.91,100.293c8.667-3.123,50.472-31.555,56.02-61.76C121.258-6.682,67.79-9.636,56.91,16.84"/></svg>';
		
		
		/**
		 * Double Circle
		 */
		/*$svg['double_circle']['colors'] = array('#2ecc71', '#08BCD0');
		$svg['double_circle']['code'] = '<svg viewBox="0 0 64 64" height="100%" width="100%"><circle cx="32" cy="32" r="28" class="colorful c1" style="stroke:#2ecc71;stroke-width:4;fill:none;"></circle><circle cx="32" cy="32" r="20" class="colorful c2" style="stroke:#08BCD0;stroke-width:4;fill:none;" /></svg>';*/

		
		/**
		 * Camera
		 */
		$svg['camera']['colors'] = array('#0F3D4D');
		$svg['camera']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['camera']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
width="100%" height="100%" viewBox="0 0 127.472 99.268" enable-background="new 0 0 127.472 99.268"
xml:space="preserve">
<path fill="#FFFFFF" d="M44.663,24.045c0,3.101-2.512,5.614-5.609,5.614c-3.102,0-5.614-2.514-5.614-5.614
c0-3.1,2.512-5.612,5.614-5.612C42.151,18.433,44.663,20.945,44.663,24.045"/>
<path class="colorful c1" fill="'.$svg['camera']['colors'][0].'" d="M118.995,13.64h-13.201l-1.944-6.775c0-2.705-2.188-4.897-4.899-4.897H47.686
c-2.702,0-4.895,2.192-4.895,4.897l-1.94,6.775h-9.412c-0.037-2.487-2.061-4.49-4.557-4.49H16.541c-2.496,0-4.519,2.003-4.559,4.49
H8.096c-3.72,0-6.734,3.013-6.734,6.734v70.487c0,3.72,3.014,6.735,6.734,6.735h110.898c3.721,0,6.736-3.016,6.736-6.735V20.374
C125.731,16.652,122.715,13.64,118.995,13.64"/>
<path fill="#FFFFFF" d="M39.386,55.358c0,18.619,15.148,33.768,33.765,33.768c18.621,0,33.765-15.148,33.765-33.768
c0-18.616-15.144-33.766-33.765-33.766C54.534,21.593,39.386,36.742,39.386,55.358 M42.455,55.358
c0-16.923,13.769-30.695,30.696-30.695c16.925,0,30.697,13.772,30.697,30.695c0,16.926-13.772,30.698-30.697,30.698
C56.224,86.057,42.455,72.284,42.455,55.358"/>
<path fill="#FFFFFF" d="M54.268,36.473c-5.05,5.046-7.827,11.754-7.827,18.886c0,14.727,11.983,26.714,26.71,26.714
c14.728,0,26.711-11.987,26.711-26.714c0-7.132-2.778-13.84-7.821-18.886c-5.048-5.046-11.755-7.821-18.89-7.821
S59.311,31.427,54.268,36.473 M48.87,55.358c0-6.486,2.528-12.581,7.112-17.167c4.587-4.587,10.684-7.113,17.169-7.113
c6.486,0,12.586,2.526,17.172,7.113c4.586,4.586,7.109,10.681,7.109,17.167c0,13.389-10.892,24.285-24.281,24.285
C59.762,79.644,48.87,68.747,48.87,55.358"/>
<path fill="#FFFFFF" d="M101.943,7.183c0,0.745-0.601,1.35-1.347,1.35H46.718c-0.74,0-1.346-0.604-1.346-1.35
c0-0.742,0.606-1.344,1.346-1.344h53.878C101.342,5.839,101.943,6.44,101.943,7.183"/>
</svg>';



		/**
		 * Glasses
		 * '.$this->svg_color_data($svg['glasses']['colors']).'
		 */
		$svg['glasses']['colors'] = array('#E44331');
		$svg['glasses']['code'] = '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
width="100%" height="100%" viewBox="0 0 168.864 63.37" enable-background="new 0 0 168.864 63.37" xml:space="preserve"><path class="colorful c1" fill="'.$svg['glasses']['colors'][0].'" d="M130.195,2.01c-22.314,0-33.573,6.014-45.587,6.014c-12.016,0-23.274-6.014-45.589-6.014,c-18.734,0-36.735,5.838-36.735,5.838v11.831c1.077,0.061,3.805,0.445,4.079,3.663C8.2,45.475,15.057,62.077,36.829,62.077,c23.426,0,32.483-10.187,36.759-23.371v0.002c3.351-9.415,7.129-16.977,11.021-16.977c3.89,0,7.668,7.562,11.019,16.977v-0.002,c4.275,13.185,13.334,23.371,36.759,23.371c21.772,0,28.629-16.602,30.467-38.734c0.273-3.218,3.001-3.602,4.078-3.663V7.848,C166.931,7.848,148.93,2.01,130.195,2.01,M7.849,14.496c-1.899,0-2.895-0.752-2.895-1.678c0-0.927,0.995-1.678,2.895-1.678,c1.9,0,2.896,0.751,2.896,1.678C10.744,13.744,9.749,14.496,7.849,14.496,M38.465,58.403c-20.419,0-26.688-14.205-27.596-33.354,C10.241,11.804,24.08,6.508,40.378,6.508c16.297,0,31.325,3.347,31.325,17.114C71.703,39.102,62.612,58.403,38.465,58.403,M158.346,25.048c-0.908,19.149-7.177,33.354-27.596,33.354c-24.147,0-33.238-19.301-33.238-34.781,c0-13.767,15.028-17.114,31.325-17.114C145.135,6.508,158.974,11.804,158.346,25.048 M161.366,14.496,c-1.9,0-2.896-0.752-2.896-1.678c0-0.927,0.995-1.678,2.896-1.678c1.899,0,2.895,0.751,2.895,1.678,C164.261,13.744,163.266,14.496,161.366,14.496"/></svg>';
		
		
		
		/** 
		 * Mustach
		 */
		$svg['mustach']['colors'] = array('#00A1A6');
		$svg['mustach']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['mustach']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"width="100%" height="100%" viewBox="0 0 200 66.301" enable-background="new 0 0 200 66.301" xml:space="preserve"><path class="colorful c1" fill="'.$svg['mustach']['colors'][0].'" d="M127.322,14.321c2.623,1.865,5.083,4.26,7.38,7.185c2.296,2.93,4.527,5.957,6.692,9.082c2.166,3.128,4.395,6.156,6.691,9.081c2.295,2.928,4.854,5.358,7.676,7.285c2.82,1.93,6.004,3.093,9.546,3.493c3.543,0.398,7.608-0.331,12.202-2.196c3.019-1.197,5.611-3.093,7.775-5.688s3.706-5.489,4.625-8.683c0.916-3.193,1.147-6.518,0.689-9.979c-0.461-3.458-1.805-6.717-4.035-9.779c-2.362-3.06-4.891-4.691-7.578-4.89c-2.689-0.201-4.889,0.566-6.593,2.295c-1.707,1.729-2.56,4.16-2.56,7.285c0,3.127,1.641,6.354,4.922,9.68c-3.021,0-5.412-0.83-7.185-2.495c-1.771-1.662-3.021-3.624-3.739-5.888c-0.724-2.262-0.855-4.656-0.394-7.186c0.458-2.525,1.407-4.591,2.854-6.187c2.097-2.127,4.557-3.459,7.381-3.992c2.818-0.53,5.607-0.399,8.363,0.399c2.756,0.798,5.346,2.229,7.775,4.291c2.426,2.064,4.359,4.559,5.806,7.483c1.31,3.063,2.097,6.422,2.362,10.08c0.261,3.661-0.198,7.354-1.378,11.078c-1.181,3.726-3.084,7.285-5.708,10.678c-2.626,3.394-6.037,6.287-10.234,8.683c-7.219,4.126-14.958,6.755-23.225,7.884c-8.268,1.132-16.174,0.798-23.717-0.998c-7.547-1.797-14.303-4.99-20.272-9.581c-5.973-4.59-10.269-10.609-12.892-18.063c-2.626,7.454-6.923,13.474-12.892,18.063c-5.972,4.591-12.728,7.784-20.271,9.581c-7.548,1.796-15.451,2.13-23.717,0.998c-8.267-1.129-16.011-3.758-23.225-7.884c-4.201-2.396-7.611-5.289-10.235-8.683c-2.626-3.393-4.527-6.952-5.708-10.678c-1.18-3.725-1.672-7.417-1.475-11.078c0.196-3.658,1.014-7.017,2.46-10.08c1.31-2.925,3.214-5.419,5.707-7.483c2.491-2.062,5.118-3.493,7.873-4.291c2.756-0.799,5.542-0.93,8.365-0.399c2.82,0.533,5.281,1.865,7.381,3.992c1.442,1.596,2.393,3.661,2.854,6.187c0.458,2.529,0.325,4.924-0.394,7.186c-0.723,2.264-1.968,4.226-3.74,5.888c-1.771,1.665-4.166,2.495-7.184,2.495c3.279-3.325,4.921-6.553,4.921-9.68c0-3.125-0.855-5.556-2.559-7.285c-1.706-1.729-3.905-2.496-6.593-2.295c-2.691,0.198-5.216,1.83-7.578,4.89c-2.232,3.062-3.576,6.321-4.034,9.779c-0.462,3.462-0.231,6.786,0.688,9.979c0.917,3.193,2.461,6.088,4.626,8.683s4.754,4.49,7.774,5.688c4.592,1.865,8.66,2.595,12.203,2.196c3.542-0.4,6.722-1.563,9.546-3.493c2.82-1.927,5.378-4.357,7.675-7.285c2.295-2.925,4.527-5.953,6.692-9.081c2.165-3.125,4.361-6.152,6.594-9.082c2.23-2.925,4.724-5.319,7.479-7.185c2.756-1.996,5.413-3.194,7.971-3.593c2.558-0.399,4.985-0.23,7.282,0.499c2.294,0.732,4.395,1.965,6.299,3.691c1.9,1.732,3.641,3.793,5.215,6.188c1.575-2.396,3.312-4.456,5.216-6.188c1.901-1.727,3.967-2.959,6.2-3.691c2.229-0.729,4.656-0.898,7.281-0.499C121.875,11.127,124.566,12.325,127.322,14.321"/></svg>';
		
		
		/**
		 * Music Note
		 */
		$svg['music_note']['colors'] = array('#000000');
		$svg['music_note']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['music_note']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"width="100%" height="100%" viewBox="0 0 123.81 123.443" enable-background="new 0 0 123.81 123.443"xml:space="preserve"><path class="colorful c1" fill="'.$svg['music_note']['colors'][0].'" d="M32.667,115.751c0.574-0.459,1.138-0.943,1.7-1.458c4.932-4.542,8.018-10.38,9.02-16.076l0.078,0.021l0.09-1.072c0.108-0.812,0.178-1.621,0.191-2.414l0.629-7.879l0.902-11.262l1.44-17.938l0.902-11.332l0.612-7.749l40.192-7.777l25.382-4.916l-0.659,8.188l-1.291,16.091L111,60.909l-1.203,15.047c-5.725-5.94-15.698-5.703-24.161,0.287c-0.417,0.301-0.856,0.543-1.271,0.867c-0.574,0.461-1.146,0.932-1.695,1.445c-2.607,2.41-4.688,5.18-6.236,8.098c-4.075,7.684-4.331,16.402,0.083,22.174c5.739,7.531,17.257,7.416,26.503,0.088c0.571-0.456,1.143-0.941,1.701-1.454c4.539-4.177,7.501-9.456,8.717-14.7c0.348-1.489,0.583-2.971,0.637-4.432h0.004l0.51-6.252l1.588-19.887l0.854-10.752l1.299-16.141l0.828-10.426l0.023-0.359l1.766-22.141L45.302,17.01l-0.615-0.061l-0.319,3.937l-0.906,11.313l-1.179,14.792L41.379,58.26l-1.431,17.829l-0.522,6.68c-6.014-6.215-16.725-5.717-25.417,1.174c-0.577,0.463-1.146,0.947-1.689,1.453c-2.705,2.493-4.845,5.385-6.404,8.408c-3.917,7.615-4.105,16.16,0.247,21.873C11.899,123.187,23.416,123.075,32.667,115.751"/></svg>';
		
		
		
		/**
		 * Iphone 1
		 */
		$svg['iphone_1']['colors'] = array('#000000');
		$svg['iphone_1']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['iphone_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"width="100%" height="100%" viewBox="0 0 118.681 200" enable-background="new 0 0 118.681 200" xml:space="preserve"><g><g><rect x="2.59" y="31.691" fill="#A8A8A7" width="1.451" height="10.879"/><rect x="88.912" y="1.663" fill="#A8A8A7" width="14.504" height="1.451"/><rect x="2.59" y="47.979" fill="#A8A8A7" width="1.451" height="10.879"/><path fill="#C6C6C6" d="M107.025,197.888H12.744c-4.798,0-8.702-3.904-8.702-8.703V11.816c0-4.799,3.904-8.702,8.702-8.702h94.281c4.799,0,8.703,3.903,8.703,8.702v177.368C115.728,193.983,111.824,197.888,107.025,197.888z"/><path class="colorful c1" fill="'.$svg['iphone_1']['colors'][0].'" d="M114.278,189.185c0,4.006-3.247,7.253-7.253,7.253H12.744c-4.005,0-7.252-3.247-7.252-7.253V11.816c0-4.006,3.247-7.252,7.252-7.252h94.281c4.006,0,7.253,3.246,7.253,7.252V189.185z"/><rect x="10.931" y="24.892" fill="#474949" width="97.907" height="146.076"/><path fill="#474949" d="M66.286,176.903c-2.345-2.345-10.459-2.345-12.803,0c-2.343,2.343-2.343,10.459,0,12.802c2.344,2.344,10.458,2.345,12.803,0C68.629,187.361,68.629,179.248,66.286,176.903z"/><path fill="#474949" d="M49.082,17.56c-1.377,0-2.493-1.116-2.493-2.493s1.116-2.493,2.493-2.493h21.606c1.377,0,2.493,1.116,2.493,2.493s-1.116,2.493-2.493,2.493H49.082z"/><circle fill="#474949" cx="81.842" cy="15.066" r="3.264"/><circle cx="81.842" cy="15.066" r="1.451"/><path d="M59.885,187.747L59.885,187.747c-1.54,0-2.829-0.371-3.45-0.993c-1.322-1.321-1.322-5.578,0-6.899c0.621-0.622,1.91-0.993,3.45-0.993c1.538,0,2.828,0.371,3.449,0.993c0.622,0.621,0.993,1.91,0.993,3.45c0,1.539-0.371,2.828-0.993,3.449C62.713,187.376,61.423,187.747,59.885,187.747z M59.885,179.768c-1.246,0-2.375,0.293-2.81,0.728c-0.972,0.971-0.972,4.647,0,5.618c0.435,0.435,1.563,0.727,2.81,0.727l0,0c1.245,0,2.374-0.291,2.809-0.727c0.435-0.435,0.727-1.564,0.727-2.809c0-1.246-0.292-2.375-0.727-2.81S61.13,179.768,59.885,179.768z"/></g></g></svg>';
		
		
		
		/**
		 * Iphone 2
		 */
		/*
		$svg['iphone_2']['colors'] = array();
		$svg['iphone_2']['code'] = '<svg id="thePhone"'.$this->svg_color_data($svg['iphone_2']['colors']).' version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%"	height="100%" viewBox="0 0 280 694.58" enable-background="new 0 0 280 694.58" xml:space="preserve"><g id="Layer_16"><defs><filter id="OpacityMaskFilter" filterUnits="userSpaceOnUse" x="5.5" y="544.58" width="275" height="82">	<feColorMatrix  type="matrix" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 1 0"/></filter></defs>					<g id="Layer_19"></g><g id="Layer_17"></g><g id="Metal_buttons">	<path fill="#B7B7B7" stroke="#A8A8A8" stroke-miterlimit="10" d="M7.054,129.455c0,1.104-0.896,2-2,2H3.638c-1.104,0-2-0.896-2-2	v-15c0-1.104,0.896-2,2-2h1.417c1.104,0,2,0.896,2,2V129.455z"/><path fill="#B7B7B7" stroke="#A8A8A8" stroke-miterlimit="10" d="M7.054,177.08c0,1.104-0.896,2-2,2H3.638c-1.104,0-2-0.896-2-2		v-15c0-1.104,0.896-2,2-2h1.417c1.104,0,2,0.896,2,2V177.08z"/>	<path fill="#B7B7B7" stroke="#A8A8A8" stroke-miterlimit="10" d="M7.054,86.705c0,1.104-0.896,2-2,2H3.638c-1.104,0-2-0.896-2-2 v-22c0-1.104,0.896-2,2-2h1.417c1.104,0,2,0.896,2,2V86.705z"/>	<linearGradient id="SVGID_5_" gradientUnits="userSpaceOnUse" x1="199.7007" y1="-9.7534" x2="222.6996" y2="13.2455"><stop  offset="0" style="stop-color:#FFFFFF"/><stop offset="0.0955" style="stop-color:#E1E1E1"/><stop  offset="0.198" style="stop-color:#C8C8C8"/>		<stop  offset="0.3053" style="stop-color:#B6B6B6"/><stop  offset="0.4194" style="stop-color:#ABABAB"/><stop  offset="0.5517" style="stop-color:#A8A8A8"/><stop offset="0.5741" style="stop-color:#C0C0C0"/><stop  offset="0.6024" style="stop-color:#D7D7D7"/>		<stop  offset="0.6352" style="stop-color:#E9E9E9"/><stop  offset="0.6745" style="stop-color:#F6F6F6"/><stop  offset="0.727" style="stop-color:#FDFDFD"/><stop  offset="0.8473" style="stop-color:#FFFFFF"/><stop  offset="0.8478" style="stop-color:#FEFEFE"/><stop  offset="0.8587" style="stop-color:#E3E3E3"/><stop  offset="0.8711" style="stop-color:#CDCDCD"/><stop  offset="0.8858" style="stop-color:#BCBCBC"/><stop  offset="0.9039" style="stop-color:#B1B1B1"/><stop  offset="0.9294" style="stop-color:#AAAAAA"/>		<stop  offset="1" style="stop-color:#A8A8A8"/>	</linearGradient>	<linearGradient id="SVGID_6_" gradientUnits="userSpaceOnUse" x1="211.1997" y1="0.0801" x2="211.1997" y2="3.4106"><stop  offset="0.2414" style="stop-color:#FFFFFF"/><stop  offset="0.3019" style="stop-color:#FFFFFF"/><stop  offset="0.6552" style="stop-color:#FFFFFF"/><stop  offset="0.6563" style="stop-color:#FEFEFE"/>		<stop  offset="0.681" style="stop-color:#E3E3E3"/><stop  offset="0.709" style="stop-color:#CDCDCD"/><stop  offset="0.7421" style="stop-color:#BCBCBC"/><stop  offset="0.7831" style="stop-color:#B1B1B1"/><stop  offset="0.8405" style="stop-color:#AAAAAA"/>		<stop  offset="1" style="stop-color:#A8A8A8"/>	</linearGradient>	<rect x="189.367" y="0.58" fill="url(#SVGID_5_)" stroke="url(#SVGID_6_)" stroke-miterlimit="10" width="43.667" height="2.331"/>	<g id="Shadows_on_metal_buttons">	<rect x="1.2" y="122.969" fill="#6D6D6D" width="5.667" height="4.223"/>	<rect x="1.2" y="79.969" fill="#6D6D6D" width="5.667" height="4.223"/>	<rect x="1.2" y="170.969" fill="#6D6D6D" width="5.666" height="4.223"/></g><g id="Layer_20"></g><g id="Metal_body">	<path fill="#D8D8D8" stroke="#A8A8A8" stroke-miterlimit="10" d="M278.034,504.08c0,22.092-17.908,40-40,40h-194		c-22.091,0-40-17.908-40-40v-461c0-22.092,17.909-40,40-40h194c22.092,0,40,17.908,40,40V504.08z"/></g><g id="Shadows_on_metal_body">	<rect x="3.2" y="482.969" fill="#6D6D6D" width="5.667" height="4.223"/>	<rect x="273.2" y="482.969" fill="#6D6D6D" width="5.666" height="4.223"/></g><g id="Black_phone">	<linearGradient id="SVGID_7_" gradientUnits="userSpaceOnUse" x1="141.0942" y1="540.5801" x2="141.0942" y2="6.4111">		<stop  offset="0" style="stop-color:#282828"/>		<stop  offset="0.0097" style="stop-color:#262626"/>		<stop  offset="0.1219" style="stop-color:#161515"/>		<stop  offset="0.2609" style="stop-color:#0A0A0A"/>		<stop  offset="0.4566" style="stop-color:#040303"/>		<stop  offset="1" style="stop-color:#020101"/>	</linearGradient>	<path fill="url(#SVGID_7_)" stroke="#282828" stroke-width="2" stroke-miterlimit="10" d="M275.488,500.58		c0,22.092-17.908,40-40,40H46.7c-22.092,0-40-17.908-40-40V46.411c0-22.092,17.908-40,40-40h188.788c22.092,0,40,17.908,40,40		V500.58z"/></g><g id="Circle_Button_x2C__speaker">	<linearGradient id="SVGID_8_" gradientUnits="userSpaceOnUse" x1="141.2822" y1="520.5791" x2="141.2822" y2="468.7461">		<stop  offset="0" style="stop-color:#575858"/>		<stop  offset="1" style="stop-color:#282828"/>	</linearGradient>	<circle opacity="0.4" fill="url(#SVGID_8_)" stroke="#444444" stroke-miterlimit="10" cx="141.282" cy="494.662" r="25.917"/>	<path fill="none" stroke="#FFFFFF" stroke-miterlimit="10" d="M149.699,499.339c0,2.065-1.675,3.74-3.741,3.74h-9.352		c-2.066,0-3.741-1.675-3.741-3.74v-9.353c0-2.065,1.675-3.74,3.741-3.74h9.352c2.066,0,3.741,1.675,3.741,3.74V499.339z"/>	<path fill="#111111" d="M169.867,49.497c0,3.452-2.486,6.25-5.554,6.25h-40.726c-3.067,0-5.554-2.798-5.554-6.25l0,0		c0-3.452,2.487-6.25,5.554-6.25h40.726C167.381,43.247,169.867,46.045,169.867,49.497L169.867,49.497z"/>	<circle display="none" fill="#2D2D2D" cx="96.033" cy="64.164" r="6.083"/></g><g id="Camera">	<circle fill="#4F14A6" stroke="#353535" stroke-miterlimit="10" cx="96.033" cy="49.497" r="3.5"/>	<ellipse cx="96.033" cy="49.663" rx="1.125" ry="1"/></g><g id="Speaker_inset">	<linearGradient id="SVGID_9_" gradientUnits="userSpaceOnUse" x1="143.8101" y1="53.5381" x2="143.8101" y2="45.834">		<stop  offset="0" style="stop-color:#575858"/>		<stop  offset="1" style="stop-color:#282828"/>	</linearGradient>	<path fill="url(#SVGID_9_)" d="M167.42,49.686c0,2.127-1.725,3.852-3.852,3.852h-39.516c-2.127,0-3.852-1.725-3.852-3.852l0,0		c0-2.127,1.725-3.852,3.852-3.852h39.516C165.695,45.834,167.42,47.559,167.42,49.686L167.42,49.686z"/></g><g id="Screen">	<rect x="23.034" y="93.414" fill="#515151" stroke="#515151" stroke-miterlimit="10" width="236" height="353.333"/></g><g id="Light_reflection"></g><g id="Button_shadow">	<g>		<defs>			<path id="SVGID_10_" d="M166.782,494.501c0,14.403-11.678,26.078-26.083,26.078c-14.406,0-26.084-11.675-26.084-26.078				c0-14.408,11.679-26.087,26.084-26.087C155.104,468.414,166.782,480.093,166.782,494.501z"/>		</defs>		<clipPath id="SVGID_11_">			<use xlink:href="#SVGID_10_"  overflow="visible"/>		</clipPath>		<circle opacity="0.5" clip-path="url(#SVGID_11_)" cx="141.282" cy="452.747" r="42"/>	</g>	<g id="Layer_11">	</g>	<g id="Layer_18">	</g></g><g id="Grill">	<ellipse fill="#2E2E2F" cx="124.54" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="124.558" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="127.215" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="127.232" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="129.889" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="129.906" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="132.563" cy="48.754" rx="0.806" ry="0.683"/>	<ellipse fill="#090405" cx="132.58" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="135.237" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="135.254" cy="48.784" rx="0.737" ry="0.623"/><ellipse fill="#2E2E2F" cx="137.91" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="137.928" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="140.585" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="140.603" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="143.259" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="143.276" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="145.933" cy="48.754" rx="0.807" ry="0.683"/><ellipse fill="#090405" cx="145.95" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="148.606" cy="48.754" rx="0.806" ry="0.683"/>	<ellipse fill="#090405" cx="148.624" cy="48.784" rx="0.736" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="151.281" cy="48.754" rx="0.807" ry="0.683"/><ellipse fill="#090405" cx="151.298" cy="48.784" rx="0.737" ry="0.623"/><ellipse fill="#2E2E2F" cx="153.954" cy="48.754" rx="0.806" ry="0.683"/><ellipse fill="#090405" cx="153.972" cy="48.784" rx="0.737" ry="0.623"/><ellipse fill="#2E2E2F" cx="156.629" cy="48.754" rx="0.807" ry="0.683"/>	<ellipse fill="#090405" cx="156.646" cy="48.784" rx="0.737" ry="0.623"/><ellipse fill="#2E2E2F" cx="159.302" cy="48.754" rx="0.807" ry="0.683"/><ellipse fill="#090405" cx="159.32" cy="48.784" rx="0.737" ry="0.623"/>	<ellipse fill="#2E2E2F" cx="161.977" cy="48.754" rx="0.807" ry="0.683"/><ellipse fill="#090405" cx="161.994" cy="48.784" rx="0.737" ry="0.623"/><ellipse fill="#2E2E2F" cx="123.146" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="123.163" cy="50.48" rx="0.737" ry="0.624"/><ellipse fill="#2E2E2F" cx="125.819" cy="50.451" rx="0.807" ry="0.682"/>	<ellipse fill="#090405" cx="125.837" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="128.494" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="128.511" cy="50.48" rx="0.737" ry="0.624"/><ellipse fill="#2E2E2F" cx="131.167" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="131.185" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="133.841" cy="50.451" rx="0.807" ry="0.682"/>	<ellipse fill="#090405" cx="133.859" cy="50.48" rx="0.737" ry="0.624"/><ellipse fill="#2E2E2F" cx="136.515" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="136.533" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="139.189" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="139.207" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="141.864" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="141.881" cy="50.48" rx="0.737" ry="0.624"/><ellipse fill="#2E2E2F" cx="144.538" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="144.556" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="147.211" cy="50.451" rx="0.807" ry="0.682"/>	<ellipse fill="#090405" cx="147.229" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="149.885" cy="50.451" rx="0.806" ry="0.682"/>	<ellipse fill="#090405" cx="149.903" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="152.56" cy="50.451" rx="0.807" ry="0.682"/>	<ellipse fill="#090405" cx="152.577" cy="50.48" rx="0.737" ry="0.624"/>	<ellipse fill="#2E2E2F" cx="155.233" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="155.251" cy="50.48" rx="0.737" ry="0.624"/><ellipse fill="#2E2E2F" cx="157.907" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="157.925" cy="50.48" rx="0.737" ry="0.624"/><ellipse fill="#2E2E2F" cx="160.581" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="160.599" cy="50.48" rx="0.737" ry="0.624"/><ellipse fill="#2E2E2F" cx="163.255" cy="50.451" rx="0.807" ry="0.682"/><ellipse fill="#090405" cx="163.273" cy="50.48" rx="0.737" ry="0.624"/></g><g id="Light_reflection_1_"><linearGradient id="SVGID_12_" gradientUnits="userSpaceOnUse" x1="210.8569" y1="6.4106" x2="210.8569" y2="375.4839"><stop  offset="0" style="stop-color:#FFFFFF;stop-opacity:0.2"/><stop offset="0.1413" style="stop-color:#FFFFFF;stop-opacity:0.1859"/><stop  offset="1" style="stop-color:#FFFFFF;stop-opacity:0.1"/></linearGradient>	<path fill="url(#SVGID_12_)" d="M275.782,374.58c0,22.092-129.85-368.169-129.85-368.169h89.85c22.092,0,40,17.908,40,40V374.58z"/></g></svg>';*/
		
		
		/**
		 * Pencil Case
		 */
		$svg['pencil_case']['colors'] = array();
		$svg['pencil_case']['code'] = '<?xml version="1.0" encoding="iso-8859-1"?><svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['pencil_case']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 395.701 395.701" style="enable-background:new 0 0 395.701 395.701;" xml:space="preserve"><g><rect x="135.725" y="246.044" style="fill:#193651;" width="12.929" height="99.556"/><rect x="191.386" y="246.044" style="fill:#193651;" width="12.929" height="99.556"/><rect x="247.046" y="246.044" style="fill:#193651;" width="12.929" height="99.556"/></g><circle style="fill:#FDBF5E;" cx="197.851" cy="178.683" r="178.683"/><g><polygon style="fill:#FFFFFF;" points="153.309,85.915 153.309,83.459 126.739,45.77 100.17,83.459 100.17,85.915 	"/><polygon style="fill:#FFFFFF;" points="288.097,116.816 294.303,94.578 272.646,45.77 250.408,94.578 257.196,116.816 	"/><path style="fill:#FFFFFF;stroke:#193651;stroke-width:2;stroke-miterlimit:10;" d="M61.253,191.03L61.253,191.03 c0,12.347,9.891,22.238,22.238,22.238h228.137c12.347,0,22.238-9.891,22.238-22.238l0,0c0-12.347-9.891-22.238-22.238-22.238 H84.137C71.725,168.792,61.253,178.683,61.253,191.03z"/></g><circle class="colorful c1" style="fill:#FDBF5E;" cx="197.851" cy="178.683" r="178.683"/><rect class="colorful c3" x="100.17" y="85.915" style="fill:#2EA2DB;" width="53.139" height="76.671"/><g><polygon style="fill:#FFFFFF;" points="153.309,85.915 153.309,83.459 126.739,45.77 100.17,83.459 100.17,85.915 	"/><rect x="173.737" y="47.58" style="fill:#FFFFFF;" width="53.139" height="115.006"/><polygon style="fill:#FFFFFF;" points="288.097,116.816 294.303,94.578 272.646,45.77 250.408,94.578 257.196,116.816 	"/></g><rect class="colorful c2" x="249.762" y="116.816" style="fill:#F16051;" width="46.352" height="51.911"/><g><rect x="197.204" y="63.418" style="fill:#193651;" width="29.673" height="12.929"/><rect x="212.073" y="89.341" style="fill:#193651;" width="14.869" height="12.929"/><rect x="197.204" y="114.683" style="fill:#193651;" width="29.673" height="12.929"/><rect x="212.073" y="140.671" style="fill:#193651;" width="14.869" height="12.929"/></g><path style="fill:#FFFFFF;" d="M311.628,168.792H84.073c-12.347,0-22.885,9.891-22.885,22.238s9.891,22.238,22.238,22.238h5.883 v141.64c0,19.329,13.576,34.586,30.901,34.586h154.57c17.325,0,30.901-15.192,30.901-34.586v-141.64h5.883 c12.347,0,22.238-9.891,22.238-22.238S323.976,168.792,311.628,168.792z"/><path style="fill:#193651;" d="M340.655,191.03c0-15.451-12.994-28.444-28.444-28.444H84.137c-15.451,0-28.444,12.994-28.444,28.444 s12.347,28.444,27.798,28.444v139.119c0,20.428,16.679,37.107,37.107,37.107h154.57c20.428,0,37.107-16.679,37.107-37.107V219.475 C327.661,219.475,340.655,206.481,340.655,191.03z M299.863,358.529c0,13.576-11.119,24.76-24.76,24.76H120.598 c-13.576,0-24.76-11.119-24.76-24.76V221.285h204.024V358.529z M311.628,207.063H84.137c-8.663,0-16.097-7.434-16.097-16.097 s7.434-16.097,16.097-16.097h228.137c8.663,0,16.097,7.434,16.097,16.097C328.307,199.693,320.873,207.063,311.628,207.063z"/><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g></svg>'; 
		
		
		/**
		 * Cake 1
		 */
		$svg['cake_1']['colors'] = array('#F088B6');
		$svg['cake_1']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['cake_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"width="100%" height="100%" viewBox="0 0 176.923 200" enable-background="new 0 0 176.923 200" xml:space="preserve"><g><path fill="#A07843" d="M38.67,191.864L6.09,108.432c0,0,8.923-66.129,82.309-66.129s82.309,66.129,82.309,66.129l-32.158,83.433H38.67z"/><g><path fill="#AECC53" d="M140.023,194.228c5.866-4.192,33.381-54.9,33.381-87.155c-4.865,1.371-9.129,9.105-15.471,10.133c-5.314,0.863-11.953-5.038-18.033-4.416c-5.518,0.566-10.748,7.716-16.699,8.082c-5.635,0.35-11.729-6.088-17.592-5.916c-5.721,0.17-11.414,6.957-17.206,6.957s-11.485-6.787-17.206-6.957c-5.864-0.171-11.958,6.267-17.594,5.918c-5.952-0.368-11.184-7.517-16.699-8.082c-6.083-0.624-12.721,5.277-18.039,4.416c-6.34-1.029-10.605-8.764-15.473-10.135c0,32.255,27.515,82.963,33.382,87.155c0,0,13.176,4.188,51.624,4.188C126.846,198.416,140.023,194.228,140.023,194.228z"/><path fill="#95C11F" d="M3.393,107.072c0,32.255,27.515,82.963,33.382,87.155c0,0,2.331,0.741,7.889,1.6l-25.799-78.62C12.526,116.178,8.261,108.443,3.393,107.072z M36.905,112.791l20.72,84.515c2.586,0.214,5.445,0.407,8.595,0.573l-12.616-77.006C47.652,120.505,42.42,113.356,36.905,112.791z M105.609,114.955l-4.279,83.291c2.85-0.078,5.516-0.182,8.008-0.304l13.863-77.071C117.566,121.221,111.473,114.783,105.609,114.955z M139.9,112.789l-17.088,84.188c3.014-0.294,5.582-0.61,7.74-0.916l27.381-78.856C152.619,118.068,145.98,112.167,139.9,112.789z M79.063,198.33c2.545,0.049,5.222,0.078,8.041,0.086l1.299-76.504c-5.792,0-11.485-6.787-17.206-6.957L79.063,198.33z"/></g><g><path class="colorful c1" fill="'.$svg['cake_1']['colors'][0].'" d="M153.211,59.562c-0.314,0-0.627,0.009-0.936,0.024c-4.514-32.636-32.515-57.768-66.391-57.768c-32.727,0-59.971,23.456-65.852,54.473c-8.961,3.944-15.22,12.896-15.22,23.315c0,14.065,11.401,25.467,25.466,25.467c8.64,0,16.27-4.307,20.874-10.887c3.044,7.472,10.377,12.739,18.941,12.739c7.18,0,13.491-3.703,17.141-9.3c1.959,4.323,6.307,7.333,11.364,7.333c5.078,0,9.444-3.039,11.39-7.394c3.155,3.739,7.876,6.117,13.152,6.117c6.718,0,12.532-3.851,15.366-9.464c3.718,3.85,8.932,6.246,14.705,6.246c11.295,0,20.452-9.155,20.452-20.451C173.663,68.719,164.506,59.562,153.211,59.562z"/><path fill="#951B81" d="M62.868,93.813h17.796v-4.862H62.868V93.813z M80.664,12.169h-4.86v17.797h4.86V12.169z M21.666,84.407l3.437,3.437l12.585-12.585l-3.438-3.437L21.666,84.407z M37.688,40.689l12.584,12.583l3.437-3.437L41.125,37.251L37.688,40.689zM116.336,43.742l4.209,2.43l8.898-15.411l-4.209-2.432L116.336,43.742z M77.907,56.439l1.259,4.697l17.19-4.607l-1.258-4.695L77.907,56.439z M153.029,72.936l-4.605,17.189l4.695,1.257l4.605-17.189L153.029,72.936z M105.046,77.489l15.413,8.897l2.432-4.209l-15.413-8.898L105.046,77.489z"/></g></g></svg>';
		
		
		
		
		/**
		 * Cake 2
		 */
		$svg['cake_2']['colors'] = array('#70C8DF','#23B9D6');
		$svg['cake_2']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['cake_2']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"width="100%" height="100%" viewBox="0 0 153.847 200" enable-background="new 0 0 153.847 200" xml:space="preserve"><g><path fill="#FECE61" d="M33.049,193.024L4.432,119.739c0,0,7.837-58.086,72.299-58.086c64.46,0,72.298,58.086,72.298,58.086l-28.248,73.285H33.049z"/><g><path fill="#951B81" d="M122.076,195.1c5.153-3.682,29.322-48.223,29.322-76.555c-4.276,1.204-8.021,7.998-13.59,8.9c-4.669,0.759-10.501-4.426-15.842-3.879c-4.845,0.497-9.439,6.777-14.667,7.1c-4.949,0.307-10.303-5.348-15.453-5.197c-5.023,0.149-10.024,6.111-15.112,6.111c-5.088,0-10.09-5.962-15.113-6.111c-5.152-0.15-10.505,5.505-15.455,5.199c-5.228-0.324-9.824-6.604-14.669-7.1c-5.341-0.549-11.174,4.636-15.844,3.879c-5.57-0.904-9.316-7.698-13.592-8.902c0,28.332,24.169,72.873,29.322,76.555c0,0,11.575,3.68,45.347,3.68C110.501,198.779,122.076,195.1,122.076,195.1z"/><path fill="#9F368C" d="M2.062,118.545c0,28.332,24.169,72.873,29.322,76.555c0,0,2.048,0.65,6.931,1.406l-22.661-69.059C10.083,126.543,6.338,119.749,2.062,118.545z M31.498,123.568l18.2,74.236c2.271,0.188,4.782,0.357,7.551,0.504l-11.083-67.641C40.939,130.344,36.343,124.064,31.498,123.568z M91.847,125.469l-3.758,73.162c2.504-0.069,4.844-0.16,7.032-0.268l12.179-67.697C102.351,130.973,96.997,125.318,91.847,125.469z M121.967,123.566l-15.01,73.949c2.649-0.259,4.904-0.535,6.8-0.805l24.052-69.266C133.14,128.204,127.308,123.02,121.967,123.566z M68.53,198.703c2.235,0.043,4.587,0.07,7.062,0.076l1.143-67.199c-5.088,0-10.09-5.962-15.113-6.111L68.53,198.703z"/></g><g><g><path class="colorful c2" fill="'.$svg['cake_2']['colors'][1].'" d="M130.126,73.83c3.566-8.823,1.195-18.871-14.295-24.647c7.682-14.01-14.375-15.173-22.965-22.458c-7.705-6.536-12.959-13.541-10.932-25.449C58.433,5.343,38.096,37.883,43.519,50.537c-10.05,0.61-17.823,11.48-14.502,20.995C15.28,76.299,8.939,83.432,8.939,91.407c0,14.351,20.534,25.985,67.792,25.985c47.257,0,67.792-11.635,67.792-25.985C144.522,84.627,139.937,78.458,130.126,73.83z"/><g><path class="colorful c1" fill="'.$svg['cake_2']['colors'][0].'" d="M72.688,10.648c-6.915,12.099,12.099,27.902,6.913,38.026C90.218,39.538,71.382,17.562,72.688,10.648z"/><path class="colorful c1" fill="'.$svg['cake_2']['colors'][0].'" d="M63.798,18.55c-9.877,19.012,12.099,27.9,6.914,38.025C81.329,47.44,61.213,33.672,63.798,18.55z"/><path class="colorful c1" fill="'.$svg['cake_2']['colors'][0].'" d="M120.589,65.419c-0.988,8.934-15.062,17.329-45.186,16.094C105.28,90.403,127.75,76.733,120.589,65.419z"/><path class="colorful c1" fill="'.$svg['cake_2']['colors'][0].'" d="M133.181,84.372c11.342,7.036-12.344,29.242-67.655,24.798C108.455,106.7,133.675,95.625,133.181,84.372z"/></g></g><path fill="#83644C" d="M63.279,92.965l-2.724,6.564l-6.563,2.724l6.563,2.726l2.724,6.562l2.725-6.562l6.563-2.726l-6.563-2.724L63.279,92.965z M61.213,64.057l-5.635-4.33l-0.933-7.045l-4.331,5.634L43.27,59.25l5.634,4.33l0.933,7.044l4.331-5.635L61.213,64.057z M27.457,79.771l-3.286,6.3l-6.776,2.143l6.301,3.286l2.142,6.774l3.286-6.301l6.775-2.141l-6.3-3.287L27.457,79.771z M96.261,35.184l-0.933,7.045l-5.634,4.331l7.045,0.933l4.33,5.633l0.934-7.043l5.633-4.33l-7.044-0.934L96.261,35.184z M86.655,59.334l-1.543,6.938l-5.99,3.822l6.938,1.544l3.821,5.99l1.543-6.937l5.991-3.822l-6.938-1.544L86.655,59.334z M120.63,89.946l-4.331-5.635l-0.933,7.044l-5.634,4.331l7.044,0.932l4.331,5.634l0.933-7.044l5.635-4.329L120.63,89.946z"/></g></g></svg>';
		
		
		
		/**
		 * Bananas
		 */
		$svg['bananas']['colors'] = array();
		$svg['bananas']['code'] = '<svg id="bananas-svg"'.$this->svg_color_data($svg['bananas']['colors']).' class="bananas" viewBox="950 216 126 112" width="100%" height="100%" ><g id="bananas"><path d="M 962 270 L 1030 303 L 1058 277 L 1039 260 L 962 270 Z" fill="#54290e"></path>		<path d="M 1059.7518 253 C 1059.7518 253 1094.0784 278.8579 1062.9449 309.9932 C 1031.8114 341.1289 986 322.8472 986 321 C 986 319.1528 1017.7083 313.4238 1031.8114 309.9932 C 1045.9146 306.563 1064.0094 297.5923 1063.7432 278.3306 C 1063.4769 259.0688 1056.5585 253 1056.5585 253 L 1059.7518 253 Z" fill="#54290e"></path><path d="M 1045.0865 223.8804 C 1045.0865 223.8804 1065.2529 269.002 1009.0861 280.3711 C 953.0947 291.7041 948.8944 243.5415 950.1807 241.7827 C 951.4666 240.0244 957.0479 256.7417 974.8516 261.8184 C 992.7134 266.9121 1018.8951 269.0767 1031.9741 250.437 C 1045.0087 231.8604 1041.5651 222.0049 1041.5651 222.0049 L 1045.0865 223.8804 Z" fill="#ffd545"></path><path d="M 1042.9208 222.3789 C 1042.9208 222.3789 1041.3035 257.0254 1012.6172 265.335 C 983.9585 273.6367 964.7408 258.9785 959.1488 253.3091 C 953.5681 247.6509 952.0226 243.1299 952.0226 243.1299 L 951.9395 239.9307 C 951.9395 239.9307 964.5732 257.376 1000.8263 256.8594 C 1030.0785 256.4419 1040.2207 219.374 1042.9208 222.3789 Z" fill="#eab916"></path><path d="M 952.929 239.2466 L 954.7722 243.8569 L 952.0959 245.0757 L 949.6526 241.0591 L 952.929 239.2466 Z" fill="#4b4304"></path>	<path d="M 1044.9116 219.5522 C 1044.9116 219.5522 1097.9142 259.6128 1049.842 307.8491 C 1001.7699 356.0854 961.9154 302.9438 961.9154 300.082 C 961.9154 297.2202 979.9938 313.1636 1001.7699 307.8491 C 1023.5461 302.5347 1051.4856 288.6367 1051.0747 258.7954 C 1050.6637 228.9541 1039.9811 219.5522 1039.9811 219.5522 L 1044.9116 219.5522 Z" fill="#ffd545"></path><path d="M 1041.6246 219.1431 C 1041.6246 219.1431 1065.2498 260.6348 1042.4464 288.2275 C 1019.6429 315.8203 989.4437 310.915 979.5829 307.8491 C 969.7219 304.7832 964.7914 300.4912 964.7914 300.4912 L 962.3262 296.812 C 962.3262 296.812 988.0903 309.1592 1024.368 285.7749 C 1053.5399 266.9707 1036.6942 217.3037 1041.6246 219.1431 Z" fill="#eab916"></path><path d="M 1040.2137 222.231 L 1045.1442 219.7783 C 1045.1442 219.7783 1040.6246 215.2822 1040.2137 216.0996 C 1039.8029 216.917 1040.2137 222.231 1040.2137 222.231 Z" fill="#4b4304"></path><path d="M 963.5588 296.812 L 967.2566 300.4912 L 964.7914 302.9438 L 961.0935 299.2646 L 963.5588 296.812 Z" fill="#4b4304"></path></g></svg>';
		
		
		
		/**
		 * Beer
		 */
		$svg['beer']['colors'] = array('#FECE56');
		$svg['beer']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['beer']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 56.41 65.202" enable-background="new 0 0 56.41 65.202" xml:space="preserve"><g id="_x32__2_"> <rect x="8.546" y="17.015" fill="#FFE2A1" width="30.681" height="46.023"/> <rect x="8.546" y="22.129" class="colorful c1" fill="'.$svg['beer']['colors'][0].'" width="30.681" height="40.909"/> <path fill="#FEF7E9" d="M41.911,11.903c0-3.567-2.893-6.457-6.456-6.457c-0.547,0-1.07,0.089-1.578,0.218 c-0.918-0.882-2.16-1.433-3.537-1.433c-0.989,0-1.903,0.294-2.687,0.781C26.271,3,23.955,1.676,21.33,1.676 c-4.238,0-7.671,3.434-7.671,7.67V9.35c-0.861-1.823-2.7-3.09-4.849-3.09c-2.972,0-5.378,2.407-5.378,5.38 c0,2.883,2.276,5.221,5.134,5.353l-0.02,0.023h30.681v0.093c0.022-0.017,0.049-0.028,0.072-0.045l0.082-0.044l-0.014-0.01 C40.906,15.828,41.911,13.989,41.911,11.903z"/> <g> <path opacity="0.8" fill="#F8F4E7" d="M39.227,46.675v-4.092c5.92,0,10.738-4.814,10.738-10.736c0-5.92-5.924-10.74-11.845-10.74 l1.106-4.091c8.176,0,14.83,6.653,14.83,14.832C54.057,40.021,47.402,46.675,39.227,46.675z"/> </g></g></svg>';



		/**
		 * Burger
		 */
		$svg['burger']['colors'] = array();
		$svg['burger']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['burger']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 59.707 51.282" enable-background="new 0 0 59.707 51.282" xml:space="preserve"><g id="_x36_"> <g id="_x31_6"> <path fill="#FECE56" d="M2.042,30.569c0,1.731,1.404,3.136,3.135,3.136h19.786l-10.231-6.129H4.236 C2.965,27.978,2.042,29.166,2.042,30.569z"/> <path fill="#FECE56" d="M57.534,30.569c0-1.403-0.924-2.592-2.194-2.993H44.854l-10.228,6.129h19.771 C56.13,33.705,57.534,32.301,57.534,30.569z"/> <path fill="#CC7C31" d="M55.274,39.547c-0.541-0.033-1.106-0.13-1.684-0.305c-2.584-0.793-3.234-0.678-4.365,0.773 c-1.045,1.342-2.778,2.102-4.418,1.942c-1.756-0.173-2.612-0.627-4.146-1.815l-0.107-0.077c-1.082-0.845-1.801-1.401-3.537-1.21 c-0.013,0.001-1.46,0.108-3.122,1.628c-0.909,0.833-2.318,1.937-4.052,1.941c-1.73-0.005-3.139-1.108-4.05-1.941 c-1.662-1.52-3.108-1.627-3.163-1.632c-1.695-0.188-2.412,0.369-3.494,1.207l-0.108,0.084c-1.532,1.188-2.39,1.643-4.147,1.815 c-1.64,0.159-3.373-0.601-4.416-1.942c-1.134-1.451-1.786-1.566-4.371-0.773c-0.613,0.187-1.209,0.283-1.779,0.31v5.274 c0,0-0.312,4.945,5.586,4.945h39.785c5.898,0,5.588-4.945,5.588-4.945V39.547z"/> <path fill="#CC7C31" d="M2.579,17.112c0,1.926,0.71,2.97,1.322,3.511h51.815c0.605-0.535,1.292-1.57,1.292-3.511 c0-4.053-6.255-14.591-27.214-14.591S2.579,13.06,2.579,17.112z"/> <polygon fill="#A45317" points="4.007,38.316 55.58,38.316 55.58,33.151 32.544,33.151 29.793,34.798 27.041,33.151 4.007,33.151  "/> <path fill="#FECE56" d="M45.352,27.576H14.951c4.786,3.192,14.54,8.767,15.203,9.207C30.815,36.343,40.569,30.769,45.352,27.576z" /> <path fill="#A45317" d="M49.226,23.494c-1.045,1.591-2.778,2.494-4.418,2.305c-1.756-0.207-2.612-0.745-4.146-2.153l-0.107-0.098 c-1.082-1.001-1.801-1.661-3.537-1.429c-0.013,0-1.46,0.132-3.122,1.932c-0.909,0.986-2.318,2.296-4.052,2.304 c-1.73-0.008-3.139-1.318-4.05-2.304c-1.662-1.8-3.108-1.932-3.163-1.939c-1.695-0.225-2.412,0.435-3.494,1.436l-0.108,0.098 c-1.532,1.409-2.39,1.947-4.147,2.153c-1.64,0.189-3.373-0.714-4.416-2.305c-1.134-1.724-1.786-1.858-4.371-0.92 c-0.724,0.264-1.428,0.386-2.087,0.384v4.973H55.58v-4.973c-0.628-0.009-1.3-0.134-1.989-0.384 C51.007,21.636,50.356,21.771,49.226,23.494z"/> <path fill="#ED6D55" d="M55.921,20.204c-0.371,0-51.782,0-52.152,0c-0.604,0.343-1.817,1.23-1.922,2.305 c-0.007,0.056-0.013,0.113-0.013,0.168c0,0.398,0.159,0.728,0.466,0.981c0.697,0.572,1.99,0.664,3.37,0.244 c2.483-0.761,4.124-1.056,5.936,1.267c0.905,1.167,2.256,1.478,3.134,1.39c1.344-0.133,1.981-0.414,3.401-1.515l0.105-0.083 c1.163-0.905,2.262-1.758,4.497-1.507c0.081,0.002,1.951,0.109,4.027,2.005c0.73,0.669,1.848,1.559,3.072,1.561 c1.228-0.002,2.342-0.892,3.076-1.561c2.074-1.896,3.946-2.003,3.979-2.003c2.283-0.253,3.382,0.6,4.545,1.505l0.105,0.083 c1.418,1.101,2.055,1.382,3.4,1.515c0.879,0.088,2.227-0.223,3.137-1.39c1.807-2.323,3.447-2.028,5.934-1.267 c1.381,0.42,2.672,0.329,3.371-0.244c0.309-0.254,0.463-0.583,0.463-0.981c0-0.055-0.004-0.112-0.012-0.168 C57.735,21.435,56.522,20.547,55.921,20.204z"/> <path fill="#8DC052" d="M55.921,37.896c-0.371,0-51.782,0-52.152,0c-0.604,0.338-1.817,1.23-1.922,2.303 c-0.007,0.058-0.013,0.115-0.013,0.168c0,0.399,0.159,0.729,0.466,0.981c0.697,0.573,1.99,0.668,3.37,0.243 c2.483-0.759,4.124-1.055,5.936,1.27c0.905,1.166,2.256,1.477,3.134,1.391c1.344-0.134,1.981-0.417,3.401-1.517l0.105-0.083 c1.163-0.904,2.262-1.758,4.497-1.508c0.081,0.006,1.951,0.111,4.027,2.008c0.73,0.669,1.848,1.561,3.072,1.563 c1.228-0.003,2.342-0.895,3.076-1.563c2.074-1.896,3.946-2.002,3.979-2.002c2.283-0.256,3.382,0.598,4.545,1.502l0.105,0.083 c1.418,1.1,2.055,1.383,3.4,1.517c0.879,0.086,2.227-0.225,3.137-1.391c1.807-2.324,3.447-2.028,5.934-1.27 c1.381,0.425,2.672,0.33,3.371-0.243c0.309-0.253,0.463-0.582,0.463-0.981c0-0.053-0.004-0.11-0.012-0.168 C57.735,39.126,56.522,38.233,55.921,37.896z"/> </g> <g>  <ellipse transform="matrix(0.2018 -0.9794 0.9794 0.2018 10.4705 44.9593)" fill="#FECE56" cx="32.818" cy="16.056" rx="0.886" ry="0.922"/>  <ellipse transform="matrix(0.2017 -0.9795 0.9795 0.2017 19.0779 56.3834)" fill="#FECE56" cx="44.127" cy="16.489" rx="0.886" ry="0.923"/>  <ellipse transform="matrix(0.2022 -0.9793 0.9793 0.2022 18.3401 47.2201)" fill="#FECE56" cx="38.153" cy="12.353" rx="0.886" ry="0.921"/>  <ellipse transform="matrix(0.2011 -0.9796 0.9796 0.2011 17.4789 37.8776)" fill="#FECE56" cx="31.962" cy="8.222" rx="0.886" ry="0.923"/>  <ellipse transform="matrix(0.2016 -0.9795 0.9795 0.2016 3.5704 40.3507)" fill="#FECE56" cx="26.535" cy="17.985" rx="0.885" ry="0.922"/>  <ellipse transform="matrix(0.201 -0.9796 0.9796 0.201 7.1657 30.9394)" fill="#FECE56" cx="22.55" cy="11.077" rx="0.887" ry="0.922"/>  <ellipse transform="matrix(0.2016 -0.9795 0.9795 0.2016 27.0967 59.9947)" fill="#FECE56" cx="50.35" cy="13.376" rx="0.886" ry="0.922"/>  <ellipse transform="matrix(0.2017 -0.9795 0.9795 0.2017 23.763 40.7302)" fill="#FECE56" cx="36.867" cy="5.788" rx="0.886" ry="0.924"/>  <ellipse transform="matrix(0.2019 -0.9794 0.9794 0.2019 18.7449 31.0342)" fill="#FECE56" cx="28.414" cy="4.016" rx="0.886" ry="0.924"/>  <ellipse transform="matrix(0.2013 -0.9795 0.9795 0.2013 8.5468 25.4066)" fill="#FECE56" cx="19.852" cy="7.463" rx="0.886" ry="0.923"/>  <ellipse transform="matrix(0.2016 -0.9795 0.9795 0.2016 -0.1104 29.9915)" fill="#FECE56" cx="18.342" cy="15.063" rx="0.886" ry="0.924"/>  <ellipse transform="matrix(0.2022 -0.9793 0.9793 0.2022 -5.567 24.0358)" fill="#FECE56" cx="11.969" cy="15.435" rx="0.886" ry="0.923"/>  <ellipse transform="matrix(0.2016 -0.9795 0.9795 0.2016 28.8385 51.3087)" fill="#FECE56" cx="45.891" cy="7.966" rx="0.887" ry="0.923"/>  <ellipse transform="matrix(0.202 -0.9794 0.9794 0.202 1.7792 21.1924)" fill="#FECE56" cx="13.894" cy="9.504" rx="0.886" ry="0.922"/> </g></g></svg>';

		
		/**
		 * Fries 
		 */ 
		$svg['fries']['colors'] = array('#ED6D55');
		$svg['fries']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['fries']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 51.283 67.033" enable-background="new 0 0 51.283 67.033" xml:space="preserve"><g id="_x39_"> <g> <path fill="#F6BB41" d="M17.256,12.888l2.735,20.122c1.325,0.177,2.719,0.314,4.173,0.396L21.49,12.398L17.256,12.888z"/> <path fill="#F6BB41" d="M16.084,32.357c0.83,0.172,1.698,0.327,2.602,0.465l-1.133-8.019L16.084,32.357z"/> <polygon fill="#F6BB41" points="28.763,14.912 24.502,14.752 24.085,21.898 25.441,33.442 28.551,18.528 "/> <path fill="#F6BB41" d="M31.278,13.885l-3.23,13.264l-1.323,6.341c0.191,0.003,0.383,0.007,0.577,0.007 c1.283,0,2.521-0.047,3.721-0.127l4.405-18.498L31.278,13.885z"/> <path fill="#F6BB41" d="M32.561,33.242c1.49-0.14,2.909-0.333,4.244-0.562l-2.328-7.581L32.561,33.242z"/> <path fill="#F6BB41" d="M35.069,22.753l2.849,9.699c1.51-0.273,2.358-0.466,3.627-0.796l-5.155-14.758L35.069,22.753z"/> <path fill="#F6BB41" d="M46.125,17.404l-3.399,9.391l-0.712,2.34l0.75,2.18l0.048-0.005c1.21-0.352,2.277-0.702,3.186-1.026 l4.134-11.429L46.125,17.404z"/> <path fill="#F6BB41" d="M13.197,20.364l-2.304,10.677c1.168,0.357,2.492,0.719,3.954,1.05l2.123-10.912L13.197,20.364z"/> <path fill="#F6BB41" d="M4.075,17.121l3.561,12.8C7.995,30.059,9.439,30.6,9.439,30.6l1.246-5.618l-2.504-9.003L4.075,17.121z"/> <polygon fill="#F6BB41" points="38.66,13.691 38.253,18.221 41.311,27.096 41.921,25.091 42.901,14.073 "/> </g> <g> <path fill="#FECE56" d="M16.372,12.888l2.735,20.122c1.325,0.177,2.719,0.314,4.173,0.396l-2.674-21.007L16.372,12.888z"/> <path fill="#FECE56" d="M15.199,32.357c0.832,0.172,1.698,0.327,2.603,0.465l-1.133-8.019L15.199,32.357z"/> <polygon fill="#FECE56" points="27.879,14.912 23.619,14.752 23.201,21.898 24.558,33.442 27.668,18.528 "/> <path fill="#FECE56" d="M30.395,13.885l-3.232,13.264l-1.322,6.341c0.191,0.003,0.384,0.007,0.578,0.007 c1.283,0,2.52-0.047,3.721-0.127l4.404-18.498L30.395,13.885z"/> <path fill="#FECE56" d="M31.676,33.242c1.492-0.14,2.91-0.333,4.244-0.562l-2.328-7.581L31.676,33.242z"/> <path fill="#FECE56" d="M34.185,22.753l2.849,9.699c1.51-0.273,2.358-0.466,3.627-0.796l-5.155-14.758L34.185,22.753z"/> <path fill="#FECE56" d="M45.241,17.404l-3.398,9.391l-0.713,2.34l0.751,2.18l0.048-0.005c1.21-0.352,2.277-0.702,3.186-1.026 l4.133-11.429L45.241,17.404z"/> <path fill="#FECE56" d="M12.313,20.364l-2.304,10.677c1.168,0.357,2.493,0.719,3.954,1.05l2.123-10.912L12.313,20.364z"/> <path fill="#FECE56" d="M3.191,17.121l3.561,12.8c0.36,0.138,1.805,0.679,1.805,0.679l1.245-5.618l-2.504-9.003L3.191,17.121z"/> <polygon fill="#FECE56" points="37.776,13.691 37.37,18.221 40.426,27.096 41.038,25.091 42.018,14.073 "/> </g> <path class="colorful c1" fill="'.$svg['fries']['colors'][0].'" d="M2.729,27.732L8.666,64.16h34.411l5.937-36.112c-0.901,0.44-9.948,4.733-22.595,4.733 C13.771,32.781,3.63,28.175,2.729,27.732z"/></g></svg>';
		
		
		
		
		
		/**
		 * Cloud
		 */
		$svg['cloud_1']['colors'] = array('#EEEEEE');
		$svg['cloud_1']['code'] = '<svg class="clouds cloud1"'.$this->svg_color_data($svg['cloud_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0" y="0" width="100%" height="100%" viewBox="0 0 512 512" enable-background="new 0 0 512 512" xml:space="preserve"><path class="colorful c1" fill="'.$svg['cloud_1']['colors'][0].'" d="M406.1 227.63c-8.23-103.65-144.71-137.8-200.49-49.05 -36.18-20.46-82.33 3.61-85.22 45.9C80.73 229.34 50 263.12 50 304.1c0 44.32 35.93 80.25 80.25 80.25h251.51c44.32 0 80.25-35.93 80.25-80.25C462 268.28 438.52 237.94 406.1 227.63z"/></svg>';
		
		
		
		
		/**
		 * Loader 1
		 */
		$svg['loader_1']['colors'] = array('#000000');
		$svg['loader_1']['code'] = '<svg version="1.1" id="loader-1"'.$this->svg_color_data($svg['loader_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 40 40" enable-background="new 0 0 40 40" xml:space="preserve"><path opacity="0.2" class="colorful c1" fill="'.$svg['loader_1']['colors'][0].'" d="M20.201,5.169c-8.254,0-14.946,6.692-14.946,14.946c0,8.255,6.692,14.946,14.946,14.946    s14.946-6.691,14.946-14.946C35.146,11.861,28.455,5.169,20.201,5.169z M20.201,31.749c-6.425,0-11.634-5.208-11.634-11.634    c0-6.425,5.209-11.634,11.634-11.634c6.425,0,11.633,5.209,11.633,11.634C31.834,26.541,26.626,31.749,20.201,31.749z"/><path class="colorful c1" fill="'.$svg['loader_1']['colors'][0].'" d="M26.013,10.047l1.654-2.866c-2.198-1.272-4.743-2.012-7.466-2.012h0v3.312h0 C22.32,8.481,24.301,9.057,26.013,10.047z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 20 20" to="360 20 20" dur="0.5s" repeatCount="indefinite"/></path></svg>';
		
		
		/**
		 * Loader 2
		 */
		$svg['loader_2']['colors'] = array('#000000');
		$svg['loader_2']['code'] = '<svg version="1.1" id="loader-1"'.$this->svg_color_data($svg['loader_2']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 50 50" style="enable-background:new 0 0 50 50;" xml:space="preserve"><path class="colorful c1" fill="'.$svg['loader_2']['colors'][0].'" d="M25.251,6.461c-10.318,0-18.683,8.365-18.683,18.683h4.068c0-8.071,6.543-14.615,14.615-14.615V6.461z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 25 25" to="360 25 25" dur="0.6s" repeatCount="indefinite"/></path></svg>';
		
		
		
		
		
		/**
		 * Loader 3
		 */
		$svg['loader_3']['colors'] = array('#000000');
		$svg['loader_3']['code'] = '<svg version="1.1" id="loader-1"'.$this->svg_color_data($svg['loader_3']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 50 50" style="enable-background:new 0 0 50 50;" xml:space="preserve"><path class="colorful c1" fill="'.$svg['loader_3']['colors'][0].'" d="M43.935,25.145c0-10.318-8.364-18.683-18.683-18.683c-10.318,0-18.683,8.365-18.683,18.683h4.068c0-8.071,6.543-14.615,14.615-14.615c8.072,0,14.615,6.543,14.615,14.615H43.935z"><animateTransform attributeType="xml" attributeName="transform" type="rotate" from="0 25 25" to="360 25 25" dur="0.6s" repeatCount="indefinite"/></path></svg>';
		
		
		
		/**
		 * Loader 4
		 */
		$svg['loader_4']['colors'] = array('#333333');
		$svg['loader_4']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['loader_4']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 24 24" style="enable-background:new 0 0 50 50;" xml:space="preserve"><rect x="0" y="0" width="4" height="7" class="colorful c1" fill="'.$svg['loader_4']['colors'][0].'"><animateTransform attributeType="xml" attributeName="transform" type="scale" values="1,1; 1,3; 1,1" begin="0s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="10" y="0" width="4" height="7" class="colorful c1" fill="'.$svg['loader_4']['colors'][0].'"><animateTransform  attributeType="xml" attributeName="transform" type="scale" values="1,1; 1,3; 1,1" begin="0.2s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="20" y="0" width="4" height="7" class="colorful c1" fill="'.$svg['loader_4']['colors'][0].'"><animateTransform  attributeType="xml" attributeName="transform" type="scale" values="1,1; 1,3; 1,1" begin="0.4s" dur="0.6s" repeatCount="indefinite" /></rect></svg>';
		
		
		
		
		/**
		 * Loader 5
		 */
		$svg['loader_5']['colors'] = array('#333333');
		$svg['loader_5']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['loader_5']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve"><rect x="0" y="0" width="4" height="10" class="colorful c1" fill="'.$svg['loader_5']['colors'][0].'"><animateTransform attributeType="xml" attributeName="transform" type="translate" values="0 0; 0 20; 0 0" begin="0" dur="0.6s" repeatCount="indefinite" /></rect><rect x="10" y="0" width="4" height="10" class="colorful c1" fill="'.$svg['loader_5']['colors'][0].'"><animateTransform attributeType="xml" attributeName="transform" type="translate" values="0 0; 0 20; 0 0" begin="0.2s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="20" y="0" width="4" height="10" class="colorful c1" fill="'.$svg['loader_5']['colors'][0].'"><animateTransform attributeType="xml" attributeName="transform" type="translate" values="0 0; 0 20; 0 0" begin="0.4s" dur="0.6s" repeatCount="indefinite" /></rect></svg>';
		
		
		
		/**
		 * Loader 6
		 */
		$svg['loader_6']['colors'] = array('#333333');
		$svg['loader_6']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['loader_6']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve"><rect x="0" y="13" width="4" height="5" class="colorful c1" fill="'.$svg['loader_6']['colors'][0].'"><animate attributeName="height" attributeType="XML" values="5;21;5" begin="0s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="y" attributeType="XML" values="13; 5; 13" begin="0s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="10" y="13" width="4" height="5" class="colorful c1" fill="'.$svg['loader_6']['colors'][0].'"><animate attributeName="height" attributeType="XML" values="5;21;5" begin="0.15s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="y" attributeType="XML" values="13; 5; 13" begin="0.15s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="20" y="13" width="4" height="5" class="colorful c1" fill="'.$svg['loader_6']['colors'][0].'"><animate attributeName="height" attributeType="XML" values="5;21;5" begin="0.3s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="y" attributeType="XML" values="13; 5; 13" begin="0.3s" dur="0.6s" repeatCount="indefinite" /></rect></svg>';
		
		
		
		/**
		 * Loader 7
		 */
		$svg['loader_7']['colors'] = array('#333333');
		$svg['loader_7']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['loader_7']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve"><rect x="0" y="0" width="4" height="20" class="colorful c1" fill="'.$svg['loader_7']['colors'][0].'"><animate attributeName="opacity" attributeType="XML" values="1; .2; 1" begin="0s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="7" y="0" width="4" height="20" class="colorful c1" fill="'.$svg['loader_7']['colors'][0].'"><animate attributeName="opacity" attributeType="XML" values="1; .2; 1" begin="0.2s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="14" y="0" width="4" height="20" class="colorful c1" fill="'.$svg['loader_7']['colors'][0].'"><animate attributeName="opacity" attributeType="XML" values="1; .2; 1" begin="0.4s" dur="0.6s" repeatCount="indefinite" /></rect></svg>';
		
		
		
		/**
		 * Loader 8
		 */
		$svg['loader_8']['colors'] = array('#333333');
		$svg['loader_8']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['loader_8']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 24 30" style="enable-background:new 0 0 50 50;" xml:space="preserve"><rect x="0" y="10" width="4" height="10" class="colorful c1" fill="'.$svg['loader_8']['colors'][0].'" opacity="0.2"><animate attributeName="opacity" attributeType="XML" values="0.2; 1; .2" begin="0s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="height" attributeType="XML" values="10; 20; 10" begin="0s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="y" attributeType="XML" values="10; 5; 10" begin="0s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="8" y="10" width="4" height="10" class="colorful c1" fill="'.$svg['loader_8']['colors'][0].'" opacity="0.2"><animate attributeName="opacity" attributeType="XML" values="0.2; 1; .2" begin="0.15s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="height" attributeType="XML" values="10; 20; 10" begin="0.15s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="y" attributeType="XML" values="10; 5; 10" begin="0.15s" dur="0.6s" repeatCount="indefinite" /></rect><rect x="16" y="10" width="4" height="10" class="colorful c1" fill="'.$svg['loader_8']['colors'][0].'" opacity="0.2"><animate attributeName="opacity" attributeType="XML" values="0.2; 1; .2" begin="0.3s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="height" attributeType="XML" values="10; 20; 10" begin="0.3s" dur="0.6s" repeatCount="indefinite" /><animate attributeName="y" attributeType="XML" values="10; 5; 10" begin="0.3s" dur="0.6s" repeatCount="indefinite" /></rect></svg>';
		
		
		
		/**
		 * Spatter 1
		 */
		$svg['spatter_1']['colors'] = array('#000000');
		$svg['spatter_1']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['spatter_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 171.062" enable-background="new 0 0 200 171.062" xml:space="preserve"><path fill-rule="evenodd" clip-rule="evenodd" class="colorful c1" fill="'.$svg['spatter_1']['colors'][0].'" d="M115.42,2.113c0.379-0.091,0.346,0.248,0.369,0.529 c-0.147-0.031-0.184-0.176-0.361-0.171C115.426,2.352,115.424,2.232,115.42,2.113z M10.265,47.768 C10.144,48.854,11.088,47.871,10.265,47.768L10.265,47.768z M87.153,54.048c0.257,1.769,3.219,0.864,4.485,0.623 C91.104,53.424,88.513,53.897,87.153,54.048z M92.346,54.299C91.61,53.685,91.937,54.883,92.346,54.299L92.346,54.299z M88.638,56.703c0.071-0.561-0.394-0.565-0.904-0.518C87.715,56.738,88.38,56.975,88.638,56.703z M116.888,64.348 c0.005-0.308-0.147-0.457-0.368-0.529C116.514,64.126,116.666,64.274,116.888,64.348z M85.065,65.543 c-0.004-0.178-0.008-0.359-0.011-0.536c-0.21,0.032-0.509-0.021-0.532,0.188C84.778,65.234,84.828,65.485,85.065,65.543z M91.391,66.78l0.32,0.058c0.011-0.283,0.454-0.151,0.347-0.544c-0.421-0.346-0.198,0.05-0.533,0.189 c-0.771-0.784-1.707-1.939-3.249-1.364c-0.751,1.025-0.301,2.009-0.655,2.877c0.727-0.469,1.118,0.488,1.604-0.212 c0.312,0.221,0.026,1.069,0.56,1.061c0.099-1.116,1.167,0.141,1.967-0.041c0.275-1.321-1.206-0.813-1.288-1.763 c0.238-0.004,0.476-0.01,0.714-0.015L91.391,66.78z M114.744,64.57c-0.117,0.842,1.341,0.604,1.071-0.2 C115.264,64.25,115.295,64.689,114.744,64.57z M82.568,65.952C82.447,67.04,83.39,66.055,82.568,65.952L82.568,65.952z M114.455,67.797c0.178-0.005,0.215,0.142,0.359,0.172c-0.021-0.282,0.012-0.621-0.368-0.529 C114.449,67.559,114.451,67.678,114.455,67.797z M92.65,68.964C91.915,68.351,92.24,69.55,92.65,68.964L92.65,68.964z M103.571,69.276c0.04-0.47-0.081-0.769-0.552-0.705C102.979,69.039,103.1,69.339,103.571,69.276z M89.8,69.561 c0.179-0.005,0.216,0.14,0.361,0.171c-0.024-0.282,0.012-0.621-0.368-0.529C89.795,69.321,89.797,69.441,89.8,69.561z M117.342,68.991c0.18-0.005,0.215,0.14,0.362,0.171c-0.024-0.282,0.011-0.621-0.37-0.529 C117.336,68.751,117.34,68.871,117.342,68.991z M88.574,70.839c-0.09-0.517-0.395-0.809-0.912-0.876 C87.634,70.601,87.937,70.893,88.574,70.839z M116.127,70.805c0.025-0.391-0.158-0.566-0.548-0.525 C115.556,70.671,115.738,70.844,116.127,70.805z M91.279,71.855c-0.321-0.153-0.243-0.721-0.906-0.517 C90.296,71.801,91.027,72.339,91.279,71.855z M117.945,72.197c0.004-0.307-0.148-0.455-0.369-0.529 C117.572,71.977,117.725,72.125,117.945,72.197z M133.33,72.057c0.023-0.389-0.159-0.564-0.549-0.525 C132.756,71.923,132.938,72.098,133.33,72.057z M105.109,74.432c-0.047-0.337,0.193-0.399,0.164-0.718 c-0.546,0.14-0.533-0.298-1.076-0.157C104.24,74.117,104.547,74.41,105.109,74.432z M168.275,74.734 c-0.033-0.454-0.277-0.688-0.73-0.701C167.433,74.635,167.857,74.682,168.275,74.734z M120.914,77.325 c0.222-0.215,0.129-0.745-0.373-0.708C120.5,77.026,120.6,77.289,120.914,77.325z M119.852,77.884 c-0.004-0.238-0.01-0.476-0.014-0.714C119.129,77.06,119.268,77.935,119.852,77.884z M151.721,78.835 c-0.355,0.005-0.239-0.484-0.725-0.343C150.975,79.011,151.622,79.464,151.721,78.835z M120.752,82.428l0.27,0.084 c-0.389-1.058-0.689-2.205-1.84-2.467c0.413,1.019,0.299,2.31,0.422,3.211c0.605,0.033,0.5-1.079,1.063-0.557L120.752,82.428z M147.268,79.822c-0.355,0.004-0.239-0.484-0.724-0.343C146.523,79.997,147.168,80.452,147.268,79.822z M128.496,80.568 c0.355-0.005,0.238,0.482,0.723,0.342c0.021-0.449-0.286-0.553-0.553-0.704C128.672,80.385,128.527,80.422,128.496,80.568z M116.175,81.717c-0.439-0.091-0.396-0.684-1.086-0.515C114.798,81.949,115.92,82.146,116.175,81.717z M144.904,82.404l0.265-0.212 c-0.499-0.341-1.527-0.873-2.157-0.494c0.125,0.903,1.145,0.877,1.99,1.032L144.904,82.404z M113.711,83.736 c0.385-0.423-0.057-1.013-0.209-1.426c-0.178,0.003-0.357,0.007-0.535,0.011C112.998,83.019,113.123,83.62,113.711,83.736z M126.572,82.755c0.229,0.006,0.253,0.223,0.541,0.168c0.004-0.309-0.147-0.457-0.369-0.529 C126.75,82.574,126.605,82.608,126.572,82.755z M146.795,82.872c0.108-0.601-0.314-0.647-0.732-0.698 C145.953,82.774,146.376,82.821,146.795,82.872z M112.099,83.591c0.069-0.559-0.396-0.564-0.907-0.517 C111.034,83.725,111.969,83.24,112.099,83.591z M118.373,84.176c0.338-0.158,0.467-0.794,0.156-1.075 c-0.179,0.004-0.357,0.007-0.537,0.011C117.723,83.39,117.699,84.344,118.373,84.176z M110.496,83.982 C110.375,85.068,111.318,84.084,110.496,83.982L110.496,83.982z M116.271,86.367c-0.09-0.844,0.717-0.831,0.499-1.799 c-0.229-0.006-0.253-0.224-0.54-0.168C115.789,84.881,115.844,85.867,116.271,86.367z M119.293,85.412 c0.311-0.469,0.428-0.87-0.201-1.071C119.021,84.741,118.699,85.319,119.293,85.412z M123.465,88.186 c0.689-0.588-0.095-1.679-0.93-1.77C122.127,87.117,122.801,88.019,123.465,88.186z M118.812,88.104 c-0.173,1.611,2.777,1.639,3.455,2.793c-0.123,1.557,1.363,2.316,2.545,1.914c0.176-0.973-1.048-0.49-0.748-1.596 c0.104-0.365,0.901-0.068,0.699-0.73c-0.404-1.218-2.432-0.75-2.9-1.906c0.022-0.817-0.328-1.244-0.574-1.777 C119.955,86.799,118.887,87.41,118.812,88.104z M124.697,87.266c0.003,0.18,0.008,0.357,0.011,0.535 c1.071-0.199,2.26,1.021,2.497-0.408C126.771,86.989,125.313,86.902,124.697,87.266z M129.002,87.713 c0.004-0.306-0.146-0.454-0.369-0.529C128.629,87.493,128.781,87.641,129.002,87.713z M55.537,91.205 c0.5-0.045,0.757-0.328,0.696-0.911C55.471,89.659,54.786,90.81,55.537,91.205z M113.658,89.821 c-0.232,1.212,1.544,1.864,2.377,2.454C118.727,90.746,114.145,87.297,113.658,89.821z M127.258,89.896 c-0.001-0.668-0.309-1.018-0.742-1.236C126.462,89.389,126.607,89.906,127.258,89.896z M118.129,89.729 c0.296,0.24,0.453,0.622,1.086,0.514C119.398,89.486,118.256,89.062,118.129,89.729z M133.707,90.299 c-0.037-0.689-0.608-0.826-0.92-1.23C132.206,89.806,133.237,90.086,133.707,90.299z M130.48,93.09l0.238-0.223 c-0.266-0.639-0.625-1.175-1.456-1.223c-0.369,0.766,0.584,1.525,1.288,1.763L130.48,93.09z M121.094,94.676 c0.388-0.537-0.081-1.401-0.744-1.414c-0.12,0.002-0.239,0.004-0.357,0.007C119.947,94.165,120.461,94.485,121.094,94.676z M124.645,93.35c-0.037,0.373-0.785,0.067-0.887,0.377c-0.039,1.565,1.672,1.304,2.021,2.464c0.748,0.174,0.788,0.028,1.607-0.033 C126.975,94.7,125.618,94.225,124.645,93.35z M2.676,96.055C2.556,97.141,3.5,96.158,2.676,96.055L2.676,96.055z M131.443,101.979 c-1.277-1.104-1.92-2.871-4-3.139c-1.205-1.423-2.452-2.804-4.017-3.854c-0.536,0.257-0.641-0.07-1.431,0.029 c-1.38,2.243,1.802,3.785,3.319,4.763c2.849-0.566,3.285,2.888,5.093,4.009c0.263,0.223,0.393-0.32,1.071-0.022 C131.476,102.863,131.233,102.746,131.443,101.979z M138.879,102.451l0.085-0.271c-0.591-0.876-0.963-2.857-2.374-2.277 c0.253,1.443,1.087,2.277,2.205,2.818L138.879,102.451z M197.05,99.188c0.118-0.002,0.239-0.004,0.358-0.007 c-0.002-0.118-0.005-0.239-0.007-0.358c-0.118,0.004-0.239,0.006-0.358,0.008C197.046,98.949,197.048,99.068,197.05,99.188z M182.779,101.273C182.045,100.658,182.369,101.855,182.779,101.273L182.779,101.273z M184.05,102.142 c0.112-0.665-0.299-0.784-0.907-0.698C183.127,102.008,183.613,102.049,184.05,102.142z M129.155,103.812 c0.081-0.523-0.841-0.931-1.084-0.512C128.453,103.451,128.611,103.833,129.155,103.812z M17.924,106.654 C17.804,107.74,18.749,106.756,17.924,106.654L17.924,106.654z M110.977,107.231c-0.357,0.006-0.238-0.482-0.721-0.343 C110.074,107.346,110.873,107.67,110.977,107.231z M178.937,114.413c0.124-0.399-0.675-0.724-0.722-0.343 C178.568,114.066,178.452,114.554,178.937,114.413z M111.248,120.287c-0.096,0.786-0.854,0.933-1.042,1.633 c0.208,0.82,0.661,1.383,1.465,1.579c1.106-1.952,0.69-5.337-0.329-7.327c-0.229-0.006-0.253-0.225-0.542-0.168 C110.21,117.256,111.225,118.805,111.248,120.287z M134.187,122.138c0.122-0.002,0.239-0.005,0.358-0.007 c0.271-0.445-0.619-0.514-0.541-0.168C134.113,121.973,134.217,121.986,134.187,122.138z M111.533,134.059 c0.577-0.974,0.654-3.084-0.789-3.562C109.998,131.586,110.613,133.582,111.533,134.059z M117.472,135.726 c0.149,0.851-0.19,1.595,0.048,2.323c0.621,1.916,2.523,2.109,4.009,3.496c0.55-0.174,0.974-0.467,1.415-0.744 c-0.279-1.172-1.238-1.633-2.015-2.286c0.065-0.578-0.269-1.542,0.324-1.615c0.359,0.161,0.864,0.564,1.256,0.153 c0.325-0.747-0.594-1.816-1.635-1.219c-0.438-0.652-0.636-1.645-1.636-1.219c-0.587-1.033-0.9-2.351-2.378-2.455 C116.238,133.461,117.275,134.621,117.472,135.726z M190.738,131.348c0.025-0.393-0.157-0.569-0.547-0.529 C190.166,131.211,190.348,131.385,190.738,131.348z M139.146,136.889c-0.221-1.234-0.809-2.084-1.842-2.469 C137.078,135.427,138.073,136.633,139.146,136.889z M175.268,135.96c-0.256-0.038-0.308-0.288-0.543-0.347 C174.575,135.984,175.205,136.407,175.268,135.96z M176.545,137.184c0.045-0.472-0.382-0.452-0.727-0.52 C175.776,137.135,176.079,137.246,176.545,137.184z M128.565,144.442c-1.249-1.507-3.092-0.788-3.019,1.134 c0.072,1.842,2.006,3.607,2.966,4.949c0.632,0.884,1.308,2.377,2.362,1.74C129.92,150.625,129.918,146.071,128.565,144.442z M146.801,143.706c0.324,0.16,1.012,0.876,1.438,0.329C147.953,143.733,147.047,142.936,146.801,143.706z M147.797,157.285 c0.003-0.311-0.146-0.457-0.368-0.531C147.425,157.061,147.576,157.211,147.797,157.285z M155.002,168.228 c0.15-0.371-0.48-0.794-0.543-0.348C154.714,167.917,154.766,168.168,155.002,168.228z M91.5,52.259l0.27,0.083 c-0.002-0.119-0.005-0.238-0.007-0.357c1.298-1.646,4.008-1.045,6.054-1.378c0.861-0.139,1.656-0.724,2.49-0.767 c2.047-0.105,4.297-0.154,6.069-0.661c0.582-0.168,1.018-0.63,1.596-0.749c1.381-0.285,3.076,0.215,4.65-0.096 c1.067-0.212,1.877-0.872,3.021-0.958c0.276-0.844,0.785-1.466,1.025-2.348c-0.459-0.669-1.01-1.85-2.013-2.105 c-1.478-0.377-3.649,1.301-5.516,1.545c-1.513,0.199-3.069-0.164-4.47,0.093c-0.867,0.159-1.58,0.664-2.311,0.763 c-1.014,0.139-1.957-0.258-2.686-0.123c-0.449,0.082-0.929,0.438-1.421,0.566c-0.733,0.192-1.688,0.57-2.319,0.227 c-1.226,0.567-3.111,0.628-4.462,0.63c-1.119,0-2.476-1.242-3.781-1.174c-0.286-0.25-0.16-0.93-0.733-0.88 c-2.828-0.98-6.315-1.8-8.492-3.939c-1.056,0.261-2.438-0.097-3.409-0.465c-5.218,0.369-7.792,3.275-12.984,3.668 c-0.645-0.972-1.438-2.11-1.682-3.364c-0.066-0.346,0.182-0.755,0.158-1.078c-0.085-1.132-0.66-2.312-0.969-3.558 c-0.354-1.436-0.457-2.552-0.789-3.562c-0.797-2.416-1.978-5.532-3.01-7.095c-0.258-0.56-0.051-0.597-0.026-1.252 c-0.431-0.22-0.978-0.321-1.092-0.871c-1.032-2.883-2.458-5.355-3.042-8.705c-0.888-0.15-0.586,0.841-1.417,0.745 c-1.055-0.788-1.993-1.699-2.916-2.624c-0.821-3.528-4.162-1.945-7.02-2.001c-2.093,0.914-3.195,2.778-4.744,4.212 c-2.153-0.451-2.761-2.446-3.842-4.035c-0.783-1.155-1.755-2.001-2.211-3.175c-1.997-1.265-4.63-0.448-5.88,1.195 c0.404,1.508-0.916,2.26-0.994,3.777c-0.081,1.508,0.818,2.63,1.336,4.088c0.525,1.483,0.563,3.021,1.512,3.905 c0.599,2.418,0.975,5.706,2.297,7.288c1.336,1.598,1.888,3.491,2.619,5.493c-1.073,0.55-0.486,2.69-1.544,3.252 c0.006,1.7-0.568,2.844-1.169,3.96c0.364,1.643,0.795,2.137,1.498,3.19c0.345,0.514,0.636,1.071,0.928,1.592 c0.777,1.393,1.848,2.511,1.876,4.253c1.073,1.38,2.667,2.215,3.304,4.047c2.153,1.046,2.741,3.721,4.755,4.913 c0.351,1.155,1.206,1.788,1.842,2.645c1.231,0.087,1.178,0.842,1.819,1.394c0.385,0.332,0.947,0.381,1.265,0.69 c0.522,0.505,0.799,1.445,1.291,1.762c0.128,0.083,0.654,0.137,0.719,0.164c0.89,0.377,1.896,0.339,2.707,1.196 c0.799,1.2-0.257,2.062-0.115,3.044c0.138,0.946,1.17,1.995,1.848,2.825c0.745,0.911,1.49,1.686,2.023,2.642 c0.832-0.069,0.984-0.573,1.608-0.033c0.793-0.468,1.366-1.145,2.478-1.306c1.334,0.62,2.104,1.829,2.4,3.53 c1.65,1.386,1.752,4.385,3.517,5.653c-0.005,0.868,0.64,1.681,1.129,2.66c0.472,0.945,0.765,2.068,1.133,2.839 c0.685,1.44,1.694,1.995,2.393,3.35c1.118,2.164,1.412,4.162-0.793,4.848c-0.133,1.811,0.581,3.43,1.702,4.438 c0.142,0.545-0.169,0.655-0.157,1.077c0.649,0.724,0.931,1.833,1.312,2.835c1.923,0.98,2.798,3.053,4.034,4.748 c0.083,0.43-0.319,0.395-0.161,0.896c1.084,0.697,1.801,1.779,2.213,3.176c2,1.576,3.289,3.402,4.061,5.999 c0.656,2.204,0.797,4.798,1.4,7.129c0.387,1.497,1.21,2.837,1.698,4.259c0.472,1.367,0.671,2.396,1.143,3.376 c1.069,2.212,1.942,4.817,3.173,6.376c1.203,0.441,2.377,1.504,4.133,0.809c0.134-1.932,2.413-1.615,3.53-2.4 c1.354-0.949,1.253-2.496,2.063-3.979c1.838-2.047,4.242-2.373,6.74-2.822c0.621-0.516,1.094-1.171,1.939-1.472 c0.582-0.984,1.451-2.511,1.714-3.614c0.198-0.828,0.044-1.902,0.298-2.868c0.403-1.538,1.012-1.913,0.816-3.774 c-0.072-0.679-0.146-1.818-0.224-2.143c-0.256-1.069-1.168-2.039-1.317-3.193c-0.178-1.37,0.418-2.936-0.442-4.105 c-1.355-0.127-2.301-1.256-3.087-2.084c-0.471-0.496-0.939-0.753-1.096-1.051c-0.689-1.324-0.29-2.411,0.471-3.229 c0.715,0.043,0.986-0.341,1.785-0.216c0.725,0.096,0.811,0.859,1.455,1.043c0.688-0.064,1.048-0.213,1.958-0.398 c2.802,1.037,5.43,2.256,7.245,4.322c0.641,0.001,1.039,0.258,1.619,0.324c0.854,0.996,1.877,1.816,2.392,3.17 c2.112,0.723,3.847,1.838,5.605,2.928c2.608,0.204,4.451,1.207,5.607,2.924c3.124,1.312,4.487,4.46,8.511,4.835 c0.191,0.47,0.837,0.466,1.092,0.87c0.416-0.008,0.834-0.017,1.25-0.025c0.713,0.393,1.521,0.868,2.348,1.025 c2.774,0.529,4.58-0.579,6.223-1.917c0.534-1.562,1.295-3.083,0.975-4.853c-0.336-1.836-2.012-2.854-3.123-3.871 c1.762-1.857-0.442-4.938-2.611-5.135c-1.835-0.166-3.389,1.043-4.436,1.881c-3.071-0.635-5.32-2.126-8.112-3.052 c-0.43-1.38-1.772-1.806-2.39-2.993c-2.359,0.024-3.504-1.217-4.7-2.406l-0.273-0.204l0.082-0.33 c-0.118,0.003-0.237,0.005-0.357,0.007c-0.884-1.176-2.006-1.868-2.921-2.801c-0.512-0.523-0.799-1.295-1.289-1.762 c-0.365-0.35-1.26-0.905-1.995-1.392c-1.089-0.718-1.929-1.316-3.425-1.182c-1.035-0.87-1.941-1.874-3.445-2.254 c-0.463-0.813-0.647-1.29-0.76-2.13c0.468-0.309,1.188-0.381,1.412-0.926c0.124-0.921-0.221-1.354-0.4-1.961 c-1.492,0.088-2.103,1.021-3.008,1.674c-0.533-1.584-2.055-1.998-2.922-2.98c-0.295-0.335-0.275-0.792-0.559-1.062 c-0.143-0.137-0.613-0.275-0.905-0.519c-0.735-0.607-0.968-0.938-1.815-1.214c-0.883-2.029,0.652-4.106,2.226-4.877 c0.017-0.932-1.182-0.597-1.457-1.222c0.373-1.892-1.077-2.848-0.264-4.11c-0.616,0.154-0.761-0.184-1.081-0.334 c-0.602-1.566-1.972-2.33-3.286-3.152c-0.544,0.729-1.048,0.34-1.963,0.219c-2.605,1.039-4.978,1.517-7.475,1.944 c-0.572-0.196-0.463-1.1-1.1-1.23c-1.16,0.803-4.973-0.579-5.752-1.312c-0.564-0.532-0.679-1.709-1.121-2.303 c-0.549-0.739-1.281-0.945-1.643-1.576c-0.726-1.265,0.031-3.215,1.904-3.081c0.638,0.188,0.341,1.351,1.453,1.042 c0.298,0.652-0.055-0.723,0.53-0.368c2.296-0.417,3.935,0.295,6.077-0.305c1.184,0.553,3.261,0.913,4.844,0.614 c0.458-0.084,1.188-0.352,1.415-0.744c0.445-0.358-0.473-0.834-0.561-1.241c-1.949,0.48-2.791-0.346-4.651,0.096 c-0.632,0.11-0.453-0.625-1.083-0.515c-2.644-0.009-5.289-0.07-7.178-0.925c-0.622-0.808-0.081-2.006,0.856-1.985 c0.88,0.02,0.636,0.44,1.272,1.047c0.055-0.417,0.098-0.84,0.7-0.73l-0.094-0.327l0.262-0.213c-0.625-0.263-1.062-0.719-1.105-1.588 c0.255-0.959,1.774-0.02,1.954-0.756c-0.39-0.752-1.891-0.345-1.998-1.391c0.681-0.625,1.716-1.348,2.828-1.668 c0.184-0.053,0.376,0.211,0.718,0.163c0.988-0.136,2.062-1.508,2.848-0.774L91.5,52.259z M78.85,46.259l-0.083,0.271 c0.867,0.193,1.511,0.617,1.817,1.393c0.983-0.927,2.894-0.964,4.628-1.169c1.868,1.195,1.648,4.281,0.301,5.898 c-2.388,0.002-3.978,1.932-6.755,2.108c-0.644-0.546-1.638-0.729-2.526-1.021c0.031-2.076,1.518-2.751,2.422-3.985 c0.668,0.274,1.694-0.427,1.945-1.115c-0.219-1.454-1.226-1.031-1.829-1.93l-0.267,0.096l0.084-0.27 c-0.298,0.006-0.597,0.012-0.894,0.019c0.156-0.314,0.617-0.476,0.89-0.199L78.85,46.259z M93.055,53.926 c-0.09,0.662,1.819,0.912,1.795,0.321c0.34-0.648-0.847-0.783-1.62-0.503l0.093,0.267L93.055,53.926z M100.326,64.283 c-0.027,0.104,0.038,0.212,0.145,0.235c0.278,0.067,0.487,0.165,0.637,0.299c0.081,0.072,0.205,0.064,0.276-0.016 c0.072-0.081,0.066-0.205-0.016-0.275c-0.2-0.18-0.463-0.306-0.809-0.389C100.456,64.114,100.352,64.179,100.326,64.283z M91.563,66.985c-0.115,0.096-0.298,0.062-0.393-0.051l0.457,0.544c0.096,0.114,0.241,0.105,0.356,0.009 c0.11-0.095,0.104-0.287,0.008-0.402l-0.38-0.458C91.705,66.741,91.677,66.892,91.563,66.985z M117.677,77.789 c-0.126,0.065-0.175,0.22-0.106,0.349l0.186,0.354c0.064,0.125,0.225,0.174,0.349,0.108c0.126-0.068,0.175-0.224,0.106-0.35 l-0.186-0.353C117.961,77.77,117.803,77.72,117.677,77.789z M120.645,82.265c-0.092,0.06-0.117,0.178-0.06,0.268l0.139,0.209 l0.143,0.28c0.048,0.093,0.181,0.211,0.275,0.168c0.098-0.045,0.157-0.077,0.116-0.175l-0.209-0.492l-0.131-0.198 C120.857,82.233,120.733,82.205,120.645,82.265z M143.189,80.084c-0.047,0.133,0.021,0.277,0.153,0.325 c0.444,0.156,0.886,0.179,1.391,0.07c0.138-0.028,0.225-0.162,0.194-0.299c-0.029-0.137-0.162-0.225-0.299-0.196 c-0.416,0.089-0.76,0.072-1.115-0.054C143.381,79.884,143.235,79.955,143.189,80.084z M103.973,82.428 c-0.092,0.08-0.104,0.216-0.025,0.308l0.105,0.123l0.424,0.55c0.074,0.097,0.227,0.136,0.324,0.061 c0.095-0.073,0.127-0.188,0.055-0.284l-0.47-0.615l-0.104-0.119C104.203,82.36,104.062,82.347,103.973,82.428z M144.631,82.366 c-0.021,0.151,0.057,0.284,0.207,0.306l0.404,0.06c-0.153-0.021-0.271-0.163-0.25-0.313c0.021-0.151,0.145-0.256,0.295-0.235 l-0.314-0.044C144.82,82.117,144.654,82.216,144.631,82.366z M130.26,92.943c-0.082,0.123-0.012,0.308,0.11,0.392l0.284,0.189 c-0.122-0.083-0.141-0.235-0.06-0.36c0.083-0.122,0.265-0.146,0.387-0.064l-0.392-0.256 C130.466,92.764,130.338,92.818,130.26,92.943z M138.662,102.297c-0.084,0.12-0.057,0.285,0.064,0.369l0.172,0.123 c0.408,0.282,0.827,0.576,1.076,0.98c0.077,0.125,0.24,0.164,0.365,0.086c0.123-0.076,0.163-0.239,0.086-0.363 c-0.307-0.499-0.773-0.822-1.223-1.139l-0.17-0.12C138.913,102.147,138.744,102.18,138.662,102.297z M179.592,99.994 c-0.049,0.118,0.029,0.26,0.146,0.307l1.292,0.528c-0.117-0.049-0.162-0.177-0.116-0.294c0.047-0.117,0.191-0.17,0.31-0.121 l-1.354-0.552C179.75,99.815,179.639,99.879,179.592,99.994z M135.906,105.284c-0.145,0.097-0.184,0.293-0.09,0.438 c0.721,1.097,1.584,2.146,2.418,3.16l0.176,0.214c0.113,0.134,0.311,0.154,0.445,0.043c0.135-0.109,0.155-0.309,0.044-0.443 l-0.179-0.215c-0.822-1.002-1.674-2.037-2.376-3.104C136.249,105.23,136.053,105.191,135.906,105.284z M105.541,106.225 c-0.076,0.076-0.072,0.199,0.006,0.273l0.07,0.068c0.245,0.231,0.498,0.471,0.621,0.748c0.043,0.1,0.156,0.143,0.254,0.101 c0.1-0.043,0.143-0.159,0.1-0.255c-0.153-0.35-0.447-0.629-0.709-0.877l-0.069-0.064 C105.737,106.143,105.613,106.146,105.541,106.225z M111.336,111.535c-0.123,0.127-0.099,0.349,0.029,0.472l0.309,0.296 c-0.129-0.123-0.123-0.314,0.001-0.443s0.339-0.12,0.468,0.002l-0.371-0.354C111.643,111.385,111.459,111.404,111.336,111.535z M178.971,110.264l-0.363,0.02l0.084,0.184l1.076,0.46l0.46,0.212c0.085,0.04,0.183,0.003,0.224-0.082 c0.039-0.084-0.001-0.186-0.085-0.225l-0.453-0.209l-1.041-0.447L178.971,110.264z M161.996,113.73 c-0.068,0.092-0.201,0.105-0.29,0.037c1.229,0.957,2.302,2.014,3.535,3.305c0.079,0.083,0.21,0.086,0.294,0.01 c0.08-0.08,0.083-0.213,0.006-0.295c-1.247-1.303-2.332-2.373-3.58-3.346C162.05,113.512,162.066,113.643,161.996,113.73z M157.895,113.766c-0.055,0.004-0.096,0.052-0.092,0.106c0.004,0.056,0.051,0.097,0.107,0.093c0.139-0.011,0.197,0.045,0.281,0.138 c0.035,0.041,0.099,0.045,0.139,0.008c0.041-0.036,0.045-0.1,0.008-0.141C158.26,113.881,158.141,113.746,157.895,113.766z M118.843,130.338c-0.043,0.023-0.067,0.062-0.046,0.107l0.145,0.292l0.05,0.08c0.027,0.042,0.083,0.056,0.124,0.03 c0.042-0.025,0.059-0.079,0.03-0.12l-0.05-0.083l-0.129-0.253C118.945,130.347,118.887,130.316,118.843,130.338z M177.342,137.986 c-0.031,0.104-0.028,0.195,0.076,0.227l0.115,0.037l0.157,0.064c0.093,0.041,0.276,0.062,0.322-0.029 c0.045-0.092,0.084-0.146-0.005-0.195l-0.371-0.218C177.533,137.84,177.373,137.884,177.342,137.986z M140.427,160.75 c-0.099,0.062-0.083,0.24-0.021,0.336l0.17,0.271l0.287,0.434c0.064,0.094,0.151,0.072,0.248,0.011 c0.098-0.062,0.083-0.237,0.023-0.333l-0.176-0.281l-0.289-0.426C140.604,160.665,140.521,160.688,140.427,160.75z M155.712,162.052 c-0.091,0.083-0.126,0.186-0.042,0.278l0.686,0.756c0.278,0.245,0.54,0.479,0.676,0.799c0.049,0.113,0.18,0.166,0.291,0.117 c0.115-0.048,0.168-0.179,0.118-0.291c-0.173-0.412-0.485-0.689-0.788-0.958l-0.599-0.65 C155.969,162.012,155.803,161.969,155.712,162.052z M127.752,162.955c-0.109,0.072-0.121,0.244-0.051,0.354l0.434,0.665 c-0.072-0.108-0.032-0.241,0.077-0.312c0.108-0.072,0.265-0.025,0.339,0.084l-0.492-0.748 C127.987,162.887,127.859,162.885,127.752,162.955z M85.684,58.642c-0.062,0.124-0.017,0.273,0.105,0.337l0.609,0.309l1.033,0.553 c0.121,0.065,0.287,0.026,0.352-0.096c0.066-0.122,0.033-0.269-0.089-0.333l-1.071-0.573l-0.596-0.304 C85.903,58.472,85.747,58.519,85.684,58.642z M125.452,102.799c-0.091,0.106-0.077,0.268,0.033,0.361 c0.106,0.092,0.271,0.076,0.36-0.031c0.246-0.293,0.559-0.233,1.049-0.111l0.516,0.104c0.139,0.028,0.25-0.066,0.279-0.205 c0.027-0.139-0.086-0.28-0.225-0.308l-0.447-0.092C126.527,102.396,125.918,102.244,125.452,102.799z M91.437,52.139 c-0.067,0.035-0.093,0.118-0.06,0.184c0.413,0.791,1.141,1.295,1.847,1.784c0.062,0.043,0.147,0.027,0.189-0.035 c0.043-0.062,0.027-0.146-0.034-0.19c-0.678-0.469-1.378-0.954-1.759-1.685C91.585,52.128,91.502,52.103,91.437,52.139z M78.758,46.19l-0.273,0.421l-0.08,0.132c-0.032,0.054-0.016,0.126,0.039,0.16c0.056,0.032,0.125,0.015,0.159-0.039l0.079-0.134 l0.262-0.401c0.035-0.053,0.021-0.131-0.031-0.166C78.859,46.127,78.792,46.137,78.758,46.19z M108.306,85.681 c-0.056,0.061-0.069,0.139-0.009,0.196l0.203,0.197l0.199,0.225c0.055,0.062,0.176,0.12,0.239,0.067 c0.062-0.054,0.101-0.096,0.047-0.161l-0.292-0.365l-0.159-0.147C108.475,85.637,108.365,85.622,108.306,85.681z M125.791,140.184 c-0.061,0.054-0.064,0.149-0.014,0.211l0.266,0.325c0.041,0.048,0.125,0.106,0.186,0.084c0.059-0.022,0.115-0.039,0.114-0.104 c-0.003-0.125-0.116-0.266-0.349-0.51C125.939,140.131,125.851,140.131,125.791,140.184z"/></svg>';
		
		
		
		
		/**
		 * Spatter 2
		 */
		$svg['spatter_2']['colors'] = array('#000000');
		$svg['spatter_2']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['spatter_2']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><path fill-rule="evenodd" clip-rule="evenodd" class="colorful c1" fill="'.$svg['spatter_2']['colors'][0].'" d="M77.477,34.313c6.438,0.401,7.239,6.438,9.426,11.089 C82.077,45.549,78.269,40.032,77.477,34.313z M86.903,59.819c0.553,0,1.108,0,1.663,0c0-0.555,0-1.109,0-1.664 c-0.555,0-1.109,0-1.663,0C86.903,58.709,86.903,59.264,86.903,59.819z M120.726,70.354c0.75,0.174,1.06,0.79,2.219,0.555 c0.156-1.451-0.203-2.386-1.664-2.22C121.304,69.454,121.02,69.908,120.726,70.354z M119.616,191.783 c2.117-0.496,1.219-4.495-1.661-3.326C117.932,190.143,117.63,192.107,119.616,191.783z M29.238,9.361 c-0.066-0.566,2.392-1.123,0.555-1.664C30.087,8.496,27.632,9.051,29.238,9.361z M5.394,30.432c2.357,3.286,0.998-0.275-1.107-1.109 C4.35,29.999,4.453,30.635,5.394,30.432z M72.21,80.611l-0.278-0.277c0,0.369,0,0.74,0,1.108c-3.616,2.887-10.158,3.6-10.534,7.763 c-0.499,5.538,8.303,4.933,8.317,11.644c-2.281,0.861-4.808,1.476-4.989,4.435c0.24,2.347,2.787,2.387,4.434,3.326 c1.914,4.186,3.458,8.742,4.989,13.309c-0.43,0.122-0.642,0.463-0.553,1.107c-2.947,1.209-5.591,0.194-8.87,1.109 c-5.045,1.406-13.011,8.381-15.527,12.199c-5.247,7.967-6.333,21.703-3.327,28.832c0.491,1.166,2.606,3.289,3.881,4.99 c1.367,1.826,2.644,4.031,3.88,4.99c0.729,0.562,2.897,0.656,4.438,1.664c1.258,0.824,1.711,2.27,2.773,2.772 c1.828,0.864,4.939,1.466,6.651,1.663c5.558,0.643,9.056-1.108,12.2-1.663c6.564-1.161,9.122-4.427,14.969-5.547 c2.017-6.919,7.619-11.782,8.319-19.958c0.099-1.156-2.099-3.74,0.553-4.437l0.278-0.832l0.276,0.832 c0.557,0.001,0.661-0.45,1.109-0.556c2.425,2.467,5.983,0.285,8.319-0.554c3.52,4.742,10.595,3.675,18.295,3.327 c1.055-1.533,0.049-5.127,2.221-5.546c4.668,2.021,6.087-3.903,8.315,0.555c0.365-1.852,1.79-2.644,2.771-3.88 c-0.544-3.527-0.433-6.705-1.107-11.09c1.912-1.229,2.759-3.522,4.99-4.437c2.956,0.071,5.698,3.484,7.761,1.109 c-1.681-5.156-9.845-3.831-12.196-8.317c2.667-5.279,7.92-7.973,15.524-8.316c2.535-2.455,5.724-4.257,8.871-6.101 c-0.184-9.409,9.014-4.3,16.636-5.544c5.029-0.822,6.677-3.876,9.979-4.989c0.614-2.344,0.639-5.275,0.555-8.318 c-4.625-4.786-8.597-7.301-14.972-6.653c-5.94,0.604-7.697,7.071-12.198,8.317c-2.613,0.724-3.348-0.187-5.544-0.556 c-6.253-1.049-13.062-0.958-17.744-4.436c2.71-3.943,6.385-6.923,10.536-9.426c0.638-14.315-5.828-21.525-16.081-24.952 c0.943-1.658,0.607-3.645,1.109-5.545c1.339-5.06,6.297-9.563,3.328-13.861c-5.606-0.652-5.927,4.786-4.438,8.317 c-3.036,2.454-2.167,8.426-3.88,13.863c-0.536,1.697-2.236,3.227-2.771,4.989c-0.765,2.494-0.231,5.17-1.109,7.208 c-0.544,1.257-2.379,2.79-3.883,4.435c-3.039,3.327-3.775,4.871-7.763,3.328c-2.007-6.373-7.572-10.54-7.761-18.852 c-0.166-7.18,4.754-17.279-1.664-17.743c-2.219,4.4-0.707,9.439-1.109,13.861c-0.069,0.737-0.949,1.387-1.109,2.218 c-0.535,2.782,0.109,5.991-0.555,8.317c-1.191,4.176-3.801,8.057-6.653,11.09c-2.385-0.76-4.518-1.767-7.209-2.22 c-0.661-3.313-4.062-5.894-7.208-4.989c-2.44,1.996,0.219,9.09-3.881,9.426c-6.615-0.442-4.59-12.359-9.979-12.199 c-1.28,7.636,7.658,12.576,6.1,20.516c-2.42,1.15-5.744,0.329-7.209-1.108L72.21,80.611z M89.886,57.659 c-0.223,0.242-0.209,0.618,0.033,0.84c0.233,0.216,0.307,0.4,0.273,0.702c-0.033,0.327,0.203,0.619,0.53,0.653 c0.327,0.035,0.619-0.203,0.653-0.529c0.07-0.675-0.142-1.231-0.65-1.701C90.483,57.403,90.108,57.418,89.886,57.659z M103.476,148.812v1.664c0,0.187,0.151,0.339,0.339,0.339s0.341-0.152,0.341-0.339v-1.664c0-0.187-0.153-0.34-0.341-0.34 S103.476,148.625,103.476,148.812z M64.25,73.234c-0.094,0.108-0.086,0.269,0.023,0.362l2.27,1.961 c1.932,1.638,3.928,3.332,5.466,5.218c0.089,0.11,0.253,0.126,0.362,0.037c0.111-0.091,0.128-0.253,0.036-0.364 c-1.564-1.923-3.58-3.632-5.528-5.285l-2.261-1.953C64.511,73.118,64.346,73.126,64.25,73.234z"/></svg>';
		
		
		
		/**
		 * Android
		 */
		$svg['android']['colors'] = array('#ABC248');
		$svg['android']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['android']['colors']).'><g><path class="colorful c1" fill="'.$svg['android']['colors'][0].'" d="M4.4 10.4c-1.1 0-2 .9-2 2v8.3c0 1.1.9 2 2 2s2-.9 2-2v-8.3c0-1.2-.9-2.1-2-2m16-7.5L21.8.4c.1-.1 0-.3-.1-.4-.1-.1-.3 0-.4.1l-1.4 2.5c-1.2-.5-2.5-.8-3.9-.8s-2.7.3-3.9.8L10.7.1c0-.1-.2-.1-.3-.1-.1.1-.2.2-.1.4l1.4 2.5C8.9 4.3 7.1 7 7.1 10h17.8c0-3-1.8-5.7-4.5-7.1m-8.5 3.9c-.4 0-.7-.3-.7-.7 0-.4.3-.7.7-.7.4 0 .7.3.7.7.1.4-.2.7-.7.7m8.1 0c-.4 0-.7-.3-.7-.7 0-.4.3-.7.7-.7.4 0 .7.3.7.7.1.4-.2.7-.7.7M7.2 10.7v12.8c0 1.2.9 2.1 2.1 2.1h1.4V30c0 1.1.9 2 2 2s2-.9 2-2v-4.4h2.7V30c0 1.1.9 2 2 2s2-.9 2-2v-4.4h1.4c1.2 0 2.1-.9 2.1-2.1V10.7H7.2zm22.3 1.6c0-1.1-.9-2-2-2s-2 .9-2 2v8.3c0 1.1.9 2 2 2s2-.9 2-2v-8.3z"/></g></svg>';
		
		
		
		/**
		 * Twitter
		 */
		$svg['twitter']['colors'] = array('#1DA1F2');
		$svg['twitter']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['twitter']['colors']).'><g id="twitter"><path class="colorful c1" fill="'.$svg['twitter']['colors'][0].'" d="M10.1 29c12.1 0 18.7-10 18.7-18.7v-.8c1.2-1 2.3-2.1 3.2-3.4-1.2.5-2.5.9-3.8 1 1.4-.8 2.4-2.1 2.9-3.6-1.3.8-2.7 1.3-4.2 1.6-2.5-2.6-6.6-2.8-9.3-.3-1.7 1.6-2.4 4-1.9 6.3-5.2-.3-10.1-2.8-13.5-6.9-1.7 3-.9 6.8 2 8.8-1 0-2.1-.3-3-.8v.1c0 3.1 2.2 5.8 5.3 6.4-1 .3-2 .3-3 .1.9 2.7 3.3 4.5 6.1 4.6-2.3 1.8-5.2 2.8-8.2 2.8-.5 0-1 0-1.6-.1C3 28 6.5 29 10.1 29"/></g></svg>';
		
		
		
		
		/**
		 * Facebook
		 */
		$svg['facebook']['colors'] = array('#485A94');
		$svg['facebook']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['facebook']['colors']).'><g id="facebook"><path class="colorful c1" fill="'.$svg['facebook']['colors'][0].'" d="M30.2 32c1 0 1.8-.8 1.8-1.8V1.8c0-1-.8-1.8-1.8-1.8H1.8C.8 0 0 .8 0 1.8v28.5c0 1 .8 1.8 1.8 1.8h28.4z"/><path fill="#FFF" d="M22.1 32V19.6h4.2l.6-4.8h-4.8v-3.1c0-1.4.4-2.4 2.4-2.4h2.6V5c-.4-.1-2-.2-3.7-.2-3.7 0-6.2 2.3-6.2 6.4v3.6H13v4.8h4.2V32h4.9z"/></g></svg>';
		
		
		
		/**
		 * LinkedIn
		 */
		$svg['linkedin']['colors'] = array('#0077B5');
		$svg['linkedin']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['linkedin']['colors']).'><g id="linkedin"><path class="colorful c1" fill="'.$svg['linkedin']['colors'][0].'" d="M29.6 0H2.4C1.1 0 0 1 0 2.3v27.4C0 31 1.1 32 2.4 32h27.3c1.3 0 2.4-1 2.4-2.3V2.3C32 1 30.9 0 29.6 0z"/><path fill="#FFFFFF" d="M4.7 12h4.8v15.3H4.7V12zm2.4-7.6c1.5 0 2.8 1.2 2.8 2.8 0 1.5-1.2 2.8-2.8 2.8-1.5 0-2.8-1.2-2.8-2.8.1-1.6 1.3-2.8 2.8-2.8M12.5 12H17v2.1h.1c.6-1.2 2.2-2.5 4.5-2.5 4.8 0 5.7 3.2 5.7 7.3v8.4h-4.7v-7.4c0-1.8 0-4.1-2.5-4.1s-2.8 1.9-2.8 3.9v7.6h-4.7V12z"/></g></svg>';
		
		
		
		/**
		 * Paypal
		 */
		$svg['paypal']['colors'] = array();
		$svg['paypal']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['paypal']['colors']).'><g id="paypal"><path fill="#253B80" d="M10.1 30.9l.6-3.5H3.6l4.1-26c0-.1.1-.2.1-.2 0-.1.1-.1.2-.1h9.9c3.3 0 5.6.7 6.8 2 .6.6.9 1.3 1.1 2 .2.8.2 1.7 0 2.9V8.8l.6.3c.5.2.8.5 1.1.9.5.5.8 1.2.9 2.1.1.8.1 1.8-.1 3-.3 1.3-.7 2.4-1.2 3.4-.5.9-1.2 1.6-1.9 2.1s-1.6.9-2.6 1.2c-1 .3-2.1.4-3.3.4h-.8c-.6 0-1.1.2-1.5.6-.4.4-.7.9-.8 1.4l-.1.3-1 6.2v.2c0 .1 0 .1-.1.1h-.1c0-.1-4.8-.1-4.8-.1z"/><path fill="#179BD7" d="M26.9 8.1c0 .2-.1.4-.1.6-1.3 6.7-5.8 9.1-11.5 9.1h-2.9c-.7 0-1.3.5-1.4 1.2l-1.5 9.5-.5 2.6c-.1.5.3.9.7.9h5.2c.6 0 1.1-.4 1.2-1l.1-.3 1-6.2.1-.3c.1-.6.6-1.1 1.2-1.1h.8c5 0 8.9-2 10.1-7.9.5-2.5.2-4.5-1-6-.5-.4-1-.8-1.5-1.1z"/><path fill="#222D65" d="M25.5 7.6c-.2-.1-.4-.1-.6-.2-.2 0-.4-.1-.7-.1-.8-.1-1.6-.2-2.6-.2h-7.8c-.2 0-.4 0-.5.1-.4.2-.6.5-.7.9L11 18.7v.3c.1-.7.7-1.2 1.4-1.2h2.9c5.7 0 10.2-2.3 11.5-9.1 0-.2.1-.4.1-.6-.3-.2-.7-.3-1.1-.5h-.3z"/><path fill="#253B80" d="M12.6 8.2c.1-.4.3-.8.7-.9.2-.1.3-.1.5-.1h7.8c.9 0 1.8.1 2.6.2.2 0 .4.1.7.1.2 0 .4.1.6.2.1 0 .2.1.3.1.4.1.7.3 1.1.5.4-2.5 0-4.2-1.3-5.7C24 .7 21.4 0 17.9 0H8c-.7 0-1.3.5-1.4 1.2L2.4 27.5c-.1.5.3 1 .8 1h6.1l1.5-9.8 1.8-10.5z"/></g></svg>';
		
		
		
		/**
		 * Pintrest
		 */
		$svg['pintrest']['colors'] = array('#bd081c');
		$svg['pintrest']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['pintrest']['colors']).'><g id="pinterest"><path class="colorful c1" fill="'.$svg['pintrest']['colors'][0].'" d="M16 0C7.2 0 0 7.2 0 16c0 6.8 4.2 12.6 10.2 14.9-.1-1.3-.3-3.2.1-4.6.3-1.2 1.9-8 1.9-8s-.5-1-.5-2.4c0-2.2 1.3-3.9 2.9-3.9 1.4 0 2 1 2 2.3 0 1.4-.9 3.4-1.3 5.3-.4 1.6.8 2.9 2.4 2.9 2.8 0 5-3 5-7.3 0-3.8-2.8-6.5-6.7-6.5-4.6 0-7.2 3.4-7.2 6.9 0 1.4.5 2.8 1.2 3.7.1.2.1.3.1.5-.1.5-.4 1.6-.4 1.8-.2.3-.4.4-.7.2-2-.9-3.2-3.9-3.2-6.2 0-5 3.7-9.7 10.6-9.7 5.6 0 9.9 4 9.9 9.2 0 5.5-3.5 10-8.3 10-1.6 0-3.1-.8-3.7-1.8 0 0-.8 3.1-1 3.8-.4 1.4-1.3 3.1-2 4.2 1.5.5 3.1.7 4.7.7 8.8 0 16-7.2 16-16S24.8 0 16 0z"/></g></svg>';
		
		
		
		/**
		 * Skype
		 */
		$svg['skype']['colors'] = array('#25A2DA');
		$svg['skype']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['skype']['colors']).'><g id="skype"><path class="colorful c1" fill="'.$svg['skype']['colors'][0].'" d="M3.8 1.6c2.8-2 6.7-2.2 9.6-.5 3.3-.6 6.8 0 9.8 1.6 3.3 1.8 5.9 4.8 7.1 8.4.8 2.4 1 5 .6 7.5 1.1 1.9 1.4 4.1 1 6.2-.5 2.3-1.9 4.4-3.9 5.7-2.7 1.8-6.5 1.9-9.4.3-3.2.5-6.5.1-9.4-1.4-3.3-1.7-6-4.6-7.3-8.2C1 18.8.7 16 1.2 13.4.1 11.5-.2 9.2.2 7.1.7 4.9 2 2.9 3.8 1.6z"/><path fill="#FFF" d="M14 6.9c2.2-.3 4.5 0 6.4 1.1.8.5 1.7 1.1 2.1 2 .3.6.3 1.4-.2 1.9s-1.3.7-2 .5c-.8-.3-1.2-1.2-1.9-1.7-.8-.7-2-.9-3.1-.9-.8 0-1.6.2-2.2.8-.5.6-.7 1.5-.2 2.2.5.6 1.2.8 1.9 1 1.3.3 2.6.6 4 .9 1.4.3 2.8.9 3.7 2 1.6 2 1.2 5.2-.7 6.9-1.6 1.4-3.7 1.8-5.7 1.8-2.1 0-4.4-.5-6.1-1.9-.8-.7-1.5-1.9-1.3-3 .3-1.1 1.8-1.6 2.7-.9.7.5 1 1.4 1.7 1.9.8.7 1.9 1 2.9 1s2.1-.3 2.8-1.1c.5-.5.7-1.3.4-2-.3-.6-.9-1-1.5-1.2-1.2-.3-2.3-.6-3.5-.9-1.3-.3-2.6-.6-3.7-1.4-.9-.6-1.5-1.4-1.7-2.5-.3-1.6-.1-3.4 1-4.6 1.1-1.1 2.7-1.7 4.2-1.9z"/></g></svg>';
		
		
		
		/**
		 * Apple
		 */
		$svg['apple']['colors'] = array('#000000');
		$svg['apple']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['apple']['colors']).'><g id="apple"><path class="colorful c1" fill="'.$svg['apple']['colors'][0].'" d="M29.5 23.5l-.6 1.5c-.5 1.1-1.1 2.1-1.7 3.1-.9 1.3-1.6 2.2-2.2 2.7-.9.8-1.8 1.2-2.8 1.3-.7 0-1.6-.2-2.6-.6-1-.4-2-.6-2.8-.6-.9 0-1.9.2-2.9.6-1 .4-1.9.6-2.5.7-1 0-1.9-.4-2.9-1.3-.6-.5-1.4-1.5-2.3-2.8-1-1.4-1.8-3-2.5-4.9-.7-2-1-3.9-1-5.8 0-2.1.5-4 1.4-5.5C4.8 10.7 5.8 9.7 7 9c1-.9 2.4-1.3 3.8-1.3.8 0 1.8.2 3 .7 1.3.5 2.1.7 2.4.7.3 0 1.2-.3 2.7-.8 1.4-.5 2.7-.7 3.6-.6 2.7.2 4.7 1.3 6.1 3.2-2.4 1.5-3.6 3.5-3.6 6.1 0 2 .8 3.7 2.2 5.1.7.5 1.5 1 2.3 1.4zM22.7 0v.6c0 1.6-.6 3.1-1.7 4.5-1.4 1.6-3.1 2.6-5 2.4v-.6c0-1.5.7-3.2 1.9-4.5.6-.7 1.3-1.2 2.3-1.7.8-.4 1.7-.7 2.5-.7z"/></g></svg>';
		
		
		/**
		 * Windows
		 */
		$svg['windows']['colors'] = array('#0078D6');
		$svg['windows']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['windows']['colors']).'><g id="windows">	<path class="colorful c1" fill="'.$svg['windows']['colors'][0].'" d="M12.9 15.5V2.8L0 4.6v10.9zM13.9 15.5H32V0L13.9 2.6zM12.9 16.5H0v10.8l12.9 1.9zM13.9 16.5v12.9L32 32V16.5z"/></g></svg>';
		
		
		
		/**
		 * Bluetooth
		 */
		$svg['bluetooth']['colors'] = array('#0F3B87');
		$svg['bluetooth']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['bluetooth']['colors']).'><g id="bluetooth"><path class="colorful c1" fill="'.$svg['bluetooth']['colors'][0].'" d="M16 32C4.6 32 4.2 20.1 4.2 16.2V16v-.2C4.2 11.9 4.6 0 16 0c11.3 0 11.8 12.2 11.8 15.8v.4c0 3.6-.5 15.8-11.8 15.8z"/>	<path fill="#FFFFFF" d="M15.6 29.3V18.6l-4.7 4.7-1.6-1.6L15 16l-5.8-5.8 1.6-1.6 4.7 4.7V2.7l8 8-5.3 5.3 5.4 5.4-8 7.9zm2.3-10.5v5l2.5-2.5-2.5-2.5zm0-10.6v5l2.5-2.5-2.5-2.5z"/></g></svg>';
		
		
		
		/**
		 * CE
		 */
		$svg['ce']['colors'] = array('#000000');
		$svg['ce']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['ce']['colors']).'><g id="ce"><path class="colorful c1" fill="'.$svg['ce']['colors'][0].'" d="M30.132 5.912H32V2.176h-1.868c-7.623 0-13.824 6.2-13.824 13.824 0 7.622 6.2 13.824 13.824 13.824H32v-3.736h-1.868c-4.923 0-9.026-3.548-9.907-8.22h8.096v-3.736h-8.095c.88-4.672 4.984-8.22 9.907-8.22zM13.824 2.176C6.2 2.176 0 8.376 0 16c0 7.622 6.2 13.824 13.824 13.824h1.868v-3.736h-1.868C8.262 26.088 3.736 21.562 3.736 16c0-5.562 4.526-10.088 10.088-10.088h1.868V2.176h-1.868z"/></g></svg>';
		
		
		/**
		 * Github
		 */
		$svg['github']['colors'] = array('#1D1C15');
		$svg['github']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['github']['colors']).'><g id="github"><path class="colorful c1" fill="'.$svg['github']['colors'][0].'" d="M16 0C7.2 0 0 7.2 0 16c0 7.1 4.6 13.1 10.9 15.2.8.1 1.1-.3 1.1-.8v-3c-4.5 1-5.4-1.9-5.4-1.9-.7-1.8-1.8-2.3-1.8-2.3-1.5-1 .1-1 .1-1 1.6.1 2.5 1.6 2.5 1.6 1.4 2.4 3.7 1.7 4.7 1.3.1-1 .6-1.7 1-2.1-3.6-.4-7.3-1.8-7.3-7.9 0-1.7.6-3.2 1.6-4.3-.2-.4-.7-2 .2-4.2 0 0 1.3-.4 4.4 1.6 1.3-.4 2.6-.5 4-.5s2.7.2 4 .5c3.1-2.1 4.4-1.6 4.4-1.6.9 2.2.3 3.8.2 4.2 1 1.1 1.6 2.5 1.6 4.3 0 6.1-3.7 7.5-7.3 7.9.6.5 1.1 1.5 1.1 3v4.4c0 .4.3.9 1.1.8C27.4 29.1 32 23.1 32 16c0-8.8-7.2-16-16-16z"/><path class="colorful c1" fill="'.$svg['github']['colors'][0].'" d="M6.1 23c0 .1-.2.1-.3 0-.1-.1-.2-.2-.1-.2 0-.1.2-.1.3 0 0 0 .1.1.1.2zM6.7 23.7c-.1.1-.2 0-.3-.1-.1-.1-.1-.3 0-.3.1-.1.2 0 .3.1.1.1.1.2 0 .3zM7.3 24.6c-.1.1-.3 0-.4-.1-.1-.1-.1-.3 0-.4.1-.1.3 0 .4.1.1.2.1.3 0 .4zM8.2 25.5c-.1.1-.3.1-.4-.1-.1-.1-.2-.3-.1-.4.1-.1.3 0 .4.1.2.1.2.3.1.4zM9.4 26c0 .1-.2.2-.4.1s-.3-.2-.3-.3c0-.1.2-.2.4-.1s.3.2.3.3zM10.7 26.1c0 .1-.1.2-.3.2-.2 0-.3-.1-.3-.2s.2-.2.3-.2c.1 0 .3.1.3.2zM11.9 25.9c0 .1-.1.3-.3.3-.2 0-.4 0-.4-.2 0-.1.1-.3.3-.3.2 0 .4.1.4.2z"/></g></svg>';
		
		
		
		/**
		 * Google +
		 */
		$svg['google_plus']['colors'] = array('#dd4b39');
		$svg['google_plus']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 32 32" width="100%" height="100%"'.$this->svg_color_data($svg['google_plus']['colors']).'><g id="google-plus"><path class="colorful c1" fill="'.$svg['google_plus']['colors'][0].'" d="M32 14.5h-2.9v-2.9h-2.9v2.9h-2.9v2.9h2.9v2.9h2.9v-2.9H32v-2.9zm-21.8 0V18H16c-.3 1.5-1.7 4.4-5.8 4.4-3.5 0-6.3-2.9-6.3-6.4s2.8-6.4 6.3-6.4c2 0 3.3.9 4.1 1.6L17 8.6c-1.7-1.7-4.1-2.8-6.8-2.8C4.5 5.8 0 10.3 0 16s4.5 10.2 10.2 10.2c5.8 0 9.7-4.1 9.7-9.9 0-.7 0-1.2-.1-1.7h-9.6z"/></g></svg>';
		
		
		
		/**
		 * CSS 3
		 */
		$svg['css3']['colors'] = array();
		$svg['css3']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 100 60" width="100%" height="100%"'.$this->svg_color_data($svg['css3']['colors']).'><g id="css3"><path d="M 71.3206 47.2883 L 56.5297 51.3169 L 41.7385 47.2883 L 38.3254 9.8838 L 74.7343 9.8838 L 71.3206 47.2883 Z" fill="#464ba6"/><path d="M 56.5295 12.9136 L 56.5295 48.1038 L 56.5627 48.1133 L 68.5325 44.8528 L 71.2954 12.9136 L 56.5295 12.9136 Z" fill="#699dca"/><path d="M 48.1351 4.3884 L 48.1351 2.1621 L 51.3462 2.1621 L 51.3462 -0.2739 L 45.7268 -0.2739 L 45.7268 6.6113 L 51.3462 6.6113 L 51.3462 4.3884 L 48.1351 4.3884 Z" fill="#000000"/><path d="M 57.1226 2.1621 L 59.3674 2.1621 L 59.3674 -0.2739 L 53.7477 -0.2739 C 53.7477 -0.2739 53.7477 0.9487 53.7477 2.1621 C 54.4995 2.9226 54.8917 3.2866 55.979 4.3867 C 55.3434 4.3867 53.7477 4.3889 53.7477 4.3889 L 53.7477 6.6113 L 59.3674 6.6113 L 59.3674 4.3884 L 57.1226 2.1621 Z" fill="#000000"/><path d="M 65.0879 2.1621 L 67.3328 2.1621 L 67.3328 -0.2739 L 61.7125 -0.2739 C 61.7125 -0.2739 61.7125 0.9487 61.7125 2.1621 C 62.4644 2.9226 62.8568 3.2866 63.9441 4.3867 C 63.3087 4.3867 61.7125 4.3889 61.7125 4.3889 L 61.7125 6.6113 L 67.3328 6.6113 L 67.3328 4.3884 L 65.0879 2.1621 Z" fill="#000000"/><path d="M 56.5164 22.1563 L 45.9299 26.6162 L 46.2811 31.0317 L 56.5164 26.605 L 67.4039 21.8965 L 67.8555 17.3794 L 56.5164 22.1563 Z" fill="#ffffff"/><path d="M 45.9299 26.6162 L 46.2811 31.0317 L 56.5164 26.605 L 56.5164 22.1563 L 45.9299 26.6162 Z" fill="#e7e7e4"/><path d="M 67.8555 17.3794 L 56.5164 22.1563 L 56.5164 26.605 L 67.4039 21.8965 L 67.8555 17.3794 Z" fill="url(#gradient1)"/><path d="M 45.9462 26.7261 L 46.2974 31.1416 L 62.002 31.1924 L 61.6509 37.0798 L 56.4832 38.5515 L 51.5154 37.283 L 51.2144 33.6284 L 46.5984 33.6284 L 47.2004 40.6831 L 56.5332 43.4746 L 65.8152 40.7339 L 67.0193 26.7261 L 45.9462 26.7261 Z" fill="#ffffff"/><path d="M 56.5164 26.7261 L 45.9299 26.7261 L 46.2811 31.1416 L 56.5164 31.1748 L 56.5164 26.7261 Z" fill="#e7e7e4"/><path d="M 56.5164 38.5374 L 56.4663 38.5515 L 51.499 37.283 L 51.1981 33.6284 L 46.5822 33.6284 L 47.1842 40.6831 L 56.5164 43.4746 L 56.5164 38.5374 Z" fill="#e7e7e4"/><path d="M 44.9767 17.3794 L 67.8555 17.3794 L 67.4039 21.8965 L 45.5286 21.8965 L 44.9767 17.3794 Z" fill="#ffffff"/><path opacity="0.0471" d="M 56.5164 17.3794 L 44.9767 17.3794 L 45.5286 21.8965 L 56.5164 21.8965 L 56.5164 17.3794 Z" fill="#000000"/></g></svg>';
		
		
		
		/**
		 * HTML5
		 */
		$svg['html5']['colors'] = array();
		$svg['html5']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"viewbox="0 0 100 60" width="100%" height="100%"'.$this->svg_color_data($svg['html5']['colors']).'><g id="html5"><path d="M 3.4105 47.1733 L 0.0971 9.8647 L 36.506 9.8647 L 33.1889 47.1675 L 18.2791 51.3169 L 3.4105 47.1733 Z" fill="#e44d26"/><path d="M 18.3015 48.1453 L 30.3492 44.792 L 33.1838 12.9153 L 18.3015 12.9153 L 18.3015 48.1453 Z" fill="#f16529"/><path d="M 18.3015 26.7527 L 12.2701 26.7527 L 11.8536 22.0669 L 18.3015 22.0669 L 18.3015 17.491 L 18.2858 17.491 L 6.8721 17.491 L 6.9813 18.7188 L 8.1016 31.3284 L 18.3015 31.3284 L 18.3015 26.7527 Z" fill="#ebebeb"/><path d="M 18.3015 38.6362 L 18.2815 38.6416 L 13.2053 37.2654 L 12.8807 33.6162 L 10.4141 33.6162 L 8.3051 33.6162 L 8.9437 40.8008 L 18.2806 43.4026 L 18.3015 43.397 L 18.3015 38.6362 Z" fill="#ebebeb"/><path d="M 3.4846 -0.2739 L 5.801 -0.2739 L 5.801 2.0234 L 7.9198 2.0234 L 7.9198 -0.2739 L 10.2362 -0.2739 L 10.2362 6.6831 L 7.9199 6.6831 L 7.9199 4.3535 L 5.801 4.3535 L 5.801 6.6831 L 3.4847 6.6831 L 3.4847 -0.2739 L 3.4846 -0.2739 Z" fill="#000000"/><path d="M 13.2822 2.033 L 11.2431 2.033 L 11.2431 -0.2739 L 17.6389 -0.2739 L 17.6389 2.033 L 15.5987 2.033 L 15.5987 6.6831 L 13.2823 6.6831 L 13.2823 2.033 L 13.2822 2.033 Z" fill="#000000"/><path d="M 18.654 -0.2739 L 21.0692 -0.2739 L 22.5551 2.1707 L 24.0391 -0.2739 L 26.4554 -0.2739 L 26.4554 6.6831 L 24.1486 6.6831 L 24.1486 3.2346 L 22.5551 5.7085 L 22.515 5.7085 L 20.9203 3.2346 L 20.9203 6.6831 L 18.654 6.6831 L 18.654 -0.2739 Z" fill="#000000"/><path d="M 27.6083 -0.2739 L 29.9252 -0.2739 L 29.9252 4.3835 L 33.1826 4.3835 L 33.1826 6.6831 L 27.6083 6.6831 L 27.6083 -0.2739 Z" fill="#000000"/><path d="M 18.2858 26.7527 L 18.2858 31.3284 L 23.8984 31.3284 L 23.3693 37.2627 L 18.2858 38.6399 L 18.2858 43.4004 L 27.6299 40.8008 L 27.6984 40.0278 L 28.7696 27.9812 L 28.8809 26.7527 L 27.6525 26.7527 L 18.2858 26.7527 Z" fill="#ffffff"/><path d="M 18.2858 17.491 L 18.2858 20.333 L 18.2858 22.0557 L 18.2858 22.0669 L 29.2809 22.0669 L 29.2809 22.0669 L 29.2954 22.0669 L 29.3868 21.0383 L 29.5945 18.7188 L 29.7037 17.491 L 18.2858 17.491 Z" fill="#ffffff"/></g></svg>';
		
		
		
		/**
		 * Dessert
		 */
		$svg['dessert_1']['colors'] = array();
		$svg['dessert_1']['code'] = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 750 279" id="arizona"'.$this->svg_color_data($svg['dessert_1']['colors']).'><circle id="sun" fill="#FFF7EB" cx="655" cy="128" r="41.5"/><path fill="hsl(32, 89%, 75%)" d="M750 119.2s-17.5-3.2-26-1.7-25.5 1.5-33.5 4.5-49.5 2.5-55.5 2.5-52-4.1-60.5-3.8c-8.5.3-76.5-5.5-86-3.8-9.5 1.7-34.5 4.2-43.5 3.7s-26-7-41-6.5-43.4 2.3-49.5 2.5-69-.5-77 .5-43-2.6-48-3c-5-.5-18-4.5-25-3.5s-63 4-71 4-45-1.5-52.5-1-54.5 4.9-64.5 3.9-16.4 0-16.4 0L0 279h750V119.2z"/><path fill="hsl(31, 74%, 71%)" d="M745 125h-72s-9.7-5-10.7-6.3c-1-1.3-9.3 3.2-9.3 3.2V120l-5.3-1.6s-6.3-1.1-7.3-2.1-9 0-9 0l-3.3 1.4-4-1.7h-6v-4h-3s-1.7-5.3-1.7-6.7c0-1.3-5.7-6.7-8-6.8-2.3-.2-14.7-.2-17 0-2.3.2-3.3 3.3-3.3 3.3l-3.3 14.6-16.4 7.1-43.2-2.1-28.3 5s-24.3 1.5-32.7 0c-5.9-1-35.3-1-40.3-.7-5 .3-31.3 0-39.3-1s-49.7 1.7-53.3 1.3-37.3-2-46 0c-8.5 2-40 1-45.7.7-5.7-.3-23.7-1-26-1.3-2.3-.4-51.3-16-61-13.6-9.7 2.3-48.7-.3-55.3 0s-37.7 3-48.3 2.6c-10.7-.3 4-3.9-27.7-4.7-12.6-.3-18 .1-18 .1V221l748 1.3 2-96.1-5.3-1.2z"/><path fill="hsl(32, 54%, 63%)" d="M750 135.6s-33.2-2.4-43-1.9-48.9.7-54.6 1.6-25.6.7-25.6.7H625l-18.5 2.8-67.2 2.2H504l-20.5-3.8-51-1.6-55.4-.7-3.2-1.4-2.6-.6-1.6-1.1-.5-.8-9.4-5H358s-5-4.6-6.1-5-4.4-.6-4.9-1.5-1-6.8-1-6.8.6-3.2.4-4.6-2.4-7-2.4-7.4v-2.8s.9-5.2.9-6.6-.9-2.1-1.8-2.2-5.1-1-5.1-1V86s-.4-2-2.1-2H333l-.6-1.6-11-.8s-.1 2.9-.6 3.4-2.5-.4-2.6.1 0 3.6 0 3.6-2.2.1-2.9 1.5-2.2 8.5-2.2 8.5-.2 1.5-.8 1.6-2-2.5-2-2.5-.2-7.6 0-9.1-1-3-1-3-1.6 2.6-1.6 3.5-.1 9.4 0 10-1.5 2.7-1.9 4.7.5 5.2.5 7-1.4 4.4-1.8 4.9-3.1 4.1-3.1 4.1l-8.5 5-1 2.1-9.5 6.2-2.9.1-1.4.4s-25.4.9-29 .9-29.6 1.4-31 1.8-25.8.5-28.2.5-82.2.7-87.9.3c-5.7-.3-17.7-6.6-26.7-6.9-9-.3-13.7 1.9-13.7 1.9l-9.7 4-13.5-5.9-38.5 3V279h750V135.6z"/><path fill="hsl(34, 44%, 57%)" d="M750 279s-.2-114.9-.2-121.8c0-2.5-34.5-1.8-38.7-2.1-10-.9-46-4.5-53.5-4s-36.6-1.1-42.2-1.7c-5.5-.6-20.1-6.2-20.1-6.2l-5.4-.5c-.7-.4-.7-2.1-3.9-2.9-2.5-.6-9.2-3-9.2-3s-.1-2.6-2.1-3.6-5.8-3.4-5.8-3.4l-.9-8.8-3.9-2.5s2.4-7.5 1.9-9.5-4.6-20.4-6.1-21.9-5.5-.8-5.5-.8L553 86s.7-2.5 0-3.2-4.9-1.5-4.9-1.5L547 80h-12l-1.9-.9-5.8.3s-.7 1.3-1.7 1.6-5.3.6-6.1 1c-.8.3-.5 1-.5 1h-4l.7 3.2s-4.8 2.1-5.5 2.2-.9 3-.9 3-5.7 2.3-6.2 2.8-1.1 6.8-1.1 6.8 1.4 1.7 1.2 2.8c-.2 1.2-1.7 3.2-1.8 3.6-.1.4-.9 7.8-.9 9s.9 7.2.9 8.8c0 1.6-11.7 10.2-12.4 10.7s-2.4.3-3.4.6-5.2 4.3-5.8 4.8-9.6 3.2-10.7 3.6c-1.1.3-3.2-.1-4.3.4s-8.3 4-10.9 4.3c-2.6.3-22.1.2-22.1.2l-.7.6s-38.4.8-43.1 1.8-42.7 4.7-50.3 4.7c-7.7 0-30-.3-36 0s-25.7-1.6-29-2.1c-3.3-.5-8 0-8 0s-28.3-3.2-35-3.9c-6.7-.7-27.7-1.7-32.7-1.7s-32.7 0-40.3 1.3C149 152 117 152 109.3 152s-27.7-3.1-35-1.7c-7.3 1.4-47.7 3.8-56.1 4.5s-15.3 0-15.3 0L.1 279"/><path fill="hsl(36, 38%, 54%)" d="M750 177.5c-13 0-55-2.5-62.5 0s-23.5 3.5-33 4-34 .5-51 0-75-5.7-82.5-5.1-94 2.3-105.5 2.7-72-1.4-87-2.8-66.5-1.3-74-3.3-20-4-27-6-18.5-10.8-22-12.1-7-2.4-10.5-5.4-5.3-23.7-5.5-25.3c-.2-1.7-.3-3-1.3-3.8-1-.8-3.3-.7-4.8-1.2s-1.7-4.2-4.8-5c-3.2-.8-7.4-1.2-9.4-1.1-2 .1-10.6-1.1-11.5-.8-.8.3-4.2-2.3-5.8-3.3-1.7-1-4.7-4.7-8.3-4.7s-26 1.7-28.7 1.5c-2.7-.2-45.5 0-49.2-1.5-3.7-1.5-5-2.5-8.2-2.5s-22.7-.2-28.2 0S0 104 0 104v175h750V177.5z"/><path fill="hsl(39, 38%, 44%)" d="M.1 190.2s5.4-7.8 7.2-8.6 28.5-10.9 28.5-10.9.4-1.6 1.6-3.3 12.6-5.1 12.6-5.1V160l12.2-3.2s1.9 0 1.9-1.5-2.2-5.2-2.4-7.8 2.8-11 2.5-14.8-3.2-3.7-3.5-6.7 2-21.2 3.5-22.8 5.2-12 6.7-13.2 10-4.2 12.3-4.2 10.5 5 15.5 5.2 13-1.5 17.5-.8S138 96 138 96l1.6-.2 5.4 3V112l1.5 7.5 1.4.8-1.4 6.5 4.2-1.5s2.4.2 2.4 1.2v3.5s5.5 2.5 6.5 2.2 1.6-12.2 1.6-12.2l.9-7.5V107l5-1v5s1.5 2.2 1.8 4-.9 15.4-.9 15.4l2.8 4.6s-.2 9.5 0 12 3.3 5.5 3.3 7.2 1.3 6.2 1.8 7.5 5.5 1.5 5.5 1.5 2.3 2.8 3 3.8 7 3.8 7 3.8l9.3 6.2 6.5 2s26.3 9.5 27 10.5 6.3 8.2 8.5 9 9-2.2 13-1.2 5.8 3.5 8.3 5.2 12.8 4.5 12.8 4.5 3.5 2.8 6.5 3 74.2-1.8 77.8-1.5 70.5.8 74.2.5 94.5 3.5 99.2 4 37.5.8 41.8 1.2 40.8 0 47.2 0 47.5-3 54-3.2 30.8-1.8 34.5-1.5 34.2-.5 38.2 0V279H0l.1-88.8z"/></svg>';
		
		
		
		/**
		 * Retro Banner 1
		 */
		$svg['retro_banner_1']['colors'] = array('#6A958C','#D44F1B','#E8EAE7');
		$svg['retro_banner_1']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['retro_banner_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 47.252" enable-background="new 0 0 200 47.252" xml:space="preserve"><path class="colorful c1" fill="'.$svg['retro_banner_1']['colors'][0].'" d="M10.942,26.065L2.731,9.368h41.466c2.267,0,4.104,1.837,4.104,4.106v27.094c0,2.271-1.838,4.106-4.104,4.106 H2.731L10.942,26.065z"/><path class="colorful c1" fill="'.$svg['retro_banner_1']['colors'][0].'" d="M189.805,27.977l8.211,16.697H156.55c-2.267,0-4.104-1.836-4.104-4.106V13.474 c0-2.27,1.838-4.106,4.104-4.106h41.466L189.805,27.977z"/><path class="colorful c1" fill="'.$svg['retro_banner_1']['colors'][0].'" d="M171.193,35.503c0,2.27-1.839,4.105-4.105,4.105H35.303c-2.268,0-4.106-1.836-4.106-4.105V8.409 c0-2.267,1.838-4.105,4.106-4.105h131.785c2.267,0,4.105,1.839,4.105,4.105V35.503z"/><path class="colorful c1" fill="'.$svg['retro_banner_1']['colors'][0].'" d="M170.373,33.861c0,2.27-1.838,4.105-4.106,4.105H34.48c-2.267,0-4.106-1.836-4.106-4.105V6.77 c0-2.271,1.84-4.109,4.106-4.109h131.786c2.269,0,4.106,1.839,4.106,4.109V33.861z"/><path class="colorful c3" fill="'.$svg['retro_banner_1']['colors'][2].'" d="M165.242,30.773c0,2.224-1.803,4.021-4.023,4.021H39.528c-2.221,0-4.022-1.797-4.022-4.021v-20.37 c0-2.221,1.802-4.021,4.022-4.021h121.691c2.221,0,4.023,1.8,4.023,4.021V30.773z"/><polygon class="colorful c2" fill="'.$svg['retro_banner_1']['colors'][1].'" points="47.413,14.729 48.799,18.997 53.285,18.997 49.655,21.63 51.043,25.901 47.413,23.26 43.783,25.901  45.169,21.63 41.54,18.997 46.025,18.997 "/><polygon class="colorful c2" fill="'.$svg['retro_banner_1']['colors'][1].'" points="153.334,14.729 154.722,18.997 159.207,18.997 155.579,21.63 156.963,25.901 153.334,23.26  149.705,25.901 151.092,21.63 147.461,18.997 151.947,18.997 "/></svg>';
		
		
		/**
		 * Retro Banner 2
		 */
		$svg['retro_banner_2']['colors'] = array();
		$svg['retro_banner_2']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['retro_banner_2']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 38.828" enable-background="new 0 0 200 38.828" xml:space="preserve"><linearGradient id="SVGID_1_" gradientUnits="userSpaceOnUse" x1="-173.6963" y1="220.3276" x2="-172.0142" y2="220.3276" gradientTransform="matrix(116.4189 0 0 -116.4189 20222.875 25670.1523)"> <stop offset="0" class="colorful c1" style="stop-color:#D44F1B"/> <stop offset="1" class="colorful c2" style="stop-color:#DC6F43"/></linearGradient><polygon fill="url(#SVGID_1_)" points="197.812,2.631 2.01,2.631 18.676,19.817 2.01,36.977 197.812,36.977 181.145,19.817 "/></svg>';
		
		
		
		
		/**
		 * Retro Banner 3
		 */
		$svg['retro_banner_3']['colors'] = array('#4D8270');
		$svg['retro_banner_3']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['retro_banner_3']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 154.212 153.48" enable-background="new 0 0 154.212 153.48" xml:space="preserve"><polygon fill="#6A958C" points="76.592,2.498 80.765,10.012 85.847,3.081 89.043,11.057 94.952,4.821 97.123,13.133 103.768,7.683  104.88,16.206 112.158,11.63 112.194,20.225 119.984,16.599 118.943,25.127 127.127,22.508 125.025,30.84 133.472,29.267  130.341,37.27 138.921,36.764 134.817,44.315 143.387,44.89 138.365,51.862 146.8,53.508 140.945,59.798 149.108,62.488  142.507,67.993 150.269,71.687 143.031,76.321 150.269,80.954 142.507,84.648 149.108,90.152 140.945,92.844 146.8,99.132  138.365,100.778 143.387,107.753 134.817,108.33 138.921,115.876 130.341,115.373 133.472,123.378 125.025,121.801 127.127,130.134  118.943,127.515 119.984,136.043 112.194,132.419 112.158,141.01 104.88,136.439 103.768,144.958 97.123,139.509 94.952,147.824  89.043,141.583 85.847,149.56 80.765,142.63 76.592,150.143 72.421,142.63 67.34,149.56 64.142,141.583 58.234,147.824  56.063,139.509 49.417,144.958 48.304,136.439 41.03,141.01 40.994,132.419 33.203,136.043 34.245,127.515 26.057,130.134  28.163,121.801 19.711,123.378 22.844,115.373 14.262,115.876 18.374,108.33 9.794,107.753 14.819,100.778 6.383,99.132  12.239,92.844 4.078,90.152 10.676,84.648 2.917,80.954 10.155,76.321 2.917,71.687 10.676,67.993 4.078,62.488 12.239,59.798  6.383,53.508 14.819,51.862 9.794,44.89 18.374,44.315 14.262,36.764 22.844,37.27 19.711,29.267 28.163,30.84 26.057,22.508  34.245,25.127 33.203,16.599 40.994,20.225 41.03,11.63 48.304,16.206 49.417,7.683 56.063,13.133 58.234,4.821 64.142,11.057  67.34,3.081 72.421,10.012 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M150.269,71.687l-7.762-3.694l6.601-5.504l-8.163-2.69l5.855-6.29l-8.436-1.646l5.022-6.972l-8.57-0.575 l4.104-7.551l-8.58,0.506l3.131-8.003l-8.447,1.573l2.103-8.332l-8.185,2.619l1.041-8.528l-7.79,3.626l-0.036-8.594l-7.277,4.575 l-1.112-8.523l-6.646,5.451l-2.171-8.312l-5.908,6.236l-3.196-7.976l-5.082,6.931l-4.173-7.514l-4.171,7.514L67.34,3.081 l-3.198,7.976l-5.908-6.236l-2.171,8.312l-6.646-5.451l-1.113,8.523L41.03,11.63l-0.036,8.594l-7.791-3.626l1.042,8.528 l-8.188-2.619l2.105,8.332l-8.451-1.573l3.133,8.003l-8.582-0.506l4.111,7.551L9.794,44.89l5.024,6.972l-8.436,1.646l5.855,6.29 l-8.161,2.69l6.599,5.504l-7.759,3.694l7.237,4.634l-7.237,4.633l7.759,3.694l-6.599,5.504l8.161,2.692l-5.855,6.288l8.436,1.646 l-5.024,6.976l8.579,0.576l-4.111,7.547l8.582-0.504l-3.133,8.006l8.451-1.577l-2.105,8.333l8.188-2.619l-1.042,8.528l7.791-3.624 l0.036,8.591l7.274-4.571l1.113,8.519l6.646-5.448l2.171,8.314l5.908-6.24l3.198,7.977l5.081-6.93l4.171,7.513l4.173-7.513 l5.082,6.93l3.196-7.977l5.908,6.24l2.171-8.314l6.646,5.448l1.112-8.519l7.277,4.571l0.036-8.591l7.79,3.624l-1.041-8.528 l8.185,2.619l-2.103-8.333l8.447,1.577l-3.131-8.006l8.58,0.504l-4.104-7.547l8.57-0.576l-5.022-6.976l8.436-1.646l-5.855-6.288 l8.163-2.692l-6.601-5.504l7.762-3.694l-7.238-4.633L150.269,71.687z M146.747,80.734c-2.29,1.088-7.39,3.516-7.39,3.516 s4.338,3.619,6.284,5.243c-2.406,0.794-7.771,2.562-7.771,2.562s3.847,4.133,5.576,5.988c-2.49,0.485-8.033,1.568-8.033,1.568 s3.301,4.582,4.784,6.639c-2.531,0.172-8.165,0.549-8.165,0.549s2.699,4.961,3.909,7.189c-2.529-0.148-8.168-0.482-8.168-0.482 s2.059,5.262,2.979,7.623c-2.491-0.463-8.043-1.502-8.043-1.502s1.382,5.479,1.999,7.934c-2.414-0.771-7.794-2.493-7.794-2.493 s0.687,5.604,0.997,8.122c-2.301-1.069-7.422-3.452-7.422-3.452s-0.024,5.647-0.036,8.184c-2.144-1.351-6.927-4.356-6.927-4.356 s-0.729,5.6-1.061,8.113c-1.961-1.608-6.325-5.189-6.325-5.189s-1.427,5.465-2.066,7.917c-1.746-1.841-5.629-5.94-5.629-5.94 s-2.099,5.242-3.045,7.596c-1.494-2.045-4.835-6.602-4.835-6.602s-2.743,4.938-3.975,7.156c-1.232-2.218-3.97-7.156-3.97-7.156 s-3.343,4.557-4.839,6.602c-0.946-2.354-3.045-7.596-3.045-7.596s-3.885,4.1-5.626,5.94c-0.641-2.452-2.069-7.917-2.069-7.917 s-4.365,3.584-6.327,5.189c-0.328-2.512-1.06-8.113-1.06-8.113s-4.78,3.006-6.928,4.356c-0.013-2.536-0.034-8.184-0.034-8.184 s-5.119,2.383-7.419,3.452c0.306-2.518,0.992-8.122,0.992-8.122s-5.379,1.723-7.794,2.493c0.621-2.454,2.003-7.931,2.003-7.931 s-5.556,1.036-8.047,1.499c0.925-2.361,2.982-7.623,2.982-7.623s-5.64,0.334-8.171,0.482c1.212-2.229,3.912-7.189,3.912-7.189 s-5.635-0.377-8.164-0.549c1.481-2.057,4.782-6.639,4.782-6.639s-5.543-1.083-8.031-1.568c1.727-1.855,5.576-5.988,5.576-5.988 s-5.364-1.768-7.773-2.562c1.947-1.624,6.283-5.243,6.283-5.243s-5.098-2.428-7.388-3.516c2.136-1.367,6.891-4.413,6.891-4.413 s-4.755-3.046-6.891-4.414c2.29-1.088,7.388-3.514,7.388-3.514s-4.336-3.62-6.283-5.244c2.409-0.794,7.773-2.562,7.773-2.562 s-3.85-4.134-5.576-5.988c2.488-0.486,8.031-1.567,8.031-1.567s-3.301-4.585-4.782-6.642c2.529-0.17,8.164-0.549,8.164-0.549 s-2.7-4.96-3.912-7.187c2.531,0.148,8.171,0.479,8.171,0.479s-2.058-5.259-2.982-7.621c2.491,0.464,8.047,1.5,8.047,1.5 s-1.382-5.477-2.003-7.932c2.415,0.772,7.794,2.494,7.794,2.494s-0.687-5.605-0.992-8.122c2.3,1.069,7.419,3.453,7.419,3.453 s0.021-5.647,0.034-8.183c2.147,1.349,6.928,4.354,6.928,4.354s0.731-5.599,1.06-8.112c1.962,1.607,6.327,5.187,6.327,5.187 s1.429-5.462,2.069-7.916c1.741,1.842,5.626,5.942,5.626,5.942s2.099-5.242,3.045-7.596c1.496,2.046,4.839,6.601,4.839,6.601 s2.737-4.939,3.97-7.157c1.231,2.218,3.975,7.157,3.975,7.157s3.341-4.555,4.835-6.601c0.946,2.354,3.045,7.596,3.045,7.596 s3.883-4.101,5.629-5.942c0.64,2.454,2.066,7.916,2.066,7.916s4.364-3.58,6.325-5.187c0.332,2.513,1.061,8.112,1.061,8.112 s4.783-3.005,6.927-4.354c0.012,2.535,0.036,8.183,0.036,8.183s5.121-2.383,7.422-3.453c-0.311,2.517-0.997,8.122-0.997,8.122 s5.38-1.722,7.794-2.494c-0.617,2.456-1.999,7.932-1.999,7.932s5.552-1.035,8.043-1.5c-0.921,2.362-2.979,7.621-2.979,7.621 s5.639-0.332,8.168-0.479c-1.21,2.227-3.909,7.187-3.909,7.187s5.634,0.379,8.165,0.549c-1.483,2.057-4.784,6.642-4.784,6.642 s5.543,1.081,8.033,1.567c-1.729,1.854-5.576,5.988-5.576,5.988s5.364,1.767,7.771,2.562c-1.946,1.624-6.284,5.244-6.284,5.244 s5.1,2.426,7.39,3.514c-2.136,1.368-6.891,4.414-6.891,4.414S144.611,79.367,146.747,80.734z"/><polygon fill="#89AAA3" points="14.79,51.865 17.743,53.023 12.942,46.411 9.749,44.924 "/><polygon fill="#89AAA3" points="12.21,59.804 15.286,60.582 9.695,54.624 6.34,53.55 "/><polygon fill="#89AAA3" points="10.647,68.003 13.797,68.39 7.501,63.179 4.04,62.534 "/><polygon fill="#89AAA3" points="10.126,76.334 13.298,76.323 6.4,71.944 2.883,71.736 "/><polygon fill="#89AAA3" points="10.651,84.664 13.797,84.256 6.405,80.775 2.89,81.011 "/><polygon fill="#89AAA3" points="12.219,92.863 15.286,92.066 7.515,89.537 4.059,90.209 "/><polygon fill="#89AAA3" points="14.797,100.801 17.745,99.623 9.719,98.093 6.372,99.191 "/><polygon fill="#89AAA3" points="18.352,108.354 21.127,106.816 12.973,106.302 9.79,107.812 "/><polygon fill="#89AAA3" points="22.826,115.4 25.388,113.528 17.234,114.038 14.265,115.937 "/><polygon fill="#89AAA3" points="28.148,121.83 30.454,119.652 22.427,121.179 19.72,123.435 "/><polygon fill="#89AAA3" points="34.235,127.544 36.249,125.093 28.478,127.617 26.073,130.193 "/><polygon fill="#89AAA3" points="40.987,132.449 42.678,129.765 35.286,133.24 33.226,136.097 "/><polygon fill="#89AAA3" points="48.302,136.469 49.646,133.593 42.745,137.969 41.059,141.062 "/><polygon fill="#89AAA3" points="56.065,139.539 57.036,136.521 50.738,141.726 49.452,145.005 "/><polygon fill="#89AAA3" points="64.149,141.614 64.735,138.498 59.141,144.451 58.275,147.865 "/><polygon fill="#89AAA3" points="72.43,142.66 72.623,139.494 67.816,146.101 67.386,149.597 "/><polygon fill="#89AAA3" points="80.779,142.657 80.57,139.492 76.629,146.65 76.646,150.175 "/><polygon fill="#89AAA3" points="89.058,141.609 88.458,138.498 85.447,146.091 85.902,149.584 "/><polygon fill="#89AAA3" points="97.141,139.532 96.155,136.519 94.119,144.431 95.009,147.84 "/><polygon fill="#89AAA3" points="104.901,136.459 103.544,133.593 102.518,141.697 103.828,144.969 "/><polygon fill="#89AAA3" points="112.215,132.437 110.51,129.764 110.507,137.932 112.215,141.014 "/><polygon fill="#89AAA3" points="118.971,127.531 116.942,125.092 117.962,133.195 120.042,136.041 "/><polygon fill="#89AAA3" points="125.053,121.816 122.737,119.649 124.763,127.562 127.186,130.125 "/><polygon fill="#89AAA3" points="130.373,115.382 127.802,113.525 130.808,121.123 133.53,123.358 "/><polygon fill="#89AAA3" points="134.843,108.333 132.059,106.813 135.993,113.972 138.976,115.851 "/><polygon fill="#89AAA3" points="138.398,100.781 135.445,99.621 140.243,106.232 143.435,107.722 "/><polygon fill="#89AAA3" points="140.976,92.841 137.9,92.06 143.49,98.019 146.843,99.095 "/><polygon fill="#89AAA3" points="142.539,84.642 139.388,84.252 145.68,89.462 149.146,90.112 "/><polygon fill="#89AAA3" points="143.061,76.312 139.889,76.319 146.784,80.699 150.302,80.908 "/><polygon fill="#89AAA3" points="142.537,67.98 139.388,68.386 146.778,71.869 150.295,71.635 "/><polygon fill="#89AAA3" points="140.97,59.783 137.9,60.577 145.667,63.106 149.127,62.434 "/><polygon fill="#89AAA3" points="138.389,51.844 135.443,53.02 143.464,54.553 146.814,53.454 "/><polygon fill="#89AAA3" points="134.835,44.291 132.056,45.827 140.209,46.342 143.397,44.833 "/><polygon fill="#89AAA3" points="130.361,37.244 127.799,39.115 135.952,38.606 138.921,36.707 "/><polygon fill="#89AAA3" points="125.04,30.813 122.732,32.99 130.758,31.464 133.467,29.209 "/><polygon fill="#89AAA3" points="118.955,25.1 116.937,27.551 124.707,25.029 127.113,22.451 "/><polygon fill="#89AAA3" points="112.199,20.193 110.505,22.878 117.9,19.403 119.961,16.543 "/><polygon fill="#89AAA3" points="104.885,16.174 103.54,19.05 110.44,14.675 112.128,11.58 "/><polygon fill="#89AAA3" points="97.123,13.104 96.15,16.123 102.449,10.919 103.734,7.637 "/><polygon fill="#89AAA3" points="89.039,11.028 88.449,14.148 94.044,8.195 94.911,4.776 "/><polygon fill="#89AAA3" points="80.755,9.984 80.563,13.152 85.37,6.544 85.799,3.046 "/><polygon fill="#89AAA3" points="72.411,9.984 72.618,13.153 76.556,5.995 76.542,2.468 "/><polygon fill="#89AAA3" points="64.125,11.032 64.728,14.148 67.739,6.553 67.288,3.058 "/><polygon fill="#89AAA3" points="56.043,13.11 57.032,16.125 59.065,8.213 58.178,4.802 "/><polygon fill="#89AAA3" points="48.283,16.183 49.641,19.053 50.667,10.948 49.36,7.674 "/><polygon fill="#89AAA3" points="40.967,20.207 42.675,22.883 42.678,14.712 40.97,11.628 "/><polygon fill="#89AAA3" points="34.218,25.112 36.247,27.553 35.223,19.448 33.142,16.604 "/><polygon fill="#89AAA3" points="28.133,30.828 30.454,32.995 28.423,25.083 26,22.521 "/><polygon fill="#89AAA3" points="22.811,37.261 25.385,39.119 22.379,31.523 19.656,29.285 "/><polygon fill="#89AAA3" points="18.34,44.31 21.127,45.831 17.192,38.672 14.211,36.794 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M119.815,33.099C108.27,21.555,92.924,15.198,76.592,15.198c-33.702,0-61.124,27.418-61.124,61.119 c0,33.705,27.422,61.128,61.124,61.128c33.703,0,61.124-27.423,61.124-61.128C137.716,59.993,131.358,44.644,119.815,33.099z"/><path fill="#6A958C" d="M76.592,16.707c-32.927,0-59.613,26.692-59.613,59.61c0,32.929,26.687,59.617,59.613,59.617 c32.925,0,59.614-26.688,59.614-59.617C136.207,43.399,109.517,16.707,76.592,16.707z M115.154,114.885 c-10.304,10.298-23.995,15.97-38.562,15.97c-30.074,0-54.536-24.457-54.536-54.538c0-30.068,24.462-54.528,54.536-54.528 c14.566,0,28.258,5.67,38.562,15.967c10.302,10.305,15.966,23.998,15.966,38.561C131.12,90.89,125.456,104.583,115.154,114.885z"/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M135.089,76.317c0,32.311-26.195,58.501-58.497,58.501c-32.308,0-58.5-26.19-58.5-58.501 c0-32.304,26.192-58.492,58.5-58.492C108.894,17.825,135.089,44.013,135.089,76.317z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="86.931,48.903 84.239,48.036 91.64,29.305 "/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="83.412,47.822 80.639,47.299 85.63,27.789 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M105.717,78.097c-0.981,16.09-14.814,28.331-30.902,27.35c-16.088-0.982-28.331-14.82-27.346-30.91 c0.979-16.087,14.816-28.33,30.903-27.346C94.458,48.176,106.704,62.011,105.717,78.097z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="79.787,47.194 76.971,47.025 79.481,27.044 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M105.711,74.432c1.043,16.084-11.146,29.967-27.235,31.008c-16.081,1.04-29.962-11.153-31.002-27.237 c-1.043-16.085,11.151-29.964,27.237-31.006C90.792,46.156,104.676,58.35,105.711,74.432z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="76.109,47.025 73.3,47.209 73.278,27.07 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M105.245,70.8c3.052,15.824-7.303,31.124-23.129,34.174c-15.827,3.047-31.125-7.312-34.175-23.137 c-3.055-15.826,7.309-31.125,23.136-34.176C86.898,44.617,102.202,54.974,105.245,70.8z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="72.443,47.317 69.677,47.852 67.131,27.874 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M104.333,67.25c5.004,15.315-3.353,31.8-18.669,36.804c-15.319,5.01-31.799-3.35-36.806-18.668 c-5.01-15.316,3.346-31.798,18.667-36.806C82.845,43.572,99.322,51.931,104.333,67.25z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="68.841,48.068 66.161,48.94 61.136,29.44 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M102.973,63.846c6.892,14.567,0.667,31.964-13.906,38.855c-14.567,6.889-31.971,0.661-38.854-13.911 c-6.887-14.569-0.66-31.964,13.906-38.853C78.693,43.047,96.089,49.274,102.973,63.846z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="65.359,49.261 62.81,50.466 55.383,31.748 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M101.203,60.637c8.662,13.59,4.666,31.63-8.927,40.292c-13.592,8.66-31.636,4.662-40.293-8.933 c-8.657-13.588-4.659-31.629,8.932-40.29C74.502,43.047,92.546,47.046,101.203,60.637z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="62.059,50.883 59.681,52.395 49.961,34.757 "/><circle class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" cx="76.595" cy="76.318" r="29.182"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="58.988,52.904 56.815,54.705 44.966,38.423 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M96.533,55.011c11.767,11.01,12.381,29.477,1.367,41.246c-11.012,11.769-29.471,12.382-41.246,1.37 c-11.768-11.009-12.379-29.478-1.371-41.248C66.295,44.611,84.765,43.998,96.533,55.011z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="56.186,55.296 54.266,57.354 40.466,42.685 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M93.703,52.676c13.06,9.451,15.979,27.696,6.534,40.752c-9.452,13.054-27.7,15.978-40.749,6.528 c-13.06-9.447-15.981-27.692-6.532-40.75C62.405,46.155,80.649,43.228,93.703,52.676z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="53.712,58.018 52.065,60.302 36.534,47.48 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M90.607,50.721c14.135,7.74,19.323,25.474,11.584,39.609c-7.737,14.137-25.473,19.326-39.607,11.587 c-14.139-7.741-19.327-25.476-11.586-39.611C58.739,48.167,76.469,42.98,90.607,50.721z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="51.607,61.029 50.249,63.506 33.236,52.729 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M87.285,49.166c15.002,5.905,22.368,22.85,16.464,37.844c-5.906,15.001-22.852,22.366-37.846,16.463 c-14.997-5.909-22.365-22.854-16.459-37.848C55.353,50.631,72.292,43.262,87.285,49.166z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="49.887,64.283 48.851,66.905 30.62,58.348 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M83.802,48.039c15.62,3.98,25.049,19.867,21.068,35.485c-3.976,15.619-19.862,25.052-35.487,21.074 c-15.613-3.983-25.048-19.87-21.064-35.487C52.295,53.493,68.182,44.061,83.802,48.039z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="48.584,67.728 47.893,70.459 28.731,64.254 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M80.201,47.358c15.992,1.994,27.347,16.571,25.351,32.562c-1.993,15.994-16.57,27.349-32.564,25.355 c-15.994-1.991-27.341-16.574-25.354-32.562C49.623,56.72,64.205,45.366,80.201,47.358z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="47.729,71.303 47.384,74.101 27.594,70.347 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M76.542,47.137c16.116-0.031,29.203,13.013,29.236,29.128c0.024,16.115-13.017,29.203-29.131,29.231 C60.529,105.529,47.44,92.488,47.412,76.37C47.384,60.253,60.425,47.164,76.542,47.137z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="47.327,74.963 47.336,77.782 27.229,76.538 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M72.881,47.371c15.988-2.047,30.612,9.254,32.657,25.237c2.05,15.986-9.249,30.606-25.239,32.656 c-15.981,2.048-30.607-9.253-32.65-25.237C45.602,64.043,56.901,49.424,72.881,47.371z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="47.394,78.642 47.747,81.437 27.652,82.72 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M69.287,48.068c15.604-4.04,31.525,5.336,35.559,20.94c4.034,15.605-5.341,31.527-20.944,35.561 c-15.6,4.035-31.527-5.342-35.56-20.942C44.311,68.021,53.684,52.102,69.287,48.068z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="47.912,82.281 48.618,85.009 28.839,88.804 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M65.806,49.207c14.969-5.962,31.942,1.348,37.902,16.318c5.961,14.977-1.352,31.947-16.324,37.908 c-14.974,5.955-31.945-1.353-37.902-16.322C43.519,72.133,50.829,55.165,65.806,49.207z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="48.887,85.83 49.925,88.449 30.781,94.693 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M62.488,50.769C76.6,42.98,94.355,48.104,102.14,62.214c7.785,14.111,2.669,31.86-11.442,39.653 c-14.107,7.788-31.86,2.664-39.651-11.447C43.26,76.312,48.384,58.56,62.488,50.769z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="50.292,89.226 51.66,91.695 33.443,100.291 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M59.397,52.74c13.021-9.496,31.28-6.638,40.777,6.383c9.495,13.023,6.638,31.277-6.388,40.773 c-13.02,9.491-31.273,6.634-40.771-6.384C43.519,80.49,46.38,62.236,59.397,52.74z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="52.121,92.423 53.78,94.702 36.789,105.511 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M56.579,55.08c11.73-11.053,30.196-10.504,41.255,1.224c11.053,11.729,10.506,30.198-1.222,41.25 c-11.73,11.055-30.206,10.506-41.252-1.221C44.301,84.602,44.848,66.134,56.579,55.08z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="54.334,95.361 56.263,97.416 40.763,110.268 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M54.076,57.759c10.254-12.438,28.646-14.21,41.079-3.961c12.434,10.251,14.209,28.644,3.959,41.081 c-10.254,12.437-28.646,14.207-41.083,3.96C45.597,88.583,43.827,70.193,54.076,57.759z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="56.894,98.002 59.072,99.796 45.296,114.488 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M51.929,60.728c8.607-13.626,26.631-17.688,40.258-9.08c13.621,8.614,17.687,26.641,9.071,40.261 C92.649,105.53,74.625,109.595,61,100.987C47.384,92.371,43.317,74.349,51.929,60.728z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="59.77,100.299 62.155,101.806 50.329,118.11 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M50.168,63.94c6.83-14.596,24.213-20.886,38.803-14.052c14.597,6.84,20.886,24.212,14.045,38.807 c-6.83,14.594-24.203,20.886-38.802,14.049C49.623,95.908,43.331,78.531,50.168,63.94z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="62.904,102.22 65.458,103.416 55.772,121.075 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M48.827,67.35C53.78,52.013,70.224,43.592,85.56,48.548c15.335,4.951,23.758,21.402,18.805,36.738 c-4.952,15.335-21.403,23.754-36.739,18.804C52.286,99.136,43.873,82.687,48.827,67.35z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="66.264,103.732 68.946,104.598 61.547,123.33 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M47.921,70.899C50.911,55.067,66.175,44.65,82.01,47.642c15.837,2.993,26.253,18.257,23.259,34.094 c-2.992,15.834-18.254,26.25-34.094,23.255C55.34,102,44.928,86.738,47.921,70.899z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="69.778,104.81 72.546,105.335 67.56,124.845 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M47.469,74.537c0.979-16.087,14.822-28.333,30.903-27.349c16.086,0.987,28.331,14.823,27.345,30.909 c-0.976,16.09-14.818,28.331-30.902,27.35C58.723,104.461,46.487,90.626,47.469,74.537z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="73.401,105.44 76.214,105.612 73.707,125.599 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M47.474,78.203c-1.043-16.084,11.151-29.966,27.237-31.009c16.081-1.038,29.965,11.156,31,27.238 c1.043,16.084-11.149,29.967-27.235,31.008C62.391,106.478,48.514,94.287,47.474,78.203z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="77.077,105.612 79.89,105.427 79.91,125.568 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M47.941,81.837c-3.055-15.823,7.309-31.129,23.136-34.176c15.821-3.045,31.125,7.312,34.168,23.138 c3.055,15.823-7.303,31.126-23.129,34.174C66.289,108.021,50.991,97.662,47.941,81.837z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="80.744,105.32 83.515,104.782 86.054,124.763 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M48.859,85.386c-5.01-15.316,3.346-31.8,18.667-36.806c15.319-5.009,31.796,3.351,36.808,18.67 c5.009,15.315-3.353,31.8-18.669,36.804C70.34,109.064,53.866,100.705,48.859,85.386z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="84.348,104.57 87.03,103.693 92.052,123.196 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M50.212,88.79c-6.89-14.569-0.66-31.97,13.906-38.853c14.574-6.886,31.971-0.662,38.854,13.909 c6.892,14.567,0.667,31.964-13.906,38.855C74.495,109.587,57.102,103.362,50.212,88.79z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="87.828,103.375 90.377,102.169 97.809,120.889 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M51.983,91.997c-8.66-13.588-4.659-31.63,8.932-40.292c13.588-8.657,31.632-4.659,40.288,8.933 c8.662,13.59,4.666,31.636-8.927,40.292C78.679,109.589,60.649,105.587,51.983,91.997z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="91.125,101.753 93.506,100.237 103.226,117.882 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M54.143,94.96c-10.3-12.398-8.589-30.803,3.812-41.097c12.395-10.292,30.792-8.587,41.092,3.812 c10.296,12.399,8.59,30.799-3.81,41.093C82.836,109.066,64.439,107.357,54.143,94.96z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="94.204,99.73 96.372,97.928 108.224,114.214 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M56.654,97.626c-11.768-11.009-12.379-29.479-1.371-41.248c11.013-11.768,29.482-12.381,41.25-1.368 c11.767,11.01,12.375,29.477,1.367,41.246C86.888,108.025,68.429,108.636,56.654,97.626z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="97.002,97.344 98.926,95.28 112.726,109.95 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M59.488,99.957c-13.064-9.447-15.981-27.695-6.532-40.75c9.449-13.052,27.693-15.979,40.747-6.53 c13.06,9.451,15.979,27.698,6.529,40.752C90.781,106.482,72.537,109.404,59.488,99.957z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="99.478,94.619 101.127,92.333 116.658,105.157 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M62.583,101.917c-14.139-7.741-19.327-25.476-11.586-39.613c7.741-14.135,25.472-19.323,39.609-11.583 c14.135,7.735,19.318,25.474,11.584,39.609C94.451,104.466,76.718,109.655,62.583,101.917z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="101.583,91.605 102.942,89.132 119.952,99.908 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M65.903,103.473c-14.997-5.909-22.369-22.854-16.459-37.848c5.909-14.994,22.848-22.364,37.841-16.459 c15.002,5.905,22.368,22.85,16.464,37.847C97.838,102.005,80.897,109.373,65.903,103.473z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="103.31,88.352 104.341,85.725 122.571,94.29 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M69.383,104.598c-15.613-3.98-25.048-19.87-21.064-35.491c3.977-15.614,19.863-25.047,35.483-21.069 s25.049,19.87,21.068,35.488C100.892,99.143,85.003,108.572,69.383,104.598z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="104.601,84.909 105.299,82.178 124.461,88.383 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M72.987,105.276c-15.994-1.991-27.347-16.574-25.354-32.565c1.989-15.991,16.571-27.345,32.567-25.353 c15.992,1.989,27.347,16.573,25.351,32.565C103.558,95.917,88.981,107.269,72.987,105.276z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="105.463,81.332 105.808,78.531 125.593,82.291 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M76.648,105.497C60.529,105.53,47.44,92.488,47.412,76.37c-0.027-16.117,13.014-29.206,29.131-29.232 c16.116-0.031,29.203,13.016,29.232,29.128C105.803,92.38,92.762,105.468,76.648,105.497z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="105.859,77.674 105.856,74.853 125.955,76.099 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M80.299,105.264c-15.981,2.051-30.607-9.249-32.65-25.241c-2.047-15.979,9.252-30.599,25.232-32.652 c15.988-2.049,30.612,9.254,32.657,25.242C107.585,88.597,96.29,103.214,80.299,105.264z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="105.798,73.996 105.44,71.197 125.541,69.918 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M83.901,104.57c-15.6,4.039-31.527-5.338-35.556-20.946c-4.034-15.603,5.339-31.521,20.941-35.555 c15.604-4.04,31.525,5.343,35.559,20.943C108.879,84.617,99.5,100.533,83.901,104.57z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="105.279,70.356 104.573,67.626 124.348,63.836 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M87.384,103.433c-14.974,5.957-31.945-1.353-37.902-16.324c-5.963-14.976,1.347-31.944,16.324-37.902 c14.966-5.962,31.942,1.348,37.902,16.321C109.669,80.503,102.357,97.472,87.384,103.433z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="104.303,66.808 103.262,64.183 122.412,57.946 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M90.698,101.867c-14.107,7.789-31.86,2.665-39.651-11.447c-7.786-14.107-2.662-31.86,11.441-39.651 c14.107-7.789,31.867-2.662,39.652,11.448S104.809,94.074,90.698,101.867z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="102.896,63.408 101.531,60.937 119.745,52.346 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M93.787,99.897c-13.015,9.497-31.273,6.636-40.771-6.386c-9.497-13.02-6.636-31.275,6.381-40.771 c13.021-9.498,31.28-6.636,40.777,6.383C109.669,72.147,106.812,90.401,93.787,99.897z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="101.071,60.212 99.408,57.935 116.404,47.131 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M96.612,97.554C84.886,108.61,66.406,108.06,55.36,96.329C44.308,84.602,44.848,66.134,56.579,55.08 s30.203-10.504,41.255,1.227C108.886,68.036,108.339,86.501,96.612,97.554z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="98.859,57.273 96.924,55.22 112.429,42.369 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M99.114,94.878c-10.244,12.439-28.646,14.211-41.083,3.957c-12.434-10.25-14.204-28.643-3.955-41.077 C64.323,45.32,82.721,43.551,95.155,53.8C107.591,64.053,109.364,82.441,99.114,94.878z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="96.296,54.631 94.117,52.84 107.889,38.145 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M101.258,91.909c-8.606,13.627-26.633,17.69-40.258,9.075c-13.616-8.609-17.684-26.635-9.071-40.256 C60.537,47.101,78.56,43.04,92.187,51.65C105.808,60.264,109.87,78.289,101.258,91.909z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="93.425,52.333 91.036,50.826 102.862,34.523 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M103.016,88.695c-6.83,14.596-24.203,20.889-38.802,14.047C49.623,95.908,43.331,78.531,50.168,63.94 c6.83-14.596,24.213-20.886,38.803-14.047C103.568,56.73,109.857,74.101,103.016,88.695z"/><polygon class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" points="90.284,50.415 87.728,49.219 97.418,31.562 "/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M104.365,85.286c-4.952,15.338-21.403,23.757-36.739,18.8C52.291,99.136,43.873,82.687,48.827,67.35 c4.953-15.337,21.4-23.753,36.733-18.8C100.895,53.502,109.315,69.95,104.365,85.286z"/><path class="colorful c1" fill="'.$svg['retro_banner_3']['colors'][0].'" d="M105.269,81.736c-2.992,15.834-18.254,26.25-34.094,23.252C55.345,102,44.928,86.738,47.921,70.899 C50.911,55.067,66.175,44.65,82.01,47.647C97.85,50.64,108.258,65.899,105.269,81.736z"/><path fill="#52716A" d="M70.479,41.633c-2.387-6.977-5.097-14.123-8.273-21.513c2.216,7.64,3.958,14.971,5.391,22.108 C68.549,41.997,69.506,41.787,70.479,41.633z M66.161,42.586c-3.211-6.579-6.73-13.277-10.633-20.11 c2.984,7.192,5.572,14.189,7.855,21.041C64.294,43.169,65.216,42.861,66.161,42.586z M83.778,18.605 c-0.693,8.072-1.759,15.625-3.049,22.866c0.994,0.129,1.97,0.315,2.938,0.523C84.014,34.562,84.113,26.834,83.778,18.605z M74.883,41.228c-1.516-7.261-3.34-14.747-5.678-22.59c1.339,7.966,2.182,15.509,2.727,22.81 C72.91,41.333,73.89,41.263,74.883,41.228z M79.3,41.352c-0.595-7.414-1.475-15.1-2.857-23.237 c0.354,8.119,0.256,15.737-0.117,23.076C77.311,41.199,78.301,41.263,79.3,41.352z M61.999,44.111 c-3.968-6.1-8.24-12.269-12.786-18.495c3.686,6.685,7.063,13.261,10.157,19.744C60.226,44.905,61.104,44.495,61.999,44.111z M45.38,58.657c-6.66-2.531-13.603-4.949-20.894-7.209c6.824,3.153,13.326,6.401,19.54,9.744 C44.453,60.33,44.889,59.479,45.38,58.657z M47.963,54.933c-6.292-3.372-12.86-6.666-19.692-9.881 c6.251,4.035,12.268,8.103,18.005,12.22C46.807,56.464,47.37,55.687,47.963,54.933z M43.317,62.708 c-6.936-1.66-14.151-3.157-21.795-4.404c7.282,2.186,14.164,4.556,20.744,7.066C42.57,64.461,42.94,63.579,43.317,62.708z M50.955,51.559c-5.824-4.149-11.923-8.257-18.205-12.33c5.612,4.805,11.053,9.611,16.223,14.432 C49.601,52.93,50.272,52.237,50.955,51.559z M54.317,48.593c-5.28-4.864-10.82-9.723-16.534-14.566 c4.977,5.497,9.784,10.976,14.321,16.433C52.823,49.812,53.548,49.18,54.317,48.593z M58.039,46.118 c-4.659-5.522-9.608-11.074-14.746-16.636c4.335,6.125,8.461,12.195,12.304,18.211C56.39,47.134,57.2,46.609,58.039,46.118z M95.809,47.114c3.082-6.719,6.062-13.739,8.923-21.088c-3.756,6.813-7.58,13.333-11.476,19.538 C94.137,46.044,94.984,46.563,95.809,47.114z M110.76,68.08c6.826-2.819,13.805-5.961,20.969-9.538 c-7.509,2.646-14.752,4.836-21.828,6.716C110.228,66.186,110.514,67.123,110.76,68.08z M111.575,72.4 c7.125-1.956,14.462-4.233,22.086-7.012c-7.85,1.803-15.322,3.105-22.575,4.104C111.292,70.45,111.454,71.42,111.575,72.4z M111.635,81.214c7.344-0.132,14.967-0.529,23.062-1.389c-8.056-0.157-15.59-0.727-22.84-1.541 C111.816,79.257,111.753,80.232,111.635,81.214z M111.872,76.801c7.301-1.056,14.847-2.411,22.803-4.282 c-8.037,0.862-15.605,1.239-22.914,1.337C111.844,74.829,111.869,75.81,111.872,76.801z M109.434,63.896 c6.416-3.63,12.925-7.574,19.527-11.852c-7.054,3.4-13.951,6.432-20.725,9.159C108.667,62.084,109.079,62.978,109.434,63.896z M105.242,56.229c5.324-5.081,10.664-10.46,15.999-16.019c-5.976,4.786-11.914,9.375-17.819,13.675 C104.064,54.641,104.669,55.423,105.242,56.229z M41.798,66.995c-7.088-0.76-14.46-1.312-22.298-1.509 c7.612,1.172,14.754,2.633,21.604,4.28C41.298,68.822,41.534,67.907,41.798,66.995z M99.34,49.744 c3.893-6.25,7.729-12.795,11.505-19.573c-4.592,6.144-9.201,12.083-13.839,17.719C97.813,48.471,98.586,49.1,99.34,49.744z M91.054,20.127c-1.772,7.832-3.8,15.181-6,22.203c0.967,0.25,1.933,0.52,2.866,0.844C89.208,35.862,90.292,28.238,91.054,20.127z M102.497,52.803c4.648-5.702,9.271-11.697,13.867-17.869c-5.331,5.47-10.652,10.769-15.966,15.77 C101.122,51.378,101.83,52.072,102.497,52.803z M107.564,59.941c5.916-4.385,11.888-9.08,17.886-14.014 c-6.541,4.103-13.008,7.935-19.389,11.465C106.596,58.216,107.094,59.072,107.564,59.941z M91.987,44.913 c2.206-7.079,4.267-14.466,6.104-22.274c-2.804,7.39-5.757,14.39-8.84,21.062C90.183,44.069,91.096,44.47,91.987,44.913z M91.606,109.177c3.852,5.891,7.976,11.845,12.367,17.852c-3.582-6.494-6.872-12.883-9.888-19.182 C93.274,108.32,92.454,108.771,91.606,109.177z M87.42,110.858c3.103,6.321,6.496,12.753,10.237,19.312 c-2.884-6.934-5.384-13.68-7.605-20.297C89.188,110.236,88.313,110.563,87.42,110.858z M95.538,106.985 c4.548,5.37,9.355,10.771,14.355,16.179c-4.241-5.984-8.275-11.919-12.043-17.801C97.101,105.933,96.33,106.473,95.538,106.985z M78.555,112.634c1.466,6.881,3.216,13.967,5.425,21.373c-1.273-7.561-2.093-14.738-2.643-21.693 C80.422,112.451,79.498,112.572,78.555,112.634z M99.138,104.294c5.195,4.782,10.646,9.562,16.264,14.324 c-4.921-5.432-9.666-10.843-14.156-16.232C100.57,103.052,99.859,103.683,99.138,104.294z M83.057,112.031 c2.304,6.653,4.896,13.463,7.918,20.494c-2.112-7.29-3.791-14.293-5.188-21.119C84.895,111.659,83.975,111.848,83.057,112.031z M105.254,97.73c6.284,3.363,12.834,6.651,19.655,9.861c-6.279-4.054-12.326-8.141-18.09-12.28 C106.324,96.136,105.811,96.95,105.254,97.73z M102.388,101.198c5.78,4.112,11.822,8.184,18.046,12.218 c-5.603-4.797-11.027-9.594-16.187-14.406C103.655,99.767,103.041,100.498,102.388,101.198z M110.821,85.587 c7.263,0.793,14.821,1.367,22.863,1.568c-7.864-1.21-15.232-2.727-22.292-4.443C111.231,83.683,111.055,84.649,110.821,85.587z M40.624,72.462c0.048-0.344,0.133-0.675,0.183-1.018c-7.113,0.146-14.495,0.544-22.319,1.374 c7.744,0.149,15.012,0.684,22.006,1.448C40.535,73.665,40.551,73.067,40.624,72.462z M107.598,93.909 c6.72,2.56,13.728,5.003,21.096,7.289c-6.925-3.2-13.518-6.497-19.808-9.893C108.494,92.195,108.055,93.059,107.598,93.909z M73.994,112.619c0.593,7.011,1.445,14.256,2.746,21.91c-0.333-7.67-0.263-14.889,0.058-21.851 C75.87,112.697,74.935,112.677,73.994,112.619z M109.464,89.842c7.051,1.696,14.404,3.226,22.196,4.497 c-7.479-2.246-14.524-4.684-21.259-7.27C110.125,88.013,109.811,88.936,109.464,89.842z M42.6,89.402 c-6.043,3.449-12.171,7.172-18.381,11.197c6.617-3.19,13.094-6.051,19.458-8.645C43.292,91.115,42.919,90.269,42.6,89.402z M41.302,85.031c-6.468,2.699-13.074,5.689-19.845,9.074c7.062-2.492,13.898-4.577,20.577-6.383 C41.757,86.837,41.515,85.939,41.302,85.031z M46.855,97.455c-4.968,4.777-9.945,9.797-14.917,14.98 c5.562-4.454,11.096-8.735,16.586-12.771C47.941,98.949,47.389,98.211,46.855,97.455z M69.46,112.054 c-0.298,7.004-0.37,14.267-0.058,21.982c0.65-7.584,1.635-14.707,2.823-21.551c-0.198-0.02-0.391-0.02-0.59-0.045 C70.898,112.349,70.181,112.191,69.46,112.054z M40.551,80.542c-6.8,1.889-13.775,4.075-21.031,6.715 c7.424-1.704,14.504-2.957,21.391-3.937C40.744,82.405,40.643,81.474,40.551,80.542z M40.361,75.986 c-7.009,1.037-14.243,2.35-21.854,4.141c7.667-0.824,14.912-1.202,21.915-1.322C40.371,77.869,40.334,76.936,40.361,75.986z M44.46,93.568c-5.537,4.137-11.123,8.535-16.73,13.146c6.103-3.823,12.135-7.41,18.099-10.744 C45.337,95.191,44.889,94.384,44.46,93.568z M62.125,132.511c1.653-7.314,3.536-14.204,5.571-20.807 c-0.915-0.221-1.811-0.477-2.692-0.765C63.836,117.804,62.838,124.942,62.125,132.511z M60.736,109.228 c-2.027,6.623-3.933,13.516-5.642,20.777c2.611-6.89,5.357-13.43,8.21-19.691C62.432,109.979,61.57,109.625,60.736,109.228z M53.014,104.236c-3.608,5.848-7.167,11.941-10.681,18.237c4.268-5.709,8.539-11.237,12.849-16.513 C54.433,105.417,53.722,104.833,53.014,104.236z M56.72,106.965c-2.849,6.283-5.607,12.823-8.267,19.651 c3.491-6.334,7.041-12.414,10.654-18.227C58.29,107.947,57.497,107.47,56.72,106.965z M51.66,103.007 c-0.674-0.635-1.331-1.279-1.955-1.963c-4.316,5.344-8.607,10.924-12.89,16.664C41.775,112.625,46.72,107.697,51.66,103.007z"/><polygon fill="#6A958C" points="86.785,43.308 83.554,42.483 90.917,19.902 "/><polygon fill="#6A958C" points="82.567,42.289 79.262,41.872 83.74,18.551 "/><polygon fill="#6A958C" points="78.254,41.816 74.931,41.816 76.443,18.115 "/><polygon fill="#6A958C" points="73.913,41.88 70.617,42.296 69.148,18.593 "/><polygon fill="#6A958C" points="69.62,42.484 66.401,43.312 61.971,19.981 "/><polygon fill="#6A958C" points="65.433,43.626 62.342,44.85 55.023,22.259 "/><polygon fill="#6A958C" points="61.424,45.282 58.512,46.886 48.414,25.387 "/><polygon fill="#6A958C" points="57.653,47.427 54.96,49.384 42.254,29.322 "/><polygon fill="#6A958C" points="54.18,50.03 51.756,52.306 36.632,33.996 "/><polygon fill="#6A958C" points="51.06,53.045 48.943,55.609 31.646,39.336 "/><polygon fill="#6A958C" points="48.345,56.429 46.568,59.235 27.361,45.26 "/><polygon fill="#6A958C" points="46.075,60.127 44.665,63.135 23.856,51.676 "/><polygon fill="#6A958C" points="44.282,64.079 43.26,67.239 21.184,58.48 "/><polygon fill="#6A958C" points="43.003,68.224 42.387,71.49 19.388,65.565 "/><polygon fill="#6A958C" points="42.258,72.498 42.047,75.816 18.487,72.818 "/><polygon fill="#6A958C" points="42.047,76.83 42.258,80.147 18.506,80.127 "/><polygon fill="#6A958C" points="42.387,81.156 43.003,84.421 19.439,87.378 "/><polygon fill="#6A958C" points="43.26,85.405 44.287,88.569 21.277,94.456 "/><polygon fill="#6A958C" points="44.665,89.513 46.079,92.515 23.987,101.242 "/><polygon fill="#6A958C" points="46.568,93.408 48.345,96.215 27.527,107.638 "/><polygon fill="#6A958C" points="48.943,97.035 51.065,99.599 31.84,113.544 "/><polygon fill="#6A958C" points="51.756,100.337 54.184,102.612 36.854,118.856 "/><polygon fill="#6A958C" points="54.96,103.259 57.653,105.213 42.501,123.5 "/><polygon fill="#6A958C" points="58.512,105.761 61.429,107.361 48.685,127.402 "/><polygon fill="#6A958C" points="62.342,107.792 65.433,109.017 55.307,130.499 "/><polygon fill="#6A958C" points="66.401,109.332 69.62,110.159 62.261,132.737 "/><polygon fill="#6A958C" points="70.617,110.349 73.913,110.763 69.446,134.089 "/><polygon fill="#6A958C" points="74.931,110.828 78.254,110.827 76.74,134.529 "/><polygon fill="#6A958C" points="79.267,110.768 82.567,110.345 84.036,134.052 "/><polygon fill="#6A958C" points="83.564,110.159 86.785,109.332 91.211,132.665 "/><polygon fill="#6A958C" points="87.75,109.017 90.842,107.792 98.158,130.386 "/><polygon fill="#6A958C" points="91.76,107.361 94.673,105.757 104.77,127.259 "/><polygon fill="#6A958C" points="95.528,105.213 98.216,103.259 110.929,123.325 "/><polygon fill="#6A958C" points="99,102.612 101.421,100.337 116.548,118.652 "/><polygon fill="#6A958C" points="102.121,99.599 104.241,97.035 121.538,113.308 "/><polygon fill="#6A958C" points="104.835,96.215 106.616,93.406 125.82,107.386 "/><polygon fill="#6A958C" points="107.106,92.515 108.52,89.508 129.323,100.969 "/><polygon fill="#6A958C" points="108.897,88.568 109.92,85.403 131.997,94.164 "/><polygon fill="#6A958C" points="110.175,84.419 110.797,81.152 133.799,87.08 "/><polygon fill="#6A958C" points="110.929,80.144 111.136,76.829 134.697,79.826 "/><polygon fill="#6A958C" points="110.803,71.49 110.175,68.22 133.742,65.266 "/><polygon fill="#6A958C" points="109.92,67.237 108.894,64.074 131.902,58.189 "/><polygon fill="#6A958C" points="108.52,63.133 107.106,60.122 129.197,51.401 "/><polygon fill="#6A958C" points="106.616,59.233 104.835,56.424 125.659,45.006 "/><polygon fill="#6A958C" points="104.241,55.605 102.118,53.042 121.346,39.101 "/><polygon fill="#6A958C" points="101.421,52.306 99,50.03 116.327,33.786 "/><polygon fill="#6A958C" points="98.216,49.378 95.528,47.424 110.684,29.142 "/><polygon fill="#6A958C" points="94.673,46.879 91.756,45.277 104.5,25.241 "/><polygon fill="#6A958C" points="90.842,44.845 87.746,43.624 97.876,22.146 "/><path fill="#6A958C" d="M111.668,72.498c0.125,0.989,0.136,1.987,0.179,2.992l22.827-2.974L111.668,72.498z"/><path fill="#EDEEED" d="M76.597,31.493c-24.759,0-44.831,20.068-44.831,44.824c0,24.765,20.072,44.833,44.831,44.833 c24.758,0,44.824-20.068,44.824-44.833C121.421,51.561,101.355,31.493,76.597,31.493z M105.596,105.32 c-7.749,7.748-18.046,12.012-28.999,12.012c-22.618,0-41.013-18.395-41.013-41.015c0-22.611,18.395-41.004,41.013-41.004 c10.953,0,21.25,4.263,28.999,12.008c7.749,7.748,12.01,18.045,12.01,28.996C117.606,87.277,113.345,97.574,105.596,105.32z"/><path fill="#E8EAE7" d="M120.583,76.317c0,24.298-19.696,43.993-43.986,43.993c-24.296,0-43.992-19.695-43.992-43.993 c0-24.292,19.696-43.987,43.992-43.987C100.887,32.33,120.583,52.025,120.583,76.317z"/><path fill="#6A958C" d="M110.498,76.319c0,18.724-15.18,33.904-33.9,33.904c-18.723,0-33.902-15.18-33.902-33.904 c0-18.721,15.18-33.9,33.902-33.9C95.318,42.419,110.498,57.599,110.498,76.319z"/><path fill="#6A958C" d="M99.878,51.679c5.723,6.072,9.808,14.23,9.808,23.232c0,18.725-15.175,33.902-33.9,33.902 c-9.001,0-17.424-3.274-23.49-9.001c6.184,6.554,15.181,10.41,24.899,10.41c18.719,0,33.9-15.18,33.9-33.904 C111.095,66.601,106.43,57.86,99.878,51.679z"/></svg>';
		
		
		
		/**
		 * Retro Banner 4
		 */
		$svg['retro_banner_4']['colors'] = array('#4D8270','#6A958C','#E8EAE7');
		$svg['retro_banner_4']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['retro_banner_4']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 150.549 150.916" enable-background="new 0 0 150.549 150.916" xml:space="preserve"><path fill-rule="evenodd" clip-rule="evenodd" class="colorful c1" fill="'.$svg['retro_banner_4']['colors'][0].'" d="M75.389,148.12c-39.974,0-72.614-32.646-72.614-72.628 c0-39.969,32.641-72.616,72.614-72.616c39.968,0,72.623,32.647,72.623,72.616C148.012,115.473,115.357,148.12,75.389,148.12z"/><path fill-rule="evenodd" clip-rule="evenodd" class="colorful c2" fill="'.$svg['retro_banner_4']['colors'][1].'" d="M75.389,20.5c30.901,0,56.036,25.148,56.036,55.867 c0,30.906-25.135,56.044-56.036,56.044c-30.893,0-56.034-25.138-56.034-56.044C19.355,45.649,44.497,20.5,75.389,20.5z"/><polygon fill-rule="evenodd" clip-rule="evenodd" class="colorful c3" fill="'.$svg['retro_banner_4']['colors'][2].'" points="75.389,34.47 86.038,65.19 118.507,65.89 92.663,85.444  102.095,116.512 75.389,98.012 48.676,116.512 58.109,85.444 32.273,65.89 64.736,65.19 "/></svg>';
		
		
		
		
		/**
		 * Best in Town
		 */
		$svg['best_in_town']['colors'] = array('#F39424','#BE202E','#F3EDD6');
		$svg['best_in_town']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['best_in_town']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 165.568 152.015" enable-background="new 0 0 165.568 152.015" xml:space="preserve"><g> <rect x="-237.687" y="-219.828" fill="none" width="634.488" height="451.141"/></g><g> <path class="colorful c2" fill="'.$svg['best_in_town']['colors'][1].'" d="M104.448,38.598c0,0-59.784-23.158-84.67-11.205C-5.111,39.346,2.224,55.53,16.769,77.401 c14.546,21.871,39.975,72.037,69.277,53.707c19.08-11.934,15.699-9.895,15.699-9.895l36.43,28.463l-21.902-37.682l39.179-29.801 C155.451,82.194,188.233,63.75,104.448,38.598z"/></g><g> <path class="colorful c1" fill="'.$svg['best_in_town']['colors'][0].'" d="M45.074,35.59c0,0-25.41,17.754-0.081,25.721c25.327,7.969,77.459,7.447,83.655,0.266 c6.195-7.184,4.845-13.705,0.062-19.893c-4.781-6.188-12.977-17.531-12.977-17.531l21.332-21.882l-31.014,10.912 C106.051,13.182,91.477-5.535,45.074,35.59z"/></g><g> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M53.28,33.547c0.143-0.629,0.527-0.943,1.155-0.943h7.699c0.513,0,0.955,0.191,1.326,0.574l1.069,1.312 c0.342,0.355,0.471,0.793,0.385,1.312L63.288,44.7c-0.085,0.438-0.313,0.82-0.685,1.148l-2.48,2.008l1.625,1.887 c0.342,0.41,0.47,0.848,0.385,1.312l-1.753,9.553c-0.086,0.438-0.314,0.82-0.685,1.148l-1.925,1.557 c-0.342,0.301-0.784,0.451-1.326,0.451h-7.57c-0.77,0-1.083-0.369-0.941-1.106L53.28,33.547z M54.435,49.579l-2.01,10.824h2.994 l1.026-0.82l1.668-9.184l-0.684-0.82H54.435z M59.054,45.479l1.583-8.774l-0.684-0.82h-2.994l-1.925,10.414h2.994L59.054,45.479z" /> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M72.783,62.822c-0.143,0.628-0.527,0.942-1.155,0.942h-8.083c-0.77,0-1.083-0.369-0.941-1.106l5.346-29.11 c0.143-0.629,0.527-0.943,1.155-0.943h7.998c0.77,0,1.083,0.369,0.941,1.107l-0.214,1.312c-0.143,0.628-0.527,0.942-1.155,0.942 h-5.047l-1.925,10.332h4.106c0.77,0,1.083,0.369,0.941,1.106l-0.214,1.312c-0.143,0.629-0.527,0.943-1.155,0.943h-4.277 l-2.01,10.742h4.961c0.77,0,1.083,0.369,0.941,1.107L72.783,62.822z"/> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M89.805,40.682c-0.143,0.628-0.527,0.942-1.154,0.942h-1.969c-0.77,0-1.083-0.369-0.94-1.106l0.685-3.813 l-0.685-0.82h-1.497l-1.026,0.82l-1.583,8.774l0.686,0.819h3.207c0.57,0,1.012,0.191,1.326,0.574l1.111,1.312 c0.343,0.355,0.471,0.793,0.386,1.312l-2.054,11.111c-0.085,0.438-0.312,0.82-0.684,1.148l-1.925,1.557 c-0.343,0.301-0.784,0.451-1.326,0.451h-4.918c-0.513,0-0.955-0.191-1.326-0.574l-1.069-1.312 c-0.342-0.354-0.471-0.792-0.385-1.312l0.898-4.838c0.143-0.629,0.527-0.943,1.155-0.943h1.967c0.77,0,1.083,0.369,0.941,1.107 l-0.684,3.771l0.684,0.82h1.711l1.026-0.82l1.669-9.184l-0.686-0.82h-3.207c-0.57,0-1.012-0.191-1.326-0.574l-1.112-1.312 c-0.342-0.355-0.471-0.792-0.385-1.312l1.968-10.701c0.085-0.437,0.313-0.819,0.684-1.147l1.925-1.559 c0.342-0.301,0.783-0.451,1.325-0.451h4.705c0.513,0,0.955,0.191,1.325,0.574l1.07,1.312c0.342,0.355,0.47,0.793,0.385,1.312 L89.805,40.682z"/> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M103.491,32.604c0.771,0,1.084,0.369,0.941,1.107l-0.214,1.23c-0.143,0.628-0.527,0.942-1.155,0.942h-2.908 l-4.961,26.938c-0.143,0.628-0.527,0.942-1.154,0.942h-1.968c-0.771,0-1.083-0.369-0.94-1.106l4.918-26.773h-2.737 c-0.771,0-1.083-0.368-0.94-1.106l0.213-1.23c0.143-0.629,0.527-0.943,1.155-0.943H103.491z"/></g><g opacity="0.5"> <path fill="#2A1F13" d="M70.777,71.555c0.797,0,1.121,0.381,0.974,1.146l-0.221,1.272c-0.147,0.65-0.546,0.977-1.195,0.977h-3.01 l-5.135,27.879c-0.148,0.651-0.546,0.977-1.195,0.977h-2.036c-0.797,0-1.122-0.382-0.974-1.146l5.091-27.71h-2.833 c-0.797,0-1.122-0.382-0.974-1.146l0.222-1.272c0.147-0.65,0.546-0.976,1.195-0.976H70.777z"/> <path fill="#2A1F13" d="M82.639,71.555c0.531,0,0.989,0.197,1.373,0.594l1.106,1.357c0.354,0.368,0.487,0.82,0.398,1.358 l-4.692,25.673c-0.088,0.453-0.324,0.849-0.708,1.188l-1.992,1.612c-0.354,0.311-0.812,0.467-1.372,0.467h-5.754 c-0.531,0-0.989-0.198-1.373-0.594l-1.106-1.358c-0.354-0.368-0.487-0.82-0.398-1.358l4.692-25.672 c0.089-0.453,0.325-0.85,0.708-1.188l1.992-1.612c0.354-0.312,0.812-0.467,1.373-0.467H82.639z M77.948,75.035l-1.062,0.849 l-4.338,23.594l0.708,0.849h2.435l1.062-0.849l4.338-23.594l-0.708-0.849H77.948z"/> <path fill="#2A1F13" d="M111.102,71.555c0.413,0,0.709,0.105,0.885,0.318c0.178,0.212,0.192,0.502,0.045,0.869l-9.562,30.172 c-0.177,0.594-0.59,0.891-1.239,0.891h-3.63c-0.767,0-1.121-0.367-1.062-1.104l2.612-26.055l-7.039,26.268 c-0.177,0.594-0.59,0.891-1.239,0.891h-3.807c-0.797,0-1.165-0.367-1.106-1.104l1.549-30.129c0.029-0.679,0.398-1.018,1.107-1.018 h2.213c0.768,0,1.106,0.367,1.018,1.104l-2.479,26.775l7.835-26.988c0.177-0.594,0.591-0.891,1.239-0.891h3.188 c0.768,0,1.121,0.367,1.062,1.104l-2.08,26.775l7.392-26.988c0.177-0.594,0.591-0.891,1.239-0.891H111.102z"/> <path fill="#2A1F13" d="M112.473,102.829c-0.146,0.651-0.545,0.977-1.195,0.977h-1.637c-0.797,0-1.122-0.382-0.975-1.146 l5.533-30.129c0.147-0.65,0.546-0.976,1.195-0.976h2.479c0.709,0,1.092,0.354,1.151,1.061l0.708,21.303l3.939-21.388 c0.148-0.65,0.547-0.976,1.195-0.976h1.639c0.797,0,1.121,0.381,0.973,1.146l-5.533,30.128c-0.146,0.651-0.545,0.977-1.195,0.977 h-2.479c-0.708,0-1.092-0.354-1.15-1.061l-0.753-20.963L112.473,102.829z"/></g><g> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M34.87,88.698c-0.095,0.42-0.353,0.631-0.773,0.631H32.78c-0.516,0-0.725-0.247-0.63-0.74l3.578-19.479 c0.096-0.421,0.353-0.631,0.773-0.631h1.317c0.515,0,0.725,0.247,0.63,0.741L34.87,88.698z"/> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M39.249,88.698c-0.096,0.42-0.353,0.631-0.773,0.631h-1.059c-0.516,0-0.725-0.247-0.63-0.74l3.578-19.479 c0.096-0.421,0.353-0.631,0.773-0.631h1.603c0.458,0,0.706,0.229,0.744,0.686l0.458,13.772l2.548-13.827 c0.095-0.421,0.353-0.631,0.773-0.631h1.059c0.515,0,0.725,0.247,0.63,0.741l-3.578,19.479c-0.096,0.42-0.354,0.631-0.773,0.631 h-1.603c-0.458,0-0.706-0.229-0.745-0.686L41.768,75.09L39.249,88.698z"/></g><g> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M67.875,69.015c0.797,0,1.122,0.382,0.974,1.146l-0.221,1.273c-0.147,0.65-0.546,0.977-1.195,0.977h-3.01 l-5.135,27.879c-0.148,0.65-0.546,0.977-1.195,0.977h-2.036c-0.797,0-1.122-0.383-0.974-1.146l5.091-27.709H57.34 c-0.797,0-1.122-0.383-0.974-1.146l0.222-1.273c0.147-0.65,0.546-0.976,1.195-0.976H67.875z"/> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M79.738,69.015c0.531,0,0.989,0.198,1.372,0.595l1.107,1.357c0.354,0.367,0.486,0.82,0.398,1.357 l-4.693,25.674c-0.088,0.452-0.325,0.848-0.708,1.188l-1.992,1.613c-0.354,0.311-0.812,0.467-1.372,0.467h-5.754 c-0.531,0-0.989-0.199-1.373-0.595l-1.106-1.358c-0.354-0.367-0.487-0.82-0.398-1.357l4.692-25.673 c0.089-0.452,0.325-0.849,0.708-1.188l1.992-1.612c0.354-0.312,0.812-0.467,1.373-0.467H79.738z M75.046,72.495l-1.062,0.85 l-4.338,23.594l0.708,0.848h2.435l1.062-0.848l4.338-23.594l-0.708-0.85H75.046z"/> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M108.2,69.015c0.414,0,0.709,0.106,0.886,0.318s0.192,0.502,0.044,0.87l-9.561,30.171 c-0.178,0.595-0.59,0.892-1.24,0.892H94.7c-0.768,0-1.121-0.368-1.062-1.104l2.611-26.055l-7.038,26.267 c-0.177,0.595-0.591,0.892-1.239,0.892h-3.807c-0.797,0-1.166-0.368-1.107-1.104l1.55-30.129c0.029-0.679,0.397-1.019,1.106-1.019 h2.213c0.768,0,1.107,0.368,1.019,1.104l-2.479,26.776l7.836-26.988c0.177-0.594,0.59-0.892,1.239-0.892h3.187 c0.768,0,1.121,0.368,1.062,1.104l-2.08,26.776l7.393-26.988c0.177-0.594,0.59-0.892,1.239-0.892H108.2z"/> <path class="colorful c3" fill="'.$svg['best_in_town']['colors'][2].'" d="M109.572,100.29c-0.147,0.65-0.546,0.977-1.195,0.977h-1.638c-0.797,0-1.121-0.383-0.975-1.146 l5.533-30.129c0.148-0.65,0.547-0.976,1.195-0.976h2.479c0.708,0,1.092,0.354,1.151,1.062l0.707,21.302l3.94-21.388 c0.147-0.65,0.546-0.976,1.194-0.976h1.639c0.797,0,1.121,0.382,0.974,1.146l-5.533,30.129c-0.147,0.65-0.546,0.977-1.195,0.977 h-2.479c-0.708,0-1.093-0.354-1.151-1.062l-0.752-20.962L109.572,100.29z"/></g></svg>';
		
		
		
		
		/**
		 * Round Pin
		 */
		$svg['rond_pin']['colors'] = array();
		$svg['rond_pin']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['rond_pin']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><g> <g> <g> <g> <path fill="#14120D" d="M199.498,99.98c0,2.133-3.945,4.123-4.081,6.223c-0.138,2.124,3.516,4.607,3.245,6.693 c-0.275,2.109-4.445,3.572-4.854,5.635c-0.411,2.088,2.886,5.025,2.344,7.061c-0.55,2.053-4.876,2.954-5.554,4.951 c-0.682,2.01,2.199,5.357,1.393,7.307c-0.814,1.961-5.219,2.285-6.152,4.178c-0.943,1.901,1.478,5.597,0.42,7.425 c-1.062,1.835-5.473,1.581-6.649,3.337c-1.176,1.76,0.738,5.741-0.551,7.416c-1.289,1.678-5.63,0.854-7.024,2.443 c-1.397,1.592-0.015,5.787-1.512,7.283c-1.496,1.496-5.691,0.114-7.283,1.508c-1.588,1.396-0.764,5.738-2.441,7.025 c-1.678,1.289-5.656-0.629-7.416,0.551c-1.758,1.174-1.503,5.586-3.338,6.647c-1.828,1.058-5.524-1.36-7.426-0.422 c-1.892,0.935-2.217,5.339-4.177,6.153c-1.948,0.809-5.296-2.075-7.306-1.393c-1.996,0.678-2.897,5.002-4.951,5.551 c-2.033,0.544-4.973-2.754-7.059-2.34c-2.064,0.408-3.527,4.576-5.637,4.853c-2.086,0.271-4.566-3.38-6.691-3.245 c-2.099,0.137-4.09,4.078-6.221,4.078c-2.132,0-4.123-3.941-6.22-4.078c-2.125-0.135-4.608,3.516-6.694,3.242 c-2.109-0.273-3.572-4.441-5.636-4.85c-2.085-0.414-5.024,2.884-7.06,2.34c-2.052-0.549-2.954-4.875-4.951-5.553 c-2.01-0.682-5.357,2.201-7.306,1.391c-1.96-0.811-2.287-5.217-4.178-6.152c-1.901-0.938-5.598,1.479-7.425,0.421 c-1.835-1.06-1.581-5.473-3.336-6.647c-1.76-1.178-5.741,0.738-7.417-0.551c-1.679-1.29-0.853-5.631-2.442-7.025 c-1.591-1.396-5.787-0.014-7.282-1.51c-1.497-1.497-0.115-5.691-1.51-7.282c-1.396-1.589-5.735-0.765-7.025-2.444 c-1.289-1.676,0.626-5.654-0.552-7.414c-1.175-1.758-5.585-1.504-6.647-3.338c-1.057-1.83,1.361-5.523,0.422-7.424 c-0.935-1.895-5.34-2.219-6.153-4.18c-0.808-1.947,2.074-5.295,1.391-7.305c-0.676-1.996-5.002-2.898-5.549-4.949 c-0.544-2.036,2.752-4.974,2.341-7.059c-0.409-2.066-4.578-3.527-4.853-5.637c-0.272-2.084,3.381-4.568,3.244-6.693 c-0.136-2.098-4.08-4.088-4.08-6.221c0-2.131,3.944-4.122,4.08-6.219c0.137-2.126-3.517-4.607-3.244-6.695 c0.274-2.109,4.444-3.57,4.853-5.636c0.413-2.087-2.884-5.024-2.341-7.059c0.549-2.054,4.873-2.954,5.551-4.949 c0.682-2.012-2.2-5.359-1.391-7.307c0.812-1.96,5.218-2.287,6.153-4.179c0.939-1.9-1.479-5.598-0.421-7.426 c1.061-1.834,5.471-1.581,6.647-3.335c1.178-1.762-0.736-5.742,0.552-7.417c1.29-1.679,5.629-0.853,7.024-2.443 c1.396-1.592,0.014-5.787,1.51-7.281c1.496-1.498,5.691-0.115,7.283-1.512c1.59-1.395,0.763-5.733,2.442-7.023 c1.676-1.291,5.656,0.627,7.417-0.55c1.756-1.177,1.5-5.589,3.336-6.648c1.827-1.059,5.524,1.359,7.426,0.421 c1.892-0.936,2.217-5.341,4.177-6.153c1.948-0.81,5.295,2.074,7.306,1.391c1.996-0.678,2.896-5.002,4.949-5.552 c2.036-0.543,4.975,2.754,7.061,2.342c2.064-0.411,3.525-4.578,5.635-4.854c2.085-0.271,4.568,3.381,6.693,3.244 c2.098-0.136,4.088-4.078,6.22-4.078c2.133,0,4.124,3.942,6.221,4.078c2.125,0.137,4.607-3.515,6.693-3.244 c2.109,0.276,3.571,4.443,5.638,4.854c2.085,0.412,5.023-2.885,7.06-2.34c2.053,0.548,2.953,4.874,4.949,5.55 c2.012,0.683,5.359-2.199,7.309-1.391c1.957,0.812,2.284,5.219,4.176,6.153c1.902,0.939,5.6-1.479,7.428-0.42 c1.834,1.061,1.579,5.47,3.336,6.647c1.76,1.178,5.74-0.737,7.416,0.55c1.68,1.292,0.854,5.632,2.443,7.026 c1.59,1.397,5.787,0.015,7.282,1.511c1.497,1.496,0.114,5.691,1.511,7.282c1.395,1.59,5.734,0.764,7.023,2.443 c1.289,1.675-0.625,5.655,0.552,7.416c1.177,1.756,5.586,1.503,6.647,3.337c1.057,1.828-1.361,5.523-0.422,7.426 c0.936,1.892,5.34,2.216,6.153,4.177c0.809,1.948-2.074,5.296-1.39,7.306c0.675,1.996,5,2.898,5.55,4.952 c0.544,2.033-2.755,4.972-2.344,7.059c0.411,2.064,4.579,3.525,4.854,5.634c0.271,2.087-3.383,4.568-3.245,6.695 C195.553,95.859,199.498,97.849,199.498,99.98z"/> </g> </g> </g> <g> <g> <g> <path fill="#FFFFFF" d="M100.578,190.262c-49.782,0-90.281-40.5-90.281-90.282c0-49.78,40.499-90.28,90.281-90.28 c49.781,0,90.28,40.5,90.28,90.28C190.858,149.762,150.359,190.262,100.578,190.262z M100.578,11.499 c-48.789,0-88.483,39.692-88.483,88.481c0,48.79,39.694,88.483,88.483,88.483s88.482-39.693,88.482-88.483 C189.061,51.191,149.367,11.499,100.578,11.499z"/> </g> </g> </g> <circle fill="#FFFFFF" cx="100.578" cy="99.98" r="85.679"/></g></svg>';
		
		
		/**
		 * Quality Guaranteed
		 */
		$svg['quality_guaranteed']['colors'] = array();
		$svg['quality_guaranteed']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['quality_guaranteed']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><g> <g> <g> <g> <polygon fill-rule="evenodd" clip-rule="evenodd" fill="#FFFFFF" points="196.687,101.88 100.752,162.594 4.819,102.084  99.616,37.626 "/> </g> </g> <g> <g> <path fill="#13110C" d="M100.753,163.872L2.846,102.117l96.761-65.793l99.069,65.576L100.753,163.872z M6.792,102.051 l93.959,59.263l93.946-59.453L99.624,38.928L6.792,102.051z"/> </g> </g> </g> <g> <g> <g> <path fill="#13110C" d="M100.751,157.756l-0.144-0.091l-88.365-55.734l0.341-0.233l87.124-59.24l0.15,0.1l89.41,59.184 l-0.353,0.222L100.751,157.756z M13.228,101.913l87.523,55.203l87.521-55.386L99.71,43.107L13.228,101.913z"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="167.284" cy="101.898" r="2.489"/> </g> </g> </g> <g> <g> <g> <path fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" d="M32.936,102.615c0,1.376-1.114,2.492-2.489,2.492 c-1.376,0-2.49-1.116-2.49-2.492c0-1.373,1.114-2.489,2.49-2.489C31.822,100.126,32.936,101.242,32.936,102.615z"/> </g> </g> </g> <g> <g> <g> <path d="M68.865,124.094c-0.493,0.39-1.226,0.652-1.833,0.652c-1.752,0-2.256-1.626-2.256-3.092c0-1.444,0.526-3.08,2.233-3.08 c0.801,0,1.5,0.469,1.912,1.145l-0.653,0.423c-0.287-0.479-0.722-0.847-1.305-0.847c-1.181,0-1.386,1.477-1.386,2.381 c0,0.93,0.205,2.348,1.408,2.348c0.39,0,0.779-0.102,1.111-0.308v-1.569h-1.431v-0.688h2.199V124.094z"/> </g> </g> <g> <g> <path d="M73.311,118.676v4.066c0,0.871,0.252,1.281,1.042,1.281c0.961,0,1.168-0.423,1.168-1.281v-4.066h0.766v4.434 c0,0.789-0.561,1.637-1.877,1.637c-1.294,0-1.868-0.812-1.868-1.684v-4.387H73.311z"/> </g> </g> <g> <g> <path d="M80.917,123.017l-0.562,1.775l-0.755-0.275l1.878-5.841h0.984l1.878,5.841l-0.756,0.275l-0.55-1.775H80.917z M81.972,119.57l-0.849,2.761h1.696L81.972,119.57z"/> </g> </g> <g> <g> <path d="M87.802,118.676h2.027c0.997,0,1.786,0.471,1.786,1.626c0,0.733-0.49,1.455-1.212,1.673l1.465,2.417l-0.664,0.4 l-1.523-2.702h-1.11v2.553h-0.769V118.676z M89.578,121.401c0.744,0,1.237-0.423,1.237-1.1c0-0.537-0.321-0.938-1.008-0.938 h-1.235v2.038H89.578z"/> </g> </g> <g> <g> <path d="M96.039,123.017l-0.561,1.775l-0.755-0.275l1.879-5.841h0.983l1.879,5.841l-0.756,0.275l-0.549-1.775H96.039z M97.094,119.57l-0.847,2.761h1.694L97.094,119.57z"/> </g> </g> <g> <g> <path d="M102.662,118.676h0.95l2.313,5.029l0.022-0.023l-0.069-1.547v-3.459h0.77v5.967h-0.952l-2.314-5.027l-0.021,0.023 l0.069,1.558v3.446h-0.768V118.676z"/> </g> </g> <g> <g> <path d="M111.849,119.363h-1.647v-0.688h4.029v0.688h-1.614v5.279h-0.768V119.363z"/> </g> </g> <g> <g> <path d="M118.138,118.676h3.724v0.688h-2.955v1.787h2.439v0.687h-2.439v2.118h2.955v0.688h-3.724V118.676z"/> </g> </g> <g> <g> <path d="M125.699,118.676h3.724v0.688h-2.955v1.787h2.439v0.687h-2.439v2.118h2.955v0.688h-3.724V118.676z"/> </g> </g> <g> <g> <path d="M132.826,118.676h1.992c1.695,0,2.463,0.698,2.463,2.91c0,1.866-0.321,3.057-2.463,3.057h-1.992v-0.688h0.619v-4.592 h-0.619V118.676z M134.212,123.955h0.812c1.008,0,1.455-0.571,1.455-2.289c0-1.832-0.526-2.303-1.478-2.303h-0.79V123.955z"/> </g> </g> </g> <g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="63.583" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="67.14" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="70.698" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="74.256" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="77.813" cy="111.333" r="0.702"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="81.371" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="84.93" cy="111.333" r="0.702"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="88.487" cy="111.333" r="0.702"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="92.044" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="95.603" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="99.161" cy="111.333" r="0.702"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="102.719" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="106.277" cy="111.333" r="0.702"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="109.836" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="113.395" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="116.953" cy="111.333" r="0.702"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="120.511" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="124.069" cy="111.333" r="0.702"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="127.628" cy="111.333" r="0.703"/> </g> </g> </g> <g> <g> <g> <circle fill-rule="evenodd" clip-rule="evenodd" fill="#13110C" cx="131.186" cy="111.333" r="0.703"/> </g> </g> </g> </g> <g> <path d="M83.793,110.599c-2.447,3.514-6.684,2.165-15.533-4.425c-1.412,0.502-2.856,0.69-4.206,0.564 c-5.24-0.471-8.001-5.051-6.684-12.489c1.82-9.947,10.732-12.959,14.749-10.889c1.13,0.597-2.228,1.067-2.385,0.91 c-3.044-2.918-8.44,3.075-9.665,9.916c-0.784,4.299-0.25,7.94,1.506,9.948c0.094-0.188,0.251-0.438,0.471-0.69 c0.91-1.066,2.949-1.066,4.989,0.502l1.381,0.973c2.573-1.601,4.801-5.146,5.523-9.477c0.093-0.502,0.188-1.004,0.219-1.506 c-1.882,0.628-3.985,0.502-5.806-0.627c-3.859-2.449-3.389-7.783,1.821-8.316c3.515-0.376,6.244,2.04,6.621,6.684 c1.476-1.538,2.166-3.922,1.067-6.84c-0.126-0.251,0.471-0.408,0.659,0.031c1.317,3.076,0.282,5.837-1.695,7.594 c0.032,0.879-0.032,1.852-0.188,2.888c-0.785,5.021-3.735,8.597-7.187,10.324c6.59,4.455,11.517,5.711,13.776,4.143 C83.511,109.814,84.013,110.253,83.793,110.599z M67.35,105.482l-0.722-0.564c-2.824-2.164-3.985-1.098-4.237-0.722l-0.25,0.503 c0.785,0.628,1.726,1.035,2.855,1.16C65.781,105.923,66.565,105.797,67.35,105.482z M74.223,93.245 c0.344-4.738-1.224-7.751-4.771-7.343c-3.357,0.376-3.64,4.613-0.596,6.621C70.52,93.591,72.496,93.778,74.223,93.245z"/> <path d="M92.39,101.938c-0.752,2.447-3.388,3.797-4.989,2.762c-0.91-0.565-1.82-1.538-2.26-3.703 c-0.69,2.196-1.757,3.922-3.231,3.922c-1.758,0-4.111-1.662-3.985-5.899c0.094-2.133,0.408-4.833,0.69-5.554 c0.251-0.69,3.295-1.538,3.012-0.878c-0.47,0.972-0.973,2.164-1.317,6.024c-0.313,3.608,0.753,5.24,2.134,5.24 s2.071-2.981,2.447-5.711c0.031-1.318,0.188-2.887,0.565-4.676c0.157-0.722,3.232-1.569,3.013-0.878 c-0.88,2.416-1.256,5.679-1.35,7.185c-0.157,2.605,0.534,3.955,1.162,4.394c1.191,0.816,2.918-0.533,3.389-2.165 C91.919,101.216,92.641,101.121,92.39,101.938z"/> <path d="M104.721,102.282c-0.721,2.417-3.043,3.452-4.644,2.417c-0.91-0.565-1.852-1.57-2.291-3.797 c-0.658,2.259-1.694,4.048-3.201,4.048c-1.914,0-4.518-1.978-3.89-7.029c0.784-6.527,6.087-6.652,7.688-4.77 c0.752-0.628,2.949-1.161,2.729-0.564c-0.848,2.416-1.224,5.679-1.317,7.185c-0.157,2.605,0.533,3.986,1.161,4.394 c1.192,0.816,2.572-0.188,3.075-1.82C104.281,101.529,105.004,101.436,104.721,102.282z M97.629,96.917 c0.064-0.878,0.188-1.851,0.377-2.855c-0.533-2.322-4.236-1.413-4.863,3.608c-0.503,4.299,0.47,6.213,1.976,6.213 C96.719,103.883,97.316,99.897,97.629,96.917z"/> <path d="M111.843,101.812c-0.376,1.287-3.137,3.985-5.585,3.106c-3.2-1.16-2.824-8.409-1.537-21.212 c0.031-0.44,3.044-0.597,2.98-0.157c-2.73,14.497-2.416,19.989-0.471,20.711c1.318,0.502,3.515-1.287,3.892-2.416 C111.404,101.059,112.062,100.965,111.843,101.812z"/> <path d="M112.533,104.604c-1.977-1.287-3.201-5.459-2.071-10.731c0.126-0.534,3.139-0.722,2.95-0.188 c-1.694,4.738-1.412,9.539-0.126,10.449c1.255,0.848,3.013-0.093,3.358-1.914c0.156-0.815,0.877-0.91,0.689-0.063 C116.832,104.479,114.604,105.954,112.533,104.604z M111.184,89.479c-0.22-0.69,0.314-1.506,1.225-1.82 c0.878-0.282,1.789,0.031,2.039,0.753c0.22,0.689-0.314,1.506-1.224,1.789C112.346,90.515,111.436,90.17,111.184,89.479z"/> <path d="M118.684,91.551c-1.068,7.751-0.534,11.924,1.537,12.709c1.318,0.502,2.918-1.287,3.295-2.416 c0.282-0.785,0.941-0.879,0.69-0.032c-0.346,1.287-2.541,3.985-4.958,3.106c-2.855-1.066-3.482-6.495-3.075-13.587 c-0.753-0.094-1.476-0.251-2.103-0.408c-0.409-0.125-0.156-0.753,0.188-0.658c0.564,0.125,1.255,0.219,1.945,0.25 c0.094-1.224,0.188-2.51,0.314-3.828c0.062-0.439,3.075-0.628,2.98-0.219l-0.658,3.953c1.819-0.219,3.64-0.69,5.083-1.537 c0.658-0.377,0.345,2.039,0.282,2.07C122.699,91.425,120.66,91.613,118.684,91.551z"/> <path d="M137.698,107.617c-1.757-1.005-3.39-1.758-6.213-1.82c-1.192,6.088-3.765,7.845-6.119,7.845 c-4.895,0-3.734-7.876,4.613-8.535c0.094-1.099,0.126-2.321,0.126-3.702c-0.691,2.07-1.727,3.671-3.139,3.671 c-1.757,0-4.142-1.694-3.985-5.899c0.063-2.165,0.408-4.832,0.69-5.554c0.252-0.722,3.295-1.568,2.981-0.91 c-0.439,0.973-0.942,2.197-1.287,6.025c-0.345,3.641,0.753,5.271,2.134,5.271c1.569,0,2.26-3.827,2.573-6.778 c0.063-1.6,0.22-2.918,0.408-3.797c0.157-0.752,3.264-1.6,3.012-0.91c-0.847,2.416-1.316,5.522-1.349,7.029 c-0.094,2.135-0.251,3.955-0.533,5.523c2.762,0.095,5.052,1.005,6.338,2.04C138.232,107.366,137.949,107.742,137.698,107.617z M129.917,105.828h-0.063c-5.711,0.377-6.369,6.998-3.923,6.998C127.469,112.826,129.32,111.226,129.917,105.828z"/> </g> <g> <g> <g> <g> <path fill="#13110C" d="M91.707,86.087c1.265-0.327,2.859-0.527,4.599-0.527c1.737,0,3.333,0.2,4.598,0.527 c0.38-3.198,2.042-5.809,4.245-6.844c-0.66-0.31-1.367-0.479-2.102-0.479c-1.512,0-2.9,0.706-3.998,1.889 c0.036-1.401-0.229-2.824-0.802-3.896l-1.941-3.641l-1.944,3.641c-0.541,1.007-0.806,2.325-0.806,3.645 c0,0.083,0,0.166,0.004,0.25c-1.098-1.184-2.489-1.889-3.997-1.889c-0.736,0-1.442,0.169-2.102,0.479 C89.665,80.278,91.323,82.889,91.707,86.087z"/> </g> </g> </g> </g></g></svg>';
		
		
		/**
		 * Quality Goods
		 */
		$svg['quality_goods']['colors'] = array('#000000');
		$svg['quality_goods']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['quality_goods']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><g> <g> <g> <g> <g> <path class="colorful c1" fill="'.$svg['quality_goods']['colors'][0].'" d="M197.492,99.812c0,2.093-3.873,4.048-4.004,6.107c-0.136,2.087,3.448,4.524,3.183,6.573 c-0.269,2.07-4.364,3.506-4.763,5.531c-0.407,2.047,2.831,4.934,2.296,6.932c-0.538,2.017-4.786,2.9-5.448,4.861 c-0.672,1.973,2.158,5.26,1.366,7.173c-0.802,1.924-5.125,2.244-6.044,4.102c-0.92,1.868,1.452,5.495,0.415,7.29 c-1.042,1.801-5.372,1.553-6.529,3.278c-1.155,1.728,0.726,5.634-0.536,7.28c-1.27,1.647-5.529,0.837-6.899,2.398 c-1.372,1.562-0.014,5.68-1.483,7.148c-1.469,1.47-5.586,0.113-7.148,1.48c-1.563,1.372-0.752,5.633-2.401,6.898 c-1.645,1.266-5.552-0.617-7.28,0.539c-1.724,1.154-1.475,5.486-3.275,6.527c-1.794,1.039-5.426-1.336-7.292-0.412 c-1.855,0.916-2.177,5.24-4.101,6.039c-1.913,0.793-5.197-2.037-7.173-1.367c-1.958,0.666-2.846,4.912-4.86,5.45 c-1.996,0.534-4.879-2.704-6.928-2.298c-2.028,0.401-3.462,4.494-5.536,4.764c-2.044,0.267-4.482-3.319-6.569-3.184 c-2.059,0.131-4.014,4.004-6.108,4.004c-2.093,0-4.045-3.873-6.107-4.004c-2.087-0.136-4.521,3.45-6.57,3.184 c-2.072-0.27-3.503-4.362-5.532-4.764c-2.048-0.406-4.935,2.831-6.933,2.297c-2.013-0.539-2.9-4.785-4.859-5.451 c-1.977-0.669-5.263,2.16-7.173,1.368c-1.926-0.8-2.246-5.124-4.104-6.043c-1.866-0.921-5.495,1.452-7.288,0.413 c-1.804-1.041-1.553-5.371-3.276-6.525c-1.729-1.157-5.637,0.723-7.281-0.541c-1.65-1.266-0.839-5.527-2.401-6.897 c-1.562-1.369-5.681-0.014-7.148-1.481c-1.471-1.471-0.112-5.588-1.485-7.15c-1.369-1.561-5.628-0.752-6.894-2.398 c-1.265-1.647,0.614-5.557-0.541-7.283c-1.155-1.724-5.484-1.473-6.526-3.273c-1.038-1.796,1.335-5.425,0.415-7.291 c-0.918-1.858-5.242-2.178-6.043-4.101c-0.792-1.913,2.04-5.198,1.37-7.171c-0.666-1.962-4.916-2.846-5.453-4.861 c-0.532-1.998,2.704-4.885,2.3-6.932c-0.403-2.027-4.494-3.462-4.766-5.531c-0.266-2.047,3.321-4.484,3.187-6.572 c-0.134-2.059-4.005-4.014-4.005-6.106c0-2.092,3.871-4.046,4.005-6.107c0.135-2.086-3.452-4.523-3.187-6.572 c0.271-2.071,4.363-3.505,4.766-5.533c0.404-2.048-2.832-4.933-2.3-6.931c0.541-2.016,4.787-2.9,5.453-4.861 c0.669-1.973-2.16-5.26-1.365-7.171c0.796-1.925,5.121-2.245,6.039-4.103c0.924-1.866-1.453-5.495-0.415-7.291 c1.042-1.801,5.374-1.552,6.529-3.276c1.156-1.728-0.723-5.636,0.538-7.28c1.27-1.648,5.53-0.838,6.898-2.398 c1.372-1.562,0.013-5.68,1.483-7.15c1.468-1.468,5.586-0.111,7.148-1.482c1.563-1.369,0.752-5.63,2.401-6.897 c1.645-1.264,5.553,0.617,7.28-0.54c1.724-1.154,1.476-5.483,3.278-6.526c1.792-1.04,5.421,1.336,7.286,0.414 c1.859-0.918,2.181-5.243,4.104-6.041c1.911-0.794,5.198,2.036,7.17,1.367c1.962-0.666,2.846-4.912,4.859-5.452 c2-0.532,4.888,2.704,6.933,2.299c2.028-0.402,3.463-4.494,5.532-4.765c2.049-0.265,4.487,3.32,6.574,3.186 c2.059-0.134,4.01-4.005,6.104-4.005c2.095,0,4.05,3.871,6.108,4.005c2.087,0.134,4.525-3.451,6.574-3.186 c2.069,0.271,3.503,4.363,5.531,4.765c2.049,0.405,4.936-2.831,6.932-2.297c2.015,0.538,2.9,4.785,4.859,5.449 c1.977,0.671,5.26-2.159,7.174-1.366c1.925,0.798,2.245,5.123,4.104,6.041c1.865,0.923,5.494-1.452,7.289-0.412 c1.803,1.042,1.551,5.37,3.275,6.526c1.729,1.157,5.636-0.723,7.285,0.541c1.647,1.268,0.834,5.528,2.396,6.897 c1.559,1.371,5.68,0.014,7.148,1.484c1.471,1.469,0.111,5.585,1.482,7.148c1.371,1.561,5.63,0.751,6.898,2.399 c1.263,1.645-0.617,5.553,0.538,7.28c1.155,1.724,5.487,1.476,6.528,3.276c1.038,1.795-1.338,5.424-0.414,7.291 c0.918,1.857,5.242,2.176,6.04,4.1c0.792,1.913-2.036,5.2-1.366,7.173c0.664,1.96,4.91,2.845,5.448,4.86 c0.535,1.999-2.703,4.883-2.296,6.932c0.398,2.026,4.494,3.459,4.763,5.53c0.266,2.049-3.318,4.486-3.183,6.574 C193.619,95.765,197.492,97.719,197.492,99.812z"/> </g> </g> </g> </g> <g> <g> <g> <path fill="#FFFFFF" d="M100.377,188.371c-48.833,0-88.562-39.729-88.562-88.561c0-48.833,39.729-88.561,88.562-88.561 c48.832,0,88.56,39.729,88.56,88.561C188.938,148.642,149.209,188.371,100.377,188.371z M100.377,13.016 c-47.858,0-86.796,38.936-86.796,86.794c0,47.859,38.938,86.795,86.796,86.795s86.792-38.936,86.792-86.795 C187.17,51.952,148.235,13.016,100.377,13.016z"/> </g> </g> </g> <g> <g> <g> <path fill="#FFFFFF" d="M44.575,67.917c1.542,0.443,2.862,1.24,3.956,2.387c1.09,1.147,1.922,2.571,2.493,4.252 c0.57,1.681,0.861,3.5,0.874,5.437c0.011,1.659-0.181,3.235-0.573,4.717c-0.391,1.482-0.95,2.833-1.678,4.045 c-0.726,1.214-1.59,2.252-2.595,3.119c-1.003,0.867-2.102,1.548-3.292,2.048c1.255,0.381,3.151,1.068,5.686,2.123 c3.085,1.289,5.686,2.313,7.798,3.002c2.111,0.688,4.297,1.039,6.553,1.02c0.941-0.007,1.818-0.173,2.631-0.498 c0.811-0.323,1.568-0.847,2.27-1.567c0.176-0.173,0.313-0.262,0.412-0.264c0.06-0.001,0.087,0.025,0.089,0.073 c0.001,0.125-0.108,0.296-0.321,0.52c-1.19,1.365-2.533,2.412-4.027,3.144c-1.496,0.732-2.998,1.091-4.507,1.091 c-2.256,0-4.398-0.445-6.422-1.307c-2.026-0.858-4.298-2.063-6.815-3.55c-1.594-0.95-2.975-1.646-4.144-2.115 c-1.168-0.468-2.437-0.706-3.805-0.723c-1.704-0.025-3.299-0.31-4.788-0.832c-1.486-0.523-2.794-1.277-3.917-2.253 c-1.126-0.976-2.002-2.143-2.636-3.51c-0.632-1.369-0.948-2.907-0.948-4.652c0-1.687,0.335-3.349,1.002-5.026 c0.666-1.675,1.583-3.253,2.753-4.74c1.166-1.485,2.509-2.766,4.029-3.817c1.518-1.052,3.102-1.779,4.752-2.144 C41.305,67.473,43.029,67.474,44.575,67.917z M30.645,86.793c0.479,1.357,1.16,2.525,2.04,3.514 c0.881,0.987,1.929,1.749,3.142,2.272c1.215,0.527,2.525,0.76,3.936,0.676c1.39-0.082,2.65-0.417,3.781-1.027 c1.132-0.607,2.106-1.452,2.921-2.54c0.816-1.088,1.435-2.395,1.855-3.915c0.421-1.52,0.627-3.196,0.615-5.013 c-0.014-2.044-0.268-3.856-0.768-5.416c-0.5-1.561-1.19-2.826-2.076-3.786c-0.887-0.96-1.904-1.602-3.058-1.932 c-1.15-0.328-2.379-0.348-3.68-0.073c-1.419,0.3-2.712,0.862-3.885,1.665c-1.173,0.804-2.166,1.78-2.988,2.919 c-0.821,1.141-1.453,2.408-1.896,3.808c-0.444,1.4-0.666,2.864-0.662,4.413C29.925,83.966,30.165,85.437,30.645,86.793z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M60.478,94.004c-0.935-0.161-1.811-0.524-2.627-1.084c-0.819-0.559-1.497-1.424-2.034-2.592 s-0.822-2.692-0.853-4.583c-0.001-0.187-0.017-1.016-0.046-2.486c-0.05-1.515-0.074-2.518-0.079-3.007 c-0.004-0.678,0.007-1.94,0.033-3.791c0.009-1.684,0.009-3.041,0.001-4.068c-0.006-1.215-0.035-2.275-0.079-3.181 c-0.046-0.835-0.18-1.557-0.41-2.163c-0.229-0.605-0.67-1.112-1.32-1.514c0-0.082,0-0.163,0-0.244 c1.292-0.08,2.342-0.177,3.145-0.304c0.47-0.074,1.145-0.226,2.028-0.454c0.47-0.094,0.833-0.172,1.088-0.233 c0.002,0.083,0.002,0.167,0.002,0.25c-0.549,0.413-0.937,1.011-1.167,1.791c-0.229,0.78-0.373,1.646-0.424,2.599 c-0.017,0.5-0.033,1.011-0.048,1.534c-0.018,0.523-0.022,1.256-0.016,2.202c-0.013,1.114-0.006,3.478,0.018,7.094 c0.005,0.733,0.014,1.465,0.03,2.197c0.013,0.732,0.044,1.71,0.092,2.937c0.05,1.652,0.251,2.988,0.601,4.012 c0.349,1.025,0.797,1.792,1.34,2.307c0.542,0.513,1.148,0.847,1.815,1.002c0.669,0.154,1.416,0.218,2.239,0.19 c1.138-0.038,2.1-0.179,2.885-0.424c0.782-0.244,1.448-0.682,1.994-1.315c0.544-0.631,0.972-1.55,1.281-2.758 c0.306-1.208,0.474-2.763,0.503-4.665c-0.003-0.395-0.005-0.825-0.007-1.294c0.015-1.087,0.018-2.111,0.011-3.074 c-0.003-0.961,0-2.085,0.011-3.369c-0.007-1.579-0.015-2.762-0.018-3.553c-0.011-1.776-0.04-3.316-0.087-4.62 c-0.045-1.107-0.188-1.932-0.427-2.474c-0.24-0.542-0.743-1.044-1.515-1.497c0-0.086-0.001-0.171-0.001-0.257 c0.217-0.025,0.531-0.037,0.946-0.033c0.59,0.01,1.025,0,1.3-0.029c0.472-0.049,1.153-0.169,2.039-0.355 c0.473-0.072,0.837-0.131,1.094-0.181c0,0.087,0,0.175,0,0.262c-0.607,0.455-1.02,0.992-1.233,1.607 c-0.215,0.617-0.337,1.583-0.368,2.9c-0.051,1.566-0.076,3.235-0.078,5.008c-0.001,1.773,0.005,3.885,0.02,6.338 c0.001,0.199,0.004,0.743,0.01,1.634c-0.018,0.894-0.025,1.439-0.021,1.638c0.015,2.726-0.187,4.922-0.599,6.582 c-0.416,1.66-0.995,2.89-1.749,3.685c-0.75,0.797-1.616,1.323-2.595,1.581c-0.981,0.258-2.206,0.407-3.678,0.449 C62.425,94.231,61.411,94.165,60.478,94.004z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M94.977,89.151c0.594,1.943,1.478,3.222,2.657,3.835c0,0.089,0,0.178,0,0.269 c-1.08-0.229-2.162-0.341-3.241-0.335c-1.161,0.006-2.32,0.129-3.477,0.368c-0.002-0.076-0.002-0.153-0.002-0.23 c-0.001-0.205,0.136-0.55,0.412-1.039c0.351-0.642,0.528-1.129,0.528-1.462c0-0.23-0.027-0.485-0.076-0.768 c-0.051-0.281-0.104-0.522-0.163-0.726c-0.771-2.729-1.545-5.452-2.32-8.167c-1.519-0.147-2.818-0.202-3.901-0.171 c-1.477,0.042-2.845,0.176-4.103,0.398c-0.865,2.962-1.729,5.912-2.591,8.85c-0.23,0.784-0.348,1.378-0.346,1.779 c0.002,0.527,0.183,1.013,0.538,1.459c0,0.076,0,0.152,0.001,0.226c-0.787-0.136-1.583-0.197-2.388-0.181 c-0.883,0.017-1.758,0.111-2.62,0.278c0.049-0.076,0.097-0.151,0.146-0.227c1.488-0.63,2.562-1.979,3.222-4.052 c2.343-7.397,4.697-14.891,7.06-22.433c0.06-0.231,0.089-0.449,0.086-0.652c-0.001-0.735-0.214-1.479-0.641-2.229 c-0.428-0.75-0.97-1.383-1.624-1.898c-0.02-0.088-0.042-0.175-0.061-0.262c0.453,0.022,1.022,0.03,1.703,0.029 c0.684-0.002,1.3-0.019,1.855-0.047c0.266-0.014,0.532-0.027,0.799-0.041c0.458,1.466,0.917,2.937,1.375,4.41 C90.208,73.736,92.598,81.425,94.977,89.151z M88.668,78.881c-1.051-3.571-2.108-7.128-3.166-10.666 c-0.029,0.002-0.059,0.003-0.089,0.004c-1.124,3.634-2.244,7.258-3.364,10.867c0,0.062,0,0.126,0.001,0.188 c1.062,0.036,2.157,0.038,3.279,0.003c1.143-0.035,2.254-0.103,3.337-0.206C88.668,79.008,88.668,78.945,88.668,78.881z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M102.41,93.1c-0.59,0.05-1.191,0.114-1.799,0.191c-0.01-0.142-0.021-0.283-0.029-0.424 c0.235-0.153,0.477-0.403,0.721-0.75c0.246-0.346,0.473-0.756,0.681-1.231c0.204-0.474,0.371-0.948,0.501-1.423 c0.129-0.474,0.193-0.904,0.193-1.288c0.038-1.975,0.06-3.605,0.06-4.887c0.002-1.283,0.003-3.104,0.003-5.465 c0.002-1.975-0.018-3.99-0.055-6.042c-0.039-2.052-0.098-4.041-0.176-5.966c-0.039-0.924-0.172-1.739-0.397-2.446 c-0.229-0.707-0.667-1.344-1.32-1.911c0-0.089,0-0.179,0-0.269c1.303,0.156,2.362,0.243,3.174,0.254 c0.475,0.005,1.157-0.036,2.046-0.12c0.476-0.016,0.84-0.034,1.1-0.053c0,0.089,0,0.179,0,0.269 c-0.556,0.347-0.95,0.92-1.19,1.723c-0.237,0.804-0.389,1.719-0.448,2.742c-0.021,0.538-0.042,1.089-0.061,1.652 c-0.021,0.564-0.031,1.358-0.033,2.383c-0.021,1.206-0.032,3.769-0.038,7.691c0,1.82,0.018,3.467,0.056,4.941 c0.038,1.475,0.095,3.302,0.171,5.481c0.02,0.691,0.15,1.275,0.396,1.75c0.247,0.476,0.56,0.844,0.943,1.102 c0.384,0.258,0.814,0.448,1.298,0.567c0.479,0.117,0.996,0.18,1.545,0.184c0.787,0.008,1.617-0.131,2.494-0.416 c0.874-0.282,1.588-0.711,2.141-1.289c0.334-0.35,0.627-0.734,0.875-1.148c0.246-0.415,0.506-0.912,0.784-1.49 c0.316-0.704,0.546-1.055,0.682-1.051c0.079,0.001,0.134,0.054,0.163,0.156c0.027,0.102,0.043,0.217,0.043,0.344 c-0.001,0.253-0.057,0.569-0.165,0.947c-0.11,0.378-0.273,0.856-0.493,1.437c-0.377,1.11-0.615,1.893-0.715,2.349 c-0.08,0.431-0.218,0.792-0.416,1.081c-0.195,0.29-0.453,0.446-0.768,0.468c-0.078,0-0.459,0.019-1.15,0.063 c-1.217,0.09-2.104,0.133-2.651,0.129c-0.667-0.005-1.272-0.023-1.813-0.052c-0.54-0.029-1.133-0.071-1.781-0.127 c-1.198-0.083-2.191-0.125-2.978-0.127C103.529,93.025,102.998,93.05,102.41,93.1z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M118.5,93.384c0.002-0.101,0.002-0.202,0.004-0.304c0.489-0.319,0.896-0.769,1.212-1.344 c0.317-0.576,0.487-1.24,0.507-1.996c0.051-2.546,0.088-6.366,0.107-11.461c0.007-1.94-0.004-3.922-0.035-5.941 c-0.032-2.019-0.082-3.978-0.154-5.875c-0.035-0.911-0.166-1.721-0.39-2.43c-0.226-0.709-0.661-1.363-1.312-1.961 c0-0.089,0-0.178,0.002-0.266c1.303,0.235,2.358,0.386,3.168,0.447c0.475,0.036,1.154,0.037,2.042,0.011 c0.477,0.015,0.841,0.021,1.099,0.018c0,0.087-0.002,0.175-0.002,0.262c-0.555,0.304-0.953,0.841-1.193,1.611 c-0.24,0.772-0.393,1.658-0.455,2.657c-0.023,0.527-0.045,1.063-0.066,1.615c-0.023,0.55-0.034,1.328-0.041,2.331 c-0.024,1.179-0.047,3.688-0.062,7.527c-0.017,3.514,0.045,7.283,0.186,11.3c0.034,0.828,0.193,1.554,0.477,2.173 c0.282,0.62,0.706,1.099,1.273,1.436c-0.002,0.101-0.002,0.2-0.002,0.3c-1.274-0.15-2.385-0.233-3.326-0.25 C120.595,93.228,119.581,93.273,118.5,93.384z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M148.934,65.938c-0.129,0.336-0.314,0.749-0.555,1.241c-0.475,0.986-0.753,1.712-0.836,2.163 c-0.019,0.135-0.068,0.228-0.147,0.273c-0.077,0.047-0.147,0.065-0.206,0.058c-0.079-0.013-0.125-0.252-0.143-0.72 c-0.018-0.375-0.047-0.647-0.084-0.816c-0.055-0.333-0.236-0.624-0.539-0.87c-0.302-0.245-0.599-0.402-0.893-0.472 c-0.117-0.018-0.422-0.065-0.908-0.139c-1.374-0.229-2.816-0.45-4.326-0.655c-0.056,0.842-0.111,1.684-0.164,2.527 c-0.11,1.494-0.171,3.475-0.186,5.938c-0.008,0.885-0.003,1.76,0.012,2.623c-0.006,0.789-0.01,1.579-0.017,2.368 c-0.021,3.349,0.036,6.945,0.167,10.775c0.033,0.79,0.191,1.485,0.473,2.081c0.279,0.595,0.701,1.058,1.27,1.384 c-0.002,0.095-0.002,0.191-0.002,0.286c-1.274-0.162-2.381-0.257-3.324-0.287c-0.941-0.029-1.951-0.001-3.033,0.09 c0.003-0.097,0.006-0.194,0.006-0.292c0.489-0.3,0.895-0.724,1.213-1.271c0.317-0.545,0.487-1.177,0.512-1.901 c0.057-2.438,0.098-6.094,0.129-10.971c0.016-2.559,0.029-4.708,0.042-6.445c0.01-1.738,0-3.502-0.028-5.295 c-0.006-0.665-0.011-1.33-0.018-1.996c-1.258-0.158-2.334-0.253-3.229-0.295c-0.896-0.042-1.787,0.015-2.673,0.168 c-0.316,0.041-0.672,0.159-1.066,0.354c-0.396,0.196-0.752,0.44-1.069,0.732c-0.1,0.089-0.226,0.215-0.387,0.372 c-0.355,0.39-0.614,0.577-0.771,0.564c-0.138-0.012-0.206-0.092-0.206-0.241c0.021-0.245,0.221-0.689,0.599-1.323 c0.317-0.516,0.517-0.893,0.597-1.133c0.08-0.178,0.16-0.356,0.24-0.534c0.34-0.857,0.549-1.464,0.631-1.827 c0.119,0.012,0.235,0.025,0.354,0.038c0.295,0.452,0.874,0.736,1.738,0.856c1.637,0.209,4.075,0.505,7.316,0.954 c1.08,0.15,2.77,0.34,5.064,0.605c0.823,0.107,1.646,0.216,2.467,0.33c0.45,0.052,0.973-0.012,1.559-0.186 c0.178-0.039,0.324-0.07,0.441-0.096c0.08,0.014,0.156,0.028,0.236,0.042C149.147,65.291,149.061,65.603,148.934,65.938z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M172.498,70.632c0.559,0.049,1.021,0.115,1.389,0.195c-0.087,0.044-0.174,0.09-0.26,0.135 c-0.734,0.119-1.398,0.44-1.998,0.971s-1.24,1.245-1.919,2.149c-0.912,1.2-1.862,2.496-2.847,3.896 c-0.986,1.4-1.92,2.765-2.804,4.079c-0.003,0.338-0.014,0.739-0.034,1.201c-0.004,0.551-0.006,0.962-0.008,1.237 c-0.005,1.521,0.053,3.877,0.178,7.053c0,0.042,0,0.085,0,0.128c0.035,0.699,0.194,1.317,0.477,1.85 c0.279,0.534,0.704,0.951,1.271,1.253c0,0.083-0.001,0.167-0.001,0.25c-1.272-0.172-2.375-0.282-3.316-0.331 c-0.938-0.048-1.947-0.046-3.021,0.011c0-0.087,0-0.174,0-0.261c0.49-0.258,0.893-0.626,1.209-1.105 c0.315-0.478,0.484-1.037,0.507-1.681c0.049-1.976,0.083-4.931,0.103-8.865c-0.463-0.92-1.158-2.369-2.086-4.379 c-1.426-3.088-2.536-5.407-3.328-6.878c-0.018-0.025-0.125-0.233-0.318-0.625c-0.52-0.982-1.02-1.829-1.493-2.534 c-0.474-0.706-1.119-1.384-1.937-2.035c-0.049-0.1-0.098-0.2-0.144-0.299c1.268,0.395,2.409,0.694,3.423,0.895 c0.469,0.092,1.18,0.178,2.135,0.266c0.467,0.03,0.817,0.061,1.051,0.088c-0.049,0.088-0.098,0.176-0.146,0.265 c-0.119,0.062-0.236,0.22-0.355,0.47c-0.116,0.251-0.177,0.463-0.181,0.639c0,0.352,0.096,0.783,0.287,1.293 c0.191,0.508,0.451,1.111,0.779,1.805c0.115,0.251,0.232,0.502,0.348,0.752c0.25,0.547,0.5,1.104,0.751,1.668 c1.214,2.665,2.177,4.588,2.896,5.824c0.782-0.946,1.526-1.908,2.232-2.882c0.703-0.976,1.348-1.938,1.932-2.892 c0.039-0.064,0.078-0.128,0.116-0.192c0.429-0.654,0.77-1.221,1.023-1.707c0.251-0.487,0.38-0.9,0.38-1.248 c0-0.448-0.115-0.875-0.344-1.281c-0.029-0.1-0.059-0.199-0.086-0.298c0.232,0.079,0.482,0.171,0.753,0.281 c0.732,0.265,1.372,0.467,1.912,0.606C171.408,70.497,171.9,70.574,172.498,70.632z"/> </g> </g> </g> <g> <g> <path fill="#FFFFFF" d="M59.032,135.934c-0.052,0.223-0.133,0.367-0.238,0.432c-0.255,0.126-0.702,0.285-1.337,0.477 c-0.531,0.171-0.913,0.299-1.146,0.383c-1.083,0.424-2.204,0.73-3.361,0.923c-1.155,0.19-2.447,0.286-3.868,0.286 c-1.806,0-3.526-0.344-5.16-1.035c-1.634-0.689-3.068-1.654-4.298-2.898c-1.232-1.24-2.192-2.679-2.882-4.314 c-0.69-1.635-1.034-3.364-1.034-5.19c0-1.849,0.333-3.608,1.001-5.286c0.669-1.676,1.624-3.152,2.866-4.426 c1.244-1.274,2.723-2.271,4.442-2.994c1.72-0.721,3.588-1.082,5.604-1.082c0.766,0,1.619,0.059,2.565,0.174 c0.944,0.118,1.915,0.271,2.914,0.463c0.211,0.043,0.542,0.148,0.987,0.318c0.572,0.254,1.019,0.382,1.337,0.382 c0.296,0,0.595-0.021,0.893-0.063c0.169-0.021,0.275-0.031,0.318-0.031c0.085,0,0.127,0.074,0.127,0.223c0,0.043,0,0.15,0,0.317 c-0.022,0.276-0.033,0.521-0.033,0.733c0,0.316,0.021,0.785,0.064,1.4c0.021,0.553,0.032,0.936,0.032,1.146 c0,0.191-0.021,0.408-0.063,0.654c-0.042,0.243-0.095,0.365-0.16,0.365c-0.084,0-0.275-0.223-0.573-0.668 c-0.405-0.595-0.812-1.119-1.225-1.576c-0.414-0.458-0.919-0.834-1.513-1.133c-1.529-0.763-3.207-1.145-5.032-1.145 c-1.698,0-3.242,0.28-4.633,0.844c-1.392,0.562-2.574,1.358-3.551,2.389c-0.978,1.029-1.724,2.244-2.245,3.646 c-0.521,1.4-0.78,2.908-0.78,4.522c0,1.612,0.266,3.189,0.796,4.729c0.531,1.539,1.274,2.914,2.229,4.123 c0.956,1.211,2.071,2.161,3.343,2.851c1.273,0.69,2.623,1.034,4.045,1.034c0.721,0,1.57-0.137,2.546-0.413 c0.978-0.275,2.091-0.647,3.345-1.114c0.339-0.127,0.558-0.361,0.653-0.7c0.095-0.341,0.152-0.798,0.174-1.371v-0.03 c0-0.234-0.011-0.573-0.031-1.02c-0.021-1.423-0.055-2.43-0.096-3.025c-0.064-0.998-0.201-1.726-0.413-2.182 c-0.214-0.455-0.691-0.928-1.433-1.416v-0.225c1.399,0.129,2.535,0.191,3.406,0.191c0.404,0,0.988-0.041,1.752-0.126 c0.509-0.044,0.935-0.075,1.274-0.096l-0.032,0.222c-0.531,0.276-0.875,0.686-1.036,1.227c-0.159,0.543-0.26,1.248-0.302,2.117 l-0.031,0.416c-0.064,0.996-0.103,1.884-0.112,2.658c-0.011,0.775-0.016,1.875-0.016,3.295 C59.112,135.504,59.087,135.711,59.032,135.934z"/> </g> <g> <path fill="#FFFFFF" d="M82.836,112.544c1.676,0.68,3.089,1.636,4.236,2.866c1.146,1.231,2.016,2.66,2.61,4.283 s0.891,3.371,0.891,5.238c0,1.933-0.344,3.732-1.034,5.398c-0.691,1.666-1.646,3.104-2.868,4.312 c-1.221,1.211-2.648,2.146-4.282,2.805c-1.635,0.658-3.366,0.986-5.19,0.986c-1.806,0-3.525-0.344-5.16-1.035 c-1.634-0.689-3.067-1.654-4.299-2.898c-1.23-1.24-2.192-2.679-2.88-4.314c-0.692-1.635-1.035-3.364-1.035-5.19 c0-1.823,0.343-3.554,1.035-5.19c0.688-1.635,1.65-3.078,2.88-4.33c1.232-1.254,2.66-2.225,4.283-2.914 c1.624-0.689,3.349-1.035,5.176-1.035C79.279,111.525,81.159,111.865,82.836,112.544z M73.187,113.912 c-1.231,0.532-2.298,1.287-3.199,2.263c-0.903,0.976-1.597,2.149-2.085,3.519c-0.49,1.369-0.733,2.86-0.733,4.475 c0,1.635,0.248,3.211,0.749,4.729c0.498,1.519,1.198,2.881,2.101,4.092c0.902,1.211,1.969,2.156,3.201,2.836 c1.23,0.678,2.557,1.018,3.981,1.018c1.464,0,2.823-0.25,4.077-0.748c1.252-0.498,2.35-1.222,3.294-2.166 c0.945-0.943,1.673-2.081,2.181-3.408c0.511-1.326,0.765-2.795,0.765-4.41c0-1.995-0.26-3.799-0.78-5.412 c-0.521-1.613-1.242-2.989-2.166-4.126c-0.924-1.134-2.017-1.994-3.279-2.579c-1.264-0.582-2.628-0.875-4.092-0.875 C75.756,113.117,74.418,113.383,73.187,113.912z"/> </g> <g> <path fill="#FFFFFF" d="M112.771,112.544c1.675,0.68,3.088,1.636,4.235,2.866c1.146,1.231,2.017,2.66,2.61,4.283 s0.891,3.371,0.891,5.238c0,1.933-0.344,3.732-1.033,5.398c-0.691,1.666-1.646,3.104-2.867,4.312 c-1.221,1.211-2.649,2.146-4.283,2.805c-1.635,0.658-3.363,0.986-5.189,0.986c-1.807,0-3.525-0.344-5.16-1.035 c-1.634-0.689-3.067-1.654-4.298-2.898c-1.232-1.24-2.193-2.679-2.882-4.314c-0.691-1.635-1.035-3.364-1.035-5.19 c0-1.823,0.344-3.554,1.035-5.19c0.689-1.635,1.65-3.078,2.882-4.33c1.23-1.254,2.658-2.225,4.282-2.914 c1.623-0.689,3.348-1.035,5.176-1.035C109.215,111.525,111.093,111.865,112.771,112.544z M103.121,113.912 c-1.231,0.532-2.297,1.287-3.199,2.263c-0.903,0.976-1.598,2.149-2.086,3.519c-0.49,1.369-0.733,2.86-0.733,4.475 c0,1.635,0.248,3.211,0.748,4.729c0.499,1.519,1.199,2.881,2.101,4.092c0.903,1.211,1.97,2.156,3.202,2.836 c1.229,0.678,2.556,1.018,3.98,1.018c1.464,0,2.822-0.25,4.076-0.748c1.252-0.498,2.35-1.222,3.295-2.166 c0.945-0.943,1.673-2.081,2.182-3.408c0.51-1.326,0.764-2.795,0.764-4.41c0-1.995-0.26-3.799-0.779-5.412 c-0.521-1.613-1.242-2.989-2.166-4.126c-0.924-1.134-2.018-1.994-3.279-2.579c-1.266-0.582-2.628-0.875-4.092-0.875 C105.689,113.117,104.352,113.383,103.121,113.912z"/> </g> <g> <path fill="#FFFFFF" d="M139.059,112.432c1.667,0.564,3.126,1.375,4.381,2.438c1.252,1.062,2.232,2.34,2.945,3.838 c0.711,1.494,1.066,3.137,1.066,4.918c0,2.082-0.361,4.009-1.084,5.78c-0.721,1.774-1.761,3.317-3.121,4.634 c-1.358,1.316-2.982,2.336-4.871,3.057c-1.891,0.723-3.971,1.094-6.242,1.115c-0.722,0-1.891-0.054-3.502-0.16 c-1.637-0.105-2.824-0.157-3.567-0.157c-0.573,0-1.231,0.015-1.976,0.048c-0.742,0.029-1.356,0.067-1.846,0.109v-0.286 c0.574-0.274,1.114-0.741,1.623-1.399c0.51-0.658,0.775-1.296,0.797-1.912c0-0.489,0-1.083,0-1.783 c0.021-2.123,0.033-4.574,0.033-7.355c0-1.636-0.021-3.301-0.064-5c-0.043-1.698-0.105-3.345-0.191-4.936 c-0.064-1.189-0.924-2.346-2.58-3.473v-0.189c0.552,0.043,1.248,0.085,2.086,0.127c0.838,0.043,1.524,0.062,2.054,0.062 c0.765,0,1.423-0.01,1.976-0.03c0.551-0.021,1.241-0.064,2.07-0.129c0.869-0.042,1.649-0.08,2.34-0.111 c0.689-0.031,1.48-0.046,2.373-0.046C135.625,111.59,137.394,111.871,139.059,112.432z M129.204,113.277 c-1.211,0.084-2.028,0.265-2.452,0.541c-0.044,0.275-0.075,0.689-0.096,1.24c-0.022,0.191-0.033,0.342-0.033,0.447 c-0.021,0.445-0.041,0.903-0.062,1.369c-0.023,0.467-0.033,1.125-0.033,1.975c-0.02,0.998-0.031,3.121-0.031,6.368 c0,2.974,0.086,6.157,0.256,9.554c0,0.148,0.02,0.329,0.062,0.541c0.594,0.468,1.445,0.787,2.549,0.956 c1.104,0.171,2.568,0.254,4.395,0.254c1.421,0,2.766-0.302,4.028-0.905c1.263-0.607,2.372-1.445,3.328-2.518 c0.954-1.072,1.702-2.318,2.245-3.74c0.54-1.423,0.811-2.931,0.811-4.523c0-1.676-0.271-3.317-0.811-4.921 c-0.543-1.602-1.291-2.923-2.245-3.964c-0.892-0.977-1.97-1.688-3.233-2.133c-1.262-0.447-2.637-0.669-4.123-0.669 C131.932,113.149,130.412,113.193,129.204,113.277z"/> </g> <g> <path fill="#FFFFFF" d="M153.373,138.147c-0.613-0.128-1.379-0.329-2.291-0.605c-0.532-0.147-0.809-0.222-0.83-0.222 c-0.381-0.106-0.635-0.32-0.764-0.637c-0.127-0.318-0.191-0.766-0.191-1.338l-0.031-0.256c-0.063-0.402-0.116-0.791-0.16-1.162 c-0.041-0.372-0.062-0.728-0.062-1.065c0-0.257,0.047-0.507,0.143-0.749c0.097-0.244,0.229-0.367,0.398-0.367 c0.043,0,0.128,0.182,0.256,0.543c0.146,0.443,0.307,0.854,0.477,1.225c0.17,0.373,0.393,0.728,0.669,1.066 c0.511,0.615,1.278,1.152,2.308,1.61c1.03,0.456,1.916,0.684,2.66,0.684c0.553,0,1.125-0.101,1.721-0.302 c0.594-0.203,1.141-0.499,1.64-0.894c0.498-0.393,0.901-0.88,1.211-1.464c0.307-0.584,0.46-1.247,0.46-1.99 c0-0.723-0.143-1.392-0.43-2.006c-0.287-0.617-0.674-1.189-1.162-1.721c-0.489-0.531-1.02-1.014-1.592-1.449 c-0.573-0.434-1.295-0.948-2.166-1.544c-0.935-0.638-1.699-1.183-2.293-1.64s-1.151-0.965-1.672-1.528 c-0.52-0.563-0.936-1.184-1.242-1.864c-0.309-0.68-0.462-1.422-0.462-2.229c0-0.827,0.14-1.634,0.415-2.421 c0.276-0.784,0.694-1.501,1.258-2.148c0.562-0.647,1.278-1.163,2.15-1.545c0.869-0.383,1.867-0.573,2.992-0.573 c0.446,0,1.136,0.085,2.07,0.255c0.912,0.192,1.593,0.286,2.036,0.286c0.191,0,0.427-0.052,0.702-0.159 c0.318-0.127,0.594-0.191,0.828-0.191c0.127,0,0.191,0.097,0.191,0.286c0,0.553,0.053,1.328,0.158,2.326 c0.086,0.956,0.129,1.678,0.129,2.166c0,0.106-0.028,0.223-0.08,0.35c-0.054,0.129-0.111,0.191-0.176,0.191 c-0.148,0-0.402-0.34-0.764-1.02c-0.191-0.381-0.371-0.701-0.541-0.954c-0.171-0.257-0.352-0.468-0.543-0.638 c-0.572-0.511-1.268-0.885-2.084-1.131c-0.818-0.242-1.588-0.366-2.311-0.366c-0.467,0-0.939,0.095-1.416,0.286 c-0.479,0.191-0.906,0.457-1.289,0.795c-0.383,0.342-0.691,0.729-0.925,1.164c-0.234,0.436-0.351,0.886-0.351,1.354 c0,0.615,0.133,1.199,0.398,1.75c0.266,0.553,0.631,1.078,1.1,1.578c0.467,0.498,0.954,0.944,1.463,1.338 c0.512,0.392,1.222,0.917,2.135,1.576c0.977,0.701,1.783,1.301,2.42,1.799s1.236,1.062,1.799,1.688s1.014,1.316,1.355,2.07 c0.338,0.753,0.519,1.565,0.539,2.436c0,0.976-0.17,1.916-0.508,2.819c-0.342,0.901-0.855,1.708-1.545,2.419 c-0.69,0.712-1.555,1.273-2.596,1.688s-2.24,0.621-3.6,0.621C154.658,138.338,153.99,138.275,153.373,138.147z"/> </g> </g> <g> <g> <polygon fill="#FFFFFF" points="99.127,28.061 101.658,33.188 107.322,34.014 103.225,38.009 104.189,43.649 99.127,40.986  94.06,43.649 95.03,38.009 90.933,34.014 96.594,33.188 "/> </g> </g></g></svg>';
		
		
		
		/**
		 * BEST Quality
		 */
		$svg['best_quality']['colors'] = array();
		$svg['best_quality']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['best_quality']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 167.033 200" enable-background="new 0 0 167.033 200" xml:space="preserve"><g> <g> <g> <g> <polygon fill="#FFFFFF" points="152.712,182.198 83.779,196.787 14.848,182.198 14.848,18.496 83.779,3.142 152.712,18.496  "/> </g> </g> <g> <g> <path fill="#13110C" d="M83.779,197.561l-0.157-0.033l-69.531-14.715V17.89L83.779,2.367l0.166,0.036l69.524,15.487v164.923 L83.779,197.561z M15.605,181.586l68.174,14.428l68.177-14.428V19.103L83.779,3.918L15.605,19.103V181.586z"/> </g> </g> </g> <g> <g> <g> <rect x="3.776" y="46.578" fill="#13110C" width="159.63" height="112.117"/> </g> </g> <g> <g> <path fill="#13110C" d="M164.165,159.453H3.02V45.821h161.145V159.453z M4.534,157.939H162.65V47.335H4.534V157.939z"/> </g> </g> </g> <g> <g> <g> <g> <polygon fill="#FFFFFF" points="160.301,153.914 156.896,153.914 156.896,153.156 159.543,153.156 159.543,150.508  160.301,150.508 "/> </g> </g> </g> <g> <g> <g> <path fill="#FFFFFF" d="M151.031,153.914h-5.865v-0.758h5.865V153.914z M139.301,153.914h-5.864v-0.758h5.864V153.914z M127.572,153.914h-5.862v-0.758h5.862V153.914z M115.845,153.914h-5.865v-0.758h5.865V153.914z M104.116,153.914h-5.864 v-0.758h5.864V153.914z M92.386,153.914h-5.863v-0.758h5.863V153.914z M80.66,153.914h-5.866v-0.758h5.866V153.914z M68.929,153.914h-5.863v-0.758h5.863V153.914z M57.201,153.914h-5.864v-0.758h5.864V153.914z M45.473,153.914h-5.865v-0.758 h5.865V153.914z M33.743,153.914h-5.862v-0.758h5.862V153.914z M22.016,153.914H16.15v-0.758h5.865V153.914z"/> </g> </g> </g> <g> <g> <g> <polygon fill="#FFFFFF" points="10.288,153.914 6.881,153.914 6.881,150.508 7.638,150.508 7.638,153.156 10.288,153.156  "/> </g> </g> </g> <g> <g> <g> <path fill="#FFFFFF" d="M7.638,144.814H6.881v-5.693h0.757V144.814z M7.638,133.428H6.881v-5.693h0.757V133.428z M7.638,122.041H6.881v-5.693h0.757V122.041z M7.638,110.654H6.881v-5.691h0.757V110.654z M7.638,99.268H6.881v-5.692h0.757 V99.268z M7.638,87.883H6.881v-5.693h0.757V87.883z M7.638,76.497H6.881v-5.693h0.757V76.497z M7.638,65.11H6.881v-5.693h0.757 V65.11z"/> </g> </g> </g> <g> <g> <g> <polygon fill="#FFFFFF" points="7.638,53.724 6.881,53.724 6.881,50.317 10.288,50.317 10.288,51.074 7.638,51.074 "/> </g> </g> </g> <g> <g> <g> <path fill="#FFFFFF" d="M151.031,51.074h-5.864v-0.757h5.864V51.074z M139.301,51.074h-5.862v-0.757h5.862V51.074z M127.574,51.074h-5.864v-0.757h5.864V51.074z M115.845,51.074h-5.864v-0.757h5.864V51.074z M104.116,51.074h-5.863v-0.757 h5.863V51.074z M92.388,51.074h-5.865v-0.757h5.865V51.074z M80.66,51.074h-5.865v-0.757h5.865V51.074z M68.931,51.074h-5.865 v-0.757h5.865V51.074z M57.203,51.074h-5.866v-0.757h5.866V51.074z M45.473,51.074H39.61v-0.757h5.863V51.074z M33.746,51.074 h-5.865v-0.757h5.865V51.074z M22.017,51.074h-5.865v-0.757h5.865V51.074z"/> </g> </g> </g> <g> <g> <g> <polygon fill="#FFFFFF" points="160.301,53.724 159.543,53.724 159.543,51.074 156.896,51.074 156.896,50.317 160.301,50.317  "/> </g> </g> </g> <g> <g> <g> <path fill="#FFFFFF" d="M160.301,144.814h-0.758v-5.693h0.758V144.814z M160.301,133.428h-0.758v-5.693h0.758V133.428z M160.301,122.041h-0.758v-5.693h0.758V122.041z M160.301,110.654h-0.758v-5.691h0.758V110.654z M160.301,99.27h-0.758v-5.694 h0.758V99.27z M160.301,87.883h-0.758v-5.693h0.758V87.883z M160.301,76.497h-0.758v-5.693h0.758V76.497z M160.301,65.11 h-0.758v-5.693h0.758V65.11z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path fill="#13110C" d="M77.708,39.185c1.864-0.481,4.215-0.774,6.78-0.774c2.561,0,4.915,0.292,6.777,0.774 c0.561-4.713,3.013-8.564,6.259-10.088c-0.973-0.456-2.015-0.707-3.098-0.707c-2.229,0-4.276,1.041-5.894,2.785 c0.053-2.065-0.338-4.164-1.183-5.742l-2.862-5.366l-2.865,5.366c-0.798,1.485-1.188,3.427-1.188,5.373 c0,0.123,0,0.245,0.005,0.37c-1.618-1.745-3.668-2.785-5.892-2.785c-1.085,0-2.125,0.251-3.097,0.707 C74.697,30.621,77.144,34.472,77.708,39.185z"/> </g> </g> </g> </g> <g> <g> <g> <path fill="#13110C" d="M65.325,179.18l0.128-0.811h1.711c0.804-5.373,1.766-9.441,1.766-9.441s-0.857,1.279-2.128,2.479 l-0.467-0.834c1.633-1.303,3.217-3.365,3.217-3.365l0.933,0.313c-0.077,0.521-0.984,4.669-1.918,10.849h1.738l-0.129,0.811 H65.325z"/> </g> </g> <g> <g> <path fill="#13110C" d="M73.083,174.979c0-3.703,1.634-7.876,4.384-7.876c2.05,0,2.671,1.982,2.671,4.381 c0,3.885-1.686,7.875-4.357,7.875C73.86,179.359,73.083,177.432,73.083,174.979z M78.711,171.12 c0-1.956-0.415-3.104-1.347-3.104c-1.792,0-2.855,4.227-2.855,7.381c0,2.006,0.415,3.051,1.35,3.051 C77.493,178.447,78.711,174.484,78.711,171.12z"/> </g> </g> <g> <g> <path fill="#13110C" d="M82.786,174.979c0-3.703,1.635-7.876,4.385-7.876c2.049,0,2.671,1.982,2.671,4.381 c0,3.885-1.686,7.875-4.357,7.875C83.566,179.359,82.786,177.432,82.786,174.979z M88.417,171.12 c0-1.956-0.416-3.104-1.349-3.104c-1.791,0-2.853,4.227-2.853,7.381c0,2.006,0.413,3.051,1.347,3.051 C87.197,178.447,88.417,174.484,88.417,171.12z"/> </g> </g> <g> <g> <path fill="#13110C" d="M97.135,167.234c2.022,0,3.631-1.095,4.409-1.801l0.727,0.418c-1.688,3.859-5.681,10.094-9.028,13.508 l-0.753-0.547c5.424-5.764,8.562-12.414,8.562-12.414s-1.478,1.254-3.787,1.254c-0.182,0-0.39-0.027-0.597-0.053 c0.518,0.338,0.856,1.119,0.856,2.008c0,1.746-1.037,3.807-3.035,3.807c-1.453,0-2.128-1.198-2.128-2.582 c0-1.695,1.194-3.755,3.139-3.755C96.096,167.077,96.615,167.234,97.135,167.234z M93.373,170.963 c0,0.965,0.364,1.799,1.168,1.799c1.219,0,1.997-1.773,1.997-3.207c0-0.938-0.337-1.773-1.115-1.826 C94.15,167.729,93.373,169.58,93.373,170.963z M102.763,175.396c0,1.801-1.141,3.912-3.086,3.912 c-1.427,0-2.076-1.146-2.076-2.479c0-1.799,1.168-3.911,3.114-3.911C102.141,172.919,102.763,174.066,102.763,175.396z M98.639,176.962c0,0.938,0.337,1.694,1.089,1.694c1.22,0,2.024-1.877,2.024-3.363c0-0.94-0.337-1.723-1.09-1.723 C99.443,173.57,98.639,175.475,98.639,176.962z"/> </g> </g> </g> <g> <g> <g> <rect x="22.382" y="33.561" fill="#13110C" width="43.201" height="0.992"/> </g> </g> </g> <g> <g> <g> <rect x="100.711" y="33.561" fill="#13110C" width="43.204" height="0.992"/> </g> </g> </g> <g> <g> <g> <circle fill="#13110C" cx="43.509" cy="82.501" r="2.278"/> </g> </g> </g> <g> <g> <g> <circle fill="#13110C" cx="124.59" cy="82.501" r="2.278"/> </g> </g> </g> <g> <path fill="#FFFFFF" d="M56.679,83.767c1.656,1.656,2.706,3.958,2.706,6.542c0,2.544-1.05,4.846-2.706,6.501 c-1.696,1.697-3.998,2.706-6.542,2.706H40.89v-31.66h9.247c2.544,0,4.846,1.01,6.542,2.706c1.656,1.655,2.706,3.998,2.706,6.542 s-1.05,4.846-2.706,6.542c-0.041,0-0.041,0.041-0.081,0.041C56.639,83.726,56.639,83.726,56.679,83.767z M56.921,90.268 c0-3.19-2.261-5.896-5.249-6.582c2.988-0.687,5.249-3.393,5.249-6.583c0-3.755-3.029-6.784-6.784-6.784h-6.784v26.732h6.784 C53.893,97.052,56.921,94.023,56.921,90.268z M43.717,83.524V70.683h6.42c3.554,0,6.42,2.867,6.42,6.42 c0,3.514-3.311,6.38-6.339,6.42H43.717z M56.558,90.268c0,3.554-2.867,6.42-6.42,6.42h-6.42V83.848h6.501 C53.731,83.928,56.558,86.755,56.558,90.268z M46.18,73.146v7.874h3.957c1.091,0,2.06-0.403,2.787-1.131 c0.727-0.727,1.171-1.696,1.171-2.786c0-1.09-0.444-2.1-1.171-2.786c-0.727-0.727-1.695-1.171-2.787-1.171H46.18z M54.095,90.309 c0-1.091-0.444-2.1-1.171-2.827c-0.687-0.686-1.656-1.131-2.746-1.131H46.18v7.874h3.957c1.091,0,2.06-0.444,2.787-1.171 C53.65,92.368,54.095,91.358,54.095,90.309z"/> <path fill="#FFFFFF" d="M81.231,97.012l2.502,2.503H65.32V67.816h18.414l-2.502,2.503H67.824v26.693H81.231z M70.65,73.146v7.471 h10.582l-2.464,2.463h-10.58V70.643h13.043l2.502,2.503H70.65z M70.65,94.186h13.084l-2.502,2.503H68.188V83.444h10.58 l2.464,2.462H70.65V94.186z"/> <path fill="#FFFFFF" d="M107.64,77.063v2.503l-2.504-2.503c0-3.715-3.028-6.744-6.743-6.744c-1.858,0-3.554,0.646-4.806,1.777 c-1.293,1.211-1.979,2.827-1.979,4.644c0,3.553,3.353,6.138,6.703,7.107c3.23,0.969,6.461,3.433,6.461,6.784 c0,3.433-2.746,6.057-6.38,6.057c-3.554,0-6.421-2.867-6.421-6.42l2.463-2.463v2.463c0,2.181,1.775,3.957,3.958,3.957 c2.261,0,3.916-1.534,3.916-3.594c0-2.1-2.423-3.755-4.684-4.401c-2.06-0.605-3.997-1.696-5.451-3.029 c-1.979-1.817-3.029-4.078-3.029-6.461c0-2.503,0.969-4.765,2.746-6.46c1.737-1.575,4.038-2.424,6.502-2.424 C103.482,67.856,107.64,71.975,107.64,77.063z M107.64,90.631c0,2.464-1.01,4.765-2.787,6.42c-1.735,1.575-4.038,2.464-6.46,2.464 c-5.129,0-9.248-4.16-9.248-9.248v-2.463l2.464,2.463c0,3.715,3.028,6.784,6.784,6.784c1.817,0,3.513-0.646,4.765-1.816 c1.291-1.171,1.979-2.827,1.979-4.604c0-1.696-0.768-3.311-2.221-4.644c-1.172-1.09-2.786-1.979-4.483-2.464 c-3.229-0.969-6.46-3.432-6.46-6.784c0-3.472,2.745-6.057,6.421-6.057c3.513,0,6.38,2.867,6.38,6.38v0.04l-2.464,2.463v-2.503 c0-2.14-1.735-3.917-3.916-3.917c-2.302,0-3.958,1.494-3.958,3.594c0,2.221,2.786,3.836,4.685,4.402 c2.06,0.605,4.038,1.696,5.492,3.028C106.59,85.988,107.64,88.208,107.64,90.631z"/> <path fill="#FFFFFF" d="M132.273,67.856l-2.504,2.463h-13.527l-2.465-2.463H132.273z M120.359,99.516V73.146h-6.582l2.465-2.463 h6.582v26.369L120.359,99.516z M129.769,70.683l2.504,2.463h-6.623v26.369l-2.463-2.464V70.683H129.769z"/> </g> <g> <path fill="#FFFFFF" d="M48.423,121.803c0,0.477,0,0.895,0.06,1.282c0.716-0.179,1.312-0.269,1.85-0.269 c1.015,0,1.761,0.328,2.387,0.806c2.029-2.566,3.67-7.608,3.67-11.904c0-3.462-0.686-5.223-3.818-5.223 c-4.565,0-8.593,2.925-8.593,7.669c0,1.163,0.298,1.372,0.298,1.611c-1.88,0-3.014-0.688-3.014-2.507 c0-4.177,5.729-8.146,12.024-8.146c5.221,0,7.071,3.193,7.071,7.639c0,4.207-1.73,10.233-5.698,13.188 c0.895,1.253,1.85,2.416,3.729,2.416c0.208,0,0.417-0.029,0.656-0.06c-0.776,2.06-1.79,2.566-3.073,2.566 c-2.626,0-3.312-1.851-3.85-3.61c-0.835,0.268-1.76,0.418-2.774,0.418c-3.133,0-5.341-1.641-5.341-5.997 c0-4.834,2.715-13.993,8.086-13.993c0.507,0,1.014,0.06,1.551,0.238C50.929,109.568,48.423,117.207,48.423,121.803z M51.288,124.935c-0.358-0.597-0.866-1.015-1.701-1.015c-0.269,0-0.538,0.03-0.866,0.119c0.269,0.775,0.716,1.223,1.433,1.223 C50.511,125.262,50.929,125.174,51.288,124.935z"/> <path fill="#FFFFFF" d="M74.322,112.582l-2.149,10.145c-0.089,0.389-0.119,0.688-0.119,0.955c0,0.836,0.388,1.104,1.224,1.104 c1.164,0,1.969-1.133,2.417-2.625h1.253c-1.701,4.863-4.386,5.52-5.997,5.52c-1.701,0-2.775-0.984-2.954-2.834 c-1.492,2.445-3.163,2.834-4.416,2.834c-1.791,0-3.193-1.074-3.193-3.58c0-0.568,0.09-1.223,0.239-1.939l2.029-9.578h4.295 l-2.147,10.145c-0.06,0.299-0.089,0.566-0.089,0.836c0,0.687,0.239,1.223,0.895,1.223c1.163,0,1.939-1.133,2.387-2.625 l2.028-9.578H74.322z"/> <path fill="#FFFFFF" d="M90.017,112.582l-2.148,10.145c-0.09,0.389-0.119,0.688-0.119,0.955c0,0.836,0.387,1.283,1.223,1.283 c1.164,0,1.971-1.312,2.416-2.805h1.254c-1.699,4.863-4.387,5.52-5.996,5.52c-1.672,0-2.746-0.955-2.925-2.745 c-0.925,1.372-2.327,2.745-4.446,2.745c-2.028,0-3.968-1.254-3.968-4.803c0-4.029,2.476-10.443,7.668-10.443 c1.7,0,2.417,0.656,2.417,1.521v0.21l0.328-1.582H90.017z M79.724,122.459c0,2.297,0.954,2.326,1.491,2.326 c0.865,0,2.119-0.895,2.477-2.625l1.432-6.742c0-0.359-0.269-1.135-1.224-1.135C81.364,114.283,79.724,119.654,79.724,122.459z"/> <path fill="#FFFFFF" d="M98.999,106.615l-3.433,16.111c-0.088,0.389-0.118,0.688-0.118,0.955c0,0.836,0.388,1.104,1.222,1.104 c1.165,0,2.239-1.133,2.687-2.625h1.253c-1.7,4.863-4.654,5.52-6.266,5.52c-1.79,0-3.191-1.074-3.191-3.58 c0-0.568,0.088-1.223,0.238-1.939l3.192-14.948L98.999,106.615z"/> <path fill="#FFFFFF" d="M105.682,112.582l-2.147,10.145c-0.09,0.389-0.119,0.688-0.119,0.955c0,0.836,0.387,1.104,1.221,1.104 c1.165,0,2.239-1.133,2.688-2.625h1.252c-1.7,4.863-4.654,5.52-6.266,5.52c-1.789,0-3.192-1.074-3.192-3.58 c0-0.568,0.091-1.223,0.239-1.939l2.028-9.578H105.682z M104.339,106.229c1.312,0,2.387,1.072,2.387,2.385 c0,1.314-1.074,2.358-2.387,2.358s-2.357-1.044-2.357-2.358C101.982,107.301,103.027,106.229,104.339,106.229z"/> <path fill="#FFFFFF" d="M114.664,107.869l-1.015,4.713h1.79l-0.238,1.193h-1.791l-1.908,8.951c-0.09,0.389-0.12,0.688-0.12,0.955 c0,0.836,0.388,1.104,1.223,1.104c1.165,0,2.239-1.133,2.686-2.625h1.253c-1.699,4.863-4.653,5.52-6.265,5.52 c-1.791,0-3.192-1.074-3.192-3.58c0-0.568,0.089-1.223,0.239-1.939l1.79-8.385h-0.985l0.239-1.193h0.984l0.895-4.117 L114.664,107.869z"/> <path fill="#FFFFFF" d="M121.616,112.582l-2.147,10.145c-0.061,0.238-0.09,0.508-0.09,0.746c0,0.686,0.209,1.312,0.895,1.312 c1.163,0,1.939-1.133,2.387-2.625l2.029-9.578h4.327l-3.642,17.305c-0.895,4.268-3.46,5.073-5.43,5.073 c-1.82,0-3.521-1.283-3.521-3.223c0-2.774,2.327-3.64,5.161-4.476l0.299-1.312c-1.282,1.463-2.625,1.73-3.641,1.73 c-1.789,0-3.192-1.074-3.192-3.58c0-0.568,0.09-1.223,0.239-1.939l2.028-9.578H121.616z M119.259,132.303 c0.596,0,1.372-0.565,1.76-2.326l0.357-1.76c-1.879,0.626-3.311,1.492-3.311,3.104 C118.066,131.737,118.602,132.303,119.259,132.303z"/> </g></g></svg>';
		
		
		
		/**
		 * Special Offers
		 */
		$svg['special_offers']['colors'] = array();
		$svg['special_offers']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['special_offers']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><g> <g> <g> <path fill="#262421" d="M91.248,16.607c0,0,7.891-1.702,15.875,1.075c9.863,3.431,41.39,11.583,46.539,13.511 c5.148,1.93,10.077,0.213,10.077,18.018l-0.429,84.929l0.218,15.658c0,0,1.716,15.227-7.938,17.373 c-9.652,2.145-36.889,10.506-36.889,10.506l-6.861,2.359l-5.577,1.506c0,0-7.991,2.82-16.086-0.217 c-8.581-3.217-27.238-7.721-27.238-7.721l-20.804-6.221c0,0-9.14-2.268-9.222-12.438c-0.098-12.01-0.431-99.732-0.431-99.732 l-0.011-11.797c0,0-1.039-10.097,12.452-12.868C60.31,27.39,91.248,16.607,91.248,16.607z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M98.292,177.482c-2.782,0-5.406-0.458-7.804-1.355c-7.852-2.941-25.091-7.117-25.264-7.156l-19.392-5.797 c-0.059-0.014-8.989-2.345-9.069-12.225c-0.088-11.05-0.396-91.981-0.398-92.797l-0.013-10.979 c-0.006-0.031-0.875-9.972,12.132-12.643c14.109-2.898,42.729-12.849,43.018-12.949c0.173-0.042,2.417-0.519,5.693-0.519 c3.424,0,6.629,0.511,9.526,1.519c4.942,1.719,15.846,4.742,25.465,7.409c8.385,2.325,15.625,4.333,17.853,5.168 c0.675,0.252,1.359,0.439,2.021,0.62c4.186,1.141,7.801,2.126,7.801,16.785l-0.398,79.026l0.201,14.556 c0.063,0.538,1.555,14.737-7.92,16.843c-8.852,1.968-34.018,9.682-34.271,9.761l-6.361,2.19l-5.232,1.412 C105.793,176.383,102.624,177.482,98.292,177.482z M97.195,22.432c-3.12,0-5.302,0.46-5.323,0.465 c-0.208,0.078-28.913,10.059-43.111,12.974c-11.759,2.415-11.077,10.873-11.042,11.231l0.016,11.045 c0.003,0.815,0.311,81.745,0.399,92.792c0.072,8.828,7.98,10.895,8.061,10.912l19.388,5.794 c0.138,0.035,17.457,4.226,25.388,7.198c2.242,0.841,4.704,1.27,7.322,1.27c4.085,0,7.149-1.061,7.179-1.071l5.237-1.413 l6.339-2.184c0.276-0.086,25.494-7.819,34.398-9.797c8.283-1.841,6.867-15.283,6.851-15.418l-0.206-14.637l0.398-79.035 c0-13.609-2.996-14.426-6.791-15.46c-0.689-0.188-1.408-0.384-2.141-0.658c-2.171-0.813-9.732-2.91-17.737-5.131 c-9.639-2.672-20.563-5.702-25.548-7.435C103.521,22.917,100.467,22.432,97.195,22.432z"/> </g> </g> <g> <g> <polygon fill="#726F6D" points="25.572,88.952 171.292,69.375 171.292,114.906 25.572,135.394 "/> </g> </g> <g> <g> <polygon fill="#474442" points="3.631,78.482 32.61,75.295 25.572,88.952 25.572,109.895 4.045,112.625 15.637,93.963 "/> </g> </g> <g> <g> <polygon fill="#474442" points="171.499,92.346 196.369,88.729 183.697,108.343 196.369,126.408 163.518,131.568  171.499,115.053 "/> </g> </g> <g> <g> <polygon fill="#14120D" points="162.949,116.179 171.499,115.053 163.184,131.568 "/> </g> </g> <g> <g> <polygon fill="#14120D" points="32.714,75.324 25.575,89.176 32.722,88.185 "/> </g> </g> <g> <g> <g> <g> <path fill="#FFFFFF" d="M41.093,111.068c-0.45,0.066-0.866-0.021-1.243-0.278c-0.646-0.394-0.898-1.148-0.748-2.262 l0.343-2.565c0.142-1.081,0.588-2.059,1.338-2.936c0.75-0.881,1.573-1.387,2.473-1.528l1.027-0.158 c0.897-0.136,1.617,0.128,2.16,0.808c0.543,0.678,0.743,1.559,0.602,2.634l-0.189,1.429l-2.813,0.434l0.494-3.703 c0.044-0.336-0.012-0.607-0.17-0.816c-0.165-0.211-0.38-0.297-0.655-0.252c-0.278,0.043-0.534,0.201-0.76,0.467 c-0.231,0.271-0.369,0.574-0.412,0.906l-0.569,4.273c-0.261,1.954-0.182,2.904,0.242,2.84l1.783-0.281 c0.447-0.064,0.87,0.017,1.264,0.252c0.646,0.396,0.895,1.152,0.748,2.258l-0.444,3.337c-0.143,1.077-0.591,2.056-1.341,2.933 c-0.749,0.879-1.576,1.387-2.47,1.523l-1.028,0.16c-0.899,0.143-1.619-0.128-2.16-0.809c-0.543-0.677-0.746-1.557-0.602-2.633 l0.19-1.426l2.791-0.434l-0.492,3.709c-0.048,0.334,0.014,0.605,0.18,0.811c0.167,0.21,0.386,0.295,0.666,0.249 c0.276-0.039,0.527-0.198,0.75-0.463c0.225-0.271,0.358-0.575,0.401-0.904l0.669-5.015c0.256-1.954,0.185-2.904-0.229-2.84 L41.093,111.068z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M56.023,100.364c0.393,0.494,0.544,1.154,0.433,1.962l-0.52,3.926c-0.106,0.811-0.44,1.535-0.988,2.178 c-0.55,0.646-1.163,1.022-1.84,1.123l-2.47,0.383l-1.162,8.738l0.634-0.099l-0.069,0.524l-3.838,0.591l0.067-0.522l0.776-0.119 l2.384-17.969l-0.768,0.119l0.074-0.545l5.674-0.884C55.089,99.667,55.622,99.866,56.023,100.364z M53.732,102.86 c0.221-1.665,0.051-2.457-0.498-2.368l-1.368,0.211l-1.159,8.71l1.309-0.2c0.399-0.062,0.673-0.31,0.834-0.736 c0.138-0.367,0.285-1.14,0.442-2.33L53.732,102.86z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M65.039,98.125l-0.519,3.931l-0.455,0.069l0.447-3.38l-3.048,0.472l-1.143,8.614l3.045-0.471 l0.214-1.616l0.455-0.071l-0.524,3.951l-0.456,0.067l0.214-1.616l-3.048,0.473l-1.148,8.639l3.048-0.468l0.453-3.405 l0.455-0.074l-0.522,3.929l-6.705,1.039l0.066-0.522l0.773-0.12l2.388-17.972l-0.774,0.125l0.078-0.552L65.039,98.125z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M72.518,110.349l-0.188,1.427c-0.146,1.078-0.591,2.061-1.339,2.938 c-0.75,0.875-1.574,1.384-2.469,1.525l-1.03,0.154c-0.896,0.143-1.618-0.128-2.16-0.805c-0.541-0.677-0.744-1.555-0.601-2.633 l1.483-11.144c0.146-1.08,0.592-2.052,1.34-2.931c0.75-0.878,1.572-1.388,2.47-1.524l1.029-0.163 c0.894-0.139,1.618,0.132,2.16,0.809c0.543,0.677,0.74,1.557,0.595,2.637l-0.186,1.425l-2.812,0.436l0.492-3.704 c0.048-0.338-0.008-0.609-0.171-0.818c-0.155-0.21-0.376-0.296-0.656-0.254c-0.276,0.047-0.524,0.199-0.757,0.472 c-0.23,0.268-0.364,0.57-0.409,0.904l-2.09,15.698c-0.044,0.34,0.016,0.609,0.182,0.816c0.165,0.205,0.391,0.291,0.664,0.246 c0.281-0.037,0.527-0.195,0.751-0.467c0.223-0.264,0.357-0.566,0.4-0.906l0.495-3.704L72.518,110.349z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M76.602,114.472l0.673-0.104l-0.068,0.524l-3.878,0.6l0.068-0.527l0.775-0.115l2.39-17.994l-0.768,0.12 l0.069-0.526l3.875-0.604l-0.07,0.527l-0.673,0.102L76.602,114.472z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M88.83,112.578l-0.071,0.548l-3.878,0.6l0.073-0.549l0.674-0.103l-0.104-4.929l-3.522,0.55 l-1.523,5.174l0.656-0.101l-0.075,0.546l-1.936,0.305l0.074-0.551l0.473-0.072l5.433-18.442l-0.868,0.135l0.07-0.522 l4.333-0.671l-0.07,0.521l-0.853,0.131l0.366,17.547L88.83,112.578z M85.526,107.396l-0.212-9.893l-3.074,10.405 L85.526,107.396z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M97.592,107.887l-0.519,3.928l-6.711,1.041l0.071-0.527l0.775-0.115l2.389-17.996l-0.672,0.105 l0.072-0.524l3.872-0.605l-0.064,0.53l-0.773,0.115l-2.393,17.994l3.046-0.472l0.455-3.404L97.592,107.887z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M111.348,105.729c-0.145,1.084-0.588,2.06-1.338,2.938c-0.752,0.875-1.576,1.389-2.473,1.525 l-1.028,0.158c-0.899,0.137-1.618-0.125-2.157-0.809c-0.543-0.675-0.746-1.558-0.602-2.633l1.478-11.141 c0.147-1.078,0.593-2.055,1.347-2.934c0.744-0.879,1.57-1.385,2.47-1.527l1.026-0.155c0.897-0.142,1.615,0.128,2.16,0.805 c0.543,0.677,0.742,1.555,0.597,2.636L111.348,105.729z M110.344,92.744c0.043-0.334-0.016-0.606-0.176-0.815 c-0.161-0.21-0.385-0.294-0.664-0.246c-0.275,0.042-0.535,0.198-0.764,0.469c-0.232,0.27-0.369,0.572-0.416,0.904l-2.086,15.7 c-0.047,0.337,0.016,0.61,0.186,0.82c0.168,0.208,0.389,0.287,0.672,0.24c0.281-0.043,0.529-0.195,0.754-0.467 c0.223-0.268,0.361-0.569,0.404-0.9L110.344,92.744z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M116.719,108.773l-3.977,0.615l0.068-0.525l0.773-0.121l2.388-17.968l-0.771,0.116l0.072-0.543 l6.711-1.041l-0.526,3.926l-0.452,0.075l0.449-3.383l-3.051,0.472l-1.146,8.617l3.052-0.471l0.216-1.62l0.452-0.071 l-0.524,3.953L120,100.871l0.217-1.618l-3.051,0.474l-1.151,8.642l0.771-0.124L116.719,108.773z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M125.046,107.48l-3.974,0.615l0.07-0.525l0.768-0.12l2.393-17.967l-0.773,0.121l0.072-0.546 l6.709-1.041l-0.52,3.926l-0.457,0.069l0.449-3.375l-3.048,0.468l-1.144,8.616l3.043-0.47l0.217-1.623l0.455-0.067 l-0.524,3.948l-0.454,0.072l0.213-1.619l-3.051,0.474l-1.145,8.641l0.773-0.122L125.046,107.48z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M138.641,86.725l-0.52,3.926l-0.457,0.073l0.453-3.379l-3.053,0.474l-1.145,8.613l3.045-0.469 l0.221-1.62l0.452-0.069l-0.524,3.95l-0.455,0.071l0.214-1.622l-3.048,0.472l-1.146,8.641l3.046-0.474l0.452-3.401l0.452-0.068 l-0.521,3.926l-6.707,1.037l0.066-0.523l0.776-0.121l2.39-17.967l-0.773,0.12l0.074-0.55L138.641,86.725z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M147,103.57l-0.068,0.521l-3.266,0.504l0.844-6.332c0.26-1.951,0.179-2.893-0.244-2.826l-2.02,0.311 l-1.164,8.736l0.636-0.098l-0.072,0.522l-3.837,0.594l0.072-0.522l0.768-0.117l2.393-17.974l-0.771,0.119l0.073-0.544 l5.678-0.879c0.674-0.109,1.209,0.086,1.607,0.584c0.395,0.502,0.544,1.153,0.434,1.964l-0.484,3.665 c-0.093,0.684-0.352,1.316-0.778,1.903c-0.429,0.587-0.921,1.002-1.485,1.244c1.52,0.044,2.168,0.925,1.938,2.64l-0.803,6.068 L147,103.57z M145.339,88.673c0.22-1.666,0.059-2.455-0.501-2.371l-1.363,0.21l-1.16,8.712l1.307-0.204 c0.383-0.057,0.66-0.306,0.834-0.734c0.143-0.377,0.289-1.154,0.445-2.328L145.339,88.673z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M152.566,93.8c-0.449,0.072-0.867-0.023-1.244-0.273c-0.646-0.394-0.896-1.151-0.749-2.261l0.34-2.569 c0.145-1.083,0.595-2.061,1.341-2.938c0.752-0.878,1.576-1.386,2.475-1.525l1.025-0.158c0.896-0.142,1.617,0.129,2.16,0.808 c0.545,0.677,0.743,1.556,0.6,2.634l-0.19,1.429l-2.81,0.437l0.49-3.709c0.047-0.335-0.009-0.606-0.17-0.816 c-0.154-0.209-0.374-0.294-0.652-0.251c-0.279,0.042-0.532,0.201-0.76,0.468c-0.229,0.271-0.369,0.576-0.41,0.906l-0.572,4.276 c-0.26,1.955-0.174,2.901,0.246,2.834l1.781-0.271c0.447-0.07,0.865,0.013,1.264,0.246c0.646,0.398,0.892,1.148,0.744,2.258 l-0.443,3.334c-0.145,1.081-0.586,2.058-1.338,2.933c-0.747,0.883-1.574,1.39-2.471,1.526l-1.03,0.162 c-0.896,0.137-1.616-0.132-2.157-0.813c-0.545-0.673-0.746-1.554-0.602-2.631l0.189-1.432l2.791-0.425l-0.494,3.704 c-0.043,0.335,0.016,0.605,0.184,0.814c0.166,0.211,0.386,0.291,0.668,0.248c0.274-0.044,0.526-0.199,0.745-0.467 c0.228-0.269,0.356-0.568,0.401-0.903l0.667-5.01c0.263-1.958,0.19-2.906-0.22-2.842L152.566,93.8z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M158.559,98.84l1.646-15.455l1.562-0.241l-2.497,15.583L158.559,98.84z M159.195,100.883l-1.127,0.177 l-0.176,1.332l1.127-0.176L159.195,100.883z"/> </g> </g> </g> </g> <g> <g> <path fill="#FAFAFB" d="M91.839,46.763c1.582-0.405,3.579-0.654,5.752-0.654c2.175,0,4.172,0.249,5.754,0.654 c0.478-3.979,2.557-7.229,5.312-8.518c-0.825-0.383-1.709-0.595-2.63-0.595c-1.892,0-3.63,0.881-5.002,2.352 c0.045-1.744-0.287-3.515-1.003-4.847l-2.431-4.532l-2.431,4.532c-0.674,1.251-1.007,2.893-1.007,4.534 c0,0.106,0,0.207,0.004,0.313c-1.374-1.471-3.111-2.352-5-2.352c-0.921,0-1.807,0.212-2.629,0.595 C89.285,39.533,91.359,42.784,91.839,46.763z"/> </g> </g> <g> <g enable-background="new "> <defs> <polygon id="SVGID_1_" enable-background="new " points="69.066,155.727 69.097,139.048 128.873,130.647 128.841,147.326  "/> </defs> <clipPath id="SVGID_2_"> <use xlink:href="#SVGID_1_" overflow="visible"/> </clipPath> <g clip-path="url(#SVGID_2_)"> <polyline fill="#FFFFFF" points="70.221,138.891 69.109,139.047 69.072,152.488 70.184,152.337 70.204,145.874 73.224,145.453  73.203,151.917 74.315,151.761 74.356,138.313 73.24,138.471 73.225,144.378 70.206,144.802 70.221,138.891 "/> <path fill="#FFFFFF" d="M76.278,143.129l-0.024,8.363l1.049-0.147l0.027-8.36L76.278,143.129 M77.356,139.707l-1.084,0.152 l-0.002,1.443l1.08-0.152L77.356,139.707"/> <path fill="#FFFFFF" d="M82.488,149.617l-1.471,0.203c-0.59,0.082-0.882-0.197-0.881-0.838l0.012-4.477 c0.005-0.641,0.298-1.002,0.884-1.084c0.138-0.02,0.629-0.059,1.476-0.122L82.488,149.617 M80.594,142.479 c-0.443,0.062-0.806,0.28-1.08,0.643c-0.278,0.368-0.417,0.798-0.418,1.288l-0.017,4.893c-0.001,0.512,0.157,0.921,0.469,1.215 c0.316,0.297,0.707,0.412,1.186,0.35l1.753-0.246l-0.008,2.199l-2.224,0.309l0.002-1.105l-1.048,0.147 c0,0.085-0.004,0.222-0.013,0.415c-0.008,0.193-0.016,0.34-0.017,0.438c-0.001,0.815,0.306,1.187,0.919,1.1l2.533-0.355 c0.004-0.001,0.008-0.001,0.012-0.001c0.594-0.084,0.891-0.45,0.893-1.096l0.031-10.559l-1.057,0.148l0,0.23 c-1.143-0.027-1.772-0.033-1.898-0.015C80.605,142.478,80.6,142.479,80.594,142.479"/> <path fill="#FFFFFF" d="M86.401,136.633l-1.064,0.15l-0.041,13.447l1.064-0.15l0.021-7.271l2.347-0.394l-0.021,7.339l1.068-0.15 l0.018-7.475c0.005-0.623-0.291-0.894-0.884-0.814c-0.305,0.042-0.725,0.14-1.259,0.288c-0.419,0.118-0.843,0.233-1.267,0.348 L86.401,136.633"/> <path fill="#FFFFFF" d="M99.017,147.26l-3.066,0.428l0.033-11.333l3.067-0.427l-0.026,9.538l-1.225-0.921l-0.103,0.014 l-0.002,1.176l1.327,1L99.017,147.26 M95.763,135.33c-0.265,0.038-0.475,0.152-0.641,0.355s-0.25,0.44-0.25,0.723l-0.033,11.537 c-0.001,0.281,0.082,0.501,0.248,0.652c0.161,0.156,0.375,0.217,0.636,0.18l3.526-0.495c0.004-0.001,0.008-0.001,0.012-0.002 c0.439-0.062,0.71-0.334,0.804-0.813l0.826,0.605l0.095-0.014l0.002-1.174l-0.853-0.623l0.031-10.594 c0-0.277-0.082-0.496-0.244-0.653c-0.162-0.151-0.375-0.212-0.637-0.175L95.763,135.33"/> <path fill="#FFFFFF" d="M102.113,139.527l-0.018,7.484c-0.006,0.619,0.283,0.886,0.861,0.81 c0.336-0.048,0.758-0.142,1.273-0.282c0.42-0.114,0.843-0.233,1.271-0.357l-0.001,0.23l1.053-0.144l0.023-8.364l-1.049,0.147 l-0.021,7.271l-2.365,0.396l0.021-7.334L102.113,139.527"/> <path fill="#FFFFFF" d="M109.285,145.898l0.01-3.008l2.377-0.33l-0.009,2.956L109.285,145.898 M109.26,138.532 c-0.602,0.085-0.899,0.45-0.9,1.096l-0.006,1.409l1.037-0.145l0.002-1.428l2.291-0.317l-0.01,2.517l-2.504,0.352 c-0.605,0.086-0.907,0.448-0.908,1.088l-0.01,3.051c0,0.619,0.287,0.887,0.869,0.805c0.316-0.045,0.736-0.134,1.259-0.275 c0.423-0.119,0.843-0.238,1.267-0.361l-0.002,0.234l1.051-0.147l0.021-7.39c0.001-0.645-0.298-0.928-0.896-0.844L109.26,138.532 "/> <polyline fill="#FFFFFF" points="115.592,132.565 114.54,132.713 114.502,146.16 115.552,146.012 115.592,132.565 "/> <path fill="#FFFFFF" d="M117.45,137.389l-0.023,8.359l1.048-0.143l0.024-8.359L117.45,137.389 M118.525,133.968l-1.084,0.153 l-0.003,1.442l1.081-0.151L118.525,133.968"/> <path fill="#FFFFFF" d="M121.76,134.188l-1.052,0.148l-0.009,2.602l-0.934,0.131l-0.002,1.004l0.934-0.127l-0.016,6.381 c-0.002,0.649,0.295,0.932,0.893,0.848l1.516-0.213l0.002-1.004l-1.361,0.188l0.02-6.348l1.361-0.191l0.002-1.004l-1.361,0.188 L121.76,134.188"/> <polyline fill="#FFFFFF" points="125.123,136.318 124.023,136.474 125.922,144.499 125.129,147.848 126.178,147.7  126.963,144.353 128.862,135.799 127.798,135.948 126.432,142.72 125.123,136.318 "/> </g> </g> </g> <g> <g> <path fill="#FFFFFF" d="M51.139,78.68c7.148-1.177,14.309-2.265,21.471-3.338l21.503-3.113l21.53-2.923l10.771-1.391 l10.788-1.304l-10.729,1.716l-10.74,1.624l-21.503,3.114L72.7,75.984C65.52,76.922,58.335,77.848,51.139,78.68z"/> </g> </g> <g> <g> <path fill="#FFFFFF" d="M63.781,71.451c5.13-0.844,10.271-1.625,15.412-2.396l15.434-2.235l15.453-2.097l7.732-0.999l7.744-0.937 l-7.703,1.232l-7.709,1.166L94.71,67.421l-15.452,2.095C74.104,70.19,68.946,70.854,63.781,71.451z"/> </g> </g></g></svg>';
		
		
		
		/**
		 * Premium Quality 1
		 */
		$svg['premium_quality_1']['colors'] = array();
		$svg['premium_quality_1']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['premium_quality_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><g> <g> <g> <g> <g> <g> <g> <path class="colorful c2" fill="#474442" d="M196.189,99.718c0,5.035-2.865,9.784-3.625,14.608c-0.78,4.951,0.473,10.352-1.041,15.014 c-1.54,4.746-5.737,8.376-7.98,12.76c-2.26,4.432-2.744,9.959-5.646,13.952c-2.921,4.011-8.036,6.169-11.536,9.669 c-3.498,3.502-5.656,8.613-9.669,11.529c-3.995,2.908-9.522,3.393-13.95,5.654c-4.383,2.238-8.016,6.438-12.761,7.979 c-4.665,1.515-10.064,0.263-15.016,1.04c-4.823,0.758-9.57,3.625-14.607,3.625c-5.035,0-9.785-2.867-14.608-3.625 c-4.951-0.777-10.351,0.475-15.013-1.04c-4.748-1.541-8.377-5.74-12.761-7.98c-4.43-2.26-9.954-2.744-13.951-5.652 c-4.012-2.918-6.171-8.028-9.67-11.529c-3.498-3.5-8.613-5.658-11.535-9.674c-2.902-3.988-3.389-9.518-5.649-13.947 c-2.239-4.384-6.436-8.014-7.979-12.76c-1.514-4.662-0.263-10.062-1.042-15.014c-0.757-4.824-3.623-9.573-3.623-14.608 c0-5.035,2.866-9.784,3.623-14.607C8.931,80.16,7.68,74.759,9.193,70.095c1.542-4.747,5.74-8.376,7.979-12.76 c2.261-4.431,2.747-9.958,5.649-13.949c2.922-4.012,8.037-6.172,11.539-9.672c3.495-3.498,5.654-8.609,9.666-11.531 c3.997-2.906,9.524-3.39,13.951-5.652c4.384-2.237,8.013-6.437,12.761-7.978C75.4,7.04,80.8,8.289,85.751,7.513 c4.823-0.758,9.573-3.626,14.608-3.626c5.037,0,9.784,2.868,14.607,3.626c4.951,0.776,10.351-0.473,15.016,1.04 c4.745,1.542,8.378,5.741,12.761,7.978c4.428,2.263,9.959,2.746,13.95,5.652c4.013,2.922,6.171,8.034,9.669,11.531 c3.502,3.5,8.615,5.66,11.536,9.672c2.901,3.992,3.386,9.52,5.646,13.949c2.243,4.383,6.44,8.013,7.98,12.76 c1.514,4.664,0.261,10.064,1.041,15.015C193.324,89.934,196.189,94.683,196.189,99.718z"/> </g> </g> </g> </g> </g> </g></g><g> <g> <g> <g> <g> <g> <g> <path class="colorful c1" fill="#FBFAF6" d="M188.064,99.718c0,48.44-39.263,87.705-87.706,87.705c-48.44,0-87.706-39.265-87.706-87.705 c0-48.441,39.266-87.707,87.706-87.707C148.802,12.011,188.064,51.277,188.064,99.718z"/> </g> </g> </g> </g> </g> </g></g><g> <g> <g> <g> <g> <g> <g> <path class="colorful c3" fill="#14120D" d="M100.359,182.314c-45.547,0-82.599-37.051-82.599-82.597c0-45.545,37.052-82.597,82.599-82.597 c45.545,0,82.598,37.052,82.598,82.597C182.957,145.264,145.904,182.314,100.359,182.314z M100.359,18.364 c-44.858,0-81.354,36.496-81.354,81.354c0,44.856,36.496,81.353,81.354,81.353c44.856,0,81.356-36.496,81.356-81.353 C181.715,54.86,145.215,18.364,100.359,18.364z"/> </g> </g> </g> </g> </g> </g></g><g> <g> <g> <g> <g> <g> <g> <polygon class="colorful c2" fill="#474442" points="38.836,115.088 9.386,115.088 9.386,81.882 38.836,81.882 34.692,98.517 "/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <polygon class="colorful c2" fill="#474442" points="159.133,115.088 188.585,115.088 188.585,81.882 159.133,81.882 163.276,98.517 "/> </g> </g> </g> </g> </g> </g></g><g> <g> <path class="colorful c3" fill="#14120D" d="M85.634,150.376c-2.439,3.501-6.66,2.156-15.476-4.408c-1.407,0.5-2.845,0.688-4.19,0.563 c-5.219-0.469-7.971-5.033-6.659-12.444c1.813-9.909,10.692-12.911,14.693-10.849c1.126,0.595-2.219,1.064-2.375,0.907 c-3.032-2.907-8.41,3.065-9.629,9.88c-0.781,4.281-0.25,7.909,1.501,9.91c0.094-0.188,0.25-0.438,0.468-0.688 c0.907-1.063,2.94-1.063,4.971,0.499l1.376,0.97c2.564-1.594,4.784-5.127,5.503-9.441c0.093-0.5,0.187-1,0.218-1.501 c-1.875,0.626-3.97,0.501-5.783-0.626c-3.846-2.438-3.377-7.752,1.813-8.283c3.502-0.375,6.221,2.031,6.596,6.659 c1.47-1.532,2.157-3.908,1.063-6.815c-0.125-0.25,0.469-0.406,0.656,0.031c1.313,3.062,0.282,5.814-1.688,7.564 c0.031,0.875-0.031,1.846-0.187,2.877c-0.781,5.002-3.72,8.565-7.16,10.285c6.566,4.439,11.475,5.689,13.726,4.127 C85.352,149.594,85.852,150.031,85.634,150.376z M69.251,145.28l-0.718-0.563c-2.814-2.158-3.97-1.094-4.22-0.719l-0.251,0.5 c0.782,0.626,1.72,1.032,2.846,1.157C67.687,145.718,68.47,145.592,69.251,145.28z M76.099,133.088 c0.344-4.723-1.22-7.723-4.753-7.316c-3.345,0.375-3.626,4.596-0.594,6.596C72.409,133.432,74.378,133.619,76.099,133.088z"/> </g> <g> <path class="colorful c3" fill="#14120D" d="M94.197,141.747c-0.751,2.438-3.377,3.783-4.971,2.751c-0.907-0.562-1.812-1.532-2.251-3.688 c-0.688,2.188-1.751,3.907-3.22,3.907c-1.751,0-4.095-1.656-3.97-5.877c0.093-2.127,0.406-4.814,0.687-5.533 c0.25-0.688,3.283-1.533,3-0.876c-0.468,0.97-0.969,2.157-1.313,6.003c-0.312,3.595,0.752,5.221,2.126,5.221 c1.376,0,2.064-2.969,2.438-5.689c0.031-1.313,0.188-2.877,0.562-4.658c0.157-0.719,3.221-1.564,3.001-0.876 c-0.875,2.407-1.25,5.658-1.345,7.159c-0.156,2.595,0.531,3.939,1.158,4.377c1.188,0.812,2.907-0.531,3.376-2.157 C93.729,141.027,94.447,140.934,94.197,141.747z"/> </g> <g> <path class="colorful c3" fill="#14120D" d="M106.482,142.092c-0.719,2.406-3.033,3.438-4.627,2.406c-0.906-0.562-1.844-1.563-2.283-3.782 c-0.656,2.25-1.688,4.032-3.188,4.032c-1.909,0-4.503-1.969-3.877-7.004c0.782-6.5,6.064-6.626,7.661-4.751 c0.749-0.626,2.939-1.157,2.718-0.562c-0.844,2.407-1.219,5.658-1.312,7.159c-0.158,2.595,0.531,3.971,1.156,4.377 c1.188,0.812,2.563-0.188,3.064-1.812C106.045,141.341,106.764,141.247,106.482,142.092z M99.417,136.745 c0.063-0.876,0.188-1.845,0.375-2.845c-0.533-2.314-4.219-1.407-4.845,3.596c-0.501,4.281,0.468,6.188,1.97,6.188 C98.511,143.685,99.104,139.715,99.417,136.745z"/> </g> <g> <path class="colorful c3" fill="#14120D" d="M113.578,141.622c-0.375,1.282-3.125,3.97-5.565,3.095c-3.187-1.156-2.813-8.379-1.532-21.133 c0.031-0.438,3.035-0.594,2.972-0.156c-2.722,14.441-2.409,19.914-0.468,20.633c1.311,0.499,3.5-1.281,3.876-2.407 C113.141,140.871,113.798,140.777,113.578,141.622z"/> </g> <g> <path class="colorful c3" fill="#14120D" d="M114.265,144.404c-1.97-1.281-3.188-5.439-2.063-10.693c0.125-0.531,3.127-0.718,2.939-0.187 c-1.689,4.722-1.407,9.505-0.125,10.411c1.25,0.844,3-0.094,3.345-1.907c0.156-0.813,0.875-0.907,0.688-0.062 C118.547,144.279,116.328,145.748,114.265,144.404z M112.92,129.336c-0.219-0.688,0.312-1.502,1.219-1.814 c0.877-0.281,1.783,0.031,2.032,0.751c0.22,0.688-0.312,1.501-1.218,1.782C114.076,130.367,113.17,130.023,112.92,129.336z"/> </g> <g> <path class="colorful c3" fill="#14120D" d="M120.391,131.399c-1.062,7.721-0.531,11.88,1.533,12.661c1.312,0.499,2.908-1.281,3.281-2.407 c0.283-0.782,0.939-0.876,0.689-0.031c-0.344,1.282-2.533,3.97-4.939,3.095c-2.846-1.062-3.471-6.471-3.064-13.536 c-0.75-0.095-1.47-0.251-2.096-0.407c-0.404-0.125-0.155-0.75,0.189-0.656c0.562,0.125,1.25,0.219,1.937,0.25 c0.095-1.221,0.188-2.501,0.313-3.814c0.062-0.438,3.064-0.625,2.971-0.219l-0.656,3.939c1.812-0.219,3.625-0.688,5.064-1.531 c0.656-0.377,0.344,2.031,0.281,2.062C124.394,131.274,122.361,131.461,120.391,131.399z"/> </g> <g> <path class="colorful c3" fill="#14120D" d="M139.336,147.406c-1.75-1.002-3.375-1.751-6.189-1.814c-1.188,6.066-3.752,7.816-6.098,7.816 c-4.876,0-3.72-7.848,4.596-8.504c0.094-1.094,0.127-2.312,0.127-3.689c-0.689,2.064-1.721,3.659-3.129,3.659 c-1.75,0-4.125-1.688-3.969-5.878c0.062-2.158,0.406-4.814,0.688-5.535c0.25-0.718,3.281-1.562,2.971-0.904 c-0.438,0.968-0.938,2.188-1.283,6.002c-0.343,3.626,0.752,5.252,2.126,5.252c1.564,0,2.252-3.814,2.563-6.754 c0.064-1.593,0.22-2.906,0.408-3.781c0.156-0.75,3.25-1.596,3-0.908c-0.843,2.408-1.313,5.502-1.344,7.004 c-0.094,2.127-0.251,3.94-0.531,5.503c2.75,0.093,5.033,0.999,6.315,2.031C139.867,147.154,139.587,147.531,139.336,147.406z M131.582,145.625h-0.062c-5.689,0.374-6.346,6.971-3.906,6.971C129.145,152.596,130.988,151.002,131.582,145.625z"/> </g></g><g> <g> <g> <polygon class="colorful c3" fill="#14120D" points="99.48,47.196 102.105,55.28 110.602,55.28 103.729,60.27 106.354,68.353 99.48,63.359  92.607,68.353 95.23,60.27 88.357,55.28 96.854,55.28 "/> </g> </g></g><g> <g> <g> <path class="colorful c2" fill="#474442" d="M57.597,99.192c0,3.2-2.24,6.49-6.216,6.49h-3.793v8.638h-2.422V82.329h6.216 c2.924,0,6.216,1.69,6.216,6.398V99.192z M55.266,88.727c0-2.651-1.417-4.25-3.884-4.25h-3.793v19.059h3.793 c1.965,0,3.884-1.6,3.884-4.343V88.727z"/> </g> </g> <g> <g> <path class="colorful c2" fill="#474442" d="M74.142,114.32h-2.377v-5.62c0-1.646-1.051-2.743-2.834-2.743h-4.523v8.363h-2.422V82.329h5.805 c3.473,0.046,6.262,1.828,6.169,6.49v10.648c0,1.783-0.914,3.932-2.604,5.027c1.919,0.732,2.788,2.423,2.788,4.206V114.32z M64.407,103.81h3.382c1.645,0,3.838-1.509,3.838-4.343V88.818c0-2.65-1.279-4.342-3.838-4.342h-3.382V103.81z"/> </g> </g> <g> <g> <path class="colorful c2" fill="#474442" d="M81.089,84.431v19.242h6.901v2.102h-6.901v6.399h8.684v2.146H78.667V82.329h11.106v2.103H81.089z"/> </g> </g> <g> <g> <path class="colorful c2" fill="#474442" d="M96.218,88.635l-0.137,10.01l-0.596,15.675h-2.329l1.232-32.038h3.109l2.788,18.373l1.233,9.233 l1.372-9.233l2.834-18.373h2.97l1.235,32.038h-2.424l-0.64-15.675l0.046-10.056h-0.092l-1.554,9.827l-2.56,15.401h-2.559 l-2.513-15.401l-1.326-9.782H96.218z"/> </g> </g> <g> <g> <path class="colorful c2" fill="#474442" d="M114.088,114.32V82.329h2.423v31.992H114.088z"/> </g> </g> <g> <g> <path class="colorful c2" fill="#474442" d="M133.604,107.969c0,3.381-2.011,6.718-6.215,6.718c-3.84,0-6.217-3.062-6.217-6.765V82.329h2.423v25.593 c0,2.286,1.097,4.617,3.794,4.617c2.878,0,3.885-2.102,3.885-4.57v-25.64h2.33V107.969z"/> </g> </g> <g> <g> <path class="colorful c2" fill="#474442" d="M141.236,88.635l-0.137,10.01l-0.595,15.675h-2.331l1.234-32.038h3.108l2.788,18.373l1.233,9.233 l1.372-9.233l2.832-18.373h2.971l1.234,32.038h-2.423l-0.639-15.675l0.046-10.056h-0.093l-1.554,9.827l-2.561,15.401h-2.558 l-2.513-15.401l-1.326-9.782H141.236z"/> </g> </g></g></svg>';
		
		
		
		/**
		 * Premium Quality 2
		 */
		$svg['premium_quality_2']['colors'] = array();
		$svg['premium_quality_2']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['premium_quality_2']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><g> <g> <path fill="#14120D" d="M198.254,99.976c0,5.138-2.924,9.983-3.697,14.903c-0.794,5.051,0.484,10.561-1.062,15.316 c-1.571,4.842-5.854,8.549-8.14,13.021c-2.308,4.519-2.803,10.157-5.766,14.229c-2.979,4.094-8.194,6.299-11.766,9.867 c-3.569,3.572-5.772,8.789-9.867,11.766c-4.072,2.965-9.711,3.459-14.23,5.768c-4.473,2.281-8.177,6.564-13.018,8.139 c-4.758,1.545-10.267,0.268-15.32,1.061c-4.918,0.771-9.764,3.699-14.901,3.699c-5.137,0-9.982-2.928-14.902-3.699 c-5.053-0.793-10.562,0.484-15.319-1.061c-4.841-1.574-8.547-5.857-13.018-8.141c-4.52-2.307-10.157-2.803-14.231-5.767 c-4.094-2.978-6.297-8.193-9.867-11.765c-3.569-3.57-8.787-5.773-11.765-9.867c-2.963-4.072-3.458-9.711-5.766-14.23 c-2.283-4.471-6.567-8.178-8.139-13.02c-1.545-4.756-0.268-10.266-1.062-15.316c-0.772-4.92-3.697-9.766-3.697-14.903 c0-5.137,2.925-9.982,3.697-14.903c0.795-5.049-0.483-10.559,1.062-15.317c1.572-4.842,5.856-8.547,8.139-13.019 c2.308-4.52,2.803-10.158,5.766-14.23c2.979-4.093,8.196-6.297,11.769-9.867c3.567-3.57,5.77-8.786,9.864-11.766 c4.074-2.963,9.712-3.459,14.231-5.766c4.471-2.282,8.177-6.566,13.018-8.139c4.758-1.545,10.267-0.268,15.319-1.061 c4.92-0.773,9.765-3.7,14.902-3.7c5.138,0,9.983,2.927,14.901,3.7c5.054,0.793,10.562-0.484,15.32,1.061 c4.841,1.572,8.545,5.856,13.018,8.139c4.52,2.307,10.16,2.803,14.23,5.766c4.095,2.98,6.298,8.196,9.867,11.766 c3.572,3.57,8.787,5.774,11.766,9.867c2.965,4.072,3.458,9.712,5.766,14.23c2.285,4.472,6.568,8.177,8.14,13.019 c1.546,4.759,0.268,10.266,1.062,15.317C195.33,89.994,198.254,94.839,198.254,99.976z"/> </g> <g> <circle fill="#FBFAF6" cx="100.487" cy="99.976" r="89.479"/> </g> <g> <path fill="#474442" d="M100.487,184.243c-46.466,0-84.268-37.804-84.268-84.268c0-46.465,37.802-84.267,84.268-84.267 s84.268,37.802,84.268,84.267C184.755,146.439,146.953,184.243,100.487,184.243z M100.487,16.979 c-45.764,0-82.997,37.232-82.997,82.997c0,45.766,37.233,82.997,82.997,82.997s82.999-37.231,82.999-82.997 C183.486,54.21,146.251,16.979,100.487,16.979z"/> </g> <g> <g> <g> <path fill="#474442" d="M61.661,110.845V98.303h2.351c0.93,0,1.612,0.048,2.049,0.146c0.438,0.098,0.821,0.257,1.142,0.479 c0.404,0.287,0.721,0.677,0.944,1.174c0.222,0.497,0.333,1.048,0.333,1.654c0,1.193-0.342,2.068-1.029,2.626 c-0.689,0.556-1.776,0.835-3.261,0.835h-1.357v5.628H61.661z M62.833,104.214h0.801c1.421,0,2.378-0.176,2.868-0.528 c0.49-0.349,0.738-0.965,0.738-1.844c0-0.372-0.057-0.713-0.167-1.024c-0.113-0.311-0.281-0.59-0.503-0.834 c-0.229-0.251-0.541-0.428-0.934-0.531c-0.395-0.104-1.062-0.154-2.002-0.154h-0.801V104.214z"/> </g> <g> <path fill="#474442" d="M80.685,110.845h-1.428l-4.528-5.979h-0.706v5.979h-1.172V98.303h2.369c1.398,0,2.445,0.283,3.143,0.848 c0.696,0.564,1.045,1.422,1.045,2.569c0,0.977-0.297,1.745-0.896,2.305c-0.596,0.561-1.415,0.84-2.462,0.84L80.685,110.845z M74.023,99.297v4.634h1.18c1.094,0,1.856-0.17,2.288-0.51c0.431-0.34,0.648-0.918,0.648-1.734c0-0.862-0.224-1.476-0.67-1.842 c-0.45-0.366-1.203-0.548-2.266-0.548H74.023z"/> </g> <g> <path fill="#474442" d="M84.542,110.845V98.303h6.389v1.071h-5.216v3.924h5.216v1.07h-5.216v5.406h5.216v1.07H84.542z"/> </g> <g> <path fill="#474442" d="M101.857,111.333l-4.532-10.065l-0.977,9.577h-1.208l1.754-13.073l4.943,11.163l5.129-11.163 l1.655,13.073h-1.205l-0.96-9.577L101.857,111.333z"/> </g> <g> <path fill="#474442" d="M113.223,110.845V98.303h1.172v12.542H113.223z"/> </g> <g> <path fill="#474442" d="M119.723,98.303h1.156v8.19c0,1.241,0.289,2.161,0.871,2.763c0.582,0.604,1.471,0.903,2.671,0.903 c1.181,0,2.06-0.3,2.642-0.903c0.583-0.602,0.873-1.521,0.873-2.763v-8.19h1.172v7.822c0,1.695-0.389,2.964-1.162,3.799 c-0.777,0.838-1.953,1.256-3.524,1.256c-1.583,0-2.76-0.418-3.534-1.256c-0.777-0.835-1.164-2.104-1.164-3.799V98.303z"/> </g> <g> <path fill="#474442" d="M140.318,111.333l-4.532-10.065l-0.978,9.577h-1.207l1.755-13.073l4.942,11.163l5.131-11.163 l1.654,13.073h-1.207l-0.961-9.577L140.318,111.333z"/> </g> </g> <g> <g> <path fill="#474442" d="M67.882,140l-1.84,1.551l-1.593-1.708c-0.357,0.225-0.754,0.394-1.194,0.504 c-0.44,0.108-0.937,0.163-1.495,0.163c-1.885,0-3.353-0.759-4.397-2.275c-1.042-1.517-1.565-3.647-1.565-6.395 c0-2.549,0.532-4.559,1.597-6.025c1.062-1.469,2.517-2.202,4.365-2.202c1.901,0,3.373,0.757,4.417,2.27 c1.043,1.513,1.567,3.653,1.567,6.423c0,1.358-0.132,2.518-0.398,3.48c-0.263,0.961-0.667,1.749-1.209,2.359L67.882,140z M62.305,134.025l1.597,1.709c0.154-0.461,0.269-0.98,0.341-1.556c0.074-0.578,0.112-1.263,0.112-2.056 c0-1.781-0.219-3.121-0.657-4.022c-0.44-0.901-1.087-1.353-1.938-1.353c-0.885,0-1.542,0.461-1.968,1.387 c-0.425,0.924-0.641,2.348-0.641,4.271c0,1.653,0.219,2.91,0.657,3.773c0.44,0.863,1.077,1.297,1.917,1.297 c0.07,0,0.147-0.004,0.234-0.012c0.085-0.006,0.181-0.018,0.289-0.035l-1.781-1.923L62.305,134.025z"/> </g> <g> <path fill="#474442" d="M83.689,123.83v10.375c0,1.27-0.041,2.168-0.117,2.699c-0.079,0.533-0.207,0.973-0.384,1.318 c-0.412,0.793-1.005,1.379-1.787,1.759c-0.781,0.382-1.783,0.572-3.01,0.572c-1.226,0-2.234-0.19-3.021-0.572 c-0.789-0.38-1.385-0.966-1.786-1.759c-0.188-0.354-0.318-0.799-0.398-1.336c-0.077-0.533-0.117-1.43-0.117-2.682v-0.486v-9.889 h3.392v10.635c0,1.352,0.141,2.223,0.423,2.609c0.284,0.389,0.785,0.583,1.507,0.583c0.738,0,1.244-0.197,1.518-0.594 c0.278-0.396,0.413-1.261,0.413-2.599V123.83H83.689z"/> </g> <g> <path fill="#474442" d="M88.164,140.352l3.96-16.521h3.549l3.773,16.521h-3.388l-0.572-2.898h-3.412l-0.522,2.898H88.164z M92.692,134.885h2.26c-0.234-1.156-0.443-2.363-0.629-3.627c-0.188-1.265-0.35-2.596-0.49-4 c-0.171,1.236-0.35,2.491-0.541,3.762C93.101,132.291,92.902,133.58,92.692,134.885z"/> </g> <g> <path fill="#474442" d="M104.016,140.352V123.83h3.354v13.297h3.867v3.225H104.016z"/> </g> <g> <path fill="#474442" d="M116.054,140.352V123.83h3.455v16.521H116.054z"/> </g> <g> <path fill="#474442" d="M127.281,140.352v-13.469h-2.596v-3.053h8.605v3.053h-2.598v13.469H127.281z"/> </g> <g> <path fill="#474442" d="M139.92,140.352v-7.766l-3.935-8.756h3.573l1.117,2.986c0.211,0.535,0.4,1.07,0.57,1.6 c0.172,0.534,0.334,1.074,0.49,1.625c0.139-0.61,0.291-1.18,0.455-1.707c0.163-0.53,0.328-1.005,0.5-1.428l1.234-3.076h3.317 l-3.958,8.756v7.766H139.92z"/> </g> </g> <g> <rect x="58.275" y="145.59" fill="#474442" width="87.184" height="3.387"/> </g> </g> <g> <g> <polygon fill="#474442" points="99.817,63.735 93.68,63.735 85.833,52.204 85.833,63.735 79.729,63.735 79.729,42.734  85.792,42.734 93.714,54.353 93.714,42.734 99.817,42.734 "/> </g> <g> <rect x="102.123" y="60.817" fill="#474442" width="8.159" height="2.276"/> </g> <g> <path fill="#474442" d="M109.449,52.843c-0.786-0.794-1.93-1.19-3.428-1.19c-1.435,0-2.552,0.403-3.354,1.207 c-0.804,0.806-1.205,1.802-1.205,2.995c0,1.152,0.4,2.133,1.194,2.94c0.797,0.809,1.918,1.212,3.365,1.212 c1.512,0,2.656-0.406,3.438-1.222c0.781-0.813,1.17-1.81,1.17-2.987C110.63,54.625,110.236,53.643,109.449,52.843z M107.055,57.32c-0.219,0.306-0.552,0.462-1.003,0.462c-0.878,0-1.318-0.643-1.318-1.928c0-0.708,0.107-1.213,0.327-1.515 c0.215-0.3,0.557-0.45,1.027-0.45c0.447,0,0.771,0.15,0.979,0.45c0.205,0.302,0.31,0.794,0.31,1.476 C107.376,56.511,107.27,57.014,107.055,57.32z"/> </g> <g> <path fill="#474442" d="M123.311,42.375v21.36h-5.903V49.74c-0.957,0.726-1.881,1.312-2.772,1.761 c-0.895,0.449-2.012,0.879-3.36,1.289v-4.785c1.988-0.64,3.534-1.409,4.627-2.307c1.101-0.897,1.96-2.005,2.583-3.323H123.311z" /> </g> </g> <g> <g> <polygon fill="#262421" points="100.307,71.576 102.859,79.436 111.121,79.436 104.439,84.289 106.992,92.15 100.307,87.292  93.623,92.15 96.174,84.289 89.491,79.436 97.752,79.436 "/> </g> </g></g></svg>';
		
		
		
		/**
		 * Text Baloon 1
		 */
		$svg['text_baloon_1']['colors'] = array();
		$svg['text_baloon_1']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['text_baloon_1']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 148.718" enable-background="new 0 0 200 148.718" xml:space="preserve"><g> <path fill="#FFFFFF" d="M76.613,95.068C28.019,100.364,5.611,69.76,13.86,20.276C16.081,6.948,41.746,5.653,70.867,5.468 c29.119-0.186,61.692,0.738,75.088,1.241c13.29,0.499,40.406-10.125,46.329,15.047c3.235,13.749,3.524,33.453-2.551,46.003 c-8.868,18.317-38.097,6.653-40.591,24.995c-2.02,14.883-28.258,57.699-29.412,50.42c-1.51-9.51,14.564-31.66,17.77-40.582 C148.355,72.352,87.688,93.862,76.613,95.068C59.462,96.938,93.171,93.263,76.613,95.068z"/> <g> <g> <path fill="#4B4033" d="M185.736,73.004c3.249-2.264,4.274-7.241,3.922-10.955c0.012-0.59-0.364-2.086-1.252-1.203 c-0.942,0.94-0.51,5.193-1.02,6.696c-1.518,4.469-6.01,5.1-10.144,5.474c-0.347-0.136-0.627-0.113-0.841,0.072 c-6.23,0.521-13.234,0.793-19.07,3.207c-0.403-1.195-1.651-0.415-1.354,0.645c-6.295,3.379-5.613,12.928-7.764,18.916 c-2.154,6.006-4.531,11.936-7.209,17.725c-4.537,9.805-11.443,25.541-22.946,28.853c4.551-5.034,7.856-11.067,11.072-16.999 c0.286-0.217,2.108-1.269,1.11-2.021c6.342-11.482,13.356-20.576,13.356-34.229c0.209-0.32,1.464-2.273-0.051-2.186 c-0.349-6.056-3.633-7.291-9.288-6.272c-6.078,1.095-12.019,1.987-18.182,2.595c-14.236,1.402-28.461,2.916-42.779,2.991 c-12.668,0.069-25.449-0.75-38.043-2.128c-11.019-1.204-17.099-4.979-18.839-16.248c-0.099,0.161,1.667-3.595-0.343-2.307 c-0.769-5.445-1.32-10.921-1.632-16.41c-0.167-2.94-0.265-5.884-0.27-8.827c0.009-2.888,1.074-7.083,0.445-9.84 c0.519-5.532,1.529-10.569,3.219-14.53c0.492-0.536,3.665-3.357,2.433-4.28c2.108-2.728,4.734-4.009,8.099-4.43 c39.751-0.208,79.487-3.508,119.241-1.724c11.631,0.523,34.285-4.225,41.598,8.009c9.148,15.309,0.598,33.77,1.955,50.046 c-0.016,1.121,1.466,2.148,1.47,0.692c0.01-4.982,0.544-9.947,1.054-14.896c1.073-10.419,2.314-21.438-0.824-31.63 c-5.61-18.219-25.63-13.381-40.372-14.2c-22.382-1.245-44.817-0.775-67.209-0.042C74.051,3.935,62.824,4.368,51.591,4.681 c-5.733,0.159-11.466,0.288-17.202,0.36C33.205,5.055,23.127,4.52,23.906,6.16c-2.942,1.342-5.062,3.854-6.544,6.664 c-0.413,0.269-0.827,0.552-1.233,0.856c0.009-0.015,0.015-0.03,0.023-0.046c0.417-0.469,3.408-3.086,2.183-3.95 c-0.788-0.107-1.319,0.204-1.594,0.929c-1.097-0.548-1.721,1.961-1.834,2.196C1.799,27.459,1.587,50.446,5.674,68.766 c-0.187,0.283-1.503,3.396,0.468,2.11c0.4,1.807,0.793,3.639,1.141,5.488c-0.324,0.485-0.706,1.63,0.291,1.639 c0.075,0.438,0.151,0.875,0.22,1.313c-0.266,0.494-0.751,1.667,0.281,1.719c0.481,2.715,1.122,5.057,2.115,7.071 c-1.246,1.489-1.074,3.08,0.921,1.619c4.973,7.561,16.558,8.415,24.667,9.448c0.134,0.939,1.146,0.504,1.627,0.197 c5.731,0.662,11.564,0.988,17.423,1.097c0.272,0.253,0.75,0.321,1.031,0.014c24.267,0.339,48.335-1.899,71.804-8.265 c0.049,0.02,0.098,0.037,0.15,0.045c-2.068,2.318,1.986,0.632,2.733,0.105c0.09,0.063,0.181,0.128,0.266,0.193l-0.786,0.53 c-0.541,0.961-0.264,1.369,0.828,1.226c0.385-0.258,0.768-0.518,1.152-0.777c1.724,1.604,2.262,3.145,1.971,5.104 c-0.16,0.212-1.816,2-0.711,2.573c-2.743,7.324-7.257,13.957-11.049,20.756c-0.332,0.277-1.725,1.1-1.051,1.869 c-3.57,6.266-7.938,11.373-12.44,16.923c-5.424,6.687,3.979,6.296,8.304,4.155c10.274-1.71,17.086-13.959,21.505-22.214 c6.503-12.144,10.694-24.562,14.095-37.806c0.055,0.143,0.145,0.258,0.268,0.342c-2.061,1.697,2.727,0.08,3.128-0.179 c0.373,0,0.743,0,1.116-0.001c-1.843,1.844,4.252-0.076,4.505-0.086c3.442-0.137,6.898-0.457,10.265-1.215 C177.869,82.418,184.018,79.359,185.736,73.004z M121.987,134.072c-1.132,0.123-2.229,0.445-3.302,0.857 c1.665-1.098,3.308-2.231,4.893-3.41C123.061,132.381,122.531,133.232,121.987,134.072z M125.529,128.153 c-0.021,0.011-0.045,0.011-0.067,0.024c-0.008,0.002-0.017,0.008-0.025,0.013c0.042-0.03,0.082-0.062,0.124-0.092 C125.55,128.117,125.539,128.135,125.529,128.153z M127.643,124.328c-0.654,0.341-1.316,0.664-1.98,0.969 c1.209-1.02,2.361-2.128,3.27-3.314C128.501,122.764,128.074,123.547,127.643,124.328z M137.729,107.359 c-1.637,1.037-3.288,1.834-5.088,2.553c1.908-1.511,4.012-2.951,5.964-4.284C138.322,106.209,138.032,106.785,137.729,107.359z M139.533,103.568c-0.168-0.061-0.357-0.061-0.535,0.014c-0.062,0.025-0.126,0.054-0.191,0.081 c0.406-0.394,0.797-0.8,1.176-1.212C139.839,102.826,139.689,103.199,139.533,103.568z M141.08,98.988 c-1.718,0.416-3.432,1.848-4.945,2.746c0.643-0.675,1.336-1.308,2.018-1.93c1.262-1.152,2.553-2.342,3.521-3.775 C141.535,97.026,141.338,98.012,141.08,98.988z M135.041,95.248c-0.177-0.418-0.402-0.828-0.686-1.235 c2.393-1.642,4.723-3.423,7.34-4.702c-0.76,0.975-1.684,1.93-2.629,2.811C137.721,92.959,136.248,94.013,135.041,95.248z M135.594,100.172c-0.223,0.219-0.439,0.444-0.654,0.673c0.033-0.106,0.067-0.214,0.102-0.32 C135.223,100.406,135.413,100.291,135.594,100.172z M141.896,94.078c-0.977-0.444-3.858,2.596-4.603,3.133 c0.957-0.932,5.119-4.155,4.491-5.709c0.106-0.117,0.204-0.235,0.306-0.352C142.049,92.172,141.98,93.168,141.896,94.078z M138.854,85.183c0.198-0.208,2.025-1.676,0.879-2.296c0.025-0.033,0.037-0.07,0.055-0.104c2.102,0.582,2.158,2.921,2.278,4.734 c-1.106,0.467-2.184,1.045-3.237,1.687c0.562-0.636,1.102-1.291,1.592-1.981c0.768-1.078-1.184-1.408-1.641-1.255 C138.828,85.714,138.856,85.451,138.854,85.183z M112.139,85.931c5.351-0.515,10.832-0.782,16.133-1.676 c-2.111,1.438-4.383,2.675-6.664,3.823c1.236-0.598,1.717-1.463,1.441-2.602c-0.816-0.885-7.514,3.602-8.598,4.16 c4.126-4.894-3.01-1.224-4.928-0.248C110.055,88.914,112.872,86.983,112.139,85.931z M110.281,86.109 c-2.59,1.187-5.186,2.357-7.746,3.608c0.85-0.542,1.661-1.135,2.408-1.805c0.361-0.646,0.257-1.065-0.317-1.267 C106.512,86.473,108.396,86.289,110.281,86.109z M100.181,87.07c1.33-0.127,2.658-0.254,3.983-0.379 c-0.882,0.365-2.694,1.809-3.411,2.377c-1.465,0.836-2.998,1.547-4.527,2.252c1.313-1.122,2.597-2.266,3.8-3.426 C100.254,87.676,100.304,87.348,100.181,87.07z M98.315,87.246c-2.889,1.82-5.893,3.446-8.879,5.098 c1.254-1.09,2.45-2.21,3.507-3.37c0.313-0.698,0.144-1.108-0.508-1.229C94.397,87.598,96.356,87.436,98.315,87.246z M86.737,88.112c1.828-0.1,3.655-0.21,5.484-0.349c-3.417,0.826-7.408,4.014-10.453,5.749c1.809-1.317,3.605-2.731,4.92-4.647 C86.845,88.637,86.855,88.348,86.737,88.112z M85.23,88.203c-2.405,2.123-5.212,3.852-8.009,5.482 c0.741-0.595,1.497-1.185,2.247-1.768c1.641-1.279,3.191-2.49,4.406-3.658C84.327,88.238,84.778,88.227,85.23,88.203z M77.583,88.467c1.145-0.025,2.29-0.065,3.437-0.102c-2,1.274-4.082,2.457-6.113,3.612c-0.3,0.171-0.599,0.341-0.899,0.511 C74.599,91.972,78.283,89.625,77.583,88.467z M76.187,88.486c-2.734,2.004-5.762,3.555-8.699,5.232 c0.575-0.589,4.298-3.896,3.16-4.93c-0.973-0.887-8.19,4.877-9.429,5.721c1.462-1.49,2.929-2.904,4.304-4.219 c1.088-0.611,0.299-2.18-0.836-1.244c-0.013,0.012-0.023,0.021-0.036,0.033c-0.908,0.492-2.219,1.227-3.746,2.148 c4.407-5.148-4.771,0.917-6.152,1.802c1.419-1.528,2.724-3.122,3.566-4.847C64.239,88.486,70.2,88.582,76.187,88.486z M25.481,84.396c4.654,1.706,10.316,2.134,15.673,2.507c-2.659,2.266-5.846,3.763-8.892,5.412 c0.608-0.604,4.688-3.982,3.596-5.01c-0.77-0.722-7.882,4.811-8.899,5.415c0.68-0.733,5.343-5.171,3.762-6.337 c-1.12-0.826-6.696,4.438-7.712,5.205c2.354-3.078,6.179-8.104-0.202-4.079C23.445,86.839,25.485,85.375,25.481,84.396z M24.131,83.85c-3.232,1.268-6.125,3.22-9.129,4.925c0.692-0.923,1.51-1.779,2.352-2.665c1.222-1.283,2.476-2.613,3.418-4.217 C21.788,82.666,22.917,83.311,24.131,83.85z M19.601,80.895c-0.981,0.5-1.933,1.154-2.86,1.901 c-0.918,1.159,3.035-4.747,0.309-2.853c-0.482,0.333-0.965,0.667-1.446,1.002c0.697-1.04,1.265-2.041,1.712-3.001 C17.948,79.071,18.716,80.047,19.601,80.895z M16.194,75.341c0.152,0.485,0.329,0.946,0.523,1.39 c-0.982,0.008-3.032,2.439-3.725,3.031C14.046,78.277,15.129,76.816,16.194,75.341z M15.725,73.465 c-1.855,1.285-3.511,2.823-5.265,4.236c1.332-2.085,2.965-4.22,4.708-6.141c0.099-0.108,0.148-0.237,0.171-0.371 C15.459,71.953,15.583,72.708,15.725,73.465z M15.266,70.723c-0.099-0.237-0.301-0.369-0.603-0.4 c0.157-0.183,0.305-0.37,0.457-0.557C15.169,70.107,15.219,70.427,15.266,70.723z M14.668,66.615 c-1.1,0.781-2.194,1.566-3.287,2.355c1.154-1.41,2.304-2.875,2.998-4.569C14.476,65.181,14.574,65.921,14.668,66.615z M14.204,62.978c-1.038-0.505-4.359,3.307-5.154,3.944c1.691-1.815,3.559-3.489,4.967-5.55 C14.08,61.921,14.142,62.456,14.204,62.978z M10.567,32.032c1.05-1.549,2.053-3.031,2.802-4.271 c-0.102,0.875-0.188,1.761-0.261,2.658c-1.135,0.941-2.266,1.888-3.38,2.853C10.007,32.858,10.288,32.443,10.567,32.032z M8.711,29.846c1.456-2.386,3.445-4.392,5.295-6.461c-0.118,0.66-0.227,1.327-0.328,2.005c-0.902,0.162-1.447,0.727-1.634,1.698 C11.135,26.021,9.146,29.4,8.711,29.846z M12.261,34.876c-0.392,0.002-0.735,0.084-1.037,0.241 c0.567-0.684,1.134-1.368,1.701-2.053c-0.105,1.922-0.163,3.868-0.175,5.814c-0.774,0.156-1.876,1.297-2.447,1.791 C10.744,39.927,13.626,35.613,12.261,34.876z M12.915,47.638c-0.807-0.02-1.931,1.176-2.477,1.651 c0.836-1.271,1.628-2.521,2.396-3.736C12.857,46.251,12.884,46.948,12.915,47.638z M12.755,42.017 c0.005,0.433,0.012,0.864,0.02,1.296c-0.854,0.172-2.053,1.751-2.644,2.327C11.135,44.478,12.079,43.281,12.755,42.017z M12.876,51.838c-0.677-0.083-1.257,0.063-1.752,0.42c0.676-0.862,1.325-1.743,1.891-2.651c0.116,2.041,0.26,4.026,0.424,5.926 c-1.127-0.272-3.427,2.459-4.122,3.098C9.868,57.796,13.997,52.729,12.876,51.838z M13.588,57.211 c0.048,0.515,0.097,1.022,0.148,1.521c-0.728,0.363-1.417,0.817-2.075,1.333C12.358,59.175,13.025,58.239,13.588,57.211z M14.433,21.261c-0.131-0.032-0.27-0.03-0.4,0.011c0.189-0.231,0.377-0.465,0.561-0.703 C14.54,20.799,14.484,21.029,14.433,21.261z M11.535,19.034c0.905,0.903,4.101-3.056,4.579-3.448 c-0.024,0.062-0.049,0.124-0.073,0.187c-2.001,2.079-4.224,3.987-6.149,6.133C10.329,20.882,10.876,19.925,11.535,19.034z M8.902,24.624c0.115,0.109,0.254,0.164,0.422,0.162c-0.32,0.483-0.609,0.984-0.863,1.504C8.597,25.73,8.741,25.174,8.902,24.624 z M8.092,27.898c0.021,0.036,0.04,0.073,0.067,0.105c-0.049,0.068-0.089,0.14-0.136,0.208C8.046,28.106,8.07,28.002,8.092,27.898 z M6.881,33.536c0.087-0.032,0.169-0.082,0.242-0.147c0.673-0.62,1.35-1.24,2.008-1.876c-0.933,1.376-1.87,2.77-2.691,4.088 C6.58,34.924,6.727,34.238,6.881,33.536z M5.868,38.473c0.474-0.067,0.866-0.27,1.194-0.583c-0.479,0.605-0.958,1.21-1.419,1.817 C5.714,39.299,5.79,38.888,5.868,38.473z M5.151,42.859c1.384-1.114,2.873-2.333,4.272-3.637 c-1.213,2.149-3.781,4.399-4.605,6.658C4.905,44.87,5.017,43.868,5.151,42.859z M4.786,46.246 c0.307,1.916,5.642-3.72,6.312-4.307c-0.819,1.32-1.969,2.613-3.159,3.951c-1.176,1.322-2.376,2.681-3.316,4.138 C4.634,48.746,4.687,47.49,4.786,46.246z M4.672,52.813c1.537-0.968,2.926-2.59,4.215-3.862c-1.099,1.66-3.512,3.99-4.096,5.858 C4.737,54.13,4.701,53.466,4.672,52.813z M4.836,55.358c0.685,1.371,2.792-1.242,3.198-1.644 c-1.038,1.263-2.069,2.559-2.947,3.94C4.99,56.893,4.903,56.126,4.836,55.358z M5.669,61.428 c-0.078-0.431-0.153-0.863-0.222-1.296c0.961-1.301,2.21-2.505,3.52-3.663C7.88,58.129,6.775,59.778,5.669,61.428z M6.042,63.408 c1.107-0.798,2.184-1.771,3.192-2.692c-1.057,1.308-2.11,2.679-2.866,4.291C6.257,64.475,6.15,63.942,6.042,63.408z M6.84,67.193 c-0.088-0.396-0.175-0.795-0.261-1.19c1.089,0.752,4.367-3.375,5.147-4.064C10.177,63.764,8.367,65.346,6.84,67.193z M7.748,71.285c-0.096-0.44-0.193-0.874-0.289-1.309c1.038-0.735,2.107-1.548,3.167-2.424 C9.638,68.774,8.608,69.964,7.748,71.285z M8.123,73.026c1.781-0.364,4.186-2.902,5.672-3.97 c-1.664,2.004-3.636,3.726-5.31,5.723C8.366,74.192,8.247,73.609,8.123,73.026z M8.914,77.037 c0.185-0.174,0.369-0.35,0.558-0.531c-0.175,0.27-0.347,0.537-0.513,0.804C8.943,77.219,8.929,77.129,8.914,77.037z M9.764,81.902c-0.109-0.514-0.21-1.045-0.304-1.597c1.027-0.706,2.016-1.511,2.982-2.319 C11.518,79.266,10.604,80.57,9.764,81.902z M10.274,84.012c1.124-0.963,2.256-1.914,3.383-2.873 c-0.936,1.275-2.297,2.432-3.11,3.764C10.454,84.611,10.361,84.316,10.274,84.012z M10.915,85.965 c0.833,0.307,2.128-1.312,2.667-1.728c-0.775,0.859-1.544,1.724-2.31,2.592C11.147,86.547,11.027,86.261,10.915,85.965z M12.782,89.482c-0.163-0.227-0.32-0.467-0.474-0.708c0.747-0.638,1.507-1.348,2.289-2.081c0.45-0.422,0.902-0.845,1.356-1.26 C14.788,86.665,13.624,87.949,12.782,89.482z M14.068,90.96c2.544-1.315,4.935-2.899,7.459-4.255 c-0.728,0.764-6.044,4.879-5.575,5.772C15.262,92.02,14.634,91.516,14.068,90.96z M16.552,92.861 c1.746,0.119,5.094-2.862,6.543-3.783c-1.285,1.615-2.597,3.291-3.652,5.15C18.381,93.822,17.415,93.373,16.552,92.861z M23.043,95.342c-0.675-0.171-1.312-0.348-1.925-0.538c1.879-1.329,3.732-2.753,5.529-4.139c0.219-0.169,0.44-0.34,0.661-0.509 c-1.331,1.49-2.811,2.875-3.872,4.588C23.249,94.896,23.118,95.095,23.043,95.342z M26.422,96.109 c-0.577-0.119-1.15-0.251-1.725-0.381c1.078-0.6,2.918-1.645,4.896-2.877C28.521,93.899,27.43,94.981,26.422,96.109z M29.704,96.746c-0.452-0.08-0.901-0.169-1.35-0.254c1.933-1.443,4.102-2.614,6.224-3.736c0.335-0.174,0.671-0.352,1.006-0.53 C34.361,93.17,30.214,95.173,29.704,96.746z M36.332,97.744c-1.588-0.198-3.169-0.424-4.738-0.678 c3.477-2.285,6.883-4.701,10.539-6.699C40.038,92.701,37.82,94.946,36.332,97.744z M42.205,92.488 c1.083-1.182,2.2-2.4,3.23-3.777c0.941-0.762,0.025-1.948-0.935-1.186c-0.004,0.004-0.009,0.008-0.015,0.012 c-1.099,0.494-2.179,1.043-3.246,1.629c0.888-0.521,1.345-1.242,1.375-2.16c4.17,0.295,8.328,0.72,12.5,0.985 c-1.313,0.696-2.684,1.513-4.105,2.452c0.413-2.26-4.215,1.286-4.446,1.437c-2.645,1.696-5.326,3.331-7.99,4.997 C39.637,95.289,40.897,93.916,42.205,92.488z M41.173,98.273c-0.587-0.054-1.17-0.119-1.753-0.179 c0.819-0.517,1.685-1.053,2.575-1.603c0.515-0.32,1.033-0.643,1.552-0.965C42.662,96.37,41.842,97.27,41.173,98.273z M43.181,98.434c4.33-3.896,8.932-7.215,12.841-9.26c-2.063,2.971-7.306,6.092-8.271,9.562 C46.222,98.656,44.699,98.555,43.181,98.434z M50.661,98.863c-0.36-0.013-0.721-0.028-1.081-0.043 c1.893-1.941,4.514-3.623,7.082-5.248C55.623,94.576,50.804,97.379,50.661,98.863z M55.177,98.988 c-0.841-0.014-1.682-0.033-2.521-0.058c2.55-1.901,4.926-3.886,7.632-5.583C58.521,95.139,56.771,97.037,55.177,98.988z M57.581,99.014c2.682-2.164,5.587-4.029,8.456-5.932c-0.48,0.484-6.246,5.38-4.343,5.932 C60.323,99.024,58.952,99.024,57.581,99.014z M74.41,98.698c-4.068,0.159-8.166,0.276-12.272,0.312 c2.549-0.865,5.441-3.656,7.876-5.013c-1.196,1.036-2.377,2.087-3.545,3.157c-0.408,0.964-0.099,1.346,0.929,1.148 c2.404-1.693,4.954-3.166,7.507-4.619c-1.285,1.098-2.53,2.26-3.599,3.572c-1.785,2.195,4.842-1.232,4.961-1.303 C75.742,96.465,74.103,97.777,74.41,98.698z M80.941,98.416c-1.565,0.073-3.14,0.143-4.719,0.209 c3.612-2.378,7.535-4.553,11.367-6.652c-1.533,1.289-3.11,2.523-4.667,3.781c0.097-0.08-1.788,2.395-1.326,2.623 C81.38,98.389,81.156,98.407,80.941,98.416z M98.32,96.73c-5.725,0.807-11.283,1.357-16.489,1.633 c0.139-0.043,0.318-0.124,0.568-0.277c3.501-2.157,7.136-4.092,10.729-6.094c-1.431,1.189-3.103,2.338-4.423,3.658 c-2.012,1.686,2.306,0.123,2.304,0.125c1.43-0.971,2.974-1.756,4.533-2.496c-0.732,0.565-4.373,2.148-3.589,3.363 c0.669,1.041,2.58-0.779,3.043-1.11c4.117-2.595,8.519-4.69,12.936-6.716C106.364,90.154,98.272,94.719,98.32,96.73z M103.718,95.902c-1.042,0.173-2.081,0.338-3.117,0.495c3.128-2.498,6.81-4.274,10.359-6.078c0.546-0.278,1.083-0.55,1.608-0.819 C111.155,90.892,103.91,94.234,103.718,95.902z M109.701,94.838c-0.926,0.177-1.852,0.348-2.775,0.514 c0.25-0.148,0.488-0.291,0.746-0.449c2.49-1.419,5.051-2.703,7.598-4.02C113.904,91.736,110.314,93.283,109.701,94.838z M120.586,92.492c-2.452,0.588-4.922,1.143-7.396,1.654c2.176-1.321,4.491-2.469,6.904-3.66c1.164-0.575,2.341-1.156,3.512-1.765 C123.012,89.27,120.012,91.374,120.586,92.492z M127.639,90.689c-1.305,0.357-2.619,0.702-3.94,1.036 c1.675-0.821,3.378-1.585,5.074-2.36C128.362,89.789,127.988,90.234,127.639,90.689z M133.35,92.808 c-0.037-0.037-0.071-0.073-0.108-0.108c0.192-0.131,0.382-0.261,0.575-0.396C133.66,92.471,133.504,92.639,133.35,92.808z M124.977,89.474c0.645-0.589,1.303-1.165,1.951-1.735c0.653-0.576,4.095-2.803,3.674-3.97c2.352-0.534,4.744-1.167,7.17-1.201 c-0.883,0.664-1.844,1.321-2.849,2.007C131.754,86.488,128.327,87.919,124.977,89.474z M133.084,105.346 c0.115-0.25,0.229-0.49,0.338-0.728c1.229,0.262,3.697-1.749,4.693-2.351c-1.809,1.809-3.913,3.421-5.927,4.881 C132.488,106.55,132.797,105.951,133.084,105.346z M131.342,108.819c0.044,0.044,0.08,0.099,0.133,0.131 c-0.123,0.095-0.238,0.195-0.359,0.294C131.191,109.102,131.268,108.962,131.342,108.819z M129.023,113.061 c0.415-0.138,0.811-0.325,1.186-0.562c-0.537,0.393-1.062,0.805-1.57,1.244C128.768,113.516,128.895,113.286,129.023,113.061z M127.188,116.267c0.035,0.029,0.06,0.071,0.099,0.093c-0.092,0.066-0.18,0.139-0.272,0.206 C127.072,116.466,127.131,116.365,127.188,116.267z M132.127,115.723c-0.207-0.339-0.645-0.451-0.99-0.26 c0.391-0.281,4.684-2.959,2.879-3.742c0.656-0.419,1.309-0.842,1.958-1.271c-1.903,3.186-3.979,6.266-5.864,9.467 c0.005-1.85-4.178,1.164-4.689,1.363C126.291,120.605,132.773,116.775,132.127,115.723z M122.926,123.732 c1.25-0.42,2.505-0.833,3.717-1.355c-1.69,1.747-3.674,3.219-5.628,4.654C121.676,125.926,122.312,124.826,122.926,123.732z M120.502,127.886c0.012,0.085,0.035,0.169,0.078,0.249c0.729,0.486,1.474,0.51,2.23,0.088c-1.434,0.982-2.844,1.883-4.199,2.645 C119.268,129.877,119.895,128.881,120.502,127.886z M117.561,132.424c0.194,0.248,0.521,0.361,0.829,0.25 c0.708-0.256,1.417-0.51,2.124-0.766c-1.654,1.151-3.354,2.256-5.043,3.347C116.195,134.32,116.896,133.377,117.561,132.424z M112.143,145.104c0.509-0.142,1.016-0.28,1.525-0.418C113.164,144.85,112.648,144.991,112.143,145.104z M114.869,142.856 c-0.031,0.007-0.062,0.015-0.093,0.021c0.073-0.047,0.146-0.097,0.22-0.143C114.953,142.775,114.912,142.815,114.869,142.856z M108.453,144.471c-0.299-0.652,0.59-1.687,0.848-2.033c0.985,0.766,4.887-1.24,5.898-1.621 C112.899,142.479,110.084,143.781,108.453,144.471z M110.914,140.493c0.425-0.476,0.907-1.003,1.469-1.593 c2.758-0.209,5.377-2.197,7.986-2.99C117.6,138.065,114.086,139.092,110.914,140.493z M153.387,83.316 c-0.172,0.224-0.34,0.447-0.508,0.668c0.543-1.846,1.298-3.384,2.919-4.483C155.312,80.797,154.342,82.07,153.387,83.316z M173.324,81.871c-0.43,0.121-0.867,0.233-1.307,0.339c0.486-0.22,0.961-0.457,1.422-0.726 C173.363,81.603,173.33,81.735,173.324,81.871z M177.043,75.259c2.403-0.212,4.538-0.479,6.338-1.093 c-0.393,0.24-1.273,0.639-1.355,1.164c-0.707,0.566-1.439,1.142-2.182,1.715c0.377-0.463,0.49-1.027,0.33-1.689 c-0.9-0.953-4.627,2.878-5.295,3.38C175.711,77.66,176.465,76.52,177.043,75.259z M171.182,75.878 c-0.051-0.037-0.105-0.061-0.162-0.085c0.9-0.098,1.781-0.182,2.62-0.254c-1.03,0.986-2.058,1.973-3.085,2.959 C171.449,77.687,171.657,76.814,171.182,75.878z M168.405,76.763c0.124-0.202,0.136-0.44,0.057-0.65 c0.626-0.091,1.242-0.171,1.848-0.241c-0.983,0.64-1.894,1.465-2.819,2.189C167.816,77.646,168.122,77.215,168.405,76.763z M163.078,77.436c0.102-0.148,0.141-0.326,0.121-0.499c1.02-0.192,2.035-0.353,3-0.497c-1.663,1.004-3.285,2.1-4.869,3.203 C161.955,78.934,162.54,78.201,163.078,77.436z M157.245,79.881c0.153-0.436,0.266-0.881,0.319-1.334 c0.543-0.241,1.116-0.456,1.713-0.648C158.561,78.488,157.891,79.174,157.245,79.881z M158.906,83.566 c-0.214,0.002-0.428,0.006-0.635,0.009c1.844-1.262,3.661-2.57,5.513-3.825C162.221,81.103,160.523,82.283,158.906,83.566z M164.157,83.352c-0.473,0.033-0.938,0.062-1.403,0.089c1.781-1.214,3.513-2.541,5.211-3.87 C166.805,80.965,165.4,82.053,164.157,83.352z M167.473,83.024c2.036-1.448,3.893-3.236,5.701-4.988 c0.434-0.419,0.859-0.833,1.283-1.235c-0.32,0.469-4.979,5.201-3.161,5.578C170.037,82.65,168.753,82.859,167.473,83.024z"/> </g> </g></g></svg>';
		
		
		
		/**
		 * Text Baloon 2
		 */
		$svg['text_baloon_2']['colors'] = array();
		$svg['text_baloon_2']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['text_baloon_2']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 200" enable-background="new 0 0 200 200" xml:space="preserve"><g> <path fill="#FFFFFF" d="M145.344,153.185c18.774-10.586,23.381-24.615,17.284-43.136c-3.643-11.064,12.712-22.825,7.965-35.688 c-3.768-10.21-13.936-21.843-25.881-23.525c-24.921-3.505-21.163-27.215-38.375-40.525C97.193,3.241,83.41,0.509,71.986,4.232 c-10.88,3.55-14.741,15.363-18.107,21.375c-3.068,5.48-11.153,3.065-18.254,4.745c-12.472,2.952-23.652,8.906-16.474,25.748 c3.997,9.387,8.61,19.318,8.61,19.318s-11.968,7.95-12.92,16.613c-1.711,15.604-9.486,20.084-0.631,39.041 c12.135,25.975,39.029,11.773,58.63,26.924C97.063,176.717,122.604,166.008,145.344,153.185 C154.971,147.756,128.34,162.771,145.344,153.185z"/> <path fill="#FFFFFF" d="M157.369,182.447c-30.486-16.766-8.9-27.482,10.279-26.819 C194.799,156.565,176.458,185.301,157.369,182.447C149.505,181.271,165.83,187.103,157.369,182.447z"/> <path fill="#FFFFFF" d="M172.25,190.268c-4.207-8.145,8.235-11.412,13.168-7.385C195.238,190.911,176.816,199.094,172.25,190.268z" /> <g> <g> <g> <path fill="#4B4033" d="M170.045,187.941c-1.178,1.092,1.615,4.585,2.354,5.258c1.471,1.34,3.358,2.088,5.271,2.396 c4.109,0.666,10.387-0.582,11.891-5.305c1.675-1.041-1.422-7.247-2.127-5.951c-1.012-2.664-4.373-3.591-6.791-4.056 c-1.085-0.214-5.777-1.346-6.63-0.233C170.596,180.832,167.484,184.456,170.045,187.941z M188.617,188.012 c-0.242-0.406-0.461-1.391-0.932-1.587c0.035-0.339,0.033-0.694-0.01-1.056C188.2,186.279,188.515,187.166,188.617,188.012z M186.514,189.039c0.222-0.393,0.521-0.721,0.734-1.129c0.334,0.693,0.773,1.365,1.241,1.899 c-0.111,0.392-0.278,0.769-0.498,1.128C187.676,190.232,186.857,189.814,186.514,189.039z M186.65,192.424 c-0.445-0.679-0.828-1.402-1.252-2.096c0.111-0.094,0.225-0.186,0.325-0.281c0.317,0.56,0.961,1.57,1.628,1.719 C187.139,191.998,186.91,192.218,186.65,192.424z M182.131,191.951c0.186-0.049,0.374-0.102,0.547-0.158 c0.39,0.561,0.783,1.176,1.246,1.682c0.4,0.435,1.165,0.02,0.965-0.561c0.181,0.1,0.356,0.201,0.534,0.305 c-0.704,0.379-1.491,0.684-2.327,0.906C183.245,193.464,182.453,192.437,182.131,191.951z M184.223,191.125 c0.075-0.041,0.152-0.078,0.225-0.119c0.084,0.141,0.17,0.281,0.255,0.426C184.537,191.334,184.383,191.229,184.223,191.125z M178.057,192.271c0.08,0.009,0.159,0.009,0.238,0.019c0.492,0.482,1.51,2.038,2.273,2.038c1.48,0-0.414-1.851-0.607-2.044 c0.312-0.02,0.617-0.051,0.91-0.089c0.514,0.653,0.734,1.526,1.222,2.157c-1.203,0.22-2.471,0.271-3.712,0.129 C178.995,194.021,178.25,192.75,178.057,192.271z M172.626,188.682c-0.021-0.029-0.047-0.054-0.069-0.083 c-1.75-2.503-0.9-5.019,1.902-5.925c1.25-0.407,2.617-0.469,3.901-0.205c0.448,0.092,1.253,0.584,1.712,0.381 c0.455-0.207,0.449-0.884,0.006-1.093c2.213,0.791,4.564,1.687,5.562,4.179c-0.09,1.702-1.824,3.018-3.068,3.848 C179.297,190.708,175.595,190.505,172.626,188.682z M175.117,191.689c0.518,0.176,1.06,0.311,1.608,0.41 c0.286,0.646,0.45,1.713,0.883,2.266c-0.136-0.024-0.271-0.043-0.406-0.073c-0.415-0.093-0.889-0.226-1.39-0.413 C176.221,193.309,175.34,192.158,175.117,191.689z M171.181,189.113c0.765,0.62,1.46,1.357,2.31,1.853 c0.355,0.8,0.76,1.583,1.136,2.374c-0.325-0.176-0.649-0.379-0.962-0.613c0.168-0.76-1.541-2.199-2.07-2.517 C171.435,189.871,171.293,189.51,171.181,189.113z M173.033,181.619c-0.045,0.117-0.061,0.248-0.023,0.38 c-1.537,0.802-2.717,2.274-2.611,4.146c-0.021-0.059-0.043-0.121-0.061-0.185C169.818,183.96,171.408,182.325,173.033,181.619z" /> <path fill="#4B4033" d="M141.215,160.906c-1.44,2.198-1.965,4.932-1.445,7.539c0.271,1.348,0.162,2.221,0.992,3.482 c0.678,1.035,1.557,1.789,2.172,2.867c1.141,1.986,2.464,3.891,4.064,5.5c0.438,0.439,3.891,3.734,4.219,2.133 c1.72,0.545,3.518,0.777,4.728,0.875c0.272,2.387,12.878-2.723,13.66-5.018c0.098-0.029,0.197-0.056,0.298-0.082 c0.15,0.016,0.289-0.014,0.421-0.119c1.052-0.273,5.957-0.861,6.046-2.298c0.827-0.343,1.624-0.772,2.364-1.28 c0.271-0.008,0.542-0.176,0.608-0.449c1.662-1.311,2.387-2.122,3.151-4.268c1.106,0.119,0.321-1.333,0.099-1.725 c0.518-1.051-2.446-5.75-3.127-6.688c-1.143-1.573-1.814-3.525-3.262-4.893c-1.7-1.611-4.009-2.462-6.298-2.402 c-1.015,0.028-2.027,0.229-2.983,0.599c-0.943,0.366-1.561,0.156-2.554,0.045c-4.676-0.523-9.195,0.006-13.815,0.716 c-3.797,0.585-6.484,1.78-8.67,5.254C141.643,160.604,141.364,160.676,141.215,160.906z M164.914,156.014 c-1.481-0.08-2.957-0.199-4.434-0.303c1.67,0.021,3.195,0.131,4.434,0.291C164.914,156.006,164.914,156.01,164.914,156.014z M169.049,155.771c-0.061,0.091-0.09,0.197-0.091,0.31c-0.732,0.025-1.474,0.025-2.222,0.004 c0.443-0.373,1.293-0.52,1.841-0.627c0.081,0.145,0.214,0.26,0.384,0.295L169.049,155.771z M177.531,161.801 c-0.375-1.016-0.812-1.937-1.192-2.658c-0.009-0.047-0.009-0.099-0.02-0.145c0.446,0.518,0.64,1.578,1.083,1.904 C177.463,161.193,177.504,161.493,177.531,161.801z M179.139,163.031c-0.066-0.028-0.138-0.039-0.207-0.037 c0.003-0.107,0-0.209-0.003-0.32C179.001,162.793,179.068,162.909,179.139,163.031z M181.088,168.82 c-0.895-1.053-1.861-2.037-2.722-3.121c-0.006-0.367,0.302-0.973,0.386-1.344C179.604,165.699,180.822,167.188,181.088,168.82z M180.613,170.981c-0.674-1.139-1.568-2.251-2.566-3.181c0.058-0.158,0.107-0.318,0.146-0.48 c0.908,1.044,1.943,2.021,2.716,3.182C180.82,170.666,180.717,170.822,180.613,170.981z M176.568,170.057 c0.521-0.391,0.557-0.676,0.914-1.169c0.783,0.76,1.493,1.64,2.047,2.536c-0.598-0.137-0.951,0.67-0.486,1.051 c-0.137,0.109-0.211,0.285-0.213,0.465c-0.018,0.017-0.038,0.029-0.057,0.047C177.9,171.941,177.168,170.971,176.568,170.057z M174.758,171.074c0.288-0.116,0.567-0.25,0.832-0.391c0.54,0.826,1.17,1.688,1.914,2.603c-0.379,0.067-0.562,0.481-0.42,0.823 c-0.021,0.016-0.041,0.023-0.062,0.035C176.645,173.574,175.556,171.962,174.758,171.074z M170.35,172 c0.307-0.01,0.613-0.033,0.926-0.066c0.631,0.656,1.287,1.297,1.859,2.009c-0.737,0.854,1.246,1.603,1.395,0.384 c0.116-0.941-1.315-2.066-1.84-2.613c0.305-0.066,0.607-0.144,0.904-0.232c0.543,0.568,1.014,1.245,1.488,1.869 c-0.859,0.494,0.178,1.115,0.521,1.371c0.021,0.018,0.044,0.033,0.066,0.048c-0.866,0.343-1.756,0.584-2.629,0.716 C173.301,174.519,170.875,172.557,170.35,172z M171.215,175.389c0.16,0.084,0.319,0.166,0.481,0.242 c-0.084,0.014-0.161,0.039-0.229,0.086C171.383,175.605,171.301,175.498,171.215,175.389z M169.695,176.263 c0.359,0.212,0.75,0.212,1.096,0.476c-0.209,0.049-0.415,0.102-0.624,0.157C170.025,176.697,169.867,176.488,169.695,176.263z M166.357,172.148c0.083-0.074,0.172-0.147,0.258-0.225c0.02-0.001,0.037-0.004,0.06-0.008c0.415,1.2,2.155,2.418,2.943,3.357 c-0.099,0.081-0.177,0.195-0.206,0.332c-0.025,0.109-0.012,0.213,0.016,0.311C168.388,174.583,167.045,172.969,166.357,172.148z M168.695,171.99c0.037,0.035,0.273,0.273,0.608,0.619c-0.284-0.229-0.568-0.459-0.854-0.687 c0.09,0.012,0.184,0.019,0.275,0.026L168.695,171.99z M165.498,179.115c-0.676-1.463-1.744-2.767-2.633-4.092 c0.906-0.67,1.773-1.401,2.606-2.113c0.005,0.005,0.009,0.01,0.017,0.021c0.782,0.938,2.443,2.928,3.482,4.307 c-0.266,0.084-0.529,0.18-0.791,0.285c-0.352-0.688-3.309-4.168-4.064-3.059c-0.553,0.809,2.535,2.682,3.021,3.534 C166.609,178.275,165.879,178.633,165.498,179.115z M163.112,181.094c-0.91-1.541-2.099-2.752-2.843-4.447 c0.561-0.283,1.107-0.605,1.643-0.959c0.846,1.272,2.033,2.577,2.585,4.023c0.08,0.208,0.261,0.34,0.458,0.367 C164.354,180.441,163.739,180.779,163.112,181.094z M155.57,177.736c0.488-0.053,0.809,0.029,1.264-0.021 c0.076,1.035,1.196,3.093,2.043,3.676c1.115,0.773,0.695-0.967,0.432-1.358c-0.451-0.665-1.166-1.519-1.338-2.335 c0.008-0.062,0.001-0.122-0.011-0.18c0.425-0.105,0.844-0.238,1.249-0.396c0.52,1.188,1.152,2.309,1.873,3.307 c-0.561,0.466,0.043,0.933,0.401,1.197c0.056,0.041,0.112,0.084,0.176,0.122c-1.343,0.539-2.731,0.884-4.153,0.913 c-0.014-0.088-0.045-0.165-0.09-0.232C158.967,182.4,155.916,178.189,155.57,177.736z M154.74,181.972 c-0.751-1.511-1.843-2.79-2.79-4.165c0.741,0.041,1.483,0.056,2.228,0.027c0.496,1.344,1.938,3.125,2.754,4.331 C156.232,182.137,155.488,182.073,154.74,181.972z M149.244,177.549c0.43,0.057,0.863,0.105,1.308,0.152 c0.165,1.28,2.067,2.935,2.728,4.027c-0.596-0.123-1.18-0.273-1.732-0.449C152.12,180.582,149.67,178.138,149.244,177.549z M144.744,175.531c0.714,0.419,1.446,0.779,2.213,1.086c-0.049,0.465,0.316,0.631,0.666,0.689 c0.861,1.152,1.65,2.366,2.587,3.457c-0.515-0.239-1.874-1.573-2.432-1.364C146.668,178.275,145.64,176.928,144.744,175.531z M147.623,175.604c-0.002-0.014-0.009-0.029-0.014-0.042c0.091,0.048,0.183,0.098,0.274,0.144 C147.798,175.674,147.711,175.639,147.623,175.604z M145.777,174.618c0.031-0.059,0.052-0.124,0.06-0.19 c0.247,0.188,0.503,0.363,0.759,0.533C146.318,174.859,146.046,174.746,145.777,174.618z M143.969,159.985 c0.576-0.55,1.248-1.034,1.998-1.462c0.572,0.235,1.458-0.584,1.961-0.798c0.98-0.419,2.014-0.696,3.064-0.852 c1.886-0.284,3.805-0.2,5.691,0.005c3.512,0.379,7.029,1.213,10.594,1.223c0.405,0,0.666-0.427,0.535-0.801 c0.674,0,3.513,0.359,3.616-0.674c0.642,0.049,1.262,0.178,1.854,0.375c1.018,0.52,1.86,1.359,1.957,2.596 c0.037,0.451-0.11,1.441,0.664,1.293c0.449,0.988,0.933,2.249,1.172,3.509c-0.832,0.116-0.357,1.014-0.092,1.394 c-0.005,0.015-0.01,0.032-0.02,0.043c-0.672,0.244-1.34,1.379-1.938,1.842c-0.604,0.466-1.263,0.85-1.957,1.143 c-2.145,0.418-4.655,0.027-6.636,1.129c-0.856,0.475-5.242,2.629-4.578,3.766c-0.024,0.023-0.047,0.047-0.068,0.064 c-6.797,4.636-17.122,1.842-19.508-6.619C142.113,164.697,142.651,162.059,143.969,159.985z M140.782,165.369 c0.089,1.12,0.346,2.268,0.557,3.367c-0.106,0.088-0.181,0.213-0.204,0.357C140.757,167.858,140.635,166.597,140.782,165.369z" /> <path fill="#4B4033" d="M12.96,123.343c-1.582,1.229,4.244,10.116,5.081,11.42c1.123,1.745,2.054,3.668,3.328,5.296 c0.493,0.637,2.351,3.146,3.206,3.06c0.262,0.184,0.529,0.354,0.805,0.521c-0.696,1.259,4.861,3.272,5.763,3.596 c0.056,1.204,9.056,2.707,10.32,2.99c3.805,0.847,7.763,1.479,11.652,0.927c0.236,0.222,1.562,1.416,1.567,0.128 c0.999,0.146,2.003,0.288,3.008,0.407c0.578,1.184,6.011,0.254,7.131,0.096c-0.184,1.043,1.092,0.721,1.218-0.225 c0.582-0.131,1.146-0.286,1.731-0.402c0.701,2.332,2.027,4.366,3.272,6.413c0.457,0.747,1.638,3.842,2.448,3.798 c0.226,0.254,0.408,0.537,0.552,0.851c0.971,0.857,2.97,4.279,4.337,4.302c-0.908,1.367,6.667,2.999,7.629,3.146 c2.868,0.451,5.757,0.852,8.636,1.25c5.688,0.786,12.143,1.449,17.635-0.699c0.298,0.387,1.149,0.888,1.251-0.014 c0.05-0.463-0.5-0.918-0.744-1.228c2.615-0.728,5.254-1.195,7.896-1.769c0.588,1.409,1.776,1.424,1.137-0.26 c0.719-0.164,1.435-0.342,2.146-0.537c0.42,0.726,1.619,0.639,1.152-0.334c4.013-1.238,7.965-3.457,11.61-5.581 c1.776-1.03,3.497-2.208,5.015-3.628c0.694-0.65,2.538-2.189,2.715-3.137c0.514,0.471,1.254-0.25,0.823-0.81l-0.085-0.116 c0.219-0.195,0.693-0.674,0.645-1c0.281,0.373,0.788,1.039,1.233,0.446c0.282,0.386,0.811,0.271,0.972-0.135 c0.523,0.12,5.184,1.029,4.487-0.489c3.771-0.775,7.085-2.826,9.874-5.536c1.455-1.407,2.672-3.403,3.754-5.209 c0.539-0.892,1.957-2.984,1.664-4.116c2.61-3.154,4.219-6.664,4.613-10.822c0.136-1.45-1.354-10.627-2.644-10.17 c-2.655-2.77-5.579-5.407-7.876-8.516c0.014-0.71,0.2-1.336,0.565-1.869c1.125,0.394,1.55-0.17,0.802-1.228 c3.791-4.99,5.861-10.527,7.188-16.717c0.828-0.082,0.49-1.34,0.375-1.863c0.935,0.081,0.659-6.098,0.686-7.028 c0.32,0.354,1.249,0.849,1.255-0.113c0.003-0.577-0.922-1.266-1.245-1.647c-0.006-0.686,0.351-3.572-0.654-3.621 c-0.075-0.854,0.108-3.528-0.558-4.087c-0.681-0.576-0.948,0.4-0.897,0.893c-1.887-2.938-4.115-5.614-6.388-8.231 c-1.108-1.273-1.952-2.86-2.398-4.524c-0.272-1.018-1.249-0.141-0.975,0.739c-1.325-1.989-2.593-3.768-4.573-4.896 c-2.027-1.545-4.328-2.67-6.734-3.414c-5.001-1.545-9.947-1.311-15.109-1.368c-1.146-3.646-2.262-7.129-3.928-10.466 c1.406-0.576-2.004-2.773-2.271-2.993c-1.008-2.525-2.085-5.017-3.389-7.547c-0.789-1.532-1.64-3.031-2.586-4.462 c-0.106-0.161-2.093-2.804-1.951-0.938c-0.377-0.449-0.754-0.886-1.133-1.315c0.289-1.27-7.816-8.843-8.583-8.036 c-0.424-0.539-2.413-3.744-3.181-2.763C99.993,4.097,92.281,1.21,83.998,1.612c-3.439-0.512-8.583,1.13-11.718,2.542 c-0.769,0.344-7.572,3.227-7.464,3.758c-1.69,1.014-3.083,2.414-4.677,3.563c-1.472,1.063-2.833,2.303-4.02,3.702 c-0.5-0.154-3.479,4.537-3.927,5.283c-1.403,2.339-1.701,5.231-1.755,7.926c-3.441-2.119-8.029-1.447-11.783-0.809 c-2.161,0.363-4.167,0.678-6.25,1.403c-0.719,0.249-5.468,1.238-4.71,2.132c-4.137,2.355-9.241,6.65-9.745,11.917 c-0.936,3.048-2.012,6.396-2.008,9.62c0.003,0.808-0.053,6.03,1.083,5.779c0.425,1.078,0.329,2.332,0.701,3.464 c0.37,1.121,0.944,2.159,1.635,3.096c1.301,1.762,3.565,2.91,4.707,4.681c-0.604,0.869,2.984,5.702,3.644,6.386 c-3.982,1.646-7.972,4.062-10.607,7.652c-2.434,3.319-4.297,7.681-5.492,11.646C8.831,104.547,8.951,114.615,12.96,123.343z M18.899,61.708c0.319,0.408,0.664,0.796,1.032,1.16c-0.168,0.769,1.418,2.446,1.815,3.077 C20.516,64.7,19.489,63.327,18.899,61.708z M29.158,32.447c-0.893,0.709-1.987,1.325-3.158,1.948 C26.962,33.519,27.983,32.966,29.158,32.447z M49.878,29.439c-0.341-0.031-0.681-0.067-1.025-0.092 c-0.633-0.404-1.33-0.719-2.076-0.971C47.937,28.552,48.996,28.888,49.878,29.439z M51.664,31.324 c-0.028-0.016-0.054-0.03-0.081-0.042c0-0.033,0-0.066,0-0.094C51.609,31.234,51.637,31.277,51.664,31.324z M54.504,19.489 c-1.284,2.061-2.278,4.302-2.792,6.653c0.247-2.478,0.988-4.615,2.531-6.533C54.336,19.592,54.426,19.553,54.504,19.489z M56.29,16.824c-0.377,0.568-0.759,1.12-1.145,1.679c0.202-0.338,0.417-0.663,0.646-0.983 C55.956,17.287,56.118,17.049,56.29,16.824z M84.389,2.893c-0.351,0.021-0.699,0.053-1.045,0.103 c0.033-0.045,0.053-0.097,0.069-0.15C83.741,2.782,84.067,2.798,84.389,2.893z M96.883,5.005 c-0.22,0.171-0.26,0.423-0.126,0.752c-0.105-0.048-0.21-0.089-0.316-0.135c0.287-1.032-1.54-0.856-2.03-0.917 c-1.424-0.613-2.847-1.144-4.264-1.604C92.5,3.454,94.761,4.088,96.883,5.005z M99.906,6.546 C99.903,6.55,99.9,6.55,99.898,6.554c-0.042-0.026-0.084-0.057-0.128-0.088C99.816,6.494,99.861,6.521,99.906,6.546z M113.9,17.969c-0.154-0.032-0.277,0-0.364,0.096c-0.274-0.305-0.931-1.172-1.192-1.49c-0.062-0.089-0.125-0.178-0.184-0.267 C112.737,16.844,113.318,17.396,113.9,17.969z M115.369,19.45c-0.081,0.049-0.156,0.113-0.203,0.194 c-0.189-0.326-0.387-0.663-0.582-0.997C114.844,18.909,115.105,19.176,115.369,19.45z M120.388,25.366 c-1.476-1.378-3.105-2.775-3.899-4.725C117.826,22.101,119.141,23.67,120.388,25.366z M123.502,29.559 c-0.238-0.247-0.484-0.496-0.733-0.746c0.092-0.088,0.153-0.198,0.177-0.32c0.012-0.002,0.023-0.002,0.032-0.006 C123.158,28.84,123.33,29.197,123.502,29.559z M125.111,33.133c-0.66-0.599-4.318-4.923-4.927-4.233 c-0.292-0.593-0.588-1.19-0.899-1.789c2.175,1.968,4.149,4.033,5.705,5.733C125.03,32.942,125.07,33.038,125.111,33.133z M126.554,36.697c-1.487-1.407-3.063-2.702-4.612-4.029c-0.277-0.625-0.559-1.25-0.847-1.866 c1.528,1.698,3.278,3.299,5.019,4.767C126.26,35.945,126.409,36.323,126.554,36.697z M128.534,42.03 c-1.278-1.831-3.071-3.12-4.682-4.601c-0.298-0.801-0.599-1.588-0.909-2.366c1.583,1.345,3.251,2.811,4.639,4.354 c0.047,0.125,0.092,0.253,0.141,0.376c-0.164,0.32-0.027,0.712,0.307,0.839C128.201,41.103,128.369,41.57,128.534,42.03z M132.049,48.297c-0.092,0.005-0.185,0.008-0.275,0.011c-1.115-1.628-2.594-2.984-4.006-4.324 c-1.465-1.386-2.256-2.414-3.082-4.264c1.131,0.969,2.262,1.98,3.091,3.254c0.864,1.326,1.94,0.909,1.042-0.522 c1.148,0.732,0.633-1.287,0.486-1.693c0.031-0.01,0.059-0.024,0.08-0.05C130.411,43.15,131.227,45.682,132.049,48.297z M126.068,49.657c0,0-0.005,0-0.005,0.003c-0.14-0.395-0.275-0.788-0.411-1.188c0-0.758-0.109-1.542-0.209-2.292 C125.646,47.34,125.814,48.509,126.068,49.657z M126.506,45.573c-0.08-0.446-0.182-0.998-0.287-1.441 c1.323,1.267,2.688,2.496,3.875,3.907c-0.158,0.134-0.223,0.279-0.195,0.444c-0.173,0.026-0.342,0.056-0.51,0.085 C128.637,47.939,127.479,45.715,126.506,45.573z M128,48.884c-0.295,0.085-0.58,0.185-0.858,0.289 c-0.095-0.457-0.192-1.012-0.286-1.562C127.228,48.055,127.617,48.493,128,48.884z M129.104,49.83 c0.013,0.01,0.026,0.018,0.04,0.025c-0.048,0.001-0.093,0-0.141,0C129.039,49.848,129.071,49.837,129.104,49.83z M157.211,57.678c-0.195-0.219-0.396-0.433-0.594-0.646c0.004-0.039,0.002-0.081,0.001-0.121 C156.829,57.16,157.029,57.418,157.211,57.678z M158.548,59.282c-0.097-0.123-0.195-0.249-0.295-0.368 c0.017,0.003,0.034,0.008,0.048,0.003C158.385,59.038,158.469,59.16,158.548,59.282z M163.485,64.657 c-0.366-0.441-0.718-0.763-1.022-0.833c-0.133-0.445-0.279-0.889-0.443-1.323C162.229,62.798,162.792,63.653,163.485,64.657z M167.787,85.658c-0.416-0.128-1.287-0.688-1.504,0.103c-1.26-1.356-2.695-2.521-4.073-3.737 c0.006-0.024,0.009-0.052,0.015-0.077C164.332,82.575,166.381,83.917,167.787,85.658z M162.471,80.778 c0.01-0.059,0.021-0.113,0.033-0.172c0.13,0.101,0.256,0.205,0.385,0.308C162.746,80.863,162.607,80.816,162.471,80.778z M165.645,76.29c-0.591-0.262-1.205-0.475-1.847-0.627c0.015-0.309-0.173-0.556-0.456-0.611 c0.037-0.388,0.066-0.772,0.091-1.159C164.186,74.69,164.923,75.491,165.645,76.29z M163.51,70.657 c-0.014-0.438-0.032-0.878-0.063-1.313c1.886,1.486,3.593,3.656,5.249,5.774c0.09,0.11,0.174,0.219,0.262,0.332 C167.35,74.69,165.498,73.062,163.51,70.657z M163.232,67.318c-0.025-0.189-0.057-0.377-0.087-0.564 c0.391,0.615,0.8,1.221,1.224,1.823c-0.329-0.271-0.666-0.522-1.01-0.753C163.38,67.644,163.338,67.477,163.232,67.318z M169.721,73.013c-1.283-1.545-2.553-3.1-3.781-4.688c-0.317-0.41-0.83-1.297-1.395-2.175c1.215,1.659,2.489,3.2,2.94,3.015 c0.327,0.468,1.147,2.336,1.904,1.82c0.052-0.04,0.092-0.088,0.131-0.136C169.591,71.588,169.658,72.309,169.721,73.013z M170.17,79.649c-0.105-0.122-0.213-0.247-0.32-0.368c0.504-0.783-2.227-2.944-2.717-3.513c1.021,0.695,1.986,1.119,2.895,1.291 C170.083,77.94,170.133,78.808,170.17,79.649z M170.042,83.087c-1.532-2.291-3.819-3.779-5.47-5.949 c1.161,0.436,2.244,1.07,3.325,1.685c0.417,0.476,1.565,2.401,2.317,2.018C170.24,81.592,170.135,82.342,170.042,83.087z M168.965,85.05c-1.832-2.132-4.023-4.034-6.215-5.752c0.051-0.472,0.178-0.922,0.373-1.354 c2.199,1.856,4.297,3.974,5.832,6.495C168.959,84.644,168.964,84.846,168.965,85.05z M164.826,99.766 c0.127-1.041-0.98-2.075-1.584-2.734c0.584-0.83-2.568-3.346-3.17-3.916c0.18-0.417,0.354-0.834,0.521-1.253 c1.327,1.649,3.375,3.178,4.343,5.099c-0.296,0.923,1.317,1.092,1.177-0.057c-0.064-0.546-0.494-1.037-0.812-1.437 c-1.349-1.68-2.94-3.141-4.223-4.882c0.104-0.288,0.202-0.58,0.298-0.872c0.576,0.635,3.654,5.031,4.34,4.708 c1.409-0.663-3.398-5.41-3.943-6.019c0.15-0.55,0.278-1.103,0.384-1.659c0.602,0.607,4.034,5.676,5.042,4.781 c0.82-0.727-4.104-5.545-4.83-6.204c0.056-0.504,0.09-1.009,0.096-1.515c1.581,1.367,3.26,2.754,4.393,4.569 c0.209,0.33,1.084,1.646,1.416,0.531c0.203-0.68-0.84-1.779-1.206-2.236c0.596,0.232,1.204,0.366,1.843,0.357 c-0.183,2.578-0.796,5.021-1.605,7.452C166.658,96.272,165.83,98.04,164.826,99.766z M160.431,96.583 c0.444,0.956,0.896,1.924,1.313,2.902c-0.992-0.975-1.906-1.809-2.754-2.523c0.198-0.736,0.375-1.487,0.538-2.247 C159.907,95.207,160.164,96.015,160.431,96.583z M159.898,86.769c-0.033,0.015-0.066,0.036-0.1,0.057 c0.084-0.239,0.172-0.478,0.256-0.712C160.002,86.326,159.949,86.547,159.898,86.769z M159.907,102.282 c0.478,0.922,0.946,1.647,1.432,2.209c-0.03,0.078-0.032,0.161-0.009,0.245c-0.201,0.244-0.408,0.488-0.615,0.729 c-0.816-1.354-2.291-2.579-3.54-3.797c0.268-0.476,0.509-0.987,0.735-1.516C158.503,100.946,159.203,101.625,159.907,102.282z M157.991,94.926c0.001-0.034,0.001-0.068,0.005-0.099c0.056-0.088,0.113-0.179,0.166-0.272 C158.109,94.676,158.049,94.799,157.991,94.926z M158.417,98.827c0.034-0.098,0.066-0.193,0.099-0.292 c0.217,0.447,0.439,0.89,0.673,1.337C158.906,99.54,158.643,99.196,158.417,98.827z M158.635,90.685 c0.258-1.055,0.573-2.108,0.926-3.155c0.026,0.086,0.072,0.161,0.131,0.229c-0.091,0.438-0.182,0.892-0.266,1.356 c-0.461,0.195-0.611,1.1-0.77,1.515C158.646,90.647,158.643,90.667,158.635,90.685z M162.183,97.615 c0.713,0.76,1.442,1.604,1.504,1.969c-0.393,0.513,0.196,1.189,0.722,0.892c-0.215,0.342-0.439,0.685-0.661,1.022 C163.316,100.194,162.764,98.891,162.183,97.615z M161.078,100.975c0.547,0.643,1.118,1.301,1.721,1.883 c-0.09,0.121-0.174,0.244-0.266,0.366C161.885,102.5,161.535,101.842,161.078,100.975z M166.936,115.788 c-0.596-0.674-3.035-4.505-3.87-4.229c-0.142-0.572-0.321-1.13-0.542-1.676C164.158,111.789,165.63,113.611,166.936,115.788z M165.303,123.531c-0.818-0.887-1.635-1.794-2.42-2.721c0.091-0.455,0.174-0.913,0.249-1.367 c0.403,0.408,0.961,1.188,1.457,1.445c-0.104,0-0.212,0.02-0.312,0.083C163.414,121.534,164.959,123.086,165.303,123.531z M163.342,117.953c0.086-0.761,0.141-1.518,0.154-2.265c0.344,0.507,0.329,1.688,0.688,2.345 c0.523,0.952,1.187,1.814,1.864,2.65C165.145,119.785,164.186,118.919,163.342,117.953z M169.6,126.634 c-0.158,0.138-0.213,0.344-0.19,0.53c-0.563-1.834-3.216-4.305-3.983-5.447C167.117,123.395,169.477,125.82,169.6,126.634z M166.918,126.992c-1.734-0.599-3.086-1.574-4.379-2.883c0.123-0.527,0.225-1.053,0.285-1.572 C164.164,124.051,165.555,125.51,166.918,126.992z M168.328,119.1c-0.241,0.154-0.342,0.46-0.228,0.74 c-1.763-2.146-3.587-4.59-4.71-6.443c-0.004-0.023-0.008-0.051-0.011-0.076c1.241,1.664,2.724,3.309,4.165,4.909 C167.809,118.521,168.068,118.809,168.328,119.1z M169.893,118.515c-0.48-0.812-0.961-1.626-1.438-2.438 c0.256,0.43,0.604,0.715,1.05,0.852C169.617,117.473,169.746,118,169.893,118.515z M170.436,122.539 c-0.505-0.551-1.057-1.175-1.625-1.851c0.487,0.529,1.004,1.039,1.549,1.534C170.389,122.324,170.412,122.434,170.436,122.539z M169.488,128.125c0.053-0.228,0.045-0.479-0.015-0.74c0.091,0.175,0.256,0.307,0.497,0.307c0.079,0,0.16-0.021,0.236-0.057 c-0.082,0.333-0.174,0.671-0.276,1.005C169.822,128.436,169.677,128.268,169.488,128.125z M169.186,130.715 c-0.647-0.848-1.411-1.664-2.229-2.461c0.419,0.125,0.848,0.221,1.285,0.273c-0.646,0.604,0.689,1.612,1.225,1.486 C169.376,130.247,169.283,130.484,169.186,130.715z M165.889,130.777c0.504-0.555-0.279-1.91-0.529-2.42 c1.022,0.953,2.003,1.922,2.795,2.922c-0.477-0.172-1.338,0.082-0.923,0.799c0.196,0.34,0.737,0.414,1.045,0.562 c-0.122,0.228-0.247,0.454-0.372,0.674C167.498,132.637,166.832,131.804,165.889,130.777z M165.709,136.305 c0.011-0.055,0.016-0.116,0.016-0.176c0-2.238-3.547-4.625-4.799-6.111c0.199-0.627,0.886-2.088,0.571-2.729 c0.216-0.522,0.417-1.045,0.591-1.569c0.922,1.036,1.881,2.25,2.462,3.659c-0.601-0.605-1.206-1.199-1.821-1.791 c-0.546-0.525-1.324,0.355-0.78,0.881c1.644,1.576,4.437,3.658,5.253,5.968C166.711,135.168,166.204,135.803,165.709,136.305z M162.04,141.137c-0.366,0.359-0.729,0.72-1.097,1.084c-1.299-1.519-2.591-3.523-4.076-4.816 c0.242-0.291,0.48-0.586,0.706-0.886l0.272,0.272C159.268,138.217,160.725,139.678,162.04,141.137z M157.264,134.945 c-0.004,0-0.006,0-0.01,0c0.235-0.357,0.469-0.719,0.697-1.08C157.736,134.232,157.504,134.592,157.264,134.945z M158.924,141.686c0.42,0.475,0.826,0.938,1.192,1.369c-0.448,0.457-0.892,0.922-1.317,1.386 c-1.217-1.696-2.842-2.989-4.197-4.556c0.523-0.533,1.021-1.062,1.496-1.598C156.838,139.314,157.896,140.517,158.924,141.686z M158.268,135.553c0.27-0.391,0.523-0.798,0.77-1.223c0.441,0.484,0.89,0.998,1.354,1.538c1.086,1.262,2.205,2.559,3.408,3.528 c-0.307,0.309-0.613,0.612-0.922,0.918C161.393,138.673,159.828,137.113,158.268,135.553z M159.627,133.244 c0.309-0.613,0.595-1.266,0.857-1.959c1.045,1.154,3.881,3.158,4.088,4.802c-0.393,0.542,0.272,1.229,0.787,0.839 c0.002,0.143,0.048,0.285,0.148,0.398c0.047,0.053,0.104,0.092,0.164,0.121c-0.34,0.371-0.686,0.74-1.039,1.107 C162.721,137.062,161.285,135.008,159.627,133.244z M161.697,143.127c0.374-0.375,0.752-0.75,1.127-1.117 c0.562,0.598,1.386-0.437,0.836-0.819c0.764-0.753,1.524-1.515,2.264-2.293c-0.822,1.688-2.109,3.522-3.563,5.162 C162.199,143.791,161.974,143.479,161.697,143.127z M156.008,149.216c0.209-1.426-3.965-4.727-4.896-5.679 c0.414-0.281,1.607-0.896,1.454-1.604c0.404-0.403,0.811-0.806,1.214-1.211c1.479,1.698,3.368,3.097,4.525,5.078 c0.756,1.294,1.962,1.181,1.119-0.38c0.503-0.225,1.06-1.061,1.443-1.453c0.211,0.267,0.422,0.74,0.709,0.932 c-1.018,1.055-2.081,1.973-3.102,2.664c-0.887-0.932-1.799-1.832-2.662-2.787c-0.531-0.592-1.596-2.656-2.326-2.83 c-1.557-0.359,0.141,2.024,0.318,2.252c0.836,1.09,1.788,2.078,2.738,3.059c-0.498,0.524,0.123,0.951,0.557,1.1 c-0.119,0.057-0.242,0.121-0.355,0.168c-0.215,0.086-0.346,0.293-0.36,0.514C156.259,149.102,156.133,149.156,156.008,149.216z M154.092,149.146c0.326,0.175,0.658,0.331,0.992,0.471c-0.182,0.073-0.369,0.143-0.555,0.21 C154.396,149.585,154.25,149.355,154.092,149.146z M146.504,145.449c1.019-0.227,2.029-0.551,2.992-0.998 c0.262,0.148,0.516,0.072,0.729-0.143c0.785,0.803,1.578,1.603,2.352,2.423c-0.564-0.428-1.688-1.815-2.404-1.823 c-0.42-0.011-0.712,0.461-0.522,0.858c0.719,1.536,2.066,2.46,3.161,3.662c-0.426,0.087-0.623,0.628-0.325,0.984 c-0.272,0.058-0.554,0.112-0.835,0.157C151.708,149.383,147.443,146.188,146.504,145.449z M150.221,142.623 c-0.041-0.049-0.09-0.088-0.15-0.119c0.246-0.149,0.488-0.297,0.732-0.47C150.611,142.227,150.418,142.425,150.221,142.623z M147.324,144.005c0.627-0.356,1.231-0.709,1.874-1.026c-0.005,0.092,0.015,0.18,0.052,0.27 C148.629,143.555,147.982,143.803,147.324,144.005z M149.641,150.457c-0.85-0.594-2.139-1.869-3.222-3.036 c1.122,1.004,2.646,1.937,3.386,2.646c-0.097,0.107-0.143,0.254-0.148,0.404C149.649,150.468,149.646,150.461,149.641,150.457z M145.275,149.232c-0.777-0.939-1.6-1.93-2.289-2.962c0.215-0.106,0.431-0.215,0.646-0.321c0.76,1.088,3.138,3.669,4.736,5.008 c-0.543-0.125-2.036-1.262-2.48-0.985C145.686,149.727,145.482,149.484,145.275,149.232z M144.926,145.725 c0.062-0.008,0.127-0.016,0.193-0.026c0.058,0.194,0.152,0.39,0.273,0.585C145.221,146.078,145.059,145.891,144.926,145.725z M143.277,143.871c-0.024-0.013-0.039-0.029-0.063-0.037c-0.167-0.057-0.327-0.127-0.483-0.197 c0.328,0.094,0.66,0.169,0.988,0.225C143.572,143.871,143.424,143.873,143.277,143.871z M142.991,148.343 c-0.169-0.247-0.327-0.496-0.497-0.744C142.643,147.805,142.81,148.064,142.991,148.343z M143.85,149.634 c0.49,0.69,1.013,1.312,1.504,1.542c0.044,0.055,0.086,0.107,0.13,0.164c-0.22-0.08-0.399-0.06-0.538,0.063 C144.595,150.805,144.227,150.219,143.85,149.634z M138.002,146.803c0.162-0.215,0.312-0.436,0.457-0.654 c1.67,1.966,3.404,3.856,4.356,6.298C141.051,151.287,139.324,148.512,138.002,146.803z M141.312,145.902 c0.027,0,0.053,0,0.08,0.003c0.187,0.331,0.387,0.655,0.596,0.968C141.764,146.552,141.539,146.227,141.312,145.902z M140.604,144.674c-0.024-0.037-0.047-0.081-0.069-0.115c0.083,0.032,0.17,0.061,0.255,0.086 c0.007,0.016,0.01,0.029,0.018,0.044C140.734,144.684,140.67,144.679,140.604,144.674z M139.704,145.812 c0.045,0.002,0.09,0.006,0.137,0.01c0.164,0.196,0.302,0.412,0.411,0.643C140.069,146.244,139.885,146.029,139.704,145.812z M139.016,144.539c-0.004-0.006-0.004-0.016-0.008-0.021c0.023-0.026,0.048-0.056,0.073-0.08 c0.024,0.038,0.052,0.076,0.079,0.116C139.111,144.549,139.062,144.543,139.016,144.539z M140.083,156.438 c0.097-0.065,0.192-0.129,0.284-0.191c0.061,0.045,0.119,0.086,0.178,0.126c-0.097,0.085-0.2,0.173-0.3,0.257 C140.193,156.565,140.136,156.502,140.083,156.438z M139.559,151.312c-0.037-0.062-0.07-0.12-0.107-0.18 c-0.469-0.784-0.928-1.548-1.311-2.308c1.24,1.453,2.578,2.87,3.569,4.516c-0.155-0.116-0.331-0.172-0.521-0.166 C140.844,152.684,140.209,151.448,139.559,151.312z M139.331,155.519c-0.941-1.183-1.88-2.431-2.563-3.798 c-0.163-0.324-0.889-2.321-1.433-1c-0.181-0.245-0.353-0.477-0.517-0.685c0.303-0.244,0.598-0.492,0.883-0.745 c0.648,0.707,3.44,5.584,4.134,4.893c0.064,0.134,0.132,0.266,0.195,0.397c-0.464-0.122-0.899,0.403-0.626,0.888 C139.381,155.486,139.355,155.502,139.331,155.519z M136.551,148.484c0.039-0.039,0.078-0.076,0.117-0.117 c0.072,0.173,0.145,0.348,0.224,0.522C136.77,148.738,136.654,148.6,136.551,148.484z M134.529,148.758 c-0.044-0.094-0.111-0.155-0.201-0.189c0.652-0.459,1.294-0.945,1.92-1.467C135.729,147.681,135.151,148.232,134.529,148.758z M137.562,157.98c0.106-0.061,0.217-0.117,0.323-0.178c0.046,0.201,0.073,0.378,0.079,0.537 c-0.067,0.045-0.135,0.092-0.204,0.135C137.774,158.291,137.708,158.106,137.562,157.98z M136.959,158.973 c0.004,0.004,0.006,0.005,0.01,0.005c-0.004,0.002-0.004,0.002-0.006,0.003C136.961,158.978,136.961,158.978,136.959,158.973z M135.281,159.94c0.008,0.001,0.015,0.005,0.021,0.007c-0.006,0.003-0.008,0.006-0.014,0.008 C135.285,159.95,135.282,159.943,135.281,159.94z M135.133,155.107c-0.093-0.369,0.002-2.027-0.943-1.375 c-0.529-0.805-0.775-1.564-1.182-2.374c0.3-0.202,0.595-0.406,0.882-0.615c1.251,1.589,2.829,4.073,3.604,5.915 c-0.269,0.155-0.537,0.305-0.806,0.444C136.215,156.563,135.676,155.866,135.133,155.107z M134.33,158.096 c-1.145-0.689-2.75-3.337-3.351-4.602c-0.327-0.692-1.358-0.164-1.028,0.531c0.376,0.797,0.957,1.506,1.477,2.199 c-0.387-0.228-1.259-0.932-1.738-0.482c-0.516,0.482,0.236,2.088,0.401,2.585c-0.849-0.853-2.001-3.226-2.979-3.697 c1.602-0.764,3.193-1.601,4.717-2.523c0.945,1.966,2.213,3.808,3.234,5.731C134.816,157.933,134.576,158.021,134.33,158.096z M127.416,153.112c-0.016-0.048-0.041-0.09-0.065-0.136c1.793-1.08,3.563-2.213,5.339-3.32 C131.143,151.111,129.312,152.225,127.416,153.112z M133.852,159.67c-0.479,0.503-0.99,1-1.535,1.443 c0.133-0.311-0.185-0.842-0.424-1.064c0.217-0.598-0.729-2.104-0.904-2.709c0.711,0.43,1.395,0.91,2.091,1.367 c-0.162,0.455,0.228,0.871,0.671,0.779C133.786,159.55,133.817,159.609,133.852,159.67z M130.465,162.273 c-1.352-2.131-3.492-5.16-5.504-6.649c0.404-0.274,0.924-0.429,1.364-0.634c-0.37,1.279,2.649,3.895,3.423,4.651 c0.449,0.439,1.384,1.711,2.053,1.711c0.102,0,0.181-0.014,0.248-0.03C131.553,161.699,131.026,162.035,130.465,162.273z M127.838,163.337c-1.016-2.29-3.842-4.329-5.447-6.204c0.588-0.305,1.149-0.619,1.682-0.939 c0.158,1.062,2.057,2.545,2.743,3.322c0.903,1.023,1.798,2.066,2.552,3.215C128.85,162.94,128.342,163.144,127.838,163.337z M118.973,158.681c0.834-0.332,1.641-0.683,2.412-1.05c0.199,0.924,1.755,2.098,2.378,2.771 c1.009,1.091,2.024,2.189,2.952,3.361c-0.535,0.195-2.227,0.428-2.2,1.246c-0.011,0.004-0.024,0.007-0.036,0.011 C123.074,162.818,121.156,160.613,118.973,158.681z M115.949,159.783c0.634-0.209,1.258-0.43,1.869-0.656 c0.41,1.065,2.315,2.26,3.092,3.133c0.863,0.973,1.668,2.002,2.389,3.09c-0.664,0.175-1.329,0.34-2,0.495 C119.95,163.462,117.797,161.719,115.949,159.783z M114.629,167.271c-1.645-1.956-3.705-3.533-5.109-5.705 c1.713-0.387,3.48-0.852,5.218-1.391c1.429,2.231,3.923,3.631,5.366,5.932c-0.844,0.18-1.688,0.352-2.529,0.528 c-0.665-0.647-4.851-5.31-5.377-4.957c-1.268,0.849,3.375,4.692,3.98,5.25C115.661,167.039,115.144,167.151,114.629,167.271z M111.977,167.966c-1.645-2.001-3.378-3.919-5.08-5.866c0.479-0.086,0.963-0.182,1.457-0.281 c0.351,2.051,3.671,4.311,4.984,5.773C112.883,167.707,112.431,167.832,111.977,167.966z M109.094,168.957 c-0.952-2.281-3.559-3.664-5.073-5.51c0.614-0.231,1.177-0.541,1.688-0.926c1.689,1.938,3.413,3.844,5.061,5.822 C110.203,168.531,109.645,168.736,109.094,168.957z M99.535,164.112c1.107,0.011,2.209-0.061,3.293-0.31 c1.033,1.493,5.242,3.926,5.268,5.845c-0.118,0.118-0.18,0.284-0.18,0.449c-1.086,0.155-2.238,0.237-3.416,0.272 c0.029-0.211,0.025-0.434-0.143-0.607c0.331,0,3.869,0.3,2.736-0.971c-0.576-0.647-3.032-0.229-3.825-0.218 C101.961,167.193,100.493,165.793,99.535,164.112z M98.625,164.843c-0.382-0.317-0.765-0.606-1.156-0.862 c0.255,0.023,0.508,0.056,0.758,0.071C98.327,164.305,98.461,164.568,98.625,164.843z M98.089,162.848 c-0.561-0.047-1.122-0.117-1.69-0.199c0.717-0.035,1.433-0.076,2.149-0.121C98.395,162.631,98.241,162.739,98.089,162.848z M98.611,162.521c0.883-0.058,1.741-0.125,2.576-0.202c0.067,0.286,0.309,0.474,0.588,0.46c0.096-0.008,0.193-0.016,0.293-0.023 c-0.916,0.158-1.908,0.197-2.94,0.156C99.049,162.688,98.85,162.529,98.611,162.521z M99.995,169.865 c0.874-0.037,1.751-0.062,2.636-0.084c-0.139,0.184-0.158,0.382-0.062,0.595c-0.836-0.017-1.679-0.044-2.522-0.097 C100.079,170.139,100.057,169.994,99.995,169.865z M98.644,168.726c-1.898-1.649-4.638-4.249-5.749-5.521 c0.597-0.037,1.391,0.283,1.985,0.393c0.004,0.239,0.147,0.465,0.376,0.549c1.784,0.674,3.758,2.378,5.258,4.5 C99.888,168.672,99.264,168.697,98.644,168.726z M96.909,169.996c0.337-0.016,0.669-0.027,1.009-0.043 c0.15,0.068,0.302,0.132,0.457,0.193C97.882,170.101,97.393,170.049,96.909,169.996z M94.062,168.581 c0.428,0.085,0.858,0.179,1.289,0.28c-0.322,0.007-0.642,0.018-0.962,0.026C94.278,168.785,94.167,168.683,94.062,168.581z M88.616,163.123c0.087-0.072,0.149-0.176,0.185-0.289c0.865,0.199,1.743,0.332,2.638,0.375 c0.794,1.346,2.134,2.579,3.236,3.643c-0.192,0.113-0.269,0.307-0.227,0.588c-0.667-0.135-1.333-0.254-1.994-0.363 C91.152,165.851,90.003,164.205,88.616,163.123z M88.741,168.686c0.43-0.049,0.583-0.488,0.443-0.889 c0.704,0.1,1.415,0.203,2.126,0.311c-0.063,0.238,0.015,0.499,0.224,0.65c0.066,0.049,0.143,0.098,0.208,0.147 C90.732,168.891,89.733,168.887,88.741,168.686z M88.589,166.505c-1.092-1.946-2.847-3.324-4.061-5.17 c0.779,0.357,1.564,0.675,2.359,0.948c-0.256,1.135,1.902,2.824,2.602,3.542c0.267,0.3,0.539,0.607,0.811,0.922 C89.729,166.665,89.161,166.586,88.589,166.505z M87.263,161.143c-0.946-0.324-1.878-0.721-2.802-1.158 c1.047,0.062,2.001,0.495,3.008,0.797C87.332,160.878,87.263,161,87.263,161.143z M85.958,167.461 c0.456,0.264,1.328,0.932,1.872,0.932c0.178,0.072,0.354,0.15,0.537,0.221c-0.153-0.029-0.301,0.006-0.42,0.088 c-0.464-0.046-0.929-0.104-1.393-0.168C86.428,168.162,86.144,167.801,85.958,167.461z M85.394,165.729 c-0.173-0.117-0.346-0.232-0.516-0.353c-0.087-0.176-0.176-0.355-0.266-0.538C84.852,165.116,85.114,165.41,85.394,165.729z M80.367,166.156c1.382,0.701,2.85,1.295,4.491,1.715c0.075,0.138,0.147,0.278,0.229,0.415 c-1.305-0.257-2.604-0.612-3.898-1.089C81.101,166.795,80.614,166.445,80.367,166.156z M82.755,163.768 c-1.857-1.502-3.14-3.037-4.34-5.197c0.215-0.004,0.358-0.082,0.432-0.23c0.573,0.297,1.137,0.599,1.7,0.918 C79.335,159.465,82.395,163.099,82.755,163.768z M81.291,159.676c0.623,0.346,1.25,0.682,1.88,1.002 c-0.412,0.084-0.583,0.357-0.639,0.505C82.155,160.656,81.748,160.15,81.291,159.676z M78.854,166.262 c0.017-0.022,0.028-0.043,0.039-0.063c0.024,0.026,0.049,0.058,0.072,0.089C78.93,166.277,78.894,166.264,78.854,166.262z M73.407,155.461c1.811,3.34,4.567,6.088,6.674,9.206c-0.56-0.303-1.104-0.631-1.642-0.968 C76.403,160.933,74.177,157.409,73.407,155.461z M77.084,158.711c-0.498-0.707-1.125-1.594-1.65-2.339 c0.299,0.158,0.602,0.319,0.904,0.487c0.149,0.805,0.744,1.703,1.135,2.398C77.349,159.084,77.218,158.899,77.084,158.711z M70.909,152.98c0.26,0.265,0.542,0.524,0.851,0.784c-0.44,0.355-0.171,0.917,0.277,1.072c0.32,1.627,1.972,4.481,3.767,7.142 c-0.255-0.172-0.51-0.343-0.765-0.515c-0.773-0.958-1.518-1.953-2.133-3.028c0.779-0.618-0.893-1.951-1.23-2.426 C71.271,155.002,70.995,153.986,70.909,152.98z M73.373,155.377c0.001,0.002,0.003,0.002,0.006,0.002 c0.006,0.016,0.006,0.029,0.012,0.042C73.385,155.406,73.38,155.393,73.373,155.377z M68.958,151.083 c0.175,0,0.302-0.058,0.426-0.2c0.119,0.249,0.256,0.496,0.414,0.74c-0.11,0.35-0.129,0.713-0.059,1.089 c-0.039,0.01-0.075,0.029-0.11,0.044C69.372,152.215,69.145,151.656,68.958,151.083z M68.901,145.775 c0.014-0.016,0.027-0.033,0.041-0.048c-0.009,0.077-0.018,0.15-0.027,0.226C68.908,145.893,68.908,145.835,68.901,145.775z M68.891,144.559c0.049-0.385,0.412-1.232,0.565-1.57c-0.149,0.687-0.302,1.387-0.418,2.078 C68.992,144.895,68.942,144.729,68.891,144.559z M67.829,141.914c0.192,0.008,0.388,0.01,0.583,0.018 c-0.104,0.225-0.182,0.449-0.265,0.676C68.043,142.374,67.939,142.143,67.829,141.914z M67.286,140.702 c0.014-0.195-0.066-0.374-0.205-0.493c0.555-0.082,1.11-0.168,1.667-0.248c0.331-0.011,0.66-0.018,0.99-0.029 c-0.153,0.281-0.306,0.562-0.458,0.846C68.614,140.736,67.95,140.715,67.286,140.702z M67.599,147.23 c-1.063-1.725-2.108-3.517-3.003-5.316c0.642-0.018,1.283-0.028,1.925-0.023c0.446,0.871,0.855,1.781,1.17,2.715 C67.527,145.404,67.486,146.252,67.599,147.23z M63.459,145.145c-0.33-0.561-0.941-2.857-1.397-3.127 c0.423-0.023,0.847-0.043,1.272-0.062c0.746,1.558,1.585,3.065,2.463,4.546c0.526,0.886,1.129,2.402,1.919,3.051 c-0.111,0.086-0.188,0.212-0.213,0.355c-0.022,0.006-0.048,0.005-0.071,0.012c-0.474,0.184-0.961,0.306-1.463,0.357 C65.564,148.404,64.405,146.752,63.459,145.145z M62.337,150.77c-0.319-3.121-3.262-5.61-4.343-8.455 c1.142-0.096,2.292-0.184,3.452-0.258c-1.388,1.072,3.051,6.971,3.39,8.404C64.015,150.588,63.164,150.747,62.337,150.77z M59.836,150.693c-1.4-2.469-4.431-4.975-4.65-7.993c0.645-0.024,1.022-0.233,1.62-0.286c0.971,2.93,3.873,5.296,4.37,8.35 C60.732,150.752,60.284,150.725,59.836,150.693z M47.28,140.813c-0.468-0.026-0.926-0.052-1.388-0.077 c3.546-0.076,7.093-0.203,10.636-0.176C53.422,140.909,50.396,141.002,47.28,140.813z M51.917,143.363 c0.114-0.159,0.138-0.347,0.077-0.564c0.686-0.045,1.359-0.061,2.044-0.068c0.168,2.855,2.607,5.257,4.108,7.451 c-0.06,0.105-0.084,0.227-0.075,0.344c-0.576-0.064-1.152-0.137-1.728-0.215C55.774,147.773,52.966,145.737,51.917,143.363z M53.584,149.34c0.14,0.146,0.278,0.294,0.421,0.439c-0.039,0.008-0.08,0.014-0.121,0.022 C53.786,149.648,53.685,149.492,53.584,149.34z M49.973,143.502c0.193-0.133,0.278-0.332,0.257-0.598 c0.092-0.004,0.185-0.01,0.277-0.014c0.625,1.944,1.869,3.541,3.051,5.145c-0.095,0.025-0.185,0.076-0.263,0.156 c-0.126,0.132-0.174,0.31-0.155,0.482C52.013,147.008,50.811,145.357,49.973,143.502z M46.438,142.996 c0.696,0.004,1.388-0.002,2.079-0.021c0.553,1.576,1.472,3.096,2.456,4.572c-0.457,0.032-0.704,0.616-0.398,0.989 c0.316,0.384,0.656,0.751,1.003,1.112c-0.45-0.051-0.899-0.104-1.346-0.143C49.015,147.336,47.37,145.326,46.438,142.996z M46.417,149.375c-1.206-2.115-2.62-4.108-3.623-6.34c0.035-0.023,0.066-0.053,0.097-0.086c0.025-0.023,0.038-0.059,0.057-0.09 c0.761,0.061,1.522,0.094,2.281,0.117c0.549,2.09,2.108,4.021,3.215,5.803c-0.388-0.287-1.568-0.393-1.084,0.578 C47.044,149.355,46.731,149.361,46.417,149.375z M38.891,142.662c0.209,0,0.359-0.082,0.448-0.248 c0.693,0.121,1.383,0.218,2.074,0.297c0.463,1.198,1.071,2.354,1.729,3.477c-0.567-0.232-1.004,0.473-0.666,0.924 c0.637,0.85,1.456,1.711,2.422,2.566c-0.633-0.105-1.266-0.227-1.896-0.353c0.281-0.661-0.1-1.308-0.764-1.317 C40.799,146.57,39.7,144.554,38.891,142.662z M38.256,147.712c-1.236-1.714-2.196-3.2-2.888-4.452 c1.695,1.566,3.441,3.078,5.115,4.671C39.736,147.881,38.992,147.809,38.256,147.712z M37.399,142.023 c0.299,0.86,0.669,1.681,1.068,2.463c-1.131-1.014-2.256-2.027-3.351-3.074c0.001,0,0.003,0.001,0.006,0.001 C35.885,141.648,36.644,141.847,37.399,142.023z M36.113,139.629c-0.376-0.133-0.749-0.272-1.119-0.414 c0.709,0.214,1.422,0.429,2.134,0.636C36.787,139.781,36.449,139.705,36.113,139.629z M35.471,147.228 c-1.811-2.159-4.345-6.372-4.158-7.204c0.382,0.155,0.767,0.309,1.155,0.456c0.036,0.242,0.618,1.146,0.886,1.222 c0.262,0.705,0.593,1.383,0.948,2.041c0.666,1.229,1.43,2.396,2.223,3.542c0.006,0.056,0.021,0.11,0.042,0.164 C36.199,147.381,35.832,147.308,35.471,147.228z M29.728,145.391c0.224-0.146,0.327-0.342,0.309-0.588 c0.229,0.342,0.451,0.674,0.663,0.994C30.368,145.668,30.046,145.531,29.728,145.391z M29.478,141.906 c-0.872-1.278-1.755-2.55-2.635-3.824c0.032-0.079,0.051-0.161,0.051-0.24c0.525,0.301,1.066,0.589,1.61,0.867 c1.246,2.916,2.849,5.619,4.713,7.945c-0.32-0.09-0.635-0.189-0.947-0.292C32.43,145.274,30.069,142.769,29.478,141.906z M30.216,139.678c-0.028-0.059-0.054-0.123-0.084-0.184c0.043,0.021,0.085,0.041,0.129,0.062 C30.247,139.598,30.227,139.633,30.216,139.678z M23.419,135.695c1.926,1.281,2.844,4.109,3.938,6.128 c0.529,0.978,1.161,2.144,1.417,2.735C26.924,142.167,24.039,138.344,23.419,135.695z M20.773,133.719 c0.45,0.379,0.913,0.74,1.387,1.096c0.006,0.424,0.074,0.875,0.2,1.347C21.841,135.367,21.311,134.547,20.773,133.719z M20.648,131.52c0.437,0.4,0.877,0.785,1.33,1.156c-0.036,0.01-0.062,0.027-0.08,0.062c-0.083-0.045-0.173-0.086-0.257-0.13 C21.3,132.249,20.972,131.885,20.648,131.52z M16.617,130.121c0.656,1.061,1.2,1.878,1.544,2.378 c-0.024,0.069-0.036,0.138-0.036,0.212C17.603,131.866,17.096,130.998,16.617,130.121z M12.992,116.832 c-0.289-1.512-0.44-3.053-0.458-4.595c0.866-0.227-0.337-4.976-0.379-5.918c-0.09-2.13,0.428-4.222,0.996-6.254 c1.102,0.341,1.922-7.476,2.173-8.555c0.875-2.795,4.297-4.888,4.822-7.818c1.653-1.354,2.94-2.591,4.817-3.616 c1.292-0.708,3.103-2.303,4.555-2.445c0.435-0.044,0.647-0.558,0.424-0.919c0.027-0.047,0.045-0.095,0.063-0.143 c1.059,0.917,0.701-1.049,0.286-1.555c-0.878-1.07-1.758-2.138-2.63-3.215c0.678-0.854-1.678-2.103-2.083-2.626 c1.334-0.396-1.769-2.83-2.124-3.318c-0.615-0.844-1.448-2.708-2.175-3.335c-0.557-1.225-1.847-7.792-2.913-8.047 c-0.069-0.54-0.117-1.083-0.137-1.639c1.359,0,0.999-4.43,0.95-5.303c-0.074-1.329,0.153-2.209,0.627-3.455 c0.292-0.385,1.134-1.025,0.649-1.59c0.788-1.78,1.704-3.494,2.841-5.058c0.387-0.071,1.799,0.02,1.267-0.924 c0.659-0.359,7.148-3.788,5.564-4.46c6.107-2.427,14.263-2.839,20.307-0.017c-0.011,0.537,0.574,0.959,0.99,0.505 c0.454,0.252,1.475,0.06,0.952-0.745c0.745-0.144,1.097-5.601,1.356-6.556c0.852-0.047,1.856-3.415,2.209-4.138 c0.744-1.52,1.56-3.006,2.497-4.402c0.976-1.455,2.06-2.616,3.393-3.717c0.544-0.452,2.94-1.668,2.75-2.507 c1.609-1.145,3.389-1.786,5.234-2.425c0.635-0.221,4.215-0.829,3.693-1.913c1.178-0.404,2.355-0.521,3.595-0.548 c0.26-0.004,2.358-0.135,1.18-1.066c0.25-0.078,1.31-0.471,1.562-0.468c-0.517,0.412-0.046,1.3,0.572,1.02 c0.651-0.295,1.33-0.521,2.021-0.684c1.522-0.354,3.334,0.174,4.861,0.415c3.006,0.474,6.146,0.692,8.927,2.036 c-0.038,0.908,3.868,2.364,4.596,2.788c2.158,1.259,4.249,2.649,6.246,4.168c3.476,2.644,6.506,6.098,8.007,10.359 c-1.303-0.936-0.387,1.345-0.175,1.625c0.954,1.239,1.86,2.521,2.712,3.841c1.485,2.302,2.25,5.325,3.152,7.926 c1.004,2.896,1.956,5.817,2.926,8.731c0.25,0.748,0.709,4.995,1.592,4.651c0.541,1.538,1.174,0.972,2.486,0.574 c1.111-0.34,2.066-0.44,3.218-0.526c1.229-0.088,5.486-0.053,6.235-1.209c2.203,0.273,4.39,0.698,6.562,1.162 c0.48,0.104,2.436,0.912,2.869,0.243c2.84,1.27,5.438,3.116,7.727,5.272c1.204,1.138,2.329,2.373,3.355,3.688 c0.275,0.36,1.402,2.411,1.963,1.272c1.89,4.133,1.951,9.141,1.689,13.642c-0.822,0.078-0.448,0.92-0.098,1.261 c-0.905,4.048-2.48,7.891-3.973,11.735c-0.176,0.444,0.202,0.872,0.615,0.812c-0.537,1.839-0.937,3.699-1.068,5.571 c-0.322,0.462-1.331,1.166-1.385,1.739c-0.058,0.661,0.643,0.769,1.02,0.439c-0.208,0.847-1.901,4.052-1.312,4.705 c-0.135,0.361-0.283,0.785,0.138,1.037c-1.86,2.291,0.404,2.268,2.017,3.381s2.693,2.914,3.32,4.787 c0.99,5.286,0.107,12.019-2.101,18.029c-0.47,0.771-4.239,5.693-3.166,6.123c-1.364,3.264-4.217,5.643-7.351,7.549 c-1.999,0.808-4.287,0.887-6.775-0.456c-0.147-0.24-0.316-0.336-0.5-0.288c-1.748-1.065-1.276-0.938-2.402,0.502 c-0.814,0.283-2.033,2.395-2.711,3.08c-1.867,1.897-4.215,3.107-6.05,5.018c-2.437,1.316-4.954,2.451-7.456,3.616 c-0.331,0.152-0.434,0.578-0.236,0.876c-5.933,2.836-12.276,4.756-18.71,5.858c-5.882,1.009-10.916,0.709-16.63-1.175 c-0.141-0.624-0.854-0.441-1.266-0.435c-5.879-2.098-11.511-4.92-15.229-10.257c-0.092-0.639,0.759-1.956,0.045-2.339 c0.093-0.78,1.011-3.245,0.708-3.93c0.21-0.673,2.469-3.304,1.439-3.595c-0.836-0.232-2.358-0.102-3.198,0.014 c-0.108-0.784-4.648,0.213-5.458,0.264c-2.632,0.176-5.148,0.401-7.789,0.394c-2.725-0.007-5.45,0.07-8.174,0.139 c-1.157,0.03-2.316,0.058-3.473,0.075c-0.69,0.009-2.4-0.312-2.957,0.164c-3.771-0.959-7.478-2.16-11.192-3.314 c-0.042-0.859-3.006-1.771-3.694-2.166c-1.275-0.734-2.492-1.576-3.641-2.514c-0.842-0.685-5.113-5.643-5.74-5.087 c-1.113-1.755-2.02-3.544-2.708-5.366C14.565,120.674,13.14,117.618,12.992,116.832z M155.688,103.691 c0.074-0.074,0.145-0.15,0.217-0.228c0.121,0.134,0.243,0.263,0.371,0.397C156.084,103.796,155.887,103.742,155.688,103.691z"/> </g> </g> </g></g></svg>';
		
		
		/**
		 * Star
		 */
		$svg['star']['colors'] = array('#000000');
		$svg['star']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['star']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 139.561 138.096" enable-background="new 0 0 139.561 138.096" xml:space="preserve"><path fill-rule="evenodd" clip-rule="evenodd" class="colorful c1" fill="'.$svg['star']['colors'][0].'" d="M137.243,42.584c-2.377,6.637-1.314,17.879-3.395,25.633 c-0.666,2.477-4.248,5.269-6.617,7.255c-2.141,1.768-4.32,3.863-6.9,4.365c-1.688,2.359-4.057,4.137-6.16,6.041 c-2.742,2.482-7.34,3.811-8.164,6.174c-0.666,1.91,1.404,7.133,2.305,9.291c1.324,3.158,2.82,5.543,4.166,8.293 c0.234,7.325-2.17,15.119-1.486,22.361c-4.271,2.715-11.334-2.82-15.982-6.211c-2.996-2.203-7.875-3.879-12.584-6.145 c-3.801-1.824-8.658-5.889-11.697-6.287c-2.869-0.379-8.4,4.405-11.127,6.01c-4.131,2.449-7.238,4.508-10.859,6.197 c-2.301,2.539-5.461,4.447-8.168,6.17c-2.65,1.688-5.48,4.043-8.625,3.541c0.266-1.594-0.895-1.607-1.52-2.208 c2.492-7.067,4.121-15.902,4.477-23.341c2.289-5.442,2.762-10.562,3.771-15.78c-7.455-3.853-16.018-10.272-22.309-11.416 c-2.893-3.088-9.879-7.316-13.145-8.07c-1.135-3.714,1.215-8.034,1.068-11.915c0.484-3.996-2.137-10.419,1.455-13.562 c0.957-0.843,8.059-1.822,10.496-1.846c8.09-0.07,18.051-3.247,26.775-4.249c2.199-0.255,4.195,0.793,6.018-0.381 c6.861-12.259,12.77-27.244,17.049-39.083c0.84,0.065,1.57-0.475,2.367-0.634c4.225,4.49,5.465,10.357,7.475,15.601 c3.104,8.069,7.342,15.438,11.742,23.2c16.062-0.177,32.422,1.357,48.287,0.095C136.386,41.984,136.813,42.285,137.243,42.584z M129.923,53.567c-0.357,4.534-0.836,9.624-0.836,13.228c2.812-5.847,2.727-13.098,3.6-19.351 C129.993,49.091,130.165,50.577,129.923,53.567z M96.446,46.588c-4.703-0.193-10.383-0.162-14.078-1.814 c-3.84-11.208-10.932-21.84-13.949-33.189c-4.232,10.662-11.947,24.968-14.156,34.961c-1.096-0.01-1.039,1.673-1.623,2.32 c-11.994,1.099-24.145,1.25-36.066,2.72c10.596,5.165,21.383,13.781,32.414,18.899c-0.141,11.223-5.047,22.589-6.725,33.656 c8.256-6.716,19.449-9.751,25.965-17.868c1.158,0.613,1.812-1.645,2.982-0.974c11.73,7.259,24.199,13.864,34.322,19.463 c-1.582-6.12-4.27-11.919-6.982-17.946c-2.6-5.734-6.123-11.857-5.672-18.174c9.379-7.29,21.223-13.201,30.822-20.974 C114.706,46.928,105.276,46.948,96.446,46.588z M122.483,54.875c-1.023,6.646-1.834,13.256-1.514,19.661 c2.258-2.448,4.664-3.503,5.393-6.582c0.908-3.886,1.457-14.079,1.094-16.887C125.847,52.594,124.151,53.648,122.483,54.875z M115.763,58.983c-1.863,7.251-0.77,13.972-0.842,20.899c0.959-1.378,2.086-1.806,3.117-2.804 c0.016-6.619,1.383-13.472,0.998-20.021C117.983,57.921,116.897,58.605,115.763,58.983z M109.013,64.232 c0.33,7.032-1.545,13.061-0.117,19.865c1.645-0.944,3.113-2.221,3.4-3.753c1.055-5.602-0.105-13.757,0.275-18.988 C111.362,62.188,110.185,63.165,109.013,64.232z M102.261,77.144c0.037,1.476,1.076,3.185,1.027,4.56 c-0.014,0.321-0.764,0.713-0.725,1.026c0.199,1.735,1.35,3.703,1.979,4.849c3.609-6.164,0.416-14.529,1.82-21.751 C102.446,68.191,102.142,72.514,102.261,77.144z M100.62,72.921c-0.721-0.854,0.531-2.05-0.285-2.881 C99.333,71.05,100.044,72.937,100.62,72.921z M104.206,124.168c0.002,0.449-0.143,0.93-0.65,1.467 c1.258,1.178,2.307,1.146,3.527,2.086c0.676-5.157-0.096-10.057,1.578-15.384c-0.605-1.247-2.08-2.341-3.75-3.403 C103.29,114.582,102.378,119.617,104.206,124.168z M99.228,106.096c-0.375,5.409-6.154,15.677,2.271,18.094 c0.021-5.411-0.09-10.809,0.732-16.362C101.149,106.785,100.263,106.871,99.228,106.096z M96.472,104.555 c-1.42-0.381-2.98-1.566-4.473-2.381c-1.559,6.117-0.844,10.481-0.998,16.195c1.211,0.473,2.48,1.268,3.783,2.266 C96.276,115.105,96.755,109.764,96.472,104.555z M89.243,100.634c-1.184,0.543-2.896-1.963-4.074-1.318 c-0.17,5.346-2.281,10.503-0.797,15.935c1.334,0.342,2.715,0.929,4.135,1.754C89.308,111.441,89.462,106.005,89.243,100.634z M78.901,95.683c-1.857,5.933-1.465,10.189-1.326,15.574c1.637,1.182,3.266,2.31,4.738,2.547c0.35-5.327,0.242-10.567,0.803-15.929 C82.05,97.465,80.532,96.226,78.901,95.683z M71.454,108.492c1.471,1.12,2.783,1.285,4.061,1.318 c-0.064-5.024-0.027-10.066,1.143-15.315c-0.854-0.598-1.713-1.203-2.57-1.804C72.124,98.148,72.856,103.137,71.454,108.492z M66.901,101.85c-0.215,3.072-0.51,6.481,0.148,8.543c4.477-4.99,2.461-12.555,3.746-18.477 C67.103,93.846,67.165,98.027,66.901,101.85z M38.001,70.836c-2.051,6.524-0.207,12.363-0.793,18.633 c0.805,0.735,1.518,0.908,2.238,1.188c1.451-5.742,0.779-11.109,2.67-16.934C41.313,72.373,39.364,71.566,38.001,70.836z M31.386,66.584c0.051,6.384-0.582,12.883-0.016,19.173c1.023-0.162,2.373,1.526,3.529,2.088 c-0.031-6.181,0.209-13.538,0.271-18.993C33.083,67.69,33.485,67.834,31.386,66.584z M24.757,81.51 c1.73,1.313,2.287,1.023,3.348,2.344c2.084-6.461,0.15-12.215,1.039-18.458c-1.367-0.963-2.74-1.926-4.107-2.884 C24.372,68.943,24.981,75.147,24.757,81.51z M19.079,74.836c0.105,3.102,0.115,3.707,3.543,4.787 c-0.164-3.568-0.379-10.268-0.27-14.381c0.082-2.811,0.771-4.8-2.904-6.267C18.296,61.718,18.929,70.658,19.079,74.836z M13.507,55.96c-0.428,6.095-0.898,12.187-1.305,18.27c1.525,0.527,3.293,2.462,4.582,1.687c-0.969-6,0.037-12.345-0.084-18.479 C15.663,57.106,14.507,56.081,13.507,55.96z M11.138,60.44c0.16-2.417-0.365-7.329-2.955-7.828 C6.722,58.66,7.063,64.383,6.552,70.269c1.58-0.932,0.246,1.287,1,1.85c-0.266,0.449,1.26,0.482,1.797,1.261 C9.304,70.183,10.87,64.569,11.138,60.44z M62.663,96.951c-0.648,5.527-1.256,11.045-0.301,16.295 c0.689-0.783,1.506-0.864,2.287-1.078c0.369-5.555,1.604-11.258,0.479-16.551C64.267,95.826,63.562,96.961,62.663,96.951z M55.937,101.072c0.98,0.348,0.529,0.95,0.488,1.484c-1.291,5.116-0.789,9.919-0.348,14.727c1.297-0.762,2.516-1.939,3.816-2.701 c0-5.338,0.291-10.728-0.324-15.955C58.46,100.013,57.157,100.3,55.937,101.072z M48.854,105.695 c1.432,5.01-0.266,10.566,0.939,15.623c1.361-0.412,2.543-1.78,3.893-2.266c-0.074-5.477-0.041-10.965,0.035-16.469 C52.069,103.421,50.474,104.643,48.854,105.695z M42.21,110.246c1.947,4.988-0.84,10.821,0.318,15.95 c1.355-1.579,3.674-1.595,4.611-3.283c0.645-1.159-0.105-2.858-0.072-4.275c0.092-3.767,0.727-9.101-0.066-11.938 C45.485,108.325,43.839,109.231,42.21,110.246z M38.476,113.379c-0.621,5.439-2.568,12.094-1.611,16.523 c3.922-1.793,2.717-5.619,3.201-10.033c0.334-3.02,0.357-5.637,0.189-7.932C39.628,112.227,39.073,112.924,38.476,113.379z"/></svg>';
		
		
		/**
		 * World Map
		 */
		$svg['world_map']['colors'] = array('#989A94');
		$svg['world_map'] = array('code' => '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['world_map']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 200 97.802" enable-background="new 0 0 200 97.802" xml:space="preserve"><path fill="#989A94" d="M9.244,24.624c-0.459-0.183-0.228,0.701-0.685,0.808c-0.458,0.109-1.005,0.378-0.639,0.487 c0.365,0.107,1.187-0.054,1.279-0.217C9.29,25.541,9.383,24.677,9.244,24.624"/><path class="colorful c1" fill="'.$svg['world_map']['colors'][0].'" d="M5.727,25.81c-0.548-0.053-1.097,0-1.188,0.216c-0.092,0.217,0.503,0.379,0.869,0.379 c0.365,0,1.096-0.271,0.958-0.324C6.229,26.026,5.727,25.81,5.727,25.81"/><path fill="#989A94" d="M9.382,20.952c-0.366,0-0.183,0-0.64,0.162c-0.186,0.066,0.32,0.432,0.501,0.432 C9.427,21.546,9.747,20.952,9.382,20.952"/><path fill="#989A94" d="M79.374,62.3c-0.318-0.161-1.004-0.214-1.279-0.647c-0.273-0.433-1.05-0.863-1.324-0.756 c-0.274,0.106-0.731,0.215-1.095-0.054c-0.367-0.27-0.959-0.595-1.188-0.81c-0.23-0.215-0.822-0.378-1.097-0.378 c-0.275,0-0.229-0.216-0.639,0.433c-0.411,0.646,0,0.863-0.731,0.755c-0.731-0.108,0.09-0.163,0.502-0.81 c0.411-0.648-0.046-1.025-0.502-0.863c-0.457,0.162-0.138,0.485-0.869,0.648c-0.73,0.161-0.73-0.379-0.274-0.486 c0.457-0.109,1.279-0.595,1.279-0.811s-0.09-0.809-0.457-0.809c-0.365,0-0.274-0.541-0.822-1.243c-0.548-0.7-1.331-1.497-1.88-1.388 c-0.546,0.107-0.86,0.632-1.134,0.04c-0.274-0.596-0.594-0.702-0.778-1.026c-0.183-0.324-0.64,0-0.776-0.162l-0.138-0.162 c0,0-0.593,0.162-0.274-0.324c0.321-0.486,0.457-1.404,0.321-1.35c-0.137,0.055-0.366,0.81-0.595,0.756 c-0.228-0.054-0.045-0.163-0.501-0.486c-0.458-0.324-1.188-0.053-1.188,0.217s-0.229,0.485-0.229,0.485s-0.137-0.162-0.274-0.485 c-0.136-0.324-0.776-0.378-1.096-0.055c-0.319,0.324-0.503-0.811-0.73-0.811c-0.23,0-0.687,0.271-0.915,0.757 s-0.137,1.188-0.32,1.134c-0.182-0.055-0.228-0.972-0.182-1.295c0.045-0.324,0.548-0.864,0.182-0.971 c-0.365-0.109-0.915,0.539-1.142,0.592c-0.229,0.055-0.686,0.432-0.961,0.864c-0.273,0.433-0.411,0.702-0.684,0.863 c-0.274,0.163-0.686,0-0.594-0.161c0.092-0.162-0.775-0.756-0.914-0.541c-0.137,0.217-0.548,0.379-0.959,0.594 c-0.411,0.217-0.775-0.27-0.868-0.485c-0.09-0.216-0.274-0.27-0.319-0.972c-0.045-0.703,0.091-1.457,0.229-1.889 c0.136-0.434-0.686-1.295-1.005-1.243c-0.32,0.055-0.641,0.434-0.959,0.378c-0.319-0.053-0.183-0.163-0.686-0.163 c-0.502,0-0.091-0.107,0-0.592c0.091-0.486-0.183-1.134,0.32-1.567c0.503-0.431,0.32-1.457,0-1.51 c-0.32-0.053-0.914,0.163-1.324,0.108c-0.412-0.055-0.731,0.378-0.595,0.863s-0.229,0.81-0.365,0.756 c-0.137-0.054-0.319-0.324-0.823,0.107c-0.502,0.433-0.685,0.271-1.188-0.216c-0.502-0.485-1.051-0.971-1.143-1.728 c-0.091-0.755-0.137-1.511,0.046-1.943c0.183-0.431,0.183-1.187-0.092-1.295c-0.273-0.107,0.319-0.646,0.639-0.755 c0.32-0.108,0.823-0.594,0.915-0.81c0.091-0.216,0.548-0.162,1.05-0.162c0.502,0,0.594,0,1.096,0.324 c0.503,0.323,0.594-0.163,0.594-0.324s0.283-0.278,0.831-0.224c0.548,0.053,1.225-0.423,1.363-0.262 c0.137,0.163,0.41,0.81,0.685,0.593c0.274-0.214,0.366-0.593,0.456,0.055c0.093,0.648,0.32,1.621,0.732,1.783 c0.411,0.162,0.183,0.809,0.594,0.863c0.412,0.052,0.594-1.025,0.457-1.404c-0.137-0.378-0.411-1.511-0.64-1.782 c-0.228-0.269,0.155-0.94,0.613-1.156c0.456-0.216,1.169-1.325,1.49-1.649c0.32-0.323,1.365-0.417,1.091-0.849 c-0.275-0.432-0.543-0.879-0.543-1.203c0-0.325,0.274-0.215,0.411,0s0.685-0.325,0.549-0.593c-0.138-0.27-0.092-0.647,0.228-0.594 c0.321,0.053,0.411-0.271,0.274-0.486c-0.137-0.217,0.319-0.486,0.639-0.379c0.321,0.109,1.376,0.195,1.513-0.021 c0.137-0.216-0.507-0.68-0.507-1.111c0-0.431,0.548-0.81,0.868-0.864c0.319-0.053,0.731,0,0.777-0.162s0.502-0.594,0.548-0.215 c0.045,0.377,0,1.024,0.365,1.024c0.367,0,0.823-0.485,0.959-0.539c0.137-0.054,1.005-0.271,1.188-0.324 c0.183-0.053,1.279-0.162,1.142-0.541c-0.138-0.378-0.275-0.755-0.412-0.917c-0.138-0.161-0.275,0.054-0.457,0.324 c-0.182,0.27-0.503,0.27-0.594,0.054c-0.092-0.215,0.044-0.863-0.275-0.648c-0.319,0.216-0.365,0.433-0.549,0.325 c-0.182-0.109-0.364-0.487-0.364-0.487s0.456-0.27,0.137-0.754c-0.319-0.486-0.777-0.379-1.235-0.108 c-0.455,0.27-0.409,0.215-0.957,0.377c-0.549,0.162-0.823,0.323-0.823,0.323s0.153-0.839,0.474-1.164 c0.32-0.323,1.306-0.184,1.581-0.509c0.274-0.323,1.005,0.162,1.005,0.162s0.365-0.432,0.365-0.162c0,0.27-0.092,0.973,0.184,0.973 c0.274,0,1.05-0.433,0.731-0.541c-0.32-0.107,0.197-0.308,0.517-0.579c0.32-0.269,0.944,0.039,1.128-0.069 c0.182-0.108,0.318-0.593,0.639-0.593c0.32,0,0.457,0.485,0,0.809c-0.457,0.325-0.503,1.135-0.731,1.35 c-0.228,0.216-0.091,0.485,0.274,0.433c0.367-0.055,0.686,0.053,1.005-0.055c0.321-0.107,0.503,0.107,0.594,0.269 c0.091,0.162,0.366-0.162,0.366-0.162s0.595-0.162,0.777,0.109c0.184,0.269,0.32-0.162,0.184-0.433 c-0.138-0.27-0.32-0.539-0.458-0.863c-0.137-0.324-0.319-0.433-0.685-0.324c-0.366,0.107-0.456-0.109-0.685-0.271 c-0.229-0.161-0.411,0.217-0.229-0.161c0.183-0.377,0.273-0.486,0.411-0.811c0.137-0.323,0.731-0.916,0.137-1.078 s-0.776-0.271-0.868-0.594c-0.091-0.325-0.777-0.919-0.959-0.919c-0.182,0-1.058,0.192-1.104-0.078 c-0.046-0.271-0.266-1.055-0.495-1.325c-0.227-0.271-1.096-1.458-1.234-1.566c-0.137-0.108-0.318-0.055-0.73,0.593 c-0.413,0.649-0.776,0.757-1.097,0.595c-0.32-0.161-0.671,0.005-0.99-0.426c-0.321-0.432,0.624-0.6,0.488-0.87 c-0.139-0.269-0.869-0.379-1.325-0.431c-0.457-0.055-0.777-0.647-1.462-0.702c-0.686-0.055-1.508,0.107-1.737,0.107 c-0.228,0-0.228,0.378-0.318,0.972c-0.093,0.593,0.318,0.755-0.093,0.864c-0.41,0.108-0.593,0.162-0.181,0.378 c0.411,0.216,0.959,1.08,0.959,1.08s0,0.485-0.32,0.756c-0.32,0.27-0.639,0.539-0.823,0.216c-0.182-0.325-0.685-0.27-0.548,0.054 c0.137,0.324,0.412,0.486,0.412,0.81c0,0.325,0.412,1.134,0.137,1.403c-0.273,0.271-0.594,0.054-0.822,0.109 c-0.229,0.052-0.457-0.433-0.275-0.541c0.183-0.107-0.044-0.918-0.044-0.918s-0.548,0.918-0.503,0.433 c0.046-0.487-0.228-0.54-0.228-0.918c0-0.378-0.398-0.903-0.81-0.795c-0.412,0.109-0.789,0.201-1.566,0.039 c-0.777-0.162-1.096-0.269-1.735-0.647c-0.64-0.378-0.868-0.107-1.189-0.054c-0.32,0.054-0.183-0.754-0.594-0.863 c-0.411-0.109-0.149-0.23-0.24-0.931c-0.091-0.702-0.354-0.527,0.651-1.284c1.006-0.754,0.868-1.079,1.645-1.186 c0.778-0.108,1.063,0.486,1.063,0.217c0-0.271,0.263-1.729,0.263-1.189c0,0.54,0.913,0.594,0.501,0.972 c-0.41,0.377-0.182,0.432,0.138,0.432c0.318,0,0.914-0.379,0.914-0.379s0.729-0.378,0.913-0.053 c0.183,0.323,0.183,0.648,0.502,0.648s1.005-0.433,0.412-0.811c-0.594-0.379-0.96-0.324-1.325-0.756 c-0.366-0.432-0.274-0.271-0.686-0.163c-0.412,0.108-0.412-0.163-0.549-0.163s-0.364,0.109-0.456-0.107 c-0.092-0.216,0.045-0.269,0.503-0.269c0.457,0,1.004,0.161,1.004,0.161s0.549-0.216,0.687-0.271 c0.138-0.053,0.867-0.163,0.73-0.648c-0.137-0.485-0.592-0.485-0.73-0.647c-0.138-0.163,0.274-0.378,0.501-0.486 c0.229-0.108,0.869,0,0.869,0s0.411,0.053,0.411-0.162c0-0.216-0.091-0.486,0.183-0.325c0.274,0.162,0,0.648,0.412,0.541 c0.41-0.107,0.503,0,0.73,0.162c0.229,0.162-0.046,0.811-0.274,0.917c-0.229,0.108-0.594,0.324-0.09,0.379 c0.502,0.054,0.866,0.054,0.866,0.054s0.321-0.379,0.458-0.703c0.136-0.324,0.365-0.107,0.549,0c0.181,0.108,0.868,0.27,0.228,0.487 c-0.64,0.216-0.776,0.485-0.914,0.754c-0.137,0.271-0.183,0.433-0.776,0.271c-0.594-0.162-0.915-0.109-1.051,0.162 c-0.138,0.27-0.046,1.134,0.183,1.025c0.227-0.108,0.457-0.108,0.731-0.215c0.273-0.109,1.369,0.107,1.643,0.054 c0.275-0.054,0.73,0.54,0.87,0.431c0.136-0.108,0.411,0.216,0.685,0.432c0.274,0.217,0.182-0.485,0.685-0.055 c0.502,0.433,0.229,0.433,0.502,0.433c0.275,0,0.87,0.052,0.87,0.052s0.043-0.538,0.501-0.431c0.458,0.107,0.868,0.702,0.823,0.27 c-0.046-0.431,0.045-0.755-0.319-1.08c-0.367-0.323-0.961-0.541-1.051-0.701c-0.091-0.162-0.183-0.378-0.047-0.487 c0.137-0.107,0.778,0.055,1.143,0.325c0.367,0.269,0.686,0.54,0.96,0.323c0.275-0.214,0.595-0.323,0.732-0.485 c0.136-0.163,0.456-0.647,0.456-0.647s-1.371-0.215-1.552-0.485c-0.184-0.27-0.823-0.648-1.007-0.648 c-0.182,0-0.685,0.378-0.867-0.162s-0.183-1.188-0.366-1.242c-0.182-0.055-2.102-0.378-2.376-0.54 c-0.273-0.162-1.371-0.54-1.782-0.81s-1.005-0.648-1.371-0.648s-1.873,0.216-2.147,0.162c-0.275-0.053-1.097,0.109-1.417,0.162 c-0.32,0.055,0.413,0.757-0.273,0.92c-0.686,0.162-0.595,0.268-0.458-0.542c0.137-0.809-0.457-1.025-1.051-0.702 c-0.594,0.324-1.553,0.541-1.324,0.918c0.229,0.377-0.046,0.648,0.411,1.025c0.457,0.378,0.64,0.485,1.233,0.433 c0.593-0.055,1.188,0.107,1.188,0.107s0,0.648-0.228,0.756c-0.229,0.108-0.595,0.108-0.687,0.432 c-0.09,0.323-0.548,0.486-0.548,0.323c0-0.162,0.229-0.702-0.091-0.972c-0.319-0.27-0.411-0.324-0.777-0.054 c-0.366,0.271-0.41,0.378-0.594-0.054c-0.182-0.432-0.731-0.81-0.731-0.81s-0.365-0.539-0.639-0.81 c-0.274-0.27-0.776-0.215-0.823,0.055c-0.045,0.27,0.092,0.54,0.273,1.025c0.184,0.486,0.265,1.102-0.056,1.155 c-0.32,0.054-0.263,0.41-0.583,0.519c-0.32,0.108-0.456-0.163-0.456-0.594c0-0.432-0.137-0.81-0.047-0.972 c0.092-0.162-0.364,0.108-0.823,0c-0.457-0.107-0.821,0.216-0.365,0.378c0.458,0.162,0.549,0.81,0.137,0.972 c-0.41,0.162-1.963,0-2.466,0c-0.501,0-1.233,0.162-1.37-0.162c-0.137-0.324,0.411-0.541,0.731-0.541s1.279,0.053,1.644-0.54 c0.366-0.594-0.456-0.702-0.822-0.702c-0.364,0-0.64-0.162-1.05-0.646c-0.412-0.486,0.273-0.811,0.182-1.027 c-0.091-0.216-0.548-0.055-0.958-0.055c-0.412,0-1.051-0.376-1.051,0.055c0,0.432,0.502,1.674,0.184,1.404 c-0.32-0.27-0.276-0.647-0.503-0.972c-0.23-0.325-0.595-0.27-1.052-0.216c-0.456,0.054-1.232,0.216-1.461,0.163 c-0.229-0.055-0.046-0.055-0.548-0.325c-0.503-0.271-0.731-0.216-1.097-0.485c-0.366-0.271-0.046-0.378-0.687-0.434 c-0.638-0.052-0.593,0.379-1.232,0.271c-0.64-0.109-0.823,0.054-1.462,0c-0.641-0.055-0.96-0.109-1.051,0.27 c-0.091,0.378-0.274,1.026-0.547,1.026c-0.274,0-0.595,0.377,0.273,0.432s0.365,0.54,1.142,0.485 c0.777-0.055,1.461-0.055,1.645-0.485c0.184-0.432,0.32-0.432,0.411-0.27c0.092,0.163,0.776,1.133,0.776,1.133 s0.457,0.432,0.64,0.54c0.183,0.108-0.183,0.594-0.547,0.323c-0.366-0.27-1.052-0.215-1.325-0.485 c-0.275-0.271-1.012-0.385-1.332-0.331c-0.32,0.052-1.365-0.047-1.547-0.047c-0.183,0-0.777,0.54-0.777,0.54 s-0.229-0.433-0.365-0.648c-0.137-0.215-0.366,0.216-0.548,0.271c-0.183,0.053-0.731-0.433-1.28-0.217 c-0.548,0.217-0.365,0.433-1.142,0.378c-0.777-0.054-0.96-0.216-1.233-0.162l-0.274,0.053c0,0,0.045,0.217-0.275,0.433 c-0.32,0.215-0.548,0.486-0.776,0.162c-0.229-0.324-0.366-0.324-0.502-0.378c-0.138-0.054-0.411-0.324-1.006-0.162 c-0.594,0.162-1.232-0.796-1.416-0.796c-0.182,0-2.102,0.472-2.467,0.365c-0.366-0.109-1.425-0.583-1.792-0.528 c-0.364,0.055-1.105,0.164-1.105,0.164s-0.758-0.176-0.895-0.176c-0.137,0-0.64,0.27-0.869,0c-0.228-0.268-0.639-0.431-0.639-0.431 s-0.183,0.593-0.503,0.701c-0.319,0.109-1.003,0.324-1.142,0.217c-0.136-0.108-1.324,0.431-1.324,0.431s-0.67,0.174-0.853,0.119 c-0.184-0.053-0.975,0.368-0.883,0.584c0.091,0.216,0,0.648,0.731,0.648c0.73,0,0.776,0.324,1.051,0.378 c0.273,0.053,0.365,0,0.685,0.324c0.32,0.323,0.32,0.647-0.092,0.592c-0.411-0.055-0.868-0.162-1.142-0.43l-0.274-0.272 l-0.502,0.272c-0.639,0.053-1.462,0.43-1.462,0.43s0.229,0.486,0.64,0.811c0.41,0.323,1.416,0.323,1.416,0.323 s0.686,0.055,0.96-0.217c0.273-0.27,0.593-0.215,0.777-0.161c0.182,0.055-0.137,0.756-0.64,0.703 c-0.503-0.055-1.097,0.053-1.508,0.431c-0.411,0.378-0.778,0.433-0.595,0.864c0.184,0.432,0.868,0.972,0.915,1.242 c0.047,0.27,0.823-0.162,0.914-0.432c0.091-0.271,0.548-0.271,0.411,0.324c-0.137,0.593,0.457,0.702,0.457,0.702 s0.275-0.541,0.412-0.432c0.137,0.107,0.594,0.595,0.594,0.595s0.594-0.487,0.776-0.163c0.183,0.324-0.273,0.593-0.549,0.755 c-0.273,0.162-1.278,0.594-1.507,0.755c-0.229,0.162-1.097,0.648-1.324,0.648c-0.23,0-0.32,0.647,0.09,0.594 c0.411-0.053,1.554-0.541,1.874-0.702c0.319-0.162,0.435,0.535,1.257,0.048c0.824-0.485,1.073-1.236,1.302-1.182 c0.227,0.054,0.273,0.432,0.64,0.54c0.365,0.107,0.685-0.323,0.913-0.485c0.229-0.161,0.411-0.809,0.183-0.756 c-0.229,0.055-0.822,0-0.822,0s0.639-0.431,0.639-0.701c0-0.271,0.091-0.704,0.458-0.865c0.364-0.162,0.364-0.054,0.136,0.595 c-0.229,0.646,0.458,0.377,0.731,0.107c0.274-0.27,0.601,0.465,1.104,0.086c0.503-0.377,0.358-1.112,0.632-1.112 c0.274,0,0.776,0.594,1.051,0.378c0.275-0.216,0.974,0.447,1.43,0.447s1.996,0.525,2.271,0.525c0.273,0,1.096,0.378,1.142,1.08 c0.046,0.701,0.32,0.647,0.593,0.647c0.275,0,0.915,0.271,0.915,0.541c0,0.269-0.182,1.35,0.275,1.62 c0.457,0.27,0.868,0.702,1.051,0.593c0.183-0.108,0-0.972-0.229-1.079c-0.229-0.108-0.091-0.486-0.182-0.703 c-0.092-0.216,0.274-0.216,0.411,0.162c0.137,0.378,0.502,1.081,0.73,1.081c0.229,0,0.731,0.647,0.595,1.024 c-0.137,0.378,0.046,1.144,0.456,1.144c0.411,0,1.006,0.531,1.188,0.584c0.182,0.053,0.287,0.523,0.287,0.685 c0,0.162,0.353,0.88,0.353,1.258c0,0.377-0.137,1.888-0.183,2.481c-0.046,0.596,0.365,1.62,0.823,2.16 c0.456,0.54,0.371,1.748,0.646,1.964c0.273,0.217,0.954,0.627,1.364,0.572c0.411-0.052,0.685,0.324,1.051,1.081 c0.365,0.756,0.731,1.996,1.005,2.106c0.273,0.107,0.73,0.485,0.501,0.755c-0.228,0.27-0.593,0.864-0.182,0.864 s0.548-0.27,0.868,0.215c0.32,0.486,0.732,0.757,0.686,1.081c-0.047,0.323,0.365,0.431,0.547,0.485 c0.184,0.054,0.594,1.027,1.005,0.594c0.412-0.432-0.548-1.079-0.822-1.351c-0.274-0.269,0-0.861-0.64-1.457 c-0.638-0.593-0.548-1.025-1.005-1.458c-0.457-0.432-0.822-0.81-0.364-1.187c0.457-0.378,0.502,0.377,0.685,0.863 c0.183,0.485,1.141,1.459,1.552,1.891c0.412,0.432,1.143,1.942,1.372,1.942c0.228,0,0.868,0.864,0.868,0.864 s0.364,0.703,0.228,0.918c-0.137,0.214,0.183,1.024,0.503,1.241c0.32,0.216,1.713,0.221,1.782,1.026 c0.018,0.21,0.248,1.242,0.75,1.242c0.502,0,1.168-0.271,1.305-0.109c0.137,0.162,0.549,0.81,0.822,0.431 c0.275-0.377,0.32-0.54,0.731-0.54c0.411,0,0.594,0.378,0.822,0.648c0.229,0.271,0.869,0.973,1.188,0.919 c0.321-0.055,0.731,0.432,0.959,0.27c0.229-0.162,0.594,0.107,0.776,0.217c0.183,0.106,0.567,0.508,0.522,1.154 c-0.047,0.647,0.62,0.787,0.894,0.95c0.275,0.161,0.641,0.539,0.869,0.81c0.229,0.27,0.731,0.324,0.869,0.486 c0.136,0.16,0.227,0.485,0.638,0.217c0.411-0.271,0.32-0.758,0.32-0.758s0.458-0.107,0.686,0.109 c0.229,0.215,0.365,0.917,0.503,1.023c0.137,0.11,0.41,0.918,0.227,1.513c-0.183,0.593-0.136,1.188-0.32,1.188 c-0.181,0-0.685,0.565-0.958,0.727c-0.274,0.162-0.732,1.054-0.686,1.323c0.045,0.271,0.204,1.126,0.112,1.503 c-0.091,0.379-0.431,0.764-0.295,1.359c0.137,0.594,1.097,0.755,1.143,1.295c0.047,0.539,0.731,1.729,0.822,2.268 c0.092,0.539,0.583,1.162,0.583,1.918c0,0.757,1.382,1.211,1.61,1.267c0.229,0.052,0.641,0.539,0.96,0.7 c0.32,0.162,0.594,0.486,0.822,0.92c0.229,0.432,0.183,1.078,0.183,1.242c0,0.16-0.137,1.834-0.274,2.807 c-0.137,0.97,0.331,1.887,0.057,2.158c-0.275,0.27-0.788,0.377-0.514,0.701s-0.32,0.541-0.32,0.702c0,0.162,0.366,1.024,0.183,1.403 s-0.32,0.917-0.457,1.24c-0.137,0.324-0.458,0.65-0.367,1.135c0.092,0.486-0.365,0.324-0.365,0.809c0,0.488,0.411,0.271,0.32,0.863 c-0.092,0.597-0.32,0.759-0.32,1.189c0,0.432,0.228,1.025,0.228,1.188c0,0.16-0.228,0.7-0.548,1.135 c-0.32,0.431-0.548,0.699-0.503,0.971c0.046,0.269,0.367,0.593,0.321,0.756c-0.046,0.16-0.457,0.7-0.411,1.078 c0.045,0.379,0.457,0.217,0.549,0.486c0.091,0.27-0.549,0.486-0.275,0.756c0.275,0.27,0.64,0.215,0.549,0.863 c-0.092,0.648,0.502,0.81,0.639,0.971c0.136,0.164,0.41,0.541,0.64,0.541c0.228,0,0.411-0.161,0.502-0.755 c0.092-0.595,0.73-0.108,0.274,0.323c-0.457,0.432-0.685,0.646-0.548,0.646c0.136,0,0.823,0.434,1.188,0.434 c0.364,0,1.097-0.217,1.234-0.27c0.137-0.056,1.142-0.217,1.232-0.379c0.092-0.161-0.776-0.107-1.189-0.271 c-0.409-0.16-1.141-0.97-1.232-1.293c-0.092-0.324-0.092-0.973,0.228-1.189c0.32-0.216,1.097-0.969,1.279-1.133 c0.183-0.161,0.457-0.918,0.319-1.025c-0.137-0.108-0.822,0-0.913-0.161c-0.091-0.163-0.091-0.378,0.365-0.758 c0.457-0.377,0.685-0.915,0.869-1.079c0.183-0.16,0.547-0.486,0.686-0.863c0.137-0.377-0.139-0.162-0.413-0.162 s-0.41-0.592-0.41-0.864c0-0.269,0.684,0.109,1.187,0.217c0.502,0.106,0.275-0.269,0.228-0.592 c-0.044-0.325,0.092-0.864,0.367-0.702c0.273,0.16,1.689-0.057,1.873-0.109c0.183-0.053,0.685-1.026,0.867-1.295 c0.183-0.27,0.228-0.541,0-0.703c-0.228-0.161-0.864-0.791-0.955-0.953c-0.09-0.163,0.224-1.099,0.315-1.367 c0.093-0.27,0,1.564,0.639,1.781s1.005,0.322,1.6-0.324c0.593-0.648,1.051-1.079,1.096-1.512c0.045-0.432,0.183-0.862,0.411-1.024 c0.229-0.161,0.416-0.047,0.69-0.748c0.273-0.701,0.498-0.171,0.771-0.763c0.273-0.595-0.456-1.352,0.092-1.781 c0.548-0.434,1.507-0.973,1.507-0.973s0.276-0.162,0.824-0.324s1.141-0.055,1.325-0.379c0.182-0.324,0.364-1.023,0.639-1.4 c0.274-0.38,0.594-0.975,0.457-1.242c-0.138-0.271,0.365-1.459,0.32-1.781c-0.046-0.325-0.458-1.081,0.228-1.729 c0.687-0.647,1.418-1.62,1.461-1.889c0.047-0.271,0.595-1.404,0.548-1.943C80.197,63.109,79.693,62.463,79.374,62.3 M56.805,30.723 c0.138,0.107,1.097-0.163,1.28,0.107c0.181,0.271-0.183,0.324-0.641,0.541c-0.457,0.216-0.594,0.162-0.775,0.431 c-0.184,0.271-0.777,0.378-1.051,0.702c-0.274,0.324-0.763,0.517-0.868,0.27c-0.137-0.323,0.046-0.161,0.091-0.323 c0.046-0.162,0.869-0.54,0.869-0.54S56.669,30.615,56.805,30.723 M54.339,29.481c0.137-0.055,0.775-0.055,1.095,0 c0.32,0.054,0.778,1.025,0.549,1.08c-0.229,0.054-0.595-0.215-0.595-0.594c0-0.378-0.319,0.702-0.137,1.026 c0.183,0.324-0.365,0.702-0.548,0.702s-0.321-0.486-0.274-0.971c0.046-0.487-0.274-0.918-0.776-0.865 c-0.502,0.055-0.732,0.54-0.914,0.702c-0.183,0.163-0.183,1.079-0.138,1.295c0.046,0.217,0.046,0.977-0.41,0.917 c-0.412-0.053-0.319-0.972-0.275-1.296c0.046-0.323-0.137-1.132,0.046-1.564c0.182-0.432,0.73-0.593,1.095-0.649 C53.424,29.21,54.202,29.535,54.339,29.481 M50.774,28.023c0.595-0.27,1.235-1.025,1.508-0.701c0.274,0.323,0.776,0.701,1.096,0.754 c0.321,0.056-0.09,0.702-0.227,0.757c-0.138,0.053-0.641-0.108-1.051-0.108c-0.412,0-0.32-0.324-0.503-0.27 c-0.183,0.055-0.593,0.162-0.868,0.323c-0.274,0.162-0.731,0.129-0.731-0.161C49.998,28.186,50.181,28.294,50.774,28.023 M32.774,28.941c-0.229,0.055-0.366-0.593-0.41-0.864c-0.047-0.269-0.504-0.269-0.733-0.431c-0.229-0.162-0.738-0.957-0.365-0.81 c0.137,0.055,0.412,0.378,0.548,0.378c0.136,0,0.823,0.649,1.005,0.863C33.002,28.294,33.002,28.886,32.774,28.941"/><path fill="#989A94" d="M53.835,19.423c-0.125,0.162,0.548,0.396,0.67,0.179C54.627,19.387,54.14,19.026,53.835,19.423"/><path fill="#989A94" d="M55.603,19.746c-0.485,0.164-0.032,0.576,0.274,0.432C56.181,20.034,56.028,19.602,55.603,19.746"/><path fill="#989A94" d="M33.55,11.181c0.396,0,1.037,0,1.219-0.108c0.183-0.106,1.096-0.358,1.066-0.035 c-0.031,0.325,0.365,0.828,0.578,0.755c0.215-0.073,0.64-0.539,0.854-0.359c0.213,0.18,0.245,0.611,0.456,0.72 c0.214,0.107,0.793,0.107,1.066,0c0.274-0.108,1.037-0.108,1.372-0.036c0.334,0.073,1.309,0.288,1.401,0.073 c0.09-0.216,0.365-0.252,0.396-0.47c0.03-0.216,0.182-0.899,0.182-0.899s-0.182-0.395-0.487-0.215 c-0.303,0.18-0.396,0.289-0.669,0.215c-0.274-0.071-0.274-0.648-0.762-0.539c-0.487,0.107-0.578,0.432-0.729,0.575 c-0.153,0.145-0.488,0.251-0.609,0.18c-0.123-0.071-0.823-0.54-0.823-0.54s-1.462-0.071-1.523-0.288 c-0.061-0.215-0.305-0.574-0.975-0.502c-0.67,0.071-1.828,0.541-2.011,0.541c-0.182,0,0.214,0.43-0.03,0.43 c-0.245,0-0.548-0.036-0.64,0.289C32.819,11.185,33.153,11.181,33.55,11.181"/><path fill="#989A94" d="M38.028,10.031c0.243,0,0.854-0.252,1.035-0.073c0.183,0.18,0.64,0.037,0.609-0.144 c-0.029-0.179,0.183-0.901-0.181-0.936c-0.367-0.036-0.884,0.396-1.432,0.612C37.706,9.629,37.784,10.031,38.028,10.031"/><path fill="#989A94" d="M42.779,9.491c0.366,0,1.158-0.217,1.219-0.037c0.062,0.182-0.03,0.325,0.396,0.396 c0.428,0.073,0.609,0.145,0.854,0.145c0.244,0,0.151-0.469-0.062-0.792c-0.212-0.324-0.152-0.287-0.7-0.468 c-0.548-0.18-1.097-0.18-1.461-0.145c-0.366,0.037-0.763-0.071-0.853,0.433C42.123,9.279,42.414,9.491,42.779,9.491"/><path fill="#989A94" d="M42.779,10.678c-0.23,0.237,0,0.97-0.091,1.042c-0.09,0.073,0.03,0.396,0.276,0.324 c0.243-0.072,0.364-0.755,0.546-0.755c0.184,0,1.127-0.252,1.279,0.144c0.153,0.395,0.153,0.214,0.58,0.252 c0.425,0.035,0.761-0.503,0.791-0.684c0.03-0.181-0.212-0.541-0.791-0.468C44.789,10.606,43.023,10.427,42.779,10.678"/><path fill="#989A94" d="M45.094,12.514c-0.214,0.108-0.853-0.181-1.188,0.072c-0.211,0.159-0.092,0.684,0.245,0.718 c0.334,0.038,0.913-0.251,0.973-0.035c0.062,0.216,0.274,1.188,0.823,0.863c0.548-0.323,0.519-0.612,0.671-0.647 c0.151-0.037-0.032-0.829-0.274-1.009C46.1,12.297,45.308,12.405,45.094,12.514"/><path fill="#989A94" d="M48.019,13.125c0.396-0.072,0.973-0.145,1.248-0.179c0.274-0.036,0.335-0.578,0.03-0.612 c-0.305-0.036-0.547-0.36-0.821-0.251c-0.274,0.107-1.219,0.574-1.128,0.828C47.383,13.008,47.622,13.196,48.019,13.125"/><path fill="#989A94" d="M48.323,11.542c-0.153-0.432-0.915-0.575-1.067-0.144C47.123,11.775,48.476,11.974,48.323,11.542"/><path fill="#989A94" d="M46.618,9.887c0.335,0.179,0.882,0.503,1.278,0.684c0.396,0.18,1.157,0.215,1.401,0.576 c0.244,0.359,1.066,0.647,1.066,0.647l0.975,0.108c0,0,0.67-0.181,1.37-0.108c0.701,0.072,1.736,0.18,2.315,0.144 c0.58-0.036,0.669-0.251,0.731-0.396c0.062-0.145-1.066-0.433-1.34-0.396c-0.275,0.035-1.829,0.035-2.285,0 c-0.458-0.037-1.035-0.037-1.401,0c-0.365,0.035-0.639-0.287-0.914-0.468c-0.274-0.18-0.883-0.755-1.249-0.829 c-0.365-0.071-0.304-0.071-1.066-0.288c-0.386-0.11-1.035-0.251-1.035-0.36C46.465,9.095,46.282,9.707,46.618,9.887"/><path fill="#989A94" d="M90.558,17.516c-0.243-0.253-0.821-0.434-1.097-0.47c-0.274-0.036-0.548,0.253-1.157,0.253 c-0.608,0-1.005,0.287-1.25,0c-0.243-0.289-1.249-0.432-1.34-0.253c-0.121,0.241-0.364,0.253-0.121,0.757 c0.243,0.502,0.427,0.791,0.64,0.755c0.213-0.036,0.944-0.072,1.037,0.216c0.09,0.289,0.334,0.541,0.852,0.359 c0.518-0.179,0.943-0.287,1.065-0.503s0.946-0.251,0.946-0.251S90.802,17.767,90.558,17.516"/><path fill="#989A94" d="M84.271,13.233c-0.112-0.252-0.378-1.043,0.208-1.116c0.585-0.072,1.686,0.755,1.657,0.18 c-0.027-0.577,0-1.188,0.168-1.512c0.168-0.324,0.53-0.54,0.335-0.647c-0.196-0.106-0.447,0.145-0.642-0.396 c-0.194-0.541,0.168-0.936,0.389-1.152c0.224-0.215,1.393-1.619,2.035-1.835c0.639-0.216,1.086-1.044,0.639-1.223 c-0.444-0.18-1.336-0.504-1.919,0.071c-0.586,0.577-0.919,1.115-1.587,0.936c-0.668-0.18-0.771-1.133-1.15-1.624 c-0.551-0.712-0.215-2.118-0.8-2.01l-0.586,0.108c0,0-0.685-0.145-1.107-0.037c-0.558,0.141-0.918,0.536-1.237,0.451 c-0.623-0.167-1.184,0.218-1.341,0.259c-1.365,0.353-2.462-0.129-2.662-0.164c-0.158-0.027,0.955,0.152,1.816,0 c0.663-0.117,1.778-0.384,2.324-0.491c0.547-0.107,0.107-0.364-0.086-0.39c-0.706-0.092-1.774-0.434-2.619-0.484 c-0.664-0.04-1.09,0.199-1.753,0.218C75.505,2.4,74.494,2.341,73.83,2.824c-0.584,0.425-1.334,0.471-1.395,0.548 c-0.333,0.432-0.64,1.512-0.945,1.224c-0.307-0.288-0.363-1.007-0.751-0.72c-0.391,0.288-0.029,1.008-0.363,1.511 c-0.334,0.504-1.281,0.432-1.559,0.253c-0.278-0.179-0.556-0.324-1.671-0.253c-1.114,0.074-2.339,0.504-2.089,0.936 c0.251,0.432-0.501,0.683-0.696,0.469c-0.195-0.216-1.087,0.251-1.03,0.683c0.056,0.431-0.14,0.936-0.612,0.827 c-0.476-0.108-0.809,0.252-0.836,0.612c-0.028,0.36-1.087,0.612-1.169,0.612c-0.086,0-1.449-0.035-0.948,0.396 c0.334,0.288,0.529,0.109,0.948,0.216c0.417,0.107,0.751,0.9,0.975,1.008c0.222,0.108,0.528,0,0.667-0.217 c0.139-0.215,0.334-0.971,0.334-0.971s0,0.719,0.334,0.863c0.333,0.145,1.169-0.107,1.393-0.071 c0.223,0.035,1.532,0.251,1.893,0.467c0.363,0.217,1.253,0.36,1.504,0.828c0.25,0.468,0.278,2.087,0.417,2.267 c0.14,0.181,0.612-0.576,0.725-0.754c0.111-0.182,0.697-0.073,0.891,0.178c0.195,0.253,0.64,0.865,0.612,1.117 c-0.028,0.251-0.111,0.647-0.279,0.503c-0.166-0.145-0.445-0.108-0.333-0.396c0.112-0.288,0.166-0.899-0.055-0.899h-0.418 c0,0-0.417-0.145-0.695,0.396c-0.279,0.54-0.057,1.08,0.139,1.08c0.194,0,0.64,0,0.64,0.142c0,0.146-0.474,0.577-0.446,0.829 c0.029,0.253,0.391,1.116,0.502,1.296c0.11,0.179,0.696,0.36,0.863,0.396c0.167,0.036-0.39,0.071-0.251,0.324 c0.141,0.252,0.363,0.863,0.669,1.007c0.306,0.146,1.169,0.792,1.28,1.081c0.112,0.287,0.781-0.215,0.921-0.252 c0.138-0.035,0.11,0.755,0.501,0.792c0.389,0.034,0.527-0.073,0.862-0.396c0.334-0.324,0.251-0.755,0.278-1.079 c0.029-0.324,0-0.576,0.362-0.469c0.362,0.107,0.557-0.072,0.53-0.431c-0.027-0.36-0.333-0.792,0.25-0.901 c0.585-0.107,0.891-0.575,1.254-0.575c0.362,0,1.364,0.181,1.476,0c0.112-0.179,0.586-1.254,0.894-1.29 c0.307-0.037,1.111,0.139,1.836-0.005c0.723-0.144,1.504-0.683,1.754-0.647c0.25,0.035,0.863,0.035,0.669-0.18 c-0.195-0.216-0.475-0.719-0.892-0.719c-0.418,0-0.486-1.11-0.376-1.11c0.111,0,1.128,0.425,1.101,0.786 c-0.027,0.36,0.168,0.827,0.725,0.685c0.557-0.145,0.473-0.685,0.362-0.828C84.466,13.845,84.383,13.483,84.271,13.233"/><path fill="#989A94" d="M58.404,46.375c0.045-0.214-0.502-0.809-0.822-0.754c-0.32,0.054-1.005-0.378-1.37-0.755 c-0.367-0.378-1.052-0.378-1.325-0.378c-0.274,0-1.371,0.378-1.371,0.378c-0.046,0.539,0.412,0.377,0.96,0.377 c0.547,0,1.507-0.107,1.689,0.162c0.183,0.271,1.005,0.702,1.234,0.918C57.627,46.538,58.359,46.592,58.404,46.375"/><path fill="#989A94" d="M57.034,43.893c0.503-0.108,0.228-0.595-0.184-0.54C56.433,43.408,56.532,44,57.034,43.893"/><path fill="#989A94" d="M57.08,47.825c-0.419,0.088-0.32,1.052,0.182,0.876C57.765,48.526,57.49,47.736,57.08,47.825"/><path fill="#989A94" d="M63.11,47.23c-0.418,0.089-0.319,1.053,0.183,0.876C63.796,47.932,63.522,47.142,63.11,47.23"/><path fill="#989A94" d="M61.054,46.538c-0.365-0.108-0.776,0-1.05,0.054c-0.274,0.055-1.051,0.864-1.051,0.864 s0.501,0.107,0.821,0.107c0.32,0,0.503,0.217,0.777,0.379c0.275,0.162,0.778-0.216,0.959-0.216c0.184,0,0.412,0.647,0.458-0.054 C62.014,46.97,61.42,46.646,61.054,46.538"/><path fill="#989A94" d="M125.519,67.049c-0.573-0.191-0.639,0.704-1.096,1.297s-0.96,1.078-1.142,1.027 c-0.184-0.057-1.189,0.376-0.869,1.186c0.318,0.809,0.274,1.619-0.046,1.998c-0.32,0.378,0.275,1.457,0.184,2.051 c-0.093,0.594,0.137,0.972,0.776,0.972s0.868-0.269,1.143-0.972c0.273-0.701,0.318-1.402,0.594-1.996 c0.273-0.594,0.502-1.836,0.639-2.16c0.137-0.323,0.414-1.35,0.367-1.943C126.022,67.915,125.838,67.159,125.519,67.049"/><path fill="#989A94" d="M142.102,53.178c-0.293,0.154-0.598,2.752-0.051,2.969c0.55,0.217,0.922-1.62,0.739-1.889 C142.605,53.989,142.516,52.961,142.102,53.178"/><path fill="#989A94" d="M104.046,33.961c0.229-0.378-0.183-0.918-0.411-0.918c-0.43,0-0.64,0.812-0.365,1.08 C103.543,34.393,103.818,34.34,104.046,33.961"/><path fill="#989A94" d="M100.618,33.961c0.093-0.216-0.137-0.648-0.456-0.055C100.052,34.111,100.528,34.178,100.618,33.961"/><path fill="#989A94" d="M106.696,35.904c0.183,0.055,0.776,0,0.595-0.54c-0.184-0.539-0.595-0.539-0.731-0.539 c-0.138,0-0.731-0.162-0.961,0c-0.167,0.117,0.274,0.486,0.503,0.593C106.332,35.526,106.513,35.851,106.696,35.904"/><path fill="#989A94" d="M93.447,25.81c-0.274,0.162,0.044,0.81,0.41,0.863c0.366,0.055,0.777-0.269,1.097-0.431 c0.32-0.162,0.776-0.485,0.776-0.972s-0.09-0.918-0.273-1.133c-0.183-0.217-0.503-0.271-0.777-0.217 c-0.415,0.082-0.457,0.595-0.731,0.595c-0.274,0-0.594,0.108-0.501,0.485C93.538,25.379,93.721,25.648,93.447,25.81"/><path fill="#989A94" d="M96.096,24.353c0.456,0.217,1.417,0.431,1.053,0.648c-0.367,0.217-1.424,1.279-1.515,1.603 c-0.092,0.324,1.195,0.178,1.195,0.178s-0.277,0.378-0.047,0.486c0.228,0.108,0.367-0.377,0.731-0.377 c0.365,0,1.096,0.27,1.462,0.27c0.367,0,0.959-0.594,0.914-0.972c-0.046-0.378-0.503-0.971-0.914-1.188 c-0.411-0.217-0.869-1.188-1.142-1.404c-0.273-0.216,1.014-0.931,0.694-1.308c-0.32-0.378-1.289-0.148-1.655-0.42 c-0.365-0.27-0.685,0.055-0.914,0.379c-0.228,0.323-0.502-0.055-0.775,0.054c-0.371,0.146-0.229,0.7-0.046,0.972 C95.32,23.542,95.639,24.137,96.096,24.353"/><path fill="#989A94" d="M188.294,20.844c1.369,0,0.913,0.109,2.01,0.054c1.097-0.054,1.506-0.701,2.558-1.025 s1.873-0.541,2.194-0.379c0.319,0.162,0.822,0.055,0.502-0.323c-0.319-0.378-1.051-0.919-0.686-1.027 c0.366-0.108,0.732-0.163,0.869-0.593c0.137-0.432-0.503-1.188-0.137-1.62c0.364-0.433-0.275-0.972-0.732-1.08 c-0.457-0.109-2.237,0.108-2.604-0.109c-0.365-0.214-0.959-0.486-1.143-0.324c-0.181,0.162-0.594,1.026-0.594,1.026 s-0.318,0.108-0.594-0.377c-0.274-0.487-1.781-0.433-2.238-0.433c-0.455,0-0.96,0.107-1.463,0.162 c-0.502,0.054-0.776,0.216-1.141-0.162c-0.365-0.378-0.869-0.54-1.053-0.701c-0.182-0.162-1.188-0.162-1.963-0.053 c-0.777,0.107-1.555,0.107-1.555,0.107s-0.364-0.162-0.912-0.54c-0.548-0.376-1.097-0.647-1.28-0.647c-0.183,0-1.598,0.271-1.919,0 c-0.32-0.271-0.639-0.433-0.867-0.433c-0.229,0-0.411-0.431-0.137-0.431c0.273,0,1.553-0.433,1.553-0.433s-0.365-0.593-0.823-0.593 c-0.456,0-1.276-0.27-1.507-0.27c-0.228,0-0.045,0.27-0.504,0.163c-0.457-0.109-1.072,0.221-1.186-0.109 c-0.201-0.584-0.914,0.54-0.229,0.756c0.685,0.214,1.325,0,1.508,0.323c0.184,0.324,0,0.486,0,0.701 c0,0.217-0.365,0.811-0.595,0.918c-0.229,0.109-0.502-0.161-0.957,0.109c-0.458,0.269-1.601,0.055-1.739,0.216 c-0.137,0.162-0.411-0.432-0.637-0.325c-0.23,0.109-0.822,0.81-1.144,0.756c-0.319-0.055-0.73-0.431-0.73-0.863 s-0.137-0.972-0.275-1.081c-0.137-0.107-1.142-0.162-1.506-0.107c-0.367,0.053-1.508,0.162-1.691,0.376 c-0.182,0.217-0.687,0.379-1.006,0.379c-0.318,0-0.593-0.379-1.279-0.487c-0.685-0.106-2.193-0.162-2.374-0.106 c-0.183,0.053-0.778-0.109-0.55-0.324c0.229-0.216,0.914-0.918,0.504-1.242c-0.411-0.324-1.326-0.324-1.736-0.378 c-0.411-0.054-0.822-0.161-1.463-0.054c-0.64,0.108-0.777,0.486-1.051,0.163c-0.273-0.325,0.686,0.162-0.273-0.325 c-0.959-0.485-1.515-0.005-1.692-0.27c-0.03-0.044-0.052-0.084-0.07-0.121c-0.077,0.143-0.25,0.331-0.613,0.552 c-0.684,0.416-1.143,0.486-1.326,0.541c-0.183,0.053-1.455-0.204-1.46-0.378c-0.041-1.353-0.641,0.053-1.098,0.269 c-0.456,0.216-0.776,0.54-1.232,0.432c-0.457-0.108-1.189-0.108-1.645,0.107c-0.457,0.217-0.778,0.217-1.235,0.593 c-0.456,0.378-1.325,0.595-1.325,0.595s-0.775-0.055-1.186-0.055c-0.414,0-0.962,0-0.597,0.379c0.366,0.378,1.464,0.756,1.601,0.972 c0.137,0.215,0.318,0.862,0.092,1.024c-0.229,0.163-0.595,0.109-0.64-0.376c-0.046-0.485-0.093-0.541-0.64-0.756 c-0.55-0.216-0.504-0.052-0.96-0.539c-0.456-0.487-0.959-0.434-1.187-0.109c-0.23,0.324-0.092,0.972-0.367,1.025 c-0.274,0.055-0.594,0.269-0.641-0.216c-0.045-0.485-0.045-1.404-0.363-0.863c-0.321,0.539-0.459,0.539-0.459,0.81 c0,0.269,0.273,0.538,0.185,1.024c-0.093,0.486-0.093,0.811,0.046,0.811c0.135,0,0.455-0.486,0.865-0.594 c0.414-0.108,1.146-0.379,1.191,0.108c0.044,0.486,0.5,0.648,0.044,0.863c-0.457,0.216-0.959,0.108-1.051-0.215 c-0.092-0.325-0.411-0.325-0.731-0.054c-0.318,0.27-1.005,1.242-1.005,1.242s-1.098,0.593-1.233,0.485 c-0.139-0.107,0.364-0.703,0.731-0.971c0.364-0.27,0.642-0.864,0.502-1.026c-0.138-0.162-0.319-1.187-0.228-1.457 c0.09-0.27,0.502-0.647,0.046-0.918c-0.456-0.269-0.778-0.593-1.143-0.754c-0.366-0.162-0.775,0.648-1.097,0.863 c-0.318,0.216-0.273,0.485-0.687,0.54c-0.41,0.054-0.685,0.702,0,1.078c0.687,0.378,0.914,0.648,0.733,0.864 c-0.184,0.217-0.961-0.108-0.961-0.108s-0.594-0.323-0.958-0.323c-0.366,0-0.823-0.27-1.188-0.324s-1.099-0.054-1.279,0.162 c-0.184,0.215-0.641,0.864-1.006,0.648s-0.365-0.433-0.869-0.216c-0.501,0.216-1.004-0.162-1.277,0.162 c-0.274,0.324-0.045,0.324-0.916,0c-0.865-0.323-0.684,0.217-1.506,0.379c-0.822,0.162-1.325-0.162-1.553,0.162 c-0.229,0.324-0.549,0.917-0.686,0.539c-0.137-0.377,0.456-1.024,0.228-1.241c-0.228-0.216-1.188-0.108-1.324,0.053 c-0.138,0.163-0.047,0.756,0.044,0.973c0.093,0.214,0.23,1.079-0.044,0.917s-0.229-0.703-0.504-0.647 c-0.274,0.055-0.593,0.216-0.729,0.323c-0.137,0.108-0.686,0.108-0.824,0.324c-0.136,0.216,0.047,0.81-0.182,0.863 c-0.228,0.053-0.411,0.27-0.913-0.108c-0.504-0.377-0.504-0.163-0.641-0.054c-0.138,0.108-0.777,0.54-0.823,0.054 c-0.044-0.485,0.093-0.648-0.318-0.971c-0.411-0.324-0.093-0.324,0.458-0.108c0.546,0.217,1.231,0.324,2.237-0.054 c1.006-0.377,1.417-0.539,1.006-0.756c-0.412-0.216-0.741-0.903-1.382-1.011c-0.638-0.108-1.588,0.363-2.594-0.068 c-1.004-0.433-1.233-0.595-1.645-0.702c-0.411-0.107-2.92-1.41-4.062-1.196c-1.142,0.217-4.299,2.006-4.481,2.167 c-0.184,0.162-0.455,0.81-1.05,1.351c-0.594,0.537-1.626,1.073-2.496,1.288c-0.868,0.216-1.936,1.789-1.936,2.003 c0,0.216,0.365,1.026,0.274,1.188c-0.093,0.162,0.182,0.972,0.686,1.188c0.501,0.214,1.371,0.162,1.415-0.162 c0.046-0.324,0.731-1.026,0.777-0.539c0.044,0.485,0.501,1.239,0.411,1.564c-0.093,0.324,0,0.648,0.317,0.594 c0.321-0.054,2.013-0.486,2.013-0.486s0.547-0.271,0.458-0.702c-0.094-0.431,0.593-1.026,0.729-1.187 c0.139-0.162,0.64-0.81,0.047-1.026c-0.595-0.216-1.053-0.271-0.413-0.917c0.642-0.647,1.053,0,1.875-0.972 c0.822-0.971-0.185-1.241,0.686-1.297c0.867-0.052,1.779-0.106,1.598,0.218c-0.182,0.323-1.232,1.026-1.826,1.349 c-0.595,0.325-0.504,0.918-0.275,1.242c0.229,0.323,0.32,1.08,0.732,0.971c0.41-0.108,0.914-0.486,1.369-0.432 c0.456,0.054,1.373-0.054,1.508-0.054c0.139,0,0.777,0.756,0.412,0.865c-0.365,0.107-0.823,0.054-1.6,0.107 c-0.775,0.054-1.645,0.054-1.645,0.216c0,0.163,1.05,0.539,0.685,0.811c-0.364,0.269-0.729-0.055-1.187-0.109 c-0.457-0.053-0.731,0.702-0.87,1.134c-0.136,0.431,0.229,1.188-0.456,0.918c-0.684-0.271-1.188-0.271-1.368-0.162 c-0.185,0.108-0.519-0.095-0.976,0.066c-0.457,0.164-0.488,0.15-1.082,0.15h-0.594l-0.366,0.054c0,0-0.364-0.27-0.411-0.702 c-0.044-0.433,0.184-0.918-0.044-1.026c-0.229-0.108-1.051,0.053-1.188,0.378c-0.137,0.324-0.275,0.917-0.092,1.188 c0.183,0.269,0.732,0.809,0.229,0.647c-0.504-0.162-1.143-0.215-1.51,0.109c-0.364,0.324-1.004,1.024-1.004,1.024 s-1.143,0.11-1.143,0.433c0,0.324,0,0.755-0.411,0.81c-0.41,0.054-0.96,0.215-1.508,0.324c-0.548,0.108-0.502,0.377-1.143,0.432 c-0.64,0.054-0.73,0.378-0.137,0.485c0.594,0.107,1.507,0.54,1.554,1.025c0.045,0.487-0.047,1.025-0.275,1.512 c-0.157,0.333-1.096,0.108-1.646,0.108c-0.548,0-1.643-0.217-2.101,0c-0.457,0.215-0.366,1.295-0.229,1.781 c0.137,0.485-0.045,0.756-0.228,0.917c-0.182,0.162-0.229,0.648,0,0.864c0.228,0.215,0.411,0.701,0.595,0.755 c0.184,0.054,0.776-0.162,1.004,0.109c0.228,0.27,0.457,0.918,0.595,0.755c0.137-0.162,0.318-0.864,0.548-0.702 c0.229,0.162,0.777-0.053,1.188-0.108c0.411-0.054,0.638-0.593,1.052-0.864c0.41-0.269,0.182-0.269,0.043-0.592 c-0.137-0.324,0.413-0.702,0.733-1.08c0.319-0.379,0.911-0.054,1.05-0.486c0.136-0.433,0.183-1.187,0.547-1.134 c0.366,0.055,0.87,0.323,1.188,0.323c0.32,0,1.006-0.592,1.188-0.7c0.183-0.108,0.868-0.055,0.961,0.432 c0.09,0.485,0.866,1.08,1.049,1.187c0.183,0.109,1.371,0.541,1.554,0.702c0.183,0.162,0.456,0.647,0.549,1.081 c0.091,0.431,0.637,0.947,0.684,0.568c0.045-0.377-0.456-1.594-0.137-1.541c0.32,0.054,0.687-0.108,0.687-0.108 s-0.869-0.702-1.189-0.863c-0.317-0.162-0.911-0.485-1.187-1.025c-0.273-0.54-0.96-0.648-0.913-1.188 c0.043-0.54,0.685-0.215,1.05,0.217c0.365,0.431,1.279,1.026,1.6,1.401c0.32,0.378,0.821,0.541,0.959,1.026 c0.137,0.487,0.548,1.027,0.686,1.242c0.136,0.217,0.22,1.934,0.357,2.205c0.137,0.27,0.969-0.584,1.196-0.801 c0.228-0.215,0.639-0.323,0.685-0.756c0.047-0.431-0.549-0.755-0.73-0.917c-0.182-0.161,0.456-0.323,0.685-0.54 c0.229-0.215,0.64-0.593,0.821-0.27c0.183,0.325,0.093,1.619,0.183,1.836c0.093,0.215,1.007,0.539,1.19,0.81 c0.182,0.27,0.957,0.377,1.096,0.215c0.138-0.161,0.869,0.108,1.052,0.162c0.182,0.055,0.73-0.108,1.096-0.215 c0.364-0.108,0.73-0.433,0.684,0.27c-0.043,0.702-0.183,1.78-0.638,2.32c-0.458,0.54-0.274,0.811-0.73,0.811 c-0.213,0-0.405,0.001-0.56,0.087c-0.149-0.277-0.355-0.493-0.63-0.412c-0.547,0.162-1.232,0.162-1.689,0.809 c-0.456,0.649-0.641,0.701-0.731,0.486c-0.093-0.216,1.325-1.133,1.143-1.403s-1.281-0.162-1.875-0.162 c-0.593,0-1.095-0.431-1.552-0.54c-0.457-0.108-0.676,1.001-1.131,1.541c-0.457,0.539-1.154-0.299-1.564-0.299 c-0.413,0-1.189-0.702-1.189-0.702s-0.775-0.378-1.096-0.378c-0.321,0-0.959-0.701-1.143-0.701c-0.181,0-0.685-0.486-0.317-0.703 c0.364-0.214,1.143,0.256,0.776-0.931c-0.364-1.188-1.602-0.958-1.92-0.797c-0.321,0.163-2.605,0.108-2.788,0.108 c-0.182,0-1.506,0.541-1.917,0.756c-0.412,0.216-1.142,0.487-1.325,0.594c-0.183,0.106-1.143-0.217-1.554,0.055 c-0.543,0.356-1.05,0.917-1.186,0.917c-0.137,0-0.55,0.378-0.824,1.187c-0.274,0.81,0.046,1.51-0.457,1.781 c-0.501,0.269-1.586,0.7-1.952,1.132c-0.366,0.432-0.652,2.106-1.109,2.808c-0.456,0.703,0,1.349,0.092,1.781 c0.091,0.432,0.411,1.243-0.092,1.998c-0.501,0.756-0.456,1.133-0.685,1.188c-0.228,0.053,0.229,0.27,0.32,0.81 c0.091,0.54-0.411,1.079,0.457,1.565c0.868,0.485,1.662,0.508,1.89,1.154c0.229,0.649,0.989,2.139,0.989,2.139 s0.821,0.864,1.234,1.242c0.41,0.379,0.548,0.162,0.638-0.216c0.091-0.378,0.64-0.433,1.278-0.433c0.64,0,1.098,0.163,1.737,0.055 c0.641-0.109,1.104-1.039,1.332-1.148c0.229-0.107,1.182-0.254,1.775,0.176c0.595,0.433,0.503,1.025,0.823,1.403 c0.318,0.379,0.865,0.163,1.279-0.215c0.41-0.378,0.228-0.216,0.73,0.106c0.501,0.325,0.73,0.65,0.273,1.135 c-0.457,0.486-0.183,1.241-0.457,1.997c-0.272,0.756,0.261,0.753,0.764,1.077c0.503,0.323,0.927,2.432,1.201,2.81 c0.275,0.376-0.092,1.458,0.229,2.107c0.32,0.646,0.466,1.04,0.1,1.362c-0.367,0.324-0.83,0.957-0.877,2.036 c-0.046,1.079,0.184,1.834,0.364,2.212c0.185,0.379,0.642,1.404,0.87,1.782c0.229,0.38,1.016,1.075,1.062,1.67 c0.047,0.594-0.605,1.517-0.377,1.839c0.228,0.324,0.364,0.809,0.775,1.242c0.413,0.434,0.549,1.348,0.549,1.348 s0.137,0.378,0.184,0.973c0.045,0.596,0.092,0.972,0.548,1.242c0.457,0.27,0.775,0.324,1.005,0.053 c0.229-0.269,1.201-0.798,1.794-0.744s1.451,0.152,2.044-0.336c0.593-0.484,1.461-1.779,1.781-2.157s1.051-1.081,0.961-1.512 s-0.62-1.13-0.252-1.347c0.365-0.215,1.577-0.382,1.62-0.707c0.047-0.322-0.319-1.67-0.409-1.941 c-0.092-0.269,0.227-0.755,0.593-1.295c0.366-0.539,1.235-1.137,1.415-1.354c0.185-0.215,0.961-0.915,1.053-1.615 c0.093-0.701-0.184-1.567,0-1.942c0.182-0.38,0.046-0.703-0.364-1.134c-0.413-0.434-0.441-1.43-0.578-1.642 c-0.136-0.218,0.074-1.653,0.349-1.761c0.273-0.107,0.868-1.186,1.233-1.672c0.364-0.486,1.417-1.998,1.92-2.105 c0.501-0.108,1.279-0.971,1.323-1.458c0.046-0.485,1.371-2.321,1.417-2.698c0.047-0.379,0.594-1.783,0.365-2.107 s-2.01,0.488-2.238,0.596s-0.867,0.539-1.601,0.485c-0.729-0.054-0.41-0.757-0.455-1.081c-0.047-0.324-0.822-1.564-1.006-1.618 s-0.729-0.701-0.959-1.35c-0.229-0.647-1.186-1.074-1.55-1.561c-0.366-0.485,0.042-2.001-0.324-2.758 c-0.366-0.756-0.685-1.727-1.005-2.429c-0.078-0.172-0.162-0.338-0.244-0.494c0.424-0.125,1.039-0.353,1.112-0.046 c0.091,0.378,0.594,1.188,0.687,1.782c0.091,0.592,0.593,0.377,0.639,0.917c0.046,0.539,0.502,1.835,0.686,1.998 c0.183,0.162,1.006,1.025,1.143,1.349c0.137,0.323,0.318,0.756,0.455,1.565c0.139,0.81,0.274,1.89,0.641,2.052 c0.365,0.16,1.599-0.27,1.828-0.432c0.229-0.163,1.736-1.027,2.285-1.081c0.548-0.054,0.638-0.486,1.324-0.648 c0.686-0.161,1.188-0.754,1.644-1.186c0.457-0.433,1.006-1.512,1.188-1.891c0.183-0.376,0.641-0.647,0.41-1.078 c-0.228-0.433-1.188-1.081-1.553-1.135c-0.365-0.054-0.319-0.754-0.547-0.754c-0.23,0-0.184,0.376-0.641,0.648 c-0.457,0.268-0.914,0.809-1.234,0.701c-0.318-0.107,0.093-0.378-0.41-0.864c-0.503-0.485-0.686-0.594-0.686-0.97 c0-0.379-1.005-1.082-1.098-1.621c-0.09-0.54,0.686-1.294,0.915-0.81c0.229,0.486,0.412,1.242,1.005,1.566 c0.594,0.324,1.143,0.865,1.418,0.972c0.273,0.107,0.958-0.593,1.186-0.485c0.229,0.107,0.688,1.078,1.097,1.24 c0.412,0.163,1.782,0.217,2.011,0.217c0.23,0,1.188,0.055,1.372-0.27c0.182-0.324,0.317-0.324,0.547-0.324 c0.229,0,0.639,0.97,0.959,1.078c0.321,0.107,0.914,0.054,0.867,0.756c-0.044,0.703,0.275,1.295,0.596,1.349 c0.319,0.056,1.05-0.809,1.05-0.809s0,1.35-0.045,1.834c-0.045,0.487,0.504,2.269,0.504,2.269s0.684,1.673,0.867,2.051 c0.182,0.378,0.959,1.511,0.959,1.997s0.092,1.241,0.366,1.241c0.273,0,0.547-0.862,0.866-1.403c0.32-0.539,0.671-1.021,0.807-1.562 c0.137-0.54-0.121-1.783-0.121-2.162s0.273-0.702,0.914-1.026c0.641-0.323,1.096-1.24,1.645-1.727 c0.549-0.485,0.504-1.294,1.6-1.294c1.098,0,1.006,0,1.28-0.324c0.273-0.325,0.547-0.541,0.685,0.053 c0.137,0.595,0.914,1.457,1.051,1.674c0.137,0.214,0.41,0.809,0.365,1.457c-0.044,0.647-0.275,2.422-0.044,2.422 c0.227,0,1.003-1.936,1.003-1.936s1.006-0.809,0.959,0.055c-0.045,0.862,0.092,1.782,0.092,2.321s0.822,1.834,0.822,1.512 c0-0.324,0.367-1.242,0.367-1.727c0-0.487,0.227-0.271,0.822,0.215c0.592,0.484,1.005,1.456,1.005,1.456s0.572,1.821,0.663,2.091 c0.092,0.27,0.752-1.279,0.889-1.604c0.138-0.324,0.228-0.487,0.596-0.595c0.365-0.106,0.822-0.106,0.959-0.7 c0.137-0.596,0.549-1.296,0-2.107c-0.549-0.81-0.824-1.347-1.233-1.726c-0.411-0.378-0.73-1.351-0.73-1.351s0.866-0.917,1.14-1.24 c0.275-0.324,0.688-0.108,0.732,0.268c0.046,0.378-0.411,0.702-0.502,1.513c-0.092,0.81,0.548,1.079,0.73,0.81 c0.182-0.27,0.639-0.919,0.639-1.081s-0.32-0.107-0.363-0.702c-0.047-0.593,0.592-1.025,0.821-0.864 c0.228,0.162,1.69-0.214,2.376-0.647c0.686-0.431,1.096-1.35,1.507-1.727c0.412-0.378,1.829-1.62,1.737-2.213 c-0.093-0.594,0.045-1.404-0.319-2.159c-0.368-0.755-0.824-1.241-1.006-1.564c-0.183-0.324,0.776-0.378,1.232-0.864 c0.457-0.486,0-0.918-0.227-0.865c-0.229,0.054-0.824,0.217-1.052,0.162c-0.229-0.053-0.366-0.323-0.731-0.648 c-0.366-0.324,0.091-0.81,0.321-0.755c0.227,0.055,0.821-0.54,1.094-0.81c0.274-0.27,0.688-0.485,0.549-0.215 c-0.137,0.271-0.457,1.242-0.09,1.295c0.365,0.055,1.234-0.81,1.371-0.755c0.138,0.053,0.364,0.755,0.227,1.078 c-0.135,0.324-0.135,0.865,0.047,0.81c0.182-0.053,0.549-0.539,0.639-0.377c0.092,0.162,0.551,0.486,0.319,1.08 c-0.228,0.593-0.684,0.81-0.136,1.188c0.549,0.376,0.729,0.052,1.143-0.217c0.409-0.269,0.684-1.458,0.456-1.836 c-0.228-0.376-0.774-1.133-0.774-1.402c0-0.271,0.912-0.271,0.912-0.702c0-0.432,0.318-0.757,0.641-0.919 c0.319-0.161,0.73-0.864,0.867-0.646c0.138,0.216,0.958,0.485,1.187,0.161c0.229-0.323,1.417-1.511,2.147-2.159 c0.731-0.648,1.006-1.403,1.188-2.159c0.185-0.757,0.457-1.243,0.365-1.836c0.273,0.755,0.32,1.296,0.273,1.89 c-0.045,0.594,0,1.834,0.093,1.997c0.092,0.161,0.456,0.54,0.684,0.432c0.229-0.107-0.091-1.187-0.091-1.403 c0-0.216,0.319-0.541,0.504-0.594c0.182-0.053,0-0.971-0.231-1.35c-0.227-0.378-0.547-0.593-0.363-0.647 c0.182-0.054,0.41-0.485,0.273-0.595c-0.137-0.107-0.046-0.484-0.363-0.376c-0.23,0.077-0.855-0.061-0.834,0.398 c-0.133-0.46-0.416-0.768-0.767-0.723c-0.412,0.054-0.64,0.325-1.052,0.325c-0.41,0-0.09-0.756-0.273-0.756 c-0.183,0-0.594,0.702-0.822,0.325c-0.229-0.379,0.64-0.865,1.324-1.135c0.687-0.27,1.827-1.835,2.285-1.89 c0.456-0.053,1.6,0.108,2.605,0.054c1.005-0.054,1.324-0.54,1.645-0.27c0.318,0.27,1.003,0.594,1.416,0.54 c0.41-0.055,0.227,0,0.867-0.54c0.639-0.54,1.232-0.81,1.553-1.241c0.321-0.432,1.188-0.755,1.234-0.324 c0.047,0.43-0.091,0.863,0.274,0.863c0.364,0,0.913-0.433,1.371-0.647c0.456-0.216,0.822-0.485,0.822-0.485s-1.874,1.51-2.331,1.834 c-0.457,0.323-1.555,0.54-2.011,1.188c-0.455,0.647-0.729,0.863-0.687,1.565c0.047,0.702,0.822,1.621,0.458,2.268 S182.4,27.97,182.4,27.97s0.548-0.918,1.322-1.513c0.777-0.593,1.234-1.402,1.51-1.727c0.274-0.323,1.098-0.378,1.098-0.755 c0-0.378,0.227-0.864,0.364-1.297c0.138-0.43-0.274-0.324,0-0.863C186.968,21.276,186.924,20.844,188.294,20.844 M115.423,20.304 c0.228-0.754,1.508,0.162,1.278,0.54C116.474,21.222,115.266,20.812,115.423,20.304 M121.133,32.99 c-0.365,0.108-1.461,0.216-1.871,0.161c-0.412-0.053-0.915-0.539-1.508-0.648c-0.597-0.107-1.327-0.053-1.555,0.325 c-0.229,0.378-1.053,0.215-1.418,0.215c-0.364,0-0.822,0.54-0.912,0.325c0,0,0.273-0.972,0-1.08 c-0.272-0.108,0.09-0.756,0.365-0.972c0.274-0.215,0.594-0.756,0.867-1.296c0.274-0.54,0.642-0.594,0.869-0.54 c0.229,0.054,0.73,1.025,0.867,1.349c0.138,0.324,0.595-0.107,0.777-0.215c0.182-0.108,0.458-0.432,0.501-0.702 c0.047-0.271,0.458-0.432,0.915-0.432s0.047,0.432-0.274,0.54c-0.321,0.108-0.138,0.324,0.411,0.54 c0.547,0.216,1.051,0.81,1.646,1.188C121.407,32.125,121.499,32.881,121.133,32.99 M128.262,30.345 c-0.184,0.162-1.008,0.323-1.282,0c-0.272-0.324-0.912,0.054-0.958,0.647c-0.045,0.595,0.183,0.162,0.457,0.378 c0.275,0.216,0.365,0.54,0.547,0.864c0.185,0.323,0.504,0.215,0.732,0.485s-0.641,0.593-0.275,0.918 c0.367,0.324,0.55,1.619,0.596,1.943c0.047,0.324-1.005,0.486-1.324,0.433c-0.321-0.054-1.28-0.433-1.602-0.541 c-0.318-0.109-0.502-1.457-0.09-1.404c0.411,0.055,0.502-0.106,0.959-0.593c0.457-0.486-0.685-0.702-1.005-0.81 c-0.32-0.108-0.96-1.295-1.188-1.673c-0.227-0.377-0.05-0.967,0.504-1.404c0.274-0.216,1.005,0.27,1.369,0 c0.366-0.269,0.731-0.593,0.867-0.702c0.139-0.107,1.052,0.162,1.189,0.486C127.895,29.697,128.443,30.183,128.262,30.345"/><path fill="#989A94" d="M153.956,9.711C154.143,9.364,153.736,9.293,153.956,9.711"/><path fill="#989A94" d="M126.661,13.772c0.275,0.109,0.868,0.162,1.371,0.485c0.502,0.324,1.215,0.455,1.552,0.055 c0.273-0.324,0.047-0.864-0.182-0.917c-0.229-0.054-0.366-0.486,0.229-0.865c0.594-0.378,1.233-0.865,1.919-0.972 c0.685-0.107,2.239-0.162,2.787,0s1.371-0.702,1.601-1.079c0.226-0.378-0.732-0.648-1.007-0.216s-1.6,0.325-1.873,0.216 c-0.272-0.108-2.467,0.432-2.923,0.432c-0.459,0-0.642,0.647-1.279,0.971c-0.641,0.324-1.509,0.81-1.83,0.972 C126.707,13.016,126.388,13.665,126.661,13.772"/><path fill="#989A94" d="M176.232,31.046c-0.184,0.055-0.504-0.593-0.868-0.486c-0.339,0.099-0.456,0.648-0.456,0.81 c0,0.162-1.281,0.486-0.869,0.918c0.411,0.431,0.824,0.108,1.463,0.053c0.637-0.053,1.233-0.269,1.233-0.269 s0.958,0.053,0.821-0.485C177.42,31.046,176.414,30.992,176.232,31.046"/><path fill="#989A94" d="M173.217,35.742c-0.184,0-1.142,0.432-1.417,0.756c-0.273,0.324-1.598-0.27-1.78,0 c-0.185,0.271-0.549,0.595-0.777,0.81c-0.23,0.216-0.868,0.054-0.732,0.702c0.139,0.648,0.457,1.241,0.732,1.241 c0.273,0,0.64-0.215,0.64-0.81c0-0.593,0.638,0,0.959-0.053c0.319-0.053,0.502-0.432,0.638-0.863 c0.016-0.052,0.027-0.088,0.033-0.112c-0.012,0.1-0.008,0.389,0.334,0.49c0.549,0.162,0.73-0.271,0.73-0.433 c0-0.161,1.006-0.431,1.188-0.592c0.185-0.162,0.915-0.432,0.963-0.648c0.043-0.215,0-1.458,0.227-1.565 c0.229-0.11,0.549-0.11,0.182-0.864c-0.365-0.756-0.365-1.459-0.823-1.134c-0.335,0.239-0.136,1.189-0.408,1.836 C173.627,35.149,173.398,35.742,173.217,35.742"/><path fill="#989A94" d="M164.261,43.299c-0.676,0.125-1.095,1.837-0.547,1.783C164.261,45.027,164.855,43.192,164.261,43.299"/><path fill="#989A94" d="M194.507,83.191c-0.184,0-0.273,0.271-0.685,0c-0.41-0.271-0.32-0.161-0.595-0.702 c-0.273-0.539-0.319-1.242-0.776-0.972c-0.184,0.108,0,0.703,0.184,0.919c0.183,0.215,0.273,0.97,0.227,1.187 c-0.044,0.216-0.821,0.487-0.456,0.756c0.366,0.272,1.052,0,0.96,0.322c-0.091,0.325-0.457,0.759-0.047,0.864 c0.411,0.109,0.549-0.377,0.731-0.753c0.184-0.38,0.32-0.702,0.64-0.919C195.009,83.678,194.689,83.191,194.507,83.191"/><path fill="#989A94" d="M192.084,84.973c-0.072,0.261-0.455,0.323-0.729,0.592c-0.275,0.271,0,0.379-0.778,0.92 c-0.776,0.539-1.735,1.131-1.918,1.617c-0.182,0.486,0.183,0.756,0.914,0.812c0.729,0.053,0.546,0.215,1.05-0.433 c0.502-0.646,0.959-1.025,1.555-1.564c0.594-0.541,0.594-1.352,0.594-1.352S192.131,84.812,192.084,84.973"/><path fill="#989A94" d="M177.557,85.674c-0.228-0.054-0.73-0.271-0.73-0.271c-0.504,0.595,0.503,0.595,0.366,1.187 c-0.136,0.596,0.684,0.379,0.914,0.271c0.227-0.107,0.775-1.351,0.684-1.674C178.699,84.864,177.785,85.727,177.557,85.674"/><path fill="#989A94" d="M180.006,72.422c0.047-0.486-1.536-0.459-1.947-0.838c-0.411-0.377-0.455-1.512-0.685-2.16 c-0.228-0.646-0.686-1.078-1.142-1.671c-0.457-0.595-0.686-1.944-0.823-1.836c-0.136,0.107-0.547,1.675-0.228,2.159 c0.32,0.487-0.138,1.457-0.365,2.105c-0.229,0.646-0.777-0.109-1.234-0.433c-0.457-0.325-1.096-0.538-1.416-0.919 c-0.32-0.377,0.548-1.402,0.32-1.781c-0.229-0.378-1.463-0.053-1.6-0.053c-0.136,0-0.41-0.539-0.685-0.539s-0.229,1.08-0.229,1.08 s-0.273-0.379-0.685-0.866c-0.413-0.483,0.044,0.325-0.367,0.812s-0.272,0.324-0.458,0.863c-0.18,0.54-0.592,0.324-1.002-0.216 c-0.412-0.538-0.641-0.161-0.916,0c-0.273,0.162-0.502,1.081-0.638,1.294c-0.138,0.217-1.454-0.387-1.685-0.116 c-0.227,0.269,0.038,2.007,0.038,2.222c0,0.218-0.958,0.107-1.278,0.38c-0.32,0.269-0.82,0.108-1.143,0.108 c-0.319,0-1.415,1.025-1.781,1.293c-0.365,0.271-0.988,1.242-0.804,1.512c0.18,0.271,1.17,0.918,0.94,1.027 c-0.227,0.107-0.365,0.863,0.183,1.51c0.548,0.649,0.366,0.811,0.411,1.135c0.045,0.322,0.273,0.433,0.641,0.971 c0.365,0.541-0.641,0.973-0.777,1.297s0.322,0.809,0.595,1.08c0.273,0.269,0.958,0.106,1.372-0.057 c0.41-0.16,0.864-0.592,1.139-0.646c0.275-0.053,1.83,0.456,1.83,0.456s0.182-1.374,0.502-1.806 c0.318-0.433,1.324-0.053,1.324-0.053s0.412-0.324,1.507-0.595c1.099-0.271,0.641,0.271,1.052,0.432 c0.411,0.163,0.957,0.27,1.279,0.54c0.32,0.27,0,0.918-0.046,1.188s0.776,0.162,0.823-0.107c0.046-0.271,0.273-0.539,0.73-0.864 c0.457-0.323,0.092,0.487,0.273,0.972c0.184,0.484,0.457-0.658,0.457-0.107c0,0.162,0.137,0.323,0.183,0.486 c0.047,0.162,0.639,0.217,0.639,0.756c0,0.538,0,0.863,0.138,0.97c0.138,0.108,0.868,0,1.189,0.647 c0.319,0.647,0.547,0.057,0.73-0.215c0.183-0.269,0.823,0.109,1.005,0.323c0.183,0.217,0.685-0.431,1.372-0.647 c0.684-0.215,0.593-0.162,0.775-0.484c0.182-0.324,0.319-1.188,0.73-1.836c0.41-0.646,1.883-1.629,1.883-2.492 c0-0.865-0.969-3.013-1.473-3.932C180.16,73.852,179.961,72.906,180.006,72.422"/><path fill="#989A94" d="M195.785,69.479c-0.41-0.162-1.234,1.134-1.234,1.134C195.148,70.883,196.197,69.641,195.785,69.479"/><path fill="#989A94" d="M188.751,73.312c0.046-0.269-0.093-0.648-0.915-0.862c-0.822-0.215-0.274,0.162,0,0.647 S188.66,73.837,188.751,73.312"/><path fill="#989A94" d="M156.082,61.167c0.23-0.324,0.139-0.809-0.227-0.756c-0.365,0.055-0.686-0.701-1.279-1.188 c-0.594-0.484-1.05-0.809-1.598-1.509c-0.548-0.702-1.234-1.136-1.601-1.514s-0.913-0.539-1.142-0.485 c-0.567,0.134,0.823,1.297,0.959,1.457c0.137,0.162,1.371,1.403,1.371,1.998c0,0.594,0.397,2.441,0.626,2.656 c0.228,0.217,1.794,0.582,1.978,1.016c0.184,0.43,0.594,0.539,0.594-0.057C155.764,62.192,155.855,61.491,156.082,61.167"/><path fill="#989A94" d="M152.611,55.067c0.229,0.972,0.688,1.945,0.868,2.322c0.183,0.377,0.961,0.916,1.234,1.188 c0.272,0.27,0.685-0.108,0.503-0.434c-0.184-0.322-0.55-0.809-0.597-1.188c-0.044-0.377-0.273-0.971-0.638-1.619 c-0.367-0.647-0.684-0.809-0.914-1.24c-0.229-0.433-1.052-1.242-1.052-1.242c-0.364,0.054-0.364,0.865-0.183,1.135 C152.017,54.258,152.384,54.096,152.611,55.067"/><path fill="#989A94" d="M160.605,64.622c0.047-0.323-0.5-0.81-0.729-0.81c-0.229,0-1.371-0.323-1.371-0.323 c-0.204,0.104-0.479,0.184-0.561,0.326c-0.023-0.05-0.077-0.105-0.17-0.164c-0.504-0.324-1.098,0-1.282-0.432 c-0.181-0.433-0.454-0.433-0.638-0.162c-0.334,0.491,0.091,0.863,0.227,0.97c0.139,0.108,0.641,0.216,1.098,0.163 c0.285-0.034,0.643-0.111,0.748-0.241c0.014,0.054,0.053,0.116,0.121,0.187c0.365,0.379,0.594,0.54,1.142,0.486 C159.738,64.567,160.562,64.946,160.605,64.622"/><path fill="#989A94" d="M162.982,65.27c-0.102,0.481,0.685,0.701,0.731,0.162C163.758,64.891,163.075,64.838,162.982,65.27"/><path fill="#989A94" d="M166.408,65.324c0,0,0.732-0.108,0.732-0.485c0-0.378-0.732-0.865-1.007-0.434 c-0.272,0.434-0.774,0.865-0.729,1.244C165.476,66.239,166.408,65.324,166.408,65.324"/><path fill="#989A94" d="M162.937,61.708c0.366,0.27,1.051-0.918,1.234-0.541c0.183,0.378-0.046,0.541,0.274,1.025 c0.32,0.487,0.914,0.434,0.914,0.434s-0.047-1.296-0.549-1.621c-0.504-0.324-0.823-0.699-0.23-0.593 c0.596,0.107,0.916-0.162,0.779-0.485c-0.137-0.324-1.006-0.162-1.281-0.107c-0.273,0.053-0.686-0.217-0.686-0.217 c-0.273,0.107-0.227,0.379-0.317,0.917C162.982,61.059,162.572,61.437,162.937,61.708"/><path fill="#989A94" d="M166.227,58.306c-0.184,0-1.461,0.271-1.6,0.324c-0.137,0.054-0.96-0.109-0.96-0.109 c-0.318,0.378-0.09,0.757,0.411,0.703c0.502-0.054,1.555-0.216,1.783-0.216S166.408,58.306,166.227,58.306"/><path fill="#989A94" d="M168.327,57.766c-0.42-0.213-1.187,1.781-0.638,1.943C168.236,59.872,168.648,57.926,168.327,57.766"/><path fill="#989A94" d="M160.926,56.092c-0.866,0-0.912,0.811-1.096,0.973c-0.184,0.164-0.366,0.215-0.731,0.324 c-0.364,0.106-0.456,0.537-0.548,0.809c-0.091,0.271-0.73-0.484-0.912-0.271c-0.184,0.217-0.047,1.244,0.273,2.107 c0.319,0.863,1.141,1.404,1.368,1.404c0.23,0,0.688,0,1.009,0.106c0.316,0.108,1.367,0.216,1.322-0.27s-0.138-1.241,0.32-1.728 c0.458-0.484,0.914-0.754,0.687-1.457c-0.229-0.701-0.687-1.135-0.366-1.457c0.32-0.324,0.685-0.432,0.685-0.703 c0-0.27-0.774,0.758-0.868-1.024c-0.018-0.382-0.73,0.106-0.777,0.485C161.247,55.77,161.795,56.092,160.926,56.092"/><path fill="#989A94" d="M163.211,49.453c0.272,0.648,1.233,1.134,1.005,1.405c-0.229,0.269-0.913,0.809-1.005,1.295 c-0.092,0.484,1.097-0.758,1.416-1.243c0.32-0.484,0.96-0.214,1.098-0.484l0.137-0.271c0,0-0.502-0.107-0.914-0.27 s-0.914,0.432-0.687-0.432c0.229-0.863,0.915-0.701,0.777-1.349c-0.136-0.648-0.594-0.81-0.73-0.81c-0.321,0,0.046,0.595-0.41,0.972 C163.439,48.643,162.936,48.805,163.211,49.453"/><path fill="#989A94" d="M164.674,53.016c0.502,0,1.369,0.162,1.188-0.108s-0.639-1.134-1.143-0.917 C164.564,52.057,164.17,53.016,164.674,53.016"/><path fill="#989A94" d="M166.227,51.181c-0.184-0.015-0.776,1.133,0.045,1.079C167.095,52.208,166.866,51.235,166.227,51.181"/><path fill="#989A94" d="M166.364,53.178c-0.641,0.973-0.595,0.756-1.052,0.541c-0.458-0.217-1.188,0.484-1.052,0.756 c0.138,0.27,1.144-0.055,1.372,0.431s0.229,0.54,0.685,0.431c0.458-0.107,0.914-0.861,0.777-1.24 C166.959,53.719,166.364,53.178,166.364,53.178"/><path fill="#989A94" d="M173.719,63.866c-0.364,0-0.775,0.539-0.502,0.595c0.273,0.054,1.095-0.162,1.143,0 c0.046,0.161,0.504,1.188,0.958,1.133c0.458-0.054,0.731-1.025,0.958-1.295c0.231-0.271,1.146-0.433,1.234,0.054 c0.093,0.486,0.366,0.973,0.915,1.297c0.548,0.322,1.188,0.647,1.235,0.376c0.042-0.271-0.277-1.296-0.642-1.457 c-0.365-0.163-1.005-1.079-1.005-1.458c0-0.376-0.547-0.484-0.822-0.754c-0.273-0.27-0.503-1.026-1.188-1.189 s-0.868-0.432-1.598-0.861c-0.733-0.434-2.376-0.434-2.422-0.162c-0.046,0.269,0,0-0.548-0.217s-0.959,0-1.096-0.379 c-0.139-0.377-0.458-0.484-0.869,0c-0.344,0.405-0.504,0.434,0.274,0.596c0.774,0.162,1.005,0.162,0.686,0.592 c-0.32,0.432-0.549,0.973-0.274,1.025c0.274,0.055,1.096-0.216,1.187,0c0.093,0.217-0.183,0.27,0.731,0.432 c0.914,0.164,1.096,0.542,1.28,0.756C173.535,63.165,174.085,63.866,173.719,63.866"/></svg>');
		
		
		

		/**
		 * Bike
		 */
		$svg['bike']['colors'] = array('#F088B6','#70C8DF');
		$svg['bike']['code'] = '<svg version="1.1" id="Layer_1"'.$this->svg_color_data($svg['bike']['colors']).' xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"width="100%" height="100%" viewBox="0 0 200 132.234" enable-background="new 0 0 200 132.234" xml:space="preserve"><g><g><path fill="#EDEDED" d="M81.761,76.865l15.916,15.911c0.64,0.641,0.64,1.678,0,2.317c-0.64,0.64-1.677,0.64-2.317,0L79.444,79.183L81.761,76.865z"/><g><g><path fill="#B2B2B2" d="M75.458,80.095h10.024c0.539,0,0.98-0.441,0.98-0.979v-2.343c0-0.539-0.441-0.98-0.98-0.98H75.458c-0.539,0-0.98,0.441-0.98,0.98v2.343C74.478,79.653,74.918,80.095,75.458,80.095z"/><g><polygon fill="#C6C6C6" points="84.169,80.715 85.108,80.715 85.354,80.095 83.924,80.095 "/><polygon fill="#C6C6C6" points="80,80.715 80.939,80.715 81.184,80.095 79.754,80.095 "/><polygon fill="#C6C6C6" points="75.83,80.715 76.77,80.715 77.015,80.095 75.585,80.095 "/></g><g><polygon fill="#C6C6C6" points="76.77,75.167 75.83,75.167 75.585,75.787 77.015,75.787 "/><polygon fill="#C6C6C6" points="80.939,75.167 80,75.167 79.754,75.787 81.184,75.787 "/><polygon fill="#C6C6C6" points="85.108,75.167 84.169,75.167 83.924,75.787 85.354,75.787 "/></g></g></g></g><g><g><g><path d="M41.86,53.875c-21.298,0-38.563,17.266-38.563,38.563s17.266,38.562,38.563,38.562s38.563-17.265,38.563-38.562S63.158,53.875,41.86,53.875z M41.86,126.211c-18.652,0-33.772-15.121-33.772-33.772c0-18.652,15.12-33.772,33.772-33.772c18.652,0,33.772,15.12,33.772,33.772C75.633,111.09,60.513,126.211,41.86,126.211z"/><path fill="#EDEDED" d="M41.86,57.362c-19.372,0-35.076,15.704-35.076,35.076s15.704,35.076,35.076,35.076c19.372,0,35.076-15.704,35.076-35.076S61.232,57.362,41.86,57.362z M41.86,126.211c-18.652,0-33.772-15.121-33.772-33.772c0-18.652,15.12-33.772,33.772-33.772c18.652,0,33.772,15.12,33.772,33.772C75.633,111.09,60.513,126.211,41.86,126.211z"/><g><g><rect x="41.86" y="88.761" width="34.141" height="0.243"/><rect x="41.86" y="95.871" width="34.141" height="0.243"/></g><g><rect x="54.744" y="63.754" transform="matrix(0.4994 0.8664 -0.8664 0.4994 97.4922 -7.0725)" width="0.243" height="34.14"/><rect x="58.299" y="69.912" transform="matrix(0.4994 0.8664 -0.8664 0.4994 104.607 -7.0699)" width="0.243" height="34.14"/></g><g><rect x="47.195" y="58.807" transform="matrix(0.8668 0.4987 -0.4987 0.8668 44.1473 -13.4882)" width="0.243" height="34.14"/><rect x="53.353" y="62.362" transform="matrix(0.8673 0.4979 -0.4979 0.8673 46.6455 -16.0788)" width="0.243" height="34.14"/></g><g><rect x="38.184" y="58.298" width="0.243" height="34.141"/><rect x="45.294" y="58.298" width="0.243" height="34.141"/></g><g><rect x="13.176" y="79.311" transform="matrix(0.5 0.866 -0.866 0.5 83.9145 13.5225)" width="34.14" height="0.243"/><rect x="19.334" y="75.755" transform="matrix(0.5 0.866 -0.866 0.5 83.9136 6.4115)" width="34.14" height="0.243"/></g><g><rect x="8.23" y="86.861" transform="matrix(0.866 0.5 -0.5 0.866 46.8814 -0.9963)" width="34.14" height="0.243"/><rect x="11.785" y="80.703" transform="matrix(0.866 0.5 -0.5 0.866 44.2809 -3.5985)" width="34.14" height="0.243"/></g><g><rect x="7.72" y="95.872" width="34.14" height="0.243"/><rect x="7.72" y="88.761" width="34.14" height="0.243"/></g><g><rect x="28.733" y="86.982" transform="matrix(0.4994 0.8664 -0.8664 0.4994 104.5945 27.0913)" width="0.243" height="34.14"/><rect x="25.178" y="80.824" transform="matrix(0.5011 0.8654 -0.8654 0.5011 97.3373 26.9439)" width="0.243" height="34.14"/></g><g><rect x="36.283" y="91.929" transform="matrix(0.8668 0.4987 -0.4987 0.8668 59.2124 -3.6325)" width="0.243" height="34.14"/><rect x="30.125" y="88.373" transform="matrix(0.8668 0.4987 -0.4987 0.8668 56.6186 -1.0352)" width="0.243" height="34.14"/></g><g><rect x="45.294" y="92.438" width="0.243" height="34.14"/><rect x="38.184" y="92.438" width="0.243" height="34.14"/></g><g><rect x="36.404" y="105.322" transform="matrix(0.5 0.866 -0.866 0.5 118.0536 6.4111)" width="34.14" height="0.243"/><rect x="30.246" y="108.878" transform="matrix(0.5 0.866 -0.866 0.5 118.0539 13.5218)" width="34.14" height="0.243"/></g><g><rect x="41.351" y="97.772" transform="matrix(0.866 0.5 -0.5 0.866 56.7716 -16.0952)" width="34.14" height="0.243"/><rect x="37.796" y="103.93" transform="matrix(0.866 0.5 -0.5 0.866 59.3769 -13.4927)" width="34.14" height="0.243"/></g></g><path fill="#878787" d="M10.393,106.215l0.247,0.429l1.9-1.098l-0.247-0.428L10.393,106.215z M13.948,112.373l0.247,0.428l1.9-1.097l-0.247-0.429L13.948,112.373z M10.393,78.661l1.901,1.097l0.247-0.428l-1.9-1.097L10.393,78.661z M13.948,72.503l1.901,1.098l0.247-0.428l-1.901-1.098L13.948,72.503z M21.498,64.773l1.097,1.901l0.428-0.247l-1.098-1.901L21.498,64.773zM21.498,120.104l0.428,0.247l1.097-1.901l-0.428-0.247L21.498,120.104z M7.72,96.24h2.195v-0.494H7.72V96.24z M7.72,89.13h2.195v-0.494H7.72V89.13z M76,88.636h-2.195v0.494h2.195L76,88.636z M69.772,72.503l-0.247-0.428l-1.9,1.098l0.247,0.428L69.772,72.503z M56.065,61.218l-0.428-0.247l-1.097,1.901l0.428,0.247L56.065,61.218z M27.655,123.658l0.428,0.247l1.097-1.9l-0.428-0.247L27.655,123.658z M60.698,118.45l1.097,1.9l0.428-0.247l-1.098-1.9L60.698,118.45z M71.18,105.546l1.901,1.098l0.247-0.428l-1.9-1.098L71.18,105.546z M67.625,111.704l1.9,1.097l0.248-0.428l-1.901-1.097L67.625,111.704z M60.698,66.427l0.428,0.247l1.098-1.901l-0.428-0.247L60.698,66.427z M27.655,61.218l1.098,1.9l0.428-0.247l-1.097-1.901L27.655,61.218zM73.806,96.24H76l0-0.494h-2.195V96.24z M71.18,79.331l0.247,0.427l1.901-1.097l-0.247-0.428L71.18,79.331z M38.058,126.578h0.494v-2.194h-0.494V126.578z M38.058,60.493h0.494v-2.195h-0.494V60.493z M45.169,60.493h0.494v-2.195h-0.494V60.493zM45.169,126.578h0.494v-2.194h-0.494L45.169,126.578z M54.541,122.005l1.097,1.9l0.428-0.247l-1.097-1.9L54.541,122.005z"/></g><g><path fill="#DADADA" d="M47.482,92.438c0-0.133-0.005-0.265-0.014-0.395l1.001-0.975c-0.053-0.256-0.12-0.506-0.201-0.75l-1.353-0.344c-0.116-0.237-0.248-0.466-0.396-0.684l0.379-1.342c-0.173-0.194-0.356-0.378-0.55-0.551l-1.342,0.379c-0.217-0.146-0.446-0.279-0.684-0.395l-0.343-1.354c-0.244-0.081-0.495-0.148-0.75-0.201l-0.974,1.002c-0.13-0.01-0.262-0.015-0.395-0.015c-0.132,0-0.264,0.005-0.395,0.015l-0.974-1.002c-0.255,0.053-0.506,0.12-0.75,0.201l-0.343,1.354c-0.238,0.115-0.466,0.248-0.684,0.395l-1.342-0.379c-0.193,0.173-0.377,0.356-0.55,0.551l0.379,1.342c-0.147,0.218-0.279,0.446-0.396,0.684l-1.354,0.344c-0.08,0.244-0.147,0.494-0.2,0.75l1.001,0.975c-0.009,0.13-0.014,0.262-0.014,0.395c0,0.132,0.005,0.264,0.014,0.394l-1.001,0.975c0.053,0.256,0.12,0.506,0.2,0.751l1.354,0.342c0.116,0.238,0.248,0.467,0.396,0.685l-0.379,1.342c0.172,0.194,0.356,0.378,0.55,0.551l1.342-0.379c0.218,0.147,0.446,0.279,0.684,0.396l0.343,1.353c0.245,0.081,0.495,0.148,0.75,0.201l0.975-1.001c0.129,0.009,0.261,0.014,0.394,0.014c0.133,0,0.264-0.005,0.395-0.014l0.974,1.001c0.255-0.053,0.506-0.12,0.75-0.201l0.343-1.353c0.238-0.116,0.467-0.248,0.684-0.396l1.342,0.379c0.194-0.173,0.377-0.356,0.55-0.551l-0.379-1.342c0.147-0.218,0.279-0.446,0.396-0.685l1.353-0.342c0.081-0.245,0.148-0.495,0.201-0.751l-1.001-0.975C47.477,92.702,47.482,92.57,47.482,92.438z"/><circle fill="#B2B2B2" cx="41.86" cy="92.438" r="3.499"/><circle fill="#DADADA" cx="41.86" cy="92.438" r="2.389"/></g></g><path class="colorful c2" fill="'.$svg['bike']['colors'][1].'" d="M82.064,81.426C77.235,63.752,61.066,50.76,41.86,50.76c-22.774,0-41.671,18.263-41.671,40.949c0,0.479,0.321,0.729,0.787,0.729h4.002c0-20.369,16.512-36.882,36.881-36.882c17.158,0,31.578,11.718,35.698,27.587c0.125,0.48,0.336,0.68,0.626,0.522L82.064,81.426z"/></g><g><g><path d="M160.934,53.875c-21.299,0-38.563,17.266-38.563,38.563s17.265,38.562,38.563,38.562c21.298,0,38.562-17.265,38.562-38.562S182.231,53.875,160.934,53.875z M160.934,126.211c-18.652,0-33.772-15.121-33.772-33.772c0-18.652,15.12-33.772,33.772-33.772c18.651,0,33.771,15.12,33.771,33.772C194.705,111.09,179.585,126.211,160.934,126.211z"/><path fill="#EDEDED" d="M160.934,57.362c-19.372,0-35.076,15.704-35.076,35.076s15.704,35.076,35.076,35.076c19.371,0,35.075-15.704,35.075-35.076S180.305,57.362,160.934,57.362z M160.934,126.211c-18.652,0-33.772-15.121-33.772-33.772c0-18.652,15.12-33.772,33.772-33.772c18.651,0,33.771,15.12,33.771,33.772C194.705,111.09,179.585,126.211,160.934,126.211z"/><g><g><rect x="160.934" y="88.761" width="34.14" height="0.243"/><rect x="160.934" y="95.871" width="34.14" height="0.243"/></g><g><rect x="173.817" y="63.754" transform="matrix(0.5009 0.8655 -0.8655 0.5009 156.7715 -110.2061)" width="0.244" height="34.14"/><rect x="177.372" y="69.912" transform="matrix(0.4979 0.8673 -0.8673 0.4979 164.5607 -110.2555)" width="0.243" height="34.139"/></g><g><rect x="166.268" y="58.807" transform="matrix(0.8673 0.4979 -0.4979 0.8673 59.8644 -72.7676)" width="0.243" height="34.14"/><rect x="172.425" y="62.362" transform="matrix(0.8673 0.4979 -0.4979 0.8673 62.452 -75.3611)" width="0.243" height="34.14"/></g><g><rect x="157.257" y="58.298" width="0.243" height="34.141"/><rect x="164.367" y="58.298" width="0.242" height="34.141"/></g><g><rect x="132.249" y="79.311" transform="matrix(0.5 0.866 -0.866 0.5 143.4497 -89.598)" width="34.14" height="0.243"/><rect x="138.407" y="75.756" transform="matrix(0.5 0.866 -0.866 0.5 143.4521 -96.7083)" width="34.14" height="0.243"/></g><g><rect x="127.302" y="86.86" transform="matrix(0.866 0.5 -0.5 0.866 62.8337 -60.5332)" width="34.14" height="0.243"/><rect x="130.857" y="80.703" transform="matrix(0.866 0.5 -0.5 0.866 60.2347 -63.138)" width="34.141" height="0.242"/></g><g><rect x="126.793" y="95.872" width="34.141" height="0.243"/><rect x="126.793" y="88.761" width="34.141" height="0.243"/></g><g><rect x="147.806" y="86.982" transform="matrix(0.4979 0.8673 -0.8673 0.4979 164.5185 -76.043)" width="0.243" height="34.14"/><rect x="144.251" y="80.824" transform="matrix(0.5026 0.8645 -0.8645 0.5026 156.4381 -76.1206)" width="0.243" height="34.14"/></g><g><rect x="155.355" y="91.929" transform="matrix(0.8663 0.4996 -0.4996 0.8663 75.2512 -63.0987)" width="0.242" height="34.14"/><rect x="149.198" y="88.373" transform="matrix(0.8673 0.4979 -0.4979 0.8673 72.3185 -60.344)" width="0.243" height="34.14"/></g><g><rect x="164.367" y="92.438" width="0.242" height="34.14"/><rect x="157.257" y="92.438" width="0.243" height="34.14"/></g><g><rect x="155.477" y="105.322" transform="matrix(0.5 0.866 -0.866 0.5 177.5894 -96.7083)" width="34.14" height="0.243"/><rect x="149.319" y="108.877" transform="matrix(0.5 0.866 -0.866 0.5 177.59 -89.5982)" width="34.14" height="0.243"/></g><g><rect x="160.424" y="97.772" transform="matrix(0.866 0.5 -0.5 0.866 72.7255 -75.6308)" width="34.139" height="0.243"/><rect x="156.869" y="103.93" transform="matrix(0.866 0.5 -0.5 0.866 75.3299 -73.0295)" width="34.14" height="0.244"/></g></g><path fill="#878787" d="M129.466,106.215l0.247,0.429l1.9-1.098l-0.247-0.428L129.466,106.215z M133.021,112.373l0.246,0.428l1.901-1.097l-0.247-0.429L133.021,112.373z M129.466,78.661l1.9,1.097l0.247-0.428l-1.9-1.097L129.466,78.661z M133.021,72.503l1.901,1.098l0.247-0.428l-1.901-1.098L133.021,72.503z M140.57,64.773l1.097,1.901l0.429-0.247l-1.098-1.901L140.57,64.773zM140.57,120.104l0.428,0.247l1.098-1.901l-0.429-0.247L140.57,120.104z M126.793,96.24h2.194v-0.494h-2.194V96.24zM126.793,89.13h2.195v-0.494h-2.195V89.13z M195.073,88.636h-2.194v0.494h2.194V88.636z M188.846,72.503l-0.247-0.428l-1.901,1.098l0.248,0.428L188.846,72.503z M175.138,61.218l-0.428-0.247l-1.097,1.901l0.428,0.247L175.138,61.218zM146.728,123.658l0.429,0.247l1.097-1.9l-0.428-0.247L146.728,123.658z M179.771,118.45l1.098,1.9l0.428-0.247l-1.097-1.9L179.771,118.45z M190.253,105.546l1.901,1.098l0.246-0.428l-1.9-1.098L190.253,105.546z M186.697,111.704l1.901,1.097l0.247-0.428l-1.901-1.097L186.697,111.704z M179.771,66.427l0.429,0.247l1.098-1.901l-0.429-0.247L179.771,66.427zM146.728,61.218l1.098,1.9l0.428-0.247l-1.097-1.901L146.728,61.218z M192.879,96.24h2.194v-0.494h-2.194V96.24zM190.253,79.331l0.247,0.427l1.9-1.097l-0.246-0.428L190.253,79.331z M157.131,126.578h0.494v-2.194h-0.494V126.578zM157.131,60.493h0.494v-2.195h-0.494V60.493z M164.241,60.493h0.494v-2.195h-0.494V60.493z M164.241,126.578h0.494v-2.194h-0.494V126.578z M173.613,122.005l1.097,1.9l0.429-0.247l-1.098-1.9L173.613,122.005z"/></g><circle fill="#DADADA" cx="160.934" cy="92.438" r="4.25"/><circle fill="#B2B2B2" cx="160.934" cy="92.438" r="2.389"/><path class="colorful c2" fill="'.$svg['bike']['colors'][1].'" d="M172.938,53.713c0.158-0.619,0.136-1.168-0.737-1.409c-3.588-0.988-7.362-1.543-11.268-1.543c-22.774,0-41.671,18.263-41.671,40.949c0,0.479,0.32,0.729,0.787,0.729h4.003c0-20.369,16.513-36.882,36.881-36.882c3.713,0,7.298,0.55,10.678,1.571L172.938,53.713z"/></g><g><path fill="#DADADA" d="M107.816,97.323c0.054-0.176,0.105-0.354,0.151-0.533c0.045-0.179,0.085-0.357,0.123-0.535l-1.224-0.649c0.025-0.152,0.048-0.305,0.067-0.456l1.359-0.27c0.033-0.367,0.05-0.735,0.049-1.1l-1.333-0.381c-0.008-0.155-0.017-0.309-0.03-0.462l1.272-0.545c-0.044-0.367-0.105-0.729-0.184-1.088l-1.383-0.094c-0.037-0.15-0.079-0.299-0.123-0.446l1.131-0.797c-0.119-0.348-0.256-0.69-0.407-1.025l-1.371,0.194c-0.068-0.137-0.14-0.273-0.214-0.407l0.942-1.017c-0.189-0.316-0.392-0.623-0.609-0.919l-1.302,0.475c-0.097-0.12-0.195-0.238-0.295-0.355l0.709-1.188c-0.249-0.269-0.512-0.526-0.787-0.772l-1.173,0.734c-0.119-0.098-0.239-0.194-0.363-0.287l0.448-1.312c-0.3-0.21-0.611-0.406-0.932-0.59l-0.995,0.964c-0.137-0.071-0.274-0.14-0.415-0.205l0.166-1.377c-0.336-0.143-0.682-0.269-1.035-0.381l-0.773,1.149c-0.074-0.021-0.148-0.041-0.222-0.06c-0.075-0.02-0.15-0.038-0.225-0.056l-0.125-1.38c-0.364-0.07-0.728-0.126-1.09-0.163l-0.518,1.286c-0.154-0.01-0.309-0.017-0.462-0.02l-0.409-1.323c-0.37,0.006-0.737,0.028-1.1,0.068l-0.239,1.365c-0.153,0.022-0.305,0.048-0.457,0.077l-0.674-1.209c-0.359,0.084-0.714,0.183-1.062,0.299l0.05,1.383c-0.144,0.055-0.287,0.11-0.428,0.171l-0.914-1.044c-0.333,0.155-0.659,0.326-0.977,0.513l0.337,1.344c-0.129,0.083-0.257,0.168-0.384,0.255l-1.108-0.83c-0.294,0.221-0.578,0.455-0.852,0.703l0.609,1.243c-0.11,0.107-0.218,0.218-0.324,0.33l-1.256-0.581c-0.241,0.275-0.469,0.564-0.685,0.864l0.853,1.089c-0.085,0.129-0.167,0.259-0.249,0.392l-1.351-0.308c-0.177,0.319-0.339,0.649-0.487,0.988l1.062,0.889c-0.056,0.143-0.109,0.287-0.161,0.434l-1.385-0.021c-0.053,0.175-0.104,0.351-0.15,0.529c-0.046,0.18-0.086,0.36-0.124,0.54l1.224,0.648c-0.025,0.152-0.048,0.305-0.067,0.457l-1.358,0.268c-0.033,0.369-0.05,0.736-0.049,1.102l1.332,0.38c0.007,0.155,0.017,0.31,0.03,0.462l-1.271,0.545c0.045,0.366,0.106,0.729,0.185,1.087l1.38,0.095c0.039,0.15,0.08,0.299,0.125,0.445l-1.132,0.797c0.12,0.35,0.257,0.691,0.408,1.026l1.371-0.195c0.068,0.139,0.141,0.274,0.214,0.409l-0.942,1.016c0.189,0.315,0.392,0.623,0.609,0.919l1.303-0.475c0.094,0.12,0.192,0.238,0.292,0.355l-0.709,1.188c0.25,0.269,0.513,0.526,0.788,0.772l1.172-0.735c0.119,0.099,0.24,0.194,0.363,0.288l-0.448,1.311c0.3,0.211,0.611,0.407,0.932,0.59l0.995-0.963c0.135,0.071,0.274,0.14,0.415,0.205l-0.165,1.377c0.335,0.143,0.681,0.27,1.034,0.382l0.773-1.15c0.075,0.021,0.148,0.041,0.224,0.06c0.074,0.02,0.149,0.038,0.224,0.056l0.125,1.38c0.364,0.071,0.728,0.127,1.09,0.163l0.517-1.286c0.155,0.01,0.309,0.017,0.462,0.02l0.409,1.323c0.37-0.006,0.737-0.028,1.101-0.067l0.239-1.366c0.153-0.021,0.305-0.048,0.457-0.077l0.675,1.208c0.358-0.083,0.713-0.183,1.062-0.298l-0.05-1.383c0.144-0.055,0.287-0.111,0.43-0.171l0.911,1.044c0.334-0.156,0.66-0.328,0.978-0.513l-0.337-1.344c0.13-0.082,0.258-0.168,0.384-0.256l1.107,0.83c0.295-0.221,0.578-0.455,0.852-0.703l-0.609-1.243c0.11-0.106,0.219-0.218,0.324-0.33l1.256,0.581c0.241-0.275,0.47-0.564,0.686-0.864l-0.854-1.089c0.086-0.128,0.168-0.258,0.248-0.391l1.352,0.308c0.177-0.319,0.339-0.649,0.487-0.988l-1.062-0.889c0.056-0.143,0.109-0.288,0.16-0.434L107.816,97.323z M97.717,84.895l-1.536,5.987c-0.895,0.077-1.712,0.561-2.211,1.308l-5.987-1.534C89.468,86.695,93.532,84.291,97.717,84.895z M93.256,102.289c-3.959-1.484-6.364-5.548-5.76-9.733l5.986,1.535c0.078,0.896,0.562,1.713,1.309,2.211L93.256,102.289z M96.126,95.046c-0.668-0.172-1.071-0.853-0.899-1.521s0.852-1.071,1.52-0.899c0.668,0.171,1.071,0.852,0.899,1.52C97.476,94.813,96.795,95.217,96.126,95.046z M95.157,102.776l1.536-5.986c0.895-0.078,1.712-0.562,2.211-1.309l5.987,1.535C103.406,100.976,99.342,103.38,95.157,102.776z M99.391,93.58c-0.078-0.895-0.562-1.713-1.309-2.211l1.536-5.987c3.958,1.484,6.363,5.549,5.76,9.733L99.391,93.58z"/><g><g><g><g><path fill="#EDEDED" d="M43.574,85.692c0.032,0.61-0.437,1.132-1.048,1.163c-0.533,0.028-0.886-0.291-1.195-0.274c-0.31,0.016-0.627,0.37-1.161,0.398c-0.611,0.032-1.131-0.438-1.164-1.048s0.437-1.132,1.048-1.164c0.534-0.028,0.886,0.292,1.196,0.275c0.31-0.017,0.626-0.37,1.16-0.398C43.021,84.612,43.542,85.082,43.574,85.692z"/></g><g><path fill="#EDEDED" d="M48.142,85.453c0.032,0.61-0.437,1.132-1.048,1.163c-0.534,0.028-0.886-0.291-1.196-0.274c-0.31,0.016-0.627,0.37-1.16,0.398c-0.611,0.032-1.132-0.438-1.164-1.048s0.437-1.132,1.048-1.164c0.534-0.028,0.886,0.291,1.196,0.275c0.31-0.017,0.626-0.371,1.161-0.398C47.589,84.373,48.11,84.842,48.142,85.453z"/></g><g><path fill="#EDEDED" d="M45.858,85.572c0.032,0.611-0.438,1.132-1.048,1.164c-0.534,0.028-0.886-0.291-1.196-0.275c-0.31,0.017-0.627,0.371-1.161,0.399c-0.61,0.031-1.132-0.438-1.164-1.049c-0.032-0.61,0.437-1.132,1.048-1.163c0.534-0.028,0.886,0.291,1.196,0.274c0.31-0.016,0.626-0.37,1.16-0.398C45.305,84.493,45.826,84.962,45.858,85.572z"/><circle fill="#DADADA" cx="42.391" cy="85.754" r="0.488"/><circle fill="#DADADA" cx="44.758" cy="85.63" r="0.488"/></g><g><path fill="#EDEDED" d="M41.261,85.705c0.104,0.603-0.302,1.175-0.904,1.278c-0.527,0.09-0.914-0.186-1.22-0.134c-0.306,0.053-0.579,0.441-1.106,0.531c-0.603,0.104-1.175-0.302-1.278-0.904c-0.103-0.603,0.302-1.175,0.905-1.278c0.527-0.09,0.914,0.186,1.22,0.134c0.306-0.053,0.579-0.441,1.106-0.532C40.585,84.697,41.158,85.102,41.261,85.705z"/><circle fill="#DADADA" cx="37.839" cy="86.291" r="0.488"/><circle fill="#DADADA" cx="40.175" cy="85.891" r="0.487"/></g></g><g><g><path fill="#EDEDED" d="M52.709,85.214c0.032,0.61-0.437,1.131-1.048,1.163c-0.534,0.028-0.886-0.291-1.195-0.274c-0.31,0.016-0.627,0.37-1.161,0.398c-0.611,0.031-1.132-0.438-1.164-1.048c-0.032-0.611,0.437-1.132,1.048-1.164c0.534-0.028,0.886,0.291,1.196,0.275c0.31-0.017,0.626-0.371,1.16-0.399C52.157,84.134,52.678,84.603,52.709,85.214z"/></g><g><path fill="#EDEDED" d="M57.277,84.974c0.032,0.611-0.437,1.132-1.048,1.164c-0.534,0.028-0.886-0.291-1.196-0.275c-0.31,0.017-0.626,0.371-1.161,0.399c-0.61,0.031-1.131-0.438-1.164-1.048c-0.032-0.611,0.437-1.132,1.048-1.164c0.534-0.028,0.886,0.291,1.196,0.275c0.31-0.017,0.626-0.371,1.16-0.399C56.724,83.895,57.245,84.363,57.277,84.974z"/></g><g><path fill="#EDEDED" d="M54.993,85.094c0.032,0.61-0.437,1.132-1.048,1.164c-0.533,0.027-0.886-0.292-1.195-0.275s-0.627,0.37-1.161,0.398c-0.611,0.032-1.132-0.437-1.164-1.048c-0.032-0.61,0.437-1.132,1.048-1.164c0.534-0.027,0.886,0.292,1.196,0.275c0.31-0.016,0.626-0.37,1.16-0.398C54.44,84.014,54.961,84.483,54.993,85.094z"/><circle fill="#DADADA" cx="51.526" cy="85.275" r="0.487"/><circle fill="#DADADA" cx="53.893" cy="85.151" r="0.487"/></g><g><path fill="#EDEDED" d="M50.426,85.333c0.032,0.611-0.437,1.132-1.048,1.164c-0.534,0.027-0.886-0.292-1.196-0.275c-0.31,0.017-0.626,0.371-1.16,0.398c-0.611,0.032-1.132-0.437-1.164-1.048c-0.032-0.61,0.437-1.132,1.048-1.163c0.533-0.028,0.886,0.291,1.195,0.274c0.31-0.016,0.627-0.37,1.161-0.398C49.873,84.253,50.394,84.723,50.426,85.333z"/><circle fill="#DADADA" cx="46.958" cy="85.515" r="0.487"/><circle fill="#DADADA" cx="49.326" cy="85.391" r="0.487"/></g></g><g><g><path fill="#EDEDED" d="M61.845,84.734c0.032,0.611-0.437,1.132-1.048,1.164c-0.534,0.028-0.886-0.291-1.195-0.275c-0.31,0.017-0.627,0.371-1.161,0.399c-0.611,0.031-1.132-0.438-1.164-1.049c-0.032-0.61,0.437-1.131,1.048-1.163c0.533-0.028,0.886,0.291,1.195,0.274c0.31-0.016,0.627-0.37,1.161-0.398C61.292,83.655,61.813,84.124,61.845,84.734z"/></g><g><path fill="#EDEDED" d="M66.412,84.495c0.032,0.611-0.437,1.132-1.047,1.164c-0.534,0.027-0.886-0.291-1.196-0.275c-0.31,0.017-0.627,0.371-1.161,0.398c-0.611,0.032-1.131-0.437-1.164-1.048c-0.032-0.61,0.437-1.132,1.048-1.163c0.534-0.028,0.886,0.291,1.196,0.274c0.31-0.016,0.626-0.37,1.16-0.398C65.859,83.415,66.38,83.885,66.412,84.495z"/></g><g><path fill="#EDEDED" d="M64.129,84.615c0.032,0.61-0.438,1.132-1.048,1.163c-0.534,0.028-0.886-0.291-1.196-0.274s-0.627,0.37-1.161,0.398c-0.611,0.032-1.132-0.438-1.164-1.048s0.437-1.132,1.048-1.164c0.534-0.027,0.886,0.291,1.196,0.275c0.31-0.017,0.626-0.371,1.16-0.398C63.576,83.535,64.097,84.005,64.129,84.615z"/><circle fill="#DADADA" cx="60.661" cy="84.797" r="0.488"/><circle fill="#DADADA" cx="63.029" cy="84.673" r="0.488"/></g><g><path fill="#EDEDED" d="M59.561,84.854c0.032,0.61-0.437,1.132-1.048,1.164c-0.534,0.027-0.886-0.292-1.196-0.275s-0.626,0.37-1.16,0.398c-0.611,0.032-1.132-0.438-1.164-1.048c-0.032-0.61,0.438-1.132,1.048-1.164c0.534-0.027,0.886,0.292,1.196,0.275s0.626-0.371,1.161-0.398C59.008,83.774,59.529,84.244,59.561,84.854z"/><circle fill="#DADADA" cx="56.094" cy="85.036" r="0.488"/><circle fill="#DADADA" cx="58.461" cy="84.912" r="0.488"/></g></g><g><g><path fill="#EDEDED" d="M70.98,84.256c0.032,0.61-0.437,1.132-1.048,1.164c-0.534,0.027-0.886-0.292-1.196-0.275s-0.626,0.371-1.16,0.398c-0.611,0.032-1.132-0.437-1.164-1.048c-0.032-0.61,0.438-1.132,1.048-1.164c0.534-0.027,0.886,0.292,1.196,0.275c0.31-0.016,0.626-0.37,1.161-0.398C70.427,83.176,70.948,83.646,70.98,84.256z"/></g><g><path fill="#EDEDED" d="M75.547,84.017c0.032,0.61-0.437,1.132-1.048,1.164c-0.534,0.027-0.886-0.292-1.195-0.275s-0.627,0.371-1.161,0.398c-0.611,0.032-1.132-0.438-1.164-1.048s0.437-1.132,1.048-1.164c0.534-0.027,0.886,0.292,1.196,0.275c0.31-0.016,0.626-0.37,1.16-0.398C74.995,82.937,75.516,83.406,75.547,84.017z"/></g><g><path fill="#EDEDED" d="M73.264,84.136c0.032,0.611-0.437,1.132-1.048,1.164c-0.534,0.028-0.886-0.291-1.195-0.274c-0.31,0.016-0.627,0.37-1.161,0.398c-0.611,0.032-1.132-0.438-1.164-1.048c-0.032-0.611,0.437-1.132,1.048-1.164c0.533-0.028,0.886,0.291,1.195,0.275c0.31-0.017,0.627-0.371,1.161-0.398C72.711,83.057,73.232,83.525,73.264,84.136z"/><circle fill="#DADADA" cx="69.796" cy="84.318" r="0.488"/><circle fill="#DADADA" cx="72.164" cy="84.194" r="0.487"/></g><g><path fill="#EDEDED" d="M68.696,84.376c0.032,0.61-0.437,1.131-1.048,1.163c-0.534,0.028-0.886-0.291-1.196-0.274c-0.31,0.016-0.626,0.37-1.161,0.398c-0.61,0.031-1.131-0.438-1.163-1.048c-0.032-0.61,0.437-1.132,1.047-1.164c0.534-0.027,0.886,0.291,1.196,0.275c0.31-0.017,0.627-0.371,1.16-0.398C68.143,83.296,68.664,83.765,68.696,84.376z"/><circle fill="#DADADA" cx="65.229" cy="84.558" r="0.488"/><circle fill="#DADADA" cx="67.596" cy="84.434" r="0.488"/></g></g><g><g><path fill="#EDEDED" d="M80.115,83.777c0.032,0.61-0.438,1.132-1.048,1.163c-0.534,0.028-0.886-0.291-1.196-0.274c-0.31,0.016-0.626,0.37-1.161,0.398c-0.61,0.032-1.132-0.438-1.164-1.048s0.437-1.132,1.048-1.164c0.534-0.027,0.886,0.291,1.196,0.275s0.626-0.371,1.16-0.398C79.562,82.697,80.083,83.167,80.115,83.777z"/></g><g><path fill="#EDEDED" d="M84.683,83.538c0.032,0.61-0.437,1.131-1.048,1.163c-0.534,0.028-0.886-0.291-1.195-0.274c-0.31,0.016-0.627,0.37-1.161,0.398c-0.611,0.032-1.132-0.438-1.164-1.048c-0.032-0.61,0.437-1.132,1.048-1.164c0.533-0.028,0.886,0.291,1.195,0.275c0.31-0.017,0.627-0.371,1.16-0.399C84.13,82.458,84.65,82.927,84.683,83.538z"/></g><g><path fill="#EDEDED" d="M82.399,83.657c0.032,0.611-0.437,1.132-1.048,1.164c-0.534,0.027-0.886-0.292-1.196-0.275s-0.627,0.371-1.16,0.398c-0.611,0.032-1.132-0.437-1.164-1.048c-0.032-0.61,0.437-1.131,1.048-1.163c0.534-0.028,0.886,0.291,1.196,0.274c0.31-0.016,0.626-0.37,1.161-0.398C81.846,82.578,82.367,83.047,82.399,83.657z"/><circle fill="#DADADA" cx="78.931" cy="83.839" r="0.488"/><circle fill="#DADADA" cx="81.299" cy="83.715" r="0.488"/></g><g><path fill="#EDEDED" d="M77.831,83.896c0.032,0.611-0.437,1.132-1.047,1.164c-0.534,0.028-0.886-0.291-1.196-0.275c-0.31,0.017-0.627,0.371-1.16,0.399c-0.611,0.031-1.132-0.438-1.164-1.049c-0.032-0.61,0.437-1.131,1.048-1.163c0.534-0.028,0.886,0.291,1.195,0.274c0.31-0.016,0.627-0.37,1.161-0.398C77.278,82.817,77.799,83.286,77.831,83.896z"/><circle fill="#DADADA" cx="74.364" cy="84.079" r="0.488"/><circle fill="#DADADA" cx="76.731" cy="83.954" r="0.487"/></g></g><g><g><path fill="#EDEDED" d="M89.25,83.298c0.032,0.611-0.437,1.133-1.048,1.164c-0.534,0.028-0.886-0.291-1.195-0.275c-0.31,0.017-0.627,0.371-1.161,0.399c-0.611,0.031-1.132-0.438-1.164-1.048c-0.032-0.611,0.437-1.132,1.048-1.164c0.534-0.028,0.886,0.291,1.195,0.275c0.31-0.017,0.627-0.371,1.161-0.398C88.697,82.219,89.218,82.688,89.25,83.298z"/></g><g><path fill="#EDEDED" d="M93.817,83.059c0.032,0.611-0.437,1.132-1.047,1.164c-0.534,0.028-0.886-0.291-1.196-0.275c-0.31,0.017-0.627,0.371-1.16,0.399c-0.611,0.031-1.132-0.438-1.164-1.049c-0.032-0.61,0.437-1.131,1.048-1.163c0.534-0.028,0.886,0.291,1.196,0.275c0.31-0.017,0.626-0.371,1.16-0.398C93.265,81.979,93.786,82.448,93.817,83.059z"/></g><g><path fill="#EDEDED" d="M91.534,83.179c0.032,0.61-0.438,1.132-1.048,1.164c-0.534,0.027-0.886-0.292-1.196-0.275s-0.627,0.371-1.161,0.398c-0.611,0.032-1.131-0.437-1.164-1.048c-0.032-0.61,0.437-1.132,1.048-1.164c0.534-0.027,0.886,0.292,1.196,0.275c0.31-0.016,0.626-0.37,1.16-0.398C90.981,82.099,91.502,82.568,91.534,83.179z"/><circle fill="#DADADA" cx="88.067" cy="83.36" r="0.488"/><circle fill="#DADADA" cx="90.434" cy="83.236" r="0.487"/></g><g><path fill="#EDEDED" d="M86.966,83.418c0.032,0.611-0.437,1.132-1.048,1.164c-0.533,0.027-0.886-0.292-1.196-0.275s-0.626,0.371-1.16,0.398c-0.611,0.032-1.132-0.437-1.164-1.048c-0.032-0.61,0.437-1.131,1.048-1.163c0.534-0.028,0.886,0.291,1.195,0.274c0.31-0.016,0.627-0.37,1.161-0.398C86.414,82.339,86.934,82.808,86.966,83.418z"/><circle fill="#DADADA" cx="83.499" cy="83.6" r="0.488"/><circle fill="#DADADA" cx="85.866" cy="83.476" r="0.488"/></g></g><g><g><path fill="#EDEDED" d="M98.367,82.515c0.083,0.605-0.34,1.165-0.945,1.249c-0.53,0.073-0.908-0.216-1.215-0.173c-0.308,0.043-0.593,0.423-1.123,0.496c-0.605,0.084-1.165-0.34-1.249-0.945c-0.084-0.606,0.339-1.165,0.945-1.249c0.529-0.073,0.908,0.215,1.215,0.173c0.307-0.043,0.593-0.423,1.123-0.496C97.724,81.485,98.283,81.909,98.367,82.515z"/></g><g><path fill="#EDEDED" d="M102.762,83.019c-0.076,0.607-0.631,1.036-1.237,0.96c-0.53-0.067-0.82-0.443-1.128-0.482c-0.307-0.039-0.682,0.253-1.212,0.187c-0.607-0.077-1.037-0.631-0.959-1.237c0.077-0.607,0.63-1.037,1.237-0.96c0.53,0.067,0.82,0.443,1.127,0.482c0.308,0.039,0.683-0.254,1.213-0.187C102.409,81.858,102.838,82.412,102.762,83.019z"/></g><g><path fill="#EDEDED" d="M100.669,82.524c0.032,0.61-0.437,1.132-1.048,1.163c-0.533,0.028-0.886-0.291-1.195-0.274c-0.31,0.016-0.627,0.37-1.161,0.398c-0.611,0.031-1.132-0.438-1.164-1.048c-0.032-0.611,0.437-1.132,1.048-1.164c0.533-0.027,0.886,0.292,1.195,0.275c0.31-0.017,0.627-0.37,1.161-0.398C100.116,81.444,100.637,81.913,100.669,82.524z"/><circle fill="#DADADA" cx="97.202" cy="82.706" r="0.487"/><circle fill="#DADADA" cx="99.569" cy="82.582" r="0.487"/></g><g><path fill="#EDEDED" d="M96.102,82.939c0.032,0.61-0.437,1.132-1.048,1.164c-0.534,0.027-0.886-0.292-1.196-0.275s-0.626,0.37-1.16,0.398c-0.611,0.032-1.132-0.438-1.164-1.048c-0.032-0.61,0.437-1.132,1.048-1.164c0.533-0.027,0.886,0.292,1.195,0.275s0.627-0.37,1.16-0.398C95.549,81.859,96.07,82.329,96.102,82.939z"/><circle fill="#DADADA" cx="92.634" cy="83.121" r="0.487"/><circle fill="#DADADA" cx="95.001" cy="82.997" r="0.488"/></g></g></g><g><g><g><path fill="#EDEDED" d="M43.747,99.858c0.136-0.596-0.236-1.189-0.832-1.326c-0.521-0.119-0.923,0.135-1.226,0.064c-0.302-0.068-0.554-0.472-1.075-0.592c-0.596-0.136-1.189,0.236-1.326,0.833c-0.137,0.596,0.236,1.189,0.832,1.326c0.521,0.119,0.923-0.135,1.225-0.065c0.303,0.069,0.554,0.473,1.075,0.592C43.016,100.827,43.61,100.455,43.747,99.858z"/></g><g><path fill="#EDEDED" d="M48.331,100.202c0.072-0.607-0.362-1.158-0.97-1.229c-0.531-0.063-0.903,0.232-1.21,0.196c-0.309-0.037-0.602-0.411-1.132-0.474c-0.607-0.072-1.158,0.362-1.23,0.97c-0.072,0.607,0.362,1.157,0.97,1.229c0.531,0.062,0.903-0.233,1.211-0.196c0.308,0.036,0.601,0.41,1.132,0.474C47.708,101.243,48.259,100.81,48.331,100.202z"/></g><g><path fill="#EDEDED" d="M46.06,99.934c0.072-0.607-0.362-1.158-0.97-1.229c-0.531-0.063-0.903,0.232-1.211,0.195c-0.308-0.036-0.601-0.41-1.132-0.473c-0.607-0.072-1.158,0.361-1.23,0.969s0.362,1.158,0.97,1.23c0.531,0.062,0.903-0.233,1.211-0.196c0.308,0.036,0.601,0.41,1.132,0.474C45.437,100.975,45.988,100.541,46.06,99.934z"/><circle fill="#DADADA" cx="42.611" cy="99.525" r="0.488"/><circle fill="#DADADA" cx="44.965" cy="99.804" r="0.487"/></g><g><path fill="#EDEDED" d="M41.485,99.55c0.245-0.561-0.01-1.213-0.57-1.459c-0.49-0.215-0.932-0.04-1.216-0.164c-0.284-0.125-0.456-0.568-0.945-0.783c-0.56-0.245-1.213,0.01-1.458,0.57c-0.246,0.56,0.01,1.213,0.57,1.458c0.489,0.215,0.932,0.04,1.216,0.165c0.284,0.124,0.456,0.567,0.945,0.782C40.586,100.364,41.239,100.109,41.485,99.55z"/><circle fill="#DADADA" cx="38.304" cy="98.156" r="0.488"/><circle fill="#DADADA" cx="40.476" cy="99.107" r="0.487"/></g></g><g><g><path fill="#EDEDED" d="M52.873,100.74c0.072-0.607-0.362-1.158-0.969-1.23c-0.531-0.062-0.903,0.233-1.211,0.196c-0.308-0.036-0.602-0.41-1.132-0.474c-0.607-0.071-1.158,0.362-1.229,0.97s0.362,1.158,0.969,1.229c0.531,0.063,0.903-0.232,1.211-0.196c0.308,0.037,0.602,0.411,1.132,0.474C52.25,101.781,52.801,101.348,52.873,100.74z"/></g><g><path fill="#EDEDED" d="M57.415,101.277c0.072-0.607-0.362-1.157-0.969-1.229c-0.53-0.063-0.903,0.232-1.211,0.196c-0.308-0.037-0.601-0.411-1.132-0.474c-0.607-0.072-1.158,0.362-1.23,0.97s0.362,1.157,0.969,1.229c0.531,0.062,0.903-0.232,1.211-0.196s0.601,0.41,1.132,0.474C56.792,102.319,57.343,101.885,57.415,101.277z"/></g><g><path fill="#EDEDED" d="M55.144,101.009c0.071-0.607-0.362-1.158-0.97-1.229c-0.531-0.063-0.903,0.232-1.211,0.195c-0.308-0.036-0.601-0.41-1.132-0.473c-0.607-0.072-1.158,0.361-1.229,0.969s0.362,1.158,0.97,1.23c0.53,0.062,0.903-0.233,1.211-0.196c0.308,0.036,0.601,0.41,1.132,0.473C54.521,102.05,55.072,101.616,55.144,101.009z"/><circle fill="#DADADA" cx="51.696" cy="100.6" r="0.488"/><circle fill="#DADADA" cx="54.05" cy="100.879" r="0.488"/></g><g><path fill="#EDEDED" d="M50.602,100.471c0.072-0.607-0.362-1.157-0.969-1.229c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.036-0.601-0.411-1.132-0.474c-0.607-0.072-1.158,0.362-1.229,0.97s0.362,1.157,0.969,1.229c0.531,0.062,0.903-0.232,1.211-0.196c0.308,0.036,0.601,0.41,1.132,0.474C49.979,101.513,50.53,101.078,50.602,100.471z"/><circle fill="#DADADA" cx="47.154" cy="100.063" r="0.487"/><circle fill="#DADADA" cx="49.508" cy="100.341" r="0.487"/></g></g><g><g><path fill="#EDEDED" d="M61.957,101.815c0.072-0.607-0.362-1.158-0.969-1.23c-0.531-0.062-0.903,0.233-1.211,0.196c-0.308-0.036-0.601-0.41-1.132-0.474c-0.607-0.071-1.158,0.362-1.23,0.97c-0.072,0.607,0.362,1.158,0.97,1.229c0.531,0.063,0.903-0.232,1.211-0.195c0.308,0.035,0.601,0.41,1.132,0.473C61.334,102.856,61.885,102.422,61.957,101.815z"/></g><g><path fill="#EDEDED" d="M66.499,102.353c0.072-0.607-0.362-1.158-0.969-1.229c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.037-0.601-0.411-1.132-0.474c-0.607-0.072-1.158,0.362-1.229,0.97c-0.072,0.606,0.362,1.157,0.97,1.229c0.53,0.062,0.903-0.232,1.211-0.196c0.308,0.036,0.601,0.411,1.132,0.474C65.877,103.395,66.427,102.96,66.499,102.353z"/></g><g><path fill="#EDEDED" d="M64.228,102.084c0.072-0.607-0.362-1.158-0.969-1.229c-0.531-0.063-0.903,0.232-1.211,0.195c-0.308-0.036-0.602-0.41-1.132-0.473c-0.608-0.072-1.158,0.361-1.23,0.969s0.362,1.158,0.969,1.23c0.531,0.062,0.903-0.233,1.211-0.197c0.308,0.037,0.601,0.411,1.131,0.475C63.605,103.125,64.156,102.691,64.228,102.084z"/><circle fill="#DADADA" cx="60.78" cy="101.676" r="0.488"/><circle fill="#DADADA" cx="63.134" cy="101.954" r="0.488"/></g><g><path fill="#EDEDED" d="M59.686,101.546c0.072-0.607-0.362-1.157-0.97-1.229c-0.53-0.063-0.903,0.232-1.211,0.196c-0.308-0.036-0.601-0.411-1.131-0.474c-0.607-0.071-1.158,0.362-1.229,0.97c-0.072,0.607,0.362,1.157,0.969,1.229c0.531,0.062,0.903-0.232,1.211-0.196c0.308,0.037,0.601,0.41,1.132,0.474C59.063,102.588,59.614,102.153,59.686,101.546z"/><circle fill="#DADADA" cx="56.238" cy="101.138" r="0.487"/><circle fill="#DADADA" cx="58.592" cy="101.417" r="0.488"/></g></g><g><g><path fill="#EDEDED" d="M71.041,102.891c0.072-0.607-0.362-1.158-0.969-1.23c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.036-0.601-0.411-1.132-0.474c-0.607-0.071-1.158,0.362-1.229,0.97s0.362,1.158,0.97,1.229c0.53,0.063,0.903-0.232,1.211-0.196c0.308,0.037,0.601,0.411,1.132,0.474C70.419,103.932,70.97,103.497,71.041,102.891z"/></g><g><path fill="#EDEDED" d="M75.583,103.428c0.072-0.607-0.362-1.158-0.969-1.229c-0.53-0.063-0.903,0.232-1.211,0.196c-0.308-0.036-0.601-0.411-1.132-0.474c-0.607-0.072-1.158,0.362-1.23,0.97c-0.071,0.606,0.362,1.157,0.97,1.229c0.531,0.062,0.903-0.232,1.211-0.196c0.308,0.036,0.602,0.41,1.132,0.474C74.961,104.469,75.512,104.035,75.583,103.428z"/></g><g><path fill="#EDEDED" d="M73.312,103.159c0.072-0.607-0.362-1.158-0.969-1.23c-0.531-0.062-0.903,0.233-1.211,0.196c-0.308-0.036-0.602-0.41-1.132-0.473c-0.607-0.072-1.158,0.362-1.23,0.969c-0.072,0.607,0.362,1.158,0.97,1.23c0.531,0.062,0.903-0.233,1.211-0.196c0.308,0.036,0.601,0.41,1.132,0.474C72.69,104.2,73.24,103.767,73.312,103.159z"/><circle fill="#DADADA" cx="69.864" cy="102.75" r="0.488"/><circle fill="#DADADA" cx="72.218" cy="103.03" r="0.488"/></g><g><path fill="#EDEDED" d="M68.77,102.621c0.072-0.606-0.362-1.157-0.969-1.229c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.036-0.601-0.411-1.131-0.474c-0.607-0.072-1.158,0.362-1.23,0.97s0.362,1.158,0.97,1.229c0.53,0.062,0.903-0.232,1.211-0.196c0.308,0.036,0.601,0.411,1.132,0.474C68.148,103.663,68.698,103.229,68.77,102.621z"/><circle fill="#DADADA" cx="65.322" cy="102.213" r="0.488"/><circle fill="#DADADA" cx="67.676" cy="102.492" r="0.487"/></g></g><g><g><path fill="#EDEDED" d="M80.125,103.966c0.072-0.607-0.362-1.158-0.97-1.23c-0.53-0.062-0.903,0.233-1.211,0.196c-0.308-0.036-0.601-0.41-1.132-0.474c-0.607-0.072-1.158,0.362-1.23,0.97c-0.071,0.607,0.362,1.158,0.97,1.23c0.531,0.062,0.903-0.233,1.211-0.197c0.308,0.036,0.601,0.411,1.132,0.474C79.503,105.007,80.054,104.572,80.125,103.966z"/></g><g><path fill="#EDEDED" d="M84.667,104.503c0.072-0.607-0.362-1.157-0.969-1.229c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.037-0.602-0.411-1.132-0.474c-0.607-0.072-1.158,0.362-1.23,0.97c-0.072,0.606,0.362,1.157,0.969,1.229c0.531,0.062,0.903-0.232,1.211-0.196s0.601,0.41,1.131,0.474C84.045,105.544,84.596,105.11,84.667,104.503z"/></g><g><path fill="#EDEDED" d="M82.396,104.234c0.072-0.607-0.362-1.158-0.969-1.229c-0.531-0.063-0.903,0.232-1.211,0.196c-0.308-0.037-0.601-0.411-1.132-0.474c-0.607-0.072-1.158,0.361-1.229,0.969c-0.072,0.607,0.362,1.158,0.969,1.23c0.531,0.062,0.904-0.233,1.211-0.196c0.308,0.036,0.601,0.41,1.132,0.474C81.774,105.275,82.325,104.842,82.396,104.234z"/><circle fill="#DADADA" cx="78.948" cy="103.826" r="0.488"/><circle fill="#DADADA" cx="81.302" cy="104.105" r="0.487"/></g><g><path fill="#EDEDED" d="M77.854,103.696c0.072-0.607-0.362-1.157-0.97-1.229c-0.53-0.063-0.903,0.232-1.211,0.196c-0.308-0.036-0.601-0.411-1.132-0.474c-0.607-0.071-1.158,0.362-1.229,0.97c-0.072,0.607,0.362,1.158,0.969,1.229c0.531,0.063,0.903-0.232,1.211-0.196s0.601,0.411,1.132,0.474C77.232,104.738,77.782,104.304,77.854,103.696z"/><circle fill="#DADADA" cx="74.407" cy="103.289" r="0.488"/><circle fill="#DADADA" cx="76.76" cy="103.567" r="0.488"/></g></g><g><g><path fill="#EDEDED" d="M89.21,105.041c0.072-0.608-0.362-1.158-0.97-1.23c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.036-0.601-0.41-1.132-0.473c-0.607-0.072-1.158,0.361-1.23,0.969s0.362,1.158,0.97,1.229c0.531,0.062,0.903-0.232,1.211-0.196c0.308,0.037,0.601,0.411,1.132,0.474C88.587,106.082,89.138,105.647,89.21,105.041z"/></g><g><path fill="#EDEDED" d="M93.752,105.578c0.072-0.607-0.362-1.157-0.97-1.229c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.037-0.601-0.411-1.132-0.474c-0.607-0.072-1.158,0.361-1.229,0.97c-0.072,0.606,0.362,1.157,0.969,1.229c0.531,0.062,0.904-0.232,1.212-0.196c0.308,0.036,0.601,0.41,1.131,0.474C93.129,106.619,93.68,106.186,93.752,105.578z"/></g><g><path fill="#EDEDED" d="M91.481,105.31c0.072-0.607-0.362-1.158-0.97-1.229c-0.531-0.063-0.903,0.232-1.211,0.195c-0.308-0.036-0.601-0.41-1.132-0.474c-0.607-0.071-1.158,0.363-1.23,0.97c-0.072,0.607,0.362,1.158,0.97,1.23c0.53,0.062,0.903-0.233,1.211-0.196c0.308,0.036,0.602,0.41,1.132,0.474C90.858,106.351,91.409,105.917,91.481,105.31z"/><circle fill="#DADADA" cx="88.033" cy="104.901" r="0.488"/><circle fill="#DADADA" cx="90.387" cy="105.18" r="0.488"/></g><g><path fill="#EDEDED" d="M86.938,104.771c0.072-0.606-0.362-1.157-0.969-1.229c-0.531-0.062-0.903,0.232-1.211,0.196c-0.308-0.037-0.601-0.411-1.131-0.474c-0.607-0.072-1.158,0.362-1.23,0.97c-0.072,0.607,0.362,1.157,0.97,1.229c0.53,0.062,0.903-0.233,1.211-0.196c0.308,0.036,0.602,0.41,1.132,0.474C86.316,105.813,86.867,105.379,86.938,104.771z"/><circle fill="#DADADA" cx="83.491" cy="104.364" r="0.487"/><circle fill="#DADADA" cx="85.844" cy="104.642" r="0.487"/></g></g><g><g><path fill="#EDEDED" d="M98.294,106.115c0.072-0.607-0.362-1.157-0.969-1.229c-0.531-0.062-0.903,0.233-1.211,0.196c-0.308-0.036-0.601-0.411-1.132-0.474c-0.607-0.071-1.158,0.362-1.229,0.97c-0.072,0.607,0.362,1.158,0.969,1.229c0.531,0.063,0.904-0.232,1.212-0.196c0.308,0.036,0.601,0.411,1.132,0.474C97.672,107.157,98.222,106.723,98.294,106.115z"/></g><g><path fill="#EDEDED" d="M102.537,104.4c-0.262-0.554-0.922-0.789-1.475-0.528c-0.483,0.229-0.642,0.677-0.922,0.81c-0.28,0.132-0.728-0.029-1.211,0.199c-0.553,0.261-0.789,0.921-0.528,1.474s0.921,0.79,1.474,0.528c0.483-0.229,0.642-0.677,0.923-0.81c0.28-0.132,0.728,0.029,1.21-0.198C102.562,105.613,102.799,104.953,102.537,104.4z"/></g><g><path fill="#EDEDED" d="M100.578,105.831c-0.034-0.611-0.556-1.078-1.167-1.045c-0.533,0.029-0.85,0.385-1.16,0.401c-0.309,0.017-0.662-0.301-1.196-0.271c-0.611,0.033-1.079,0.556-1.045,1.166c0.033,0.61,0.555,1.078,1.166,1.045c0.534-0.029,0.85-0.385,1.159-0.401c0.31-0.018,0.663,0.301,1.197,0.271C100.143,106.964,100.611,106.441,100.578,105.831z"/><circle fill="#DADADA" cx="97.111" cy="106.021" r="0.488"/><circle fill="#DADADA" cx="99.478" cy="105.891" r="0.487"/></g><g><path fill="#EDEDED" d="M96.023,105.847c0.072-0.607-0.362-1.157-0.969-1.229c-0.531-0.063-0.903,0.232-1.211,0.196s-0.601-0.41-1.131-0.474c-0.608-0.072-1.158,0.362-1.23,0.97s0.362,1.158,0.969,1.229c0.531,0.062,0.903-0.232,1.211-0.196s0.602,0.41,1.132,0.474C95.4,106.889,95.951,106.454,96.023,105.847z"/><circle fill="#DADADA" cx="92.575" cy="105.439" r="0.488"/><circle fill="#DADADA" cx="94.928" cy="105.717" r="0.487"/></g></g></g><g><path fill="#EDEDED" d="M35.092,90.106c0.611,0,1.107,0.495,1.107,1.107c0,0.534-0.337,0.869-0.337,1.179c0,0.311,0.337,0.646,0.337,1.181c0,0.611-0.496,1.107-1.107,1.107s-1.107-0.496-1.107-1.107c0-0.535,0.337-0.87,0.337-1.181c0-0.31-0.337-0.645-0.337-1.179C33.984,90.602,34.48,90.106,35.092,90.106z"/><circle fill="#DADADA" cx="35.092" cy="93.579" r="0.488"/><circle fill="#DADADA" cx="35.092" cy="91.208" r="0.487"/></g><g><path fill="#EDEDED" d="M108.492,91.549c0.611,0,1.107,0.495,1.107,1.107c0,0.534-0.338,0.869-0.338,1.18c0,0.31,0.338,0.645,0.338,1.18c0,0.611-0.496,1.107-1.107,1.107c-0.612,0-1.107-0.496-1.107-1.107c0-0.535,0.337-0.87,0.337-1.18c0-0.311-0.337-0.646-0.337-1.18C107.385,92.044,107.88,91.549,108.492,91.549z"/><circle fill="#DADADA" cx="108.492" cy="95.021" r="0.488"/><circle fill="#DADADA" cx="108.492" cy="92.65" r="0.487"/></g><g><path fill="#EDEDED" d="M106.994,87.545c0.574-0.21,1.209,0.087,1.419,0.661c0.183,0.502-0.02,0.933,0.086,1.225c0.106,0.291,0.538,0.49,0.721,0.992c0.209,0.575-0.087,1.211-0.661,1.42c-0.575,0.209-1.211-0.088-1.42-0.662c-0.183-0.502,0.02-0.932-0.087-1.224c-0.105-0.291-0.537-0.491-0.72-0.993C106.123,88.39,106.419,87.754,106.994,87.545z"/><circle fill="#DADADA" cx="108.181" cy="90.808" r="0.487"/><circle fill="#DADADA" cx="107.37" cy="88.58" r="0.488"/></g><g><path fill="#EDEDED" d="M104.217,84.294c0.468-0.393,1.166-0.332,1.56,0.137c0.343,0.409,0.301,0.883,0.5,1.121c0.199,0.237,0.673,0.277,1.017,0.687c0.393,0.468,0.332,1.167-0.137,1.56c-0.469,0.394-1.167,0.332-1.56-0.136c-0.344-0.41-0.301-0.883-0.5-1.121c-0.199-0.237-0.673-0.277-1.017-0.687C103.687,85.386,103.748,84.688,104.217,84.294z"/><circle fill="#DADADA" cx="106.448" cy="86.954" r="0.487"/><circle fill="#DADADA" cx="104.925" cy="85.138" r="0.488"/></g><g><path fill="#EDEDED" d="M37.287,86.511c0.53,0.306,0.711,0.982,0.405,1.513c-0.267,0.463-0.727,0.584-0.882,0.853s-0.03,0.728-0.298,1.19c-0.306,0.529-0.983,0.711-1.513,0.405c-0.529-0.306-0.711-0.982-0.405-1.513c0.268-0.463,0.727-0.584,0.882-0.853c0.155-0.269,0.031-0.728,0.298-1.19C36.08,86.386,36.758,86.205,37.287,86.511z"/><circle fill="#DADADA" cx="35.551" cy="89.518" r="0.487"/><circle fill="#DADADA" cx="36.736" cy="87.465" r="0.488"/></g><g><path fill="#EDEDED" d="M35.179,94.286c0.53-0.307,1.207-0.125,1.513,0.405c0.267,0.462,0.143,0.921,0.298,1.189s0.615,0.391,0.882,0.854c0.306,0.529,0.125,1.207-0.405,1.513s-1.207,0.124-1.513-0.405c-0.267-0.463-0.143-0.922-0.298-1.19c-0.155-0.269-0.614-0.391-0.882-0.854C34.468,95.269,34.649,94.592,35.179,94.286z"/><circle fill="#DADADA" cx="36.915" cy="97.292" r="0.488"/><circle fill="#DADADA" cx="35.73" cy="95.24" r="0.488"/></g><g><path fill="#EDEDED" d="M106.994,100.119c0.574,0.209,1.209-0.087,1.419-0.662c0.183-0.502-0.02-0.933,0.086-1.224c0.106-0.291,0.538-0.491,0.721-0.993c0.209-0.574-0.087-1.21-0.661-1.419c-0.575-0.21-1.211,0.087-1.42,0.661c-0.183,0.503,0.02,0.933-0.087,1.224c-0.105,0.292-0.537,0.492-0.72,0.994C106.123,99.274,106.419,99.91,106.994,100.119z"/><circle fill="#DADADA" cx="108.181" cy="96.856" r="0.487"/><circle fill="#DADADA" cx="107.37" cy="99.084" r="0.488"/></g><g><path fill="#EDEDED" d="M104.217,103.369c0.468,0.394,1.166,0.332,1.56-0.136c0.343-0.41,0.301-0.884,0.5-1.121s0.673-0.277,1.017-0.687c0.393-0.469,0.332-1.167-0.137-1.561c-0.469-0.393-1.167-0.332-1.56,0.137c-0.344,0.409-0.301,0.883-0.5,1.12c-0.199,0.238-0.673,0.278-1.017,0.688C103.687,102.278,103.748,102.977,104.217,103.369z"/><circle fill="#DADADA" cx="106.448" cy="100.709" r="0.488"/><circle fill="#DADADA" cx="104.925" cy="102.526" r="0.488"/></g><g><path fill="#EDEDED" d="M100.495,105.474c0.306,0.529,0.983,0.711,1.513,0.405c0.462-0.267,0.584-0.727,0.853-0.882s0.728-0.03,1.19-0.298c0.529-0.306,0.711-0.983,0.405-1.513s-0.983-0.711-1.513-0.405c-0.463,0.268-0.584,0.728-0.854,0.882c-0.268,0.155-0.727,0.03-1.189,0.298C100.37,104.267,100.189,104.944,100.495,105.474z"/><circle fill="#DADADA" cx="103.501" cy="103.738" r="0.488"/><circle fill="#DADADA" cx="101.449" cy="104.923" r="0.488"/></g><g><path fill="#EDEDED" d="M100.495,82.189c0.306-0.529,0.983-0.711,1.513-0.405c0.462,0.268,0.584,0.728,0.853,0.883c0.269,0.154,0.728,0.03,1.19,0.297c0.529,0.307,0.711,0.983,0.405,1.513c-0.306,0.53-0.983,0.712-1.513,0.405c-0.463-0.267-0.584-0.727-0.854-0.882c-0.268-0.155-0.727-0.03-1.189-0.298C100.37,83.396,100.189,82.72,100.495,82.189z"/><circle fill="#DADADA" cx="103.501" cy="83.926" r="0.488"/><circle fill="#DADADA" cx="101.449" cy="82.741" r="0.488"/></g></g><g><g><path fill="#DADADA" d="M79.694,52.21c-0.443,0-0.863-0.266-1.039-0.702l-6.992-17.384c-0.23-0.574,0.047-1.226,0.621-1.456c0.574-0.231,1.226,0.047,1.456,0.62l6.992,17.385c0.23,0.573-0.047,1.225-0.621,1.456C79.975,52.184,79.833,52.21,79.694,52.21z"/><g><path fill="#C09A5D" d="M70.825,29.236c8.489,0,21.133,1.787,21.535,5.797c0.401,4.011-3.342,4.145-7.286,4.679c-3.943,0.535-8.489,1.671-15.44,1.738c-6.951,0.066-7.352-3.25-7.352-6.726S65.076,29.236,70.825,29.236z"/><path fill="#B29057" d="M92.359,35.033c-0.141-1.406-1.789-2.539-4.234-3.417c-6.423-0.898-11.238,1.312-11.238,1.312c-3.91,0.805-12.494,3.512-8.459,8.497c0.378,0.021,0.779,0.029,1.205,0.025c6.952-0.067,11.497-1.203,15.44-1.738C89.017,39.178,92.76,39.044,92.359,35.033z"/><path fill="#CDAE7D" d="M92.359,35.033c-0.401-4.01-13.046-5.797-21.535-5.797c-2.309,0-4.141,0.325-5.507,0.939c-1.05,1.736-0.932,3.373,4.182,4.791c6.973,1.934,21.222-4.911,22.765,1.654C92.384,36.172,92.421,35.649,92.359,35.033z"/></g></g><g><rect x="129.795" y="22.781" transform="matrix(0.2323 0.9726 -0.9726 0.2323 126.8933 -112.9723)" fill="#DADADA" width="10.437" height="2.238"/><path fill="#EDEDED" d="M133.216,18.24c-0.653,0-1.244-0.448-1.399-1.111c-0.182-0.774,0.299-1.548,1.073-1.729c0.17-0.04,4.199-0.979,6.753-1.305c1.746-0.222,4.202-2.031,5.714-4.207c1.911-2.752,1.533-3.547,1.517-3.58c-0.104-0.199-0.713-0.536-2.333-0.536h-11.646c-0.795,0-1.439-0.644-1.439-1.438c0-0.795,0.645-1.439,1.439-1.439h11.646c0.938,0,3.796,0,4.883,2.08c1.097,2.098-0.446,4.746-1.703,6.555c-1.683,2.423-4.721,5.039-7.713,5.42c-2.408,0.307-6.421,1.243-6.462,1.252C133.435,18.228,133.324,18.24,133.216,18.24z"/><g><path fill="#D9C29D" d="M134.248,7.225c-0.871,0.112-0.879-0.629-1.757-0.629c-0.88,0-0.88,0.629-1.758,0.629c-0.879,0-0.879-0.629-1.758-0.629s-0.879,0.629-1.758,0.629c-0.878,0-0.878-0.629-1.758-0.629c-0.878,0-0.878,0.629-1.757,0.629s-0.879-0.629-1.758-0.629s-0.879,0.629-1.758,0.629c-1.157,0-1.771-0.887-1.771-2.109s0.375-3.278,5.535-3.278s7.076,0,8.409,0c1.334,0,2.318,1.208,2.657,2.803C135.358,6.236,135.277,7.094,134.248,7.225z"/></g><circle fill="#B2B2B2" cx="133.217" cy="17.28" r="2.471"/><path fill="#DADADA" d="M141.423,18.719h-8.206c-0.795,0-1.439-0.644-1.439-1.439s0.645-1.439,1.439-1.439h8.206c1.719,0,4.083-2.11,5.531-4.195c1.911-2.752,1.534-3.547,1.517-3.58c-0.104-0.199-0.712-0.536-2.333-0.536h-11.646c-0.795,0-1.439-0.644-1.439-1.438c0-0.795,0.645-1.439,1.439-1.439h11.646c0.938,0,3.796,0,4.884,2.08c1.097,2.098-0.447,4.746-1.703,6.555C147.578,15.793,144.466,18.719,141.423,18.719z"/><g><path fill="#C09A5D" d="M136.842,9.591c-0.914,0.117-0.921-0.66-1.843-0.66c-0.921,0-0.921,0.66-1.843,0.66c-0.921,0-0.921-0.66-1.842-0.66c-0.922,0-0.922,0.66-1.843,0.66s-0.921-0.66-1.843-0.66c-0.921,0-0.921,0.66-1.843,0.66c-0.921,0-0.921-0.66-1.843-0.66c-0.921,0-0.921,0.66-1.842,0.66c-1.214,0-1.857-0.93-1.857-2.211s0.395-3.437,5.804-3.437s7.419,0,8.816,0s2.43,1.266,2.785,2.938C138.006,8.555,137.92,9.454,136.842,9.591z"/><path fill="#B29057" d="M120.957,9.209c0.294,0.243,0.676,0.382,1.145,0.382c0.921,0,0.921-0.66,1.842-0.66c0.922,0,0.922,0.66,1.843,0.66c0.922,0,0.922-0.66,1.843-0.66c0.922,0,0.922,0.66,1.843,0.66s0.921-0.66,1.843-0.66c0.921,0,0.921,0.66,1.842,0.66c0.922,0,0.922-0.66,1.843-0.66c0.922,0,0.929,0.777,1.843,0.66c0.893-0.114,1.104-0.751,0.948-1.916C129.675,5.438,124.582,6.875,120.957,9.209z"/><path fill="#CDAE7D" d="M120.244,7.38c0,1.247,0.61,2.158,1.762,2.207c1.109-1.724,1.186-3.402,0.203-5.066C120.425,5.25,120.244,6.515,120.244,7.38z"/></g></g><path d="M80.744,53.311l-0.64-0.715c-1.62,1.449-3.329,1.24-6.529-0.801c-0.528-0.336-1.095-0.745-1.753-1.219c-3.671-2.644-9.218-6.637-19.647-6.637h-0.029l-0.491,0c-15.014,0.01-24.933,0.017-28.086,3.908c-0.36,0.444-0.593,0.996-0.719,1.637c-1.284,0.531-2.277,1.2-2.958,2.04c-2.92,3.603,3.489,14.76,9.381,23.486c4.765,7.057,12.121,17.597,12.194,17.702l0.393-0.274l0.43-0.214c-0.068-0.138-6.899-13.856-10.753-21.379l-0.192-0.374c-1.248-2.436-2.787-5.439-4.158-8.459c-0.292,0.141-0.582,0.286-0.869,0.436c1.324,2.899,2.828,5.836,4.173,8.461l0.192,0.374c2.227,4.346,5.449,10.764,7.785,15.432c-2.525-3.644-5.836-8.446-8.399-12.241c-7.838-11.608-11.363-19.961-9.431-22.345c0.494-0.609,1.2-1.12,2.1-1.547c-0.029,1.267,0.239,2.773,0.708,4.424c0.293-0.143,0.588-0.283,0.886-0.42c-0.482-1.707-0.733-3.227-0.625-4.406c4.755-1.724,13.554-1.768,24.757-1.604c10.59,0.154,15.249,3.668,18.333,5.993c0.976,0.735,1.817,1.37,2.648,1.745c3.386,1.529,7.72,0.376,9.954-1.623l-0.343-0.384C79.63,54.127,80.192,53.804,80.744,53.311z M23.952,49.083c0.094-0.237,0.214-0.449,0.362-0.632c1.625-2.006,5.462-2.875,11.167-3.255c-0.647,0.767-1.323,1.748-1.703,2.503C29.724,47.891,26.417,48.298,23.952,49.083z M48.476,47.616c-5.12-0.075-9.67-0.106-13.579,0.037c0.557-0.938,1.418-2.027,1.973-2.538c4.104-0.209,9.068-0.213,14.786-0.217h0.491h0.028c0.199,0,0.393,0.004,0.589,0.007c-0.686,0.805-1.456,1.913-1.885,2.809C50.11,47.663,49.313,47.628,48.476,47.616zM69.837,55.439c-0.733-0.331-1.535-0.937-2.465-1.637c-2.826-2.132-6.94-5.229-15.459-6.007c0.572-1.051,1.542-2.3,2.124-2.852c8.931,0.44,13.879,4.002,17.225,6.411c0.641,0.461,1.247,0.898,1.797,1.249c1.862,1.188,3.518,1.962,5.053,1.875C76.013,55.918,72.529,56.655,69.837,55.439z"/><g><path class="colorful c1" fill="'.$svg['bike']['colors'][0].'" d="M161.9,91.601c-11.611-13.403-16.059-30.246-19.307-42.543l-0.25-0.945c-3.203-12.106-5.757-23.228-5.782-23.339c-0.158-0.688-0.843-1.12-1.532-0.961c-0.688,0.158-1.119,0.844-0.961,1.532c0.012,0.052,0.582,2.537,1.517,6.415c-9.346,2.753-14.139,12.597-18.778,22.131c-0.835,1.715-1.698,3.489-2.575,5.195c-2.515,4.894-5.855,7.853-9.929,8.795c-6.574,1.521-13.707-2.338-18.652-5.967l-5.506-14.058c-0.322-0.822-1.25-1.227-2.072-0.905s-1.228,1.25-0.906,2.072l1.52,3.879L40.945,91.544c-0.355,0.364-0.461,0.904-0.27,1.376c0.191,0.471,0.644,0.784,1.152,0.797l53.622,1.373c0.189,0.149,0.411,0.258,0.654,0.31c0.111,0.023,0.223,0.035,0.334,0.035c0.415,0,0.818-0.162,1.12-0.459l43.287-42.532c3.268,12.224,7.973,27.962,19.121,40.832c0.253,0.292,0.609,0.441,0.968,0.441c0.297,0,0.595-0.103,0.837-0.312C162.305,92.942,162.362,92.135,161.9,91.601z M44.824,91.234l34.886-35.72l14.486,36.984L44.824,91.234z M97.043,90.999l-9.746-24.881c4.968,3.082,9.7,4.658,13.974,4.658c1.242,0,2.447-0.134,3.607-0.401c3.369-0.78,6.288-2.667,8.721-5.628l4.808,5.261L97.043,90.999z M120.233,68.213l-5.098-5.579c0.479-0.743,0.938-1.536,1.37-2.379c0.89-1.731,1.76-3.518,2.601-5.246c4.569-9.389,8.898-18.281,17.082-20.762c0.998,4.092,2.278,9.211,3.683,14.519l0.031,0.12L120.233,68.213z"/><circle fill="#DADADA" cx="160.934" cy="92.438" r="0.812"/><circle fill="#DADADA" cx="41.86" cy="92.438" r="0.812"/></g><g><g><circle fill="#B2B2B2" cx="96.438" cy="93.836" r="2.185"/></g><g><path fill="#C6C6C6" d="M111.194,110.905l-15.916-15.91c-0.64-0.641-0.64-1.678,0-2.318c0.64-0.64,1.677-0.64,2.317,0.001l15.916,15.911L111.194,110.905z"/><g><g><path fill="#575756" d="M117.499,107.676h-10.024c-0.539,0-0.98,0.441-0.98,0.98v2.342c0,0.539,0.441,0.98,0.98,0.98h10.024c0.538,0,0.979-0.441,0.979-0.98v-2.342C118.479,108.117,118.037,107.676,117.499,107.676z"/><g><polygon fill="#878787" points="108.787,107.057 107.848,107.057 107.603,107.676 109.031,107.676 "/><polygon fill="#878787" points="112.956,107.057 112.018,107.057 111.772,107.676 113.201,107.676 "/><polygon fill="#878787" points="117.126,107.057 116.187,107.057 115.941,107.676 117.371,107.676 "/></g><g><polygon fill="#878787" points="116.187,112.604 117.126,112.604 117.371,111.984 115.941,111.984 "/><polygon fill="#878787" points="112.018,112.604 112.956,112.604 113.201,111.984 111.772,111.984 "/><polygon fill="#878787" points="107.848,112.604 108.787,112.604 109.031,111.984 107.603,111.984 "/></g></g><circle cx="112.486" cy="109.83" r="1.521"/></g></g></g></g></g></g></svg>';
		
		return !empty($args['item']) ? $svg[$args['item']]['code'] : $svg;
	}
	
}
?>