<?php
class WPPAS_Adzone_Creator {	

	public function __construct() 
	{
		add_filter('the_content', array($this, 'update_content'));
	}
	
	
	
	/**
	 * LOAD ADZONE DATA
	 *
	 */
	public function load_adzone_data($id = 0)
	{
		if($id)
		{
			$adzone_post = get_post($id);
			$adzone_data = get_post_meta($id, '_wpproads_adzone_data', array());
			
			$adzone = array(
				'adzone'       => $adzone_post,
				'adzone_data'  => $adzone_data
			);
			
			return $adzone;
		}
	}
	
	
	
	
	/**
	 * Get adzone data or default values.
	 *
	 */
	public function vbc_adzone_data($args = array())
	{
		$defaults = array(
			'aid'      => 0, 
			'type'     => 'size',
			'default'  => '300x250'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$data = $this->load_adzone_data($args['aid']);
		$result = !empty($data['adzone_data'][0][$args['type']]) ? $data['adzone_data'][0][$args['type']] : $args['default'];
		
		return $result;
	}
	
	
	
	
	/**
	 * SHOW ADZONE
	 *
	 */
	public function show_adzone($args = array()) 
	{
		global $wppas_banner_creator;
		
		$defaults = array(
			'aid'         => 0,
			'reload_on_rotation' => 1,
			'options'     => array(),
		);
		
		$args = wp_parse_args( $args, $defaults );
		
		wp_enqueue_script('wppas_jsrslider');
		
		$data = $this->load_adzone_data($args['aid']);
		$html = '';
		
		if(!empty($data['adzone_data']))
		{
			$unique = uniqid();
			$unique = 'wp'.$unique;
			$linked_banners = $data['adzone_data'][0]['banners'];
			$linked_banner_count = $this->count_banners_in_adzone($linked_banners);
			$display_options_css = WPPAS_Display_Options::display_options_css($args['options']);
			$use_trigger = WPPAS_Display_Options::use_trigger($args['options']);
			$size = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'size'));
			$rotation = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation', 'default' => 1));
			$rotation_shuffle = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation_shuffle', 'default' => 0));
			$rotation_time = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation_time', 'default' => 5000));
			$rotation_type = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation_type', 'default' => '{$Duration:400,x:-1,$Easing:$Jease$.$InQuad}'));
			$max_banners = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_max_banners', 'default' => ''));
			$buyandsell = WPPAS_TPL::vbc_data(array('id' => $args['aid'],'type' => 'buyandsell','default' => 0));
			$rotation_type = $rotation_type == 'null' ? '' : $rotation_type;
			$size = explode('x', $size);
			$w = $size[0] != 'full' ? $size[0].'px' : '100%';
			$h = $size[1] != 'full' ? $size[1].'px' : '100%';
			$effect = array_key_exists('effect', $args['options']) ? $args['options']['effect'] : '';
			$style = array_key_exists('style', $args['options']) ? $args['options']['style'] : '';
			$hide_empty = array_key_exists('hide_empty', $args['options']) ? $args['options']['hide_empty'] : 0;
			$custom_class = array_key_exists('class', $args['options']) ? ' '.$args['options']['class'] : '';
			$args['options']['unique'] = $unique;
			$args['options']['width'] = $w;
			$args['options']['height'] = $h;
			
			if( $linked_banner_count || $buyandsell )
			{
			// @since v5.2.2 added width,height,transform-origin.
			$html.= '<div id="cont'.$unique.'" class="wppas_container '.$unique.$custom_class.'" style="display:none;width:'.$w.';height:'.$h.';max-width:'.$w.';max-height:'.$h.';position:relative;transform-origin: 0px 0px 0px;'.$display_options_css.$style.'">';
	
				$html.= '<div id="wppas_zone_'.$args['aid'].'" class="wppas_zone" style="width:'.$w.';height:'.$h.';">';
					// Loading screen
					if( !empty($linked_banners) && $rotation)
					{
						$html.= '<div u="loading" style="position: absolute; top: 0px; left: 0px;">';
							$html.= __('Loading...','wpproads');
						$html.= '</div>';
					}
					
					// Slides container
					$html.= '<div class="wppas_zone" u="slides" style="position: absolute; overflow: hidden; left: 0px; top: 0px; width:'.$w.';height:'.$h.';">';
					
						// Banners
						$i = 0;
						if( !empty($linked_banners))
						{
							// Shuffle linked banners - if rotation is off
							if(!$rotation || $rotation_shuffle)
							{
								shuffle($linked_banners);
							}
							
							foreach($linked_banners as $linked_banner)
							{
								$show = $wppas_banner_creator->show_or_hide_banner( $linked_banner );
								if( $show )
								{
									$html.= '<div class="slide_'.$i.' wpslide" idle="'.$rotation_time.'" style="width:'.$w.';height:'.$h.';">';
										$html.= do_shortcode('[wpproads id="'.$linked_banner.'" adzone="'.$args['aid'].'"]');
									$html.= '</div>';
									$i++;
									if(!$rotation)
									{
										break;
									}
								}
							}
						}
						
						// Buy and Sell
						if( !empty($max_banners) && count($linked_banners) < $max_banners )
						{
							$html.= WPPAS_BuySell::show_bs_banner(array(
								'aid' => $args['aid'], 
								'rotation_time' => $rotation_time,
								'slide_num' => $i
							));
						}
						
					$html.= '</div>';
					
				$html.= '</div>';
			$html.= '</div>';
			
			// JS
			$html.= '<script type="text/javascript">';
				
				$html.= 'function wppasReloadBnr_'.$unique.'(){ ';
					$html.= 'jQuery(".'.$unique.'").wppas_show_adzone({';
						$html.= 'aid: '.$args['aid'].',';
						$html.= 'w: jQuery(".'.$unique.'").width(),';
						$html.= 'effect:"'.$effect.'",';
					$html.= '});';
					
					//Extra display JS
					$html.= WPPAS_Display_Options::extra_display_js($args['options']);
					
					// IF EFFECT IS DEFINED - Show banner after everything is loaded with effect.
					$html.= WPPAS_Display_Options::banner_effect($args['options']);
					
					// Info text wrapper
					$html.= WPPAS_Display_Options::info_text($args['options']);
					
					// fix to reload the first banner to make sure it has its full size.
					/*$html.= 'var b_unique = jQuery(".slide_0").find(".b_container").data("unique");';
					$html.= 'jQuery(".slide_0").find(".b_container").removeClass("lded");';
					$html.= 'window["wppasReloadBnr_"+b_unique]();';*/
					
				$html.= '}';
				
				
				
				$html.= 'jQuery(document).ready(function($) { ';
					
					// Show Adzone
					if( !$use_trigger )
					{
						$html.= 'wppasReloadBnr_'.$unique.'();';
					}
					else
					{
						$html.= WPPAS_Display_Options::trigger_js($args['options']);	
					}
					
					if($rotation)
					{
						$html.= 'var _SlideshowTransitions = ['.$rotation_type.'];';
						$html.= 'var options = {';
							$html.= '$AutoPlay: true,';
							$html.= '$ArrowKeyNavigation: false,';
							$html.= '$DragOrientation: 0,';
							$html.= '$SlideshowOptions: {';
								$html.= '$Class: $JssorSlideshowRunner$,';
								$html.= '$Transitions: _SlideshowTransitions,';
								$html.= '$TransitionsOrder: 1,';
								$html.= '$ShowLink: true';
							$html.= '}';
						$html.= '};';
						
						// Load Adzone
						//$html.= 'var wppas_slider_'.$args['aid'].' = new $JssorSlider$("wppas_zone_'.$args['aid'].'", options);';
						$html.= 'var wppas_slider_'.$unique.' = new $JssorSlider$("cont'.$unique.'", options);';
						
						// news slide - CALLBACK 
						$html.= 'wppas_slider_'.$unique.'.$On($JssorSlider$.$EVT_PARK, SlideParkEventHandler);';
						$html.= 'function SlideParkEventHandler(slideIndex, fromIndex) {';
							//$html.= 'console.log("event"+slideIndex);';
							$html.= 'if( _SlideshowTransitions == ""){';
							
								if( $args['reload_on_rotation'])
								{
									// Clean up previous slide to get it started from 0 next time.
									$html.= 'var prev_slide = slideIndex > 0 ? slideIndex-1 : wppas_slider_'.$unique.'.$SlidesCount()-1;';
									$html.= 'if ($(".wppas_zone .slide_"+prev_slide).find(".b_container")[0]){';
										$html.= '$(".wppas_zone .slide_"+prev_slide).find(".b_container").removeClass("lded");';
										//$html.= '$(".wppas_zone .slide_"+prev_slide).find(".b_container").html("");';
									$html.= '}';
								}
								
								// Chceck for banner ID and if found start the banner animation.
								$html.= 'if ($(".wppas_zone .slide_"+slideIndex).find(".b_container")[0]){';
									$html.= 'var bid = $(".wppas_zone .slide_"+slideIndex).find(".b_container").data("unique");';
									$html.= '$(".wppas_zone .slide_"+slideIndex).find(".b_container").removeClass("lded");';
									$html.= 'window["wppasReloadBnr_"+bid]();';
								$html.= '}';
							$html.= '}';
						$html.= '}';
						
						// Slideshow (transition) ends - CALLBACK 
						$html.= 'wppas_slider_'.$unique.'.$On($JssorSlider$.$EVT_SLIDESHOW_END, SlideshowEndHandler);';
						$html.= 'function SlideshowEndHandler(slideIndex, fromIndex) {';
							//$html.= 'console.log("trans end "+slideIndex);';
							if( $args['reload_on_rotation'])
							{
								// Clean up previous slide to get it started from 0 next time.
								$html.= 'var prev_slide = slideIndex > 0 ? slideIndex-1 : wppas_slider_'.$unique.'.$SlidesCount()-1;';
								$html.= 'if ($(".wppas_zone .slide_"+prev_slide).find(".b_container")[0]){';
									$html.= '$(".wppas_zone .slide_"+prev_slide).find(".b_container").removeClass("lded");';
									//$html.= '$(".wppas_zone .slide_"+prev_slide).find(".b_container").html("");';
								$html.= '}';
							}
							
							// Chceck for banner ID and if found start the banner animation.
							$html.= 'if ($(".wppas_zone .slide_"+slideIndex).find(".b_container")[0]){';
								$html.= 'var bid = $(".wppas_zone .slide_"+slideIndex).find(".b_container").data("unique");';
								$html.= 'window["wppasReloadBnr_"+bid]();';
							$html.= '}';
						$html.= '}';
					}
					
					
					// Responsive functions
					$html.= 'function ScaleSlider() {';
						$html.= 'var prop = $(this).wppas.get_proportion($("#cont'.$unique.'"));';
						$html.= '$("#cont'.$unique.'").css({"transform": "scale("+prop.proportion+")", "transform-origin": "0px 0px 0px"});';
						// Adjust margin-bottom neccessery for some themes.
						$html.= 'var mrgn = $("#cont'.$unique.'").height() - $("#cont'.$unique.'")[0].getBoundingClientRect().height;';
						//$html.= '$("#cont'.$unique.'").css({"margin-bottom":-mrgn});';
						$html.= '$("#cont'.$unique.'")[0].style.setProperty( "margin-bottom", -mrgn+"px", "important" );';
						
					$html.= '}';
					
					$html.= 'ScaleSlider();';			
					$html.= '$(window).bind("load", ScaleSlider);';
					$html.= '$(window).bind("resize", ScaleSlider);';
					$html.= '$(window).bind("orientationchange", ScaleSlider);';
					
				$html.= '});';
				
				
			$html.= '</script>';
			}
		}
		
		return $html;
	}
	
	
	
	/**
	 * Count banners in adzone - after filtering
	 */
	public function count_banners_in_adzone($linked_banners = array())
	{
		global $wppas_banner_creator;
		$cnt = 0;
		if( !empty($linked_banners))
		{	
			foreach($linked_banners as $linked_banner)
			{
				if( $wppas_banner_creator->show_or_hide_banner( $linked_banner ))
				{
					$cnt++;
				}
			}
		}
		
		return $cnt;
	}
	
	
	
	
	/**
	 * ALL ADZONES QUERY
	 *
	 */
	public function all_adzones_query( $args = array() )
	{
		$defaults = array(
			'posts_per_page'   => -1,
			'offset'           => 0,
			'orderby'          => 'date',
			'order'            => 'DESC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'wppas_adzones',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'author'	       => '',
			'author_name'	   => '',
			'post_status'      => 'publish',
			'suppress_filters' => true 
		);
		$args = wp_parse_args( $args, $defaults );
		$adzones = get_posts( $args );
		
		return $adzones;
	}
	
	
	
	
	public function all_adzoness_tpl()
	{
		global $wppas_banner_creator;
		
		$html = '';
		$args = array(
			'posts_per_page'   => -1,
			'offset'           => 0,
			'orderby'          => 'date',
			'order'            => 'DESC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'wppas_adzones',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'author'	       => '',
			'author_name'	   => '',
			'post_status'      => 'publish',
			'suppress_filters' => true 
		);
		$adzones = get_posts( $args );
		
		$html.= '<ul id="all_vbc_adzone_items" class="wppas_actions">';
		
			if( !empty($adzones))
			{
				foreach($adzones as $i => $adzone)
				{
					$html.= $this->all_adzones_item($adzone);
				}
			}
			
			// NEW ADZONE BUTTON
			$html.= '<li class="wppas_action" style="width:15%;">';
				$html.= '<div class="wppas_action_meta wppas_action_new_adzone wppas_action_addnew" style="height:140px;">';
					$html.= '<a href="admin.php?page=wppas-banner-creator&view=adzone_editor" title="'.__('New Adzone','wpproads').'" style="z-index: 10;position: absolute;text-align: center;width: 100%;height: 100%;color:#333;">';
						$html.= '<span class="wppas_icon_wrapper wppas_banner" style="line-height: 110px;">';
							$html.= '<i class="fa fa-plus" aria-hidden="true"></i>';
						$html.= '</span>';
					 $html.= '</a>';
					
					 $html.= '<span class="wppas_action_info" style="left:0; z-index:999;">';
						 $html.= '<span class="wppas_action_title_wrapper">';		
							$html.= '<a title="'.__('Import Banner','wpproads').'">';
								$html.= '<span class="wppas_action_title" style="font-size: 10px;max-width: 90%;max-height: 15px;overflow: hidden;display: inline-block;">'.__('New Adzone','wpproads').'</span>';	
								//$html.= '<div class="float_right"><i class="fa fa-pencil" aria-hidden="true" style="margin-right: 5px;"></i></div>';
							$html.= '</a>';			
						$html.= '</span>';
					$html.= '</span>';
				$html.= '</div>';
				
			$html.= '</li>';
			
		$html.= '</ul>';
		
		return $html;
	}
	
	
	
	
	
	public function all_adzones_item($adzone)
	{
		$adzone_data = $this->load_adzone_data($adzone->ID);
		//$linked_banners = $adzone_data['adzone_data'][0]['banners'];
		$linked_banners = $this->update_linked_banners($adzone->ID);
		$count_banners = !empty($linked_banners) ? count($linked_banners) : 0;
		$max_banners = WPPAS_TPL::vbc_data(array('id' => $adzone->ID, 'type' => 'bs_max_banners', 'default' => ''));
		
		
		$html = '';
		$html.= '<li class="wppas_action" style="width:15%;">'; //style="width:10%; height:auto;"
			$html.= '<div class="wppas_action_meta wppas_action_addnew" style="height:140px;">';
				 $html.= '<div>';
				 
				 	// Droppable zone
					$html.= '<div class="wppas_actions" style="padding:0; margin:0;">';
                  	$html.= '<ul class="adzone_'.$adzone->ID.'_drop wppas_droppable" data-id="'.$adzone->ID.'" data-size="'.$adzone_data['adzone_data'][0]['size'].'" data-max-banners="'.$max_banners.'" data-linked-banners="'.$count_banners.'" style="border:none;">';
							
							if( !empty($linked_banners))
							{
								foreach($linked_banners as $linked_banner)
								{
									if( get_post_status( $linked_banner ) == 'publish' )
									{
										$html.= '<li class="wppas_action wppas_draggable" data-id="'.$linked_banner.'" data-size="'.$adzone_data['adzone_data'][0]['size'].'"></li>';
									}
								}
							}	
							
						$html.= '</ul>';
                  $html.= '</div>';
				  
				 $html.= '</div>';
				 $html.= '<span class="wppas_action_info" style="left:0; z-index:999;">';
					 $html.= '<span class="wppas_action_title_wrapper">';		
						$html.= '<a href="admin.php?page=wppas-banner-creator&view=adzone_editor&aid='.$adzone->ID.'" title="'.$adzone->post_title.'">';
							$html.= '<span class="wppas_action_title" style="font-size: 10px;max-width: 90%;max-height: 15px;overflow: hidden;display: inline-block;">'.$adzone->post_title.'</span>';	
						$html.= '</a>';
						
						// TOOLS
						$html.= '<div class="tools">';
							$html.= '<a class="tool" href="admin.php?page=wppas-banner-creator&view=adzone_editor&aid='.$adzone->ID.'" title="'.__('Edit Banner','wpproads').'"><i class="fa fa-pencil" aria-hidden="true"></i></a>';
							//$html.= '<a class="tool"><i class="fa fa-pencil" aria-hidden="true"></i></a>';
						$html.= '</div>';	
								
					$html.= '</span>';
				$html.= '</span>';
			$html.= '</div>';
			
			/*$html.= '<div class="extra_tools">';
				$html.= '<a href="admin.php?page=wp-pro-ads-stats&group=banner&group_id='.$adzone->ID.'">';
					$html.= '<i class="fa fa-area-chart" aria-hidden="true"></i>';
					$html.= '<span>'.__('Statistics','wpproads').'</span>';
				$html.= '</a>';
			$html.= '</div>';
			$html.= '';*/
		$html.= '</li>';	
		
		return $html;
	}
	
	
	
	/**
	 * UPDATE LINKED BANNERS
	 */
	public function update_linked_banners($ID)
	{
		$adzone_data = $this->load_adzone_data($ID);
		$linked_banners = $adzone_data['adzone_data'][0]['banners'];
		$linked_banners_check = array();
		$max_banners = WPPAS_TPL::vbc_data(array('id' => $ID, 'type' => 'bs_max_banners', 'default' => ''));
		
		if( !empty($linked_banners))
		{
			foreach($linked_banners as $i => $linked_banner)
			{
				if(!empty($max_banners) && ($i+1) > $max_banners)
				{
					break;	
				}
				if( get_post_status( $linked_banner ) == 'publish' )
				{
					$linked_banners_check[] = $linked_banner;
				}
			}
			$adzone_data['adzone_data'][0]['banners'] = $linked_banners_check;
			update_post_meta($ID, '_wpproads_adzone_data', $adzone_data['adzone_data'][0]);
		}
		
		return $linked_banners_check;	
	}
	
	
	
	/**
	 * ORDER LINKED BANNERS
	 */
	public function order_linked_banners($args = array())
	{
		$defaults = array(
			'adzone_id'      => 0,
			'linked_banners' => array()
		);
		$args = wp_parse_args( $args, $defaults );
		$positions = array();
		
		if( empty($args['linked_banners']))
		{
			$adzone_info = WPPAS_BuySell::adzone_info($args['adzone_id']);
			$linked_banners = $adzone_info['linked_banners'];
		}
		else
		{
			$linked_banners = $args['linked_banners'];	
		}
		
		if(!empty($linked_banners))
		{
			$linked_banners = WPPAS_BuySell::top_position_banners(array('linked_banners' => $linked_banners));
			foreach($linked_banners as $banner)
			{
				array_push($positions, $banner['id']);
			}
		}
		
		return $positions;
	}
	
	
	
	
	public function vbc_container_tpl($args = array())
	{
		global $wppas_banner_creator;
		
		$defaults = array(
			'aid'     => 0 //2505
		);
		
		$args = wp_parse_args( $args, $defaults );
		?>
        <div class="vbc_container">
            
            <div class="wppas_loading_vbc">
				<?php _e('LOADING ADZONE CREATOR ...','wpproads'); ?>
                <div>
                	<?php echo $wppas_banner_creator->vbc_loader(); ?>
                </div>
            </div>
            <div class="vbc_main_tabs_container">
                <div id="vbc_main_area" style="display:none;">
                    <ul id="vbc_menu" class="vbc_menu_toggle vbc_main_menu_toggle">
                    	<li data-link="admin.php?page=wppas-banner-creator">
                            <i class="fa fa-object-ungroup" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('All Adzones','wpproads'); ?>
                        </li>
                        <li class="selected" data-target="vbc-general">
                            <i class="fa fa-cog" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('Adzone Settings','wpproads'); ?>
                        </li>
                        <li class="vbc_linked_banners" data-target="vbc-linked-banners">
                            <i class="fa fa-square-o" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('Linked Banners','wpproads'); ?>
                        </li>
                        <li class="vbc_export_tab" data-target="vbc-export" data-type="adzone">
                            <i class="fa fa-download" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('Export','wpproads'); ?>
                        </li>
                        <li class="trash_adzone trash right" data-option="vbc-trash">
                            <i class="fa fa-trash" aria-hidden="true" style="margin-right: 5px;"></i>
                        </li>
                        <li class="save_adzone save right" data-option="vbc-save">
                            <i class="fa fa-save" aria-hidden="true" style="margin-right: 5px;"></i>
                        </li>
                        <!--<li class="preview_adzone preview right" data-option="vbc-preview">
                            <i class="fa fa-search" aria-hidden="true" style="margin-right: 5px;"></i>
                        </li>-->
                     </ul>
                     
                     <!-- content container -->
                     <div id="vbc_content_container">
                        <div id="vbc-general" class="vbc_nfer"><?php echo $this->start_screen_tpl($args); ?></div>
                        <div id="vbc-linked-banners" class="vbc_nfer" style="display:none;"><?php echo $this->linked_banners_template($args); ?></div>
                        <div id="vbc-export" class="vbc_nfer" style="display:none;"><?php echo $this->export_template($args); ?></div>
                    </div>
                </div>
            </div>
            <!-- end .vbc_main_tabs_container -->
            
            <div class="vbc_loader_bg"></div>
            <div class="vbc_loader_duration">
            	<div class="vbc_loader">
            		<?php echo $wppas_banner_creator->vbc_loader(); ?>
                </div>
            </div>
            <div class="vbc_saved_confirm"><div class="vbc_conf_txt"><?php _e('SAVED','wpproads'); ?></div></div>
            <div class="vbc_preview_container">
            	<div class="preview_cont"></div>
            </div>
         </div>
         <!-- end .vbc_container -->
         <?php
	}
	
	
	
	
	
	
	public function start_screen_tpl($args = array())
	{
		global $wppas_banner_creator;
		
		$defaults = array(
			'aid'        => 0, 
		);
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$data = $this->load_adzone_data($args['aid']);
		$aname = !empty($data['adzone']->post_title) ? $data['adzone']->post_title : '';
		$asize = $this->vbc_adzone_data(array('aid' => $args['aid'], 'type' => 'size', 'default' => '300x250'));
		
		// HIDDEN FIELDS.
		$html.= '<input type="hidden" id="adzone_ID" value="'.$args['aid'].'" />';
		$html.= '<input type="hidden" id="wppas_adzone_size" value="'.$asize.'" />';
		
		// -- 1. Banner Title --
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">1</span>';
				$html.= '<span class="text">'.__('Adzone Title','wpproads').'</span>';
			$html.= '</div>';
			
			$html.= WPPAS_TPL::inpt_cont(array(
				'desc' => __('Add an adzone title.','wpproads'),
				'id' => 'wppas_adzone_name', 
				'placeholder' => __('Adzone Title','wpproads'),
				'value' => $aname
			));
			
		$html.= '</div>';
		// end .vbc_option_box	
		
		
		
		// -- 2. Adzone Sizing --
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">2</span>';
				$html.= '<span class="text">'.__('Adzone Sizing','wpproads').'</span>';
			$html.= '</div>';
			
			
			$html.= '<div class="wppas_sep_line">';
				$html.= '<span><strong>'.__("Common adzone sizes","wpproads").'</strong></span>';
			$html.= '</div>';
			
			
			$html.= '<div class="wppas_info_btns">';
				
				$banners = $wppas_banner_creator->banner_sizes();
				foreach($banners as $group)
				{
					foreach($group as $size )
					{
						// Hide full size (for now)
						if( $size['size'] != 'fullxfull') 
						{
							$conversion_w = array_key_exists('conversion',$size) ? $size['conversion']['w'] : 0;
							$conversion_h = array_key_exists('conversion',$size) ? $size['conversion']['h'] : 0;
							$prev_class = array_key_exists('prev_class',$size) ? ' '.$size['prev_class'] : '';
							$w = ($size['w']*100)/800;
							$h = ($size['h']*100)/800;
							$w = !empty($conversion_w) ? $conversion_w : $w;
							$h = !empty($conversion_h) ? $conversion_h : $h;
							
							$html.= '<a class="wppas_home_tpl_btn bsize" data-type="'.$size['size'].'" edit="0">';
								$html.= '<div class="btn_icon">';
									$html.= '<div class="prev_banner_container">';
										$html.= '<div class="prev_banner'.$prev_class.'" style="width:'.$w.'%; height:'.$h.'%;"></div>';
									$html.= '</div>';
									
									//$rand = rand(2, 3);
									$html.= $wppas_banner_creator->btn_prev_bg(2);
								$html.= '</div>';
								$html.= '<div class="btn_info">';
									$html.= '<h5 style="margin:0; font-size:14px;">'.$size['name'].'</h5>';
									$html.= '<span>'.$size['w'].' x '.$size['h'].'</span>';
								$html.= '</div>';
								$html.= '<div class="clearFix"></div>';
							$html.= '</a>';
						}
					}
				}
				
			$html.= '</div>';
			
			$html.= '<div class="wppas_sep_line">';
				$html.= '<span><strong>'.__("Custom banner size","wpproads").'</strong></span>';
			$html.= '</div>';
			
			$html.= '<div class="wppas_info_btns">';
				
				$w = (100*100)/800;
				$h = (100*100)/800;
				$html.= '<div>';
					$html.= '<div class="wppas_home_tpl_btn" style="width:auto; cursor:default;">';
						$html.= '<div class="btn_icon" style="float:none; opacity:1;">';
							$html.= '<div class="prev_banner_container">';
								$html.= '<div class="prev_banner custom_bsize_preview" style="width:'.$w.'%; height:'.$h.'%;"></div>';
							$html.= '</div>';
							$html.= $wppas_banner_creator->btn_prev_bg(2);
						$html.= '</div>';
					$html.= '</div>';
				$html.= '</div>';
				
				$html.= '<div style="display:inline-block; width:50%;">';
					
					$html.= $wppas_banner_creator->inpt_cont(array(
						'desc' => __('Banner width in pixels.','wpproads'),
						'id' => 'custom_bsize_w', 
						'placeholder' => 100,
						'size' => 'one_third',
						'icon' => 'arrows-h'
					));
					
					$html.= $wppas_banner_creator->inpt_cont(array(
						'desc' => __('Banner height in pixels.','wpproads'),
						'id' => 'custom_bsize_h', 
						'placeholder' => 100,
						'size' => 'one_third',
						'icon' => 'arrows-v'
					));
					
				$html.= '</div>';
			$html.= '</div>';
			
			// Advanced sizing options
			/*$html.= '<div class="wppas_sep_line">';
				$html.= '<span><strong>'.__("Advanced sizing options","wpproads").'</strong></span>';
			$html.= '</div>';*/
			
			/*$html.= '<div style="display:inline-block; width:90%; margin-bottom:20px; text-align:left;">';
				
				// Aspect ratio
				$ckd = $baspectratio ? 'checked="checked"' : '';
				$html.= '<div class="one_third" style="text-align:left;">';
                    $html.= '<span class="label">'.__('Respect aspect ratio:','wpproads').'</span>';
                    $html.= '<div class="switch_btn" style="margin-bottom: 15px;">';
                        $html.= '<input id="baspectratio" type="checkbox" name="baspectratio" value="'.$baspectratio.'" '.$ckd.' 
                            data-labels_placement="right" 
                            data-on_label="ON" 
                            data-off_label="OFF"
                            data-width="50" 
                            data-height="30" 
                            data-button_width="30"
                        >';
                    $html.= '</div>';
					$html.= '<span class="description">'.__('Keeps banner aspect ratio. Turn this ON for optimal responsiveness.','wpproads').'</span>';
               $html.= '</div>';
			   
			   // Centrer banner
			   $ckd = $bcenter ? 'checked="checked"' : '';
			   $html.= '<div class="one_third" style="text-align:left;">';
                    $html.= '<span class="label">'.__('Center banner:','wpproads').'</span>';
                    $html.= '<div class="switch_btn" style="margin-bottom: 15px;">';
                        $html.= '<input id="bcenter" type="checkbox" name="bcenter" value="'.$bcenter.'" '.$ckd.' 
                            data-labels_placement="right" 
                            data-on_label="ON" 
                            data-off_label="OFF"
                            data-width="50" 
                            data-height="30" 
                            data-button_width="30"
                        >';
                    $html.= '</div>';
					$html.= '<span class="description">'.__('Keep the banner centered on the page.','wpproads').'</span>';
               $html.= '</div>';
			   
			$html.= '</div>';
			*/
			
		$html.= '</div>';
		// end .vbc_option_box
		
		
		
		// -- 3. Adzone Rotation --
		$rotation = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation', 'default' => 1));
		$rotation_shuffle = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation_shuffle', 'default' => 0));
		$rotation_time = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation_time', 'default' => 5000));
		$rotation_type = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'rotation_type', 'default' => ''));
		//print_r($data['adzone_data']);
		
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">3</span>';
				$html.= '<span class="text">'.__('Adzone Rotation','wpproads').'</span>';
			$html.= '</div>';
			
			$html.= WPPAS_TPL::select_cont(array(
				'title' => __('Rotate Banners','wpproads'),
				'desc' => __('Does this adzone has to rotate banners every x seconds? Selecting "No" will load a random banner on each page load.','wpproads'),
				'id' => 'wppas_adzone_rotation', 
				'size' => 'one_forth',
				'value' => $rotation,
				'select_opts' => array(
					'no' => array('value' => '0', 'text' => __('No', 'wpproads')),
					'yes' => array('value' => '1', 'text' => __('Yes', 'wpproads'))
				)
			));
			
			$html.= WPPAS_TPL::select_cont(array(
				'title' => __('Rotation Shuffle','wpproads'),
				'desc' => __('Shuffle banner positions before rotation? <strong>NOTE:</strong> if this option is selected advertiser bidding for positions will be disabled.','wpproads'),
				'id' => 'wppas_adzone_rotation_shuffle', 
				'size' => 'one_forth',
				'value' => $rotation_shuffle,
				'select_opts' => array(
					'no' => array('value' => '0', 'text' => __('No', 'wpproads')),
					'yes' => array('value' => '1', 'text' => __('Yes', 'wpproads'))
				)
			));
			
			$html.= WPPAS_TPL::inpt_cont(array(
				'title' => __('Rotation Time','wpproads'),
				'desc' => __('Rotation time in miliseconds.','wpproads'),
				'id' => 'wppas_adzone_rotation_time', 
				'placeholder' => 5000,
				'value' => $rotation_time,
				'icon' => 'clock-o',
				'size' => 'one_forth'
			));
			
			$rotation_options = $this->jssor_rotation_effects();
			$select_opts = array();
			foreach( $rotation_options as $rotation )
			{
				$select_opts[$rotation['value']] = array(
					'value' => $rotation['value'],
					'text' => $rotation['text']
				);
			}
			
			$html.= WPPAS_TPL::select_cont(array(
				'title' => __('Rotation Effect','wpproads'),
				'desc' => __('Select your preffered rotation effect.','wpproads'),
				'id' => 'wppas_adzone_rotation_effect', 
				'size' => 'one_forth',
				'select_opts' => $select_opts
			));
			
		$html.= '</div>';
		// end .vbc_option_box	
		
		
		
		// -- 4. BUY AND SELL Option --
		$bs_data = WPPAS_BuySell::get_buysell_data();
		$buyandsell = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'buyandsell', 'default' => 0));
		$bs_price = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_price', 'default' => 10));
		$bs_pos_bid = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_pos_bid', 'default' => 5));
		$bs_max_banners = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_max_banners', 'default' => ''));
		$bs_duration = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_duration', 'default' => 10));
		$bs_contract = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_contract', 'default' => 'ppc'));
		$bs_approve = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_approve', 'default' => 0));
		$bs_banner_id = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'bs_banner_id', 'default' => ''));
		
		$ckd = $buyandsell ? 'checked="checked"' : '';
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">4</span>';
				$html.= '<span class="text">'.__('Sell AD Spots','wpproads').'</span>';
			$html.= '</div>';
			
			$html.= '<div>';
				$html.= WPPAS_TPL::checkbox_cont(array(
					'title' => __('Sell ad spots:','wpproads'),
					'desc' => __('Do you want to sell ad spots for this adzone.','wpproads'),
					'id' => 'wppas_adzone_buyandsell',
					'value' => $buyandsell,
					'chk-on' => __('YES','wpproads'),
					'chk-off' => __('NO','wpproads'),
					'size' => 'one_forth'
				));
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Max. amount of banners:','wpproads'),
					'desc' => __('The maximum amount of banners allowed in this adzone. Leave empty for unlimited.','wpproads'),
					'id' => 'wppas_adzone_bs_max_banners',
					'value' => $bs_max_banners,
					'size' => 'one_forth',
				));
				
				$all_banners = $wppas_banner_creator->all_banners_query();
				$slct = array();
				foreach($all_banners as $bnr)
				{
					$slct[$bnr->ID] = array('text' => 'ID: '.$bnr->ID.' - '.$bnr->post_title);
				}
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Advertise Here Banner:','wpproads'),
					'desc' => __('Select the banner you want to use as "Advertise Here" button.','wpproads'),
					'id' => 'wppas_adzone_bs_banner_id',
					'value' => $bs_banner_id,
					'size' => 'one_forth',
					'select_opts' => $slct
				));
				
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Approve Banners Manually','wpproads'),
					'desc' => __('Do you want each banner to be approved manually before going live?','wpproads'),
					'id' => 'wppas_adzone_bs_approve',
					'value' => $bs_approve,
					'size' => 'one_forth',
					'select_opts' => array(
						'no' => array('value' => '', 'text' => __('No', 'wpproads')),
						'yes' => array('value' => 1, 'text' => __('Yes', 'wpproads'))
					)
				));
			$html.= '</div>';
			
			
		   
			$html.= '<div>';
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Contract Type','wpproads'),
					'desc' => __('Select a contract type.','wpproads'),
					'id' => 'wppas_adzone_bs_contract',
					'value' => $bs_contract,
					'size' => 'one_forth',
					'select_opts' => array(
						'ppc' => array('text' => __('Pay per Click', 'wpproads')),
						'ppv' => array('text' => __('Pay per View', 'wpproads')),
						'ppd' => array('text' => __('Pay per Day', 'wpproads'))
					)
				));
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Contract Duration','wpproads'),
					'desc' => __('Select the duration amount for the contract.','wpproads'),
					'id' => 'wppas_adzone_bs_duration', 
					'placeholder' => 10,
					'value' => $bs_duration,
					'size' => 'one_forth',
					'icon' => 'clock-o'
				));
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => sprintf(__('Price %s','wpproads'), '('.$bs_data['cur'].')'),
					'desc' => __('Price for the selected contract duration.','wpproads'),
					'id' => 'wppas_adzone_bs_price', 
					'placeholder' => 100,
					'value' => $bs_price,
					'size' => 'one_forth',
					'icon' => 'money'
				));
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => sprintf(__('Position bids %s','wpproads'), '('.$bs_data['cur'].')'),
					'desc' => __('Price for single bids to adjust banner positions.','wpproads'),
					'id' => 'wppas_adzone_bs_pos_bid', 
					'placeholder' => 5,
					'value' => $bs_pos_bid,
					'size' => 'one_forth',
					'icon' => 'money'
				));
				
			$html.= '</div>';
			   
			
		$html.= '</div>';
		// end .vbc_option_box
		
		
		
		// -- 5. Display Options for posts and categories --	
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">5</span>';
				$html.= '<span class="text">'.__('Display Options for Posts & Categories','wpproads').'</span>';
			$html.= '</div>';
			
			
			// Add banner to posts automatically
			$all_post_ad = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'auto_show', 'default' => array(), 'request' => 'adzone'));
			$all_post_ad = !empty($all_post_ad) ? $all_post_ad['post_types'] : $all_post_ad;
			
			$html.= '<div class="input_container one_third">';
				$html.= '<h3 class="title" style="font-size: 12px;color: #333;">'.__('Add to all posts automatically','wpproads').'</h3>';
				$html.= '<select id="wppas_all_post_ad" name="wppas_all_post_ad[]" data-placeholder="'.__('No post types selected.', 'wpproads').'" class="chosen-select-ad-dashboard" multiple>';
					$html.= '<option value="0">'.__('','wpproads').'</option>';
					
					$post_types = get_post_types();
					if( !empty($post_types ))
					{
						foreach( $post_types as $post_type )
						{
							$exclude = array('attachment', 'revision', 'nav_menu_item', 'vbc_banners');
							if( !in_array( $post_type, PAS()->cpts ) && !in_array( $post_type, $exclude))
							{
								$selected = !empty($all_post_ad) && in_array($post_type, $all_post_ad) ? 'selected' : '';
								$html.= '<option value="'.$post_type.'" '.$selected.'>'.$post_type.'</option>';
							}
						}
					}
				$html.= '</select>';
				$html.= '<span class="description bottom">'.__('Select the post types where you want to show this adzone automatically for every post.','wpproads').'</span>';
			$html.= '</div>';
			
			// Position
			//$all_ad_pos = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'auto_show', 'default' => array()));
			$all_ad_pos = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'auto_show', 'default' => array()));
			$all_ad_pos = !empty($all_ad_pos) ? $all_ad_pos['position'] : '';
			
			$html.= WPPAS_TPL::select_cont(array(
				'title' => __('Position','wpproads'),
				'desc' => __('Where do you want to show the adzone in the post.','wpproads'),
				'id' => 'wppas_all_post_ad_position',
				'value' => $all_ad_pos,
				'select_opts' => array(
					'top' => array('text' => __('Top of the post', 'wpproads')),
					'middle' => array('text' => __('Middle of the post', 'wpproads')),
					'bottom' => array('text' => __('Bottom of the post', 'wpproads'))
				),
				'size' => 'one_third'
			));
			
			
			// Paragraph
			//$all_ad_parag = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'auto_show', 'default' => array()));
			$all_ad_parag = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'auto_show', 'default' => array(), 'request' => 'adzone'));
			$all_ad_parag = !empty($all_ad_parag) ? $all_ad_parag['paragraph'] : '';
			
			$html.= WPPAS_TPL::inpt_cont(array(
				'title' => __('Paragraphs (number)','wpproads'),
				'desc' => __('Select after how many paragraphs the ad should show (only works if you choose the middle position).','wpproads'),
				'id' => 'wppas_all_post_ad_parag', 
				'placeholder' => 2,
				'value' => $all_ad_parag,
				'size' => 'one_third'
			));
			
			// Shortcode
			$all_ad_sc = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'auto_show', 'default' => array(), 'request' => 'adzone'));
			//$all_ad_sc = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'auto_show', 'default' => array()));
			$all_ad_sc = !empty($all_ad_sc) ? $all_ad_sc['shortcode'] : '';
			
			$html.= WPPAS_TPL::inpt_cont(array(
				'title' => __('<em>(Optional)</em> Shortcode','wpproads'),
				'desc' => __('Add the shortcode here if you want to add extra customized attributes for this banner.','wpproads'),
				'id' => 'wppas_all_post_ad_sc', 
				'value' => $all_ad_sc
			));
			
			
			
			
			// Advanced banner-link options 
			$html.= '<div class="wppas_sep_line">';
				$html.= '<span><strong>'.__("Hiding options","wpproads").'</strong></span>';
			$html.= '</div>';
			
	
			// Show/Hide
			$showhide = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'showhide', 'default' => 0));
			$html.= WPPAS_TPL::checkbox_cont(array(
				'title' => __('Show / Hide:','wpproads'),
				'desc' => __('Show or Hide the adzone:','wpproads'),
				'id' => 'wppas_showhide',
				'chk-on' => __('Show','wpproads'),
				'chk-off' => __('Hide','wpproads'),
				'value' => $showhide
			));
			
			
			// Hide for Categories.
			$categories = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'hide_for_categories', 'default' => array(), 'request' => 'adzone'));
			//$categories = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'hide_for_categories', 'default' => ''));
			
			$html.= '<div class="input_container one_second">';
				
				$html.= '<h3 style="font-size: 12px;color: #333;">'.__('for Categories','wpproads').'</h3>';
				$html.= '<select id="wppas_adzone_hide_categories" name="adzone_categories[]" data-placeholder="'.__('Select Categories', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
					$html.= '<option value=""></option>';
	
					$taxonomies = get_taxonomies();
					$allowed_taxonomies = apply_filters( 'wp_pro_ads_banner_limit_categories', array('category'));
					$allowed_taxonomies = apply_filters( 'wpproads_hide_categories', $allowed_taxonomies);
					
					foreach($taxonomies as $i => $taxonomy)
					{
						$terms = get_terms($taxonomy);
						foreach($terms as $cat)
						{
							if(in_array($cat->taxonomy, $allowed_taxonomies))
							{
								$selected = !empty($categories) && is_array($categories) ? in_array($cat->term_id, $categories) ? 'selected' : '' : '';
								$html.= '<option value="'.$cat->term_id.'" '.$selected.'>'.$cat->name.' - (ID:'.$cat->term_id.')</option>';
							}
						}
					}
				$html.= '</select>';
				$html.= '<span class="description bottom">'.__('Select the categories you want this banner to show/hide for.','wpproads').'</span>';
			$html.= '</div>';
			
			
			// Hide for Tags.
			$tags = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'hide_for_tags', 'default' => array(), 'request' => 'adzone'));
			//$tags = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'hide_for_tags', 'default' => ''));
			
			$html.= '<div class="input_container one_second">';
				
				$html.= '<h3 style="font-size: 12px;color: #333;">'.__('for Tags','wpproads').'</h3>';
				$html.= '<select id="wppas_adzone_hide_tags" name="adzone_tags[]" data-placeholder="'.__('Select Tags', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
					$html.= '<option value=""></option>';
	
					$taxonomies = get_taxonomies();
					$allowed_taxonomies = apply_filters( 'wpproads_hide_tags', array('post_tag'));
					
					foreach($taxonomies as $i => $taxonomy)
					{
						$terms = get_terms($taxonomy);
						foreach($terms as $tag)
						{
							if(in_array($tag->taxonomy, $allowed_taxonomies))
							{
								$selected = !empty($tags) && is_array($tags) ? in_array($tag->term_id, $tags) ? 'selected' : '' : '';
								$html.= '<option value="'.$tag->term_id.'" '.$selected.'>'.$tag->name.' - (ID:'.$tag->term_id.')</option>';
							}
						}
					}
				$html.= '</select>';
				$html.= '<span class="description bottom">'.__('Select the tags you want this banner to show/hide for.','wpproads').'</span>';
			$html.= '</div>';
			
			
			
			// Hide for Posts.
			$posts = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'hide_for_posts', 'default' => array(), 'request' => 'adzone'));
			//$posts = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'hide_for_posts', 'default' => ''));
			
			$html.= '<div class="input_container one_second">';
				
				$html.= '<h3 style="font-size: 12px;color: #333;">'.__('for Posts','wpproads').'</h3>';
				$html.= '<select id="wppas_adzone_hide_posts" name="adzone_posts[]" data-placeholder="'.__('Select Posts', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
					$html.= '<option value=""></option>';
					
					$all_posts = get_posts(array(
						'posts_per_page'   => -1,
						'post_status'      => 'publish',
						'post_type'        => apply_filters( 'wpproads_hide_posts', array('post'))
					));
	
					foreach($all_posts as $i => $post)
					{
						$selected = !empty($posts) && is_array($posts) ? in_array($post->ID, $posts) ? 'selected' : '' : '';
						$html.= '<option value="'.$post->ID.'" '.$selected.'>'.$post->post_name.' - (ID:'.$post->ID.')</option>';
					}
				$html.= '</select>';
				$html.= '<span class="description bottom">'.__('Select the posts you want this banner to show/hide for.','wpproads').'</span>';
			$html.= '</div>';
			
			// Hide for Pages.
			$posts = WPPAS_TPL::vbc_data(array('id' => $args['aid'], 'type' => 'hide_for_pages', 'default' => array(), 'request' => 'adzone'));
			//$posts = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'hide_for_pages', 'default' => ''));
			
			$html.= '<div class="input_container one_second">';
				
				$html.= '<h3 style="font-size: 12px;color: #333;">'.__('for Pages','wpproads').'</h3>';
				$html.= '<select id="wppas_adzone_hide_pages" name="adzone_pages[]" data-placeholder="'.__('Select Pages', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
					$html.= '<option value=""></option>';
					
					$all_posts = get_posts(array(
						'posts_per_page'   => -1,
						'post_status'      => 'publish',
						'post_type'        => apply_filters( 'wpproads_hide_pages', array('page'))
					));
	
					foreach($all_posts as $i => $post)
					{
						$selected = !empty($posts) && is_array($posts) ? in_array($post->ID, $posts) ? 'selected' : '' : '';
						$html.= '<option value="'.$post->ID.'" '.$selected.'>'.$post->post_name.' - (ID:'.$post->ID.')</option>';
					}
				$html.= '</select>';
				$html.= '<span class="description bottom">'.__('Select the pages you want this banner to show/hide for.','wpproads').'</span>';
			$html.= '</div>';
		
		$html.= '</div>';
		// end .vbc_option_box
			
		
		
		// ---------------- Save benner function in  - jquery.wppas.vbc.editor.js - arround line 780
		$html.= '<a class="wppas_home_tpl_btn main green save_adzone save"><i class="fa fa-save" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Save Adzone','wpproads').'</a>';
		$html.= $this->start_screen_js();
		
		return $html;
	}


	
	
	
	/** 
	 * START SCREEN JS TEMPLATE
	 *
	 */
	public function start_screen_js()
	{
		global $wppas_banner_creator;
		
		$sizes = $wppas_banner_creator->screen_sizes(); 
		$screen_sizes = json_encode($sizes);
		
		$js = '';
        $js.= '<script type="text/javascript">';
		
			$js.= 'var _VBC = jQuery("#wppas_visual_bc_container");';
			$js.= 'var screen_sizes = '.$screen_sizes.';';
			
			$js.= 'jQuery(document).ready(function($) {';
				
				$js.= '_VBC.wppas.wppas_adzone_startscreen({screen_sizes: screen_sizes});';
				$js.= '_VBC.wppas.activate_switch_buttons();';
				
			$js.= '});';
			
		$js.= '</script>';
       
		return $js;
	}

	
	
	
	
	public function linked_banners_template( $args = array() )
	{
		global $wppas_banner_creator;
		
		$defaults = array(
			'aid'        => 0, 
		);
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$data = $this->load_adzone_data($args['aid']);
		$linked_banners = $data['adzone_data'][0]['banners'];
		
		$html.= WPPAS_TPL::info_box(array(
			'desc' => sprintf(__('To link banners to this adzone go to the %s','wpproads'), '<a href="admin.php?page=wppas-banner-creator">main page</a> and Drag&Drop the banners you want to add into the adzone.'),
			'icon' => 'info-circle'
		));
		
		
		// -- 1. Linked Banners --
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">1</span>';
				$html.= '<span class="text">'.__('Linked Banners','wpproads').'</span>';
			$html.= '</div>';
			
			$html.= '<div id="linked_banners_container" data-id="'.$args['aid'].'">';
				
				if( !empty($linked_banners))
				{
					foreach($linked_banners as $linked_banner)
					{
						if( get_post_status( $linked_banner ) == 'publish' )
						{
							$html.= $wppas_banner_creator->adzone_linked_banner_item($linked_banner);
						}
					}
				}
				
			$html.= '</div>';
			// end .linked_banners_container
			
		$html.= '</div>';
		// end .vbc_option_box	
		
		
		$html.= '';
		
		return $html;
	}



	public function export_template( $args = array())
	{
		global $pro_ads_multisite, $wppas_banner_creator;
		
		$html = '';
		$adzone = !empty($args['aid']) ? $this->load_adzone_data($args['aid']) : '';
		
		$html.= '<div class="export_options" style="display:inline-block;width:40%;min-width:300px;">';
			// -- SHORTCODE --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">1</span>';
					$html.= '<span class="text">'.__('Shortcode','wpproads').'</span>';
				$html.= '</div>';
				
				// Shortcode
				$html.= '<span class="input_container">';
					$html.= '<div class="export_sc_cont">';
						if( !empty($args['aid']) )
						{
							$html.= '<input type="text" value="[wpproads id="'.$args['aid'].'"]" />';
							$html.= '<i class="input_icon fa fa-pencil" aria-hidden="true"></i>';
							$html.= '<span class="description bottom">'.__('A Wordpress shortcode to show the adzone on this website only.','wpproads').'</span>';
						}
						else
						{
							$html.= '<span class="description bottom">'.__('You need to save the adzone in order for this option to be available.','wpproads').'</span>';
						}
					$html.= '</div>';
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box	
			
			
			$html.= '<div class="wppas_sep_line" style="margin: 50px 0 15px 0;">';
				$html.= '<span style="background-color:#FFF;"><strong>'.__("Additional export options","wpproads").'</strong></span>';
			$html.= '</div>';
			
			$html.= '<div style="margin: 0 0 40px;">';
				$html.= 'The following options allow you to show the adzone as a default inline adzone only. Display options selected above will not work on the iframe or HTML options.';
			$html.= '</div>';
			
			// -- IFRAME --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">2</span>';
					$html.= '<span class="text">'.__('Iframe','wpproads').'</span>';
				$html.= '</div>';
				
				$html.= '<span class="input_container">';
					$html.= '<div class="export_iframe_cont">';
						if( !empty($args['aid']) )
						{
							$if = '';
							$if.= '<div style="max-width:'.$adzone['adzone_data'][0]['w'].'px; width:100%; height:'.$adzone['adzone_data'][0]['h'].'px;">';
								$if.= '<iframe ';
									$if.= 'src="'.$pro_ads_multisite->wpproads_get_site_url().'?wppasaid='.$args['aid'].'" ';
									$if.= 'border="0" ';
									$if.= 'scrolling="no" ';
									$if.= 'allowtransparency="true" ';
									//$if.= 'width="100%" ';
									//$if.= 'height="100%" ';
									$if.= 'style="width:1px;min-width:100%;*width:100%;height:100%;border:0;">';
									//$if.= 'style="border:0;">';
							   $if.= '</iframe>';
						   $if.= '</div>';
						   
							$html.= '<textarea id="wppas_iframe_code" style="width:100%; height:100px; font-size: 11px; font-weight: normal; margin-bottom: 10px;" readonly="readonly">'.$if.'</textarea>';
							$html.= '<span class="description bottom">'.__('Iframe code. This code can be used to place the adzone anywhere you want even on other websites.','wpproads').'</span>';
						}
						else
						{
							$html.= '<span class="description bottom">'.__('You need to save the banner in order for this option to be available.','wpproads').'</span>';
						}
					$html.= '</div>';
					
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box	
			
		$html.= '</div>';
		// end .export_options
		
		// -- DISPLAY OPTIONS --
		$html.= $wppas_banner_creator->wppas_display_options(array('ID' => $args['aid'], 'type' => 'adzone'));
		
		/*// -- HTML --
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">3</span>';
				$html.= '<span class="text">'.__('HTML Code','wpproads').'</span>';
			$html.= '</div>';
			
			$html.= '<span class="input_container">';
				//$html.= '<h5 style="margin:0;">'.__('To use on this website','wpproads').'</h5>';
				$html.= '<textarea id="wppas_html_code" style="width:100%; height:150px; font-size: 11px; font-weight: normal; margin-bottom: 10px;" readonly="readonly"></textarea>';
				$html.= '<span class="description bottom">'.__('Banner HTML code. This code can be used to place the banner anywhere you want even on other websites.','wpproads').'</span>';
				
			$html.= '</span>';
			
		$html.= '</div>';
		// end .vbc_option_box	
		
		
		
		// -- EXPORT CODE --
		$html.= '<div class="vbc_option_box">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">4</span>';
				$html.= '<span class="text">'.__('Export','wpproads').'</span>';
			$html.= '</div>';
			
			// Export code
			$html.= '<span class="input_container">';
				//$html.= '<h5 style="margin:0;">'.__('Export code','wpproads').'</h5>';
				$html.= '<div class="export_cd_cont">';
					
					$html.= '<textarea id="wppas_export_code" style="width:100%; height:150px; font-size: 11px; font-weight: normal; margin-bottom: 10px;"></textarea>';
					$html.= '<span class="description bottom">'.__('Export banner to import into another website.','wpproads').'</span>';
					
				$html.= '</div>';
			$html.= '</span>';
			
		$html.= '</div>';
		// end .vbc_option_box	
		*/
		
		
		return $html;
	}
	
	
	
	
	
	public function save_confirms()
	{
		$array = array(
			__('SAVED','wpproads'),
			__('Good Job','wpproads'),
			__('NICE','wpproads'),
			__('SWEET','wpproads'),
			__('DONE','wpproads'),
		);
		
		wp_localize_script( 'WPPAS_VBC_ADZN_STSCRN', 'itm_editor_save_confirms', array('array' => json_encode($array)) );
		return $array;
	}
	
	
	
	
	
	
	
	/** 
	 * ADZONE REMOVE CONFIRMATION
	 *
	 */
	public function adzone_remove_confirmation($aid)
	{
		$html = '';
		$html.= '<div class="wppas_remove_confirmation">';
			$html.= '<h3 style="margin-bottom:20px;">'.__('Adzone Removed','wpproads').'</h3>';
			$html.= '<a id="wppas_undo_adzone_removal" class="wppas_confi_btn" data-id="'.$aid.'">';
				$html.= '<div style="font-size:30px;margin-top:25px;"><i class="fa fa-undo" aria-hidden="true"></i></div>';
				$html.= '<div>'.__('Undo','wpproads').'</div>';
			$html.= '</a>';
			$html.= '<a href="admin.php?page=wppas-banner-creator&view=adzone_editor" class="wppas_confi_btn">';
				$html.= '<div style="font-size:30px;margin-top:25px;"><i class="fa fa-pencil" aria-hidden="true"></i></div>';
				$html.= '<div>'.__('New Adzone','wpproads').'</div>';
			$html.= '</a>';
			$html.= '<a href="admin.php?page=wppas-banner-creator&view=banners" class="wppas_confi_btn">';
				$html.= '<div style="font-size:30px;margin-top:25px;"><i class="fa fa-object-ungroup" aria-hidden="true"></i></div>';
				$html.= '<div>'.__('All Adzones','wpproads').'</div>';
			$html.= '</a>';
		$html.= '</div>';
		
		return $html;
	}
	
	
	
	
	
	
	
	/*
	 * Add ads to posts if necessary
	 *
	 * @access public
	 * @return array
	*/
	public function update_content($content) 
	{
		global $post;
		
		if(!is_single() && !is_page())
		{
			return $content;
		}
		
		// Load all banners
		$adzones = $this->all_adzones_query();
		$new_content = '';
		
		if( !empty($adzones))
		{
			foreach( $adzones as $adzone )
			{
				$data = WPPAS_TPL::vbc_data(array('id' => $adzone->ID, 'type' => 'auto_show', 'default' => array()));
				$post_types = !empty($data) ? $data['post_types'] : $data;
				$content_str = !empty($new_content) ? $new_content : $content;
				
				if(!empty($post_types))
				{
					if( in_array(get_post_type( $post->ID ), $post_types))
					{	
						$show = apply_filters( 'wpproads_show_adzone_in_post', 1, $post->ID );
					
						if( $show )
						{	
							$ad = !empty($data['shortcode']) ? do_shortcode($data['shortcode']) : do_shortcode('[wpproads id="'.$adzone->ID.'"]');
							if( $data['position'] == 'top' )
							{
								$new_content = $ad.$content_str;
							}
							elseif( $data['position'] == 'bottom')
							{
								$new_content = $content_str.$ad;
							}
							elseif( $data['position'] == 'middle')
							{
								//$str = !empty($new_content) ? $new_content : $content;
								$cont_arr = explode ( "</p>", $content_str );
								$new_cont = '';
								foreach( $cont_arr as $i => $cont )
								{
									if ( $i == $data['paragraph'] ) 
									{
										$new_cont.= $ad;
									}
									$new_cont.= $cont . "</p>";
								}
								$new_content = $new_cont;
							}
						}
					}
				}
			}
		}
		
		return !empty($new_content) ? $new_content : $content;
	}
	
	
	
	
	
	
	
	
	
	
	/** 
	 * JSSON ROTATION EFFECTS JSON
	 *
	 */
	public function jssor_rotation_effects()
	{
		$json = '[{"text":"------------ Fade Effects --------------","value":""},{"text":"Fade","value":"{$Duration:1200,$Opacity:2}"},{"text":"Fade in L","value":"{$Duration:1200,x:0.3,$During:{$Left:[0.3,0.7]},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in R","value":"{$Duration:1200,x:-0.3,$During:{$Left:[0.3,0.7]},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in T","value":"{$Duration:1200,y:0.3,$During:{$Top:[0.3,0.7]},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in B","value":"{$Duration:1200,y:-0.3,$During:{$Top:[0.3,0.7]},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in LR","value":"{$Duration:1200,x:0.3,$Cols:2,$During:{$Left:[0.3,0.7]},$ChessMode:{$Column:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in LR Chess","value":"{$Duration:1200,y:0.3,$Cols:2,$During:{$Top:[0.3,0.7]},$ChessMode:{$Column:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in TB","value":"{$Duration:1200,y:0.3,$Rows:2,$During:{$Top:[0.3,0.7]},$ChessMode:{$Row:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in TB Chess","value":"{$Duration:1200,x:0.3,$Rows:2,$During:{$Left:[0.3,0.7]},$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade in Corners","value":"{$Duration:1200,x:0.3,y:0.3,$Cols:2,$Rows:2,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out L","value":"{$Duration:1200,x:0.3,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out R","value":"{$Duration:1200,x:-0.3,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out T","value":"{$Duration:1200,y:0.3,$SlideOut:true,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out B","value":"{$Duration:1200,y:-0.3,$SlideOut:true,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out LR","value":"{$Duration:1200,x:0.3,$Cols:2,$SlideOut:true,$ChessMode:{$Column:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out LR Chess","value":"{$Duration:1200,y:-0.3,$Cols:2,$SlideOut:true,$ChessMode:{$Column:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out TB","value":"{$Duration:1200,y:0.3,$Rows:2,$SlideOut:true,$ChessMode:{$Row:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out TB Chess","value":"{$Duration:1200,x:-0.3,$Rows:2,$SlideOut:true,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade out Corners","value":"{$Duration:1200,x:0.3,y:0.3,$Cols:2,$Rows:2,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade Fly in L","value":"{$Duration:1200,x:0.3,$During:{$Left:[0.3,0.7]},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in R","value":"{$Duration:1200,x:-0.3,$During:{$Left:[0.3,0.7]},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in T","value":"{$Duration:1200,y:0.3,$During:{$Top:[0.3,0.7]},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in B","value":"{$Duration:1200,y:-0.3,$During:{$Top:[0.3,0.7]},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in LR","value":"{$Duration:1200,x:0.3,$Cols:2,$During:{$Left:[0.3,0.7]},$ChessMode:{$Column:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in LR Chess","value":"{$Duration:1200,y:0.3,$Cols:2,$During:{$Top:[0.3,0.7]},$ChessMode:{$Column:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in TB","value":"{$Duration:1200,y:0.3,$Rows:2,$During:{$Top:[0.3,0.7]},$ChessMode:{$Row:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in TB Chess","value":"{$Duration:1200,x:0.3,$Rows:2,$During:{$Left:[0.3,0.7]},$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly in Corners","value":"{$Duration:1200,x:0.3,y:0.3,$Cols:2,$Rows:2,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out L","value":"{$Duration:1200,x:0.3,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out R","value":"{$Duration:1200,x:-0.3,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out T","value":"{$Duration:1200,y:0.3,$SlideOut:true,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out B","value":"{$Duration:1200,y:-0.3,$SlideOut:true,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out LR","value":"{$Duration:1200,x:0.3,$Cols:2,$SlideOut:true,$ChessMode:{$Column:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out LR Chess","value":"{$Duration:1200,y:0.3,$Cols:2,$SlideOut:true,$ChessMode:{$Column:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out TB","value":"{$Duration:1200,y:0.3,$Rows:2,$SlideOut:true,$ChessMode:{$Row:12},$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out TB Chess","value":"{$Duration:1200,x:0.3,$Rows:2,$SlideOut:true,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Fly out Corners","value":"{$Duration:1200,x:0.3,y:0.3,$Cols:2,$Rows:2,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true}"},{"text":"Fade Clip in H","value":"{$Duration:1200,$Delay:20,$Clip:3,$Assembly:260,$Easing:{$Clip:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade Clip in V","value":"{$Duration:1200,$Delay:20,$Clip:12,$Assembly:260,$Easing:{$Clip:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade Clip out H","value":"{$Duration:1200,$Delay:20,$Clip:3,$SlideOut:true,$Assembly:260,$Easing:{$Clip:$Jease$.$OutCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade Clip out V","value":"{$Duration:1200,$Delay:20,$Clip:12,$SlideOut:true,$Assembly:260,$Easing:{$Clip:$Jease$.$OutCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Fade Stairs","value":"{$Duration:800,$Delay:30,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:2050,$Opacity:2}"},{"text":"Fade Random","value":"{$Duration:1000,$Delay:80,$Cols:8,$Rows:4,$Opacity:2}"},{"text":"Fade Swirl","value":"{$Duration:800,$Delay:30,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Opacity:2}"},{"text":"Fade ZigZag","value":"{$Duration:800,$Delay:30,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Opacity:2}"},{"text":"------------ Swing Outside Effects --------------","value":"null"},{"text":"Swing Outside in Stairs","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside in ZigZag","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside in Swirl","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside in Random","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside in Random Chess","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$ChessMode:{$Column:3,$Row:3},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside in Square","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside out Stairs","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside out ZigZag","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside out Swirl","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside out Random","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside out Random Chess","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$ChessMode:{$Column:3,$Row:3},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Outside out Square","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:1.3,$Top:2.5}}"},{"text":"------------ Swing Inside Effects --------------","value":"null"},{"text":"Swing Inside in Stairs","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Inside in ZigZag","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Inside in Swirl","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Inside in Random","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Inside in Random Chess","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$ChessMode:{$Column:3,$Row:3},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Inside in Square","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Inside out ZigZag","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"Swing Inside out Swirl","value":"{$Duration:1200,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:1.3,$Top:2.5}}"},{"text":"------------ Dodge Dance Outside Effects --------------","value":"null"},{"text":"Dodge Dance Outside in Stairs","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside in Swirl","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside in ZigZag","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside in Random","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside in Random Chess","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside in Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Linear},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside out Stairs","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.1,0.9],$Top:[0.1,0.9]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside out Swirl","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.1,0.9],$Top:[0.1,0.9]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside out ZigZag","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.1,0.9],$Top:[0.1,0.9]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside out Random","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside out Random Chess","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Outside out Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Linear},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"------------ Dodge Dance Inside Effects --------------","value":"null"},{"text":"Dodge Dance Inside in Stairs","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside in Swirl","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside in ZigZag","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside in Random","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside in Random Chess","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside in Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Linear},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside out Stairs","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.1,0.9],$Top:[0.1,0.9]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside out Swirl","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.1,0.9],$Top:[0.1,0.9]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside out ZigZag","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.1,0.9],$Top:[0.1,0.9]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside out Random","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside out Random Chess","value":"{$Duration:1500,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Dance Inside out Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Linear},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"------------ Dodge Pet Outside Effects --------------","value":"null"},{"text":"Dodge Pet Outside in Stairs","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside in Swirl","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside in ZigZag","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside in Random","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside in Random Chess","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside in Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside out Stairs","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside out Swirl","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside out ZigZag","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside out Random","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside out Random Chess","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Outside out Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Outside:true,$Round:{$Left:0.8,$Top:2.5}}"},{"text":"------------ Dodge Pet Inside Effects --------------","value":"null"},{"text":"Dodge Pet Inside in Stairs","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside in Swirl","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside in ZigZag","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside in Random","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside in Random Chess","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside in Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside out Stairs","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside out Swirl","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside out ZigZag","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside out Random","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside out Random Chess","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$Linear},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"Dodge Pet Inside out Square","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InWave,$Top:$Jease$.$InWave,$Clip:$Jease$.$OutQuad},$Round:{$Left:0.8,$Top:2.5}}"},{"text":"------------ Dodge Outside Effects --------------","value":"null"},{"text":"Dodge Outside out Stairs","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside out Swirl","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside out ZigZag","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside out Random","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside out Random Chess","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Assembly:260,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside out Square","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside in Stairs","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside in Swirl","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside in ZigZag","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside in Random","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside in Random Chess","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Assembly:260,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Outside in Square","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump},$Outside:true,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"------------ Dodge Inside Effects --------------","value":"null"},{"text":"Dodge Inside out Stairs","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out Swirl","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out ZigZag","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out Random","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out Random Chess","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Assembly:260,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out Square","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in Stairs","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in Swirl","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in ZigZag","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in Random","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in Random Chess","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Assembly:260,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in Square","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:20,$Cols:8,$Rows:4,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8]},$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Clip:$Jease$.$Swing},$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in TL","value":"{$Duration:1200,x:0.3,y:0.3,$Delay:60,$Zoom:1,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in TR","value":"{$Duration:1200,x:-0.3,y:0.3,$Delay:60,$Zoom:1,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in BL","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:60,$Zoom:1,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside in BR","value":"{$Duration:1200,x:-0.3,y:-0.3,$Delay:60,$Zoom:1,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out TL","value":"{$Duration:1200,x:0.3,y:0.3,$Delay:60,$Zoom:1,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out TR","value":"{$Duration:1200,x:-0.3,y:0.3,$Delay:60,$Zoom:1,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out BL","value":"{$Duration:1200,x:0.3,y:-0.3,$Delay:60,$Zoom:1,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"Dodge Inside out BR","value":"{$Duration:1200,x:-0.3,y:-0.3,$Delay:60,$Zoom:1,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InJump,$Top:$Jease$.$InJump,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Left:0.8,$Top:0.8}}"},{"text":"------------ Flutter Outside Effects --------------","value":"null"},{"text":"Flutter Outside in","value":"{$Duration:1800,x:1,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InOutExpo,$Clip:$Jease$.$InOutQuad},$Outside:true,$Round:{$Top:0.8}}"},{"text":"Flutter Outside in Wind","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Outside:true,$Round:{$Top:1.3}}"},{"text":"Flutter Outside in Swirl","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Outside:true,$Round:{$Top:1.3}}"},{"text":"Flutter Outside in Column","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:150,$Cols:12,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true,$Round:{$Top:2}}"},{"text":"Flutter Outside out","value":"{$Duration:1800,x:1,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InOutExpo,$Clip:$Jease$.$InOutQuad},$Outside:true,$Round:{$Top:0.8}}"},{"text":"Flutter Outside out Wind","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Outside:true,$Round:{$Top:1.3}}"},{"text":"Flutter Outside out Swirl","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Outside:true,$Round:{$Top:1.3}}"},{"text":"Flutter Outside out Column","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:150,$Cols:12,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true,$Round:{$Top:2}}"},{"text":"------------ Flutter Inside Effects --------------","value":"null"},{"text":"Flutter Inside in","value":"{$Duration:1800,x:1,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7]},$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InOutExpo,$Clip:$Jease$.$InOutQuad},$Round:{$Top:0.8}}"},{"text":"Flutter Inside in Wind","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Round:{$Top:1.3}}"},{"text":"Flutter Inside in Swirl","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Round:{$Top:1.3}}"},{"text":"Flutter Inside in Column","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:150,$Cols:12,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Top:2}}"},{"text":"Flutter Inside out","value":"{$Duration:1800,x:1,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InOutExpo,$Clip:$Jease$.$InOutQuad},$Round:{$Top:0.8}}"},{"text":"Flutter Inside out Wind","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Round:{$Top:1.3}}"},{"text":"Flutter Inside out Swirl","value":"{$Duration:1800,x:1,y:0.2,$Delay:30,$Cols:10,$Rows:5,$Clip:15,$During:{$Left:[0.3,0.7],$Top:[0.3,0.7]},$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:2050,$Easing:{$Left:$Jease$.$InOutSine,$Top:$Jease$.$OutWave,$Clip:$Jease$.$InOutQuad},$Round:{$Top:1.3}}"},{"text":"Flutter Inside out Column","value":"{$Duration:1500,x:0.2,y:-0.1,$Delay:150,$Cols:12,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave,$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Top:2}}"},{"text":"------------ Rotate Effects --------------","value":"null"},{"text":"Rotate VDouble+ in","value":"{$Duration:1200,x:-1,y:2,$Rows:2,$Zoom:11,$Rotate:1,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate HDouble+ in","value":"{$Duration:1200,x:2,y:1,$Cols:2,$Zoom:11,$Rotate:1,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate VDouble- in","value":"{$Duration:1200,x:-0.5,y:1,$Rows:2,$Zoom:1,$Rotate:1,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate HDouble- in","value":"{$Duration:1200,x:0.5,y:0.3,$Cols:2,$Zoom:1,$Rotate:1,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate VDouble+ out","value":"{$Duration:1000,x:-1,y:2,$Rows:2,$Zoom:11,$Rotate:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.85}}"},{"text":"Rotate HDouble+ out","value":"{$Duration:1000,x:4,y:2,$Cols:2,$Zoom:11,$Rotate:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate VDouble- out","value":"{$Duration:1000,x:-0.5,y:1,$Rows:2,$Zoom:1,$Rotate:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate HDouble- out","value":"{$Duration:1000,x:0.5,y:0.3,$Cols:2,$Zoom:1,$Rotate:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate VFork+ in","value":"{$Duration:1200,x:-4,y:2,$Rows:2,$Zoom:11,$Rotate:1,$Assembly:2049,$ChessMode:{$Row:28},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate HFork+ in","value":"{$Duration:1200,x:1,y:2,$Cols:2,$Zoom:11,$Rotate:1,$Assembly:2049,$ChessMode:{$Column:19},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate VFork+ out","value":"{$Duration:1000,x:-3,y:1,$Rows:2,$Zoom:11,$Rotate:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Row:28},$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate HFork+ out","value":"{$Duration:1000,x:1,y:2,$Cols:2,$Zoom:11,$Rotate:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Column:19},$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ in","value":"{$Duration:1200,$Zoom:11,$Rotate:1,$Easing:{$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in L","value":"{$Duration:1200,x:4,$Zoom:11,$Rotate:1,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in R","value":"{$Duration:1200,x:-4,$Zoom:11,$Rotate:1,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in T","value":"{$Duration:1200,y:4,$Zoom:11,$Rotate:1,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in B","value":"{$Duration:1200,y:-4,$Zoom:11,$Rotate:1,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in TL","value":"{$Duration:1200,x:4,y:4,$Zoom:11,$Rotate:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in TR","value":"{$Duration:1200,x:-4,y:4,$Zoom:11,$Rotate:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in BL","value":"{$Duration:1200,x:4,y:-4,$Zoom:11,$Rotate:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ in BR","value":"{$Duration:1200,x:-4,y:-4,$Zoom:11,$Rotate:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.7}}"},{"text":"Rotate Zoom+ out","value":"{$Duration:1000,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out L","value":"{$Duration:1000,x:4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out R","value":"{$Duration:1000,x:-4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out T","value":"{$Duration:1000,y:4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out B","value":"{$Duration:1000,y:-4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out TL","value":"{$Duration:1000,x:4,y:4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out TR","value":"{$Duration:1000,x:-4,y:4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out BL","value":"{$Duration:1000,x:4,y:-4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom+ out BR","value":"{$Duration:1000,x:-4,y:-4,$Zoom:11,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InExpo},$Opacity:2,$Round:{$Rotate:0.8}}"},{"text":"Rotate Zoom- in","value":"{$Duration:1200,$Zoom:1,$Rotate:1,$During:{$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in L","value":"{$Duration:1200,x:0.6,$Zoom:1,$Rotate:1,$During:{$Left:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Left:$Jease$.$Swing,$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in R","value":"{$Duration:1200,x:-0.6,$Zoom:1,$Rotate:1,$During:{$Left:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Left:$Jease$.$Swing,$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in T","value":"{$Duration:1200,y:0.6,$Zoom:1,$Rotate:1,$During:{$Top:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in B","value":"{$Duration:1200,y:-0.6,$Zoom:1,$Rotate:1,$During:{$Top:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in TL","value":"{$Duration:1200,x:0.6,y:0.6,$Zoom:1,$Rotate:1,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in TR","value":"{$Duration:1200,x:-0.6,y:0.6,$Zoom:1,$Rotate:1,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in BL","value":"{$Duration:1200,x:0.6,y:-0.6,$Zoom:1,$Rotate:1,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- in BR","value":"{$Duration:1200,x:-0.6,y:-0.6,$Zoom:1,$Rotate:1,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8],$Zoom:[0.2,0.8],$Rotate:[0.2,0.8]},$Easing:{$Zoom:$Jease$.$Swing,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$Swing},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out","value":"{$Duration:1000,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Opacity:$Jease$.$Linear},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out L","value":"{$Duration:1000,x:0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out R","value":"{$Duration:1000,x:-0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out T","value":"{$Duration:1000,y:0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out B","value":"{$Duration:1000,y:-0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out TL","value":"{$Duration:1000,x:0.5,y:0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out TR","value":"{$Duration:1000,x:-0.5,y:0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out BL","value":"{$Duration:1000,x:0.5,y:-0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"Rotate Zoom- out BR","value":"{$Duration:1000,x:-0.5,y:-0.5,$Zoom:1,$Rotate:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InCubic},$Opacity:2,$Round:{$Rotate:0.5}}"},{"text":"------------ Zoom Effects --------------","value":"null"},{"text":"Zoom VDouble+ in","value":"{$Duration:1200,y:2,$Rows:2,$Zoom:11,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom HDouble+ in","value":"{$Duration:1200,x:4,$Cols:2,$Zoom:11,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom VDouble- in","value":"{$Duration:1200,y:1,$Rows:2,$Zoom:1,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom HDouble- in","value":"{$Duration:1200,x:0.5,$Cols:2,$Zoom:1,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom VDouble+ out","value":"{$Duration:1200,y:2,$Rows:2,$Zoom:11,$SlideOut:true,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom HDouble+ out","value":"{$Duration:1200,x:4,$Cols:2,$Zoom:11,$SlideOut:true,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom VDouble- out","value":"{$Duration:1200,y:1,$Rows:2,$Zoom:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Row:15},$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom HDouble- out","value":"{$Duration:1200,x:0.5,$Cols:2,$Zoom:1,$SlideOut:true,$Assembly:2049,$ChessMode:{$Column:15},$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ in","value":"{$Duration:1000,$Zoom:11,$Easing:{$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ in L","value":"{$Duration:1000,x:4,$Zoom:11,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ in R","value":"{$Duration:1000,x:-4,$Zoom:11,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2,$Round:{$Top:2.5}}"},{"text":"Zoom+ in T","value":"{$Duration:1000,y:4,$Zoom:11,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ in B","value":"{$Duration:1000,y:-4,$Zoom:11,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ in TL","value":"{$Duration:1000,x:4,y:4,$Zoom:11,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ in TR","value":"{$Duration:1000,x:-4,y:4,$Zoom:11,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ in BL","value":"{$Duration:1000,x:4,y:-4,$Zoom:11,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ in BR","value":"{$Duration:1000,x:-4,y:-4,$Zoom:11,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom+ out","value":"{$Duration:1000,$Zoom:11,$SlideOut:true,$Easing:{$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out L","value":"{$Duration:1000,x:4,$Zoom:11,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out R","value":"{$Duration:1000,x:-4,$Zoom:11,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out T","value":"{$Duration:1000,y:4,$Zoom:11,$SlideOut:true,$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out B","value":"{$Duration:1000,y:-4,$Zoom:11,$SlideOut:true,$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out TL","value":"{$Duration:1000,x:4,y:4,$Zoom:11,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out TR","value":"{$Duration:1000,x:-4,y:4,$Zoom:11,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out BL","value":"{$Duration:1000,x:4,y:-4,$Zoom:11,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom+ out BR","value":"{$Duration:1000,x:-4,y:-4,$Zoom:11,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- in","value":"{$Duration:1200,$Zoom:1,$Easing:{$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in L","value":"{$Duration:1200,x:0.6,$Zoom:1,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in R","value":"{$Duration:1200,x:-0.6,$Zoom:1,$Easing:{$Left:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in T","value":"{$Duration:1200,y:0.6,$Zoom:1,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in B","value":"{$Duration:1200,y:-0.6,$Zoom:1,$Easing:{$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in TL","value":"{$Duration:1200,x:0.6,y:0.6,$Zoom:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in TR","value":"{$Duration:1200,x:-0.6,y:0.6,$Zoom:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in BL","value":"{$Duration:1200,x:0.6,y:-0.6,$Zoom:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- in BR","value":"{$Duration:1200,x:-0.6,y:-0.6,$Zoom:1,$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Zoom:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Zoom- out","value":"{$Duration:1000,$Zoom:1,$SlideOut:true,$Easing:{$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out L","value":"{$Duration:1000,x:1,$Zoom:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out R","value":"{$Duration:1000,x:-1,$Zoom:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out T","value":"{$Duration:1000,y:1,$Zoom:1,$SlideOut:true,$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out B","value":"{$Duration:1000,y:-1,$Zoom:1,$SlideOut:true,$Easing:{$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out TL","value":"{$Duration:1000,x:1,y:1,$Zoom:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out TR","value":"{$Duration:1000,x:-1,y:1,$Zoom:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out BL","value":"{$Duration:1000,x:1,y:-1,$Zoom:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Zoom- out BR","value":"{$Duration:1000,x:-1,y:-1,$Zoom:1,$SlideOut:true,$Easing:{$Left:$Jease$.$InExpo,$Top:$Jease$.$InExpo,$Zoom:$Jease$.$InExpo,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"------------ Twins Effects --------------","value":"null"},{"text":"Fade Twins","value":"{$Duration:700,$Opacity:2,$Brother:{$Duration:1000,$Opacity:2}}"},{"text":"Rotate Overlap","value":"{$Duration:1200,$Zoom:11,$Rotate:-1,$Easing:{$Zoom:$Jease$.$InQuad,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Round:{$Rotate:0.5},$Brother:{$Duration:1200,$Zoom:1,$Rotate:1,$Easing:$Jease$.$Swing,$Opacity:2,$Round:{$Rotate:0.5},$Shift:90}}"},{"text":"Switch","value":"{$Duration:1400,x:0.25,$Zoom:1.5,$Easing:{$Left:$Jease$.$InWave,$Zoom:$Jease$.$InSine},$Opacity:2,$ZIndex:-10,$Brother:{$Duration:1400,x:-0.25,$Zoom:1.5,$Easing:{$Left:$Jease$.$InWave,$Zoom:$Jease$.$InSine},$Opacity:2,$ZIndex:-10}}"},{"text":"Rotate Relay","value":"{$Duration:1200,$Zoom:11,$Rotate:1,$Easing:{$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Round:{$Rotate:1},$ZIndex:-10,$Brother:{$Duration:1200,$Zoom:11,$Rotate:-1,$Easing:{$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Round:{$Rotate:1},$ZIndex:-10,$Shift:600}}"},{"text":"Doors","value":"{$Duration:1500,x:0.5,$Cols:2,$ChessMode:{$Column:3},$Easing:{$Left:$Jease$.$InOutCubic},$Opacity:2,$Brother:{$Duration:1500,$Opacity:2}}"},{"text":"Rotate in+ out-","value":"{$Duration:1500,x:-0.3,y:0.5,$Zoom:1,$Rotate:0.1,$During:{$Left:[0.6,0.4],$Top:[0.6,0.4],$Rotate:[0.6,0.4],$Zoom:[0.6,0.4]},$Easing:{$Left:$Jease$.$InQuad,$Top:$Jease$.$InQuad,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Brother:{$Duration:1000,$Zoom:11,$Rotate:-0.5,$Easing:{$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Shift:200}}"},{"text":"Fly Twins","value":"{$Duration:1500,x:0.3,$During:{$Left:[0.6,0.4]},$Easing:{$Left:$Jease$.$InQuad,$Opacity:$Jease$.$Linear},$Opacity:2,$Outside:true,$Brother:{$Duration:1000,x:-0.3,$Easing:{$Left:$Jease$.$InQuad,$Opacity:$Jease$.$Linear},$Opacity:2}}"},{"text":"Rotate in- out+","value":"{$Duration:1500,$Zoom:11,$Rotate:0.5,$During:{$Left:[0.4,0.6],$Top:[0.4,0.6],$Rotate:[0.4,0.6],$Zoom:[0.4,0.6]},$Easing:{$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Brother:{$Duration:1000,$Zoom:1,$Rotate:-0.5,$Easing:{$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Shift:200}}"},{"text":"Rotate Axis up overlap","value":"{$Duration:1200,x:0.25,y:0.5,$Rotate:-0.1,$Easing:{$Left:$Jease$.$InQuad,$Top:$Jease$.$InQuad,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Brother:{$Duration:1200,x:-0.1,y:-0.7,$Rotate:0.1,$Easing:{$Left:$Jease$.$InQuad,$Top:$Jease$.$InQuad,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2}}"},{"text":"Chess Replace TB","value":"{$Duration:1600,x:1,$Rows:2,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$Brother:{$Duration:1600,x:-1,$Rows:2,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2}}"},{"text":"Chess Replace LR","value":"{$Duration:1600,y:-1,$Cols:2,$ChessMode:{$Column:12},$Easing:{$Top:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$Brother:{$Duration:1600,y:1,$Cols:2,$ChessMode:{$Column:12},$Easing:{$Top:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2}}"},{"text":"Shift TB","value":"{$Duration:1200,y:1,$Easing:{$Top:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$Brother:{$Duration:1200,y:-1,$Easing:{$Top:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2}}"},{"text":"Shift LR","value":"{$Duration:1200,x:1,$Easing:{$Left:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$Brother:{$Duration:1200,x:-1,$Easing:{$Left:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2}}"},{"text":"Return TB","value":"{$Duration:1200,y:-1,$Easing:{$Top:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$ZIndex:-10,$Brother:{$Duration:1200,y:-1,$Easing:{$Top:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$ZIndex:-10,$Shift:-100}}"},{"text":"Return LR","value":"{$Duration:1200,x:1,$Delay:40,$Cols:6,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Easing:{$Left:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$ZIndex:-10,$Brother:{$Duration:1200,x:1,$Delay:40,$Cols:6,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Easing:{$Top:$Jease$.$InOutQuart,$Opacity:$Jease$.$Linear},$Opacity:2,$ZIndex:-10,$Shift:-100}}"},{"text":"Rotate Axis down","value":"{$Duration:1500,x:-0.1,y:-0.7,$Rotate:0.1,$During:{$Left:[0.6,0.4],$Top:[0.6,0.4],$Rotate:[0.6,0.4]},$Easing:{$Left:$Jease$.$InQuad,$Top:$Jease$.$InQuad,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2,$Brother:{$Duration:1000,x:0.2,y:0.5,$Rotate:-0.1,$Easing:{$Left:$Jease$.$InQuad,$Top:$Jease$.$InQuad,$Opacity:$Jease$.$Linear,$Rotate:$Jease$.$InQuad},$Opacity:2}}"},{"text":"Extrude Replace","value":"{$Duration:1600,x:-0.2,$Delay:40,$Cols:12,$During:{$Left:[0.4,0.6]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:260,$Easing:{$Left:$Jease$.$InOutExpo,$Opacity:$Jease$.$InOutQuad},$Opacity:2,$Outside:true,$Round:{$Top:0.5},$Brother:{$Duration:1000,x:0.2,$Delay:40,$Cols:12,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:1028,$Easing:{$Left:$Jease$.$InOutExpo,$Opacity:$Jease$.$InOutQuad},$Opacity:2,$Round:{$Top:0.5}}}"},{"text":"------------ Collapse Effects --------------","value":"null"},{"text":"Collapse Stairs","value":"{$Duration:1000,$Delay:30,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:2049,$Easing:$Jease$.$OutQuad}"},{"text":"Collapse Swirl","value":"{$Duration:500,$Delay:30,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Easing:$Jease$.$OutQuad}"},{"text":"Collapse Square","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:$Jease$.$OutQuad}"},{"text":"Collapse Rectangle Cross","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationRectangleCross,$Easing:$Jease$.$OutQuad}"},{"text":"Collapse Rectangle","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationRectangle,$Easing:$Jease$.$OutQuad}"},{"text":"Collapse Cross","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationCross,$Easing:$Jease$.$OutQuad}"},{"text":"Collapse Circle","value":"{$Duration:800,$Delay:200,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Assembly:2049}"},{"text":"Collapse ZigZag","value":"{$Duration:500,$Delay:30,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Easing:$Jease$.$OutQuad}"},{"text":"Collapse Random","value":"{$Duration:1000,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$SlideOut:true,$Easing:$Jease$.$OutQuad}"},{"text":"------------ Compound Effects --------------","value":"null"},{"text":"Clip & Chess in","value":"{$Duration:1200,y:-1,$Cols:8,$Rows:4,$Clip:15,$During:{$Top:[0.5,0.5],$Clip:[0,0.5]},$Formation:$JssorSlideshowFormations$.$FormationStraight,$ChessMode:{$Column:12},$ScaleClip:0.5}"},{"text":"Clip & Chess out","value":"{$Duration:1200,y:-1,$Cols:8,$Rows:4,$Clip:15,$During:{$Top:[0.5,0.5],$Clip:[0,0.5]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$ChessMode:{$Column:12},$ScaleClip:0.5}"},{"text":"Clip & Oblique Chess in","value":"{$Duration:1200,x:-1,y:-1,$Cols:6,$Rows:6,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8],$Clip:[0,0.2]},$Formation:$JssorSlideshowFormations$.$FormationStraight,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Clip:$Jease$.$Swing},$ScaleClip:0.5}"},{"text":"Clip & Oblique Chess out","value":"{$Duration:1200,x:-1,y:-1,$Cols:6,$Rows:6,$Clip:15,$During:{$Left:[0.2,0.8],$Top:[0.2,0.8],$Clip:[0,0.2]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$ChessMode:{$Column:15,$Row:15},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Clip:$Jease$.$Swing},$ScaleClip:0.5}"},{"text":"Clip & Wave in","value":"{$Duration:4000,x:-1,y:0.45,$Delay:80,$Cols:12,$Clip:15,$During:{$Left:[0.35,0.65],$Top:[0.35,0.65],$Clip:[0,0.15]},$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:2049,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave,$Clip:$Jease$.$OutQuad},$ScaleClip:0.7,$Round:{$Top:4}}"},{"text":"Clip & Wave out","value":"{$Duration:4000,x:-1,y:0.45,$Delay:80,$Cols:12,$Clip:15,$During:{$Left:[0.35,0.65],$Top:[0.35,0.65],$Clip:[0,0.15]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:2049,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave,$Clip:$Jease$.$OutQuad},$ScaleClip:0.7,$Round:{$Top:4}}"},{"text":"Clip & Jump in","value":"{$Duration:4000,x:-1,y:0.7,$Delay:80,$Cols:12,$Clip:11,$Move:true,$During:{$Left:[0.35,0.65],$Top:[0.35,0.65],$Clip:[0,0.1]},$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:2049,$Easing:{$Left:$Jease$.$OutQuad,$Top:$Jease$.$OutJump,$Clip:$Jease$.$OutQuad},$ScaleClip:0.7,$Round:{$Top:4}}"},{"text":"Clip & Jump out","value":"{$Duration:4000,x:-1,y:0.7,$Delay:80,$Cols:12,$Clip:11,$Move:true,$During:{$Left:[0.35,0.65],$Top:[0.35,0.65],$Clip:[0,0.1]},$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:2049,$Easing:{$Left:$Jease$.$OutQuad,$Top:$Jease$.$OutJump,$Clip:$Jease$.$OutQuad},$ScaleClip:0.7,$Round:{$Top:4}}"},{"text":"------------ Expand Effects --------------","value":"null"},{"text":"Expand Stairs","value":"{$Duration:1000,$Delay:30,$Cols:8,$Rows:4,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:2050,$Easing:$Jease$.$InQuad}"},{"text":"Expand Straight","value":"{$Duration:1000,$Cols:3,$Rows:2,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Easing:$Jease$.$InBounce}"},{"text":"Expand Swirl","value":"{$Duration:500,$Delay:30,$Cols:8,$Rows:4,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Easing:$Jease$.$InQuad}"},{"text":"Expand Square","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Easing:$Jease$.$InQuad}"},{"text":"Expand Rectangle Cross","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationRectangleCross,$Easing:$Jease$.$InQuad}"},{"text":"Expand Rectangle","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationRectangle,$Easing:$Jease$.$InQuad}"},{"text":"Expand Cross","value":"{$Duration:800,$Delay:300,$Cols:8,$Rows:4,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationCross,$Easing:$Jease$.$InQuad}"},{"text":"Expand ZigZag","value":"{$Duration:500,$Delay:30,$Cols:8,$Rows:4,$Clip:15,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:$Jease$.$InQuad}"},{"text":"Expand Random","value":"{$Duration:1000,$Delay:80,$Cols:8,$Rows:4,$Clip:15,$Easing:$Jease$.$InQuad}"},{"text":"------------ Stripe Effects --------------","value":"null"},{"text":"Dominoes Stripe","value":"{$Duration:2000,y:-1,$Delay:60,$Cols:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Easing:$Jease$.$OutJump,$Round:{$Top:1.5}}"},{"text":"Extrude out Stripe","value":"{$Duration:1000,x:-0.2,$Delay:40,$Cols:12,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:260,$Easing:{$Left:$Jease$.$InOutExpo,$Opacity:$Jease$.$InOutQuad},$Opacity:2,$Outside:true,$Round:{$Top:0.5}}"},{"text":"Extrude in Stripe","value":"{$Duration:1000,x:0.2,$Delay:40,$Cols:12,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Assembly:260,$Easing:{$Left:$Jease$.$InOutExpo,$Opacity:$Jease$.$InOutQuad},$Opacity:2,$Outside:true,$Round:{$Top:0.5}}"},{"text":"Horizontal Blind Stripe","value":"{$Duration:400,$Delay:100,$Rows:7,$Clip:4,$Formation:$JssorSlideshowFormations$.$FormationStraight}"},{"text":"Vertical Blind Stripe","value":"{$Duration:400,$Delay:100,$Cols:10,$Clip:2,$Formation:$JssorSlideshowFormations$.$FormationStraight}"},{"text":"Horizontal Stripe","value":"{$Duration:1000,$Rows:6,$Clip:4}"},{"text":"Vertical Stripe","value":"{$Duration:1000,$Cols:8,$Clip:1}"},{"text":"Horizontal Moving Stripe","value":"{$Duration:1000,$Rows:6,$Clip:4,$Move:true}"},{"text":"Vertical Moving Stripe","value":"{$Duration:1000,$Cols:8,$Clip:1,$Move:true}"},{"text":"Horizontal Fade Stripe","value":"{$Duration:600,$Delay:100,$Rows:7,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Opacity:2}"},{"text":"Vertical Fade Stripe","value":"{$Duration:600,$Delay:100,$Cols:10,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Opacity:2}"},{"text":"Horizontal Fly Stripe","value":"{$Duration:800,x:1,$Delay:80,$Rows:8,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:513,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Vertical Fly Stripe","value":"{$Duration:800,y:1,$Delay:80,$Cols:12,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:513,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Horizontal Chess Stripe","value":"{$Duration:1000,x:-1,$Rows:6,$Formation:$JssorSlideshowFormations$.$FormationStraight,$ChessMode:{$Row:3}}"},{"text":"Vertical Chess Stripe","value":"{$Duration:1000,y:-1,$Cols:12,$Formation:$JssorSlideshowFormations$.$FormationStraight,$ChessMode:{$Column:12}}"},{"text":"Horizontal Random Fade Stripe","value":"{$Duration:600,$Delay:80,$Rows:6,$Opacity:2}"},{"text":"Vertical Random Fade Stripe","value":"{$Duration:600,$Delay:80,$Cols:10,$Opacity:2}"},{"text":"Horizontal Bounce Stripe","value":"{$Duration:800,$Delay:150,$Rows:5,$Clip:8,$Move:true,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Assembly:264,$Easing:$Jease$.$InBounce}"},{"text":"Vertical Bounce Stripe","value":"{$Duration:800,$Delay:150,$Cols:10,$Clip:1,$Move:true,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Assembly:264,$Easing:$Jease$.$InBounce}"},{"text":"------------ Wave out Effects --------------","value":"null"},{"text":"Wave out","value":"{$Duration:1500,y:-0.5,$Delay:60,$Cols:12,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:$Jease$.$InWave,$Round:{$Top:1.5}}"},{"text":"Wave out Eagle","value":"{$Duration:1500,y:-0.5,$Delay:60,$Cols:15,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Easing:$Jease$.$InWave,$Round:{$Top:1.5}}"},{"text":"Wave out Swirl","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave},$Round:{$Top:1.5}}"},{"text":"Wave out ZigZag","value":"{$Duration:1500,x:1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave},$Round:{$Top:1.5}}"},{"text":"Wave out Square","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave},$Round:{$Top:1.5}}"},{"text":"Wave out Rectangle","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationRectangle,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave},$Round:{$Top:1.5}}"},{"text":"Wave out Circle","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave},$Round:{$Top:1.5}}"},{"text":"Wave out Cross","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationCross,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave},$Round:{$Top:1.5}}"},{"text":"Wave out Rectangle Cross","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationRectangleCross,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutWave},$Round:{$Top:1.5}}"},{"text":"------------ Wave in Effects --------------","value":"null"},{"text":"Wave in","value":"{$Duration:1500,y:-0.5,$Delay:60,$Cols:12,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:$Jease$.$InWave,$Round:{$Top:1.5}}"},{"text":"Wave in Eagle","value":"{$Duration:1500,y:-0.5,$Delay:60,$Cols:15,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Easing:$Jease$.$InWave,$Round:{$Top:1.5}}"},{"text":"Wave in Swirl","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InWave},$Round:{$Top:1.5}}"},{"text":"Wave in ZigZag","value":"{$Duration:1500,x:1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InWave},$Round:{$Top:1.5}}"},{"text":"Wave in Square","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InWave},$Round:{$Top:1.5}}"},{"text":"Wave in Rectangle","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationRectangle,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InWave},$Round:{$Top:1.5}}"},{"text":"Wave in Circle","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InWave},$Round:{$Top:1.5}}"},{"text":"Wave in Cross","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationCross,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InWave},$Round:{$Top:1.5}}"},{"text":"Wave in Rectangle Cross","value":"{$Duration:1500,x:-1,y:0.5,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationRectangleCross,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InWave},$Round:{$Top:1.5}}"},{"text":"------------ Jump out Effects --------------","value":"null"},{"text":"Jump out Straight","value":"{$Duration:1500,x:-1,y:0.5,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:513,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"Jump out Swirl","value":"{$Duration:1500,x:-1,y:0.5,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"Jump out ZigZag","value":"{$Duration:1500,x:-1,y:0.5,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"Jump out Square","value":"{$Duration:1500,x:-1,y:0.5,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"Jump out Square with Chess","value":"{$Duration:1500,x:-1,y:0.5,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"Jump out Rectangle","value":"{$Duration:1500,x:-1,y:0.5,$Delay:800,$Cols:8,$Rows:4,$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationRectangle,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"Jump out Circle","value":"{$Duration:1500,x:-1,y:0.5,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"Jump out Rectangle Cross","value":"{$Duration:1500,x:-1,y:0.5,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationRectangleCross,$Assembly:260,$Easing:{$Left:$Jease$.$Linear,$Top:$Jease$.$OutJump},$Round:{$Top:1.5}}"},{"text":"------------ Jump in Effects --------------","value":"null"},{"text":"Jump in Straight","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationStraight,$Assembly:513,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"Jump in Swirl","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"Jump in ZigZag","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"Jump in Square","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"Jump in Square with Chess","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationSquare,$Assembly:260,$ChessMode:{$Row:3},$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"Jump in Rectangle","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:800,$Cols:8,$Rows:4,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationRectangle,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"Jump in Circle","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationCircle,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"Jump in Rectangle Cross","value":"{$Duration:1500,x:-1,y:-0.5,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationRectangleCross,$Assembly:260,$Easing:{$Left:$Jease$.$Swing,$Top:$Jease$.$InJump},$Round:{$Top:1.5}}"},{"text":"------------ Parabola Effects --------------","value":"null"},{"text":"Parabola Swirl in","value":"{$Duration:600,x:-1,y:1,$Delay:100,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:264,$Easing:{$Top:$Jease$.$InQuart,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Parabola Swirl out","value":"{$Duration:600,x:-1,y:1,$Delay:100,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:264,$Easing:{$Top:$Jease$.$InQuart,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Parabola ZigZag in","value":"{$Duration:600,x:1,y:1,$Delay:60,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$ChessMode:{$Row:3},$Easing:{$Top:$Jease$.$InQuart,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Parabola ZigZag out","value":"{$Duration:600,x:1,y:1,$Delay:60,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:260,$ChessMode:{$Row:3},$Easing:{$Top:$Jease$.$InQuart,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Parabola Stairs in","value":"{$Duration:600,x:-1,y:1,$Delay:30,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InQuart,$Top:$Jease$.$InQuart,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"Parabola Stairs out","value":"{$Duration:600,x:-1,y:1,$Delay:30,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationStraightStairs,$Easing:{$Left:$Jease$.$InQuart,$Top:$Jease$.$InQuart,$Opacity:$Jease$.$Linear},$Opacity:2}"},{"text":"------------ Float Effects --------------","value":"null"},{"text":"Float Right Random","value":"{$Duration:600,x:-1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float up Random","value":"{$Duration:600,y:1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float up Random with Chess","value":"{$Duration:600,x:1,y:-1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float Right ZigZag","value":"{$Duration:600,x:-1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:513,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float up ZigZag","value":"{$Duration:600,y:1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:264,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float up ZigZag with Chess","value":"{$Duration:600,x:-1,y:-1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:1028,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float Right Swirl","value":"{$Duration:600,x:-1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:513,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float up Swirl","value":"{$Duration:600,y:1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:2049,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Float up Swirl with Chess","value":"{$Duration:600,x:1,y:1,$Delay:50,$Cols:8,$Rows:4,$SlideOut:true,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:513,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"------------ Fly Effects --------------","value":"null"},{"text":"Fly Right Random","value":"{$Duration:600,x:1,$Delay:50,$Cols:8,$Rows:4,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly up Random","value":"{$Duration:600,y:-1,$Delay:50,$Cols:8,$Rows:4,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly up Random with Chess","value":"{$Duration:600,x:-1,y:1,$Delay:50,$Cols:8,$Rows:4,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly Right ZigZag","value":"{$Duration:600,x:1,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:513,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly up ZigZag","value":"{$Duration:600,y:-1,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:264,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly up ZigZag with Chess","value":"{$Duration:600,x:1,y:1,$Delay:50,$Cols:8,$Rows:4,$Formation:$JssorSlideshowFormations$.$FormationZigZag,$Assembly:1028,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly Right Swirl","value":"{$Duration:600,x:1,$Delay:50,$Cols:8,$Rows:4,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:513,$Easing:{$Left:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly up Swirl","value":"{$Duration:600,y:-1,$Delay:50,$Cols:8,$Rows:4,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:2049,$Easing:{$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"Fly up Swirl with Chess","value":"{$Duration:600,x:-1,y:-1,$Delay:50,$Cols:8,$Rows:4,$Reverse:true,$Formation:$JssorSlideshowFormations$.$FormationSwirl,$Assembly:513,$ChessMode:{$Column:3,$Row:12},$Easing:{$Left:$Jease$.$InCubic,$Top:$Jease$.$InCubic,$Opacity:$Jease$.$OutQuad},$Opacity:2}"},{"text":"------------ Stone Effects --------------","value":"null"},{"text":"Slide Down","value":"{$Duration:500,y:1,$Easing:$Jease$.$InQuad}"},{"text":"Slide Right","value":"{$Duration:400,x:1,$Easing:$Jease$.$InQuad}"},{"text":"Bounce Down","value":"{$Duration:1000,y:1,$Easing:$Jease$.$InBounce}"},{"text":"Bounce Right","value":"{$Duration:1000,x:1,$Easing:$Jease$.$InBounce}"}]';

		$arr = json_decode($json,true);
		
		return $arr;
	}
}
?>