<?php
defined('ABSPATH') or die("No script kiddies please!");

/**
  Plugin name: WP Floating Menu Pro
  Plugin URI: https://accesspressthemes.com/wordpress-plugins/wp-floating-menu-pro/
  Description: WordPress plugin that allows you to enhance your WordPress website usability with easy one page navigator and many other sticky navigation menus.
  Version: 2.0.7
  Author: اسکریپت دات کام
  Author URI: http://www.اسکریپت.com
  Text Domain: wp-floating-menu-pro
  Domain Path: /languages/
 */
if (!defined('WPFM_PRO_VERSION')) {
    define('WPFM_PRO_VERSION', '2.0.7');
}

if (!defined('WPFM_PRO_IMAGE_DIR')) {
    define('WPFM_PRO_IMAGE_DIR', plugin_dir_url(__FILE__) . 'images/');
}

if (!defined('WPFM_PRO_JS_DIR')) {
    define('WPFM_PRO_JS_DIR', plugin_dir_url(__FILE__) . 'js/');
}

if (!defined('WPFM_PRO_CSS_DIR')) {
    define('WPFM_PRO_CSS_DIR', plugin_dir_url(__FILE__) . 'css/');
}

if (!defined('WPFM_PRO_TEXT_DOMAIN')) {
    define('WPFM_PRO_TEXT_DOMAIN', 'wp-floating-menu-pro');
}

if (!defined('WPFM_PRO_LANG_DIR')) {
    define('WPFM_PRO_LANG_DIR', basename(dirname(__FILE__)) . '/languages/');
}

if (!defined('WPFM_SETTINGS')) {
    define('WPFM_SETTINGS', 'wpfm-settings');
}
if (!defined('WPFM_PRO_FILE_ROOT_DIR')) {
    define('WPFM_PRO_FILE_ROOT_DIR', plugin_dir_path(__FILE__));
}

/** Declaring Class for Plugin */
if (!class_exists('WPFM_PRO')) {

    class WPFM_PRO {

        var $wpfm_settings;

        function __construct() {
            $this->wpfm_settings = get_option(WPFM_SETTINGS);
            add_action('init', array($this, 'wpfm_start_session_init'));
            add_action('init', array($this, 'wpfm_plugin_text_domain'));
            register_activation_hook(__FILE__, array($this, 'wpfm_plugin_activation'));
            add_action('admin_menu', array($this, 'wpfm_add_plugin_menu'));
            add_action('admin_enqueue_scripts', array($this, 'wpfm_register_admin_assets'));
            add_action('wp_enqueue_scripts', array($this, 'wpfm_register_frontend_assets'));
            add_action('wp_ajax_wpfm_pull_data_contents', array($this, 'wpfm_pull_data_contents'));
            add_action('admin_post_wpfm_add_menu_field_options', array($this, 'wpfm_add_menu_field_options'));
            add_action('admin_post_wpfm_save_menu_field_options', array($this, 'wpfm_save_menu_options'));
            add_action('admin_post_wpfm_menu_delete_options', array($this, 'wpfm_menu_delete_options'));
            add_action('admin_post_wpfm_menu_duplicate_options', array($this, 'wpfm_menu_duplicate_options'));
            add_action('admin_post_wpfm_menu_custom_template_duplicate_options', array($this, 'wpfm_menu_custom_template_duplicate_options'));
            add_action('admin_post_wpfm_menu_delete_template_options', array($this, 'wpfm_menu_delete_template_options'));
            add_action('admin_post_wpfm_save_menu_show_options', array($this, 'wpfm_save_menu_show_options'));
            add_action('wp_footer', array($this, 'wpfm_menu_call_frontend'));
            add_action('add_meta_boxes', array($this, 'wpfm_metabox_add'));
            add_action('save_post', array($this, 'wpfm_menu_save_meta_box_data'));
            add_action('admin_post_wpfm_save_template_options', array($this, 'wpfm_save_template_options'));
            add_action('admin_post_wpfm_save_edited_template_options', array($this, 'wpfm_save_template_options'));
            add_action('wp_print_styles', array($this, 'wpfm_load_fonts'));
            add_filter('upload_mimes', array($this, 'wpfmp_upload_svg'));
            add_action('wp_footer', array($this, 'wpfmp_preview_menu_appendto_footer'), 100);
        }

        function wpfmp_preview_menu_appendto_footer() {
            if (isset($_GET['wpfmp_preview']) && $_GET['wpfmp_preview'] && isset($_GET['menu_id']) && intval($_GET['menu_id']) && is_user_logged_in()) {

                $wpfm_template_check_main_array = $this->global_template_display_condition_check();

                $menu_id = intval($_GET['menu_id']);
                $get_data_from_table = $this->get_menu_data($menu_id);
                if (isset($get_data_from_table[0]) && !empty($get_data_from_table[0])) {
                    ?>
                    <div class="wpfm-floating-wh-wrapper <?php
                    if (is_user_logged_in()) {
                        echo 'wpfm-logged-in';
                    }
                    ?>">
                             <?php
                             $menu_data = $get_data_from_table[0];
                             $menu_structure_detail = unserialize($menu_data->menu_details);
                             $menu_design_detail = unserialize($menu_data->menu_display_setting_details);
                             $template = $menu_design_detail['menu_design']['template_number'];
                             $menu_title = stripslashes_deep(esc_attr($menu_data->menu_name));
                             ?>
                        <div class="wpfm-live-preview-header">
                            <h3><?php echo __('Template Preview', 'wp-floating-menu-pro'); ?></h3>
                            <h4><?php echo!empty($menu_title) ? $menu_title : __('Untitled Menu', 'wp-floating-menu-pro'); ?></h4>
                        </div>
                        <?php
                        if (isset($menu_design_detail['menu_design']['menu_layout']) && in_array($menu_design_detail['menu_design']['menu_layout'], $wpfm_template_check_main_array['wpfm_position_check_array'])) {
                            $menu_position = esc_attr($menu_design_detail['menu_design']['cmenu_placement']);
                        } else {
                            $menu_position = esc_attr($menu_design_detail['menu_design']['menu_placement']);
                        }

                        //Template Include condition
                        if ($menu_design_detail['menu_design']['menu_template_style'] == 'custom-template') {
                            include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/custom-template.php';
                        } else {
                            if (isset($template) && in_array($template, $wpfm_template_check_main_array['wpfm_template_check_array'])) {
                                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/templates/template-1.php';
                            } else if (isset($template) && in_array($template, $wpfm_template_check_main_array['wpfm_template_check_array_2'])) {
                                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/templates/template-2.php';
                            } else if (!empty($template) && in_array($template, $wpfm_template_check_main_array['wpfm_template_check_array_3'])) {
                                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/templates/template-3.php';
                            } else if (!empty($template) && in_array($template, $wpfm_template_check_main_array['wpfm_template_check_array_4'])) {
                                include WPFM_PRO_FILE_ROOT_DIR . 'inc/frontend/templates/template-4.php';
                            } else {
                                ?> 
                                <div class="error notice">
                                    <p>
                                        <?php echo __('No such floating menu template found. Please check and try again', 'wp-floating-menu-pro'); ?>
                                    </p>
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </div>
                    <?php
                } /* Get data from table end if */
            }
        }

        function global_template_display_condition_check() {
            $wpfm_template_check_main_array = array(
                'wpfm_template_check_array' => array('template-1', 'template-2', 'template-3', 'template-4', 'template-7', 'template-11', 'template-12', 'template-13', 'template-14', 'template-15', 'template-18', 'template-19', 'template-20', 'template-17'),
                'wpfm_template_check_array_2' => array('template-5', 'template-6', 'template-16'),
                'wpfm_template_check_array_3' => array('template-8', 'template-9'),
                'wpfm_template_check_array_4' => array('template-10'),
                'wpfm_position_check_array' => array('template-11', 'template-12', 'template-13', 'template-16'),
                'template_position_array_1' => array('template-1', 'template-2', 'template-3', 'template-4', 'template-5', 'template-6', 'template-7', 'template-8', 'template-9', 'template-10', 'template-14', 'template-15', 'template-17', 'template-18', 'template-19', 'template-20')
            );

            return $wpfm_template_check_main_array;
        }

        /** Starting session if not already started */
        function wpfm_start_session_init() {
            if (!session_id()) {
                session_start();
            }
        }

        /**  Function to load plugin text domain for translation */
        function wpfm_plugin_text_domain() {
            load_plugin_textdomain('wp-floating-menu-pro', false, WPFM_PRO_LANG_DIR);
        }

        /** Implement default setting on plugin activation */
        function wpfm_plugin_activation() {
            include( 'inc/backend/includes/activate.php' );
        }

        /** Create Menu on activating New Plugin */
        function wpfm_add_plugin_menu() {
            add_menu_page(__('WP Floating Menu Pro', 'wp-floating-menu-pro'), 'WP Floating<br/>Menu Pro', 'manage_options', 'wpfmp-admin', array($this, 'wpfmp_main_page'), 'dashicons-admin-page');
            add_submenu_page('wpfmp-admin', 'All Menus', 'All Menus', 'manage_options', 'wpfmp-admin', array($this, 'wpfmp_main_page'));
            add_submenu_page('wpfmp-admin', 'Add New Menu', 'Add New Menu', 'manage_options', 'wpfmp-add-menu', array($this, 'wpfmp_add_new_menu'));
            add_submenu_page('wpfmp-admin', 'Custom Templates', 'Custom Templates', 'manage_options', 'wpfmp-custom-template', array($this, 'wpfmp_custom_template'));
            add_submenu_page('wpfmp-admin', 'Floating Menu Setting', 'Floating Menu Setting', 'manage_options', 'wpfm_menu_setting', array($this, 'wpfmp_menu_setting'));
            add_submenu_page('wpfmp-admin', 'How To Use', 'How To Use', 'manage_options', 'how-to-use', array($this, 'wpfmp_how_to_use'));
            add_submenu_page('wpfmp-admin', 'About', 'About', 'manage_options', 'wpfmp-about', array($this, 'wpfmp_about'));
            add_submenu_page('wpfmp-admin', 'More WordPress Stuffs', 'More WordPress Stuffs', 'manage_options', 'wpfmp-more-wp-stuffs', array($this, 'wpfmp_more_wordpress_resources'));
        }

        /** Main Menu setting */
        function wpfmp_main_page() {
            include( 'inc/backend/setting-tabs/menu-listing.php' );
        }

        /** Add Menu Setting */
        function wpfmp_add_new_menu() {
            include( 'inc/backend/menu-actions/add-new-menu-field.php' );
        }

        /** Edit Menu */
        function wpfmp_custom_template() {
            include( 'inc/backend/setting-tabs/custom-template-listing.php' );
        }

        /** Menu Setting */
        function wpfmp_menu_setting() {
            include( 'inc/backend/setting-tabs/menu-options.php' );
        }

        /** How To use */
        function wpfmp_how_to_use() {
            include( 'inc/backend/setting-tabs/how-to-use.php' );
        }

        /** About */
        function wpfmp_about() {
            include( 'inc/backend/setting-tabs/about.php' );
        }

        /** Wordpress Stuffs */
        function wpfmp_more_wordpress_resources() {
            include( 'inc/backend/setting-tabs/more-wp-resources.php' );
        }

        function wpfmp_upload_svg($mimes) {
            $mimes['svg'] = 'image/svg+xml';
            return $mimes;
        }

        /** Register Backend Assets */
        function wpfm_register_admin_assets() {
            $wpfm_admin_ajax_nonce = wp_create_nonce('wpfm-admin-ajax-nonce');
            $wpfm_admin_ajax_object = array('ajax_url' => admin_url('admin-ajax.php'), 'ajax_nonce' => $wpfm_admin_ajax_nonce);
            wp_enqueue_script('wpfm-admin-js', WPFM_PRO_JS_DIR . 'backend.js', array('jquery', 'jquery-ui-sortable', 'wp-color-picker', 'wpfm-icon-picker-js'), WPFM_PRO_VERSION);
            wp_localize_script('wpfm-admin-js', 'wpfm_backend_js_params', $wpfm_admin_ajax_object);
            wp_enqueue_style('wpfm-backend-css', WPFM_PRO_CSS_DIR . 'back-end.css', WPFM_PRO_VERSION);

            wp_enqueue_style('wpfm-fontawesome-css', WPFM_PRO_CSS_DIR . 'fontawesome.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-fa-brands-css', WPFM_PRO_CSS_DIR . 'fa-brands.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-fa-solid-css', WPFM_PRO_CSS_DIR . 'fa-solid.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-fa-regular-css', WPFM_PRO_CSS_DIR . 'fa-regular.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-fontawesome-min-css', WPFM_PRO_CSS_DIR . 'font-awesome.min.css', WPFM_PRO_VERSION);
            wp_enqueue_script('wpfm-icon-picker-js', WPFM_PRO_JS_DIR . 'icon-picker.js', array('jquery'), WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-icon-picker-elegant-icons', WPFM_PRO_CSS_DIR . 'elegant-icons.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-icon-picker-genericons-css', WPFM_PRO_CSS_DIR . 'genericons.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-icon-picker-css', WPFM_PRO_CSS_DIR . 'icon-picker.css', WPFM_PRO_VERSION);
            wp_enqueue_script('wpfm-pro-webfont', '//ajax.googleapis.com/ajax/libs/webfont/1.4.7/webfont.js');
            wp_enqueue_script('wpfm-colorpicker-alpha', WPFM_PRO_JS_DIR . 'wp-color-picker-alpha.js', array('wp-color-picker'), WPFM_PRO_VERSION);
            wp_enqueue_style('wp-color-picker');
            wp_enqueue_script('thickbox');
            wp_enqueue_style('thickbox');
            wp_enqueue_media();

            /**
             * Enqueue custom font for the tooltip and title font family 
             */
            $wpfm_cust_def_id = '';
            $cust_template_lists = $this->get_template_data($wpfm_cust_def_id);
            if (count($cust_template_lists) > 0) {
                foreach ($cust_template_lists as $row) {
                    $template_settings = unserialize($row->template_details);
                    $wpfmp_title_fonts = isset($template_settings['custom_template']['icon_title_text_font']) && $template_settings['custom_template']['icon_title_text_font'] !== 'default' ? esc_attr($template_settings['custom_template']['icon_title_text_font']) : '';
                    $wpfmp_tooltip_fonts = isset($template_settings['custom_template']['icon_tooltip_text_font']) && $template_settings['custom_template']['icon_tooltip_text_font'] !== 'default' ? esc_attr($template_settings['custom_template']['icon_tooltip_text_font']) : '';

                    if (isset($template_settings['custom_template']['icon_title_text_font']) && $template_settings['custom_template']['icon_title_text_font'] !== 'default') {
                        $title_fonts_final = str_replace(' ', '+', $wpfmp_title_fonts);
                        wp_enqueue_style('wpfmp-title-google-backend-fonts', '//fonts.googleapis.com/css?family=' . $title_fonts_final . ':300italic,400italic,700italic,400,700,300', false);
                    }
                    if (isset($template_settings['custom_template']['icon_tooltip_text_font']) && $template_settings['custom_template']['icon_tooltip_text_font'] !== 'default') {
                        $tooltip_font_final = str_replace(' ', '+', $wpfmp_tooltip_fonts);
                        wp_enqueue_style('wpfmp-tooltip-google-backend-fonts', '//fonts.googleapis.com/css?family=' . $tooltip_font_final . ':300italic,400italic,700italic,400,700,300', false);
                    }
                }
            } /** Font family ends here */
        }

        /** Register Front-end assets */
        function wpfm_register_frontend_assets() {
            $wpfm_settings = get_option(WPFM_SETTINGS);
            wp_enqueue_script('wpfm-frontend-js', WPFM_PRO_JS_DIR . 'frontend.js', array('jquery'), WPFM_PRO_VERSION);
            if ((isset($wpfm_settings['menu_link_disable_fa']) && $wpfm_settings['menu_link_disable_fa'] == '0') || !isset($wpfm_settings['menu_link_disable_fa'])) {
                wp_enqueue_style('wpfm-fontawesome-css', WPFM_PRO_CSS_DIR . 'fontawesome.css', WPFM_PRO_VERSION);
                wp_enqueue_style('wpfm-fa-brands-css', WPFM_PRO_CSS_DIR . 'fa-brands.css', WPFM_PRO_VERSION);
                wp_enqueue_style('wpfm-fa-solid-css', WPFM_PRO_CSS_DIR . 'fa-solid.css', WPFM_PRO_VERSION);
                wp_enqueue_style('wpfm-fa-regular-css', WPFM_PRO_CSS_DIR . 'fa-regular.css', WPFM_PRO_VERSION);
                wp_enqueue_style('wpfm-fontawesome-min-css', WPFM_PRO_CSS_DIR . 'font-awesome.min.css', WPFM_PRO_VERSION);
            }
            wp_enqueue_style('wpfm-icon-picker-elegant-icons', WPFM_PRO_CSS_DIR . 'elegant-icons.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-frontend-genericons-css', WPFM_PRO_CSS_DIR . 'genericons.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-frontend-vesper-icons-css', WPFM_PRO_CSS_DIR . 'vesper-icons.css', WPFM_PRO_VERSION);
            wp_enqueue_style('wpfm-frontend-css', WPFM_PRO_CSS_DIR . 'front-end.css', WPFM_PRO_VERSION);
            wp_enqueue_style('dashicons');

            /**
             * Enqueue custom font for the tooltip and title font family 
             */
            $wpfm_cust_def_id = '';
            $cust_template_lists = $this->get_template_data($wpfm_cust_def_id);
            if (count($cust_template_lists) > 0) {
                foreach ($cust_template_lists as $row) {
                    $template_settings = unserialize($row->template_details);
                    $wpfmp_title_fonts = isset($template_settings['custom_template']['icon_title_text_font']) && $template_settings['custom_template']['icon_title_text_font'] !== 'default' ? esc_attr($template_settings['custom_template']['icon_title_text_font']) : '';
                    $wpfmp_tooltip_fonts = isset($template_settings['custom_template']['icon_tooltip_text_font']) && $template_settings['custom_template']['icon_tooltip_text_font'] !== 'default' ? esc_attr($template_settings['custom_template']['icon_tooltip_text_font']) : '';

                    if (isset($template_settings['custom_template']['icon_title_text_font']) && $template_settings['custom_template']['icon_title_text_font'] !== 'default') {
                        $title_fonts_final = str_replace(' ', '+', $wpfmp_title_fonts);
                        wp_enqueue_style('wpfmp-title-frontend-google-fonts', '//fonts.googleapis.com/css?family=' . $title_fonts_final . ':300italic,400italic,700italic,400,700,300', false);
                    }
                    if (isset($template_settings['custom_template']['icon_tooltip_text_font']) && $template_settings['custom_template']['icon_tooltip_text_font'] !== 'default') {
                        $tooltip_font_final = str_replace(' ', '+', $wpfmp_tooltip_fonts);
                        wp_enqueue_style('wpfmp-tooltip-frontend-google-fonts', '//fonts.googleapis.com/css?family=' . $tooltip_font_final . ':300italic,400italic,700italic,400,700,300', false);
                    }
                }
            } /** Font family ends here */
        }

        /** Register font for frontend */
        function wpfm_load_fonts() {
            wp_register_style('wpfm-google-fonts', '//fonts.googleapis.com/css?family=Roboto:100italic,100,300italic,300,400italic,400,500italic,500,700italic,700,900italic,900');
            wp_enqueue_style('wpfm-google-fonts');
        }

        /** Get all pages */
        function get_all_page_lists() {
            wp_reset_postdata();
            $pages = get_pages(array('posts_per_page' => -1, 'post_status' => 'publish'));
            $page_lists = array();
            if (count($pages) > 0) {
                foreach ($pages as $page) :
                    $page_lists[$page->ID] = $page->post_title;
                endforeach;
            }
            return $page_lists;
        }

        /** Get all posts */
        function get_all_post_lists() {
            wp_reset_postdata();
            $posts = get_posts(array('posts_per_page' => -1, 'post_status' => 'publish'));
            $post_lists = array();
            if (count($posts) > 0) {
                foreach ($posts as $post) :
                    $post_lists[$post->ID] = $post->post_title;
                endforeach;
            }
            return $post_lists;
        }

        /** Get all categories */
        function get_categories($args = '') {
            $defaults = array('taxonomy' => 'category');
            $args = wp_parse_args($args, $defaults);
            $taxonomy = $args['taxonomy'];
            $taxonomy = apply_filters('get_categories_taxonomy', $taxonomy, $args);
            $categories = get_terms($taxonomy, $args);
            $categories_lists = array();
            if (count($categories) > 0) {
                foreach ($categories as $category):
                    $categories_lists[$category->term_id] = $category->name;
                endforeach;
            }
            return $categories_lists;
        }

        /** Get All Custom Post Types */
        function get_post_types() {
            wp_reset_postdata();
            $args = array('public' => true, '_builtin' => false);
            $output = 'objects'; // names or objects, note names is the default
            $operator = 'and'; // 'and' or 'or'
            $post_types = get_post_types($args, $output, $operator);
            $post_type_lists = array();
            if (count($post_types) > 0) {
                foreach ($post_types as $post_type) :
                    $post_type_lists[] = $post_type->labels->name;
                endforeach;
                return $post_type_lists;
            }
        }

        /** Pull page, post and category details from WordPress db to append */
        function wpfm_pull_data_contents() {
            if (isset($_POST['_wpnonce']) && wp_verify_nonce($_POST['_wpnonce'], 'wpfm-admin-ajax-nonce')) {
                $page_id = !empty($_POST['page_value']) ? sanitize_text_field($_POST['page_value']) : '';
                $field_data = !empty($_POST['field_data']) ? sanitize_text_field($_POST['field_data']) : '';
                $submit_field_data = !empty($_POST['submit_field_data']) ? sanitize_text_field($_POST['submit_field_data']) : '';
                $custom_link_name = !empty($_POST['custom_link_name']) ? sanitize_text_field($_POST['custom_link_name']) : '';
                $custom_link_url = !empty($_POST['custom_link_url']) ? sanitize_text_field($_POST['custom_link_url']) : '';
                $custom_link_field_data = !empty($_POST['custom_link_field_data']) ? sanitize_text_field($_POST['custom_link_field_data']) : '';
                include( 'inc/backend/menu-actions/menu-detail-filter.php' );
                wp_die();
            }
        }

        /** Add new Menu */
        function wpfm_add_menu_field_options() {
            if (isset($_POST['wpfm_add_nonce_add_menu_fields']) && isset($_POST['wpfm_add_menu_fields']) && wp_verify_nonce($_POST['wpfm_add_nonce_add_menu_fields'], 'wpfm_nonce_add_menu_fields')) {
                include( 'inc/backend/menu-actions/create-new-menu-action.php' );
            }
        }

        /** Function to save Menu */
        function wpfm_save_menu_options() {
            if (isset($_POST['wpfm_add_nonce_save_menu_settings']) && isset($_POST['wpfm_save_menu_settings']) && wp_verify_nonce($_POST['wpfm_add_nonce_save_menu_settings'], 'wpfm_nonce_save_menu_settings') || (isset($_POST['wpfm_add_nonce_save_menu_fields']) && isset($_POST['wpfm_save_menu_fields']) && wp_verify_nonce($_POST['wpfm_add_nonce_save_menu_fields'], 'wpfm_nonce_save_menu_fields'))) {
                include( 'inc/backend/menu-actions/save-menu-action.php' );
                die();
            }
        }

        /** Function to Delete Menu */
        function wpfm_menu_delete_options() {
            $wpfm_delete_nonce = $_REQUEST['_wpnonce'];
            if (!empty($_GET) && wp_verify_nonce($wpfm_delete_nonce, 'wpfm-remove-menu-settings-nonce')) {
                include( 'inc/backend/menu-actions/delete-menu-action.php' );
                $_SESSION['wpfmp_message'] = __('Menu Deleted.', 'wp-floating-menu-pro');
                wp_redirect(admin_url() . 'admin.php?page=wpfmp-admin');
                exit;
            } else {
                die('No script kiddies please!');
            }
        }

        /** Function to save menu setting values into option table */
        function wpfm_save_menu_show_options() {
            if (isset($_POST['wpfm_add_nonce_save_menu_show_settings']) && isset($_POST['wpfm_save_menu_show_settings']) && wp_verify_nonce($_POST['wpfm_add_nonce_save_menu_show_settings'], 'wpfm_nonce_save_menu_show_settings')) {
                include( 'inc/backend/save-setting.php' );
            } else {
                die('No script kiddies please!');
            }
        }

        /** function to call menu into front-end */
        function wpfm_menu_call_frontend() {
            $wpfm_settings = get_option(WPFM_SETTINGS);
            if (isset($wpfm_settings['responsive_n_different_menu_enable_disable']) && $wpfm_settings['responsive_n_different_menu_enable_disable'] == 1) {
                $wpfmp_useragent = isset($_SERVER['HTTP_USER_AGENT']) && !empty($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';
                if (preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i', $wpfmp_useragent) || preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i', substr($wpfmp_useragent, 0, 4))) {
                    include( 'inc/frontend/front-end-responsive.php' );
                } else {
                    include( 'inc/frontend/front-end.php');
                }
            } else {
                include( 'inc/frontend/front-end.php');
            }
        }

        /** get Menu Content Data From Table. */
        function get_menu_data($id) {
            global $wpdb;
            $table_name = $wpdb->prefix . "wp_floating_menu_details";
            if (intval($id)) {
                $menu_content = $wpdb->get_results("SELECT * FROM $table_name where id = $id");
            } else {
                $menu_content = $wpdb->get_results("SELECT * FROM $table_name");
            }
            return $menu_content;
        }

        /** get Template Content Data From Table. */
        function get_template_data($id) {
            global $wpdb;
            $table_name = $wpdb->prefix . "wp_floating_menu_custom_templates";
            if (intval($id)) {
                $template_content = $wpdb->get_results("SELECT * FROM $table_name where id = $id");
            } else {
                $template_content = $wpdb->get_results("SELECT * FROM $table_name");
            }
            return $template_content;
        }

        /** Get Menu data from Custom Table . */
        function wpfm_get_page_base_menu($post_id) {
            $menu_page = get_post_meta($post_id, 'wp-floating-menu', true);
            return $menu_page;
        }

        /** Adds a section in all the post and page section to disable the share options in frontend pages */
        function wpfm_metabox_add() {
            $screens = array('post', 'page', 'post_type');
            add_meta_box(
                    'wp-floating-menu', __('WP Floating Menu Options', 'wp-floating-menu-pro'), array($this, 'floating_menu_callback'), '', 'side', 'default'
            );
        }

        /** Function to display Metabox in pages/post */
        function floating_menu_callback($post) {
            global $post, $post_type;
            $menu_contents = $this->get_menu_data('');
            wp_nonce_field(basename(__FILE__), 'floating_menu_nonce');
            $menu = get_post_meta($post->ID, 'wp-floating-menu', true);

            $right_menu = get_post_meta($post->ID, 'menu_list_select_pwmr', true);
            $top_right_menu = get_post_meta($post->ID, 'menu_list_selected_pwtr', true);
            $bottom_right_menu = get_post_meta($post->ID, 'menu_list_select_pwbr', true);
            $middle_left_menu = get_post_meta($post->ID, 'menu_list_select_pwml', true);
            $top_left_menu = get_post_meta($post->ID, 'menu_list_select_pwtl', true);
            $bottom_left_menu = get_post_meta($post->ID, 'menu_list_select_pwbl', true);
            $bottom_center_menu = get_post_meta($post->ID, 'menu_list_select_pwbc', true);

            /*
             * For responsive Menu Screen
             */
            $resp_right_menu = get_post_meta($post->ID, 'menu_list_select_resp_pwmr', true);
            $resp_top_right_menu = get_post_meta($post->ID, 'menu_list_selected_resp_pwtr', true);
            $resp_bottom_right_menu = get_post_meta($post->ID, 'menu_list_select_resp_pwbr', true);
            $resp_middle_left_menu = get_post_meta($post->ID, 'menu_list_select_resp_pwml', true);
            $resp_top_left_menu = get_post_meta($post->ID, 'menu_list_select_resp_pwtl', true);
            $resp_bottom_left_menu = get_post_meta($post->ID, 'menu_list_select_resp_pwbl', true);
            $resp_bottom_center_menu = get_post_meta($post->ID, 'menu_list_select_resp_pwbc', true);
            include( 'inc/backend/setting-tabs/custom-meta-field.php' );
        }

        /**
         * When the post is saved, saves our custom data.
         * @param int $post_id The ID of the post being saved.
         */
        function wpfm_menu_save_meta_box_data($post_id) {
            global $post;
            // Verify the nonce before proceeding.
            if (!isset($_POST['menu_list_select_pwmr']) || !wp_verify_nonce($_POST['floating_menu_nonce'], basename(__FILE__)))
                return;
            // Stop WP from clearing custom fields on autosave
            if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
                return;
            if (!current_user_can('edit_post', $post_id)) {
                return $post_id;
            }

            //Execute this saving function
            $old = get_post_meta($post_id, 'wp-floating-menu', true);
            $new = isset($_POST['wp-floating-menu']) && !empty($_POST['wp-floating-menu']) ? sanitize_text_field($_POST['wp-floating-menu']) : '';
            if ($new && $new != $old) {
                update_post_meta($post_id, 'wp-floating-menu', $new);
            } elseif ('' == $new && $old) {
                delete_post_meta($post_id, 'wp-floating-menu', $old);
            }
            // Sanitizing the metabox Input
            $right_menu = sanitize_text_field($_POST['menu_list_select_pwmr']);
            $top_right_menu = sanitize_text_field($_POST['menu_list_selected_pwtr']);
            $bottom_right_menu = sanitize_text_field($_POST['menu_list_select_pwbr']);
            $middle_left_menu = sanitize_text_field($_POST['menu_list_select_pwml']);
            $top_left_menu = sanitize_text_field($_POST['menu_list_select_pwtl']);
            $bottom_left_menu = sanitize_text_field($_POST['menu_list_select_pwbl']);
            $bottom_center_menu = sanitize_text_field($_POST['menu_list_select_pwbc']);

            // Resposive Menus
            $resp_right_menu = sanitize_text_field($_POST['menu_list_select_resp_pwmr']);
            $resp_top_right_menu = sanitize_text_field($_POST['menu_list_selected_resp_pwtr']);
            $resp_bottom_right_menu = sanitize_text_field($_POST['menu_list_select_resp_pwbr']);
            $resp_middle_left_menu = sanitize_text_field($_POST['menu_list_select_resp_pwml']);
            $resp_top_left_menu = sanitize_text_field($_POST['menu_list_select_resp_pwtl']);
            $resp_bottom_left_menu = sanitize_text_field($_POST['menu_list_select_resp_pwbl']);
            $resp_bottom_center_menu = sanitize_text_field($_POST['menu_list_select_resp_pwbc']);

            /**
             * Updating value from meta data to database 
             */
            //For Desktop Data
            update_post_meta($post_id, 'menu_list_select_pwmr', $right_menu);
            update_post_meta($post_id, 'menu_list_selected_pwtr', $top_right_menu);
            update_post_meta($post_id, 'menu_list_select_pwbr', $bottom_right_menu);
            update_post_meta($post_id, 'menu_list_select_pwml', $middle_left_menu);
            update_post_meta($post_id, 'menu_list_select_pwtl', $top_left_menu);
            update_post_meta($post_id, 'menu_list_select_pwbl', $bottom_left_menu);
            update_post_meta($post_id, 'menu_list_select_pwbc', $bottom_center_menu);

            //For Resposive Data
            update_post_meta($post_id, 'menu_list_select_resp_pwmr', $resp_right_menu);
            update_post_meta($post_id, 'menu_list_selected_resp_pwtr', $resp_top_right_menu);
            update_post_meta($post_id, 'menu_list_select_resp_pwbr', $resp_bottom_right_menu);
            update_post_meta($post_id, 'menu_list_select_resp_pwml', $resp_middle_left_menu);
            update_post_meta($post_id, 'menu_list_select_resp_pwtl', $resp_top_left_menu);
            update_post_meta($post_id, 'menu_list_select_resp_pwbl', $resp_bottom_left_menu);
            update_post_meta($post_id, 'menu_list_select_resp_pwbc', $resp_bottom_center_menu);
        }

        /**
         * Get Menu data from Custom Table 
         */
        function wpfm_get_page_base_popup_data($post_id) {
            $wpb_page_meta_val = array();
            $wpb_page_meta_val['menu_list_select_pwmr'] = esc_attr(get_post_meta($post_id, 'menu_list_select_pwmr', true));
            $wpb_page_meta_val['menu_list_selected_pwtr'] = esc_attr(get_post_meta($post_id, 'menu_list_selected_pwtr', true));
            $wpb_page_meta_val['menu_list_select_pwbr'] = esc_attr(get_post_meta($post_id, 'menu_list_select_pwbr', true));
            $wpb_page_meta_val['menu_list_select_pwml'] = esc_attr(get_post_meta($post_id, 'menu_list_select_pwml', true));
            $wpb_page_meta_val['menu_list_select_pwtl'] = esc_attr(get_post_meta($post_id, 'menu_list_select_pwtl', true));
            $wpb_page_meta_val['menu_list_select_pwbl'] = esc_attr(get_post_meta($post_id, 'menu_list_select_pwbl', true));
            $wpb_page_meta_val['menu_list_select_pwbc'] = esc_attr(get_post_meta($post_id, 'menu_list_select_pwbc', true));

            //Resposive Pagewise Data
            $wpb_page_meta_val['menu_list_select_resp_pwmr'] = esc_attr(get_post_meta($post_id, 'menu_list_select_resp_pwmr', true));
            $wpb_page_meta_val['menu_list_selected_resp_pwtr'] = esc_attr(get_post_meta($post_id, 'menu_list_selected_resp_pwtr', true));
            $wpb_page_meta_val['menu_list_select_resp_pwbr'] = esc_attr(get_post_meta($post_id, 'menu_list_select_resp_pwbr', true));
            $wpb_page_meta_val['menu_list_select_resp_pwml'] = esc_attr(get_post_meta($post_id, 'menu_list_select_resp_pwml', true));
            $wpb_page_meta_val['menu_list_select_resp_pwtl'] = esc_attr(get_post_meta($post_id, 'menu_list_select_resp_pwtl', true));
            $wpb_page_meta_val['menu_list_select_resp_pwbl'] = esc_attr(get_post_meta($post_id, 'menu_list_select_resp_pwbl', true));
            $wpb_page_meta_val['menu_list_select_resp_pwbc'] = esc_attr(get_post_meta($post_id, 'menu_list_select_resp_pwbc', true));
            return $wpb_page_meta_val;
        }

        /** Save Template Value * */
        function wpfm_save_template_options() {
            if (isset($_POST['wpfm_add_nonce_save_template_settings']) && isset($_POST['wpfm_save_template_settings']) && wp_verify_nonce($_POST['wpfm_add_nonce_save_template_settings'], 'wpfm_nonce_save_template_settings') || isset($_POST['wpfm_add_nonce_save_edited_template_settings']) && isset($_POST['wpfm_save_edited_template_settings']) && wp_verify_nonce($_POST['wpfm_add_nonce_save_edited_template_settings'], 'wpfm_nonce_save_edited_template_settings')) {
                include( 'inc/backend/template-actions/save-template-action.php' );
            }
        }

        /** Function to Delete Template */
        function wpfm_menu_delete_template_options() {
            $wpfm_delete_template_nonce = $_REQUEST['_wpnonce'];
            if (!empty($_GET) && wp_verify_nonce($wpfm_delete_template_nonce, 'wpfm-remove-template-settings-nonce')) {
                include( 'inc/backend/template-actions/delete-template-action.php' );
                $_SESSION['wpfmp_message'] = __('Template Deleted.', 'wp-floating-menu-pro');
                wp_redirect(admin_url() . 'admin.php?page=wpfmp-custom-template');
                exit;
            } else {
                die('No script kiddies please!');
            }
        }

        /** Function to Delete Template */
        function wpfm_menu_duplicate_options() {
            $wpfm_duplicate_template_nonce = $_REQUEST['_wpnonce'];
            if (!empty($_GET) && wp_verify_nonce($wpfm_duplicate_template_nonce, 'wpfm-duplicate-menu-settings-nonce')) {
                $wpfm_log_id = $_GET['id'];
                global $wpdb;
                if (isset($wpfm_log_id) && !empty($wpfm_log_id) && intval($wpfm_log_id)) {
                    $table_name = $wpdb->prefix . "wp_floating_menu_details";
                    $menu_row_details = $wpdb->get_results("SELECT * FROM $table_name WHERE id=" . $wpfm_log_id);
                    foreach ($menu_row_details as $menu_row_detail) {
                        $menu_name = $menu_row_detail->menu_name;
                        $menu_details = maybe_unserialize($menu_row_detail->menu_details);
                        $menu_display_setting_details = maybe_unserialize($menu_row_detail->menu_display_setting_details);
                    }
                    $insert = $wpdb->insert(
                            $table_name, array(
                        'menu_name' => $menu_name . '-copy',
                        'menu_details' => maybe_serialize($menu_details),
                        'menu_display_setting_details' => maybe_serialize($menu_display_setting_details),
                            )
                    );
                    if ($insert) {
                        $_SESSION['wpfmp_message'] = __('Duplicating the Menu successful.', 'wp-floating-menu-pro');
                        wp_redirect(admin_url() . 'admin.php?page=wpfmp-admin');
                        exit;
                    } else {
                        $_SESSION['wpfmp_message'] = __('Duplicating the Menu Failed. Please Try Again', 'wp-floating-menu-pro');
                        wp_redirect(admin_url() . 'admin.php?page=wpfmp-admin');
                        exit;
                    }
                } else {
                    $_SESSION['wpfmp_message'] = __('No Action Performed', 'wp-floating-menu-pro');
                    wp_redirect(admin_url() . 'admin.php?page=wpfmp-admin');
                    exit;
                }
            } else {
                die('No script kiddies please!');
            }
        }

        /** Function to Duplicate Custom Design Template */
        function wpfm_menu_custom_template_duplicate_options() {
            $wpfm_duplicate_custom_template_nonce = $_REQUEST['_wpnonce'];
            if (!empty($_GET) && wp_verify_nonce($wpfm_duplicate_custom_template_nonce, 'wpfm-duplicate-custom-template-settings-nonce')) {
                $wpfm_log_id = $_GET['id'];
                global $wpdb;
                if (isset($wpfm_log_id) && !empty($wpfm_log_id) && intval($wpfm_log_id)) {
                    $table_name = $wpdb->prefix . "wp_floating_menu_custom_templates";
                    $custom_template_row_details = $wpdb->get_results("SELECT * FROM $table_name WHERE id=" . $wpfm_log_id);
                    foreach ($custom_template_row_details as $custom_template_row_detail) {
                        $template_name = $custom_template_row_detail->template_name;
                        $template_details = maybe_unserialize($custom_template_row_detail->template_details);
                    }
                    $insert = $wpdb->insert(
                            $table_name, array(
                        'template_name' => $template_name . '-copy',
                        'template_details' => maybe_serialize($template_details),
                            )
                    );
                    if ($insert) {
                        $_SESSION['wpfmp_message'] = __('Successfully Duplicated Template - <strong>' . $template_name . '</strong>.', 'wp-floating-menu-pro');
                        wp_redirect(admin_url() . 'admin.php?page=wpfmp-custom-template');
                        exit;
                    } else {
                        $_SESSION['wpfmp_message'] = __('Couldnot Perform Duplicate action. Please Try Again', 'wp-floating-menu-pro');
                        wp_redirect(admin_url() . 'admin.php?page=wpfmp-custom-template');
                        exit;
                    }
                } else {
                    $_SESSION['wpfmp_message'] = __('No Action Performed', 'wp-floating-menu-pro');
                    wp_redirect(admin_url() . 'admin.php?page=wpfmp-admin');
                    exit;
                }
            } else {
                die('No script kiddies please!');
            }
        }

        function wpfm_get_user_role($user = null) {
            $user = $user ? new WP_User($user) : wp_get_current_user();
            return $user->roles ? $user->roles[0] : false;
        }

        function wpfm_get_default_user_list() {
            global $wp_roles;
            $user_role = array();
            $user_role = $wp_roles->roles;
            return $user_role;
        }

    }

    $wpfm_object = new WPFM_PRO();
}