<?php defined('ABSPATH') or die('No script kiddies please!'); ?>

<?php
global $wpdb;
$pages = $this->get_all_page_lists();
$posts = $this->get_all_post_lists();
$categories = $this->get_categories();
$args = array('public' => true, '_builtin' => false);
$output = 'objects';
$operator = 'and';
$post_types = get_post_types($args, $output, $operator);
$all_post_types = array();
foreach ($post_types as $post_type) {
    $all_post_types[] = $post_type->name;
}
$table_name = $wpdb->prefix . "wp_floating_menu_details";
$menu_detail = $wpdb->get_results("SELECT * FROM $table_name WHERE id=" . $_GET['id']);
foreach ($menu_detail as $rows) {
    $id = $_GET['id'];
}
?>

<div class="form-body">
    <div class="wpfm-header-add-menu">
        <a href="<?php echo admin_url() . 'admin.php?page=wpfmp-add-menu' ?>" class="wpfm-add-new-menu"><?php _e('Create New Menu', 'wp-floating-menu-pro'); ?></a> <span><?php _e('Or keep editing current menu', 'wp-floating-menu-pro'); ?> - <span class="wpfm-current-menu-title"><?php echo '<strong>' . esc_attr($rows->menu_name) . '</strong>'; ?></span></span>
    </div>  
    <div class="wpfm-form-body-left">
        <form id="wpfm-update-nav-menu" class="wpfm-add-page-fields" method="post" enctype="multipart/form-data">
            <div class="wpfm-menu-list-field" id="wpfm-page-field">
                <div class="wpfm-field-header" id="wpfm-page-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Pages', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">        
                    <div id="wpfm-page-all" class="wpfm-field-listing">                                                   
                        <ul id="page-checklist" class="list-check-fields">
                            <?php
                            if (count($pages) > 0) {
                                foreach ($pages as $key => $val) {
                                    ?>
                                    <li>
                                        <label>
                                            <input type="checkbox" field-data="<?php _e('Page', 'wp-floating-menu-pro'); ?>" id="wpfm-page-checkbox" class="wpfm-add-check" name="wpfm-add-check[]" id="wpfm-add-check-page" value="<?php echo $key; ?>" />
                                            <span class="pages"><?php echo $val; ?></span>
                                        </label>
                                    </li>
                                    <?php
                                }
                            } else {
                                echo '<span class="wpfm-no-content-error">' . __('No Pages', 'wp-floating-menu-pro') . '</span>';
                            }
                            ?>
                        </ul>
                        <p class="button-controls wp-clearfix">
                            <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                            <span class="wpfm-add-to-menu">
                                <input type="submit" submit-field-val="0" class="button-secondary wpfm-submit-add-to-menu" id="wpfm-page-add-to-menu" value="Add to Menu" name="wpfm_add_post_type_page" />
                            </span>
                        </p>
                        <input type="hidden" name="page_id_values" id="page-id-values"/>
                    </div>
                </div>                                        
            </div><!-- #wpfm-page-field .wpfm-menu-list-field -->

            <div class="wpfm-menu-list-field" id="wpfm-post-field">
                <div class="wpfm-field-header" id="wpfm-post-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Posts', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">
                    <div id="wpfm-post-all" class="wpfm-field-listing">                                
                        <ul id="post-check-list" class="list-check-fields">
                            <?php
                            if (count($posts) > 0) {
                                foreach ($posts as $key => $val) {
                                    ?>                                  
                                    <li>
                                        <label><input type="checkbox" class="wpfm-add-check" field-data="<?php _e('Post', 'wp-floating-menu-pro'); ?>" name="wpfm-add-check[]" id="wpfm-add-check-post" value="<?php echo $key; ?>"/>
                                            <span class="posts"><?php echo $val; ?></span></label>
                                    </li>
                                    <?php
                                }
                            } else {
                                echo '<span class="wpfm-no-content-error">' . __('No Post', 'wp-floating-menu-pro') . '</span>';
                            }
                            ?>
                        </ul>
                        <p class="button-controls wp-clearfix">
                            <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                            <span class="wpfm-add-to-menu">
                                <input type="submit" id="wpfm-submit-posttype-post" submit-field-val="1" class="button-secondary wpfm-submit-add-to-menu" value="Add to Menu" name="wpfm_add_post_type_post" />
                            </span>                
                        </p>                                         
                    </div>
                </div>
            </div><!-- #wpfm-post-field .wpfm-menu-list-field -->
            <div class="wpfm-menu-list-field" id="wpfm-custom-link-field">
                <div class="wpfm-field-header" id="wpfm-custom-link-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Custom Links', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">
                    <div id="wpfm-custom-link-url" class="wpfm-custom-link">                                
                        <label for="wpfm_custom_link_url" class=""><?php _e('URL', 'wp-floating-menu-pro'); ?></label>
                        <div class="wpfm-input-field-wrapper">
                            <input type="url" name="wpfm_custom_link_url" id="wpfm-custom-link-url"/>
                        </div>                             
                    </div>
                    <div id="wpfm-custom-link-text" class="wpfm-custom-link">                                
                        <label for="wpfm_custom_link_text" class=""><?php _e('Link Text', 'wp-floating-menu-pro'); ?></label>
                        <div class="wpfm-input-field-wrapper">
                            <input type="text" name="wpfm_custom_link_text" id="wpfm-custom-link-text"/>
                        </div>                             
                    </div>
                    <p class="button-controls wp-clearfix">
                        <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                        <span class="wpfm-add-to-menu">
                            <input type="button" field-data="<?php _e('Custom Link', 'wp-floating-menu-pro'); ?>" submit-field-val="2" class="button-secondary wpfm-submit-add-to-menu"  id="wpfm-submit-posttype-custom-link" value="Add to Menu" name="wpfm_add_post_type_custom_link"/>
                        </span>                
                    </p>
                </div>
            </div><!-- #wpfm-custom-link-field .wpfm-menu-list-field -->
            <div class="wpfm-menu-list-field" id="wpfm-category-field">
                <div class="wpfm-field-header" id="wpfm-post-content">
                    <div class="wpfm-drag-icon"></div>
                    <h3 class="wpfm-menu-title"><?php _e('Categories', 'wp-floating-menu-pro'); ?></h3>
                    <span class="wpfm-arrow-down wpfm-arrow"></span>
                </div>
                <div class="wpfm-list-inner-content" style="display:none;">
                    <div id="wpfm-page-all" class="wpfm-category-listing">                                
                        <ul id="category-check-list" class="list-check-fields">
                            <?php
                            if (count($categories) > 0) {
                                foreach ($categories as $key => $val) {
                                    ?>                       
                                    <li>
                                        <label><input type="checkbox" class="wpfm-add-check" field-data="<?php _e('Category', 'wp-floating-menu-pro'); ?>" name="wpfm-add-check[]" value="<?php echo $key; ?>" />
                                            <span class="category"><?php echo $val; ?></span></label>
                                    </li>
                                    <?php
                                }
                            } else {
                                echo '<span class="wpfm-no-content-error">' . __('No Category', 'wp-floating-menu-pro') . '</span>';
                            }
                            ?>
                        </ul>
                        <p class="button-controls wp-clearfix">
                            <span class="spinner wpfm-view-wrap is-active" style="display:none;"></span> 
                            <span class="wpfm-add-to-menu">
                                <input type="submit" submit-field-val="3" class="button-secondary wpfm-submit-add-to-menu" value="Add to Menu" name="wpfm_add_post_type_category" id="wpfm-submit-posttype-category" />
                            </span>
                        </p>                                            
                    </div>
                </div>
            </div><!-- #wpfm-category-field .wpfm-menu-list-field -->
        </form><!-- .wpfm-add-page-fields -->
    </div><!--wpfm-form-body-left -->

    <div class="wpfm-form-body-right">
        <div class="wpfm-form-body-right-inner-wrapper">
            <form action="<?php echo admin_url() . 'admin-post.php' ?>" method='post' class="wpfm-menu-structure">
                <div class='wpfm-tab-contents' id='tab-wpfm-add-menu'>
                    <input type="hidden" name="action" value="wpfm_save_menu_field_options" />
                    <div class="wpfm-upper-body-section">
                        <div class="wpfm-add-new-form">
                            <label for="wpfm_save_menu_name" class="wpfm-input-field-controller"><?php _e('Menu Name', 'wp-floating-menu-pro'); ?></label>
                            <div class="wpfm-input-field-wrapper">
                                <input type="text" name="wpfm_save_menu_name" class="wpfm-menu-name" id="wpfm-menu-name" value="<?php echo esc_attr($rows->menu_name); ?>"/>
                            </div>
                        </div>
                        <div class="wpfm-publishing-action" id="wpfm-save-form-upper">
                            <input type="submit" name="wpfm_save_menu_fields" id="wpfm-save-menu-header" class="button button-primary wpfm-menu-field-save" value="Save Menu"/>
                            <a class="button button-primary wpfm-menu-field-preview" href="<?php echo site_url('?wpfmp_preview=true&menu_id=' . $id); ?>"  target="_blank"><?php _e('Preview Menu', 'wp-floating-menu-pro') ?></a>
                        </div>
                    </div>

                    <div id="post-body-content" class="wp-clearfix">
                        <h3 class="wpfm-menu-name"><?php _e('Menu Structure', 'wp-floating-menu-pro'); ?></h3>
                        <div class="drag-instructions post-body-plain">
                            <?php _e('<p class="menu-field-info">Drag each item into the order you prefer. Click the arrow on the right of the item to reveal additional configuration options.</p>', 'wp-floating-menu-pro'); ?> 
                        </div>
                        <div class="wpfm-menu-temp-holder" style="display:none;"></div>
                        <div class="wpfm-sortable-menu-field">
                            <?php
                            $menu_details = maybe_unserialize($rows->menu_details);
                            $keyArray = array();
                            if (!empty($menu_details)) {
                                foreach ($menu_details as $key => $val) {
                                    $keyArray[$key] = $key;
                                    ?>                                
                                    <ul class="wpfm-menu ui-sortable" id="wpfm-menu-to-edit">
                                        <li id="wpfm-menu-item" class="wpfm-menu-item">
                                            <div class="wpfm-menu-item-bar">
                                                <div class="wpfm-menu-item-handle">
                                                    <span class="wpfm-item-title">
                                                        <span class="wpfm-menu-item-title"><?php echo stripslashes_deep($val["wpfm_menu_item_title"]); ?></span> 
                                                    </span>
                                                    <span class="wpfm-item-type"><?php echo $val['field_data']; ?></span>
                                                    <span class="wpfm-ind-menu-toggle-icon"><i class="fa fa-sort-down"></i></span>                   
                                                </div>
                                            </div>
                                            <div class="wpfm-menu-item-settings" id="wpfm-menu-item-settings" style="display:none">
                                                <div class="wpfm-description wpfm-description-wide">
                                                    <label class="wpfm-menu-label-controller" for="wpfm_menu_item_title"><?php _e('Navigation Label', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <input type="text" id="wpfm-edit-menu-item-item-title" class="wpfm-edit-menu-item-title" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_menu_item_title]" data-field-name="menu_id" value="<?php echo stripslashes_deep($val["wpfm_menu_item_title"]); ?>"/>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                                                    <label class="wpfm-menu-label-controller"><?php _e('Show Navigation Label', 'wp-floating-menu-pro'); ?></label>
                                                    <label class="wpfm-menu-label-controller" for="wpfm-navigation-show-hide">                  
                                                        <input type="checkbox" id="wpfm-navigation-show-hide" value="1" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_title_show]" data-field-name="menu_id" <?php
                                                        if (isset($val['wpfm_title_show']) && $val['wpfm_title_show'] == '1') {
                                                            echo 'checked="checked"';
                                                        }
                                                        ?>/><?php _e('Show/Hide', 'wp-floating-menu-pro'); ?></label>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide">
                                                    <label class="wpfm-menu-label-controller" for="wpfm_menu_item_title_attribute"><?php _e('Title Attribute', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <input type="text" id="wpfm-edit-menu-title-attribute" class="wpfm-edit-menu-item-title-attribute" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_menu_item_title_attribute]" data-field-name="menu_id" value="<?php echo $val['wpfm_menu_item_title_attribute']; ?>"/>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                                                    <label class="wpfm-menu-label-controller"><?php _e('Show Tooltip Title', 'wp-floating-menu-pro'); ?></label>
                                                    <label class="wpfm-menu-label-controller">
                                                        <input type="checkbox" id="wpfm-tooltip-show-hide" value="1" <?php
                                                        if (isset($val['wpfm_tooltip_show']) && $val['wpfm_tooltip_show'] == '1') {
                                                            echo 'checked="checked"';
                                                        }
                                                        ?> name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_tooltip_show]" data-field-name="menu_id"/>
                                                        <?php _e('Show/Hide', 'wp-floating-menu-pro'); ?></label>					
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-edit-menu-tooltip-wrap" <?php
                                                if (isset($val['wpfm_tooltip_show']) && $val['wpfm_tooltip_show'] == '1') {
                                                    echo 'style="display:block;"';
                                                } else {
                                                    echo 'style="display:none;"';
                                                }
                                                ?>>
                                                    <label class="wpfm-menu-tooltip-title" for="wpfm_menu_tooltip_title"><?php _e('Tooltip Title', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <input type="text" id="wpfm-edit-menu-tooltip" class="wpfm-edit-menu-tooltip-title" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_menu_tooltip_title]" data-field-name="menu_id" value="<?php echo stripslashes_deep($val['wpfm_menu_tooltip_title']); ?>"/>
                                                    </div>
                                                </div>
                                                <div class="wpfm-field-targer-link wpfm-description-wide">
                                                    <label for="wpfm_target_link_address"><?php _e('Target Link', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <input type="text" id="wpfm-edit-menu-item-title" class="wpfm-edit-menu-item-title" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_target_link_address]"  data-field-name="menu_id" value="<?php echo $val['wpfm_target_link_address']; ?>"/>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                                                    <label class="wpfm-menu-label-controller"><?php _e('Open Link in New Tab', 'wp-floating-menu-pro'); ?></label>
                                                    <label class="wpfm-menu-label-controller" for="wpfm-field-link-target">
                                                        <input type="checkbox" <?php
                                                        if (isset($val['wpfm_field_link_target']) && $val['wpfm_field_link_target'] == '1') {
                                                            echo 'checked="checked"';
                                                        }
                                                        ?> id="wpfm-field-link-target" value="1" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_field_link_target]" data-field-name="menu_id" />
                                                        <?php _e('New Tab/Same Tab ', 'wp-floating-menu-pro'); ?></label>					
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-field-targer-link">
                                                    <label for="wpfm_target_class"><?php _e('Custom Class', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <input type="text" id="wpfm-edit-menu-item-class" class="wpfm-edit-menu-item-class" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_custom_class]"  data-field-name="menu_id" value="<?php echo isset($val['wpfm_custom_class']) && !empty($val['wpfm_custom_class']) ? $val['wpfm_custom_class'] : ''; ?>"/>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-field-targer-link">
                                                    <label for="wpfm-edit-menu-item-link-relation"><?php _e('Link Relationship (XFN)', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <input type="text" id="wpfm-edit-menu-item-link-relation" class="wpfm-edit-menu-item-link-relation" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_xfn_relationship]"  value="<?php echo isset($val['wpfm_xfn_relationship']) && !empty($val['wpfm_xfn_relationship']) ? $val['wpfm_xfn_relationship'] : ''; ?>"/>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide" id="wpfm-menu-item-type-field">
                                                    <label class="wpfm-menu-label-controller"><?php _e('Modal Popup For This Menu', 'wp-floating-menu-pro'); ?></label>
                                                    <label class="wpfm-menu-label-controller">                        
                                                        <input type="checkbox" <?php
                                                        if (isset($val['wpfm_field_enable_modal_pp']) && $val['wpfm_field_enable_modal_pp'] == '1') {
                                                            echo 'checked="checked"';
                                                        }
                                                        ?> class="wpfm-checkbox" id="wpfm-field-modal-pp-target" value="1" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_field_enable_modal_pp]"/>                				
                                                        <?php _e('Enable/Disable', 'wp-floating-menu-pro'); ?></label>
                                                    </label>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-menu-popup-content-wrap" id="wpfm-menu-item-type-field" <?php if (isset($val['wpfm_field_enable_modal_pp']) && $val['wpfm_field_enable_modal_pp'] == '1') { ?> style="display:block;"<?php } else { ?>style="display:none;" <?php } ?>>
                                                    <label for="wpfm_custom_mod_popup_content"><?php _e('Modal Popup Content', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <textarea id="wpfm-menu-popup-content" class="wpfm-edit-menu-item-class" name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_custom_mod_popup_content]" placeholder="<?php _e('You can insert shortcode or basic text content here', 'wp-floating-menu-pro'); ?>"><?php echo isset($val['wpfm_custom_mod_popup_content']) && !empty($val['wpfm_custom_mod_popup_content']) ? stripslashes_deep($val['wpfm_custom_mod_popup_content']) : ''; ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-type-field" id="wpfm-field-add-menu-type">
                                                    <label for="wpfm_edit_menu_icons_type"><?php _e('Menu Icon Type', 'wp-floating-menu-pro'); ?></label>
                                                    <select name="menu_structure[<?php echo esc_attr($key); ?>][icon_icon_type]"  data-field-name="menu_id" class="wpfm-icon-type">
                                                        <option value="default" <?php if (isset($val['icon_icon_type']) && $val['icon_icon_type'] == 'default') { ?>selected="selected"<?php } ?>><?php _e('Use Default Icon', 'wp-floating-menu-pro'); ?></option>
                                                        <option value="custom" <?php if (isset($val['icon_icon_type']) && $val['icon_icon_type'] == 'custom') { ?>selected="selected"<?php } ?>><?php _e('Use Custom Icon', 'wp-floating-menu-pro'); ?></option>
                                                        <option value="image-icon" <?php if (isset($val['icon_icon_type']) && $val['icon_icon_type'] == 'image-icon') { ?>selected="selected"<?php } ?>><?php _e('Use Custom Image', 'wp-floating-menu-pro'); ?></option>
                                                    </select>	
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field" id="wpfm-field-add-menu-icons"
                                                     <?php if (isset($val['icon_icon_type']) && $val['icon_icon_type'] == 'default' || !isset($val['icon_icon_type'])) { ?>style="display:block"<?php } else { ?>style="display:none"<?php } ?>>
                                                    <label class="wpfm-menu-label-controller" for="wpfm_edit_menu_icons"><?php _e('Default Icon', 'wp-floating-menu-pro'); ?></label>
                                                    <span>
                                                        <input class="wpfm-icon-picker" type="hidden" id="wpfm-icon-picker-icon_<?php echo esc_attr($key); ?>" name="menu_structure[<?php echo esc_attr($key); ?>][icon_picker_settings]" data-field-name="menu_id" value="<?php echo $val['icon_picker_settings']; ?>"/>
                                                        <div id="wpfm-menu-icon-div" data-target="#wpfm-icon-picker-icon_<?php echo esc_attr($key); ?>" class="button icon-picker <?php
                                                        if (isset($val['icon_picker_settings']) && !empty($val['icon_picker_settings'])) {
                                                            $v = explode('|', esc_attr($val['icon_picker_settings']));
                                                            echo $v[0] == 'eleganticons' ? esc_attr($v[0]) . ' ' . ltrim($v[1], '-') : $v[0] . ' ' . $v[1];
                                                        }
                                                        ?>"><?php _e('Select Icon', 'wp-floating-menu-pro'); ?></div>
                                                    </span>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field" id="wpfm-field-add-custom-menu-icons"  <?php if (isset($val['icon_icon_type']) && $val['icon_icon_type'] == 'custom') { ?>style="display:block"<?php } else { ?>style="display:none"<?php } ?>>
                                                    <label class="wpfm-menu-label-controller" for="icon_picker_custom"><?php _e('Custom Icon:', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <input class="wpfm-icon-custom" type="text" id="wpfm-icon-picker-custom" name="menu_structure[<?php echo esc_attr($key); ?>][icon_picker_custom]" data-field-name="menu_id" value="<?php
                                                        if (isset($val['icon_picker_custom']) && !empty($val['icon_picker_custom'])) {
                                                            echo $val['icon_picker_custom'];
                                                        }
                                                        ?>" placeholder="<?php _e('Eg:-', 'wp-floating-menu-pro'); ?> fa fa-bars"/>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field" id="wpfm-field-add-custom-image-icons" <?php if (isset($val['icon_icon_type']) && $val['icon_icon_type'] == 'image-icon') { ?>style="display:block"<?php } else { ?>style="display:none"<?php } ?>>
                                                    <label class="wpfm-menu-label-controller" for="icon_picker_image_custom"><?php _e('Image Icon:', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="menu-inner-input-field">
                                                        <span class="wpfm-image-preview"><img src="<?php echo!empty($val['icon_picker_image_custom']) ? $val['icon_picker_image_custom'] : WPFM_PRO_IMAGE_DIR . 'default-image-icon.png'; ?>" style="width:<?php echo!empty($val['icon_picker_image_custom_size']) ? $val['icon_picker_image_custom_size'] : '25'; ?>px; height:<?php echo!empty($val['icon_picker_image_custom_size']) ? $val['icon_picker_image_custom_size'] : '25'; ?>px; box-shadow: 2px 0px 10px 1px;"/></span>
                                                        <input class="wpfm-icon-image-custom" type="text" id="wpfm-icon-picker-image-custom" name="menu_structure[<?php echo esc_attr($key); ?>][icon_picker_image_custom]" data-field-name="menu_id" value="<?php echo!empty($val['icon_picker_image_custom']) ? $val['icon_picker_image_custom'] : ''; ?>"/>
                                                        <input class="wpfm-icon-image-custom-upload button button-primary" type="button" value="<?php _e('Upload Icon', 'wp-floating-menu-pro'); ?>">
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field">
                                                    <label class="wpfm-menu-label-controller" for="icon_color_type"><?php _e('Icon Color Type', 'wp-floating-menu-pro'); ?></label>
                                                    <select name="menu_structure[<?php echo esc_attr($key); ?>][icon_color_type]"  data-field-name="menu_id" class="wpfm-icon-color-type">
                                                        <option value="default" <?php if (isset($val['icon_color_type']) && $val['icon_color_type'] == 'default') { ?>selected="selected"<?php } ?>><?php _e('Use Default', 'wp-floating-menu-pro'); ?></option>
                                                        <option value="custom" <?php if (isset($val['icon_color_type']) && $val['icon_color_type'] == 'custom') { ?>selected="selected"<?php } ?>><?php _e('Use Custom Color', 'wp-floating-menu-pro'); ?></option>
                                                    </select>					
                                                </div>
                                                <div class="wpfm-menu-icon-color-setting wpfm-menu-icon-field" id="wpfm-menu-icon-color-setting" <?php
                                                if (isset($val['icon_color_type']) && $val['icon_color_type'] == 'custom') {
                                                    echo 'style="display:block"';
                                                } else {
                                                    echo 'style="display:none;"';
                                                }
                                                ?>>
                                                    <div class="wpfm-description wpfm-description-wide">
                                                        <label class="wpfm-menu-label-controller" for="menu_icon_color"><?php _e('Icon color', 'wp-floating-menu-pro'); ?></label>
                                                        <div class="menu-inner-input-field">
                                                            <input type="text" name="menu_structure[<?php echo esc_attr($key); ?>][menu_icon_color]" data-field-name="menu_id" id="menu-icon-color" class="wpfm-colorpicker-trigger" value="<?php
                                                            if (!empty($val['menu_icon_color'])) {
                                                                echo $val['menu_icon_color'];
                                                            }
                                                            ?>"/>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-menu-icon-field">
                                                    <label class="wpfm-menu-label-controller" for=""><?php _e('User Control', 'wp-floating-menu-pro'); ?></label>
                                                    <select name="menu_structure[<?php echo esc_attr($key); ?>][check_user_log]"  data-field-name="menu_id" class="wpfm-icon-user-type">
                                                        <option value="all" <?php if (isset($val['check_user_log']) && $val['check_user_log'] == 'all') { ?>selected="selected"<?php } ?>><?php _e('All Users', 'wp-floating-menu-pro'); ?></option>
                                                        <option value="logged-in" <?php if (isset($val['check_user_log']) && $val['check_user_log'] == 'logged-in') { ?>selected="selected"<?php } ?>><?php _e('Only Logged In User', 'wp-floating-menu-pro'); ?></option>
                                                    </select>
                                                </div>
                                                <div class="wpfm-description wpfm-description-wide wpfm-user-role-checkbox" <?php if (isset($val['check_user_log']) && $val['check_user_log'] == 'logged-in') { ?>style="display:block;" <?php } else { ?>style="display:none;" <?php } ?>>
                                                    <label class="wpfm-menu-label-controller"><?php _e('User Role For Logged In', 'wp-floating-menu-pro'); ?></label>
                                                    <div class="wpfm-user-control-label-controller-input">
                                                        <?php
                                                        $wpfm_userrole_admin = array();
                                                        if (isset($val["wpfm_userrole"]) && !empty($val["wpfm_userrole"])) {
                                                            foreach ($val["wpfm_userrole"] as $akey => $aval) {
                                                                array_push($wpfm_userrole_admin, $aval);
                                                            }
                                                        }
                                                        $wpfm_default_user_lists = $this->wpfm_get_default_user_list();
                                                        if (!empty($wpfm_default_user_lists)) {
                                                            foreach ($wpfm_default_user_lists as $wpfm_edit_user_key => $wpfm_edit_user_value):
                                                                ?>
                                                                <label class="wpfm-menu-label-inner-controller">
                                                                    <input type="checkbox" class="wpfm-user-role" value="<?php echo $wpfm_edit_user_key; ?>" <?php
                                                                    if (in_array($wpfm_edit_user_key, $wpfm_userrole_admin)) {
                                                                        echo 'checked="checked"';
                                                                    }
                                                                    ?>name="menu_structure[<?php echo esc_attr($key); ?>][wpfm_userrole][]" data-field-name="menu_id"/>
                                                                    <?php echo esc_attr($wpfm_edit_user_key); ?></label>					
                                                                <?php
                                                            endforeach;
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                                <div class="wpfm-field-remove">
                                                    <a href="#" class="wpfm-remove-menu"><?php _e('Remove', 'wp-floating-menu-pro'); ?></a>
                                                </div>             
                                            </div><!-- .menu-item-settings-->

                                            <input type="hidden" name="menu_structure[<?php echo esc_attr($key); ?>][item_value]"  data-field-name="menu_id" value="<?php echo stripslashes_deep($val['item_value']); ?>" />
                                            <input type="hidden" name="menu_structure[<?php echo esc_attr($key); ?>][field_data]"  data-field-name="menu_id" value="<?php echo $val['field_data']; ?>" />
                                        </li>
                                    </ul>
                                    <?php
                                }
                            }
                            $max_key = !empty($keyArray) ? array_keys($keyArray, max($keyArray)) : array('0' => '0');
                            ?>
                            <input type="hidden" name="menu_count" value="<?php echo $max_key[0]; ?>" class="wpfm-menu-count"/>
                        </div>
                        <input type="hidden" name="current_menu_id" value="<?php echo esc_attr($_GET['id']); ?>" />
                        <input type="hidden" name="current_menu_name" value="<?php echo esc_attr($rows->menu_name); ?>" />                    
                    </div>
                </div>
                <div class="wpfm-setting-form" >
                    <div class='wpfm-tab-contents' id='tab-wpfm-display-setting' style="display:none">                 
                        <?php include( 'wpfm-display-setting.php' ); ?>
                    </div>
                </div>
                <div class="wpfm-right-body-footer">
                    <div class="wpfm-publishing-action" id="wpfm-save-form-lower">
                        <input type="submit" name="wpfm_save_menu_fields" id="wpfm-save-menu-footer" class="button button-primary wpfm-menu-field-save" value="Save Menu"/>
                        <a class="button button-primary wpfm-menu-field-preview" href="<?php echo site_url('?wpfmp_preview=true&menu_id=' . $id); ?>"  target="_blank"><?php _e('Preview Menu', 'wp-floating-menu-pro') ?></a>
                    </div>
                    <?php wp_nonce_field('wpfm_nonce_save_menu_fields', 'wpfm_add_nonce_save_menu_fields'); ?>
                </div>
            </form><!-- #wpfm-update-nav-menu .wpfm-save-menu -->
        </div><!-- .wpfm-form-body-right-inner-wrapper -->
    </div><!-- .wpfm-form-body-right -->
</div><!-- .Form-Body --> 