<?php
/**
 * WP Courseware Legacy Setup.
 *
 * @package WPCW
 * @since 4.1.0
 */

/**
 * Creates the correct URL for course units, showing module and course names.
 *
 * @since 4.1.0
 *
 * @param string $post_link The current permalinkf for the unit (which includes %module_number%).
 * @param object $post The object of the post for which a URL is requested.
 */
function WPCW_units_createCorrectUnitURL( $post_link, $post = 0, $leavename = false ) {
	// Only filter if found module number
	if ( strpos( '%module_number%', $post_link ) === 'FALSE' ) {
		return $post_link;
	}

	// Ensure we have access to the post object
	if ( is_object( $post ) ) {
		$post_id = $post->ID;
	} else {
		$post_id = $post;
		$post    = get_post( $post_id );
	}

	// Check that we've got access to the right course unit post type
	if ( ! is_object( $post ) || $post->post_type != 'course_unit' ) {
		return $post_link;
	}

	// Work out the module number for the unit.
	$moduleID = get_post_meta( $post->ID, 'wpcw_associated_module', true );

	// V2.2 Fix - Using module NUMBER not module ID for the URL.
	$moduleDetails = WPCW_modules_getModuleDetails( absint( $moduleID ) );

	// Not found the right module, so remove the prefix.
	if ( ! $moduleDetails ) {
		//return str_replace('%module_number%', 'module-unassigned', $post_link);
		return str_replace( '%module_number%', apply_filters( 'wpcw_permalinks_urlgen_module_unassigned', 'module-unassigned' ), $post_link );
	}

	// Put new slug in place of %module_number%
	//return str_replace('%module_number%', 'module-' . $moduleDetails->module_number, $post_link);
	return str_replace( '%module_number%', sprintf( apply_filters( 'wpcw_permalinks_urlgen_module', 'module-%d', $post, $moduleDetails ), $moduleDetails->module_number ), $post_link );
}

/**
 * Create screen optionsn for the course dashboard page.
 *
 * @since 4.1.0
 */
function WPCW_course_dashboard_screen_options() {
	$user_id = get_current_user_id();

	// Check for form submission
	if ( isset( $_POST['course_dashboard_screen_options_submit'] ) AND $_POST['course_dashboard_screen_options_submit'] == 1 ) {
		if ( isset( $_POST['quiz_notification_hide'] ) && $_POST['quiz_notification_hide'] = 'show' ) {
			update_user_meta( $user_id, 'wpcw_course_dashboard_quiz_notification_hide', 'show', 'hide' );
		} else {
			update_user_meta( $user_id, 'wpcw_course_dashboard_quiz_notification_hide', 'hide', 'show' );
		}
		if ( isset( $_POST['wpcw_courses_per_page'] ) && $_POST['wpcw_courses_per_page'] > 0 ) {
			update_user_meta( $user_id, 'wpcw_courses_per_page', $_POST['wpcw_courses_per_page'], '' );
		}
	}

	// Initiate the $screen variable.
	$screen = get_current_screen();

	// Add our custom HTML to the screen options panel.
	add_filter( 'screen_layout_columns', function ( $html ) {
		$user_id = get_current_user_id();
		$html    = sprintf( '<div id="screen-options-wrap">
			<form name="course_dashboard_screen_options_form" method="post">
				<input type="hidden" name="course_dashboard_screen_options_submit" value="1">
				<legend>WP Courseware - Course Dashboard Options</legend>
					<fieldset >
						<label>Enable/Disable - Quiz Notifications</label><input class="hide-column-tog" name="quiz_notification_hide" type="checkbox" id="quiz_notification_hide" value="%s" %s>
					</fieldset>
					<fieldset >
						<label for="wpcw_courses_per_page">Number of courses per page:</label><input type="number" step="1" min="1" max="50" class="screen-per-page" name="wpcw_courses_per_page" id="wpcw_courses_per_page" maxlength="3" value="%d">
					</fieldset>
						<p class="submit"><input type="submit" name="screen-options-apply" id="screen-options-apply" class="button button-primary" value="Apply"></p>
			</form>
			</div>',
			$quiz_notify = ( get_user_meta( $user_id, 'wpcw_course_dashboard_quiz_notification_hide', true ) != false ) ? get_user_meta( $user_id, 'wpcw_course_dashboard_quiz_notification_hide', true ) : 'hide',
			$quiz_notify_check = ( get_user_meta( $user_id, 'wpcw_course_dashboard_quiz_notification_hide', true ) != 'show' ) ? '' : 'checked',
			$course_per_page = ( get_user_meta( $user_id, 'wpcw_courses_per_page', true ) != false ) ? get_user_meta( $user_id, 'wpcw_courses_per_page', true ) : 20
		);

		echo $html;
	} );

	// Register our new screen options tab.
	$screen->add_option( 'my_option', '' );
}

/**
 * Return the URL for the page Icon.
 *
 * @since 4.1.0
 *
 * @return string The URL for the page icon.
 */
function WPCW_icon_getPageIconURL() {
	return WPCW_IMG_URL . 'icon_training_32.png';
}

/**
 * Get the URL for the plugin path including a trailing slash.
 *
 * @since 4.1.0
 *
 * @return string The URL for the plugin path.
 */
function WPCW_plugin_getPluginPath() {
	return plugin_dir_url( WPCW_FILE );
}

/**
 * Get the directory path for the plugin path including a trailing slash.
 *
 * @since 4.1.0
 *
 * @return string The URL for the plugin path.
 */
function WPCW_plugin_getPluginDirPath() {
	$folder = basename( dirname( WPCW_FILE ) );

	return WP_PLUGIN_DIR . "/" . trailingslashit( $folder );
}

/**
 * Determine if we're on a page just related to this plugin in the admin area.
 *
 * @since 4.1.0
 *
 * @return boolean True if we're on an admin page, false otherwise.
 */
function WPCW_areWeOnPluginPage() {
	if ( $currentPage = WPCW_arrays_getValue( $_GET, 'page' ) ) {
		if ( substr( $currentPage, 0, 5 ) == 'WPCW_' ) {
			return true;
		}
	}

	return false;
}

/**
 * Hide items from the menu we don't want, but still want access to.
 *
 * @since 4.1.0
 */
function WPCW_menu_MainMenu_cleanUnwantedEntries() {
	global $submenu;

	// Rename the Training Courses page to include a count of quizzes that need attention.
	$quizCount = WPCW_quizzes_getCoursesNeedingAttentionCount();
	if ( $quizCount > 0 ) {
		if ( isset( $submenu[ WPCW_PLUGIN_ID ] ) ) {
			$submenu[ WPCW_PLUGIN_ID ][0][0] .= sprintf( '<span class="update-plugins count-%d"><span class="update-count">%s</span></span>', $quizCount, $quizCount );
		}
	}

	// Hide context pages
	WPCW_menu_removeSubmenuItem( WPCW_PLUGIN_ID, 'WPCW_showPage_CourseOrdering' );
	WPCW_menu_removeSubmenuItem( WPCW_PLUGIN_ID, 'WPCW_showPage_ConvertPage' );
	WPCW_menu_removeSubmenuItem( WPCW_PLUGIN_ID, 'WPCW_showPage_GradeBook' );
	//WPCW_menu_removeSubmenuItem(WPCW_PLUGIN_ID, 'WPCW_showPage_ModifyQuestion');

	// Hide User Menus
	WPCW_menu_removeSubmenuItem( 'admin.php', 'WPCW_showPage_UserCourseAccess' );
	WPCW_menu_removeSubmenuItem( 'admin.php', 'WPCW_showPage_UserProgess' );
	WPCW_menu_removeSubmenuItem( 'admin.php', 'WPCW_showPage_UserProgess_quizAnswers' );

	// Hide from single profile menus
	WPCW_menu_removeSubmenuItem( 'admin.php', 'WPCW_showPage_UserCourseAccess' );
	WPCW_menu_removeSubmenuItem( 'profile.php', 'WPCW_showPage_UserProgess' );
	WPCW_menu_removeSubmenuItem( 'profile.php', 'WPCW_showPage_UserProgess_quizAnswers' );
}

/**
 * Checks to see if the permalinks are using '/%postname%/' for WPCW to work correctly.
 *
 * @since 4.1.0
 */
function WPCW_plugin_permalinkCheck() {
	global $current_user;
	$userid              = $current_user->ID;
	$permalink_structure = get_option( 'permalink_structure' );

	// Only show this notice if user hasn't already dismissed it
	if ( ! get_user_meta( $userid, 'ignore_permalinks_notice' ) &&
	     ( '/%postname%/' != $permalink_structure ) ) {
		printf( '<div class="updated notice wpcw-perm-notice is-dismissible">
					<p>%s</p>
					<p>%s <strong><a href="%s">%s</a></strong>.</p>
					<p><a class="button button-secondary" href="%s">%s</a></p>
				</div>',
			__( "For <strong>WP Courseware</strong> unit URLs to work correctly, please ensure your <strong>permalinks</strong> use just <code>/%postname%/</code>.", 'wp-courseware' ),
			__( "You can update the permalink settings to use just <strong>Post Name</strong> on the", 'wp-courseware' ),
			admin_url( 'options-permalink.php' ),
			__( 'Permalink Settings page', 'wp-courseware' ),
			add_query_arg( array( 'wpcw_perma_notice_hide' => true ) ),
			__( 'Dismiss this notice.', 'wp-courseware' )
		);
	}
}

/**
 * Message shown to say that multi-site is not currently supported.
 *
 * @since 4.1.0
 */
function WPCW_plugin_multisiteCheck() {
	if ( ! is_multisite() ) {
		return;
	}

	printf( '<div class="updated error"><p>%s</p></div>', __( '<b>WP Courseware</b> is not currently supported on WordPress Multisite. <b>Yet</b>.', 'wp-courseware' ) );
}

/**
 * Function called on initialisation of the function to clean up orphan tags.
 *
 * @since 4.1.0
 */
function WPCW_tag_cleanup() {
	global $wpdb, $wpcwdb;
	$wpdb->show_errors();

	// If table doesn't exist, don't run maintenance.
	if ( ! is_null( $wpdb->get_var( "SHOW TABLES LIKE '$wpcwdb->question_tag_mapping'" ) ) ) {
		// We want to find all unique questions that have been deleted. We do this by
		// joining the tag table with the table of questions. WHERE filters out where
		// a tag exists, but a question does.
		$tags = $wpdb->get_results( "SELECT tm.*, qq.question_id AS jn_question_id
				FROM $wpcwdb->question_tag_mapping tm
				LEFT JOIN $wpcwdb->quiz_qs qq ON qq.question_id = tm.question_id
				WHERE qq.question_id IS NULL
				" );

		// Delete the tag from each question that we've found above, which will also
		// update the tag popularity once deleted.
		if ( $tags ) {
			foreach ( $tags as $tag ) {
				WPCW_questions_tags_removeTag( $tag->question_id, $tag->tag_id );
			}
		}
	}
}