<?php
/**
 * WP Courseware Units Functions.
 *
 * @package WPCW
 * @subpackage Functions
 * @since 4.3.0
 */

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Can Student Access Unit?
 *
 * @since 4.3.0
 *
 * @param int $unit_id The unit id.
 * @param int $student_id The student id.
 *
 * @return bool True if the student can access unit.
 */
function wpcw_can_student_access_unit( $unit_id, $student_id = 0 ) {
	$can_access = false;

	if ( ! $unit_id ) {
		return $can_access;
	}

	if ( ! $student_id && ! is_user_logged_in() ) {
		return $can_access;
	}

	if ( ! $student_id ) {
		$student_id = get_current_user_id();
	}

	$unit_data = WPCW_units_getUnitMetaData( $unit_id );

	if ( empty( $unit_data ) || empty( $unit_data->parent_course_id ) ) {
		return $can_access;
	}

	if ( WPCW_courses_canUserAccessCourse( $unit_data->parent_course_id, $student_id ) ) {
		$can_access = true;
	}

	return $can_access;
}