<?php
/**
 * WP Courseware Database Table User Progress.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_User_Progress.
 *
 * @since 4.3.0
 */
final class DB_Table_User_Progress extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_user_progress';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 430;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "user_id int(11) unsigned NOT NULL,
			             unit_id int(11) unsigned NOT NULL,
			             unit_completed_date datetime DEFAULT NULL,
			             unit_completed_status varchar(20) NOT NULL,
			             PRIMARY KEY  (user_id,unit_id)";
	}

	/**
	 * Handle Upgrades.
	 *
	 * @since 4.3.0
	 */
	protected function upgrade() {
	}
}