<?php
/**
 * WP Courseware Database Table Quizzes Questions Map.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Quizzes_Questions_Map.
 *
 * @since 4.3.0
 */
final class DB_Table_Quizzes_Questions_Map extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_quizzes_questions_map';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 430;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "parent_quiz_id bigint(20) unsigned NULL,
						 question_id bigint(20) unsigned NOT NULL,
						 question_order int(11) unsigned NOT NULL DEFAULT '0',
						 UNIQUE KEY question_assoc_id (parent_quiz_id,question_id)";
	}

	/**
	 * Handle Upgrades.
	 *
	 * @since 4.3.0
	 */
	protected function upgrade() {
	}
}