<?php
/**
 * WP Courseware Database Table Question Tags Map.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Question_Tags_Map.
 *
 * @since 4.3.0
 */
final class DB_Table_Question_Tags_Map extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_question_tags_map';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 430;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "question_id bigint(20) unsigned NOT NULL,
						 tag_id bigint(20) unsigned NOT NULL,
						 UNIQUE KEY question_tag_id (question_id,tag_id)";
	}

	/**
	 * Handle Upgrades.
	 *
	 * @since 4.3.0
	 */
	protected function upgrade() {
	}
}