<?php
/**
 * WP Courseware Database Table Modules.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Modules.
 *
 * @since 4.3.0
 */
final class DB_Table_Modules extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_modules';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 430;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "module_id int(11) unsigned NOT NULL AUTO_INCREMENT,
			             parent_course_id int(11) unsigned NOT NULL DEFAULT '0',
			             module_author bigint(20) unsigned NOT NULL default '0',
			             module_title varchar(150) NOT NULL,
			             module_desc text NULL,
			             module_order int(11) unsigned NOT NULL DEFAULT '10000',
			             module_number int(11) unsigned NOT NULL DEFAULT '0',
			             PRIMARY KEY  (module_id)";
	}

	/**
	 * Handle Upgrades.
	 *
	 * @since 4.3.0
	 */
	protected function upgrade() {
	}
}