<?php
/**
 * WP Courseware Database Logs Table.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Logs.
 *
 * @since 4.3.0
 */
final class DB_Table_Logs extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_logs';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 430;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "log_id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						 object_id bigint(20) unsigned NOT NULL DEFAULT '0',
						 object_type varchar(20) DEFAULT NULL,
						 type varchar(30) DEFAULT NULL,
						 title varchar(200) DEFAULT NULL,
						 message longtext,
						 date_created datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
						 PRIMARY KEY (log_id),
						 KEY object_id_type (object_id, object_type),
						 KEY type (type),
						 KEY date_created (date_created)";
	}

	/**
	 * Handle Upgrades.
	 *
	 * @since 4.3.0
	 */
	protected function upgrade() {
	}
}