<?php
/**
 * WP Courseware Database Table Courses.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Courses.
 *
 * @since 4.3.0
 */
final class DB_Table_Courses extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_courses';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 432;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "course_id int(11) unsigned NOT NULL AUTO_INCREMENT,
			             course_title varchar(150) NOT NULL,
			             course_desc text NULL,
			             course_author bigint(20) unsigned NOT NULL default '0',
			             course_opt_completion_wall varchar(20) NOT NULL,
			             course_opt_use_certificate varchar(20) NOT NULL DEFAULT 'no_certs',
			             course_opt_user_access varchar(20) NOT NULL,
			             course_unit_count int(11) unsigned NULL DEFAULT '0',
			             course_from_name varchar(150) NOT NULL,
			             course_from_email varchar(150) NOT NULL,
			             course_to_email varchar(150) NOT NULL,
			             course_opt_prerequisites longtext NOT NULL,
			             course_message_unit_complete text NULL,
			             course_message_course_complete text NULL,
			             course_message_unit_not_logged_in text NULL,
			             course_message_unit_pending text NULL,
			             course_message_unit_no_access text NULL,
			             course_message_prerequisite_not_met text NULL,
			             course_message_unit_not_yet text NULL,
			             course_message_unit_not_yet_dripfeed text NULL,
			             course_message_quiz_open_grading_blocking text NULL,
			             course_message_quiz_open_grading_non_blocking text NULL,
			             email_complete_module_option_admin varchar(20) NOT NULL,
			             email_complete_module_option varchar(20) NOT NULL,
			             email_complete_module_subject varchar(300) NOT NULL,
			             email_complete_module_body text NULL,
			             email_complete_course_option_admin varchar(20) NOT NULL,
			             email_complete_course_option varchar(20) NOT NULL,
			             email_complete_course_subject varchar(300) NOT NULL,
			             email_complete_course_body text NULL,
			             email_quiz_grade_option varchar(20) NOT NULL,
			             email_quiz_grade_subject varchar(300) NOT NULL,
			             email_quiz_grade_body text NULL,
			             email_complete_course_grade_summary_subject varchar(300) NOT NULL,
			             email_complete_course_grade_summary_body text NULL,
			             email_unit_unlocked_subject varchar(300) NOT NULL,
			             email_unit_unlocked_body text NULL,
			             cert_signature_type varchar(20) NOT NULL DEFAULT 'text',
			             cert_sig_text varchar(300) NOT NULL,
			             cert_sig_image_url varchar(300) NOT NULL DEFAULT  '',
			             cert_logo_enabled varchar(20) NOT NULL DEFAULT 'no_cert_logo',
			             cert_logo_url varchar(300) NOT NULL DEFAULT '',
			             cert_background_type varchar(20) NOT NULL DEFAULT 'use_default',
			             cert_background_custom_url varchar(300) NOT NULL DEFAULT  '',
			             payments_type varchar(20) NOT NULL DEFAULT 'free',
			             payments_price varchar(100) NOT NULL DEFAULT '0.00',
			             payments_interval varchar(20) NOT NULL DEFAULT 'month',
			             PRIMARY KEY  (course_id)";
	}

	/**
	 * Handle Upgrades.
	 *
	 * @since 4.3.0
	 */
	protected function upgrade() {
		$current = $this->db_version;

		$versions = array(
			'430' => 'upgrade_to_430',
			'432' => 'upgrade_to_432',
		);

		foreach ( $versions as $vers => $upgrade ) {
			if ( version_compare( absint( $current ), absint( $vers ) ) === -1 ) {
				if ( is_callable( array( $this, $upgrade ) ) ) {
					$this->{$upgrade}();
				}
			}
		}
	}

	/**
	 * Upgrade to version 4.3.0
	 *
	 * @since 4.3.0
	 */
	private function upgrade_to_430() {
		global $wpdb;

		$course_author     = $wpdb->query( "SHOW COLUMNS FROM $this->table_name LIKE 'course_author'" );
		$payments_type     = $wpdb->query( "SHOW COLUMNS FROM $this->table_name LIKE 'payments_type'" );
		$payments_price    = $wpdb->query( "SHOW COLUMNS FROM $this->table_name LIKE 'payments_price'" );
		$payments_interval = $wpdb->query( "SHOW COLUMNS FROM $this->table_name LIKE 'payments_interval'" );

		if ( ! $course_author ) {
			$wpdb->query( "ALTER TABLE $this->table_name ADD `course_author` bigint(20) unsigned NOT NULL default '0'" );
		}

		if ( ! $payments_type ) {
			$wpdb->query( "ALTER TABLE $this->table_name ADD `payments_type` varchar(20) NOT NULL DEFAULT 'free'" );
		}

		if ( ! $payments_price ) {
			$wpdb->query( "ALTER TABLE $this->table_name ADD `payments_price` varchar(100) NOT NULL DEFAULT '0.00'" );
		}

		if ( ! $payments_interval ) {
			$wpdb->query( "ALTER TABLE $this->table_name ADD `payments_interval` varchar(100) NOT NULL DEFAULT 'month'" );
		}
	}

	/**
	 * Upgrade to version 4.3.2
	 *
	 * @since 4.3.2
	 */
	private function upgrade_to_432() {
		global $wpdb;

		$course_author = $wpdb->query( "SHOW COLUMNS FROM $this->table_name LIKE 'course_author'" );

		if ( ! $course_author ) {
			$wpdb->query( "ALTER TABLE $this->table_name ADD `course_author` bigint(20) unsigned NOT NULL default '0'" );
		}
	}
}