<?php
/**
 * WP Courseware DB Units Meta.
 *
 * @package WPCW
 * @subpackage Database
 * @since 4.3.0
 */
namespace WPCW\Database;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Units_Meta.
 *
 * @since 4.3.0
 */
class DB_Units_Meta extends DB {

	/**
	 * Units Meta Database Constructor.
	 *
	 * Intiate the table name, version, and primary key.
	 *
	 * @since 4.3.0
	 */
	public function __construct() {
		// Define Table Name and Primary Key
		$this->table_name  = wpcw()->database->get_table_name( 'units_meta' );
		$this->primary_key = 'unit_id';
	}

	/**
	 * Get Columns.
	 *
	 * @since 4.3.0
	 *
	 * @return array The array of columns.
	 */
	public function get_columns() {
		return array(
			'unit_id'                 => '%d',
			'parent_module_id'        => '%d',
			'parent_course_id'        => '%d',
			'unit_author'             => '%d',
			'unit_order'              => '%d',
			'unit_number'             => '%d',
			'unit_drip_type'          => '%s',
			'unit_drip_date'          => '%s',
			'unit_drip_interval'      => '%d',
			'unit_drip_interval_type' => '%s',
		);
	}
}