<?php
/**
 * WP Courseware Uninstall.
 *
 * @package WPCW
 * @subpackage Core
 * @since 4.3.0
 */
namespace WPCW\Core;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class Uninstall.
 *
 * @since 4.3.0
 */
final class Uninstall {

	/**
	 * Load Uninstall Class.
	 *
	 * @since 4.3.0
	 */
	public function load() {
		register_uninstall_hook( WPCW_FILE, array( __CLASS__, 'uninstall' ) );
	}

	/**
	 * Uninstall Plugin.
	 *
	 * @since 4.3.0
	 *
	 * @static
	 */
	public static function uninstall() {
		$roles = new Roles();
		$roles->remove_caps();
	}
}