<?php

/**
 * The plugin bootstrap file
 *
 *
 * @link              https://welaunch.io/plugins/wordpress-posts-pdf/
 * @since             1.0.
 * @package           WordPress_Print_Posts
 *
 * @wordpress-plugin
 * Plugin Name:       WordPress Print Posts
 * Plugin URI:        https://welaunch.io/plugins/wordpress-posts-pdf/
 * Description:       Give your visitors the option to create a PDF or Word-File from your Posts.
 * Version:           1.1.5
 * Author:            اسکریپت دات کام
 * Author URI:        https://www.اسکریپت.com
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       wordpress-print-posts
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-wordpress-print-posts-activator.php
 */
function activate_wordpress_print_posts() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-print-posts-activator.php';
	WordPress_Print_Posts_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-wordpress-print-posts-deactivator.php
 */
function deactivate_wordpress_print_posts() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-print-posts-deactivator.php';
	WordPress_Print_Posts_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_wordpress_print_posts' );
register_deactivation_hook( __FILE__, 'deactivate_wordpress_print_posts' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-wordpress-print-posts.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_wordpress_print_posts() {

	$plugin_data = get_plugin_data( __FILE__ );
	$version = $plugin_data['Version'];

	$plugin = new WordPress_Print_Posts($version);
	$plugin->run();

	return $plugin;

}

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if ( is_plugin_active('redux-framework/redux-framework.php') ){
	$WordPress_Print_Posts = run_wordpress_print_posts();
} else {
	add_action( 'admin_notices', 'wordpress_print_posts_installed_notice' );
}

function wordpress_print_posts_installed_notice()
{
	?>
    <div class="error">
      <p><?php _e( 'WordPress Print Posts requires the Redux Framework plugin. Please install or activate them before!', 'wordpress-print-posts'); ?></p>
    </div>
    <?php
}