<div class="wrap">
    <h1><?php esc_html_e('GDPR Settings', 'wp-any-contact-us')?></h1>
    <?php do_action('wacu_admin_notifications');?>
    <hr>

    <form action="#" method="post">

        <table class="form-table">
            <tbody>

                <?php

                    $field->add('checkbox',
                        array(
                            'label'         => esc_html__('GDPR', 'wp-any-contact-us'),
                            'tooltip'       => esc_attr__('Enable this option if your website is under the GDPR compliance.', 'wp-any-contact-us'),
                            'name'          => 'wacu_gdpr_setting[is_gdpr]',
                            'value'         => esc_attr($wacu_gdpr_setting['is_gdpr']),
                            'checkbox_text' => esc_html__('Enable/ Disable', 'wp-any-contact-us'),
                        )
                    );

                    $field->add('textarea',
                        array(
                            'label'   => esc_html__('GDPR Message', 'wp-any-contact-us'),
                            'name'    => 'wacu_gdpr_setting[message]',
                            'value'   => esc_html__($wacu_gdpr_setting['message']),
                            'tooltip' => esc_attr__('Enter the GDPR message', 'wp-any-contact-us'),
                            'rows'    => '5',
                            'desc'    => sprintf(esc_html__('Use tag %1$s for privacy page.', 'wp-any-contact-us'), '<code>{{privace_page}}</code>'),
                        )
                    );

                ?>

                <tr>
                    <th scope="row">
                      <label><?php esc_html_e('Privacy page', 'wc-wws')?></label>
                      <span class="dashicons dashicons-info wecreativez-admin-tooltip" data-tippy-content="<?php esc_attr_e('Select your privacy page.', 'wp-any-contact-us')?>"></span>
                    </th>
                    <td>
                    <?php
                        wacu_page_dropdown(
                            array(
                                'name'     => 'wacu_gdpr_setting[privacy_page]',
                                'selected' => esc_attr__($wacu_gdpr_setting['privacy_page']),
                            )
                        );
                    ?>
                    </td>
                </tr>

            </tbody>
        </table>

        <?php submit_button(esc_attr__('Save Changes', 'wp-any-contact-us'), 'primary', 'wacu_gdpr_setting_submit');?>

    </form>

</div>