<form action="#" method="post" novalidate="novalidate">

    <table class="form-table">
        <tbody>

            <?php

                // Background Color
                $field->add('color',
                    array(
                        'label'   => esc_html__('Background Color', 'wp-any-contact-us'),
                        'tooltip' => esc_attr__('Change the widget background color.', 'wp-any-contact-us'),
                        'name'    => 'wacu_appearance[bg_color]',
                        'value'   => esc_attr($wacu_appearance['bg_color']),
                        'desc'    => sprintf(esc_html__('Default: %1$s', 'wp-any-contact-us'), '<code> #606ccb</code>'),
                    )
                );

                // Text Color
                $field->add('color',
                    array(
                        'label'   => esc_html__('Text Color', 'wp-any-contact-us'),
                        'tooltip' => esc_attr__('Change the widget text color.', 'wp-any-contact-us'),
                        'name'    => 'wacu_appearance[text_color]',
                        'value'   => esc_attr($wacu_appearance['text_color']),
                        'desc'    => sprintf(esc_html__('Default: %1$s', 'wp-any-contact-us'), '<code> #fff</code>'),
                    )
                );

                // Widget location
                $field->add('select',
                    array(
                        'label'    => esc_html__('Widget Location', 'wp-any-contact-us'),
                        'tooltip'  => esc_attr__('Change the widget location.', 'wp-any-contact-us'),
                        'name'     => 'wacu_appearance[location]',
                        'selected' => esc_html($wacu_appearance['location']),
                        'option'   => array(
                            'br' => esc_html__('Bottom Right', 'wp-any-contact-us'),
                            'bl' => esc_html__('Bottom Left', 'wp-any-contact-us'),
                        ),
                    )
                );

                // Enable RTL
                $field->add('checkbox',
                    array(
                        'label'         => esc_html__('RTL (Right to Left)', 'wp-any-contact-us'),
                        'tooltip'       => esc_attr__('If your website supports arabic or hebrew then you can enable this option.', 'wp-any-contact-us'),
                        'name'          => 'wacu_appearance[rtl]',
                        'value'         => esc_attr($wacu_appearance['rtl']),
                        'checkbox_text' => esc_html__('Enable/ Disable', 'wp-any-contact-us'),
                    )
                );

                $field->add('number',
                    array(
                        'label'   => esc_html__('Button Offset', 'wp-any-contact-us'),
                        'name'    => 'wacu_appearance[button_offset]',
                        'value'   => esc_attr($wacu_appearance['button_offset']),
                        'min'     => '1',
                        'step'    => '1',
                        'tooltip' => esc_attr__('You can change the button offset.', 'wp-any-contact-us'),
                        'desc'    => esc_html__('Example: Default 16, means 16px from bottom and 16px from left or right.', 'wp-any-contact-us'),
                    )
                );

                $field->add('radio',
                    array(
                        'label'        => esc_html__('Button Icon', 'wp-any-contact-us'),
                        'tooltip'      => esc_attr__('You can choose the button icon as per your choice', 'wp-any-contact-us'),
                        'name'         => 'wacu_appearance[button_icon]',
                        'radio_inline' => true,
                        'selected'     => esc_attr($wacu_appearance['button_icon']),
                        'option'       => array(
                            array(
                                'value'      => 'wacu-fa wacu-fa-envelope',
                                'radio_text' => '<i class="wacu-fa wacu-fa-envelope"></i>',
                            ),
                            array(
                                'value'      => 'wacu-fa wacu-fa-phone',
                                'radio_text' => '<i class="wacu-fa wacu-fa-phone"></i>',
                            ),
                            array(
                                'value'      => 'wacu-fa wacu-fa-whatsapp',
                                'radio_text' => '<i class="wacu-fa wacu-fa-whatsapp"></i>',
                            ),
                            array(
                                'value'      => 'wacu-fa wacu-fa-skype',
                                'radio_text' => '<i class="wacu-fa wacu-fa-skype"></i>',
                            ),
                            array(
                                'value'      => 'wacu-fa wacu-fa-comments',
                                'radio_text' => '<i class="wacu-fa wacu-fa-comments"></i>',
                            ),
                            array(
                                'value'      => 'wacu-fa wacu-fa-telegram',
                                'radio_text' => '<i class="wacu-fa wacu-fa-telegram"></i>',
                            ),

                        ),
                    )
                );

            ?>

        </tbody>
    </table>

    <hr>

    <table class="form-table">
        <tbody>

            <?php

                $field->add('text',
                    array(
                        'label'   => esc_html__('Widget Header Label', 'wp-any-contact-us'),
                        'name'    => 'wacu_appearance[header_text]',
                        'value'   => esc_attr($wacu_appearance['header_text']),
                        'tooltip' => esc_attr__('Enter the widget header text', 'wp-any-contact-us'),
                    )
                );

            ?>

        </tbody>
    </table>

    <?php submit_button(esc_attr__('Save Changes', 'wp-any-contact-us'), 'primary', 'wacu_appearance_submit');?>

</form>